/**
 * @file nat_misc.h
 * @brief Helper functions for NAT
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _NAT_MISC_H
#define _NAT_MISC_H

//Dependencies
#include "core/net.h"
#include "nat/nat.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//NAT related functions
void natTick(NatContext *context);

bool_t natIsPublicInterface(NatContext *context, NetInterface *interface);
bool_t natIsPrivateInterface(NatContext *context, NetInterface *interface);

error_t natProcessPacket(NatContext *context, NetInterface *inInterface,
   const Ipv4PseudoHeader *inPseudoHeader, const NetBuffer *inBuffer,
   size_t inOffset, NetRxAncillary *ancillary);

error_t natTranslateInboundPacket(NatContext *context, NatIpPacket *packet);
error_t natTranslateOutboundPacket(NatContext *context, NatIpPacket *packet);

error_t natForwardPacket(NatContext *context, const NatIpPacket *packet);

NatPortFwdRule *natMatchPortFwdRule(NatContext *context,
   const NatIpPacket *packet);

NatSession *natMatchSession(NatContext *context, const NatIpPacket *packet);

NatSession *natCreateSession(NatContext *context);

uint16_t natAllocatePort(NatContext *context);
uint16_t natAllocateIcmpQueryId(NatContext *context);

error_t natParseTransportHeader(NatIpPacket *packet);

error_t natTranslateTransportHeader(const NatIpPacket *packet,
   const Ipv4PseudoHeader *pseudoHeader, const NetBuffer *buffer,
   size_t offset);

void natDumpPacket(const NatIpPacket *packet);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
