/**
 * @file nts_client_misc.h
 * @brief Helper functions for NTS client
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _NTS_CLIENT_MISC_H
#define _NTS_CLIENT_MISC_H

//Dependencies
#include "core/net.h"
#include "nts/nts_client.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//NTS client related functions
void ntsClientChangeState(NtsClientContext *context,
   NtsClientState newState);

error_t ntsClientOpenNtsKeConnection(NtsClientContext *context);
error_t ntsClientEstablishNtsKeConnection(NtsClientContext *context);
error_t ntsClientFormatNtsKeRequest(NtsClientContext *context);
error_t ntsClientSendNtsKeRequest(NtsClientContext *context);
error_t ntsClientReceiveNtsKeResponse(NtsClientContext *context);

error_t ntsClientParseEndOfMessageRecord(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientParseNtsNextProtoNegoRecord(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientParseErrorRecord(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientParseWarningRecord(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientParseAeadAlgoNegoRecord(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientParseNewCookieForNtpv4Record(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientParseNtpv4ServerRecord(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientParseNtpv4PortRecord(NtsClientContext *context,
   const uint8_t *body, size_t length);

error_t ntsClientShutdownNtsKeConnection(NtsClientContext *context);
void ntsClientCloseNtsKeConnection(NtsClientContext *context);
error_t ntsClientCheckNtsKeTimeout(NtsClientContext *context);

error_t ntsClientOpenNtpConnection(NtsClientContext *context);
error_t ntsClientSendNtpRequest(NtsClientContext *context);
error_t ntsClientReceiveNtpResponse(NtsClientContext *context);

error_t ntsClientDecryptNtpResponse(NtsClientContext *context,
   const IpAddr *ipAddr, uint16_t port, const uint8_t *message,
   size_t length);

error_t ntsClientParseNtpResponse(NtsClientContext *context,
   NtpTimestamp *timestamp);

void ntsClientCloseNtpConnection(NtsClientContext *context);
error_t ntsClientCheckNtpTimeout(NtsClientContext *context);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
