/**
 * @file nts_common.h
 * @brief Definitions common to NTS client and server
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _NTS_COMMON_H
#define _NTS_COMMON_H

//Dependencies
#include "core/net.h"

//NTS port number
#define NTS_PORT 4460

//Critical flag
#define NTS_KE_CRITICAL 0x8000
//Record type mask
#define NTS_KE_RECORD_TYPE_MASK 0x7FFF

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief NTS-KE record types
 **/

typedef enum
{
   NTS_KE_RECORD_TYPE_END_OF_MESSAGE       = 0, ///<End of Message
   NTS_KE_RECORD_TYPE_NTS_NEXT_PROTO_NEGO  = 1, ///<NTS Next Protocol Negotiation
   NTS_KE_RECORD_TYPE_ERROR                = 2, ///<Error
   NTS_KE_RECORD_TYPE_WARNING              = 3, ///<Warning
   NTS_KE_RECORD_TYPE_AEAD_ALGO_NEGO       = 4, ///<AEAD Algorithm Negotiation
   NTS_KE_RECORD_TYPE_NEW_COOKIE_FOR_NTPV4 = 5, ///<New Cookie for NTPv4
   NTS_KE_RECORD_TYPE_NTPV4_SERVER_NEGO    = 6, ///<NTPv4 Server Negotiation
   NTS_KE_RECORD_TYPE_NTPV4_PORT_NEGO      = 7  ///<NTPv4 Port Negotiation
} NtsKeRecordType;


/**
 * @brief Protocol IDs
 **/

typedef enum
{
   NTS_PROTOCOL_ID_NTPV4 = 0 ///<Network Time Protocol version 4 (NTPv4)
} NtsProtocolId;


/**
 * @brief Error codes
 **/

typedef enum
{
   NTS_ERROR_CODE_UNRECOGNIZED_CRITICAL_RECORD = 0, ///<Unrecognized Critical Record
   NTS_ERROR_CODE_BAD_REQUEST                  = 1, ///<Bad Request
   NTS_ERROR_CODE_INTERNAL_SERVER_ERROR        = 2  ///<Internal Server Error
} NtsErrorCode;


//CC-RX, CodeWarrior or Win32 compiler?
#if defined(__CCRX__)
   #pragma pack
#elif defined(__CWCC__) || defined(_WIN32)
   #pragma pack(push, 1)
#endif


/**
 * @brief NTS-KE record
 **/

typedef __packed_struct
{
   uint16_t type;       //0-1
   uint16_t bodyLength; //2-3
   uint8_t body[];      //4
} NtsKeRecord;


//CC-RX, CodeWarrior or Win32 compiler?
#if defined(__CCRX__)
   #pragma unpack
#elif defined(__CWCC__) || defined(_WIN32)
   #pragma pack(pop)
#endif

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
