# Getting Started with the CycloneBOOT Repository

## Folder Structure

```plaintext
demo
├── microchip
│   └── same54_xplained_pro
│      ├── iap_dual_bank
│      └── iap_single_bank
└── st
    ├── nucleo_f429zi
    │   └── iap_dual_bank
    ├── nucleo_f767zi
    │   └── iap_dual_bank
    ├── nucleo_h563zi
    │   ├── iap_dual_bank
    │   └── iap_single_bank
    ├── nucleo_h743zi2
    │   ├── iap_dual_bank
    │   └── iap_single_bank
    ├── nucleo_h7a3zi_q
    │   └── iap_dual_bank
    ├── nucleo_l496zg
    │   └── iap_dual_bank
    ├── nucleo_u575zi_q
    │   └── iap_dual_bank
    ├── stm32429i_eval
    │   ├── iap_dual_bank
    │   └── iap_single_bank_ext_mem
    ├── stm32f769i_discovery
    │   ├── iap_dual_bank
    │   └── iap_single_bank_ext_mem
    ├── stm32f769i_eval
    │   ├── iap_dual_bank
    │   ├── iap_single_bank
    │   └── iap_single_bank_ext_mem
    └── stm32h753i_eval2
        ├── iap_dual_bank
        └── iap_single_bank_ext_mem

src
├── common
├── cyclone_boot
├── cyclone_crypto
├── cyclone_ssh
├── cyclone_ssl
└── cyclone_tcp

third_party
├── cmsis
├── freertos
├── microchip
└── st

tools
├── ImageBuilder
└── ResourceCompiler
```

## Folder Descriptions

### `demo/`

Contains ready-to-use demonstration projects for supported evaluation boards. Projects are organized by hardware vendor and then by board.

Each board includes multiple *firmware update scenarios* for different types of flash memory architecture:

- Internal Flash only (`iap_single_bank`)
- Internal Flash with External Flash (`iap_single_bank_ext_mem`)
- Internal Flash with Dual Bank capability (`iap_dual_bank`)

Scenarios typically implement different transport protocols (e.g., HTTP, SFTP, MQTT) for delivering firmware updates.

> Refer to the `README.md` inside each demo project folder for more details.

---

### `src/`

Contains the main source code for **CycloneBOOT** and other **Oryx Embedded** middleware:

- `cyclone_boot` and `cyclone_crypto`: Core components of the CycloneBOOT system.
- Other folders (e.g., `cyclone_tcp`, `cyclone_ssh`) provide protocol support for demos.

---

### `third_party/`

Contains vendor libraries and middleware dependencies:

- CMSIS and HAL drivers from vendors such as STMicroelectronics
- FreeRTOS
- Board Support Packages (BSPs)
- Etc.

---

### `tools/`

Includes utilities used by the demos:

- **ImageBuilder**  
  Creates firmware update images compatible with CycloneBOOT.  
  Pre-built binaries are available for Windows and Linux in `ImageBuilder/bin`.

- **ResourceCompiler**  
  Converts files like `.pem` keys and `.html` pages into C arrays.  
  These resources simulate a basic filesystem within demos.  
  Pre-built binaries are available for Windows and Linux in `ResourceCompiler/bin`.  
  Resource files can be found in the `resources/` folder of each demo project.

---

## Contact

For support or questions, contact the development team at:

**info@oryx-embedded.com**
