import os
import sys

def formatDemoVersion(demoVersion, demoVersionColor):
    versionTxt = ""

    # Check demo version
    if(len(demoVersion.split(".")) != 3):
        return ""
    
    # Check demo version color
    if((len(demoVersionColor) != 7) or (demoVersionColor[0] != "#")):
        return ""

    # Get major,minor and rev version
    versionMajor    = int(demoVersion.split(".")[0])
    versionMinor    = int(demoVersion.split(".")[1])
    versionRev      = int(demoVersion.split(".")[2])
    
    # Prepare demo version text format
    versionTxt += "//Major version" + "\n"
    versionTxt += "#define APP_MAJOR_VERSION {:d}" + "\n"
    versionTxt += "//Minor version" + "\n"
    versionTxt += "#define APP_MINOR_VERSION {:d}" + "\n"
    versionTxt += "//Revision number" + "\n"
    versionTxt += "#define APP_REV_NUMBER {:d}" + "\n"
    versionTxt += "//Version string" + "\n"
    versionTxt += "#define APP_VERSION_STRING \"{:s}\"" + "\n"
    versionTxt += "//Version color" + "\n"
    versionTxt += "#define APP_VERSION_COLOR \"{:s}\"" + "\n"

    # Format demo version text
    versionTxt = versionTxt.format(versionMajor, versionMinor, versionRev,
                      demoVersion, demoVersionColor)
    
    return versionTxt


def formatDemoScenario(demoScenario):
    scenarioTxt = ""

    # Check demo scenario
    if((int(demoScenario) < 1) or (int(demoScenario) > 3)):
        return ""
    
    # Get scenario number
    scenarioNb = int(demoScenario)

    # Prepare demo scenario text format
    scenarioTxt = "#define UPDT_USED_SCENARIO UPDT_SCENARIO_{:d}\n"

    # Format demo scenario text
    scenarioTxt = scenarioTxt.format(scenarioNb)

    return scenarioTxt


def changeDemoVersionAndScenario(demoPath, demoVersion, demoVersionColor, demoScenario):
    output_1 = ""
    output_2 = ""
    # Get demo app user settings file path
    demoSettingsFilePath = os.path.join(demoPath, "src\\app_user_settings.h")
    demoMainFilePath = os.path.join(demoPath, "src\\main.h")

    # Check demo app user settings file path
    if(not os.path.exists(demoSettingsFilePath)):
        exit(-1)
    # Check demo version
    if(len(demoVersion.split(".")) != 3):
        exit(-1)
    
    # Check demo version color
    if((len(demoVersionColor) != 7) or (demoVersionColor[0] != "#")):
        exit(-1)

    # Check demo scenario
    if((int(demoScenario) < 1) or (int(demoScenario) > 3)):
        exit(-1)

    # Read app user settings file
    with open(demoSettingsFilePath, "r") as fileIn_1, open(demoMainFilePath, "r") as fileIn_2:
        # Init variables
        state_1 = 0
        
        #Endless loop
        while True:
            # Read line
            line_1 = fileIn_1.readline()
            line_2 = fileIn_2.readline()

            # Not End of file ?
            if line_1:
                # Default state
                if(state_1 == 0):
                    if(line_1.rstrip() == "//Major version"):
                        output_1 += formatDemoVersion(demoVersion, demoVersionColor)
                        state_1 = 1
                    else:
                        output_1 += line_1
                # Change version state
                elif (state_1 == 1):
                    if(line_1.rstrip() == "//Version"):
                        output_1 += line_1 + fileIn_1.readline()
                        state_1 = 0

            # Not End of file ?
            if line_2:
                # Find update scenario choice line?
                if("#define UPDT_USED_SCENARIO" in line_2.rstrip()):
                    output_2 += formatDemoScenario(demoScenario)
                else:
                    output_2 += line_2

            # EOF of both file?
            if not line_1 and not line_2:
                break
        
        
        # Write new app user settings file
        with open(demoSettingsFilePath, "w")  as fileOut:
            fileOut.write(output_1)

        # Write new main.h file
        with open(demoMainFilePath, "w")  as fileOut:
            fileOut.write(output_2)

print(sys.argv)

if len(sys.argv) != 5:
    print("changeDemoVersion [demoPath] [demoVersion] [demoVersionColor] [demoScenario]")
    print(" - demoPath: demo path")
    print(" - demoVersion: demo version X.X.X")
    print(" - demoVersionColor: demo version hex color \"#XXXXXX\"")
    print(" - demoScenario: demo scenario (1, 2 ou 3)")
    exit(-1)

changeDemoVersionAndScenario(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])