import os
import sys

def formatDemoVersion(demoVersion, demoVersionColor):
    versionTxt = ""

    # Check demo version
    if(len(demoVersion.split(".")) != 3):
        return ""
    
    # Check demo version color
    if((len(demoVersionColor) != 7) or (demoVersionColor[0] != "#")):
        return ""

    # Get major,minor and rev version
    versionMajor    = int(demoVersion.split(".")[0])
    versionMinor    = int(demoVersion.split(".")[1])
    versionRev      = int(demoVersion.split(".")[2])
    
    # Prepare demo version text format
    versionTxt += "//Major version" + "\n"
    versionTxt += "#define APP_MAJOR_VERSION {:d}" + "\n"
    versionTxt += "//Minor version" + "\n"
    versionTxt += "#define APP_MINOR_VERSION {:d}" + "\n"
    versionTxt += "//Revision number" + "\n"
    versionTxt += "#define APP_REV_NUMBER {:d}" + "\n"
    versionTxt += "//Version string" + "\n"
    versionTxt += "#define APP_VERSION_STRING \"{:s}\"" + "\n"
    versionTxt += "//Version color" + "\n"
    versionTxt += "#define APP_VERSION_COLOR \"{:s}\"" + "\n"

    # Format demo version text
    versionTxt = versionTxt.format(versionMajor, versionMinor, versionRev,
                      demoVersion, demoVersionColor)
    
    return versionTxt

def setDemoVersion(demoPath, demoVersion, demoVersionColor):
    output = ""

    # Get demo app user settings file path
    demoVersionFilePath = os.path.join(demoPath, "src\\version.h")

    # Check demo app user settings file path
    if(not os.path.exists(demoVersionFilePath)):
        exit(-1)
    # Check demo version
    if(len(demoVersion.split(".")) != 3):
        exit(-1)
    
    # Check demo version color
    if((len(demoVersionColor) != 7) or (demoVersionColor[0] != "#")):
        exit(-1)

    # Read app user settings file
    with open(demoVersionFilePath, "r") as fileIn:
        # Init variables
        state = 0
        
        #Endless loop
        while True:
            # Read line
            line = fileIn.readline()

            # Not End of file ?
            if line:
                # Default state
                if(state == 0):
                    if(line.rstrip() == "//Major version"):
                        output += formatDemoVersion(demoVersion, demoVersionColor)
                        state = 1
                    else:
                        output += line
                # Change version state
                elif (state == 1):
                    if(line.rstrip() == "//Version"):
                        output += line + fileIn.readline()
                        state = 0

            # End of file?
            if not line:
                break
        
        
        # Write new app user settings file
        with open(demoVersionFilePath, "w")  as fileOut:
            fileOut.write(output)

if len(sys.argv) != 4:
    print("changeDemoVersion [demoPath] [demoVersion] [demoVersionColor]")
    print(" - demoPath: demo path")
    print(" - demoVersion: demo version X.X.X")
    print(" - demoVersionColor: demo version hex color \"#XXXXXX\"")
    exit(-1)

setDemoVersion(sys.argv[1], sys.argv[2], sys.argv[3])