## Quick Start

1. **Connect the Board**:

   - Connect the STM32F769I-EVAL board to your PC and to an Ethernet network.

2. **Optional: Erase Flash Memory**:

   - Optionally, erase the internal and external flash memory of the board.

3. **Open STM32CubeIDE**:

   - Launch the STM32CubeIDE software.

4. **Import the Bootloader Project**:

   - Import the bootloader project from:
      `/demo/st/stm32f769i_eval/iap_single_bank/bootloader/stm32_cube_ide`.

5. **Flash the Bootloader**:

   - Flash the bootloader onto the board using either a debugger or the STM32CubeProgrammer.

6. **Verify Bootloader Operation**:

   - Open a serial terminal with a baud rate of `115200`.
   - The bootloader should start and indicate that no valid image is present.

7. **Import the MQTT Client Demo**:

   - Close the bootloader project in STM32CubeIDE.
   - Import the `mqtt_client_demo` project from:
      `/demo/st/stm32f769i_eval/iap_single_bank/mqtt_client_demo/stm32_cube_ide`.

8. **Compile the Project**:

   - Compile the project.
   - This will generate a binary file: `iap_demo_1_0_0.bin` in the `mqtt_client_demo` folder.

9. **Generate and Load the Initial Firmware**:

   - Navigate to the `scripts/` folder in the `mqtt_client_demo` directory.
   - On Windows, run the following helper scripts:
     - `generate_bootable_initial_firmware.bat` to create the bootable firmware image.
     - `load_initial_bootable_image.bat` to load the firmware onto the board.

10. **Verify Firmware Boot**:

    - Check the serial terminal to confirm the initial firmware app (v1.0.0) has booted successfully.
    - The MQTT client will attempt to connect to a broker (defined by the macro `APP_SERVER_NAME`) over TCP.

11. **Prepare a New Firmware Version**:

    - Update the 

      ```
      src/version.h
      ```

       file:

      - Set `APP_MAJOR_VERSION` to `2`.
      - Set `APP_VERSION_STRING` to `"2.0.0"`.

    - Compile the project again to generate the new binary file: `iap_demo_2_0_0.bin`.

12. **Generate an Update Image**:

    - Navigate to the `scripts/` folder in the `mqtt_client_demo` directory.
    - Run the script: `generate_update_image.bat`.
    - This will create an update image with a SHA256 integrity check:
       `iap_demo_2_0_0.img` (located in the `mqtt_client_demo` folder).

13. **Send the Update Image via MQTT**:

    - Ensure the Python `paho-mqtt` library is installed (available at: https://pypi.org/project/paho-mqtt/).

    - Use the script 

      ```
      mqtt_fuota_update.py
      ```

       (located in 

      ```
      mqtt_client_demo/tools
      ```

      ):

      ```bash
      python.exe .\tools\mqtt_fuota_update.py --firmware .\iap_demo_2_0_0.img --device "00-AB-CD-EF-07-69"
      ```

      -  `"00-AB-CD-EF-07-69"` is the board’s default MAC address (defined by `APP_MAC_ADDR`).

14. **Monitor the Update Process**:

    - Check the Python script output and the serial terminal.
    - The update process should take about **3 minutes**.
    - If successful, the Python script will display:
       `"Device notify Firmware Update completed"`.
    - The serial terminal will show the device rebooting to install the update.

15. **Verify the Update**:

    - After the update is installed, check the greetings message in the serial terminal.
    - The app version should now display as **v2.0.0**.
