/**
 * @file boot_config.h
 * @brief CycloneBOOT configuration file
 *
 * @section License
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 * 
 * This file is part of CycloneBOOT Open.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.6
 **/

#ifndef _BOOT_CONFIG_H
#define _BOOT_CONFIG_H

//Trace level for CycloneBOOT stack debugging
#define CBOOT_TRACE_LEVEL TRACE_LEVEL_INFO
#define CBOOT_DRIVER_TRACE_LEVEL TRACE_LEVEL_INFO

//Number of memories used
// #define NB_MEMORIES 1
#define NB_MEMORIES 2 //because of external memory use
//Number of slots within the memory
#define NB_MAX_MEMORY_SLOTS 3
//External memory support
#define EXTERNAL_MEMORY_SUPPORT ENABLED//DISABLED

//Update Single Bank Mode support
#define UPDATE_SINGLE_BANK_SUPPORT ENABLED
//Update Dual Bank Mode support
#define UPDATE_DUAL_BANK_SUPPORT DISABLED
//Update Anti-Rollback support
#define UPDATE_ANTI_ROLLBACK_SUPPORT DISABLED

//Cipher support
#define CIPHER_SUPPORT DISABLED
//Image input encrypted
#define IMAGE_INPUT_ENCRYPTED DISABLED
//Image output encrypted
#define IMAGE_OUTPUT_ENCRYPTED DISABLED
//Verification Integrity support
#define VERIFY_INTEGRITY_SUPPORT ENABLED
//Verification Signture support
#define VERIFY_SIGNATURE_SUPPORT DISABLED
//Verification RSA signture algo support
#define VERIFY_RSA_SUPPORT DISABLED


#endif //!_BOOT_CONFIG_H
