/**
 * @file lpc55s6x_crypto_pkc.h
 * @brief LPC55S6x public-key hardware accelerator
 *
 * @section License
 *
 * Copyright (C) 2021-2025 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Open
 * 
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.5.2
 **/

#ifndef _LPC55S6X_CRYPTO_PKC_H
#define _LPC55S6X_CRYPTO_PKC_H

//Dependencies
#include "core/crypto.h"

//Public-key hardware accelerator
#ifndef LPC55S6X_CRYPTO_PKC_SUPPORT
   #define LPC55S6X_CRYPTO_PKC_SUPPORT DISABLED
#elif (LPC55S6X_CRYPTO_PKC_SUPPORT != ENABLED && LPC55S6X_CRYPTO_PKC_SUPPORT != DISABLED)
   #error LPC55S6X_CRYPTO_PKC_SUPPORT parameter is not valid
#endif

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief EC primitive arguments
 **/

typedef struct
{
   uint32_t rx[18];
   uint32_t ry[18];
   uint32_t sx[18];
   uint32_t sy[18];
   uint32_t d[18];
} Lpc55s6xEcArgs;


//C++ guard
#ifdef __cplusplus
}
#endif

#endif
