/**
 * @file llmnr_responder.h
 * @brief LLMNR responder (Link-Local Multicast Name Resolution)
 *
 * @section License
 *
 * Copyright (C) 2021-2025 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Open
 * 
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.5.2
 **/

#ifndef _LLMNR_RESPONDER_H
#define _LLMNR_RESPONDER_H

//Dependencies
#include "core/net.h"
#include "core/udp.h"
#include "dns/dns_common.h"
#include "llmnr/llmnr_common.h"

//LLMNR responder support
#ifndef LLMNR_RESPONDER_SUPPORT
   #define LLMNR_RESPONDER_SUPPORT DISABLED
#elif (LLMNR_RESPONDER_SUPPORT != ENABLED && LLMNR_RESPONDER_SUPPORT != DISABLED)
   #error LLMNR_RESPONDER_SUPPORT parameter is not valid
#endif

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//LLMNR related functions
error_t llmnrResponderInit(NetInterface *interface);

void llmnrProcessQuery(NetInterface *interface,
   const IpPseudoHeader *pseudoHeader, const UdpHeader *udpHeader,
   const NetBuffer *buffer, size_t offset, const NetRxAncillary *ancillary,
   void *param);

error_t llmnrSendResponse(NetInterface *interface, const IpAddr *destIpAddr,
   uint16_t destPort, uint16_t id, uint16_t qtype, uint16_t qclass);

error_t llmnrFormatIpv4AddrRecord(NetInterface *interface,
   LlmnrHeader *message, size_t *length, Ipv4Addr ipv4Addr);

error_t llmnrFormatIpv6AddrRecord(NetInterface *interface,
   LlmnrHeader *message, size_t *length, const Ipv6Addr *ipv6Addr);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
