# CycloneBOOT Quick Start Guide

This guide explains how to perform secure firmware updates on an MCU using CycloneBOOT.

The MCU's internal flash is configured in a **Dual Bank/Pane/Partition** architecture to enable firmware updates without requiring a dedicated bootloader. In-Application Programming (IAP) refers to the process of updating firmware from within the user application, using a predefined protocol and an update library responsible for validating and installing the update.

| Memory Section | Description                        |
| -------------- | ---------------------------------- |
| Bank 1         | Holds current application firmware |
| Bank 2         | Stores new firmware during update  |

**Update Flow**: New firmware received and validated by the application firmware, then directly installed in the alternate bank → On reboot, the MCU swaps flash banks to run the new firmware.

---

## 0. Prerequisites

1. A flashing/programming tool. Refer to the Flashing & Programming section for more information
2. **CycloneBOOT ImageBuilder** – Located in `tools/ImageBuilder/bin/`. Packages firmware, adds metadata, and applies encryption/signatures if required
3. **Python 3.0+** – Required for some post-build hooks: <https://www.python.org/downloads/>
4. Client/host software to transfer the encrypted and signed update image to the device. Refer to the Protocol section for more information
5. Terminal emulator (Windows Terminal, PowerShell, Bash, etc.)

### Flashing & Programming

Flashing/programming depends on the MCU vendor of the chosen demo project. Typically, there are a few options:

- **STM32CubeIDE or STM32CubeProgrammer** (compatible with STM32 MCUs). The commands to use this tool are available in the comment block in `src/main.c` of the chosen demo project
- **J-Link, ST-Link, etc.** Since there are many tools and options available, the comment block in `src/main.c` of the chosen demo project will indicate the address and any special options (depending on the MCU) that must be configured when flashing the firmware

### Protocol

CycloneBOOT is protocol-agnostic. However, for easier evaluation, demo projects in this repository use common protocols such as HTTP, FTP, or UART. Depending on the chosen protocol, the user may need to use a different tool (e.g., a web browser, FTP/SFTP client, serial terminal emulator, etc.). Below is a summary of tools used across available demo projects. Any specific parameters required will be noted in the comment block in `src/main.c` of the chosen demo project.

- **HTTP**: Web browser is used to upload the firmware update
- **SFTP/FTP**: FileZilla FTP client is used to upload the firmware update
- **UART/Y-Modem**: Tera Term is used on Windows; on Linux, many Y-Modem implementations are available
- **MQTT**: A custom Python script using the `paho-mqtt` library from Pip

---

## 1. Configure Board

- Make sure the MCU is configured in such a way that the internal flash is divided into two equal banks/partitions/panes. Refer to the comment block in `src/main.c` of your chosen demo project for more information
- Erase the internal flash before proceeding further

---

## 3. Build & Flash Initial Firmware (v1.0.0)

1. Open `iap_dual_bank/app_<protocol_config>/` using your preferred IDE/toolchain
2. Check `src/version.h` → default `1.0.0`.
3. Build the project located in `hybrid_app_bl/app_<protocol_config>` using your preferred toolchain
4. Flash the resulting `iap_demo_1_0_0.bin` to MCU internal flash using your preferred programming tool (e.g., STM32CubeProgrammer for STM32 devices). Exact address available in `src/main.c` comment block

---

## 4. Build New Firmware (v2.0.0)

1. Update `src/version.h` → `2.0.0`
2. Build the project again, which should produce `iap_demo_2_0_0.bin`
3. Package this binary with ImageBuilder to generate a firmware image compatible with 2nd stage bootloader :

   ```cmd
   image_builder_windows.exe --input iap_demo_2_0_0.bin --output iap_demo_2_0_0.img --enc-algo aes-cbc --enc-key aa3ff7d43cc015682c7dfd00de9379e7 --sign-algo rsa-sha256 --sign-key  .\resources\keys\rsa_private_key.pem
   ```

---

## 5. Upload Firmware via FTP

Refer to the `src/main.c` comment block for more information about the required tools and configuration steps.

---

## Troubleshooting

- In case of debugger connection failing after an update, this is due the swapped flash bank status of the MCU. Debugger might expect a flash running on the "default" flash bank. To fix this, uncheck swapped bank feature using OptionBytes or equivalent. More information available in `src/main.c` comment block.
