# CycloneBOOT Quick Start Guide

This guide explains how to perform secure firmware updates on an MCU using CycloneBOOT.

The "hybrid_app_bl" configuration defines a shared responsibility between the application and the bootloader: the application handles the reception of a firmware update via a predefined protocol, while the second-stage bootloader validates the current firmware and installs an update if available. This configuration also supports an optional first-stage bootloader for updating the second-stage bootloader.

| Memory Section       | Description                                          |
| -------------------- | ---------------------------------------------------- |
| 1st-stage Bootloader | Optional stage for updating the 2nd-stage bootloader |
| 2nd-stage Bootloader | Manages application installation and startup         |
| Application          | Application firmware capable of receiving updates    |
| Free Slot            | Free memory slot to store a firmware update          |

The internal flash stores the first-stage, the second-stage bootloader, and the application firmware. The free slot may reside in internal flash or external flash as well.

**Update Flow**: New firmware is received and validated by the application firmware, then stored in a free slot → It is applied on reboot by the appropriate bootloader depending the target use case (2nd-stage bootloader update or application update).

---

## 0. Prerequisites

1. A flashing/programming tool. Refer to the Flashing & Programming section for more information
2. **CycloneBOOT ImageBuilder** – Located in `tools/ImageBuilder/bin/`. Packages firmware, adds metadata, and applies encryption/signatures if required
3. **Python 3.0+** – Required for some post-build hooks: <https://www.python.org/downloads/>
4. Client/host software to transfer the encrypted and signed update image to the device. Refer to the Protocol section for more information
5. Terminal emulator (Windows Terminal, PowerShell, Bash, etc.)

### Flashing & Programming

Flashing/programming depends on the MCU vendor of the chosen demo project. Typically, there are a few options:

- **STM32CubeIDE or STM32CubeProgrammer** (compatible with STM32 MCUs). The commands to use this tool are available in the comment block in `src/main.c` of the chosen demo project
- **J-Link, ST-Link, etc.** Since there are many tools and options available, the comment block in `src/main.c` of the chosen demo project will indicate the address and any special options (depending on the MCU) that must be configured when flashing the firmware

---

### Protocol

CycloneBOOT is protocol-agnostic. However, for easier evaluation, demo projects in this repository use common protocols such as HTTP, FTP, or UART. Depending on the chosen protocol, the user may need to use a different tool (e.g., a web browser, FTP/SFTP client, serial terminal emulator, etc.). Below is a summary of tools used across available demo projects. Any specific parameters required will be noted in the comment block in `src/main.c` of the chosen demo project.

- **HTTP Server**: Web browser is used to upload the firmware update
- **SFTP/FTP**: FileZilla FTP client is used to upload the firmware update
- **UART/Y-Modem**: Tera Term is used on Windows; on Linux, many Y-Modem implementations are available
- **MQTT**: A custom Python script using the `paho-mqtt` library from Pip
- **USB**: A custom Python script using standard library features
- **HTTP Client**: A custom Python based on `Flask` library from Pip

---

## 1. Configure Board

- Make sure the MCU is configured in such a way that the internal flash is treated as a contiguous memory block. Refer to the comment block in `src/main.c` of your chosen demo project for more information
- Erase the internal/external flash before proceeding further

---

## 2a. 1st Stage Bootloader [OPTIONAL]

This step is relevant if your chosen demo project contains a `1st_stage_bl` subfolder, indicating the demo is configured by default to also support 2nd stage bootloader updates.

### Build 1st Stage Bootloader

1. Open `hybrid_app_bl/1st_stage_bl/` in your IDE
2. Build → generates `bootloader.bin`

### Flash 1st Stage Bootloader

- Use a programming tool to flash the 1st stage bootloader to the beginning of MCU internal flash. Refer to the comment block in `src/main.c` of your chosen demo project for more information

## 2b. 2nd Stage Bootloader

This is mandatory for all demo projects of type `hybrid_app_bl`.

### Build 2nd Stage Bootloader

1. Open `hybrid_app_bl/2nd_stage_bl/` in your IDE
2. Build → generates `bootloader.bin` (or in case of a demo project supporting 2nd stage bootoader updates, `bootloader_1_0_0.bin`)

### Flash 2nd Stage Bootloader

- Use a programming tool to flash the 2nd stage bootloader to the MCU internal flash. The exact address depends on the MCU vendor and wether the demo project is configured to support 2nd stage bootloader updates. Refer to the comment block in `src/main.c` of your chosen demo project for more information

---

## 3. Build & Flash Initial Firmware (v1.0.0)

1. Open `hybrid_app_bl/app_<protocol_config>/` using your preferred IDE/toolchain
2. Check `src/version.h`: default `v1.0.0`
3. Build the project located in `hybrid_app_bl/app_<protocol_config>` using your preferred toolchain
4. Package the binary resulting from the previous step with ImageBuilder CLI tool :

_Secure Boot enabled:_

```cmd
image_builder_windows.exe --input iap_demo_1_0_0.bin --output iap_demo_1_0_0_bootable.bin --runtime-sign-algo rsa-sha256
--runtime-sign-key ../../resources/keys/my_rsa_private_key.pem --vtor-align
```

_Secure Boot disabled:_

```cmd
image_builder_windows.exe --input iap_demo_1_0_0.bin --output iap_demo_1_0_0_bootable.bin --integrity-algo crc32 --vtor-align
```

5. Flash the resulting `iap_demo_1_0_0_bootable.bin` to MCU internal flash using your preferred programming tool (e.g., STM32CubeProgrammer for STM32 devices). Exact address available in `src/main.c` comment block

## 4. Build & Generate Firmware Update (v2.0.0)

1. Update `src/version.h` → `2.0.0`
2. Build the project again, which should produce `iap_demo_2_0_0.bin`
3. Package this binary with ImageBuilder to generate a firmware image compatible with 2nd stage bootloader :

_Secure Boot enabled:_

```cmd
image_builder_windows.exe --input iap_demo_2_0_0.bin --output iap_demo_2_0_0.img --runtime-sign-algo rsa-sha256 --runtime-sign-key
../../resources/keys/my_rsa_private_key.pem --sign-algo rsa-sha256 --sign-key ../../resources/keys/my_rsa_private_key.pem --enc-algo aes-cbc
	--enc-key aa3ff7d43cc015682c7dfd00de9379e7 --vtor-align
```

_Secure Boot disabled:_

```cmd
image_builder_windows.exe --input iap_demo_2_0_0.bin --output iap_demo_2_0_0.img --enc-algo aes-cbc --enc-key aa3ff7d43cc015682c7dfd00de9379e7 --sign-algo rsa-sha256 --sign-key .\resources\keys\rsa_private_key.pem
--vtor-align
```

---

## 5. Upload the Firmware Update

Refer to the `src/main.c` comment block for more information about the required tools and configuration steps.

---

## 6. Bootloader Updates [[OPTIONAL]]

This step is relevant if your chosen demo project contains a `1st_stage_bl` subfolder, indicating the demo is configured by default to also support 2nd stage bootloader updates.

- Update `hybrid_app_bl/2nd_stage_bl/src/version.h` → e.g., `2.0.0`.
- Build → `bootloader_2_0_0.bin`.
- Package with ImageBuilder (same encryption and signature scheme used to secure application firmware updates):
  ```cmd
  image_builder_windows.exe --input bootloader_2_0_0.bin --output bootloader_2_0_0.img --enc-algo aes-cbc --enc-key aa3ff7d43cc015682c7dfd00de9379e7 --sign-algo rsa-sha256 --sign-key .\resources\keys\rsa_private_key.pem
  --vtor-align
  ```
- Use the same method as the firmware update to send the image to the device

---

## Troubleshooting

- Old update images in external flash can trigger unwanted updates. Make sure to always erase internal/external flash to start from a clean slate during experiments
