/**
 * @file stm32h573i_discovery_conf.h
 * @brief STM32H573I-DK board configuration file.
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 * 
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef STM32H573I_DK_CONF_H
#define STM32H573I_DK_CONF_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32h5xx_hal.h"

/** @addtogroup BSP
  * @{
  */

/** @addtogroup STM32H573I_DK
  * @{
  */

/** @defgroup STM32H573I_DK_CONFIG Config
  * @{
  */

/** @defgroup STM32H573I_DK_CONFIG_Exported_Constants Exported Constants
  * @{
  */

/* Board revision to be used: By default STM32H573I_DK_REVB is used unless the below 
   definition is uncommented */
/* #define STM32H573I_DK_REVA */

/* COM define */
#define USE_BSP_COM_FEATURE               0U
#define USE_COM_LOG                       0U

/* I2C BUS timing define */
#define I2C_VALID_TIMING_NBR              128U

/* Audio codecs defines */
#define USE_AUDIO_CODEC_CS42L51           1U

/* Default Audio IN internal buffer size */
#define DEFAULT_AUDIO_IN_BUFFER_SIZE      2048U


/* TS defines */
#define USE_TS_GESTURE                    1U
#define USE_TS_MULTI_TOUCH                1U
#define TS_TOUCH_NBR                      2U

/* IRQn priorities */
#define BSP_BUTTON_USER_IT_PRIORITY       15U
#define BSP_AUDIO_OUT_IT_PRIORITY         14U
#define BSP_AUDIO_IN_IT_PRIORITY          15U
#define BSP_SD_IT_PRIORITY                14U
#define BSP_SD_RX_IT_PRIORITY             14U
#define BSP_SD_TX_IT_PRIORITY             15U
#define BSP_TS_IT_PRIORITY                15U


/* I2C4 Frequencies in Hz  */
#define BUS_I2C4_FREQUENCY                100000UL /* Frequency of I2C4 = 100 KHz*/

/* Usage of USBPD PWR TRACE system */
#define USE_BSP_USBPD_PWR_TRACE           0U /* USBPD BSP trace system is disabled */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /* STM32H573I_DK_CONF_H */
