/**
 * @file boot_config.h
 * @brief Generic module description
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 * 
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

//
// Created by danan on 2/14/2025.
//

#ifndef BOOT_CONFIG_H
#define BOOT_CONFIG_H

//Bootloader trace level
#define BOOT_TRACE_LEVEL 4

//Number of memory to be used
#define NB_MEMORIES 1

//Number of slots within the memory
#define NB_MAX_MEMORY_SLOTS 1

#define UPDATE_SINGLE_BANK_SUPPORT ENABLED
#define UPDATE_DUAL_BANK_SUPPORT DISABLED

//External memory support
#define EXTERNAL_MEMORY_SUPPORT DISABLED

//Anti-Rollback support
#define UPDATE_ANTI_ROLLBACK_SUPPORT DISABLED

//Fallback support
#define UPDATE_FALLBACK_SUPPORT DISABLED

//Cipher support
#define CIPHER_SUPPORT ENABLED
//Image input encrypted
#define IMAGE_INPUT_ENCRYPTED ENABLED
//Verification Integrity support
#define VERIFY_INTEGRITY_SUPPORT ENABLED
//Verification Signture support
#define VERIFY_SIGNATURE_SUPPORT ENABLED
//Verification RSA signture algo support
#define VERIFY_RSA_SUPPORT ENABLED

//Experimental configurations
#define BOOT_XIP_SUPPORT            ENABLED
#define UPDATE_STANDALONE_BOOT_MODE ENABLED

#endif //BOOT_CONFIG_H
