/**
 * @file stm32mp2xx_crypto_cipher.h
 * @brief STM32MP2 cipher hardware accelerator
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Open
 * 
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _STM32MP2XX_CRYPTO_CIPHER_H
#define _STM32MP2XX_CRYPTO_CIPHER_H

//Dependencies
#include "core/crypto.h"

//Cipher hardware accelerator
#ifndef STM32MP2XX_CRYPTO_CIPHER_SUPPORT
   #define STM32MP2XX_CRYPTO_CIPHER_SUPPORT DISABLED
#elif (STM32MP2XX_CRYPTO_CIPHER_SUPPORT != ENABLED && STM32MP2XX_CRYPTO_CIPHER_SUPPORT != DISABLED)
   #error STM32MP2XX_CRYPTO_CIPHER_SUPPORT parameter is not valid
#endif

//GCM_CCMPH  bitfield
#define CRYP_CR_GCM_CCMPH_INIT    0
#define CRYP_CR_GCM_CCMPH_HEADER  CRYP_CR_GCM_CCMPH_0
#define CRYP_CR_GCM_CCMPH_PAYLOAD CRYP_CR_GCM_CCMPH_1
#define CRYP_CR_GCM_CCMPH_FINAL   (CRYP_CR_GCM_CCMPH_1 | CRYP_CR_GCM_CCMPH_0)

//KEYSIZE bitfield
#define CRYP_CR_KEYSIZE_128B      0
#define CRYP_CR_KEYSIZE_192B      CRYP_CR_KEYSIZE_0
#define CRYP_CR_KEYSIZE_256B      CRYP_CR_KEYSIZE_1

//DATATYPE bitfield
#define CRYP_CR_DATATYPE_32B      0
#define CRYP_CR_DATATYPE_16B      CRYP_CR_DATATYPE_0
#define CRYP_CR_DATATYPE_8B       CRYP_CR_DATATYPE_1
#define CRYP_CR_DATATYPE_1B       (CRYP_CR_DATATYPE_1 | CRYP_CR_DATATYPE_0)

//ALGOMODE bitfield
#define CRYP_CR_ALGOMODE_TDES_ECB 0
#define CRYP_CR_ALGOMODE_TDES_CBC CRYP_CR_ALGOMODE_0
#define CRYP_CR_ALGOMODE_DES_ECB  CRYP_CR_ALGOMODE_1
#define CRYP_CR_ALGOMODE_DES_CBC  (CRYP_CR_ALGOMODE_1 | CRYP_CR_ALGOMODE_0)
#define CRYP_CR_ALGOMODE_AES_ECB  CRYP_CR_ALGOMODE_2
#define CRYP_CR_ALGOMODE_AES_CBC  (CRYP_CR_ALGOMODE_2 | CRYP_CR_ALGOMODE_0)
#define CRYP_CR_ALGOMODE_AES_CTR  (CRYP_CR_ALGOMODE_2 | CRYP_CR_ALGOMODE_1)
#define CRYP_CR_ALGOMODE_AES_KEY  (CRYP_CR_ALGOMODE_2 | CRYP_CR_ALGOMODE_1 | CRYP_CR_ALGOMODE_0)
#define CRYP_CR_ALGOMODE_AES_GCM  CRYP_CR_ALGOMODE_3
#define CRYP_CR_ALGOMODE_AES_CCM  (CRYP_CR_ALGOMODE_3 | CRYP_CR_ALGOMODE_0)

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//Cipher related functions
error_t crypInit(void);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
