/**
 * @file f2838x_eth_driver.h
 * @brief TMS320F2838xD Ethernet MAC driver
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Open
 * 
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _F2838X_ETH_DRIVER_H
#define _F2838X_ETH_DRIVER_H

//Dependencies
#include "core/nic.h"

//Number of TX buffers
#ifndef F2838X_ETH_TX_BUFFER_COUNT
   #define F2838X_ETH_TX_BUFFER_COUNT 2
#elif (F2838X_ETH_TX_BUFFER_COUNT < 1)
   #error F2838X_ETH_TX_BUFFER_COUNT parameter is not valid
#endif

//TX buffer size
#ifndef F2838X_ETH_TX_BUFFER_SIZE
   #define F2838X_ETH_TX_BUFFER_SIZE 1536
#elif (F2838X_ETH_TX_BUFFER_SIZE != 1536)
   #error F2838X_ETH_TX_BUFFER_SIZE parameter is not valid
#endif

//Number of RX buffers
#ifndef F2838X_ETH_RX_BUFFER_COUNT
   #define F2838X_ETH_RX_BUFFER_COUNT 4
#elif (F2838X_ETH_RX_BUFFER_COUNT < 1)
   #error F2838X_ETH_RX_BUFFER_COUNT parameter is not valid
#endif

//RX buffer size
#ifndef F2838X_ETH_RX_BUFFER_SIZE
   #define F2838X_ETH_RX_BUFFER_SIZE 1536
#elif (F2838X_ETH_RX_BUFFER_SIZE != 1536)
   #error F2838X_ETH_RX_BUFFER_SIZE parameter is not valid
#endif

//Ethernet interrupt priority
#ifndef F2838X_ETH_IRQ_PRIORITY
   #define F2838X_ETH_IRQ_PRIORITY 6
#elif (F2838X_ETH_IRQ_PRIORITY < 0)
   #error F2838X_ETH_IRQ_PRIORITY parameter is not valid
#endif

//EMAC registers
#define ETHERNET_MAC_CONFIGURATION_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_CONFIGURATION)
#define ETHERNET_MAC_EXT_CONFIGURATION_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_EXT_CONFIGURATION)
#define ETHERNET_MAC_PACKET_FILTER_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_PACKET_FILTER)
#define ETHERNET_MAC_WATCHDOG_TIMEOUT_R                  HWREG(EMAC_BASE + ETHERNET_O_MAC_WATCHDOG_TIMEOUT)
#define ETHERNET_MAC_HASH_TABLE_REG0_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_HASH_TABLE_REG0)
#define ETHERNET_MAC_HASH_TABLE_REG1_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_HASH_TABLE_REG1)
#define ETHERNET_MAC_VLAN_TAG_CTRL_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_VLAN_TAG_CTRL)
#define ETHERNET_MAC_VLAN_TAG_DATA_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_VLAN_TAG_DATA)
#define ETHERNET_MAC_VLAN_HASH_TABLE_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_VLAN_HASH_TABLE)
#define ETHERNET_MAC_VLAN_INCL_R                         HWREG(EMAC_BASE + ETHERNET_O_MAC_VLAN_INCL)
#define ETHERNET_MAC_INNER_VLAN_INCL_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_INNER_VLAN_INCL)
#define ETHERNET_MAC_Q0_TX_FLOW_CTRL_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_Q0_TX_FLOW_CTRL)
#define ETHERNET_MAC_RX_FLOW_CTRL_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_RX_FLOW_CTRL)
#define ETHERNET_MAC_RXQ_CTRL4_R                         HWREG(EMAC_BASE + ETHERNET_O_MAC_RXQ_CTRL4)
#define ETHERNET_MAC_RXQ_CTRL0_R                         HWREG(EMAC_BASE + ETHERNET_O_MAC_RXQ_CTRL0)
#define ETHERNET_MAC_RXQ_CTRL1_R                         HWREG(EMAC_BASE + ETHERNET_O_MAC_RXQ_CTRL1)
#define ETHERNET_MAC_RXQ_CTRL2_R                         HWREG(EMAC_BASE + ETHERNET_O_MAC_RXQ_CTRL2)
#define ETHERNET_MAC_INTERRUPT_STATUS_R                  HWREG(EMAC_BASE + ETHERNET_O_MAC_INTERRUPT_STATUS)
#define ETHERNET_MAC_INTERRUPT_ENABLE_R                  HWREG(EMAC_BASE + ETHERNET_O_MAC_INTERRUPT_ENABLE)
#define ETHERNET_MAC_RX_TX_STATUS_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_RX_TX_STATUS)
#define ETHERNET_MAC_PMT_CONTROL_STATUS_R                HWREG(EMAC_BASE + ETHERNET_O_MAC_PMT_CONTROL_STATUS)
#define ETHERNET_MAC_RWK_PACKET_FILTER_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_RWK_PACKET_FILTER)
#define ETHERNET_MAC_LPI_CONTROL_STATUS_R                HWREG(EMAC_BASE + ETHERNET_O_MAC_LPI_CONTROL_STATUS)
#define ETHERNET_MAC_LPI_TIMERS_CONTROL_R                HWREG(EMAC_BASE + ETHERNET_O_MAC_LPI_TIMERS_CONTROL)
#define ETHERNET_MAC_LPI_ENTRY_TIMER_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_LPI_ENTRY_TIMER)
#define ETHERNET_MAC_1US_TIC_COUNTER_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_1US_TIC_COUNTER)
#define ETHERNET_MAC_VERSION_R                           HWREG(EMAC_BASE + ETHERNET_O_MAC_VERSION)
#define ETHERNET_MAC_DEBUG_R                             HWREG(EMAC_BASE + ETHERNET_O_MAC_DEBUG)
#define ETHERNET_MAC_HW_FEATURE0_R                       HWREG(EMAC_BASE + ETHERNET_O_MAC_HW_FEATURE0)
#define ETHERNET_MAC_HW_FEATURE1_R                       HWREG(EMAC_BASE + ETHERNET_O_MAC_HW_FEATURE1)
#define ETHERNET_MAC_HW_FEATURE2_R                       HWREG(EMAC_BASE + ETHERNET_O_MAC_HW_FEATURE2)
#define ETHERNET_MAC_HW_FEATURE3_R                       HWREG(EMAC_BASE + ETHERNET_O_MAC_HW_FEATURE3)
#define ETHERNET_MAC_MDIO_ADDRESS_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_MDIO_ADDRESS)
#define ETHERNET_MAC_MDIO_DATA_R                         HWREG(EMAC_BASE + ETHERNET_O_MAC_MDIO_DATA)
#define ETHERNET_MAC_ARP_ADDRESS_R                       HWREG(EMAC_BASE + ETHERNET_O_MAC_ARP_ADDRESS)
#define ETHERNET_MAC_ADDRESS0_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS0_HIGH)
#define ETHERNET_MAC_ADDRESS0_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS0_LOW)
#define ETHERNET_MAC_ADDRESS1_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS1_HIGH)
#define ETHERNET_MAC_ADDRESS1_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS1_LOW)
#define ETHERNET_MAC_ADDRESS2_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS2_HIGH)
#define ETHERNET_MAC_ADDRESS2_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS2_LOW)
#define ETHERNET_MAC_ADDRESS3_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS3_HIGH)
#define ETHERNET_MAC_ADDRESS3_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS3_LOW)
#define ETHERNET_MAC_ADDRESS4_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS4_HIGH)
#define ETHERNET_MAC_ADDRESS4_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS4_LOW)
#define ETHERNET_MAC_ADDRESS5_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS5_HIGH)
#define ETHERNET_MAC_ADDRESS5_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS5_LOW)
#define ETHERNET_MAC_ADDRESS6_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS6_HIGH)
#define ETHERNET_MAC_ADDRESS6_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS6_LOW)
#define ETHERNET_MAC_ADDRESS7_HIGH_R                     HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS7_HIGH)
#define ETHERNET_MAC_ADDRESS7_LOW_R                      HWREG(EMAC_BASE + ETHERNET_O_MAC_ADDRESS7_LOW)
#define ETHERNET_MMC_CONTROL_R                           HWREG(EMAC_BASE + ETHERNET_O_MMC_CONTROL)
#define ETHERNET_MMC_RX_INTERRUPT_R                      HWREG(EMAC_BASE + ETHERNET_O_MMC_RX_INTERRUPT)
#define ETHERNET_MMC_TX_INTERRUPT_R                      HWREG(EMAC_BASE + ETHERNET_O_MMC_TX_INTERRUPT)
#define ETHERNET_MMC_RX_INTERRUPT_MASK_R                 HWREG(EMAC_BASE + ETHERNET_O_MMC_RX_INTERRUPT_MASK)
#define ETHERNET_MMC_TX_INTERRUPT_MASK_R                 HWREG(EMAC_BASE + ETHERNET_O_MMC_TX_INTERRUPT_MASK)
#define ETHERNET_TX_OCTET_COUNT_GOOD_BAD_R               HWREG(EMAC_BASE + ETHERNET_O_TX_OCTET_COUNT_GOOD_BAD)
#define ETHERNET_TX_PACKET_COUNT_GOOD_BAD_R              HWREG(EMAC_BASE + ETHERNET_O_TX_PACKET_COUNT_GOOD_BAD)
#define ETHERNET_TX_BROADCAST_PACKETS_GOOD_R             HWREG(EMAC_BASE + ETHERNET_O_TX_BROADCAST_PACKETS_GOOD)
#define ETHERNET_TX_MULTICAST_PACKETS_GOOD_R             HWREG(EMAC_BASE + ETHERNET_O_TX_MULTICAST_PACKETS_GOOD)
#define ETHERNET_TX_64OCTETS_PACKETS_GOOD_BAD_R          HWREG(EMAC_BASE + ETHERNET_O_TX_64OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_TX_65TO127OCTETS_PACKETS_GOOD_BAD_R     HWREG(EMAC_BASE + ETHERNET_O_TX_65TO127OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_TX_128TO255OCTETS_PACKETS_GOOD_BAD_R    HWREG(EMAC_BASE + ETHERNET_O_TX_128TO255OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_TX_256TO511OCTETS_PACKETS_GOOD_BAD_R    HWREG(EMAC_BASE + ETHERNET_O_TX_256TO511OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_TX_512TO1023OCTETS_PACKETS_GOOD_BAD_R   HWREG(EMAC_BASE + ETHERNET_O_TX_512TO1023OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_TX_1024TOMAXOCTETS_PACKETS_GOOD_BAD_R   HWREG(EMAC_BASE + ETHERNET_O_TX_1024TOMAXOCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_TX_UNICAST_PACKETS_GOOD_BAD_R           HWREG(EMAC_BASE + ETHERNET_O_TX_UNICAST_PACKETS_GOOD_BAD)
#define ETHERNET_TX_MULTICAST_PACKETS_GOOD_BAD_R         HWREG(EMAC_BASE + ETHERNET_O_TX_MULTICAST_PACKETS_GOOD_BAD)
#define ETHERNET_TX_BROADCAST_PACKETS_GOOD_BAD_R         HWREG(EMAC_BASE + ETHERNET_O_TX_BROADCAST_PACKETS_GOOD_BAD)
#define ETHERNET_TX_UNDERFLOW_ERROR_PACKETS_R            HWREG(EMAC_BASE + ETHERNET_O_TX_UNDERFLOW_ERROR_PACKETS)
#define ETHERNET_TX_SINGLE_COLLISION_GOOD_PACKETS_R      HWREG(EMAC_BASE + ETHERNET_O_TX_SINGLE_COLLISION_GOOD_PACKETS)
#define ETHERNET_TX_MULTIPLE_COLLISION_GOOD_PACKETS_R    HWREG(EMAC_BASE + ETHERNET_O_TX_MULTIPLE_COLLISION_GOOD_PACKETS)
#define ETHERNET_TX_DEFERRED_PACKETS_R                   HWREG(EMAC_BASE + ETHERNET_O_TX_DEFERRED_PACKETS)
#define ETHERNET_TX_LATE_COLLISION_PACKETS_R             HWREG(EMAC_BASE + ETHERNET_O_TX_LATE_COLLISION_PACKETS)
#define ETHERNET_TX_EXCESSIVE_COLLISION_PACKETS_R        HWREG(EMAC_BASE + ETHERNET_O_TX_EXCESSIVE_COLLISION_PACKETS)
#define ETHERNET_TX_CARRIER_ERROR_PACKETS_R              HWREG(EMAC_BASE + ETHERNET_O_TX_CARRIER_ERROR_PACKETS)
#define ETHERNET_TX_OCTET_COUNT_GOOD_R                   HWREG(EMAC_BASE + ETHERNET_O_TX_OCTET_COUNT_GOOD)
#define ETHERNET_TX_PACKET_COUNT_GOOD_R                  HWREG(EMAC_BASE + ETHERNET_O_TX_PACKET_COUNT_GOOD)
#define ETHERNET_TX_EXCESSIVE_DEFERRAL_ERROR_R           HWREG(EMAC_BASE + ETHERNET_O_TX_EXCESSIVE_DEFERRAL_ERROR)
#define ETHERNET_TX_PAUSE_PACKETS_R                      HWREG(EMAC_BASE + ETHERNET_O_TX_PAUSE_PACKETS)
#define ETHERNET_TX_VLAN_PACKETS_GOOD_R                  HWREG(EMAC_BASE + ETHERNET_O_TX_VLAN_PACKETS_GOOD)
#define ETHERNET_TX_OSIZE_PACKETS_GOOD_R                 HWREG(EMAC_BASE + ETHERNET_O_TX_OSIZE_PACKETS_GOOD)
#define ETHERNET_RX_PACKETS_COUNT_GOOD_BAD_R             HWREG(EMAC_BASE + ETHERNET_O_RX_PACKETS_COUNT_GOOD_BAD)
#define ETHERNET_RX_OCTET_COUNT_GOOD_BAD_R               HWREG(EMAC_BASE + ETHERNET_O_RX_OCTET_COUNT_GOOD_BAD)
#define ETHERNET_RX_OCTET_COUNT_GOOD_R                   HWREG(EMAC_BASE + ETHERNET_O_RX_OCTET_COUNT_GOOD)
#define ETHERNET_RX_BROADCAST_PACKETS_GOOD_R             HWREG(EMAC_BASE + ETHERNET_O_RX_BROADCAST_PACKETS_GOOD)
#define ETHERNET_RX_MULTICAST_PACKETS_GOOD_R             HWREG(EMAC_BASE + ETHERNET_O_RX_MULTICAST_PACKETS_GOOD)
#define ETHERNET_RX_CRC_ERROR_PACKETS_R                  HWREG(EMAC_BASE + ETHERNET_O_RX_CRC_ERROR_PACKETS)
#define ETHERNET_RX_ALIGNMENT_ERROR_PACKETS_R            HWREG(EMAC_BASE + ETHERNET_O_RX_ALIGNMENT_ERROR_PACKETS)
#define ETHERNET_RX_RUNT_ERROR_PACKETS_R                 HWREG(EMAC_BASE + ETHERNET_O_RX_RUNT_ERROR_PACKETS)
#define ETHERNET_RX_JABBER_ERROR_PACKETS_R               HWREG(EMAC_BASE + ETHERNET_O_RX_JABBER_ERROR_PACKETS)
#define ETHERNET_RX_UNDERSIZE_PACKETS_GOOD_R             HWREG(EMAC_BASE + ETHERNET_O_RX_UNDERSIZE_PACKETS_GOOD)
#define ETHERNET_RX_OVERSIZE_PACKETS_GOOD_R              HWREG(EMAC_BASE + ETHERNET_O_RX_OVERSIZE_PACKETS_GOOD)
#define ETHERNET_RX_64OCTETS_PACKETS_GOOD_BAD_R          HWREG(EMAC_BASE + ETHERNET_O_RX_64OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_RX_65TO127OCTETS_PACKETS_GOOD_BAD_R     HWREG(EMAC_BASE + ETHERNET_O_RX_65TO127OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_RX_128TO255OCTETS_PACKETS_GOOD_BAD_R    HWREG(EMAC_BASE + ETHERNET_O_RX_128TO255OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_RX_256TO511OCTETS_PACKETS_GOOD_BAD_R    HWREG(EMAC_BASE + ETHERNET_O_RX_256TO511OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_RX_512TO1023OCTETS_PACKETS_GOOD_BAD_R   HWREG(EMAC_BASE + ETHERNET_O_RX_512TO1023OCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_RX_1024TOMAXOCTETS_PACKETS_GOOD_BAD_R   HWREG(EMAC_BASE + ETHERNET_O_RX_1024TOMAXOCTETS_PACKETS_GOOD_BAD)
#define ETHERNET_RX_UNICAST_PACKETS_GOOD_R               HWREG(EMAC_BASE + ETHERNET_O_RX_UNICAST_PACKETS_GOOD)
#define ETHERNET_RX_LENGTH_ERROR_PACKETS_R               HWREG(EMAC_BASE + ETHERNET_O_RX_LENGTH_ERROR_PACKETS)
#define ETHERNET_RX_OUT_OF_RANGE_TYPE_PACKETS_R          HWREG(EMAC_BASE + ETHERNET_O_RX_OUT_OF_RANGE_TYPE_PACKETS)
#define ETHERNET_RX_PAUSE_PACKETS_R                      HWREG(EMAC_BASE + ETHERNET_O_RX_PAUSE_PACKETS)
#define ETHERNET_RX_FIFO_OVERFLOW_PACKETS_R              HWREG(EMAC_BASE + ETHERNET_O_RX_FIFO_OVERFLOW_PACKETS)
#define ETHERNET_RX_VLAN_PACKETS_GOOD_BAD_R              HWREG(EMAC_BASE + ETHERNET_O_RX_VLAN_PACKETS_GOOD_BAD)
#define ETHERNET_RX_WATCHDOG_ERROR_PACKETS_R             HWREG(EMAC_BASE + ETHERNET_O_RX_WATCHDOG_ERROR_PACKETS)
#define ETHERNET_RX_RECEIVE_ERROR_PACKETS_R              HWREG(EMAC_BASE + ETHERNET_O_RX_RECEIVE_ERROR_PACKETS)
#define ETHERNET_RX_CONTROL_PACKETS_GOOD_R               HWREG(EMAC_BASE + ETHERNET_O_RX_CONTROL_PACKETS_GOOD)
#define ETHERNET_TX_LPI_USEC_CNTR_R                      HWREG(EMAC_BASE + ETHERNET_O_TX_LPI_USEC_CNTR)
#define ETHERNET_TX_LPI_TRAN_CNTR_R                      HWREG(EMAC_BASE + ETHERNET_O_TX_LPI_TRAN_CNTR)
#define ETHERNET_RX_LPI_USEC_CNTR_R                      HWREG(EMAC_BASE + ETHERNET_O_RX_LPI_USEC_CNTR)
#define ETHERNET_RX_LPI_TRAN_CNTR_R                      HWREG(EMAC_BASE + ETHERNET_O_RX_LPI_TRAN_CNTR)
#define ETHERNET_MMC_IPC_RX_INTERRUPT_MASK_R             HWREG(EMAC_BASE + ETHERNET_O_MMC_IPC_RX_INTERRUPT_MASK)
#define ETHERNET_MMC_IPC_RX_INTERRUPT_R                  HWREG(EMAC_BASE + ETHERNET_O_MMC_IPC_RX_INTERRUPT)
#define ETHERNET_RXIPV4_GOOD_PACKETS_R                   HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_GOOD_PACKETS)
#define ETHERNET_RXIPV4_HEADER_ERROR_PACKETS_R           HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_HEADER_ERROR_PACKETS)
#define ETHERNET_RXIPV4_NO_PAYLOAD_PACKETS_R             HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_NO_PAYLOAD_PACKETS)
#define ETHERNET_RXIPV4_FRAGMENTED_PACKETS_R             HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_FRAGMENTED_PACKETS)
#define ETHERNET_RXIPV4_UDP_CHECKSUM_DISABLED_PACKETS_R  HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_UDP_CHECKSUM_DISABLED_PACKETS)
#define ETHERNET_RXIPV6_GOOD_PACKETS_R                   HWREG(EMAC_BASE + ETHERNET_O_RXIPV6_GOOD_PACKETS)
#define ETHERNET_RXIPV6_HEADER_ERROR_PACKETS_R           HWREG(EMAC_BASE + ETHERNET_O_RXIPV6_HEADER_ERROR_PACKETS)
#define ETHERNET_RXIPV6_NO_PAYLOAD_PACKETS_R             HWREG(EMAC_BASE + ETHERNET_O_RXIPV6_NO_PAYLOAD_PACKETS)
#define ETHERNET_RXUDP_GOOD_PACKETS_R                    HWREG(EMAC_BASE + ETHERNET_O_RXUDP_GOOD_PACKETS)
#define ETHERNET_RXUDP_ERROR_PACKETS_R                   HWREG(EMAC_BASE + ETHERNET_O_RXUDP_ERROR_PACKETS)
#define ETHERNET_RXTCP_GOOD_PACKETS_R                    HWREG(EMAC_BASE + ETHERNET_O_RXTCP_GOOD_PACKETS)
#define ETHERNET_RXTCP_ERROR_PACKETS_R                   HWREG(EMAC_BASE + ETHERNET_O_RXTCP_ERROR_PACKETS)
#define ETHERNET_RXICMP_GOOD_PACKETS_R                   HWREG(EMAC_BASE + ETHERNET_O_RXICMP_GOOD_PACKETS)
#define ETHERNET_RXICMP_ERROR_PACKETS_R                  HWREG(EMAC_BASE + ETHERNET_O_RXICMP_ERROR_PACKETS)
#define ETHERNET_RXIPV4_GOOD_OCTETS_R                    HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_GOOD_OCTETS)
#define ETHERNET_RXIPV4_HEADER_ERROR_OCTETS_R            HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_HEADER_ERROR_OCTETS)
#define ETHERNET_RXIPV4_NO_PAYLOAD_OCTETS_R              HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_NO_PAYLOAD_OCTETS)
#define ETHERNET_RXIPV4_FRAGMENTED_OCTETS_R              HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_FRAGMENTED_OCTETS)
#define ETHERNET_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_R    HWREG(EMAC_BASE + ETHERNET_O_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS)
#define ETHERNET_RXIPV6_GOOD_OCTETS_R                    HWREG(EMAC_BASE + ETHERNET_O_RXIPV6_GOOD_OCTETS)
#define ETHERNET_RXIPV6_HEADER_ERROR_OCTETS_R            HWREG(EMAC_BASE + ETHERNET_O_RXIPV6_HEADER_ERROR_OCTETS)
#define ETHERNET_RXIPV6_NO_PAYLOAD_OCTETS_R              HWREG(EMAC_BASE + ETHERNET_O_RXIPV6_NO_PAYLOAD_OCTETS)
#define ETHERNET_RXUDP_GOOD_OCTETS_R                     HWREG(EMAC_BASE + ETHERNET_O_RXUDP_GOOD_OCTETS)
#define ETHERNET_RXUDP_ERROR_OCTETS_R                    HWREG(EMAC_BASE + ETHERNET_O_RXUDP_ERROR_OCTETS)
#define ETHERNET_RXTCP_GOOD_OCTETS_R                     HWREG(EMAC_BASE + ETHERNET_O_RXTCP_GOOD_OCTETS)
#define ETHERNET_RXTCP_ERROR_OCTETS_R                    HWREG(EMAC_BASE + ETHERNET_O_RXTCP_ERROR_OCTETS)
#define ETHERNET_RXICMP_GOOD_OCTETS_R                    HWREG(EMAC_BASE + ETHERNET_O_RXICMP_GOOD_OCTETS)
#define ETHERNET_RXICMP_ERROR_OCTETS_R                   HWREG(EMAC_BASE + ETHERNET_O_RXICMP_ERROR_OCTETS)
#define ETHERNET_MAC_L3_L4_CONTROL0_R                    HWREG(EMAC_BASE + ETHERNET_O_MAC_L3_L4_CONTROL0)
#define ETHERNET_MAC_LAYER4_ADDRESS0_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER4_ADDRESS0)
#define ETHERNET_MAC_LAYER3_ADDR0_REG0_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR0_REG0)
#define ETHERNET_MAC_LAYER3_ADDR1_REG0_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR1_REG0)
#define ETHERNET_MAC_LAYER3_ADDR2_REG0_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR2_REG0)
#define ETHERNET_MAC_LAYER3_ADDR3_REG0_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR3_REG0)
#define ETHERNET_MAC_L3_L4_CONTROL1_R                    HWREG(EMAC_BASE + ETHERNET_O_MAC_L3_L4_CONTROL1)
#define ETHERNET_MAC_LAYER4_ADDRESS1_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER4_ADDRESS1)
#define ETHERNET_MAC_LAYER3_ADDR0_REG1_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR0_REG1)
#define ETHERNET_MAC_LAYER3_ADDR1_REG1_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR1_REG1)
#define ETHERNET_MAC_LAYER3_ADDR2_REG1_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR2_REG1)
#define ETHERNET_MAC_LAYER3_ADDR3_REG1_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR3_REG1)
#define ETHERNET_MAC_L3_L4_CONTROL2_R                    HWREG(EMAC_BASE + ETHERNET_O_MAC_L3_L4_CONTROL2)
#define ETHERNET_MAC_LAYER4_ADDRESS2_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER4_ADDRESS2)
#define ETHERNET_MAC_LAYER3_ADDR0_REG2_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR0_REG2)
#define ETHERNET_MAC_LAYER3_ADDR1_REG2_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR1_REG2)
#define ETHERNET_MAC_LAYER3_ADDR2_REG2_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR2_REG2)
#define ETHERNET_MAC_LAYER3_ADDR3_REG2_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR3_REG2)
#define ETHERNET_MAC_L3_L4_CONTROL3_R                    HWREG(EMAC_BASE + ETHERNET_O_MAC_L3_L4_CONTROL3)
#define ETHERNET_MAC_LAYER4_ADDRESS3_R                   HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER4_ADDRESS3)
#define ETHERNET_MAC_LAYER3_ADDR0_REG3_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR0_REG3)
#define ETHERNET_MAC_LAYER3_ADDR1_REG3_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR1_REG3)
#define ETHERNET_MAC_LAYER3_ADDR2_REG3_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR2_REG3)
#define ETHERNET_MAC_LAYER3_ADDR3_REG3_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_LAYER3_ADDR3_REG3)
#define ETHERNET_MAC_TIMESTAMP_CONTROL_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_CONTROL)
#define ETHERNET_MAC_SUB_SECOND_INCREMENT_R              HWREG(EMAC_BASE + ETHERNET_O_MAC_SUB_SECOND_INCREMENT)
#define ETHERNET_MAC_SYSTEM_TIME_SECONDS_R               HWREG(EMAC_BASE + ETHERNET_O_MAC_SYSTEM_TIME_SECONDS)
#define ETHERNET_MAC_SYSTEM_TIME_NANOSECONDS_R           HWREG(EMAC_BASE + ETHERNET_O_MAC_SYSTEM_TIME_NANOSECONDS)
#define ETHERNET_MAC_SYSTEM_TIME_SECONDS_UPDATE_R        HWREG(EMAC_BASE + ETHERNET_O_MAC_SYSTEM_TIME_SECONDS_UPDATE)
#define ETHERNET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_R    HWREG(EMAC_BASE + ETHERNET_O_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE)
#define ETHERNET_MAC_TIMESTAMP_ADDEND_R                  HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_ADDEND)
#define ETHERNET_MAC_SYSTEM_TIME_HIGHER_WORD_SECONDS_R   HWREG(EMAC_BASE + ETHERNET_O_MAC_SYSTEM_TIME_HIGHER_WORD_SECONDS)
#define ETHERNET_MAC_TIMESTAMP_STATUS_R                  HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_STATUS)
#define ETHERNET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_R   HWREG(EMAC_BASE + ETHERNET_O_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS)
#define ETHERNET_MAC_TX_TIMESTAMP_STATUS_SECONDS_R       HWREG(EMAC_BASE + ETHERNET_O_MAC_TX_TIMESTAMP_STATUS_SECONDS)
#define ETHERNET_MAC_AUXILIARY_CONTROL_R                 HWREG(EMAC_BASE + ETHERNET_O_MAC_AUXILIARY_CONTROL)
#define ETHERNET_MAC_AUXILIARY_TIMESTAMP_NANOSECONDS_R   HWREG(EMAC_BASE + ETHERNET_O_MAC_AUXILIARY_TIMESTAMP_NANOSECONDS)
#define ETHERNET_MAC_AUXILIARY_TIMESTAMP_SECONDS_R       HWREG(EMAC_BASE + ETHERNET_O_MAC_AUXILIARY_TIMESTAMP_SECONDS)
#define ETHERNET_MAC_TIMESTAMP_INGRESS_ASYM_CORR_R       HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_INGRESS_ASYM_CORR)
#define ETHERNET_MAC_TIMESTAMP_EGRESS_ASYM_CORR_R        HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_EGRESS_ASYM_CORR)
#define ETHERNET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_R HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND)
#define ETHERNET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_R  HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND)
#define ETHERNET_MAC_TIMESTAMP_INGRESS_CORR_SUBNANOSEC_R HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_INGRESS_CORR_SUBNANOSEC)
#define ETHERNET_MAC_TIMESTAMP_EGRESS_CORR_SUBNANOSEC_R  HWREG(EMAC_BASE + ETHERNET_O_MAC_TIMESTAMP_EGRESS_CORR_SUBNANOSEC)
#define ETHERNET_MAC_PPS_CONTROL_R                       HWREG(EMAC_BASE + ETHERNET_O_MAC_PPS_CONTROL)
#define ETHERNET_MAC_PTO_CONTROL_R                       HWREG(EMAC_BASE + ETHERNET_O_MAC_PTO_CONTROL)
#define ETHERNET_MAC_SOURCE_PORT_IDENTITY0_R             HWREG(EMAC_BASE + ETHERNET_O_MAC_SOURCE_PORT_IDENTITY0)
#define ETHERNET_MAC_SOURCE_PORT_IDENTITY1_R             HWREG(EMAC_BASE + ETHERNET_O_MAC_SOURCE_PORT_IDENTITY1)
#define ETHERNET_MAC_SOURCE_PORT_IDENTITY2_R             HWREG(EMAC_BASE + ETHERNET_O_MAC_SOURCE_PORT_IDENTITY2)
#define ETHERNET_MAC_LOG_MESSAGE_INTERVAL_R              HWREG(EMAC_BASE + ETHERNET_O_MAC_LOG_MESSAGE_INTERVAL)
#define ETHERNET_DMA_MODE_R                              HWREG(EMAC_BASE + ETHERNET_O_DMA_MODE)
#define ETHERNET_DMA_SYSBUS_MODE_R                       HWREG(EMAC_BASE + ETHERNET_O_DMA_SYSBUS_MODE)
#define ETHERNET_DMA_INTERRUPT_STATUS_R                  HWREG(EMAC_BASE + ETHERNET_O_DMA_INTERRUPT_STATUS)
#define ETHERNET_DMA_DEBUG_STATUS0_R                     HWREG(EMAC_BASE + ETHERNET_O_DMA_DEBUG_STATUS0)
#define ETHERNET_DMA_CH0_CONTROL_R                       HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_CONTROL)
#define ETHERNET_DMA_CH0_TX_CONTROL_R                    HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_TX_CONTROL)
#define ETHERNET_DMA_CH0_RX_CONTROL_R                    HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_RX_CONTROL)
#define ETHERNET_DMA_CH0_TXDESC_LIST_ADDRESS_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_TXDESC_LIST_ADDRESS)
#define ETHERNET_DMA_CH0_RXDESC_LIST_ADDRESS_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_RXDESC_LIST_ADDRESS)
#define ETHERNET_DMA_CH0_TXDESC_TAIL_POINTER_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_TXDESC_TAIL_POINTER)
#define ETHERNET_DMA_CH0_RXDESC_TAIL_POINTER_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_RXDESC_TAIL_POINTER)
#define ETHERNET_DMA_CH0_TXDESC_RING_LENGTH_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_TXDESC_RING_LENGTH)
#define ETHERNET_DMA_CH0_RXDESC_RING_LENGTH_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_RXDESC_RING_LENGTH)
#define ETHERNET_DMA_CH0_INTERRUPT_ENABLE_R              HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_INTERRUPT_ENABLE)
#define ETHERNET_DMA_CH0_RX_INTERRUPT_WATCHDOG_TIMER_R   HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_RX_INTERRUPT_WATCHDOG_TIMER)
#define ETHERNET_DMA_CH0_CURRENT_APP_TXDESC_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_CURRENT_APP_TXDESC)
#define ETHERNET_DMA_CH0_CURRENT_APP_RXDESC_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_CURRENT_APP_RXDESC)
#define ETHERNET_DMA_CH0_CURRENT_APP_TXBUFFER_R          HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_CURRENT_APP_TXBUFFER)
#define ETHERNET_DMA_CH0_CURRENT_APP_RXBUFFER_R          HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_CURRENT_APP_RXBUFFER)
#define ETHERNET_DMA_CH0_STATUS_R                        HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_STATUS)
#define ETHERNET_DMA_CH0_MISS_FRAME_CNT_R                HWREG(EMAC_BASE + ETHERNET_O_DMA_CH0_MISS_FRAME_CNT)
#define ETHERNET_DMA_CH1_CONTROL_R                       HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_CONTROL)
#define ETHERNET_DMA_CH1_TX_CONTROL_R                    HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_TX_CONTROL)
#define ETHERNET_DMA_CH1_RX_CONTROL_R                    HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_RX_CONTROL)
#define ETHERNET_DMA_CH1_TXDESC_LIST_ADDRESS_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_TXDESC_LIST_ADDRESS)
#define ETHERNET_DMA_CH1_RXDESC_LIST_ADDRESS_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_RXDESC_LIST_ADDRESS)
#define ETHERNET_DMA_CH1_TXDESC_TAIL_POINTER_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_TXDESC_TAIL_POINTER)
#define ETHERNET_DMA_CH1_RXDESC_TAIL_POINTER_R           HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_RXDESC_TAIL_POINTER)
#define ETHERNET_DMA_CH1_TXDESC_RING_LENGTH_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_TXDESC_RING_LENGTH)
#define ETHERNET_DMA_CH1_RXDESC_RING_LENGTH_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_RXDESC_RING_LENGTH)
#define ETHERNET_DMA_CH1_INTERRUPT_ENABLE_R              HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_INTERRUPT_ENABLE)
#define ETHERNET_DMA_CH1_RX_INTERRUPT_WATCHDOG_TIMER_R   HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_RX_INTERRUPT_WATCHDOG_TIMER)
#define ETHERNET_DMA_CH1_CURRENT_APP_TXDESC_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_CURRENT_APP_TXDESC)
#define ETHERNET_DMA_CH1_CURRENT_APP_RXDESC_R            HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_CURRENT_APP_RXDESC)
#define ETHERNET_DMA_CH1_CURRENT_APP_TXBUFFER_R          HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_CURRENT_APP_TXBUFFER)
#define ETHERNET_DMA_CH1_CURRENT_APP_RXBUFFER_R          HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_CURRENT_APP_RXBUFFER)
#define ETHERNET_DMA_CH1_STATUS_R                        HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_STATUS)
#define ETHERNET_DMA_CH1_MISS_FRAME_CNT_R                HWREG(EMAC_BASE + ETHERNET_O_DMA_CH1_MISS_FRAME_CNT)
#define ETHERNET_MTL_OPERATION_MODE_R                    HWREG(EMAC_BASE + ETHERNET_O_MTL_OPERATION_MODE)
#define ETHERNET_MTL_DBG_CTL_R                           HWREG(EMAC_BASE + ETHERNET_O_MTL_DBG_CTL)
#define ETHERNET_MTL_DBG_STS_R                           HWREG(EMAC_BASE + ETHERNET_O_MTL_DBG_STS)
#define ETHERNET_MTL_FIFO_DEBUG_DATA_R                   HWREG(EMAC_BASE + ETHERNET_O_MTL_FIFO_DEBUG_DATA)
#define ETHERNET_MTL_INTERRUPT_STATUS_R                  HWREG(EMAC_BASE + ETHERNET_O_MTL_INTERRUPT_STATUS)
#define ETHERNET_MTL_RXQ_DMA_MAP0_R                      HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ_DMA_MAP0)
#define ETHERNET_MTL_TXQ0_OPERATION_MODE_R               HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ0_OPERATION_MODE)
#define ETHERNET_MTL_TXQ0_UNDERFLOW_R                    HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ0_UNDERFLOW)
#define ETHERNET_MTL_TXQ0_DEBUG_R                        HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ0_DEBUG)
#define ETHERNET_MTL_TXQ0_ETS_STATUS_R                   HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ0_ETS_STATUS)
#define ETHERNET_MTL_TXQ0_QUANTUM_WEIGHT_R               HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ0_QUANTUM_WEIGHT)
#define ETHERNET_MTL_Q0_INTERRUPT_CONTROL_STATUS_R       HWREG(EMAC_BASE + ETHERNET_O_MTL_Q0_INTERRUPT_CONTROL_STATUS)
#define ETHERNET_MTL_RXQ0_OPERATION_MODE_R               HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ0_OPERATION_MODE)
#define ETHERNET_MTL_RXQ0_MISSED_PACKET_OVERFLOW_CNT_R   HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ0_MISSED_PACKET_OVERFLOW_CNT)
#define ETHERNET_MTL_RXQ0_DEBUG_R                        HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ0_DEBUG)
#define ETHERNET_MTL_RXQ0_CONTROL_R                      HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ0_CONTROL)
#define ETHERNET_MTL_TXQ1_OPERATION_MODE_R               HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ1_OPERATION_MODE)
#define ETHERNET_MTL_TXQ1_UNDERFLOW_R                    HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ1_UNDERFLOW)
#define ETHERNET_MTL_TXQ1_DEBUG_R                        HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ1_DEBUG)
#define ETHERNET_MTL_TXQ1_ETS_STATUS_R                   HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ1_ETS_STATUS)
#define ETHERNET_MTL_TXQ1_QUANTUM_WEIGHT_R               HWREG(EMAC_BASE + ETHERNET_O_MTL_TXQ1_QUANTUM_WEIGHT)
#define ETHERNET_MTL_Q1_INTERRUPT_CONTROL_STATUS_R       HWREG(EMAC_BASE + ETHERNET_O_MTL_Q1_INTERRUPT_CONTROL_STATUS)
#define ETHERNET_MTL_RXQ1_OPERATION_MODE_R               HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ1_OPERATION_MODE)
#define ETHERNET_MTL_RXQ1_MISSED_PACKET_OVERFLOW_CNT_R   HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ1_MISSED_PACKET_OVERFLOW_CNT)
#define ETHERNET_MTL_RXQ1_DEBUG_R                        HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ1_DEBUG)
#define ETHERNET_MTL_RXQ1_CONTROL_R                      HWREG(EMAC_BASE + ETHERNET_O_MTL_RXQ1_CONTROL)

//EMACSS registers
#define ETHERNETSS_IPREVNUM_R                            HWREG(EMAC_SS_BASE + ETHERNETSS_O_IPREVNUM)
#define ETHERNETSS_CTRLSTS_R                             HWREG(EMAC_SS_BASE + ETHERNETSS_O_CTRLSTS)
#define ETHERNETSS_PTPTSTRIGSEL0_R                       HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTPTSTRIGSEL0)
#define ETHERNETSS_PTPTSTRIGSEL1_R                       HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTPTSTRIGSEL1)
#define ETHERNETSS_PTPTSSWTRIG0_R                        HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTPTSSWTRIG0)
#define ETHERNETSS_PTPTSSWTRIG1_R                        HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTPTSSWTRIG1)
#define ETHERNETSS_PTPPPSR0_R                            HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTPPPSR0)
#define ETHERNETSS_PTPPPSR1_R                            HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTPPPSR1)
#define ETHERNETSS_PTP_TSRL_R                            HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTP_TSRL)
#define ETHERNETSS_PTP_TSRH_R                            HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTP_TSRH)
#define ETHERNETSS_PTP_TSWL_R                            HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTP_TSWL)
#define ETHERNETSS_PTP_TSWH_R                            HWREG(EMAC_SS_BASE + ETHERNETSS_O_PTP_TSWH)
#define ETHERNETSS_REVMII_CTRL_R                         HWREG(EMAC_SS_BASE + ETHERNETSS_O_REVMII_CTRL)

//Transmit normal descriptor (read format)
#define ETH_TDES0_BUF1AP        0xFFFFFFFF
#define ETH_TDES1_BUF2AP        0xFFFFFFFF
#define ETH_TDES2_IOC           0x80000000
#define ETH_TDES2_TTSE          0x40000000
#define ETH_TDES2_B2L           0x3FFF0000
#define ETH_TDES2_VTIR          0x0000C000
#define ETH_TDES2_B1L           0x00003FFF
#define ETH_TDES3_OWN           0x80000000
#define ETH_TDES3_CTXT          0x40000000
#define ETH_TDES3_FD            0x20000000
#define ETH_TDES3_LD            0x10000000
#define ETH_TDES3_CPC           0x0C000000
#define ETH_TDES3_SAIC          0x03800000
#define ETH_TDES3_THL           0x00780000
#define ETH_TDES3_TSE           0x00040000
#define ETH_TDES3_CIC           0x00030000
#define ETH_TDES3_FL            0x00007FFF

//Transmit normal descriptor (write-back format)
#define ETH_TDES0_TTSL          0xFFFFFFFF
#define ETH_TDES1_TTSH          0xFFFFFFFF
#define ETH_TDES3_OWN           0x80000000
#define ETH_TDES3_CTXT          0x40000000
#define ETH_TDES3_FD            0x20000000
#define ETH_TDES3_LD            0x10000000
#define ETH_TDES3_TTSS          0x00020000
#define ETH_TDES3_ES            0x00008000
#define ETH_TDES3_JT            0x00004000
#define ETH_TDES3_FF            0x00002000
#define ETH_TDES3_PCE           0x00001000
#define ETH_TDES3_LOC           0x00000800
#define ETH_TDES3_NC            0x00000400
#define ETH_TDES3_LC            0x00000200
#define ETH_TDES3_EC            0x00000100
#define ETH_TDES3_CC            0x000000F0
#define ETH_TDES3_ED            0x00000008
#define ETH_TDES3_UF            0x00000004
#define ETH_TDES3_DB            0x00000002
#define ETH_TDES3_IHE           0x00000001

//Transmit context descriptor
#define ETH_TDES0_TTSL          0xFFFFFFFF
#define ETH_TDES1_TTSH          0xFFFFFFFF
#define ETH_TDES2_IVT           0xFFFF0000
#define ETH_TDES2_MSS           0x00003FFF
#define ETH_TDES3_OWN           0x80000000
#define ETH_TDES3_CTXT          0x40000000
#define ETH_TDES3_OSTC          0x08000000
#define ETH_TDES3_TCMSSV        0x04000000
#define ETH_TDES3_CDE           0x00800000
#define ETH_TDES3_IVLTV         0x00020000
#define ETH_TDES3_VLTV          0x00010000
#define ETH_TDES3_VT            0x0000FFFF

//Receive normal descriptor (read format)
#define ETH_RDES0_BUF1AP        0xFFFFFFFF
#define ETH_RDES2_BUF2AP        0xFFFFFFFF
#define ETH_RDES3_OWN           0x80000000
#define ETH_RDES3_IOC           0x40000000
#define ETH_RDES3_BUF2V         0x02000000
#define ETH_RDES3_BUF1V         0x01000000

//Receive normal descriptor (write-back format)
#define ETH_RDES0_IVT           0xFFFF0000
#define ETH_RDES0_OVT           0x0000FFFF
#define ETH_RDES1_OPC           0xFFFF0000
#define ETH_RDES1_TD            0x00008000
#define ETH_RDES1_TSA           0x00004000
#define ETH_RDES1_PV            0x00002000
#define ETH_RDES1_PFT           0x00001000
#define ETH_RDES1_PMT           0x00000F00
#define ETH_RDES1_IPCE          0x00000080
#define ETH_RDES1_IPCB          0x00000040
#define ETH_RDES1_IPV6          0x00000020
#define ETH_RDES1_IPV4          0x00000010
#define ETH_RDES1_IPHE          0x00000008
#define ETH_RDES1_PT            0x00000007
#define ETH_RDES2_L3L4FM        0xE0000000
#define ETH_RDES2_L4FM          0x10000000
#define ETH_RDES2_L3FM          0x08000000
#define ETH_RDES2_MADRM         0x07F80000
#define ETH_RDES2_HF            0x00040000
#define ETH_RDES2_DAF           0x00020000
#define ETH_RDES2_SAF           0x00010000
#define ETH_RDES2_VF            0x00008000
#define ETH_RDES2_ARPRN         0x00000400
#define ETH_RDES3_OWN           0x80000000
#define ETH_RDES3_CTXT          0x40000000
#define ETH_RDES3_FD            0x20000000
#define ETH_RDES3_LD            0x10000000
#define ETH_RDES3_RS2V          0x08000000
#define ETH_RDES3_RS1V          0x04000000
#define ETH_RDES3_RS0V          0x02000000
#define ETH_RDES3_CE            0x01000000
#define ETH_RDES3_GP            0x00800000
#define ETH_RDES3_RWT           0x00400000
#define ETH_RDES3_OE            0x00200000
#define ETH_RDES3_RE            0x00100000
#define ETH_RDES3_DE            0x00080000
#define ETH_RDES3_LT            0x00070000
#define ETH_RDES3_ES            0x00008000
#define ETH_RDES3_PL            0x00007FFF

//Receive context descriptor
#define ETH_RDES0_RTSL          0xFFFFFFFF
#define ETH_RDES1_RTSH          0xFFFFFFFF
#define ETH_RDES3_OWN           0x80000000
#define ETH_RDES3_CTXT          0x40000000

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Transmit descriptor
 **/

typedef struct
{
   uint32_t tdes0;
   uint32_t tdes1;
   uint32_t tdes2;
   uint32_t tdes3;
} F2838xTxDmaDesc;


/**
 * @brief Receive descriptor
 **/

typedef struct
{
   uint32_t rdes0;
   uint32_t rdes1;
   uint32_t rdes2;
   uint32_t rdes3;
} F2838xRxDmaDesc;


//TMS320F2838xD Ethernet MAC driver
extern const NicDriver f2838xEthDriver;

//TMS320F2838xD Ethernet MAC related functions
error_t f2838xEthInit(NetInterface *interface);
void f2838xEthInitGpio(NetInterface *interface);
void f2838xEthInitDmaDesc(NetInterface *interface);

void f2838xEthTick(NetInterface *interface);

void f2838xEthEnableIrq(NetInterface *interface);
void f2838xEthDisableIrq(NetInterface *interface);
void f2838xEthIrqHandler(void);
void f2838xEthEventHandler(NetInterface *interface);

error_t f2838xEthSendPacket(NetInterface *interface,
   const NetBuffer *buffer, size_t offset, NetTxAncillary *ancillary);

error_t f2838xEthReceivePacket(NetInterface *interface);

error_t f2838xEthUpdateMacAddrFilter(NetInterface *interface);
error_t f2838xEthUpdateMacConfig(NetInterface *interface);

void f2838xEthWritePhyReg(uint8_t opcode, uint8_t phyAddr,
   uint8_t regAddr, uint16_t data);

uint16_t f2838xEthReadPhyReg(uint8_t opcode, uint8_t phyAddr,
   uint8_t regAddr);

uint32_t f2838xEthCalcCrc(const void *data, size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
