/* Adapted for use with IAR Embedded Workbench */
/******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized.
* This software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES
* REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY
* DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
* FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS
* AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this
* software and to discontinue the availability of this software.
* By using this software, you agree to the additional terms and
* conditions found by accessing the following link:
* http://www.renesas.com/disclaimer
******************************************************************************/
/* Copyright (C) 2010 Renesas Electronics Corporation. All rights reserved. */
/* Code written for Renesas by Future Designs, Inc. www.teamfdi.com */

/******************************************************************************
* File Name : font_8x8.c
* Version : 1.00
* Tool-Chain : Glyph - The Generic API for Graphics LCD API
* H/W Platform : RX62N Group
* Description : An 8 x 8 Font.
******************************************************************************
* History :
* : 21.07.2010 1.00 First Release
******************************************************************************/

/******************************************************************************
Includes Glyph config Include
******************************************************************************/
#include "glyph_config.h"

const uint8_t Font8x8_char_0[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
const uint8_t Font8x8_char_1[] = {
  0x08, 0x08, // width=8, height=8
  0x7E, 0x81, 0x95, 0xB1, 0xB1, 0x95, 0x81, 0x7E, 
};
const uint8_t Font8x8_char_2[] = {
  0x08, 0x08, // width=8, height=8
  0x3E, 0x77, 0x6B, 0x6F, 0x6B, 0x77, 0x3E, 0x00, 
};
const uint8_t Font8x8_char_3[] = {
  0x08, 0x08, // width=8, height=8
  0x0F, 0x1F, 0x3E, 0x7C, 0x3E, 0x1F, 0x0F, 0x00, 
};
const uint8_t Font8x8_char_4[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 
};
const uint8_t Font8x8_char_5[] = {
  0x08, 0x08, // width=8, height=8
  0x18, 0x18, 0x5A, 0x67, 0x5A, 0x18, 0x18, 0x00, 
};
const uint8_t Font8x8_char_6[] = {
  0x08, 0x08, // width=8, height=8
  0x0C, 0x1E, 0x5F, 0x6F, 0x5F, 0x1E, 0x0C, 0x00, 
};
const uint8_t Font8x8_char_7[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x08, 0x1C, 0x3E, 0x3E, 0x1C, 0x08, 0x00, 
};
const uint8_t Font8x8_char_8[] = {
  0x08, 0x08, // width=8, height=8
  0xFF, 0xF7, 0xE3, 0xC1, 0xC1, 0xE3, 0xF7, 0xFF, 
};
const uint8_t Font8x8_char_9[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x18, 0x3C, 0x66, 0x66, 0x3C, 0x18, 0x00, 
};
const uint8_t Font8x8_char_10[] = {
  0x08, 0x08, // width=8, height=8
  0xFF, 0xE7, 0xC3, 0x99, 0x99, 0xC3, 0xE7, 0xFF, 
};
const uint8_t Font8x8_char_11[] = {
  0x08, 0x08, // width=8, height=8
  0x60, 0xF0, 0x98, 0x9D, 0xF7, 0x6F, 0x0F, 0x00, 
};
const uint8_t Font8x8_char_12[] = {
  0x08, 0x08, // width=8, height=8
  0x06, 0x2F, 0x29, 0xF9, 0xF9, 0x29, 0x2F, 0x06, 
};
const uint8_t Font8x8_char_13[] = {
  0x08, 0x08, // width=8, height=8
  0x40, 0xE0, 0xE0, 0x7F, 0x1F, 0x05, 0x07, 0x00, 
};
const uint8_t Font8x8_char_14[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x30, 0x3F, 0x5F, 0xC3, 0xFF, 0x7F, 0x00, 
};
const uint8_t Font8x8_char_15[] = {
  0x08, 0x08, // width=8, height=8
  0x49, 0x5D, 0x3E, 0x63, 0x63, 0x3E, 0x5D, 0x49, 
};
const uint8_t Font8x8_char_16[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x3E, 0x1C, 0x1C, 0x08, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_17[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x08, 0x1C, 0x1C, 0x3E, 0x7F, 0x00, 
};
const uint8_t Font8x8_char_18[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x14, 0x36, 0x7F, 0x7F, 0x36, 0x14, 0x00, 
};
const uint8_t Font8x8_char_19[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x5F, 0x5F, 0x00, 0x00, 0x5F, 0x5F, 0x00, 
};
const uint8_t Font8x8_char_20[] = {
  0x08, 0x08, // width=8, height=8
  0x02, 0x07, 0x0D, 0x7F, 0x7F, 0x01, 0x7F, 0x7F, 
};
const uint8_t Font8x8_char_21[] = {
  0x08, 0x08, // width=8, height=8
  0x40, 0xDA, 0xBF, 0xA5, 0xFD, 0x5B, 0x02, 0x00, 
};
const uint8_t Font8x8_char_22[] = {
  0x08, 0x08, // width=8, height=8
  0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x00, 
};
const uint8_t Font8x8_char_23[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x94, 0xB6, 0xFF, 0xFF, 0xB6, 0x94, 0x00, 
};
const uint8_t Font8x8_char_24[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x04, 0x06, 0x7F, 0x7F, 0x06, 0x04, 0x00, 
};
const uint8_t Font8x8_char_25[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x10, 0x30, 0x7F, 0x7F, 0x30, 0x10, 0x00, 
};
const uint8_t Font8x8_char_26[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x08, 0x08, 0x3E, 0x3E, 0x1C, 0x08, 0x00, 
};
const uint8_t Font8x8_char_27[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x1C, 0x3E, 0x3E, 0x08, 0x08, 0x08, 0x00, 
};
const uint8_t Font8x8_char_28[] = {
  0x08, 0x08, // width=8, height=8
  0x3C, 0x3C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 
};
const uint8_t Font8x8_char_29[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x1C, 0x3E, 0x08, 0x08, 0x3E, 0x1C, 0x08, 
};
const uint8_t Font8x8_char_30[] = {
  0x08, 0x08, // width=8, height=8
  0x20, 0x38, 0x3C, 0x3E, 0x3C, 0x38, 0x20, 0x00, 
};
const uint8_t Font8x8_char_31[] = {
  0x08, 0x08, // width=8, height=8
  0x02, 0x0E, 0x1E, 0x3E, 0x1E, 0x0E, 0x02, 0x00, 
};
const uint8_t Font8x8_char_32[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_33[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x06, 0x5F, 0x5F, 0x06, 0x00, 0x00, 
};
const uint8_t Font8x8_char_34[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x07, 0x07, 0x00, 0x07, 0x07, 0x00, 0x00, 
};
const uint8_t Font8x8_char_35[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x7F, 0x7F, 0x14, 0x7F, 0x7F, 0x14, 0x00, 
};
const uint8_t Font8x8_char_36[] = {
  0x08, 0x08, // width=8, height=8
  0x24, 0x2E, 0x2A, 0x6B, 0x6B, 0x3A, 0x12, 0x00, 
};
const uint8_t Font8x8_char_37[] = {
  0x08, 0x08, // width=8, height=8
  0x42, 0x62, 0x30, 0x18, 0x0C, 0x46, 0x42, 0x00, 
};
const uint8_t Font8x8_char_38[] = {
  0x08, 0x08, // width=8, height=8
  0x30, 0x7A, 0x4F, 0x4D, 0x37, 0x7A, 0x48, 0x00, 
};
const uint8_t Font8x8_char_39[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x04, 0x07, 0x03, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_40[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x1C, 0x3E, 0x63, 0x41, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_41[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x41, 0x63, 0x3E, 0x1C, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_42[] = {
  0x08, 0x08, // width=8, height=8
  0x2A, 0x3E, 0x3E, 0x1C, 0x3E, 0x3E, 0x2A, 0x00, 
};
const uint8_t Font8x8_char_43[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x08, 0x08, 0x3E, 0x3E, 0x08, 0x08, 0x00, 
};
const uint8_t Font8x8_char_44[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x40, 0x70, 0x30, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_45[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 
};
const uint8_t Font8x8_char_46[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_47[] = {
  0x08, 0x08, // width=8, height=8
  0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x00, 
};
const uint8_t Font8x8_char_48[] = {
  0x08, 0x08, // width=8, height=8
  0x3E, 0x7F, 0x71, 0x59, 0x4D, 0x7F, 0x3E, 0x00, 
};
const uint8_t Font8x8_char_49[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x42, 0x42, 0x7F, 0x7F, 0x40, 0x40, 0x00, 
};
const uint8_t Font8x8_char_50[] = {
  0x08, 0x08, // width=8, height=8
  0x42, 0x63, 0x71, 0x59, 0x4D, 0x67, 0x62, 0x00, 
};
const uint8_t Font8x8_char_51[] = {
  0x08, 0x08, // width=8, height=8
  0x22, 0x63, 0x49, 0x49, 0x49, 0x7F, 0x36, 0x00, 
};
const uint8_t Font8x8_char_52[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x18, 0x1C, 0x16, 0x7F, 0x7F, 0x10, 0x00, 
};
const uint8_t Font8x8_char_53[] = {
  0x08, 0x08, // width=8, height=8
  0x27, 0x67, 0x45, 0x45, 0x45, 0x7D, 0x39, 0x00, 
};
const uint8_t Font8x8_char_54[] = {
  0x08, 0x08, // width=8, height=8
  0x3E, 0x7F, 0x49, 0x49, 0x49, 0x7B, 0x32, 0x00, 
};
const uint8_t Font8x8_char_55[] = {
  0x08, 0x08, // width=8, height=8
  0x03, 0x03, 0x01, 0x71, 0x79, 0x0F, 0x07, 0x00, 
};
const uint8_t Font8x8_char_56[] = {
  0x08, 0x08, // width=8, height=8
  0x36, 0x7F, 0x49, 0x49, 0x49, 0x7F, 0x36, 0x00, 
};
const uint8_t Font8x8_char_57[] = {
  0x08, 0x08, // width=8, height=8
  0x26, 0x6F, 0x49, 0x49, 0x49, 0x7F, 0x3E, 0x00, 
};
const uint8_t Font8x8_char_58[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 
};
const uint8_t Font8x8_char_59[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x80, 0xE6, 0x66, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_60[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x08, 0x1C, 0x36, 0x63, 0x41, 0x00, 0x00, 
};
const uint8_t Font8x8_char_61[] = {
  0x08, 0x08, // width=8, height=8
  0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 
};
const uint8_t Font8x8_char_62[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x41, 0x63, 0x36, 0x1C, 0x08, 0x00, 0x00, 
};
const uint8_t Font8x8_char_63[] = {
  0x08, 0x08, // width=8, height=8
  0x02, 0x03, 0x01, 0x51, 0x59, 0x0F, 0x06, 0x00, 
};
const uint8_t Font8x8_char_64[] = {
  0x08, 0x08, // width=8, height=8
  0x3E, 0x7F, 0x41, 0x59, 0x59, 0x5F, 0x4E, 0x00, 
};
const uint8_t Font8x8_char_65[] = {
  0x08, 0x08, // width=8, height=8
  0x7C, 0x7E, 0x13, 0x11, 0x13, 0x7E, 0x7C, 0x00, 
};
const uint8_t Font8x8_char_66[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00, 
};
const uint8_t Font8x8_char_67[] = {
  0x08, 0x08, // width=8, height=8
  0x1C, 0x3E, 0x63, 0x41, 0x41, 0x63, 0x22, 0x00, 
};
const uint8_t Font8x8_char_68[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x41, 0x63, 0x3E, 0x1C, 0x00, 
};
const uint8_t Font8x8_char_69[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x49, 0x49, 0x49, 0x41, 0x63, 0x00, 
};
const uint8_t Font8x8_char_70[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x49, 0x09, 0x09, 0x03, 0x00, 
};
const uint8_t Font8x8_char_71[] = {
  0x08, 0x08, // width=8, height=8
  0x3E, 0x7F, 0x41, 0x51, 0x51, 0x73, 0x32, 0x00, 
};
const uint8_t Font8x8_char_72[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x08, 0x08, 0x08, 0x7F, 0x7F, 0x00, 
};
const uint8_t Font8x8_char_73[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x41, 0x7F, 0x7F, 0x41, 0x00, 0x00, 
};
const uint8_t Font8x8_char_74[] = {
  0x08, 0x08, // width=8, height=8
  0x30, 0x70, 0x41, 0x7F, 0x3F, 0x01, 0x00, 0x00, 
};
const uint8_t Font8x8_char_75[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x08, 0x1C, 0x36, 0x63, 0x41, 0x00, 
};
const uint8_t Font8x8_char_76[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x41, 0x40, 0x40, 0x60, 0x00, 
};
const uint8_t Font8x8_char_77[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x06, 0x1C, 0x06, 0x7F, 0x7F, 0x00, 
};
const uint8_t Font8x8_char_78[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x0E, 0x18, 0x30, 0x7F, 0x7F, 0x00, 
};
const uint8_t Font8x8_char_79[] = {
  0x08, 0x08, // width=8, height=8
  0x3E, 0x7F, 0x41, 0x41, 0x41, 0x7F, 0x3E, 0x00, 
};
const uint8_t Font8x8_char_80[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x49, 0x09, 0x0F, 0x06, 0x00, 
};
const uint8_t Font8x8_char_81[] = {
  0x08, 0x08, // width=8, height=8
  0x3E, 0x7F, 0x41, 0x61, 0x41, 0xFF, 0xBE, 0x00, 
};
const uint8_t Font8x8_char_82[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x09, 0x19, 0x39, 0x6F, 0x46, 0x00, 
};
const uint8_t Font8x8_char_83[] = {
  0x08, 0x08, // width=8, height=8
  0x26, 0x6F, 0x49, 0x49, 0x49, 0x7B, 0x32, 0x00, 
};
const uint8_t Font8x8_char_84[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x03, 0x41, 0x7F, 0x7F, 0x41, 0x03, 0x00, 
};
const uint8_t Font8x8_char_85[] = {
  0x08, 0x08, // width=8, height=8
  0x3F, 0x7F, 0x40, 0x40, 0x40, 0x7F, 0x3F, 0x00, 
};
const uint8_t Font8x8_char_86[] = {
  0x08, 0x08, // width=8, height=8
  0x0F, 0x1F, 0x30, 0x60, 0x30, 0x1F, 0x0F, 0x00, 
};
const uint8_t Font8x8_char_87[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x30, 0x1C, 0x30, 0x7F, 0x7F, 0x00, 
};
const uint8_t Font8x8_char_88[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x63, 0x3E, 0x1C, 0x3E, 0x63, 0x41, 0x00, 
};
const uint8_t Font8x8_char_89[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x07, 0x4F, 0x78, 0x78, 0x4F, 0x07, 0x00, 
};
const uint8_t Font8x8_char_90[] = {
  0x08, 0x08, // width=8, height=8
  0x43, 0x61, 0x71, 0x59, 0x4D, 0x47, 0x63, 0x00, 
};
const uint8_t Font8x8_char_91[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x7F, 0x7F, 0x41, 0x41, 0x41, 0x00, 0x00, 
};
const uint8_t Font8x8_char_92[] = {
  0x08, 0x08, // width=8, height=8
  0x01, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00, 
};
const uint8_t Font8x8_char_93[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x41, 0x41, 0x41, 0x7F, 0x7F, 0x00, 0x00, 
};
const uint8_t Font8x8_char_94[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x08, 0x00, 
};
const uint8_t Font8x8_char_95[] = {
  0x08, 0x08, // width=8, height=8
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 
};
const uint8_t Font8x8_char_96[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x03, 0x07, 0x04, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_97[] = {
  0x08, 0x08, // width=8, height=8
  0x20, 0x74, 0x54, 0x54, 0x7C, 0x78, 0x40, 0x00, 
};
const uint8_t Font8x8_char_98[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x44, 0x44, 0x7C, 0x38, 0x00, 
};
const uint8_t Font8x8_char_99[] = {
  0x08, 0x08, // width=8, height=8
  0x38, 0x7C, 0x44, 0x44, 0x44, 0x6C, 0x28, 0x00, 
};
const uint8_t Font8x8_char_100[] = {
  0x08, 0x08, // width=8, height=8
  0x38, 0x7C, 0x44, 0x45, 0x7F, 0x7F, 0x40, 0x00, 
};
const uint8_t Font8x8_char_101[] = {
  0x08, 0x08, // width=8, height=8
  0x38, 0x7C, 0x54, 0x54, 0x54, 0x5C, 0x18, 0x00, 
};
const uint8_t Font8x8_char_102[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x48, 0x7E, 0x7F, 0x49, 0x0B, 0x02, 0x00, 
};
const uint8_t Font8x8_char_103[] = {
  0x08, 0x08, // width=8, height=8
  0x18, 0xBC, 0xA4, 0xA4, 0xA8, 0xFC, 0x7C, 0x00, 
};
const uint8_t Font8x8_char_104[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x04, 0x04, 0x7C, 0x78, 0x00, 
};
const uint8_t Font8x8_char_105[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x44, 0x7D, 0x7D, 0x40, 0x00, 0x00, 
};
const uint8_t Font8x8_char_106[] = {
  0x08, 0x08, // width=8, height=8
  0x40, 0xC0, 0x80, 0x84, 0xFD, 0x7D, 0x00, 0x00, 
};
const uint8_t Font8x8_char_107[] = {
  0x08, 0x08, // width=8, height=8
  0x41, 0x7F, 0x7F, 0x10, 0x38, 0x6C, 0x44, 0x00, 
};
const uint8_t Font8x8_char_108[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x7F, 0x7F, 0x40, 0x00, 0x00, 
};
const uint8_t Font8x8_char_109[] = {
  0x08, 0x08, // width=8, height=8
  0x78, 0x7C, 0x0C, 0x38, 0x0C, 0x7C, 0x78, 0x00, 
};
const uint8_t Font8x8_char_110[] = {
  0x08, 0x08, // width=8, height=8
  0x04, 0x7C, 0x78, 0x04, 0x04, 0x7C, 0x78, 0x00, 
};
const uint8_t Font8x8_char_111[] = {
  0x08, 0x08, // width=8, height=8
  0x38, 0x7C, 0x44, 0x44, 0x44, 0x7C, 0x38, 0x00, 
};
const uint8_t Font8x8_char_112[] = {
  0x08, 0x08, // width=8, height=8
  0x84, 0xFC, 0xF8, 0xA4, 0x24, 0x3C, 0x18, 0x00, 
};
const uint8_t Font8x8_char_113[] = {
  0x08, 0x08, // width=8, height=8
  0x18, 0x3C, 0x24, 0xA4, 0xF8, 0xFC, 0x84, 0x00, 
};
const uint8_t Font8x8_char_114[] = {
  0x08, 0x08, // width=8, height=8
  0x44, 0x7C, 0x78, 0x44, 0x04, 0x0C, 0x08, 0x00, 
};
const uint8_t Font8x8_char_115[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x5C, 0x54, 0x54, 0x54, 0x74, 0x20, 0x00, 
};
const uint8_t Font8x8_char_116[] = {
  0x08, 0x08, // width=8, height=8
  0x04, 0x04, 0x3F, 0x7F, 0x44, 0x64, 0x20, 0x00, 
};
const uint8_t Font8x8_char_117[] = {
  0x08, 0x08, // width=8, height=8
  0x3C, 0x7C, 0x40, 0x40, 0x3C, 0x7C, 0x40, 0x00, 
};
const uint8_t Font8x8_char_118[] = {
  0x08, 0x08, // width=8, height=8
  0x0C, 0x1C, 0x30, 0x60, 0x30, 0x1C, 0x0C, 0x00, 
};
const uint8_t Font8x8_char_119[] = {
  0x08, 0x08, // width=8, height=8
  0x3C, 0x7C, 0x60, 0x30, 0x60, 0x7C, 0x3C, 0x00, 
};
const uint8_t Font8x8_char_120[] = {
  0x08, 0x08, // width=8, height=8
  0x44, 0x6C, 0x38, 0x10, 0x38, 0x6C, 0x44, 0x00, 
};
const uint8_t Font8x8_char_121[] = {
  0x08, 0x08, // width=8, height=8
  0x1C, 0xBC, 0xA0, 0xA0, 0x90, 0xFC, 0x7C, 0x00, 
};
const uint8_t Font8x8_char_122[] = {
  0x08, 0x08, // width=8, height=8
  0x4C, 0x64, 0x74, 0x5C, 0x4C, 0x64, 0x00, 0x00, 
};
const uint8_t Font8x8_char_123[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x08, 0x08, 0x3E, 0x77, 0x41, 0x41, 0x00, 
};
const uint8_t Font8x8_char_124[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_125[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x41, 0x41, 0x77, 0x3E, 0x08, 0x08, 0x00, 
};
const uint8_t Font8x8_char_126[] = {
  0x08, 0x08, // width=8, height=8
  0x02, 0x03, 0x01, 0x03, 0x02, 0x03, 0x01, 0x00, 
};
const uint8_t Font8x8_char_127[] = {
  0x08, 0x08, // width=8, height=8
  0x40, 0x70, 0x7C, 0x4E, 0x7C, 0x70, 0x40, 0x00, 
};
const uint8_t Font8x8_char_128[] = {
  0x08, 0x08, // width=8, height=8
  0x44, 0xCE, 0x9B, 0xB1, 0xF1, 0x5B, 0x0A, 0x00, 
};
const uint8_t Font8x8_char_129[] = {
  0x08, 0x08, // width=8, height=8
  0x3A, 0x7A, 0x40, 0x40, 0x20, 0x7A, 0x7A, 0x00, 
};
const uint8_t Font8x8_char_130[] = {
  0x08, 0x08, // width=8, height=8
  0x38, 0x7C, 0x54, 0x54, 0x55, 0x5D, 0x19, 0x00, 
};
const uint8_t Font8x8_char_131[] = {
  0x08, 0x08, // width=8, height=8
  0x22, 0x77, 0x55, 0x55, 0x7D, 0x7B, 0x42, 0x00, 
};
const uint8_t Font8x8_char_132[] = {
  0x08, 0x08, // width=8, height=8
  0x21, 0x75, 0x54, 0x54, 0x7C, 0x79, 0x41, 0x00, 
};
const uint8_t Font8x8_char_133[] = {
  0x08, 0x08, // width=8, height=8
  0x21, 0x75, 0x55, 0x54, 0x7C, 0x78, 0x40, 0x00, 
};
const uint8_t Font8x8_char_134[] = {
  0x08, 0x08, // width=8, height=8
  0x20, 0x74, 0x57, 0x57, 0x7F, 0x78, 0x40, 0x00, 
};
const uint8_t Font8x8_char_135[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x5C, 0xD4, 0xB4, 0xF4, 0x54, 0x00, 0x00, 
};
const uint8_t Font8x8_char_136[] = {
  0x08, 0x08, // width=8, height=8
  0x3A, 0x7F, 0x55, 0x55, 0x55, 0x5F, 0x1A, 0x00, 
};
const uint8_t Font8x8_char_137[] = {
  0x08, 0x08, // width=8, height=8
  0x39, 0x7D, 0x54, 0x54, 0x54, 0x5D, 0x19, 0x00, 
};
const uint8_t Font8x8_char_138[] = {
  0x08, 0x08, // width=8, height=8
  0x39, 0x7D, 0x55, 0x54, 0x54, 0x5C, 0x18, 0x00, 
};
const uint8_t Font8x8_char_139[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x01, 0x45, 0x7C, 0x7C, 0x41, 0x01, 0x00, 
};
const uint8_t Font8x8_char_140[] = {
  0x08, 0x08, // width=8, height=8
  0x02, 0x03, 0x45, 0x7D, 0x7D, 0x43, 0x02, 0x00, 
};
const uint8_t Font8x8_char_141[] = {
  0x08, 0x08, // width=8, height=8
  0x01, 0x01, 0x45, 0x7C, 0x7C, 0x40, 0x00, 0x00, 
};
const uint8_t Font8x8_char_142[] = {
  0x08, 0x08, // width=8, height=8
  0x79, 0x7D, 0x16, 0x12, 0x16, 0x7D, 0x79, 0x00, 
};
const uint8_t Font8x8_char_143[] = {
  0x08, 0x08, // width=8, height=8
  0x70, 0x78, 0x2B, 0x2B, 0x2B, 0x78, 0x70, 0x00, 
};
const uint8_t Font8x8_char_144[] = {
  0x08, 0x08, // width=8, height=8
  0x7C, 0x7C, 0x54, 0x54, 0x55, 0x45, 0x45, 0x00, 
};
const uint8_t Font8x8_char_145[] = {
  0x08, 0x08, // width=8, height=8
  0x28, 0x74, 0x54, 0x38, 0x7C, 0x54, 0x58, 0x00, 
};
const uint8_t Font8x8_char_146[] = {
  0x08, 0x08, // width=8, height=8
  0x7E, 0x7F, 0x09, 0x7F, 0x7F, 0x49, 0x49, 0x00, 
};
const uint8_t Font8x8_char_147[] = {
  0x08, 0x08, // width=8, height=8
  0x32, 0x7B, 0x49, 0x49, 0x49, 0x7B, 0x32, 0x00, 
};
const uint8_t Font8x8_char_148[] = {
  0x08, 0x08, // width=8, height=8
  0x32, 0x7A, 0x48, 0x48, 0x48, 0x7A, 0x32, 0x00, 
};
const uint8_t Font8x8_char_149[] = {
  0x08, 0x08, // width=8, height=8
  0x32, 0x7A, 0x4A, 0x48, 0x48, 0x78, 0x30, 0x00, 
};
const uint8_t Font8x8_char_150[] = {
  0x08, 0x08, // width=8, height=8
  0x3A, 0x7B, 0x41, 0x41, 0x21, 0x7B, 0x7A, 0x00, 
};
const uint8_t Font8x8_char_151[] = {
  0x08, 0x08, // width=8, height=8
  0x3A, 0x7A, 0x42, 0x40, 0x20, 0x78, 0x78, 0x00, 
};
const uint8_t Font8x8_char_152[] = {
  0x08, 0x08, // width=8, height=8
  0x1A, 0xBA, 0xA0, 0xA0, 0x90, 0xFA, 0x7A, 0x00, 
};
const uint8_t Font8x8_char_153[] = {
  0x08, 0x08, // width=8, height=8
  0x19, 0x3D, 0x66, 0x42, 0x66, 0x3D, 0x19, 0x00, 
};
const uint8_t Font8x8_char_154[] = {
  0x08, 0x08, // width=8, height=8
  0x3D, 0x7D, 0x40, 0x40, 0x40, 0x7D, 0x3D, 0x00, 
};
const uint8_t Font8x8_char_155[] = {
  0x08, 0x08, // width=8, height=8
  0x18, 0x3C, 0x24, 0x7E, 0x7E, 0x24, 0x24, 0x00, 
};
const uint8_t Font8x8_char_156[] = {
  0x08, 0x08, // width=8, height=8
  0x28, 0x7E, 0x7F, 0x29, 0x43, 0x72, 0x30, 0x00, 
};
const uint8_t Font8x8_char_157[] = {
  0x08, 0x08, // width=8, height=8
  0x01, 0x0B, 0x2E, 0x7C, 0x7C, 0x2E, 0x0B, 0x01, 
};
const uint8_t Font8x8_char_158[] = {
  0x08, 0x08, // width=8, height=8
  0x7F, 0x7F, 0x05, 0x15, 0x7D, 0x7F, 0x52, 0x00, 
};
const uint8_t Font8x8_char_159[] = {
  0x08, 0x08, // width=8, height=8
  0x40, 0xC8, 0x88, 0xFE, 0x7F, 0x0B, 0x0A, 0x00, 
};
const uint8_t Font8x8_char_160[] = {
  0x08, 0x08, // width=8, height=8
  0x20, 0x74, 0x54, 0x54, 0x7D, 0x79, 0x41, 0x00, 
};
const uint8_t Font8x8_char_161[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x44, 0x7D, 0x7D, 0x41, 0x00, 0x00, 
};
const uint8_t Font8x8_char_162[] = {
  0x08, 0x08, // width=8, height=8
  0x30, 0x78, 0x48, 0x48, 0x4A, 0x7A, 0x32, 0x00, 
};
const uint8_t Font8x8_char_163[] = {
  0x08, 0x08, // width=8, height=8
  0x38, 0x78, 0x40, 0x60, 0x3A, 0x7A, 0x42, 0x00, 
};
const uint8_t Font8x8_char_164[] = {
  0x08, 0x08, // width=8, height=8
  0x4A, 0x72, 0x7A, 0x0A, 0x0A, 0x7A, 0x70, 0x00, 
};
const uint8_t Font8x8_char_165[] = {
  0x08, 0x08, // width=8, height=8
  0x7D, 0x7D, 0x19, 0x11, 0x21, 0x7D, 0x7D, 0x00, 
};
const uint8_t Font8x8_char_166[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x12, 0x17, 0x15, 0x17, 0x16, 0x14, 0x00, 
};
const uint8_t Font8x8_char_167[] = {
  0x08, 0x08, // width=8, height=8
  0x02, 0x17, 0x15, 0x15, 0x15, 0x17, 0x02, 0x00, 
};
const uint8_t Font8x8_char_168[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x30, 0x78, 0x4D, 0x45, 0x60, 0x20, 0x00, 
};
const uint8_t Font8x8_char_169[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x38, 0x38, 0x08, 0x08, 0x08, 0x00, 0x00, 
};
const uint8_t Font8x8_char_170[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x08, 0x08, 0x08, 0x38, 0x38, 0x00, 0x00, 
};
const uint8_t Font8x8_char_171[] = {
  0x08, 0x08, // width=8, height=8
  0x07, 0x17, 0xB8, 0xBC, 0xD6, 0xF2, 0xA0, 0x00, 
};
const uint8_t Font8x8_char_172[] = {
  0x08, 0x08, // width=8, height=8
  0x07, 0x57, 0x78, 0x6C, 0xF6, 0xF2, 0x40, 0x00, 
};
const uint8_t Font8x8_char_173[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x30, 0x7D, 0x7D, 0x30, 0x00, 0x00, 
};
const uint8_t Font8x8_char_174[] = {
  0x08, 0x08, // width=8, height=8
  0x08, 0x1C, 0x36, 0x2A, 0x1C, 0x36, 0x22, 0x00, 
};
const uint8_t Font8x8_char_175[] = {
  0x08, 0x08, // width=8, height=8
  0x22, 0x36, 0x1C, 0x2A, 0x36, 0x1C, 0x08, 0x00, 
};
const uint8_t Font8x8_char_176[] = {
  0x08, 0x08, // width=8, height=8
  0xAA, 0x00, 0x55, 0x00, 0xAA, 0x00, 0x55, 0x00, 
};
const uint8_t Font8x8_char_177[] = {
  0x08, 0x08, // width=8, height=8
  0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 
};
const uint8_t Font8x8_char_178[] = {
  0x08, 0x08, // width=8, height=8
  0x55, 0xFF, 0xAA, 0xFF, 0x55, 0xFF, 0xAA, 0xFF, 
};
const uint8_t Font8x8_char_179[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_180[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_181[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x14, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_182[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 
};
const uint8_t Font8x8_char_183[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0xF0, 0xF0, 0x10, 0xF0, 0xF0, 0x00, 
};
const uint8_t Font8x8_char_184[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x14, 0xFC, 0xFC, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_185[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0xF7, 0xF7, 0x00, 0xFF, 0xFF, 0x00, 
};
const uint8_t Font8x8_char_186[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 
};
const uint8_t Font8x8_char_187[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0xF4, 0xF4, 0x04, 0xFC, 0xFC, 0x00, 
};
const uint8_t Font8x8_char_188[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x17, 0x17, 0x10, 0x1F, 0x1F, 0x00, 
};
const uint8_t Font8x8_char_189[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x1F, 0x1F, 0x10, 0x1F, 0x1F, 0x00, 
};
const uint8_t Font8x8_char_190[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x14, 0x1F, 0x1F, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_191[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x10, 0xF0, 0xF0, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_192[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x1F, 0x1F, 0x10, 0x10, 0x10, 
};
const uint8_t Font8x8_char_193[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x10, 
};
const uint8_t Font8x8_char_194[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x10, 0xF0, 0xF0, 0x10, 0x10, 0x10, 
};
const uint8_t Font8x8_char_195[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x10, 0x10, 0x10, 
};
const uint8_t Font8x8_char_196[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
};
const uint8_t Font8x8_char_197[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x10, 0xFF, 0xFF, 0x10, 0x10, 0x10, 
};
const uint8_t Font8x8_char_198[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x14, 0x14, 
};
const uint8_t Font8x8_char_199[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x10, 
};
const uint8_t Font8x8_char_200[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x1F, 0x1F, 0x10, 0x17, 0x17, 0x14, 
};
const uint8_t Font8x8_char_201[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0xFC, 0xFC, 0x04, 0xF4, 0xF4, 0x14, 
};
const uint8_t Font8x8_char_202[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x17, 0x17, 0x10, 0x17, 0x17, 0x14, 
};
const uint8_t Font8x8_char_203[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0xF4, 0xF4, 0x04, 0xF4, 0xF4, 0x14, 
};
const uint8_t Font8x8_char_204[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0xFF, 0xFF, 0x00, 0xF7, 0xF7, 0x14, 
};
const uint8_t Font8x8_char_205[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
};
const uint8_t Font8x8_char_206[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0xF7, 0xF7, 0x00, 0xF7, 0xF7, 0x14, 
};
const uint8_t Font8x8_char_207[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x14, 0x17, 0x17, 0x14, 0x14, 0x14, 
};
const uint8_t Font8x8_char_208[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x1F, 0x1F, 0x10, 0x1F, 0x1F, 0x10, 
};
const uint8_t Font8x8_char_209[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x14, 0xF4, 0xF4, 0x14, 0x14, 0x14, 
};
const uint8_t Font8x8_char_210[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0xF0, 0xF0, 0x10, 0xF0, 0xF0, 0x10, 
};
const uint8_t Font8x8_char_211[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x1F, 0x1F, 0x10, 0x1F, 0x1F, 0x10, 
};
const uint8_t Font8x8_char_212[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x1F, 0x1F, 0x14, 0x14, 0x14, 
};
const uint8_t Font8x8_char_213[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0xFC, 0xFC, 0x14, 0x14, 0x14, 
};
const uint8_t Font8x8_char_214[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0xF0, 0xF0, 0x10, 0xF0, 0xF0, 0x10, 
};
const uint8_t Font8x8_char_215[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0xFF, 0xFF, 0x10, 0xFF, 0xFF, 0x10, 
};
const uint8_t Font8x8_char_216[] = {
  0x08, 0x08, // width=8, height=8
  0x14, 0x14, 0x14, 0xFF, 0xFF, 0x14, 0x14, 0x14, 
};
const uint8_t Font8x8_char_217[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x10, 0x1F, 0x1F, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_218[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0xF0, 0xF0, 0x10, 0x10, 0x10, 
};
const uint8_t Font8x8_char_219[] = {
  0x08, 0x08, // width=8, height=8
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
const uint8_t Font8x8_char_220[] = {
  0x08, 0x08, // width=8, height=8
  0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 
};
const uint8_t Font8x8_char_221[] = {
  0x08, 0x08, // width=8, height=8
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_222[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
};
const uint8_t Font8x8_char_223[] = {
  0x08, 0x08, // width=8, height=8
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
};
const uint8_t Font8x8_char_224[] = {
  0x08, 0x08, // width=8, height=8
  0x38, 0x7C, 0x44, 0x38, 0x38, 0x6C, 0x44, 0x00, 
};
const uint8_t Font8x8_char_225[] = {
  0x08, 0x08, // width=8, height=8
  0x7C, 0x7E, 0x0A, 0x0A, 0x5E, 0x74, 0x20, 0x00, 
};
const uint8_t Font8x8_char_226[] = {
  0x08, 0x08, // width=8, height=8
  0x42, 0x7E, 0x7E, 0x02, 0x02, 0x02, 0x06, 0x00, 
};
const uint8_t Font8x8_char_227[] = {
  0x08, 0x08, // width=8, height=8
  0x02, 0x7E, 0x7E, 0x02, 0x7E, 0x7E, 0x02, 0x00, 
};
const uint8_t Font8x8_char_228[] = {
  0x08, 0x08, // width=8, height=8
  0x63, 0x77, 0x5D, 0x49, 0x41, 0x63, 0x63, 0x00, 
};
const uint8_t Font8x8_char_229[] = {
  0x08, 0x08, // width=8, height=8
  0x3C, 0x7E, 0x42, 0x66, 0x3E, 0x1A, 0x02, 0x00, 
};
const uint8_t Font8x8_char_230[] = {
  0x08, 0x08, // width=8, height=8
  0x40, 0x7E, 0x3E, 0x20, 0x20, 0x3E, 0x1E, 0x00, 
};
const uint8_t Font8x8_char_231[] = {
  0x08, 0x08, // width=8, height=8
  0x04, 0x06, 0x42, 0x7E, 0x7C, 0x06, 0x02, 0x00, 
};
const uint8_t Font8x8_char_232[] = {
  0x08, 0x08, // width=8, height=8
  0x49, 0x5D, 0x77, 0x63, 0x77, 0x5D, 0x49, 0x00, 
};
const uint8_t Font8x8_char_233[] = {
  0x08, 0x08, // width=8, height=8
  0x1C, 0x3E, 0x6B, 0x49, 0x6B, 0x3E, 0x1C, 0x00, 
};
const uint8_t Font8x8_char_234[] = {
  0x08, 0x08, // width=8, height=8
  0x4C, 0x7E, 0x73, 0x01, 0x73, 0x7E, 0x4C, 0x00, 
};
const uint8_t Font8x8_char_235[] = {
  0x08, 0x08, // width=8, height=8
  0x30, 0x7A, 0x4F, 0x45, 0x65, 0x39, 0x19, 0x00, 
};
const uint8_t Font8x8_char_236[] = {
  0x08, 0x08, // width=8, height=8
  0x18, 0x3C, 0x24, 0x3C, 0x3C, 0x24, 0x3C, 0x18, 
};
const uint8_t Font8x8_char_237[] = {
  0x08, 0x08, // width=8, height=8
  0x5C, 0x7E, 0x3A, 0x2E, 0x26, 0x3F, 0x1D, 0x00, 
};
const uint8_t Font8x8_char_238[] = {
  0x08, 0x08, // width=8, height=8
  0x1C, 0x3E, 0x6B, 0x49, 0x49, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_239[] = {
  0x08, 0x08, // width=8, height=8
  0x7E, 0x7F, 0x01, 0x01, 0x01, 0x7F, 0x7E, 0x00, 
};
const uint8_t Font8x8_char_240[] = {
  0x08, 0x08, // width=8, height=8
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x00, 
};
const uint8_t Font8x8_char_241[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x44, 0x44, 0x5F, 0x5F, 0x44, 0x44, 0x00, 
};
const uint8_t Font8x8_char_242[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x40, 0x51, 0x5B, 0x4E, 0x44, 0x40, 0x00, 
};
const uint8_t Font8x8_char_243[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x40, 0x44, 0x4E, 0x5B, 0x51, 0x40, 0x00, 
};
const uint8_t Font8x8_char_244[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0xFE, 0xFF, 0x03, 0x02, 0x00, 
};
const uint8_t Font8x8_char_245[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x20, 0x60, 0x7F, 0x3F, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_246[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x10, 0x10, 0x54, 0x54, 0x10, 0x10, 0x00, 
};
const uint8_t Font8x8_char_247[] = {
  0x08, 0x08, // width=8, height=8
  0x24, 0x36, 0x12, 0x36, 0x24, 0x36, 0x12, 0x00, 
};
const uint8_t Font8x8_char_248[] = {
  0x08, 0x08, // width=8, height=8
  0x06, 0x0F, 0x09, 0x09, 0x09, 0x0F, 0x06, 0x00, 
};
const uint8_t Font8x8_char_249[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_250[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_251[] = {
  0x08, 0x08, // width=8, height=8
  0x10, 0x10, 0x30, 0x7F, 0x7F, 0x01, 0x01, 0x01, 
};
const uint8_t Font8x8_char_252[] = {
  0x08, 0x08, // width=8, height=8
  0x01, 0x0F, 0x0E, 0x01, 0x0F, 0x0E, 0x00, 0x00, 
};
const uint8_t Font8x8_char_253[] = {
  0x08, 0x08, // width=8, height=8
  0x0A, 0x0B, 0x0D, 0x0F, 0x0A, 0x00, 0x00, 0x00, 
};
const uint8_t Font8x8_char_254[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00, 
};
const uint8_t Font8x8_char_255[] = {
  0x08, 0x08, // width=8, height=8
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

const uint8_t * Font8x8_table[256] = {
  Font8x8_char_0,
  Font8x8_char_1,
  Font8x8_char_2,
  Font8x8_char_3,
  Font8x8_char_4,
  Font8x8_char_5,
  Font8x8_char_6,
  Font8x8_char_7,
  Font8x8_char_8,
  Font8x8_char_9,
  Font8x8_char_10,
  Font8x8_char_11,
  Font8x8_char_12,
  Font8x8_char_13,
  Font8x8_char_14,
  Font8x8_char_15,
  Font8x8_char_16,
  Font8x8_char_17,
  Font8x8_char_18,
  Font8x8_char_19,
  Font8x8_char_20,
  Font8x8_char_21,
  Font8x8_char_22,
  Font8x8_char_23,
  Font8x8_char_24,
  Font8x8_char_25,
  Font8x8_char_26,
  Font8x8_char_27,
  Font8x8_char_28,
  Font8x8_char_29,
  Font8x8_char_30,
  Font8x8_char_31,
  Font8x8_char_32,
  Font8x8_char_33,
  Font8x8_char_34,
  Font8x8_char_35,
  Font8x8_char_36,
  Font8x8_char_37,
  Font8x8_char_38,
  Font8x8_char_39,
  Font8x8_char_40,
  Font8x8_char_41,
  Font8x8_char_42,
  Font8x8_char_43,
  Font8x8_char_44,
  Font8x8_char_45,
  Font8x8_char_46,
  Font8x8_char_47,
  Font8x8_char_48,
  Font8x8_char_49,
  Font8x8_char_50,
  Font8x8_char_51,
  Font8x8_char_52,
  Font8x8_char_53,
  Font8x8_char_54,
  Font8x8_char_55,
  Font8x8_char_56,
  Font8x8_char_57,
  Font8x8_char_58,
  Font8x8_char_59,
  Font8x8_char_60,
  Font8x8_char_61,
  Font8x8_char_62,
  Font8x8_char_63,
  Font8x8_char_64,
  Font8x8_char_65,
  Font8x8_char_66,
  Font8x8_char_67,
  Font8x8_char_68,
  Font8x8_char_69,
  Font8x8_char_70,
  Font8x8_char_71,
  Font8x8_char_72,
  Font8x8_char_73,
  Font8x8_char_74,
  Font8x8_char_75,
  Font8x8_char_76,
  Font8x8_char_77,
  Font8x8_char_78,
  Font8x8_char_79,
  Font8x8_char_80,
  Font8x8_char_81,
  Font8x8_char_82,
  Font8x8_char_83,
  Font8x8_char_84,
  Font8x8_char_85,
  Font8x8_char_86,
  Font8x8_char_87,
  Font8x8_char_88,
  Font8x8_char_89,
  Font8x8_char_90,
  Font8x8_char_91,
  Font8x8_char_92,
  Font8x8_char_93,
  Font8x8_char_94,
  Font8x8_char_95,
  Font8x8_char_96,
  Font8x8_char_97,
  Font8x8_char_98,
  Font8x8_char_99,
  Font8x8_char_100,
  Font8x8_char_101,
  Font8x8_char_102,
  Font8x8_char_103,
  Font8x8_char_104,
  Font8x8_char_105,
  Font8x8_char_106,
  Font8x8_char_107,
  Font8x8_char_108,
  Font8x8_char_109,
  Font8x8_char_110,
  Font8x8_char_111,
  Font8x8_char_112,
  Font8x8_char_113,
  Font8x8_char_114,
  Font8x8_char_115,
  Font8x8_char_116,
  Font8x8_char_117,
  Font8x8_char_118,
  Font8x8_char_119,
  Font8x8_char_120,
  Font8x8_char_121,
  Font8x8_char_122,
  Font8x8_char_123,
  Font8x8_char_124,
  Font8x8_char_125,
  Font8x8_char_126,
  Font8x8_char_127,
  Font8x8_char_128,
  Font8x8_char_129,
  Font8x8_char_130,
  Font8x8_char_131,
  Font8x8_char_132,
  Font8x8_char_133,
  Font8x8_char_134,
  Font8x8_char_135,
  Font8x8_char_136,
  Font8x8_char_137,
  Font8x8_char_138,
  Font8x8_char_139,
  Font8x8_char_140,
  Font8x8_char_141,
  Font8x8_char_142,
  Font8x8_char_143,
  Font8x8_char_144,
  Font8x8_char_145,
  Font8x8_char_146,
  Font8x8_char_147,
  Font8x8_char_148,
  Font8x8_char_149,
  Font8x8_char_150,
  Font8x8_char_151,
  Font8x8_char_152,
  Font8x8_char_153,
  Font8x8_char_154,
  Font8x8_char_155,
  Font8x8_char_156,
  Font8x8_char_157,
  Font8x8_char_158,
  Font8x8_char_159,
  Font8x8_char_160,
  Font8x8_char_161,
  Font8x8_char_162,
  Font8x8_char_163,
  Font8x8_char_164,
  Font8x8_char_165,
  Font8x8_char_166,
  Font8x8_char_167,
  Font8x8_char_168,
  Font8x8_char_169,
  Font8x8_char_170,
  Font8x8_char_171,
  Font8x8_char_172,
  Font8x8_char_173,
  Font8x8_char_174,
  Font8x8_char_175,
  Font8x8_char_176,
  Font8x8_char_177,
  Font8x8_char_178,
  Font8x8_char_179,
  Font8x8_char_180,
  Font8x8_char_181,
  Font8x8_char_182,
  Font8x8_char_183,
  Font8x8_char_184,
  Font8x8_char_185,
  Font8x8_char_186,
  Font8x8_char_187,
  Font8x8_char_188,
  Font8x8_char_189,
  Font8x8_char_190,
  Font8x8_char_191,
  Font8x8_char_192,
  Font8x8_char_193,
  Font8x8_char_194,
  Font8x8_char_195,
  Font8x8_char_196,
  Font8x8_char_197,
  Font8x8_char_198,
  Font8x8_char_199,
  Font8x8_char_200,
  Font8x8_char_201,
  Font8x8_char_202,
  Font8x8_char_203,
  Font8x8_char_204,
  Font8x8_char_205,
  Font8x8_char_206,
  Font8x8_char_207,
  Font8x8_char_208,
  Font8x8_char_209,
  Font8x8_char_210,
  Font8x8_char_211,
  Font8x8_char_212,
  Font8x8_char_213,
  Font8x8_char_214,
  Font8x8_char_215,
  Font8x8_char_216,
  Font8x8_char_217,
  Font8x8_char_218,
  Font8x8_char_219,
  Font8x8_char_220,
  Font8x8_char_221,
  Font8x8_char_222,
  Font8x8_char_223,
  Font8x8_char_224,
  Font8x8_char_225,
  Font8x8_char_226,
  Font8x8_char_227,
  Font8x8_char_228,
  Font8x8_char_229,
  Font8x8_char_230,
  Font8x8_char_231,
  Font8x8_char_232,
  Font8x8_char_233,
  Font8x8_char_234,
  Font8x8_char_235,
  Font8x8_char_236,
  Font8x8_char_237,
  Font8x8_char_238,
  Font8x8_char_239,
  Font8x8_char_240,
  Font8x8_char_241,
  Font8x8_char_242,
  Font8x8_char_243,
  Font8x8_char_244,
  Font8x8_char_245,
  Font8x8_char_246,
  Font8x8_char_247,
  Font8x8_char_248,
  Font8x8_char_249,
  Font8x8_char_250,
  Font8x8_char_251,
  Font8x8_char_252,
  Font8x8_char_253,
  Font8x8_char_254,
  Font8x8_char_255,
};





