/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
*
*******************************************************************************/
/*******************************************************************************
* Copyright (C) 2013 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* File Name     : intc_iobitmask.h
* Device(s)     : RZ/A1H RSK2+RZA1H
* H/W Platform  : RSK2+RZA1H CPU Board
* Description   : INTC register define header
*******************************************************************************/
/*******************************************************************************
* History       : DD.MM.YYYY Version Description
*               : 18.06.2013 1.00
*******************************************************************************/

#ifndef INTC_IOBITMASK_H
#define INTC_IOBITMASK_H

/* ==== Mask values for IO registers ==== */
#define INTC_ICDDCR_Enable                      (0x00000001uL)

#define INTC_ICDICTR_ITLinesNumber              (0x0000001FuL)
#define INTC_ICDICTR_CPUNumber                  (0x000000E0uL)
#define INTC_ICDICTR_SecurityExtn               (0x00000400uL)
#define INTC_ICDICTR_LSPI                       (0x0000F800uL)

#define INTC_ICDIIDR_Implementer                (0x00000FFFuL)
#define INTC_ICDIIDR_Revision                   (0x0000F000uL)
#define INTC_ICDIIDR_Variant                    (0x000F0000uL)
#define INTC_ICDIIDR_ProductID                  (0xFF000000uL)

#define INTC_ICDISR0_SW0                        (0x00000001uL)
#define INTC_ICDISR0_SW1                        (0x00000002uL)
#define INTC_ICDISR0_SW2                        (0x00000004uL)
#define INTC_ICDISR0_SW3                        (0x00000008uL)
#define INTC_ICDISR0_SW4                        (0x00000010uL)
#define INTC_ICDISR0_SW5                        (0x00000020uL)
#define INTC_ICDISR0_SW6                        (0x00000040uL)
#define INTC_ICDISR0_SW7                        (0x00000080uL)
#define INTC_ICDISR0_SW8                        (0x00000100uL)
#define INTC_ICDISR0_SW9                        (0x00000200uL)
#define INTC_ICDISR0_SW10                       (0x00000400uL)
#define INTC_ICDISR0_SW11                       (0x00000800uL)
#define INTC_ICDISR0_SW12                       (0x00001000uL)
#define INTC_ICDISR0_SW13                       (0x00002000uL)
#define INTC_ICDISR0_SW14                       (0x00004000uL)
#define INTC_ICDISR0_SW15                       (0x00008000uL)
#define INTC_ICDISR0_PMUIRQ0                    (0x00010000uL)
#define INTC_ICDISR0_COMMRX0                    (0x00020000uL)
#define INTC_ICDISR0_COMMTX0                    (0x00040000uL)
#define INTC_ICDISR0_CTIIRQ0                    (0x00080000uL)

#define INTC_ICDISR1_IRQ0                       (0x00000001uL)
#define INTC_ICDISR1_IRQ1                       (0x00000002uL)
#define INTC_ICDISR1_IRQ2                       (0x00000004uL)
#define INTC_ICDISR1_IRQ3                       (0x00000008uL)
#define INTC_ICDISR1_IRQ4                       (0x00000010uL)
#define INTC_ICDISR1_IRQ5                       (0x00000020uL)
#define INTC_ICDISR1_IRQ6                       (0x00000040uL)
#define INTC_ICDISR1_IRQ7                       (0x00000080uL)
#define INTC_ICDISR1_PL310ERR                   (0x00000100uL)
#define INTC_ICDISR1_DMAINT0                    (0x00000200uL)
#define INTC_ICDISR1_DMAINT1                    (0x00000400uL)
#define INTC_ICDISR1_DMAINT2                    (0x00000800uL)
#define INTC_ICDISR1_DMAINT3                    (0x00001000uL)
#define INTC_ICDISR1_DMAINT4                    (0x00002000uL)
#define INTC_ICDISR1_DMAINT5                    (0x00004000uL)
#define INTC_ICDISR1_DMAINT6                    (0x00008000uL)
#define INTC_ICDISR1_DMAINT7                    (0x00010000uL)
#define INTC_ICDISR1_DMAINT8                    (0x00020000uL)
#define INTC_ICDISR1_DMAINT9                    (0x00040000uL)
#define INTC_ICDISR1_DMAINT10                   (0x00080000uL)
#define INTC_ICDISR1_DMAINT11                   (0x00100000uL)
#define INTC_ICDISR1_DMAINT12                   (0x00200000uL)
#define INTC_ICDISR1_DMAINT13                   (0x00400000uL)
#define INTC_ICDISR1_DMAINT14                   (0x00800000uL)
#define INTC_ICDISR1_DMAINT15                   (0x01000000uL)
#define INTC_ICDISR1_DMAERR                     (0x02000000uL)

#define INTC_ICDISR2_USBI0                      (0x00000200uL)
#define INTC_ICDISR2_USBI1                      (0x00000400uL)
#define INTC_ICDISR2_S0_VI_VSYNC0               (0x00000800uL)
#define INTC_ICDISR2_S0_LO_VSYNC0               (0x00001000uL)
#define INTC_ICDISR2_S0_VSYNCERR0               (0x00002000uL)
#define INTC_ICDISR2_GR3_VLINE0                 (0x00004000uL)
#define INTC_ICDISR2_S0_VFIELD0                 (0x00008000uL)
#define INTC_ICDISR2_IV1_VBUFERR0               (0x00010000uL)
#define INTC_ICDISR2_IV3_VBUFERR0               (0x00020000uL)
#define INTC_ICDISR2_IV5_VBUFERR0               (0x00040000uL)
#define INTC_ICDISR2_IV6_VBUFERR0               (0x00080000uL)
#define INTC_ICDISR2_S0_WLINE0                  (0x00100000uL)
#define INTC_ICDISR2_S1_VI_VSYNC0               (0x00200000uL)
#define INTC_ICDISR2_S1_LO_VSYNC0               (0x00400000uL)
#define INTC_ICDISR2_S1_VSYNCERR0               (0x00800000uL)
#define INTC_ICDISR2_S1_VFIELD0                 (0x01000000uL)
#define INTC_ICDISR2_IV2_VBUFERR0               (0x02000000uL)
#define INTC_ICDISR2_IV4_VBUFERR0               (0x04000000uL)
#define INTC_ICDISR2_S1_WLINE0                  (0x08000000uL)
#define INTC_ICDISR2_OIR_VI_VSYNC0              (0x10000000uL)
#define INTC_ICDISR2_OIR_LO_VSYNC0              (0x20000000uL)
#define INTC_ICDISR2_OIR_VSYNCERR0              (0x40000000uL)
#define INTC_ICDISR2_OIR_VFIELD0                (0x80000000uL)

#define INTC_ICDISR3_IV7_VBUFERR0               (0x00000001uL)
#define INTC_ICDISR3_IV8_VBUFERR0               (0x00000002uL)
#define INTC_ICDISR3_OIR_WLINE0                 (0x00000004uL)
#define INTC_ICDISR3_S0_VI_VSYNC1               (0x00000008uL)
#define INTC_ICDISR3_S0_LO_VSYNC1               (0x00000010uL)
#define INTC_ICDISR3_S0_VSYNCERR1               (0x00000020uL)
#define INTC_ICDISR3_GR3_VLINE1                 (0x00000040uL)
#define INTC_ICDISR3_S0_VFIELD1                 (0x00000080uL)
#define INTC_ICDISR3_IV1_VBUFERR1               (0x00000100uL)
#define INTC_ICDISR3_IV3_VBUFERR1               (0x00000200uL)
#define INTC_ICDISR3_IV5_VBUFERR1               (0x00000400uL)
#define INTC_ICDISR3_IV6_VBUFERR1               (0x00000800uL)
#define INTC_ICDISR3_S0_WLINE1                  (0x00001000uL)
#define INTC_ICDISR3_S1_VI_VSYNC1               (0x00002000uL)
#define INTC_ICDISR3_S1_LO_VSYNC1               (0x00004000uL)
#define INTC_ICDISR3_S1_VSYNCERR1               (0x00008000uL)
#define INTC_ICDISR3_S1_VFIELD1                 (0x00010000uL)
#define INTC_ICDISR3_IV2_VBUFERR1               (0x00020000uL)
#define INTC_ICDISR3_IV4_VBUFERR1               (0x00040000uL)
#define INTC_ICDISR3_S1_WLINE1                  (0x00080000uL)
#define INTC_ICDISR3_OIR_VI_VSYNC1              (0x00100000uL)
#define INTC_ICDISR3_OIR_LO_VSYNC1              (0x00200000uL)
#define INTC_ICDISR3_OIR_VLINE1                 (0x00400000uL)
#define INTC_ICDISR3_OIR_VFIELD1                (0x00800000uL)
#define INTC_ICDISR3_IV7_VBUFERR1               (0x01000000uL)
#define INTC_ICDISR3_IV8_VBUFERR1               (0x02000000uL)
#define INTC_ICDISR3_OIR_WLINE1                 (0x04000000uL)
#define INTC_ICDISR3_IMRDI                      (0x08000000uL)
#define INTC_ICDISR3_IMR2I0                     (0x10000000uL)
#define INTC_ICDISR3_IMR2I1                     (0x20000000uL)
#define INTC_ICDISR3_JEDI                       (0x40000000uL)
#define INTC_ICDISR3_JDTI                       (0x80000000uL)

#define INTC_ICDISR4_CMP0                       (0x00000001uL)
#define INTC_ICDISR4_CMP1                       (0x00000002uL)
#define INTC_ICDISR4_INT0                       (0x00000004uL)
#define INTC_ICDISR4_INT1                       (0x00000008uL)
#define INTC_ICDISR4_INT2                       (0x00000010uL)
#define INTC_ICDISR4_INT3                       (0x00000020uL)
#define INTC_ICDISR4_OSTM0TINT                  (0x00000040uL)
#define INTC_ICDISR4_OSTM1TINT                  (0x00000080uL)
#define INTC_ICDISR4_CMI                        (0x00000100uL)
#define INTC_ICDISR4_WTOUT                      (0x00000200uL)
#define INTC_ICDISR4_ITI                        (0x00000400uL)
#define INTC_ICDISR4_TGI0A                      (0x00000800uL)
#define INTC_ICDISR4_TGI0B                      (0x00001000uL)
#define INTC_ICDISR4_TGI0C                      (0x00002000uL)
#define INTC_ICDISR4_TGI0D                      (0x00004000uL)
#define INTC_ICDISR4_TGI0V                      (0x00008000uL)
#define INTC_ICDISR4_TGI0E                      (0x00010000uL)
#define INTC_ICDISR4_TGI0F                      (0x00020000uL)
#define INTC_ICDISR4_TGI1A                      (0x00040000uL)
#define INTC_ICDISR4_TGI1B                      (0x00080000uL)
#define INTC_ICDISR4_TGI1V                      (0x00100000uL)
#define INTC_ICDISR4_TGI1U                      (0x00200000uL)
#define INTC_ICDISR4_TGI2A                      (0x00400000uL)
#define INTC_ICDISR4_TGI2B                      (0x00800000uL)
#define INTC_ICDISR4_TGI2V                      (0x01000000uL)
#define INTC_ICDISR4_TGI2U                      (0x02000000uL)
#define INTC_ICDISR4_TGI3A                      (0x04000000uL)
#define INTC_ICDISR4_TGI3B                      (0x08000000uL)
#define INTC_ICDISR4_TGI3C                      (0x10000000uL)
#define INTC_ICDISR4_TGI3D                      (0x20000000uL)
#define INTC_ICDISR4_TGI3V                      (0x40000000uL)
#define INTC_ICDISR4_TGI4A                      (0x80000000uL)

#define INTC_ICDISR5_TGI4B                      (0x00000001uL)
#define INTC_ICDISR5_TGI4C                      (0x00000002uL)
#define INTC_ICDISR5_TGI4D                      (0x00000004uL)
#define INTC_ICDISR5_TGI4V                      (0x00000008uL)
#define INTC_ICDISR5_CMI1                       (0x00000010uL)
#define INTC_ICDISR5_CMI2                       (0x00000020uL)
#define INTC_ICDISR5_SGDEI0                     (0x00000040uL)
#define INTC_ICDISR5_SGDEI1                     (0x00000080uL)
#define INTC_ICDISR5_SGDEI2                     (0x00000100uL)
#define INTC_ICDISR5_SGDEI3                     (0x00000200uL)
#define INTC_ICDISR5_ADI                        (0x00000400uL)
#define INTC_ICDISR5_LMTI                       (0x00000800uL)
#define INTC_ICDISR5_SSII0                      (0x00001000uL)
#define INTC_ICDISR5_SSIRXI0                    (0x00002000uL)
#define INTC_ICDISR5_SSITXI0                    (0x00004000uL)
#define INTC_ICDISR5_SSII1                      (0x00008000uL)
#define INTC_ICDISR5_SSIRXI1                    (0x00010000uL)
#define INTC_ICDISR5_SSITXI1                    (0x00020000uL)
#define INTC_ICDISR5_SSII2                      (0x00040000uL)
#define INTC_ICDISR5_SSIRTI2                    (0x00080000uL)
#define INTC_ICDISR5_SSII3                      (0x00100000uL)
#define INTC_ICDISR5_SSIRXI3                    (0x00200000uL)
#define INTC_ICDISR5_SSITXI3                    (0x00400000uL)
#define INTC_ICDISR5_SSII4                      (0x00800000uL)
#define INTC_ICDISR5_SSIRTI4                    (0x01000000uL)
#define INTC_ICDISR5_SSII5                      (0x02000000uL)
#define INTC_ICDISR5_SSIRXI5                    (0x04000000uL)
#define INTC_ICDISR5_SSITXI5                    (0x08000000uL)
#define INTC_ICDISR5_SPDIFI                     (0x10000000uL)
#define INTC_ICDISR5_INTIICTEI0                 (0x20000000uL)
#define INTC_ICDISR5_INTIICRI0                  (0x40000000uL)
#define INTC_ICDISR5_INTIICTI0                  (0x80000000uL)

#define INTC_ICDISR6_INTIICSPI0                 (0x00000001uL)
#define INTC_ICDISR6_INTIICSTI0                 (0x00000002uL)
#define INTC_ICDISR6_INTIICNAKI0                (0x00000004uL)
#define INTC_ICDISR6_INTIICALI0                 (0x00000008uL)
#define INTC_ICDISR6_INTIICTMOI0                (0x00000010uL)
#define INTC_ICDISR6_INTIICTEI1                 (0x00000020uL)
#define INTC_ICDISR6_INTIICRI1                  (0x00000040uL)
#define INTC_ICDISR6_INTIICTI1                  (0x00000080uL)
#define INTC_ICDISR6_INTIICSPI1                 (0x00000100uL)
#define INTC_ICDISR6_INTIICSTI1                 (0x00000200uL)
#define INTC_ICDISR6_INTIICNAKI1                (0x00000400uL)
#define INTC_ICDISR6_INTIICALI1                 (0x00000800uL)
#define INTC_ICDISR6_INTIICTMOI1                (0x00001000uL)
#define INTC_ICDISR6_INTIICTEI2                 (0x00002000uL)
#define INTC_ICDISR6_INTIICRI2                  (0x00004000uL)
#define INTC_ICDISR6_INTIICTI2                  (0x00008000uL)
#define INTC_ICDISR6_INTIICSPI2                 (0x00010000uL)
#define INTC_ICDISR6_INTIICSTI2                 (0x00020000uL)
#define INTC_ICDISR6_INTIICNAKI2                (0x00040000uL)
#define INTC_ICDISR6_INTIICALI2                 (0x00080000uL)
#define INTC_ICDISR6_INTIICTMOI2                (0x00100000uL)
#define INTC_ICDISR6_INTIICTEI3                 (0x00200000uL)
#define INTC_ICDISR6_INTIICRI3                  (0x00400000uL)
#define INTC_ICDISR6_INTIICTI3                  (0x00800000uL)
#define INTC_ICDISR6_INTIICSPI3                 (0x01000000uL)
#define INTC_ICDISR6_INTIICSTI3                 (0x02000000uL)
#define INTC_ICDISR6_INTIICNAKI3                (0x04000000uL)
#define INTC_ICDISR6_INTIICALI3                 (0x08000000uL)
#define INTC_ICDISR6_INTIICTMOI3                (0x10000000uL)
#define INTC_ICDISR6_BRI0                       (0x20000000uL)
#define INTC_ICDISR6_ERI0                       (0x40000000uL)
#define INTC_ICDISR6_RXI0                       (0x80000000uL)

#define INTC_ICDISR7_TXI0                       (0x00000001uL)
#define INTC_ICDISR7_BRI1                       (0x00000002uL)
#define INTC_ICDISR7_ERI1                       (0x00000004uL)
#define INTC_ICDISR7_RXI1                       (0x00000008uL)
#define INTC_ICDISR7_TXI1                       (0x00000010uL)
#define INTC_ICDISR7_BRI2                       (0x00000020uL)
#define INTC_ICDISR7_ERI2                       (0x00000040uL)
#define INTC_ICDISR7_RXI2                       (0x00000080uL)
#define INTC_ICDISR7_TXI2                       (0x00000100uL)
#define INTC_ICDISR7_BRI3                       (0x00000200uL)
#define INTC_ICDISR7_ERI3                       (0x00000400uL)
#define INTC_ICDISR7_RXI3                       (0x00000800uL)
#define INTC_ICDISR7_TXI3                       (0x00001000uL)
#define INTC_ICDISR7_BRI4                       (0x00002000uL)
#define INTC_ICDISR7_ERI4                       (0x00004000uL)
#define INTC_ICDISR7_RXI4                       (0x00008000uL)
#define INTC_ICDISR7_TXI4                       (0x00010000uL)
#define INTC_ICDISR7_BRI5                       (0x00020000uL)
#define INTC_ICDISR7_ERI5                       (0x00040000uL)
#define INTC_ICDISR7_RXI5                       (0x00080000uL)
#define INTC_ICDISR7_TXI5                       (0x00100000uL)
#define INTC_ICDISR7_BRI6                       (0x00200000uL)
#define INTC_ICDISR7_ERI6                       (0x00400000uL)
#define INTC_ICDISR7_RXI6                       (0x00800000uL)
#define INTC_ICDISR7_TXI6                       (0x01000000uL)
#define INTC_ICDISR7_BRI7                       (0x02000000uL)
#define INTC_ICDISR7_ERI7                       (0x04000000uL)
#define INTC_ICDISR7_RXI7                       (0x08000000uL)
#define INTC_ICDISR7_TXI7                       (0x10000000uL)
#define INTC_ICDISR7_INTRCANGERR                (0x20000000uL)
#define INTC_ICDISR7_INTRCANGRECC               (0x40000000uL)
#define INTC_ICDISR7_INTRCAN0REC                (0x80000000uL)

#define INTC_ICDISR8_INTRCAN0ERR                (0x00000001uL)
#define INTC_ICDISR8_INTRCAN0TRX                (0x00000002uL)
#define INTC_ICDISR8_INTRCAN1REC                (0x00000004uL)
#define INTC_ICDISR8_INTRCAN1ERR                (0x00000008uL)
#define INTC_ICDISR8_INTRCAN1TRX                (0x00000010uL)
#define INTC_ICDISR8_INTRCAN2REC                (0x00000020uL)
#define INTC_ICDISR8_INTRCAN2ERR                (0x00000040uL)
#define INTC_ICDISR8_INTRCAN2TRX                (0x00000080uL)
#define INTC_ICDISR8_INTRCAN3REC                (0x00000100uL)
#define INTC_ICDISR8_INTRCAN3ERR                (0x00000200uL)
#define INTC_ICDISR8_INTRCAN3TRX                (0x00000400uL)
#define INTC_ICDISR8_INTRCAN4REC                (0x00000800uL)
#define INTC_ICDISR8_INTRCAN4ERR                (0x00001000uL)
#define INTC_ICDISR8_INTRCAN4TRX                (0x00002000uL)
#define INTC_ICDISR8_SPEI0                      (0x00004000uL)
#define INTC_ICDISR8_SPRI0                      (0x00008000uL)
#define INTC_ICDISR8_SPTI0                      (0x00010000uL)
#define INTC_ICDISR8_SPEI1                      (0x00020000uL)
#define INTC_ICDISR8_SPRI1                      (0x00040000uL)
#define INTC_ICDISR8_SPTI1                      (0x00080000uL)
#define INTC_ICDISR8_SPEI2                      (0x00100000uL)
#define INTC_ICDISR8_SPRI2                      (0x00200000uL)
#define INTC_ICDISR8_SPTI2                      (0x00400000uL)
#define INTC_ICDISR8_SPEI3                      (0x00800000uL)
#define INTC_ICDISR8_SPRI3                      (0x01000000uL)
#define INTC_ICDISR8_SPTI3                      (0x02000000uL)
#define INTC_ICDISR8_SPEI4                      (0x04000000uL)
#define INTC_ICDISR8_SPRI4                      (0x08000000uL)
#define INTC_ICDISR8_SPTI4                      (0x10000000uL)
#define INTC_ICDISR8_IEBBTD                     (0x20000000uL)
#define INTC_ICDISR8_IEBBTERR                   (0x40000000uL)
#define INTC_ICDISR8_IEBBTSTA                   (0x80000000uL)

#define INTC_ICDISR9_IEBBTV                     (0x00000001uL)
#define INTC_ICDISR9_ISY                        (0x00000002uL)
#define INTC_ICDISR9_IERR                       (0x00000004uL)
#define INTC_ICDISR9_ITARG                      (0x00000008uL)
#define INTC_ICDISR9_ISEC                       (0x00000010uL)
#define INTC_ICDISR9_IBUF                       (0x00000020uL)
#define INTC_ICDISR9_IREADY                     (0x00000040uL)
#define INTC_ICDISR9_FLSTE                      (0x00000080uL)
#define INTC_ICDISR9_FLTENDI                    (0x00000100uL)
#define INTC_ICDISR9_FLTREQ0I                   (0x00000200uL)
#define INTC_ICDISR9_FLTREQ1I                   (0x00000400uL)
#define INTC_ICDISR9_MMC0                       (0x00000800uL)
#define INTC_ICDISR9_MMC1                       (0x00001000uL)
#define INTC_ICDISR9_MMC2                       (0x00002000uL)
#define INTC_ICDISR9_SDHI0_3                    (0x00004000uL)
#define INTC_ICDISR9_SDHI0_0                    (0x00008000uL)
#define INTC_ICDISR9_SDHI0_1                    (0x00010000uL)
#define INTC_ICDISR9_SDHI1_3                    (0x00020000uL)
#define INTC_ICDISR9_SDHI1_0                    (0x00040000uL)
#define INTC_ICDISR9_SDHI1_1                    (0x00080000uL)
#define INTC_ICDISR9_ARM                        (0x00100000uL)
#define INTC_ICDISR9_PRD                        (0x00200000uL)
#define INTC_ICDISR9_CUP                        (0x00400000uL)
#define INTC_ICDISR9_SCUAI0                     (0x00800000uL)
#define INTC_ICDISR9_SCUAI1                     (0x01000000uL)
#define INTC_ICDISR9_SCUFDI0                    (0x02000000uL)
#define INTC_ICDISR9_SCUFDI1                    (0x04000000uL)
#define INTC_ICDISR9_SCUFDI2                    (0x08000000uL)
#define INTC_ICDISR9_SCUFDI3                    (0x10000000uL)
#define INTC_ICDISR9_SCUFUI0                    (0x20000000uL)
#define INTC_ICDISR9_SCUFUI1                    (0x40000000uL)
#define INTC_ICDISR9_SCUFUI2                    (0x80000000uL)

#define INTC_ICDISR10_SCUFUI3                   (0x00000001uL)
#define INTC_ICDISR10_SCUDVI0                   (0x00000002uL)
#define INTC_ICDISR10_SCUDVI1                   (0x00000004uL)
#define INTC_ICDISR10_SCUDVI2                   (0x00000008uL)
#define INTC_ICDISR10_SCUDVI3                   (0x00000010uL)
#define INTC_ICDISR10_MLB_CINT                  (0x00000020uL)
#define INTC_ICDISR10_MLB_SINT                  (0x00000040uL)
#define INTC_ICDISR10_DRC0                      (0x00000080uL)
#define INTC_ICDISR10_DRC1                      (0x00000100uL)
#define INTC_ICDISR10_LINI0_INT_T               (0x00000800uL)
#define INTC_ICDISR10_LINI0_INT_R               (0x00001000uL)
#define INTC_ICDISR10_LINI0_INT_S               (0x00002000uL)
#define INTC_ICDISR10_LINI0_INT_M               (0x00004000uL)
#define INTC_ICDISR10_LINI1_INT_T               (0x00008000uL)
#define INTC_ICDISR10_LINI1_INT_R               (0x00010000uL)
#define INTC_ICDISR10_LINI1_INT_S               (0x00020000uL)
#define INTC_ICDISR10_LINI1_INT_M               (0x00040000uL)
#define INTC_ICDISR10_ERI0                      (0x08000000uL)
#define INTC_ICDISR10_RXI0                      (0x10000000uL)
#define INTC_ICDISR10_TXI0                      (0x20000000uL)
#define INTC_ICDISR10_TEI0                      (0x40000000uL)
#define INTC_ICDISR10_ERI1                      (0x80000000uL)

#define INTC_ICDISR11_RXI1                      (0x00000001uL)
#define INTC_ICDISR11_TXI1                      (0x00000002uL)
#define INTC_ICDISR11_TEI1                      (0x00000004uL)
#define INTC_ICDISR11_AVBI_DATA                 (0x00000008uL)
#define INTC_ICDISR11_AVBI_ERROR                (0x00000010uL)
#define INTC_ICDISR11_AVBI_MANAGE               (0x00000020uL)
#define INTC_ICDISR11_AVBI_MAC                  (0x00000040uL)
#define INTC_ICDISR11_ETHERI                    (0x00000080uL)
#define INTC_ICDISR11_CEUI                      (0x00001000uL)
#define INTC_ICDISR11_H2XMLB_ERRINT             (0x20000000uL)
#define INTC_ICDISR11_H2XIC1_ERRINT             (0x40000000uL)
#define INTC_ICDISR11_X2HPERI1_ERRINT           (0x80000000uL)

#define INTC_ICDISR12_X2HPERI2_ERRINT           (0x00000001uL)
#define INTC_ICDISR12_X2HPERI34_ERRINT          (0x00000002uL)
#define INTC_ICDISR12_X2HPERI5_ERRINT           (0x00000004uL)
#define INTC_ICDISR12_X2HPERI67_ERRINT          (0x00000008uL)
#define INTC_ICDISR12_X2HDBGR_ERRINT            (0x00000010uL)
#define INTC_ICDISR12_X2HBSC_ERRINT             (0x00000020uL)
#define INTC_ICDISR12_X2HSPI1_ERRINT            (0x00000040uL)
#define INTC_ICDISR12_X2HSPI2_ERRINT            (0x00000080uL)
#define INTC_ICDISR12_PRRI                      (0x00000100uL)
#define INTC_ICDISR12_IFEI0                     (0x00000200uL)
#define INTC_ICDISR12_OFFI0                     (0x00000400uL)
#define INTC_ICDISR12_PFVEI0                    (0x00000800uL)
#define INTC_ICDISR12_IFEI1                     (0x00001000uL)
#define INTC_ICDISR12_OFFI1                     (0x00002000uL)
#define INTC_ICDISR12_PFVEI1                    (0x00004000uL)

#define INTC_ICDISR13_TINT0                     (0x00000001uL)
#define INTC_ICDISR13_TINT1                     (0x00000002uL)
#define INTC_ICDISR13_TINT2                     (0x00000004uL)
#define INTC_ICDISR13_TINT3                     (0x00000008uL)
#define INTC_ICDISR13_TINT4                     (0x00000010uL)
#define INTC_ICDISR13_TINT5                     (0x00000020uL)
#define INTC_ICDISR13_TINT6                     (0x00000040uL)
#define INTC_ICDISR13_TINT7                     (0x00000080uL)
#define INTC_ICDISR13_TINT8                     (0x00000100uL)
#define INTC_ICDISR13_TINT9                     (0x00000200uL)
#define INTC_ICDISR13_TINT10                    (0x00000400uL)
#define INTC_ICDISR13_TINT11                    (0x00000800uL)
#define INTC_ICDISR13_TINT12                    (0x00001000uL)
#define INTC_ICDISR13_TINT13                    (0x00002000uL)
#define INTC_ICDISR13_TINT14                    (0x00004000uL)
#define INTC_ICDISR13_TINT15                    (0x00008000uL)
#define INTC_ICDISR13_TINT16                    (0x00010000uL)
#define INTC_ICDISR13_TINT17                    (0x00020000uL)
#define INTC_ICDISR13_TINT18                    (0x00040000uL)
#define INTC_ICDISR13_TINT19                    (0x00080000uL)
#define INTC_ICDISR13_TINT20                    (0x00100000uL)
#define INTC_ICDISR13_TINT21                    (0x00200000uL)
#define INTC_ICDISR13_TINT22                    (0x00400000uL)
#define INTC_ICDISR13_TINT23                    (0x00800000uL)
#define INTC_ICDISR13_TINT24                    (0x01000000uL)
#define INTC_ICDISR13_TINT25                    (0x02000000uL)
#define INTC_ICDISR13_TINT26                    (0x04000000uL)
#define INTC_ICDISR13_TINT27                    (0x08000000uL)
#define INTC_ICDISR13_TINT28                    (0x10000000uL)
#define INTC_ICDISR13_TINT29                    (0x20000000uL)
#define INTC_ICDISR13_TINT30                    (0x40000000uL)
#define INTC_ICDISR13_TINT31                    (0x80000000uL)

#define INTC_ICDISR14_TINT32                    (0x00000001uL)
#define INTC_ICDISR14_TINT33                    (0x00000002uL)
#define INTC_ICDISR14_TINT34                    (0x00000004uL)
#define INTC_ICDISR14_TINT35                    (0x00000008uL)
#define INTC_ICDISR14_TINT36                    (0x00000010uL)
#define INTC_ICDISR14_TINT37                    (0x00000020uL)
#define INTC_ICDISR14_TINT38                    (0x00000040uL)
#define INTC_ICDISR14_TINT39                    (0x00000080uL)
#define INTC_ICDISR14_TINT40                    (0x00000100uL)
#define INTC_ICDISR14_TINT41                    (0x00000200uL)
#define INTC_ICDISR14_TINT42                    (0x00000400uL)
#define INTC_ICDISR14_TINT43                    (0x00000800uL)
#define INTC_ICDISR14_TINT44                    (0x00001000uL)
#define INTC_ICDISR14_TINT45                    (0x00002000uL)
#define INTC_ICDISR14_TINT46                    (0x00004000uL)
#define INTC_ICDISR14_TINT47                    (0x00008000uL)
#define INTC_ICDISR14_TINT48                    (0x00010000uL)
#define INTC_ICDISR14_TINT49                    (0x00020000uL)
#define INTC_ICDISR14_TINT50                    (0x00040000uL)
#define INTC_ICDISR14_TINT51                    (0x00080000uL)
#define INTC_ICDISR14_TINT52                    (0x00100000uL)
#define INTC_ICDISR14_TINT53                    (0x00200000uL)
#define INTC_ICDISR14_TINT54                    (0x00400000uL)
#define INTC_ICDISR14_TINT55                    (0x00800000uL)
#define INTC_ICDISR14_TINT56                    (0x01000000uL)
#define INTC_ICDISR14_TINT57                    (0x02000000uL)
#define INTC_ICDISR14_TINT58                    (0x04000000uL)
#define INTC_ICDISR14_TINT59                    (0x08000000uL)
#define INTC_ICDISR14_TINT60                    (0x10000000uL)
#define INTC_ICDISR14_TINT61                    (0x20000000uL)
#define INTC_ICDISR14_TINT62                    (0x40000000uL)
#define INTC_ICDISR14_TINT63                    (0x80000000uL)

#define INTC_ICDISR15_TINT64                    (0x00000001uL)
#define INTC_ICDISR15_TINT65                    (0x00000002uL)
#define INTC_ICDISR15_TINT66                    (0x00000004uL)
#define INTC_ICDISR15_TINT67                    (0x00000008uL)
#define INTC_ICDISR15_TINT68                    (0x00000010uL)
#define INTC_ICDISR15_TINT69                    (0x00000020uL)
#define INTC_ICDISR15_TINT70                    (0x00000040uL)
#define INTC_ICDISR15_TINT71                    (0x00000080uL)
#define INTC_ICDISR15_TINT72                    (0x00000100uL)
#define INTC_ICDISR15_TINT73                    (0x00000200uL)
#define INTC_ICDISR15_TINT74                    (0x00000400uL)
#define INTC_ICDISR15_TINT75                    (0x00000800uL)
#define INTC_ICDISR15_TINT76                    (0x00001000uL)
#define INTC_ICDISR15_TINT77                    (0x00002000uL)
#define INTC_ICDISR15_TINT78                    (0x00004000uL)
#define INTC_ICDISR15_TINT79                    (0x00008000uL)
#define INTC_ICDISR15_TINT80                    (0x00010000uL)
#define INTC_ICDISR15_TINT81                    (0x00020000uL)
#define INTC_ICDISR15_TINT82                    (0x00040000uL)
#define INTC_ICDISR15_TINT83                    (0x00080000uL)
#define INTC_ICDISR15_TINT84                    (0x00100000uL)
#define INTC_ICDISR15_TINT85                    (0x00200000uL)
#define INTC_ICDISR15_TINT86                    (0x00400000uL)
#define INTC_ICDISR15_TINT87                    (0x00800000uL)
#define INTC_ICDISR15_TINT88                    (0x01000000uL)
#define INTC_ICDISR15_TINT89                    (0x02000000uL)
#define INTC_ICDISR15_TINT90                    (0x04000000uL)
#define INTC_ICDISR15_TINT91                    (0x08000000uL)
#define INTC_ICDISR15_TINT92                    (0x10000000uL)
#define INTC_ICDISR15_TINT93                    (0x20000000uL)
#define INTC_ICDISR15_TINT94                    (0x40000000uL)
#define INTC_ICDISR15_TINT95                    (0x80000000uL)

#define INTC_ICDISR16_TINT96                    (0x00000001uL)
#define INTC_ICDISR16_TINT97                    (0x00000002uL)
#define INTC_ICDISR16_TINT98                    (0x00000004uL)
#define INTC_ICDISR16_TINT99                    (0x00000008uL)
#define INTC_ICDISR16_TINT100                   (0x00000010uL)
#define INTC_ICDISR16_TINT101                   (0x00000020uL)
#define INTC_ICDISR16_TINT102                   (0x00000040uL)
#define INTC_ICDISR16_TINT103                   (0x00000080uL)
#define INTC_ICDISR16_TINT104                   (0x00000100uL)
#define INTC_ICDISR16_TINT105                   (0x00000200uL)
#define INTC_ICDISR16_TINT106                   (0x00000400uL)
#define INTC_ICDISR16_TINT107                   (0x00000800uL)
#define INTC_ICDISR16_TINT108                   (0x00001000uL)
#define INTC_ICDISR16_TINT109                   (0x00002000uL)
#define INTC_ICDISR16_TINT110                   (0x00004000uL)
#define INTC_ICDISR16_TINT111                   (0x00008000uL)
#define INTC_ICDISR16_TINT112                   (0x00010000uL)
#define INTC_ICDISR16_TINT113                   (0x00020000uL)
#define INTC_ICDISR16_TINT114                   (0x00040000uL)
#define INTC_ICDISR16_TINT115                   (0x00080000uL)
#define INTC_ICDISR16_TINT116                   (0x00100000uL)
#define INTC_ICDISR16_TINT117                   (0x00200000uL)
#define INTC_ICDISR16_TINT118                   (0x00400000uL)
#define INTC_ICDISR16_TINT119                   (0x00800000uL)
#define INTC_ICDISR16_TINT120                   (0x01000000uL)
#define INTC_ICDISR16_TINT121                   (0x02000000uL)
#define INTC_ICDISR16_TINT122                   (0x04000000uL)
#define INTC_ICDISR16_TINT123                   (0x08000000uL)
#define INTC_ICDISR16_TINT124                   (0x10000000uL)
#define INTC_ICDISR16_TINT125                   (0x20000000uL)
#define INTC_ICDISR16_TINT126                   (0x40000000uL)
#define INTC_ICDISR16_TINT127                   (0x80000000uL)

#define INTC_ICDISR17_TINT128                   (0x00000001uL)
#define INTC_ICDISR17_TINT129                   (0x00000002uL)
#define INTC_ICDISR17_TINT130                   (0x00000004uL)
#define INTC_ICDISR17_TINT131                   (0x00000008uL)
#define INTC_ICDISR17_TINT132                   (0x00000010uL)
#define INTC_ICDISR17_TINT133                   (0x00000020uL)
#define INTC_ICDISR17_TINT134                   (0x00000040uL)
#define INTC_ICDISR17_TINT135                   (0x00000080uL)
#define INTC_ICDISR17_TINT136                   (0x00000100uL)
#define INTC_ICDISR17_TINT137                   (0x00000200uL)
#define INTC_ICDISR17_TINT138                   (0x00000400uL)
#define INTC_ICDISR17_TINT139                   (0x00000800uL)
#define INTC_ICDISR17_TINT140                   (0x00001000uL)
#define INTC_ICDISR17_TINT141                   (0x00002000uL)
#define INTC_ICDISR17_TINT142                   (0x00004000uL)
#define INTC_ICDISR17_TINT143                   (0x00008000uL)
#define INTC_ICDISR17_TINT144                   (0x00010000uL)
#define INTC_ICDISR17_TINT145                   (0x00020000uL)
#define INTC_ICDISR17_TINT146                   (0x00040000uL)
#define INTC_ICDISR17_TINT147                   (0x00080000uL)
#define INTC_ICDISR17_TINT148                   (0x00100000uL)
#define INTC_ICDISR17_TINT149                   (0x00200000uL)
#define INTC_ICDISR17_TINT150                   (0x00400000uL)
#define INTC_ICDISR17_TINT151                   (0x00800000uL)
#define INTC_ICDISR17_TINT152                   (0x01000000uL)
#define INTC_ICDISR17_TINT153                   (0x02000000uL)
#define INTC_ICDISR17_TINT154                   (0x04000000uL)
#define INTC_ICDISR17_TINT155                   (0x08000000uL)
#define INTC_ICDISR17_TINT156                   (0x10000000uL)
#define INTC_ICDISR17_TINT157                   (0x20000000uL)
#define INTC_ICDISR17_TINT158                   (0x40000000uL)
#define INTC_ICDISR17_TINT159                   (0x80000000uL)

#define INTC_ICDISR18_TINT160                   (0x00000001uL)
#define INTC_ICDISR18_TINT161                   (0x00000002uL)
#define INTC_ICDISR18_TINT162                   (0x00000004uL)
#define INTC_ICDISR18_TINT163                   (0x00000008uL)
#define INTC_ICDISR18_TINT164                   (0x00000010uL)
#define INTC_ICDISR18_TINT165                   (0x00000020uL)
#define INTC_ICDISR18_TINT166                   (0x00000040uL)
#define INTC_ICDISR18_TINT167                   (0x00000080uL)
#define INTC_ICDISR18_TINT168                   (0x00000100uL)
#define INTC_ICDISR18_TINT169                   (0x00000200uL)
#define INTC_ICDISR18_TINT170                   (0x00000400uL)

#define INTC_ICDISER0_SW0                       (0x00000001uL)
#define INTC_ICDISER0_SW1                       (0x00000002uL)
#define INTC_ICDISER0_SW2                       (0x00000004uL)
#define INTC_ICDISER0_SW3                       (0x00000008uL)
#define INTC_ICDISER0_SW4                       (0x00000010uL)
#define INTC_ICDISER0_SW5                       (0x00000020uL)
#define INTC_ICDISER0_SW6                       (0x00000040uL)
#define INTC_ICDISER0_SW7                       (0x00000080uL)
#define INTC_ICDISER0_SW8                       (0x00000100uL)
#define INTC_ICDISER0_SW9                       (0x00000200uL)
#define INTC_ICDISER0_SW10                      (0x00000400uL)
#define INTC_ICDISER0_SW11                      (0x00000800uL)
#define INTC_ICDISER0_SW12                      (0x00001000uL)
#define INTC_ICDISER0_SW13                      (0x00002000uL)
#define INTC_ICDISER0_SW14                      (0x00004000uL)
#define INTC_ICDISER0_SW15                      (0x00008000uL)
#define INTC_ICDISER0_PMUIRQ0                   (0x00010000uL)
#define INTC_ICDISER0_COMMRX0                   (0x00020000uL)
#define INTC_ICDISER0_COMMTX0                   (0x00040000uL)
#define INTC_ICDISER0_CTIIRQ0                   (0x00080000uL)

#define INTC_ICDISER1_IRQ0                      (0x00000001uL)
#define INTC_ICDISER1_IRQ1                      (0x00000002uL)
#define INTC_ICDISER1_IRQ2                      (0x00000004uL)
#define INTC_ICDISER1_IRQ3                      (0x00000008uL)
#define INTC_ICDISER1_IRQ4                      (0x00000010uL)
#define INTC_ICDISER1_IRQ5                      (0x00000020uL)
#define INTC_ICDISER1_IRQ6                      (0x00000040uL)
#define INTC_ICDISER1_IRQ7                      (0x00000080uL)
#define INTC_ICDISER1_PL310ERR                  (0x00000100uL)
#define INTC_ICDISER1_DMAINT0                   (0x00000200uL)
#define INTC_ICDISER1_DMAINT1                   (0x00000400uL)
#define INTC_ICDISER1_DMAINT2                   (0x00000800uL)
#define INTC_ICDISER1_DMAINT3                   (0x00001000uL)
#define INTC_ICDISER1_DMAINT4                   (0x00002000uL)
#define INTC_ICDISER1_DMAINT5                   (0x00004000uL)
#define INTC_ICDISER1_DMAINT6                   (0x00008000uL)
#define INTC_ICDISER1_DMAINT7                   (0x00010000uL)
#define INTC_ICDISER1_DMAINT8                   (0x00020000uL)
#define INTC_ICDISER1_DMAINT9                   (0x00040000uL)
#define INTC_ICDISER1_DMAINT10                  (0x00080000uL)
#define INTC_ICDISER1_DMAINT11                  (0x00100000uL)
#define INTC_ICDISER1_DMAINT12                  (0x00200000uL)
#define INTC_ICDISER1_DMAINT13                  (0x00400000uL)
#define INTC_ICDISER1_DMAINT14                  (0x00800000uL)
#define INTC_ICDISER1_DMAINT15                  (0x01000000uL)
#define INTC_ICDISER1_DMAERR                    (0x02000000uL)

#define INTC_ICDISER2_USBI0                     (0x00000200uL)
#define INTC_ICDISER2_USBI1                     (0x00000400uL)
#define INTC_ICDISER2_S0_VI_VSYNC0              (0x00000800uL)
#define INTC_ICDISER2_S0_LO_VSYNC0              (0x00001000uL)
#define INTC_ICDISER2_S0_VSYNCERR0              (0x00002000uL)
#define INTC_ICDISER2_GR3_VLINE0                (0x00004000uL)
#define INTC_ICDISER2_S0_VFIELD0                (0x00008000uL)
#define INTC_ICDISER2_IV1_VBUFERR0              (0x00010000uL)
#define INTC_ICDISER2_IV3_VBUFERR0              (0x00020000uL)
#define INTC_ICDISER2_IV5_VBUFERR0              (0x00040000uL)
#define INTC_ICDISER2_IV6_VBUFERR0              (0x00080000uL)
#define INTC_ICDISER2_S0_WLINE0                 (0x00100000uL)
#define INTC_ICDISER2_S1_VI_VSYNC0              (0x00200000uL)
#define INTC_ICDISER2_S1_LO_VSYNC0              (0x00400000uL)
#define INTC_ICDISER2_S1_VSYNCERR0              (0x00800000uL)
#define INTC_ICDISER2_S1_VFIELD0                (0x01000000uL)
#define INTC_ICDISER2_IV2_VBUFERR0              (0x02000000uL)
#define INTC_ICDISER2_IV4_VBUFERR0              (0x04000000uL)
#define INTC_ICDISER2_S1_WLINE0                 (0x08000000uL)
#define INTC_ICDISER2_OIR_VI_VSYNC0             (0x10000000uL)
#define INTC_ICDISER2_OIR_LO_VSYNC0             (0x20000000uL)
#define INTC_ICDISER2_OIR_VSYNCERR0             (0x40000000uL)
#define INTC_ICDISER2_OIR_VFIELD0               (0x80000000uL)

#define INTC_ICDISER3_IV7_VBUFERR0              (0x00000001uL)
#define INTC_ICDISER3_IV8_VBUFERR0              (0x00000002uL)
#define INTC_ICDISER3_OIR_WLINE0                (0x00000004uL)
#define INTC_ICDISER3_S0_VI_VSYNC1              (0x00000008uL)
#define INTC_ICDISER3_S0_LO_VSYNC1              (0x00000010uL)
#define INTC_ICDISER3_S0_VSYNCERR1              (0x00000020uL)
#define INTC_ICDISER3_GR3_VLINE1                (0x00000040uL)
#define INTC_ICDISER3_S0_VFIELD1                (0x00000080uL)
#define INTC_ICDISER3_IV1_VBUFERR1              (0x00000100uL)
#define INTC_ICDISER3_IV3_VBUFERR1              (0x00000200uL)
#define INTC_ICDISER3_IV5_VBUFERR1              (0x00000400uL)
#define INTC_ICDISER3_IV6_VBUFERR1              (0x00000800uL)
#define INTC_ICDISER3_S0_WLINE1                 (0x00001000uL)
#define INTC_ICDISER3_S1_VI_VSYNC1              (0x00002000uL)
#define INTC_ICDISER3_S1_LO_VSYNC1              (0x00004000uL)
#define INTC_ICDISER3_S1_VSYNCERR1              (0x00008000uL)
#define INTC_ICDISER3_S1_VFIELD1                (0x00010000uL)
#define INTC_ICDISER3_IV2_VBUFERR1              (0x00020000uL)
#define INTC_ICDISER3_IV4_VBUFERR1              (0x00040000uL)
#define INTC_ICDISER3_S1_WLINE1                 (0x00080000uL)
#define INTC_ICDISER3_OIR_VI_VSYNC1             (0x00100000uL)
#define INTC_ICDISER3_OIR_LO_VSYNC1             (0x00200000uL)
#define INTC_ICDISER3_OIR_VLINE1                (0x00400000uL)
#define INTC_ICDISER3_OIR_VFIELD1               (0x00800000uL)
#define INTC_ICDISER3_IV7_VBUFERR1              (0x01000000uL)
#define INTC_ICDISER3_IV8_VBUFERR1              (0x02000000uL)
#define INTC_ICDISER3_OIR_WLINE1                (0x04000000uL)
#define INTC_ICDISER3_IMRDI                     (0x08000000uL)
#define INTC_ICDISER3_IMR2I0                    (0x10000000uL)
#define INTC_ICDISER3_IMR2I1                    (0x20000000uL)
#define INTC_ICDISER3_JEDI                      (0x40000000uL)
#define INTC_ICDISER3_JDTI                      (0x80000000uL)

#define INTC_ICDISER4_CMP0                      (0x00000001uL)
#define INTC_ICDISER4_CMP1                      (0x00000002uL)
#define INTC_ICDISER4_INT0                      (0x00000004uL)
#define INTC_ICDISER4_INT1                      (0x00000008uL)
#define INTC_ICDISER4_INT2                      (0x00000010uL)
#define INTC_ICDISER4_INT3                      (0x00000020uL)
#define INTC_ICDISER4_OSTM0TINT                 (0x00000040uL)
#define INTC_ICDISER4_OSTM1TINT                 (0x00000080uL)
#define INTC_ICDISER4_CMI                       (0x00000100uL)
#define INTC_ICDISER4_WTOUT                     (0x00000200uL)
#define INTC_ICDISER4_ITI                       (0x00000400uL)
#define INTC_ICDISER4_TGI0A                     (0x00000800uL)
#define INTC_ICDISER4_TGI0B                     (0x00001000uL)
#define INTC_ICDISER4_TGI0C                     (0x00002000uL)
#define INTC_ICDISER4_TGI0D                     (0x00004000uL)
#define INTC_ICDISER4_TGI0V                     (0x00008000uL)
#define INTC_ICDISER4_TGI0E                     (0x00010000uL)
#define INTC_ICDISER4_TGI0F                     (0x00020000uL)
#define INTC_ICDISER4_TGI1A                     (0x00040000uL)
#define INTC_ICDISER4_TGI1B                     (0x00080000uL)
#define INTC_ICDISER4_TGI1V                     (0x00100000uL)
#define INTC_ICDISER4_TGI1U                     (0x00200000uL)
#define INTC_ICDISER4_TGI2A                     (0x00400000uL)
#define INTC_ICDISER4_TGI2B                     (0x00800000uL)
#define INTC_ICDISER4_TGI2V                     (0x01000000uL)
#define INTC_ICDISER4_TGI2U                     (0x02000000uL)
#define INTC_ICDISER4_TGI3A                     (0x04000000uL)
#define INTC_ICDISER4_TGI3B                     (0x08000000uL)
#define INTC_ICDISER4_TGI3C                     (0x10000000uL)
#define INTC_ICDISER4_TGI3D                     (0x20000000uL)
#define INTC_ICDISER4_TGI3V                     (0x40000000uL)
#define INTC_ICDISER4_TGI4A                     (0x80000000uL)

#define INTC_ICDISER5_TGI4B                     (0x00000001uL)
#define INTC_ICDISER5_TGI4C                     (0x00000002uL)
#define INTC_ICDISER5_TGI4D                     (0x00000004uL)
#define INTC_ICDISER5_TGI4V                     (0x00000008uL)
#define INTC_ICDISER5_CMI1                      (0x00000010uL)
#define INTC_ICDISER5_CMI2                      (0x00000020uL)
#define INTC_ICDISER5_SGDEI0                    (0x00000040uL)
#define INTC_ICDISER5_SGDEI1                    (0x00000080uL)
#define INTC_ICDISER5_SGDEI2                    (0x00000100uL)
#define INTC_ICDISER5_SGDEI3                    (0x00000200uL)
#define INTC_ICDISER5_ADI                       (0x00000400uL)
#define INTC_ICDISER5_LMTI                      (0x00000800uL)
#define INTC_ICDISER5_SSII0                     (0x00001000uL)
#define INTC_ICDISER5_SSIRXI0                   (0x00002000uL)
#define INTC_ICDISER5_SSITXI0                   (0x00004000uL)
#define INTC_ICDISER5_SSII1                     (0x00008000uL)
#define INTC_ICDISER5_SSIRXI1                   (0x00010000uL)
#define INTC_ICDISER5_SSITXI1                   (0x00020000uL)
#define INTC_ICDISER5_SSII2                     (0x00040000uL)
#define INTC_ICDISER5_SSIRTI2                   (0x00080000uL)
#define INTC_ICDISER5_SSII3                     (0x00100000uL)
#define INTC_ICDISER5_SSIRXI3                   (0x00200000uL)
#define INTC_ICDISER5_SSITXI3                   (0x00400000uL)
#define INTC_ICDISER5_SSII4                     (0x00800000uL)
#define INTC_ICDISER5_SSIRTI4                   (0x01000000uL)
#define INTC_ICDISER5_SSII5                     (0x02000000uL)
#define INTC_ICDISER5_SSIRXI5                   (0x04000000uL)
#define INTC_ICDISER5_SSITXI5                   (0x08000000uL)
#define INTC_ICDISER5_SPDIFI                    (0x10000000uL)
#define INTC_ICDISER5_INTIICTEI0                (0x20000000uL)
#define INTC_ICDISER5_INTIICRI0                 (0x40000000uL)
#define INTC_ICDISER5_INTIICTI0                 (0x80000000uL)

#define INTC_ICDISER6_INTIICSPI0                (0x00000001uL)
#define INTC_ICDISER6_INTIICSTI0                (0x00000002uL)
#define INTC_ICDISER6_INTIICNAKI0               (0x00000004uL)
#define INTC_ICDISER6_INTIICALI0                (0x00000008uL)
#define INTC_ICDISER6_INTIICTMOI0               (0x00000010uL)
#define INTC_ICDISER6_INTIICTEI1                (0x00000020uL)
#define INTC_ICDISER6_INTIICRI1                 (0x00000040uL)
#define INTC_ICDISER6_INTIICTI1                 (0x00000080uL)
#define INTC_ICDISER6_INTIICSPI1                (0x00000100uL)
#define INTC_ICDISER6_INTIICSTI1                (0x00000200uL)
#define INTC_ICDISER6_INTIICNAKI1               (0x00000400uL)
#define INTC_ICDISER6_INTIICALI1                (0x00000800uL)
#define INTC_ICDISER6_INTIICTMOI1               (0x00001000uL)
#define INTC_ICDISER6_INTIICTEI2                (0x00002000uL)
#define INTC_ICDISER6_INTIICRI2                 (0x00004000uL)
#define INTC_ICDISER6_INTIICTI2                 (0x00008000uL)
#define INTC_ICDISER6_INTIICSPI2                (0x00010000uL)
#define INTC_ICDISER6_INTIICSTI2                (0x00020000uL)
#define INTC_ICDISER6_INTIICNAKI2               (0x00040000uL)
#define INTC_ICDISER6_INTIICALI2                (0x00080000uL)
#define INTC_ICDISER6_INTIICTMOI2               (0x00100000uL)
#define INTC_ICDISER6_INTIICTEI3                (0x00200000uL)
#define INTC_ICDISER6_INTIICRI3                 (0x00400000uL)
#define INTC_ICDISER6_INTIICTI3                 (0x00800000uL)
#define INTC_ICDISER6_INTIICSPI3                (0x01000000uL)
#define INTC_ICDISER6_INTIICSTI3                (0x02000000uL)
#define INTC_ICDISER6_INTIICNAKI3               (0x04000000uL)
#define INTC_ICDISER6_INTIICALI3                (0x08000000uL)
#define INTC_ICDISER6_INTIICTMOI3               (0x10000000uL)
#define INTC_ICDISER6_BRI0                      (0x20000000uL)
#define INTC_ICDISER6_ERI0                      (0x40000000uL)
#define INTC_ICDISER6_RXI0                      (0x80000000uL)

#define INTC_ICDISER7_TXI0                      (0x00000001uL)
#define INTC_ICDISER7_BRI1                      (0x00000002uL)
#define INTC_ICDISER7_ERI1                      (0x00000004uL)
#define INTC_ICDISER7_RXI1                      (0x00000008uL)
#define INTC_ICDISER7_TXI1                      (0x00000010uL)
#define INTC_ICDISER7_BRI2                      (0x00000020uL)
#define INTC_ICDISER7_ERI2                      (0x00000040uL)
#define INTC_ICDISER7_RXI2                      (0x00000080uL)
#define INTC_ICDISER7_TXI2                      (0x00000100uL)
#define INTC_ICDISER7_BRI3                      (0x00000200uL)
#define INTC_ICDISER7_ERI3                      (0x00000400uL)
#define INTC_ICDISER7_RXI3                      (0x00000800uL)
#define INTC_ICDISER7_TXI3                      (0x00001000uL)
#define INTC_ICDISER7_BRI4                      (0x00002000uL)
#define INTC_ICDISER7_ERI4                      (0x00004000uL)
#define INTC_ICDISER7_RXI4                      (0x00008000uL)
#define INTC_ICDISER7_TXI4                      (0x00010000uL)
#define INTC_ICDISER7_BRI5                      (0x00020000uL)
#define INTC_ICDISER7_ERI5                      (0x00040000uL)
#define INTC_ICDISER7_RXI5                      (0x00080000uL)
#define INTC_ICDISER7_TXI5                      (0x00100000uL)
#define INTC_ICDISER7_BRI6                      (0x00200000uL)
#define INTC_ICDISER7_ERI6                      (0x00400000uL)
#define INTC_ICDISER7_RXI6                      (0x00800000uL)
#define INTC_ICDISER7_TXI6                      (0x01000000uL)
#define INTC_ICDISER7_BRI7                      (0x02000000uL)
#define INTC_ICDISER7_ERI7                      (0x04000000uL)
#define INTC_ICDISER7_RXI7                      (0x08000000uL)
#define INTC_ICDISER7_TXI7                      (0x10000000uL)
#define INTC_ICDISER7_INTRCANGERR               (0x20000000uL)
#define INTC_ICDISER7_INTRCANGRECC              (0x40000000uL)
#define INTC_ICDISER7_INTRCAN0REC               (0x80000000uL)

#define INTC_ICDISER8_INTRCAN0ERR               (0x00000001uL)
#define INTC_ICDISER8_INTRCAN0TRX               (0x00000002uL)
#define INTC_ICDISER8_INTRCAN1REC               (0x00000004uL)
#define INTC_ICDISER8_INTRCAN1ERR               (0x00000008uL)
#define INTC_ICDISER8_INTRCAN1TRX               (0x00000010uL)
#define INTC_ICDISER8_INTRCAN2REC               (0x00000020uL)
#define INTC_ICDISER8_INTRCAN2ERR               (0x00000040uL)
#define INTC_ICDISER8_INTRCAN2TRX               (0x00000080uL)
#define INTC_ICDISER8_INTRCAN3REC               (0x00000100uL)
#define INTC_ICDISER8_INTRCAN3ERR               (0x00000200uL)
#define INTC_ICDISER8_INTRCAN3TRX               (0x00000400uL)
#define INTC_ICDISER8_INTRCAN4REC               (0x00000800uL)
#define INTC_ICDISER8_INTRCAN4ERR               (0x00001000uL)
#define INTC_ICDISER8_INTRCAN4TRX               (0x00002000uL)
#define INTC_ICDISER8_SPEI0                     (0x00004000uL)
#define INTC_ICDISER8_SPRI0                     (0x00008000uL)
#define INTC_ICDISER8_SPTI0                     (0x00010000uL)
#define INTC_ICDISER8_SPEI1                     (0x00020000uL)
#define INTC_ICDISER8_SPRI1                     (0x00040000uL)
#define INTC_ICDISER8_SPTI1                     (0x00080000uL)
#define INTC_ICDISER8_SPEI2                     (0x00100000uL)
#define INTC_ICDISER8_SPRI2                     (0x00200000uL)
#define INTC_ICDISER8_SPTI2                     (0x00400000uL)
#define INTC_ICDISER8_SPEI3                     (0x00800000uL)
#define INTC_ICDISER8_SPRI3                     (0x01000000uL)
#define INTC_ICDISER8_SPTI3                     (0x02000000uL)
#define INTC_ICDISER8_SPEI4                     (0x04000000uL)
#define INTC_ICDISER8_SPRI4                     (0x08000000uL)
#define INTC_ICDISER8_SPTI4                     (0x10000000uL)
#define INTC_ICDISER8_IEBBTD                    (0x20000000uL)
#define INTC_ICDISER8_IEBBTERR                  (0x40000000uL)
#define INTC_ICDISER8_IEBBTSTA                  (0x80000000uL)

#define INTC_ICDISER9_IEBBTV                    (0x00000001uL)
#define INTC_ICDISER9_ISY                       (0x00000002uL)
#define INTC_ICDISER9_IERR                      (0x00000004uL)
#define INTC_ICDISER9_ITARG                     (0x00000008uL)
#define INTC_ICDISER9_ISEC                      (0x00000010uL)
#define INTC_ICDISER9_IBUF                      (0x00000020uL)
#define INTC_ICDISER9_IREADY                    (0x00000040uL)
#define INTC_ICDISER9_FLSTE                     (0x00000080uL)
#define INTC_ICDISER9_FLTENDI                   (0x00000100uL)
#define INTC_ICDISER9_FLTREQ0I                  (0x00000200uL)
#define INTC_ICDISER9_FLTREQ1I                  (0x00000400uL)
#define INTC_ICDISER9_MMC0                      (0x00000800uL)
#define INTC_ICDISER9_MMC1                      (0x00001000uL)
#define INTC_ICDISER9_MMC2                      (0x00002000uL)
#define INTC_ICDISER9_SDHI0_3                   (0x00004000uL)
#define INTC_ICDISER9_SDHI0_0                   (0x00008000uL)
#define INTC_ICDISER9_SDHI0_1                   (0x00010000uL)
#define INTC_ICDISER9_SDHI1_3                   (0x00020000uL)
#define INTC_ICDISER9_SDHI1_0                   (0x00040000uL)
#define INTC_ICDISER9_SDHI1_1                   (0x00080000uL)
#define INTC_ICDISER9_ARM                       (0x00100000uL)
#define INTC_ICDISER9_PRD                       (0x00200000uL)
#define INTC_ICDISER9_CUP                       (0x00400000uL)
#define INTC_ICDISER9_SCUAI0                    (0x00800000uL)
#define INTC_ICDISER9_SCUAI1                    (0x01000000uL)
#define INTC_ICDISER9_SCUFDI0                   (0x02000000uL)
#define INTC_ICDISER9_SCUFDI1                   (0x04000000uL)
#define INTC_ICDISER9_SCUFDI2                   (0x08000000uL)
#define INTC_ICDISER9_SCUFDI3                   (0x10000000uL)
#define INTC_ICDISER9_SCUFUI0                   (0x20000000uL)
#define INTC_ICDISER9_SCUFUI1                   (0x40000000uL)
#define INTC_ICDISER9_SCUFUI2                   (0x80000000uL)

#define INTC_ICDISER10_SCUFUI3                  (0x00000001uL)
#define INTC_ICDISER10_SCUDVI0                  (0x00000002uL)
#define INTC_ICDISER10_SCUDVI1                  (0x00000004uL)
#define INTC_ICDISER10_SCUDVI2                  (0x00000008uL)
#define INTC_ICDISER10_SCUDVI3                  (0x00000010uL)
#define INTC_ICDISER10_MLB_CINT                 (0x00000020uL)
#define INTC_ICDISER10_MLB_SINT                 (0x00000040uL)
#define INTC_ICDISER10_DRC0                     (0x00000080uL)
#define INTC_ICDISER10_DRC1                     (0x00000100uL)
#define INTC_ICDISER10_LINI0_INT_T              (0x00000800uL)
#define INTC_ICDISER10_LINI0_INT_R              (0x00001000uL)
#define INTC_ICDISER10_LINI0_INT_S              (0x00002000uL)
#define INTC_ICDISER10_LINI0_INT_M              (0x00004000uL)
#define INTC_ICDISER10_LINI1_INT_T              (0x00008000uL)
#define INTC_ICDISER10_LINI1_INT_R              (0x00010000uL)
#define INTC_ICDISER10_LINI1_INT_S              (0x00020000uL)
#define INTC_ICDISER10_LINI1_INT_M              (0x00040000uL)
#define INTC_ICDISER10_ERI0                     (0x08000000uL)
#define INTC_ICDISER10_RXI0                     (0x10000000uL)
#define INTC_ICDISER10_TXI0                     (0x20000000uL)
#define INTC_ICDISER10_TEI0                     (0x40000000uL)
#define INTC_ICDISER10_ERI1                     (0x80000000uL)

#define INTC_ICDISER11_RXI1                     (0x00000001uL)
#define INTC_ICDISER11_TXI1                     (0x00000002uL)
#define INTC_ICDISER11_TEI1                     (0x00000004uL)
#define INTC_ICDISER11_AVBI_DATA                (0x00000008uL)
#define INTC_ICDISER11_AVBI_ERROR               (0x00000010uL)
#define INTC_ICDISER11_AVBI_MANAGE              (0x00000020uL)
#define INTC_ICDISER11_AVBI_MAC                 (0x00000040uL)
#define INTC_ICDISER11_ETHERI                   (0x00000080uL)
#define INTC_ICDISER11_CEUI                     (0x00001000uL)
#define INTC_ICDISER11_H2XMLB_ERRINT            (0x20000000uL)
#define INTC_ICDISER11_H2XIC1_ERRINT            (0x40000000uL)
#define INTC_ICDISER11_X2HPERI1_ERRINT          (0x80000000uL)

#define INTC_ICDISER12_X2HPERI2_ERRINT          (0x00000001uL)
#define INTC_ICDISER12_X2HPERI34_ERRINT         (0x00000002uL)
#define INTC_ICDISER12_X2HPERI5_ERRINT          (0x00000004uL)
#define INTC_ICDISER12_X2HPERI67_ERRINT         (0x00000008uL)
#define INTC_ICDISER12_X2HDBGR_ERRINT           (0x00000010uL)
#define INTC_ICDISER12_X2HBSC_ERRINT            (0x00000020uL)
#define INTC_ICDISER12_X2HSPI1_ERRINT           (0x00000040uL)
#define INTC_ICDISER12_X2HSPI2_ERRINT           (0x00000080uL)
#define INTC_ICDISER12_PRRI                     (0x00000100uL)
#define INTC_ICDISER12_IFEI0                    (0x00000200uL)
#define INTC_ICDISER12_OFFI0                    (0x00000400uL)
#define INTC_ICDISER12_PFVEI0                   (0x00000800uL)
#define INTC_ICDISER12_IFEI1                    (0x00001000uL)
#define INTC_ICDISER12_OFFI1                    (0x00002000uL)
#define INTC_ICDISER12_PFVEI1                   (0x00004000uL)

#define INTC_ICDISER13_TINT0                    (0x00000001uL)
#define INTC_ICDISER13_TINT1                    (0x00000002uL)
#define INTC_ICDISER13_TINT2                    (0x00000004uL)
#define INTC_ICDISER13_TINT3                    (0x00000008uL)
#define INTC_ICDISER13_TINT4                    (0x00000010uL)
#define INTC_ICDISER13_TINT5                    (0x00000020uL)
#define INTC_ICDISER13_TINT6                    (0x00000040uL)
#define INTC_ICDISER13_TINT7                    (0x00000080uL)
#define INTC_ICDISER13_TINT8                    (0x00000100uL)
#define INTC_ICDISER13_TINT9                    (0x00000200uL)
#define INTC_ICDISER13_TINT10                   (0x00000400uL)
#define INTC_ICDISER13_TINT11                   (0x00000800uL)
#define INTC_ICDISER13_TINT12                   (0x00001000uL)
#define INTC_ICDISER13_TINT13                   (0x00002000uL)
#define INTC_ICDISER13_TINT14                   (0x00004000uL)
#define INTC_ICDISER13_TINT15                   (0x00008000uL)
#define INTC_ICDISER13_TINT16                   (0x00010000uL)
#define INTC_ICDISER13_TINT17                   (0x00020000uL)
#define INTC_ICDISER13_TINT18                   (0x00040000uL)
#define INTC_ICDISER13_TINT19                   (0x00080000uL)
#define INTC_ICDISER13_TINT20                   (0x00100000uL)
#define INTC_ICDISER13_TINT21                   (0x00200000uL)
#define INTC_ICDISER13_TINT22                   (0x00400000uL)
#define INTC_ICDISER13_TINT23                   (0x00800000uL)
#define INTC_ICDISER13_TINT24                   (0x01000000uL)
#define INTC_ICDISER13_TINT25                   (0x02000000uL)
#define INTC_ICDISER13_TINT26                   (0x04000000uL)
#define INTC_ICDISER13_TINT27                   (0x08000000uL)
#define INTC_ICDISER13_TINT28                   (0x10000000uL)
#define INTC_ICDISER13_TINT29                   (0x20000000uL)
#define INTC_ICDISER13_TINT30                   (0x40000000uL)
#define INTC_ICDISER13_TINT31                   (0x80000000uL)

#define INTC_ICDISER14_TINT32                   (0x00000001uL)
#define INTC_ICDISER14_TINT33                   (0x00000002uL)
#define INTC_ICDISER14_TINT34                   (0x00000004uL)
#define INTC_ICDISER14_TINT35                   (0x00000008uL)
#define INTC_ICDISER14_TINT36                   (0x00000010uL)
#define INTC_ICDISER14_TINT37                   (0x00000020uL)
#define INTC_ICDISER14_TINT38                   (0x00000040uL)
#define INTC_ICDISER14_TINT39                   (0x00000080uL)
#define INTC_ICDISER14_TINT40                   (0x00000100uL)
#define INTC_ICDISER14_TINT41                   (0x00000200uL)
#define INTC_ICDISER14_TINT42                   (0x00000400uL)
#define INTC_ICDISER14_TINT43                   (0x00000800uL)
#define INTC_ICDISER14_TINT44                   (0x00001000uL)
#define INTC_ICDISER14_TINT45                   (0x00002000uL)
#define INTC_ICDISER14_TINT46                   (0x00004000uL)
#define INTC_ICDISER14_TINT47                   (0x00008000uL)
#define INTC_ICDISER14_TINT48                   (0x00010000uL)
#define INTC_ICDISER14_TINT49                   (0x00020000uL)
#define INTC_ICDISER14_TINT50                   (0x00040000uL)
#define INTC_ICDISER14_TINT51                   (0x00080000uL)
#define INTC_ICDISER14_TINT52                   (0x00100000uL)
#define INTC_ICDISER14_TINT53                   (0x00200000uL)
#define INTC_ICDISER14_TINT54                   (0x00400000uL)
#define INTC_ICDISER14_TINT55                   (0x00800000uL)
#define INTC_ICDISER14_TINT56                   (0x01000000uL)
#define INTC_ICDISER14_TINT57                   (0x02000000uL)
#define INTC_ICDISER14_TINT58                   (0x04000000uL)
#define INTC_ICDISER14_TINT59                   (0x08000000uL)
#define INTC_ICDISER14_TINT60                   (0x10000000uL)
#define INTC_ICDISER14_TINT61                   (0x20000000uL)
#define INTC_ICDISER14_TINT62                   (0x40000000uL)
#define INTC_ICDISER14_TINT63                   (0x80000000uL)

#define INTC_ICDISER15_TINT64                   (0x00000001uL)
#define INTC_ICDISER15_TINT65                   (0x00000002uL)
#define INTC_ICDISER15_TINT66                   (0x00000004uL)
#define INTC_ICDISER15_TINT67                   (0x00000008uL)
#define INTC_ICDISER15_TINT68                   (0x00000010uL)
#define INTC_ICDISER15_TINT69                   (0x00000020uL)
#define INTC_ICDISER15_TINT70                   (0x00000040uL)
#define INTC_ICDISER15_TINT71                   (0x00000080uL)
#define INTC_ICDISER15_TINT72                   (0x00000100uL)
#define INTC_ICDISER15_TINT73                   (0x00000200uL)
#define INTC_ICDISER15_TINT74                   (0x00000400uL)
#define INTC_ICDISER15_TINT75                   (0x00000800uL)
#define INTC_ICDISER15_TINT76                   (0x00001000uL)
#define INTC_ICDISER15_TINT77                   (0x00002000uL)
#define INTC_ICDISER15_TINT78                   (0x00004000uL)
#define INTC_ICDISER15_TINT79                   (0x00008000uL)
#define INTC_ICDISER15_TINT80                   (0x00010000uL)
#define INTC_ICDISER15_TINT81                   (0x00020000uL)
#define INTC_ICDISER15_TINT82                   (0x00040000uL)
#define INTC_ICDISER15_TINT83                   (0x00080000uL)
#define INTC_ICDISER15_TINT84                   (0x00100000uL)
#define INTC_ICDISER15_TINT85                   (0x00200000uL)
#define INTC_ICDISER15_TINT86                   (0x00400000uL)
#define INTC_ICDISER15_TINT87                   (0x00800000uL)
#define INTC_ICDISER15_TINT88                   (0x01000000uL)
#define INTC_ICDISER15_TINT89                   (0x02000000uL)
#define INTC_ICDISER15_TINT90                   (0x04000000uL)
#define INTC_ICDISER15_TINT91                   (0x08000000uL)
#define INTC_ICDISER15_TINT92                   (0x10000000uL)
#define INTC_ICDISER15_TINT93                   (0x20000000uL)
#define INTC_ICDISER15_TINT94                   (0x40000000uL)
#define INTC_ICDISER15_TINT95                   (0x80000000uL)

#define INTC_ICDISER16_TINT96                   (0x00000001uL)
#define INTC_ICDISER16_TINT97                   (0x00000002uL)
#define INTC_ICDISER16_TINT98                   (0x00000004uL)
#define INTC_ICDISER16_TINT99                   (0x00000008uL)
#define INTC_ICDISER16_TINT100                  (0x00000010uL)
#define INTC_ICDISER16_TINT101                  (0x00000020uL)
#define INTC_ICDISER16_TINT102                  (0x00000040uL)
#define INTC_ICDISER16_TINT103                  (0x00000080uL)
#define INTC_ICDISER16_TINT104                  (0x00000100uL)
#define INTC_ICDISER16_TINT105                  (0x00000200uL)
#define INTC_ICDISER16_TINT106                  (0x00000400uL)
#define INTC_ICDISER16_TINT107                  (0x00000800uL)
#define INTC_ICDISER16_TINT108                  (0x00001000uL)
#define INTC_ICDISER16_TINT109                  (0x00002000uL)
#define INTC_ICDISER16_TINT110                  (0x00004000uL)
#define INTC_ICDISER16_TINT111                  (0x00008000uL)
#define INTC_ICDISER16_TINT112                  (0x00010000uL)
#define INTC_ICDISER16_TINT113                  (0x00020000uL)
#define INTC_ICDISER16_TINT114                  (0x00040000uL)
#define INTC_ICDISER16_TINT115                  (0x00080000uL)
#define INTC_ICDISER16_TINT116                  (0x00100000uL)
#define INTC_ICDISER16_TINT117                  (0x00200000uL)
#define INTC_ICDISER16_TINT118                  (0x00400000uL)
#define INTC_ICDISER16_TINT119                  (0x00800000uL)
#define INTC_ICDISER16_TINT120                  (0x01000000uL)
#define INTC_ICDISER16_TINT121                  (0x02000000uL)
#define INTC_ICDISER16_TINT122                  (0x04000000uL)
#define INTC_ICDISER16_TINT123                  (0x08000000uL)
#define INTC_ICDISER16_TINT124                  (0x10000000uL)
#define INTC_ICDISER16_TINT125                  (0x20000000uL)
#define INTC_ICDISER16_TINT126                  (0x40000000uL)
#define INTC_ICDISER16_TINT127                  (0x80000000uL)

#define INTC_ICDISER17_TINT128                  (0x00000001uL)
#define INTC_ICDISER17_TINT129                  (0x00000002uL)
#define INTC_ICDISER17_TINT130                  (0x00000004uL)
#define INTC_ICDISER17_TINT131                  (0x00000008uL)
#define INTC_ICDISER17_TINT132                  (0x00000010uL)
#define INTC_ICDISER17_TINT133                  (0x00000020uL)
#define INTC_ICDISER17_TINT134                  (0x00000040uL)
#define INTC_ICDISER17_TINT135                  (0x00000080uL)
#define INTC_ICDISER17_TINT136                  (0x00000100uL)
#define INTC_ICDISER17_TINT137                  (0x00000200uL)
#define INTC_ICDISER17_TINT138                  (0x00000400uL)
#define INTC_ICDISER17_TINT139                  (0x00000800uL)
#define INTC_ICDISER17_TINT140                  (0x00001000uL)
#define INTC_ICDISER17_TINT141                  (0x00002000uL)
#define INTC_ICDISER17_TINT142                  (0x00004000uL)
#define INTC_ICDISER17_TINT143                  (0x00008000uL)
#define INTC_ICDISER17_TINT144                  (0x00010000uL)
#define INTC_ICDISER17_TINT145                  (0x00020000uL)
#define INTC_ICDISER17_TINT146                  (0x00040000uL)
#define INTC_ICDISER17_TINT147                  (0x00080000uL)
#define INTC_ICDISER17_TINT148                  (0x00100000uL)
#define INTC_ICDISER17_TINT149                  (0x00200000uL)
#define INTC_ICDISER17_TINT150                  (0x00400000uL)
#define INTC_ICDISER17_TINT151                  (0x00800000uL)
#define INTC_ICDISER17_TINT152                  (0x01000000uL)
#define INTC_ICDISER17_TINT153                  (0x02000000uL)
#define INTC_ICDISER17_TINT154                  (0x04000000uL)
#define INTC_ICDISER17_TINT155                  (0x08000000uL)
#define INTC_ICDISER17_TINT156                  (0x10000000uL)
#define INTC_ICDISER17_TINT157                  (0x20000000uL)
#define INTC_ICDISER17_TINT158                  (0x40000000uL)
#define INTC_ICDISER17_TINT159                  (0x80000000uL)

#define INTC_ICDISER18_TINT160                  (0x00000001uL)
#define INTC_ICDISER18_TINT161                  (0x00000002uL)
#define INTC_ICDISER18_TINT162                  (0x00000004uL)
#define INTC_ICDISER18_TINT163                  (0x00000008uL)
#define INTC_ICDISER18_TINT164                  (0x00000010uL)
#define INTC_ICDISER18_TINT165                  (0x00000020uL)
#define INTC_ICDISER18_TINT166                  (0x00000040uL)
#define INTC_ICDISER18_TINT167                  (0x00000080uL)
#define INTC_ICDISER18_TINT168                  (0x00000100uL)
#define INTC_ICDISER18_TINT169                  (0x00000200uL)
#define INTC_ICDISER18_TINT170                  (0x00000400uL)

#define INTC_ICDICER0_SW0                       (0x00000001uL)
#define INTC_ICDICER0_SW1                       (0x00000002uL)
#define INTC_ICDICER0_SW2                       (0x00000004uL)
#define INTC_ICDICER0_SW3                       (0x00000008uL)
#define INTC_ICDICER0_SW4                       (0x00000010uL)
#define INTC_ICDICER0_SW5                       (0x00000020uL)
#define INTC_ICDICER0_SW6                       (0x00000040uL)
#define INTC_ICDICER0_SW7                       (0x00000080uL)
#define INTC_ICDICER0_SW8                       (0x00000100uL)
#define INTC_ICDICER0_SW9                       (0x00000200uL)
#define INTC_ICDICER0_SW10                      (0x00000400uL)
#define INTC_ICDICER0_SW11                      (0x00000800uL)
#define INTC_ICDICER0_SW12                      (0x00001000uL)
#define INTC_ICDICER0_SW13                      (0x00002000uL)
#define INTC_ICDICER0_SW14                      (0x00004000uL)
#define INTC_ICDICER0_SW15                      (0x00008000uL)
#define INTC_ICDICER0_PMUIRQ0                   (0x00010000uL)
#define INTC_ICDICER0_COMMRX0                   (0x00020000uL)
#define INTC_ICDICER0_COMMTX0                   (0x00040000uL)
#define INTC_ICDICER0_CTIIRQ0                   (0x00080000uL)

#define INTC_ICDICER1_IRQ0                      (0x00000001uL)
#define INTC_ICDICER1_IRQ1                      (0x00000002uL)
#define INTC_ICDICER1_IRQ2                      (0x00000004uL)
#define INTC_ICDICER1_IRQ3                      (0x00000008uL)
#define INTC_ICDICER1_IRQ4                      (0x00000010uL)
#define INTC_ICDICER1_IRQ5                      (0x00000020uL)
#define INTC_ICDICER1_IRQ6                      (0x00000040uL)
#define INTC_ICDICER1_IRQ7                      (0x00000080uL)
#define INTC_ICDICER1_PL310ERR                  (0x00000100uL)
#define INTC_ICDICER1_DMAINT0                   (0x00000200uL)
#define INTC_ICDICER1_DMAINT1                   (0x00000400uL)
#define INTC_ICDICER1_DMAINT2                   (0x00000800uL)
#define INTC_ICDICER1_DMAINT3                   (0x00001000uL)
#define INTC_ICDICER1_DMAINT4                   (0x00002000uL)
#define INTC_ICDICER1_DMAINT5                   (0x00004000uL)
#define INTC_ICDICER1_DMAINT6                   (0x00008000uL)
#define INTC_ICDICER1_DMAINT7                   (0x00010000uL)
#define INTC_ICDICER1_DMAINT8                   (0x00020000uL)
#define INTC_ICDICER1_DMAINT9                   (0x00040000uL)
#define INTC_ICDICER1_DMAINT10                  (0x00080000uL)
#define INTC_ICDICER1_DMAINT11                  (0x00100000uL)
#define INTC_ICDICER1_DMAINT12                  (0x00200000uL)
#define INTC_ICDICER1_DMAINT13                  (0x00400000uL)
#define INTC_ICDICER1_DMAINT14                  (0x00800000uL)
#define INTC_ICDICER1_DMAINT15                  (0x01000000uL)
#define INTC_ICDICER1_DMAERR                    (0x02000000uL)

#define INTC_ICDICER2_USBI0                     (0x00000200uL)
#define INTC_ICDICER2_USBI1                     (0x00000400uL)
#define INTC_ICDICER2_S0_VI_VSYNC0              (0x00000800uL)
#define INTC_ICDICER2_S0_LO_VSYNC0              (0x00001000uL)
#define INTC_ICDICER2_S0_VSYNCERR0              (0x00002000uL)
#define INTC_ICDICER2_GR3_VLINE0                (0x00004000uL)
#define INTC_ICDICER2_S0_VFIELD0                (0x00008000uL)
#define INTC_ICDICER2_IV1_VBUFERR0              (0x00010000uL)
#define INTC_ICDICER2_IV3_VBUFERR0              (0x00020000uL)
#define INTC_ICDICER2_IV5_VBUFERR0              (0x00040000uL)
#define INTC_ICDICER2_IV6_VBUFERR0              (0x00080000uL)
#define INTC_ICDICER2_S0_WLINE0                 (0x00100000uL)
#define INTC_ICDICER2_S1_VI_VSYNC0              (0x00200000uL)
#define INTC_ICDICER2_S1_LO_VSYNC0              (0x00400000uL)
#define INTC_ICDICER2_S1_VSYNCERR0              (0x00800000uL)
#define INTC_ICDICER2_S1_VFIELD0                (0x01000000uL)
#define INTC_ICDICER2_IV2_VBUFERR0              (0x02000000uL)
#define INTC_ICDICER2_IV4_VBUFERR0              (0x04000000uL)
#define INTC_ICDICER2_S1_WLINE0                 (0x08000000uL)
#define INTC_ICDICER2_OIR_VI_VSYNC0             (0x10000000uL)
#define INTC_ICDICER2_OIR_LO_VSYNC0             (0x20000000uL)
#define INTC_ICDICER2_OIR_VSYNCERR0             (0x40000000uL)
#define INTC_ICDICER2_OIR_VFIELD0               (0x80000000uL)

#define INTC_ICDICER3_IV7_VBUFERR0              (0x00000001uL)
#define INTC_ICDICER3_IV8_VBUFERR0              (0x00000002uL)
#define INTC_ICDICER3_OIR_WLINE0                (0x00000004uL)
#define INTC_ICDICER3_S0_VI_VSYNC1              (0x00000008uL)
#define INTC_ICDICER3_S0_LO_VSYNC1              (0x00000010uL)
#define INTC_ICDICER3_S0_VSYNCERR1              (0x00000020uL)
#define INTC_ICDICER3_GR3_VLINE1                (0x00000040uL)
#define INTC_ICDICER3_S0_VFIELD1                (0x00000080uL)
#define INTC_ICDICER3_IV1_VBUFERR1              (0x00000100uL)
#define INTC_ICDICER3_IV3_VBUFERR1              (0x00000200uL)
#define INTC_ICDICER3_IV5_VBUFERR1              (0x00000400uL)
#define INTC_ICDICER3_IV6_VBUFERR1              (0x00000800uL)
#define INTC_ICDICER3_S0_WLINE1                 (0x00001000uL)
#define INTC_ICDICER3_S1_VI_VSYNC1              (0x00002000uL)
#define INTC_ICDICER3_S1_LO_VSYNC1              (0x00004000uL)
#define INTC_ICDICER3_S1_VSYNCERR1              (0x00008000uL)
#define INTC_ICDICER3_S1_VFIELD1                (0x00010000uL)
#define INTC_ICDICER3_IV2_VBUFERR1              (0x00020000uL)
#define INTC_ICDICER3_IV4_VBUFERR1              (0x00040000uL)
#define INTC_ICDICER3_S1_WLINE1                 (0x00080000uL)
#define INTC_ICDICER3_OIR_VI_VSYNC1             (0x00100000uL)
#define INTC_ICDICER3_OIR_LO_VSYNC1             (0x00200000uL)
#define INTC_ICDICER3_OIR_VLINE1                (0x00400000uL)
#define INTC_ICDICER3_OIR_VFIELD1               (0x00800000uL)
#define INTC_ICDICER3_IV7_VBUFERR1              (0x01000000uL)
#define INTC_ICDICER3_IV8_VBUFERR1              (0x02000000uL)
#define INTC_ICDICER3_OIR_WLINE1                (0x04000000uL)
#define INTC_ICDICER3_IMRDI                     (0x08000000uL)
#define INTC_ICDICER3_IMR2I0                    (0x10000000uL)
#define INTC_ICDICER3_IMR2I1                    (0x20000000uL)
#define INTC_ICDICER3_JEDI                      (0x40000000uL)
#define INTC_ICDICER3_JDTI                      (0x80000000uL)

#define INTC_ICDICER4_CMP0                      (0x00000001uL)
#define INTC_ICDICER4_CMP1                      (0x00000002uL)
#define INTC_ICDICER4_INT0                      (0x00000004uL)
#define INTC_ICDICER4_INT1                      (0x00000008uL)
#define INTC_ICDICER4_INT2                      (0x00000010uL)
#define INTC_ICDICER4_INT3                      (0x00000020uL)
#define INTC_ICDICER4_OSTM0TINT                 (0x00000040uL)
#define INTC_ICDICER4_OSTM1TINT                 (0x00000080uL)
#define INTC_ICDICER4_CMI                       (0x00000100uL)
#define INTC_ICDICER4_WTOUT                     (0x00000200uL)
#define INTC_ICDICER4_ITI                       (0x00000400uL)
#define INTC_ICDICER4_TGI0A                     (0x00000800uL)
#define INTC_ICDICER4_TGI0B                     (0x00001000uL)
#define INTC_ICDICER4_TGI0C                     (0x00002000uL)
#define INTC_ICDICER4_TGI0D                     (0x00004000uL)
#define INTC_ICDICER4_TGI0V                     (0x00008000uL)
#define INTC_ICDICER4_TGI0E                     (0x00010000uL)
#define INTC_ICDICER4_TGI0F                     (0x00020000uL)
#define INTC_ICDICER4_TGI1A                     (0x00040000uL)
#define INTC_ICDICER4_TGI1B                     (0x00080000uL)
#define INTC_ICDICER4_TGI1V                     (0x00100000uL)
#define INTC_ICDICER4_TGI1U                     (0x00200000uL)
#define INTC_ICDICER4_TGI2A                     (0x00400000uL)
#define INTC_ICDICER4_TGI2B                     (0x00800000uL)
#define INTC_ICDICER4_TGI2V                     (0x01000000uL)
#define INTC_ICDICER4_TGI2U                     (0x02000000uL)
#define INTC_ICDICER4_TGI3A                     (0x04000000uL)
#define INTC_ICDICER4_TGI3B                     (0x08000000uL)
#define INTC_ICDICER4_TGI3C                     (0x10000000uL)
#define INTC_ICDICER4_TGI3D                     (0x20000000uL)
#define INTC_ICDICER4_TGI3V                     (0x40000000uL)
#define INTC_ICDICER4_TGI4A                     (0x80000000uL)

#define INTC_ICDICER5_TGI4B                     (0x00000001uL)
#define INTC_ICDICER5_TGI4C                     (0x00000002uL)
#define INTC_ICDICER5_TGI4D                     (0x00000004uL)
#define INTC_ICDICER5_TGI4V                     (0x00000008uL)
#define INTC_ICDICER5_CMI1                      (0x00000010uL)
#define INTC_ICDICER5_CMI2                      (0x00000020uL)
#define INTC_ICDICER5_SGDEI0                    (0x00000040uL)
#define INTC_ICDICER5_SGDEI1                    (0x00000080uL)
#define INTC_ICDICER5_SGDEI2                    (0x00000100uL)
#define INTC_ICDICER5_SGDEI3                    (0x00000200uL)
#define INTC_ICDICER5_ADI                       (0x00000400uL)
#define INTC_ICDICER5_LMTI                      (0x00000800uL)
#define INTC_ICDICER5_SSII0                     (0x00001000uL)
#define INTC_ICDICER5_SSIRXI0                   (0x00002000uL)
#define INTC_ICDICER5_SSITXI0                   (0x00004000uL)
#define INTC_ICDICER5_SSII1                     (0x00008000uL)
#define INTC_ICDICER5_SSIRXI1                   (0x00010000uL)
#define INTC_ICDICER5_SSITXI1                   (0x00020000uL)
#define INTC_ICDICER5_SSII2                     (0x00040000uL)
#define INTC_ICDICER5_SSIRTI2                   (0x00080000uL)
#define INTC_ICDICER5_SSII3                     (0x00100000uL)
#define INTC_ICDICER5_SSIRXI3                   (0x00200000uL)
#define INTC_ICDICER5_SSITXI3                   (0x00400000uL)
#define INTC_ICDICER5_SSII4                     (0x00800000uL)
#define INTC_ICDICER5_SSIRTI4                   (0x01000000uL)
#define INTC_ICDICER5_SSII5                     (0x02000000uL)
#define INTC_ICDICER5_SSIRXI5                   (0x04000000uL)
#define INTC_ICDICER5_SSITXI5                   (0x08000000uL)
#define INTC_ICDICER5_SPDIFI                    (0x10000000uL)
#define INTC_ICDICER5_INTIICTEI0                (0x20000000uL)
#define INTC_ICDICER5_INTIICRI0                 (0x40000000uL)
#define INTC_ICDICER5_INTIICTI0                 (0x80000000uL)

#define INTC_ICDICER6_INTIICSPI0                (0x00000001uL)
#define INTC_ICDICER6_INTIICSTI0                (0x00000002uL)
#define INTC_ICDICER6_INTIICNAKI0               (0x00000004uL)
#define INTC_ICDICER6_INTIICALI0                (0x00000008uL)
#define INTC_ICDICER6_INTIICTMOI0               (0x00000010uL)
#define INTC_ICDICER6_INTIICTEI1                (0x00000020uL)
#define INTC_ICDICER6_INTIICRI1                 (0x00000040uL)
#define INTC_ICDICER6_INTIICTI1                 (0x00000080uL)
#define INTC_ICDICER6_INTIICSPI1                (0x00000100uL)
#define INTC_ICDICER6_INTIICSTI1                (0x00000200uL)
#define INTC_ICDICER6_INTIICNAKI1               (0x00000400uL)
#define INTC_ICDICER6_INTIICALI1                (0x00000800uL)
#define INTC_ICDICER6_INTIICTMOI1               (0x00001000uL)
#define INTC_ICDICER6_INTIICTEI2                (0x00002000uL)
#define INTC_ICDICER6_INTIICRI2                 (0x00004000uL)
#define INTC_ICDICER6_INTIICTI2                 (0x00008000uL)
#define INTC_ICDICER6_INTIICSPI2                (0x00010000uL)
#define INTC_ICDICER6_INTIICSTI2                (0x00020000uL)
#define INTC_ICDICER6_INTIICNAKI2               (0x00040000uL)
#define INTC_ICDICER6_INTIICALI2                (0x00080000uL)
#define INTC_ICDICER6_INTIICTMOI2               (0x00100000uL)
#define INTC_ICDICER6_INTIICTEI3                (0x00200000uL)
#define INTC_ICDICER6_INTIICRI3                 (0x00400000uL)
#define INTC_ICDICER6_INTIICTI3                 (0x00800000uL)
#define INTC_ICDICER6_INTIICSPI3                (0x01000000uL)
#define INTC_ICDICER6_INTIICSTI3                (0x02000000uL)
#define INTC_ICDICER6_INTIICNAKI3               (0x04000000uL)
#define INTC_ICDICER6_INTIICALI3                (0x08000000uL)
#define INTC_ICDICER6_INTIICTMOI3               (0x10000000uL)
#define INTC_ICDICER6_BRI0                      (0x20000000uL)
#define INTC_ICDICER6_ERI0                      (0x40000000uL)
#define INTC_ICDICER6_RXI0                      (0x80000000uL)

#define INTC_ICDICER7_TXI0                      (0x00000001uL)
#define INTC_ICDICER7_BRI1                      (0x00000002uL)
#define INTC_ICDICER7_ERI1                      (0x00000004uL)
#define INTC_ICDICER7_RXI1                      (0x00000008uL)
#define INTC_ICDICER7_TXI1                      (0x00000010uL)
#define INTC_ICDICER7_BRI2                      (0x00000020uL)
#define INTC_ICDICER7_ERI2                      (0x00000040uL)
#define INTC_ICDICER7_RXI2                      (0x00000080uL)
#define INTC_ICDICER7_TXI2                      (0x00000100uL)
#define INTC_ICDICER7_BRI3                      (0x00000200uL)
#define INTC_ICDICER7_ERI3                      (0x00000400uL)
#define INTC_ICDICER7_RXI3                      (0x00000800uL)
#define INTC_ICDICER7_TXI3                      (0x00001000uL)
#define INTC_ICDICER7_BRI4                      (0x00002000uL)
#define INTC_ICDICER7_ERI4                      (0x00004000uL)
#define INTC_ICDICER7_RXI4                      (0x00008000uL)
#define INTC_ICDICER7_TXI4                      (0x00010000uL)
#define INTC_ICDICER7_BRI5                      (0x00020000uL)
#define INTC_ICDICER7_ERI5                      (0x00040000uL)
#define INTC_ICDICER7_RXI5                      (0x00080000uL)
#define INTC_ICDICER7_TXI5                      (0x00100000uL)
#define INTC_ICDICER7_BRI6                      (0x00200000uL)
#define INTC_ICDICER7_ERI6                      (0x00400000uL)
#define INTC_ICDICER7_RXI6                      (0x00800000uL)
#define INTC_ICDICER7_TXI6                      (0x01000000uL)
#define INTC_ICDICER7_BRI7                      (0x02000000uL)
#define INTC_ICDICER7_ERI7                      (0x04000000uL)
#define INTC_ICDICER7_RXI7                      (0x08000000uL)
#define INTC_ICDICER7_TXI7                      (0x10000000uL)
#define INTC_ICDICER7_INTRCANGERR               (0x20000000uL)
#define INTC_ICDICER7_INTRCANGRECC              (0x40000000uL)
#define INTC_ICDICER7_INTRCAN0REC               (0x80000000uL)

#define INTC_ICDICER8_INTRCAN0ERR               (0x00000001uL)
#define INTC_ICDICER8_INTRCAN0TRX               (0x00000002uL)
#define INTC_ICDICER8_INTRCAN1REC               (0x00000004uL)
#define INTC_ICDICER8_INTRCAN1ERR               (0x00000008uL)
#define INTC_ICDICER8_INTRCAN1TRX               (0x00000010uL)
#define INTC_ICDICER8_INTRCAN2REC               (0x00000020uL)
#define INTC_ICDICER8_INTRCAN2ERR               (0x00000040uL)
#define INTC_ICDICER8_INTRCAN2TRX               (0x00000080uL)
#define INTC_ICDICER8_INTRCAN3REC               (0x00000100uL)
#define INTC_ICDICER8_INTRCAN3ERR               (0x00000200uL)
#define INTC_ICDICER8_INTRCAN3TRX               (0x00000400uL)
#define INTC_ICDICER8_INTRCAN4REC               (0x00000800uL)
#define INTC_ICDICER8_INTRCAN4ERR               (0x00001000uL)
#define INTC_ICDICER8_INTRCAN4TRX               (0x00002000uL)
#define INTC_ICDICER8_SPEI0                     (0x00004000uL)
#define INTC_ICDICER8_SPRI0                     (0x00008000uL)
#define INTC_ICDICER8_SPTI0                     (0x00010000uL)
#define INTC_ICDICER8_SPEI1                     (0x00020000uL)
#define INTC_ICDICER8_SPRI1                     (0x00040000uL)
#define INTC_ICDICER8_SPTI1                     (0x00080000uL)
#define INTC_ICDICER8_SPEI2                     (0x00100000uL)
#define INTC_ICDICER8_SPRI2                     (0x00200000uL)
#define INTC_ICDICER8_SPTI2                     (0x00400000uL)
#define INTC_ICDICER8_SPEI3                     (0x00800000uL)
#define INTC_ICDICER8_SPRI3                     (0x01000000uL)
#define INTC_ICDICER8_SPTI3                     (0x02000000uL)
#define INTC_ICDICER8_SPEI4                     (0x04000000uL)
#define INTC_ICDICER8_SPRI4                     (0x08000000uL)
#define INTC_ICDICER8_SPTI4                     (0x10000000uL)
#define INTC_ICDICER8_IEBBTD                    (0x20000000uL)
#define INTC_ICDICER8_IEBBTERR                  (0x40000000uL)
#define INTC_ICDICER8_IEBBTSTA                  (0x80000000uL)

#define INTC_ICDICER9_IEBBTV                    (0x00000001uL)
#define INTC_ICDICER9_ISY                       (0x00000002uL)
#define INTC_ICDICER9_IERR                      (0x00000004uL)
#define INTC_ICDICER9_ITARG                     (0x00000008uL)
#define INTC_ICDICER9_ISEC                      (0x00000010uL)
#define INTC_ICDICER9_IBUF                      (0x00000020uL)
#define INTC_ICDICER9_IREADY                    (0x00000040uL)
#define INTC_ICDICER9_FLSTE                     (0x00000080uL)
#define INTC_ICDICER9_FLTENDI                   (0x00000100uL)
#define INTC_ICDICER9_FLTREQ0I                  (0x00000200uL)
#define INTC_ICDICER9_FLTREQ1I                  (0x00000400uL)
#define INTC_ICDICER9_MMC0                      (0x00000800uL)
#define INTC_ICDICER9_MMC1                      (0x00001000uL)
#define INTC_ICDICER9_MMC2                      (0x00002000uL)
#define INTC_ICDICER9_SDHI0_3                   (0x00004000uL)
#define INTC_ICDICER9_SDHI0_0                   (0x00008000uL)
#define INTC_ICDICER9_SDHI0_1                   (0x00010000uL)
#define INTC_ICDICER9_SDHI1_3                   (0x00020000uL)
#define INTC_ICDICER9_SDHI1_0                   (0x00040000uL)
#define INTC_ICDICER9_SDHI1_1                   (0x00080000uL)
#define INTC_ICDICER9_ARM                       (0x00100000uL)
#define INTC_ICDICER9_PRD                       (0x00200000uL)
#define INTC_ICDICER9_CUP                       (0x00400000uL)
#define INTC_ICDICER9_SCUAI0                    (0x00800000uL)
#define INTC_ICDICER9_SCUAI1                    (0x01000000uL)
#define INTC_ICDICER9_SCUFDI0                   (0x02000000uL)
#define INTC_ICDICER9_SCUFDI1                   (0x04000000uL)
#define INTC_ICDICER9_SCUFDI2                   (0x08000000uL)
#define INTC_ICDICER9_SCUFDI3                   (0x10000000uL)
#define INTC_ICDICER9_SCUFUI0                   (0x20000000uL)
#define INTC_ICDICER9_SCUFUI1                   (0x40000000uL)
#define INTC_ICDICER9_SCUFUI2                   (0x80000000uL)

#define INTC_ICDICER10_SCUFUI3                  (0x00000001uL)
#define INTC_ICDICER10_SCUDVI0                  (0x00000002uL)
#define INTC_ICDICER10_SCUDVI1                  (0x00000004uL)
#define INTC_ICDICER10_SCUDVI2                  (0x00000008uL)
#define INTC_ICDICER10_SCUDVI3                  (0x00000010uL)
#define INTC_ICDICER10_MLB_CINT                 (0x00000020uL)
#define INTC_ICDICER10_MLB_SINT                 (0x00000040uL)
#define INTC_ICDICER10_DRC0                     (0x00000080uL)
#define INTC_ICDICER10_DRC1                     (0x00000100uL)
#define INTC_ICDICER10_LINI0_INT_T              (0x00000800uL)
#define INTC_ICDICER10_LINI0_INT_R              (0x00001000uL)
#define INTC_ICDICER10_LINI0_INT_S              (0x00002000uL)
#define INTC_ICDICER10_LINI0_INT_M              (0x00004000uL)
#define INTC_ICDICER10_LINI1_INT_T              (0x00008000uL)
#define INTC_ICDICER10_LINI1_INT_R              (0x00010000uL)
#define INTC_ICDICER10_LINI1_INT_S              (0x00020000uL)
#define INTC_ICDICER10_LINI1_INT_M              (0x00040000uL)
#define INTC_ICDICER10_ERI0                     (0x08000000uL)
#define INTC_ICDICER10_RXI0                     (0x10000000uL)
#define INTC_ICDICER10_TXI0                     (0x20000000uL)
#define INTC_ICDICER10_TEI0                     (0x40000000uL)
#define INTC_ICDICER10_ERI1                     (0x80000000uL)

#define INTC_ICDICER11_RXI1                     (0x00000001uL)
#define INTC_ICDICER11_TXI1                     (0x00000002uL)
#define INTC_ICDICER11_TEI1                     (0x00000004uL)
#define INTC_ICDICER11_AVBI_DATA                (0x00000008uL)
#define INTC_ICDICER11_AVBI_ERROR               (0x00000010uL)
#define INTC_ICDICER11_AVBI_MANAGE              (0x00000020uL)
#define INTC_ICDICER11_AVBI_MAC                 (0x00000040uL)
#define INTC_ICDICER11_ETHERI                   (0x00000080uL)
#define INTC_ICDICER11_CEUI                     (0x00001000uL)
#define INTC_ICDICER11_H2XMLB_ERRINT            (0x20000000uL)
#define INTC_ICDICER11_H2XIC1_ERRINT            (0x40000000uL)
#define INTC_ICDICER11_X2HPERI1_ERRINT          (0x80000000uL)

#define INTC_ICDICER12_X2HPERI2_ERRINT          (0x00000001uL)
#define INTC_ICDICER12_X2HPERI34_ERRINT         (0x00000002uL)
#define INTC_ICDICER12_X2HPERI5_ERRINT          (0x00000004uL)
#define INTC_ICDICER12_X2HPERI67_ERRINT         (0x00000008uL)
#define INTC_ICDICER12_X2HDBGR_ERRINT           (0x00000010uL)
#define INTC_ICDICER12_X2HBSC_ERRINT            (0x00000020uL)
#define INTC_ICDICER12_X2HSPI1_ERRINT           (0x00000040uL)
#define INTC_ICDICER12_X2HSPI2_ERRINT           (0x00000080uL)
#define INTC_ICDICER12_PRRI                     (0x00000100uL)
#define INTC_ICDICER12_IFEI0                    (0x00000200uL)
#define INTC_ICDICER12_OFFI0                    (0x00000400uL)
#define INTC_ICDICER12_PFVEI0                   (0x00000800uL)
#define INTC_ICDICER12_IFEI1                    (0x00001000uL)
#define INTC_ICDICER12_OFFI1                    (0x00002000uL)
#define INTC_ICDICER12_PFVEI1                   (0x00004000uL)

#define INTC_ICDICER13_TINT0                    (0x00000001uL)
#define INTC_ICDICER13_TINT1                    (0x00000002uL)
#define INTC_ICDICER13_TINT2                    (0x00000004uL)
#define INTC_ICDICER13_TINT3                    (0x00000008uL)
#define INTC_ICDICER13_TINT4                    (0x00000010uL)
#define INTC_ICDICER13_TINT5                    (0x00000020uL)
#define INTC_ICDICER13_TINT6                    (0x00000040uL)
#define INTC_ICDICER13_TINT7                    (0x00000080uL)
#define INTC_ICDICER13_TINT8                    (0x00000100uL)
#define INTC_ICDICER13_TINT9                    (0x00000200uL)
#define INTC_ICDICER13_TINT10                   (0x00000400uL)
#define INTC_ICDICER13_TINT11                   (0x00000800uL)
#define INTC_ICDICER13_TINT12                   (0x00001000uL)
#define INTC_ICDICER13_TINT13                   (0x00002000uL)
#define INTC_ICDICER13_TINT14                   (0x00004000uL)
#define INTC_ICDICER13_TINT15                   (0x00008000uL)
#define INTC_ICDICER13_TINT16                   (0x00010000uL)
#define INTC_ICDICER13_TINT17                   (0x00020000uL)
#define INTC_ICDICER13_TINT18                   (0x00040000uL)
#define INTC_ICDICER13_TINT19                   (0x00080000uL)
#define INTC_ICDICER13_TINT20                   (0x00100000uL)
#define INTC_ICDICER13_TINT21                   (0x00200000uL)
#define INTC_ICDICER13_TINT22                   (0x00400000uL)
#define INTC_ICDICER13_TINT23                   (0x00800000uL)
#define INTC_ICDICER13_TINT24                   (0x01000000uL)
#define INTC_ICDICER13_TINT25                   (0x02000000uL)
#define INTC_ICDICER13_TINT26                   (0x04000000uL)
#define INTC_ICDICER13_TINT27                   (0x08000000uL)
#define INTC_ICDICER13_TINT28                   (0x10000000uL)
#define INTC_ICDICER13_TINT29                   (0x20000000uL)
#define INTC_ICDICER13_TINT30                   (0x40000000uL)
#define INTC_ICDICER13_TINT31                   (0x80000000uL)

#define INTC_ICDICER14_TINT32                   (0x00000001uL)
#define INTC_ICDICER14_TINT33                   (0x00000002uL)
#define INTC_ICDICER14_TINT34                   (0x00000004uL)
#define INTC_ICDICER14_TINT35                   (0x00000008uL)
#define INTC_ICDICER14_TINT36                   (0x00000010uL)
#define INTC_ICDICER14_TINT37                   (0x00000020uL)
#define INTC_ICDICER14_TINT38                   (0x00000040uL)
#define INTC_ICDICER14_TINT39                   (0x00000080uL)
#define INTC_ICDICER14_TINT40                   (0x00000100uL)
#define INTC_ICDICER14_TINT41                   (0x00000200uL)
#define INTC_ICDICER14_TINT42                   (0x00000400uL)
#define INTC_ICDICER14_TINT43                   (0x00000800uL)
#define INTC_ICDICER14_TINT44                   (0x00001000uL)
#define INTC_ICDICER14_TINT45                   (0x00002000uL)
#define INTC_ICDICER14_TINT46                   (0x00004000uL)
#define INTC_ICDICER14_TINT47                   (0x00008000uL)
#define INTC_ICDICER14_TINT48                   (0x00010000uL)
#define INTC_ICDICER14_TINT49                   (0x00020000uL)
#define INTC_ICDICER14_TINT50                   (0x00040000uL)
#define INTC_ICDICER14_TINT51                   (0x00080000uL)
#define INTC_ICDICER14_TINT52                   (0x00100000uL)
#define INTC_ICDICER14_TINT53                   (0x00200000uL)
#define INTC_ICDICER14_TINT54                   (0x00400000uL)
#define INTC_ICDICER14_TINT55                   (0x00800000uL)
#define INTC_ICDICER14_TINT56                   (0x01000000uL)
#define INTC_ICDICER14_TINT57                   (0x02000000uL)
#define INTC_ICDICER14_TINT58                   (0x04000000uL)
#define INTC_ICDICER14_TINT59                   (0x08000000uL)
#define INTC_ICDICER14_TINT60                   (0x10000000uL)
#define INTC_ICDICER14_TINT61                   (0x20000000uL)
#define INTC_ICDICER14_TINT62                   (0x40000000uL)
#define INTC_ICDICER14_TINT63                   (0x80000000uL)

#define INTC_ICDICER15_TINT64                   (0x00000001uL)
#define INTC_ICDICER15_TINT65                   (0x00000002uL)
#define INTC_ICDICER15_TINT66                   (0x00000004uL)
#define INTC_ICDICER15_TINT67                   (0x00000008uL)
#define INTC_ICDICER15_TINT68                   (0x00000010uL)
#define INTC_ICDICER15_TINT69                   (0x00000020uL)
#define INTC_ICDICER15_TINT70                   (0x00000040uL)
#define INTC_ICDICER15_TINT71                   (0x00000080uL)
#define INTC_ICDICER15_TINT72                   (0x00000100uL)
#define INTC_ICDICER15_TINT73                   (0x00000200uL)
#define INTC_ICDICER15_TINT74                   (0x00000400uL)
#define INTC_ICDICER15_TINT75                   (0x00000800uL)
#define INTC_ICDICER15_TINT76                   (0x00001000uL)
#define INTC_ICDICER15_TINT77                   (0x00002000uL)
#define INTC_ICDICER15_TINT78                   (0x00004000uL)
#define INTC_ICDICER15_TINT79                   (0x00008000uL)
#define INTC_ICDICER15_TINT80                   (0x00010000uL)
#define INTC_ICDICER15_TINT81                   (0x00020000uL)
#define INTC_ICDICER15_TINT82                   (0x00040000uL)
#define INTC_ICDICER15_TINT83                   (0x00080000uL)
#define INTC_ICDICER15_TINT84                   (0x00100000uL)
#define INTC_ICDICER15_TINT85                   (0x00200000uL)
#define INTC_ICDICER15_TINT86                   (0x00400000uL)
#define INTC_ICDICER15_TINT87                   (0x00800000uL)
#define INTC_ICDICER15_TINT88                   (0x01000000uL)
#define INTC_ICDICER15_TINT89                   (0x02000000uL)
#define INTC_ICDICER15_TINT90                   (0x04000000uL)
#define INTC_ICDICER15_TINT91                   (0x08000000uL)
#define INTC_ICDICER15_TINT92                   (0x10000000uL)
#define INTC_ICDICER15_TINT93                   (0x20000000uL)
#define INTC_ICDICER15_TINT94                   (0x40000000uL)
#define INTC_ICDICER15_TINT95                   (0x80000000uL)

#define INTC_ICDICER16_TINT96                   (0x00000001uL)
#define INTC_ICDICER16_TINT97                   (0x00000002uL)
#define INTC_ICDICER16_TINT98                   (0x00000004uL)
#define INTC_ICDICER16_TINT99                   (0x00000008uL)
#define INTC_ICDICER16_TINT100                  (0x00000010uL)
#define INTC_ICDICER16_TINT101                  (0x00000020uL)
#define INTC_ICDICER16_TINT102                  (0x00000040uL)
#define INTC_ICDICER16_TINT103                  (0x00000080uL)
#define INTC_ICDICER16_TINT104                  (0x00000100uL)
#define INTC_ICDICER16_TINT105                  (0x00000200uL)
#define INTC_ICDICER16_TINT106                  (0x00000400uL)
#define INTC_ICDICER16_TINT107                  (0x00000800uL)
#define INTC_ICDICER16_TINT108                  (0x00001000uL)
#define INTC_ICDICER16_TINT109                  (0x00002000uL)
#define INTC_ICDICER16_TINT110                  (0x00004000uL)
#define INTC_ICDICER16_TINT111                  (0x00008000uL)
#define INTC_ICDICER16_TINT112                  (0x00010000uL)
#define INTC_ICDICER16_TINT113                  (0x00020000uL)
#define INTC_ICDICER16_TINT114                  (0x00040000uL)
#define INTC_ICDICER16_TINT115                  (0x00080000uL)
#define INTC_ICDICER16_TINT116                  (0x00100000uL)
#define INTC_ICDICER16_TINT117                  (0x00200000uL)
#define INTC_ICDICER16_TINT118                  (0x00400000uL)
#define INTC_ICDICER16_TINT119                  (0x00800000uL)
#define INTC_ICDICER16_TINT120                  (0x01000000uL)
#define INTC_ICDICER16_TINT121                  (0x02000000uL)
#define INTC_ICDICER16_TINT122                  (0x04000000uL)
#define INTC_ICDICER16_TINT123                  (0x08000000uL)
#define INTC_ICDICER16_TINT124                  (0x10000000uL)
#define INTC_ICDICER16_TINT125                  (0x20000000uL)
#define INTC_ICDICER16_TINT126                  (0x40000000uL)
#define INTC_ICDICER16_TINT127                  (0x80000000uL)

#define INTC_ICDICER17_TINT128                  (0x00000001uL)
#define INTC_ICDICER17_TINT129                  (0x00000002uL)
#define INTC_ICDICER17_TINT130                  (0x00000004uL)
#define INTC_ICDICER17_TINT131                  (0x00000008uL)
#define INTC_ICDICER17_TINT132                  (0x00000010uL)
#define INTC_ICDICER17_TINT133                  (0x00000020uL)
#define INTC_ICDICER17_TINT134                  (0x00000040uL)
#define INTC_ICDICER17_TINT135                  (0x00000080uL)
#define INTC_ICDICER17_TINT136                  (0x00000100uL)
#define INTC_ICDICER17_TINT137                  (0x00000200uL)
#define INTC_ICDICER17_TINT138                  (0x00000400uL)
#define INTC_ICDICER17_TINT139                  (0x00000800uL)
#define INTC_ICDICER17_TINT140                  (0x00001000uL)
#define INTC_ICDICER17_TINT141                  (0x00002000uL)
#define INTC_ICDICER17_TINT142                  (0x00004000uL)
#define INTC_ICDICER17_TINT143                  (0x00008000uL)
#define INTC_ICDICER17_TINT144                  (0x00010000uL)
#define INTC_ICDICER17_TINT145                  (0x00020000uL)
#define INTC_ICDICER17_TINT146                  (0x00040000uL)
#define INTC_ICDICER17_TINT147                  (0x00080000uL)
#define INTC_ICDICER17_TINT148                  (0x00100000uL)
#define INTC_ICDICER17_TINT149                  (0x00200000uL)
#define INTC_ICDICER17_TINT150                  (0x00400000uL)
#define INTC_ICDICER17_TINT151                  (0x00800000uL)
#define INTC_ICDICER17_TINT152                  (0x01000000uL)
#define INTC_ICDICER17_TINT153                  (0x02000000uL)
#define INTC_ICDICER17_TINT154                  (0x04000000uL)
#define INTC_ICDICER17_TINT155                  (0x08000000uL)
#define INTC_ICDICER17_TINT156                  (0x10000000uL)
#define INTC_ICDICER17_TINT157                  (0x20000000uL)
#define INTC_ICDICER17_TINT158                  (0x40000000uL)
#define INTC_ICDICER17_TINT159                  (0x80000000uL)

#define INTC_ICDICER18_TINT160                  (0x00000001uL)
#define INTC_ICDICER18_TINT161                  (0x00000002uL)
#define INTC_ICDICER18_TINT162                  (0x00000004uL)
#define INTC_ICDICER18_TINT163                  (0x00000008uL)
#define INTC_ICDICER18_TINT164                  (0x00000010uL)
#define INTC_ICDICER18_TINT165                  (0x00000020uL)
#define INTC_ICDICER18_TINT166                  (0x00000040uL)
#define INTC_ICDICER18_TINT167                  (0x00000080uL)
#define INTC_ICDICER18_TINT168                  (0x00000100uL)
#define INTC_ICDICER18_TINT169                  (0x00000200uL)
#define INTC_ICDICER18_TINT170                  (0x00000400uL)

#define INTC_ICDISPR0_SW0                       (0x00000001uL)
#define INTC_ICDISPR0_SW1                       (0x00000002uL)
#define INTC_ICDISPR0_SW2                       (0x00000004uL)
#define INTC_ICDISPR0_SW3                       (0x00000008uL)
#define INTC_ICDISPR0_SW4                       (0x00000010uL)
#define INTC_ICDISPR0_SW5                       (0x00000020uL)
#define INTC_ICDISPR0_SW6                       (0x00000040uL)
#define INTC_ICDISPR0_SW7                       (0x00000080uL)
#define INTC_ICDISPR0_SW8                       (0x00000100uL)
#define INTC_ICDISPR0_SW9                       (0x00000200uL)
#define INTC_ICDISPR0_SW10                      (0x00000400uL)
#define INTC_ICDISPR0_SW11                      (0x00000800uL)
#define INTC_ICDISPR0_SW12                      (0x00001000uL)
#define INTC_ICDISPR0_SW13                      (0x00002000uL)
#define INTC_ICDISPR0_SW14                      (0x00004000uL)
#define INTC_ICDISPR0_SW15                      (0x00008000uL)
#define INTC_ICDISPR0_PMUIRQ0                   (0x00010000uL)
#define INTC_ICDISPR0_COMMRX0                   (0x00020000uL)
#define INTC_ICDISPR0_COMMTX0                   (0x00040000uL)
#define INTC_ICDISPR0_CTIIRQ0                   (0x00080000uL)

#define INTC_ICDISPR1_IRQ0                      (0x00000001uL)
#define INTC_ICDISPR1_IRQ1                      (0x00000002uL)
#define INTC_ICDISPR1_IRQ2                      (0x00000004uL)
#define INTC_ICDISPR1_IRQ3                      (0x00000008uL)
#define INTC_ICDISPR1_IRQ4                      (0x00000010uL)
#define INTC_ICDISPR1_IRQ5                      (0x00000020uL)
#define INTC_ICDISPR1_IRQ6                      (0x00000040uL)
#define INTC_ICDISPR1_IRQ7                      (0x00000080uL)
#define INTC_ICDISPR1_PL310ERR                  (0x00000100uL)
#define INTC_ICDISPR1_DMAINT0                   (0x00000200uL)
#define INTC_ICDISPR1_DMAINT1                   (0x00000400uL)
#define INTC_ICDISPR1_DMAINT2                   (0x00000800uL)
#define INTC_ICDISPR1_DMAINT3                   (0x00001000uL)
#define INTC_ICDISPR1_DMAINT4                   (0x00002000uL)
#define INTC_ICDISPR1_DMAINT5                   (0x00004000uL)
#define INTC_ICDISPR1_DMAINT6                   (0x00008000uL)
#define INTC_ICDISPR1_DMAINT7                   (0x00010000uL)
#define INTC_ICDISPR1_DMAINT8                   (0x00020000uL)
#define INTC_ICDISPR1_DMAINT9                   (0x00040000uL)
#define INTC_ICDISPR1_DMAINT10                  (0x00080000uL)
#define INTC_ICDISPR1_DMAINT11                  (0x00100000uL)
#define INTC_ICDISPR1_DMAINT12                  (0x00200000uL)
#define INTC_ICDISPR1_DMAINT13                  (0x00400000uL)
#define INTC_ICDISPR1_DMAINT14                  (0x00800000uL)
#define INTC_ICDISPR1_DMAINT15                  (0x01000000uL)
#define INTC_ICDISPR1_DMAERR                    (0x02000000uL)

#define INTC_ICDISPR2_USBI0                     (0x00000200uL)
#define INTC_ICDISPR2_USBI1                     (0x00000400uL)
#define INTC_ICDISPR2_S0_VI_VSYNC0              (0x00000800uL)
#define INTC_ICDISPR2_S0_LO_VSYNC0              (0x00001000uL)
#define INTC_ICDISPR2_S0_VSYNCERR0              (0x00002000uL)
#define INTC_ICDISPR2_GR3_VLINE0                (0x00004000uL)
#define INTC_ICDISPR2_S0_VFIELD0                (0x00008000uL)
#define INTC_ICDISPR2_IV1_VBUFERR0              (0x00010000uL)
#define INTC_ICDISPR2_IV3_VBUFERR0              (0x00020000uL)
#define INTC_ICDISPR2_IV5_VBUFERR0              (0x00040000uL)
#define INTC_ICDISPR2_IV6_VBUFERR0              (0x00080000uL)
#define INTC_ICDISPR2_S0_WLINE0                 (0x00100000uL)
#define INTC_ICDISPR2_S1_VI_VSYNC0              (0x00200000uL)
#define INTC_ICDISPR2_S1_LO_VSYNC0              (0x00400000uL)
#define INTC_ICDISPR2_S1_VSYNCERR0              (0x00800000uL)
#define INTC_ICDISPR2_S1_VFIELD0                (0x01000000uL)
#define INTC_ICDISPR2_IV2_VBUFERR0              (0x02000000uL)
#define INTC_ICDISPR2_IV4_VBUFERR0              (0x04000000uL)
#define INTC_ICDISPR2_S1_WLINE0                 (0x08000000uL)
#define INTC_ICDISPR2_OIR_VI_VSYNC0             (0x10000000uL)
#define INTC_ICDISPR2_OIR_LO_VSYNC0             (0x20000000uL)
#define INTC_ICDISPR2_OIR_VSYNCERR0             (0x40000000uL)
#define INTC_ICDISPR2_OIR_VFIELD0               (0x80000000uL)

#define INTC_ICDISPR3_IV7_VBUFERR0              (0x00000001uL)
#define INTC_ICDISPR3_IV8_VBUFERR0              (0x00000002uL)
#define INTC_ICDISPR3_OIR_WLINE0                (0x00000004uL)
#define INTC_ICDISPR3_S0_VI_VSYNC1              (0x00000008uL)
#define INTC_ICDISPR3_S0_LO_VSYNC1              (0x00000010uL)
#define INTC_ICDISPR3_S0_VSYNCERR1              (0x00000020uL)
#define INTC_ICDISPR3_GR3_VLINE1                (0x00000040uL)
#define INTC_ICDISPR3_S0_VFIELD1                (0x00000080uL)
#define INTC_ICDISPR3_IV1_VBUFERR1              (0x00000100uL)
#define INTC_ICDISPR3_IV3_VBUFERR1              (0x00000200uL)
#define INTC_ICDISPR3_IV5_VBUFERR1              (0x00000400uL)
#define INTC_ICDISPR3_IV6_VBUFERR1              (0x00000800uL)
#define INTC_ICDISPR3_S0_WLINE1                 (0x00001000uL)
#define INTC_ICDISPR3_S1_VI_VSYNC1              (0x00002000uL)
#define INTC_ICDISPR3_S1_LO_VSYNC1              (0x00004000uL)
#define INTC_ICDISPR3_S1_VSYNCERR1              (0x00008000uL)
#define INTC_ICDISPR3_S1_VFIELD1                (0x00010000uL)
#define INTC_ICDISPR3_IV2_VBUFERR1              (0x00020000uL)
#define INTC_ICDISPR3_IV4_VBUFERR1              (0x00040000uL)
#define INTC_ICDISPR3_S1_WLINE1                 (0x00080000uL)
#define INTC_ICDISPR3_OIR_VI_VSYNC1             (0x00100000uL)
#define INTC_ICDISPR3_OIR_LO_VSYNC1             (0x00200000uL)
#define INTC_ICDISPR3_OIR_VLINE1                (0x00400000uL)
#define INTC_ICDISPR3_OIR_VFIELD1               (0x00800000uL)
#define INTC_ICDISPR3_IV7_VBUFERR1              (0x01000000uL)
#define INTC_ICDISPR3_IV8_VBUFERR1              (0x02000000uL)
#define INTC_ICDISPR3_OIR_WLINE1                (0x04000000uL)
#define INTC_ICDISPR3_IMRDI                     (0x08000000uL)
#define INTC_ICDISPR3_IMR2I0                    (0x10000000uL)
#define INTC_ICDISPR3_IMR2I1                    (0x20000000uL)
#define INTC_ICDISPR3_JEDI                      (0x40000000uL)
#define INTC_ICDISPR3_JDTI                      (0x80000000uL)

#define INTC_ICDISPR4_CMP0                      (0x00000001uL)
#define INTC_ICDISPR4_CMP1                      (0x00000002uL)
#define INTC_ICDISPR4_INT0                      (0x00000004uL)
#define INTC_ICDISPR4_INT1                      (0x00000008uL)
#define INTC_ICDISPR4_INT2                      (0x00000010uL)
#define INTC_ICDISPR4_INT3                      (0x00000020uL)
#define INTC_ICDISPR4_OSTM0TINT                 (0x00000040uL)
#define INTC_ICDISPR4_OSTM1TINT                 (0x00000080uL)
#define INTC_ICDISPR4_CMI                       (0x00000100uL)
#define INTC_ICDISPR4_WTOUT                     (0x00000200uL)
#define INTC_ICDISPR4_ITI                       (0x00000400uL)
#define INTC_ICDISPR4_TGI0A                     (0x00000800uL)
#define INTC_ICDISPR4_TGI0B                     (0x00001000uL)
#define INTC_ICDISPR4_TGI0C                     (0x00002000uL)
#define INTC_ICDISPR4_TGI0D                     (0x00004000uL)
#define INTC_ICDISPR4_TGI0V                     (0x00008000uL)
#define INTC_ICDISPR4_TGI0E                     (0x00010000uL)
#define INTC_ICDISPR4_TGI0F                     (0x00020000uL)
#define INTC_ICDISPR4_TGI1A                     (0x00040000uL)
#define INTC_ICDISPR4_TGI1B                     (0x00080000uL)
#define INTC_ICDISPR4_TGI1V                     (0x00100000uL)
#define INTC_ICDISPR4_TGI1U                     (0x00200000uL)
#define INTC_ICDISPR4_TGI2A                     (0x00400000uL)
#define INTC_ICDISPR4_TGI2B                     (0x00800000uL)
#define INTC_ICDISPR4_TGI2V                     (0x01000000uL)
#define INTC_ICDISPR4_TGI2U                     (0x02000000uL)
#define INTC_ICDISPR4_TGI3A                     (0x04000000uL)
#define INTC_ICDISPR4_TGI3B                     (0x08000000uL)
#define INTC_ICDISPR4_TGI3C                     (0x10000000uL)
#define INTC_ICDISPR4_TGI3D                     (0x20000000uL)
#define INTC_ICDISPR4_TGI3V                     (0x40000000uL)
#define INTC_ICDISPR4_TGI4A                     (0x80000000uL)

#define INTC_ICDISPR5_TGI4B                     (0x00000001uL)
#define INTC_ICDISPR5_TGI4C                     (0x00000002uL)
#define INTC_ICDISPR5_TGI4D                     (0x00000004uL)
#define INTC_ICDISPR5_TGI4V                     (0x00000008uL)
#define INTC_ICDISPR5_CMI1                      (0x00000010uL)
#define INTC_ICDISPR5_CMI2                      (0x00000020uL)
#define INTC_ICDISPR5_SGDEI0                    (0x00000040uL)
#define INTC_ICDISPR5_SGDEI1                    (0x00000080uL)
#define INTC_ICDISPR5_SGDEI2                    (0x00000100uL)
#define INTC_ICDISPR5_SGDEI3                    (0x00000200uL)
#define INTC_ICDISPR5_ADI                       (0x00000400uL)
#define INTC_ICDISPR5_LMTI                      (0x00000800uL)
#define INTC_ICDISPR5_SSII0                     (0x00001000uL)
#define INTC_ICDISPR5_SSIRXI0                   (0x00002000uL)
#define INTC_ICDISPR5_SSITXI0                   (0x00004000uL)
#define INTC_ICDISPR5_SSII1                     (0x00008000uL)
#define INTC_ICDISPR5_SSIRXI1                   (0x00010000uL)
#define INTC_ICDISPR5_SSITXI1                   (0x00020000uL)
#define INTC_ICDISPR5_SSII2                     (0x00040000uL)
#define INTC_ICDISPR5_SSIRTI2                   (0x00080000uL)
#define INTC_ICDISPR5_SSII3                     (0x00100000uL)
#define INTC_ICDISPR5_SSIRXI3                   (0x00200000uL)
#define INTC_ICDISPR5_SSITXI3                   (0x00400000uL)
#define INTC_ICDISPR5_SSII4                     (0x00800000uL)
#define INTC_ICDISPR5_SSIRTI4                   (0x01000000uL)
#define INTC_ICDISPR5_SSII5                     (0x02000000uL)
#define INTC_ICDISPR5_SSIRXI5                   (0x04000000uL)
#define INTC_ICDISPR5_SSITXI5                   (0x08000000uL)
#define INTC_ICDISPR5_SPDIFI                    (0x10000000uL)
#define INTC_ICDISPR5_INTIICTEI0                (0x20000000uL)
#define INTC_ICDISPR5_INTIICRI0                 (0x40000000uL)
#define INTC_ICDISPR5_INTIICTI0                 (0x80000000uL)

#define INTC_ICDISPR6_INTIICSPI0                (0x00000001uL)
#define INTC_ICDISPR6_INTIICSTI0                (0x00000002uL)
#define INTC_ICDISPR6_INTIICNAKI0               (0x00000004uL)
#define INTC_ICDISPR6_INTIICALI0                (0x00000008uL)
#define INTC_ICDISPR6_INTIICTMOI0               (0x00000010uL)
#define INTC_ICDISPR6_INTIICTEI1                (0x00000020uL)
#define INTC_ICDISPR6_INTIICRI1                 (0x00000040uL)
#define INTC_ICDISPR6_INTIICTI1                 (0x00000080uL)
#define INTC_ICDISPR6_INTIICSPI1                (0x00000100uL)
#define INTC_ICDISPR6_INTIICSTI1                (0x00000200uL)
#define INTC_ICDISPR6_INTIICNAKI1               (0x00000400uL)
#define INTC_ICDISPR6_INTIICALI1                (0x00000800uL)
#define INTC_ICDISPR6_INTIICTMOI1               (0x00001000uL)
#define INTC_ICDISPR6_INTIICTEI2                (0x00002000uL)
#define INTC_ICDISPR6_INTIICRI2                 (0x00004000uL)
#define INTC_ICDISPR6_INTIICTI2                 (0x00008000uL)
#define INTC_ICDISPR6_INTIICSPI2                (0x00010000uL)
#define INTC_ICDISPR6_INTIICSTI2                (0x00020000uL)
#define INTC_ICDISPR6_INTIICNAKI2               (0x00040000uL)
#define INTC_ICDISPR6_INTIICALI2                (0x00080000uL)
#define INTC_ICDISPR6_INTIICTMOI2               (0x00100000uL)
#define INTC_ICDISPR6_INTIICTEI3                (0x00200000uL)
#define INTC_ICDISPR6_INTIICRI3                 (0x00400000uL)
#define INTC_ICDISPR6_INTIICTI3                 (0x00800000uL)
#define INTC_ICDISPR6_INTIICSPI3                (0x01000000uL)
#define INTC_ICDISPR6_INTIICSTI3                (0x02000000uL)
#define INTC_ICDISPR6_INTIICNAKI3               (0x04000000uL)
#define INTC_ICDISPR6_INTIICALI3                (0x08000000uL)
#define INTC_ICDISPR6_INTIICTMOI3               (0x10000000uL)
#define INTC_ICDISPR6_BRI0                      (0x20000000uL)
#define INTC_ICDISPR6_ERI0                      (0x40000000uL)
#define INTC_ICDISPR6_RXI0                      (0x80000000uL)

#define INTC_ICDISPR7_TXI0                      (0x00000001uL)
#define INTC_ICDISPR7_BRI1                      (0x00000002uL)
#define INTC_ICDISPR7_ERI1                      (0x00000004uL)
#define INTC_ICDISPR7_RXI1                      (0x00000008uL)
#define INTC_ICDISPR7_TXI1                      (0x00000010uL)
#define INTC_ICDISPR7_BRI2                      (0x00000020uL)
#define INTC_ICDISPR7_ERI2                      (0x00000040uL)
#define INTC_ICDISPR7_RXI2                      (0x00000080uL)
#define INTC_ICDISPR7_TXI2                      (0x00000100uL)
#define INTC_ICDISPR7_BRI3                      (0x00000200uL)
#define INTC_ICDISPR7_ERI3                      (0x00000400uL)
#define INTC_ICDISPR7_RXI3                      (0x00000800uL)
#define INTC_ICDISPR7_TXI3                      (0x00001000uL)
#define INTC_ICDISPR7_BRI4                      (0x00002000uL)
#define INTC_ICDISPR7_ERI4                      (0x00004000uL)
#define INTC_ICDISPR7_RXI4                      (0x00008000uL)
#define INTC_ICDISPR7_TXI4                      (0x00010000uL)
#define INTC_ICDISPR7_BRI5                      (0x00020000uL)
#define INTC_ICDISPR7_ERI5                      (0x00040000uL)
#define INTC_ICDISPR7_RXI5                      (0x00080000uL)
#define INTC_ICDISPR7_TXI5                      (0x00100000uL)
#define INTC_ICDISPR7_BRI6                      (0x00200000uL)
#define INTC_ICDISPR7_ERI6                      (0x00400000uL)
#define INTC_ICDISPR7_RXI6                      (0x00800000uL)
#define INTC_ICDISPR7_TXI6                      (0x01000000uL)
#define INTC_ICDISPR7_BRI7                      (0x02000000uL)
#define INTC_ICDISPR7_ERI7                      (0x04000000uL)
#define INTC_ICDISPR7_RXI7                      (0x08000000uL)
#define INTC_ICDISPR7_TXI7                      (0x10000000uL)
#define INTC_ICDISPR7_INTRCANGERR               (0x20000000uL)
#define INTC_ICDISPR7_INTRCANGRECC              (0x40000000uL)
#define INTC_ICDISPR7_INTRCAN0REC               (0x80000000uL)

#define INTC_ICDISPR8_INTRCAN0ERR               (0x00000001uL)
#define INTC_ICDISPR8_INTRCAN0TRX               (0x00000002uL)
#define INTC_ICDISPR8_INTRCAN1REC               (0x00000004uL)
#define INTC_ICDISPR8_INTRCAN1ERR               (0x00000008uL)
#define INTC_ICDISPR8_INTRCAN1TRX               (0x00000010uL)
#define INTC_ICDISPR8_INTRCAN2REC               (0x00000020uL)
#define INTC_ICDISPR8_INTRCAN2ERR               (0x00000040uL)
#define INTC_ICDISPR8_INTRCAN2TRX               (0x00000080uL)
#define INTC_ICDISPR8_INTRCAN3REC               (0x00000100uL)
#define INTC_ICDISPR8_INTRCAN3ERR               (0x00000200uL)
#define INTC_ICDISPR8_INTRCAN3TRX               (0x00000400uL)
#define INTC_ICDISPR8_INTRCAN4REC               (0x00000800uL)
#define INTC_ICDISPR8_INTRCAN4ERR               (0x00001000uL)
#define INTC_ICDISPR8_INTRCAN4TRX               (0x00002000uL)
#define INTC_ICDISPR8_SPEI0                     (0x00004000uL)
#define INTC_ICDISPR8_SPRI0                     (0x00008000uL)
#define INTC_ICDISPR8_SPTI0                     (0x00010000uL)
#define INTC_ICDISPR8_SPEI1                     (0x00020000uL)
#define INTC_ICDISPR8_SPRI1                     (0x00040000uL)
#define INTC_ICDISPR8_SPTI1                     (0x00080000uL)
#define INTC_ICDISPR8_SPEI2                     (0x00100000uL)
#define INTC_ICDISPR8_SPRI2                     (0x00200000uL)
#define INTC_ICDISPR8_SPTI2                     (0x00400000uL)
#define INTC_ICDISPR8_SPEI3                     (0x00800000uL)
#define INTC_ICDISPR8_SPRI3                     (0x01000000uL)
#define INTC_ICDISPR8_SPTI3                     (0x02000000uL)
#define INTC_ICDISPR8_SPEI4                     (0x04000000uL)
#define INTC_ICDISPR8_SPRI4                     (0x08000000uL)
#define INTC_ICDISPR8_SPTI4                     (0x10000000uL)
#define INTC_ICDISPR8_IEBBTD                    (0x20000000uL)
#define INTC_ICDISPR8_IEBBTERR                  (0x40000000uL)
#define INTC_ICDISPR8_IEBBTSTA                  (0x80000000uL)

#define INTC_ICDISPR9_IEBBTV                    (0x00000001uL)
#define INTC_ICDISPR9_ISY                       (0x00000002uL)
#define INTC_ICDISPR9_IERR                      (0x00000004uL)
#define INTC_ICDISPR9_ITARG                     (0x00000008uL)
#define INTC_ICDISPR9_ISEC                      (0x00000010uL)
#define INTC_ICDISPR9_IBUF                      (0x00000020uL)
#define INTC_ICDISPR9_IREADY                    (0x00000040uL)
#define INTC_ICDISPR9_FLSTE                     (0x00000080uL)
#define INTC_ICDISPR9_FLTENDI                   (0x00000100uL)
#define INTC_ICDISPR9_FLTREQ0I                  (0x00000200uL)
#define INTC_ICDISPR9_FLTREQ1I                  (0x00000400uL)
#define INTC_ICDISPR9_MMC0                      (0x00000800uL)
#define INTC_ICDISPR9_MMC1                      (0x00001000uL)
#define INTC_ICDISPR9_MMC2                      (0x00002000uL)
#define INTC_ICDISPR9_SDHI0_3                   (0x00004000uL)
#define INTC_ICDISPR9_SDHI0_0                   (0x00008000uL)
#define INTC_ICDISPR9_SDHI0_1                   (0x00010000uL)
#define INTC_ICDISPR9_SDHI1_3                   (0x00020000uL)
#define INTC_ICDISPR9_SDHI1_0                   (0x00040000uL)
#define INTC_ICDISPR9_SDHI1_1                   (0x00080000uL)
#define INTC_ICDISPR9_ARM                       (0x00100000uL)
#define INTC_ICDISPR9_PRD                       (0x00200000uL)
#define INTC_ICDISPR9_CUP                       (0x00400000uL)
#define INTC_ICDISPR9_SCUAI0                    (0x00800000uL)
#define INTC_ICDISPR9_SCUAI1                    (0x01000000uL)
#define INTC_ICDISPR9_SCUFDI0                   (0x02000000uL)
#define INTC_ICDISPR9_SCUFDI1                   (0x04000000uL)
#define INTC_ICDISPR9_SCUFDI2                   (0x08000000uL)
#define INTC_ICDISPR9_SCUFDI3                   (0x10000000uL)
#define INTC_ICDISPR9_SCUFUI0                   (0x20000000uL)
#define INTC_ICDISPR9_SCUFUI1                   (0x40000000uL)
#define INTC_ICDISPR9_SCUFUI2                   (0x80000000uL)

#define INTC_ICDISPR10_SCUFUI3                  (0x00000001uL)
#define INTC_ICDISPR10_SCUDVI0                  (0x00000002uL)
#define INTC_ICDISPR10_SCUDVI1                  (0x00000004uL)
#define INTC_ICDISPR10_SCUDVI2                  (0x00000008uL)
#define INTC_ICDISPR10_SCUDVI3                  (0x00000010uL)
#define INTC_ICDISPR10_MLB_CINT                 (0x00000020uL)
#define INTC_ICDISPR10_MLB_SINT                 (0x00000040uL)
#define INTC_ICDISPR10_DRC0                     (0x00000080uL)
#define INTC_ICDISPR10_DRC1                     (0x00000100uL)
#define INTC_ICDISPR10_LINI0_INT_T              (0x00000800uL)
#define INTC_ICDISPR10_LINI0_INT_R              (0x00001000uL)
#define INTC_ICDISPR10_LINI0_INT_S              (0x00002000uL)
#define INTC_ICDISPR10_LINI0_INT_M              (0x00004000uL)
#define INTC_ICDISPR10_LINI1_INT_T              (0x00008000uL)
#define INTC_ICDISPR10_LINI1_INT_R              (0x00010000uL)
#define INTC_ICDISPR10_LINI1_INT_S              (0x00020000uL)
#define INTC_ICDISPR10_LINI1_INT_M              (0x00040000uL)
#define INTC_ICDISPR10_ERI0                     (0x08000000uL)
#define INTC_ICDISPR10_RXI0                     (0x10000000uL)
#define INTC_ICDISPR10_TXI0                     (0x20000000uL)
#define INTC_ICDISPR10_TEI0                     (0x40000000uL)
#define INTC_ICDISPR10_ERI1                     (0x80000000uL)

#define INTC_ICDISPR11_RXI1                     (0x00000001uL)
#define INTC_ICDISPR11_TXI1                     (0x00000002uL)
#define INTC_ICDISPR11_TEI1                     (0x00000004uL)
#define INTC_ICDISPR11_AVBI_DATA                (0x00000008uL)
#define INTC_ICDISPR11_AVBI_ERROR               (0x00000010uL)
#define INTC_ICDISPR11_AVBI_MANAGE              (0x00000020uL)
#define INTC_ICDISPR11_AVBI_MAC                 (0x00000040uL)
#define INTC_ICDISPR11_ETHERI                   (0x00000080uL)
#define INTC_ICDISPR11_CEUI                     (0x00001000uL)
#define INTC_ICDISPR11_H2XMLB_ERRINT            (0x20000000uL)
#define INTC_ICDISPR11_H2XIC1_ERRINT            (0x40000000uL)
#define INTC_ICDISPR11_X2HPERI1_ERRINT          (0x80000000uL)

#define INTC_ICDISPR12_X2HPERI2_ERRINT          (0x00000001uL)
#define INTC_ICDISPR12_X2HPERI34_ERRINT         (0x00000002uL)
#define INTC_ICDISPR12_X2HPERI5_ERRINT          (0x00000004uL)
#define INTC_ICDISPR12_X2HPERI67_ERRINT         (0x00000008uL)
#define INTC_ICDISPR12_X2HDBGR_ERRINT           (0x00000010uL)
#define INTC_ICDISPR12_X2HBSC_ERRINT            (0x00000020uL)
#define INTC_ICDISPR12_X2HSPI1_ERRINT           (0x00000040uL)
#define INTC_ICDISPR12_X2HSPI2_ERRINT           (0x00000080uL)
#define INTC_ICDISPR12_PRRI                     (0x00000100uL)
#define INTC_ICDISPR12_IFEI0                    (0x00000200uL)
#define INTC_ICDISPR12_OFFI0                    (0x00000400uL)
#define INTC_ICDISPR12_PFVEI0                   (0x00000800uL)
#define INTC_ICDISPR12_IFEI1                    (0x00001000uL)
#define INTC_ICDISPR12_OFFI1                    (0x00002000uL)
#define INTC_ICDISPR12_PFVEI1                   (0x00004000uL)

#define INTC_ICDISPR13_TINT0                    (0x00000001uL)
#define INTC_ICDISPR13_TINT1                    (0x00000002uL)
#define INTC_ICDISPR13_TINT2                    (0x00000004uL)
#define INTC_ICDISPR13_TINT3                    (0x00000008uL)
#define INTC_ICDISPR13_TINT4                    (0x00000010uL)
#define INTC_ICDISPR13_TINT5                    (0x00000020uL)
#define INTC_ICDISPR13_TINT6                    (0x00000040uL)
#define INTC_ICDISPR13_TINT7                    (0x00000080uL)
#define INTC_ICDISPR13_TINT8                    (0x00000100uL)
#define INTC_ICDISPR13_TINT9                    (0x00000200uL)
#define INTC_ICDISPR13_TINT10                   (0x00000400uL)
#define INTC_ICDISPR13_TINT11                   (0x00000800uL)
#define INTC_ICDISPR13_TINT12                   (0x00001000uL)
#define INTC_ICDISPR13_TINT13                   (0x00002000uL)
#define INTC_ICDISPR13_TINT14                   (0x00004000uL)
#define INTC_ICDISPR13_TINT15                   (0x00008000uL)
#define INTC_ICDISPR13_TINT16                   (0x00010000uL)
#define INTC_ICDISPR13_TINT17                   (0x00020000uL)
#define INTC_ICDISPR13_TINT18                   (0x00040000uL)
#define INTC_ICDISPR13_TINT19                   (0x00080000uL)
#define INTC_ICDISPR13_TINT20                   (0x00100000uL)
#define INTC_ICDISPR13_TINT21                   (0x00200000uL)
#define INTC_ICDISPR13_TINT22                   (0x00400000uL)
#define INTC_ICDISPR13_TINT23                   (0x00800000uL)
#define INTC_ICDISPR13_TINT24                   (0x01000000uL)
#define INTC_ICDISPR13_TINT25                   (0x02000000uL)
#define INTC_ICDISPR13_TINT26                   (0x04000000uL)
#define INTC_ICDISPR13_TINT27                   (0x08000000uL)
#define INTC_ICDISPR13_TINT28                   (0x10000000uL)
#define INTC_ICDISPR13_TINT29                   (0x20000000uL)
#define INTC_ICDISPR13_TINT30                   (0x40000000uL)
#define INTC_ICDISPR13_TINT31                   (0x80000000uL)

#define INTC_ICDISPR14_TINT32                   (0x00000001uL)
#define INTC_ICDISPR14_TINT33                   (0x00000002uL)
#define INTC_ICDISPR14_TINT34                   (0x00000004uL)
#define INTC_ICDISPR14_TINT35                   (0x00000008uL)
#define INTC_ICDISPR14_TINT36                   (0x00000010uL)
#define INTC_ICDISPR14_TINT37                   (0x00000020uL)
#define INTC_ICDISPR14_TINT38                   (0x00000040uL)
#define INTC_ICDISPR14_TINT39                   (0x00000080uL)
#define INTC_ICDISPR14_TINT40                   (0x00000100uL)
#define INTC_ICDISPR14_TINT41                   (0x00000200uL)
#define INTC_ICDISPR14_TINT42                   (0x00000400uL)
#define INTC_ICDISPR14_TINT43                   (0x00000800uL)
#define INTC_ICDISPR14_TINT44                   (0x00001000uL)
#define INTC_ICDISPR14_TINT45                   (0x00002000uL)
#define INTC_ICDISPR14_TINT46                   (0x00004000uL)
#define INTC_ICDISPR14_TINT47                   (0x00008000uL)
#define INTC_ICDISPR14_TINT48                   (0x00010000uL)
#define INTC_ICDISPR14_TINT49                   (0x00020000uL)
#define INTC_ICDISPR14_TINT50                   (0x00040000uL)
#define INTC_ICDISPR14_TINT51                   (0x00080000uL)
#define INTC_ICDISPR14_TINT52                   (0x00100000uL)
#define INTC_ICDISPR14_TINT53                   (0x00200000uL)
#define INTC_ICDISPR14_TINT54                   (0x00400000uL)
#define INTC_ICDISPR14_TINT55                   (0x00800000uL)
#define INTC_ICDISPR14_TINT56                   (0x01000000uL)
#define INTC_ICDISPR14_TINT57                   (0x02000000uL)
#define INTC_ICDISPR14_TINT58                   (0x04000000uL)
#define INTC_ICDISPR14_TINT59                   (0x08000000uL)
#define INTC_ICDISPR14_TINT60                   (0x10000000uL)
#define INTC_ICDISPR14_TINT61                   (0x20000000uL)
#define INTC_ICDISPR14_TINT62                   (0x40000000uL)
#define INTC_ICDISPR14_TINT63                   (0x80000000uL)

#define INTC_ICDISPR15_TINT64                   (0x00000001uL)
#define INTC_ICDISPR15_TINT65                   (0x00000002uL)
#define INTC_ICDISPR15_TINT66                   (0x00000004uL)
#define INTC_ICDISPR15_TINT67                   (0x00000008uL)
#define INTC_ICDISPR15_TINT68                   (0x00000010uL)
#define INTC_ICDISPR15_TINT69                   (0x00000020uL)
#define INTC_ICDISPR15_TINT70                   (0x00000040uL)
#define INTC_ICDISPR15_TINT71                   (0x00000080uL)
#define INTC_ICDISPR15_TINT72                   (0x00000100uL)
#define INTC_ICDISPR15_TINT73                   (0x00000200uL)
#define INTC_ICDISPR15_TINT74                   (0x00000400uL)
#define INTC_ICDISPR15_TINT75                   (0x00000800uL)
#define INTC_ICDISPR15_TINT76                   (0x00001000uL)
#define INTC_ICDISPR15_TINT77                   (0x00002000uL)
#define INTC_ICDISPR15_TINT78                   (0x00004000uL)
#define INTC_ICDISPR15_TINT79                   (0x00008000uL)
#define INTC_ICDISPR15_TINT80                   (0x00010000uL)
#define INTC_ICDISPR15_TINT81                   (0x00020000uL)
#define INTC_ICDISPR15_TINT82                   (0x00040000uL)
#define INTC_ICDISPR15_TINT83                   (0x00080000uL)
#define INTC_ICDISPR15_TINT84                   (0x00100000uL)
#define INTC_ICDISPR15_TINT85                   (0x00200000uL)
#define INTC_ICDISPR15_TINT86                   (0x00400000uL)
#define INTC_ICDISPR15_TINT87                   (0x00800000uL)
#define INTC_ICDISPR15_TINT88                   (0x01000000uL)
#define INTC_ICDISPR15_TINT89                   (0x02000000uL)
#define INTC_ICDISPR15_TINT90                   (0x04000000uL)
#define INTC_ICDISPR15_TINT91                   (0x08000000uL)
#define INTC_ICDISPR15_TINT92                   (0x10000000uL)
#define INTC_ICDISPR15_TINT93                   (0x20000000uL)
#define INTC_ICDISPR15_TINT94                   (0x40000000uL)
#define INTC_ICDISPR15_TINT95                   (0x80000000uL)

#define INTC_ICDISPR16_TINT96                   (0x00000001uL)
#define INTC_ICDISPR16_TINT97                   (0x00000002uL)
#define INTC_ICDISPR16_TINT98                   (0x00000004uL)
#define INTC_ICDISPR16_TINT99                   (0x00000008uL)
#define INTC_ICDISPR16_TINT100                  (0x00000010uL)
#define INTC_ICDISPR16_TINT101                  (0x00000020uL)
#define INTC_ICDISPR16_TINT102                  (0x00000040uL)
#define INTC_ICDISPR16_TINT103                  (0x00000080uL)
#define INTC_ICDISPR16_TINT104                  (0x00000100uL)
#define INTC_ICDISPR16_TINT105                  (0x00000200uL)
#define INTC_ICDISPR16_TINT106                  (0x00000400uL)
#define INTC_ICDISPR16_TINT107                  (0x00000800uL)
#define INTC_ICDISPR16_TINT108                  (0x00001000uL)
#define INTC_ICDISPR16_TINT109                  (0x00002000uL)
#define INTC_ICDISPR16_TINT110                  (0x00004000uL)
#define INTC_ICDISPR16_TINT111                  (0x00008000uL)
#define INTC_ICDISPR16_TINT112                  (0x00010000uL)
#define INTC_ICDISPR16_TINT113                  (0x00020000uL)
#define INTC_ICDISPR16_TINT114                  (0x00040000uL)
#define INTC_ICDISPR16_TINT115                  (0x00080000uL)
#define INTC_ICDISPR16_TINT116                  (0x00100000uL)
#define INTC_ICDISPR16_TINT117                  (0x00200000uL)
#define INTC_ICDISPR16_TINT118                  (0x00400000uL)
#define INTC_ICDISPR16_TINT119                  (0x00800000uL)
#define INTC_ICDISPR16_TINT120                  (0x01000000uL)
#define INTC_ICDISPR16_TINT121                  (0x02000000uL)
#define INTC_ICDISPR16_TINT122                  (0x04000000uL)
#define INTC_ICDISPR16_TINT123                  (0x08000000uL)
#define INTC_ICDISPR16_TINT124                  (0x10000000uL)
#define INTC_ICDISPR16_TINT125                  (0x20000000uL)
#define INTC_ICDISPR16_TINT126                  (0x40000000uL)
#define INTC_ICDISPR16_TINT127                  (0x80000000uL)

#define INTC_ICDISPR17_TINT128                  (0x00000001uL)
#define INTC_ICDISPR17_TINT129                  (0x00000002uL)
#define INTC_ICDISPR17_TINT130                  (0x00000004uL)
#define INTC_ICDISPR17_TINT131                  (0x00000008uL)
#define INTC_ICDISPR17_TINT132                  (0x00000010uL)
#define INTC_ICDISPR17_TINT133                  (0x00000020uL)
#define INTC_ICDISPR17_TINT134                  (0x00000040uL)
#define INTC_ICDISPR17_TINT135                  (0x00000080uL)
#define INTC_ICDISPR17_TINT136                  (0x00000100uL)
#define INTC_ICDISPR17_TINT137                  (0x00000200uL)
#define INTC_ICDISPR17_TINT138                  (0x00000400uL)
#define INTC_ICDISPR17_TINT139                  (0x00000800uL)
#define INTC_ICDISPR17_TINT140                  (0x00001000uL)
#define INTC_ICDISPR17_TINT141                  (0x00002000uL)
#define INTC_ICDISPR17_TINT142                  (0x00004000uL)
#define INTC_ICDISPR17_TINT143                  (0x00008000uL)
#define INTC_ICDISPR17_TINT144                  (0x00010000uL)
#define INTC_ICDISPR17_TINT145                  (0x00020000uL)
#define INTC_ICDISPR17_TINT146                  (0x00040000uL)
#define INTC_ICDISPR17_TINT147                  (0x00080000uL)
#define INTC_ICDISPR17_TINT148                  (0x00100000uL)
#define INTC_ICDISPR17_TINT149                  (0x00200000uL)
#define INTC_ICDISPR17_TINT150                  (0x00400000uL)
#define INTC_ICDISPR17_TINT151                  (0x00800000uL)
#define INTC_ICDISPR17_TINT152                  (0x01000000uL)
#define INTC_ICDISPR17_TINT153                  (0x02000000uL)
#define INTC_ICDISPR17_TINT154                  (0x04000000uL)
#define INTC_ICDISPR17_TINT155                  (0x08000000uL)
#define INTC_ICDISPR17_TINT156                  (0x10000000uL)
#define INTC_ICDISPR17_TINT157                  (0x20000000uL)
#define INTC_ICDISPR17_TINT158                  (0x40000000uL)
#define INTC_ICDISPR17_TINT159                  (0x80000000uL)

#define INTC_ICDISPR18_TINT160                  (0x00000001uL)
#define INTC_ICDISPR18_TINT161                  (0x00000002uL)
#define INTC_ICDISPR18_TINT162                  (0x00000004uL)
#define INTC_ICDISPR18_TINT163                  (0x00000008uL)
#define INTC_ICDISPR18_TINT164                  (0x00000010uL)
#define INTC_ICDISPR18_TINT165                  (0x00000020uL)
#define INTC_ICDISPR18_TINT166                  (0x00000040uL)
#define INTC_ICDISPR18_TINT167                  (0x00000080uL)
#define INTC_ICDISPR18_TINT168                  (0x00000100uL)
#define INTC_ICDISPR18_TINT169                  (0x00000200uL)
#define INTC_ICDISPR18_TINT170                  (0x00000400uL)

#define INTC_ICDICPR0_SW0                       (0x00000001uL)
#define INTC_ICDICPR0_SW1                       (0x00000002uL)
#define INTC_ICDICPR0_SW2                       (0x00000004uL)
#define INTC_ICDICPR0_SW3                       (0x00000008uL)
#define INTC_ICDICPR0_SW4                       (0x00000010uL)
#define INTC_ICDICPR0_SW5                       (0x00000020uL)
#define INTC_ICDICPR0_SW6                       (0x00000040uL)
#define INTC_ICDICPR0_SW7                       (0x00000080uL)
#define INTC_ICDICPR0_SW8                       (0x00000100uL)
#define INTC_ICDICPR0_SW9                       (0x00000200uL)
#define INTC_ICDICPR0_SW10                      (0x00000400uL)
#define INTC_ICDICPR0_SW11                      (0x00000800uL)
#define INTC_ICDICPR0_SW12                      (0x00001000uL)
#define INTC_ICDICPR0_SW13                      (0x00002000uL)
#define INTC_ICDICPR0_SW14                      (0x00004000uL)
#define INTC_ICDICPR0_SW15                      (0x00008000uL)
#define INTC_ICDICPR0_PMUIRQ0                   (0x00010000uL)
#define INTC_ICDICPR0_COMMRX0                   (0x00020000uL)
#define INTC_ICDICPR0_COMMTX0                   (0x00040000uL)
#define INTC_ICDICPR0_CTIIRQ0                   (0x00080000uL)

#define INTC_ICDICPR1_IRQ0                      (0x00000001uL)
#define INTC_ICDICPR1_IRQ1                      (0x00000002uL)
#define INTC_ICDICPR1_IRQ2                      (0x00000004uL)
#define INTC_ICDICPR1_IRQ3                      (0x00000008uL)
#define INTC_ICDICPR1_IRQ4                      (0x00000010uL)
#define INTC_ICDICPR1_IRQ5                      (0x00000020uL)
#define INTC_ICDICPR1_IRQ6                      (0x00000040uL)
#define INTC_ICDICPR1_IRQ7                      (0x00000080uL)
#define INTC_ICDICPR1_PL310ERR                  (0x00000100uL)
#define INTC_ICDICPR1_DMAINT0                   (0x00000200uL)
#define INTC_ICDICPR1_DMAINT1                   (0x00000400uL)
#define INTC_ICDICPR1_DMAINT2                   (0x00000800uL)
#define INTC_ICDICPR1_DMAINT3                   (0x00001000uL)
#define INTC_ICDICPR1_DMAINT4                   (0x00002000uL)
#define INTC_ICDICPR1_DMAINT5                   (0x00004000uL)
#define INTC_ICDICPR1_DMAINT6                   (0x00008000uL)
#define INTC_ICDICPR1_DMAINT7                   (0x00010000uL)
#define INTC_ICDICPR1_DMAINT8                   (0x00020000uL)
#define INTC_ICDICPR1_DMAINT9                   (0x00040000uL)
#define INTC_ICDICPR1_DMAINT10                  (0x00080000uL)
#define INTC_ICDICPR1_DMAINT11                  (0x00100000uL)
#define INTC_ICDICPR1_DMAINT12                  (0x00200000uL)
#define INTC_ICDICPR1_DMAINT13                  (0x00400000uL)
#define INTC_ICDICPR1_DMAINT14                  (0x00800000uL)
#define INTC_ICDICPR1_DMAINT15                  (0x01000000uL)
#define INTC_ICDICPR1_DMAERR                    (0x02000000uL)

#define INTC_ICDICPR2_USBI0                     (0x00000200uL)
#define INTC_ICDICPR2_USBI1                     (0x00000400uL)
#define INTC_ICDICPR2_S0_VI_VSYNC0              (0x00000800uL)
#define INTC_ICDICPR2_S0_LO_VSYNC0              (0x00001000uL)
#define INTC_ICDICPR2_S0_VSYNCERR0              (0x00002000uL)
#define INTC_ICDICPR2_GR3_VLINE0                (0x00004000uL)
#define INTC_ICDICPR2_S0_VFIELD0                (0x00008000uL)
#define INTC_ICDICPR2_IV1_VBUFERR0              (0x00010000uL)
#define INTC_ICDICPR2_IV3_VBUFERR0              (0x00020000uL)
#define INTC_ICDICPR2_IV5_VBUFERR0              (0x00040000uL)
#define INTC_ICDICPR2_IV6_VBUFERR0              (0x00080000uL)
#define INTC_ICDICPR2_S0_WLINE0                 (0x00100000uL)
#define INTC_ICDICPR2_S1_VI_VSYNC0              (0x00200000uL)
#define INTC_ICDICPR2_S1_LO_VSYNC0              (0x00400000uL)
#define INTC_ICDICPR2_S1_VSYNCERR0              (0x00800000uL)
#define INTC_ICDICPR2_S1_VFIELD0                (0x01000000uL)
#define INTC_ICDICPR2_IV2_VBUFERR0              (0x02000000uL)
#define INTC_ICDICPR2_IV4_VBUFERR0              (0x04000000uL)
#define INTC_ICDICPR2_S1_WLINE0                 (0x08000000uL)
#define INTC_ICDICPR2_OIR_VI_VSYNC0             (0x10000000uL)
#define INTC_ICDICPR2_OIR_LO_VSYNC0             (0x20000000uL)
#define INTC_ICDICPR2_OIR_VSYNCERR0             (0x40000000uL)
#define INTC_ICDICPR2_OIR_VFIELD0               (0x80000000uL)

#define INTC_ICDICPR3_IV7_VBUFERR0              (0x00000001uL)
#define INTC_ICDICPR3_IV8_VBUFERR0              (0x00000002uL)
#define INTC_ICDICPR3_OIR_WLINE0                (0x00000004uL)
#define INTC_ICDICPR3_S0_VI_VSYNC1              (0x00000008uL)
#define INTC_ICDICPR3_S0_LO_VSYNC1              (0x00000010uL)
#define INTC_ICDICPR3_S0_VSYNCERR1              (0x00000020uL)
#define INTC_ICDICPR3_GR3_VLINE1                (0x00000040uL)
#define INTC_ICDICPR3_S0_VFIELD1                (0x00000080uL)
#define INTC_ICDICPR3_IV1_VBUFERR1              (0x00000100uL)
#define INTC_ICDICPR3_IV3_VBUFERR1              (0x00000200uL)
#define INTC_ICDICPR3_IV5_VBUFERR1              (0x00000400uL)
#define INTC_ICDICPR3_IV6_VBUFERR1              (0x00000800uL)
#define INTC_ICDICPR3_S0_WLINE1                 (0x00001000uL)
#define INTC_ICDICPR3_S1_VI_VSYNC1              (0x00002000uL)
#define INTC_ICDICPR3_S1_LO_VSYNC1              (0x00004000uL)
#define INTC_ICDICPR3_S1_VSYNCERR1              (0x00008000uL)
#define INTC_ICDICPR3_S1_VFIELD1                (0x00010000uL)
#define INTC_ICDICPR3_IV2_VBUFERR1              (0x00020000uL)
#define INTC_ICDICPR3_IV4_VBUFERR1              (0x00040000uL)
#define INTC_ICDICPR3_S1_WLINE1                 (0x00080000uL)
#define INTC_ICDICPR3_OIR_VI_VSYNC1             (0x00100000uL)
#define INTC_ICDICPR3_OIR_LO_VSYNC1             (0x00200000uL)
#define INTC_ICDICPR3_OIR_VLINE1                (0x00400000uL)
#define INTC_ICDICPR3_OIR_VFIELD1               (0x00800000uL)
#define INTC_ICDICPR3_IV7_VBUFERR1              (0x01000000uL)
#define INTC_ICDICPR3_IV8_VBUFERR1              (0x02000000uL)
#define INTC_ICDICPR3_OIR_WLINE1                (0x04000000uL)
#define INTC_ICDICPR3_IMRDI                     (0x08000000uL)
#define INTC_ICDICPR3_IMR2I0                    (0x10000000uL)
#define INTC_ICDICPR3_IMR2I1                    (0x20000000uL)
#define INTC_ICDICPR3_JEDI                      (0x40000000uL)
#define INTC_ICDICPR3_JDTI                      (0x80000000uL)

#define INTC_ICDICPR4_CMP0                      (0x00000001uL)
#define INTC_ICDICPR4_CMP1                      (0x00000002uL)
#define INTC_ICDICPR4_INT0                      (0x00000004uL)
#define INTC_ICDICPR4_INT1                      (0x00000008uL)
#define INTC_ICDICPR4_INT2                      (0x00000010uL)
#define INTC_ICDICPR4_INT3                      (0x00000020uL)
#define INTC_ICDICPR4_OSTM0TINT                 (0x00000040uL)
#define INTC_ICDICPR4_OSTM1TINT                 (0x00000080uL)
#define INTC_ICDICPR4_CMI                       (0x00000100uL)
#define INTC_ICDICPR4_WTOUT                     (0x00000200uL)
#define INTC_ICDICPR4_ITI                       (0x00000400uL)
#define INTC_ICDICPR4_TGI0A                     (0x00000800uL)
#define INTC_ICDICPR4_TGI0B                     (0x00001000uL)
#define INTC_ICDICPR4_TGI0C                     (0x00002000uL)
#define INTC_ICDICPR4_TGI0D                     (0x00004000uL)
#define INTC_ICDICPR4_TGI0V                     (0x00008000uL)
#define INTC_ICDICPR4_TGI0E                     (0x00010000uL)
#define INTC_ICDICPR4_TGI0F                     (0x00020000uL)
#define INTC_ICDICPR4_TGI1A                     (0x00040000uL)
#define INTC_ICDICPR4_TGI1B                     (0x00080000uL)
#define INTC_ICDICPR4_TGI1V                     (0x00100000uL)
#define INTC_ICDICPR4_TGI1U                     (0x00200000uL)
#define INTC_ICDICPR4_TGI2A                     (0x00400000uL)
#define INTC_ICDICPR4_TGI2B                     (0x00800000uL)
#define INTC_ICDICPR4_TGI2V                     (0x01000000uL)
#define INTC_ICDICPR4_TGI2U                     (0x02000000uL)
#define INTC_ICDICPR4_TGI3A                     (0x04000000uL)
#define INTC_ICDICPR4_TGI3B                     (0x08000000uL)
#define INTC_ICDICPR4_TGI3C                     (0x10000000uL)
#define INTC_ICDICPR4_TGI3D                     (0x20000000uL)
#define INTC_ICDICPR4_TGI3V                     (0x40000000uL)
#define INTC_ICDICPR4_TGI4A                     (0x80000000uL)

#define INTC_ICDICPR5_TGI4B                     (0x00000001uL)
#define INTC_ICDICPR5_TGI4C                     (0x00000002uL)
#define INTC_ICDICPR5_TGI4D                     (0x00000004uL)
#define INTC_ICDICPR5_TGI4V                     (0x00000008uL)
#define INTC_ICDICPR5_CMI1                      (0x00000010uL)
#define INTC_ICDICPR5_CMI2                      (0x00000020uL)
#define INTC_ICDICPR5_SGDEI0                    (0x00000040uL)
#define INTC_ICDICPR5_SGDEI1                    (0x00000080uL)
#define INTC_ICDICPR5_SGDEI2                    (0x00000100uL)
#define INTC_ICDICPR5_SGDEI3                    (0x00000200uL)
#define INTC_ICDICPR5_ADI                       (0x00000400uL)
#define INTC_ICDICPR5_LMTI                      (0x00000800uL)
#define INTC_ICDICPR5_SSII0                     (0x00001000uL)
#define INTC_ICDICPR5_SSIRXI0                   (0x00002000uL)
#define INTC_ICDICPR5_SSITXI0                   (0x00004000uL)
#define INTC_ICDICPR5_SSII1                     (0x00008000uL)
#define INTC_ICDICPR5_SSIRXI1                   (0x00010000uL)
#define INTC_ICDICPR5_SSITXI1                   (0x00020000uL)
#define INTC_ICDICPR5_SSII2                     (0x00040000uL)
#define INTC_ICDICPR5_SSIRTI2                   (0x00080000uL)
#define INTC_ICDICPR5_SSII3                     (0x00100000uL)
#define INTC_ICDICPR5_SSIRXI3                   (0x00200000uL)
#define INTC_ICDICPR5_SSITXI3                   (0x00400000uL)
#define INTC_ICDICPR5_SSII4                     (0x00800000uL)
#define INTC_ICDICPR5_SSIRTI4                   (0x01000000uL)
#define INTC_ICDICPR5_SSII5                     (0x02000000uL)
#define INTC_ICDICPR5_SSIRXI5                   (0x04000000uL)
#define INTC_ICDICPR5_SSITXI5                   (0x08000000uL)
#define INTC_ICDICPR5_SPDIFI                    (0x10000000uL)
#define INTC_ICDICPR5_INTIICTEI0                (0x20000000uL)
#define INTC_ICDICPR5_INTIICRI0                 (0x40000000uL)
#define INTC_ICDICPR5_INTIICTI0                 (0x80000000uL)

#define INTC_ICDICPR6_INTIICSPI0                (0x00000001uL)
#define INTC_ICDICPR6_INTIICSTI0                (0x00000002uL)
#define INTC_ICDICPR6_INTIICNAKI0               (0x00000004uL)
#define INTC_ICDICPR6_INTIICALI0                (0x00000008uL)
#define INTC_ICDICPR6_INTIICTMOI0               (0x00000010uL)
#define INTC_ICDICPR6_INTIICTEI1                (0x00000020uL)
#define INTC_ICDICPR6_INTIICRI1                 (0x00000040uL)
#define INTC_ICDICPR6_INTIICTI1                 (0x00000080uL)
#define INTC_ICDICPR6_INTIICSPI1                (0x00000100uL)
#define INTC_ICDICPR6_INTIICSTI1                (0x00000200uL)
#define INTC_ICDICPR6_INTIICNAKI1               (0x00000400uL)
#define INTC_ICDICPR6_INTIICALI1                (0x00000800uL)
#define INTC_ICDICPR6_INTIICTMOI1               (0x00001000uL)
#define INTC_ICDICPR6_INTIICTEI2                (0x00002000uL)
#define INTC_ICDICPR6_INTIICRI2                 (0x00004000uL)
#define INTC_ICDICPR6_INTIICTI2                 (0x00008000uL)
#define INTC_ICDICPR6_INTIICSPI2                (0x00010000uL)
#define INTC_ICDICPR6_INTIICSTI2                (0x00020000uL)
#define INTC_ICDICPR6_INTIICNAKI2               (0x00040000uL)
#define INTC_ICDICPR6_INTIICALI2                (0x00080000uL)
#define INTC_ICDICPR6_INTIICTMOI2               (0x00100000uL)
#define INTC_ICDICPR6_INTIICTEI3                (0x00200000uL)
#define INTC_ICDICPR6_INTIICRI3                 (0x00400000uL)
#define INTC_ICDICPR6_INTIICTI3                 (0x00800000uL)
#define INTC_ICDICPR6_INTIICSPI3                (0x01000000uL)
#define INTC_ICDICPR6_INTIICSTI3                (0x02000000uL)
#define INTC_ICDICPR6_INTIICNAKI3               (0x04000000uL)
#define INTC_ICDICPR6_INTIICALI3                (0x08000000uL)
#define INTC_ICDICPR6_INTIICTMOI3               (0x10000000uL)
#define INTC_ICDICPR6_BRI0                      (0x20000000uL)
#define INTC_ICDICPR6_ERI0                      (0x40000000uL)
#define INTC_ICDICPR6_RXI0                      (0x80000000uL)

#define INTC_ICDICPR7_TXI0                      (0x00000001uL)
#define INTC_ICDICPR7_BRI1                      (0x00000002uL)
#define INTC_ICDICPR7_ERI1                      (0x00000004uL)
#define INTC_ICDICPR7_RXI1                      (0x00000008uL)
#define INTC_ICDICPR7_TXI1                      (0x00000010uL)
#define INTC_ICDICPR7_BRI2                      (0x00000020uL)
#define INTC_ICDICPR7_ERI2                      (0x00000040uL)
#define INTC_ICDICPR7_RXI2                      (0x00000080uL)
#define INTC_ICDICPR7_TXI2                      (0x00000100uL)
#define INTC_ICDICPR7_BRI3                      (0x00000200uL)
#define INTC_ICDICPR7_ERI3                      (0x00000400uL)
#define INTC_ICDICPR7_RXI3                      (0x00000800uL)
#define INTC_ICDICPR7_TXI3                      (0x00001000uL)
#define INTC_ICDICPR7_BRI4                      (0x00002000uL)
#define INTC_ICDICPR7_ERI4                      (0x00004000uL)
#define INTC_ICDICPR7_RXI4                      (0x00008000uL)
#define INTC_ICDICPR7_TXI4                      (0x00010000uL)
#define INTC_ICDICPR7_BRI5                      (0x00020000uL)
#define INTC_ICDICPR7_ERI5                      (0x00040000uL)
#define INTC_ICDICPR7_RXI5                      (0x00080000uL)
#define INTC_ICDICPR7_TXI5                      (0x00100000uL)
#define INTC_ICDICPR7_BRI6                      (0x00200000uL)
#define INTC_ICDICPR7_ERI6                      (0x00400000uL)
#define INTC_ICDICPR7_RXI6                      (0x00800000uL)
#define INTC_ICDICPR7_TXI6                      (0x01000000uL)
#define INTC_ICDICPR7_BRI7                      (0x02000000uL)
#define INTC_ICDICPR7_ERI7                      (0x04000000uL)
#define INTC_ICDICPR7_RXI7                      (0x08000000uL)
#define INTC_ICDICPR7_TXI7                      (0x10000000uL)
#define INTC_ICDICPR7_INTRCANGERR               (0x20000000uL)
#define INTC_ICDICPR7_INTRCANGRECC              (0x40000000uL)
#define INTC_ICDICPR7_INTRCAN0REC               (0x80000000uL)

#define INTC_ICDICPR8_INTRCAN0ERR               (0x00000001uL)
#define INTC_ICDICPR8_INTRCAN0TRX               (0x00000002uL)
#define INTC_ICDICPR8_INTRCAN1REC               (0x00000004uL)
#define INTC_ICDICPR8_INTRCAN1ERR               (0x00000008uL)
#define INTC_ICDICPR8_INTRCAN1TRX               (0x00000010uL)
#define INTC_ICDICPR8_INTRCAN2REC               (0x00000020uL)
#define INTC_ICDICPR8_INTRCAN2ERR               (0x00000040uL)
#define INTC_ICDICPR8_INTRCAN2TRX               (0x00000080uL)
#define INTC_ICDICPR8_INTRCAN3REC               (0x00000100uL)
#define INTC_ICDICPR8_INTRCAN3ERR               (0x00000200uL)
#define INTC_ICDICPR8_INTRCAN3TRX               (0x00000400uL)
#define INTC_ICDICPR8_INTRCAN4REC               (0x00000800uL)
#define INTC_ICDICPR8_INTRCAN4ERR               (0x00001000uL)
#define INTC_ICDICPR8_INTRCAN4TRX               (0x00002000uL)
#define INTC_ICDICPR8_SPEI0                     (0x00004000uL)
#define INTC_ICDICPR8_SPRI0                     (0x00008000uL)
#define INTC_ICDICPR8_SPTI0                     (0x00010000uL)
#define INTC_ICDICPR8_SPEI1                     (0x00020000uL)
#define INTC_ICDICPR8_SPRI1                     (0x00040000uL)
#define INTC_ICDICPR8_SPTI1                     (0x00080000uL)
#define INTC_ICDICPR8_SPEI2                     (0x00100000uL)
#define INTC_ICDICPR8_SPRI2                     (0x00200000uL)
#define INTC_ICDICPR8_SPTI2                     (0x00400000uL)
#define INTC_ICDICPR8_SPEI3                     (0x00800000uL)
#define INTC_ICDICPR8_SPRI3                     (0x01000000uL)
#define INTC_ICDICPR8_SPTI3                     (0x02000000uL)
#define INTC_ICDICPR8_SPEI4                     (0x04000000uL)
#define INTC_ICDICPR8_SPRI4                     (0x08000000uL)
#define INTC_ICDICPR8_SPTI4                     (0x10000000uL)
#define INTC_ICDICPR8_IEBBTD                    (0x20000000uL)
#define INTC_ICDICPR8_IEBBTERR                  (0x40000000uL)
#define INTC_ICDICPR8_IEBBTSTA                  (0x80000000uL)

#define INTC_ICDICPR9_IEBBTV                    (0x00000001uL)
#define INTC_ICDICPR9_ISY                       (0x00000002uL)
#define INTC_ICDICPR9_IERR                      (0x00000004uL)
#define INTC_ICDICPR9_ITARG                     (0x00000008uL)
#define INTC_ICDICPR9_ISEC                      (0x00000010uL)
#define INTC_ICDICPR9_IBUF                      (0x00000020uL)
#define INTC_ICDICPR9_IREADY                    (0x00000040uL)
#define INTC_ICDICPR9_FLSTE                     (0x00000080uL)
#define INTC_ICDICPR9_FLTENDI                   (0x00000100uL)
#define INTC_ICDICPR9_FLTREQ0I                  (0x00000200uL)
#define INTC_ICDICPR9_FLTREQ1I                  (0x00000400uL)
#define INTC_ICDICPR9_MMC0                      (0x00000800uL)
#define INTC_ICDICPR9_MMC1                      (0x00001000uL)
#define INTC_ICDICPR9_MMC2                      (0x00002000uL)
#define INTC_ICDICPR9_SDHI0_3                   (0x00004000uL)
#define INTC_ICDICPR9_SDHI0_0                   (0x00008000uL)
#define INTC_ICDICPR9_SDHI0_1                   (0x00010000uL)
#define INTC_ICDICPR9_SDHI1_3                   (0x00020000uL)
#define INTC_ICDICPR9_SDHI1_0                   (0x00040000uL)
#define INTC_ICDICPR9_SDHI1_1                   (0x00080000uL)
#define INTC_ICDICPR9_ARM                       (0x00100000uL)
#define INTC_ICDICPR9_PRD                       (0x00200000uL)
#define INTC_ICDICPR9_CUP                       (0x00400000uL)
#define INTC_ICDICPR9_SCUAI0                    (0x00800000uL)
#define INTC_ICDICPR9_SCUAI1                    (0x01000000uL)
#define INTC_ICDICPR9_SCUFDI0                   (0x02000000uL)
#define INTC_ICDICPR9_SCUFDI1                   (0x04000000uL)
#define INTC_ICDICPR9_SCUFDI2                   (0x08000000uL)
#define INTC_ICDICPR9_SCUFDI3                   (0x10000000uL)
#define INTC_ICDICPR9_SCUFUI0                   (0x20000000uL)
#define INTC_ICDICPR9_SCUFUI1                   (0x40000000uL)
#define INTC_ICDICPR9_SCUFUI2                   (0x80000000uL)

#define INTC_ICDICPR10_SCUFUI3                  (0x00000001uL)
#define INTC_ICDICPR10_SCUDVI0                  (0x00000002uL)
#define INTC_ICDICPR10_SCUDVI1                  (0x00000004uL)
#define INTC_ICDICPR10_SCUDVI2                  (0x00000008uL)
#define INTC_ICDICPR10_SCUDVI3                  (0x00000010uL)
#define INTC_ICDICPR10_MLB_CINT                 (0x00000020uL)
#define INTC_ICDICPR10_MLB_SINT                 (0x00000040uL)
#define INTC_ICDICPR10_DRC0                     (0x00000080uL)
#define INTC_ICDICPR10_DRC1                     (0x00000100uL)
#define INTC_ICDICPR10_LINI0_INT_T              (0x00000800uL)
#define INTC_ICDICPR10_LINI0_INT_R              (0x00001000uL)
#define INTC_ICDICPR10_LINI0_INT_S              (0x00002000uL)
#define INTC_ICDICPR10_LINI0_INT_M              (0x00004000uL)
#define INTC_ICDICPR10_LINI1_INT_T              (0x00008000uL)
#define INTC_ICDICPR10_LINI1_INT_R              (0x00010000uL)
#define INTC_ICDICPR10_LINI1_INT_S              (0x00020000uL)
#define INTC_ICDICPR10_LINI1_INT_M              (0x00040000uL)
#define INTC_ICDICPR10_ERI0                     (0x08000000uL)
#define INTC_ICDICPR10_RXI0                     (0x10000000uL)
#define INTC_ICDICPR10_TXI0                     (0x20000000uL)
#define INTC_ICDICPR10_TEI0                     (0x40000000uL)
#define INTC_ICDICPR10_ERI1                     (0x80000000uL)

#define INTC_ICDICPR11_RXI1                     (0x00000001uL)
#define INTC_ICDICPR11_TXI1                     (0x00000002uL)
#define INTC_ICDICPR11_TEI1                     (0x00000004uL)
#define INTC_ICDICPR11_AVBI_DATA                (0x00000008uL)
#define INTC_ICDICPR11_AVBI_ERROR               (0x00000010uL)
#define INTC_ICDICPR11_AVBI_MANAGE              (0x00000020uL)
#define INTC_ICDICPR11_AVBI_MAC                 (0x00000040uL)
#define INTC_ICDICPR11_ETHERI                   (0x00000080uL)
#define INTC_ICDICPR11_CEUI                     (0x00001000uL)
#define INTC_ICDICPR11_H2XMLB_ERRINT            (0x20000000uL)
#define INTC_ICDICPR11_H2XIC1_ERRINT            (0x40000000uL)
#define INTC_ICDICPR11_X2HPERI1_ERRINT          (0x80000000uL)

#define INTC_ICDICPR12_X2HPERI2_ERRINT          (0x00000001uL)
#define INTC_ICDICPR12_X2HPERI34_ERRINT         (0x00000002uL)
#define INTC_ICDICPR12_X2HPERI5_ERRINT          (0x00000004uL)
#define INTC_ICDICPR12_X2HPERI67_ERRINT         (0x00000008uL)
#define INTC_ICDICPR12_X2HDBGR_ERRINT           (0x00000010uL)
#define INTC_ICDICPR12_X2HBSC_ERRINT            (0x00000020uL)
#define INTC_ICDICPR12_X2HSPI1_ERRINT           (0x00000040uL)
#define INTC_ICDICPR12_X2HSPI2_ERRINT           (0x00000080uL)
#define INTC_ICDICPR12_PRRI                     (0x00000100uL)
#define INTC_ICDICPR12_IFEI0                    (0x00000200uL)
#define INTC_ICDICPR12_OFFI0                    (0x00000400uL)
#define INTC_ICDICPR12_PFVEI0                   (0x00000800uL)
#define INTC_ICDICPR12_IFEI1                    (0x00001000uL)
#define INTC_ICDICPR12_OFFI1                    (0x00002000uL)
#define INTC_ICDICPR12_PFVEI1                   (0x00004000uL)

#define INTC_ICDICPR13_TINT0                    (0x00000001uL)
#define INTC_ICDICPR13_TINT1                    (0x00000002uL)
#define INTC_ICDICPR13_TINT2                    (0x00000004uL)
#define INTC_ICDICPR13_TINT3                    (0x00000008uL)
#define INTC_ICDICPR13_TINT4                    (0x00000010uL)
#define INTC_ICDICPR13_TINT5                    (0x00000020uL)
#define INTC_ICDICPR13_TINT6                    (0x00000040uL)
#define INTC_ICDICPR13_TINT7                    (0x00000080uL)
#define INTC_ICDICPR13_TINT8                    (0x00000100uL)
#define INTC_ICDICPR13_TINT9                    (0x00000200uL)
#define INTC_ICDICPR13_TINT10                   (0x00000400uL)
#define INTC_ICDICPR13_TINT11                   (0x00000800uL)
#define INTC_ICDICPR13_TINT12                   (0x00001000uL)
#define INTC_ICDICPR13_TINT13                   (0x00002000uL)
#define INTC_ICDICPR13_TINT14                   (0x00004000uL)
#define INTC_ICDICPR13_TINT15                   (0x00008000uL)
#define INTC_ICDICPR13_TINT16                   (0x00010000uL)
#define INTC_ICDICPR13_TINT17                   (0x00020000uL)
#define INTC_ICDICPR13_TINT18                   (0x00040000uL)
#define INTC_ICDICPR13_TINT19                   (0x00080000uL)
#define INTC_ICDICPR13_TINT20                   (0x00100000uL)
#define INTC_ICDICPR13_TINT21                   (0x00200000uL)
#define INTC_ICDICPR13_TINT22                   (0x00400000uL)
#define INTC_ICDICPR13_TINT23                   (0x00800000uL)
#define INTC_ICDICPR13_TINT24                   (0x01000000uL)
#define INTC_ICDICPR13_TINT25                   (0x02000000uL)
#define INTC_ICDICPR13_TINT26                   (0x04000000uL)
#define INTC_ICDICPR13_TINT27                   (0x08000000uL)
#define INTC_ICDICPR13_TINT28                   (0x10000000uL)
#define INTC_ICDICPR13_TINT29                   (0x20000000uL)
#define INTC_ICDICPR13_TINT30                   (0x40000000uL)
#define INTC_ICDICPR13_TINT31                   (0x80000000uL)

#define INTC_ICDICPR14_TINT32                   (0x00000001uL)
#define INTC_ICDICPR14_TINT33                   (0x00000002uL)
#define INTC_ICDICPR14_TINT34                   (0x00000004uL)
#define INTC_ICDICPR14_TINT35                   (0x00000008uL)
#define INTC_ICDICPR14_TINT36                   (0x00000010uL)
#define INTC_ICDICPR14_TINT37                   (0x00000020uL)
#define INTC_ICDICPR14_TINT38                   (0x00000040uL)
#define INTC_ICDICPR14_TINT39                   (0x00000080uL)
#define INTC_ICDICPR14_TINT40                   (0x00000100uL)
#define INTC_ICDICPR14_TINT41                   (0x00000200uL)
#define INTC_ICDICPR14_TINT42                   (0x00000400uL)
#define INTC_ICDICPR14_TINT43                   (0x00000800uL)
#define INTC_ICDICPR14_TINT44                   (0x00001000uL)
#define INTC_ICDICPR14_TINT45                   (0x00002000uL)
#define INTC_ICDICPR14_TINT46                   (0x00004000uL)
#define INTC_ICDICPR14_TINT47                   (0x00008000uL)
#define INTC_ICDICPR14_TINT48                   (0x00010000uL)
#define INTC_ICDICPR14_TINT49                   (0x00020000uL)
#define INTC_ICDICPR14_TINT50                   (0x00040000uL)
#define INTC_ICDICPR14_TINT51                   (0x00080000uL)
#define INTC_ICDICPR14_TINT52                   (0x00100000uL)
#define INTC_ICDICPR14_TINT53                   (0x00200000uL)
#define INTC_ICDICPR14_TINT54                   (0x00400000uL)
#define INTC_ICDICPR14_TINT55                   (0x00800000uL)
#define INTC_ICDICPR14_TINT56                   (0x01000000uL)
#define INTC_ICDICPR14_TINT57                   (0x02000000uL)
#define INTC_ICDICPR14_TINT58                   (0x04000000uL)
#define INTC_ICDICPR14_TINT59                   (0x08000000uL)
#define INTC_ICDICPR14_TINT60                   (0x10000000uL)
#define INTC_ICDICPR14_TINT61                   (0x20000000uL)
#define INTC_ICDICPR14_TINT62                   (0x40000000uL)
#define INTC_ICDICPR14_TINT63                   (0x80000000uL)

#define INTC_ICDICPR15_TINT64                   (0x00000001uL)
#define INTC_ICDICPR15_TINT65                   (0x00000002uL)
#define INTC_ICDICPR15_TINT66                   (0x00000004uL)
#define INTC_ICDICPR15_TINT67                   (0x00000008uL)
#define INTC_ICDICPR15_TINT68                   (0x00000010uL)
#define INTC_ICDICPR15_TINT69                   (0x00000020uL)
#define INTC_ICDICPR15_TINT70                   (0x00000040uL)
#define INTC_ICDICPR15_TINT71                   (0x00000080uL)
#define INTC_ICDICPR15_TINT72                   (0x00000100uL)
#define INTC_ICDICPR15_TINT73                   (0x00000200uL)
#define INTC_ICDICPR15_TINT74                   (0x00000400uL)
#define INTC_ICDICPR15_TINT75                   (0x00000800uL)
#define INTC_ICDICPR15_TINT76                   (0x00001000uL)
#define INTC_ICDICPR15_TINT77                   (0x00002000uL)
#define INTC_ICDICPR15_TINT78                   (0x00004000uL)
#define INTC_ICDICPR15_TINT79                   (0x00008000uL)
#define INTC_ICDICPR15_TINT80                   (0x00010000uL)
#define INTC_ICDICPR15_TINT81                   (0x00020000uL)
#define INTC_ICDICPR15_TINT82                   (0x00040000uL)
#define INTC_ICDICPR15_TINT83                   (0x00080000uL)
#define INTC_ICDICPR15_TINT84                   (0x00100000uL)
#define INTC_ICDICPR15_TINT85                   (0x00200000uL)
#define INTC_ICDICPR15_TINT86                   (0x00400000uL)
#define INTC_ICDICPR15_TINT87                   (0x00800000uL)
#define INTC_ICDICPR15_TINT88                   (0x01000000uL)
#define INTC_ICDICPR15_TINT89                   (0x02000000uL)
#define INTC_ICDICPR15_TINT90                   (0x04000000uL)
#define INTC_ICDICPR15_TINT91                   (0x08000000uL)
#define INTC_ICDICPR15_TINT92                   (0x10000000uL)
#define INTC_ICDICPR15_TINT93                   (0x20000000uL)
#define INTC_ICDICPR15_TINT94                   (0x40000000uL)
#define INTC_ICDICPR15_TINT95                   (0x80000000uL)

#define INTC_ICDICPR16_TINT96                   (0x00000001uL)
#define INTC_ICDICPR16_TINT97                   (0x00000002uL)
#define INTC_ICDICPR16_TINT98                   (0x00000004uL)
#define INTC_ICDICPR16_TINT99                   (0x00000008uL)
#define INTC_ICDICPR16_TINT100                  (0x00000010uL)
#define INTC_ICDICPR16_TINT101                  (0x00000020uL)
#define INTC_ICDICPR16_TINT102                  (0x00000040uL)
#define INTC_ICDICPR16_TINT103                  (0x00000080uL)
#define INTC_ICDICPR16_TINT104                  (0x00000100uL)
#define INTC_ICDICPR16_TINT105                  (0x00000200uL)
#define INTC_ICDICPR16_TINT106                  (0x00000400uL)
#define INTC_ICDICPR16_TINT107                  (0x00000800uL)
#define INTC_ICDICPR16_TINT108                  (0x00001000uL)
#define INTC_ICDICPR16_TINT109                  (0x00002000uL)
#define INTC_ICDICPR16_TINT110                  (0x00004000uL)
#define INTC_ICDICPR16_TINT111                  (0x00008000uL)
#define INTC_ICDICPR16_TINT112                  (0x00010000uL)
#define INTC_ICDICPR16_TINT113                  (0x00020000uL)
#define INTC_ICDICPR16_TINT114                  (0x00040000uL)
#define INTC_ICDICPR16_TINT115                  (0x00080000uL)
#define INTC_ICDICPR16_TINT116                  (0x00100000uL)
#define INTC_ICDICPR16_TINT117                  (0x00200000uL)
#define INTC_ICDICPR16_TINT118                  (0x00400000uL)
#define INTC_ICDICPR16_TINT119                  (0x00800000uL)
#define INTC_ICDICPR16_TINT120                  (0x01000000uL)
#define INTC_ICDICPR16_TINT121                  (0x02000000uL)
#define INTC_ICDICPR16_TINT122                  (0x04000000uL)
#define INTC_ICDICPR16_TINT123                  (0x08000000uL)
#define INTC_ICDICPR16_TINT124                  (0x10000000uL)
#define INTC_ICDICPR16_TINT125                  (0x20000000uL)
#define INTC_ICDICPR16_TINT126                  (0x40000000uL)
#define INTC_ICDICPR16_TINT127                  (0x80000000uL)

#define INTC_ICDICPR17_TINT128                  (0x00000001uL)
#define INTC_ICDICPR17_TINT129                  (0x00000002uL)
#define INTC_ICDICPR17_TINT130                  (0x00000004uL)
#define INTC_ICDICPR17_TINT131                  (0x00000008uL)
#define INTC_ICDICPR17_TINT132                  (0x00000010uL)
#define INTC_ICDICPR17_TINT133                  (0x00000020uL)
#define INTC_ICDICPR17_TINT134                  (0x00000040uL)
#define INTC_ICDICPR17_TINT135                  (0x00000080uL)
#define INTC_ICDICPR17_TINT136                  (0x00000100uL)
#define INTC_ICDICPR17_TINT137                  (0x00000200uL)
#define INTC_ICDICPR17_TINT138                  (0x00000400uL)
#define INTC_ICDICPR17_TINT139                  (0x00000800uL)
#define INTC_ICDICPR17_TINT140                  (0x00001000uL)
#define INTC_ICDICPR17_TINT141                  (0x00002000uL)
#define INTC_ICDICPR17_TINT142                  (0x00004000uL)
#define INTC_ICDICPR17_TINT143                  (0x00008000uL)
#define INTC_ICDICPR17_TINT144                  (0x00010000uL)
#define INTC_ICDICPR17_TINT145                  (0x00020000uL)
#define INTC_ICDICPR17_TINT146                  (0x00040000uL)
#define INTC_ICDICPR17_TINT147                  (0x00080000uL)
#define INTC_ICDICPR17_TINT148                  (0x00100000uL)
#define INTC_ICDICPR17_TINT149                  (0x00200000uL)
#define INTC_ICDICPR17_TINT150                  (0x00400000uL)
#define INTC_ICDICPR17_TINT151                  (0x00800000uL)
#define INTC_ICDICPR17_TINT152                  (0x01000000uL)
#define INTC_ICDICPR17_TINT153                  (0x02000000uL)
#define INTC_ICDICPR17_TINT154                  (0x04000000uL)
#define INTC_ICDICPR17_TINT155                  (0x08000000uL)
#define INTC_ICDICPR17_TINT156                  (0x10000000uL)
#define INTC_ICDICPR17_TINT157                  (0x20000000uL)
#define INTC_ICDICPR17_TINT158                  (0x40000000uL)
#define INTC_ICDICPR17_TINT159                  (0x80000000uL)

#define INTC_ICDICPR18_TINT160                  (0x00000001uL)
#define INTC_ICDICPR18_TINT161                  (0x00000002uL)
#define INTC_ICDICPR18_TINT162                  (0x00000004uL)
#define INTC_ICDICPR18_TINT163                  (0x00000008uL)
#define INTC_ICDICPR18_TINT164                  (0x00000010uL)
#define INTC_ICDICPR18_TINT165                  (0x00000020uL)
#define INTC_ICDICPR18_TINT166                  (0x00000040uL)
#define INTC_ICDICPR18_TINT167                  (0x00000080uL)
#define INTC_ICDICPR18_TINT168                  (0x00000100uL)
#define INTC_ICDICPR18_TINT169                  (0x00000200uL)
#define INTC_ICDICPR18_TINT170                  (0x00000400uL)

#define INTC_ICDABR0_SW0                        (0x00000001uL)
#define INTC_ICDABR0_SW1                        (0x00000002uL)
#define INTC_ICDABR0_SW2                        (0x00000004uL)
#define INTC_ICDABR0_SW3                        (0x00000008uL)
#define INTC_ICDABR0_SW4                        (0x00000010uL)
#define INTC_ICDABR0_SW5                        (0x00000020uL)
#define INTC_ICDABR0_SW6                        (0x00000040uL)
#define INTC_ICDABR0_SW7                        (0x00000080uL)
#define INTC_ICDABR0_SW8                        (0x00000100uL)
#define INTC_ICDABR0_SW9                        (0x00000200uL)
#define INTC_ICDABR0_SW10                       (0x00000400uL)
#define INTC_ICDABR0_SW11                       (0x00000800uL)
#define INTC_ICDABR0_SW12                       (0x00001000uL)
#define INTC_ICDABR0_SW13                       (0x00002000uL)
#define INTC_ICDABR0_SW14                       (0x00004000uL)
#define INTC_ICDABR0_SW15                       (0x00008000uL)
#define INTC_ICDABR0_PMUIRQ0                    (0x00010000uL)
#define INTC_ICDABR0_COMMRX0                    (0x00020000uL)
#define INTC_ICDABR0_COMMTX0                    (0x00040000uL)
#define INTC_ICDABR0_CTIIRQ0                    (0x00080000uL)

#define INTC_ICDABR1_IRQ0                       (0x00000001uL)
#define INTC_ICDABR1_IRQ1                       (0x00000002uL)
#define INTC_ICDABR1_IRQ2                       (0x00000004uL)
#define INTC_ICDABR1_IRQ3                       (0x00000008uL)
#define INTC_ICDABR1_IRQ4                       (0x00000010uL)
#define INTC_ICDABR1_IRQ5                       (0x00000020uL)
#define INTC_ICDABR1_IRQ6                       (0x00000040uL)
#define INTC_ICDABR1_IRQ7                       (0x00000080uL)
#define INTC_ICDABR1_PL310ERR                   (0x00000100uL)
#define INTC_ICDABR1_DMAINT0                    (0x00000200uL)
#define INTC_ICDABR1_DMAINT1                    (0x00000400uL)
#define INTC_ICDABR1_DMAINT2                    (0x00000800uL)
#define INTC_ICDABR1_DMAINT3                    (0x00001000uL)
#define INTC_ICDABR1_DMAINT4                    (0x00002000uL)
#define INTC_ICDABR1_DMAINT5                    (0x00004000uL)
#define INTC_ICDABR1_DMAINT6                    (0x00008000uL)
#define INTC_ICDABR1_DMAINT7                    (0x00010000uL)
#define INTC_ICDABR1_DMAINT8                    (0x00020000uL)
#define INTC_ICDABR1_DMAINT9                    (0x00040000uL)
#define INTC_ICDABR1_DMAINT10                   (0x00080000uL)
#define INTC_ICDABR1_DMAINT11                   (0x00100000uL)
#define INTC_ICDABR1_DMAINT12                   (0x00200000uL)
#define INTC_ICDABR1_DMAINT13                   (0x00400000uL)
#define INTC_ICDABR1_DMAINT14                   (0x00800000uL)
#define INTC_ICDABR1_DMAINT15                   (0x01000000uL)
#define INTC_ICDABR1_DMAERR                     (0x02000000uL)

#define INTC_ICDABR2_USBI0                      (0x00000200uL)
#define INTC_ICDABR2_USBI1                      (0x00000400uL)
#define INTC_ICDABR2_S0_VI_VSYNC0               (0x00000800uL)
#define INTC_ICDABR2_S0_LO_VSYNC0               (0x00001000uL)
#define INTC_ICDABR2_S0_VSYNCERR0               (0x00002000uL)
#define INTC_ICDABR2_GR3_VLINE0                 (0x00004000uL)
#define INTC_ICDABR2_S0_VFIELD0                 (0x00008000uL)
#define INTC_ICDABR2_IV1_VBUFERR0               (0x00010000uL)
#define INTC_ICDABR2_IV3_VBUFERR0               (0x00020000uL)
#define INTC_ICDABR2_IV5_VBUFERR0               (0x00040000uL)
#define INTC_ICDABR2_IV6_VBUFERR0               (0x00080000uL)
#define INTC_ICDABR2_S0_WLINE0                  (0x00100000uL)
#define INTC_ICDABR2_S1_VI_VSYNC0               (0x00200000uL)
#define INTC_ICDABR2_S1_LO_VSYNC0               (0x00400000uL)
#define INTC_ICDABR2_S1_VSYNCERR0               (0x00800000uL)
#define INTC_ICDABR2_S1_VFIELD0                 (0x01000000uL)
#define INTC_ICDABR2_IV2_VBUFERR0               (0x02000000uL)
#define INTC_ICDABR2_IV4_VBUFERR0               (0x04000000uL)
#define INTC_ICDABR2_S1_WLINE0                  (0x08000000uL)
#define INTC_ICDABR2_OIR_VI_VSYNC0              (0x10000000uL)
#define INTC_ICDABR2_OIR_LO_VSYNC0              (0x20000000uL)
#define INTC_ICDABR2_OIR_VSYNCERR0              (0x40000000uL)
#define INTC_ICDABR2_OIR_VFIELD0                (0x80000000uL)

#define INTC_ICDABR3_IV7_VBUFERR0               (0x00000001uL)
#define INTC_ICDABR3_IV8_VBUFERR0               (0x00000002uL)
#define INTC_ICDABR3_OIR_WLINE0                 (0x00000004uL)
#define INTC_ICDABR3_S0_VI_VSYNC1               (0x00000008uL)
#define INTC_ICDABR3_S0_LO_VSYNC1               (0x00000010uL)
#define INTC_ICDABR3_S0_VSYNCERR1               (0x00000020uL)
#define INTC_ICDABR3_GR3_VLINE1                 (0x00000040uL)
#define INTC_ICDABR3_S0_VFIELD1                 (0x00000080uL)
#define INTC_ICDABR3_IV1_VBUFERR1               (0x00000100uL)
#define INTC_ICDABR3_IV3_VBUFERR1               (0x00000200uL)
#define INTC_ICDABR3_IV5_VBUFERR1               (0x00000400uL)
#define INTC_ICDABR3_IV6_VBUFERR1               (0x00000800uL)
#define INTC_ICDABR3_S0_WLINE1                  (0x00001000uL)
#define INTC_ICDABR3_S1_VI_VSYNC1               (0x00002000uL)
#define INTC_ICDABR3_S1_LO_VSYNC1               (0x00004000uL)
#define INTC_ICDABR3_S1_VSYNCERR1               (0x00008000uL)
#define INTC_ICDABR3_S1_VFIELD1                 (0x00010000uL)
#define INTC_ICDABR3_IV2_VBUFERR1               (0x00020000uL)
#define INTC_ICDABR3_IV4_VBUFERR1               (0x00040000uL)
#define INTC_ICDABR3_S1_WLINE1                  (0x00080000uL)
#define INTC_ICDABR3_OIR_VI_VSYNC1              (0x00100000uL)
#define INTC_ICDABR3_OIR_LO_VSYNC1              (0x00200000uL)
#define INTC_ICDABR3_OIR_VLINE1                 (0x00400000uL)
#define INTC_ICDABR3_OIR_VFIELD1                (0x00800000uL)
#define INTC_ICDABR3_IV7_VBUFERR1               (0x01000000uL)
#define INTC_ICDABR3_IV8_VBUFERR1               (0x02000000uL)
#define INTC_ICDABR3_OIR_WLINE1                 (0x04000000uL)
#define INTC_ICDABR3_IMRDI                      (0x08000000uL)
#define INTC_ICDABR3_IMR2I0                     (0x10000000uL)
#define INTC_ICDABR3_IMR2I1                     (0x20000000uL)
#define INTC_ICDABR3_JEDI                       (0x40000000uL)
#define INTC_ICDABR3_JDTI                       (0x80000000uL)

#define INTC_ICDABR4_CMP0                       (0x00000001uL)
#define INTC_ICDABR4_CMP1                       (0x00000002uL)
#define INTC_ICDABR4_INT0                       (0x00000004uL)
#define INTC_ICDABR4_INT1                       (0x00000008uL)
#define INTC_ICDABR4_INT2                       (0x00000010uL)
#define INTC_ICDABR4_INT3                       (0x00000020uL)
#define INTC_ICDABR4_OSTM0TINT                  (0x00000040uL)
#define INTC_ICDABR4_OSTM1TINT                  (0x00000080uL)
#define INTC_ICDABR4_CMI                        (0x00000100uL)
#define INTC_ICDABR4_WTOUT                      (0x00000200uL)
#define INTC_ICDABR4_ITI                        (0x00000400uL)
#define INTC_ICDABR4_TGI0A                      (0x00000800uL)
#define INTC_ICDABR4_TGI0B                      (0x00001000uL)
#define INTC_ICDABR4_TGI0C                      (0x00002000uL)
#define INTC_ICDABR4_TGI0D                      (0x00004000uL)
#define INTC_ICDABR4_TGI0V                      (0x00008000uL)
#define INTC_ICDABR4_TGI0E                      (0x00010000uL)
#define INTC_ICDABR4_TGI0F                      (0x00020000uL)
#define INTC_ICDABR4_TGI1A                      (0x00040000uL)
#define INTC_ICDABR4_TGI1B                      (0x00080000uL)
#define INTC_ICDABR4_TGI1V                      (0x00100000uL)
#define INTC_ICDABR4_TGI1U                      (0x00200000uL)
#define INTC_ICDABR4_TGI2A                      (0x00400000uL)
#define INTC_ICDABR4_TGI2B                      (0x00800000uL)
#define INTC_ICDABR4_TGI2V                      (0x01000000uL)
#define INTC_ICDABR4_TGI2U                      (0x02000000uL)
#define INTC_ICDABR4_TGI3A                      (0x04000000uL)
#define INTC_ICDABR4_TGI3B                      (0x08000000uL)
#define INTC_ICDABR4_TGI3C                      (0x10000000uL)
#define INTC_ICDABR4_TGI3D                      (0x20000000uL)
#define INTC_ICDABR4_TGI3V                      (0x40000000uL)
#define INTC_ICDABR4_TGI4A                      (0x80000000uL)

#define INTC_ICDABR5_TGI4B                      (0x00000001uL)
#define INTC_ICDABR5_TGI4C                      (0x00000002uL)
#define INTC_ICDABR5_TGI4D                      (0x00000004uL)
#define INTC_ICDABR5_TGI4V                      (0x00000008uL)
#define INTC_ICDABR5_CMI1                       (0x00000010uL)
#define INTC_ICDABR5_CMI2                       (0x00000020uL)
#define INTC_ICDABR5_SGDEI0                     (0x00000040uL)
#define INTC_ICDABR5_SGDEI1                     (0x00000080uL)
#define INTC_ICDABR5_SGDEI2                     (0x00000100uL)
#define INTC_ICDABR5_SGDEI3                     (0x00000200uL)
#define INTC_ICDABR5_ADI                        (0x00000400uL)
#define INTC_ICDABR5_LMTI                       (0x00000800uL)
#define INTC_ICDABR5_SSII0                      (0x00001000uL)
#define INTC_ICDABR5_SSIRXI0                    (0x00002000uL)
#define INTC_ICDABR5_SSITXI0                    (0x00004000uL)
#define INTC_ICDABR5_SSII1                      (0x00008000uL)
#define INTC_ICDABR5_SSIRXI1                    (0x00010000uL)
#define INTC_ICDABR5_SSITXI1                    (0x00020000uL)
#define INTC_ICDABR5_SSII2                      (0x00040000uL)
#define INTC_ICDABR5_SSIRTI2                    (0x00080000uL)
#define INTC_ICDABR5_SSII3                      (0x00100000uL)
#define INTC_ICDABR5_SSIRXI3                    (0x00200000uL)
#define INTC_ICDABR5_SSITXI3                    (0x00400000uL)
#define INTC_ICDABR5_SSII4                      (0x00800000uL)
#define INTC_ICDABR5_SSIRTI4                    (0x01000000uL)
#define INTC_ICDABR5_SSII5                      (0x02000000uL)
#define INTC_ICDABR5_SSIRXI5                    (0x04000000uL)
#define INTC_ICDABR5_SSITXI5                    (0x08000000uL)
#define INTC_ICDABR5_SPDIFI                     (0x10000000uL)
#define INTC_ICDABR5_INTIICTEI0                 (0x20000000uL)
#define INTC_ICDABR5_INTIICRI0                  (0x40000000uL)
#define INTC_ICDABR5_INTIICTI0                  (0x80000000uL)

#define INTC_ICDABR6_INTIICSPI0                 (0x00000001uL)
#define INTC_ICDABR6_INTIICSTI0                 (0x00000002uL)
#define INTC_ICDABR6_INTIICNAKI0                (0x00000004uL)
#define INTC_ICDABR6_INTIICALI0                 (0x00000008uL)
#define INTC_ICDABR6_INTIICTMOI0                (0x00000010uL)
#define INTC_ICDABR6_INTIICTEI1                 (0x00000020uL)
#define INTC_ICDABR6_INTIICRI1                  (0x00000040uL)
#define INTC_ICDABR6_INTIICTI1                  (0x00000080uL)
#define INTC_ICDABR6_INTIICSPI1                 (0x00000100uL)
#define INTC_ICDABR6_INTIICSTI1                 (0x00000200uL)
#define INTC_ICDABR6_INTIICNAKI1                (0x00000400uL)
#define INTC_ICDABR6_INTIICALI1                 (0x00000800uL)
#define INTC_ICDABR6_INTIICTMOI1                (0x00001000uL)
#define INTC_ICDABR6_INTIICTEI2                 (0x00002000uL)
#define INTC_ICDABR6_INTIICRI2                  (0x00004000uL)
#define INTC_ICDABR6_INTIICTI2                  (0x00008000uL)
#define INTC_ICDABR6_INTIICSPI2                 (0x00010000uL)
#define INTC_ICDABR6_INTIICSTI2                 (0x00020000uL)
#define INTC_ICDABR6_INTIICNAKI2                (0x00040000uL)
#define INTC_ICDABR6_INTIICALI2                 (0x00080000uL)
#define INTC_ICDABR6_INTIICTMOI2                (0x00100000uL)
#define INTC_ICDABR6_INTIICTEI3                 (0x00200000uL)
#define INTC_ICDABR6_INTIICRI3                  (0x00400000uL)
#define INTC_ICDABR6_INTIICTI3                  (0x00800000uL)
#define INTC_ICDABR6_INTIICSPI3                 (0x01000000uL)
#define INTC_ICDABR6_INTIICSTI3                 (0x02000000uL)
#define INTC_ICDABR6_INTIICNAKI3                (0x04000000uL)
#define INTC_ICDABR6_INTIICALI3                 (0x08000000uL)
#define INTC_ICDABR6_INTIICTMOI3                (0x10000000uL)
#define INTC_ICDABR6_BRI0                       (0x20000000uL)
#define INTC_ICDABR6_ERI0                       (0x40000000uL)
#define INTC_ICDABR6_RXI0                       (0x80000000uL)

#define INTC_ICDABR7_TXI0                       (0x00000001uL)
#define INTC_ICDABR7_BRI1                       (0x00000002uL)
#define INTC_ICDABR7_ERI1                       (0x00000004uL)
#define INTC_ICDABR7_RXI1                       (0x00000008uL)
#define INTC_ICDABR7_TXI1                       (0x00000010uL)
#define INTC_ICDABR7_BRI2                       (0x00000020uL)
#define INTC_ICDABR7_ERI2                       (0x00000040uL)
#define INTC_ICDABR7_RXI2                       (0x00000080uL)
#define INTC_ICDABR7_TXI2                       (0x00000100uL)
#define INTC_ICDABR7_BRI3                       (0x00000200uL)
#define INTC_ICDABR7_ERI3                       (0x00000400uL)
#define INTC_ICDABR7_RXI3                       (0x00000800uL)
#define INTC_ICDABR7_TXI3                       (0x00001000uL)
#define INTC_ICDABR7_BRI4                       (0x00002000uL)
#define INTC_ICDABR7_ERI4                       (0x00004000uL)
#define INTC_ICDABR7_RXI4                       (0x00008000uL)
#define INTC_ICDABR7_TXI4                       (0x00010000uL)
#define INTC_ICDABR7_BRI5                       (0x00020000uL)
#define INTC_ICDABR7_ERI5                       (0x00040000uL)
#define INTC_ICDABR7_RXI5                       (0x00080000uL)
#define INTC_ICDABR7_TXI5                       (0x00100000uL)
#define INTC_ICDABR7_BRI6                       (0x00200000uL)
#define INTC_ICDABR7_ERI6                       (0x00400000uL)
#define INTC_ICDABR7_RXI6                       (0x00800000uL)
#define INTC_ICDABR7_TXI6                       (0x01000000uL)
#define INTC_ICDABR7_BRI7                       (0x02000000uL)
#define INTC_ICDABR7_ERI7                       (0x04000000uL)
#define INTC_ICDABR7_RXI7                       (0x08000000uL)
#define INTC_ICDABR7_TXI7                       (0x10000000uL)
#define INTC_ICDABR7_INTRCANGERR                (0x20000000uL)
#define INTC_ICDABR7_INTRCANGRECC               (0x40000000uL)
#define INTC_ICDABR7_INTRCAN0REC                (0x80000000uL)

#define INTC_ICDABR8_INTRCAN0ERR                (0x00000001uL)
#define INTC_ICDABR8_INTRCAN0TRX                (0x00000002uL)
#define INTC_ICDABR8_INTRCAN1REC                (0x00000004uL)
#define INTC_ICDABR8_INTRCAN1ERR                (0x00000008uL)
#define INTC_ICDABR8_INTRCAN1TRX                (0x00000010uL)
#define INTC_ICDABR8_INTRCAN2REC                (0x00000020uL)
#define INTC_ICDABR8_INTRCAN2ERR                (0x00000040uL)
#define INTC_ICDABR8_INTRCAN2TRX                (0x00000080uL)
#define INTC_ICDABR8_INTRCAN3REC                (0x00000100uL)
#define INTC_ICDABR8_INTRCAN3ERR                (0x00000200uL)
#define INTC_ICDABR8_INTRCAN3TRX                (0x00000400uL)
#define INTC_ICDABR8_INTRCAN4REC                (0x00000800uL)
#define INTC_ICDABR8_INTRCAN4ERR                (0x00001000uL)
#define INTC_ICDABR8_INTRCAN4TRX                (0x00002000uL)
#define INTC_ICDABR8_SPEI0                      (0x00004000uL)
#define INTC_ICDABR8_SPRI0                      (0x00008000uL)
#define INTC_ICDABR8_SPTI0                      (0x00010000uL)
#define INTC_ICDABR8_SPEI1                      (0x00020000uL)
#define INTC_ICDABR8_SPRI1                      (0x00040000uL)
#define INTC_ICDABR8_SPTI1                      (0x00080000uL)
#define INTC_ICDABR8_SPEI2                      (0x00100000uL)
#define INTC_ICDABR8_SPRI2                      (0x00200000uL)
#define INTC_ICDABR8_SPTI2                      (0x00400000uL)
#define INTC_ICDABR8_SPEI3                      (0x00800000uL)
#define INTC_ICDABR8_SPRI3                      (0x01000000uL)
#define INTC_ICDABR8_SPTI3                      (0x02000000uL)
#define INTC_ICDABR8_SPEI4                      (0x04000000uL)
#define INTC_ICDABR8_SPRI4                      (0x08000000uL)
#define INTC_ICDABR8_SPTI4                      (0x10000000uL)
#define INTC_ICDABR8_IEBBTD                     (0x20000000uL)
#define INTC_ICDABR8_IEBBTERR                   (0x40000000uL)
#define INTC_ICDABR8_IEBBTSTA                   (0x80000000uL)

#define INTC_ICDABR9_IEBBTV                     (0x00000001uL)
#define INTC_ICDABR9_ISY                        (0x00000002uL)
#define INTC_ICDABR9_IERR                       (0x00000004uL)
#define INTC_ICDABR9_ITARG                      (0x00000008uL)
#define INTC_ICDABR9_ISEC                       (0x00000010uL)
#define INTC_ICDABR9_IBUF                       (0x00000020uL)
#define INTC_ICDABR9_IREADY                     (0x00000040uL)
#define INTC_ICDABR9_FLSTE                      (0x00000080uL)
#define INTC_ICDABR9_FLTENDI                    (0x00000100uL)
#define INTC_ICDABR9_FLTREQ0I                   (0x00000200uL)
#define INTC_ICDABR9_FLTREQ1I                   (0x00000400uL)
#define INTC_ICDABR9_MMC0                       (0x00000800uL)
#define INTC_ICDABR9_MMC1                       (0x00001000uL)
#define INTC_ICDABR9_MMC2                       (0x00002000uL)
#define INTC_ICDABR9_SDHI0_3                    (0x00004000uL)
#define INTC_ICDABR9_SDHI0_0                    (0x00008000uL)
#define INTC_ICDABR9_SDHI0_1                    (0x00010000uL)
#define INTC_ICDABR9_SDHI1_3                    (0x00020000uL)
#define INTC_ICDABR9_SDHI1_0                    (0x00040000uL)
#define INTC_ICDABR9_SDHI1_1                    (0x00080000uL)
#define INTC_ICDABR9_ARM                        (0x00100000uL)
#define INTC_ICDABR9_PRD                        (0x00200000uL)
#define INTC_ICDABR9_CUP                        (0x00400000uL)
#define INTC_ICDABR9_SCUAI0                     (0x00800000uL)
#define INTC_ICDABR9_SCUAI1                     (0x01000000uL)
#define INTC_ICDABR9_SCUFDI0                    (0x02000000uL)
#define INTC_ICDABR9_SCUFDI1                    (0x04000000uL)
#define INTC_ICDABR9_SCUFDI2                    (0x08000000uL)
#define INTC_ICDABR9_SCUFDI3                    (0x10000000uL)
#define INTC_ICDABR9_SCUFUI0                    (0x20000000uL)
#define INTC_ICDABR9_SCUFUI1                    (0x40000000uL)
#define INTC_ICDABR9_SCUFUI2                    (0x80000000uL)

#define INTC_ICDABR10_SCUFUI3                   (0x00000001uL)
#define INTC_ICDABR10_SCUDVI0                   (0x00000002uL)
#define INTC_ICDABR10_SCUDVI1                   (0x00000004uL)
#define INTC_ICDABR10_SCUDVI2                   (0x00000008uL)
#define INTC_ICDABR10_SCUDVI3                   (0x00000010uL)
#define INTC_ICDABR10_MLB_CINT                  (0x00000020uL)
#define INTC_ICDABR10_MLB_SINT                  (0x00000040uL)
#define INTC_ICDABR10_DRC0                      (0x00000080uL)
#define INTC_ICDABR10_DRC1                      (0x00000100uL)
#define INTC_ICDABR10_LINI0_INT_T               (0x00000800uL)
#define INTC_ICDABR10_LINI0_INT_R               (0x00001000uL)
#define INTC_ICDABR10_LINI0_INT_S               (0x00002000uL)
#define INTC_ICDABR10_LINI0_INT_M               (0x00004000uL)
#define INTC_ICDABR10_LINI1_INT_T               (0x00008000uL)
#define INTC_ICDABR10_LINI1_INT_R               (0x00010000uL)
#define INTC_ICDABR10_LINI1_INT_S               (0x00020000uL)
#define INTC_ICDABR10_LINI1_INT_M               (0x00040000uL)
#define INTC_ICDABR10_ERI0                      (0x08000000uL)
#define INTC_ICDABR10_RXI0                      (0x10000000uL)
#define INTC_ICDABR10_TXI0                      (0x20000000uL)
#define INTC_ICDABR10_TEI0                      (0x40000000uL)
#define INTC_ICDABR10_ERI1                      (0x80000000uL)

#define INTC_ICDABR11_RXI1                      (0x00000001uL)
#define INTC_ICDABR11_TXI1                      (0x00000002uL)
#define INTC_ICDABR11_TEI1                      (0x00000004uL)
#define INTC_ICDABR11_AVBI_DATA                 (0x00000008uL)
#define INTC_ICDABR11_AVBI_ERROR                (0x00000010uL)
#define INTC_ICDABR11_AVBI_MANAGE               (0x00000020uL)
#define INTC_ICDABR11_AVBI_MAC                  (0x00000040uL)
#define INTC_ICDABR11_ETHERI                    (0x00000080uL)
#define INTC_ICDABR11_CEUI                      (0x00001000uL)
#define INTC_ICDABR11_H2XMLB_ERRINT             (0x20000000uL)
#define INTC_ICDABR11_H2XIC1_ERRINT             (0x40000000uL)
#define INTC_ICDABR11_X2HPERI1_ERRINT           (0x80000000uL)

#define INTC_ICDABR12_X2HPERI2_ERRINT           (0x00000001uL)
#define INTC_ICDABR12_X2HPERI34_ERRINT          (0x00000002uL)
#define INTC_ICDABR12_X2HPERI5_ERRINT           (0x00000004uL)
#define INTC_ICDABR12_X2HPERI67_ERRINT          (0x00000008uL)
#define INTC_ICDABR12_X2HDBGR_ERRINT            (0x00000010uL)
#define INTC_ICDABR12_X2HBSC_ERRINT             (0x00000020uL)
#define INTC_ICDABR12_X2HSPI1_ERRINT            (0x00000040uL)
#define INTC_ICDABR12_X2HSPI2_ERRINT            (0x00000080uL)
#define INTC_ICDABR12_PRRI                      (0x00000100uL)
#define INTC_ICDABR12_IFEI0                     (0x00000200uL)
#define INTC_ICDABR12_OFFI0                     (0x00000400uL)
#define INTC_ICDABR12_PFVEI0                    (0x00000800uL)
#define INTC_ICDABR12_IFEI1                     (0x00001000uL)
#define INTC_ICDABR12_OFFI1                     (0x00002000uL)
#define INTC_ICDABR12_PFVEI1                    (0x00004000uL)

#define INTC_ICDABR13_TINT0                     (0x00000001uL)
#define INTC_ICDABR13_TINT1                     (0x00000002uL)
#define INTC_ICDABR13_TINT2                     (0x00000004uL)
#define INTC_ICDABR13_TINT3                     (0x00000008uL)
#define INTC_ICDABR13_TINT4                     (0x00000010uL)
#define INTC_ICDABR13_TINT5                     (0x00000020uL)
#define INTC_ICDABR13_TINT6                     (0x00000040uL)
#define INTC_ICDABR13_TINT7                     (0x00000080uL)
#define INTC_ICDABR13_TINT8                     (0x00000100uL)
#define INTC_ICDABR13_TINT9                     (0x00000200uL)
#define INTC_ICDABR13_TINT10                    (0x00000400uL)
#define INTC_ICDABR13_TINT11                    (0x00000800uL)
#define INTC_ICDABR13_TINT12                    (0x00001000uL)
#define INTC_ICDABR13_TINT13                    (0x00002000uL)
#define INTC_ICDABR13_TINT14                    (0x00004000uL)
#define INTC_ICDABR13_TINT15                    (0x00008000uL)
#define INTC_ICDABR13_TINT16                    (0x00010000uL)
#define INTC_ICDABR13_TINT17                    (0x00020000uL)
#define INTC_ICDABR13_TINT18                    (0x00040000uL)
#define INTC_ICDABR13_TINT19                    (0x00080000uL)
#define INTC_ICDABR13_TINT20                    (0x00100000uL)
#define INTC_ICDABR13_TINT21                    (0x00200000uL)
#define INTC_ICDABR13_TINT22                    (0x00400000uL)
#define INTC_ICDABR13_TINT23                    (0x00800000uL)
#define INTC_ICDABR13_TINT24                    (0x01000000uL)
#define INTC_ICDABR13_TINT25                    (0x02000000uL)
#define INTC_ICDABR13_TINT26                    (0x04000000uL)
#define INTC_ICDABR13_TINT27                    (0x08000000uL)
#define INTC_ICDABR13_TINT28                    (0x10000000uL)
#define INTC_ICDABR13_TINT29                    (0x20000000uL)
#define INTC_ICDABR13_TINT30                    (0x40000000uL)
#define INTC_ICDABR13_TINT31                    (0x80000000uL)

#define INTC_ICDABR14_TINT32                    (0x00000001uL)
#define INTC_ICDABR14_TINT33                    (0x00000002uL)
#define INTC_ICDABR14_TINT34                    (0x00000004uL)
#define INTC_ICDABR14_TINT35                    (0x00000008uL)
#define INTC_ICDABR14_TINT36                    (0x00000010uL)
#define INTC_ICDABR14_TINT37                    (0x00000020uL)
#define INTC_ICDABR14_TINT38                    (0x00000040uL)
#define INTC_ICDABR14_TINT39                    (0x00000080uL)
#define INTC_ICDABR14_TINT40                    (0x00000100uL)
#define INTC_ICDABR14_TINT41                    (0x00000200uL)
#define INTC_ICDABR14_TINT42                    (0x00000400uL)
#define INTC_ICDABR14_TINT43                    (0x00000800uL)
#define INTC_ICDABR14_TINT44                    (0x00001000uL)
#define INTC_ICDABR14_TINT45                    (0x00002000uL)
#define INTC_ICDABR14_TINT46                    (0x00004000uL)
#define INTC_ICDABR14_TINT47                    (0x00008000uL)
#define INTC_ICDABR14_TINT48                    (0x00010000uL)
#define INTC_ICDABR14_TINT49                    (0x00020000uL)
#define INTC_ICDABR14_TINT50                    (0x00040000uL)
#define INTC_ICDABR14_TINT51                    (0x00080000uL)
#define INTC_ICDABR14_TINT52                    (0x00100000uL)
#define INTC_ICDABR14_TINT53                    (0x00200000uL)
#define INTC_ICDABR14_TINT54                    (0x00400000uL)
#define INTC_ICDABR14_TINT55                    (0x00800000uL)
#define INTC_ICDABR14_TINT56                    (0x01000000uL)
#define INTC_ICDABR14_TINT57                    (0x02000000uL)
#define INTC_ICDABR14_TINT58                    (0x04000000uL)
#define INTC_ICDABR14_TINT59                    (0x08000000uL)
#define INTC_ICDABR14_TINT60                    (0x10000000uL)
#define INTC_ICDABR14_TINT61                    (0x20000000uL)
#define INTC_ICDABR14_TINT62                    (0x40000000uL)
#define INTC_ICDABR14_TINT63                    (0x80000000uL)

#define INTC_ICDABR15_TINT64                    (0x00000001uL)
#define INTC_ICDABR15_TINT65                    (0x00000002uL)
#define INTC_ICDABR15_TINT66                    (0x00000004uL)
#define INTC_ICDABR15_TINT67                    (0x00000008uL)
#define INTC_ICDABR15_TINT68                    (0x00000010uL)
#define INTC_ICDABR15_TINT69                    (0x00000020uL)
#define INTC_ICDABR15_TINT70                    (0x00000040uL)
#define INTC_ICDABR15_TINT71                    (0x00000080uL)
#define INTC_ICDABR15_TINT72                    (0x00000100uL)
#define INTC_ICDABR15_TINT73                    (0x00000200uL)
#define INTC_ICDABR15_TINT74                    (0x00000400uL)
#define INTC_ICDABR15_TINT75                    (0x00000800uL)
#define INTC_ICDABR15_TINT76                    (0x00001000uL)
#define INTC_ICDABR15_TINT77                    (0x00002000uL)
#define INTC_ICDABR15_TINT78                    (0x00004000uL)
#define INTC_ICDABR15_TINT79                    (0x00008000uL)
#define INTC_ICDABR15_TINT80                    (0x00010000uL)
#define INTC_ICDABR15_TINT81                    (0x00020000uL)
#define INTC_ICDABR15_TINT82                    (0x00040000uL)
#define INTC_ICDABR15_TINT83                    (0x00080000uL)
#define INTC_ICDABR15_TINT84                    (0x00100000uL)
#define INTC_ICDABR15_TINT85                    (0x00200000uL)
#define INTC_ICDABR15_TINT86                    (0x00400000uL)
#define INTC_ICDABR15_TINT87                    (0x00800000uL)
#define INTC_ICDABR15_TINT88                    (0x01000000uL)
#define INTC_ICDABR15_TINT89                    (0x02000000uL)
#define INTC_ICDABR15_TINT90                    (0x04000000uL)
#define INTC_ICDABR15_TINT91                    (0x08000000uL)
#define INTC_ICDABR15_TINT92                    (0x10000000uL)
#define INTC_ICDABR15_TINT93                    (0x20000000uL)
#define INTC_ICDABR15_TINT94                    (0x40000000uL)
#define INTC_ICDABR15_TINT95                    (0x80000000uL)

#define INTC_ICDABR16_TINT96                    (0x00000001uL)
#define INTC_ICDABR16_TINT97                    (0x00000002uL)
#define INTC_ICDABR16_TINT98                    (0x00000004uL)
#define INTC_ICDABR16_TINT99                    (0x00000008uL)
#define INTC_ICDABR16_TINT100                   (0x00000010uL)
#define INTC_ICDABR16_TINT101                   (0x00000020uL)
#define INTC_ICDABR16_TINT102                   (0x00000040uL)
#define INTC_ICDABR16_TINT103                   (0x00000080uL)
#define INTC_ICDABR16_TINT104                   (0x00000100uL)
#define INTC_ICDABR16_TINT105                   (0x00000200uL)
#define INTC_ICDABR16_TINT106                   (0x00000400uL)
#define INTC_ICDABR16_TINT107                   (0x00000800uL)
#define INTC_ICDABR16_TINT108                   (0x00001000uL)
#define INTC_ICDABR16_TINT109                   (0x00002000uL)
#define INTC_ICDABR16_TINT110                   (0x00004000uL)
#define INTC_ICDABR16_TINT111                   (0x00008000uL)
#define INTC_ICDABR16_TINT112                   (0x00010000uL)
#define INTC_ICDABR16_TINT113                   (0x00020000uL)
#define INTC_ICDABR16_TINT114                   (0x00040000uL)
#define INTC_ICDABR16_TINT115                   (0x00080000uL)
#define INTC_ICDABR16_TINT116                   (0x00100000uL)
#define INTC_ICDABR16_TINT117                   (0x00200000uL)
#define INTC_ICDABR16_TINT118                   (0x00400000uL)
#define INTC_ICDABR16_TINT119                   (0x00800000uL)
#define INTC_ICDABR16_TINT120                   (0x01000000uL)
#define INTC_ICDABR16_TINT121                   (0x02000000uL)
#define INTC_ICDABR16_TINT122                   (0x04000000uL)
#define INTC_ICDABR16_TINT123                   (0x08000000uL)
#define INTC_ICDABR16_TINT124                   (0x10000000uL)
#define INTC_ICDABR16_TINT125                   (0x20000000uL)
#define INTC_ICDABR16_TINT126                   (0x40000000uL)
#define INTC_ICDABR16_TINT127                   (0x80000000uL)

#define INTC_ICDABR17_TINT128                   (0x00000001uL)
#define INTC_ICDABR17_TINT129                   (0x00000002uL)
#define INTC_ICDABR17_TINT130                   (0x00000004uL)
#define INTC_ICDABR17_TINT131                   (0x00000008uL)
#define INTC_ICDABR17_TINT132                   (0x00000010uL)
#define INTC_ICDABR17_TINT133                   (0x00000020uL)
#define INTC_ICDABR17_TINT134                   (0x00000040uL)
#define INTC_ICDABR17_TINT135                   (0x00000080uL)
#define INTC_ICDABR17_TINT136                   (0x00000100uL)
#define INTC_ICDABR17_TINT137                   (0x00000200uL)
#define INTC_ICDABR17_TINT138                   (0x00000400uL)
#define INTC_ICDABR17_TINT139                   (0x00000800uL)
#define INTC_ICDABR17_TINT140                   (0x00001000uL)
#define INTC_ICDABR17_TINT141                   (0x00002000uL)
#define INTC_ICDABR17_TINT142                   (0x00004000uL)
#define INTC_ICDABR17_TINT143                   (0x00008000uL)
#define INTC_ICDABR17_TINT144                   (0x00010000uL)
#define INTC_ICDABR17_TINT145                   (0x00020000uL)
#define INTC_ICDABR17_TINT146                   (0x00040000uL)
#define INTC_ICDABR17_TINT147                   (0x00080000uL)
#define INTC_ICDABR17_TINT148                   (0x00100000uL)
#define INTC_ICDABR17_TINT149                   (0x00200000uL)
#define INTC_ICDABR17_TINT150                   (0x00400000uL)
#define INTC_ICDABR17_TINT151                   (0x00800000uL)
#define INTC_ICDABR17_TINT152                   (0x01000000uL)
#define INTC_ICDABR17_TINT153                   (0x02000000uL)
#define INTC_ICDABR17_TINT154                   (0x04000000uL)
#define INTC_ICDABR17_TINT155                   (0x08000000uL)
#define INTC_ICDABR17_TINT156                   (0x10000000uL)
#define INTC_ICDABR17_TINT157                   (0x20000000uL)
#define INTC_ICDABR17_TINT158                   (0x40000000uL)
#define INTC_ICDABR17_TINT159                   (0x80000000uL)

#define INTC_ICDABR18_TINT160                   (0x00000001uL)
#define INTC_ICDABR18_TINT161                   (0x00000002uL)
#define INTC_ICDABR18_TINT162                   (0x00000004uL)
#define INTC_ICDABR18_TINT163                   (0x00000008uL)
#define INTC_ICDABR18_TINT164                   (0x00000010uL)
#define INTC_ICDABR18_TINT165                   (0x00000020uL)
#define INTC_ICDABR18_TINT166                   (0x00000040uL)
#define INTC_ICDABR18_TINT167                   (0x00000080uL)
#define INTC_ICDABR18_TINT168                   (0x00000100uL)
#define INTC_ICDABR18_TINT169                   (0x00000200uL)
#define INTC_ICDABR18_TINT170                   (0x00000400uL)

#define INTC_ICDIPR0_SW0                        (0x000000FFuL)
#define INTC_ICDIPR0_SW1                        (0x0000FF00uL)
#define INTC_ICDIPR0_SW2                        (0x00FF0000uL)
#define INTC_ICDIPR0_SW3                        (0xFF000000uL)

#define INTC_ICDIPR1_SW4                        (0x000000FFuL)
#define INTC_ICDIPR1_SW5                        (0x0000FF00uL)
#define INTC_ICDIPR1_SW6                        (0x00FF0000uL)
#define INTC_ICDIPR1_SW7                        (0xFF000000uL)

#define INTC_ICDIPR2_SW8                        (0x000000FFuL)
#define INTC_ICDIPR2_SW9                        (0x0000FF00uL)
#define INTC_ICDIPR2_SW10                       (0x00FF0000uL)
#define INTC_ICDIPR2_SW11                       (0xFF000000uL)

#define INTC_ICDIPR3_SW12                       (0x000000FFuL)
#define INTC_ICDIPR3_SW13                       (0x0000FF00uL)
#define INTC_ICDIPR3_SW14                       (0x00FF0000uL)
#define INTC_ICDIPR3_SW15                       (0xFF000000uL)

#define INTC_ICDIPR4_PMUIRQ0                    (0x000000FFuL)
#define INTC_ICDIPR4_COMMRX0                    (0x0000FF00uL)
#define INTC_ICDIPR4_COMMTX0                    (0x00FF0000uL)
#define INTC_ICDIPR4_CTIIRQ0                    (0xFF000000uL)

#define INTC_ICDIPR8_IRQ0                       (0x000000FFuL)
#define INTC_ICDIPR8_IRQ1                       (0x0000FF00uL)
#define INTC_ICDIPR8_IRQ2                       (0x00FF0000uL)
#define INTC_ICDIPR8_IRQ3                       (0xFF000000uL)

#define INTC_ICDIPR9_IRQ4                       (0x000000FFuL)
#define INTC_ICDIPR9_IRQ5                       (0x0000FF00uL)
#define INTC_ICDIPR9_IRQ6                       (0x00FF0000uL)
#define INTC_ICDIPR9_IRQ7                       (0xFF000000uL)

#define INTC_ICDIPR10_PL310ERR                  (0x000000FFuL)
#define INTC_ICDIPR10_DMAINT0                   (0x0000FF00uL)
#define INTC_ICDIPR10_DMAINT1                   (0x00FF0000uL)
#define INTC_ICDIPR10_DMAINT2                   (0xFF000000uL)

#define INTC_ICDIPR11_DMAINT3                   (0x000000FFuL)
#define INTC_ICDIPR11_DMAINT4                   (0x0000FF00uL)
#define INTC_ICDIPR11_DMAINT5                   (0x00FF0000uL)
#define INTC_ICDIPR11_DMAINT6                   (0xFF000000uL)

#define INTC_ICDIPR12_DMAINT7                   (0x000000FFuL)
#define INTC_ICDIPR12_DMAINT8                   (0x0000FF00uL)
#define INTC_ICDIPR12_DMAINT9                   (0x00FF0000uL)
#define INTC_ICDIPR12_DMAINT10                  (0xFF000000uL)

#define INTC_ICDIPR13_DMAINT11                  (0x000000FFuL)
#define INTC_ICDIPR13_DMAINT12                  (0x0000FF00uL)
#define INTC_ICDIPR13_DMAINT13                  (0x00FF0000uL)
#define INTC_ICDIPR13_DMAINT14                  (0xFF000000uL)

#define INTC_ICDIPR14_DMAINT15                  (0x000000FFuL)
#define INTC_ICDIPR14_DMAERR                    (0x0000FF00uL)

#define INTC_ICDIPR18_USBI0                     (0x0000FF00uL)
#define INTC_ICDIPR18_USBI1                     (0x00FF0000uL)
#define INTC_ICDIPR18_S0_VI_VSYNC0              (0xFF000000uL)

#define INTC_ICDIPR19_S0_LO_VSYNC0              (0x000000FFuL)
#define INTC_ICDIPR19_S0_VSYNCERR0              (0x0000FF00uL)
#define INTC_ICDIPR19_GR3_VLINE0                (0x00FF0000uL)
#define INTC_ICDIPR19_S0_VFIELD0                (0xFF000000uL)

#define INTC_ICDIPR20_IV1_VBUFERR0              (0x000000FFuL)
#define INTC_ICDIPR20_IV3_VBUFERR0              (0x0000FF00uL)
#define INTC_ICDIPR20_IV5_VBUFERR0              (0x00FF0000uL)
#define INTC_ICDIPR20_IV6_VBUFERR0              (0xFF000000uL)

#define INTC_ICDIPR21_S0_WLINE0                 (0x000000FFuL)
#define INTC_ICDIPR21_S1_VI_VSYNC0              (0x0000FF00uL)
#define INTC_ICDIPR21_S1_LO_VSYNC0              (0x00FF0000uL)
#define INTC_ICDIPR21_S1_VSYNCERR0              (0xFF000000uL)

#define INTC_ICDIPR22_S1_VFIELD0                (0x000000FFuL)
#define INTC_ICDIPR22_IV2_VBUFERR0              (0x0000FF00uL)
#define INTC_ICDIPR22_IV4_VBUFERR0              (0x00FF0000uL)
#define INTC_ICDIPR22_S1_WLINE0                 (0xFF000000uL)

#define INTC_ICDIPR23_OIR_VI_VSYNC0             (0x000000FFuL)
#define INTC_ICDIPR23_OIR_LO_VSYNC0             (0x0000FF00uL)
#define INTC_ICDIPR23_OIR_VSYNCERR0             (0x00FF0000uL)
#define INTC_ICDIPR23_OIR_VFIELD0               (0xFF000000uL)

#define INTC_ICDIPR24_IV7_VBUFERR0              (0x000000FFuL)
#define INTC_ICDIPR24_IV8_VBUFERR0              (0x0000FF00uL)
#define INTC_ICDIPR24_OIR_WLINE0                (0x00FF0000uL)
#define INTC_ICDIPR24_S0_VI_VSYNC1              (0xFF000000uL)

#define INTC_ICDIPR25_S0_LO_VSYNC1              (0x000000FFuL)
#define INTC_ICDIPR25_S0_VSYNCERR1              (0x0000FF00uL)
#define INTC_ICDIPR25_GR3_VLINE1                (0x00FF0000uL)
#define INTC_ICDIPR25_S0_VFIELD1                (0xFF000000uL)

#define INTC_ICDIPR26_IV1_VBUFERR1              (0x000000FFuL)
#define INTC_ICDIPR26_IV3_VBUFERR1              (0x0000FF00uL)
#define INTC_ICDIPR26_IV5_VBUFERR1              (0x00FF0000uL)
#define INTC_ICDIPR26_IV6_VBUFERR1              (0xFF000000uL)

#define INTC_ICDIPR27_S0_WLINE1                 (0x000000FFuL)
#define INTC_ICDIPR27_S1_VI_VSYNC1              (0x0000FF00uL)
#define INTC_ICDIPR27_S1_LO_VSYNC1              (0x00FF0000uL)
#define INTC_ICDIPR27_S1_VSYNCERR1              (0xFF000000uL)

#define INTC_ICDIPR28_S1_VFIELD1                (0x000000FFuL)
#define INTC_ICDIPR28_IV2_VBUFERR1              (0x0000FF00uL)
#define INTC_ICDIPR28_IV4_VBUFERR1              (0x00FF0000uL)
#define INTC_ICDIPR28_S1_WLINE1                 (0xFF000000uL)

#define INTC_ICDIPR29_OIR_VI_VSYNC1             (0x000000FFuL)
#define INTC_ICDIPR29_OIR_LO_VSYNC1             (0x0000FF00uL)
#define INTC_ICDIPR29_OIR_VLINE1                (0x00FF0000uL)
#define INTC_ICDIPR29_OIR_VFIELD1               (0xFF000000uL)

#define INTC_ICDIPR30_IV7_VBUFERR1              (0x000000FFuL)
#define INTC_ICDIPR30_IV8_VBUFERR1              (0x0000FF00uL)
#define INTC_ICDIPR30_OIR_WLINE1                (0x00FF0000uL)
#define INTC_ICDIPR30_IMRDI                     (0xFF000000uL)

#define INTC_ICDIPR31_IMR2I0                    (0x000000FFuL)
#define INTC_ICDIPR31_IMR2I1                    (0x0000FF00uL)
#define INTC_ICDIPR31_JEDI                      (0x00FF0000uL)
#define INTC_ICDIPR31_JDTI                      (0xFF000000uL)

#define INTC_ICDIPR32_CMP0                      (0x000000FFuL)
#define INTC_ICDIPR32_CMP1                      (0x0000FF00uL)
#define INTC_ICDIPR32_INT0                      (0x00FF0000uL)
#define INTC_ICDIPR32_INT1                      (0xFF000000uL)

#define INTC_ICDIPR33_INT2                      (0x000000FFuL)
#define INTC_ICDIPR33_INT3                      (0x0000FF00uL)
#define INTC_ICDIPR33_OSTM0TINT                 (0x00FF0000uL)
#define INTC_ICDIPR33_OSTM1TINT                 (0xFF000000uL)

#define INTC_ICDIPR34_CMI                       (0x000000FFuL)
#define INTC_ICDIPR34_WTOUT                     (0x0000FF00uL)
#define INTC_ICDIPR34_ITI                       (0x00FF0000uL)
#define INTC_ICDIPR34_TGI0A                     (0xFF000000uL)

#define INTC_ICDIPR35_TGI0B                     (0x000000FFuL)
#define INTC_ICDIPR35_TGI0C                     (0x0000FF00uL)
#define INTC_ICDIPR35_TGI0D                     (0x00FF0000uL)
#define INTC_ICDIPR35_TGI0V                     (0xFF000000uL)

#define INTC_ICDIPR36_TGI0E                     (0x000000FFuL)
#define INTC_ICDIPR36_TGI0F                     (0x0000FF00uL)
#define INTC_ICDIPR36_TGI1A                     (0x00FF0000uL)
#define INTC_ICDIPR36_TGI1B                     (0xFF000000uL)

#define INTC_ICDIPR37_TGI1V                     (0x000000FFuL)
#define INTC_ICDIPR37_TGI1U                     (0x0000FF00uL)
#define INTC_ICDIPR37_TGI2A                     (0x00FF0000uL)
#define INTC_ICDIPR37_TGI2B                     (0xFF000000uL)

#define INTC_ICDIPR38_TGI2V                     (0x000000FFuL)
#define INTC_ICDIPR38_TGI2U                     (0x0000FF00uL)
#define INTC_ICDIPR38_TGI3A                     (0x00FF0000uL)
#define INTC_ICDIPR38_TGI3B                     (0xFF000000uL)

#define INTC_ICDIPR39_TGI3C                     (0x000000FFuL)
#define INTC_ICDIPR39_TGI3D                     (0x0000FF00uL)
#define INTC_ICDIPR39_TGI3V                     (0x00FF0000uL)
#define INTC_ICDIPR39_TGI4A                     (0xFF000000uL)

#define INTC_ICDIPR40_TGI4B                     (0x000000FFuL)
#define INTC_ICDIPR40_TGI4C                     (0x0000FF00uL)
#define INTC_ICDIPR40_TGI4D                     (0x00FF0000uL)
#define INTC_ICDIPR40_TGI4V                     (0xFF000000uL)

#define INTC_ICDIPR41_CMI1                      (0x000000FFuL)
#define INTC_ICDIPR41_CMI2                      (0x0000FF00uL)
#define INTC_ICDIPR41_SGDEI0                    (0x00FF0000uL)
#define INTC_ICDIPR41_SGDEI1                    (0xFF000000uL)

#define INTC_ICDIPR42_SGDEI2                    (0x000000FFuL)
#define INTC_ICDIPR42_SGDEI3                    (0x0000FF00uL)
#define INTC_ICDIPR42_ADI                       (0x00FF0000uL)
#define INTC_ICDIPR42_LMTI                      (0xFF000000uL)

#define INTC_ICDIPR43_SSII0                     (0x000000FFuL)
#define INTC_ICDIPR43_SSIRXI0                   (0x0000FF00uL)
#define INTC_ICDIPR43_SSITXI0                   (0x00FF0000uL)
#define INTC_ICDIPR43_SSII1                     (0xFF000000uL)

#define INTC_ICDIPR44_SSIRXI1                   (0x000000FFuL)
#define INTC_ICDIPR44_SSITXI1                   (0x0000FF00uL)
#define INTC_ICDIPR44_SSII2                     (0x00FF0000uL)
#define INTC_ICDIPR44_SSIRTI2                   (0xFF000000uL)

#define INTC_ICDIPR45_SSII3                     (0x000000FFuL)
#define INTC_ICDIPR45_SSIRXI3                   (0x0000FF00uL)
#define INTC_ICDIPR45_SSITXI3                   (0x00FF0000uL)
#define INTC_ICDIPR45_SSII4                     (0xFF000000uL)

#define INTC_ICDIPR46_SSIRTI4                   (0x000000FFuL)
#define INTC_ICDIPR46_SSII5                     (0x0000FF00uL)
#define INTC_ICDIPR46_SSIRXI5                   (0x00FF0000uL)
#define INTC_ICDIPR46_SSITXI5                   (0xFF000000uL)

#define INTC_ICDIPR47_SPDIFI                    (0x000000FFuL)
#define INTC_ICDIPR47_INTIICTEI0                (0x0000FF00uL)
#define INTC_ICDIPR47_INTIICRI0                 (0x00FF0000uL)
#define INTC_ICDIPR47_INTIICTI0                 (0xFF000000uL)

#define INTC_ICDIPR48_INTIICSPI0                (0x000000FFuL)
#define INTC_ICDIPR48_INTIICSTI0                (0x0000FF00uL)
#define INTC_ICDIPR48_INTIICNAKI0               (0x00FF0000uL)
#define INTC_ICDIPR48_INTIICALI0                (0xFF000000uL)

#define INTC_ICDIPR49_INTIICTMOI0               (0x000000FFuL)
#define INTC_ICDIPR49_INTIICTEI1                (0x0000FF00uL)
#define INTC_ICDIPR49_INTIICRI1                 (0x00FF0000uL)
#define INTC_ICDIPR49_INTIICTI1                 (0xFF000000uL)

#define INTC_ICDIPR50_INTIICSPI1                (0x000000FFuL)
#define INTC_ICDIPR50_INTIICSTI1                (0x0000FF00uL)
#define INTC_ICDIPR50_INTIICNAKI1               (0x00FF0000uL)
#define INTC_ICDIPR50_INTIICALI1                (0xFF000000uL)

#define INTC_ICDIPR51_INTIICTMOI1               (0x000000FFuL)
#define INTC_ICDIPR51_INTIICTEI2                (0x0000FF00uL)
#define INTC_ICDIPR51_INTIICRI2                 (0x00FF0000uL)
#define INTC_ICDIPR51_INTIICTI2                 (0xFF000000uL)

#define INTC_ICDIPR52_INTIICSPI2                (0x000000FFuL)
#define INTC_ICDIPR52_INTIICSTI2                (0x0000FF00uL)
#define INTC_ICDIPR52_INTIICNAKI2               (0x00FF0000uL)
#define INTC_ICDIPR52_INTIICALI2                (0xFF000000uL)

#define INTC_ICDIPR53_INTIICTMOI2               (0x000000FFuL)
#define INTC_ICDIPR53_INTIICTEI3                (0x0000FF00uL)
#define INTC_ICDIPR53_INTIICRI3                 (0x00FF0000uL)
#define INTC_ICDIPR53_INTIICTI3                 (0xFF000000uL)

#define INTC_ICDIPR54_INTIICSPI3                (0x000000FFuL)
#define INTC_ICDIPR54_INTIICSTI3                (0x0000FF00uL)
#define INTC_ICDIPR54_INTIICNAKI3               (0x00FF0000uL)
#define INTC_ICDIPR54_INTIICALI3                (0xFF000000uL)

#define INTC_ICDIPR55_INTIICTMOI3               (0x000000FFuL)
#define INTC_ICDIPR55_BRI0                      (0x0000FF00uL)
#define INTC_ICDIPR55_ERI0                      (0x00FF0000uL)
#define INTC_ICDIPR55_RXI0                      (0xFF000000uL)

#define INTC_ICDIPR56_TXI0                      (0x000000FFuL)
#define INTC_ICDIPR56_BRI1                      (0x0000FF00uL)
#define INTC_ICDIPR56_ERI1                      (0x00FF0000uL)
#define INTC_ICDIPR56_RXI1                      (0xFF000000uL)

#define INTC_ICDIPR57_TXI1                      (0x000000FFuL)
#define INTC_ICDIPR57_BRI2                      (0x0000FF00uL)
#define INTC_ICDIPR57_ERI2                      (0x00FF0000uL)
#define INTC_ICDIPR57_RXI2                      (0xFF000000uL)

#define INTC_ICDIPR58_TXI2                      (0x000000FFuL)
#define INTC_ICDIPR58_BRI3                      (0x0000FF00uL)
#define INTC_ICDIPR58_ERI3                      (0x00FF0000uL)
#define INTC_ICDIPR58_RXI3                      (0xFF000000uL)

#define INTC_ICDIPR59_TXI3                      (0x000000FFuL)
#define INTC_ICDIPR59_BRI4                      (0x0000FF00uL)
#define INTC_ICDIPR59_ERI4                      (0x00FF0000uL)
#define INTC_ICDIPR59_RXI4                      (0xFF000000uL)

#define INTC_ICDIPR60_TXI4                      (0x000000FFuL)
#define INTC_ICDIPR60_BRI5                      (0x0000FF00uL)
#define INTC_ICDIPR60_ERI5                      (0x00FF0000uL)
#define INTC_ICDIPR60_RXI5                      (0xFF000000uL)

#define INTC_ICDIPR61_TXI5                      (0x000000FFuL)
#define INTC_ICDIPR61_BRI6                      (0x0000FF00uL)
#define INTC_ICDIPR61_ERI6                      (0x00FF0000uL)
#define INTC_ICDIPR61_RXI6                      (0xFF000000uL)

#define INTC_ICDIPR62_TXI6                      (0x000000FFuL)
#define INTC_ICDIPR62_BRI7                      (0x0000FF00uL)
#define INTC_ICDIPR62_ERI7                      (0x00FF0000uL)
#define INTC_ICDIPR62_RXI7                      (0xFF000000uL)

#define INTC_ICDIPR63_TXI7                      (0x000000FFuL)
#define INTC_ICDIPR63_INTRCANGERR               (0x0000FF00uL)
#define INTC_ICDIPR63_INTRCANGRECC              (0x00FF0000uL)
#define INTC_ICDIPR63_INTRCAN0REC               (0xFF000000uL)

#define INTC_ICDIPR64_INTRCAN0ERR               (0x000000FFuL)
#define INTC_ICDIPR64_INTRCAN0TRX               (0x0000FF00uL)
#define INTC_ICDIPR64_INTRCAN1REC               (0x00FF0000uL)
#define INTC_ICDIPR64_INTRCAN1ERR               (0xFF000000uL)

#define INTC_ICDIPR65_INTRCAN1TRX               (0x000000FFuL)
#define INTC_ICDIPR65_INTRCAN2REC               (0x0000FF00uL)
#define INTC_ICDIPR65_INTRCAN2ERR               (0x00FF0000uL)
#define INTC_ICDIPR65_INTRCAN2TRX               (0xFF000000uL)

#define INTC_ICDIPR66_INTRCAN3REC               (0x000000FFuL)
#define INTC_ICDIPR66_INTRCAN3ERR               (0x0000FF00uL)
#define INTC_ICDIPR66_INTRCAN3TRX               (0x00FF0000uL)
#define INTC_ICDIPR66_INTRCAN4REC               (0xFF000000uL)

#define INTC_ICDIPR67_INTRCAN4ERR               (0x000000FFuL)
#define INTC_ICDIPR67_INTRCAN4TRX               (0x0000FF00uL)
#define INTC_ICDIPR67_SPEI0                     (0x00FF0000uL)
#define INTC_ICDIPR67_SPRI0                     (0xFF000000uL)

#define INTC_ICDIPR68_SPTI0                     (0x000000FFuL)
#define INTC_ICDIPR68_SPEI1                     (0x0000FF00uL)
#define INTC_ICDIPR68_SPRI1                     (0x00FF0000uL)
#define INTC_ICDIPR68_SPTI1                     (0xFF000000uL)

#define INTC_ICDIPR69_SPEI2                     (0x000000FFuL)
#define INTC_ICDIPR69_SPRI2                     (0x0000FF00uL)
#define INTC_ICDIPR69_SPTI2                     (0x00FF0000uL)
#define INTC_ICDIPR69_SPEI3                     (0xFF000000uL)

#define INTC_ICDIPR70_SPRI3                     (0x000000FFuL)
#define INTC_ICDIPR70_SPTI3                     (0x0000FF00uL)
#define INTC_ICDIPR70_SPEI4                     (0x00FF0000uL)
#define INTC_ICDIPR70_SPRI4                     (0xFF000000uL)

#define INTC_ICDIPR71_SPTI4                     (0x000000FFuL)
#define INTC_ICDIPR71_IEBBTD                    (0x0000FF00uL)
#define INTC_ICDIPR71_IEBBTERR                  (0x00FF0000uL)
#define INTC_ICDIPR71_IEBBTSTA                  (0xFF000000uL)

#define INTC_ICDIPR72_IEBBTV                    (0x000000FFuL)
#define INTC_ICDIPR72_ISY                       (0x0000FF00uL)
#define INTC_ICDIPR72_IERR                      (0x00FF0000uL)
#define INTC_ICDIPR72_ITARG                     (0xFF000000uL)

#define INTC_ICDIPR73_ISEC                      (0x000000FFuL)
#define INTC_ICDIPR73_IBUF                      (0x0000FF00uL)
#define INTC_ICDIPR73_IREADY                    (0x00FF0000uL)
#define INTC_ICDIPR73_FLSTE                     (0xFF000000uL)

#define INTC_ICDIPR74_FLTENDI                   (0x000000FFuL)
#define INTC_ICDIPR74_FLTREQ0I                  (0x0000FF00uL)
#define INTC_ICDIPR74_FLTREQ1I                  (0x00FF0000uL)
#define INTC_ICDIPR74_MMC0                      (0xFF000000uL)

#define INTC_ICDIPR75_MMC1                      (0x000000FFuL)
#define INTC_ICDIPR75_MMC2                      (0x0000FF00uL)
#define INTC_ICDIPR75_SDHI0_3                   (0x00FF0000uL)
#define INTC_ICDIPR75_SDHI0_0                   (0xFF000000uL)

#define INTC_ICDIPR76_SDHI0_1                   (0x000000FFuL)
#define INTC_ICDIPR76_SDHI1_3                   (0x0000FF00uL)
#define INTC_ICDIPR76_SDHI1_0                   (0x00FF0000uL)
#define INTC_ICDIPR76_SDHI1_1                   (0xFF000000uL)

#define INTC_ICDIPR77_ARM                       (0x000000FFuL)
#define INTC_ICDIPR77_PRD                       (0x0000FF00uL)
#define INTC_ICDIPR77_CUP                       (0x00FF0000uL)
#define INTC_ICDIPR77_SCUAI0                    (0xFF000000uL)

#define INTC_ICDIPR78_SCUAI1                    (0x000000FFuL)
#define INTC_ICDIPR78_SCUFDI0                   (0x0000FF00uL)
#define INTC_ICDIPR78_SCUFDI1                   (0x00FF0000uL)
#define INTC_ICDIPR78_SCUFDI2                   (0xFF000000uL)

#define INTC_ICDIPR79_SCUFDI3                   (0x000000FFuL)
#define INTC_ICDIPR79_SCUFUI0                   (0x0000FF00uL)
#define INTC_ICDIPR79_SCUFUI1                   (0x00FF0000uL)
#define INTC_ICDIPR79_SCUFUI2                   (0xFF000000uL)

#define INTC_ICDIPR80_SCUFUI3                   (0x000000FFuL)
#define INTC_ICDIPR80_SCUDVI0                   (0x0000FF00uL)
#define INTC_ICDIPR80_SCUDVI1                   (0x00FF0000uL)
#define INTC_ICDIPR80_SCUDVI2                   (0xFF000000uL)

#define INTC_ICDIPR81_SCUDVI3                   (0x000000FFuL)
#define INTC_ICDIPR81_MLB_CINT                  (0x0000FF00uL)
#define INTC_ICDIPR81_MLB_SINT                  (0x00FF0000uL)
#define INTC_ICDIPR81_DRC0                      (0xFF000000uL)

#define INTC_ICDIPR82_DRC1                      (0x000000FFuL)
#define INTC_ICDIPR82_LINI0_INT_T               (0xFF000000uL)

#define INTC_ICDIPR83_LINI0_INT_R               (0x000000FFuL)
#define INTC_ICDIPR83_LINI0_INT_S               (0x0000FF00uL)
#define INTC_ICDIPR83_LINI0_INT_M               (0x00FF0000uL)
#define INTC_ICDIPR83_LINI1_INT_T               (0xFF000000uL)

#define INTC_ICDIPR84_LINI1_INT_R               (0x000000FFuL)
#define INTC_ICDIPR84_LINI1_INT_S               (0x0000FF00uL)
#define INTC_ICDIPR84_LINI1_INT_M               (0x00FF0000uL)

#define INTC_ICDIPR86_ERI0                      (0xFF000000uL)

#define INTC_ICDIPR87_RXI0                      (0x000000FFuL)
#define INTC_ICDIPR87_TXI0                      (0x0000FF00uL)
#define INTC_ICDIPR87_TEI0                      (0x00FF0000uL)
#define INTC_ICDIPR87_ERI1                      (0xFF000000uL)

#define INTC_ICDIPR88_RXI1                      (0x000000FFuL)
#define INTC_ICDIPR88_TXI1                      (0x0000FF00uL)
#define INTC_ICDIPR88_TEI1                      (0x00FF0000uL)
#define INTC_ICDIPR88_AVBI_DATA                 (0xFF000000uL)

#define INTC_ICDIPR89_AVBI_ERROR                (0x000000FFuL)
#define INTC_ICDIPR89_AVBI_MANAGE               (0x0000FF00uL)
#define INTC_ICDIPR89_AVBI_MAC                  (0x00FF0000uL)
#define INTC_ICDIPR89_ETHERI                    (0xFF000000uL)

#define INTC_ICDIPR91_CEUI                      (0x000000FFuL)

#define INTC_ICDIPR95_H2XMLB_ERRINT             (0x0000FF00uL)
#define INTC_ICDIPR95_H2XIC1_ERRINT             (0x00FF0000uL)
#define INTC_ICDIPR95_X2HPERI1_ERRINT           (0xFF000000uL)

#define INTC_ICDIPR96_X2HPERI2_ERRINT           (0x000000FFuL)
#define INTC_ICDIPR96_X2HPERI34_ERRINT          (0x0000FF00uL)
#define INTC_ICDIPR96_X2HPERI5_ERRINT           (0x00FF0000uL)
#define INTC_ICDIPR96_X2HPERI67_ERRINT          (0xFF000000uL)

#define INTC_ICDIPR97_X2HDBGR_ERRINT            (0x000000FFuL)
#define INTC_ICDIPR97_X2HBSC_ERRINT             (0x0000FF00uL)
#define INTC_ICDIPR97_X2HSPI1_ERRINT            (0x00FF0000uL)
#define INTC_ICDIPR97_X2HSPI2_ERRINT            (0xFF000000uL)

#define INTC_ICDIPR98_PRRI                      (0x000000FFuL)
#define INTC_ICDIPR98_IFEI0                     (0x0000FF00uL)
#define INTC_ICDIPR98_OFFI0                     (0x00FF0000uL)
#define INTC_ICDIPR98_PFVEI0                    (0xFF000000uL)

#define INTC_ICDIPR99_IFEI1                     (0x000000FFuL)
#define INTC_ICDIPR99_OFFI1                     (0x0000FF00uL)
#define INTC_ICDIPR99_PFVEI1                    (0x00FF0000uL)

#define INTC_ICDIPR104_TINT0                    (0x000000FFuL)
#define INTC_ICDIPR104_TINT1                    (0x0000FF00uL)
#define INTC_ICDIPR104_TINT2                    (0x00FF0000uL)
#define INTC_ICDIPR104_TINT3                    (0xFF000000uL)

#define INTC_ICDIPR105_TINT4                    (0x000000FFuL)
#define INTC_ICDIPR105_TINT5                    (0x0000FF00uL)
#define INTC_ICDIPR105_TINT6                    (0x00FF0000uL)
#define INTC_ICDIPR105_TINT7                    (0xFF000000uL)

#define INTC_ICDIPR106_TINT8                    (0x000000FFuL)
#define INTC_ICDIPR106_TINT9                    (0x0000FF00uL)
#define INTC_ICDIPR106_TINT10                   (0x00FF0000uL)
#define INTC_ICDIPR106_TINT11                   (0xFF000000uL)

#define INTC_ICDIPR107_TINT12                   (0x000000FFuL)
#define INTC_ICDIPR107_TINT13                   (0x0000FF00uL)
#define INTC_ICDIPR107_TINT14                   (0x00FF0000uL)
#define INTC_ICDIPR107_TINT15                   (0xFF000000uL)

#define INTC_ICDIPR108_TINT16                   (0x000000FFuL)
#define INTC_ICDIPR108_TINT17                   (0x0000FF00uL)
#define INTC_ICDIPR108_TINT18                   (0x00FF0000uL)
#define INTC_ICDIPR108_TINT19                   (0xFF000000uL)

#define INTC_ICDIPR109_TINT20                   (0x000000FFuL)
#define INTC_ICDIPR109_TINT21                   (0x0000FF00uL)
#define INTC_ICDIPR109_TINT22                   (0x00FF0000uL)
#define INTC_ICDIPR109_TINT23                   (0xFF000000uL)

#define INTC_ICDIPR110_TINT24                   (0x000000FFuL)
#define INTC_ICDIPR110_TINT25                   (0x0000FF00uL)
#define INTC_ICDIPR110_TINT26                   (0x00FF0000uL)
#define INTC_ICDIPR110_TINT27                   (0xFF000000uL)

#define INTC_ICDIPR111_TINT28                   (0x000000FFuL)
#define INTC_ICDIPR111_TINT29                   (0x0000FF00uL)
#define INTC_ICDIPR111_TINT30                   (0x00FF0000uL)
#define INTC_ICDIPR111_TINT31                   (0xFF000000uL)

#define INTC_ICDIPR112_TINT32                   (0x000000FFuL)
#define INTC_ICDIPR112_TINT33                   (0x0000FF00uL)
#define INTC_ICDIPR112_TINT34                   (0x00FF0000uL)
#define INTC_ICDIPR112_TINT35                   (0xFF000000uL)

#define INTC_ICDIPR113_TINT36                   (0x000000FFuL)
#define INTC_ICDIPR113_TINT37                   (0x0000FF00uL)
#define INTC_ICDIPR113_TINT38                   (0x00FF0000uL)
#define INTC_ICDIPR113_TINT39                   (0xFF000000uL)

#define INTC_ICDIPR114_TINT40                   (0x000000FFuL)
#define INTC_ICDIPR114_TINT41                   (0x0000FF00uL)
#define INTC_ICDIPR114_TINT42                   (0x00FF0000uL)
#define INTC_ICDIPR114_TINT43                   (0xFF000000uL)

#define INTC_ICDIPR115_TINT44                   (0x000000FFuL)
#define INTC_ICDIPR115_TINT45                   (0x0000FF00uL)
#define INTC_ICDIPR115_TINT46                   (0x00FF0000uL)
#define INTC_ICDIPR115_TINT47                   (0xFF000000uL)

#define INTC_ICDIPR116_TINT48                   (0x000000FFuL)
#define INTC_ICDIPR116_TINT49                   (0x0000FF00uL)
#define INTC_ICDIPR116_TINT50                   (0x00FF0000uL)
#define INTC_ICDIPR116_TINT51                   (0xFF000000uL)

#define INTC_ICDIPR117_TINT52                   (0x000000FFuL)
#define INTC_ICDIPR117_TINT53                   (0x0000FF00uL)
#define INTC_ICDIPR117_TINT54                   (0x00FF0000uL)
#define INTC_ICDIPR117_TINT55                   (0xFF000000uL)

#define INTC_ICDIPR118_TINT56                   (0x000000FFuL)
#define INTC_ICDIPR118_TINT57                   (0x0000FF00uL)
#define INTC_ICDIPR118_TINT58                   (0x00FF0000uL)
#define INTC_ICDIPR118_TINT59                   (0xFF000000uL)

#define INTC_ICDIPR119_TINT60                   (0x000000FFuL)
#define INTC_ICDIPR119_TINT61                   (0x0000FF00uL)
#define INTC_ICDIPR119_TINT62                   (0x00FF0000uL)
#define INTC_ICDIPR119_TINT63                   (0xFF000000uL)

#define INTC_ICDIPR120_TINT64                   (0x000000FFuL)
#define INTC_ICDIPR120_TINT65                   (0x0000FF00uL)
#define INTC_ICDIPR120_TINT66                   (0x00FF0000uL)
#define INTC_ICDIPR120_TINT67                   (0xFF000000uL)

#define INTC_ICDIPR121_TINT68                   (0x000000FFuL)
#define INTC_ICDIPR121_TINT69                   (0x0000FF00uL)
#define INTC_ICDIPR121_TINT70                   (0x00FF0000uL)
#define INTC_ICDIPR121_TINT71                   (0xFF000000uL)

#define INTC_ICDIPR122_TINT72                   (0x000000FFuL)
#define INTC_ICDIPR122_TINT73                   (0x0000FF00uL)
#define INTC_ICDIPR122_TINT74                   (0x00FF0000uL)
#define INTC_ICDIPR122_TINT75                   (0xFF000000uL)

#define INTC_ICDIPR123_TINT76                   (0x000000FFuL)
#define INTC_ICDIPR123_TINT77                   (0x0000FF00uL)
#define INTC_ICDIPR123_TINT78                   (0x00FF0000uL)
#define INTC_ICDIPR123_TINT79                   (0xFF000000uL)

#define INTC_ICDIPR124_TINT80                   (0x000000FFuL)
#define INTC_ICDIPR124_TINT81                   (0x0000FF00uL)
#define INTC_ICDIPR124_TINT82                   (0x00FF0000uL)
#define INTC_ICDIPR124_TINT83                   (0xFF000000uL)

#define INTC_ICDIPR125_TINT84                   (0x000000FFuL)
#define INTC_ICDIPR125_TINT85                   (0x0000FF00uL)
#define INTC_ICDIPR125_TINT86                   (0x00FF0000uL)
#define INTC_ICDIPR125_TINT87                   (0xFF000000uL)

#define INTC_ICDIPR126_TINT88                   (0x000000FFuL)
#define INTC_ICDIPR126_TINT89                   (0x0000FF00uL)
#define INTC_ICDIPR126_TINT90                   (0x00FF0000uL)
#define INTC_ICDIPR126_TINT91                   (0xFF000000uL)

#define INTC_ICDIPR127_TINT92                   (0x000000FFuL)
#define INTC_ICDIPR127_TINT93                   (0x0000FF00uL)
#define INTC_ICDIPR127_TINT94                   (0x00FF0000uL)
#define INTC_ICDIPR127_TINT95                   (0xFF000000uL)

#define INTC_ICDIPR128_TINT96                   (0x000000FFuL)
#define INTC_ICDIPR128_TINT97                   (0x0000FF00uL)
#define INTC_ICDIPR128_TINT98                   (0x00FF0000uL)
#define INTC_ICDIPR128_TINT99                   (0xFF000000uL)

#define INTC_ICDIPR129_TINT100                  (0x000000FFuL)
#define INTC_ICDIPR129_TINT101                  (0x0000FF00uL)
#define INTC_ICDIPR129_TINT102                  (0x00FF0000uL)
#define INTC_ICDIPR129_TINT103                  (0xFF000000uL)

#define INTC_ICDIPR130_TINT104                  (0x000000FFuL)
#define INTC_ICDIPR130_TINT105                  (0x0000FF00uL)
#define INTC_ICDIPR130_TINT106                  (0x00FF0000uL)
#define INTC_ICDIPR130_TINT107                  (0xFF000000uL)

#define INTC_ICDIPR131_TINT108                  (0x000000FFuL)
#define INTC_ICDIPR131_TINT109                  (0x0000FF00uL)
#define INTC_ICDIPR131_TINT110                  (0x00FF0000uL)
#define INTC_ICDIPR131_TINT111                  (0xFF000000uL)

#define INTC_ICDIPR132_TINT112                  (0x000000FFuL)
#define INTC_ICDIPR132_TINT113                  (0x0000FF00uL)
#define INTC_ICDIPR132_TINT114                  (0x00FF0000uL)
#define INTC_ICDIPR132_TINT115                  (0xFF000000uL)

#define INTC_ICDIPR133_TINT116                  (0x000000FFuL)
#define INTC_ICDIPR133_TINT117                  (0x0000FF00uL)
#define INTC_ICDIPR133_TINT118                  (0x00FF0000uL)
#define INTC_ICDIPR133_TINT119                  (0xFF000000uL)

#define INTC_ICDIPR134_TINT120                  (0x000000FFuL)
#define INTC_ICDIPR134_TINT121                  (0x0000FF00uL)
#define INTC_ICDIPR134_TINT122                  (0x00FF0000uL)
#define INTC_ICDIPR134_TINT123                  (0xFF000000uL)

#define INTC_ICDIPR135_TINT124                  (0x000000FFuL)
#define INTC_ICDIPR135_TINT125                  (0x0000FF00uL)
#define INTC_ICDIPR135_TINT126                  (0x00FF0000uL)
#define INTC_ICDIPR135_TINT127                  (0xFF000000uL)

#define INTC_ICDIPR136_TINT128                  (0x000000FFuL)
#define INTC_ICDIPR136_TINT129                  (0x0000FF00uL)
#define INTC_ICDIPR136_TINT130                  (0x00FF0000uL)
#define INTC_ICDIPR136_TINT131                  (0xFF000000uL)

#define INTC_ICDIPR137_TINT132                  (0x000000FFuL)
#define INTC_ICDIPR137_TINT133                  (0x0000FF00uL)
#define INTC_ICDIPR137_TINT134                  (0x00FF0000uL)
#define INTC_ICDIPR137_TINT135                  (0xFF000000uL)

#define INTC_ICDIPR138_TINT136                  (0x000000FFuL)
#define INTC_ICDIPR138_TINT137                  (0x0000FF00uL)
#define INTC_ICDIPR138_TINT138                  (0x00FF0000uL)
#define INTC_ICDIPR138_TINT139                  (0xFF000000uL)

#define INTC_ICDIPR139_TINT140                  (0x000000FFuL)
#define INTC_ICDIPR139_TINT141                  (0x0000FF00uL)
#define INTC_ICDIPR139_TINT142                  (0x00FF0000uL)
#define INTC_ICDIPR139_TINT143                  (0xFF000000uL)

#define INTC_ICDIPR140_TINT144                  (0x000000FFuL)
#define INTC_ICDIPR140_TINT145                  (0x0000FF00uL)
#define INTC_ICDIPR140_TINT146                  (0x00FF0000uL)
#define INTC_ICDIPR140_TINT147                  (0xFF000000uL)

#define INTC_ICDIPR141_TINT148                  (0x000000FFuL)
#define INTC_ICDIPR141_TINT149                  (0x0000FF00uL)
#define INTC_ICDIPR141_TINT150                  (0x00FF0000uL)
#define INTC_ICDIPR141_TINT151                  (0xFF000000uL)

#define INTC_ICDIPR142_TINT152                  (0x000000FFuL)
#define INTC_ICDIPR142_TINT153                  (0x0000FF00uL)
#define INTC_ICDIPR142_TINT154                  (0x00FF0000uL)
#define INTC_ICDIPR142_TINT155                  (0xFF000000uL)

#define INTC_ICDIPR143_TINT156                  (0x000000FFuL)
#define INTC_ICDIPR143_TINT157                  (0x0000FF00uL)
#define INTC_ICDIPR143_TINT158                  (0x00FF0000uL)
#define INTC_ICDIPR143_TINT159                  (0xFF000000uL)

#define INTC_ICDIPR144_TINT160                  (0x000000FFuL)
#define INTC_ICDIPR144_TINT161                  (0x0000FF00uL)
#define INTC_ICDIPR144_TINT162                  (0x00FF0000uL)
#define INTC_ICDIPR144_TINT163                  (0xFF000000uL)

#define INTC_ICDIPR145_TINT164                  (0x000000FFuL)
#define INTC_ICDIPR145_TINT165                  (0x0000FF00uL)
#define INTC_ICDIPR145_TINT166                  (0x00FF0000uL)
#define INTC_ICDIPR145_TINT167                  (0xFF000000uL)

#define INTC_ICDIPR146_TINT168                  (0x000000FFuL)
#define INTC_ICDIPR146_TINT169                  (0x0000FF00uL)
#define INTC_ICDIPR146_TINT170                  (0x00FF0000uL)

#define INTC_ICDIPTR0_SW0                       (0x000000FFuL)
#define INTC_ICDIPTR0_SW1                       (0x0000FF00uL)
#define INTC_ICDIPTR0_SW2                       (0x00FF0000uL)
#define INTC_ICDIPTR0_SW3                       (0xFF000000uL)

#define INTC_ICDIPTR1_SW4                       (0x000000FFuL)
#define INTC_ICDIPTR1_SW5                       (0x0000FF00uL)
#define INTC_ICDIPTR1_SW6                       (0x00FF0000uL)
#define INTC_ICDIPTR1_SW7                       (0xFF000000uL)

#define INTC_ICDIPTR2_SW8                       (0x000000FFuL)
#define INTC_ICDIPTR2_SW9                       (0x0000FF00uL)
#define INTC_ICDIPTR2_SW10                      (0x00FF0000uL)
#define INTC_ICDIPTR2_SW11                      (0xFF000000uL)

#define INTC_ICDIPTR3_SW12                      (0x000000FFuL)
#define INTC_ICDIPTR3_SW13                      (0x0000FF00uL)
#define INTC_ICDIPTR3_SW14                      (0x00FF0000uL)
#define INTC_ICDIPTR3_SW15                      (0xFF000000uL)

#define INTC_ICDIPTR4_PMUIRQ0                   (0x000000FFuL)
#define INTC_ICDIPTR4_COMMRX0                   (0x0000FF00uL)
#define INTC_ICDIPTR4_COMMTX0                   (0x00FF0000uL)
#define INTC_ICDIPTR4_CTIIRQ0                   (0xFF000000uL)

#define INTC_ICDIPTR8_IRQ0                      (0x000000FFuL)
#define INTC_ICDIPTR8_IRQ1                      (0x0000FF00uL)
#define INTC_ICDIPTR8_IRQ2                      (0x00FF0000uL)
#define INTC_ICDIPTR8_IRQ3                      (0xFF000000uL)

#define INTC_ICDIPTR9_IRQ4                      (0x000000FFuL)
#define INTC_ICDIPTR9_IRQ5                      (0x0000FF00uL)
#define INTC_ICDIPTR9_IRQ6                      (0x00FF0000uL)
#define INTC_ICDIPTR9_IRQ7                      (0xFF000000uL)

#define INTC_ICDIPTR10_PL310ERR                 (0x000000FFuL)
#define INTC_ICDIPTR10_DMAINT0                  (0x0000FF00uL)
#define INTC_ICDIPTR10_DMAINT1                  (0x00FF0000uL)
#define INTC_ICDIPTR10_DMAINT2                  (0xFF000000uL)

#define INTC_ICDIPTR11_DMAINT3                  (0x000000FFuL)
#define INTC_ICDIPTR11_DMAINT4                  (0x0000FF00uL)
#define INTC_ICDIPTR11_DMAINT5                  (0x00FF0000uL)
#define INTC_ICDIPTR11_DMAINT6                  (0xFF000000uL)

#define INTC_ICDIPTR12_DMAINT7                  (0x000000FFuL)
#define INTC_ICDIPTR12_DMAINT8                  (0x0000FF00uL)
#define INTC_ICDIPTR12_DMAINT9                  (0x00FF0000uL)
#define INTC_ICDIPTR12_DMAINT10                 (0xFF000000uL)

#define INTC_ICDIPTR13_DMAINT11                 (0x000000FFuL)
#define INTC_ICDIPTR13_DMAINT12                 (0x0000FF00uL)
#define INTC_ICDIPTR13_DMAINT13                 (0x00FF0000uL)
#define INTC_ICDIPTR13_DMAINT14                 (0xFF000000uL)

#define INTC_ICDIPTR14_DMAINT15                 (0x000000FFuL)
#define INTC_ICDIPTR14_DMAERR                   (0x0000FF00uL)

#define INTC_ICDIPTR18_USBI0                    (0x0000FF00uL)
#define INTC_ICDIPTR18_USBI1                    (0x00FF0000uL)
#define INTC_ICDIPTR18_S0_VI_VSYNC0             (0xFF000000uL)

#define INTC_ICDIPTR19_S0_LO_VSYNC0             (0x000000FFuL)
#define INTC_ICDIPTR19_S0_VSYNCERR0             (0x0000FF00uL)
#define INTC_ICDIPTR19_GR3_VLINE0               (0x00FF0000uL)
#define INTC_ICDIPTR19_S0_VFIELD0               (0xFF000000uL)

#define INTC_ICDIPTR20_IV1_VBUFERR0             (0x000000FFuL)
#define INTC_ICDIPTR20_IV3_VBUFERR0             (0x0000FF00uL)
#define INTC_ICDIPTR20_IV5_VBUFERR0             (0x00FF0000uL)
#define INTC_ICDIPTR20_IV6_VBUFERR0             (0xFF000000uL)

#define INTC_ICDIPTR21_S0_WLINE0                (0x000000FFuL)
#define INTC_ICDIPTR21_S1_VI_VSYNC0             (0x0000FF00uL)
#define INTC_ICDIPTR21_S1_LO_VSYNC0             (0x00FF0000uL)
#define INTC_ICDIPTR21_S1_VSYNCERR0             (0xFF000000uL)

#define INTC_ICDIPTR22_S1_VFIELD0               (0x000000FFuL)
#define INTC_ICDIPTR22_IV2_VBUFERR0             (0x0000FF00uL)
#define INTC_ICDIPTR22_IV4_VBUFERR0             (0x00FF0000uL)
#define INTC_ICDIPTR22_S1_WLINE0                (0xFF000000uL)

#define INTC_ICDIPTR23_OIR_VI_VSYNC0            (0x000000FFuL)
#define INTC_ICDIPTR23_OIR_LO_VSYNC0            (0x0000FF00uL)
#define INTC_ICDIPTR23_OIR_VSYNCERR0            (0x00FF0000uL)
#define INTC_ICDIPTR23_OIR_VFIELD0              (0xFF000000uL)

#define INTC_ICDIPTR24_IV7_VBUFERR0             (0x000000FFuL)
#define INTC_ICDIPTR24_IV8_VBUFERR0             (0x0000FF00uL)
#define INTC_ICDIPTR24_OIR_WLINE0               (0x00FF0000uL)
#define INTC_ICDIPTR24_S0_VI_VSYNC1             (0xFF000000uL)

#define INTC_ICDIPTR25_S0_LO_VSYNC1             (0x000000FFuL)
#define INTC_ICDIPTR25_S0_VSYNCERR1             (0x0000FF00uL)
#define INTC_ICDIPTR25_GR3_VLINE1               (0x00FF0000uL)
#define INTC_ICDIPTR25_S0_VFIELD1               (0xFF000000uL)

#define INTC_ICDIPTR26_IV1_VBUFERR1             (0x000000FFuL)
#define INTC_ICDIPTR26_IV3_VBUFERR1             (0x0000FF00uL)
#define INTC_ICDIPTR26_IV5_VBUFERR1             (0x00FF0000uL)
#define INTC_ICDIPTR26_IV6_VBUFERR1             (0xFF000000uL)

#define INTC_ICDIPTR27_S0_WLINE1                (0x000000FFuL)
#define INTC_ICDIPTR27_S1_VI_VSYNC1             (0x0000FF00uL)
#define INTC_ICDIPTR27_S1_LO_VSYNC1             (0x00FF0000uL)
#define INTC_ICDIPTR27_S1_VSYNCERR1             (0xFF000000uL)

#define INTC_ICDIPTR28_S1_VFIELD1               (0x000000FFuL)
#define INTC_ICDIPTR28_IV2_VBUFERR1             (0x0000FF00uL)
#define INTC_ICDIPTR28_IV4_VBUFERR1             (0x00FF0000uL)
#define INTC_ICDIPTR28_S1_WLINE1                (0xFF000000uL)

#define INTC_ICDIPTR29_OIR_VI_VSYNC1            (0x000000FFuL)
#define INTC_ICDIPTR29_OIR_LO_VSYNC1            (0x0000FF00uL)
#define INTC_ICDIPTR29_OIR_VLINE1               (0x00FF0000uL)
#define INTC_ICDIPTR29_OIR_VFIELD1              (0xFF000000uL)

#define INTC_ICDIPTR30_IV7_VBUFERR1             (0x000000FFuL)
#define INTC_ICDIPTR30_IV8_VBUFERR1             (0x0000FF00uL)
#define INTC_ICDIPTR30_OIR_WLINE1               (0x00FF0000uL)
#define INTC_ICDIPTR30_IMRDI                    (0xFF000000uL)

#define INTC_ICDIPTR31_IMR2I0                   (0x000000FFuL)
#define INTC_ICDIPTR31_IMR2I1                   (0x0000FF00uL)
#define INTC_ICDIPTR31_JEDI                     (0x00FF0000uL)
#define INTC_ICDIPTR31_JDTI                     (0xFF000000uL)

#define INTC_ICDIPTR32_CMP0                     (0x000000FFuL)
#define INTC_ICDIPTR32_CMP1                     (0x0000FF00uL)
#define INTC_ICDIPTR32_INT0                     (0x00FF0000uL)
#define INTC_ICDIPTR32_INT1                     (0xFF000000uL)

#define INTC_ICDIPTR33_INT2                     (0x000000FFuL)
#define INTC_ICDIPTR33_INT3                     (0x0000FF00uL)
#define INTC_ICDIPTR33_OSTM0TINT                (0x00FF0000uL)
#define INTC_ICDIPTR33_OSTM1TINT                (0xFF000000uL)

#define INTC_ICDIPTR34_CMI                      (0x000000FFuL)
#define INTC_ICDIPTR34_WTOUT                    (0x0000FF00uL)
#define INTC_ICDIPTR34_ITI                      (0x00FF0000uL)
#define INTC_ICDIPTR34_TGI0A                    (0xFF000000uL)

#define INTC_ICDIPTR35_TGI0B                    (0x000000FFuL)
#define INTC_ICDIPTR35_TGI0C                    (0x0000FF00uL)
#define INTC_ICDIPTR35_TGI0D                    (0x00FF0000uL)
#define INTC_ICDIPTR35_TGI0V                    (0xFF000000uL)

#define INTC_ICDIPTR36_TGI0E                    (0x000000FFuL)
#define INTC_ICDIPTR36_TGI0F                    (0x0000FF00uL)
#define INTC_ICDIPTR36_TGI1A                    (0x00FF0000uL)
#define INTC_ICDIPTR36_TGI1B                    (0xFF000000uL)

#define INTC_ICDIPTR37_TGI1V                    (0x000000FFuL)
#define INTC_ICDIPTR37_TGI1U                    (0x0000FF00uL)
#define INTC_ICDIPTR37_TGI2A                    (0x00FF0000uL)
#define INTC_ICDIPTR37_TGI2B                    (0xFF000000uL)

#define INTC_ICDIPTR38_TGI2V                    (0x000000FFuL)
#define INTC_ICDIPTR38_TGI2U                    (0x0000FF00uL)
#define INTC_ICDIPTR38_TGI3A                    (0x00FF0000uL)
#define INTC_ICDIPTR38_TGI3B                    (0xFF000000uL)

#define INTC_ICDIPTR39_TGI3C                    (0x000000FFuL)
#define INTC_ICDIPTR39_TGI3D                    (0x0000FF00uL)
#define INTC_ICDIPTR39_TGI3V                    (0x00FF0000uL)
#define INTC_ICDIPTR39_TGI4A                    (0xFF000000uL)

#define INTC_ICDIPTR40_TGI4B                    (0x000000FFuL)
#define INTC_ICDIPTR40_TGI4C                    (0x0000FF00uL)
#define INTC_ICDIPTR40_TGI4D                    (0x00FF0000uL)
#define INTC_ICDIPTR40_TGI4V                    (0xFF000000uL)

#define INTC_ICDIPTR41_CMI1                     (0x000000FFuL)
#define INTC_ICDIPTR41_CMI2                     (0x0000FF00uL)
#define INTC_ICDIPTR41_SGDEI0                   (0x00FF0000uL)
#define INTC_ICDIPTR41_SGDEI1                   (0xFF000000uL)

#define INTC_ICDIPTR42_SGDEI2                   (0x000000FFuL)
#define INTC_ICDIPTR42_SGDEI3                   (0x0000FF00uL)
#define INTC_ICDIPTR42_ADI                      (0x00FF0000uL)
#define INTC_ICDIPTR42_LMTI                     (0xFF000000uL)

#define INTC_ICDIPTR43_SSII0                    (0x000000FFuL)
#define INTC_ICDIPTR43_SSIRXI0                  (0x0000FF00uL)
#define INTC_ICDIPTR43_SSITXI0                  (0x00FF0000uL)
#define INTC_ICDIPTR43_SSII1                    (0xFF000000uL)

#define INTC_ICDIPTR44_SSIRXI1                  (0x000000FFuL)
#define INTC_ICDIPTR44_SSITXI1                  (0x0000FF00uL)
#define INTC_ICDIPTR44_SSII2                    (0x00FF0000uL)
#define INTC_ICDIPTR44_SSIRTI2                  (0xFF000000uL)

#define INTC_ICDIPTR45_SSII3                    (0x000000FFuL)
#define INTC_ICDIPTR45_SSIRXI3                  (0x0000FF00uL)
#define INTC_ICDIPTR45_SSITXI3                  (0x00FF0000uL)
#define INTC_ICDIPTR45_SSII4                    (0xFF000000uL)

#define INTC_ICDIPTR46_SSIRTI4                  (0x000000FFuL)
#define INTC_ICDIPTR46_SSII5                    (0x0000FF00uL)
#define INTC_ICDIPTR46_SSIRXI5                  (0x00FF0000uL)
#define INTC_ICDIPTR46_SSITXI5                  (0xFF000000uL)

#define INTC_ICDIPTR47_SPDIFI                   (0x000000FFuL)
#define INTC_ICDIPTR47_INTIICTEI0               (0x0000FF00uL)
#define INTC_ICDIPTR47_INTIICRI0                (0x00FF0000uL)
#define INTC_ICDIPTR47_INTIICTI0                (0xFF000000uL)

#define INTC_ICDIPTR48_INTIICSPI0               (0x000000FFuL)
#define INTC_ICDIPTR48_INTIICSTI0               (0x0000FF00uL)
#define INTC_ICDIPTR48_INTIICNAKI0              (0x00FF0000uL)
#define INTC_ICDIPTR48_INTIICALI0               (0xFF000000uL)

#define INTC_ICDIPTR49_INTIICTMOI0              (0x000000FFuL)
#define INTC_ICDIPTR49_INTIICTEI1               (0x0000FF00uL)
#define INTC_ICDIPTR49_INTIICRI1                (0x00FF0000uL)
#define INTC_ICDIPTR49_INTIICTI1                (0xFF000000uL)

#define INTC_ICDIPTR50_INTIICSPI1               (0x000000FFuL)
#define INTC_ICDIPTR50_INTIICSTI1               (0x0000FF00uL)
#define INTC_ICDIPTR50_INTIICNAKI1              (0x00FF0000uL)
#define INTC_ICDIPTR50_INTIICALI1               (0xFF000000uL)

#define INTC_ICDIPTR51_INTIICTMOI1              (0x000000FFuL)
#define INTC_ICDIPTR51_INTIICTEI2               (0x0000FF00uL)
#define INTC_ICDIPTR51_INTIICRI2                (0x00FF0000uL)
#define INTC_ICDIPTR51_INTIICTI2                (0xFF000000uL)

#define INTC_ICDIPTR52_INTIICSPI2               (0x000000FFuL)
#define INTC_ICDIPTR52_INTIICSTI2               (0x0000FF00uL)
#define INTC_ICDIPTR52_INTIICNAKI2              (0x00FF0000uL)
#define INTC_ICDIPTR52_INTIICALI2               (0xFF000000uL)

#define INTC_ICDIPTR53_INTIICTMOI2              (0x000000FFuL)
#define INTC_ICDIPTR53_INTIICTEI3               (0x0000FF00uL)
#define INTC_ICDIPTR53_INTIICRI3                (0x00FF0000uL)
#define INTC_ICDIPTR53_INTIICTI3                (0xFF000000uL)

#define INTC_ICDIPTR54_INTIICSPI3               (0x000000FFuL)
#define INTC_ICDIPTR54_INTIICSTI3               (0x0000FF00uL)
#define INTC_ICDIPTR54_INTIICNAKI3              (0x00FF0000uL)
#define INTC_ICDIPTR54_INTIICALI3               (0xFF000000uL)

#define INTC_ICDIPTR55_INTIICTMOI3              (0x000000FFuL)
#define INTC_ICDIPTR55_BRI0                     (0x0000FF00uL)
#define INTC_ICDIPTR55_ERI0                     (0x00FF0000uL)
#define INTC_ICDIPTR55_RXI0                     (0xFF000000uL)

#define INTC_ICDIPTR56_TXI0                     (0x000000FFuL)
#define INTC_ICDIPTR56_BRI1                     (0x0000FF00uL)
#define INTC_ICDIPTR56_ERI1                     (0x00FF0000uL)
#define INTC_ICDIPTR56_RXI1                     (0xFF000000uL)

#define INTC_ICDIPTR57_TXI1                     (0x000000FFuL)
#define INTC_ICDIPTR57_BRI2                     (0x0000FF00uL)
#define INTC_ICDIPTR57_ERI2                     (0x00FF0000uL)
#define INTC_ICDIPTR57_RXI2                     (0xFF000000uL)

#define INTC_ICDIPTR58_TXI2                     (0x000000FFuL)
#define INTC_ICDIPTR58_BRI3                     (0x0000FF00uL)
#define INTC_ICDIPTR58_ERI3                     (0x00FF0000uL)
#define INTC_ICDIPTR58_RXI3                     (0xFF000000uL)

#define INTC_ICDIPTR59_TXI3                     (0x000000FFuL)
#define INTC_ICDIPTR59_BRI4                     (0x0000FF00uL)
#define INTC_ICDIPTR59_ERI4                     (0x00FF0000uL)
#define INTC_ICDIPTR59_RXI4                     (0xFF000000uL)

#define INTC_ICDIPTR60_TXI4                     (0x000000FFuL)
#define INTC_ICDIPTR60_BRI5                     (0x0000FF00uL)
#define INTC_ICDIPTR60_ERI5                     (0x00FF0000uL)
#define INTC_ICDIPTR60_RXI5                     (0xFF000000uL)

#define INTC_ICDIPTR61_TXI5                     (0x000000FFuL)
#define INTC_ICDIPTR61_BRI6                     (0x0000FF00uL)
#define INTC_ICDIPTR61_ERI6                     (0x00FF0000uL)
#define INTC_ICDIPTR61_RXI6                     (0xFF000000uL)

#define INTC_ICDIPTR62_TXI6                     (0x000000FFuL)
#define INTC_ICDIPTR62_BRI7                     (0x0000FF00uL)
#define INTC_ICDIPTR62_ERI7                     (0x00FF0000uL)
#define INTC_ICDIPTR62_RXI7                     (0xFF000000uL)

#define INTC_ICDIPTR63_TXI7                     (0x000000FFuL)
#define INTC_ICDIPTR63_INTRCANGERR              (0x0000FF00uL)
#define INTC_ICDIPTR63_INTRCANGRECC             (0x00FF0000uL)
#define INTC_ICDIPTR63_INTRCAN0REC              (0xFF000000uL)

#define INTC_ICDIPTR64_INTRCAN0ERR              (0x000000FFuL)
#define INTC_ICDIPTR64_INTRCAN0TRX              (0x0000FF00uL)
#define INTC_ICDIPTR64_INTRCAN1REC              (0x00FF0000uL)
#define INTC_ICDIPTR64_INTRCAN1ERR              (0xFF000000uL)

#define INTC_ICDIPTR65_INTRCAN1TRX              (0x000000FFuL)
#define INTC_ICDIPTR65_INTRCAN2REC              (0x0000FF00uL)
#define INTC_ICDIPTR65_INTRCAN2ERR              (0x00FF0000uL)
#define INTC_ICDIPTR65_INTRCAN2TRX              (0xFF000000uL)

#define INTC_ICDIPTR66_INTRCAN3REC              (0x000000FFuL)
#define INTC_ICDIPTR66_INTRCAN3ERR              (0x0000FF00uL)
#define INTC_ICDIPTR66_INTRCAN3TRX              (0x00FF0000uL)
#define INTC_ICDIPTR66_INTRCAN4REC              (0xFF000000uL)

#define INTC_ICDIPTR67_INTRCAN4ERR              (0x000000FFuL)
#define INTC_ICDIPTR67_INTRCAN4TRX              (0x0000FF00uL)
#define INTC_ICDIPTR67_SPEI0                    (0x00FF0000uL)
#define INTC_ICDIPTR67_SPRI0                    (0xFF000000uL)

#define INTC_ICDIPTR68_SPTI0                    (0x000000FFuL)
#define INTC_ICDIPTR68_SPEI1                    (0x0000FF00uL)
#define INTC_ICDIPTR68_SPRI1                    (0x00FF0000uL)
#define INTC_ICDIPTR68_SPTI1                    (0xFF000000uL)

#define INTC_ICDIPTR69_SPEI2                    (0x000000FFuL)
#define INTC_ICDIPTR69_SPRI2                    (0x0000FF00uL)
#define INTC_ICDIPTR69_SPTI2                    (0x00FF0000uL)
#define INTC_ICDIPTR69_SPEI3                    (0xFF000000uL)

#define INTC_ICDIPTR70_SPRI3                    (0x000000FFuL)
#define INTC_ICDIPTR70_SPTI3                    (0x0000FF00uL)
#define INTC_ICDIPTR70_SPEI4                    (0x00FF0000uL)
#define INTC_ICDIPTR70_SPRI4                    (0xFF000000uL)

#define INTC_ICDIPTR71_SPTI4                    (0x000000FFuL)
#define INTC_ICDIPTR71_IEBBTD                   (0x0000FF00uL)
#define INTC_ICDIPTR71_IEBBTERR                 (0x00FF0000uL)
#define INTC_ICDIPTR71_IEBBTSTA                 (0xFF000000uL)

#define INTC_ICDIPTR72_IEBBTV                   (0x000000FFuL)
#define INTC_ICDIPTR72_ISY                      (0x0000FF00uL)
#define INTC_ICDIPTR72_IERR                     (0x00FF0000uL)
#define INTC_ICDIPTR72_ITARG                    (0xFF000000uL)

#define INTC_ICDIPTR73_ISEC                     (0x000000FFuL)
#define INTC_ICDIPTR73_IBUF                     (0x0000FF00uL)
#define INTC_ICDIPTR73_IREADY                   (0x00FF0000uL)
#define INTC_ICDIPTR73_FLSTE                    (0xFF000000uL)

#define INTC_ICDIPTR74_FLTENDI                  (0x000000FFuL)
#define INTC_ICDIPTR74_FLTREQ0I                 (0x0000FF00uL)
#define INTC_ICDIPTR74_FLTREQ1I                 (0x00FF0000uL)
#define INTC_ICDIPTR74_MMC0                     (0xFF000000uL)

#define INTC_ICDIPTR75_MMC1                     (0x000000FFuL)
#define INTC_ICDIPTR75_MMC2                     (0x0000FF00uL)
#define INTC_ICDIPTR75_SDHI0_3                  (0x00FF0000uL)
#define INTC_ICDIPTR75_SDHI0_0                  (0xFF000000uL)

#define INTC_ICDIPTR76_SDHI0_1                  (0x000000FFuL)
#define INTC_ICDIPTR76_SDHI1_3                  (0x0000FF00uL)
#define INTC_ICDIPTR76_SDHI1_0                  (0x00FF0000uL)
#define INTC_ICDIPTR76_SDHI1_1                  (0xFF000000uL)

#define INTC_ICDIPTR77_ARM                      (0x000000FFuL)
#define INTC_ICDIPTR77_PRD                      (0x0000FF00uL)
#define INTC_ICDIPTR77_CUP                      (0x00FF0000uL)
#define INTC_ICDIPTR77_SCUAI0                   (0xFF000000uL)

#define INTC_ICDIPTR78_SCUAI1                   (0x000000FFuL)
#define INTC_ICDIPTR78_SCUFDI0                  (0x0000FF00uL)
#define INTC_ICDIPTR78_SCUFDI1                  (0x00FF0000uL)
#define INTC_ICDIPTR78_SCUFDI2                  (0xFF000000uL)

#define INTC_ICDIPTR79_SCUFDI3                  (0x000000FFuL)
#define INTC_ICDIPTR79_SCUFUI0                  (0x0000FF00uL)
#define INTC_ICDIPTR79_SCUFUI1                  (0x00FF0000uL)
#define INTC_ICDIPTR79_SCUFUI2                  (0xFF000000uL)

#define INTC_ICDIPTR80_SCUFUI3                  (0x000000FFuL)
#define INTC_ICDIPTR80_SCUDVI0                  (0x0000FF00uL)
#define INTC_ICDIPTR80_SCUDVI1                  (0x00FF0000uL)
#define INTC_ICDIPTR80_SCUDVI2                  (0xFF000000uL)

#define INTC_ICDIPTR81_SCUDVI3                  (0x000000FFuL)
#define INTC_ICDIPTR81_MLB_CINT                 (0x0000FF00uL)
#define INTC_ICDIPTR81_MLB_SINT                 (0x00FF0000uL)
#define INTC_ICDIPTR81_DRC0                     (0xFF000000uL)

#define INTC_ICDIPTR82_DRC1                     (0x000000FFuL)
#define INTC_ICDIPTR82_LINI0_INT_T              (0xFF000000uL)

#define INTC_ICDIPTR83_LINI0_INT_R              (0x000000FFuL)
#define INTC_ICDIPTR83_LINI0_INT_S              (0x0000FF00uL)
#define INTC_ICDIPTR83_LINI0_INT_M              (0x00FF0000uL)
#define INTC_ICDIPTR83_LINI1_INT_T              (0xFF000000uL)

#define INTC_ICDIPTR84_LINI1_INT_R              (0x000000FFuL)
#define INTC_ICDIPTR84_LINI1_INT_S              (0x0000FF00uL)
#define INTC_ICDIPTR84_LINI1_INT_M              (0x00FF0000uL)

#define INTC_ICDIPTR86_ERI0                     (0xFF000000uL)

#define INTC_ICDIPTR87_RXI0                     (0x000000FFuL)
#define INTC_ICDIPTR87_TXI0                     (0x0000FF00uL)
#define INTC_ICDIPTR87_TEI0                     (0x00FF0000uL)
#define INTC_ICDIPTR87_ERI1                     (0xFF000000uL)

#define INTC_ICDIPTR88_RXI1                     (0x000000FFuL)
#define INTC_ICDIPTR88_TXI1                     (0x0000FF00uL)
#define INTC_ICDIPTR88_TEI1                     (0x00FF0000uL)
#define INTC_ICDIPTR88_AVBI_DATA                (0xFF000000uL)

#define INTC_ICDIPTR89_AVBI_ERROR               (0x000000FFuL)
#define INTC_ICDIPTR89_AVBI_MANAGE              (0x0000FF00uL)
#define INTC_ICDIPTR89_AVBI_MAC                 (0x00FF0000uL)
#define INTC_ICDIPTR89_ETHERI                   (0xFF000000uL)

#define INTC_ICDIPTR91_CEUI                     (0x000000FFuL)

#define INTC_ICDIPTR95_H2XMLB_ERRINT            (0x0000FF00uL)
#define INTC_ICDIPTR95_H2XIC1_ERRINT            (0x00FF0000uL)
#define INTC_ICDIPTR95_X2HPERI1_ERRINT          (0xFF000000uL)

#define INTC_ICDIPTR96_X2HPERI2_ERRINT          (0x000000FFuL)
#define INTC_ICDIPTR96_X2HPERI34_ERRINT         (0x0000FF00uL)
#define INTC_ICDIPTR96_X2HPERI5_ERRINT          (0x00FF0000uL)
#define INTC_ICDIPTR96_X2HPERI67_ERRINT         (0xFF000000uL)

#define INTC_ICDIPTR97_X2HDBGR_ERRINT           (0x000000FFuL)
#define INTC_ICDIPTR97_X2HBSC_ERRINT            (0x0000FF00uL)
#define INTC_ICDIPTR97_X2HSPI1_ERRINT           (0x00FF0000uL)
#define INTC_ICDIPTR97_X2HSPI2_ERRINT           (0xFF000000uL)

#define INTC_ICDIPTR98_PRRI                     (0x000000FFuL)
#define INTC_ICDIPTR98_IFEI0                    (0x0000FF00uL)
#define INTC_ICDIPTR98_OFFI0                    (0x00FF0000uL)
#define INTC_ICDIPTR98_PFVEI0                   (0xFF000000uL)

#define INTC_ICDIPTR99_IFEI1                    (0x000000FFuL)
#define INTC_ICDIPTR99_OFFI1                    (0x0000FF00uL)
#define INTC_ICDIPTR99_PFVEI1                   (0x00FF0000uL)

#define INTC_ICDIPTR104_TINT0                   (0x000000FFuL)
#define INTC_ICDIPTR104_TINT1                   (0x0000FF00uL)
#define INTC_ICDIPTR104_TINT2                   (0x00FF0000uL)
#define INTC_ICDIPTR104_TINT3                   (0xFF000000uL)

#define INTC_ICDIPTR105_TINT4                   (0x000000FFuL)
#define INTC_ICDIPTR105_TINT5                   (0x0000FF00uL)
#define INTC_ICDIPTR105_TINT6                   (0x00FF0000uL)
#define INTC_ICDIPTR105_TINT7                   (0xFF000000uL)

#define INTC_ICDIPTR106_TINT8                   (0x000000FFuL)
#define INTC_ICDIPTR106_TINT9                   (0x0000FF00uL)
#define INTC_ICDIPTR106_TINT10                  (0x00FF0000uL)
#define INTC_ICDIPTR106_TINT11                  (0xFF000000uL)

#define INTC_ICDIPTR107_TINT12                  (0x000000FFuL)
#define INTC_ICDIPTR107_TINT13                  (0x0000FF00uL)
#define INTC_ICDIPTR107_TINT14                  (0x00FF0000uL)
#define INTC_ICDIPTR107_TINT15                  (0xFF000000uL)

#define INTC_ICDIPTR108_TINT16                  (0x000000FFuL)
#define INTC_ICDIPTR108_TINT17                  (0x0000FF00uL)
#define INTC_ICDIPTR108_TINT18                  (0x00FF0000uL)
#define INTC_ICDIPTR108_TINT19                  (0xFF000000uL)

#define INTC_ICDIPTR109_TINT20                  (0x000000FFuL)
#define INTC_ICDIPTR109_TINT21                  (0x0000FF00uL)
#define INTC_ICDIPTR109_TINT22                  (0x00FF0000uL)
#define INTC_ICDIPTR109_TINT23                  (0xFF000000uL)

#define INTC_ICDIPTR110_TINT24                  (0x000000FFuL)
#define INTC_ICDIPTR110_TINT25                  (0x0000FF00uL)
#define INTC_ICDIPTR110_TINT26                  (0x00FF0000uL)
#define INTC_ICDIPTR110_TINT27                  (0xFF000000uL)

#define INTC_ICDIPTR111_TINT28                  (0x000000FFuL)
#define INTC_ICDIPTR111_TINT29                  (0x0000FF00uL)
#define INTC_ICDIPTR111_TINT30                  (0x00FF0000uL)
#define INTC_ICDIPTR111_TINT31                  (0xFF000000uL)

#define INTC_ICDIPTR112_TINT32                  (0x000000FFuL)
#define INTC_ICDIPTR112_TINT33                  (0x0000FF00uL)
#define INTC_ICDIPTR112_TINT34                  (0x00FF0000uL)
#define INTC_ICDIPTR112_TINT35                  (0xFF000000uL)

#define INTC_ICDIPTR113_TINT36                  (0x000000FFuL)
#define INTC_ICDIPTR113_TINT37                  (0x0000FF00uL)
#define INTC_ICDIPTR113_TINT38                  (0x00FF0000uL)
#define INTC_ICDIPTR113_TINT39                  (0xFF000000uL)

#define INTC_ICDIPTR114_TINT40                  (0x000000FFuL)
#define INTC_ICDIPTR114_TINT41                  (0x0000FF00uL)
#define INTC_ICDIPTR114_TINT42                  (0x00FF0000uL)
#define INTC_ICDIPTR114_TINT43                  (0xFF000000uL)

#define INTC_ICDIPTR115_TINT44                  (0x000000FFuL)
#define INTC_ICDIPTR115_TINT45                  (0x0000FF00uL)
#define INTC_ICDIPTR115_TINT46                  (0x00FF0000uL)
#define INTC_ICDIPTR115_TINT47                  (0xFF000000uL)

#define INTC_ICDIPTR116_TINT48                  (0x000000FFuL)
#define INTC_ICDIPTR116_TINT49                  (0x0000FF00uL)
#define INTC_ICDIPTR116_TINT50                  (0x00FF0000uL)
#define INTC_ICDIPTR116_TINT51                  (0xFF000000uL)

#define INTC_ICDIPTR117_TINT52                  (0x000000FFuL)
#define INTC_ICDIPTR117_TINT53                  (0x0000FF00uL)
#define INTC_ICDIPTR117_TINT54                  (0x00FF0000uL)
#define INTC_ICDIPTR117_TINT55                  (0xFF000000uL)

#define INTC_ICDIPTR118_TINT56                  (0x000000FFuL)
#define INTC_ICDIPTR118_TINT57                  (0x0000FF00uL)
#define INTC_ICDIPTR118_TINT58                  (0x00FF0000uL)
#define INTC_ICDIPTR118_TINT59                  (0xFF000000uL)

#define INTC_ICDIPTR119_TINT60                  (0x000000FFuL)
#define INTC_ICDIPTR119_TINT61                  (0x0000FF00uL)
#define INTC_ICDIPTR119_TINT62                  (0x00FF0000uL)
#define INTC_ICDIPTR119_TINT63                  (0xFF000000uL)

#define INTC_ICDIPTR120_TINT64                  (0x000000FFuL)
#define INTC_ICDIPTR120_TINT65                  (0x0000FF00uL)
#define INTC_ICDIPTR120_TINT66                  (0x00FF0000uL)
#define INTC_ICDIPTR120_TINT67                  (0xFF000000uL)

#define INTC_ICDIPTR121_TINT68                  (0x000000FFuL)
#define INTC_ICDIPTR121_TINT69                  (0x0000FF00uL)
#define INTC_ICDIPTR121_TINT70                  (0x00FF0000uL)
#define INTC_ICDIPTR121_TINT71                  (0xFF000000uL)

#define INTC_ICDIPTR122_TINT72                  (0x000000FFuL)
#define INTC_ICDIPTR122_TINT73                  (0x0000FF00uL)
#define INTC_ICDIPTR122_TINT74                  (0x00FF0000uL)
#define INTC_ICDIPTR122_TINT75                  (0xFF000000uL)

#define INTC_ICDIPTR123_TINT76                  (0x000000FFuL)
#define INTC_ICDIPTR123_TINT77                  (0x0000FF00uL)
#define INTC_ICDIPTR123_TINT78                  (0x00FF0000uL)
#define INTC_ICDIPTR123_TINT79                  (0xFF000000uL)

#define INTC_ICDIPTR124_TINT80                  (0x000000FFuL)
#define INTC_ICDIPTR124_TINT81                  (0x0000FF00uL)
#define INTC_ICDIPTR124_TINT82                  (0x00FF0000uL)
#define INTC_ICDIPTR124_TINT83                  (0xFF000000uL)

#define INTC_ICDIPTR125_TINT84                  (0x000000FFuL)
#define INTC_ICDIPTR125_TINT85                  (0x0000FF00uL)
#define INTC_ICDIPTR125_TINT86                  (0x00FF0000uL)
#define INTC_ICDIPTR125_TINT87                  (0xFF000000uL)

#define INTC_ICDIPTR126_TINT88                  (0x000000FFuL)
#define INTC_ICDIPTR126_TINT89                  (0x0000FF00uL)
#define INTC_ICDIPTR126_TINT90                  (0x00FF0000uL)
#define INTC_ICDIPTR126_TINT91                  (0xFF000000uL)

#define INTC_ICDIPTR127_TINT92                  (0x000000FFuL)
#define INTC_ICDIPTR127_TINT93                  (0x0000FF00uL)
#define INTC_ICDIPTR127_TINT94                  (0x00FF0000uL)
#define INTC_ICDIPTR127_TINT95                  (0xFF000000uL)

#define INTC_ICDIPTR128_TINT96                  (0x000000FFuL)
#define INTC_ICDIPTR128_TINT97                  (0x0000FF00uL)
#define INTC_ICDIPTR128_TINT98                  (0x00FF0000uL)
#define INTC_ICDIPTR128_TINT99                  (0xFF000000uL)

#define INTC_ICDIPTR129_TINT100                 (0x000000FFuL)
#define INTC_ICDIPTR129_TINT101                 (0x0000FF00uL)
#define INTC_ICDIPTR129_TINT102                 (0x00FF0000uL)
#define INTC_ICDIPTR129_TINT103                 (0xFF000000uL)

#define INTC_ICDIPTR130_TINT104                 (0x000000FFuL)
#define INTC_ICDIPTR130_TINT105                 (0x0000FF00uL)
#define INTC_ICDIPTR130_TINT106                 (0x00FF0000uL)
#define INTC_ICDIPTR130_TINT107                 (0xFF000000uL)

#define INTC_ICDIPTR131_TINT108                 (0x000000FFuL)
#define INTC_ICDIPTR131_TINT109                 (0x0000FF00uL)
#define INTC_ICDIPTR131_TINT110                 (0x00FF0000uL)
#define INTC_ICDIPTR131_TINT111                 (0xFF000000uL)

#define INTC_ICDIPTR132_TINT112                 (0x000000FFuL)
#define INTC_ICDIPTR132_TINT113                 (0x0000FF00uL)
#define INTC_ICDIPTR132_TINT114                 (0x00FF0000uL)
#define INTC_ICDIPTR132_TINT115                 (0xFF000000uL)

#define INTC_ICDIPTR133_TINT116                 (0x000000FFuL)
#define INTC_ICDIPTR133_TINT117                 (0x0000FF00uL)
#define INTC_ICDIPTR133_TINT118                 (0x00FF0000uL)
#define INTC_ICDIPTR133_TINT119                 (0xFF000000uL)

#define INTC_ICDIPTR134_TINT120                 (0x000000FFuL)
#define INTC_ICDIPTR134_TINT121                 (0x0000FF00uL)
#define INTC_ICDIPTR134_TINT122                 (0x00FF0000uL)
#define INTC_ICDIPTR134_TINT123                 (0xFF000000uL)

#define INTC_ICDIPTR135_TINT124                 (0x000000FFuL)
#define INTC_ICDIPTR135_TINT125                 (0x0000FF00uL)
#define INTC_ICDIPTR135_TINT126                 (0x00FF0000uL)
#define INTC_ICDIPTR135_TINT127                 (0xFF000000uL)

#define INTC_ICDIPTR136_TINT128                 (0x000000FFuL)
#define INTC_ICDIPTR136_TINT129                 (0x0000FF00uL)
#define INTC_ICDIPTR136_TINT130                 (0x00FF0000uL)
#define INTC_ICDIPTR136_TINT131                 (0xFF000000uL)

#define INTC_ICDIPTR137_TINT132                 (0x000000FFuL)
#define INTC_ICDIPTR137_TINT133                 (0x0000FF00uL)
#define INTC_ICDIPTR137_TINT134                 (0x00FF0000uL)
#define INTC_ICDIPTR137_TINT135                 (0xFF000000uL)

#define INTC_ICDIPTR138_TINT136                 (0x000000FFuL)
#define INTC_ICDIPTR138_TINT137                 (0x0000FF00uL)
#define INTC_ICDIPTR138_TINT138                 (0x00FF0000uL)
#define INTC_ICDIPTR138_TINT139                 (0xFF000000uL)

#define INTC_ICDIPTR139_TINT140                 (0x000000FFuL)
#define INTC_ICDIPTR139_TINT141                 (0x0000FF00uL)
#define INTC_ICDIPTR139_TINT142                 (0x00FF0000uL)
#define INTC_ICDIPTR139_TINT143                 (0xFF000000uL)

#define INTC_ICDIPTR140_TINT144                 (0x000000FFuL)
#define INTC_ICDIPTR140_TINT145                 (0x0000FF00uL)
#define INTC_ICDIPTR140_TINT146                 (0x00FF0000uL)
#define INTC_ICDIPTR140_TINT147                 (0xFF000000uL)

#define INTC_ICDIPTR141_TINT148                 (0x000000FFuL)
#define INTC_ICDIPTR141_TINT149                 (0x0000FF00uL)
#define INTC_ICDIPTR141_TINT150                 (0x00FF0000uL)
#define INTC_ICDIPTR141_TINT151                 (0xFF000000uL)

#define INTC_ICDIPTR142_TINT152                 (0x000000FFuL)
#define INTC_ICDIPTR142_TINT153                 (0x0000FF00uL)
#define INTC_ICDIPTR142_TINT154                 (0x00FF0000uL)
#define INTC_ICDIPTR142_TINT155                 (0xFF000000uL)

#define INTC_ICDIPTR143_TINT156                 (0x000000FFuL)
#define INTC_ICDIPTR143_TINT157                 (0x0000FF00uL)
#define INTC_ICDIPTR143_TINT158                 (0x00FF0000uL)
#define INTC_ICDIPTR143_TINT159                 (0xFF000000uL)

#define INTC_ICDIPTR144_TINT160                 (0x000000FFuL)
#define INTC_ICDIPTR144_TINT161                 (0x0000FF00uL)
#define INTC_ICDIPTR144_TINT162                 (0x00FF0000uL)
#define INTC_ICDIPTR144_TINT163                 (0xFF000000uL)

#define INTC_ICDIPTR145_TINT164                 (0x000000FFuL)
#define INTC_ICDIPTR145_TINT165                 (0x0000FF00uL)
#define INTC_ICDIPTR145_TINT166                 (0x00FF0000uL)
#define INTC_ICDIPTR145_TINT167                 (0xFF000000uL)

#define INTC_ICDIPTR146_TINT168                 (0x000000FFuL)
#define INTC_ICDIPTR146_TINT169                 (0x0000FF00uL)
#define INTC_ICDIPTR146_TINT170                 (0x00FF0000uL)

#define INTC_ICDICFR0_SW0_0                     (0x00000001uL)
#define INTC_ICDICFR0_SW0_1                     (0x00000002uL)
#define INTC_ICDICFR0_SW1_0                     (0x00000004uL)
#define INTC_ICDICFR0_SW1_1                     (0x00000008uL)
#define INTC_ICDICFR0_SW2_0                     (0x00000010uL)
#define INTC_ICDICFR0_SW2_1                     (0x00000020uL)
#define INTC_ICDICFR0_SW3_0                     (0x00000040uL)
#define INTC_ICDICFR0_SW3_1                     (0x00000080uL)
#define INTC_ICDICFR0_SW4_0                     (0x00000100uL)
#define INTC_ICDICFR0_SW4_1                     (0x00000200uL)
#define INTC_ICDICFR0_SW5_0                     (0x00000400uL)
#define INTC_ICDICFR0_SW5_1                     (0x00000800uL)
#define INTC_ICDICFR0_SW6_0                     (0x00001000uL)
#define INTC_ICDICFR0_SW6_1                     (0x00002000uL)
#define INTC_ICDICFR0_SW7_0                     (0x00004000uL)
#define INTC_ICDICFR0_SW7_1                     (0x00008000uL)
#define INTC_ICDICFR0_SW8_0                     (0x00010000uL)
#define INTC_ICDICFR0_SW8_1                     (0x00020000uL)
#define INTC_ICDICFR0_SW9_0                     (0x00040000uL)
#define INTC_ICDICFR0_SW9_1                     (0x00080000uL)
#define INTC_ICDICFR0_SW10_0                    (0x00100000uL)
#define INTC_ICDICFR0_SW10_1                    (0x00200000uL)
#define INTC_ICDICFR0_SW11_0                    (0x00400000uL)
#define INTC_ICDICFR0_SW11_1                    (0x00800000uL)
#define INTC_ICDICFR0_SW12_0                    (0x01000000uL)
#define INTC_ICDICFR0_SW12_1                    (0x02000000uL)
#define INTC_ICDICFR0_SW13_0                    (0x04000000uL)
#define INTC_ICDICFR0_SW13_1                    (0x08000000uL)
#define INTC_ICDICFR0_SW14_0                    (0x10000000uL)
#define INTC_ICDICFR0_SW14_1                    (0x20000000uL)
#define INTC_ICDICFR0_SW15_0                    (0x40000000uL)
#define INTC_ICDICFR0_SW15_1                    (0x80000000uL)

#define INTC_ICDICFR1_PMUIRQ0_0                 (0x00000001uL)
#define INTC_ICDICFR1_PMUIRQ0_1                 (0x00000002uL)
#define INTC_ICDICFR1_COMMRX0_0                 (0x00000004uL)
#define INTC_ICDICFR1_COMMRX0_1                 (0x00000008uL)
#define INTC_ICDICFR1_COMMTX0_0                 (0x00000010uL)
#define INTC_ICDICFR1_COMMTX0_1                 (0x00000020uL)
#define INTC_ICDICFR1_CTIIRQ0_0                 (0x00000040uL)
#define INTC_ICDICFR1_CTIIRQ0_1                 (0x00000080uL)

#define INTC_ICDICFR2_IRQ0_0                    (0x00000001uL)
#define INTC_ICDICFR2_IRQ0_1                    (0x00000002uL)
#define INTC_ICDICFR2_IRQ1_0                    (0x00000004uL)
#define INTC_ICDICFR2_IRQ1_1                    (0x00000008uL)
#define INTC_ICDICFR2_IRQ2_0                    (0x00000010uL)
#define INTC_ICDICFR2_IRQ2_1                    (0x00000020uL)
#define INTC_ICDICFR2_IRQ3_0                    (0x00000040uL)
#define INTC_ICDICFR2_IRQ3_1                    (0x00000080uL)
#define INTC_ICDICFR2_IRQ4_0                    (0x00000100uL)
#define INTC_ICDICFR2_IRQ4_1                    (0x00000200uL)
#define INTC_ICDICFR2_IRQ5_0                    (0x00000400uL)
#define INTC_ICDICFR2_IRQ5_1                    (0x00000800uL)
#define INTC_ICDICFR2_IRQ6_0                    (0x00001000uL)
#define INTC_ICDICFR2_IRQ6_1                    (0x00002000uL)
#define INTC_ICDICFR2_IRQ7_0                    (0x00004000uL)
#define INTC_ICDICFR2_IRQ7_1                    (0x00008000uL)
#define INTC_ICDICFR2_PL310ERR_0                (0x00010000uL)
#define INTC_ICDICFR2_PL310ERR_1                (0x00020000uL)
#define INTC_ICDICFR2_DMAINT0_0                 (0x00040000uL)
#define INTC_ICDICFR2_DMAINT0_1                 (0x00080000uL)
#define INTC_ICDICFR2_DMAINT1_0                 (0x00100000uL)
#define INTC_ICDICFR2_DMAINT1_1                 (0x00200000uL)
#define INTC_ICDICFR2_DMAINT2_0                 (0x00400000uL)
#define INTC_ICDICFR2_DMAINT2_1                 (0x00800000uL)
#define INTC_ICDICFR2_DMAINT3_0                 (0x01000000uL)
#define INTC_ICDICFR2_DMAINT3_1                 (0x02000000uL)
#define INTC_ICDICFR2_DMAINT4_0                 (0x04000000uL)
#define INTC_ICDICFR2_DMAINT4_1                 (0x08000000uL)
#define INTC_ICDICFR2_DMAINT5_0                 (0x10000000uL)
#define INTC_ICDICFR2_DMAINT5_1                 (0x20000000uL)
#define INTC_ICDICFR2_DMAINT6_0                 (0x40000000uL)
#define INTC_ICDICFR2_DMAINT6_1                 (0x80000000uL)

#define INTC_ICDICFR3_DMAINT7_0                 (0x00000001uL)
#define INTC_ICDICFR3_DMAINT7_1                 (0x00000002uL)
#define INTC_ICDICFR3_DMAINT8_0                 (0x00000004uL)
#define INTC_ICDICFR3_DMAINT8_1                 (0x00000008uL)
#define INTC_ICDICFR3_DMAINT9_0                 (0x00000010uL)
#define INTC_ICDICFR3_DMAINT9_1                 (0x00000020uL)
#define INTC_ICDICFR3_DMAINT10_0                (0x00000040uL)
#define INTC_ICDICFR3_DMAINT10_1                (0x00000080uL)
#define INTC_ICDICFR3_DMAINT11_0                (0x00000100uL)
#define INTC_ICDICFR3_DMAINT11_1                (0x00000200uL)
#define INTC_ICDICFR3_DMAINT12_0                (0x00000400uL)
#define INTC_ICDICFR3_DMAINT12_1                (0x00000800uL)
#define INTC_ICDICFR3_DMAINT13_0                (0x00001000uL)
#define INTC_ICDICFR3_DMAINT13_1                (0x00002000uL)
#define INTC_ICDICFR3_DMAINT14_0                (0x00004000uL)
#define INTC_ICDICFR3_DMAINT14_1                (0x00008000uL)
#define INTC_ICDICFR3_DMAINT15_0                (0x00010000uL)
#define INTC_ICDICFR3_DMAINT15_1                (0x00020000uL)
#define INTC_ICDICFR3_DMAERR_0                  (0x00040000uL)
#define INTC_ICDICFR3_DMAERR_1                  (0x00080000uL)

#define INTC_ICDICFR4_USBI0_0                   (0x00040000uL)
#define INTC_ICDICFR4_USBI0_1                   (0x00080000uL)
#define INTC_ICDICFR4_USBI1_0                   (0x00100000uL)
#define INTC_ICDICFR4_USBI1_1                   (0x00200000uL)
#define INTC_ICDICFR4_S0_VI_VSYNC0_0            (0x00400000uL)
#define INTC_ICDICFR4_S0_VI_VSYNC0_1            (0x00800000uL)
#define INTC_ICDICFR4_S0_LO_VSYNC0_0            (0x01000000uL)
#define INTC_ICDICFR4_S0_LO_VSYNC0_1            (0x02000000uL)
#define INTC_ICDICFR4_S0_VSYNCERR0_0            (0x04000000uL)
#define INTC_ICDICFR4_S0_VSYNCERR0_1            (0x08000000uL)
#define INTC_ICDICFR4_GR3_VLINE0_0              (0x10000000uL)
#define INTC_ICDICFR4_GR3_VLINE0_1              (0x20000000uL)
#define INTC_ICDICFR4_S0_VFIELD0_0              (0x40000000uL)
#define INTC_ICDICFR4_S0_VFIELD0_1              (0x80000000uL)

#define INTC_ICDICFR5_IV1_VBUFERR0_0            (0x00000001uL)
#define INTC_ICDICFR5_IV1_VBUFERR0_1            (0x00000002uL)
#define INTC_ICDICFR5_IV3_VBUFERR0_0            (0x00000004uL)
#define INTC_ICDICFR5_IV3_VBUFERR0_1            (0x00000008uL)
#define INTC_ICDICFR5_IV5_VBUFERR0_0            (0x00000010uL)
#define INTC_ICDICFR5_IV5_VBUFERR0_1            (0x00000020uL)
#define INTC_ICDICFR5_IV6_VBUFERR0_0            (0x00000040uL)
#define INTC_ICDICFR5_IV6_VBUFERR0_1            (0x00000080uL)
#define INTC_ICDICFR5_S0_WLINE0_0               (0x00000100uL)
#define INTC_ICDICFR5_S0_WLINE0_1               (0x00000200uL)
#define INTC_ICDICFR5_S1_VI_VSYNC0_0            (0x00000400uL)
#define INTC_ICDICFR5_S1_VI_VSYNC0_1            (0x00000800uL)
#define INTC_ICDICFR5_S1_LO_VSYNC0_0            (0x00001000uL)
#define INTC_ICDICFR5_S1_LO_VSYNC0_1            (0x00002000uL)
#define INTC_ICDICFR5_S1_VSYNCERR0_0            (0x00004000uL)
#define INTC_ICDICFR5_S1_VSYNCERR0_1            (0x00008000uL)
#define INTC_ICDICFR5_S1_VFIELD0_0              (0x00010000uL)
#define INTC_ICDICFR5_S1_VFIELD0_1              (0x00020000uL)
#define INTC_ICDICFR5_IV2_VBUFERR0_0            (0x00040000uL)
#define INTC_ICDICFR5_IV2_VBUFERR0_1            (0x00080000uL)
#define INTC_ICDICFR5_IV4_VBUFERR0_0            (0x00100000uL)
#define INTC_ICDICFR5_IV4_VBUFERR0_1            (0x00200000uL)
#define INTC_ICDICFR5_S1_WLINE0_0               (0x00400000uL)
#define INTC_ICDICFR5_S1_WLINE0_1               (0x00800000uL)
#define INTC_ICDICFR5_OIR_VI_VSYNC0_0           (0x01000000uL)
#define INTC_ICDICFR5_OIR_VI_VSYNC0_1           (0x02000000uL)
#define INTC_ICDICFR5_OIR_LO_VSYNC0_0           (0x04000000uL)
#define INTC_ICDICFR5_OIR_LO_VSYNC0_1           (0x08000000uL)
#define INTC_ICDICFR5_OIR_VSYNCERR0_0           (0x10000000uL)
#define INTC_ICDICFR5_OIR_VSYNCERR0_1           (0x20000000uL)
#define INTC_ICDICFR5_OIR_VFIELD0_0             (0x40000000uL)
#define INTC_ICDICFR5_OIR_VFIELD0_1             (0x80000000uL)

#define INTC_ICDICFR6_IV7_VBUFERR0_0            (0x00000001uL)
#define INTC_ICDICFR6_IV7_VBUFERR0_1            (0x00000002uL)
#define INTC_ICDICFR6_IV8_VBUFERR0_0            (0x00000004uL)
#define INTC_ICDICFR6_IV8_VBUFERR0_1            (0x00000008uL)
#define INTC_ICDICFR6_OIR_WLINE0_0              (0x00000010uL)
#define INTC_ICDICFR6_OIR_WLINE0_1              (0x00000020uL)
#define INTC_ICDICFR6_S0_VI_VSYNC1_0            (0x00000040uL)
#define INTC_ICDICFR6_S0_VI_VSYNC1_1            (0x00000080uL)
#define INTC_ICDICFR6_S0_LO_VSYNC1_0            (0x00000100uL)
#define INTC_ICDICFR6_S0_LO_VSYNC1_1            (0x00000200uL)
#define INTC_ICDICFR6_S0_VSYNCERR1_0            (0x00000400uL)
#define INTC_ICDICFR6_S0_VSYNCERR1_1            (0x00000800uL)
#define INTC_ICDICFR6_GR3_VLINE1_0              (0x00001000uL)
#define INTC_ICDICFR6_GR3_VLINE1_1              (0x00002000uL)
#define INTC_ICDICFR6_S0_VFIELD1_0              (0x00004000uL)
#define INTC_ICDICFR6_S0_VFIELD1_1              (0x00008000uL)
#define INTC_ICDICFR6_IV1_VBUFERR1_0            (0x00010000uL)
#define INTC_ICDICFR6_IV1_VBUFERR1_1            (0x00020000uL)
#define INTC_ICDICFR6_IV3_VBUFERR1_0            (0x00040000uL)
#define INTC_ICDICFR6_IV3_VBUFERR1_1            (0x00080000uL)
#define INTC_ICDICFR6_IV5_VBUFERR1_0            (0x00100000uL)
#define INTC_ICDICFR6_IV5_VBUFERR1_1            (0x00200000uL)
#define INTC_ICDICFR6_IV6_VBUFERR1_0            (0x00400000uL)
#define INTC_ICDICFR6_IV6_VBUFERR1_1            (0x00800000uL)
#define INTC_ICDICFR6_S0_WLINE1_0               (0x01000000uL)
#define INTC_ICDICFR6_S0_WLINE1_1               (0x02000000uL)
#define INTC_ICDICFR6_S1_VI_VSYNC1_0            (0x04000000uL)
#define INTC_ICDICFR6_S1_VI_VSYNC1_1            (0x08000000uL)
#define INTC_ICDICFR6_S1_LO_VSYNC1_0            (0x10000000uL)
#define INTC_ICDICFR6_S1_LO_VSYNC1_1            (0x20000000uL)
#define INTC_ICDICFR6_S1_VSYNCERR1_0            (0x40000000uL)
#define INTC_ICDICFR6_S1_VSYNCERR1_1            (0x80000000uL)

#define INTC_ICDICFR7_S1_VFIELD1_0              (0x00000001uL)
#define INTC_ICDICFR7_S1_VFIELD1_1              (0x00000002uL)
#define INTC_ICDICFR7_IV2_VBUFERR1_0            (0x00000004uL)
#define INTC_ICDICFR7_IV2_VBUFERR1_1            (0x00000008uL)
#define INTC_ICDICFR7_IV4_VBUFERR1_0            (0x00000010uL)
#define INTC_ICDICFR7_IV4_VBUFERR1_1            (0x00000020uL)
#define INTC_ICDICFR7_S1_WLINE1_0               (0x00000040uL)
#define INTC_ICDICFR7_S1_WLINE1_1               (0x00000080uL)
#define INTC_ICDICFR7_OIR_VI_VSYNC1_0           (0x00000100uL)
#define INTC_ICDICFR7_OIR_VI_VSYNC1_1           (0x00000200uL)
#define INTC_ICDICFR7_OIR_LO_VSYNC1_0           (0x00000400uL)
#define INTC_ICDICFR7_OIR_LO_VSYNC1_1           (0x00000800uL)
#define INTC_ICDICFR7_OIR_VLINE1_0              (0x00001000uL)
#define INTC_ICDICFR7_OIR_VLINE1_1              (0x00002000uL)
#define INTC_ICDICFR7_OIR_VFIELD1_0             (0x00004000uL)
#define INTC_ICDICFR7_OIR_VFIELD1_1             (0x00008000uL)
#define INTC_ICDICFR7_IV7_VBUFERR1_0            (0x00010000uL)
#define INTC_ICDICFR7_IV7_VBUFERR1_1            (0x00020000uL)
#define INTC_ICDICFR7_IV8_VBUFERR1_0            (0x00040000uL)
#define INTC_ICDICFR7_IV8_VBUFERR1_1            (0x00080000uL)
#define INTC_ICDICFR7_OIR_WLINE1_0              (0x00100000uL)
#define INTC_ICDICFR7_OIR_WLINE1_1              (0x00200000uL)
#define INTC_ICDICFR7_IMRDI_0                   (0x00400000uL)
#define INTC_ICDICFR7_IMRDI_1                   (0x00800000uL)
#define INTC_ICDICFR7_IMR2I0_0                  (0x01000000uL)
#define INTC_ICDICFR7_IMR2I0_1                  (0x02000000uL)
#define INTC_ICDICFR7_IMR2I1_0                  (0x04000000uL)
#define INTC_ICDICFR7_IMR2I1_1                  (0x08000000uL)
#define INTC_ICDICFR7_JEDI_0                    (0x10000000uL)
#define INTC_ICDICFR7_JEDI_1                    (0x20000000uL)
#define INTC_ICDICFR7_JDTI_0                    (0x40000000uL)
#define INTC_ICDICFR7_JDTI_1                    (0x80000000uL)

#define INTC_ICDICFR8_CMP0_0                    (0x00000001uL)
#define INTC_ICDICFR8_CMP0_1                    (0x00000002uL)
#define INTC_ICDICFR8_CMP1_0                    (0x00000004uL)
#define INTC_ICDICFR8_CMP1_1                    (0x00000008uL)
#define INTC_ICDICFR8_INT0_0                    (0x00000010uL)
#define INTC_ICDICFR8_INT0_1                    (0x00000020uL)
#define INTC_ICDICFR8_INT1_0                    (0x00000040uL)
#define INTC_ICDICFR8_INT1_1                    (0x00000080uL)
#define INTC_ICDICFR8_INT2_0                    (0x00000100uL)
#define INTC_ICDICFR8_INT2_1                    (0x00000200uL)
#define INTC_ICDICFR8_INT3_0                    (0x00000400uL)
#define INTC_ICDICFR8_INT3_1                    (0x00000800uL)
#define INTC_ICDICFR8_OSTM0TINT_0               (0x00001000uL)
#define INTC_ICDICFR8_OSTM0TINT_1               (0x00002000uL)
#define INTC_ICDICFR8_OSTM1TINT_0               (0x00004000uL)
#define INTC_ICDICFR8_OSTM1TINT_1               (0x00008000uL)
#define INTC_ICDICFR8_CMI_0                     (0x00010000uL)
#define INTC_ICDICFR8_CMI_1                     (0x00020000uL)
#define INTC_ICDICFR8_WTOUT_0                   (0x00040000uL)
#define INTC_ICDICFR8_WTOUT_1                   (0x00080000uL)
#define INTC_ICDICFR8_ITI_0                     (0x00100000uL)
#define INTC_ICDICFR8_ITI_1                     (0x00200000uL)
#define INTC_ICDICFR8_TGI0A_0                   (0x00400000uL)
#define INTC_ICDICFR8_TGI0A_1                   (0x00800000uL)
#define INTC_ICDICFR8_TGI0B_0                   (0x01000000uL)
#define INTC_ICDICFR8_TGI0B_1                   (0x02000000uL)
#define INTC_ICDICFR8_TGI0C_0                   (0x04000000uL)
#define INTC_ICDICFR8_TGI0C_1                   (0x08000000uL)
#define INTC_ICDICFR8_TGI0D_0                   (0x10000000uL)
#define INTC_ICDICFR8_TGI0D_1                   (0x20000000uL)
#define INTC_ICDICFR8_TGI0V_0                   (0x40000000uL)
#define INTC_ICDICFR8_TGI0V_1                   (0x80000000uL)

#define INTC_ICDICFR9_TGI0E_0                   (0x00000001uL)
#define INTC_ICDICFR9_TGI0E_1                   (0x00000002uL)
#define INTC_ICDICFR9_TGI0F_0                   (0x00000004uL)
#define INTC_ICDICFR9_TGI0F_1                   (0x00000008uL)
#define INTC_ICDICFR9_TGI1A_0                   (0x00000010uL)
#define INTC_ICDICFR9_TGI1A_1                   (0x00000020uL)
#define INTC_ICDICFR9_TGI1B_0                   (0x00000040uL)
#define INTC_ICDICFR9_TGI1B_1                   (0x00000080uL)
#define INTC_ICDICFR9_TGI1V_0                   (0x00000100uL)
#define INTC_ICDICFR9_TGI1V_1                   (0x00000200uL)
#define INTC_ICDICFR9_TGI1U_0                   (0x00000400uL)
#define INTC_ICDICFR9_TGI1U_1                   (0x00000800uL)
#define INTC_ICDICFR9_TGI2A_0                   (0x00001000uL)
#define INTC_ICDICFR9_TGI2A_1                   (0x00002000uL)
#define INTC_ICDICFR9_TGI2B_0                   (0x00004000uL)
#define INTC_ICDICFR9_TGI2B_1                   (0x00008000uL)
#define INTC_ICDICFR9_TGI2V_0                   (0x00010000uL)
#define INTC_ICDICFR9_TGI2V_1                   (0x00020000uL)
#define INTC_ICDICFR9_TGI2U_0                   (0x00040000uL)
#define INTC_ICDICFR9_TGI2U_1                   (0x00080000uL)
#define INTC_ICDICFR9_TGI3A_0                   (0x00100000uL)
#define INTC_ICDICFR9_TGI3A_1                   (0x00200000uL)
#define INTC_ICDICFR9_TGI3B_0                   (0x00400000uL)
#define INTC_ICDICFR9_TGI3B_1                   (0x00800000uL)
#define INTC_ICDICFR9_TGI3C_0                   (0x01000000uL)
#define INTC_ICDICFR9_TGI3C_1                   (0x02000000uL)
#define INTC_ICDICFR9_TGI3D_0                   (0x04000000uL)
#define INTC_ICDICFR9_TGI3D_1                   (0x08000000uL)
#define INTC_ICDICFR9_TGI3V_0                   (0x10000000uL)
#define INTC_ICDICFR9_TGI3V_1                   (0x20000000uL)
#define INTC_ICDICFR9_TGI4A_0                   (0x40000000uL)
#define INTC_ICDICFR9_TGI4A_1                   (0x80000000uL)

#define INTC_ICDICFR10_TGI4B_0                  (0x00000001uL)
#define INTC_ICDICFR10_TGI4B_1                  (0x00000002uL)
#define INTC_ICDICFR10_TGI4C_0                  (0x00000004uL)
#define INTC_ICDICFR10_TGI4C_1                  (0x00000008uL)
#define INTC_ICDICFR10_TGI4D_0                  (0x00000010uL)
#define INTC_ICDICFR10_TGI4D_1                  (0x00000020uL)
#define INTC_ICDICFR10_TGI4V_0                  (0x00000040uL)
#define INTC_ICDICFR10_TGI4V_1                  (0x00000080uL)
#define INTC_ICDICFR10_CMI1_0                   (0x00000100uL)
#define INTC_ICDICFR10_CMI1_1                   (0x00000200uL)
#define INTC_ICDICFR10_CMI2_0                   (0x00000400uL)
#define INTC_ICDICFR10_CMI2_1                   (0x00000800uL)
#define INTC_ICDICFR10_SGDEI0_0                 (0x00001000uL)
#define INTC_ICDICFR10_SGDEI0_1                 (0x00002000uL)
#define INTC_ICDICFR10_SGDEI1_0                 (0x00004000uL)
#define INTC_ICDICFR10_SGDEI1_1                 (0x00008000uL)
#define INTC_ICDICFR10_SGDEI2_0                 (0x00010000uL)
#define INTC_ICDICFR10_SGDEI2_1                 (0x00020000uL)
#define INTC_ICDICFR10_SGDEI3_0                 (0x00040000uL)
#define INTC_ICDICFR10_SGDEI3_1                 (0x00080000uL)
#define INTC_ICDICFR10_ADI_0                    (0x00100000uL)
#define INTC_ICDICFR10_ADI_1                    (0x00200000uL)
#define INTC_ICDICFR10_LMTI_0                   (0x00400000uL)
#define INTC_ICDICFR10_LMTI_1                   (0x00800000uL)
#define INTC_ICDICFR10_SSII0_0                  (0x01000000uL)
#define INTC_ICDICFR10_SSII0_1                  (0x02000000uL)
#define INTC_ICDICFR10_SSIRXI0_0                (0x04000000uL)
#define INTC_ICDICFR10_SSIRXI0_1                (0x08000000uL)
#define INTC_ICDICFR10_SSITXI0_0                (0x10000000uL)
#define INTC_ICDICFR10_SSITXI0_1                (0x20000000uL)
#define INTC_ICDICFR10_SSII1_0                  (0x40000000uL)
#define INTC_ICDICFR10_SSII1_1                  (0x80000000uL)

#define INTC_ICDICFR11_SSIRXI1_0                (0x00000001uL)
#define INTC_ICDICFR11_SSIRXI1_1                (0x00000002uL)
#define INTC_ICDICFR11_SSITXI1_0                (0x00000004uL)
#define INTC_ICDICFR11_SSITXI1_1                (0x00000008uL)
#define INTC_ICDICFR11_SSII2_0                  (0x00000010uL)
#define INTC_ICDICFR11_SSII2_1                  (0x00000020uL)
#define INTC_ICDICFR11_SSIRTI2_0                (0x00000040uL)
#define INTC_ICDICFR11_SSIRTI2_1                (0x00000080uL)
#define INTC_ICDICFR11_SSII3_0                  (0x00000100uL)
#define INTC_ICDICFR11_SSII3_1                  (0x00000200uL)
#define INTC_ICDICFR11_SSIRXI3_0                (0x00000400uL)
#define INTC_ICDICFR11_SSIRXI3_1                (0x00000800uL)
#define INTC_ICDICFR11_SSITXI3_0                (0x00001000uL)
#define INTC_ICDICFR11_SSITXI3_1                (0x00002000uL)
#define INTC_ICDICFR11_SSII4_0                  (0x00004000uL)
#define INTC_ICDICFR11_SSII4_1                  (0x00008000uL)
#define INTC_ICDICFR11_SSIRTI4_0                (0x00010000uL)
#define INTC_ICDICFR11_SSIRTI4_1                (0x00020000uL)
#define INTC_ICDICFR11_SSII5_0                  (0x00040000uL)
#define INTC_ICDICFR11_SSII5_1                  (0x00080000uL)
#define INTC_ICDICFR11_SSIRXI5_0                (0x00100000uL)
#define INTC_ICDICFR11_SSIRXI5_1                (0x00200000uL)
#define INTC_ICDICFR11_SSITXI5_0                (0x00400000uL)
#define INTC_ICDICFR11_SSITXI5_1                (0x00800000uL)
#define INTC_ICDICFR11_SPDIFI_0                 (0x01000000uL)
#define INTC_ICDICFR11_SPDIFI_1                 (0x02000000uL)
#define INTC_ICDICFR11_INTIICTEI0_0             (0x04000000uL)
#define INTC_ICDICFR11_INTIICTEI0_1             (0x08000000uL)
#define INTC_ICDICFR11_INTIICRI0_0              (0x10000000uL)
#define INTC_ICDICFR11_INTIICRI0_1              (0x20000000uL)
#define INTC_ICDICFR11_INTIICTI0_0              (0x40000000uL)
#define INTC_ICDICFR11_INTIICTI0_1              (0x80000000uL)

#define INTC_ICDICFR12_INTIICSPI0_0             (0x00000001uL)
#define INTC_ICDICFR12_INTIICSPI0_1             (0x00000002uL)
#define INTC_ICDICFR12_INTIICSTI0_0             (0x00000004uL)
#define INTC_ICDICFR12_INTIICSTI0_1             (0x00000008uL)
#define INTC_ICDICFR12_INTIICNAKI0_0            (0x00000010uL)
#define INTC_ICDICFR12_INTIICNAKI0_1            (0x00000020uL)
#define INTC_ICDICFR12_INTIICALI0_0             (0x00000040uL)
#define INTC_ICDICFR12_INTIICALI0_1             (0x00000080uL)
#define INTC_ICDICFR12_INTIICTMOI0_0            (0x00000100uL)
#define INTC_ICDICFR12_INTIICTMOI0_1            (0x00000200uL)
#define INTC_ICDICFR12_INTIICTEI1_0             (0x00000400uL)
#define INTC_ICDICFR12_INTIICTEI1_1             (0x00000800uL)
#define INTC_ICDICFR12_INTIICRI1_0              (0x00001000uL)
#define INTC_ICDICFR12_INTIICRI1_1              (0x00002000uL)
#define INTC_ICDICFR12_INTIICTI1_0              (0x00004000uL)
#define INTC_ICDICFR12_INTIICTI1_1              (0x00008000uL)
#define INTC_ICDICFR12_INTIICSPI1_0             (0x00010000uL)
#define INTC_ICDICFR12_INTIICSPI1_1             (0x00020000uL)
#define INTC_ICDICFR12_INTIICSTI1_0             (0x00040000uL)
#define INTC_ICDICFR12_INTIICSTI1_1             (0x00080000uL)
#define INTC_ICDICFR12_INTIICNAKI1_0            (0x00100000uL)
#define INTC_ICDICFR12_INTIICNAKI1_1            (0x00200000uL)
#define INTC_ICDICFR12_INTIICALI1_0             (0x00400000uL)
#define INTC_ICDICFR12_INTIICALI1_1             (0x00800000uL)
#define INTC_ICDICFR12_INTIICTMOI1_0            (0x01000000uL)
#define INTC_ICDICFR12_INTIICTMOI1_1            (0x02000000uL)
#define INTC_ICDICFR12_INTIICTEI2_0             (0x04000000uL)
#define INTC_ICDICFR12_INTIICTEI2_1             (0x08000000uL)
#define INTC_ICDICFR12_INTIICRI2_0              (0x10000000uL)
#define INTC_ICDICFR12_INTIICRI2_1              (0x20000000uL)
#define INTC_ICDICFR12_INTIICTI2_0              (0x40000000uL)
#define INTC_ICDICFR12_INTIICTI2_1              (0x80000000uL)

#define INTC_ICDICFR13_INTIICSPI2_0             (0x00000001uL)
#define INTC_ICDICFR13_INTIICSPI2_1             (0x00000002uL)
#define INTC_ICDICFR13_INTIICSTI2_0             (0x00000004uL)
#define INTC_ICDICFR13_INTIICSTI2_1             (0x00000008uL)
#define INTC_ICDICFR13_INTIICNAKI2_0            (0x00000010uL)
#define INTC_ICDICFR13_INTIICNAKI2_1            (0x00000020uL)
#define INTC_ICDICFR13_INTIICALI2_0             (0x00000040uL)
#define INTC_ICDICFR13_INTIICALI2_1             (0x00000080uL)
#define INTC_ICDICFR13_INTIICTMOI2_0            (0x00000100uL)
#define INTC_ICDICFR13_INTIICTMOI2_1            (0x00000200uL)
#define INTC_ICDICFR13_INTIICTEI3_0             (0x00000400uL)
#define INTC_ICDICFR13_INTIICTEI3_1             (0x00000800uL)
#define INTC_ICDICFR13_INTIICRI3_0              (0x00001000uL)
#define INTC_ICDICFR13_INTIICRI3_1              (0x00002000uL)
#define INTC_ICDICFR13_INTIICTI3_0              (0x00004000uL)
#define INTC_ICDICFR13_INTIICTI3_1              (0x00008000uL)
#define INTC_ICDICFR13_INTIICSPI3_0             (0x00010000uL)
#define INTC_ICDICFR13_INTIICSPI3_1             (0x00020000uL)
#define INTC_ICDICFR13_INTIICSTI3_0             (0x00040000uL)
#define INTC_ICDICFR13_INTIICSTI3_1             (0x00080000uL)
#define INTC_ICDICFR13_INTIICNAKI3_0            (0x00100000uL)
#define INTC_ICDICFR13_INTIICNAKI3_1            (0x00200000uL)
#define INTC_ICDICFR13_INTIICALI3_0             (0x00400000uL)
#define INTC_ICDICFR13_INTIICALI3_1             (0x00800000uL)
#define INTC_ICDICFR13_INTIICTMOI3_0            (0x01000000uL)
#define INTC_ICDICFR13_INTIICTMOI3_1            (0x02000000uL)
#define INTC_ICDICFR13_BRI0_0                   (0x04000000uL)
#define INTC_ICDICFR13_BRI0_1                   (0x08000000uL)
#define INTC_ICDICFR13_ERI0_0                   (0x10000000uL)
#define INTC_ICDICFR13_ERI0_1                   (0x20000000uL)
#define INTC_ICDICFR13_RXI0_0                   (0x40000000uL)
#define INTC_ICDICFR13_RXI0_1                   (0x80000000uL)

#define INTC_ICDICFR14_TXI0_0                   (0x00000001uL)
#define INTC_ICDICFR14_TXI0_1                   (0x00000002uL)
#define INTC_ICDICFR14_BRI1_0                   (0x00000004uL)
#define INTC_ICDICFR14_BRI1_1                   (0x00000008uL)
#define INTC_ICDICFR14_ERI1_0                   (0x00000010uL)
#define INTC_ICDICFR14_ERI1_1                   (0x00000020uL)
#define INTC_ICDICFR14_RXI1_0                   (0x00000040uL)
#define INTC_ICDICFR14_RXI1_1                   (0x00000080uL)
#define INTC_ICDICFR14_TXI1_0                   (0x00000100uL)
#define INTC_ICDICFR14_TXI1_1                   (0x00000200uL)
#define INTC_ICDICFR14_BRI2_0                   (0x00000400uL)
#define INTC_ICDICFR14_BRI2_1                   (0x00000800uL)
#define INTC_ICDICFR14_ERI2_0                   (0x00001000uL)
#define INTC_ICDICFR14_ERI2_1                   (0x00002000uL)
#define INTC_ICDICFR14_RXI2_0                   (0x00004000uL)
#define INTC_ICDICFR14_RXI2_1                   (0x00008000uL)
#define INTC_ICDICFR14_TXI2_0                   (0x00010000uL)
#define INTC_ICDICFR14_TXI2_1                   (0x00020000uL)
#define INTC_ICDICFR14_BRI3_0                   (0x00040000uL)
#define INTC_ICDICFR14_BRI3_1                   (0x00080000uL)
#define INTC_ICDICFR14_ERI3_0                   (0x00100000uL)
#define INTC_ICDICFR14_ERI3_1                   (0x00200000uL)
#define INTC_ICDICFR14_RXI3_0                   (0x00400000uL)
#define INTC_ICDICFR14_RXI3_1                   (0x00800000uL)
#define INTC_ICDICFR14_TXI3_0                   (0x01000000uL)
#define INTC_ICDICFR14_TXI3_1                   (0x02000000uL)
#define INTC_ICDICFR14_BRI4_0                   (0x04000000uL)
#define INTC_ICDICFR14_BRI4_1                   (0x08000000uL)
#define INTC_ICDICFR14_ERI4_0                   (0x10000000uL)
#define INTC_ICDICFR14_ERI4_1                   (0x20000000uL)
#define INTC_ICDICFR14_RXI4_0                   (0x40000000uL)
#define INTC_ICDICFR14_RXI4_1                   (0x80000000uL)

#define INTC_ICDICFR15_TXI4_0                   (0x00000001uL)
#define INTC_ICDICFR15_TXI4_1                   (0x00000002uL)
#define INTC_ICDICFR15_BRI5_0                   (0x00000004uL)
#define INTC_ICDICFR15_BRI5_1                   (0x00000008uL)
#define INTC_ICDICFR15_ERI5_0                   (0x00000010uL)
#define INTC_ICDICFR15_ERI5_1                   (0x00000020uL)
#define INTC_ICDICFR15_RXI5_0                   (0x00000040uL)
#define INTC_ICDICFR15_RXI5_1                   (0x00000080uL)
#define INTC_ICDICFR15_TXI5_0                   (0x00000100uL)
#define INTC_ICDICFR15_TXI5_1                   (0x00000200uL)
#define INTC_ICDICFR15_BRI6_0                   (0x00000400uL)
#define INTC_ICDICFR15_BRI6_1                   (0x00000800uL)
#define INTC_ICDICFR15_ERI6_0                   (0x00001000uL)
#define INTC_ICDICFR15_ERI6_1                   (0x00002000uL)
#define INTC_ICDICFR15_RXI6_0                   (0x00004000uL)
#define INTC_ICDICFR15_RXI6_1                   (0x00008000uL)
#define INTC_ICDICFR15_TXI6_0                   (0x00010000uL)
#define INTC_ICDICFR15_TXI6_1                   (0x00020000uL)
#define INTC_ICDICFR15_BRI7_0                   (0x00040000uL)
#define INTC_ICDICFR15_BRI7_1                   (0x00080000uL)
#define INTC_ICDICFR15_ERI7_0                   (0x00100000uL)
#define INTC_ICDICFR15_ERI7_1                   (0x00200000uL)
#define INTC_ICDICFR15_RXI7_0                   (0x00400000uL)
#define INTC_ICDICFR15_RXI7_1                   (0x00800000uL)
#define INTC_ICDICFR15_TXI7_0                   (0x01000000uL)
#define INTC_ICDICFR15_TXI7_1                   (0x02000000uL)
#define INTC_ICDICFR15_INTRCANGERR_0            (0x04000000uL)
#define INTC_ICDICFR15_INTRCANGERR_1            (0x08000000uL)
#define INTC_ICDICFR15_INTRCANGRECC_0           (0x10000000uL)
#define INTC_ICDICFR15_INTRCANGRECC_1           (0x20000000uL)
#define INTC_ICDICFR15_INTRCAN0REC_0            (0x40000000uL)
#define INTC_ICDICFR15_INTRCAN0REC_1            (0x80000000uL)

#define INTC_ICDICFR16_INTRCAN0ERR_0            (0x00000001uL)
#define INTC_ICDICFR16_INTRCAN0ERR_1            (0x00000002uL)
#define INTC_ICDICFR16_INTRCAN0TRX_0            (0x00000004uL)
#define INTC_ICDICFR16_INTRCAN0TRX_1            (0x00000008uL)
#define INTC_ICDICFR16_INTRCAN1REC_0            (0x00000010uL)
#define INTC_ICDICFR16_INTRCAN1REC_1            (0x00000020uL)
#define INTC_ICDICFR16_INTRCAN1ERR_0            (0x00000040uL)
#define INTC_ICDICFR16_INTRCAN1ERR_1            (0x00000080uL)
#define INTC_ICDICFR16_INTRCAN1TRX_0            (0x00000100uL)
#define INTC_ICDICFR16_INTRCAN1TRX_1            (0x00000200uL)
#define INTC_ICDICFR16_INTRCAN2REC_0            (0x00000400uL)
#define INTC_ICDICFR16_INTRCAN2REC_1            (0x00000800uL)
#define INTC_ICDICFR16_INTRCAN2ERR_0            (0x00001000uL)
#define INTC_ICDICFR16_INTRCAN2ERR_1            (0x00002000uL)
#define INTC_ICDICFR16_INTRCAN2TRX_0            (0x00004000uL)
#define INTC_ICDICFR16_INTRCAN2TRX_1            (0x00008000uL)
#define INTC_ICDICFR16_INTRCAN3REC_0            (0x00010000uL)
#define INTC_ICDICFR16_INTRCAN3REC_1            (0x00020000uL)
#define INTC_ICDICFR16_INTRCAN3ERR_0            (0x00040000uL)
#define INTC_ICDICFR16_INTRCAN3ERR_1            (0x00080000uL)
#define INTC_ICDICFR16_INTRCAN3TRX_0            (0x00100000uL)
#define INTC_ICDICFR16_INTRCAN3TRX_1            (0x00200000uL)
#define INTC_ICDICFR16_INTRCAN4REC_0            (0x00400000uL)
#define INTC_ICDICFR16_INTRCAN4REC_1            (0x00800000uL)
#define INTC_ICDICFR16_INTRCAN4ERR_0            (0x01000000uL)
#define INTC_ICDICFR16_INTRCAN4ERR_1            (0x02000000uL)
#define INTC_ICDICFR16_INTRCAN4TRX_0            (0x04000000uL)
#define INTC_ICDICFR16_INTRCAN4TRX_1            (0x08000000uL)
#define INTC_ICDICFR16_SPEI0_0                  (0x10000000uL)
#define INTC_ICDICFR16_SPEI0_1                  (0x20000000uL)
#define INTC_ICDICFR16_SPRI0_0                  (0x40000000uL)
#define INTC_ICDICFR16_SPRI0_1                  (0x80000000uL)

#define INTC_ICDICFR17_SPTI0_0                  (0x00000001uL)
#define INTC_ICDICFR17_SPTI0_1                  (0x00000002uL)
#define INTC_ICDICFR17_SPEI1_0                  (0x00000004uL)
#define INTC_ICDICFR17_SPEI1_1                  (0x00000008uL)
#define INTC_ICDICFR17_SPRI1_0                  (0x00000010uL)
#define INTC_ICDICFR17_SPRI1_1                  (0x00000020uL)
#define INTC_ICDICFR17_SPTI1_0                  (0x00000040uL)
#define INTC_ICDICFR17_SPTI1_1                  (0x00000080uL)
#define INTC_ICDICFR17_SPEI2_0                  (0x00000100uL)
#define INTC_ICDICFR17_SPEI2_1                  (0x00000200uL)
#define INTC_ICDICFR17_SPRI2_0                  (0x00000400uL)
#define INTC_ICDICFR17_SPRI2_1                  (0x00000800uL)
#define INTC_ICDICFR17_SPTI2_0                  (0x00001000uL)
#define INTC_ICDICFR17_SPTI2_1                  (0x00002000uL)
#define INTC_ICDICFR17_SPEI3_0                  (0x00004000uL)
#define INTC_ICDICFR17_SPEI3_1                  (0x00008000uL)
#define INTC_ICDICFR17_SPRI3_0                  (0x00010000uL)
#define INTC_ICDICFR17_SPRI3_1                  (0x00020000uL)
#define INTC_ICDICFR17_SPTI3_0                  (0x00040000uL)
#define INTC_ICDICFR17_SPTI3_1                  (0x00080000uL)
#define INTC_ICDICFR17_SPEI4_0                  (0x00100000uL)
#define INTC_ICDICFR17_SPEI4_1                  (0x00200000uL)
#define INTC_ICDICFR17_SPRI4_0                  (0x00400000uL)
#define INTC_ICDICFR17_SPRI4_1                  (0x00800000uL)
#define INTC_ICDICFR17_SPTI4_0                  (0x01000000uL)
#define INTC_ICDICFR17_SPTI4_1                  (0x02000000uL)
#define INTC_ICDICFR17_IEBBTD_0                 (0x04000000uL)
#define INTC_ICDICFR17_IEBBTD_1                 (0x08000000uL)
#define INTC_ICDICFR17_IEBBTERR_0               (0x10000000uL)
#define INTC_ICDICFR17_IEBBTERR_1               (0x20000000uL)
#define INTC_ICDICFR17_IEBBTSTA_0               (0x40000000uL)
#define INTC_ICDICFR17_IEBBTSTA_1               (0x80000000uL)

#define INTC_ICDICFR18_IEBBTV_0                 (0x00000001uL)
#define INTC_ICDICFR18_IEBBTV_1                 (0x00000002uL)
#define INTC_ICDICFR18_ISY_0                    (0x00000004uL)
#define INTC_ICDICFR18_ISY_1                    (0x00000008uL)
#define INTC_ICDICFR18_IERR_0                   (0x00000010uL)
#define INTC_ICDICFR18_IERR_1                   (0x00000020uL)
#define INTC_ICDICFR18_ITARG_0                  (0x00000040uL)
#define INTC_ICDICFR18_ITARG_1                  (0x00000080uL)
#define INTC_ICDICFR18_ISEC_0                   (0x00000100uL)
#define INTC_ICDICFR18_ISEC_1                   (0x00000200uL)
#define INTC_ICDICFR18_IBUF_0                   (0x00000400uL)
#define INTC_ICDICFR18_IBUF_1                   (0x00000800uL)
#define INTC_ICDICFR18_IREADY_0                 (0x00001000uL)
#define INTC_ICDICFR18_IREADY_1                 (0x00002000uL)
#define INTC_ICDICFR18_FLSTE_0                  (0x00004000uL)
#define INTC_ICDICFR18_FLSTE_1                  (0x00008000uL)
#define INTC_ICDICFR18_FLTENDI_0                (0x00010000uL)
#define INTC_ICDICFR18_FLTENDI_1                (0x00020000uL)
#define INTC_ICDICFR18_FLTREQ0I_0               (0x00040000uL)
#define INTC_ICDICFR18_FLTREQ0I_1               (0x00080000uL)
#define INTC_ICDICFR18_FLTREQ1I_0               (0x00100000uL)
#define INTC_ICDICFR18_FLTREQ1I_1               (0x00200000uL)
#define INTC_ICDICFR18_MMC0_0                   (0x00400000uL)
#define INTC_ICDICFR18_MMC0_1                   (0x00800000uL)
#define INTC_ICDICFR18_MMC1_0                   (0x01000000uL)
#define INTC_ICDICFR18_MMC1_1                   (0x02000000uL)
#define INTC_ICDICFR18_MMC2_0                   (0x04000000uL)
#define INTC_ICDICFR18_MMC2_1                   (0x08000000uL)
#define INTC_ICDICFR18_SDHI0_3_0                (0x10000000uL)
#define INTC_ICDICFR18_SDHI0_3_1                (0x20000000uL)
#define INTC_ICDICFR18_SDHI0_0_0                (0x40000000uL)
#define INTC_ICDICFR18_SDHI0_0_1                (0x80000000uL)

#define INTC_ICDICFR19_SDHI0_1_0                (0x00000001uL)
#define INTC_ICDICFR19_SDHI0_1_1                (0x00000002uL)
#define INTC_ICDICFR19_SDHI1_3_0                (0x00000004uL)
#define INTC_ICDICFR19_SDHI1_3_1                (0x00000008uL)
#define INTC_ICDICFR19_SDHI1_0_0                (0x00000010uL)
#define INTC_ICDICFR19_SDHI1_0_1                (0x00000020uL)
#define INTC_ICDICFR19_SDHI1_1_0                (0x00000040uL)
#define INTC_ICDICFR19_SDHI1_1_1                (0x00000080uL)
#define INTC_ICDICFR19_ARM_0                    (0x00000100uL)
#define INTC_ICDICFR19_ARM_1                    (0x00000200uL)
#define INTC_ICDICFR19_PRD_0                    (0x00000400uL)
#define INTC_ICDICFR19_PRD_1                    (0x00000800uL)
#define INTC_ICDICFR19_CUP_0                    (0x00001000uL)
#define INTC_ICDICFR19_CUP_1                    (0x00002000uL)
#define INTC_ICDICFR19_SCUAI0_0                 (0x00004000uL)
#define INTC_ICDICFR19_SCUAI0_1                 (0x00008000uL)
#define INTC_ICDICFR19_SCUAI1_0                 (0x00010000uL)
#define INTC_ICDICFR19_SCUAI1_1                 (0x00020000uL)
#define INTC_ICDICFR19_SCUFDI0_0                (0x00040000uL)
#define INTC_ICDICFR19_SCUFDI0_1                (0x00080000uL)
#define INTC_ICDICFR19_SCUFDI1_0                (0x00100000uL)
#define INTC_ICDICFR19_SCUFDI1_1                (0x00200000uL)
#define INTC_ICDICFR19_SCUFDI2_0                (0x00400000uL)
#define INTC_ICDICFR19_SCUFDI2_1                (0x00800000uL)
#define INTC_ICDICFR19_SCUFDI3_0                (0x01000000uL)
#define INTC_ICDICFR19_SCUFDI3_1                (0x02000000uL)
#define INTC_ICDICFR19_SCUFUI0_0                (0x04000000uL)
#define INTC_ICDICFR19_SCUFUI0_1                (0x08000000uL)
#define INTC_ICDICFR19_SCUFUI1_0                (0x10000000uL)
#define INTC_ICDICFR19_SCUFUI1_1                (0x20000000uL)
#define INTC_ICDICFR19_SCUFUI2_0                (0x40000000uL)
#define INTC_ICDICFR19_SCUFUI2_1                (0x80000000uL)

#define INTC_ICDICFR20_SCUFUI3_0                (0x00000001uL)
#define INTC_ICDICFR20_SCUFUI3_1                (0x00000002uL)
#define INTC_ICDICFR20_SCUDVI0_0                (0x00000004uL)
#define INTC_ICDICFR20_SCUDVI0_1                (0x00000008uL)
#define INTC_ICDICFR20_SCUDVI1_0                (0x00000010uL)
#define INTC_ICDICFR20_SCUDVI1_1                (0x00000020uL)
#define INTC_ICDICFR20_SCUDVI2_0                (0x00000040uL)
#define INTC_ICDICFR20_SCUDVI2_1                (0x00000080uL)
#define INTC_ICDICFR20_SCUDVI3_0                (0x00000100uL)
#define INTC_ICDICFR20_SCUDVI3_1                (0x00000200uL)
#define INTC_ICDICFR20_MLB_CINT_0               (0x00000400uL)
#define INTC_ICDICFR20_MLB_CINT_1               (0x00000800uL)
#define INTC_ICDICFR20_MLB_SINT_0               (0x00001000uL)
#define INTC_ICDICFR20_MLB_SINT_1               (0x00002000uL)
#define INTC_ICDICFR20_DRC0_0                   (0x00004000uL)
#define INTC_ICDICFR20_DRC0_1                   (0x00008000uL)
#define INTC_ICDICFR20_DRC1_0                   (0x00010000uL)
#define INTC_ICDICFR20_DRC1_1                   (0x00020000uL)
#define INTC_ICDICFR20_LINI0_INT_T_0            (0x00400000uL)
#define INTC_ICDICFR20_LINI0_INT_T_1            (0x00800000uL)
#define INTC_ICDICFR20_LINI0_INT_R_0            (0x01000000uL)
#define INTC_ICDICFR20_LINI0_INT_R_1            (0x02000000uL)
#define INTC_ICDICFR20_LINI0_INT_S_0            (0x04000000uL)
#define INTC_ICDICFR20_LINI0_INT_S_1            (0x08000000uL)
#define INTC_ICDICFR20_LINI0_INT_M_0            (0x10000000uL)
#define INTC_ICDICFR20_LINI0_INT_M_1            (0x20000000uL)
#define INTC_ICDICFR20_LINI1_INT_T_0            (0x40000000uL)
#define INTC_ICDICFR20_LINI1_INT_T_1            (0x80000000uL)

#define INTC_ICDICFR21_LINI1_INT_R_0            (0x00000001uL)
#define INTC_ICDICFR21_LINI1_INT_R_1            (0x00000002uL)
#define INTC_ICDICFR21_LINI1_INT_S_0            (0x00000004uL)
#define INTC_ICDICFR21_LINI1_INT_S_1            (0x00000008uL)
#define INTC_ICDICFR21_LINI1_INT_M_0            (0x00000010uL)
#define INTC_ICDICFR21_LINI1_INT_M_1            (0x00000020uL)
#define INTC_ICDICFR21_ERI0_0                   (0x00400000uL)
#define INTC_ICDICFR21_ERI0_1                   (0x00800000uL)
#define INTC_ICDICFR21_RXI0_0                   (0x01000000uL)
#define INTC_ICDICFR21_RXI0_1                   (0x02000000uL)
#define INTC_ICDICFR21_TXI0_0                   (0x04000000uL)
#define INTC_ICDICFR21_TXI0_1                   (0x08000000uL)
#define INTC_ICDICFR21_TEI0_0                   (0x10000000uL)
#define INTC_ICDICFR21_TEI0_1                   (0x20000000uL)
#define INTC_ICDICFR21_ERI1_0                   (0x40000000uL)
#define INTC_ICDICFR21_ERI1_1                   (0x80000000uL)

#define INTC_ICDICFR22_RXI1_0                   (0x00000001uL)
#define INTC_ICDICFR22_RXI1_1                   (0x00000002uL)
#define INTC_ICDICFR22_TXI1_0                   (0x00000004uL)
#define INTC_ICDICFR22_TXI1_1                   (0x00000008uL)
#define INTC_ICDICFR22_TEI1_0                   (0x00000010uL)
#define INTC_ICDICFR22_TEI1_1                   (0x00000020uL)
#define INTC_ICDICFR22_AVBI_DATA_0              (0x00000040uL)
#define INTC_ICDICFR22_AVBI_DATA_1              (0x00000080uL)
#define INTC_ICDICFR22_AVBI_ERROR_0             (0x00000100uL)
#define INTC_ICDICFR22_AVBI_ERROR_1             (0x00000200uL)
#define INTC_ICDICFR22_AVBI_MANAGE_0            (0x00000400uL)
#define INTC_ICDICFR22_AVBI_MANAGE_1            (0x00000800uL)
#define INTC_ICDICFR22_AVBI_MAC_0               (0x00001000uL)
#define INTC_ICDICFR22_AVBI_MAC_1               (0x00002000uL)
#define INTC_ICDICFR22_ETHERI_0                 (0x00004000uL)
#define INTC_ICDICFR22_ETHERI_1                 (0x00008000uL)
#define INTC_ICDICFR22_CEUI_0                   (0x01000000uL)
#define INTC_ICDICFR22_CEUI_1                   (0x02000000uL)

#define INTC_ICDICFR23_H2XMLB_ERRINT_0          (0x04000000uL)
#define INTC_ICDICFR23_H2XMLB_ERRINT_1          (0x08000000uL)
#define INTC_ICDICFR23_H2XIC1_ERRINT_0          (0x10000000uL)
#define INTC_ICDICFR23_H2XIC1_ERRINT_1          (0x20000000uL)
#define INTC_ICDICFR23_X2HPERI1_ERRINT_0        (0x40000000uL)
#define INTC_ICDICFR23_X2HPERI1_ERRINT_1        (0x80000000uL)

#define INTC_ICDICFR24_X2HPERI2_ERRINT_0        (0x00000001uL)
#define INTC_ICDICFR24_X2HPERI2_ERRINT_1        (0x00000002uL)
#define INTC_ICDICFR24_X2HPERI34_ERRINT_0       (0x00000004uL)
#define INTC_ICDICFR24_X2HPERI34_ERRINT_1       (0x00000008uL)
#define INTC_ICDICFR24_X2HPERI5_ERRINT_0        (0x00000010uL)
#define INTC_ICDICFR24_X2HPERI5_ERRINT_1        (0x00000020uL)
#define INTC_ICDICFR24_X2HPERI67_ERRINT_0       (0x00000040uL)
#define INTC_ICDICFR24_X2HPERI67_ERRINT_1       (0x00000080uL)
#define INTC_ICDICFR24_X2HDBGR_ERRINT_0         (0x00000100uL)
#define INTC_ICDICFR24_X2HDBGR_ERRINT_1         (0x00000200uL)
#define INTC_ICDICFR24_X2HBSC_ERRINT_0          (0x00000400uL)
#define INTC_ICDICFR24_X2HBSC_ERRINT_1          (0x00000800uL)
#define INTC_ICDICFR24_X2HSPI1_ERRINT_0         (0x00001000uL)
#define INTC_ICDICFR24_X2HSPI1_ERRINT_1         (0x00002000uL)
#define INTC_ICDICFR24_X2HSPI2_ERRINT_0         (0x00004000uL)
#define INTC_ICDICFR24_X2HSPI2_ERRINT_1         (0x00008000uL)
#define INTC_ICDICFR24_PRRI_0                   (0x00010000uL)
#define INTC_ICDICFR24_PRRI_1                   (0x00020000uL)
#define INTC_ICDICFR24_IFEI0_0                  (0x00040000uL)
#define INTC_ICDICFR24_IFEI0_1                  (0x00080000uL)
#define INTC_ICDICFR24_OFFI0_0                  (0x00100000uL)
#define INTC_ICDICFR24_OFFI0_1                  (0x00200000uL)
#define INTC_ICDICFR24_PFVEI0_0                 (0x00400000uL)
#define INTC_ICDICFR24_PFVEI0_1                 (0x00800000uL)
#define INTC_ICDICFR24_IFEI1_0                  (0x01000000uL)
#define INTC_ICDICFR24_IFEI1_1                  (0x02000000uL)
#define INTC_ICDICFR24_OFFI1_0                  (0x04000000uL)
#define INTC_ICDICFR24_OFFI1_1                  (0x08000000uL)
#define INTC_ICDICFR24_PFVEI1_0                 (0x10000000uL)
#define INTC_ICDICFR24_PFVEI1_1                 (0x20000000uL)

#define INTC_ICDICFR26_TINT0_0                  (0x00000001uL)
#define INTC_ICDICFR26_TINT0_1                  (0x00000002uL)
#define INTC_ICDICFR26_TINT1_0                  (0x00000004uL)
#define INTC_ICDICFR26_TINT1_1                  (0x00000008uL)
#define INTC_ICDICFR26_TINT2_0                  (0x00000010uL)
#define INTC_ICDICFR26_TINT2_1                  (0x00000020uL)
#define INTC_ICDICFR26_TINT3_0                  (0x00000040uL)
#define INTC_ICDICFR26_TINT3_1                  (0x00000080uL)
#define INTC_ICDICFR26_TINT4_0                  (0x00000100uL)
#define INTC_ICDICFR26_TINT4_1                  (0x00000200uL)
#define INTC_ICDICFR26_TINT5_0                  (0x00000400uL)
#define INTC_ICDICFR26_TINT5_1                  (0x00000800uL)
#define INTC_ICDICFR26_TINT6_0                  (0x00001000uL)
#define INTC_ICDICFR26_TINT6_1                  (0x00002000uL)
#define INTC_ICDICFR26_TINT7_0                  (0x00004000uL)
#define INTC_ICDICFR26_TINT7_1                  (0x00008000uL)
#define INTC_ICDICFR26_TINT8_0                  (0x00010000uL)
#define INTC_ICDICFR26_TINT8_1                  (0x00020000uL)
#define INTC_ICDICFR26_TINT9_0                  (0x00040000uL)
#define INTC_ICDICFR26_TINT9_1                  (0x00080000uL)
#define INTC_ICDICFR26_TINT10_0                 (0x00100000uL)
#define INTC_ICDICFR26_TINT10_1                 (0x00200000uL)
#define INTC_ICDICFR26_TINT11_0                 (0x00400000uL)
#define INTC_ICDICFR26_TINT11_1                 (0x00800000uL)
#define INTC_ICDICFR26_TINT12_0                 (0x01000000uL)
#define INTC_ICDICFR26_TINT12_1                 (0x02000000uL)
#define INTC_ICDICFR26_TINT13_0                 (0x04000000uL)
#define INTC_ICDICFR26_TINT13_1                 (0x08000000uL)
#define INTC_ICDICFR26_TINT14_0                 (0x10000000uL)
#define INTC_ICDICFR26_TINT14_1                 (0x20000000uL)
#define INTC_ICDICFR26_TINT15_0                 (0x40000000uL)
#define INTC_ICDICFR26_TINT15_1                 (0x80000000uL)

#define INTC_ICDICFR27_TINT16_0                 (0x00000001uL)
#define INTC_ICDICFR27_TINT16_1                 (0x00000002uL)
#define INTC_ICDICFR27_TINT17_0                 (0x00000004uL)
#define INTC_ICDICFR27_TINT17_1                 (0x00000008uL)
#define INTC_ICDICFR27_TINT18_0                 (0x00000010uL)
#define INTC_ICDICFR27_TINT18_1                 (0x00000020uL)
#define INTC_ICDICFR27_TINT19_0                 (0x00000040uL)
#define INTC_ICDICFR27_TINT19_1                 (0x00000080uL)
#define INTC_ICDICFR27_TINT20_0                 (0x00000100uL)
#define INTC_ICDICFR27_TINT20_1                 (0x00000200uL)
#define INTC_ICDICFR27_TINT21_0                 (0x00000400uL)
#define INTC_ICDICFR27_TINT21_1                 (0x00000800uL)
#define INTC_ICDICFR27_TINT22_0                 (0x00001000uL)
#define INTC_ICDICFR27_TINT22_1                 (0x00002000uL)
#define INTC_ICDICFR27_TINT23_0                 (0x00004000uL)
#define INTC_ICDICFR27_TINT23_1                 (0x00008000uL)
#define INTC_ICDICFR27_TINT24_0                 (0x00010000uL)
#define INTC_ICDICFR27_TINT24_1                 (0x00020000uL)
#define INTC_ICDICFR27_TINT25_0                 (0x00040000uL)
#define INTC_ICDICFR27_TINT25_1                 (0x00080000uL)
#define INTC_ICDICFR27_TINT26_0                 (0x00100000uL)
#define INTC_ICDICFR27_TINT26_1                 (0x00200000uL)
#define INTC_ICDICFR27_TINT27_0                 (0x00400000uL)
#define INTC_ICDICFR27_TINT27_1                 (0x00800000uL)
#define INTC_ICDICFR27_TINT28_0                 (0x01000000uL)
#define INTC_ICDICFR27_TINT28_1                 (0x02000000uL)
#define INTC_ICDICFR27_TINT29_0                 (0x04000000uL)
#define INTC_ICDICFR27_TINT29_1                 (0x08000000uL)
#define INTC_ICDICFR27_TINT30_0                 (0x10000000uL)
#define INTC_ICDICFR27_TINT30_1                 (0x20000000uL)
#define INTC_ICDICFR27_TINT31_0                 (0x40000000uL)
#define INTC_ICDICFR27_TINT31_1                 (0x80000000uL)

#define INTC_ICDICFR28_TINT32_0                 (0x00000001uL)
#define INTC_ICDICFR28_TINT32_1                 (0x00000002uL)
#define INTC_ICDICFR28_TINT33_0                 (0x00000004uL)
#define INTC_ICDICFR28_TINT33_1                 (0x00000008uL)
#define INTC_ICDICFR28_TINT34_0                 (0x00000010uL)
#define INTC_ICDICFR28_TINT34_1                 (0x00000020uL)
#define INTC_ICDICFR28_TINT35_0                 (0x00000040uL)
#define INTC_ICDICFR28_TINT35_1                 (0x00000080uL)
#define INTC_ICDICFR28_TINT36_0                 (0x00000100uL)
#define INTC_ICDICFR28_TINT36_1                 (0x00000200uL)
#define INTC_ICDICFR28_TINT37_0                 (0x00000400uL)
#define INTC_ICDICFR28_TINT37_1                 (0x00000800uL)
#define INTC_ICDICFR28_TINT38_0                 (0x00001000uL)
#define INTC_ICDICFR28_TINT38_1                 (0x00002000uL)
#define INTC_ICDICFR28_TINT39_0                 (0x00004000uL)
#define INTC_ICDICFR28_TINT39_1                 (0x00008000uL)
#define INTC_ICDICFR28_TINT40_0                 (0x00010000uL)
#define INTC_ICDICFR28_TINT40_1                 (0x00020000uL)
#define INTC_ICDICFR28_TINT41_0                 (0x00040000uL)
#define INTC_ICDICFR28_TINT41_1                 (0x00080000uL)
#define INTC_ICDICFR28_TINT42_0                 (0x00100000uL)
#define INTC_ICDICFR28_TINT42_1                 (0x00200000uL)
#define INTC_ICDICFR28_TINT43_0                 (0x00400000uL)
#define INTC_ICDICFR28_TINT43_1                 (0x00800000uL)
#define INTC_ICDICFR28_TINT44_0                 (0x01000000uL)
#define INTC_ICDICFR28_TINT44_1                 (0x02000000uL)
#define INTC_ICDICFR28_TINT45_0                 (0x04000000uL)
#define INTC_ICDICFR28_TINT45_1                 (0x08000000uL)
#define INTC_ICDICFR28_TINT46_0                 (0x10000000uL)
#define INTC_ICDICFR28_TINT46_1                 (0x20000000uL)
#define INTC_ICDICFR28_TINT47_0                 (0x40000000uL)
#define INTC_ICDICFR28_TINT47_1                 (0x80000000uL)

#define INTC_ICDICFR29_TINT48_0                 (0x00000001uL)
#define INTC_ICDICFR29_TINT48_1                 (0x00000002uL)
#define INTC_ICDICFR29_TINT49_0                 (0x00000004uL)
#define INTC_ICDICFR29_TINT49_1                 (0x00000008uL)
#define INTC_ICDICFR29_TINT50_0                 (0x00000010uL)
#define INTC_ICDICFR29_TINT50_1                 (0x00000020uL)
#define INTC_ICDICFR29_TINT51_0                 (0x00000040uL)
#define INTC_ICDICFR29_TINT51_1                 (0x00000080uL)
#define INTC_ICDICFR29_TINT52_0                 (0x00000100uL)
#define INTC_ICDICFR29_TINT52_1                 (0x00000200uL)
#define INTC_ICDICFR29_TINT53_0                 (0x00000400uL)
#define INTC_ICDICFR29_TINT53_1                 (0x00000800uL)
#define INTC_ICDICFR29_TINT54_0                 (0x00001000uL)
#define INTC_ICDICFR29_TINT54_1                 (0x00002000uL)
#define INTC_ICDICFR29_TINT55_0                 (0x00004000uL)
#define INTC_ICDICFR29_TINT55_1                 (0x00008000uL)
#define INTC_ICDICFR29_TINT56_0                 (0x00010000uL)
#define INTC_ICDICFR29_TINT56_1                 (0x00020000uL)
#define INTC_ICDICFR29_TINT57_0                 (0x00040000uL)
#define INTC_ICDICFR29_TINT57_1                 (0x00080000uL)
#define INTC_ICDICFR29_TINT58_0                 (0x00100000uL)
#define INTC_ICDICFR29_TINT58_1                 (0x00200000uL)
#define INTC_ICDICFR29_TINT59_0                 (0x00400000uL)
#define INTC_ICDICFR29_TINT59_1                 (0x00800000uL)
#define INTC_ICDICFR29_TINT60_0                 (0x01000000uL)
#define INTC_ICDICFR29_TINT60_1                 (0x02000000uL)
#define INTC_ICDICFR29_TINT61_0                 (0x04000000uL)
#define INTC_ICDICFR29_TINT61_1                 (0x08000000uL)
#define INTC_ICDICFR29_TINT62_0                 (0x10000000uL)
#define INTC_ICDICFR29_TINT62_1                 (0x20000000uL)
#define INTC_ICDICFR29_TINT63_0                 (0x40000000uL)
#define INTC_ICDICFR29_TINT63_1                 (0x80000000uL)

#define INTC_ICDICFR30_TINT64_0                 (0x00000001uL)
#define INTC_ICDICFR30_TINT64_1                 (0x00000002uL)
#define INTC_ICDICFR30_TINT65_0                 (0x00000004uL)
#define INTC_ICDICFR30_TINT65_1                 (0x00000008uL)
#define INTC_ICDICFR30_TINT66_0                 (0x00000010uL)
#define INTC_ICDICFR30_TINT66_1                 (0x00000020uL)
#define INTC_ICDICFR30_TINT67_0                 (0x00000040uL)
#define INTC_ICDICFR30_TINT67_1                 (0x00000080uL)
#define INTC_ICDICFR30_TINT68_0                 (0x00000100uL)
#define INTC_ICDICFR30_TINT68_1                 (0x00000200uL)
#define INTC_ICDICFR30_TINT69_0                 (0x00000400uL)
#define INTC_ICDICFR30_TINT69_1                 (0x00000800uL)
#define INTC_ICDICFR30_TINT70_0                 (0x00001000uL)
#define INTC_ICDICFR30_TINT70_1                 (0x00002000uL)
#define INTC_ICDICFR30_TINT71_0                 (0x00004000uL)
#define INTC_ICDICFR30_TINT71_1                 (0x00008000uL)
#define INTC_ICDICFR30_TINT72_0                 (0x00010000uL)
#define INTC_ICDICFR30_TINT72_1                 (0x00020000uL)
#define INTC_ICDICFR30_TINT73_0                 (0x00040000uL)
#define INTC_ICDICFR30_TINT73_1                 (0x00080000uL)
#define INTC_ICDICFR30_TINT74_0                 (0x00100000uL)
#define INTC_ICDICFR30_TINT74_1                 (0x00200000uL)
#define INTC_ICDICFR30_TINT75_0                 (0x00400000uL)
#define INTC_ICDICFR30_TINT75_1                 (0x00800000uL)
#define INTC_ICDICFR30_TINT76_0                 (0x01000000uL)
#define INTC_ICDICFR30_TINT76_1                 (0x02000000uL)
#define INTC_ICDICFR30_TINT77_0                 (0x04000000uL)
#define INTC_ICDICFR30_TINT77_1                 (0x08000000uL)
#define INTC_ICDICFR30_TINT78_0                 (0x10000000uL)
#define INTC_ICDICFR30_TINT78_1                 (0x20000000uL)
#define INTC_ICDICFR30_TINT79_0                 (0x40000000uL)
#define INTC_ICDICFR30_TINT79_1                 (0x80000000uL)

#define INTC_ICDICFR31_TINT80_0                 (0x00000001uL)
#define INTC_ICDICFR31_TINT80_1                 (0x00000002uL)
#define INTC_ICDICFR31_TINT81_0                 (0x00000004uL)
#define INTC_ICDICFR31_TINT81_1                 (0x00000008uL)
#define INTC_ICDICFR31_TINT82_0                 (0x00000010uL)
#define INTC_ICDICFR31_TINT82_1                 (0x00000020uL)
#define INTC_ICDICFR31_TINT83_0                 (0x00000040uL)
#define INTC_ICDICFR31_TINT83_1                 (0x00000080uL)
#define INTC_ICDICFR31_TINT84_0                 (0x00000100uL)
#define INTC_ICDICFR31_TINT84_1                 (0x00000200uL)
#define INTC_ICDICFR31_TINT85_0                 (0x00000400uL)
#define INTC_ICDICFR31_TINT85_1                 (0x00000800uL)
#define INTC_ICDICFR31_TINT86_0                 (0x00001000uL)
#define INTC_ICDICFR31_TINT86_1                 (0x00002000uL)
#define INTC_ICDICFR31_TINT87_0                 (0x00004000uL)
#define INTC_ICDICFR31_TINT87_1                 (0x00008000uL)
#define INTC_ICDICFR31_TINT88_0                 (0x00010000uL)
#define INTC_ICDICFR31_TINT88_1                 (0x00020000uL)
#define INTC_ICDICFR31_TINT89_0                 (0x00040000uL)
#define INTC_ICDICFR31_TINT89_1                 (0x00080000uL)
#define INTC_ICDICFR31_TINT90_0                 (0x00100000uL)
#define INTC_ICDICFR31_TINT90_1                 (0x00200000uL)
#define INTC_ICDICFR31_TINT91_0                 (0x00400000uL)
#define INTC_ICDICFR31_TINT91_1                 (0x00800000uL)
#define INTC_ICDICFR31_TINT92_0                 (0x01000000uL)
#define INTC_ICDICFR31_TINT92_1                 (0x02000000uL)
#define INTC_ICDICFR31_TINT93_0                 (0x04000000uL)
#define INTC_ICDICFR31_TINT93_1                 (0x08000000uL)
#define INTC_ICDICFR31_TINT94_0                 (0x10000000uL)
#define INTC_ICDICFR31_TINT94_1                 (0x20000000uL)
#define INTC_ICDICFR31_TINT95_0                 (0x40000000uL)
#define INTC_ICDICFR31_TINT95_1                 (0x80000000uL)

#define INTC_ICDICFR32_TINT96_0                 (0x00000001uL)
#define INTC_ICDICFR32_TINT96_1                 (0x00000002uL)
#define INTC_ICDICFR32_TINT97_0                 (0x00000004uL)
#define INTC_ICDICFR32_TINT97_1                 (0x00000008uL)
#define INTC_ICDICFR32_TINT98_0                 (0x00000010uL)
#define INTC_ICDICFR32_TINT98_1                 (0x00000020uL)
#define INTC_ICDICFR32_TINT99_0                 (0x00000040uL)
#define INTC_ICDICFR32_TINT99_1                 (0x00000080uL)
#define INTC_ICDICFR32_TINT100_0                (0x00000100uL)
#define INTC_ICDICFR32_TINT100_1                (0x00000200uL)
#define INTC_ICDICFR32_TINT101_0                (0x00000400uL)
#define INTC_ICDICFR32_TINT101_1                (0x00000800uL)
#define INTC_ICDICFR32_TINT102_0                (0x00001000uL)
#define INTC_ICDICFR32_TINT102_1                (0x00002000uL)
#define INTC_ICDICFR32_TINT103_0                (0x00004000uL)
#define INTC_ICDICFR32_TINT103_1                (0x00008000uL)
#define INTC_ICDICFR32_TINT104_0                (0x00010000uL)
#define INTC_ICDICFR32_TINT104_1                (0x00020000uL)
#define INTC_ICDICFR32_TINT105_0                (0x00040000uL)
#define INTC_ICDICFR32_TINT105_1                (0x00080000uL)
#define INTC_ICDICFR32_TINT106_0                (0x00100000uL)
#define INTC_ICDICFR32_TINT106_1                (0x00200000uL)
#define INTC_ICDICFR32_TINT107_0                (0x00400000uL)
#define INTC_ICDICFR32_TINT107_1                (0x00800000uL)
#define INTC_ICDICFR32_TINT108_0                (0x01000000uL)
#define INTC_ICDICFR32_TINT108_1                (0x02000000uL)
#define INTC_ICDICFR32_TINT109_0                (0x04000000uL)
#define INTC_ICDICFR32_TINT109_1                (0x08000000uL)
#define INTC_ICDICFR32_TINT110_0                (0x10000000uL)
#define INTC_ICDICFR32_TINT110_1                (0x20000000uL)
#define INTC_ICDICFR32_TINT111_0                (0x40000000uL)
#define INTC_ICDICFR32_TINT111_1                (0x80000000uL)

#define INTC_ICDICFR33_TINT112_0                (0x00000001uL)
#define INTC_ICDICFR33_TINT112_1                (0x00000002uL)
#define INTC_ICDICFR33_TINT113_0                (0x00000004uL)
#define INTC_ICDICFR33_TINT113_1                (0x00000008uL)
#define INTC_ICDICFR33_TINT114_0                (0x00000010uL)
#define INTC_ICDICFR33_TINT114_1                (0x00000020uL)
#define INTC_ICDICFR33_TINT115_0                (0x00000040uL)
#define INTC_ICDICFR33_TINT115_1                (0x00000080uL)
#define INTC_ICDICFR33_TINT116_0                (0x00000100uL)
#define INTC_ICDICFR33_TINT116_1                (0x00000200uL)
#define INTC_ICDICFR33_TINT117_0                (0x00000400uL)
#define INTC_ICDICFR33_TINT117_1                (0x00000800uL)
#define INTC_ICDICFR33_TINT118_0                (0x00001000uL)
#define INTC_ICDICFR33_TINT118_1                (0x00002000uL)
#define INTC_ICDICFR33_TINT119_0                (0x00004000uL)
#define INTC_ICDICFR33_TINT119_1                (0x00008000uL)
#define INTC_ICDICFR33_TINT120_0                (0x00010000uL)
#define INTC_ICDICFR33_TINT120_1                (0x00020000uL)
#define INTC_ICDICFR33_TINT121_0                (0x00040000uL)
#define INTC_ICDICFR33_TINT121_1                (0x00080000uL)
#define INTC_ICDICFR33_TINT122_0                (0x00100000uL)
#define INTC_ICDICFR33_TINT122_1                (0x00200000uL)
#define INTC_ICDICFR33_TINT123_0                (0x00400000uL)
#define INTC_ICDICFR33_TINT123_1                (0x00800000uL)
#define INTC_ICDICFR33_TINT124_0                (0x01000000uL)
#define INTC_ICDICFR33_TINT124_1                (0x02000000uL)
#define INTC_ICDICFR33_TINT125_0                (0x04000000uL)
#define INTC_ICDICFR33_TINT125_1                (0x08000000uL)
#define INTC_ICDICFR33_TINT126_0                (0x10000000uL)
#define INTC_ICDICFR33_TINT126_1                (0x20000000uL)
#define INTC_ICDICFR33_TINT127_0                (0x40000000uL)
#define INTC_ICDICFR33_TINT127_1                (0x80000000uL)

#define INTC_ICDICFR34_TINT128_0                (0x00000001uL)
#define INTC_ICDICFR34_TINT128_1                (0x00000002uL)
#define INTC_ICDICFR34_TINT129_0                (0x00000004uL)
#define INTC_ICDICFR34_TINT129_1                (0x00000008uL)
#define INTC_ICDICFR34_TINT130_0                (0x00000010uL)
#define INTC_ICDICFR34_TINT130_1                (0x00000020uL)
#define INTC_ICDICFR34_TINT131_0                (0x00000040uL)
#define INTC_ICDICFR34_TINT131_1                (0x00000080uL)
#define INTC_ICDICFR34_TINT132_0                (0x00000100uL)
#define INTC_ICDICFR34_TINT132_1                (0x00000200uL)
#define INTC_ICDICFR34_TINT133_0                (0x00000400uL)
#define INTC_ICDICFR34_TINT133_1                (0x00000800uL)
#define INTC_ICDICFR34_TINT134_0                (0x00001000uL)
#define INTC_ICDICFR34_TINT134_1                (0x00002000uL)
#define INTC_ICDICFR34_TINT135_0                (0x00004000uL)
#define INTC_ICDICFR34_TINT135_1                (0x00008000uL)
#define INTC_ICDICFR34_TINT136_0                (0x00010000uL)
#define INTC_ICDICFR34_TINT136_1                (0x00020000uL)
#define INTC_ICDICFR34_TINT137_0                (0x00040000uL)
#define INTC_ICDICFR34_TINT137_1                (0x00080000uL)
#define INTC_ICDICFR34_TINT138_0                (0x00100000uL)
#define INTC_ICDICFR34_TINT138_1                (0x00200000uL)
#define INTC_ICDICFR34_TINT139_0                (0x00400000uL)
#define INTC_ICDICFR34_TINT139_1                (0x00800000uL)
#define INTC_ICDICFR34_TINT140_0                (0x01000000uL)
#define INTC_ICDICFR34_TINT140_1                (0x02000000uL)
#define INTC_ICDICFR34_TINT141_0                (0x04000000uL)
#define INTC_ICDICFR34_TINT141_1                (0x08000000uL)
#define INTC_ICDICFR34_TINT142_0                (0x10000000uL)
#define INTC_ICDICFR34_TINT142_1                (0x20000000uL)
#define INTC_ICDICFR34_TINT143_0                (0x40000000uL)
#define INTC_ICDICFR34_TINT143_1                (0x80000000uL)

#define INTC_ICDICFR35_TINT144_0                (0x00000001uL)
#define INTC_ICDICFR35_TINT144_1                (0x00000002uL)
#define INTC_ICDICFR35_TINT145_0                (0x00000004uL)
#define INTC_ICDICFR35_TINT145_1                (0x00000008uL)
#define INTC_ICDICFR35_TINT146_0                (0x00000010uL)
#define INTC_ICDICFR35_TINT146_1                (0x00000020uL)
#define INTC_ICDICFR35_TINT147_0                (0x00000040uL)
#define INTC_ICDICFR35_TINT147_1                (0x00000080uL)
#define INTC_ICDICFR35_TINT148_0                (0x00000100uL)
#define INTC_ICDICFR35_TINT148_1                (0x00000200uL)
#define INTC_ICDICFR35_TINT149_0                (0x00000400uL)
#define INTC_ICDICFR35_TINT149_1                (0x00000800uL)
#define INTC_ICDICFR35_TINT150_0                (0x00001000uL)
#define INTC_ICDICFR35_TINT150_1                (0x00002000uL)
#define INTC_ICDICFR35_TINT151_0                (0x00004000uL)
#define INTC_ICDICFR35_TINT151_1                (0x00008000uL)
#define INTC_ICDICFR35_TINT152_0                (0x00010000uL)
#define INTC_ICDICFR35_TINT152_1                (0x00020000uL)
#define INTC_ICDICFR35_TINT153_0                (0x00040000uL)
#define INTC_ICDICFR35_TINT153_1                (0x00080000uL)
#define INTC_ICDICFR35_TINT154_0                (0x00100000uL)
#define INTC_ICDICFR35_TINT154_1                (0x00200000uL)
#define INTC_ICDICFR35_TINT155_0                (0x00400000uL)
#define INTC_ICDICFR35_TINT155_1                (0x00800000uL)
#define INTC_ICDICFR35_TINT156_0                (0x01000000uL)
#define INTC_ICDICFR35_TINT156_1                (0x02000000uL)
#define INTC_ICDICFR35_TINT157_0                (0x04000000uL)
#define INTC_ICDICFR35_TINT157_1                (0x08000000uL)
#define INTC_ICDICFR35_TINT158_0                (0x10000000uL)
#define INTC_ICDICFR35_TINT158_1                (0x20000000uL)
#define INTC_ICDICFR35_TINT159_0                (0x40000000uL)
#define INTC_ICDICFR35_TINT159_1                (0x80000000uL)

#define INTC_ICDICFR36_TINT160_0                (0x00000001uL)
#define INTC_ICDICFR36_TINT160_1                (0x00000002uL)
#define INTC_ICDICFR36_TINT161_0                (0x00000004uL)
#define INTC_ICDICFR36_TINT161_1                (0x00000008uL)
#define INTC_ICDICFR36_TINT162_0                (0x00000010uL)
#define INTC_ICDICFR36_TINT162_1                (0x00000020uL)
#define INTC_ICDICFR36_TINT163_0                (0x00000040uL)
#define INTC_ICDICFR36_TINT163_1                (0x00000080uL)
#define INTC_ICDICFR36_TINT164_0                (0x00000100uL)
#define INTC_ICDICFR36_TINT164_1                (0x00000200uL)
#define INTC_ICDICFR36_TINT165_0                (0x00000400uL)
#define INTC_ICDICFR36_TINT165_1                (0x00000800uL)
#define INTC_ICDICFR36_TINT166_0                (0x00001000uL)
#define INTC_ICDICFR36_TINT166_1                (0x00002000uL)
#define INTC_ICDICFR36_TINT167_0                (0x00004000uL)
#define INTC_ICDICFR36_TINT167_1                (0x00008000uL)
#define INTC_ICDICFR36_TINT168_0                (0x00010000uL)
#define INTC_ICDICFR36_TINT168_1                (0x00020000uL)
#define INTC_ICDICFR36_TINT169_0                (0x00040000uL)
#define INTC_ICDICFR36_TINT169_1                (0x00080000uL)
#define INTC_ICDICFR36_TINT170_0                (0x00100000uL)
#define INTC_ICDICFR36_TINT170_1                (0x00200000uL)

#define INTC_ICDSGIR_SGIINTID                   (0x0000000FuL)
#define INTC_ICDSGIR_SATT                       (0x00008000uL)
#define INTC_ICDSGIR_CPUTargetList              (0x00FF0000uL)
#define INTC_ICDSGIR_TargetListFilter           (0x03000000uL)

#define INTC_ICCICR_EnableS                     (0x00000001uL)
#define INTC_ICCICR_EnableNS                    (0x00000002uL)
#define INTC_ICCICR_AckCtl                      (0x00000004uL)
#define INTC_ICCICR_FIQEn                       (0x00000008uL)
#define INTC_ICCICR_SBPR                        (0x00000010uL)

#define INTC_ICCPMR_Priority                    (0x000000FFuL)

#define INTC_ICCBPR_Binarypoint                 (0x00000007uL)

#define INTC_ICCIAR_ACKINTID                    (0x000003FFuL)
#define INTC_ICCIAR_CPUID                       (0x00001C00uL)

#define INTC_ICCEOIR_EOIINTID                   (0x000003FFuL)
#define INTC_ICCEOIR_CPUID                      (0x00001C00uL)

#define INTC_ICCRPR_Priority                    (0x000000FFuL)

#define INTC_ICCHPIR_PENDINTID                  (0x000003FFuL)
#define INTC_ICCHPIR_CPUID                      (0x00001C00uL)

#define INTC_ICCABPR_Binarypoint                (0x00000007uL)

#define INTC_ICCIIDR_Implementer                (0x00000FFFuL)
#define INTC_ICCIIDR_Revision                   (0x0000F000uL)
#define INTC_ICCIIDR_Architecture_version       (0x000F0000uL)
#define INTC_ICCIIDR_ProductID                  (0xFFF00000uL)

#define INTC_ICR0_NMIF                          (0x0002u)
#define INTC_ICR0_NMIE                          (0x0100u)
#define INTC_ICR0_NMIL                          (0x8000u)

#define INTC_ICR1_IRQ00S                        (0x0001u)
#define INTC_ICR1_IRQ01S                        (0x0002u)
#define INTC_ICR1_IRQ10S                        (0x0004u)
#define INTC_ICR1_IRQ11S                        (0x0008u)
#define INTC_ICR1_IRQ20S                        (0x0010u)
#define INTC_ICR1_IRQ21S                        (0x0020u)
#define INTC_ICR1_IRQ30S                        (0x0040u)
#define INTC_ICR1_IRQ31S                        (0x0080u)
#define INTC_ICR1_IRQ40S                        (0x0100u)
#define INTC_ICR1_IRQ41S                        (0x0200u)
#define INTC_ICR1_IRQ50S                        (0x0400u)
#define INTC_ICR1_IRQ51S                        (0x0800u)
#define INTC_ICR1_IRQ60S                        (0x1000u)
#define INTC_ICR1_IRQ61S                        (0x2000u)
#define INTC_ICR1_IRQ70S                        (0x4000u)
#define INTC_ICR1_IRQ71S                        (0x8000u)

#define INTC_IRQRR_IRQ0F                        (0x0001u)
#define INTC_IRQRR_IRQ1F                        (0x0002u)
#define INTC_IRQRR_IRQ2F                        (0x0004u)
#define INTC_IRQRR_IRQ3F                        (0x0008u)
#define INTC_IRQRR_IRQ4F                        (0x0010u)
#define INTC_IRQRR_IRQ5F                        (0x0020u)
#define INTC_IRQRR_IRQ6F                        (0x0040u)
#define INTC_IRQRR_IRQ7F                        (0x0080u)


/* ==== Shift values for IO registers ==== */
#define INTC_ICDDCR_Enable_SHIFT                (0u)

#define INTC_ICDICTR_ITLinesNumber_SHIFT        (0u)
#define INTC_ICDICTR_CPUNumber_SHIFT            (5u)
#define INTC_ICDICTR_SecurityExtn_SHIFT         (10u)
#define INTC_ICDICTR_LSPI_SHIFT                 (11u)

#define INTC_ICDIIDR_Implementer_SHIFT          (0u)
#define INTC_ICDIIDR_Revision_SHIFT             (12u)
#define INTC_ICDIIDR_Variant_SHIFT              (16u)
#define INTC_ICDIIDR_ProductID_SHIFT            (24u)

#define INTC_ICDISR0_SW0_SHIFT                  (0u)
#define INTC_ICDISR0_SW1_SHIFT                  (1u)
#define INTC_ICDISR0_SW2_SHIFT                  (2u)
#define INTC_ICDISR0_SW3_SHIFT                  (3u)
#define INTC_ICDISR0_SW4_SHIFT                  (4u)
#define INTC_ICDISR0_SW5_SHIFT                  (5u)
#define INTC_ICDISR0_SW6_SHIFT                  (6u)
#define INTC_ICDISR0_SW7_SHIFT                  (7u)
#define INTC_ICDISR0_SW8_SHIFT                  (8u)
#define INTC_ICDISR0_SW9_SHIFT                  (9u)
#define INTC_ICDISR0_SW10_SHIFT                 (10u)
#define INTC_ICDISR0_SW11_SHIFT                 (11u)
#define INTC_ICDISR0_SW12_SHIFT                 (12u)
#define INTC_ICDISR0_SW13_SHIFT                 (13u)
#define INTC_ICDISR0_SW14_SHIFT                 (14u)
#define INTC_ICDISR0_SW15_SHIFT                 (15u)
#define INTC_ICDISR0_PMUIRQ0_SHIFT              (16u)
#define INTC_ICDISR0_COMMRX0_SHIFT              (17u)
#define INTC_ICDISR0_COMMTX0_SHIFT              (18u)
#define INTC_ICDISR0_CTIIRQ0_SHIFT              (19u)

#define INTC_ICDISR1_IRQ0_SHIFT                 (0u)
#define INTC_ICDISR1_IRQ1_SHIFT                 (1u)
#define INTC_ICDISR1_IRQ2_SHIFT                 (2u)
#define INTC_ICDISR1_IRQ3_SHIFT                 (3u)
#define INTC_ICDISR1_IRQ4_SHIFT                 (4u)
#define INTC_ICDISR1_IRQ5_SHIFT                 (5u)
#define INTC_ICDISR1_IRQ6_SHIFT                 (6u)
#define INTC_ICDISR1_IRQ7_SHIFT                 (7u)
#define INTC_ICDISR1_PL310ERR_SHIFT             (8u)
#define INTC_ICDISR1_DMAINT0_SHIFT              (9u)
#define INTC_ICDISR1_DMAINT1_SHIFT              (10u)
#define INTC_ICDISR1_DMAINT2_SHIFT              (11u)
#define INTC_ICDISR1_DMAINT3_SHIFT              (12u)
#define INTC_ICDISR1_DMAINT4_SHIFT              (13u)
#define INTC_ICDISR1_DMAINT5_SHIFT              (14u)
#define INTC_ICDISR1_DMAINT6_SHIFT              (15u)
#define INTC_ICDISR1_DMAINT7_SHIFT              (16u)
#define INTC_ICDISR1_DMAINT8_SHIFT              (17u)
#define INTC_ICDISR1_DMAINT9_SHIFT              (18u)
#define INTC_ICDISR1_DMAINT10_SHIFT             (19u)
#define INTC_ICDISR1_DMAINT11_SHIFT             (20u)
#define INTC_ICDISR1_DMAINT12_SHIFT             (21u)
#define INTC_ICDISR1_DMAINT13_SHIFT             (22u)
#define INTC_ICDISR1_DMAINT14_SHIFT             (23u)
#define INTC_ICDISR1_DMAINT15_SHIFT             (24u)
#define INTC_ICDISR1_DMAERR_SHIFT               (25u)

#define INTC_ICDISR2_USBI0_SHIFT                (9u)
#define INTC_ICDISR2_USBI1_SHIFT                (10u)
#define INTC_ICDISR2_S0_VI_VSYNC0_SHIFT         (11u)
#define INTC_ICDISR2_S0_LO_VSYNC0_SHIFT         (12u)
#define INTC_ICDISR2_S0_VSYNCERR0_SHIFT         (13u)
#define INTC_ICDISR2_GR3_VLINE0_SHIFT           (14u)
#define INTC_ICDISR2_S0_VFIELD0_SHIFT           (15u)
#define INTC_ICDISR2_IV1_VBUFERR0_SHIFT         (16u)
#define INTC_ICDISR2_IV3_VBUFERR0_SHIFT         (17u)
#define INTC_ICDISR2_IV5_VBUFERR0_SHIFT         (18u)
#define INTC_ICDISR2_IV6_VBUFERR0_SHIFT         (19u)
#define INTC_ICDISR2_S0_WLINE0_SHIFT            (20u)
#define INTC_ICDISR2_S1_VI_VSYNC0_SHIFT         (21u)
#define INTC_ICDISR2_S1_LO_VSYNC0_SHIFT         (22u)
#define INTC_ICDISR2_S1_VSYNCERR0_SHIFT         (23u)
#define INTC_ICDISR2_S1_VFIELD0_SHIFT           (24u)
#define INTC_ICDISR2_IV2_VBUFERR0_SHIFT         (25u)
#define INTC_ICDISR2_IV4_VBUFERR0_SHIFT         (26u)
#define INTC_ICDISR2_S1_WLINE0_SHIFT            (27u)
#define INTC_ICDISR2_OIR_VI_VSYNC0_SHIFT        (28u)
#define INTC_ICDISR2_OIR_LO_VSYNC0_SHIFT        (29u)
#define INTC_ICDISR2_OIR_VSYNCERR0_SHIFT        (30u)
#define INTC_ICDISR2_OIR_VFIELD0_SHIFT          (31u)

#define INTC_ICDISR3_IV7_VBUFERR0_SHIFT         (0u)
#define INTC_ICDISR3_IV8_VBUFERR0_SHIFT         (1u)
#define INTC_ICDISR3_OIR_WLINE0_SHIFT           (2u)
#define INTC_ICDISR3_S0_VI_VSYNC1_SHIFT         (3u)
#define INTC_ICDISR3_S0_LO_VSYNC1_SHIFT         (4u)
#define INTC_ICDISR3_S0_VSYNCERR1_SHIFT         (5u)
#define INTC_ICDISR3_GR3_VLINE1_SHIFT           (6u)
#define INTC_ICDISR3_S0_VFIELD1_SHIFT           (7u)
#define INTC_ICDISR3_IV1_VBUFERR1_SHIFT         (8u)
#define INTC_ICDISR3_IV3_VBUFERR1_SHIFT         (9u)
#define INTC_ICDISR3_IV5_VBUFERR1_SHIFT         (10u)
#define INTC_ICDISR3_IV6_VBUFERR1_SHIFT         (11u)
#define INTC_ICDISR3_S0_WLINE1_SHIFT            (12u)
#define INTC_ICDISR3_S1_VI_VSYNC1_SHIFT         (13u)
#define INTC_ICDISR3_S1_LO_VSYNC1_SHIFT         (14u)
#define INTC_ICDISR3_S1_VSYNCERR1_SHIFT         (15u)
#define INTC_ICDISR3_S1_VFIELD1_SHIFT           (16u)
#define INTC_ICDISR3_IV2_VBUFERR1_SHIFT         (17u)
#define INTC_ICDISR3_IV4_VBUFERR1_SHIFT         (18u)
#define INTC_ICDISR3_S1_WLINE1_SHIFT            (19u)
#define INTC_ICDISR3_OIR_VI_VSYNC1_SHIFT        (20u)
#define INTC_ICDISR3_OIR_LO_VSYNC1_SHIFT        (21u)
#define INTC_ICDISR3_OIR_VLINE1_SHIFT           (22u)
#define INTC_ICDISR3_OIR_VFIELD1_SHIFT          (23u)
#define INTC_ICDISR3_IV7_VBUFERR1_SHIFT         (24u)
#define INTC_ICDISR3_IV8_VBUFERR1_SHIFT         (25u)
#define INTC_ICDISR3_OIR_WLINE1_SHIFT           (26u)
#define INTC_ICDISR3_IMRDI_SHIFT                (27u)
#define INTC_ICDISR3_IMR2I0_SHIFT               (28u)
#define INTC_ICDISR3_IMR2I1_SHIFT               (29u)
#define INTC_ICDISR3_JEDI_SHIFT                 (30u)
#define INTC_ICDISR3_JDTI_SHIFT                 (31u)

#define INTC_ICDISR4_CMP0_SHIFT                 (0u)
#define INTC_ICDISR4_CMP1_SHIFT                 (1u)
#define INTC_ICDISR4_INT0_SHIFT                 (2u)
#define INTC_ICDISR4_INT1_SHIFT                 (3u)
#define INTC_ICDISR4_INT2_SHIFT                 (4u)
#define INTC_ICDISR4_INT3_SHIFT                 (5u)
#define INTC_ICDISR4_OSTM0TINT_SHIFT            (6u)
#define INTC_ICDISR4_OSTM1TINT_SHIFT            (7u)
#define INTC_ICDISR4_CMI_SHIFT                  (8u)
#define INTC_ICDISR4_WTOUT_SHIFT                (9u)
#define INTC_ICDISR4_ITI_SHIFT                  (10u)
#define INTC_ICDISR4_TGI0A_SHIFT                (11u)
#define INTC_ICDISR4_TGI0B_SHIFT                (12u)
#define INTC_ICDISR4_TGI0C_SHIFT                (13u)
#define INTC_ICDISR4_TGI0D_SHIFT                (14u)
#define INTC_ICDISR4_TGI0V_SHIFT                (15u)
#define INTC_ICDISR4_TGI0E_SHIFT                (16u)
#define INTC_ICDISR4_TGI0F_SHIFT                (17u)
#define INTC_ICDISR4_TGI1A_SHIFT                (18u)
#define INTC_ICDISR4_TGI1B_SHIFT                (19u)
#define INTC_ICDISR4_TGI1V_SHIFT                (20u)
#define INTC_ICDISR4_TGI1U_SHIFT                (21u)
#define INTC_ICDISR4_TGI2A_SHIFT                (22u)
#define INTC_ICDISR4_TGI2B_SHIFT                (23u)
#define INTC_ICDISR4_TGI2V_SHIFT                (24u)
#define INTC_ICDISR4_TGI2U_SHIFT                (25u)
#define INTC_ICDISR4_TGI3A_SHIFT                (26u)
#define INTC_ICDISR4_TGI3B_SHIFT                (27u)
#define INTC_ICDISR4_TGI3C_SHIFT                (28u)
#define INTC_ICDISR4_TGI3D_SHIFT                (29u)
#define INTC_ICDISR4_TGI3V_SHIFT                (30u)
#define INTC_ICDISR4_TGI4A_SHIFT                (31u)

#define INTC_ICDISR5_TGI4B_SHIFT                (0u)
#define INTC_ICDISR5_TGI4C_SHIFT                (1u)
#define INTC_ICDISR5_TGI4D_SHIFT                (2u)
#define INTC_ICDISR5_TGI4V_SHIFT                (3u)
#define INTC_ICDISR5_CMI1_SHIFT                 (4u)
#define INTC_ICDISR5_CMI2_SHIFT                 (5u)
#define INTC_ICDISR5_SGDEI0_SHIFT               (6u)
#define INTC_ICDISR5_SGDEI1_SHIFT               (7u)
#define INTC_ICDISR5_SGDEI2_SHIFT               (8u)
#define INTC_ICDISR5_SGDEI3_SHIFT               (9u)
#define INTC_ICDISR5_ADI_SHIFT                  (10u)
#define INTC_ICDISR5_LMTI_SHIFT                 (11u)
#define INTC_ICDISR5_SSII0_SHIFT                (12u)
#define INTC_ICDISR5_SSIRXI0_SHIFT              (13u)
#define INTC_ICDISR5_SSITXI0_SHIFT              (14u)
#define INTC_ICDISR5_SSII1_SHIFT                (15u)
#define INTC_ICDISR5_SSIRXI1_SHIFT              (16u)
#define INTC_ICDISR5_SSITXI1_SHIFT              (17u)
#define INTC_ICDISR5_SSII2_SHIFT                (18u)
#define INTC_ICDISR5_SSIRTI2_SHIFT              (19u)
#define INTC_ICDISR5_SSII3_SHIFT                (20u)
#define INTC_ICDISR5_SSIRXI3_SHIFT              (21u)
#define INTC_ICDISR5_SSITXI3_SHIFT              (22u)
#define INTC_ICDISR5_SSII4_SHIFT                (23u)
#define INTC_ICDISR5_SSIRTI4_SHIFT              (24u)
#define INTC_ICDISR5_SSII5_SHIFT                (25u)
#define INTC_ICDISR5_SSIRXI5_SHIFT              (26u)
#define INTC_ICDISR5_SSITXI5_SHIFT              (27u)
#define INTC_ICDISR5_SPDIFI_SHIFT               (28u)
#define INTC_ICDISR5_INTIICTEI0_SHIFT           (29u)
#define INTC_ICDISR5_INTIICRI0_SHIFT            (30u)
#define INTC_ICDISR5_INTIICTI0_SHIFT            (31u)

#define INTC_ICDISR6_INTIICSPI0_SHIFT           (0u)
#define INTC_ICDISR6_INTIICSTI0_SHIFT           (1u)
#define INTC_ICDISR6_INTIICNAKI0_SHIFT          (2u)
#define INTC_ICDISR6_INTIICALI0_SHIFT           (3u)
#define INTC_ICDISR6_INTIICTMOI0_SHIFT          (4u)
#define INTC_ICDISR6_INTIICTEI1_SHIFT           (5u)
#define INTC_ICDISR6_INTIICRI1_SHIFT            (6u)
#define INTC_ICDISR6_INTIICTI1_SHIFT            (7u)
#define INTC_ICDISR6_INTIICSPI1_SHIFT           (8u)
#define INTC_ICDISR6_INTIICSTI1_SHIFT           (9u)
#define INTC_ICDISR6_INTIICNAKI1_SHIFT          (10u)
#define INTC_ICDISR6_INTIICALI1_SHIFT           (11u)
#define INTC_ICDISR6_INTIICTMOI1_SHIFT          (12u)
#define INTC_ICDISR6_INTIICTEI2_SHIFT           (13u)
#define INTC_ICDISR6_INTIICRI2_SHIFT            (14u)
#define INTC_ICDISR6_INTIICTI2_SHIFT            (15u)
#define INTC_ICDISR6_INTIICSPI2_SHIFT           (16u)
#define INTC_ICDISR6_INTIICSTI2_SHIFT           (17u)
#define INTC_ICDISR6_INTIICNAKI2_SHIFT          (18u)
#define INTC_ICDISR6_INTIICALI2_SHIFT           (19u)
#define INTC_ICDISR6_INTIICTMOI2_SHIFT          (20u)
#define INTC_ICDISR6_INTIICTEI3_SHIFT           (21u)
#define INTC_ICDISR6_INTIICRI3_SHIFT            (22u)
#define INTC_ICDISR6_INTIICTI3_SHIFT            (23u)
#define INTC_ICDISR6_INTIICSPI3_SHIFT           (24u)
#define INTC_ICDISR6_INTIICSTI3_SHIFT           (25u)
#define INTC_ICDISR6_INTIICNAKI3_SHIFT          (26u)
#define INTC_ICDISR6_INTIICALI3_SHIFT           (27u)
#define INTC_ICDISR6_INTIICTMOI3_SHIFT          (28u)
#define INTC_ICDISR6_BRI0_SHIFT                 (29u)
#define INTC_ICDISR6_ERI0_SHIFT                 (30u)
#define INTC_ICDISR6_RXI0_SHIFT                 (31u)

#define INTC_ICDISR7_TXI0_SHIFT                 (0u)
#define INTC_ICDISR7_BRI1_SHIFT                 (1u)
#define INTC_ICDISR7_ERI1_SHIFT                 (2u)
#define INTC_ICDISR7_RXI1_SHIFT                 (3u)
#define INTC_ICDISR7_TXI1_SHIFT                 (4u)
#define INTC_ICDISR7_BRI2_SHIFT                 (5u)
#define INTC_ICDISR7_ERI2_SHIFT                 (6u)
#define INTC_ICDISR7_RXI2_SHIFT                 (7u)
#define INTC_ICDISR7_TXI2_SHIFT                 (8u)
#define INTC_ICDISR7_BRI3_SHIFT                 (9u)
#define INTC_ICDISR7_ERI3_SHIFT                 (10u)
#define INTC_ICDISR7_RXI3_SHIFT                 (11u)
#define INTC_ICDISR7_TXI3_SHIFT                 (12u)
#define INTC_ICDISR7_BRI4_SHIFT                 (13u)
#define INTC_ICDISR7_ERI4_SHIFT                 (14u)
#define INTC_ICDISR7_RXI4_SHIFT                 (15u)
#define INTC_ICDISR7_TXI4_SHIFT                 (16u)
#define INTC_ICDISR7_BRI5_SHIFT                 (17u)
#define INTC_ICDISR7_ERI5_SHIFT                 (18u)
#define INTC_ICDISR7_RXI5_SHIFT                 (19u)
#define INTC_ICDISR7_TXI5_SHIFT                 (20u)
#define INTC_ICDISR7_BRI6_SHIFT                 (21u)
#define INTC_ICDISR7_ERI6_SHIFT                 (22u)
#define INTC_ICDISR7_RXI6_SHIFT                 (23u)
#define INTC_ICDISR7_TXI6_SHIFT                 (24u)
#define INTC_ICDISR7_BRI7_SHIFT                 (25u)
#define INTC_ICDISR7_ERI7_SHIFT                 (26u)
#define INTC_ICDISR7_RXI7_SHIFT                 (27u)
#define INTC_ICDISR7_TXI7_SHIFT                 (28u)
#define INTC_ICDISR7_INTRCANGERR_SHIFT          (29u)
#define INTC_ICDISR7_INTRCANGRECC_SHIFT         (30u)
#define INTC_ICDISR7_INTRCAN0REC_SHIFT          (31u)

#define INTC_ICDISR8_INTRCAN0ERR_SHIFT          (0u)
#define INTC_ICDISR8_INTRCAN0TRX_SHIFT          (1u)
#define INTC_ICDISR8_INTRCAN1REC_SHIFT          (2u)
#define INTC_ICDISR8_INTRCAN1ERR_SHIFT          (3u)
#define INTC_ICDISR8_INTRCAN1TRX_SHIFT          (4u)
#define INTC_ICDISR8_INTRCAN2REC_SHIFT          (5u)
#define INTC_ICDISR8_INTRCAN2ERR_SHIFT          (6u)
#define INTC_ICDISR8_INTRCAN2TRX_SHIFT          (7u)
#define INTC_ICDISR8_INTRCAN3REC_SHIFT          (8u)
#define INTC_ICDISR8_INTRCAN3ERR_SHIFT          (9u)
#define INTC_ICDISR8_INTRCAN3TRX_SHIFT          (10u)
#define INTC_ICDISR8_INTRCAN4REC_SHIFT          (11u)
#define INTC_ICDISR8_INTRCAN4ERR_SHIFT          (12u)
#define INTC_ICDISR8_INTRCAN4TRX_SHIFT          (13u)
#define INTC_ICDISR8_SPEI0_SHIFT                (14u)
#define INTC_ICDISR8_SPRI0_SHIFT                (15u)
#define INTC_ICDISR8_SPTI0_SHIFT                (16u)
#define INTC_ICDISR8_SPEI1_SHIFT                (17u)
#define INTC_ICDISR8_SPRI1_SHIFT                (18u)
#define INTC_ICDISR8_SPTI1_SHIFT                (19u)
#define INTC_ICDISR8_SPEI2_SHIFT                (20u)
#define INTC_ICDISR8_SPRI2_SHIFT                (21u)
#define INTC_ICDISR8_SPTI2_SHIFT                (22u)
#define INTC_ICDISR8_SPEI3_SHIFT                (23u)
#define INTC_ICDISR8_SPRI3_SHIFT                (24u)
#define INTC_ICDISR8_SPTI3_SHIFT                (25u)
#define INTC_ICDISR8_SPEI4_SHIFT                (26u)
#define INTC_ICDISR8_SPRI4_SHIFT                (27u)
#define INTC_ICDISR8_SPTI4_SHIFT                (28u)
#define INTC_ICDISR8_IEBBTD_SHIFT               (29u)
#define INTC_ICDISR8_IEBBTERR_SHIFT             (30u)
#define INTC_ICDISR8_IEBBTSTA_SHIFT             (31u)

#define INTC_ICDISR9_IEBBTV_SHIFT               (0u)
#define INTC_ICDISR9_ISY_SHIFT                  (1u)
#define INTC_ICDISR9_IERR_SHIFT                 (2u)
#define INTC_ICDISR9_ITARG_SHIFT                (3u)
#define INTC_ICDISR9_ISEC_SHIFT                 (4u)
#define INTC_ICDISR9_IBUF_SHIFT                 (5u)
#define INTC_ICDISR9_IREADY_SHIFT               (6u)
#define INTC_ICDISR9_FLSTE_SHIFT                (7u)
#define INTC_ICDISR9_FLTENDI_SHIFT              (8u)
#define INTC_ICDISR9_FLTREQ0I_SHIFT             (9u)
#define INTC_ICDISR9_FLTREQ1I_SHIFT             (10u)
#define INTC_ICDISR9_MMC0_SHIFT                 (11u)
#define INTC_ICDISR9_MMC1_SHIFT                 (12u)
#define INTC_ICDISR9_MMC2_SHIFT                 (13u)
#define INTC_ICDISR9_SDHI0_3_SHIFT              (14u)
#define INTC_ICDISR9_SDHI0_0_SHIFT              (15u)
#define INTC_ICDISR9_SDHI0_1_SHIFT              (16u)
#define INTC_ICDISR9_SDHI1_3_SHIFT              (17u)
#define INTC_ICDISR9_SDHI1_0_SHIFT              (18u)
#define INTC_ICDISR9_SDHI1_1_SHIFT              (19u)
#define INTC_ICDISR9_ARM_SHIFT                  (20u)
#define INTC_ICDISR9_PRD_SHIFT                  (21u)
#define INTC_ICDISR9_CUP_SHIFT                  (22u)
#define INTC_ICDISR9_SCUAI0_SHIFT               (23u)
#define INTC_ICDISR9_SCUAI1_SHIFT               (24u)
#define INTC_ICDISR9_SCUFDI0_SHIFT              (25u)
#define INTC_ICDISR9_SCUFDI1_SHIFT              (26u)
#define INTC_ICDISR9_SCUFDI2_SHIFT              (27u)
#define INTC_ICDISR9_SCUFDI3_SHIFT              (28u)
#define INTC_ICDISR9_SCUFUI0_SHIFT              (29u)
#define INTC_ICDISR9_SCUFUI1_SHIFT              (30u)
#define INTC_ICDISR9_SCUFUI2_SHIFT              (31u)

#define INTC_ICDISR10_SCUFUI3_SHIFT             (0u)
#define INTC_ICDISR10_SCUDVI0_SHIFT             (1u)
#define INTC_ICDISR10_SCUDVI1_SHIFT             (2u)
#define INTC_ICDISR10_SCUDVI2_SHIFT             (3u)
#define INTC_ICDISR10_SCUDVI3_SHIFT             (4u)
#define INTC_ICDISR10_MLB_CINT_SHIFT            (5u)
#define INTC_ICDISR10_MLB_SINT_SHIFT            (6u)
#define INTC_ICDISR10_DRC0_SHIFT                (7u)
#define INTC_ICDISR10_DRC1_SHIFT                (8u)
#define INTC_ICDISR10_LINI0_INT_T_SHIFT         (11u)
#define INTC_ICDISR10_LINI0_INT_R_SHIFT         (12u)
#define INTC_ICDISR10_LINI0_INT_S_SHIFT         (13u)
#define INTC_ICDISR10_LINI0_INT_M_SHIFT         (14u)
#define INTC_ICDISR10_LINI1_INT_T_SHIFT         (15u)
#define INTC_ICDISR10_LINI1_INT_R_SHIFT         (16u)
#define INTC_ICDISR10_LINI1_INT_S_SHIFT         (17u)
#define INTC_ICDISR10_LINI1_INT_M_SHIFT         (18u)
#define INTC_ICDISR10_ERI0_SHIFT                (27u)
#define INTC_ICDISR10_RXI0_SHIFT                (28u)
#define INTC_ICDISR10_TXI0_SHIFT                (29u)
#define INTC_ICDISR10_TEI0_SHIFT                (30u)
#define INTC_ICDISR10_ERI1_SHIFT                (31u)

#define INTC_ICDISR11_RXI1_SHIFT                (0u)
#define INTC_ICDISR11_TXI1_SHIFT                (1u)
#define INTC_ICDISR11_TEI1_SHIFT                (2u)
#define INTC_ICDISR11_AVBI_DATA_SHIFT           (3u)
#define INTC_ICDISR11_AVBI_ERROR_SHIFT          (4u)
#define INTC_ICDISR11_AVBI_MANAGE_SHIFT         (5u)
#define INTC_ICDISR11_AVBI_MAC_SHIFT            (6u)
#define INTC_ICDISR11_ETHERI_SHIFT              (7u)
#define INTC_ICDISR11_CEUI_SHIFT                (12u)
#define INTC_ICDISR11_H2XMLB_ERRINT_SHIFT       (29u)
#define INTC_ICDISR11_H2XIC1_ERRINT_SHIFT       (30u)
#define INTC_ICDISR11_X2HPERI1_ERRINT_SHIFT     (31u)

#define INTC_ICDISR12_X2HPERI2_ERRINT_SHIFT     (0u)
#define INTC_ICDISR12_X2HPERI34_ERRINT_SHIFT    (1u)
#define INTC_ICDISR12_X2HPERI5_ERRINT_SHIFT     (2u)
#define INTC_ICDISR12_X2HPERI67_ERRINT_SHIFT    (3u)
#define INTC_ICDISR12_X2HDBGR_ERRINT_SHIFT      (4u)
#define INTC_ICDISR12_X2HBSC_ERRINT_SHIFT       (5u)
#define INTC_ICDISR12_X2HSPI1_ERRINT_SHIFT      (6u)
#define INTC_ICDISR12_X2HSPI2_ERRINT_SHIFT      (7u)
#define INTC_ICDISR12_PRRI_SHIFT                (8u)
#define INTC_ICDISR12_IFEI0_SHIFT               (9u)
#define INTC_ICDISR12_OFFI0_SHIFT               (10u)
#define INTC_ICDISR12_PFVEI0_SHIFT              (11u)
#define INTC_ICDISR12_IFEI1_SHIFT               (12u)
#define INTC_ICDISR12_OFFI1_SHIFT               (13u)
#define INTC_ICDISR12_PFVEI1_SHIFT              (14u)

#define INTC_ICDISR13_TINT0_SHIFT               (0u)
#define INTC_ICDISR13_TINT1_SHIFT               (1u)
#define INTC_ICDISR13_TINT2_SHIFT               (2u)
#define INTC_ICDISR13_TINT3_SHIFT               (3u)
#define INTC_ICDISR13_TINT4_SHIFT               (4u)
#define INTC_ICDISR13_TINT5_SHIFT               (5u)
#define INTC_ICDISR13_TINT6_SHIFT               (6u)
#define INTC_ICDISR13_TINT7_SHIFT               (7u)
#define INTC_ICDISR13_TINT8_SHIFT               (8u)
#define INTC_ICDISR13_TINT9_SHIFT               (9u)
#define INTC_ICDISR13_TINT10_SHIFT              (10u)
#define INTC_ICDISR13_TINT11_SHIFT              (11u)
#define INTC_ICDISR13_TINT12_SHIFT              (12u)
#define INTC_ICDISR13_TINT13_SHIFT              (13u)
#define INTC_ICDISR13_TINT14_SHIFT              (14u)
#define INTC_ICDISR13_TINT15_SHIFT              (15u)
#define INTC_ICDISR13_TINT16_SHIFT              (16u)
#define INTC_ICDISR13_TINT17_SHIFT              (17u)
#define INTC_ICDISR13_TINT18_SHIFT              (18u)
#define INTC_ICDISR13_TINT19_SHIFT              (19u)
#define INTC_ICDISR13_TINT20_SHIFT              (20u)
#define INTC_ICDISR13_TINT21_SHIFT              (21u)
#define INTC_ICDISR13_TINT22_SHIFT              (22u)
#define INTC_ICDISR13_TINT23_SHIFT              (23u)
#define INTC_ICDISR13_TINT24_SHIFT              (24u)
#define INTC_ICDISR13_TINT25_SHIFT              (25u)
#define INTC_ICDISR13_TINT26_SHIFT              (26u)
#define INTC_ICDISR13_TINT27_SHIFT              (27u)
#define INTC_ICDISR13_TINT28_SHIFT              (28u)
#define INTC_ICDISR13_TINT29_SHIFT              (29u)
#define INTC_ICDISR13_TINT30_SHIFT              (30u)
#define INTC_ICDISR13_TINT31_SHIFT              (31u)

#define INTC_ICDISR14_TINT32_SHIFT              (0u)
#define INTC_ICDISR14_TINT33_SHIFT              (1u)
#define INTC_ICDISR14_TINT34_SHIFT              (2u)
#define INTC_ICDISR14_TINT35_SHIFT              (3u)
#define INTC_ICDISR14_TINT36_SHIFT              (4u)
#define INTC_ICDISR14_TINT37_SHIFT              (5u)
#define INTC_ICDISR14_TINT38_SHIFT              (6u)
#define INTC_ICDISR14_TINT39_SHIFT              (7u)
#define INTC_ICDISR14_TINT40_SHIFT              (8u)
#define INTC_ICDISR14_TINT41_SHIFT              (9u)
#define INTC_ICDISR14_TINT42_SHIFT              (10u)
#define INTC_ICDISR14_TINT43_SHIFT              (11u)
#define INTC_ICDISR14_TINT44_SHIFT              (12u)
#define INTC_ICDISR14_TINT45_SHIFT              (13u)
#define INTC_ICDISR14_TINT46_SHIFT              (14u)
#define INTC_ICDISR14_TINT47_SHIFT              (15u)
#define INTC_ICDISR14_TINT48_SHIFT              (16u)
#define INTC_ICDISR14_TINT49_SHIFT              (17u)
#define INTC_ICDISR14_TINT50_SHIFT              (18u)
#define INTC_ICDISR14_TINT51_SHIFT              (19u)
#define INTC_ICDISR14_TINT52_SHIFT              (20u)
#define INTC_ICDISR14_TINT53_SHIFT              (21u)
#define INTC_ICDISR14_TINT54_SHIFT              (22u)
#define INTC_ICDISR14_TINT55_SHIFT              (23u)
#define INTC_ICDISR14_TINT56_SHIFT              (24u)
#define INTC_ICDISR14_TINT57_SHIFT              (25u)
#define INTC_ICDISR14_TINT58_SHIFT              (26u)
#define INTC_ICDISR14_TINT59_SHIFT              (27u)
#define INTC_ICDISR14_TINT60_SHIFT              (28u)
#define INTC_ICDISR14_TINT61_SHIFT              (29u)
#define INTC_ICDISR14_TINT62_SHIFT              (30u)
#define INTC_ICDISR14_TINT63_SHIFT              (31u)

#define INTC_ICDISR15_TINT64_SHIFT              (0u)
#define INTC_ICDISR15_TINT65_SHIFT              (1u)
#define INTC_ICDISR15_TINT66_SHIFT              (2u)
#define INTC_ICDISR15_TINT67_SHIFT              (3u)
#define INTC_ICDISR15_TINT68_SHIFT              (4u)
#define INTC_ICDISR15_TINT69_SHIFT              (5u)
#define INTC_ICDISR15_TINT70_SHIFT              (6u)
#define INTC_ICDISR15_TINT71_SHIFT              (7u)
#define INTC_ICDISR15_TINT72_SHIFT              (8u)
#define INTC_ICDISR15_TINT73_SHIFT              (9u)
#define INTC_ICDISR15_TINT74_SHIFT              (10u)
#define INTC_ICDISR15_TINT75_SHIFT              (11u)
#define INTC_ICDISR15_TINT76_SHIFT              (12u)
#define INTC_ICDISR15_TINT77_SHIFT              (13u)
#define INTC_ICDISR15_TINT78_SHIFT              (14u)
#define INTC_ICDISR15_TINT79_SHIFT              (15u)
#define INTC_ICDISR15_TINT80_SHIFT              (16u)
#define INTC_ICDISR15_TINT81_SHIFT              (17u)
#define INTC_ICDISR15_TINT82_SHIFT              (18u)
#define INTC_ICDISR15_TINT83_SHIFT              (19u)
#define INTC_ICDISR15_TINT84_SHIFT              (20u)
#define INTC_ICDISR15_TINT85_SHIFT              (21u)
#define INTC_ICDISR15_TINT86_SHIFT              (22u)
#define INTC_ICDISR15_TINT87_SHIFT              (23u)
#define INTC_ICDISR15_TINT88_SHIFT              (24u)
#define INTC_ICDISR15_TINT89_SHIFT              (25u)
#define INTC_ICDISR15_TINT90_SHIFT              (26u)
#define INTC_ICDISR15_TINT91_SHIFT              (27u)
#define INTC_ICDISR15_TINT92_SHIFT              (28u)
#define INTC_ICDISR15_TINT93_SHIFT              (29u)
#define INTC_ICDISR15_TINT94_SHIFT              (30u)
#define INTC_ICDISR15_TINT95_SHIFT              (31u)

#define INTC_ICDISR16_TINT96_SHIFT              (0u)
#define INTC_ICDISR16_TINT97_SHIFT              (1u)
#define INTC_ICDISR16_TINT98_SHIFT              (2u)
#define INTC_ICDISR16_TINT99_SHIFT              (3u)
#define INTC_ICDISR16_TINT100_SHIFT             (4u)
#define INTC_ICDISR16_TINT101_SHIFT             (5u)
#define INTC_ICDISR16_TINT102_SHIFT             (6u)
#define INTC_ICDISR16_TINT103_SHIFT             (7u)
#define INTC_ICDISR16_TINT104_SHIFT             (8u)
#define INTC_ICDISR16_TINT105_SHIFT             (9u)
#define INTC_ICDISR16_TINT106_SHIFT             (10u)
#define INTC_ICDISR16_TINT107_SHIFT             (11u)
#define INTC_ICDISR16_TINT108_SHIFT             (12u)
#define INTC_ICDISR16_TINT109_SHIFT             (13u)
#define INTC_ICDISR16_TINT110_SHIFT             (14u)
#define INTC_ICDISR16_TINT111_SHIFT             (15u)
#define INTC_ICDISR16_TINT112_SHIFT             (16u)
#define INTC_ICDISR16_TINT113_SHIFT             (17u)
#define INTC_ICDISR16_TINT114_SHIFT             (18u)
#define INTC_ICDISR16_TINT115_SHIFT             (19u)
#define INTC_ICDISR16_TINT116_SHIFT             (20u)
#define INTC_ICDISR16_TINT117_SHIFT             (21u)
#define INTC_ICDISR16_TINT118_SHIFT             (22u)
#define INTC_ICDISR16_TINT119_SHIFT             (23u)
#define INTC_ICDISR16_TINT120_SHIFT             (24u)
#define INTC_ICDISR16_TINT121_SHIFT             (25u)
#define INTC_ICDISR16_TINT122_SHIFT             (26u)
#define INTC_ICDISR16_TINT123_SHIFT             (27u)
#define INTC_ICDISR16_TINT124_SHIFT             (28u)
#define INTC_ICDISR16_TINT125_SHIFT             (29u)
#define INTC_ICDISR16_TINT126_SHIFT             (30u)
#define INTC_ICDISR16_TINT127_SHIFT             (31u)

#define INTC_ICDISR17_TINT128_SHIFT             (0u)
#define INTC_ICDISR17_TINT129_SHIFT             (1u)
#define INTC_ICDISR17_TINT130_SHIFT             (2u)
#define INTC_ICDISR17_TINT131_SHIFT             (3u)
#define INTC_ICDISR17_TINT132_SHIFT             (4u)
#define INTC_ICDISR17_TINT133_SHIFT             (5u)
#define INTC_ICDISR17_TINT134_SHIFT             (6u)
#define INTC_ICDISR17_TINT135_SHIFT             (7u)
#define INTC_ICDISR17_TINT136_SHIFT             (8u)
#define INTC_ICDISR17_TINT137_SHIFT             (9u)
#define INTC_ICDISR17_TINT138_SHIFT             (10u)
#define INTC_ICDISR17_TINT139_SHIFT             (11u)
#define INTC_ICDISR17_TINT140_SHIFT             (12u)
#define INTC_ICDISR17_TINT141_SHIFT             (13u)
#define INTC_ICDISR17_TINT142_SHIFT             (14u)
#define INTC_ICDISR17_TINT143_SHIFT             (15u)
#define INTC_ICDISR17_TINT144_SHIFT             (16u)
#define INTC_ICDISR17_TINT145_SHIFT             (17u)
#define INTC_ICDISR17_TINT146_SHIFT             (18u)
#define INTC_ICDISR17_TINT147_SHIFT             (19u)
#define INTC_ICDISR17_TINT148_SHIFT             (20u)
#define INTC_ICDISR17_TINT149_SHIFT             (21u)
#define INTC_ICDISR17_TINT150_SHIFT             (22u)
#define INTC_ICDISR17_TINT151_SHIFT             (23u)
#define INTC_ICDISR17_TINT152_SHIFT             (24u)
#define INTC_ICDISR17_TINT153_SHIFT             (25u)
#define INTC_ICDISR17_TINT154_SHIFT             (26u)
#define INTC_ICDISR17_TINT155_SHIFT             (27u)
#define INTC_ICDISR17_TINT156_SHIFT             (28u)
#define INTC_ICDISR17_TINT157_SHIFT             (29u)
#define INTC_ICDISR17_TINT158_SHIFT             (30u)
#define INTC_ICDISR17_TINT159_SHIFT             (31u)

#define INTC_ICDISR18_TINT160_SHIFT             (0u)
#define INTC_ICDISR18_TINT161_SHIFT             (1u)
#define INTC_ICDISR18_TINT162_SHIFT             (2u)
#define INTC_ICDISR18_TINT163_SHIFT             (3u)
#define INTC_ICDISR18_TINT164_SHIFT             (4u)
#define INTC_ICDISR18_TINT165_SHIFT             (5u)
#define INTC_ICDISR18_TINT166_SHIFT             (6u)
#define INTC_ICDISR18_TINT167_SHIFT             (7u)
#define INTC_ICDISR18_TINT168_SHIFT             (8u)
#define INTC_ICDISR18_TINT169_SHIFT             (9u)
#define INTC_ICDISR18_TINT170_SHIFT             (10u)

#define INTC_ICDISER0_SW0_SHIFT                 (0u)
#define INTC_ICDISER0_SW1_SHIFT                 (1u)
#define INTC_ICDISER0_SW2_SHIFT                 (2u)
#define INTC_ICDISER0_SW3_SHIFT                 (3u)
#define INTC_ICDISER0_SW4_SHIFT                 (4u)
#define INTC_ICDISER0_SW5_SHIFT                 (5u)
#define INTC_ICDISER0_SW6_SHIFT                 (6u)
#define INTC_ICDISER0_SW7_SHIFT                 (7u)
#define INTC_ICDISER0_SW8_SHIFT                 (8u)
#define INTC_ICDISER0_SW9_SHIFT                 (9u)
#define INTC_ICDISER0_SW10_SHIFT                (10u)
#define INTC_ICDISER0_SW11_SHIFT                (11u)
#define INTC_ICDISER0_SW12_SHIFT                (12u)
#define INTC_ICDISER0_SW13_SHIFT                (13u)
#define INTC_ICDISER0_SW14_SHIFT                (14u)
#define INTC_ICDISER0_SW15_SHIFT                (15u)
#define INTC_ICDISER0_PMUIRQ0_SHIFT             (16u)
#define INTC_ICDISER0_COMMRX0_SHIFT             (17u)
#define INTC_ICDISER0_COMMTX0_SHIFT             (18u)
#define INTC_ICDISER0_CTIIRQ0_SHIFT             (19u)

#define INTC_ICDISER1_IRQ0_SHIFT                (0u)
#define INTC_ICDISER1_IRQ1_SHIFT                (1u)
#define INTC_ICDISER1_IRQ2_SHIFT                (2u)
#define INTC_ICDISER1_IRQ3_SHIFT                (3u)
#define INTC_ICDISER1_IRQ4_SHIFT                (4u)
#define INTC_ICDISER1_IRQ5_SHIFT                (5u)
#define INTC_ICDISER1_IRQ6_SHIFT                (6u)
#define INTC_ICDISER1_IRQ7_SHIFT                (7u)
#define INTC_ICDISER1_PL310ERR_SHIFT            (8u)
#define INTC_ICDISER1_DMAINT0_SHIFT             (9u)
#define INTC_ICDISER1_DMAINT1_SHIFT             (10u)
#define INTC_ICDISER1_DMAINT2_SHIFT             (11u)
#define INTC_ICDISER1_DMAINT3_SHIFT             (12u)
#define INTC_ICDISER1_DMAINT4_SHIFT             (13u)
#define INTC_ICDISER1_DMAINT5_SHIFT             (14u)
#define INTC_ICDISER1_DMAINT6_SHIFT             (15u)
#define INTC_ICDISER1_DMAINT7_SHIFT             (16u)
#define INTC_ICDISER1_DMAINT8_SHIFT             (17u)
#define INTC_ICDISER1_DMAINT9_SHIFT             (18u)
#define INTC_ICDISER1_DMAINT10_SHIFT            (19u)
#define INTC_ICDISER1_DMAINT11_SHIFT            (20u)
#define INTC_ICDISER1_DMAINT12_SHIFT            (21u)
#define INTC_ICDISER1_DMAINT13_SHIFT            (22u)
#define INTC_ICDISER1_DMAINT14_SHIFT            (23u)
#define INTC_ICDISER1_DMAINT15_SHIFT            (24u)
#define INTC_ICDISER1_DMAERR_SHIFT              (25u)

#define INTC_ICDISER2_USBI0_SHIFT               (9u)
#define INTC_ICDISER2_USBI1_SHIFT               (10u)
#define INTC_ICDISER2_S0_VI_VSYNC0_SHIFT        (11u)
#define INTC_ICDISER2_S0_LO_VSYNC0_SHIFT        (12u)
#define INTC_ICDISER2_S0_VSYNCERR0_SHIFT        (13u)
#define INTC_ICDISER2_GR3_VLINE0_SHIFT          (14u)
#define INTC_ICDISER2_S0_VFIELD0_SHIFT          (15u)
#define INTC_ICDISER2_IV1_VBUFERR0_SHIFT        (16u)
#define INTC_ICDISER2_IV3_VBUFERR0_SHIFT        (17u)
#define INTC_ICDISER2_IV5_VBUFERR0_SHIFT        (18u)
#define INTC_ICDISER2_IV6_VBUFERR0_SHIFT        (19u)
#define INTC_ICDISER2_S0_WLINE0_SHIFT           (20u)
#define INTC_ICDISER2_S1_VI_VSYNC0_SHIFT        (21u)
#define INTC_ICDISER2_S1_LO_VSYNC0_SHIFT        (22u)
#define INTC_ICDISER2_S1_VSYNCERR0_SHIFT        (23u)
#define INTC_ICDISER2_S1_VFIELD0_SHIFT          (24u)
#define INTC_ICDISER2_IV2_VBUFERR0_SHIFT        (25u)
#define INTC_ICDISER2_IV4_VBUFERR0_SHIFT        (26u)
#define INTC_ICDISER2_S1_WLINE0_SHIFT           (27u)
#define INTC_ICDISER2_OIR_VI_VSYNC0_SHIFT       (28u)
#define INTC_ICDISER2_OIR_LO_VSYNC0_SHIFT       (29u)
#define INTC_ICDISER2_OIR_VSYNCERR0_SHIFT       (30u)
#define INTC_ICDISER2_OIR_VFIELD0_SHIFT         (31u)

#define INTC_ICDISER3_IV7_VBUFERR0_SHIFT        (0u)
#define INTC_ICDISER3_IV8_VBUFERR0_SHIFT        (1u)
#define INTC_ICDISER3_OIR_WLINE0_SHIFT          (2u)
#define INTC_ICDISER3_S0_VI_VSYNC1_SHIFT        (3u)
#define INTC_ICDISER3_S0_LO_VSYNC1_SHIFT        (4u)
#define INTC_ICDISER3_S0_VSYNCERR1_SHIFT        (5u)
#define INTC_ICDISER3_GR3_VLINE1_SHIFT          (6u)
#define INTC_ICDISER3_S0_VFIELD1_SHIFT          (7u)
#define INTC_ICDISER3_IV1_VBUFERR1_SHIFT        (8u)
#define INTC_ICDISER3_IV3_VBUFERR1_SHIFT        (9u)
#define INTC_ICDISER3_IV5_VBUFERR1_SHIFT        (10u)
#define INTC_ICDISER3_IV6_VBUFERR1_SHIFT        (11u)
#define INTC_ICDISER3_S0_WLINE1_SHIFT           (12u)
#define INTC_ICDISER3_S1_VI_VSYNC1_SHIFT        (13u)
#define INTC_ICDISER3_S1_LO_VSYNC1_SHIFT        (14u)
#define INTC_ICDISER3_S1_VSYNCERR1_SHIFT        (15u)
#define INTC_ICDISER3_S1_VFIELD1_SHIFT          (16u)
#define INTC_ICDISER3_IV2_VBUFERR1_SHIFT        (17u)
#define INTC_ICDISER3_IV4_VBUFERR1_SHIFT        (18u)
#define INTC_ICDISER3_S1_WLINE1_SHIFT           (19u)
#define INTC_ICDISER3_OIR_VI_VSYNC1_SHIFT       (20u)
#define INTC_ICDISER3_OIR_LO_VSYNC1_SHIFT       (21u)
#define INTC_ICDISER3_OIR_VLINE1_SHIFT          (22u)
#define INTC_ICDISER3_OIR_VFIELD1_SHIFT         (23u)
#define INTC_ICDISER3_IV7_VBUFERR1_SHIFT        (24u)
#define INTC_ICDISER3_IV8_VBUFERR1_SHIFT        (25u)
#define INTC_ICDISER3_OIR_WLINE1_SHIFT          (26u)
#define INTC_ICDISER3_IMRDI_SHIFT               (27u)
#define INTC_ICDISER3_IMR2I0_SHIFT              (28u)
#define INTC_ICDISER3_IMR2I1_SHIFT              (29u)
#define INTC_ICDISER3_JEDI_SHIFT                (30u)
#define INTC_ICDISER3_JDTI_SHIFT                (31u)

#define INTC_ICDISER4_CMP0_SHIFT                (0u)
#define INTC_ICDISER4_CMP1_SHIFT                (1u)
#define INTC_ICDISER4_INT0_SHIFT                (2u)
#define INTC_ICDISER4_INT1_SHIFT                (3u)
#define INTC_ICDISER4_INT2_SHIFT                (4u)
#define INTC_ICDISER4_INT3_SHIFT                (5u)
#define INTC_ICDISER4_OSTM0TINT_SHIFT           (6u)
#define INTC_ICDISER4_OSTM1TINT_SHIFT           (7u)
#define INTC_ICDISER4_CMI_SHIFT                 (8u)
#define INTC_ICDISER4_WTOUT_SHIFT               (9u)
#define INTC_ICDISER4_ITI_SHIFT                 (10u)
#define INTC_ICDISER4_TGI0A_SHIFT               (11u)
#define INTC_ICDISER4_TGI0B_SHIFT               (12u)
#define INTC_ICDISER4_TGI0C_SHIFT               (13u)
#define INTC_ICDISER4_TGI0D_SHIFT               (14u)
#define INTC_ICDISER4_TGI0V_SHIFT               (15u)
#define INTC_ICDISER4_TGI0E_SHIFT               (16u)
#define INTC_ICDISER4_TGI0F_SHIFT               (17u)
#define INTC_ICDISER4_TGI1A_SHIFT               (18u)
#define INTC_ICDISER4_TGI1B_SHIFT               (19u)
#define INTC_ICDISER4_TGI1V_SHIFT               (20u)
#define INTC_ICDISER4_TGI1U_SHIFT               (21u)
#define INTC_ICDISER4_TGI2A_SHIFT               (22u)
#define INTC_ICDISER4_TGI2B_SHIFT               (23u)
#define INTC_ICDISER4_TGI2V_SHIFT               (24u)
#define INTC_ICDISER4_TGI2U_SHIFT               (25u)
#define INTC_ICDISER4_TGI3A_SHIFT               (26u)
#define INTC_ICDISER4_TGI3B_SHIFT               (27u)
#define INTC_ICDISER4_TGI3C_SHIFT               (28u)
#define INTC_ICDISER4_TGI3D_SHIFT               (29u)
#define INTC_ICDISER4_TGI3V_SHIFT               (30u)
#define INTC_ICDISER4_TGI4A_SHIFT               (31u)

#define INTC_ICDISER5_TGI4B_SHIFT               (0u)
#define INTC_ICDISER5_TGI4C_SHIFT               (1u)
#define INTC_ICDISER5_TGI4D_SHIFT               (2u)
#define INTC_ICDISER5_TGI4V_SHIFT               (3u)
#define INTC_ICDISER5_CMI1_SHIFT                (4u)
#define INTC_ICDISER5_CMI2_SHIFT                (5u)
#define INTC_ICDISER5_SGDEI0_SHIFT              (6u)
#define INTC_ICDISER5_SGDEI1_SHIFT              (7u)
#define INTC_ICDISER5_SGDEI2_SHIFT              (8u)
#define INTC_ICDISER5_SGDEI3_SHIFT              (9u)
#define INTC_ICDISER5_ADI_SHIFT                 (10u)
#define INTC_ICDISER5_LMTI_SHIFT                (11u)
#define INTC_ICDISER5_SSII0_SHIFT               (12u)
#define INTC_ICDISER5_SSIRXI0_SHIFT             (13u)
#define INTC_ICDISER5_SSITXI0_SHIFT             (14u)
#define INTC_ICDISER5_SSII1_SHIFT               (15u)
#define INTC_ICDISER5_SSIRXI1_SHIFT             (16u)
#define INTC_ICDISER5_SSITXI1_SHIFT             (17u)
#define INTC_ICDISER5_SSII2_SHIFT               (18u)
#define INTC_ICDISER5_SSIRTI2_SHIFT             (19u)
#define INTC_ICDISER5_SSII3_SHIFT               (20u)
#define INTC_ICDISER5_SSIRXI3_SHIFT             (21u)
#define INTC_ICDISER5_SSITXI3_SHIFT             (22u)
#define INTC_ICDISER5_SSII4_SHIFT               (23u)
#define INTC_ICDISER5_SSIRTI4_SHIFT             (24u)
#define INTC_ICDISER5_SSII5_SHIFT               (25u)
#define INTC_ICDISER5_SSIRXI5_SHIFT             (26u)
#define INTC_ICDISER5_SSITXI5_SHIFT             (27u)
#define INTC_ICDISER5_SPDIFI_SHIFT              (28u)
#define INTC_ICDISER5_INTIICTEI0_SHIFT          (29u)
#define INTC_ICDISER5_INTIICRI0_SHIFT           (30u)
#define INTC_ICDISER5_INTIICTI0_SHIFT           (31u)

#define INTC_ICDISER6_INTIICSPI0_SHIFT          (0u)
#define INTC_ICDISER6_INTIICSTI0_SHIFT          (1u)
#define INTC_ICDISER6_INTIICNAKI0_SHIFT         (2u)
#define INTC_ICDISER6_INTIICALI0_SHIFT          (3u)
#define INTC_ICDISER6_INTIICTMOI0_SHIFT         (4u)
#define INTC_ICDISER6_INTIICTEI1_SHIFT          (5u)
#define INTC_ICDISER6_INTIICRI1_SHIFT           (6u)
#define INTC_ICDISER6_INTIICTI1_SHIFT           (7u)
#define INTC_ICDISER6_INTIICSPI1_SHIFT          (8u)
#define INTC_ICDISER6_INTIICSTI1_SHIFT          (9u)
#define INTC_ICDISER6_INTIICNAKI1_SHIFT         (10u)
#define INTC_ICDISER6_INTIICALI1_SHIFT          (11u)
#define INTC_ICDISER6_INTIICTMOI1_SHIFT         (12u)
#define INTC_ICDISER6_INTIICTEI2_SHIFT          (13u)
#define INTC_ICDISER6_INTIICRI2_SHIFT           (14u)
#define INTC_ICDISER6_INTIICTI2_SHIFT           (15u)
#define INTC_ICDISER6_INTIICSPI2_SHIFT          (16u)
#define INTC_ICDISER6_INTIICSTI2_SHIFT          (17u)
#define INTC_ICDISER6_INTIICNAKI2_SHIFT         (18u)
#define INTC_ICDISER6_INTIICALI2_SHIFT          (19u)
#define INTC_ICDISER6_INTIICTMOI2_SHIFT         (20u)
#define INTC_ICDISER6_INTIICTEI3_SHIFT          (21u)
#define INTC_ICDISER6_INTIICRI3_SHIFT           (22u)
#define INTC_ICDISER6_INTIICTI3_SHIFT           (23u)
#define INTC_ICDISER6_INTIICSPI3_SHIFT          (24u)
#define INTC_ICDISER6_INTIICSTI3_SHIFT          (25u)
#define INTC_ICDISER6_INTIICNAKI3_SHIFT         (26u)
#define INTC_ICDISER6_INTIICALI3_SHIFT          (27u)
#define INTC_ICDISER6_INTIICTMOI3_SHIFT         (28u)
#define INTC_ICDISER6_BRI0_SHIFT                (29u)
#define INTC_ICDISER6_ERI0_SHIFT                (30u)
#define INTC_ICDISER6_RXI0_SHIFT                (31u)

#define INTC_ICDISER7_TXI0_SHIFT                (0u)
#define INTC_ICDISER7_BRI1_SHIFT                (1u)
#define INTC_ICDISER7_ERI1_SHIFT                (2u)
#define INTC_ICDISER7_RXI1_SHIFT                (3u)
#define INTC_ICDISER7_TXI1_SHIFT                (4u)
#define INTC_ICDISER7_BRI2_SHIFT                (5u)
#define INTC_ICDISER7_ERI2_SHIFT                (6u)
#define INTC_ICDISER7_RXI2_SHIFT                (7u)
#define INTC_ICDISER7_TXI2_SHIFT                (8u)
#define INTC_ICDISER7_BRI3_SHIFT                (9u)
#define INTC_ICDISER7_ERI3_SHIFT                (10u)
#define INTC_ICDISER7_RXI3_SHIFT                (11u)
#define INTC_ICDISER7_TXI3_SHIFT                (12u)
#define INTC_ICDISER7_BRI4_SHIFT                (13u)
#define INTC_ICDISER7_ERI4_SHIFT                (14u)
#define INTC_ICDISER7_RXI4_SHIFT                (15u)
#define INTC_ICDISER7_TXI4_SHIFT                (16u)
#define INTC_ICDISER7_BRI5_SHIFT                (17u)
#define INTC_ICDISER7_ERI5_SHIFT                (18u)
#define INTC_ICDISER7_RXI5_SHIFT                (19u)
#define INTC_ICDISER7_TXI5_SHIFT                (20u)
#define INTC_ICDISER7_BRI6_SHIFT                (21u)
#define INTC_ICDISER7_ERI6_SHIFT                (22u)
#define INTC_ICDISER7_RXI6_SHIFT                (23u)
#define INTC_ICDISER7_TXI6_SHIFT                (24u)
#define INTC_ICDISER7_BRI7_SHIFT                (25u)
#define INTC_ICDISER7_ERI7_SHIFT                (26u)
#define INTC_ICDISER7_RXI7_SHIFT                (27u)
#define INTC_ICDISER7_TXI7_SHIFT                (28u)
#define INTC_ICDISER7_INTRCANGERR_SHIFT         (29u)
#define INTC_ICDISER7_INTRCANGRECC_SHIFT        (30u)
#define INTC_ICDISER7_INTRCAN0REC_SHIFT         (31u)

#define INTC_ICDISER8_INTRCAN0ERR_SHIFT         (0u)
#define INTC_ICDISER8_INTRCAN0TRX_SHIFT         (1u)
#define INTC_ICDISER8_INTRCAN1REC_SHIFT         (2u)
#define INTC_ICDISER8_INTRCAN1ERR_SHIFT         (3u)
#define INTC_ICDISER8_INTRCAN1TRX_SHIFT         (4u)
#define INTC_ICDISER8_INTRCAN2REC_SHIFT         (5u)
#define INTC_ICDISER8_INTRCAN2ERR_SHIFT         (6u)
#define INTC_ICDISER8_INTRCAN2TRX_SHIFT         (7u)
#define INTC_ICDISER8_INTRCAN3REC_SHIFT         (8u)
#define INTC_ICDISER8_INTRCAN3ERR_SHIFT         (9u)
#define INTC_ICDISER8_INTRCAN3TRX_SHIFT         (10u)
#define INTC_ICDISER8_INTRCAN4REC_SHIFT         (11u)
#define INTC_ICDISER8_INTRCAN4ERR_SHIFT         (12u)
#define INTC_ICDISER8_INTRCAN4TRX_SHIFT         (13u)
#define INTC_ICDISER8_SPEI0_SHIFT               (14u)
#define INTC_ICDISER8_SPRI0_SHIFT               (15u)
#define INTC_ICDISER8_SPTI0_SHIFT               (16u)
#define INTC_ICDISER8_SPEI1_SHIFT               (17u)
#define INTC_ICDISER8_SPRI1_SHIFT               (18u)
#define INTC_ICDISER8_SPTI1_SHIFT               (19u)
#define INTC_ICDISER8_SPEI2_SHIFT               (20u)
#define INTC_ICDISER8_SPRI2_SHIFT               (21u)
#define INTC_ICDISER8_SPTI2_SHIFT               (22u)
#define INTC_ICDISER8_SPEI3_SHIFT               (23u)
#define INTC_ICDISER8_SPRI3_SHIFT               (24u)
#define INTC_ICDISER8_SPTI3_SHIFT               (25u)
#define INTC_ICDISER8_SPEI4_SHIFT               (26u)
#define INTC_ICDISER8_SPRI4_SHIFT               (27u)
#define INTC_ICDISER8_SPTI4_SHIFT               (28u)
#define INTC_ICDISER8_IEBBTD_SHIFT              (29u)
#define INTC_ICDISER8_IEBBTERR_SHIFT            (30u)
#define INTC_ICDISER8_IEBBTSTA_SHIFT            (31u)

#define INTC_ICDISER9_IEBBTV_SHIFT              (0u)
#define INTC_ICDISER9_ISY_SHIFT                 (1u)
#define INTC_ICDISER9_IERR_SHIFT                (2u)
#define INTC_ICDISER9_ITARG_SHIFT               (3u)
#define INTC_ICDISER9_ISEC_SHIFT                (4u)
#define INTC_ICDISER9_IBUF_SHIFT                (5u)
#define INTC_ICDISER9_IREADY_SHIFT              (6u)
#define INTC_ICDISER9_FLSTE_SHIFT               (7u)
#define INTC_ICDISER9_FLTENDI_SHIFT             (8u)
#define INTC_ICDISER9_FLTREQ0I_SHIFT            (9u)
#define INTC_ICDISER9_FLTREQ1I_SHIFT            (10u)
#define INTC_ICDISER9_MMC0_SHIFT                (11u)
#define INTC_ICDISER9_MMC1_SHIFT                (12u)
#define INTC_ICDISER9_MMC2_SHIFT                (13u)
#define INTC_ICDISER9_SDHI0_3_SHIFT             (14u)
#define INTC_ICDISER9_SDHI0_0_SHIFT             (15u)
#define INTC_ICDISER9_SDHI0_1_SHIFT             (16u)
#define INTC_ICDISER9_SDHI1_3_SHIFT             (17u)
#define INTC_ICDISER9_SDHI1_0_SHIFT             (18u)
#define INTC_ICDISER9_SDHI1_1_SHIFT             (19u)
#define INTC_ICDISER9_ARM_SHIFT                 (20u)
#define INTC_ICDISER9_PRD_SHIFT                 (21u)
#define INTC_ICDISER9_CUP_SHIFT                 (22u)
#define INTC_ICDISER9_SCUAI0_SHIFT              (23u)
#define INTC_ICDISER9_SCUAI1_SHIFT              (24u)
#define INTC_ICDISER9_SCUFDI0_SHIFT             (25u)
#define INTC_ICDISER9_SCUFDI1_SHIFT             (26u)
#define INTC_ICDISER9_SCUFDI2_SHIFT             (27u)
#define INTC_ICDISER9_SCUFDI3_SHIFT             (28u)
#define INTC_ICDISER9_SCUFUI0_SHIFT             (29u)
#define INTC_ICDISER9_SCUFUI1_SHIFT             (30u)
#define INTC_ICDISER9_SCUFUI2_SHIFT             (31u)

#define INTC_ICDISER10_SCUFUI3_SHIFT            (0u)
#define INTC_ICDISER10_SCUDVI0_SHIFT            (1u)
#define INTC_ICDISER10_SCUDVI1_SHIFT            (2u)
#define INTC_ICDISER10_SCUDVI2_SHIFT            (3u)
#define INTC_ICDISER10_SCUDVI3_SHIFT            (4u)
#define INTC_ICDISER10_MLB_CINT_SHIFT           (5u)
#define INTC_ICDISER10_MLB_SINT_SHIFT           (6u)
#define INTC_ICDISER10_DRC0_SHIFT               (7u)
#define INTC_ICDISER10_DRC1_SHIFT               (8u)
#define INTC_ICDISER10_LINI0_INT_T_SHIFT        (11u)
#define INTC_ICDISER10_LINI0_INT_R_SHIFT        (12u)
#define INTC_ICDISER10_LINI0_INT_S_SHIFT        (13u)
#define INTC_ICDISER10_LINI0_INT_M_SHIFT        (14u)
#define INTC_ICDISER10_LINI1_INT_T_SHIFT        (15u)
#define INTC_ICDISER10_LINI1_INT_R_SHIFT        (16u)
#define INTC_ICDISER10_LINI1_INT_S_SHIFT        (17u)
#define INTC_ICDISER10_LINI1_INT_M_SHIFT        (18u)
#define INTC_ICDISER10_ERI0_SHIFT               (27u)
#define INTC_ICDISER10_RXI0_SHIFT               (28u)
#define INTC_ICDISER10_TXI0_SHIFT               (29u)
#define INTC_ICDISER10_TEI0_SHIFT               (30u)
#define INTC_ICDISER10_ERI1_SHIFT               (31u)

#define INTC_ICDISER11_RXI1_SHIFT               (0u)
#define INTC_ICDISER11_TXI1_SHIFT               (1u)
#define INTC_ICDISER11_TEI1_SHIFT               (2u)
#define INTC_ICDISER11_AVBI_DATA_SHIFT          (3u)
#define INTC_ICDISER11_AVBI_ERROR_SHIFT         (4u)
#define INTC_ICDISER11_AVBI_MANAGE_SHIFT        (5u)
#define INTC_ICDISER11_AVBI_MAC_SHIFT           (6u)
#define INTC_ICDISER11_ETHERI_SHIFT             (7u)
#define INTC_ICDISER11_CEUI_SHIFT               (12u)
#define INTC_ICDISER11_H2XMLB_ERRINT_SHIFT      (29u)
#define INTC_ICDISER11_H2XIC1_ERRINT_SHIFT      (30u)
#define INTC_ICDISER11_X2HPERI1_ERRINT_SHIFT    (31u)

#define INTC_ICDISER12_X2HPERI2_ERRINT_SHIFT    (0u)
#define INTC_ICDISER12_X2HPERI34_ERRINT_SHIFT   (1u)
#define INTC_ICDISER12_X2HPERI5_ERRINT_SHIFT    (2u)
#define INTC_ICDISER12_X2HPERI67_ERRINT_SHIFT   (3u)
#define INTC_ICDISER12_X2HDBGR_ERRINT_SHIFT     (4u)
#define INTC_ICDISER12_X2HBSC_ERRINT_SHIFT      (5u)
#define INTC_ICDISER12_X2HSPI1_ERRINT_SHIFT     (6u)
#define INTC_ICDISER12_X2HSPI2_ERRINT_SHIFT     (7u)
#define INTC_ICDISER12_PRRI_SHIFT               (8u)
#define INTC_ICDISER12_IFEI0_SHIFT              (9u)
#define INTC_ICDISER12_OFFI0_SHIFT              (10u)
#define INTC_ICDISER12_PFVEI0_SHIFT             (11u)
#define INTC_ICDISER12_IFEI1_SHIFT              (12u)
#define INTC_ICDISER12_OFFI1_SHIFT              (13u)
#define INTC_ICDISER12_PFVEI1_SHIFT             (14u)

#define INTC_ICDISER13_TINT0_SHIFT              (0u)
#define INTC_ICDISER13_TINT1_SHIFT              (1u)
#define INTC_ICDISER13_TINT2_SHIFT              (2u)
#define INTC_ICDISER13_TINT3_SHIFT              (3u)
#define INTC_ICDISER13_TINT4_SHIFT              (4u)
#define INTC_ICDISER13_TINT5_SHIFT              (5u)
#define INTC_ICDISER13_TINT6_SHIFT              (6u)
#define INTC_ICDISER13_TINT7_SHIFT              (7u)
#define INTC_ICDISER13_TINT8_SHIFT              (8u)
#define INTC_ICDISER13_TINT9_SHIFT              (9u)
#define INTC_ICDISER13_TINT10_SHIFT             (10u)
#define INTC_ICDISER13_TINT11_SHIFT             (11u)
#define INTC_ICDISER13_TINT12_SHIFT             (12u)
#define INTC_ICDISER13_TINT13_SHIFT             (13u)
#define INTC_ICDISER13_TINT14_SHIFT             (14u)
#define INTC_ICDISER13_TINT15_SHIFT             (15u)
#define INTC_ICDISER13_TINT16_SHIFT             (16u)
#define INTC_ICDISER13_TINT17_SHIFT             (17u)
#define INTC_ICDISER13_TINT18_SHIFT             (18u)
#define INTC_ICDISER13_TINT19_SHIFT             (19u)
#define INTC_ICDISER13_TINT20_SHIFT             (20u)
#define INTC_ICDISER13_TINT21_SHIFT             (21u)
#define INTC_ICDISER13_TINT22_SHIFT             (22u)
#define INTC_ICDISER13_TINT23_SHIFT             (23u)
#define INTC_ICDISER13_TINT24_SHIFT             (24u)
#define INTC_ICDISER13_TINT25_SHIFT             (25u)
#define INTC_ICDISER13_TINT26_SHIFT             (26u)
#define INTC_ICDISER13_TINT27_SHIFT             (27u)
#define INTC_ICDISER13_TINT28_SHIFT             (28u)
#define INTC_ICDISER13_TINT29_SHIFT             (29u)
#define INTC_ICDISER13_TINT30_SHIFT             (30u)
#define INTC_ICDISER13_TINT31_SHIFT             (31u)

#define INTC_ICDISER14_TINT32_SHIFT             (0u)
#define INTC_ICDISER14_TINT33_SHIFT             (1u)
#define INTC_ICDISER14_TINT34_SHIFT             (2u)
#define INTC_ICDISER14_TINT35_SHIFT             (3u)
#define INTC_ICDISER14_TINT36_SHIFT             (4u)
#define INTC_ICDISER14_TINT37_SHIFT             (5u)
#define INTC_ICDISER14_TINT38_SHIFT             (6u)
#define INTC_ICDISER14_TINT39_SHIFT             (7u)
#define INTC_ICDISER14_TINT40_SHIFT             (8u)
#define INTC_ICDISER14_TINT41_SHIFT             (9u)
#define INTC_ICDISER14_TINT42_SHIFT             (10u)
#define INTC_ICDISER14_TINT43_SHIFT             (11u)
#define INTC_ICDISER14_TINT44_SHIFT             (12u)
#define INTC_ICDISER14_TINT45_SHIFT             (13u)
#define INTC_ICDISER14_TINT46_SHIFT             (14u)
#define INTC_ICDISER14_TINT47_SHIFT             (15u)
#define INTC_ICDISER14_TINT48_SHIFT             (16u)
#define INTC_ICDISER14_TINT49_SHIFT             (17u)
#define INTC_ICDISER14_TINT50_SHIFT             (18u)
#define INTC_ICDISER14_TINT51_SHIFT             (19u)
#define INTC_ICDISER14_TINT52_SHIFT             (20u)
#define INTC_ICDISER14_TINT53_SHIFT             (21u)
#define INTC_ICDISER14_TINT54_SHIFT             (22u)
#define INTC_ICDISER14_TINT55_SHIFT             (23u)
#define INTC_ICDISER14_TINT56_SHIFT             (24u)
#define INTC_ICDISER14_TINT57_SHIFT             (25u)
#define INTC_ICDISER14_TINT58_SHIFT             (26u)
#define INTC_ICDISER14_TINT59_SHIFT             (27u)
#define INTC_ICDISER14_TINT60_SHIFT             (28u)
#define INTC_ICDISER14_TINT61_SHIFT             (29u)
#define INTC_ICDISER14_TINT62_SHIFT             (30u)
#define INTC_ICDISER14_TINT63_SHIFT             (31u)

#define INTC_ICDISER15_TINT64_SHIFT             (0u)
#define INTC_ICDISER15_TINT65_SHIFT             (1u)
#define INTC_ICDISER15_TINT66_SHIFT             (2u)
#define INTC_ICDISER15_TINT67_SHIFT             (3u)
#define INTC_ICDISER15_TINT68_SHIFT             (4u)
#define INTC_ICDISER15_TINT69_SHIFT             (5u)
#define INTC_ICDISER15_TINT70_SHIFT             (6u)
#define INTC_ICDISER15_TINT71_SHIFT             (7u)
#define INTC_ICDISER15_TINT72_SHIFT             (8u)
#define INTC_ICDISER15_TINT73_SHIFT             (9u)
#define INTC_ICDISER15_TINT74_SHIFT             (10u)
#define INTC_ICDISER15_TINT75_SHIFT             (11u)
#define INTC_ICDISER15_TINT76_SHIFT             (12u)
#define INTC_ICDISER15_TINT77_SHIFT             (13u)
#define INTC_ICDISER15_TINT78_SHIFT             (14u)
#define INTC_ICDISER15_TINT79_SHIFT             (15u)
#define INTC_ICDISER15_TINT80_SHIFT             (16u)
#define INTC_ICDISER15_TINT81_SHIFT             (17u)
#define INTC_ICDISER15_TINT82_SHIFT             (18u)
#define INTC_ICDISER15_TINT83_SHIFT             (19u)
#define INTC_ICDISER15_TINT84_SHIFT             (20u)
#define INTC_ICDISER15_TINT85_SHIFT             (21u)
#define INTC_ICDISER15_TINT86_SHIFT             (22u)
#define INTC_ICDISER15_TINT87_SHIFT             (23u)
#define INTC_ICDISER15_TINT88_SHIFT             (24u)
#define INTC_ICDISER15_TINT89_SHIFT             (25u)
#define INTC_ICDISER15_TINT90_SHIFT             (26u)
#define INTC_ICDISER15_TINT91_SHIFT             (27u)
#define INTC_ICDISER15_TINT92_SHIFT             (28u)
#define INTC_ICDISER15_TINT93_SHIFT             (29u)
#define INTC_ICDISER15_TINT94_SHIFT             (30u)
#define INTC_ICDISER15_TINT95_SHIFT             (31u)

#define INTC_ICDISER16_TINT96_SHIFT             (0u)
#define INTC_ICDISER16_TINT97_SHIFT             (1u)
#define INTC_ICDISER16_TINT98_SHIFT             (2u)
#define INTC_ICDISER16_TINT99_SHIFT             (3u)
#define INTC_ICDISER16_TINT100_SHIFT            (4u)
#define INTC_ICDISER16_TINT101_SHIFT            (5u)
#define INTC_ICDISER16_TINT102_SHIFT            (6u)
#define INTC_ICDISER16_TINT103_SHIFT            (7u)
#define INTC_ICDISER16_TINT104_SHIFT            (8u)
#define INTC_ICDISER16_TINT105_SHIFT            (9u)
#define INTC_ICDISER16_TINT106_SHIFT            (10u)
#define INTC_ICDISER16_TINT107_SHIFT            (11u)
#define INTC_ICDISER16_TINT108_SHIFT            (12u)
#define INTC_ICDISER16_TINT109_SHIFT            (13u)
#define INTC_ICDISER16_TINT110_SHIFT            (14u)
#define INTC_ICDISER16_TINT111_SHIFT            (15u)
#define INTC_ICDISER16_TINT112_SHIFT            (16u)
#define INTC_ICDISER16_TINT113_SHIFT            (17u)
#define INTC_ICDISER16_TINT114_SHIFT            (18u)
#define INTC_ICDISER16_TINT115_SHIFT            (19u)
#define INTC_ICDISER16_TINT116_SHIFT            (20u)
#define INTC_ICDISER16_TINT117_SHIFT            (21u)
#define INTC_ICDISER16_TINT118_SHIFT            (22u)
#define INTC_ICDISER16_TINT119_SHIFT            (23u)
#define INTC_ICDISER16_TINT120_SHIFT            (24u)
#define INTC_ICDISER16_TINT121_SHIFT            (25u)
#define INTC_ICDISER16_TINT122_SHIFT            (26u)
#define INTC_ICDISER16_TINT123_SHIFT            (27u)
#define INTC_ICDISER16_TINT124_SHIFT            (28u)
#define INTC_ICDISER16_TINT125_SHIFT            (29u)
#define INTC_ICDISER16_TINT126_SHIFT            (30u)
#define INTC_ICDISER16_TINT127_SHIFT            (31u)

#define INTC_ICDISER17_TINT128_SHIFT            (0u)
#define INTC_ICDISER17_TINT129_SHIFT            (1u)
#define INTC_ICDISER17_TINT130_SHIFT            (2u)
#define INTC_ICDISER17_TINT131_SHIFT            (3u)
#define INTC_ICDISER17_TINT132_SHIFT            (4u)
#define INTC_ICDISER17_TINT133_SHIFT            (5u)
#define INTC_ICDISER17_TINT134_SHIFT            (6u)
#define INTC_ICDISER17_TINT135_SHIFT            (7u)
#define INTC_ICDISER17_TINT136_SHIFT            (8u)
#define INTC_ICDISER17_TINT137_SHIFT            (9u)
#define INTC_ICDISER17_TINT138_SHIFT            (10u)
#define INTC_ICDISER17_TINT139_SHIFT            (11u)
#define INTC_ICDISER17_TINT140_SHIFT            (12u)
#define INTC_ICDISER17_TINT141_SHIFT            (13u)
#define INTC_ICDISER17_TINT142_SHIFT            (14u)
#define INTC_ICDISER17_TINT143_SHIFT            (15u)
#define INTC_ICDISER17_TINT144_SHIFT            (16u)
#define INTC_ICDISER17_TINT145_SHIFT            (17u)
#define INTC_ICDISER17_TINT146_SHIFT            (18u)
#define INTC_ICDISER17_TINT147_SHIFT            (19u)
#define INTC_ICDISER17_TINT148_SHIFT            (20u)
#define INTC_ICDISER17_TINT149_SHIFT            (21u)
#define INTC_ICDISER17_TINT150_SHIFT            (22u)
#define INTC_ICDISER17_TINT151_SHIFT            (23u)
#define INTC_ICDISER17_TINT152_SHIFT            (24u)
#define INTC_ICDISER17_TINT153_SHIFT            (25u)
#define INTC_ICDISER17_TINT154_SHIFT            (26u)
#define INTC_ICDISER17_TINT155_SHIFT            (27u)
#define INTC_ICDISER17_TINT156_SHIFT            (28u)
#define INTC_ICDISER17_TINT157_SHIFT            (29u)
#define INTC_ICDISER17_TINT158_SHIFT            (30u)
#define INTC_ICDISER17_TINT159_SHIFT            (31u)

#define INTC_ICDISER18_TINT160_SHIFT            (0u)
#define INTC_ICDISER18_TINT161_SHIFT            (1u)
#define INTC_ICDISER18_TINT162_SHIFT            (2u)
#define INTC_ICDISER18_TINT163_SHIFT            (3u)
#define INTC_ICDISER18_TINT164_SHIFT            (4u)
#define INTC_ICDISER18_TINT165_SHIFT            (5u)
#define INTC_ICDISER18_TINT166_SHIFT            (6u)
#define INTC_ICDISER18_TINT167_SHIFT            (7u)
#define INTC_ICDISER18_TINT168_SHIFT            (8u)
#define INTC_ICDISER18_TINT169_SHIFT            (9u)
#define INTC_ICDISER18_TINT170_SHIFT            (10u)

#define INTC_ICDICER0_SW0_SHIFT                 (0u)
#define INTC_ICDICER0_SW1_SHIFT                 (1u)
#define INTC_ICDICER0_SW2_SHIFT                 (2u)
#define INTC_ICDICER0_SW3_SHIFT                 (3u)
#define INTC_ICDICER0_SW4_SHIFT                 (4u)
#define INTC_ICDICER0_SW5_SHIFT                 (5u)
#define INTC_ICDICER0_SW6_SHIFT                 (6u)
#define INTC_ICDICER0_SW7_SHIFT                 (7u)
#define INTC_ICDICER0_SW8_SHIFT                 (8u)
#define INTC_ICDICER0_SW9_SHIFT                 (9u)
#define INTC_ICDICER0_SW10_SHIFT                (10u)
#define INTC_ICDICER0_SW11_SHIFT                (11u)
#define INTC_ICDICER0_SW12_SHIFT                (12u)
#define INTC_ICDICER0_SW13_SHIFT                (13u)
#define INTC_ICDICER0_SW14_SHIFT                (14u)
#define INTC_ICDICER0_SW15_SHIFT                (15u)
#define INTC_ICDICER0_PMUIRQ0_SHIFT             (16u)
#define INTC_ICDICER0_COMMRX0_SHIFT             (17u)
#define INTC_ICDICER0_COMMTX0_SHIFT             (18u)
#define INTC_ICDICER0_CTIIRQ0_SHIFT             (19u)

#define INTC_ICDICER1_IRQ0_SHIFT                (0u)
#define INTC_ICDICER1_IRQ1_SHIFT                (1u)
#define INTC_ICDICER1_IRQ2_SHIFT                (2u)
#define INTC_ICDICER1_IRQ3_SHIFT                (3u)
#define INTC_ICDICER1_IRQ4_SHIFT                (4u)
#define INTC_ICDICER1_IRQ5_SHIFT                (5u)
#define INTC_ICDICER1_IRQ6_SHIFT                (6u)
#define INTC_ICDICER1_IRQ7_SHIFT                (7u)
#define INTC_ICDICER1_PL310ERR_SHIFT            (8u)
#define INTC_ICDICER1_DMAINT0_SHIFT             (9u)
#define INTC_ICDICER1_DMAINT1_SHIFT             (10u)
#define INTC_ICDICER1_DMAINT2_SHIFT             (11u)
#define INTC_ICDICER1_DMAINT3_SHIFT             (12u)
#define INTC_ICDICER1_DMAINT4_SHIFT             (13u)
#define INTC_ICDICER1_DMAINT5_SHIFT             (14u)
#define INTC_ICDICER1_DMAINT6_SHIFT             (15u)
#define INTC_ICDICER1_DMAINT7_SHIFT             (16u)
#define INTC_ICDICER1_DMAINT8_SHIFT             (17u)
#define INTC_ICDICER1_DMAINT9_SHIFT             (18u)
#define INTC_ICDICER1_DMAINT10_SHIFT            (19u)
#define INTC_ICDICER1_DMAINT11_SHIFT            (20u)
#define INTC_ICDICER1_DMAINT12_SHIFT            (21u)
#define INTC_ICDICER1_DMAINT13_SHIFT            (22u)
#define INTC_ICDICER1_DMAINT14_SHIFT            (23u)
#define INTC_ICDICER1_DMAINT15_SHIFT            (24u)
#define INTC_ICDICER1_DMAERR_SHIFT              (25u)

#define INTC_ICDICER2_USBI0_SHIFT               (9u)
#define INTC_ICDICER2_USBI1_SHIFT               (10u)
#define INTC_ICDICER2_S0_VI_VSYNC0_SHIFT        (11u)
#define INTC_ICDICER2_S0_LO_VSYNC0_SHIFT        (12u)
#define INTC_ICDICER2_S0_VSYNCERR0_SHIFT        (13u)
#define INTC_ICDICER2_GR3_VLINE0_SHIFT          (14u)
#define INTC_ICDICER2_S0_VFIELD0_SHIFT          (15u)
#define INTC_ICDICER2_IV1_VBUFERR0_SHIFT        (16u)
#define INTC_ICDICER2_IV3_VBUFERR0_SHIFT        (17u)
#define INTC_ICDICER2_IV5_VBUFERR0_SHIFT        (18u)
#define INTC_ICDICER2_IV6_VBUFERR0_SHIFT        (19u)
#define INTC_ICDICER2_S0_WLINE0_SHIFT           (20u)
#define INTC_ICDICER2_S1_VI_VSYNC0_SHIFT        (21u)
#define INTC_ICDICER2_S1_LO_VSYNC0_SHIFT        (22u)
#define INTC_ICDICER2_S1_VSYNCERR0_SHIFT        (23u)
#define INTC_ICDICER2_S1_VFIELD0_SHIFT          (24u)
#define INTC_ICDICER2_IV2_VBUFERR0_SHIFT        (25u)
#define INTC_ICDICER2_IV4_VBUFERR0_SHIFT        (26u)
#define INTC_ICDICER2_S1_WLINE0_SHIFT           (27u)
#define INTC_ICDICER2_OIR_VI_VSYNC0_SHIFT       (28u)
#define INTC_ICDICER2_OIR_LO_VSYNC0_SHIFT       (29u)
#define INTC_ICDICER2_OIR_VSYNCERR0_SHIFT       (30u)
#define INTC_ICDICER2_OIR_VFIELD0_SHIFT         (31u)

#define INTC_ICDICER3_IV7_VBUFERR0_SHIFT        (0u)
#define INTC_ICDICER3_IV8_VBUFERR0_SHIFT        (1u)
#define INTC_ICDICER3_OIR_WLINE0_SHIFT          (2u)
#define INTC_ICDICER3_S0_VI_VSYNC1_SHIFT        (3u)
#define INTC_ICDICER3_S0_LO_VSYNC1_SHIFT        (4u)
#define INTC_ICDICER3_S0_VSYNCERR1_SHIFT        (5u)
#define INTC_ICDICER3_GR3_VLINE1_SHIFT          (6u)
#define INTC_ICDICER3_S0_VFIELD1_SHIFT          (7u)
#define INTC_ICDICER3_IV1_VBUFERR1_SHIFT        (8u)
#define INTC_ICDICER3_IV3_VBUFERR1_SHIFT        (9u)
#define INTC_ICDICER3_IV5_VBUFERR1_SHIFT        (10u)
#define INTC_ICDICER3_IV6_VBUFERR1_SHIFT        (11u)
#define INTC_ICDICER3_S0_WLINE1_SHIFT           (12u)
#define INTC_ICDICER3_S1_VI_VSYNC1_SHIFT        (13u)
#define INTC_ICDICER3_S1_LO_VSYNC1_SHIFT        (14u)
#define INTC_ICDICER3_S1_VSYNCERR1_SHIFT        (15u)
#define INTC_ICDICER3_S1_VFIELD1_SHIFT          (16u)
#define INTC_ICDICER3_IV2_VBUFERR1_SHIFT        (17u)
#define INTC_ICDICER3_IV4_VBUFERR1_SHIFT        (18u)
#define INTC_ICDICER3_S1_WLINE1_SHIFT           (19u)
#define INTC_ICDICER3_OIR_VI_VSYNC1_SHIFT       (20u)
#define INTC_ICDICER3_OIR_LO_VSYNC1_SHIFT       (21u)
#define INTC_ICDICER3_OIR_VLINE1_SHIFT          (22u)
#define INTC_ICDICER3_OIR_VFIELD1_SHIFT         (23u)
#define INTC_ICDICER3_IV7_VBUFERR1_SHIFT        (24u)
#define INTC_ICDICER3_IV8_VBUFERR1_SHIFT        (25u)
#define INTC_ICDICER3_OIR_WLINE1_SHIFT          (26u)
#define INTC_ICDICER3_IMRDI_SHIFT               (27u)
#define INTC_ICDICER3_IMR2I0_SHIFT              (28u)
#define INTC_ICDICER3_IMR2I1_SHIFT              (29u)
#define INTC_ICDICER3_JEDI_SHIFT                (30u)
#define INTC_ICDICER3_JDTI_SHIFT                (31u)

#define INTC_ICDICER4_CMP0_SHIFT                (0u)
#define INTC_ICDICER4_CMP1_SHIFT                (1u)
#define INTC_ICDICER4_INT0_SHIFT                (2u)
#define INTC_ICDICER4_INT1_SHIFT                (3u)
#define INTC_ICDICER4_INT2_SHIFT                (4u)
#define INTC_ICDICER4_INT3_SHIFT                (5u)
#define INTC_ICDICER4_OSTM0TINT_SHIFT           (6u)
#define INTC_ICDICER4_OSTM1TINT_SHIFT           (7u)
#define INTC_ICDICER4_CMI_SHIFT                 (8u)
#define INTC_ICDICER4_WTOUT_SHIFT               (9u)
#define INTC_ICDICER4_ITI_SHIFT                 (10u)
#define INTC_ICDICER4_TGI0A_SHIFT               (11u)
#define INTC_ICDICER4_TGI0B_SHIFT               (12u)
#define INTC_ICDICER4_TGI0C_SHIFT               (13u)
#define INTC_ICDICER4_TGI0D_SHIFT               (14u)
#define INTC_ICDICER4_TGI0V_SHIFT               (15u)
#define INTC_ICDICER4_TGI0E_SHIFT               (16u)
#define INTC_ICDICER4_TGI0F_SHIFT               (17u)
#define INTC_ICDICER4_TGI1A_SHIFT               (18u)
#define INTC_ICDICER4_TGI1B_SHIFT               (19u)
#define INTC_ICDICER4_TGI1V_SHIFT               (20u)
#define INTC_ICDICER4_TGI1U_SHIFT               (21u)
#define INTC_ICDICER4_TGI2A_SHIFT               (22u)
#define INTC_ICDICER4_TGI2B_SHIFT               (23u)
#define INTC_ICDICER4_TGI2V_SHIFT               (24u)
#define INTC_ICDICER4_TGI2U_SHIFT               (25u)
#define INTC_ICDICER4_TGI3A_SHIFT               (26u)
#define INTC_ICDICER4_TGI3B_SHIFT               (27u)
#define INTC_ICDICER4_TGI3C_SHIFT               (28u)
#define INTC_ICDICER4_TGI3D_SHIFT               (29u)
#define INTC_ICDICER4_TGI3V_SHIFT               (30u)
#define INTC_ICDICER4_TGI4A_SHIFT               (31u)

#define INTC_ICDICER5_TGI4B_SHIFT               (0u)
#define INTC_ICDICER5_TGI4C_SHIFT               (1u)
#define INTC_ICDICER5_TGI4D_SHIFT               (2u)
#define INTC_ICDICER5_TGI4V_SHIFT               (3u)
#define INTC_ICDICER5_CMI1_SHIFT                (4u)
#define INTC_ICDICER5_CMI2_SHIFT                (5u)
#define INTC_ICDICER5_SGDEI0_SHIFT              (6u)
#define INTC_ICDICER5_SGDEI1_SHIFT              (7u)
#define INTC_ICDICER5_SGDEI2_SHIFT              (8u)
#define INTC_ICDICER5_SGDEI3_SHIFT              (9u)
#define INTC_ICDICER5_ADI_SHIFT                 (10u)
#define INTC_ICDICER5_LMTI_SHIFT                (11u)
#define INTC_ICDICER5_SSII0_SHIFT               (12u)
#define INTC_ICDICER5_SSIRXI0_SHIFT             (13u)
#define INTC_ICDICER5_SSITXI0_SHIFT             (14u)
#define INTC_ICDICER5_SSII1_SHIFT               (15u)
#define INTC_ICDICER5_SSIRXI1_SHIFT             (16u)
#define INTC_ICDICER5_SSITXI1_SHIFT             (17u)
#define INTC_ICDICER5_SSII2_SHIFT               (18u)
#define INTC_ICDICER5_SSIRTI2_SHIFT             (19u)
#define INTC_ICDICER5_SSII3_SHIFT               (20u)
#define INTC_ICDICER5_SSIRXI3_SHIFT             (21u)
#define INTC_ICDICER5_SSITXI3_SHIFT             (22u)
#define INTC_ICDICER5_SSII4_SHIFT               (23u)
#define INTC_ICDICER5_SSIRTI4_SHIFT             (24u)
#define INTC_ICDICER5_SSII5_SHIFT               (25u)
#define INTC_ICDICER5_SSIRXI5_SHIFT             (26u)
#define INTC_ICDICER5_SSITXI5_SHIFT             (27u)
#define INTC_ICDICER5_SPDIFI_SHIFT              (28u)
#define INTC_ICDICER5_INTIICTEI0_SHIFT          (29u)
#define INTC_ICDICER5_INTIICRI0_SHIFT           (30u)
#define INTC_ICDICER5_INTIICTI0_SHIFT           (31u)

#define INTC_ICDICER6_INTIICSPI0_SHIFT          (0u)
#define INTC_ICDICER6_INTIICSTI0_SHIFT          (1u)
#define INTC_ICDICER6_INTIICNAKI0_SHIFT         (2u)
#define INTC_ICDICER6_INTIICALI0_SHIFT          (3u)
#define INTC_ICDICER6_INTIICTMOI0_SHIFT         (4u)
#define INTC_ICDICER6_INTIICTEI1_SHIFT          (5u)
#define INTC_ICDICER6_INTIICRI1_SHIFT           (6u)
#define INTC_ICDICER6_INTIICTI1_SHIFT           (7u)
#define INTC_ICDICER6_INTIICSPI1_SHIFT          (8u)
#define INTC_ICDICER6_INTIICSTI1_SHIFT          (9u)
#define INTC_ICDICER6_INTIICNAKI1_SHIFT         (10u)
#define INTC_ICDICER6_INTIICALI1_SHIFT          (11u)
#define INTC_ICDICER6_INTIICTMOI1_SHIFT         (12u)
#define INTC_ICDICER6_INTIICTEI2_SHIFT          (13u)
#define INTC_ICDICER6_INTIICRI2_SHIFT           (14u)
#define INTC_ICDICER6_INTIICTI2_SHIFT           (15u)
#define INTC_ICDICER6_INTIICSPI2_SHIFT          (16u)
#define INTC_ICDICER6_INTIICSTI2_SHIFT          (17u)
#define INTC_ICDICER6_INTIICNAKI2_SHIFT         (18u)
#define INTC_ICDICER6_INTIICALI2_SHIFT          (19u)
#define INTC_ICDICER6_INTIICTMOI2_SHIFT         (20u)
#define INTC_ICDICER6_INTIICTEI3_SHIFT          (21u)
#define INTC_ICDICER6_INTIICRI3_SHIFT           (22u)
#define INTC_ICDICER6_INTIICTI3_SHIFT           (23u)
#define INTC_ICDICER6_INTIICSPI3_SHIFT          (24u)
#define INTC_ICDICER6_INTIICSTI3_SHIFT          (25u)
#define INTC_ICDICER6_INTIICNAKI3_SHIFT         (26u)
#define INTC_ICDICER6_INTIICALI3_SHIFT          (27u)
#define INTC_ICDICER6_INTIICTMOI3_SHIFT         (28u)
#define INTC_ICDICER6_BRI0_SHIFT                (29u)
#define INTC_ICDICER6_ERI0_SHIFT                (30u)
#define INTC_ICDICER6_RXI0_SHIFT                (31u)

#define INTC_ICDICER7_TXI0_SHIFT                (0u)
#define INTC_ICDICER7_BRI1_SHIFT                (1u)
#define INTC_ICDICER7_ERI1_SHIFT                (2u)
#define INTC_ICDICER7_RXI1_SHIFT                (3u)
#define INTC_ICDICER7_TXI1_SHIFT                (4u)
#define INTC_ICDICER7_BRI2_SHIFT                (5u)
#define INTC_ICDICER7_ERI2_SHIFT                (6u)
#define INTC_ICDICER7_RXI2_SHIFT                (7u)
#define INTC_ICDICER7_TXI2_SHIFT                (8u)
#define INTC_ICDICER7_BRI3_SHIFT                (9u)
#define INTC_ICDICER7_ERI3_SHIFT                (10u)
#define INTC_ICDICER7_RXI3_SHIFT                (11u)
#define INTC_ICDICER7_TXI3_SHIFT                (12u)
#define INTC_ICDICER7_BRI4_SHIFT                (13u)
#define INTC_ICDICER7_ERI4_SHIFT                (14u)
#define INTC_ICDICER7_RXI4_SHIFT                (15u)
#define INTC_ICDICER7_TXI4_SHIFT                (16u)
#define INTC_ICDICER7_BRI5_SHIFT                (17u)
#define INTC_ICDICER7_ERI5_SHIFT                (18u)
#define INTC_ICDICER7_RXI5_SHIFT                (19u)
#define INTC_ICDICER7_TXI5_SHIFT                (20u)
#define INTC_ICDICER7_BRI6_SHIFT                (21u)
#define INTC_ICDICER7_ERI6_SHIFT                (22u)
#define INTC_ICDICER7_RXI6_SHIFT                (23u)
#define INTC_ICDICER7_TXI6_SHIFT                (24u)
#define INTC_ICDICER7_BRI7_SHIFT                (25u)
#define INTC_ICDICER7_ERI7_SHIFT                (26u)
#define INTC_ICDICER7_RXI7_SHIFT                (27u)
#define INTC_ICDICER7_TXI7_SHIFT                (28u)
#define INTC_ICDICER7_INTRCANGERR_SHIFT         (29u)
#define INTC_ICDICER7_INTRCANGRECC_SHIFT        (30u)
#define INTC_ICDICER7_INTRCAN0REC_SHIFT         (31u)

#define INTC_ICDICER8_INTRCAN0ERR_SHIFT         (0u)
#define INTC_ICDICER8_INTRCAN0TRX_SHIFT         (1u)
#define INTC_ICDICER8_INTRCAN1REC_SHIFT         (2u)
#define INTC_ICDICER8_INTRCAN1ERR_SHIFT         (3u)
#define INTC_ICDICER8_INTRCAN1TRX_SHIFT         (4u)
#define INTC_ICDICER8_INTRCAN2REC_SHIFT         (5u)
#define INTC_ICDICER8_INTRCAN2ERR_SHIFT         (6u)
#define INTC_ICDICER8_INTRCAN2TRX_SHIFT         (7u)
#define INTC_ICDICER8_INTRCAN3REC_SHIFT         (8u)
#define INTC_ICDICER8_INTRCAN3ERR_SHIFT         (9u)
#define INTC_ICDICER8_INTRCAN3TRX_SHIFT         (10u)
#define INTC_ICDICER8_INTRCAN4REC_SHIFT         (11u)
#define INTC_ICDICER8_INTRCAN4ERR_SHIFT         (12u)
#define INTC_ICDICER8_INTRCAN4TRX_SHIFT         (13u)
#define INTC_ICDICER8_SPEI0_SHIFT               (14u)
#define INTC_ICDICER8_SPRI0_SHIFT               (15u)
#define INTC_ICDICER8_SPTI0_SHIFT               (16u)
#define INTC_ICDICER8_SPEI1_SHIFT               (17u)
#define INTC_ICDICER8_SPRI1_SHIFT               (18u)
#define INTC_ICDICER8_SPTI1_SHIFT               (19u)
#define INTC_ICDICER8_SPEI2_SHIFT               (20u)
#define INTC_ICDICER8_SPRI2_SHIFT               (21u)
#define INTC_ICDICER8_SPTI2_SHIFT               (22u)
#define INTC_ICDICER8_SPEI3_SHIFT               (23u)
#define INTC_ICDICER8_SPRI3_SHIFT               (24u)
#define INTC_ICDICER8_SPTI3_SHIFT               (25u)
#define INTC_ICDICER8_SPEI4_SHIFT               (26u)
#define INTC_ICDICER8_SPRI4_SHIFT               (27u)
#define INTC_ICDICER8_SPTI4_SHIFT               (28u)
#define INTC_ICDICER8_IEBBTD_SHIFT              (29u)
#define INTC_ICDICER8_IEBBTERR_SHIFT            (30u)
#define INTC_ICDICER8_IEBBTSTA_SHIFT            (31u)

#define INTC_ICDICER9_IEBBTV_SHIFT              (0u)
#define INTC_ICDICER9_ISY_SHIFT                 (1u)
#define INTC_ICDICER9_IERR_SHIFT                (2u)
#define INTC_ICDICER9_ITARG_SHIFT               (3u)
#define INTC_ICDICER9_ISEC_SHIFT                (4u)
#define INTC_ICDICER9_IBUF_SHIFT                (5u)
#define INTC_ICDICER9_IREADY_SHIFT              (6u)
#define INTC_ICDICER9_FLSTE_SHIFT               (7u)
#define INTC_ICDICER9_FLTENDI_SHIFT             (8u)
#define INTC_ICDICER9_FLTREQ0I_SHIFT            (9u)
#define INTC_ICDICER9_FLTREQ1I_SHIFT            (10u)
#define INTC_ICDICER9_MMC0_SHIFT                (11u)
#define INTC_ICDICER9_MMC1_SHIFT                (12u)
#define INTC_ICDICER9_MMC2_SHIFT                (13u)
#define INTC_ICDICER9_SDHI0_3_SHIFT             (14u)
#define INTC_ICDICER9_SDHI0_0_SHIFT             (15u)
#define INTC_ICDICER9_SDHI0_1_SHIFT             (16u)
#define INTC_ICDICER9_SDHI1_3_SHIFT             (17u)
#define INTC_ICDICER9_SDHI1_0_SHIFT             (18u)
#define INTC_ICDICER9_SDHI1_1_SHIFT             (19u)
#define INTC_ICDICER9_ARM_SHIFT                 (20u)
#define INTC_ICDICER9_PRD_SHIFT                 (21u)
#define INTC_ICDICER9_CUP_SHIFT                 (22u)
#define INTC_ICDICER9_SCUAI0_SHIFT              (23u)
#define INTC_ICDICER9_SCUAI1_SHIFT              (24u)
#define INTC_ICDICER9_SCUFDI0_SHIFT             (25u)
#define INTC_ICDICER9_SCUFDI1_SHIFT             (26u)
#define INTC_ICDICER9_SCUFDI2_SHIFT             (27u)
#define INTC_ICDICER9_SCUFDI3_SHIFT             (28u)
#define INTC_ICDICER9_SCUFUI0_SHIFT             (29u)
#define INTC_ICDICER9_SCUFUI1_SHIFT             (30u)
#define INTC_ICDICER9_SCUFUI2_SHIFT             (31u)

#define INTC_ICDICER10_SCUFUI3_SHIFT            (0u)
#define INTC_ICDICER10_SCUDVI0_SHIFT            (1u)
#define INTC_ICDICER10_SCUDVI1_SHIFT            (2u)
#define INTC_ICDICER10_SCUDVI2_SHIFT            (3u)
#define INTC_ICDICER10_SCUDVI3_SHIFT            (4u)
#define INTC_ICDICER10_MLB_CINT_SHIFT           (5u)
#define INTC_ICDICER10_MLB_SINT_SHIFT           (6u)
#define INTC_ICDICER10_DRC0_SHIFT               (7u)
#define INTC_ICDICER10_DRC1_SHIFT               (8u)
#define INTC_ICDICER10_LINI0_INT_T_SHIFT        (11u)
#define INTC_ICDICER10_LINI0_INT_R_SHIFT        (12u)
#define INTC_ICDICER10_LINI0_INT_S_SHIFT        (13u)
#define INTC_ICDICER10_LINI0_INT_M_SHIFT        (14u)
#define INTC_ICDICER10_LINI1_INT_T_SHIFT        (15u)
#define INTC_ICDICER10_LINI1_INT_R_SHIFT        (16u)
#define INTC_ICDICER10_LINI1_INT_S_SHIFT        (17u)
#define INTC_ICDICER10_LINI1_INT_M_SHIFT        (18u)
#define INTC_ICDICER10_ERI0_SHIFT               (27u)
#define INTC_ICDICER10_RXI0_SHIFT               (28u)
#define INTC_ICDICER10_TXI0_SHIFT               (29u)
#define INTC_ICDICER10_TEI0_SHIFT               (30u)
#define INTC_ICDICER10_ERI1_SHIFT               (31u)

#define INTC_ICDICER11_RXI1_SHIFT               (0u)
#define INTC_ICDICER11_TXI1_SHIFT               (1u)
#define INTC_ICDICER11_TEI1_SHIFT               (2u)
#define INTC_ICDICER11_AVBI_DATA_SHIFT          (3u)
#define INTC_ICDICER11_AVBI_ERROR_SHIFT         (4u)
#define INTC_ICDICER11_AVBI_MANAGE_SHIFT        (5u)
#define INTC_ICDICER11_AVBI_MAC_SHIFT           (6u)
#define INTC_ICDICER11_ETHERI_SHIFT             (7u)
#define INTC_ICDICER11_CEUI_SHIFT               (12u)
#define INTC_ICDICER11_H2XMLB_ERRINT_SHIFT      (29u)
#define INTC_ICDICER11_H2XIC1_ERRINT_SHIFT      (30u)
#define INTC_ICDICER11_X2HPERI1_ERRINT_SHIFT    (31u)

#define INTC_ICDICER12_X2HPERI2_ERRINT_SHIFT    (0u)
#define INTC_ICDICER12_X2HPERI34_ERRINT_SHIFT   (1u)
#define INTC_ICDICER12_X2HPERI5_ERRINT_SHIFT    (2u)
#define INTC_ICDICER12_X2HPERI67_ERRINT_SHIFT   (3u)
#define INTC_ICDICER12_X2HDBGR_ERRINT_SHIFT     (4u)
#define INTC_ICDICER12_X2HBSC_ERRINT_SHIFT      (5u)
#define INTC_ICDICER12_X2HSPI1_ERRINT_SHIFT     (6u)
#define INTC_ICDICER12_X2HSPI2_ERRINT_SHIFT     (7u)
#define INTC_ICDICER12_PRRI_SHIFT               (8u)
#define INTC_ICDICER12_IFEI0_SHIFT              (9u)
#define INTC_ICDICER12_OFFI0_SHIFT              (10u)
#define INTC_ICDICER12_PFVEI0_SHIFT             (11u)
#define INTC_ICDICER12_IFEI1_SHIFT              (12u)
#define INTC_ICDICER12_OFFI1_SHIFT              (13u)
#define INTC_ICDICER12_PFVEI1_SHIFT             (14u)

#define INTC_ICDICER13_TINT0_SHIFT              (0u)
#define INTC_ICDICER13_TINT1_SHIFT              (1u)
#define INTC_ICDICER13_TINT2_SHIFT              (2u)
#define INTC_ICDICER13_TINT3_SHIFT              (3u)
#define INTC_ICDICER13_TINT4_SHIFT              (4u)
#define INTC_ICDICER13_TINT5_SHIFT              (5u)
#define INTC_ICDICER13_TINT6_SHIFT              (6u)
#define INTC_ICDICER13_TINT7_SHIFT              (7u)
#define INTC_ICDICER13_TINT8_SHIFT              (8u)
#define INTC_ICDICER13_TINT9_SHIFT              (9u)
#define INTC_ICDICER13_TINT10_SHIFT             (10u)
#define INTC_ICDICER13_TINT11_SHIFT             (11u)
#define INTC_ICDICER13_TINT12_SHIFT             (12u)
#define INTC_ICDICER13_TINT13_SHIFT             (13u)
#define INTC_ICDICER13_TINT14_SHIFT             (14u)
#define INTC_ICDICER13_TINT15_SHIFT             (15u)
#define INTC_ICDICER13_TINT16_SHIFT             (16u)
#define INTC_ICDICER13_TINT17_SHIFT             (17u)
#define INTC_ICDICER13_TINT18_SHIFT             (18u)
#define INTC_ICDICER13_TINT19_SHIFT             (19u)
#define INTC_ICDICER13_TINT20_SHIFT             (20u)
#define INTC_ICDICER13_TINT21_SHIFT             (21u)
#define INTC_ICDICER13_TINT22_SHIFT             (22u)
#define INTC_ICDICER13_TINT23_SHIFT             (23u)
#define INTC_ICDICER13_TINT24_SHIFT             (24u)
#define INTC_ICDICER13_TINT25_SHIFT             (25u)
#define INTC_ICDICER13_TINT26_SHIFT             (26u)
#define INTC_ICDICER13_TINT27_SHIFT             (27u)
#define INTC_ICDICER13_TINT28_SHIFT             (28u)
#define INTC_ICDICER13_TINT29_SHIFT             (29u)
#define INTC_ICDICER13_TINT30_SHIFT             (30u)
#define INTC_ICDICER13_TINT31_SHIFT             (31u)

#define INTC_ICDICER14_TINT32_SHIFT             (0u)
#define INTC_ICDICER14_TINT33_SHIFT             (1u)
#define INTC_ICDICER14_TINT34_SHIFT             (2u)
#define INTC_ICDICER14_TINT35_SHIFT             (3u)
#define INTC_ICDICER14_TINT36_SHIFT             (4u)
#define INTC_ICDICER14_TINT37_SHIFT             (5u)
#define INTC_ICDICER14_TINT38_SHIFT             (6u)
#define INTC_ICDICER14_TINT39_SHIFT             (7u)
#define INTC_ICDICER14_TINT40_SHIFT             (8u)
#define INTC_ICDICER14_TINT41_SHIFT             (9u)
#define INTC_ICDICER14_TINT42_SHIFT             (10u)
#define INTC_ICDICER14_TINT43_SHIFT             (11u)
#define INTC_ICDICER14_TINT44_SHIFT             (12u)
#define INTC_ICDICER14_TINT45_SHIFT             (13u)
#define INTC_ICDICER14_TINT46_SHIFT             (14u)
#define INTC_ICDICER14_TINT47_SHIFT             (15u)
#define INTC_ICDICER14_TINT48_SHIFT             (16u)
#define INTC_ICDICER14_TINT49_SHIFT             (17u)
#define INTC_ICDICER14_TINT50_SHIFT             (18u)
#define INTC_ICDICER14_TINT51_SHIFT             (19u)
#define INTC_ICDICER14_TINT52_SHIFT             (20u)
#define INTC_ICDICER14_TINT53_SHIFT             (21u)
#define INTC_ICDICER14_TINT54_SHIFT             (22u)
#define INTC_ICDICER14_TINT55_SHIFT             (23u)
#define INTC_ICDICER14_TINT56_SHIFT             (24u)
#define INTC_ICDICER14_TINT57_SHIFT             (25u)
#define INTC_ICDICER14_TINT58_SHIFT             (26u)
#define INTC_ICDICER14_TINT59_SHIFT             (27u)
#define INTC_ICDICER14_TINT60_SHIFT             (28u)
#define INTC_ICDICER14_TINT61_SHIFT             (29u)
#define INTC_ICDICER14_TINT62_SHIFT             (30u)
#define INTC_ICDICER14_TINT63_SHIFT             (31u)

#define INTC_ICDICER15_TINT64_SHIFT             (0u)
#define INTC_ICDICER15_TINT65_SHIFT             (1u)
#define INTC_ICDICER15_TINT66_SHIFT             (2u)
#define INTC_ICDICER15_TINT67_SHIFT             (3u)
#define INTC_ICDICER15_TINT68_SHIFT             (4u)
#define INTC_ICDICER15_TINT69_SHIFT             (5u)
#define INTC_ICDICER15_TINT70_SHIFT             (6u)
#define INTC_ICDICER15_TINT71_SHIFT             (7u)
#define INTC_ICDICER15_TINT72_SHIFT             (8u)
#define INTC_ICDICER15_TINT73_SHIFT             (9u)
#define INTC_ICDICER15_TINT74_SHIFT             (10u)
#define INTC_ICDICER15_TINT75_SHIFT             (11u)
#define INTC_ICDICER15_TINT76_SHIFT             (12u)
#define INTC_ICDICER15_TINT77_SHIFT             (13u)
#define INTC_ICDICER15_TINT78_SHIFT             (14u)
#define INTC_ICDICER15_TINT79_SHIFT             (15u)
#define INTC_ICDICER15_TINT80_SHIFT             (16u)
#define INTC_ICDICER15_TINT81_SHIFT             (17u)
#define INTC_ICDICER15_TINT82_SHIFT             (18u)
#define INTC_ICDICER15_TINT83_SHIFT             (19u)
#define INTC_ICDICER15_TINT84_SHIFT             (20u)
#define INTC_ICDICER15_TINT85_SHIFT             (21u)
#define INTC_ICDICER15_TINT86_SHIFT             (22u)
#define INTC_ICDICER15_TINT87_SHIFT             (23u)
#define INTC_ICDICER15_TINT88_SHIFT             (24u)
#define INTC_ICDICER15_TINT89_SHIFT             (25u)
#define INTC_ICDICER15_TINT90_SHIFT             (26u)
#define INTC_ICDICER15_TINT91_SHIFT             (27u)
#define INTC_ICDICER15_TINT92_SHIFT             (28u)
#define INTC_ICDICER15_TINT93_SHIFT             (29u)
#define INTC_ICDICER15_TINT94_SHIFT             (30u)
#define INTC_ICDICER15_TINT95_SHIFT             (31u)

#define INTC_ICDICER16_TINT96_SHIFT             (0u)
#define INTC_ICDICER16_TINT97_SHIFT             (1u)
#define INTC_ICDICER16_TINT98_SHIFT             (2u)
#define INTC_ICDICER16_TINT99_SHIFT             (3u)
#define INTC_ICDICER16_TINT100_SHIFT            (4u)
#define INTC_ICDICER16_TINT101_SHIFT            (5u)
#define INTC_ICDICER16_TINT102_SHIFT            (6u)
#define INTC_ICDICER16_TINT103_SHIFT            (7u)
#define INTC_ICDICER16_TINT104_SHIFT            (8u)
#define INTC_ICDICER16_TINT105_SHIFT            (9u)
#define INTC_ICDICER16_TINT106_SHIFT            (10u)
#define INTC_ICDICER16_TINT107_SHIFT            (11u)
#define INTC_ICDICER16_TINT108_SHIFT            (12u)
#define INTC_ICDICER16_TINT109_SHIFT            (13u)
#define INTC_ICDICER16_TINT110_SHIFT            (14u)
#define INTC_ICDICER16_TINT111_SHIFT            (15u)
#define INTC_ICDICER16_TINT112_SHIFT            (16u)
#define INTC_ICDICER16_TINT113_SHIFT            (17u)
#define INTC_ICDICER16_TINT114_SHIFT            (18u)
#define INTC_ICDICER16_TINT115_SHIFT            (19u)
#define INTC_ICDICER16_TINT116_SHIFT            (20u)
#define INTC_ICDICER16_TINT117_SHIFT            (21u)
#define INTC_ICDICER16_TINT118_SHIFT            (22u)
#define INTC_ICDICER16_TINT119_SHIFT            (23u)
#define INTC_ICDICER16_TINT120_SHIFT            (24u)
#define INTC_ICDICER16_TINT121_SHIFT            (25u)
#define INTC_ICDICER16_TINT122_SHIFT            (26u)
#define INTC_ICDICER16_TINT123_SHIFT            (27u)
#define INTC_ICDICER16_TINT124_SHIFT            (28u)
#define INTC_ICDICER16_TINT125_SHIFT            (29u)
#define INTC_ICDICER16_TINT126_SHIFT            (30u)
#define INTC_ICDICER16_TINT127_SHIFT            (31u)

#define INTC_ICDICER17_TINT128_SHIFT            (0u)
#define INTC_ICDICER17_TINT129_SHIFT            (1u)
#define INTC_ICDICER17_TINT130_SHIFT            (2u)
#define INTC_ICDICER17_TINT131_SHIFT            (3u)
#define INTC_ICDICER17_TINT132_SHIFT            (4u)
#define INTC_ICDICER17_TINT133_SHIFT            (5u)
#define INTC_ICDICER17_TINT134_SHIFT            (6u)
#define INTC_ICDICER17_TINT135_SHIFT            (7u)
#define INTC_ICDICER17_TINT136_SHIFT            (8u)
#define INTC_ICDICER17_TINT137_SHIFT            (9u)
#define INTC_ICDICER17_TINT138_SHIFT            (10u)
#define INTC_ICDICER17_TINT139_SHIFT            (11u)
#define INTC_ICDICER17_TINT140_SHIFT            (12u)
#define INTC_ICDICER17_TINT141_SHIFT            (13u)
#define INTC_ICDICER17_TINT142_SHIFT            (14u)
#define INTC_ICDICER17_TINT143_SHIFT            (15u)
#define INTC_ICDICER17_TINT144_SHIFT            (16u)
#define INTC_ICDICER17_TINT145_SHIFT            (17u)
#define INTC_ICDICER17_TINT146_SHIFT            (18u)
#define INTC_ICDICER17_TINT147_SHIFT            (19u)
#define INTC_ICDICER17_TINT148_SHIFT            (20u)
#define INTC_ICDICER17_TINT149_SHIFT            (21u)
#define INTC_ICDICER17_TINT150_SHIFT            (22u)
#define INTC_ICDICER17_TINT151_SHIFT            (23u)
#define INTC_ICDICER17_TINT152_SHIFT            (24u)
#define INTC_ICDICER17_TINT153_SHIFT            (25u)
#define INTC_ICDICER17_TINT154_SHIFT            (26u)
#define INTC_ICDICER17_TINT155_SHIFT            (27u)
#define INTC_ICDICER17_TINT156_SHIFT            (28u)
#define INTC_ICDICER17_TINT157_SHIFT            (29u)
#define INTC_ICDICER17_TINT158_SHIFT            (30u)
#define INTC_ICDICER17_TINT159_SHIFT            (31u)

#define INTC_ICDICER18_TINT160_SHIFT            (0u)
#define INTC_ICDICER18_TINT161_SHIFT            (1u)
#define INTC_ICDICER18_TINT162_SHIFT            (2u)
#define INTC_ICDICER18_TINT163_SHIFT            (3u)
#define INTC_ICDICER18_TINT164_SHIFT            (4u)
#define INTC_ICDICER18_TINT165_SHIFT            (5u)
#define INTC_ICDICER18_TINT166_SHIFT            (6u)
#define INTC_ICDICER18_TINT167_SHIFT            (7u)
#define INTC_ICDICER18_TINT168_SHIFT            (8u)
#define INTC_ICDICER18_TINT169_SHIFT            (9u)
#define INTC_ICDICER18_TINT170_SHIFT            (10u)

#define INTC_ICDISPR0_SW0_SHIFT                 (0u)
#define INTC_ICDISPR0_SW1_SHIFT                 (1u)
#define INTC_ICDISPR0_SW2_SHIFT                 (2u)
#define INTC_ICDISPR0_SW3_SHIFT                 (3u)
#define INTC_ICDISPR0_SW4_SHIFT                 (4u)
#define INTC_ICDISPR0_SW5_SHIFT                 (5u)
#define INTC_ICDISPR0_SW6_SHIFT                 (6u)
#define INTC_ICDISPR0_SW7_SHIFT                 (7u)
#define INTC_ICDISPR0_SW8_SHIFT                 (8u)
#define INTC_ICDISPR0_SW9_SHIFT                 (9u)
#define INTC_ICDISPR0_SW10_SHIFT                (10u)
#define INTC_ICDISPR0_SW11_SHIFT                (11u)
#define INTC_ICDISPR0_SW12_SHIFT                (12u)
#define INTC_ICDISPR0_SW13_SHIFT                (13u)
#define INTC_ICDISPR0_SW14_SHIFT                (14u)
#define INTC_ICDISPR0_SW15_SHIFT                (15u)
#define INTC_ICDISPR0_PMUIRQ0_SHIFT             (16u)
#define INTC_ICDISPR0_COMMRX0_SHIFT             (17u)
#define INTC_ICDISPR0_COMMTX0_SHIFT             (18u)
#define INTC_ICDISPR0_CTIIRQ0_SHIFT             (19u)

#define INTC_ICDISPR1_IRQ0_SHIFT                (0u)
#define INTC_ICDISPR1_IRQ1_SHIFT                (1u)
#define INTC_ICDISPR1_IRQ2_SHIFT                (2u)
#define INTC_ICDISPR1_IRQ3_SHIFT                (3u)
#define INTC_ICDISPR1_IRQ4_SHIFT                (4u)
#define INTC_ICDISPR1_IRQ5_SHIFT                (5u)
#define INTC_ICDISPR1_IRQ6_SHIFT                (6u)
#define INTC_ICDISPR1_IRQ7_SHIFT                (7u)
#define INTC_ICDISPR1_PL310ERR_SHIFT            (8u)
#define INTC_ICDISPR1_DMAINT0_SHIFT             (9u)
#define INTC_ICDISPR1_DMAINT1_SHIFT             (10u)
#define INTC_ICDISPR1_DMAINT2_SHIFT             (11u)
#define INTC_ICDISPR1_DMAINT3_SHIFT             (12u)
#define INTC_ICDISPR1_DMAINT4_SHIFT             (13u)
#define INTC_ICDISPR1_DMAINT5_SHIFT             (14u)
#define INTC_ICDISPR1_DMAINT6_SHIFT             (15u)
#define INTC_ICDISPR1_DMAINT7_SHIFT             (16u)
#define INTC_ICDISPR1_DMAINT8_SHIFT             (17u)
#define INTC_ICDISPR1_DMAINT9_SHIFT             (18u)
#define INTC_ICDISPR1_DMAINT10_SHIFT            (19u)
#define INTC_ICDISPR1_DMAINT11_SHIFT            (20u)
#define INTC_ICDISPR1_DMAINT12_SHIFT            (21u)
#define INTC_ICDISPR1_DMAINT13_SHIFT            (22u)
#define INTC_ICDISPR1_DMAINT14_SHIFT            (23u)
#define INTC_ICDISPR1_DMAINT15_SHIFT            (24u)
#define INTC_ICDISPR1_DMAERR_SHIFT              (25u)

#define INTC_ICDISPR2_USBI0_SHIFT               (9u)
#define INTC_ICDISPR2_USBI1_SHIFT               (10u)
#define INTC_ICDISPR2_S0_VI_VSYNC0_SHIFT        (11u)
#define INTC_ICDISPR2_S0_LO_VSYNC0_SHIFT        (12u)
#define INTC_ICDISPR2_S0_VSYNCERR0_SHIFT        (13u)
#define INTC_ICDISPR2_GR3_VLINE0_SHIFT          (14u)
#define INTC_ICDISPR2_S0_VFIELD0_SHIFT          (15u)
#define INTC_ICDISPR2_IV1_VBUFERR0_SHIFT        (16u)
#define INTC_ICDISPR2_IV3_VBUFERR0_SHIFT        (17u)
#define INTC_ICDISPR2_IV5_VBUFERR0_SHIFT        (18u)
#define INTC_ICDISPR2_IV6_VBUFERR0_SHIFT        (19u)
#define INTC_ICDISPR2_S0_WLINE0_SHIFT           (20u)
#define INTC_ICDISPR2_S1_VI_VSYNC0_SHIFT        (21u)
#define INTC_ICDISPR2_S1_LO_VSYNC0_SHIFT        (22u)
#define INTC_ICDISPR2_S1_VSYNCERR0_SHIFT        (23u)
#define INTC_ICDISPR2_S1_VFIELD0_SHIFT          (24u)
#define INTC_ICDISPR2_IV2_VBUFERR0_SHIFT        (25u)
#define INTC_ICDISPR2_IV4_VBUFERR0_SHIFT        (26u)
#define INTC_ICDISPR2_S1_WLINE0_SHIFT           (27u)
#define INTC_ICDISPR2_OIR_VI_VSYNC0_SHIFT       (28u)
#define INTC_ICDISPR2_OIR_LO_VSYNC0_SHIFT       (29u)
#define INTC_ICDISPR2_OIR_VSYNCERR0_SHIFT       (30u)
#define INTC_ICDISPR2_OIR_VFIELD0_SHIFT         (31u)

#define INTC_ICDISPR3_IV7_VBUFERR0_SHIFT        (0u)
#define INTC_ICDISPR3_IV8_VBUFERR0_SHIFT        (1u)
#define INTC_ICDISPR3_OIR_WLINE0_SHIFT          (2u)
#define INTC_ICDISPR3_S0_VI_VSYNC1_SHIFT        (3u)
#define INTC_ICDISPR3_S0_LO_VSYNC1_SHIFT        (4u)
#define INTC_ICDISPR3_S0_VSYNCERR1_SHIFT        (5u)
#define INTC_ICDISPR3_GR3_VLINE1_SHIFT          (6u)
#define INTC_ICDISPR3_S0_VFIELD1_SHIFT          (7u)
#define INTC_ICDISPR3_IV1_VBUFERR1_SHIFT        (8u)
#define INTC_ICDISPR3_IV3_VBUFERR1_SHIFT        (9u)
#define INTC_ICDISPR3_IV5_VBUFERR1_SHIFT        (10u)
#define INTC_ICDISPR3_IV6_VBUFERR1_SHIFT        (11u)
#define INTC_ICDISPR3_S0_WLINE1_SHIFT           (12u)
#define INTC_ICDISPR3_S1_VI_VSYNC1_SHIFT        (13u)
#define INTC_ICDISPR3_S1_LO_VSYNC1_SHIFT        (14u)
#define INTC_ICDISPR3_S1_VSYNCERR1_SHIFT        (15u)
#define INTC_ICDISPR3_S1_VFIELD1_SHIFT          (16u)
#define INTC_ICDISPR3_IV2_VBUFERR1_SHIFT        (17u)
#define INTC_ICDISPR3_IV4_VBUFERR1_SHIFT        (18u)
#define INTC_ICDISPR3_S1_WLINE1_SHIFT           (19u)
#define INTC_ICDISPR3_OIR_VI_VSYNC1_SHIFT       (20u)
#define INTC_ICDISPR3_OIR_LO_VSYNC1_SHIFT       (21u)
#define INTC_ICDISPR3_OIR_VLINE1_SHIFT          (22u)
#define INTC_ICDISPR3_OIR_VFIELD1_SHIFT         (23u)
#define INTC_ICDISPR3_IV7_VBUFERR1_SHIFT        (24u)
#define INTC_ICDISPR3_IV8_VBUFERR1_SHIFT        (25u)
#define INTC_ICDISPR3_OIR_WLINE1_SHIFT          (26u)
#define INTC_ICDISPR3_IMRDI_SHIFT               (27u)
#define INTC_ICDISPR3_IMR2I0_SHIFT              (28u)
#define INTC_ICDISPR3_IMR2I1_SHIFT              (29u)
#define INTC_ICDISPR3_JEDI_SHIFT                (30u)
#define INTC_ICDISPR3_JDTI_SHIFT                (31u)

#define INTC_ICDISPR4_CMP0_SHIFT                (0u)
#define INTC_ICDISPR4_CMP1_SHIFT                (1u)
#define INTC_ICDISPR4_INT0_SHIFT                (2u)
#define INTC_ICDISPR4_INT1_SHIFT                (3u)
#define INTC_ICDISPR4_INT2_SHIFT                (4u)
#define INTC_ICDISPR4_INT3_SHIFT                (5u)
#define INTC_ICDISPR4_OSTM0TINT_SHIFT           (6u)
#define INTC_ICDISPR4_OSTM1TINT_SHIFT           (7u)
#define INTC_ICDISPR4_CMI_SHIFT                 (8u)
#define INTC_ICDISPR4_WTOUT_SHIFT               (9u)
#define INTC_ICDISPR4_ITI_SHIFT                 (10u)
#define INTC_ICDISPR4_TGI0A_SHIFT               (11u)
#define INTC_ICDISPR4_TGI0B_SHIFT               (12u)
#define INTC_ICDISPR4_TGI0C_SHIFT               (13u)
#define INTC_ICDISPR4_TGI0D_SHIFT               (14u)
#define INTC_ICDISPR4_TGI0V_SHIFT               (15u)
#define INTC_ICDISPR4_TGI0E_SHIFT               (16u)
#define INTC_ICDISPR4_TGI0F_SHIFT               (17u)
#define INTC_ICDISPR4_TGI1A_SHIFT               (18u)
#define INTC_ICDISPR4_TGI1B_SHIFT               (19u)
#define INTC_ICDISPR4_TGI1V_SHIFT               (20u)
#define INTC_ICDISPR4_TGI1U_SHIFT               (21u)
#define INTC_ICDISPR4_TGI2A_SHIFT               (22u)
#define INTC_ICDISPR4_TGI2B_SHIFT               (23u)
#define INTC_ICDISPR4_TGI2V_SHIFT               (24u)
#define INTC_ICDISPR4_TGI2U_SHIFT               (25u)
#define INTC_ICDISPR4_TGI3A_SHIFT               (26u)
#define INTC_ICDISPR4_TGI3B_SHIFT               (27u)
#define INTC_ICDISPR4_TGI3C_SHIFT               (28u)
#define INTC_ICDISPR4_TGI3D_SHIFT               (29u)
#define INTC_ICDISPR4_TGI3V_SHIFT               (30u)
#define INTC_ICDISPR4_TGI4A_SHIFT               (31u)

#define INTC_ICDISPR5_TGI4B_SHIFT               (0u)
#define INTC_ICDISPR5_TGI4C_SHIFT               (1u)
#define INTC_ICDISPR5_TGI4D_SHIFT               (2u)
#define INTC_ICDISPR5_TGI4V_SHIFT               (3u)
#define INTC_ICDISPR5_CMI1_SHIFT                (4u)
#define INTC_ICDISPR5_CMI2_SHIFT                (5u)
#define INTC_ICDISPR5_SGDEI0_SHIFT              (6u)
#define INTC_ICDISPR5_SGDEI1_SHIFT              (7u)
#define INTC_ICDISPR5_SGDEI2_SHIFT              (8u)
#define INTC_ICDISPR5_SGDEI3_SHIFT              (9u)
#define INTC_ICDISPR5_ADI_SHIFT                 (10u)
#define INTC_ICDISPR5_LMTI_SHIFT                (11u)
#define INTC_ICDISPR5_SSII0_SHIFT               (12u)
#define INTC_ICDISPR5_SSIRXI0_SHIFT             (13u)
#define INTC_ICDISPR5_SSITXI0_SHIFT             (14u)
#define INTC_ICDISPR5_SSII1_SHIFT               (15u)
#define INTC_ICDISPR5_SSIRXI1_SHIFT             (16u)
#define INTC_ICDISPR5_SSITXI1_SHIFT             (17u)
#define INTC_ICDISPR5_SSII2_SHIFT               (18u)
#define INTC_ICDISPR5_SSIRTI2_SHIFT             (19u)
#define INTC_ICDISPR5_SSII3_SHIFT               (20u)
#define INTC_ICDISPR5_SSIRXI3_SHIFT             (21u)
#define INTC_ICDISPR5_SSITXI3_SHIFT             (22u)
#define INTC_ICDISPR5_SSII4_SHIFT               (23u)
#define INTC_ICDISPR5_SSIRTI4_SHIFT             (24u)
#define INTC_ICDISPR5_SSII5_SHIFT               (25u)
#define INTC_ICDISPR5_SSIRXI5_SHIFT             (26u)
#define INTC_ICDISPR5_SSITXI5_SHIFT             (27u)
#define INTC_ICDISPR5_SPDIFI_SHIFT              (28u)
#define INTC_ICDISPR5_INTIICTEI0_SHIFT          (29u)
#define INTC_ICDISPR5_INTIICRI0_SHIFT           (30u)
#define INTC_ICDISPR5_INTIICTI0_SHIFT           (31u)

#define INTC_ICDISPR6_INTIICSPI0_SHIFT          (0u)
#define INTC_ICDISPR6_INTIICSTI0_SHIFT          (1u)
#define INTC_ICDISPR6_INTIICNAKI0_SHIFT         (2u)
#define INTC_ICDISPR6_INTIICALI0_SHIFT          (3u)
#define INTC_ICDISPR6_INTIICTMOI0_SHIFT         (4u)
#define INTC_ICDISPR6_INTIICTEI1_SHIFT          (5u)
#define INTC_ICDISPR6_INTIICRI1_SHIFT           (6u)
#define INTC_ICDISPR6_INTIICTI1_SHIFT           (7u)
#define INTC_ICDISPR6_INTIICSPI1_SHIFT          (8u)
#define INTC_ICDISPR6_INTIICSTI1_SHIFT          (9u)
#define INTC_ICDISPR6_INTIICNAKI1_SHIFT         (10u)
#define INTC_ICDISPR6_INTIICALI1_SHIFT          (11u)
#define INTC_ICDISPR6_INTIICTMOI1_SHIFT         (12u)
#define INTC_ICDISPR6_INTIICTEI2_SHIFT          (13u)
#define INTC_ICDISPR6_INTIICRI2_SHIFT           (14u)
#define INTC_ICDISPR6_INTIICTI2_SHIFT           (15u)
#define INTC_ICDISPR6_INTIICSPI2_SHIFT          (16u)
#define INTC_ICDISPR6_INTIICSTI2_SHIFT          (17u)
#define INTC_ICDISPR6_INTIICNAKI2_SHIFT         (18u)
#define INTC_ICDISPR6_INTIICALI2_SHIFT          (19u)
#define INTC_ICDISPR6_INTIICTMOI2_SHIFT         (20u)
#define INTC_ICDISPR6_INTIICTEI3_SHIFT          (21u)
#define INTC_ICDISPR6_INTIICRI3_SHIFT           (22u)
#define INTC_ICDISPR6_INTIICTI3_SHIFT           (23u)
#define INTC_ICDISPR6_INTIICSPI3_SHIFT          (24u)
#define INTC_ICDISPR6_INTIICSTI3_SHIFT          (25u)
#define INTC_ICDISPR6_INTIICNAKI3_SHIFT         (26u)
#define INTC_ICDISPR6_INTIICALI3_SHIFT          (27u)
#define INTC_ICDISPR6_INTIICTMOI3_SHIFT         (28u)
#define INTC_ICDISPR6_BRI0_SHIFT                (29u)
#define INTC_ICDISPR6_ERI0_SHIFT                (30u)
#define INTC_ICDISPR6_RXI0_SHIFT                (31u)

#define INTC_ICDISPR7_TXI0_SHIFT                (0u)
#define INTC_ICDISPR7_BRI1_SHIFT                (1u)
#define INTC_ICDISPR7_ERI1_SHIFT                (2u)
#define INTC_ICDISPR7_RXI1_SHIFT                (3u)
#define INTC_ICDISPR7_TXI1_SHIFT                (4u)
#define INTC_ICDISPR7_BRI2_SHIFT                (5u)
#define INTC_ICDISPR7_ERI2_SHIFT                (6u)
#define INTC_ICDISPR7_RXI2_SHIFT                (7u)
#define INTC_ICDISPR7_TXI2_SHIFT                (8u)
#define INTC_ICDISPR7_BRI3_SHIFT                (9u)
#define INTC_ICDISPR7_ERI3_SHIFT                (10u)
#define INTC_ICDISPR7_RXI3_SHIFT                (11u)
#define INTC_ICDISPR7_TXI3_SHIFT                (12u)
#define INTC_ICDISPR7_BRI4_SHIFT                (13u)
#define INTC_ICDISPR7_ERI4_SHIFT                (14u)
#define INTC_ICDISPR7_RXI4_SHIFT                (15u)
#define INTC_ICDISPR7_TXI4_SHIFT                (16u)
#define INTC_ICDISPR7_BRI5_SHIFT                (17u)
#define INTC_ICDISPR7_ERI5_SHIFT                (18u)
#define INTC_ICDISPR7_RXI5_SHIFT                (19u)
#define INTC_ICDISPR7_TXI5_SHIFT                (20u)
#define INTC_ICDISPR7_BRI6_SHIFT                (21u)
#define INTC_ICDISPR7_ERI6_SHIFT                (22u)
#define INTC_ICDISPR7_RXI6_SHIFT                (23u)
#define INTC_ICDISPR7_TXI6_SHIFT                (24u)
#define INTC_ICDISPR7_BRI7_SHIFT                (25u)
#define INTC_ICDISPR7_ERI7_SHIFT                (26u)
#define INTC_ICDISPR7_RXI7_SHIFT                (27u)
#define INTC_ICDISPR7_TXI7_SHIFT                (28u)
#define INTC_ICDISPR7_INTRCANGERR_SHIFT         (29u)
#define INTC_ICDISPR7_INTRCANGRECC_SHIFT        (30u)
#define INTC_ICDISPR7_INTRCAN0REC_SHIFT         (31u)

#define INTC_ICDISPR8_INTRCAN0ERR_SHIFT         (0u)
#define INTC_ICDISPR8_INTRCAN0TRX_SHIFT         (1u)
#define INTC_ICDISPR8_INTRCAN1REC_SHIFT         (2u)
#define INTC_ICDISPR8_INTRCAN1ERR_SHIFT         (3u)
#define INTC_ICDISPR8_INTRCAN1TRX_SHIFT         (4u)
#define INTC_ICDISPR8_INTRCAN2REC_SHIFT         (5u)
#define INTC_ICDISPR8_INTRCAN2ERR_SHIFT         (6u)
#define INTC_ICDISPR8_INTRCAN2TRX_SHIFT         (7u)
#define INTC_ICDISPR8_INTRCAN3REC_SHIFT         (8u)
#define INTC_ICDISPR8_INTRCAN3ERR_SHIFT         (9u)
#define INTC_ICDISPR8_INTRCAN3TRX_SHIFT         (10u)
#define INTC_ICDISPR8_INTRCAN4REC_SHIFT         (11u)
#define INTC_ICDISPR8_INTRCAN4ERR_SHIFT         (12u)
#define INTC_ICDISPR8_INTRCAN4TRX_SHIFT         (13u)
#define INTC_ICDISPR8_SPEI0_SHIFT               (14u)
#define INTC_ICDISPR8_SPRI0_SHIFT               (15u)
#define INTC_ICDISPR8_SPTI0_SHIFT               (16u)
#define INTC_ICDISPR8_SPEI1_SHIFT               (17u)
#define INTC_ICDISPR8_SPRI1_SHIFT               (18u)
#define INTC_ICDISPR8_SPTI1_SHIFT               (19u)
#define INTC_ICDISPR8_SPEI2_SHIFT               (20u)
#define INTC_ICDISPR8_SPRI2_SHIFT               (21u)
#define INTC_ICDISPR8_SPTI2_SHIFT               (22u)
#define INTC_ICDISPR8_SPEI3_SHIFT               (23u)
#define INTC_ICDISPR8_SPRI3_SHIFT               (24u)
#define INTC_ICDISPR8_SPTI3_SHIFT               (25u)
#define INTC_ICDISPR8_SPEI4_SHIFT               (26u)
#define INTC_ICDISPR8_SPRI4_SHIFT               (27u)
#define INTC_ICDISPR8_SPTI4_SHIFT               (28u)
#define INTC_ICDISPR8_IEBBTD_SHIFT              (29u)
#define INTC_ICDISPR8_IEBBTERR_SHIFT            (30u)
#define INTC_ICDISPR8_IEBBTSTA_SHIFT            (31u)

#define INTC_ICDISPR9_IEBBTV_SHIFT              (0u)
#define INTC_ICDISPR9_ISY_SHIFT                 (1u)
#define INTC_ICDISPR9_IERR_SHIFT                (2u)
#define INTC_ICDISPR9_ITARG_SHIFT               (3u)
#define INTC_ICDISPR9_ISEC_SHIFT                (4u)
#define INTC_ICDISPR9_IBUF_SHIFT                (5u)
#define INTC_ICDISPR9_IREADY_SHIFT              (6u)
#define INTC_ICDISPR9_FLSTE_SHIFT               (7u)
#define INTC_ICDISPR9_FLTENDI_SHIFT             (8u)
#define INTC_ICDISPR9_FLTREQ0I_SHIFT            (9u)
#define INTC_ICDISPR9_FLTREQ1I_SHIFT            (10u)
#define INTC_ICDISPR9_MMC0_SHIFT                (11u)
#define INTC_ICDISPR9_MMC1_SHIFT                (12u)
#define INTC_ICDISPR9_MMC2_SHIFT                (13u)
#define INTC_ICDISPR9_SDHI0_3_SHIFT             (14u)
#define INTC_ICDISPR9_SDHI0_0_SHIFT             (15u)
#define INTC_ICDISPR9_SDHI0_1_SHIFT             (16u)
#define INTC_ICDISPR9_SDHI1_3_SHIFT             (17u)
#define INTC_ICDISPR9_SDHI1_0_SHIFT             (18u)
#define INTC_ICDISPR9_SDHI1_1_SHIFT             (19u)
#define INTC_ICDISPR9_ARM_SHIFT                 (20u)
#define INTC_ICDISPR9_PRD_SHIFT                 (21u)
#define INTC_ICDISPR9_CUP_SHIFT                 (22u)
#define INTC_ICDISPR9_SCUAI0_SHIFT              (23u)
#define INTC_ICDISPR9_SCUAI1_SHIFT              (24u)
#define INTC_ICDISPR9_SCUFDI0_SHIFT             (25u)
#define INTC_ICDISPR9_SCUFDI1_SHIFT             (26u)
#define INTC_ICDISPR9_SCUFDI2_SHIFT             (27u)
#define INTC_ICDISPR9_SCUFDI3_SHIFT             (28u)
#define INTC_ICDISPR9_SCUFUI0_SHIFT             (29u)
#define INTC_ICDISPR9_SCUFUI1_SHIFT             (30u)
#define INTC_ICDISPR9_SCUFUI2_SHIFT             (31u)

#define INTC_ICDISPR10_SCUFUI3_SHIFT            (0u)
#define INTC_ICDISPR10_SCUDVI0_SHIFT            (1u)
#define INTC_ICDISPR10_SCUDVI1_SHIFT            (2u)
#define INTC_ICDISPR10_SCUDVI2_SHIFT            (3u)
#define INTC_ICDISPR10_SCUDVI3_SHIFT            (4u)
#define INTC_ICDISPR10_MLB_CINT_SHIFT           (5u)
#define INTC_ICDISPR10_MLB_SINT_SHIFT           (6u)
#define INTC_ICDISPR10_DRC0_SHIFT               (7u)
#define INTC_ICDISPR10_DRC1_SHIFT               (8u)
#define INTC_ICDISPR10_LINI0_INT_T_SHIFT        (11u)
#define INTC_ICDISPR10_LINI0_INT_R_SHIFT        (12u)
#define INTC_ICDISPR10_LINI0_INT_S_SHIFT        (13u)
#define INTC_ICDISPR10_LINI0_INT_M_SHIFT        (14u)
#define INTC_ICDISPR10_LINI1_INT_T_SHIFT        (15u)
#define INTC_ICDISPR10_LINI1_INT_R_SHIFT        (16u)
#define INTC_ICDISPR10_LINI1_INT_S_SHIFT        (17u)
#define INTC_ICDISPR10_LINI1_INT_M_SHIFT        (18u)
#define INTC_ICDISPR10_ERI0_SHIFT               (27u)
#define INTC_ICDISPR10_RXI0_SHIFT               (28u)
#define INTC_ICDISPR10_TXI0_SHIFT               (29u)
#define INTC_ICDISPR10_TEI0_SHIFT               (30u)
#define INTC_ICDISPR10_ERI1_SHIFT               (31u)

#define INTC_ICDISPR11_RXI1_SHIFT               (0u)
#define INTC_ICDISPR11_TXI1_SHIFT               (1u)
#define INTC_ICDISPR11_TEI1_SHIFT               (2u)
#define INTC_ICDISPR11_AVBI_DATA_SHIFT          (3u)
#define INTC_ICDISPR11_AVBI_ERROR_SHIFT         (4u)
#define INTC_ICDISPR11_AVBI_MANAGE_SHIFT        (5u)
#define INTC_ICDISPR11_AVBI_MAC_SHIFT           (6u)
#define INTC_ICDISPR11_ETHERI_SHIFT             (7u)
#define INTC_ICDISPR11_CEUI_SHIFT               (12u)
#define INTC_ICDISPR11_H2XMLB_ERRINT_SHIFT      (29u)
#define INTC_ICDISPR11_H2XIC1_ERRINT_SHIFT      (30u)
#define INTC_ICDISPR11_X2HPERI1_ERRINT_SHIFT    (31u)

#define INTC_ICDISPR12_X2HPERI2_ERRINT_SHIFT    (0u)
#define INTC_ICDISPR12_X2HPERI34_ERRINT_SHIFT   (1u)
#define INTC_ICDISPR12_X2HPERI5_ERRINT_SHIFT    (2u)
#define INTC_ICDISPR12_X2HPERI67_ERRINT_SHIFT   (3u)
#define INTC_ICDISPR12_X2HDBGR_ERRINT_SHIFT     (4u)
#define INTC_ICDISPR12_X2HBSC_ERRINT_SHIFT      (5u)
#define INTC_ICDISPR12_X2HSPI1_ERRINT_SHIFT     (6u)
#define INTC_ICDISPR12_X2HSPI2_ERRINT_SHIFT     (7u)
#define INTC_ICDISPR12_PRRI_SHIFT               (8u)
#define INTC_ICDISPR12_IFEI0_SHIFT              (9u)
#define INTC_ICDISPR12_OFFI0_SHIFT              (10u)
#define INTC_ICDISPR12_PFVEI0_SHIFT             (11u)
#define INTC_ICDISPR12_IFEI1_SHIFT              (12u)
#define INTC_ICDISPR12_OFFI1_SHIFT              (13u)
#define INTC_ICDISPR12_PFVEI1_SHIFT             (14u)

#define INTC_ICDISPR13_TINT0_SHIFT              (0u)
#define INTC_ICDISPR13_TINT1_SHIFT              (1u)
#define INTC_ICDISPR13_TINT2_SHIFT              (2u)
#define INTC_ICDISPR13_TINT3_SHIFT              (3u)
#define INTC_ICDISPR13_TINT4_SHIFT              (4u)
#define INTC_ICDISPR13_TINT5_SHIFT              (5u)
#define INTC_ICDISPR13_TINT6_SHIFT              (6u)
#define INTC_ICDISPR13_TINT7_SHIFT              (7u)
#define INTC_ICDISPR13_TINT8_SHIFT              (8u)
#define INTC_ICDISPR13_TINT9_SHIFT              (9u)
#define INTC_ICDISPR13_TINT10_SHIFT             (10u)
#define INTC_ICDISPR13_TINT11_SHIFT             (11u)
#define INTC_ICDISPR13_TINT12_SHIFT             (12u)
#define INTC_ICDISPR13_TINT13_SHIFT             (13u)
#define INTC_ICDISPR13_TINT14_SHIFT             (14u)
#define INTC_ICDISPR13_TINT15_SHIFT             (15u)
#define INTC_ICDISPR13_TINT16_SHIFT             (16u)
#define INTC_ICDISPR13_TINT17_SHIFT             (17u)
#define INTC_ICDISPR13_TINT18_SHIFT             (18u)
#define INTC_ICDISPR13_TINT19_SHIFT             (19u)
#define INTC_ICDISPR13_TINT20_SHIFT             (20u)
#define INTC_ICDISPR13_TINT21_SHIFT             (21u)
#define INTC_ICDISPR13_TINT22_SHIFT             (22u)
#define INTC_ICDISPR13_TINT23_SHIFT             (23u)
#define INTC_ICDISPR13_TINT24_SHIFT             (24u)
#define INTC_ICDISPR13_TINT25_SHIFT             (25u)
#define INTC_ICDISPR13_TINT26_SHIFT             (26u)
#define INTC_ICDISPR13_TINT27_SHIFT             (27u)
#define INTC_ICDISPR13_TINT28_SHIFT             (28u)
#define INTC_ICDISPR13_TINT29_SHIFT             (29u)
#define INTC_ICDISPR13_TINT30_SHIFT             (30u)
#define INTC_ICDISPR13_TINT31_SHIFT             (31u)

#define INTC_ICDISPR14_TINT32_SHIFT             (0u)
#define INTC_ICDISPR14_TINT33_SHIFT             (1u)
#define INTC_ICDISPR14_TINT34_SHIFT             (2u)
#define INTC_ICDISPR14_TINT35_SHIFT             (3u)
#define INTC_ICDISPR14_TINT36_SHIFT             (4u)
#define INTC_ICDISPR14_TINT37_SHIFT             (5u)
#define INTC_ICDISPR14_TINT38_SHIFT             (6u)
#define INTC_ICDISPR14_TINT39_SHIFT             (7u)
#define INTC_ICDISPR14_TINT40_SHIFT             (8u)
#define INTC_ICDISPR14_TINT41_SHIFT             (9u)
#define INTC_ICDISPR14_TINT42_SHIFT             (10u)
#define INTC_ICDISPR14_TINT43_SHIFT             (11u)
#define INTC_ICDISPR14_TINT44_SHIFT             (12u)
#define INTC_ICDISPR14_TINT45_SHIFT             (13u)
#define INTC_ICDISPR14_TINT46_SHIFT             (14u)
#define INTC_ICDISPR14_TINT47_SHIFT             (15u)
#define INTC_ICDISPR14_TINT48_SHIFT             (16u)
#define INTC_ICDISPR14_TINT49_SHIFT             (17u)
#define INTC_ICDISPR14_TINT50_SHIFT             (18u)
#define INTC_ICDISPR14_TINT51_SHIFT             (19u)
#define INTC_ICDISPR14_TINT52_SHIFT             (20u)
#define INTC_ICDISPR14_TINT53_SHIFT             (21u)
#define INTC_ICDISPR14_TINT54_SHIFT             (22u)
#define INTC_ICDISPR14_TINT55_SHIFT             (23u)
#define INTC_ICDISPR14_TINT56_SHIFT             (24u)
#define INTC_ICDISPR14_TINT57_SHIFT             (25u)
#define INTC_ICDISPR14_TINT58_SHIFT             (26u)
#define INTC_ICDISPR14_TINT59_SHIFT             (27u)
#define INTC_ICDISPR14_TINT60_SHIFT             (28u)
#define INTC_ICDISPR14_TINT61_SHIFT             (29u)
#define INTC_ICDISPR14_TINT62_SHIFT             (30u)
#define INTC_ICDISPR14_TINT63_SHIFT             (31u)

#define INTC_ICDISPR15_TINT64_SHIFT             (0u)
#define INTC_ICDISPR15_TINT65_SHIFT             (1u)
#define INTC_ICDISPR15_TINT66_SHIFT             (2u)
#define INTC_ICDISPR15_TINT67_SHIFT             (3u)
#define INTC_ICDISPR15_TINT68_SHIFT             (4u)
#define INTC_ICDISPR15_TINT69_SHIFT             (5u)
#define INTC_ICDISPR15_TINT70_SHIFT             (6u)
#define INTC_ICDISPR15_TINT71_SHIFT             (7u)
#define INTC_ICDISPR15_TINT72_SHIFT             (8u)
#define INTC_ICDISPR15_TINT73_SHIFT             (9u)
#define INTC_ICDISPR15_TINT74_SHIFT             (10u)
#define INTC_ICDISPR15_TINT75_SHIFT             (11u)
#define INTC_ICDISPR15_TINT76_SHIFT             (12u)
#define INTC_ICDISPR15_TINT77_SHIFT             (13u)
#define INTC_ICDISPR15_TINT78_SHIFT             (14u)
#define INTC_ICDISPR15_TINT79_SHIFT             (15u)
#define INTC_ICDISPR15_TINT80_SHIFT             (16u)
#define INTC_ICDISPR15_TINT81_SHIFT             (17u)
#define INTC_ICDISPR15_TINT82_SHIFT             (18u)
#define INTC_ICDISPR15_TINT83_SHIFT             (19u)
#define INTC_ICDISPR15_TINT84_SHIFT             (20u)
#define INTC_ICDISPR15_TINT85_SHIFT             (21u)
#define INTC_ICDISPR15_TINT86_SHIFT             (22u)
#define INTC_ICDISPR15_TINT87_SHIFT             (23u)
#define INTC_ICDISPR15_TINT88_SHIFT             (24u)
#define INTC_ICDISPR15_TINT89_SHIFT             (25u)
#define INTC_ICDISPR15_TINT90_SHIFT             (26u)
#define INTC_ICDISPR15_TINT91_SHIFT             (27u)
#define INTC_ICDISPR15_TINT92_SHIFT             (28u)
#define INTC_ICDISPR15_TINT93_SHIFT             (29u)
#define INTC_ICDISPR15_TINT94_SHIFT             (30u)
#define INTC_ICDISPR15_TINT95_SHIFT             (31u)

#define INTC_ICDISPR16_TINT96_SHIFT             (0u)
#define INTC_ICDISPR16_TINT97_SHIFT             (1u)
#define INTC_ICDISPR16_TINT98_SHIFT             (2u)
#define INTC_ICDISPR16_TINT99_SHIFT             (3u)
#define INTC_ICDISPR16_TINT100_SHIFT            (4u)
#define INTC_ICDISPR16_TINT101_SHIFT            (5u)
#define INTC_ICDISPR16_TINT102_SHIFT            (6u)
#define INTC_ICDISPR16_TINT103_SHIFT            (7u)
#define INTC_ICDISPR16_TINT104_SHIFT            (8u)
#define INTC_ICDISPR16_TINT105_SHIFT            (9u)
#define INTC_ICDISPR16_TINT106_SHIFT            (10u)
#define INTC_ICDISPR16_TINT107_SHIFT            (11u)
#define INTC_ICDISPR16_TINT108_SHIFT            (12u)
#define INTC_ICDISPR16_TINT109_SHIFT            (13u)
#define INTC_ICDISPR16_TINT110_SHIFT            (14u)
#define INTC_ICDISPR16_TINT111_SHIFT            (15u)
#define INTC_ICDISPR16_TINT112_SHIFT            (16u)
#define INTC_ICDISPR16_TINT113_SHIFT            (17u)
#define INTC_ICDISPR16_TINT114_SHIFT            (18u)
#define INTC_ICDISPR16_TINT115_SHIFT            (19u)
#define INTC_ICDISPR16_TINT116_SHIFT            (20u)
#define INTC_ICDISPR16_TINT117_SHIFT            (21u)
#define INTC_ICDISPR16_TINT118_SHIFT            (22u)
#define INTC_ICDISPR16_TINT119_SHIFT            (23u)
#define INTC_ICDISPR16_TINT120_SHIFT            (24u)
#define INTC_ICDISPR16_TINT121_SHIFT            (25u)
#define INTC_ICDISPR16_TINT122_SHIFT            (26u)
#define INTC_ICDISPR16_TINT123_SHIFT            (27u)
#define INTC_ICDISPR16_TINT124_SHIFT            (28u)
#define INTC_ICDISPR16_TINT125_SHIFT            (29u)
#define INTC_ICDISPR16_TINT126_SHIFT            (30u)
#define INTC_ICDISPR16_TINT127_SHIFT            (31u)

#define INTC_ICDISPR17_TINT128_SHIFT            (0u)
#define INTC_ICDISPR17_TINT129_SHIFT            (1u)
#define INTC_ICDISPR17_TINT130_SHIFT            (2u)
#define INTC_ICDISPR17_TINT131_SHIFT            (3u)
#define INTC_ICDISPR17_TINT132_SHIFT            (4u)
#define INTC_ICDISPR17_TINT133_SHIFT            (5u)
#define INTC_ICDISPR17_TINT134_SHIFT            (6u)
#define INTC_ICDISPR17_TINT135_SHIFT            (7u)
#define INTC_ICDISPR17_TINT136_SHIFT            (8u)
#define INTC_ICDISPR17_TINT137_SHIFT            (9u)
#define INTC_ICDISPR17_TINT138_SHIFT            (10u)
#define INTC_ICDISPR17_TINT139_SHIFT            (11u)
#define INTC_ICDISPR17_TINT140_SHIFT            (12u)
#define INTC_ICDISPR17_TINT141_SHIFT            (13u)
#define INTC_ICDISPR17_TINT142_SHIFT            (14u)
#define INTC_ICDISPR17_TINT143_SHIFT            (15u)
#define INTC_ICDISPR17_TINT144_SHIFT            (16u)
#define INTC_ICDISPR17_TINT145_SHIFT            (17u)
#define INTC_ICDISPR17_TINT146_SHIFT            (18u)
#define INTC_ICDISPR17_TINT147_SHIFT            (19u)
#define INTC_ICDISPR17_TINT148_SHIFT            (20u)
#define INTC_ICDISPR17_TINT149_SHIFT            (21u)
#define INTC_ICDISPR17_TINT150_SHIFT            (22u)
#define INTC_ICDISPR17_TINT151_SHIFT            (23u)
#define INTC_ICDISPR17_TINT152_SHIFT            (24u)
#define INTC_ICDISPR17_TINT153_SHIFT            (25u)
#define INTC_ICDISPR17_TINT154_SHIFT            (26u)
#define INTC_ICDISPR17_TINT155_SHIFT            (27u)
#define INTC_ICDISPR17_TINT156_SHIFT            (28u)
#define INTC_ICDISPR17_TINT157_SHIFT            (29u)
#define INTC_ICDISPR17_TINT158_SHIFT            (30u)
#define INTC_ICDISPR17_TINT159_SHIFT            (31u)

#define INTC_ICDISPR18_TINT160_SHIFT            (0u)
#define INTC_ICDISPR18_TINT161_SHIFT            (1u)
#define INTC_ICDISPR18_TINT162_SHIFT            (2u)
#define INTC_ICDISPR18_TINT163_SHIFT            (3u)
#define INTC_ICDISPR18_TINT164_SHIFT            (4u)
#define INTC_ICDISPR18_TINT165_SHIFT            (5u)
#define INTC_ICDISPR18_TINT166_SHIFT            (6u)
#define INTC_ICDISPR18_TINT167_SHIFT            (7u)
#define INTC_ICDISPR18_TINT168_SHIFT            (8u)
#define INTC_ICDISPR18_TINT169_SHIFT            (9u)
#define INTC_ICDISPR18_TINT170_SHIFT            (10u)

#define INTC_ICDICPR0_SW0_SHIFT                 (0u)
#define INTC_ICDICPR0_SW1_SHIFT                 (1u)
#define INTC_ICDICPR0_SW2_SHIFT                 (2u)
#define INTC_ICDICPR0_SW3_SHIFT                 (3u)
#define INTC_ICDICPR0_SW4_SHIFT                 (4u)
#define INTC_ICDICPR0_SW5_SHIFT                 (5u)
#define INTC_ICDICPR0_SW6_SHIFT                 (6u)
#define INTC_ICDICPR0_SW7_SHIFT                 (7u)
#define INTC_ICDICPR0_SW8_SHIFT                 (8u)
#define INTC_ICDICPR0_SW9_SHIFT                 (9u)
#define INTC_ICDICPR0_SW10_SHIFT                (10u)
#define INTC_ICDICPR0_SW11_SHIFT                (11u)
#define INTC_ICDICPR0_SW12_SHIFT                (12u)
#define INTC_ICDICPR0_SW13_SHIFT                (13u)
#define INTC_ICDICPR0_SW14_SHIFT                (14u)
#define INTC_ICDICPR0_SW15_SHIFT                (15u)
#define INTC_ICDICPR0_PMUIRQ0_SHIFT             (16u)
#define INTC_ICDICPR0_COMMRX0_SHIFT             (17u)
#define INTC_ICDICPR0_COMMTX0_SHIFT             (18u)
#define INTC_ICDICPR0_CTIIRQ0_SHIFT             (19u)

#define INTC_ICDICPR1_IRQ0_SHIFT                (0u)
#define INTC_ICDICPR1_IRQ1_SHIFT                (1u)
#define INTC_ICDICPR1_IRQ2_SHIFT                (2u)
#define INTC_ICDICPR1_IRQ3_SHIFT                (3u)
#define INTC_ICDICPR1_IRQ4_SHIFT                (4u)
#define INTC_ICDICPR1_IRQ5_SHIFT                (5u)
#define INTC_ICDICPR1_IRQ6_SHIFT                (6u)
#define INTC_ICDICPR1_IRQ7_SHIFT                (7u)
#define INTC_ICDICPR1_PL310ERR_SHIFT            (8u)
#define INTC_ICDICPR1_DMAINT0_SHIFT             (9u)
#define INTC_ICDICPR1_DMAINT1_SHIFT             (10u)
#define INTC_ICDICPR1_DMAINT2_SHIFT             (11u)
#define INTC_ICDICPR1_DMAINT3_SHIFT             (12u)
#define INTC_ICDICPR1_DMAINT4_SHIFT             (13u)
#define INTC_ICDICPR1_DMAINT5_SHIFT             (14u)
#define INTC_ICDICPR1_DMAINT6_SHIFT             (15u)
#define INTC_ICDICPR1_DMAINT7_SHIFT             (16u)
#define INTC_ICDICPR1_DMAINT8_SHIFT             (17u)
#define INTC_ICDICPR1_DMAINT9_SHIFT             (18u)
#define INTC_ICDICPR1_DMAINT10_SHIFT            (19u)
#define INTC_ICDICPR1_DMAINT11_SHIFT            (20u)
#define INTC_ICDICPR1_DMAINT12_SHIFT            (21u)
#define INTC_ICDICPR1_DMAINT13_SHIFT            (22u)
#define INTC_ICDICPR1_DMAINT14_SHIFT            (23u)
#define INTC_ICDICPR1_DMAINT15_SHIFT            (24u)
#define INTC_ICDICPR1_DMAERR_SHIFT              (25u)

#define INTC_ICDICPR2_USBI0_SHIFT               (9u)
#define INTC_ICDICPR2_USBI1_SHIFT               (10u)
#define INTC_ICDICPR2_S0_VI_VSYNC0_SHIFT        (11u)
#define INTC_ICDICPR2_S0_LO_VSYNC0_SHIFT        (12u)
#define INTC_ICDICPR2_S0_VSYNCERR0_SHIFT        (13u)
#define INTC_ICDICPR2_GR3_VLINE0_SHIFT          (14u)
#define INTC_ICDICPR2_S0_VFIELD0_SHIFT          (15u)
#define INTC_ICDICPR2_IV1_VBUFERR0_SHIFT        (16u)
#define INTC_ICDICPR2_IV3_VBUFERR0_SHIFT        (17u)
#define INTC_ICDICPR2_IV5_VBUFERR0_SHIFT        (18u)
#define INTC_ICDICPR2_IV6_VBUFERR0_SHIFT        (19u)
#define INTC_ICDICPR2_S0_WLINE0_SHIFT           (20u)
#define INTC_ICDICPR2_S1_VI_VSYNC0_SHIFT        (21u)
#define INTC_ICDICPR2_S1_LO_VSYNC0_SHIFT        (22u)
#define INTC_ICDICPR2_S1_VSYNCERR0_SHIFT        (23u)
#define INTC_ICDICPR2_S1_VFIELD0_SHIFT          (24u)
#define INTC_ICDICPR2_IV2_VBUFERR0_SHIFT        (25u)
#define INTC_ICDICPR2_IV4_VBUFERR0_SHIFT        (26u)
#define INTC_ICDICPR2_S1_WLINE0_SHIFT           (27u)
#define INTC_ICDICPR2_OIR_VI_VSYNC0_SHIFT       (28u)
#define INTC_ICDICPR2_OIR_LO_VSYNC0_SHIFT       (29u)
#define INTC_ICDICPR2_OIR_VSYNCERR0_SHIFT       (30u)
#define INTC_ICDICPR2_OIR_VFIELD0_SHIFT         (31u)

#define INTC_ICDICPR3_IV7_VBUFERR0_SHIFT        (0u)
#define INTC_ICDICPR3_IV8_VBUFERR0_SHIFT        (1u)
#define INTC_ICDICPR3_OIR_WLINE0_SHIFT          (2u)
#define INTC_ICDICPR3_S0_VI_VSYNC1_SHIFT        (3u)
#define INTC_ICDICPR3_S0_LO_VSYNC1_SHIFT        (4u)
#define INTC_ICDICPR3_S0_VSYNCERR1_SHIFT        (5u)
#define INTC_ICDICPR3_GR3_VLINE1_SHIFT          (6u)
#define INTC_ICDICPR3_S0_VFIELD1_SHIFT          (7u)
#define INTC_ICDICPR3_IV1_VBUFERR1_SHIFT        (8u)
#define INTC_ICDICPR3_IV3_VBUFERR1_SHIFT        (9u)
#define INTC_ICDICPR3_IV5_VBUFERR1_SHIFT        (10u)
#define INTC_ICDICPR3_IV6_VBUFERR1_SHIFT        (11u)
#define INTC_ICDICPR3_S0_WLINE1_SHIFT           (12u)
#define INTC_ICDICPR3_S1_VI_VSYNC1_SHIFT        (13u)
#define INTC_ICDICPR3_S1_LO_VSYNC1_SHIFT        (14u)
#define INTC_ICDICPR3_S1_VSYNCERR1_SHIFT        (15u)
#define INTC_ICDICPR3_S1_VFIELD1_SHIFT          (16u)
#define INTC_ICDICPR3_IV2_VBUFERR1_SHIFT        (17u)
#define INTC_ICDICPR3_IV4_VBUFERR1_SHIFT        (18u)
#define INTC_ICDICPR3_S1_WLINE1_SHIFT           (19u)
#define INTC_ICDICPR3_OIR_VI_VSYNC1_SHIFT       (20u)
#define INTC_ICDICPR3_OIR_LO_VSYNC1_SHIFT       (21u)
#define INTC_ICDICPR3_OIR_VLINE1_SHIFT          (22u)
#define INTC_ICDICPR3_OIR_VFIELD1_SHIFT         (23u)
#define INTC_ICDICPR3_IV7_VBUFERR1_SHIFT        (24u)
#define INTC_ICDICPR3_IV8_VBUFERR1_SHIFT        (25u)
#define INTC_ICDICPR3_OIR_WLINE1_SHIFT          (26u)
#define INTC_ICDICPR3_IMRDI_SHIFT               (27u)
#define INTC_ICDICPR3_IMR2I0_SHIFT              (28u)
#define INTC_ICDICPR3_IMR2I1_SHIFT              (29u)
#define INTC_ICDICPR3_JEDI_SHIFT                (30u)
#define INTC_ICDICPR3_JDTI_SHIFT                (31u)

#define INTC_ICDICPR4_CMP0_SHIFT                (0u)
#define INTC_ICDICPR4_CMP1_SHIFT                (1u)
#define INTC_ICDICPR4_INT0_SHIFT                (2u)
#define INTC_ICDICPR4_INT1_SHIFT                (3u)
#define INTC_ICDICPR4_INT2_SHIFT                (4u)
#define INTC_ICDICPR4_INT3_SHIFT                (5u)
#define INTC_ICDICPR4_OSTM0TINT_SHIFT           (6u)
#define INTC_ICDICPR4_OSTM1TINT_SHIFT           (7u)
#define INTC_ICDICPR4_CMI_SHIFT                 (8u)
#define INTC_ICDICPR4_WTOUT_SHIFT               (9u)
#define INTC_ICDICPR4_ITI_SHIFT                 (10u)
#define INTC_ICDICPR4_TGI0A_SHIFT               (11u)
#define INTC_ICDICPR4_TGI0B_SHIFT               (12u)
#define INTC_ICDICPR4_TGI0C_SHIFT               (13u)
#define INTC_ICDICPR4_TGI0D_SHIFT               (14u)
#define INTC_ICDICPR4_TGI0V_SHIFT               (15u)
#define INTC_ICDICPR4_TGI0E_SHIFT               (16u)
#define INTC_ICDICPR4_TGI0F_SHIFT               (17u)
#define INTC_ICDICPR4_TGI1A_SHIFT               (18u)
#define INTC_ICDICPR4_TGI1B_SHIFT               (19u)
#define INTC_ICDICPR4_TGI1V_SHIFT               (20u)
#define INTC_ICDICPR4_TGI1U_SHIFT               (21u)
#define INTC_ICDICPR4_TGI2A_SHIFT               (22u)
#define INTC_ICDICPR4_TGI2B_SHIFT               (23u)
#define INTC_ICDICPR4_TGI2V_SHIFT               (24u)
#define INTC_ICDICPR4_TGI2U_SHIFT               (25u)
#define INTC_ICDICPR4_TGI3A_SHIFT               (26u)
#define INTC_ICDICPR4_TGI3B_SHIFT               (27u)
#define INTC_ICDICPR4_TGI3C_SHIFT               (28u)
#define INTC_ICDICPR4_TGI3D_SHIFT               (29u)
#define INTC_ICDICPR4_TGI3V_SHIFT               (30u)
#define INTC_ICDICPR4_TGI4A_SHIFT               (31u)

#define INTC_ICDICPR5_TGI4B_SHIFT               (0u)
#define INTC_ICDICPR5_TGI4C_SHIFT               (1u)
#define INTC_ICDICPR5_TGI4D_SHIFT               (2u)
#define INTC_ICDICPR5_TGI4V_SHIFT               (3u)
#define INTC_ICDICPR5_CMI1_SHIFT                (4u)
#define INTC_ICDICPR5_CMI2_SHIFT                (5u)
#define INTC_ICDICPR5_SGDEI0_SHIFT              (6u)
#define INTC_ICDICPR5_SGDEI1_SHIFT              (7u)
#define INTC_ICDICPR5_SGDEI2_SHIFT              (8u)
#define INTC_ICDICPR5_SGDEI3_SHIFT              (9u)
#define INTC_ICDICPR5_ADI_SHIFT                 (10u)
#define INTC_ICDICPR5_LMTI_SHIFT                (11u)
#define INTC_ICDICPR5_SSII0_SHIFT               (12u)
#define INTC_ICDICPR5_SSIRXI0_SHIFT             (13u)
#define INTC_ICDICPR5_SSITXI0_SHIFT             (14u)
#define INTC_ICDICPR5_SSII1_SHIFT               (15u)
#define INTC_ICDICPR5_SSIRXI1_SHIFT             (16u)
#define INTC_ICDICPR5_SSITXI1_SHIFT             (17u)
#define INTC_ICDICPR5_SSII2_SHIFT               (18u)
#define INTC_ICDICPR5_SSIRTI2_SHIFT             (19u)
#define INTC_ICDICPR5_SSII3_SHIFT               (20u)
#define INTC_ICDICPR5_SSIRXI3_SHIFT             (21u)
#define INTC_ICDICPR5_SSITXI3_SHIFT             (22u)
#define INTC_ICDICPR5_SSII4_SHIFT               (23u)
#define INTC_ICDICPR5_SSIRTI4_SHIFT             (24u)
#define INTC_ICDICPR5_SSII5_SHIFT               (25u)
#define INTC_ICDICPR5_SSIRXI5_SHIFT             (26u)
#define INTC_ICDICPR5_SSITXI5_SHIFT             (27u)
#define INTC_ICDICPR5_SPDIFI_SHIFT              (28u)
#define INTC_ICDICPR5_INTIICTEI0_SHIFT          (29u)
#define INTC_ICDICPR5_INTIICRI0_SHIFT           (30u)
#define INTC_ICDICPR5_INTIICTI0_SHIFT           (31u)

#define INTC_ICDICPR6_INTIICSPI0_SHIFT          (0u)
#define INTC_ICDICPR6_INTIICSTI0_SHIFT          (1u)
#define INTC_ICDICPR6_INTIICNAKI0_SHIFT         (2u)
#define INTC_ICDICPR6_INTIICALI0_SHIFT          (3u)
#define INTC_ICDICPR6_INTIICTMOI0_SHIFT         (4u)
#define INTC_ICDICPR6_INTIICTEI1_SHIFT          (5u)
#define INTC_ICDICPR6_INTIICRI1_SHIFT           (6u)
#define INTC_ICDICPR6_INTIICTI1_SHIFT           (7u)
#define INTC_ICDICPR6_INTIICSPI1_SHIFT          (8u)
#define INTC_ICDICPR6_INTIICSTI1_SHIFT          (9u)
#define INTC_ICDICPR6_INTIICNAKI1_SHIFT         (10u)
#define INTC_ICDICPR6_INTIICALI1_SHIFT          (11u)
#define INTC_ICDICPR6_INTIICTMOI1_SHIFT         (12u)
#define INTC_ICDICPR6_INTIICTEI2_SHIFT          (13u)
#define INTC_ICDICPR6_INTIICRI2_SHIFT           (14u)
#define INTC_ICDICPR6_INTIICTI2_SHIFT           (15u)
#define INTC_ICDICPR6_INTIICSPI2_SHIFT          (16u)
#define INTC_ICDICPR6_INTIICSTI2_SHIFT          (17u)
#define INTC_ICDICPR6_INTIICNAKI2_SHIFT         (18u)
#define INTC_ICDICPR6_INTIICALI2_SHIFT          (19u)
#define INTC_ICDICPR6_INTIICTMOI2_SHIFT         (20u)
#define INTC_ICDICPR6_INTIICTEI3_SHIFT          (21u)
#define INTC_ICDICPR6_INTIICRI3_SHIFT           (22u)
#define INTC_ICDICPR6_INTIICTI3_SHIFT           (23u)
#define INTC_ICDICPR6_INTIICSPI3_SHIFT          (24u)
#define INTC_ICDICPR6_INTIICSTI3_SHIFT          (25u)
#define INTC_ICDICPR6_INTIICNAKI3_SHIFT         (26u)
#define INTC_ICDICPR6_INTIICALI3_SHIFT          (27u)
#define INTC_ICDICPR6_INTIICTMOI3_SHIFT         (28u)
#define INTC_ICDICPR6_BRI0_SHIFT                (29u)
#define INTC_ICDICPR6_ERI0_SHIFT                (30u)
#define INTC_ICDICPR6_RXI0_SHIFT                (31u)

#define INTC_ICDICPR7_TXI0_SHIFT                (0u)
#define INTC_ICDICPR7_BRI1_SHIFT                (1u)
#define INTC_ICDICPR7_ERI1_SHIFT                (2u)
#define INTC_ICDICPR7_RXI1_SHIFT                (3u)
#define INTC_ICDICPR7_TXI1_SHIFT                (4u)
#define INTC_ICDICPR7_BRI2_SHIFT                (5u)
#define INTC_ICDICPR7_ERI2_SHIFT                (6u)
#define INTC_ICDICPR7_RXI2_SHIFT                (7u)
#define INTC_ICDICPR7_TXI2_SHIFT                (8u)
#define INTC_ICDICPR7_BRI3_SHIFT                (9u)
#define INTC_ICDICPR7_ERI3_SHIFT                (10u)
#define INTC_ICDICPR7_RXI3_SHIFT                (11u)
#define INTC_ICDICPR7_TXI3_SHIFT                (12u)
#define INTC_ICDICPR7_BRI4_SHIFT                (13u)
#define INTC_ICDICPR7_ERI4_SHIFT                (14u)
#define INTC_ICDICPR7_RXI4_SHIFT                (15u)
#define INTC_ICDICPR7_TXI4_SHIFT                (16u)
#define INTC_ICDICPR7_BRI5_SHIFT                (17u)
#define INTC_ICDICPR7_ERI5_SHIFT                (18u)
#define INTC_ICDICPR7_RXI5_SHIFT                (19u)
#define INTC_ICDICPR7_TXI5_SHIFT                (20u)
#define INTC_ICDICPR7_BRI6_SHIFT                (21u)
#define INTC_ICDICPR7_ERI6_SHIFT                (22u)
#define INTC_ICDICPR7_RXI6_SHIFT                (23u)
#define INTC_ICDICPR7_TXI6_SHIFT                (24u)
#define INTC_ICDICPR7_BRI7_SHIFT                (25u)
#define INTC_ICDICPR7_ERI7_SHIFT                (26u)
#define INTC_ICDICPR7_RXI7_SHIFT                (27u)
#define INTC_ICDICPR7_TXI7_SHIFT                (28u)
#define INTC_ICDICPR7_INTRCANGERR_SHIFT         (29u)
#define INTC_ICDICPR7_INTRCANGRECC_SHIFT        (30u)
#define INTC_ICDICPR7_INTRCAN0REC_SHIFT         (31u)

#define INTC_ICDICPR8_INTRCAN0ERR_SHIFT         (0u)
#define INTC_ICDICPR8_INTRCAN0TRX_SHIFT         (1u)
#define INTC_ICDICPR8_INTRCAN1REC_SHIFT         (2u)
#define INTC_ICDICPR8_INTRCAN1ERR_SHIFT         (3u)
#define INTC_ICDICPR8_INTRCAN1TRX_SHIFT         (4u)
#define INTC_ICDICPR8_INTRCAN2REC_SHIFT         (5u)
#define INTC_ICDICPR8_INTRCAN2ERR_SHIFT         (6u)
#define INTC_ICDICPR8_INTRCAN2TRX_SHIFT         (7u)
#define INTC_ICDICPR8_INTRCAN3REC_SHIFT         (8u)
#define INTC_ICDICPR8_INTRCAN3ERR_SHIFT         (9u)
#define INTC_ICDICPR8_INTRCAN3TRX_SHIFT         (10u)
#define INTC_ICDICPR8_INTRCAN4REC_SHIFT         (11u)
#define INTC_ICDICPR8_INTRCAN4ERR_SHIFT         (12u)
#define INTC_ICDICPR8_INTRCAN4TRX_SHIFT         (13u)
#define INTC_ICDICPR8_SPEI0_SHIFT               (14u)
#define INTC_ICDICPR8_SPRI0_SHIFT               (15u)
#define INTC_ICDICPR8_SPTI0_SHIFT               (16u)
#define INTC_ICDICPR8_SPEI1_SHIFT               (17u)
#define INTC_ICDICPR8_SPRI1_SHIFT               (18u)
#define INTC_ICDICPR8_SPTI1_SHIFT               (19u)
#define INTC_ICDICPR8_SPEI2_SHIFT               (20u)
#define INTC_ICDICPR8_SPRI2_SHIFT               (21u)
#define INTC_ICDICPR8_SPTI2_SHIFT               (22u)
#define INTC_ICDICPR8_SPEI3_SHIFT               (23u)
#define INTC_ICDICPR8_SPRI3_SHIFT               (24u)
#define INTC_ICDICPR8_SPTI3_SHIFT               (25u)
#define INTC_ICDICPR8_SPEI4_SHIFT               (26u)
#define INTC_ICDICPR8_SPRI4_SHIFT               (27u)
#define INTC_ICDICPR8_SPTI4_SHIFT               (28u)
#define INTC_ICDICPR8_IEBBTD_SHIFT              (29u)
#define INTC_ICDICPR8_IEBBTERR_SHIFT            (30u)
#define INTC_ICDICPR8_IEBBTSTA_SHIFT            (31u)

#define INTC_ICDICPR9_IEBBTV_SHIFT              (0u)
#define INTC_ICDICPR9_ISY_SHIFT                 (1u)
#define INTC_ICDICPR9_IERR_SHIFT                (2u)
#define INTC_ICDICPR9_ITARG_SHIFT               (3u)
#define INTC_ICDICPR9_ISEC_SHIFT                (4u)
#define INTC_ICDICPR9_IBUF_SHIFT                (5u)
#define INTC_ICDICPR9_IREADY_SHIFT              (6u)
#define INTC_ICDICPR9_FLSTE_SHIFT               (7u)
#define INTC_ICDICPR9_FLTENDI_SHIFT             (8u)
#define INTC_ICDICPR9_FLTREQ0I_SHIFT            (9u)
#define INTC_ICDICPR9_FLTREQ1I_SHIFT            (10u)
#define INTC_ICDICPR9_MMC0_SHIFT                (11u)
#define INTC_ICDICPR9_MMC1_SHIFT                (12u)
#define INTC_ICDICPR9_MMC2_SHIFT                (13u)
#define INTC_ICDICPR9_SDHI0_3_SHIFT             (14u)
#define INTC_ICDICPR9_SDHI0_0_SHIFT             (15u)
#define INTC_ICDICPR9_SDHI0_1_SHIFT             (16u)
#define INTC_ICDICPR9_SDHI1_3_SHIFT             (17u)
#define INTC_ICDICPR9_SDHI1_0_SHIFT             (18u)
#define INTC_ICDICPR9_SDHI1_1_SHIFT             (19u)
#define INTC_ICDICPR9_ARM_SHIFT                 (20u)
#define INTC_ICDICPR9_PRD_SHIFT                 (21u)
#define INTC_ICDICPR9_CUP_SHIFT                 (22u)
#define INTC_ICDICPR9_SCUAI0_SHIFT              (23u)
#define INTC_ICDICPR9_SCUAI1_SHIFT              (24u)
#define INTC_ICDICPR9_SCUFDI0_SHIFT             (25u)
#define INTC_ICDICPR9_SCUFDI1_SHIFT             (26u)
#define INTC_ICDICPR9_SCUFDI2_SHIFT             (27u)
#define INTC_ICDICPR9_SCUFDI3_SHIFT             (28u)
#define INTC_ICDICPR9_SCUFUI0_SHIFT             (29u)
#define INTC_ICDICPR9_SCUFUI1_SHIFT             (30u)
#define INTC_ICDICPR9_SCUFUI2_SHIFT             (31u)

#define INTC_ICDICPR10_SCUFUI3_SHIFT            (0u)
#define INTC_ICDICPR10_SCUDVI0_SHIFT            (1u)
#define INTC_ICDICPR10_SCUDVI1_SHIFT            (2u)
#define INTC_ICDICPR10_SCUDVI2_SHIFT            (3u)
#define INTC_ICDICPR10_SCUDVI3_SHIFT            (4u)
#define INTC_ICDICPR10_MLB_CINT_SHIFT           (5u)
#define INTC_ICDICPR10_MLB_SINT_SHIFT           (6u)
#define INTC_ICDICPR10_DRC0_SHIFT               (7u)
#define INTC_ICDICPR10_DRC1_SHIFT               (8u)
#define INTC_ICDICPR10_LINI0_INT_T_SHIFT        (11u)
#define INTC_ICDICPR10_LINI0_INT_R_SHIFT        (12u)
#define INTC_ICDICPR10_LINI0_INT_S_SHIFT        (13u)
#define INTC_ICDICPR10_LINI0_INT_M_SHIFT        (14u)
#define INTC_ICDICPR10_LINI1_INT_T_SHIFT        (15u)
#define INTC_ICDICPR10_LINI1_INT_R_SHIFT        (16u)
#define INTC_ICDICPR10_LINI1_INT_S_SHIFT        (17u)
#define INTC_ICDICPR10_LINI1_INT_M_SHIFT        (18u)
#define INTC_ICDICPR10_ERI0_SHIFT               (27u)
#define INTC_ICDICPR10_RXI0_SHIFT               (28u)
#define INTC_ICDICPR10_TXI0_SHIFT               (29u)
#define INTC_ICDICPR10_TEI0_SHIFT               (30u)
#define INTC_ICDICPR10_ERI1_SHIFT               (31u)

#define INTC_ICDICPR11_RXI1_SHIFT               (0u)
#define INTC_ICDICPR11_TXI1_SHIFT               (1u)
#define INTC_ICDICPR11_TEI1_SHIFT               (2u)
#define INTC_ICDICPR11_AVBI_DATA_SHIFT          (3u)
#define INTC_ICDICPR11_AVBI_ERROR_SHIFT         (4u)
#define INTC_ICDICPR11_AVBI_MANAGE_SHIFT        (5u)
#define INTC_ICDICPR11_AVBI_MAC_SHIFT           (6u)
#define INTC_ICDICPR11_ETHERI_SHIFT             (7u)
#define INTC_ICDICPR11_CEUI_SHIFT               (12u)
#define INTC_ICDICPR11_H2XMLB_ERRINT_SHIFT      (29u)
#define INTC_ICDICPR11_H2XIC1_ERRINT_SHIFT      (30u)
#define INTC_ICDICPR11_X2HPERI1_ERRINT_SHIFT    (31u)

#define INTC_ICDICPR12_X2HPERI2_ERRINT_SHIFT    (0u)
#define INTC_ICDICPR12_X2HPERI34_ERRINT_SHIFT   (1u)
#define INTC_ICDICPR12_X2HPERI5_ERRINT_SHIFT    (2u)
#define INTC_ICDICPR12_X2HPERI67_ERRINT_SHIFT   (3u)
#define INTC_ICDICPR12_X2HDBGR_ERRINT_SHIFT     (4u)
#define INTC_ICDICPR12_X2HBSC_ERRINT_SHIFT      (5u)
#define INTC_ICDICPR12_X2HSPI1_ERRINT_SHIFT     (6u)
#define INTC_ICDICPR12_X2HSPI2_ERRINT_SHIFT     (7u)
#define INTC_ICDICPR12_PRRI_SHIFT               (8u)
#define INTC_ICDICPR12_IFEI0_SHIFT              (9u)
#define INTC_ICDICPR12_OFFI0_SHIFT              (10u)
#define INTC_ICDICPR12_PFVEI0_SHIFT             (11u)
#define INTC_ICDICPR12_IFEI1_SHIFT              (12u)
#define INTC_ICDICPR12_OFFI1_SHIFT              (13u)
#define INTC_ICDICPR12_PFVEI1_SHIFT             (14u)

#define INTC_ICDICPR13_TINT0_SHIFT              (0u)
#define INTC_ICDICPR13_TINT1_SHIFT              (1u)
#define INTC_ICDICPR13_TINT2_SHIFT              (2u)
#define INTC_ICDICPR13_TINT3_SHIFT              (3u)
#define INTC_ICDICPR13_TINT4_SHIFT              (4u)
#define INTC_ICDICPR13_TINT5_SHIFT              (5u)
#define INTC_ICDICPR13_TINT6_SHIFT              (6u)
#define INTC_ICDICPR13_TINT7_SHIFT              (7u)
#define INTC_ICDICPR13_TINT8_SHIFT              (8u)
#define INTC_ICDICPR13_TINT9_SHIFT              (9u)
#define INTC_ICDICPR13_TINT10_SHIFT             (10u)
#define INTC_ICDICPR13_TINT11_SHIFT             (11u)
#define INTC_ICDICPR13_TINT12_SHIFT             (12u)
#define INTC_ICDICPR13_TINT13_SHIFT             (13u)
#define INTC_ICDICPR13_TINT14_SHIFT             (14u)
#define INTC_ICDICPR13_TINT15_SHIFT             (15u)
#define INTC_ICDICPR13_TINT16_SHIFT             (16u)
#define INTC_ICDICPR13_TINT17_SHIFT             (17u)
#define INTC_ICDICPR13_TINT18_SHIFT             (18u)
#define INTC_ICDICPR13_TINT19_SHIFT             (19u)
#define INTC_ICDICPR13_TINT20_SHIFT             (20u)
#define INTC_ICDICPR13_TINT21_SHIFT             (21u)
#define INTC_ICDICPR13_TINT22_SHIFT             (22u)
#define INTC_ICDICPR13_TINT23_SHIFT             (23u)
#define INTC_ICDICPR13_TINT24_SHIFT             (24u)
#define INTC_ICDICPR13_TINT25_SHIFT             (25u)
#define INTC_ICDICPR13_TINT26_SHIFT             (26u)
#define INTC_ICDICPR13_TINT27_SHIFT             (27u)
#define INTC_ICDICPR13_TINT28_SHIFT             (28u)
#define INTC_ICDICPR13_TINT29_SHIFT             (29u)
#define INTC_ICDICPR13_TINT30_SHIFT             (30u)
#define INTC_ICDICPR13_TINT31_SHIFT             (31u)

#define INTC_ICDICPR14_TINT32_SHIFT             (0u)
#define INTC_ICDICPR14_TINT33_SHIFT             (1u)
#define INTC_ICDICPR14_TINT34_SHIFT             (2u)
#define INTC_ICDICPR14_TINT35_SHIFT             (3u)
#define INTC_ICDICPR14_TINT36_SHIFT             (4u)
#define INTC_ICDICPR14_TINT37_SHIFT             (5u)
#define INTC_ICDICPR14_TINT38_SHIFT             (6u)
#define INTC_ICDICPR14_TINT39_SHIFT             (7u)
#define INTC_ICDICPR14_TINT40_SHIFT             (8u)
#define INTC_ICDICPR14_TINT41_SHIFT             (9u)
#define INTC_ICDICPR14_TINT42_SHIFT             (10u)
#define INTC_ICDICPR14_TINT43_SHIFT             (11u)
#define INTC_ICDICPR14_TINT44_SHIFT             (12u)
#define INTC_ICDICPR14_TINT45_SHIFT             (13u)
#define INTC_ICDICPR14_TINT46_SHIFT             (14u)
#define INTC_ICDICPR14_TINT47_SHIFT             (15u)
#define INTC_ICDICPR14_TINT48_SHIFT             (16u)
#define INTC_ICDICPR14_TINT49_SHIFT             (17u)
#define INTC_ICDICPR14_TINT50_SHIFT             (18u)
#define INTC_ICDICPR14_TINT51_SHIFT             (19u)
#define INTC_ICDICPR14_TINT52_SHIFT             (20u)
#define INTC_ICDICPR14_TINT53_SHIFT             (21u)
#define INTC_ICDICPR14_TINT54_SHIFT             (22u)
#define INTC_ICDICPR14_TINT55_SHIFT             (23u)
#define INTC_ICDICPR14_TINT56_SHIFT             (24u)
#define INTC_ICDICPR14_TINT57_SHIFT             (25u)
#define INTC_ICDICPR14_TINT58_SHIFT             (26u)
#define INTC_ICDICPR14_TINT59_SHIFT             (27u)
#define INTC_ICDICPR14_TINT60_SHIFT             (28u)
#define INTC_ICDICPR14_TINT61_SHIFT             (29u)
#define INTC_ICDICPR14_TINT62_SHIFT             (30u)
#define INTC_ICDICPR14_TINT63_SHIFT             (31u)

#define INTC_ICDICPR15_TINT64_SHIFT             (0u)
#define INTC_ICDICPR15_TINT65_SHIFT             (1u)
#define INTC_ICDICPR15_TINT66_SHIFT             (2u)
#define INTC_ICDICPR15_TINT67_SHIFT             (3u)
#define INTC_ICDICPR15_TINT68_SHIFT             (4u)
#define INTC_ICDICPR15_TINT69_SHIFT             (5u)
#define INTC_ICDICPR15_TINT70_SHIFT             (6u)
#define INTC_ICDICPR15_TINT71_SHIFT             (7u)
#define INTC_ICDICPR15_TINT72_SHIFT             (8u)
#define INTC_ICDICPR15_TINT73_SHIFT             (9u)
#define INTC_ICDICPR15_TINT74_SHIFT             (10u)
#define INTC_ICDICPR15_TINT75_SHIFT             (11u)
#define INTC_ICDICPR15_TINT76_SHIFT             (12u)
#define INTC_ICDICPR15_TINT77_SHIFT             (13u)
#define INTC_ICDICPR15_TINT78_SHIFT             (14u)
#define INTC_ICDICPR15_TINT79_SHIFT             (15u)
#define INTC_ICDICPR15_TINT80_SHIFT             (16u)
#define INTC_ICDICPR15_TINT81_SHIFT             (17u)
#define INTC_ICDICPR15_TINT82_SHIFT             (18u)
#define INTC_ICDICPR15_TINT83_SHIFT             (19u)
#define INTC_ICDICPR15_TINT84_SHIFT             (20u)
#define INTC_ICDICPR15_TINT85_SHIFT             (21u)
#define INTC_ICDICPR15_TINT86_SHIFT             (22u)
#define INTC_ICDICPR15_TINT87_SHIFT             (23u)
#define INTC_ICDICPR15_TINT88_SHIFT             (24u)
#define INTC_ICDICPR15_TINT89_SHIFT             (25u)
#define INTC_ICDICPR15_TINT90_SHIFT             (26u)
#define INTC_ICDICPR15_TINT91_SHIFT             (27u)
#define INTC_ICDICPR15_TINT92_SHIFT             (28u)
#define INTC_ICDICPR15_TINT93_SHIFT             (29u)
#define INTC_ICDICPR15_TINT94_SHIFT             (30u)
#define INTC_ICDICPR15_TINT95_SHIFT             (31u)

#define INTC_ICDICPR16_TINT96_SHIFT             (0u)
#define INTC_ICDICPR16_TINT97_SHIFT             (1u)
#define INTC_ICDICPR16_TINT98_SHIFT             (2u)
#define INTC_ICDICPR16_TINT99_SHIFT             (3u)
#define INTC_ICDICPR16_TINT100_SHIFT            (4u)
#define INTC_ICDICPR16_TINT101_SHIFT            (5u)
#define INTC_ICDICPR16_TINT102_SHIFT            (6u)
#define INTC_ICDICPR16_TINT103_SHIFT            (7u)
#define INTC_ICDICPR16_TINT104_SHIFT            (8u)
#define INTC_ICDICPR16_TINT105_SHIFT            (9u)
#define INTC_ICDICPR16_TINT106_SHIFT            (10u)
#define INTC_ICDICPR16_TINT107_SHIFT            (11u)
#define INTC_ICDICPR16_TINT108_SHIFT            (12u)
#define INTC_ICDICPR16_TINT109_SHIFT            (13u)
#define INTC_ICDICPR16_TINT110_SHIFT            (14u)
#define INTC_ICDICPR16_TINT111_SHIFT            (15u)
#define INTC_ICDICPR16_TINT112_SHIFT            (16u)
#define INTC_ICDICPR16_TINT113_SHIFT            (17u)
#define INTC_ICDICPR16_TINT114_SHIFT            (18u)
#define INTC_ICDICPR16_TINT115_SHIFT            (19u)
#define INTC_ICDICPR16_TINT116_SHIFT            (20u)
#define INTC_ICDICPR16_TINT117_SHIFT            (21u)
#define INTC_ICDICPR16_TINT118_SHIFT            (22u)
#define INTC_ICDICPR16_TINT119_SHIFT            (23u)
#define INTC_ICDICPR16_TINT120_SHIFT            (24u)
#define INTC_ICDICPR16_TINT121_SHIFT            (25u)
#define INTC_ICDICPR16_TINT122_SHIFT            (26u)
#define INTC_ICDICPR16_TINT123_SHIFT            (27u)
#define INTC_ICDICPR16_TINT124_SHIFT            (28u)
#define INTC_ICDICPR16_TINT125_SHIFT            (29u)
#define INTC_ICDICPR16_TINT126_SHIFT            (30u)
#define INTC_ICDICPR16_TINT127_SHIFT            (31u)

#define INTC_ICDICPR17_TINT128_SHIFT            (0u)
#define INTC_ICDICPR17_TINT129_SHIFT            (1u)
#define INTC_ICDICPR17_TINT130_SHIFT            (2u)
#define INTC_ICDICPR17_TINT131_SHIFT            (3u)
#define INTC_ICDICPR17_TINT132_SHIFT            (4u)
#define INTC_ICDICPR17_TINT133_SHIFT            (5u)
#define INTC_ICDICPR17_TINT134_SHIFT            (6u)
#define INTC_ICDICPR17_TINT135_SHIFT            (7u)
#define INTC_ICDICPR17_TINT136_SHIFT            (8u)
#define INTC_ICDICPR17_TINT137_SHIFT            (9u)
#define INTC_ICDICPR17_TINT138_SHIFT            (10u)
#define INTC_ICDICPR17_TINT139_SHIFT            (11u)
#define INTC_ICDICPR17_TINT140_SHIFT            (12u)
#define INTC_ICDICPR17_TINT141_SHIFT            (13u)
#define INTC_ICDICPR17_TINT142_SHIFT            (14u)
#define INTC_ICDICPR17_TINT143_SHIFT            (15u)
#define INTC_ICDICPR17_TINT144_SHIFT            (16u)
#define INTC_ICDICPR17_TINT145_SHIFT            (17u)
#define INTC_ICDICPR17_TINT146_SHIFT            (18u)
#define INTC_ICDICPR17_TINT147_SHIFT            (19u)
#define INTC_ICDICPR17_TINT148_SHIFT            (20u)
#define INTC_ICDICPR17_TINT149_SHIFT            (21u)
#define INTC_ICDICPR17_TINT150_SHIFT            (22u)
#define INTC_ICDICPR17_TINT151_SHIFT            (23u)
#define INTC_ICDICPR17_TINT152_SHIFT            (24u)
#define INTC_ICDICPR17_TINT153_SHIFT            (25u)
#define INTC_ICDICPR17_TINT154_SHIFT            (26u)
#define INTC_ICDICPR17_TINT155_SHIFT            (27u)
#define INTC_ICDICPR17_TINT156_SHIFT            (28u)
#define INTC_ICDICPR17_TINT157_SHIFT            (29u)
#define INTC_ICDICPR17_TINT158_SHIFT            (30u)
#define INTC_ICDICPR17_TINT159_SHIFT            (31u)

#define INTC_ICDICPR18_TINT160_SHIFT            (0u)
#define INTC_ICDICPR18_TINT161_SHIFT            (1u)
#define INTC_ICDICPR18_TINT162_SHIFT            (2u)
#define INTC_ICDICPR18_TINT163_SHIFT            (3u)
#define INTC_ICDICPR18_TINT164_SHIFT            (4u)
#define INTC_ICDICPR18_TINT165_SHIFT            (5u)
#define INTC_ICDICPR18_TINT166_SHIFT            (6u)
#define INTC_ICDICPR18_TINT167_SHIFT            (7u)
#define INTC_ICDICPR18_TINT168_SHIFT            (8u)
#define INTC_ICDICPR18_TINT169_SHIFT            (9u)
#define INTC_ICDICPR18_TINT170_SHIFT            (10u)

#define INTC_ICDABR0_SW0_SHIFT                  (0u)
#define INTC_ICDABR0_SW1_SHIFT                  (1u)
#define INTC_ICDABR0_SW2_SHIFT                  (2u)
#define INTC_ICDABR0_SW3_SHIFT                  (3u)
#define INTC_ICDABR0_SW4_SHIFT                  (4u)
#define INTC_ICDABR0_SW5_SHIFT                  (5u)
#define INTC_ICDABR0_SW6_SHIFT                  (6u)
#define INTC_ICDABR0_SW7_SHIFT                  (7u)
#define INTC_ICDABR0_SW8_SHIFT                  (8u)
#define INTC_ICDABR0_SW9_SHIFT                  (9u)
#define INTC_ICDABR0_SW10_SHIFT                 (10u)
#define INTC_ICDABR0_SW11_SHIFT                 (11u)
#define INTC_ICDABR0_SW12_SHIFT                 (12u)
#define INTC_ICDABR0_SW13_SHIFT                 (13u)
#define INTC_ICDABR0_SW14_SHIFT                 (14u)
#define INTC_ICDABR0_SW15_SHIFT                 (15u)
#define INTC_ICDABR0_PMUIRQ0_SHIFT              (16u)
#define INTC_ICDABR0_COMMRX0_SHIFT              (17u)
#define INTC_ICDABR0_COMMTX0_SHIFT              (18u)
#define INTC_ICDABR0_CTIIRQ0_SHIFT              (19u)

#define INTC_ICDABR1_IRQ0_SHIFT                 (0u)
#define INTC_ICDABR1_IRQ1_SHIFT                 (1u)
#define INTC_ICDABR1_IRQ2_SHIFT                 (2u)
#define INTC_ICDABR1_IRQ3_SHIFT                 (3u)
#define INTC_ICDABR1_IRQ4_SHIFT                 (4u)
#define INTC_ICDABR1_IRQ5_SHIFT                 (5u)
#define INTC_ICDABR1_IRQ6_SHIFT                 (6u)
#define INTC_ICDABR1_IRQ7_SHIFT                 (7u)
#define INTC_ICDABR1_PL310ERR_SHIFT             (8u)
#define INTC_ICDABR1_DMAINT0_SHIFT              (9u)
#define INTC_ICDABR1_DMAINT1_SHIFT              (10u)
#define INTC_ICDABR1_DMAINT2_SHIFT              (11u)
#define INTC_ICDABR1_DMAINT3_SHIFT              (12u)
#define INTC_ICDABR1_DMAINT4_SHIFT              (13u)
#define INTC_ICDABR1_DMAINT5_SHIFT              (14u)
#define INTC_ICDABR1_DMAINT6_SHIFT              (15u)
#define INTC_ICDABR1_DMAINT7_SHIFT              (16u)
#define INTC_ICDABR1_DMAINT8_SHIFT              (17u)
#define INTC_ICDABR1_DMAINT9_SHIFT              (18u)
#define INTC_ICDABR1_DMAINT10_SHIFT             (19u)
#define INTC_ICDABR1_DMAINT11_SHIFT             (20u)
#define INTC_ICDABR1_DMAINT12_SHIFT             (21u)
#define INTC_ICDABR1_DMAINT13_SHIFT             (22u)
#define INTC_ICDABR1_DMAINT14_SHIFT             (23u)
#define INTC_ICDABR1_DMAINT15_SHIFT             (24u)
#define INTC_ICDABR1_DMAERR_SHIFT               (25u)

#define INTC_ICDABR2_USBI0_SHIFT                (9u)
#define INTC_ICDABR2_USBI1_SHIFT                (10u)
#define INTC_ICDABR2_S0_VI_VSYNC0_SHIFT         (11u)
#define INTC_ICDABR2_S0_LO_VSYNC0_SHIFT         (12u)
#define INTC_ICDABR2_S0_VSYNCERR0_SHIFT         (13u)
#define INTC_ICDABR2_GR3_VLINE0_SHIFT           (14u)
#define INTC_ICDABR2_S0_VFIELD0_SHIFT           (15u)
#define INTC_ICDABR2_IV1_VBUFERR0_SHIFT         (16u)
#define INTC_ICDABR2_IV3_VBUFERR0_SHIFT         (17u)
#define INTC_ICDABR2_IV5_VBUFERR0_SHIFT         (18u)
#define INTC_ICDABR2_IV6_VBUFERR0_SHIFT         (19u)
#define INTC_ICDABR2_S0_WLINE0_SHIFT            (20u)
#define INTC_ICDABR2_S1_VI_VSYNC0_SHIFT         (21u)
#define INTC_ICDABR2_S1_LO_VSYNC0_SHIFT         (22u)
#define INTC_ICDABR2_S1_VSYNCERR0_SHIFT         (23u)
#define INTC_ICDABR2_S1_VFIELD0_SHIFT           (24u)
#define INTC_ICDABR2_IV2_VBUFERR0_SHIFT         (25u)
#define INTC_ICDABR2_IV4_VBUFERR0_SHIFT         (26u)
#define INTC_ICDABR2_S1_WLINE0_SHIFT            (27u)
#define INTC_ICDABR2_OIR_VI_VSYNC0_SHIFT        (28u)
#define INTC_ICDABR2_OIR_LO_VSYNC0_SHIFT        (29u)
#define INTC_ICDABR2_OIR_VSYNCERR0_SHIFT        (30u)
#define INTC_ICDABR2_OIR_VFIELD0_SHIFT          (31u)

#define INTC_ICDABR3_IV7_VBUFERR0_SHIFT         (0u)
#define INTC_ICDABR3_IV8_VBUFERR0_SHIFT         (1u)
#define INTC_ICDABR3_OIR_WLINE0_SHIFT           (2u)
#define INTC_ICDABR3_S0_VI_VSYNC1_SHIFT         (3u)
#define INTC_ICDABR3_S0_LO_VSYNC1_SHIFT         (4u)
#define INTC_ICDABR3_S0_VSYNCERR1_SHIFT         (5u)
#define INTC_ICDABR3_GR3_VLINE1_SHIFT           (6u)
#define INTC_ICDABR3_S0_VFIELD1_SHIFT           (7u)
#define INTC_ICDABR3_IV1_VBUFERR1_SHIFT         (8u)
#define INTC_ICDABR3_IV3_VBUFERR1_SHIFT         (9u)
#define INTC_ICDABR3_IV5_VBUFERR1_SHIFT         (10u)
#define INTC_ICDABR3_IV6_VBUFERR1_SHIFT         (11u)
#define INTC_ICDABR3_S0_WLINE1_SHIFT            (12u)
#define INTC_ICDABR3_S1_VI_VSYNC1_SHIFT         (13u)
#define INTC_ICDABR3_S1_LO_VSYNC1_SHIFT         (14u)
#define INTC_ICDABR3_S1_VSYNCERR1_SHIFT         (15u)
#define INTC_ICDABR3_S1_VFIELD1_SHIFT           (16u)
#define INTC_ICDABR3_IV2_VBUFERR1_SHIFT         (17u)
#define INTC_ICDABR3_IV4_VBUFERR1_SHIFT         (18u)
#define INTC_ICDABR3_S1_WLINE1_SHIFT            (19u)
#define INTC_ICDABR3_OIR_VI_VSYNC1_SHIFT        (20u)
#define INTC_ICDABR3_OIR_LO_VSYNC1_SHIFT        (21u)
#define INTC_ICDABR3_OIR_VLINE1_SHIFT           (22u)
#define INTC_ICDABR3_OIR_VFIELD1_SHIFT          (23u)
#define INTC_ICDABR3_IV7_VBUFERR1_SHIFT         (24u)
#define INTC_ICDABR3_IV8_VBUFERR1_SHIFT         (25u)
#define INTC_ICDABR3_OIR_WLINE1_SHIFT           (26u)
#define INTC_ICDABR3_IMRDI_SHIFT                (27u)
#define INTC_ICDABR3_IMR2I0_SHIFT               (28u)
#define INTC_ICDABR3_IMR2I1_SHIFT               (29u)
#define INTC_ICDABR3_JEDI_SHIFT                 (30u)
#define INTC_ICDABR3_JDTI_SHIFT                 (31u)

#define INTC_ICDABR4_CMP0_SHIFT                 (0u)
#define INTC_ICDABR4_CMP1_SHIFT                 (1u)
#define INTC_ICDABR4_INT0_SHIFT                 (2u)
#define INTC_ICDABR4_INT1_SHIFT                 (3u)
#define INTC_ICDABR4_INT2_SHIFT                 (4u)
#define INTC_ICDABR4_INT3_SHIFT                 (5u)
#define INTC_ICDABR4_OSTM0TINT_SHIFT            (6u)
#define INTC_ICDABR4_OSTM1TINT_SHIFT            (7u)
#define INTC_ICDABR4_CMI_SHIFT                  (8u)
#define INTC_ICDABR4_WTOUT_SHIFT                (9u)
#define INTC_ICDABR4_ITI_SHIFT                  (10u)
#define INTC_ICDABR4_TGI0A_SHIFT                (11u)
#define INTC_ICDABR4_TGI0B_SHIFT                (12u)
#define INTC_ICDABR4_TGI0C_SHIFT                (13u)
#define INTC_ICDABR4_TGI0D_SHIFT                (14u)
#define INTC_ICDABR4_TGI0V_SHIFT                (15u)
#define INTC_ICDABR4_TGI0E_SHIFT                (16u)
#define INTC_ICDABR4_TGI0F_SHIFT                (17u)
#define INTC_ICDABR4_TGI1A_SHIFT                (18u)
#define INTC_ICDABR4_TGI1B_SHIFT                (19u)
#define INTC_ICDABR4_TGI1V_SHIFT                (20u)
#define INTC_ICDABR4_TGI1U_SHIFT                (21u)
#define INTC_ICDABR4_TGI2A_SHIFT                (22u)
#define INTC_ICDABR4_TGI2B_SHIFT                (23u)
#define INTC_ICDABR4_TGI2V_SHIFT                (24u)
#define INTC_ICDABR4_TGI2U_SHIFT                (25u)
#define INTC_ICDABR4_TGI3A_SHIFT                (26u)
#define INTC_ICDABR4_TGI3B_SHIFT                (27u)
#define INTC_ICDABR4_TGI3C_SHIFT                (28u)
#define INTC_ICDABR4_TGI3D_SHIFT                (29u)
#define INTC_ICDABR4_TGI3V_SHIFT                (30u)
#define INTC_ICDABR4_TGI4A_SHIFT                (31u)

#define INTC_ICDABR5_TGI4B_SHIFT                (0u)
#define INTC_ICDABR5_TGI4C_SHIFT                (1u)
#define INTC_ICDABR5_TGI4D_SHIFT                (2u)
#define INTC_ICDABR5_TGI4V_SHIFT                (3u)
#define INTC_ICDABR5_CMI1_SHIFT                 (4u)
#define INTC_ICDABR5_CMI2_SHIFT                 (5u)
#define INTC_ICDABR5_SGDEI0_SHIFT               (6u)
#define INTC_ICDABR5_SGDEI1_SHIFT               (7u)
#define INTC_ICDABR5_SGDEI2_SHIFT               (8u)
#define INTC_ICDABR5_SGDEI3_SHIFT               (9u)
#define INTC_ICDABR5_ADI_SHIFT                  (10u)
#define INTC_ICDABR5_LMTI_SHIFT                 (11u)
#define INTC_ICDABR5_SSII0_SHIFT                (12u)
#define INTC_ICDABR5_SSIRXI0_SHIFT              (13u)
#define INTC_ICDABR5_SSITXI0_SHIFT              (14u)
#define INTC_ICDABR5_SSII1_SHIFT                (15u)
#define INTC_ICDABR5_SSIRXI1_SHIFT              (16u)
#define INTC_ICDABR5_SSITXI1_SHIFT              (17u)
#define INTC_ICDABR5_SSII2_SHIFT                (18u)
#define INTC_ICDABR5_SSIRTI2_SHIFT              (19u)
#define INTC_ICDABR5_SSII3_SHIFT                (20u)
#define INTC_ICDABR5_SSIRXI3_SHIFT              (21u)
#define INTC_ICDABR5_SSITXI3_SHIFT              (22u)
#define INTC_ICDABR5_SSII4_SHIFT                (23u)
#define INTC_ICDABR5_SSIRTI4_SHIFT              (24u)
#define INTC_ICDABR5_SSII5_SHIFT                (25u)
#define INTC_ICDABR5_SSIRXI5_SHIFT              (26u)
#define INTC_ICDABR5_SSITXI5_SHIFT              (27u)
#define INTC_ICDABR5_SPDIFI_SHIFT               (28u)
#define INTC_ICDABR5_INTIICTEI0_SHIFT           (29u)
#define INTC_ICDABR5_INTIICRI0_SHIFT            (30u)
#define INTC_ICDABR5_INTIICTI0_SHIFT            (31u)

#define INTC_ICDABR6_INTIICSPI0_SHIFT           (0u)
#define INTC_ICDABR6_INTIICSTI0_SHIFT           (1u)
#define INTC_ICDABR6_INTIICNAKI0_SHIFT          (2u)
#define INTC_ICDABR6_INTIICALI0_SHIFT           (3u)
#define INTC_ICDABR6_INTIICTMOI0_SHIFT          (4u)
#define INTC_ICDABR6_INTIICTEI1_SHIFT           (5u)
#define INTC_ICDABR6_INTIICRI1_SHIFT            (6u)
#define INTC_ICDABR6_INTIICTI1_SHIFT            (7u)
#define INTC_ICDABR6_INTIICSPI1_SHIFT           (8u)
#define INTC_ICDABR6_INTIICSTI1_SHIFT           (9u)
#define INTC_ICDABR6_INTIICNAKI1_SHIFT          (10u)
#define INTC_ICDABR6_INTIICALI1_SHIFT           (11u)
#define INTC_ICDABR6_INTIICTMOI1_SHIFT          (12u)
#define INTC_ICDABR6_INTIICTEI2_SHIFT           (13u)
#define INTC_ICDABR6_INTIICRI2_SHIFT            (14u)
#define INTC_ICDABR6_INTIICTI2_SHIFT            (15u)
#define INTC_ICDABR6_INTIICSPI2_SHIFT           (16u)
#define INTC_ICDABR6_INTIICSTI2_SHIFT           (17u)
#define INTC_ICDABR6_INTIICNAKI2_SHIFT          (18u)
#define INTC_ICDABR6_INTIICALI2_SHIFT           (19u)
#define INTC_ICDABR6_INTIICTMOI2_SHIFT          (20u)
#define INTC_ICDABR6_INTIICTEI3_SHIFT           (21u)
#define INTC_ICDABR6_INTIICRI3_SHIFT            (22u)
#define INTC_ICDABR6_INTIICTI3_SHIFT            (23u)
#define INTC_ICDABR6_INTIICSPI3_SHIFT           (24u)
#define INTC_ICDABR6_INTIICSTI3_SHIFT           (25u)
#define INTC_ICDABR6_INTIICNAKI3_SHIFT          (26u)
#define INTC_ICDABR6_INTIICALI3_SHIFT           (27u)
#define INTC_ICDABR6_INTIICTMOI3_SHIFT          (28u)
#define INTC_ICDABR6_BRI0_SHIFT                 (29u)
#define INTC_ICDABR6_ERI0_SHIFT                 (30u)
#define INTC_ICDABR6_RXI0_SHIFT                 (31u)

#define INTC_ICDABR7_TXI0_SHIFT                 (0u)
#define INTC_ICDABR7_BRI1_SHIFT                 (1u)
#define INTC_ICDABR7_ERI1_SHIFT                 (2u)
#define INTC_ICDABR7_RXI1_SHIFT                 (3u)
#define INTC_ICDABR7_TXI1_SHIFT                 (4u)
#define INTC_ICDABR7_BRI2_SHIFT                 (5u)
#define INTC_ICDABR7_ERI2_SHIFT                 (6u)
#define INTC_ICDABR7_RXI2_SHIFT                 (7u)
#define INTC_ICDABR7_TXI2_SHIFT                 (8u)
#define INTC_ICDABR7_BRI3_SHIFT                 (9u)
#define INTC_ICDABR7_ERI3_SHIFT                 (10u)
#define INTC_ICDABR7_RXI3_SHIFT                 (11u)
#define INTC_ICDABR7_TXI3_SHIFT                 (12u)
#define INTC_ICDABR7_BRI4_SHIFT                 (13u)
#define INTC_ICDABR7_ERI4_SHIFT                 (14u)
#define INTC_ICDABR7_RXI4_SHIFT                 (15u)
#define INTC_ICDABR7_TXI4_SHIFT                 (16u)
#define INTC_ICDABR7_BRI5_SHIFT                 (17u)
#define INTC_ICDABR7_ERI5_SHIFT                 (18u)
#define INTC_ICDABR7_RXI5_SHIFT                 (19u)
#define INTC_ICDABR7_TXI5_SHIFT                 (20u)
#define INTC_ICDABR7_BRI6_SHIFT                 (21u)
#define INTC_ICDABR7_ERI6_SHIFT                 (22u)
#define INTC_ICDABR7_RXI6_SHIFT                 (23u)
#define INTC_ICDABR7_TXI6_SHIFT                 (24u)
#define INTC_ICDABR7_BRI7_SHIFT                 (25u)
#define INTC_ICDABR7_ERI7_SHIFT                 (26u)
#define INTC_ICDABR7_RXI7_SHIFT                 (27u)
#define INTC_ICDABR7_TXI7_SHIFT                 (28u)
#define INTC_ICDABR7_INTRCANGERR_SHIFT          (29u)
#define INTC_ICDABR7_INTRCANGRECC_SHIFT         (30u)
#define INTC_ICDABR7_INTRCAN0REC_SHIFT          (31u)

#define INTC_ICDABR8_INTRCAN0ERR_SHIFT          (0u)
#define INTC_ICDABR8_INTRCAN0TRX_SHIFT          (1u)
#define INTC_ICDABR8_INTRCAN1REC_SHIFT          (2u)
#define INTC_ICDABR8_INTRCAN1ERR_SHIFT          (3u)
#define INTC_ICDABR8_INTRCAN1TRX_SHIFT          (4u)
#define INTC_ICDABR8_INTRCAN2REC_SHIFT          (5u)
#define INTC_ICDABR8_INTRCAN2ERR_SHIFT          (6u)
#define INTC_ICDABR8_INTRCAN2TRX_SHIFT          (7u)
#define INTC_ICDABR8_INTRCAN3REC_SHIFT          (8u)
#define INTC_ICDABR8_INTRCAN3ERR_SHIFT          (9u)
#define INTC_ICDABR8_INTRCAN3TRX_SHIFT          (10u)
#define INTC_ICDABR8_INTRCAN4REC_SHIFT          (11u)
#define INTC_ICDABR8_INTRCAN4ERR_SHIFT          (12u)
#define INTC_ICDABR8_INTRCAN4TRX_SHIFT          (13u)
#define INTC_ICDABR8_SPEI0_SHIFT                (14u)
#define INTC_ICDABR8_SPRI0_SHIFT                (15u)
#define INTC_ICDABR8_SPTI0_SHIFT                (16u)
#define INTC_ICDABR8_SPEI1_SHIFT                (17u)
#define INTC_ICDABR8_SPRI1_SHIFT                (18u)
#define INTC_ICDABR8_SPTI1_SHIFT                (19u)
#define INTC_ICDABR8_SPEI2_SHIFT                (20u)
#define INTC_ICDABR8_SPRI2_SHIFT                (21u)
#define INTC_ICDABR8_SPTI2_SHIFT                (22u)
#define INTC_ICDABR8_SPEI3_SHIFT                (23u)
#define INTC_ICDABR8_SPRI3_SHIFT                (24u)
#define INTC_ICDABR8_SPTI3_SHIFT                (25u)
#define INTC_ICDABR8_SPEI4_SHIFT                (26u)
#define INTC_ICDABR8_SPRI4_SHIFT                (27u)
#define INTC_ICDABR8_SPTI4_SHIFT                (28u)
#define INTC_ICDABR8_IEBBTD_SHIFT               (29u)
#define INTC_ICDABR8_IEBBTERR_SHIFT             (30u)
#define INTC_ICDABR8_IEBBTSTA_SHIFT             (31u)

#define INTC_ICDABR9_IEBBTV_SHIFT               (0u)
#define INTC_ICDABR9_ISY_SHIFT                  (1u)
#define INTC_ICDABR9_IERR_SHIFT                 (2u)
#define INTC_ICDABR9_ITARG_SHIFT                (3u)
#define INTC_ICDABR9_ISEC_SHIFT                 (4u)
#define INTC_ICDABR9_IBUF_SHIFT                 (5u)
#define INTC_ICDABR9_IREADY_SHIFT               (6u)
#define INTC_ICDABR9_FLSTE_SHIFT                (7u)
#define INTC_ICDABR9_FLTENDI_SHIFT              (8u)
#define INTC_ICDABR9_FLTREQ0I_SHIFT             (9u)
#define INTC_ICDABR9_FLTREQ1I_SHIFT             (10u)
#define INTC_ICDABR9_MMC0_SHIFT                 (11u)
#define INTC_ICDABR9_MMC1_SHIFT                 (12u)
#define INTC_ICDABR9_MMC2_SHIFT                 (13u)
#define INTC_ICDABR9_SDHI0_3_SHIFT              (14u)
#define INTC_ICDABR9_SDHI0_0_SHIFT              (15u)
#define INTC_ICDABR9_SDHI0_1_SHIFT              (16u)
#define INTC_ICDABR9_SDHI1_3_SHIFT              (17u)
#define INTC_ICDABR9_SDHI1_0_SHIFT              (18u)
#define INTC_ICDABR9_SDHI1_1_SHIFT              (19u)
#define INTC_ICDABR9_ARM_SHIFT                  (20u)
#define INTC_ICDABR9_PRD_SHIFT                  (21u)
#define INTC_ICDABR9_CUP_SHIFT                  (22u)
#define INTC_ICDABR9_SCUAI0_SHIFT               (23u)
#define INTC_ICDABR9_SCUAI1_SHIFT               (24u)
#define INTC_ICDABR9_SCUFDI0_SHIFT              (25u)
#define INTC_ICDABR9_SCUFDI1_SHIFT              (26u)
#define INTC_ICDABR9_SCUFDI2_SHIFT              (27u)
#define INTC_ICDABR9_SCUFDI3_SHIFT              (28u)
#define INTC_ICDABR9_SCUFUI0_SHIFT              (29u)
#define INTC_ICDABR9_SCUFUI1_SHIFT              (30u)
#define INTC_ICDABR9_SCUFUI2_SHIFT              (31u)

#define INTC_ICDABR10_SCUFUI3_SHIFT             (0u)
#define INTC_ICDABR10_SCUDVI0_SHIFT             (1u)
#define INTC_ICDABR10_SCUDVI1_SHIFT             (2u)
#define INTC_ICDABR10_SCUDVI2_SHIFT             (3u)
#define INTC_ICDABR10_SCUDVI3_SHIFT             (4u)
#define INTC_ICDABR10_MLB_CINT_SHIFT            (5u)
#define INTC_ICDABR10_MLB_SINT_SHIFT            (6u)
#define INTC_ICDABR10_DRC0_SHIFT                (7u)
#define INTC_ICDABR10_DRC1_SHIFT                (8u)
#define INTC_ICDABR10_LINI0_INT_T_SHIFT         (11u)
#define INTC_ICDABR10_LINI0_INT_R_SHIFT         (12u)
#define INTC_ICDABR10_LINI0_INT_S_SHIFT         (13u)
#define INTC_ICDABR10_LINI0_INT_M_SHIFT         (14u)
#define INTC_ICDABR10_LINI1_INT_T_SHIFT         (15u)
#define INTC_ICDABR10_LINI1_INT_R_SHIFT         (16u)
#define INTC_ICDABR10_LINI1_INT_S_SHIFT         (17u)
#define INTC_ICDABR10_LINI1_INT_M_SHIFT         (18u)
#define INTC_ICDABR10_ERI0_SHIFT                (27u)
#define INTC_ICDABR10_RXI0_SHIFT                (28u)
#define INTC_ICDABR10_TXI0_SHIFT                (29u)
#define INTC_ICDABR10_TEI0_SHIFT                (30u)
#define INTC_ICDABR10_ERI1_SHIFT                (31u)

#define INTC_ICDABR11_RXI1_SHIFT                (0u)
#define INTC_ICDABR11_TXI1_SHIFT                (1u)
#define INTC_ICDABR11_TEI1_SHIFT                (2u)
#define INTC_ICDABR11_AVBI_DATA_SHIFT           (3u)
#define INTC_ICDABR11_AVBI_ERROR_SHIFT          (4u)
#define INTC_ICDABR11_AVBI_MANAGE_SHIFT         (5u)
#define INTC_ICDABR11_AVBI_MAC_SHIFT            (6u)
#define INTC_ICDABR11_ETHERI_SHIFT              (7u)
#define INTC_ICDABR11_CEUI_SHIFT                (12u)
#define INTC_ICDABR11_H2XMLB_ERRINT_SHIFT       (29u)
#define INTC_ICDABR11_H2XIC1_ERRINT_SHIFT       (30u)
#define INTC_ICDABR11_X2HPERI1_ERRINT_SHIFT     (31u)

#define INTC_ICDABR12_X2HPERI2_ERRINT_SHIFT     (0u)
#define INTC_ICDABR12_X2HPERI34_ERRINT_SHIFT    (1u)
#define INTC_ICDABR12_X2HPERI5_ERRINT_SHIFT     (2u)
#define INTC_ICDABR12_X2HPERI67_ERRINT_SHIFT    (3u)
#define INTC_ICDABR12_X2HDBGR_ERRINT_SHIFT      (4u)
#define INTC_ICDABR12_X2HBSC_ERRINT_SHIFT       (5u)
#define INTC_ICDABR12_X2HSPI1_ERRINT_SHIFT      (6u)
#define INTC_ICDABR12_X2HSPI2_ERRINT_SHIFT      (7u)
#define INTC_ICDABR12_PRRI_SHIFT                (8u)
#define INTC_ICDABR12_IFEI0_SHIFT               (9u)
#define INTC_ICDABR12_OFFI0_SHIFT               (10u)
#define INTC_ICDABR12_PFVEI0_SHIFT              (11u)
#define INTC_ICDABR12_IFEI1_SHIFT               (12u)
#define INTC_ICDABR12_OFFI1_SHIFT               (13u)
#define INTC_ICDABR12_PFVEI1_SHIFT              (14u)

#define INTC_ICDABR13_TINT0_SHIFT               (0u)
#define INTC_ICDABR13_TINT1_SHIFT               (1u)
#define INTC_ICDABR13_TINT2_SHIFT               (2u)
#define INTC_ICDABR13_TINT3_SHIFT               (3u)
#define INTC_ICDABR13_TINT4_SHIFT               (4u)
#define INTC_ICDABR13_TINT5_SHIFT               (5u)
#define INTC_ICDABR13_TINT6_SHIFT               (6u)
#define INTC_ICDABR13_TINT7_SHIFT               (7u)
#define INTC_ICDABR13_TINT8_SHIFT               (8u)
#define INTC_ICDABR13_TINT9_SHIFT               (9u)
#define INTC_ICDABR13_TINT10_SHIFT              (10u)
#define INTC_ICDABR13_TINT11_SHIFT              (11u)
#define INTC_ICDABR13_TINT12_SHIFT              (12u)
#define INTC_ICDABR13_TINT13_SHIFT              (13u)
#define INTC_ICDABR13_TINT14_SHIFT              (14u)
#define INTC_ICDABR13_TINT15_SHIFT              (15u)
#define INTC_ICDABR13_TINT16_SHIFT              (16u)
#define INTC_ICDABR13_TINT17_SHIFT              (17u)
#define INTC_ICDABR13_TINT18_SHIFT              (18u)
#define INTC_ICDABR13_TINT19_SHIFT              (19u)
#define INTC_ICDABR13_TINT20_SHIFT              (20u)
#define INTC_ICDABR13_TINT21_SHIFT              (21u)
#define INTC_ICDABR13_TINT22_SHIFT              (22u)
#define INTC_ICDABR13_TINT23_SHIFT              (23u)
#define INTC_ICDABR13_TINT24_SHIFT              (24u)
#define INTC_ICDABR13_TINT25_SHIFT              (25u)
#define INTC_ICDABR13_TINT26_SHIFT              (26u)
#define INTC_ICDABR13_TINT27_SHIFT              (27u)
#define INTC_ICDABR13_TINT28_SHIFT              (28u)
#define INTC_ICDABR13_TINT29_SHIFT              (29u)
#define INTC_ICDABR13_TINT30_SHIFT              (30u)
#define INTC_ICDABR13_TINT31_SHIFT              (31u)

#define INTC_ICDABR14_TINT32_SHIFT              (0u)
#define INTC_ICDABR14_TINT33_SHIFT              (1u)
#define INTC_ICDABR14_TINT34_SHIFT              (2u)
#define INTC_ICDABR14_TINT35_SHIFT              (3u)
#define INTC_ICDABR14_TINT36_SHIFT              (4u)
#define INTC_ICDABR14_TINT37_SHIFT              (5u)
#define INTC_ICDABR14_TINT38_SHIFT              (6u)
#define INTC_ICDABR14_TINT39_SHIFT              (7u)
#define INTC_ICDABR14_TINT40_SHIFT              (8u)
#define INTC_ICDABR14_TINT41_SHIFT              (9u)
#define INTC_ICDABR14_TINT42_SHIFT              (10u)
#define INTC_ICDABR14_TINT43_SHIFT              (11u)
#define INTC_ICDABR14_TINT44_SHIFT              (12u)
#define INTC_ICDABR14_TINT45_SHIFT              (13u)
#define INTC_ICDABR14_TINT46_SHIFT              (14u)
#define INTC_ICDABR14_TINT47_SHIFT              (15u)
#define INTC_ICDABR14_TINT48_SHIFT              (16u)
#define INTC_ICDABR14_TINT49_SHIFT              (17u)
#define INTC_ICDABR14_TINT50_SHIFT              (18u)
#define INTC_ICDABR14_TINT51_SHIFT              (19u)
#define INTC_ICDABR14_TINT52_SHIFT              (20u)
#define INTC_ICDABR14_TINT53_SHIFT              (21u)
#define INTC_ICDABR14_TINT54_SHIFT              (22u)
#define INTC_ICDABR14_TINT55_SHIFT              (23u)
#define INTC_ICDABR14_TINT56_SHIFT              (24u)
#define INTC_ICDABR14_TINT57_SHIFT              (25u)
#define INTC_ICDABR14_TINT58_SHIFT              (26u)
#define INTC_ICDABR14_TINT59_SHIFT              (27u)
#define INTC_ICDABR14_TINT60_SHIFT              (28u)
#define INTC_ICDABR14_TINT61_SHIFT              (29u)
#define INTC_ICDABR14_TINT62_SHIFT              (30u)
#define INTC_ICDABR14_TINT63_SHIFT              (31u)

#define INTC_ICDABR15_TINT64_SHIFT              (0u)
#define INTC_ICDABR15_TINT65_SHIFT              (1u)
#define INTC_ICDABR15_TINT66_SHIFT              (2u)
#define INTC_ICDABR15_TINT67_SHIFT              (3u)
#define INTC_ICDABR15_TINT68_SHIFT              (4u)
#define INTC_ICDABR15_TINT69_SHIFT              (5u)
#define INTC_ICDABR15_TINT70_SHIFT              (6u)
#define INTC_ICDABR15_TINT71_SHIFT              (7u)
#define INTC_ICDABR15_TINT72_SHIFT              (8u)
#define INTC_ICDABR15_TINT73_SHIFT              (9u)
#define INTC_ICDABR15_TINT74_SHIFT              (10u)
#define INTC_ICDABR15_TINT75_SHIFT              (11u)
#define INTC_ICDABR15_TINT76_SHIFT              (12u)
#define INTC_ICDABR15_TINT77_SHIFT              (13u)
#define INTC_ICDABR15_TINT78_SHIFT              (14u)
#define INTC_ICDABR15_TINT79_SHIFT              (15u)
#define INTC_ICDABR15_TINT80_SHIFT              (16u)
#define INTC_ICDABR15_TINT81_SHIFT              (17u)
#define INTC_ICDABR15_TINT82_SHIFT              (18u)
#define INTC_ICDABR15_TINT83_SHIFT              (19u)
#define INTC_ICDABR15_TINT84_SHIFT              (20u)
#define INTC_ICDABR15_TINT85_SHIFT              (21u)
#define INTC_ICDABR15_TINT86_SHIFT              (22u)
#define INTC_ICDABR15_TINT87_SHIFT              (23u)
#define INTC_ICDABR15_TINT88_SHIFT              (24u)
#define INTC_ICDABR15_TINT89_SHIFT              (25u)
#define INTC_ICDABR15_TINT90_SHIFT              (26u)
#define INTC_ICDABR15_TINT91_SHIFT              (27u)
#define INTC_ICDABR15_TINT92_SHIFT              (28u)
#define INTC_ICDABR15_TINT93_SHIFT              (29u)
#define INTC_ICDABR15_TINT94_SHIFT              (30u)
#define INTC_ICDABR15_TINT95_SHIFT              (31u)

#define INTC_ICDABR16_TINT96_SHIFT              (0u)
#define INTC_ICDABR16_TINT97_SHIFT              (1u)
#define INTC_ICDABR16_TINT98_SHIFT              (2u)
#define INTC_ICDABR16_TINT99_SHIFT              (3u)
#define INTC_ICDABR16_TINT100_SHIFT             (4u)
#define INTC_ICDABR16_TINT101_SHIFT             (5u)
#define INTC_ICDABR16_TINT102_SHIFT             (6u)
#define INTC_ICDABR16_TINT103_SHIFT             (7u)
#define INTC_ICDABR16_TINT104_SHIFT             (8u)
#define INTC_ICDABR16_TINT105_SHIFT             (9u)
#define INTC_ICDABR16_TINT106_SHIFT             (10u)
#define INTC_ICDABR16_TINT107_SHIFT             (11u)
#define INTC_ICDABR16_TINT108_SHIFT             (12u)
#define INTC_ICDABR16_TINT109_SHIFT             (13u)
#define INTC_ICDABR16_TINT110_SHIFT             (14u)
#define INTC_ICDABR16_TINT111_SHIFT             (15u)
#define INTC_ICDABR16_TINT112_SHIFT             (16u)
#define INTC_ICDABR16_TINT113_SHIFT             (17u)
#define INTC_ICDABR16_TINT114_SHIFT             (18u)
#define INTC_ICDABR16_TINT115_SHIFT             (19u)
#define INTC_ICDABR16_TINT116_SHIFT             (20u)
#define INTC_ICDABR16_TINT117_SHIFT             (21u)
#define INTC_ICDABR16_TINT118_SHIFT             (22u)
#define INTC_ICDABR16_TINT119_SHIFT             (23u)
#define INTC_ICDABR16_TINT120_SHIFT             (24u)
#define INTC_ICDABR16_TINT121_SHIFT             (25u)
#define INTC_ICDABR16_TINT122_SHIFT             (26u)
#define INTC_ICDABR16_TINT123_SHIFT             (27u)
#define INTC_ICDABR16_TINT124_SHIFT             (28u)
#define INTC_ICDABR16_TINT125_SHIFT             (29u)
#define INTC_ICDABR16_TINT126_SHIFT             (30u)
#define INTC_ICDABR16_TINT127_SHIFT             (31u)

#define INTC_ICDABR17_TINT128_SHIFT             (0u)
#define INTC_ICDABR17_TINT129_SHIFT             (1u)
#define INTC_ICDABR17_TINT130_SHIFT             (2u)
#define INTC_ICDABR17_TINT131_SHIFT             (3u)
#define INTC_ICDABR17_TINT132_SHIFT             (4u)
#define INTC_ICDABR17_TINT133_SHIFT             (5u)
#define INTC_ICDABR17_TINT134_SHIFT             (6u)
#define INTC_ICDABR17_TINT135_SHIFT             (7u)
#define INTC_ICDABR17_TINT136_SHIFT             (8u)
#define INTC_ICDABR17_TINT137_SHIFT             (9u)
#define INTC_ICDABR17_TINT138_SHIFT             (10u)
#define INTC_ICDABR17_TINT139_SHIFT             (11u)
#define INTC_ICDABR17_TINT140_SHIFT             (12u)
#define INTC_ICDABR17_TINT141_SHIFT             (13u)
#define INTC_ICDABR17_TINT142_SHIFT             (14u)
#define INTC_ICDABR17_TINT143_SHIFT             (15u)
#define INTC_ICDABR17_TINT144_SHIFT             (16u)
#define INTC_ICDABR17_TINT145_SHIFT             (17u)
#define INTC_ICDABR17_TINT146_SHIFT             (18u)
#define INTC_ICDABR17_TINT147_SHIFT             (19u)
#define INTC_ICDABR17_TINT148_SHIFT             (20u)
#define INTC_ICDABR17_TINT149_SHIFT             (21u)
#define INTC_ICDABR17_TINT150_SHIFT             (22u)
#define INTC_ICDABR17_TINT151_SHIFT             (23u)
#define INTC_ICDABR17_TINT152_SHIFT             (24u)
#define INTC_ICDABR17_TINT153_SHIFT             (25u)
#define INTC_ICDABR17_TINT154_SHIFT             (26u)
#define INTC_ICDABR17_TINT155_SHIFT             (27u)
#define INTC_ICDABR17_TINT156_SHIFT             (28u)
#define INTC_ICDABR17_TINT157_SHIFT             (29u)
#define INTC_ICDABR17_TINT158_SHIFT             (30u)
#define INTC_ICDABR17_TINT159_SHIFT             (31u)

#define INTC_ICDABR18_TINT160_SHIFT             (0u)
#define INTC_ICDABR18_TINT161_SHIFT             (1u)
#define INTC_ICDABR18_TINT162_SHIFT             (2u)
#define INTC_ICDABR18_TINT163_SHIFT             (3u)
#define INTC_ICDABR18_TINT164_SHIFT             (4u)
#define INTC_ICDABR18_TINT165_SHIFT             (5u)
#define INTC_ICDABR18_TINT166_SHIFT             (6u)
#define INTC_ICDABR18_TINT167_SHIFT             (7u)
#define INTC_ICDABR18_TINT168_SHIFT             (8u)
#define INTC_ICDABR18_TINT169_SHIFT             (9u)
#define INTC_ICDABR18_TINT170_SHIFT             (10u)

#define INTC_ICDIPR0_SW0_SHIFT                  (0u)
#define INTC_ICDIPR0_SW1_SHIFT                  (8u)
#define INTC_ICDIPR0_SW2_SHIFT                  (16u)
#define INTC_ICDIPR0_SW3_SHIFT                  (24u)

#define INTC_ICDIPR1_SW4_SHIFT                  (0u)
#define INTC_ICDIPR1_SW5_SHIFT                  (8u)
#define INTC_ICDIPR1_SW6_SHIFT                  (16u)
#define INTC_ICDIPR1_SW7_SHIFT                  (24u)

#define INTC_ICDIPR2_SW8_SHIFT                  (0u)
#define INTC_ICDIPR2_SW9_SHIFT                  (8u)
#define INTC_ICDIPR2_SW10_SHIFT                 (16u)
#define INTC_ICDIPR2_SW11_SHIFT                 (24u)

#define INTC_ICDIPR3_SW12_SHIFT                 (0u)
#define INTC_ICDIPR3_SW13_SHIFT                 (8u)
#define INTC_ICDIPR3_SW14_SHIFT                 (16u)
#define INTC_ICDIPR3_SW15_SHIFT                 (24u)

#define INTC_ICDIPR4_PMUIRQ0_SHIFT              (0u)
#define INTC_ICDIPR4_COMMRX0_SHIFT              (8u)
#define INTC_ICDIPR4_COMMTX0_SHIFT              (16u)
#define INTC_ICDIPR4_CTIIRQ0_SHIFT              (24u)

#define INTC_ICDIPR8_IRQ0_SHIFT                 (0u)
#define INTC_ICDIPR8_IRQ1_SHIFT                 (8u)
#define INTC_ICDIPR8_IRQ2_SHIFT                 (16u)
#define INTC_ICDIPR8_IRQ3_SHIFT                 (24u)

#define INTC_ICDIPR9_IRQ4_SHIFT                 (0u)
#define INTC_ICDIPR9_IRQ5_SHIFT                 (8u)
#define INTC_ICDIPR9_IRQ6_SHIFT                 (16u)
#define INTC_ICDIPR9_IRQ7_SHIFT                 (24u)

#define INTC_ICDIPR10_PL310ERR_SHIFT            (0u)
#define INTC_ICDIPR10_DMAINT0_SHIFT             (8u)
#define INTC_ICDIPR10_DMAINT1_SHIFT             (16u)
#define INTC_ICDIPR10_DMAINT2_SHIFT             (24u)

#define INTC_ICDIPR11_DMAINT3_SHIFT             (0u)
#define INTC_ICDIPR11_DMAINT4_SHIFT             (8u)
#define INTC_ICDIPR11_DMAINT5_SHIFT             (16u)
#define INTC_ICDIPR11_DMAINT6_SHIFT             (24u)

#define INTC_ICDIPR12_DMAINT7_SHIFT             (0u)
#define INTC_ICDIPR12_DMAINT8_SHIFT             (8u)
#define INTC_ICDIPR12_DMAINT9_SHIFT             (16u)
#define INTC_ICDIPR12_DMAINT10_SHIFT            (24u)

#define INTC_ICDIPR13_DMAINT11_SHIFT            (0u)
#define INTC_ICDIPR13_DMAINT12_SHIFT            (8u)
#define INTC_ICDIPR13_DMAINT13_SHIFT            (16u)
#define INTC_ICDIPR13_DMAINT14_SHIFT            (24u)

#define INTC_ICDIPR14_DMAINT15_SHIFT            (0u)
#define INTC_ICDIPR14_DMAERR_SHIFT              (8u)

#define INTC_ICDIPR18_USBI0_SHIFT               (8u)
#define INTC_ICDIPR18_USBI1_SHIFT               (16u)
#define INTC_ICDIPR18_S0_VI_VSYNC0_SHIFT        (24u)

#define INTC_ICDIPR19_S0_LO_VSYNC0_SHIFT        (0u)
#define INTC_ICDIPR19_S0_VSYNCERR0_SHIFT        (8u)
#define INTC_ICDIPR19_GR3_VLINE0_SHIFT          (16u)
#define INTC_ICDIPR19_S0_VFIELD0_SHIFT          (24u)

#define INTC_ICDIPR20_IV1_VBUFERR0_SHIFT        (0u)
#define INTC_ICDIPR20_IV3_VBUFERR0_SHIFT        (8u)
#define INTC_ICDIPR20_IV5_VBUFERR0_SHIFT        (16u)
#define INTC_ICDIPR20_IV6_VBUFERR0_SHIFT        (24u)

#define INTC_ICDIPR21_S0_WLINE0_SHIFT           (0u)
#define INTC_ICDIPR21_S1_VI_VSYNC0_SHIFT        (8u)
#define INTC_ICDIPR21_S1_LO_VSYNC0_SHIFT        (16u)
#define INTC_ICDIPR21_S1_VSYNCERR0_SHIFT        (24u)

#define INTC_ICDIPR22_S1_VFIELD0_SHIFT          (0u)
#define INTC_ICDIPR22_IV2_VBUFERR0_SHIFT        (8u)
#define INTC_ICDIPR22_IV4_VBUFERR0_SHIFT        (16u)
#define INTC_ICDIPR22_S1_WLINE0_SHIFT           (24u)

#define INTC_ICDIPR23_OIR_VI_VSYNC0_SHIFT       (0u)
#define INTC_ICDIPR23_OIR_LO_VSYNC0_SHIFT       (8u)
#define INTC_ICDIPR23_OIR_VSYNCERR0_SHIFT       (16u)
#define INTC_ICDIPR23_OIR_VFIELD0_SHIFT         (24u)

#define INTC_ICDIPR24_IV7_VBUFERR0_SHIFT        (0u)
#define INTC_ICDIPR24_IV8_VBUFERR0_SHIFT        (8u)
#define INTC_ICDIPR24_OIR_WLINE0_SHIFT          (16u)
#define INTC_ICDIPR24_S0_VI_VSYNC1_SHIFT        (24u)

#define INTC_ICDIPR25_S0_LO_VSYNC1_SHIFT        (0u)
#define INTC_ICDIPR25_S0_VSYNCERR1_SHIFT        (8u)
#define INTC_ICDIPR25_GR3_VLINE1_SHIFT          (16u)
#define INTC_ICDIPR25_S0_VFIELD1_SHIFT          (24u)

#define INTC_ICDIPR26_IV1_VBUFERR1_SHIFT        (0u)
#define INTC_ICDIPR26_IV3_VBUFERR1_SHIFT        (8u)
#define INTC_ICDIPR26_IV5_VBUFERR1_SHIFT        (16u)
#define INTC_ICDIPR26_IV6_VBUFERR1_SHIFT        (24u)

#define INTC_ICDIPR27_S0_WLINE1_SHIFT           (0u)
#define INTC_ICDIPR27_S1_VI_VSYNC1_SHIFT        (8u)
#define INTC_ICDIPR27_S1_LO_VSYNC1_SHIFT        (16u)
#define INTC_ICDIPR27_S1_VSYNCERR1_SHIFT        (24u)

#define INTC_ICDIPR28_S1_VFIELD1_SHIFT          (0u)
#define INTC_ICDIPR28_IV2_VBUFERR1_SHIFT        (8u)
#define INTC_ICDIPR28_IV4_VBUFERR1_SHIFT        (16u)
#define INTC_ICDIPR28_S1_WLINE1_SHIFT           (24u)

#define INTC_ICDIPR29_OIR_VI_VSYNC1_SHIFT       (0u)
#define INTC_ICDIPR29_OIR_LO_VSYNC1_SHIFT       (8u)
#define INTC_ICDIPR29_OIR_VLINE1_SHIFT          (16u)
#define INTC_ICDIPR29_OIR_VFIELD1_SHIFT         (24u)

#define INTC_ICDIPR30_IV7_VBUFERR1_SHIFT        (0u)
#define INTC_ICDIPR30_IV8_VBUFERR1_SHIFT        (8u)
#define INTC_ICDIPR30_OIR_WLINE1_SHIFT          (16u)
#define INTC_ICDIPR30_IMRDI_SHIFT               (24u)

#define INTC_ICDIPR31_IMR2I0_SHIFT              (0u)
#define INTC_ICDIPR31_IMR2I1_SHIFT              (8u)
#define INTC_ICDIPR31_JEDI_SHIFT                (16u)
#define INTC_ICDIPR31_JDTI_SHIFT                (24u)

#define INTC_ICDIPR32_CMP0_SHIFT                (0u)
#define INTC_ICDIPR32_CMP1_SHIFT                (8u)
#define INTC_ICDIPR32_INT0_SHIFT                (16u)
#define INTC_ICDIPR32_INT1_SHIFT                (24u)

#define INTC_ICDIPR33_INT2_SHIFT                (0u)
#define INTC_ICDIPR33_INT3_SHIFT                (8u)
#define INTC_ICDIPR33_OSTM0TINT_SHIFT           (16u)
#define INTC_ICDIPR33_OSTM1TINT_SHIFT           (24u)

#define INTC_ICDIPR34_CMI_SHIFT                 (0u)
#define INTC_ICDIPR34_WTOUT_SHIFT               (8u)
#define INTC_ICDIPR34_ITI_SHIFT                 (16u)
#define INTC_ICDIPR34_TGI0A_SHIFT               (24u)

#define INTC_ICDIPR35_TGI0B_SHIFT               (0u)
#define INTC_ICDIPR35_TGI0C_SHIFT               (8u)
#define INTC_ICDIPR35_TGI0D_SHIFT               (16u)
#define INTC_ICDIPR35_TGI0V_SHIFT               (24u)

#define INTC_ICDIPR36_TGI0E_SHIFT               (0u)
#define INTC_ICDIPR36_TGI0F_SHIFT               (8u)
#define INTC_ICDIPR36_TGI1A_SHIFT               (16u)
#define INTC_ICDIPR36_TGI1B_SHIFT               (24u)

#define INTC_ICDIPR37_TGI1V_SHIFT               (0u)
#define INTC_ICDIPR37_TGI1U_SHIFT               (8u)
#define INTC_ICDIPR37_TGI2A_SHIFT               (16u)
#define INTC_ICDIPR37_TGI2B_SHIFT               (24u)

#define INTC_ICDIPR38_TGI2V_SHIFT               (0u)
#define INTC_ICDIPR38_TGI2U_SHIFT               (8u)
#define INTC_ICDIPR38_TGI3A_SHIFT               (16u)
#define INTC_ICDIPR38_TGI3B_SHIFT               (24u)

#define INTC_ICDIPR39_TGI3C_SHIFT               (0u)
#define INTC_ICDIPR39_TGI3D_SHIFT               (8u)
#define INTC_ICDIPR39_TGI3V_SHIFT               (16u)
#define INTC_ICDIPR39_TGI4A_SHIFT               (24u)

#define INTC_ICDIPR40_TGI4B_SHIFT               (0u)
#define INTC_ICDIPR40_TGI4C_SHIFT               (8u)
#define INTC_ICDIPR40_TGI4D_SHIFT               (16u)
#define INTC_ICDIPR40_TGI4V_SHIFT               (24u)

#define INTC_ICDIPR41_CMI1_SHIFT                (0u)
#define INTC_ICDIPR41_CMI2_SHIFT                (8u)
#define INTC_ICDIPR41_SGDEI0_SHIFT              (16u)
#define INTC_ICDIPR41_SGDEI1_SHIFT              (24u)

#define INTC_ICDIPR42_SGDEI2_SHIFT              (0u)
#define INTC_ICDIPR42_SGDEI3_SHIFT              (8u)
#define INTC_ICDIPR42_ADI_SHIFT                 (16u)
#define INTC_ICDIPR42_LMTI_SHIFT                (24u)

#define INTC_ICDIPR43_SSII0_SHIFT               (0u)
#define INTC_ICDIPR43_SSIRXI0_SHIFT             (8u)
#define INTC_ICDIPR43_SSITXI0_SHIFT             (16u)
#define INTC_ICDIPR43_SSII1_SHIFT               (24u)

#define INTC_ICDIPR44_SSIRXI1_SHIFT             (0u)
#define INTC_ICDIPR44_SSITXI1_SHIFT             (8u)
#define INTC_ICDIPR44_SSII2_SHIFT               (16u)
#define INTC_ICDIPR44_SSIRTI2_SHIFT             (24u)

#define INTC_ICDIPR45_SSII3_SHIFT               (0u)
#define INTC_ICDIPR45_SSIRXI3_SHIFT             (8u)
#define INTC_ICDIPR45_SSITXI3_SHIFT             (16u)
#define INTC_ICDIPR45_SSII4_SHIFT               (24u)

#define INTC_ICDIPR46_SSIRTI4_SHIFT             (0u)
#define INTC_ICDIPR46_SSII5_SHIFT               (8u)
#define INTC_ICDIPR46_SSIRXI5_SHIFT             (16u)
#define INTC_ICDIPR46_SSITXI5_SHIFT             (24u)

#define INTC_ICDIPR47_SPDIFI_SHIFT              (0u)
#define INTC_ICDIPR47_INTIICTEI0_SHIFT          (8u)
#define INTC_ICDIPR47_INTIICRI0_SHIFT           (16u)
#define INTC_ICDIPR47_INTIICTI0_SHIFT           (24u)

#define INTC_ICDIPR48_INTIICSPI0_SHIFT          (0u)
#define INTC_ICDIPR48_INTIICSTI0_SHIFT          (8u)
#define INTC_ICDIPR48_INTIICNAKI0_SHIFT         (16u)
#define INTC_ICDIPR48_INTIICALI0_SHIFT          (24u)

#define INTC_ICDIPR49_INTIICTMOI0_SHIFT         (0u)
#define INTC_ICDIPR49_INTIICTEI1_SHIFT          (8u)
#define INTC_ICDIPR49_INTIICRI1_SHIFT           (16u)
#define INTC_ICDIPR49_INTIICTI1_SHIFT           (24u)

#define INTC_ICDIPR50_INTIICSPI1_SHIFT          (0u)
#define INTC_ICDIPR50_INTIICSTI1_SHIFT          (8u)
#define INTC_ICDIPR50_INTIICNAKI1_SHIFT         (16u)
#define INTC_ICDIPR50_INTIICALI1_SHIFT          (24u)

#define INTC_ICDIPR51_INTIICTMOI1_SHIFT         (0u)
#define INTC_ICDIPR51_INTIICTEI2_SHIFT          (8u)
#define INTC_ICDIPR51_INTIICRI2_SHIFT           (16u)
#define INTC_ICDIPR51_INTIICTI2_SHIFT           (24u)

#define INTC_ICDIPR52_INTIICSPI2_SHIFT          (0u)
#define INTC_ICDIPR52_INTIICSTI2_SHIFT          (8u)
#define INTC_ICDIPR52_INTIICNAKI2_SHIFT         (16u)
#define INTC_ICDIPR52_INTIICALI2_SHIFT          (24u)

#define INTC_ICDIPR53_INTIICTMOI2_SHIFT         (0u)
#define INTC_ICDIPR53_INTIICTEI3_SHIFT          (8u)
#define INTC_ICDIPR53_INTIICRI3_SHIFT           (16u)
#define INTC_ICDIPR53_INTIICTI3_SHIFT           (24u)

#define INTC_ICDIPR54_INTIICSPI3_SHIFT          (0u)
#define INTC_ICDIPR54_INTIICSTI3_SHIFT          (8u)
#define INTC_ICDIPR54_INTIICNAKI3_SHIFT         (16u)
#define INTC_ICDIPR54_INTIICALI3_SHIFT          (24u)

#define INTC_ICDIPR55_INTIICTMOI3_SHIFT         (0u)
#define INTC_ICDIPR55_BRI0_SHIFT                (8u)
#define INTC_ICDIPR55_ERI0_SHIFT                (16u)
#define INTC_ICDIPR55_RXI0_SHIFT                (24u)

#define INTC_ICDIPR56_TXI0_SHIFT                (0u)
#define INTC_ICDIPR56_BRI1_SHIFT                (8u)
#define INTC_ICDIPR56_ERI1_SHIFT                (16u)
#define INTC_ICDIPR56_RXI1_SHIFT                (24u)

#define INTC_ICDIPR57_TXI1_SHIFT                (0u)
#define INTC_ICDIPR57_BRI2_SHIFT                (8u)
#define INTC_ICDIPR57_ERI2_SHIFT                (16u)
#define INTC_ICDIPR57_RXI2_SHIFT                (24u)

#define INTC_ICDIPR58_TXI2_SHIFT                (0u)
#define INTC_ICDIPR58_BRI3_SHIFT                (8u)
#define INTC_ICDIPR58_ERI3_SHIFT                (16u)
#define INTC_ICDIPR58_RXI3_SHIFT                (24u)

#define INTC_ICDIPR59_TXI3_SHIFT                (0u)
#define INTC_ICDIPR59_BRI4_SHIFT                (8u)
#define INTC_ICDIPR59_ERI4_SHIFT                (16u)
#define INTC_ICDIPR59_RXI4_SHIFT                (24u)

#define INTC_ICDIPR60_TXI4_SHIFT                (0u)
#define INTC_ICDIPR60_BRI5_SHIFT                (8u)
#define INTC_ICDIPR60_ERI5_SHIFT                (16u)
#define INTC_ICDIPR60_RXI5_SHIFT                (24u)

#define INTC_ICDIPR61_TXI5_SHIFT                (0u)
#define INTC_ICDIPR61_BRI6_SHIFT                (8u)
#define INTC_ICDIPR61_ERI6_SHIFT                (16u)
#define INTC_ICDIPR61_RXI6_SHIFT                (24u)

#define INTC_ICDIPR62_TXI6_SHIFT                (0u)
#define INTC_ICDIPR62_BRI7_SHIFT                (8u)
#define INTC_ICDIPR62_ERI7_SHIFT                (16u)
#define INTC_ICDIPR62_RXI7_SHIFT                (24u)

#define INTC_ICDIPR63_TXI7_SHIFT                (0u)
#define INTC_ICDIPR63_INTRCANGERR_SHIFT         (8u)
#define INTC_ICDIPR63_INTRCANGRECC_SHIFT        (16u)
#define INTC_ICDIPR63_INTRCAN0REC_SHIFT         (24u)

#define INTC_ICDIPR64_INTRCAN0ERR_SHIFT         (0u)
#define INTC_ICDIPR64_INTRCAN0TRX_SHIFT         (8u)
#define INTC_ICDIPR64_INTRCAN1REC_SHIFT         (16u)
#define INTC_ICDIPR64_INTRCAN1ERR_SHIFT         (24u)

#define INTC_ICDIPR65_INTRCAN1TRX_SHIFT         (0u)
#define INTC_ICDIPR65_INTRCAN2REC_SHIFT         (8u)
#define INTC_ICDIPR65_INTRCAN2ERR_SHIFT         (16u)
#define INTC_ICDIPR65_INTRCAN2TRX_SHIFT         (24u)

#define INTC_ICDIPR66_INTRCAN3REC_SHIFT         (0u)
#define INTC_ICDIPR66_INTRCAN3ERR_SHIFT         (8u)
#define INTC_ICDIPR66_INTRCAN3TRX_SHIFT         (16u)
#define INTC_ICDIPR66_INTRCAN4REC_SHIFT         (24u)

#define INTC_ICDIPR67_INTRCAN4ERR_SHIFT         (0u)
#define INTC_ICDIPR67_INTRCAN4TRX_SHIFT         (8u)
#define INTC_ICDIPR67_SPEI0_SHIFT               (16u)
#define INTC_ICDIPR67_SPRI0_SHIFT               (24u)

#define INTC_ICDIPR68_SPTI0_SHIFT               (0u)
#define INTC_ICDIPR68_SPEI1_SHIFT               (8u)
#define INTC_ICDIPR68_SPRI1_SHIFT               (16u)
#define INTC_ICDIPR68_SPTI1_SHIFT               (24u)

#define INTC_ICDIPR69_SPEI2_SHIFT               (0u)
#define INTC_ICDIPR69_SPRI2_SHIFT               (8u)
#define INTC_ICDIPR69_SPTI2_SHIFT               (16u)
#define INTC_ICDIPR69_SPEI3_SHIFT               (24u)

#define INTC_ICDIPR70_SPRI3_SHIFT               (0u)
#define INTC_ICDIPR70_SPTI3_SHIFT               (8u)
#define INTC_ICDIPR70_SPEI4_SHIFT               (16u)
#define INTC_ICDIPR70_SPRI4_SHIFT               (24u)

#define INTC_ICDIPR71_SPTI4_SHIFT               (0u)
#define INTC_ICDIPR71_IEBBTD_SHIFT              (8u)
#define INTC_ICDIPR71_IEBBTERR_SHIFT            (16u)
#define INTC_ICDIPR71_IEBBTSTA_SHIFT            (24u)

#define INTC_ICDIPR72_IEBBTV_SHIFT              (0u)
#define INTC_ICDIPR72_ISY_SHIFT                 (8u)
#define INTC_ICDIPR72_IERR_SHIFT                (16u)
#define INTC_ICDIPR72_ITARG_SHIFT               (24u)

#define INTC_ICDIPR73_ISEC_SHIFT                (0u)
#define INTC_ICDIPR73_IBUF_SHIFT                (8u)
#define INTC_ICDIPR73_IREADY_SHIFT              (16u)
#define INTC_ICDIPR73_FLSTE_SHIFT               (24u)

#define INTC_ICDIPR74_FLTENDI_SHIFT             (0u)
#define INTC_ICDIPR74_FLTREQ0I_SHIFT            (8u)
#define INTC_ICDIPR74_FLTREQ1I_SHIFT            (16u)
#define INTC_ICDIPR74_MMC0_SHIFT                (24u)

#define INTC_ICDIPR75_MMC1_SHIFT                (0u)
#define INTC_ICDIPR75_MMC2_SHIFT                (8u)
#define INTC_ICDIPR75_SDHI0_3_SHIFT             (16u)
#define INTC_ICDIPR75_SDHI0_0_SHIFT             (24u)

#define INTC_ICDIPR76_SDHI0_1_SHIFT             (0u)
#define INTC_ICDIPR76_SDHI1_3_SHIFT             (8u)
#define INTC_ICDIPR76_SDHI1_0_SHIFT             (16u)
#define INTC_ICDIPR76_SDHI1_1_SHIFT             (24u)

#define INTC_ICDIPR77_ARM_SHIFT                 (0u)
#define INTC_ICDIPR77_PRD_SHIFT                 (8u)
#define INTC_ICDIPR77_CUP_SHIFT                 (16u)
#define INTC_ICDIPR77_SCUAI0_SHIFT              (24u)

#define INTC_ICDIPR78_SCUAI1_SHIFT              (0u)
#define INTC_ICDIPR78_SCUFDI0_SHIFT             (8u)
#define INTC_ICDIPR78_SCUFDI1_SHIFT             (16u)
#define INTC_ICDIPR78_SCUFDI2_SHIFT             (24u)

#define INTC_ICDIPR79_SCUFDI3_SHIFT             (0u)
#define INTC_ICDIPR79_SCUFUI0_SHIFT             (8u)
#define INTC_ICDIPR79_SCUFUI1_SHIFT             (16u)
#define INTC_ICDIPR79_SCUFUI2_SHIFT             (24u)

#define INTC_ICDIPR80_SCUFUI3_SHIFT             (0u)
#define INTC_ICDIPR80_SCUDVI0_SHIFT             (8u)
#define INTC_ICDIPR80_SCUDVI1_SHIFT             (16u)
#define INTC_ICDIPR80_SCUDVI2_SHIFT             (24u)

#define INTC_ICDIPR81_SCUDVI3_SHIFT             (0u)
#define INTC_ICDIPR81_MLB_CINT_SHIFT            (8u)
#define INTC_ICDIPR81_MLB_SINT_SHIFT            (16u)
#define INTC_ICDIPR81_DRC0_SHIFT                (24u)

#define INTC_ICDIPR82_DRC1_SHIFT                (0u)
#define INTC_ICDIPR82_LINI0_INT_T_SHIFT         (24u)

#define INTC_ICDIPR83_LINI0_INT_R_SHIFT         (0u)
#define INTC_ICDIPR83_LINI0_INT_S_SHIFT         (8u)
#define INTC_ICDIPR83_LINI0_INT_M_SHIFT         (16u)
#define INTC_ICDIPR83_LINI1_INT_T_SHIFT         (24u)

#define INTC_ICDIPR84_LINI1_INT_R_SHIFT         (0u)
#define INTC_ICDIPR84_LINI1_INT_S_SHIFT         (8u)
#define INTC_ICDIPR84_LINI1_INT_M_SHIFT         (16u)

#define INTC_ICDIPR86_ERI0_SHIFT                (24u)

#define INTC_ICDIPR87_RXI0_SHIFT                (0u)
#define INTC_ICDIPR87_TXI0_SHIFT                (8u)
#define INTC_ICDIPR87_TEI0_SHIFT                (16u)
#define INTC_ICDIPR87_ERI1_SHIFT                (24u)

#define INTC_ICDIPR88_RXI1_SHIFT                (0u)
#define INTC_ICDIPR88_TXI1_SHIFT                (8u)
#define INTC_ICDIPR88_TEI1_SHIFT                (16u)
#define INTC_ICDIPR88_AVBI_DATA_SHIFT           (24u)

#define INTC_ICDIPR89_AVBI_ERROR_SHIFT          (0u)
#define INTC_ICDIPR89_AVBI_MANAGE_SHIFT         (8u)
#define INTC_ICDIPR89_AVBI_MAC_SHIFT            (16u)
#define INTC_ICDIPR89_ETHERI_SHIFT              (24u)

#define INTC_ICDIPR91_CEUI_SHIFT                (0u)

#define INTC_ICDIPR95_H2XMLB_ERRINT_SHIFT       (8u)
#define INTC_ICDIPR95_H2XIC1_ERRINT_SHIFT       (16u)
#define INTC_ICDIPR95_X2HPERI1_ERRINT_SHIFT     (24u)

#define INTC_ICDIPR96_X2HPERI2_ERRINT_SHIFT     (0u)
#define INTC_ICDIPR96_X2HPERI34_ERRINT_SHIFT    (8u)
#define INTC_ICDIPR96_X2HPERI5_ERRINT_SHIFT     (16u)
#define INTC_ICDIPR96_X2HPERI67_ERRINT_SHIFT    (24u)

#define INTC_ICDIPR97_X2HDBGR_ERRINT_SHIFT      (0u)
#define INTC_ICDIPR97_X2HBSC_ERRINT_SHIFT       (8u)
#define INTC_ICDIPR97_X2HSPI1_ERRINT_SHIFT      (16u)
#define INTC_ICDIPR97_X2HSPI2_ERRINT_SHIFT      (24u)

#define INTC_ICDIPR98_PRRI_SHIFT                (0u)
#define INTC_ICDIPR98_IFEI0_SHIFT               (8u)
#define INTC_ICDIPR98_OFFI0_SHIFT               (16u)
#define INTC_ICDIPR98_PFVEI0_SHIFT              (24u)

#define INTC_ICDIPR99_IFEI1_SHIFT               (0u)
#define INTC_ICDIPR99_OFFI1_SHIFT               (8u)
#define INTC_ICDIPR99_PFVEI1_SHIFT              (16u)

#define INTC_ICDIPR104_TINT0_SHIFT              (0u)
#define INTC_ICDIPR104_TINT1_SHIFT              (8u)
#define INTC_ICDIPR104_TINT2_SHIFT              (16u)
#define INTC_ICDIPR104_TINT3_SHIFT              (24u)

#define INTC_ICDIPR105_TINT4_SHIFT              (0u)
#define INTC_ICDIPR105_TINT5_SHIFT              (8u)
#define INTC_ICDIPR105_TINT6_SHIFT              (16u)
#define INTC_ICDIPR105_TINT7_SHIFT              (24u)

#define INTC_ICDIPR106_TINT8_SHIFT              (0u)
#define INTC_ICDIPR106_TINT9_SHIFT              (8u)
#define INTC_ICDIPR106_TINT10_SHIFT             (16u)
#define INTC_ICDIPR106_TINT11_SHIFT             (24u)

#define INTC_ICDIPR107_TINT12_SHIFT             (0u)
#define INTC_ICDIPR107_TINT13_SHIFT             (8u)
#define INTC_ICDIPR107_TINT14_SHIFT             (16u)
#define INTC_ICDIPR107_TINT15_SHIFT             (24u)

#define INTC_ICDIPR108_TINT16_SHIFT             (0u)
#define INTC_ICDIPR108_TINT17_SHIFT             (8u)
#define INTC_ICDIPR108_TINT18_SHIFT             (16u)
#define INTC_ICDIPR108_TINT19_SHIFT             (24u)

#define INTC_ICDIPR109_TINT20_SHIFT             (0u)
#define INTC_ICDIPR109_TINT21_SHIFT             (8u)
#define INTC_ICDIPR109_TINT22_SHIFT             (16u)
#define INTC_ICDIPR109_TINT23_SHIFT             (24u)

#define INTC_ICDIPR110_TINT24_SHIFT             (0u)
#define INTC_ICDIPR110_TINT25_SHIFT             (8u)
#define INTC_ICDIPR110_TINT26_SHIFT             (16u)
#define INTC_ICDIPR110_TINT27_SHIFT             (24u)

#define INTC_ICDIPR111_TINT28_SHIFT             (0u)
#define INTC_ICDIPR111_TINT29_SHIFT             (8u)
#define INTC_ICDIPR111_TINT30_SHIFT             (16u)
#define INTC_ICDIPR111_TINT31_SHIFT             (24u)

#define INTC_ICDIPR112_TINT32_SHIFT             (0u)
#define INTC_ICDIPR112_TINT33_SHIFT             (8u)
#define INTC_ICDIPR112_TINT34_SHIFT             (16u)
#define INTC_ICDIPR112_TINT35_SHIFT             (24u)

#define INTC_ICDIPR113_TINT36_SHIFT             (0u)
#define INTC_ICDIPR113_TINT37_SHIFT             (8u)
#define INTC_ICDIPR113_TINT38_SHIFT             (16u)
#define INTC_ICDIPR113_TINT39_SHIFT             (24u)

#define INTC_ICDIPR114_TINT40_SHIFT             (0u)
#define INTC_ICDIPR114_TINT41_SHIFT             (8u)
#define INTC_ICDIPR114_TINT42_SHIFT             (16u)
#define INTC_ICDIPR114_TINT43_SHIFT             (24u)

#define INTC_ICDIPR115_TINT44_SHIFT             (0u)
#define INTC_ICDIPR115_TINT45_SHIFT             (8u)
#define INTC_ICDIPR115_TINT46_SHIFT             (16u)
#define INTC_ICDIPR115_TINT47_SHIFT             (24u)

#define INTC_ICDIPR116_TINT48_SHIFT             (0u)
#define INTC_ICDIPR116_TINT49_SHIFT             (8u)
#define INTC_ICDIPR116_TINT50_SHIFT             (16u)
#define INTC_ICDIPR116_TINT51_SHIFT             (24u)

#define INTC_ICDIPR117_TINT52_SHIFT             (0u)
#define INTC_ICDIPR117_TINT53_SHIFT             (8u)
#define INTC_ICDIPR117_TINT54_SHIFT             (16u)
#define INTC_ICDIPR117_TINT55_SHIFT             (24u)

#define INTC_ICDIPR118_TINT56_SHIFT             (0u)
#define INTC_ICDIPR118_TINT57_SHIFT             (8u)
#define INTC_ICDIPR118_TINT58_SHIFT             (16u)
#define INTC_ICDIPR118_TINT59_SHIFT             (24u)

#define INTC_ICDIPR119_TINT60_SHIFT             (0u)
#define INTC_ICDIPR119_TINT61_SHIFT             (8u)
#define INTC_ICDIPR119_TINT62_SHIFT             (16u)
#define INTC_ICDIPR119_TINT63_SHIFT             (24u)

#define INTC_ICDIPR120_TINT64_SHIFT             (0u)
#define INTC_ICDIPR120_TINT65_SHIFT             (8u)
#define INTC_ICDIPR120_TINT66_SHIFT             (16u)
#define INTC_ICDIPR120_TINT67_SHIFT             (24u)

#define INTC_ICDIPR121_TINT68_SHIFT             (0u)
#define INTC_ICDIPR121_TINT69_SHIFT             (8u)
#define INTC_ICDIPR121_TINT70_SHIFT             (16u)
#define INTC_ICDIPR121_TINT71_SHIFT             (24u)

#define INTC_ICDIPR122_TINT72_SHIFT             (0u)
#define INTC_ICDIPR122_TINT73_SHIFT             (8u)
#define INTC_ICDIPR122_TINT74_SHIFT             (16u)
#define INTC_ICDIPR122_TINT75_SHIFT             (24u)

#define INTC_ICDIPR123_TINT76_SHIFT             (0u)
#define INTC_ICDIPR123_TINT77_SHIFT             (8u)
#define INTC_ICDIPR123_TINT78_SHIFT             (16u)
#define INTC_ICDIPR123_TINT79_SHIFT             (24u)

#define INTC_ICDIPR124_TINT80_SHIFT             (0u)
#define INTC_ICDIPR124_TINT81_SHIFT             (8u)
#define INTC_ICDIPR124_TINT82_SHIFT             (16u)
#define INTC_ICDIPR124_TINT83_SHIFT             (24u)

#define INTC_ICDIPR125_TINT84_SHIFT             (0u)
#define INTC_ICDIPR125_TINT85_SHIFT             (8u)
#define INTC_ICDIPR125_TINT86_SHIFT             (16u)
#define INTC_ICDIPR125_TINT87_SHIFT             (24u)

#define INTC_ICDIPR126_TINT88_SHIFT             (0u)
#define INTC_ICDIPR126_TINT89_SHIFT             (8u)
#define INTC_ICDIPR126_TINT90_SHIFT             (16u)
#define INTC_ICDIPR126_TINT91_SHIFT             (24u)

#define INTC_ICDIPR127_TINT92_SHIFT             (0u)
#define INTC_ICDIPR127_TINT93_SHIFT             (8u)
#define INTC_ICDIPR127_TINT94_SHIFT             (16u)
#define INTC_ICDIPR127_TINT95_SHIFT             (24u)

#define INTC_ICDIPR128_TINT96_SHIFT             (0u)
#define INTC_ICDIPR128_TINT97_SHIFT             (8u)
#define INTC_ICDIPR128_TINT98_SHIFT             (16u)
#define INTC_ICDIPR128_TINT99_SHIFT             (24u)

#define INTC_ICDIPR129_TINT100_SHIFT            (0u)
#define INTC_ICDIPR129_TINT101_SHIFT            (8u)
#define INTC_ICDIPR129_TINT102_SHIFT            (16u)
#define INTC_ICDIPR129_TINT103_SHIFT            (24u)

#define INTC_ICDIPR130_TINT104_SHIFT            (0u)
#define INTC_ICDIPR130_TINT105_SHIFT            (8u)
#define INTC_ICDIPR130_TINT106_SHIFT            (16u)
#define INTC_ICDIPR130_TINT107_SHIFT            (24u)

#define INTC_ICDIPR131_TINT108_SHIFT            (0u)
#define INTC_ICDIPR131_TINT109_SHIFT            (8u)
#define INTC_ICDIPR131_TINT110_SHIFT            (16u)
#define INTC_ICDIPR131_TINT111_SHIFT            (24u)

#define INTC_ICDIPR132_TINT112_SHIFT            (0u)
#define INTC_ICDIPR132_TINT113_SHIFT            (8u)
#define INTC_ICDIPR132_TINT114_SHIFT            (16u)
#define INTC_ICDIPR132_TINT115_SHIFT            (24u)

#define INTC_ICDIPR133_TINT116_SHIFT            (0u)
#define INTC_ICDIPR133_TINT117_SHIFT            (8u)
#define INTC_ICDIPR133_TINT118_SHIFT            (16u)
#define INTC_ICDIPR133_TINT119_SHIFT            (24u)

#define INTC_ICDIPR134_TINT120_SHIFT            (0u)
#define INTC_ICDIPR134_TINT121_SHIFT            (8u)
#define INTC_ICDIPR134_TINT122_SHIFT            (16u)
#define INTC_ICDIPR134_TINT123_SHIFT            (24u)

#define INTC_ICDIPR135_TINT124_SHIFT            (0u)
#define INTC_ICDIPR135_TINT125_SHIFT            (8u)
#define INTC_ICDIPR135_TINT126_SHIFT            (16u)
#define INTC_ICDIPR135_TINT127_SHIFT            (24u)

#define INTC_ICDIPR136_TINT128_SHIFT            (0u)
#define INTC_ICDIPR136_TINT129_SHIFT            (8u)
#define INTC_ICDIPR136_TINT130_SHIFT            (16u)
#define INTC_ICDIPR136_TINT131_SHIFT            (24u)

#define INTC_ICDIPR137_TINT132_SHIFT            (0u)
#define INTC_ICDIPR137_TINT133_SHIFT            (8u)
#define INTC_ICDIPR137_TINT134_SHIFT            (16u)
#define INTC_ICDIPR137_TINT135_SHIFT            (24u)

#define INTC_ICDIPR138_TINT136_SHIFT            (0u)
#define INTC_ICDIPR138_TINT137_SHIFT            (8u)
#define INTC_ICDIPR138_TINT138_SHIFT            (16u)
#define INTC_ICDIPR138_TINT139_SHIFT            (24u)

#define INTC_ICDIPR139_TINT140_SHIFT            (0u)
#define INTC_ICDIPR139_TINT141_SHIFT            (8u)
#define INTC_ICDIPR139_TINT142_SHIFT            (16u)
#define INTC_ICDIPR139_TINT143_SHIFT            (24u)

#define INTC_ICDIPR140_TINT144_SHIFT            (0u)
#define INTC_ICDIPR140_TINT145_SHIFT            (8u)
#define INTC_ICDIPR140_TINT146_SHIFT            (16u)
#define INTC_ICDIPR140_TINT147_SHIFT            (24u)

#define INTC_ICDIPR141_TINT148_SHIFT            (0u)
#define INTC_ICDIPR141_TINT149_SHIFT            (8u)
#define INTC_ICDIPR141_TINT150_SHIFT            (16u)
#define INTC_ICDIPR141_TINT151_SHIFT            (24u)

#define INTC_ICDIPR142_TINT152_SHIFT            (0u)
#define INTC_ICDIPR142_TINT153_SHIFT            (8u)
#define INTC_ICDIPR142_TINT154_SHIFT            (16u)
#define INTC_ICDIPR142_TINT155_SHIFT            (24u)

#define INTC_ICDIPR143_TINT156_SHIFT            (0u)
#define INTC_ICDIPR143_TINT157_SHIFT            (8u)
#define INTC_ICDIPR143_TINT158_SHIFT            (16u)
#define INTC_ICDIPR143_TINT159_SHIFT            (24u)

#define INTC_ICDIPR144_TINT160_SHIFT            (0u)
#define INTC_ICDIPR144_TINT161_SHIFT            (8u)
#define INTC_ICDIPR144_TINT162_SHIFT            (16u)
#define INTC_ICDIPR144_TINT163_SHIFT            (24u)

#define INTC_ICDIPR145_TINT164_SHIFT            (0u)
#define INTC_ICDIPR145_TINT165_SHIFT            (8u)
#define INTC_ICDIPR145_TINT166_SHIFT            (16u)
#define INTC_ICDIPR145_TINT167_SHIFT            (24u)

#define INTC_ICDIPR146_TINT168_SHIFT            (0u)
#define INTC_ICDIPR146_TINT169_SHIFT            (8u)
#define INTC_ICDIPR146_TINT170_SHIFT            (16u)

#define INTC_ICDIPTR0_SW0_SHIFT                 (0u)
#define INTC_ICDIPTR0_SW1_SHIFT                 (8u)
#define INTC_ICDIPTR0_SW2_SHIFT                 (16u)
#define INTC_ICDIPTR0_SW3_SHIFT                 (24u)

#define INTC_ICDIPTR1_SW4_SHIFT                 (0u)
#define INTC_ICDIPTR1_SW5_SHIFT                 (8u)
#define INTC_ICDIPTR1_SW6_SHIFT                 (16u)
#define INTC_ICDIPTR1_SW7_SHIFT                 (24u)

#define INTC_ICDIPTR2_SW8_SHIFT                 (0u)
#define INTC_ICDIPTR2_SW9_SHIFT                 (8u)
#define INTC_ICDIPTR2_SW10_SHIFT                (16u)
#define INTC_ICDIPTR2_SW11_SHIFT                (24u)

#define INTC_ICDIPTR3_SW12_SHIFT                (0u)
#define INTC_ICDIPTR3_SW13_SHIFT                (8u)
#define INTC_ICDIPTR3_SW14_SHIFT                (16u)
#define INTC_ICDIPTR3_SW15_SHIFT                (24u)

#define INTC_ICDIPTR4_PMUIRQ0_SHIFT             (0u)
#define INTC_ICDIPTR4_COMMRX0_SHIFT             (8u)
#define INTC_ICDIPTR4_COMMTX0_SHIFT             (16u)
#define INTC_ICDIPTR4_CTIIRQ0_SHIFT             (24u)

#define INTC_ICDIPTR8_IRQ0_SHIFT                (0u)
#define INTC_ICDIPTR8_IRQ1_SHIFT                (8u)
#define INTC_ICDIPTR8_IRQ2_SHIFT                (16u)
#define INTC_ICDIPTR8_IRQ3_SHIFT                (24u)

#define INTC_ICDIPTR9_IRQ4_SHIFT                (0u)
#define INTC_ICDIPTR9_IRQ5_SHIFT                (8u)
#define INTC_ICDIPTR9_IRQ6_SHIFT                (16u)
#define INTC_ICDIPTR9_IRQ7_SHIFT                (24u)

#define INTC_ICDIPTR10_PL310ERR_SHIFT           (0u)
#define INTC_ICDIPTR10_DMAINT0_SHIFT            (8u)
#define INTC_ICDIPTR10_DMAINT1_SHIFT            (16u)
#define INTC_ICDIPTR10_DMAINT2_SHIFT            (24u)

#define INTC_ICDIPTR11_DMAINT3_SHIFT            (0u)
#define INTC_ICDIPTR11_DMAINT4_SHIFT            (8u)
#define INTC_ICDIPTR11_DMAINT5_SHIFT            (16u)
#define INTC_ICDIPTR11_DMAINT6_SHIFT            (24u)

#define INTC_ICDIPTR12_DMAINT7_SHIFT            (0u)
#define INTC_ICDIPTR12_DMAINT8_SHIFT            (8u)
#define INTC_ICDIPTR12_DMAINT9_SHIFT            (16u)
#define INTC_ICDIPTR12_DMAINT10_SHIFT           (24u)

#define INTC_ICDIPTR13_DMAINT11_SHIFT           (0u)
#define INTC_ICDIPTR13_DMAINT12_SHIFT           (8u)
#define INTC_ICDIPTR13_DMAINT13_SHIFT           (16u)
#define INTC_ICDIPTR13_DMAINT14_SHIFT           (24u)

#define INTC_ICDIPTR14_DMAINT15_SHIFT           (0u)
#define INTC_ICDIPTR14_DMAERR_SHIFT             (8u)

#define INTC_ICDIPTR18_USBI0_SHIFT              (8u)
#define INTC_ICDIPTR18_USBI1_SHIFT              (16u)
#define INTC_ICDIPTR18_S0_VI_VSYNC0_SHIFT       (24u)

#define INTC_ICDIPTR19_S0_LO_VSYNC0_SHIFT       (0u)
#define INTC_ICDIPTR19_S0_VSYNCERR0_SHIFT       (8u)
#define INTC_ICDIPTR19_GR3_VLINE0_SHIFT         (16u)
#define INTC_ICDIPTR19_S0_VFIELD0_SHIFT         (24u)

#define INTC_ICDIPTR20_IV1_VBUFERR0_SHIFT       (0u)
#define INTC_ICDIPTR20_IV3_VBUFERR0_SHIFT       (8u)
#define INTC_ICDIPTR20_IV5_VBUFERR0_SHIFT       (16u)
#define INTC_ICDIPTR20_IV6_VBUFERR0_SHIFT       (24u)

#define INTC_ICDIPTR21_S0_WLINE0_SHIFT          (0u)
#define INTC_ICDIPTR21_S1_VI_VSYNC0_SHIFT       (8u)
#define INTC_ICDIPTR21_S1_LO_VSYNC0_SHIFT       (16u)
#define INTC_ICDIPTR21_S1_VSYNCERR0_SHIFT       (24u)

#define INTC_ICDIPTR22_S1_VFIELD0_SHIFT         (0u)
#define INTC_ICDIPTR22_IV2_VBUFERR0_SHIFT       (8u)
#define INTC_ICDIPTR22_IV4_VBUFERR0_SHIFT       (16u)
#define INTC_ICDIPTR22_S1_WLINE0_SHIFT          (24u)

#define INTC_ICDIPTR23_OIR_VI_VSYNC0_SHIFT      (0u)
#define INTC_ICDIPTR23_OIR_LO_VSYNC0_SHIFT      (8u)
#define INTC_ICDIPTR23_OIR_VSYNCERR0_SHIFT      (16u)
#define INTC_ICDIPTR23_OIR_VFIELD0_SHIFT        (24u)

#define INTC_ICDIPTR24_IV7_VBUFERR0_SHIFT       (0u)
#define INTC_ICDIPTR24_IV8_VBUFERR0_SHIFT       (8u)
#define INTC_ICDIPTR24_OIR_WLINE0_SHIFT         (16u)
#define INTC_ICDIPTR24_S0_VI_VSYNC1_SHIFT       (24u)

#define INTC_ICDIPTR25_S0_LO_VSYNC1_SHIFT       (0u)
#define INTC_ICDIPTR25_S0_VSYNCERR1_SHIFT       (8u)
#define INTC_ICDIPTR25_GR3_VLINE1_SHIFT         (16u)
#define INTC_ICDIPTR25_S0_VFIELD1_SHIFT         (24u)

#define INTC_ICDIPTR26_IV1_VBUFERR1_SHIFT       (0u)
#define INTC_ICDIPTR26_IV3_VBUFERR1_SHIFT       (8u)
#define INTC_ICDIPTR26_IV5_VBUFERR1_SHIFT       (16u)
#define INTC_ICDIPTR26_IV6_VBUFERR1_SHIFT       (24u)

#define INTC_ICDIPTR27_S0_WLINE1_SHIFT          (0u)
#define INTC_ICDIPTR27_S1_VI_VSYNC1_SHIFT       (8u)
#define INTC_ICDIPTR27_S1_LO_VSYNC1_SHIFT       (16u)
#define INTC_ICDIPTR27_S1_VSYNCERR1_SHIFT       (24u)

#define INTC_ICDIPTR28_S1_VFIELD1_SHIFT         (0u)
#define INTC_ICDIPTR28_IV2_VBUFERR1_SHIFT       (8u)
#define INTC_ICDIPTR28_IV4_VBUFERR1_SHIFT       (16u)
#define INTC_ICDIPTR28_S1_WLINE1_SHIFT          (24u)

#define INTC_ICDIPTR29_OIR_VI_VSYNC1_SHIFT      (0u)
#define INTC_ICDIPTR29_OIR_LO_VSYNC1_SHIFT      (8u)
#define INTC_ICDIPTR29_OIR_VLINE1_SHIFT         (16u)
#define INTC_ICDIPTR29_OIR_VFIELD1_SHIFT        (24u)

#define INTC_ICDIPTR30_IV7_VBUFERR1_SHIFT       (0u)
#define INTC_ICDIPTR30_IV8_VBUFERR1_SHIFT       (8u)
#define INTC_ICDIPTR30_OIR_WLINE1_SHIFT         (16u)
#define INTC_ICDIPTR30_IMRDI_SHIFT              (24u)

#define INTC_ICDIPTR31_IMR2I0_SHIFT             (0u)
#define INTC_ICDIPTR31_IMR2I1_SHIFT             (8u)
#define INTC_ICDIPTR31_JEDI_SHIFT               (16u)
#define INTC_ICDIPTR31_JDTI_SHIFT               (24u)

#define INTC_ICDIPTR32_CMP0_SHIFT               (0u)
#define INTC_ICDIPTR32_CMP1_SHIFT               (8u)
#define INTC_ICDIPTR32_INT0_SHIFT               (16u)
#define INTC_ICDIPTR32_INT1_SHIFT               (24u)

#define INTC_ICDIPTR33_INT2_SHIFT               (0u)
#define INTC_ICDIPTR33_INT3_SHIFT               (8u)
#define INTC_ICDIPTR33_OSTM0TINT_SHIFT          (16u)
#define INTC_ICDIPTR33_OSTM1TINT_SHIFT          (24u)

#define INTC_ICDIPTR34_CMI_SHIFT                (0u)
#define INTC_ICDIPTR34_WTOUT_SHIFT              (8u)
#define INTC_ICDIPTR34_ITI_SHIFT                (16u)
#define INTC_ICDIPTR34_TGI0A_SHIFT              (24u)

#define INTC_ICDIPTR35_TGI0B_SHIFT              (0u)
#define INTC_ICDIPTR35_TGI0C_SHIFT              (8u)
#define INTC_ICDIPTR35_TGI0D_SHIFT              (16u)
#define INTC_ICDIPTR35_TGI0V_SHIFT              (24u)

#define INTC_ICDIPTR36_TGI0E_SHIFT              (0u)
#define INTC_ICDIPTR36_TGI0F_SHIFT              (8u)
#define INTC_ICDIPTR36_TGI1A_SHIFT              (16u)
#define INTC_ICDIPTR36_TGI1B_SHIFT              (24u)

#define INTC_ICDIPTR37_TGI1V_SHIFT              (0u)
#define INTC_ICDIPTR37_TGI1U_SHIFT              (8u)
#define INTC_ICDIPTR37_TGI2A_SHIFT              (16u)
#define INTC_ICDIPTR37_TGI2B_SHIFT              (24u)

#define INTC_ICDIPTR38_TGI2V_SHIFT              (0u)
#define INTC_ICDIPTR38_TGI2U_SHIFT              (8u)
#define INTC_ICDIPTR38_TGI3A_SHIFT              (16u)
#define INTC_ICDIPTR38_TGI3B_SHIFT              (24u)

#define INTC_ICDIPTR39_TGI3C_SHIFT              (0u)
#define INTC_ICDIPTR39_TGI3D_SHIFT              (8u)
#define INTC_ICDIPTR39_TGI3V_SHIFT              (16u)
#define INTC_ICDIPTR39_TGI4A_SHIFT              (24u)

#define INTC_ICDIPTR40_TGI4B_SHIFT              (0u)
#define INTC_ICDIPTR40_TGI4C_SHIFT              (8u)
#define INTC_ICDIPTR40_TGI4D_SHIFT              (16u)
#define INTC_ICDIPTR40_TGI4V_SHIFT              (24u)

#define INTC_ICDIPTR41_CMI1_SHIFT               (0u)
#define INTC_ICDIPTR41_CMI2_SHIFT               (8u)
#define INTC_ICDIPTR41_SGDEI0_SHIFT             (16u)
#define INTC_ICDIPTR41_SGDEI1_SHIFT             (24u)

#define INTC_ICDIPTR42_SGDEI2_SHIFT             (0u)
#define INTC_ICDIPTR42_SGDEI3_SHIFT             (8u)
#define INTC_ICDIPTR42_ADI_SHIFT                (16u)
#define INTC_ICDIPTR42_LMTI_SHIFT               (24u)

#define INTC_ICDIPTR43_SSII0_SHIFT              (0u)
#define INTC_ICDIPTR43_SSIRXI0_SHIFT            (8u)
#define INTC_ICDIPTR43_SSITXI0_SHIFT            (16u)
#define INTC_ICDIPTR43_SSII1_SHIFT              (24u)

#define INTC_ICDIPTR44_SSIRXI1_SHIFT            (0u)
#define INTC_ICDIPTR44_SSITXI1_SHIFT            (8u)
#define INTC_ICDIPTR44_SSII2_SHIFT              (16u)
#define INTC_ICDIPTR44_SSIRTI2_SHIFT            (24u)

#define INTC_ICDIPTR45_SSII3_SHIFT              (0u)
#define INTC_ICDIPTR45_SSIRXI3_SHIFT            (8u)
#define INTC_ICDIPTR45_SSITXI3_SHIFT            (16u)
#define INTC_ICDIPTR45_SSII4_SHIFT              (24u)

#define INTC_ICDIPTR46_SSIRTI4_SHIFT            (0u)
#define INTC_ICDIPTR46_SSII5_SHIFT              (8u)
#define INTC_ICDIPTR46_SSIRXI5_SHIFT            (16u)
#define INTC_ICDIPTR46_SSITXI5_SHIFT            (24u)

#define INTC_ICDIPTR47_SPDIFI_SHIFT             (0u)
#define INTC_ICDIPTR47_INTIICTEI0_SHIFT         (8u)
#define INTC_ICDIPTR47_INTIICRI0_SHIFT          (16u)
#define INTC_ICDIPTR47_INTIICTI0_SHIFT          (24u)

#define INTC_ICDIPTR48_INTIICSPI0_SHIFT         (0u)
#define INTC_ICDIPTR48_INTIICSTI0_SHIFT         (8u)
#define INTC_ICDIPTR48_INTIICNAKI0_SHIFT        (16u)
#define INTC_ICDIPTR48_INTIICALI0_SHIFT         (24u)

#define INTC_ICDIPTR49_INTIICTMOI0_SHIFT        (0u)
#define INTC_ICDIPTR49_INTIICTEI1_SHIFT         (8u)
#define INTC_ICDIPTR49_INTIICRI1_SHIFT          (16u)
#define INTC_ICDIPTR49_INTIICTI1_SHIFT          (24u)

#define INTC_ICDIPTR50_INTIICSPI1_SHIFT         (0u)
#define INTC_ICDIPTR50_INTIICSTI1_SHIFT         (8u)
#define INTC_ICDIPTR50_INTIICNAKI1_SHIFT        (16u)
#define INTC_ICDIPTR50_INTIICALI1_SHIFT         (24u)

#define INTC_ICDIPTR51_INTIICTMOI1_SHIFT        (0u)
#define INTC_ICDIPTR51_INTIICTEI2_SHIFT         (8u)
#define INTC_ICDIPTR51_INTIICRI2_SHIFT          (16u)
#define INTC_ICDIPTR51_INTIICTI2_SHIFT          (24u)

#define INTC_ICDIPTR52_INTIICSPI2_SHIFT         (0u)
#define INTC_ICDIPTR52_INTIICSTI2_SHIFT         (8u)
#define INTC_ICDIPTR52_INTIICNAKI2_SHIFT        (16u)
#define INTC_ICDIPTR52_INTIICALI2_SHIFT         (24u)

#define INTC_ICDIPTR53_INTIICTMOI2_SHIFT        (0u)
#define INTC_ICDIPTR53_INTIICTEI3_SHIFT         (8u)
#define INTC_ICDIPTR53_INTIICRI3_SHIFT          (16u)
#define INTC_ICDIPTR53_INTIICTI3_SHIFT          (24u)

#define INTC_ICDIPTR54_INTIICSPI3_SHIFT         (0u)
#define INTC_ICDIPTR54_INTIICSTI3_SHIFT         (8u)
#define INTC_ICDIPTR54_INTIICNAKI3_SHIFT        (16u)
#define INTC_ICDIPTR54_INTIICALI3_SHIFT         (24u)

#define INTC_ICDIPTR55_INTIICTMOI3_SHIFT        (0u)
#define INTC_ICDIPTR55_BRI0_SHIFT               (8u)
#define INTC_ICDIPTR55_ERI0_SHIFT               (16u)
#define INTC_ICDIPTR55_RXI0_SHIFT               (24u)

#define INTC_ICDIPTR56_TXI0_SHIFT               (0u)
#define INTC_ICDIPTR56_BRI1_SHIFT               (8u)
#define INTC_ICDIPTR56_ERI1_SHIFT               (16u)
#define INTC_ICDIPTR56_RXI1_SHIFT               (24u)

#define INTC_ICDIPTR57_TXI1_SHIFT               (0u)
#define INTC_ICDIPTR57_BRI2_SHIFT               (8u)
#define INTC_ICDIPTR57_ERI2_SHIFT               (16u)
#define INTC_ICDIPTR57_RXI2_SHIFT               (24u)

#define INTC_ICDIPTR58_TXI2_SHIFT               (0u)
#define INTC_ICDIPTR58_BRI3_SHIFT               (8u)
#define INTC_ICDIPTR58_ERI3_SHIFT               (16u)
#define INTC_ICDIPTR58_RXI3_SHIFT               (24u)

#define INTC_ICDIPTR59_TXI3_SHIFT               (0u)
#define INTC_ICDIPTR59_BRI4_SHIFT               (8u)
#define INTC_ICDIPTR59_ERI4_SHIFT               (16u)
#define INTC_ICDIPTR59_RXI4_SHIFT               (24u)

#define INTC_ICDIPTR60_TXI4_SHIFT               (0u)
#define INTC_ICDIPTR60_BRI5_SHIFT               (8u)
#define INTC_ICDIPTR60_ERI5_SHIFT               (16u)
#define INTC_ICDIPTR60_RXI5_SHIFT               (24u)

#define INTC_ICDIPTR61_TXI5_SHIFT               (0u)
#define INTC_ICDIPTR61_BRI6_SHIFT               (8u)
#define INTC_ICDIPTR61_ERI6_SHIFT               (16u)
#define INTC_ICDIPTR61_RXI6_SHIFT               (24u)

#define INTC_ICDIPTR62_TXI6_SHIFT               (0u)
#define INTC_ICDIPTR62_BRI7_SHIFT               (8u)
#define INTC_ICDIPTR62_ERI7_SHIFT               (16u)
#define INTC_ICDIPTR62_RXI7_SHIFT               (24u)

#define INTC_ICDIPTR63_TXI7_SHIFT               (0u)
#define INTC_ICDIPTR63_INTRCANGERR_SHIFT        (8u)
#define INTC_ICDIPTR63_INTRCANGRECC_SHIFT       (16u)
#define INTC_ICDIPTR63_INTRCAN0REC_SHIFT        (24u)

#define INTC_ICDIPTR64_INTRCAN0ERR_SHIFT        (0u)
#define INTC_ICDIPTR64_INTRCAN0TRX_SHIFT        (8u)
#define INTC_ICDIPTR64_INTRCAN1REC_SHIFT        (16u)
#define INTC_ICDIPTR64_INTRCAN1ERR_SHIFT        (24u)

#define INTC_ICDIPTR65_INTRCAN1TRX_SHIFT        (0u)
#define INTC_ICDIPTR65_INTRCAN2REC_SHIFT        (8u)
#define INTC_ICDIPTR65_INTRCAN2ERR_SHIFT        (16u)
#define INTC_ICDIPTR65_INTRCAN2TRX_SHIFT        (24u)

#define INTC_ICDIPTR66_INTRCAN3REC_SHIFT        (0u)
#define INTC_ICDIPTR66_INTRCAN3ERR_SHIFT        (8u)
#define INTC_ICDIPTR66_INTRCAN3TRX_SHIFT        (16u)
#define INTC_ICDIPTR66_INTRCAN4REC_SHIFT        (24u)

#define INTC_ICDIPTR67_INTRCAN4ERR_SHIFT        (0u)
#define INTC_ICDIPTR67_INTRCAN4TRX_SHIFT        (8u)
#define INTC_ICDIPTR67_SPEI0_SHIFT              (16u)
#define INTC_ICDIPTR67_SPRI0_SHIFT              (24u)

#define INTC_ICDIPTR68_SPTI0_SHIFT              (0u)
#define INTC_ICDIPTR68_SPEI1_SHIFT              (8u)
#define INTC_ICDIPTR68_SPRI1_SHIFT              (16u)
#define INTC_ICDIPTR68_SPTI1_SHIFT              (24u)

#define INTC_ICDIPTR69_SPEI2_SHIFT              (0u)
#define INTC_ICDIPTR69_SPRI2_SHIFT              (8u)
#define INTC_ICDIPTR69_SPTI2_SHIFT              (16u)
#define INTC_ICDIPTR69_SPEI3_SHIFT              (24u)

#define INTC_ICDIPTR70_SPRI3_SHIFT              (0u)
#define INTC_ICDIPTR70_SPTI3_SHIFT              (8u)
#define INTC_ICDIPTR70_SPEI4_SHIFT              (16u)
#define INTC_ICDIPTR70_SPRI4_SHIFT              (24u)

#define INTC_ICDIPTR71_SPTI4_SHIFT              (0u)
#define INTC_ICDIPTR71_IEBBTD_SHIFT             (8u)
#define INTC_ICDIPTR71_IEBBTERR_SHIFT           (16u)
#define INTC_ICDIPTR71_IEBBTSTA_SHIFT           (24u)

#define INTC_ICDIPTR72_IEBBTV_SHIFT             (0u)
#define INTC_ICDIPTR72_ISY_SHIFT                (8u)
#define INTC_ICDIPTR72_IERR_SHIFT               (16u)
#define INTC_ICDIPTR72_ITARG_SHIFT              (24u)

#define INTC_ICDIPTR73_ISEC_SHIFT               (0u)
#define INTC_ICDIPTR73_IBUF_SHIFT               (8u)
#define INTC_ICDIPTR73_IREADY_SHIFT             (16u)
#define INTC_ICDIPTR73_FLSTE_SHIFT              (24u)

#define INTC_ICDIPTR74_FLTENDI_SHIFT            (0u)
#define INTC_ICDIPTR74_FLTREQ0I_SHIFT           (8u)
#define INTC_ICDIPTR74_FLTREQ1I_SHIFT           (16u)
#define INTC_ICDIPTR74_MMC0_SHIFT               (24u)

#define INTC_ICDIPTR75_MMC1_SHIFT               (0u)
#define INTC_ICDIPTR75_MMC2_SHIFT               (8u)
#define INTC_ICDIPTR75_SDHI0_3_SHIFT            (16u)
#define INTC_ICDIPTR75_SDHI0_0_SHIFT            (24u)

#define INTC_ICDIPTR76_SDHI0_1_SHIFT            (0u)
#define INTC_ICDIPTR76_SDHI1_3_SHIFT            (8u)
#define INTC_ICDIPTR76_SDHI1_0_SHIFT            (16u)
#define INTC_ICDIPTR76_SDHI1_1_SHIFT            (24u)

#define INTC_ICDIPTR77_ARM_SHIFT                (0u)
#define INTC_ICDIPTR77_PRD_SHIFT                (8u)
#define INTC_ICDIPTR77_CUP_SHIFT                (16u)
#define INTC_ICDIPTR77_SCUAI0_SHIFT             (24u)

#define INTC_ICDIPTR78_SCUAI1_SHIFT             (0u)
#define INTC_ICDIPTR78_SCUFDI0_SHIFT            (8u)
#define INTC_ICDIPTR78_SCUFDI1_SHIFT            (16u)
#define INTC_ICDIPTR78_SCUFDI2_SHIFT            (24u)

#define INTC_ICDIPTR79_SCUFDI3_SHIFT            (0u)
#define INTC_ICDIPTR79_SCUFUI0_SHIFT            (8u)
#define INTC_ICDIPTR79_SCUFUI1_SHIFT            (16u)
#define INTC_ICDIPTR79_SCUFUI2_SHIFT            (24u)

#define INTC_ICDIPTR80_SCUFUI3_SHIFT            (0u)
#define INTC_ICDIPTR80_SCUDVI0_SHIFT            (8u)
#define INTC_ICDIPTR80_SCUDVI1_SHIFT            (16u)
#define INTC_ICDIPTR80_SCUDVI2_SHIFT            (24u)

#define INTC_ICDIPTR81_SCUDVI3_SHIFT            (0u)
#define INTC_ICDIPTR81_MLB_CINT_SHIFT           (8u)
#define INTC_ICDIPTR81_MLB_SINT_SHIFT           (16u)
#define INTC_ICDIPTR81_DRC0_SHIFT               (24u)

#define INTC_ICDIPTR82_DRC1_SHIFT               (0u)
#define INTC_ICDIPTR82_LINI0_INT_T_SHIFT        (24u)

#define INTC_ICDIPTR83_LINI0_INT_R_SHIFT        (0u)
#define INTC_ICDIPTR83_LINI0_INT_S_SHIFT        (8u)
#define INTC_ICDIPTR83_LINI0_INT_M_SHIFT        (16u)
#define INTC_ICDIPTR83_LINI1_INT_T_SHIFT        (24u)

#define INTC_ICDIPTR84_LINI1_INT_R_SHIFT        (0u)
#define INTC_ICDIPTR84_LINI1_INT_S_SHIFT        (8u)
#define INTC_ICDIPTR84_LINI1_INT_M_SHIFT        (16u)

#define INTC_ICDIPTR86_ERI0_SHIFT               (24u)

#define INTC_ICDIPTR87_RXI0_SHIFT               (0u)
#define INTC_ICDIPTR87_TXI0_SHIFT               (8u)
#define INTC_ICDIPTR87_TEI0_SHIFT               (16u)
#define INTC_ICDIPTR87_ERI1_SHIFT               (24u)

#define INTC_ICDIPTR88_RXI1_SHIFT               (0u)
#define INTC_ICDIPTR88_TXI1_SHIFT               (8u)
#define INTC_ICDIPTR88_TEI1_SHIFT               (16u)
#define INTC_ICDIPTR88_AVBI_DATA_SHIFT          (24u)

#define INTC_ICDIPTR89_AVBI_ERROR_SHIFT         (0u)
#define INTC_ICDIPTR89_AVBI_MANAGE_SHIFT        (8u)
#define INTC_ICDIPTR89_AVBI_MAC_SHIFT           (16u)
#define INTC_ICDIPTR89_ETHERI_SHIFT             (24u)

#define INTC_ICDIPTR91_CEUI_SHIFT               (0u)

#define INTC_ICDIPTR95_H2XMLB_ERRINT_SHIFT      (8u)
#define INTC_ICDIPTR95_H2XIC1_ERRINT_SHIFT      (16u)
#define INTC_ICDIPTR95_X2HPERI1_ERRINT_SHIFT    (24u)

#define INTC_ICDIPTR96_X2HPERI2_ERRINT_SHIFT    (0u)
#define INTC_ICDIPTR96_X2HPERI34_ERRINT_SHIFT   (8u)
#define INTC_ICDIPTR96_X2HPERI5_ERRINT_SHIFT    (16u)
#define INTC_ICDIPTR96_X2HPERI67_ERRINT_SHIFT   (24u)

#define INTC_ICDIPTR97_X2HDBGR_ERRINT_SHIFT     (0u)
#define INTC_ICDIPTR97_X2HBSC_ERRINT_SHIFT      (8u)
#define INTC_ICDIPTR97_X2HSPI1_ERRINT_SHIFT     (16u)
#define INTC_ICDIPTR97_X2HSPI2_ERRINT_SHIFT     (24u)

#define INTC_ICDIPTR98_PRRI_SHIFT               (0u)
#define INTC_ICDIPTR98_IFEI0_SHIFT              (8u)
#define INTC_ICDIPTR98_OFFI0_SHIFT              (16u)
#define INTC_ICDIPTR98_PFVEI0_SHIFT             (24u)

#define INTC_ICDIPTR99_IFEI1_SHIFT              (0u)
#define INTC_ICDIPTR99_OFFI1_SHIFT              (8u)
#define INTC_ICDIPTR99_PFVEI1_SHIFT             (16u)

#define INTC_ICDIPTR104_TINT0_SHIFT             (0u)
#define INTC_ICDIPTR104_TINT1_SHIFT             (8u)
#define INTC_ICDIPTR104_TINT2_SHIFT             (16u)
#define INTC_ICDIPTR104_TINT3_SHIFT             (24u)

#define INTC_ICDIPTR105_TINT4_SHIFT             (0u)
#define INTC_ICDIPTR105_TINT5_SHIFT             (8u)
#define INTC_ICDIPTR105_TINT6_SHIFT             (16u)
#define INTC_ICDIPTR105_TINT7_SHIFT             (24u)

#define INTC_ICDIPTR106_TINT8_SHIFT             (0u)
#define INTC_ICDIPTR106_TINT9_SHIFT             (8u)
#define INTC_ICDIPTR106_TINT10_SHIFT            (16u)
#define INTC_ICDIPTR106_TINT11_SHIFT            (24u)

#define INTC_ICDIPTR107_TINT12_SHIFT            (0u)
#define INTC_ICDIPTR107_TINT13_SHIFT            (8u)
#define INTC_ICDIPTR107_TINT14_SHIFT            (16u)
#define INTC_ICDIPTR107_TINT15_SHIFT            (24u)

#define INTC_ICDIPTR108_TINT16_SHIFT            (0u)
#define INTC_ICDIPTR108_TINT17_SHIFT            (8u)
#define INTC_ICDIPTR108_TINT18_SHIFT            (16u)
#define INTC_ICDIPTR108_TINT19_SHIFT            (24u)

#define INTC_ICDIPTR109_TINT20_SHIFT            (0u)
#define INTC_ICDIPTR109_TINT21_SHIFT            (8u)
#define INTC_ICDIPTR109_TINT22_SHIFT            (16u)
#define INTC_ICDIPTR109_TINT23_SHIFT            (24u)

#define INTC_ICDIPTR110_TINT24_SHIFT            (0u)
#define INTC_ICDIPTR110_TINT25_SHIFT            (8u)
#define INTC_ICDIPTR110_TINT26_SHIFT            (16u)
#define INTC_ICDIPTR110_TINT27_SHIFT            (24u)

#define INTC_ICDIPTR111_TINT28_SHIFT            (0u)
#define INTC_ICDIPTR111_TINT29_SHIFT            (8u)
#define INTC_ICDIPTR111_TINT30_SHIFT            (16u)
#define INTC_ICDIPTR111_TINT31_SHIFT            (24u)

#define INTC_ICDIPTR112_TINT32_SHIFT            (0u)
#define INTC_ICDIPTR112_TINT33_SHIFT            (8u)
#define INTC_ICDIPTR112_TINT34_SHIFT            (16u)
#define INTC_ICDIPTR112_TINT35_SHIFT            (24u)

#define INTC_ICDIPTR113_TINT36_SHIFT            (0u)
#define INTC_ICDIPTR113_TINT37_SHIFT            (8u)
#define INTC_ICDIPTR113_TINT38_SHIFT            (16u)
#define INTC_ICDIPTR113_TINT39_SHIFT            (24u)

#define INTC_ICDIPTR114_TINT40_SHIFT            (0u)
#define INTC_ICDIPTR114_TINT41_SHIFT            (8u)
#define INTC_ICDIPTR114_TINT42_SHIFT            (16u)
#define INTC_ICDIPTR114_TINT43_SHIFT            (24u)

#define INTC_ICDIPTR115_TINT44_SHIFT            (0u)
#define INTC_ICDIPTR115_TINT45_SHIFT            (8u)
#define INTC_ICDIPTR115_TINT46_SHIFT            (16u)
#define INTC_ICDIPTR115_TINT47_SHIFT            (24u)

#define INTC_ICDIPTR116_TINT48_SHIFT            (0u)
#define INTC_ICDIPTR116_TINT49_SHIFT            (8u)
#define INTC_ICDIPTR116_TINT50_SHIFT            (16u)
#define INTC_ICDIPTR116_TINT51_SHIFT            (24u)

#define INTC_ICDIPTR117_TINT52_SHIFT            (0u)
#define INTC_ICDIPTR117_TINT53_SHIFT            (8u)
#define INTC_ICDIPTR117_TINT54_SHIFT            (16u)
#define INTC_ICDIPTR117_TINT55_SHIFT            (24u)

#define INTC_ICDIPTR118_TINT56_SHIFT            (0u)
#define INTC_ICDIPTR118_TINT57_SHIFT            (8u)
#define INTC_ICDIPTR118_TINT58_SHIFT            (16u)
#define INTC_ICDIPTR118_TINT59_SHIFT            (24u)

#define INTC_ICDIPTR119_TINT60_SHIFT            (0u)
#define INTC_ICDIPTR119_TINT61_SHIFT            (8u)
#define INTC_ICDIPTR119_TINT62_SHIFT            (16u)
#define INTC_ICDIPTR119_TINT63_SHIFT            (24u)

#define INTC_ICDIPTR120_TINT64_SHIFT            (0u)
#define INTC_ICDIPTR120_TINT65_SHIFT            (8u)
#define INTC_ICDIPTR120_TINT66_SHIFT            (16u)
#define INTC_ICDIPTR120_TINT67_SHIFT            (24u)

#define INTC_ICDIPTR121_TINT68_SHIFT            (0u)
#define INTC_ICDIPTR121_TINT69_SHIFT            (8u)
#define INTC_ICDIPTR121_TINT70_SHIFT            (16u)
#define INTC_ICDIPTR121_TINT71_SHIFT            (24u)

#define INTC_ICDIPTR122_TINT72_SHIFT            (0u)
#define INTC_ICDIPTR122_TINT73_SHIFT            (8u)
#define INTC_ICDIPTR122_TINT74_SHIFT            (16u)
#define INTC_ICDIPTR122_TINT75_SHIFT            (24u)

#define INTC_ICDIPTR123_TINT76_SHIFT            (0u)
#define INTC_ICDIPTR123_TINT77_SHIFT            (8u)
#define INTC_ICDIPTR123_TINT78_SHIFT            (16u)
#define INTC_ICDIPTR123_TINT79_SHIFT            (24u)

#define INTC_ICDIPTR124_TINT80_SHIFT            (0u)
#define INTC_ICDIPTR124_TINT81_SHIFT            (8u)
#define INTC_ICDIPTR124_TINT82_SHIFT            (16u)
#define INTC_ICDIPTR124_TINT83_SHIFT            (24u)

#define INTC_ICDIPTR125_TINT84_SHIFT            (0u)
#define INTC_ICDIPTR125_TINT85_SHIFT            (8u)
#define INTC_ICDIPTR125_TINT86_SHIFT            (16u)
#define INTC_ICDIPTR125_TINT87_SHIFT            (24u)

#define INTC_ICDIPTR126_TINT88_SHIFT            (0u)
#define INTC_ICDIPTR126_TINT89_SHIFT            (8u)
#define INTC_ICDIPTR126_TINT90_SHIFT            (16u)
#define INTC_ICDIPTR126_TINT91_SHIFT            (24u)

#define INTC_ICDIPTR127_TINT92_SHIFT            (0u)
#define INTC_ICDIPTR127_TINT93_SHIFT            (8u)
#define INTC_ICDIPTR127_TINT94_SHIFT            (16u)
#define INTC_ICDIPTR127_TINT95_SHIFT            (24u)

#define INTC_ICDIPTR128_TINT96_SHIFT            (0u)
#define INTC_ICDIPTR128_TINT97_SHIFT            (8u)
#define INTC_ICDIPTR128_TINT98_SHIFT            (16u)
#define INTC_ICDIPTR128_TINT99_SHIFT            (24u)

#define INTC_ICDIPTR129_TINT100_SHIFT           (0u)
#define INTC_ICDIPTR129_TINT101_SHIFT           (8u)
#define INTC_ICDIPTR129_TINT102_SHIFT           (16u)
#define INTC_ICDIPTR129_TINT103_SHIFT           (24u)

#define INTC_ICDIPTR130_TINT104_SHIFT           (0u)
#define INTC_ICDIPTR130_TINT105_SHIFT           (8u)
#define INTC_ICDIPTR130_TINT106_SHIFT           (16u)
#define INTC_ICDIPTR130_TINT107_SHIFT           (24u)

#define INTC_ICDIPTR131_TINT108_SHIFT           (0u)
#define INTC_ICDIPTR131_TINT109_SHIFT           (8u)
#define INTC_ICDIPTR131_TINT110_SHIFT           (16u)
#define INTC_ICDIPTR131_TINT111_SHIFT           (24u)

#define INTC_ICDIPTR132_TINT112_SHIFT           (0u)
#define INTC_ICDIPTR132_TINT113_SHIFT           (8u)
#define INTC_ICDIPTR132_TINT114_SHIFT           (16u)
#define INTC_ICDIPTR132_TINT115_SHIFT           (24u)

#define INTC_ICDIPTR133_TINT116_SHIFT           (0u)
#define INTC_ICDIPTR133_TINT117_SHIFT           (8u)
#define INTC_ICDIPTR133_TINT118_SHIFT           (16u)
#define INTC_ICDIPTR133_TINT119_SHIFT           (24u)

#define INTC_ICDIPTR134_TINT120_SHIFT           (0u)
#define INTC_ICDIPTR134_TINT121_SHIFT           (8u)
#define INTC_ICDIPTR134_TINT122_SHIFT           (16u)
#define INTC_ICDIPTR134_TINT123_SHIFT           (24u)

#define INTC_ICDIPTR135_TINT124_SHIFT           (0u)
#define INTC_ICDIPTR135_TINT125_SHIFT           (8u)
#define INTC_ICDIPTR135_TINT126_SHIFT           (16u)
#define INTC_ICDIPTR135_TINT127_SHIFT           (24u)

#define INTC_ICDIPTR136_TINT128_SHIFT           (0u)
#define INTC_ICDIPTR136_TINT129_SHIFT           (8u)
#define INTC_ICDIPTR136_TINT130_SHIFT           (16u)
#define INTC_ICDIPTR136_TINT131_SHIFT           (24u)

#define INTC_ICDIPTR137_TINT132_SHIFT           (0u)
#define INTC_ICDIPTR137_TINT133_SHIFT           (8u)
#define INTC_ICDIPTR137_TINT134_SHIFT           (16u)
#define INTC_ICDIPTR137_TINT135_SHIFT           (24u)

#define INTC_ICDIPTR138_TINT136_SHIFT           (0u)
#define INTC_ICDIPTR138_TINT137_SHIFT           (8u)
#define INTC_ICDIPTR138_TINT138_SHIFT           (16u)
#define INTC_ICDIPTR138_TINT139_SHIFT           (24u)

#define INTC_ICDIPTR139_TINT140_SHIFT           (0u)
#define INTC_ICDIPTR139_TINT141_SHIFT           (8u)
#define INTC_ICDIPTR139_TINT142_SHIFT           (16u)
#define INTC_ICDIPTR139_TINT143_SHIFT           (24u)

#define INTC_ICDIPTR140_TINT144_SHIFT           (0u)
#define INTC_ICDIPTR140_TINT145_SHIFT           (8u)
#define INTC_ICDIPTR140_TINT146_SHIFT           (16u)
#define INTC_ICDIPTR140_TINT147_SHIFT           (24u)

#define INTC_ICDIPTR141_TINT148_SHIFT           (0u)
#define INTC_ICDIPTR141_TINT149_SHIFT           (8u)
#define INTC_ICDIPTR141_TINT150_SHIFT           (16u)
#define INTC_ICDIPTR141_TINT151_SHIFT           (24u)

#define INTC_ICDIPTR142_TINT152_SHIFT           (0u)
#define INTC_ICDIPTR142_TINT153_SHIFT           (8u)
#define INTC_ICDIPTR142_TINT154_SHIFT           (16u)
#define INTC_ICDIPTR142_TINT155_SHIFT           (24u)

#define INTC_ICDIPTR143_TINT156_SHIFT           (0u)
#define INTC_ICDIPTR143_TINT157_SHIFT           (8u)
#define INTC_ICDIPTR143_TINT158_SHIFT           (16u)
#define INTC_ICDIPTR143_TINT159_SHIFT           (24u)

#define INTC_ICDIPTR144_TINT160_SHIFT           (0u)
#define INTC_ICDIPTR144_TINT161_SHIFT           (8u)
#define INTC_ICDIPTR144_TINT162_SHIFT           (16u)
#define INTC_ICDIPTR144_TINT163_SHIFT           (24u)

#define INTC_ICDIPTR145_TINT164_SHIFT           (0u)
#define INTC_ICDIPTR145_TINT165_SHIFT           (8u)
#define INTC_ICDIPTR145_TINT166_SHIFT           (16u)
#define INTC_ICDIPTR145_TINT167_SHIFT           (24u)

#define INTC_ICDIPTR146_TINT168_SHIFT           (0u)
#define INTC_ICDIPTR146_TINT169_SHIFT           (8u)
#define INTC_ICDIPTR146_TINT170_SHIFT           (16u)

#define INTC_ICDICFR0_SW0_0_SHIFT               (0u)
#define INTC_ICDICFR0_SW0_1_SHIFT               (1u)
#define INTC_ICDICFR0_SW1_0_SHIFT               (2u)
#define INTC_ICDICFR0_SW1_1_SHIFT               (3u)
#define INTC_ICDICFR0_SW2_0_SHIFT               (4u)
#define INTC_ICDICFR0_SW2_1_SHIFT               (5u)
#define INTC_ICDICFR0_SW3_0_SHIFT               (6u)
#define INTC_ICDICFR0_SW3_1_SHIFT               (7u)
#define INTC_ICDICFR0_SW4_0_SHIFT               (8u)
#define INTC_ICDICFR0_SW4_1_SHIFT               (9u)
#define INTC_ICDICFR0_SW5_0_SHIFT               (10u)
#define INTC_ICDICFR0_SW5_1_SHIFT               (11u)
#define INTC_ICDICFR0_SW6_0_SHIFT               (12u)
#define INTC_ICDICFR0_SW6_1_SHIFT               (13u)
#define INTC_ICDICFR0_SW7_0_SHIFT               (14u)
#define INTC_ICDICFR0_SW7_1_SHIFT               (15u)
#define INTC_ICDICFR0_SW8_0_SHIFT               (16u)
#define INTC_ICDICFR0_SW8_1_SHIFT               (17u)
#define INTC_ICDICFR0_SW9_0_SHIFT               (18u)
#define INTC_ICDICFR0_SW9_1_SHIFT               (19u)
#define INTC_ICDICFR0_SW10_0_SHIFT              (20u)
#define INTC_ICDICFR0_SW10_1_SHIFT              (21u)
#define INTC_ICDICFR0_SW11_0_SHIFT              (22u)
#define INTC_ICDICFR0_SW11_1_SHIFT              (23u)
#define INTC_ICDICFR0_SW12_0_SHIFT              (24u)
#define INTC_ICDICFR0_SW12_1_SHIFT              (25u)
#define INTC_ICDICFR0_SW13_0_SHIFT              (26u)
#define INTC_ICDICFR0_SW13_1_SHIFT              (27u)
#define INTC_ICDICFR0_SW14_0_SHIFT              (28u)
#define INTC_ICDICFR0_SW14_1_SHIFT              (29u)
#define INTC_ICDICFR0_SW15_0_SHIFT              (30u)
#define INTC_ICDICFR0_SW15_1_SHIFT              (31u)

#define INTC_ICDICFR1_PMUIRQ0_0_SHIFT           (0u)
#define INTC_ICDICFR1_PMUIRQ0_1_SHIFT           (1u)
#define INTC_ICDICFR1_COMMRX0_0_SHIFT           (2u)
#define INTC_ICDICFR1_COMMRX0_1_SHIFT           (3u)
#define INTC_ICDICFR1_COMMTX0_0_SHIFT           (4u)
#define INTC_ICDICFR1_COMMTX0_1_SHIFT           (5u)
#define INTC_ICDICFR1_CTIIRQ0_0_SHIFT           (6u)
#define INTC_ICDICFR1_CTIIRQ0_1_SHIFT           (7u)

#define INTC_ICDICFR2_IRQ0_0_SHIFT              (0u)
#define INTC_ICDICFR2_IRQ0_1_SHIFT              (1u)
#define INTC_ICDICFR2_IRQ1_0_SHIFT              (2u)
#define INTC_ICDICFR2_IRQ1_1_SHIFT              (3u)
#define INTC_ICDICFR2_IRQ2_0_SHIFT              (4u)
#define INTC_ICDICFR2_IRQ2_1_SHIFT              (5u)
#define INTC_ICDICFR2_IRQ3_0_SHIFT              (6u)
#define INTC_ICDICFR2_IRQ3_1_SHIFT              (7u)
#define INTC_ICDICFR2_IRQ4_0_SHIFT              (8u)
#define INTC_ICDICFR2_IRQ4_1_SHIFT              (9u)
#define INTC_ICDICFR2_IRQ5_0_SHIFT              (10u)
#define INTC_ICDICFR2_IRQ5_1_SHIFT              (11u)
#define INTC_ICDICFR2_IRQ6_0_SHIFT              (12u)
#define INTC_ICDICFR2_IRQ6_1_SHIFT              (13u)
#define INTC_ICDICFR2_IRQ7_0_SHIFT              (14u)
#define INTC_ICDICFR2_IRQ7_1_SHIFT              (15u)
#define INTC_ICDICFR2_PL310ERR_0_SHIFT          (16u)
#define INTC_ICDICFR2_PL310ERR_1_SHIFT          (17u)
#define INTC_ICDICFR2_DMAINT0_0_SHIFT           (18u)
#define INTC_ICDICFR2_DMAINT0_1_SHIFT           (19u)
#define INTC_ICDICFR2_DMAINT1_0_SHIFT           (20u)
#define INTC_ICDICFR2_DMAINT1_1_SHIFT           (21u)
#define INTC_ICDICFR2_DMAINT2_0_SHIFT           (22u)
#define INTC_ICDICFR2_DMAINT2_1_SHIFT           (23u)
#define INTC_ICDICFR2_DMAINT3_0_SHIFT           (24u)
#define INTC_ICDICFR2_DMAINT3_1_SHIFT           (25u)
#define INTC_ICDICFR2_DMAINT4_0_SHIFT           (26u)
#define INTC_ICDICFR2_DMAINT4_1_SHIFT           (27u)
#define INTC_ICDICFR2_DMAINT5_0_SHIFT           (28u)
#define INTC_ICDICFR2_DMAINT5_1_SHIFT           (29u)
#define INTC_ICDICFR2_DMAINT6_0_SHIFT           (30u)
#define INTC_ICDICFR2_DMAINT6_1_SHIFT           (31u)

#define INTC_ICDICFR3_DMAINT7_0_SHIFT           (0u)
#define INTC_ICDICFR3_DMAINT7_1_SHIFT           (1u)
#define INTC_ICDICFR3_DMAINT8_0_SHIFT           (2u)
#define INTC_ICDICFR3_DMAINT8_1_SHIFT           (3u)
#define INTC_ICDICFR3_DMAINT9_0_SHIFT           (4u)
#define INTC_ICDICFR3_DMAINT9_1_SHIFT           (5u)
#define INTC_ICDICFR3_DMAINT10_0_SHIFT          (6u)
#define INTC_ICDICFR3_DMAINT10_1_SHIFT          (7u)
#define INTC_ICDICFR3_DMAINT11_0_SHIFT          (8u)
#define INTC_ICDICFR3_DMAINT11_1_SHIFT          (9u)
#define INTC_ICDICFR3_DMAINT12_0_SHIFT          (10u)
#define INTC_ICDICFR3_DMAINT12_1_SHIFT          (11u)
#define INTC_ICDICFR3_DMAINT13_0_SHIFT          (12u)
#define INTC_ICDICFR3_DMAINT13_1_SHIFT          (13u)
#define INTC_ICDICFR3_DMAINT14_0_SHIFT          (14u)
#define INTC_ICDICFR3_DMAINT14_1_SHIFT          (15u)
#define INTC_ICDICFR3_DMAINT15_0_SHIFT          (16u)
#define INTC_ICDICFR3_DMAINT15_1_SHIFT          (17u)
#define INTC_ICDICFR3_DMAERR_0_SHIFT            (18u)
#define INTC_ICDICFR3_DMAERR_1_SHIFT            (19u)

#define INTC_ICDICFR4_USBI0_0_SHIFT             (18u)
#define INTC_ICDICFR4_USBI0_1_SHIFT             (19u)
#define INTC_ICDICFR4_USBI1_0_SHIFT             (20u)
#define INTC_ICDICFR4_USBI1_1_SHIFT             (21u)
#define INTC_ICDICFR4_S0_VI_VSYNC0_0_SHIFT      (22u)
#define INTC_ICDICFR4_S0_VI_VSYNC0_1_SHIFT      (23u)
#define INTC_ICDICFR4_S0_LO_VSYNC0_0_SHIFT      (24u)
#define INTC_ICDICFR4_S0_LO_VSYNC0_1_SHIFT      (25u)
#define INTC_ICDICFR4_S0_VSYNCERR0_0_SHIFT      (26u)
#define INTC_ICDICFR4_S0_VSYNCERR0_1_SHIFT      (27u)
#define INTC_ICDICFR4_GR3_VLINE0_0_SHIFT        (28u)
#define INTC_ICDICFR4_GR3_VLINE0_1_SHIFT        (29u)
#define INTC_ICDICFR4_S0_VFIELD0_0_SHIFT        (30u)
#define INTC_ICDICFR4_S0_VFIELD0_1_SHIFT        (31u)

#define INTC_ICDICFR5_IV1_VBUFERR0_0_SHIFT      (0u)
#define INTC_ICDICFR5_IV1_VBUFERR0_1_SHIFT      (1u)
#define INTC_ICDICFR5_IV3_VBUFERR0_0_SHIFT      (2u)
#define INTC_ICDICFR5_IV3_VBUFERR0_1_SHIFT      (3u)
#define INTC_ICDICFR5_IV5_VBUFERR0_0_SHIFT      (4u)
#define INTC_ICDICFR5_IV5_VBUFERR0_1_SHIFT      (5u)
#define INTC_ICDICFR5_IV6_VBUFERR0_0_SHIFT      (6u)
#define INTC_ICDICFR5_IV6_VBUFERR0_1_SHIFT      (7u)
#define INTC_ICDICFR5_S0_WLINE0_0_SHIFT         (8u)
#define INTC_ICDICFR5_S0_WLINE0_1_SHIFT         (9u)
#define INTC_ICDICFR5_S1_VI_VSYNC0_0_SHIFT      (10u)
#define INTC_ICDICFR5_S1_VI_VSYNC0_1_SHIFT      (11u)
#define INTC_ICDICFR5_S1_LO_VSYNC0_0_SHIFT      (12u)
#define INTC_ICDICFR5_S1_LO_VSYNC0_1_SHIFT      (13u)
#define INTC_ICDICFR5_S1_VSYNCERR0_0_SHIFT      (14u)
#define INTC_ICDICFR5_S1_VSYNCERR0_1_SHIFT      (15u)
#define INTC_ICDICFR5_S1_VFIELD0_0_SHIFT        (16u)
#define INTC_ICDICFR5_S1_VFIELD0_1_SHIFT        (17u)
#define INTC_ICDICFR5_IV2_VBUFERR0_0_SHIFT      (18u)
#define INTC_ICDICFR5_IV2_VBUFERR0_1_SHIFT      (19u)
#define INTC_ICDICFR5_IV4_VBUFERR0_0_SHIFT      (20u)
#define INTC_ICDICFR5_IV4_VBUFERR0_1_SHIFT      (21u)
#define INTC_ICDICFR5_S1_WLINE0_0_SHIFT         (22u)
#define INTC_ICDICFR5_S1_WLINE0_1_SHIFT         (23u)
#define INTC_ICDICFR5_OIR_VI_VSYNC0_0_SHIFT     (24u)
#define INTC_ICDICFR5_OIR_VI_VSYNC0_1_SHIFT     (25u)
#define INTC_ICDICFR5_OIR_LO_VSYNC0_0_SHIFT     (26u)
#define INTC_ICDICFR5_OIR_LO_VSYNC0_1_SHIFT     (27u)
#define INTC_ICDICFR5_OIR_VSYNCERR0_0_SHIFT     (28u)
#define INTC_ICDICFR5_OIR_VSYNCERR0_1_SHIFT     (29u)
#define INTC_ICDICFR5_OIR_VFIELD0_0_SHIFT       (30u)
#define INTC_ICDICFR5_OIR_VFIELD0_1_SHIFT       (31u)

#define INTC_ICDICFR6_IV7_VBUFERR0_0_SHIFT      (0u)
#define INTC_ICDICFR6_IV7_VBUFERR0_1_SHIFT      (1u)
#define INTC_ICDICFR6_IV8_VBUFERR0_0_SHIFT      (2u)
#define INTC_ICDICFR6_IV8_VBUFERR0_1_SHIFT      (3u)
#define INTC_ICDICFR6_OIR_WLINE0_0_SHIFT        (4u)
#define INTC_ICDICFR6_OIR_WLINE0_1_SHIFT        (5u)
#define INTC_ICDICFR6_S0_VI_VSYNC1_0_SHIFT      (6u)
#define INTC_ICDICFR6_S0_VI_VSYNC1_1_SHIFT      (7u)
#define INTC_ICDICFR6_S0_LO_VSYNC1_0_SHIFT      (8u)
#define INTC_ICDICFR6_S0_LO_VSYNC1_1_SHIFT      (9u)
#define INTC_ICDICFR6_S0_VSYNCERR1_0_SHIFT      (10u)
#define INTC_ICDICFR6_S0_VSYNCERR1_1_SHIFT      (11u)
#define INTC_ICDICFR6_GR3_VLINE1_0_SHIFT        (12u)
#define INTC_ICDICFR6_GR3_VLINE1_1_SHIFT        (13u)
#define INTC_ICDICFR6_S0_VFIELD1_0_SHIFT        (14u)
#define INTC_ICDICFR6_S0_VFIELD1_1_SHIFT        (15u)
#define INTC_ICDICFR6_IV1_VBUFERR1_0_SHIFT      (16u)
#define INTC_ICDICFR6_IV1_VBUFERR1_1_SHIFT      (17u)
#define INTC_ICDICFR6_IV3_VBUFERR1_0_SHIFT      (18u)
#define INTC_ICDICFR6_IV3_VBUFERR1_1_SHIFT      (19u)
#define INTC_ICDICFR6_IV5_VBUFERR1_0_SHIFT      (20u)
#define INTC_ICDICFR6_IV5_VBUFERR1_1_SHIFT      (21u)
#define INTC_ICDICFR6_IV6_VBUFERR1_0_SHIFT      (22u)
#define INTC_ICDICFR6_IV6_VBUFERR1_1_SHIFT      (23u)
#define INTC_ICDICFR6_S0_WLINE1_0_SHIFT         (24u)
#define INTC_ICDICFR6_S0_WLINE1_1_SHIFT         (25u)
#define INTC_ICDICFR6_S1_VI_VSYNC1_0_SHIFT      (26u)
#define INTC_ICDICFR6_S1_VI_VSYNC1_1_SHIFT      (27u)
#define INTC_ICDICFR6_S1_LO_VSYNC1_0_SHIFT      (28u)
#define INTC_ICDICFR6_S1_LO_VSYNC1_1_SHIFT      (29u)
#define INTC_ICDICFR6_S1_VSYNCERR1_0_SHIFT      (30u)
#define INTC_ICDICFR6_S1_VSYNCERR1_1_SHIFT      (31u)

#define INTC_ICDICFR7_S1_VFIELD1_0_SHIFT        (0u)
#define INTC_ICDICFR7_S1_VFIELD1_1_SHIFT        (1u)
#define INTC_ICDICFR7_IV2_VBUFERR1_0_SHIFT      (2u)
#define INTC_ICDICFR7_IV2_VBUFERR1_1_SHIFT      (3u)
#define INTC_ICDICFR7_IV4_VBUFERR1_0_SHIFT      (4u)
#define INTC_ICDICFR7_IV4_VBUFERR1_1_SHIFT      (5u)
#define INTC_ICDICFR7_S1_WLINE1_0_SHIFT         (6u)
#define INTC_ICDICFR7_S1_WLINE1_1_SHIFT         (7u)
#define INTC_ICDICFR7_OIR_VI_VSYNC1_0_SHIFT     (8u)
#define INTC_ICDICFR7_OIR_VI_VSYNC1_1_SHIFT     (9u)
#define INTC_ICDICFR7_OIR_LO_VSYNC1_0_SHIFT     (10u)
#define INTC_ICDICFR7_OIR_LO_VSYNC1_1_SHIFT     (11u)
#define INTC_ICDICFR7_OIR_VLINE1_0_SHIFT        (12u)
#define INTC_ICDICFR7_OIR_VLINE1_1_SHIFT        (13u)
#define INTC_ICDICFR7_OIR_VFIELD1_0_SHIFT       (14u)
#define INTC_ICDICFR7_OIR_VFIELD1_1_SHIFT       (15u)
#define INTC_ICDICFR7_IV7_VBUFERR1_0_SHIFT      (16u)
#define INTC_ICDICFR7_IV7_VBUFERR1_1_SHIFT      (17u)
#define INTC_ICDICFR7_IV8_VBUFERR1_0_SHIFT      (18u)
#define INTC_ICDICFR7_IV8_VBUFERR1_1_SHIFT      (19u)
#define INTC_ICDICFR7_OIR_WLINE1_0_SHIFT        (20u)
#define INTC_ICDICFR7_OIR_WLINE1_1_SHIFT        (21u)
#define INTC_ICDICFR7_IMRDI_0_SHIFT             (22u)
#define INTC_ICDICFR7_IMRDI_1_SHIFT             (23u)
#define INTC_ICDICFR7_IMR2I0_0_SHIFT            (24u)
#define INTC_ICDICFR7_IMR2I0_1_SHIFT            (25u)
#define INTC_ICDICFR7_IMR2I1_0_SHIFT            (26u)
#define INTC_ICDICFR7_IMR2I1_1_SHIFT            (27u)
#define INTC_ICDICFR7_JEDI_0_SHIFT              (28u)
#define INTC_ICDICFR7_JEDI_1_SHIFT              (29u)
#define INTC_ICDICFR7_JDTI_0_SHIFT              (30u)
#define INTC_ICDICFR7_JDTI_1_SHIFT              (31u)

#define INTC_ICDICFR8_CMP0_0_SHIFT              (0u)
#define INTC_ICDICFR8_CMP0_1_SHIFT              (1u)
#define INTC_ICDICFR8_CMP1_0_SHIFT              (2u)
#define INTC_ICDICFR8_CMP1_1_SHIFT              (3u)
#define INTC_ICDICFR8_INT0_0_SHIFT              (4u)
#define INTC_ICDICFR8_INT0_1_SHIFT              (5u)
#define INTC_ICDICFR8_INT1_0_SHIFT              (6u)
#define INTC_ICDICFR8_INT1_1_SHIFT              (7u)
#define INTC_ICDICFR8_INT2_0_SHIFT              (8u)
#define INTC_ICDICFR8_INT2_1_SHIFT              (9u)
#define INTC_ICDICFR8_INT3_0_SHIFT              (10u)
#define INTC_ICDICFR8_INT3_1_SHIFT              (11u)
#define INTC_ICDICFR8_OSTM0TINT_0_SHIFT         (12u)
#define INTC_ICDICFR8_OSTM0TINT_1_SHIFT         (13u)
#define INTC_ICDICFR8_OSTM1TINT_0_SHIFT         (14u)
#define INTC_ICDICFR8_OSTM1TINT_1_SHIFT         (15u)
#define INTC_ICDICFR8_CMI_0_SHIFT               (16u)
#define INTC_ICDICFR8_CMI_1_SHIFT               (17u)
#define INTC_ICDICFR8_WTOUT_0_SHIFT             (18u)
#define INTC_ICDICFR8_WTOUT_1_SHIFT             (19u)
#define INTC_ICDICFR8_ITI_0_SHIFT               (20u)
#define INTC_ICDICFR8_ITI_1_SHIFT               (21u)
#define INTC_ICDICFR8_TGI0A_0_SHIFT             (22u)
#define INTC_ICDICFR8_TGI0A_1_SHIFT             (23u)
#define INTC_ICDICFR8_TGI0B_0_SHIFT             (24u)
#define INTC_ICDICFR8_TGI0B_1_SHIFT             (25u)
#define INTC_ICDICFR8_TGI0C_0_SHIFT             (26u)
#define INTC_ICDICFR8_TGI0C_1_SHIFT             (27u)
#define INTC_ICDICFR8_TGI0D_0_SHIFT             (28u)
#define INTC_ICDICFR8_TGI0D_1_SHIFT             (29u)
#define INTC_ICDICFR8_TGI0V_0_SHIFT             (30u)
#define INTC_ICDICFR8_TGI0V_1_SHIFT             (31u)

#define INTC_ICDICFR9_TGI0E_0_SHIFT             (0u)
#define INTC_ICDICFR9_TGI0E_1_SHIFT             (1u)
#define INTC_ICDICFR9_TGI0F_0_SHIFT             (2u)
#define INTC_ICDICFR9_TGI0F_1_SHIFT             (3u)
#define INTC_ICDICFR9_TGI1A_0_SHIFT             (4u)
#define INTC_ICDICFR9_TGI1A_1_SHIFT             (5u)
#define INTC_ICDICFR9_TGI1B_0_SHIFT             (6u)
#define INTC_ICDICFR9_TGI1B_1_SHIFT             (7u)
#define INTC_ICDICFR9_TGI1V_0_SHIFT             (8u)
#define INTC_ICDICFR9_TGI1V_1_SHIFT             (9u)
#define INTC_ICDICFR9_TGI1U_0_SHIFT             (10u)
#define INTC_ICDICFR9_TGI1U_1_SHIFT             (11u)
#define INTC_ICDICFR9_TGI2A_0_SHIFT             (12u)
#define INTC_ICDICFR9_TGI2A_1_SHIFT             (13u)
#define INTC_ICDICFR9_TGI2B_0_SHIFT             (14u)
#define INTC_ICDICFR9_TGI2B_1_SHIFT             (15u)
#define INTC_ICDICFR9_TGI2V_0_SHIFT             (16u)
#define INTC_ICDICFR9_TGI2V_1_SHIFT             (17u)
#define INTC_ICDICFR9_TGI2U_0_SHIFT             (18u)
#define INTC_ICDICFR9_TGI2U_1_SHIFT             (19u)
#define INTC_ICDICFR9_TGI3A_0_SHIFT             (20u)
#define INTC_ICDICFR9_TGI3A_1_SHIFT             (21u)
#define INTC_ICDICFR9_TGI3B_0_SHIFT             (22u)
#define INTC_ICDICFR9_TGI3B_1_SHIFT             (23u)
#define INTC_ICDICFR9_TGI3C_0_SHIFT             (24u)
#define INTC_ICDICFR9_TGI3C_1_SHIFT             (25u)
#define INTC_ICDICFR9_TGI3D_0_SHIFT             (26u)
#define INTC_ICDICFR9_TGI3D_1_SHIFT             (27u)
#define INTC_ICDICFR9_TGI3V_0_SHIFT             (28u)
#define INTC_ICDICFR9_TGI3V_1_SHIFT             (29u)
#define INTC_ICDICFR9_TGI4A_0_SHIFT             (30u)
#define INTC_ICDICFR9_TGI4A_1_SHIFT             (31u)

#define INTC_ICDICFR10_TGI4B_0_SHIFT            (0u)
#define INTC_ICDICFR10_TGI4B_1_SHIFT            (1u)
#define INTC_ICDICFR10_TGI4C_0_SHIFT            (2u)
#define INTC_ICDICFR10_TGI4C_1_SHIFT            (3u)
#define INTC_ICDICFR10_TGI4D_0_SHIFT            (4u)
#define INTC_ICDICFR10_TGI4D_1_SHIFT            (5u)
#define INTC_ICDICFR10_TGI4V_0_SHIFT            (6u)
#define INTC_ICDICFR10_TGI4V_1_SHIFT            (7u)
#define INTC_ICDICFR10_CMI1_0_SHIFT             (8u)
#define INTC_ICDICFR10_CMI1_1_SHIFT             (9u)
#define INTC_ICDICFR10_CMI2_0_SHIFT             (10u)
#define INTC_ICDICFR10_CMI2_1_SHIFT             (11u)
#define INTC_ICDICFR10_SGDEI0_0_SHIFT           (12u)
#define INTC_ICDICFR10_SGDEI0_1_SHIFT           (13u)
#define INTC_ICDICFR10_SGDEI1_0_SHIFT           (14u)
#define INTC_ICDICFR10_SGDEI1_1_SHIFT           (15u)
#define INTC_ICDICFR10_SGDEI2_0_SHIFT           (16u)
#define INTC_ICDICFR10_SGDEI2_1_SHIFT           (17u)
#define INTC_ICDICFR10_SGDEI3_0_SHIFT           (18u)
#define INTC_ICDICFR10_SGDEI3_1_SHIFT           (19u)
#define INTC_ICDICFR10_ADI_0_SHIFT              (20u)
#define INTC_ICDICFR10_ADI_1_SHIFT              (21u)
#define INTC_ICDICFR10_LMTI_0_SHIFT             (22u)
#define INTC_ICDICFR10_LMTI_1_SHIFT             (23u)
#define INTC_ICDICFR10_SSII0_0_SHIFT            (24u)
#define INTC_ICDICFR10_SSII0_1_SHIFT            (25u)
#define INTC_ICDICFR10_SSIRXI0_0_SHIFT          (26u)
#define INTC_ICDICFR10_SSIRXI0_1_SHIFT          (27u)
#define INTC_ICDICFR10_SSITXI0_0_SHIFT          (28u)
#define INTC_ICDICFR10_SSITXI0_1_SHIFT          (29u)
#define INTC_ICDICFR10_SSII1_0_SHIFT            (30u)
#define INTC_ICDICFR10_SSII1_1_SHIFT            (31u)

#define INTC_ICDICFR11_SSIRXI1_0_SHIFT          (0u)
#define INTC_ICDICFR11_SSIRXI1_1_SHIFT          (1u)
#define INTC_ICDICFR11_SSITXI1_0_SHIFT          (2u)
#define INTC_ICDICFR11_SSITXI1_1_SHIFT          (3u)
#define INTC_ICDICFR11_SSII2_0_SHIFT            (4u)
#define INTC_ICDICFR11_SSII2_1_SHIFT            (5u)
#define INTC_ICDICFR11_SSIRTI2_0_SHIFT          (6u)
#define INTC_ICDICFR11_SSIRTI2_1_SHIFT          (7u)
#define INTC_ICDICFR11_SSII3_0_SHIFT            (8u)
#define INTC_ICDICFR11_SSII3_1_SHIFT            (9u)
#define INTC_ICDICFR11_SSIRXI3_0_SHIFT          (10u)
#define INTC_ICDICFR11_SSIRXI3_1_SHIFT          (11u)
#define INTC_ICDICFR11_SSITXI3_0_SHIFT          (12u)
#define INTC_ICDICFR11_SSITXI3_1_SHIFT          (13u)
#define INTC_ICDICFR11_SSII4_0_SHIFT            (14u)
#define INTC_ICDICFR11_SSII4_1_SHIFT            (15u)
#define INTC_ICDICFR11_SSIRTI4_0_SHIFT          (16u)
#define INTC_ICDICFR11_SSIRTI4_1_SHIFT          (17u)
#define INTC_ICDICFR11_SSII5_0_SHIFT            (18u)
#define INTC_ICDICFR11_SSII5_1_SHIFT            (19u)
#define INTC_ICDICFR11_SSIRXI5_0_SHIFT          (20u)
#define INTC_ICDICFR11_SSIRXI5_1_SHIFT          (21u)
#define INTC_ICDICFR11_SSITXI5_0_SHIFT          (22u)
#define INTC_ICDICFR11_SSITXI5_1_SHIFT          (23u)
#define INTC_ICDICFR11_SPDIFI_0_SHIFT           (24u)
#define INTC_ICDICFR11_SPDIFI_1_SHIFT           (25u)
#define INTC_ICDICFR11_INTIICTEI0_0_SHIFT       (26u)
#define INTC_ICDICFR11_INTIICTEI0_1_SHIFT       (27u)
#define INTC_ICDICFR11_INTIICRI0_0_SHIFT        (28u)
#define INTC_ICDICFR11_INTIICRI0_1_SHIFT        (29u)
#define INTC_ICDICFR11_INTIICTI0_0_SHIFT        (30u)
#define INTC_ICDICFR11_INTIICTI0_1_SHIFT        (31u)

#define INTC_ICDICFR12_INTIICSPI0_0_SHIFT       (0u)
#define INTC_ICDICFR12_INTIICSPI0_1_SHIFT       (1u)
#define INTC_ICDICFR12_INTIICSTI0_0_SHIFT       (2u)
#define INTC_ICDICFR12_INTIICSTI0_1_SHIFT       (3u)
#define INTC_ICDICFR12_INTIICNAKI0_0_SHIFT      (4u)
#define INTC_ICDICFR12_INTIICNAKI0_1_SHIFT      (5u)
#define INTC_ICDICFR12_INTIICALI0_0_SHIFT       (6u)
#define INTC_ICDICFR12_INTIICALI0_1_SHIFT       (7u)
#define INTC_ICDICFR12_INTIICTMOI0_0_SHIFT      (8u)
#define INTC_ICDICFR12_INTIICTMOI0_1_SHIFT      (9u)
#define INTC_ICDICFR12_INTIICTEI1_0_SHIFT       (10u)
#define INTC_ICDICFR12_INTIICTEI1_1_SHIFT       (11u)
#define INTC_ICDICFR12_INTIICRI1_0_SHIFT        (12u)
#define INTC_ICDICFR12_INTIICRI1_1_SHIFT        (13u)
#define INTC_ICDICFR12_INTIICTI1_0_SHIFT        (14u)
#define INTC_ICDICFR12_INTIICTI1_1_SHIFT        (15u)
#define INTC_ICDICFR12_INTIICSPI1_0_SHIFT       (16u)
#define INTC_ICDICFR12_INTIICSPI1_1_SHIFT       (17u)
#define INTC_ICDICFR12_INTIICSTI1_0_SHIFT       (18u)
#define INTC_ICDICFR12_INTIICSTI1_1_SHIFT       (19u)
#define INTC_ICDICFR12_INTIICNAKI1_0_SHIFT      (20u)
#define INTC_ICDICFR12_INTIICNAKI1_1_SHIFT      (21u)
#define INTC_ICDICFR12_INTIICALI1_0_SHIFT       (22u)
#define INTC_ICDICFR12_INTIICALI1_1_SHIFT       (23u)
#define INTC_ICDICFR12_INTIICTMOI1_0_SHIFT      (24u)
#define INTC_ICDICFR12_INTIICTMOI1_1_SHIFT      (25u)
#define INTC_ICDICFR12_INTIICTEI2_0_SHIFT       (26u)
#define INTC_ICDICFR12_INTIICTEI2_1_SHIFT       (27u)
#define INTC_ICDICFR12_INTIICRI2_0_SHIFT        (28u)
#define INTC_ICDICFR12_INTIICRI2_1_SHIFT        (29u)
#define INTC_ICDICFR12_INTIICTI2_0_SHIFT        (30u)
#define INTC_ICDICFR12_INTIICTI2_1_SHIFT        (31u)

#define INTC_ICDICFR13_INTIICSPI2_0_SHIFT       (0u)
#define INTC_ICDICFR13_INTIICSPI2_1_SHIFT       (1u)
#define INTC_ICDICFR13_INTIICSTI2_0_SHIFT       (2u)
#define INTC_ICDICFR13_INTIICSTI2_1_SHIFT       (3u)
#define INTC_ICDICFR13_INTIICNAKI2_0_SHIFT      (4u)
#define INTC_ICDICFR13_INTIICNAKI2_1_SHIFT      (5u)
#define INTC_ICDICFR13_INTIICALI2_0_SHIFT       (6u)
#define INTC_ICDICFR13_INTIICALI2_1_SHIFT       (7u)
#define INTC_ICDICFR13_INTIICTMOI2_0_SHIFT      (8u)
#define INTC_ICDICFR13_INTIICTMOI2_1_SHIFT      (9u)
#define INTC_ICDICFR13_INTIICTEI3_0_SHIFT       (10u)
#define INTC_ICDICFR13_INTIICTEI3_1_SHIFT       (11u)
#define INTC_ICDICFR13_INTIICRI3_0_SHIFT        (12u)
#define INTC_ICDICFR13_INTIICRI3_1_SHIFT        (13u)
#define INTC_ICDICFR13_INTIICTI3_0_SHIFT        (14u)
#define INTC_ICDICFR13_INTIICTI3_1_SHIFT        (15u)
#define INTC_ICDICFR13_INTIICSPI3_0_SHIFT       (16u)
#define INTC_ICDICFR13_INTIICSPI3_1_SHIFT       (17u)
#define INTC_ICDICFR13_INTIICSTI3_0_SHIFT       (18u)
#define INTC_ICDICFR13_INTIICSTI3_1_SHIFT       (19u)
#define INTC_ICDICFR13_INTIICNAKI3_0_SHIFT      (20u)
#define INTC_ICDICFR13_INTIICNAKI3_1_SHIFT      (21u)
#define INTC_ICDICFR13_INTIICALI3_0_SHIFT       (22u)
#define INTC_ICDICFR13_INTIICALI3_1_SHIFT       (23u)
#define INTC_ICDICFR13_INTIICTMOI3_0_SHIFT      (24u)
#define INTC_ICDICFR13_INTIICTMOI3_1_SHIFT      (25u)
#define INTC_ICDICFR13_BRI0_0_SHIFT             (26u)
#define INTC_ICDICFR13_BRI0_1_SHIFT             (27u)
#define INTC_ICDICFR13_ERI0_0_SHIFT             (28u)
#define INTC_ICDICFR13_ERI0_1_SHIFT             (29u)
#define INTC_ICDICFR13_RXI0_0_SHIFT             (30u)
#define INTC_ICDICFR13_RXI0_1_SHIFT             (31u)

#define INTC_ICDICFR14_TXI0_0_SHIFT             (0u)
#define INTC_ICDICFR14_TXI0_1_SHIFT             (1u)
#define INTC_ICDICFR14_BRI1_0_SHIFT             (2u)
#define INTC_ICDICFR14_BRI1_1_SHIFT             (3u)
#define INTC_ICDICFR14_ERI1_0_SHIFT             (4u)
#define INTC_ICDICFR14_ERI1_1_SHIFT             (5u)
#define INTC_ICDICFR14_RXI1_0_SHIFT             (6u)
#define INTC_ICDICFR14_RXI1_1_SHIFT             (7u)
#define INTC_ICDICFR14_TXI1_0_SHIFT             (8u)
#define INTC_ICDICFR14_TXI1_1_SHIFT             (9u)
#define INTC_ICDICFR14_BRI2_0_SHIFT             (10u)
#define INTC_ICDICFR14_BRI2_1_SHIFT             (11u)
#define INTC_ICDICFR14_ERI2_0_SHIFT             (12u)
#define INTC_ICDICFR14_ERI2_1_SHIFT             (13u)
#define INTC_ICDICFR14_RXI2_0_SHIFT             (14u)
#define INTC_ICDICFR14_RXI2_1_SHIFT             (15u)
#define INTC_ICDICFR14_TXI2_0_SHIFT             (16u)
#define INTC_ICDICFR14_TXI2_1_SHIFT             (17u)
#define INTC_ICDICFR14_BRI3_0_SHIFT             (18u)
#define INTC_ICDICFR14_BRI3_1_SHIFT             (19u)
#define INTC_ICDICFR14_ERI3_0_SHIFT             (20u)
#define INTC_ICDICFR14_ERI3_1_SHIFT             (21u)
#define INTC_ICDICFR14_RXI3_0_SHIFT             (22u)
#define INTC_ICDICFR14_RXI3_1_SHIFT             (23u)
#define INTC_ICDICFR14_TXI3_0_SHIFT             (24u)
#define INTC_ICDICFR14_TXI3_1_SHIFT             (25u)
#define INTC_ICDICFR14_BRI4_0_SHIFT             (26u)
#define INTC_ICDICFR14_BRI4_1_SHIFT             (27u)
#define INTC_ICDICFR14_ERI4_0_SHIFT             (28u)
#define INTC_ICDICFR14_ERI4_1_SHIFT             (29u)
#define INTC_ICDICFR14_RXI4_0_SHIFT             (30u)
#define INTC_ICDICFR14_RXI4_1_SHIFT             (31u)

#define INTC_ICDICFR15_TXI4_0_SHIFT             (0u)
#define INTC_ICDICFR15_TXI4_1_SHIFT             (1u)
#define INTC_ICDICFR15_BRI5_0_SHIFT             (2u)
#define INTC_ICDICFR15_BRI5_1_SHIFT             (3u)
#define INTC_ICDICFR15_ERI5_0_SHIFT             (4u)
#define INTC_ICDICFR15_ERI5_1_SHIFT             (5u)
#define INTC_ICDICFR15_RXI5_0_SHIFT             (6u)
#define INTC_ICDICFR15_RXI5_1_SHIFT             (7u)
#define INTC_ICDICFR15_TXI5_0_SHIFT             (8u)
#define INTC_ICDICFR15_TXI5_1_SHIFT             (9u)
#define INTC_ICDICFR15_BRI6_0_SHIFT             (10u)
#define INTC_ICDICFR15_BRI6_1_SHIFT             (11u)
#define INTC_ICDICFR15_ERI6_0_SHIFT             (12u)
#define INTC_ICDICFR15_ERI6_1_SHIFT             (13u)
#define INTC_ICDICFR15_RXI6_0_SHIFT             (14u)
#define INTC_ICDICFR15_RXI6_1_SHIFT             (15u)
#define INTC_ICDICFR15_TXI6_0_SHIFT             (16u)
#define INTC_ICDICFR15_TXI6_1_SHIFT             (17u)
#define INTC_ICDICFR15_BRI7_0_SHIFT             (18u)
#define INTC_ICDICFR15_BRI7_1_SHIFT             (19u)
#define INTC_ICDICFR15_ERI7_0_SHIFT             (20u)
#define INTC_ICDICFR15_ERI7_1_SHIFT             (21u)
#define INTC_ICDICFR15_RXI7_0_SHIFT             (22u)
#define INTC_ICDICFR15_RXI7_1_SHIFT             (23u)
#define INTC_ICDICFR15_TXI7_0_SHIFT             (24u)
#define INTC_ICDICFR15_TXI7_1_SHIFT             (25u)
#define INTC_ICDICFR15_INTRCANGERR_0_SHIFT      (26u)
#define INTC_ICDICFR15_INTRCANGERR_1_SHIFT      (27u)
#define INTC_ICDICFR15_INTRCANGRECC_0_SHIFT     (28u)
#define INTC_ICDICFR15_INTRCANGRECC_1_SHIFT     (29u)
#define INTC_ICDICFR15_INTRCAN0REC_0_SHIFT      (30u)
#define INTC_ICDICFR15_INTRCAN0REC_1_SHIFT      (31u)

#define INTC_ICDICFR16_INTRCAN0ERR_0_SHIFT      (0u)
#define INTC_ICDICFR16_INTRCAN0ERR_1_SHIFT      (1u)
#define INTC_ICDICFR16_INTRCAN0TRX_0_SHIFT      (2u)
#define INTC_ICDICFR16_INTRCAN0TRX_1_SHIFT      (3u)
#define INTC_ICDICFR16_INTRCAN1REC_0_SHIFT      (4u)
#define INTC_ICDICFR16_INTRCAN1REC_1_SHIFT      (5u)
#define INTC_ICDICFR16_INTRCAN1ERR_0_SHIFT      (6u)
#define INTC_ICDICFR16_INTRCAN1ERR_1_SHIFT      (7u)
#define INTC_ICDICFR16_INTRCAN1TRX_0_SHIFT      (8u)
#define INTC_ICDICFR16_INTRCAN1TRX_1_SHIFT      (9u)
#define INTC_ICDICFR16_INTRCAN2REC_0_SHIFT      (10u)
#define INTC_ICDICFR16_INTRCAN2REC_1_SHIFT      (11u)
#define INTC_ICDICFR16_INTRCAN2ERR_0_SHIFT      (12u)
#define INTC_ICDICFR16_INTRCAN2ERR_1_SHIFT      (13u)
#define INTC_ICDICFR16_INTRCAN2TRX_0_SHIFT      (14u)
#define INTC_ICDICFR16_INTRCAN2TRX_1_SHIFT      (15u)
#define INTC_ICDICFR16_INTRCAN3REC_0_SHIFT      (16u)
#define INTC_ICDICFR16_INTRCAN3REC_1_SHIFT      (17u)
#define INTC_ICDICFR16_INTRCAN3ERR_0_SHIFT      (18u)
#define INTC_ICDICFR16_INTRCAN3ERR_1_SHIFT      (19u)
#define INTC_ICDICFR16_INTRCAN3TRX_0_SHIFT      (20u)
#define INTC_ICDICFR16_INTRCAN3TRX_1_SHIFT      (21u)
#define INTC_ICDICFR16_INTRCAN4REC_0_SHIFT      (22u)
#define INTC_ICDICFR16_INTRCAN4REC_1_SHIFT      (23u)
#define INTC_ICDICFR16_INTRCAN4ERR_0_SHIFT      (24u)
#define INTC_ICDICFR16_INTRCAN4ERR_1_SHIFT      (25u)
#define INTC_ICDICFR16_INTRCAN4TRX_0_SHIFT      (26u)
#define INTC_ICDICFR16_INTRCAN4TRX_1_SHIFT      (27u)
#define INTC_ICDICFR16_SPEI0_0_SHIFT            (28u)
#define INTC_ICDICFR16_SPEI0_1_SHIFT            (29u)
#define INTC_ICDICFR16_SPRI0_0_SHIFT            (30u)
#define INTC_ICDICFR16_SPRI0_1_SHIFT            (31u)

#define INTC_ICDICFR17_SPTI0_0_SHIFT            (0u)
#define INTC_ICDICFR17_SPTI0_1_SHIFT            (1u)
#define INTC_ICDICFR17_SPEI1_0_SHIFT            (2u)
#define INTC_ICDICFR17_SPEI1_1_SHIFT            (3u)
#define INTC_ICDICFR17_SPRI1_0_SHIFT            (4u)
#define INTC_ICDICFR17_SPRI1_1_SHIFT            (5u)
#define INTC_ICDICFR17_SPTI1_0_SHIFT            (6u)
#define INTC_ICDICFR17_SPTI1_1_SHIFT            (7u)
#define INTC_ICDICFR17_SPEI2_0_SHIFT            (8u)
#define INTC_ICDICFR17_SPEI2_1_SHIFT            (9u)
#define INTC_ICDICFR17_SPRI2_0_SHIFT            (10u)
#define INTC_ICDICFR17_SPRI2_1_SHIFT            (11u)
#define INTC_ICDICFR17_SPTI2_0_SHIFT            (12u)
#define INTC_ICDICFR17_SPTI2_1_SHIFT            (13u)
#define INTC_ICDICFR17_SPEI3_0_SHIFT            (14u)
#define INTC_ICDICFR17_SPEI3_1_SHIFT            (15u)
#define INTC_ICDICFR17_SPRI3_0_SHIFT            (16u)
#define INTC_ICDICFR17_SPRI3_1_SHIFT            (17u)
#define INTC_ICDICFR17_SPTI3_0_SHIFT            (18u)
#define INTC_ICDICFR17_SPTI3_1_SHIFT            (19u)
#define INTC_ICDICFR17_SPEI4_0_SHIFT            (20u)
#define INTC_ICDICFR17_SPEI4_1_SHIFT            (21u)
#define INTC_ICDICFR17_SPRI4_0_SHIFT            (22u)
#define INTC_ICDICFR17_SPRI4_1_SHIFT            (23u)
#define INTC_ICDICFR17_SPTI4_0_SHIFT            (24u)
#define INTC_ICDICFR17_SPTI4_1_SHIFT            (25u)
#define INTC_ICDICFR17_IEBBTD_0_SHIFT           (26u)
#define INTC_ICDICFR17_IEBBTD_1_SHIFT           (27u)
#define INTC_ICDICFR17_IEBBTERR_0_SHIFT         (28u)
#define INTC_ICDICFR17_IEBBTERR_1_SHIFT         (29u)
#define INTC_ICDICFR17_IEBBTSTA_0_SHIFT         (30u)
#define INTC_ICDICFR17_IEBBTSTA_1_SHIFT         (31u)

#define INTC_ICDICFR18_IEBBTV_0_SHIFT           (0u)
#define INTC_ICDICFR18_IEBBTV_1_SHIFT           (1u)
#define INTC_ICDICFR18_ISY_0_SHIFT              (2u)
#define INTC_ICDICFR18_ISY_1_SHIFT              (3u)
#define INTC_ICDICFR18_IERR_0_SHIFT             (4u)
#define INTC_ICDICFR18_IERR_1_SHIFT             (5u)
#define INTC_ICDICFR18_ITARG_0_SHIFT            (6u)
#define INTC_ICDICFR18_ITARG_1_SHIFT            (7u)
#define INTC_ICDICFR18_ISEC_0_SHIFT             (8u)
#define INTC_ICDICFR18_ISEC_1_SHIFT             (9u)
#define INTC_ICDICFR18_IBUF_0_SHIFT             (10u)
#define INTC_ICDICFR18_IBUF_1_SHIFT             (11u)
#define INTC_ICDICFR18_IREADY_0_SHIFT           (12u)
#define INTC_ICDICFR18_IREADY_1_SHIFT           (13u)
#define INTC_ICDICFR18_FLSTE_0_SHIFT            (14u)
#define INTC_ICDICFR18_FLSTE_1_SHIFT            (15u)
#define INTC_ICDICFR18_FLTENDI_0_SHIFT          (16u)
#define INTC_ICDICFR18_FLTENDI_1_SHIFT          (17u)
#define INTC_ICDICFR18_FLTREQ0I_0_SHIFT         (18u)
#define INTC_ICDICFR18_FLTREQ0I_1_SHIFT         (19u)
#define INTC_ICDICFR18_FLTREQ1I_0_SHIFT         (20u)
#define INTC_ICDICFR18_FLTREQ1I_1_SHIFT         (21u)
#define INTC_ICDICFR18_MMC0_0_SHIFT             (22u)
#define INTC_ICDICFR18_MMC0_1_SHIFT             (23u)
#define INTC_ICDICFR18_MMC1_0_SHIFT             (24u)
#define INTC_ICDICFR18_MMC1_1_SHIFT             (25u)
#define INTC_ICDICFR18_MMC2_0_SHIFT             (26u)
#define INTC_ICDICFR18_MMC2_1_SHIFT             (27u)
#define INTC_ICDICFR18_SDHI0_3_0_SHIFT          (28u)
#define INTC_ICDICFR18_SDHI0_3_1_SHIFT          (29u)
#define INTC_ICDICFR18_SDHI0_0_0_SHIFT          (30u)
#define INTC_ICDICFR18_SDHI0_0_1_SHIFT          (31u)

#define INTC_ICDICFR19_SDHI0_1_0_SHIFT          (0u)
#define INTC_ICDICFR19_SDHI0_1_1_SHIFT          (1u)
#define INTC_ICDICFR19_SDHI1_3_0_SHIFT          (2u)
#define INTC_ICDICFR19_SDHI1_3_1_SHIFT          (3u)
#define INTC_ICDICFR19_SDHI1_0_0_SHIFT          (4u)
#define INTC_ICDICFR19_SDHI1_0_1_SHIFT          (5u)
#define INTC_ICDICFR19_SDHI1_1_0_SHIFT          (6u)
#define INTC_ICDICFR19_SDHI1_1_1_SHIFT          (7u)
#define INTC_ICDICFR19_ARM_0_SHIFT              (8u)
#define INTC_ICDICFR19_ARM_1_SHIFT              (9u)
#define INTC_ICDICFR19_PRD_0_SHIFT              (10u)
#define INTC_ICDICFR19_PRD_1_SHIFT              (11u)
#define INTC_ICDICFR19_CUP_0_SHIFT              (12u)
#define INTC_ICDICFR19_CUP_1_SHIFT              (13u)
#define INTC_ICDICFR19_SCUAI0_0_SHIFT           (14u)
#define INTC_ICDICFR19_SCUAI0_1_SHIFT           (15u)
#define INTC_ICDICFR19_SCUAI1_0_SHIFT           (16u)
#define INTC_ICDICFR19_SCUAI1_1_SHIFT           (17u)
#define INTC_ICDICFR19_SCUFDI0_0_SHIFT          (18u)
#define INTC_ICDICFR19_SCUFDI0_1_SHIFT          (19u)
#define INTC_ICDICFR19_SCUFDI1_0_SHIFT          (20u)
#define INTC_ICDICFR19_SCUFDI1_1_SHIFT          (21u)
#define INTC_ICDICFR19_SCUFDI2_0_SHIFT          (22u)
#define INTC_ICDICFR19_SCUFDI2_1_SHIFT          (23u)
#define INTC_ICDICFR19_SCUFDI3_0_SHIFT          (24u)
#define INTC_ICDICFR19_SCUFDI3_1_SHIFT          (25u)
#define INTC_ICDICFR19_SCUFUI0_0_SHIFT          (26u)
#define INTC_ICDICFR19_SCUFUI0_1_SHIFT          (27u)
#define INTC_ICDICFR19_SCUFUI1_0_SHIFT          (28u)
#define INTC_ICDICFR19_SCUFUI1_1_SHIFT          (29u)
#define INTC_ICDICFR19_SCUFUI2_0_SHIFT          (30u)
#define INTC_ICDICFR19_SCUFUI2_1_SHIFT          (31u)

#define INTC_ICDICFR20_SCUFUI3_0_SHIFT          (0u)
#define INTC_ICDICFR20_SCUFUI3_1_SHIFT          (1u)
#define INTC_ICDICFR20_SCUDVI0_0_SHIFT          (2u)
#define INTC_ICDICFR20_SCUDVI0_1_SHIFT          (3u)
#define INTC_ICDICFR20_SCUDVI1_0_SHIFT          (4u)
#define INTC_ICDICFR20_SCUDVI1_1_SHIFT          (5u)
#define INTC_ICDICFR20_SCUDVI2_0_SHIFT          (6u)
#define INTC_ICDICFR20_SCUDVI2_1_SHIFT          (7u)
#define INTC_ICDICFR20_SCUDVI3_0_SHIFT          (8u)
#define INTC_ICDICFR20_SCUDVI3_1_SHIFT          (9u)
#define INTC_ICDICFR20_MLB_CINT_0_SHIFT         (10u)
#define INTC_ICDICFR20_MLB_CINT_1_SHIFT         (11u)
#define INTC_ICDICFR20_MLB_SINT_0_SHIFT         (12u)
#define INTC_ICDICFR20_MLB_SINT_1_SHIFT         (13u)
#define INTC_ICDICFR20_DRC0_0_SHIFT             (14u)
#define INTC_ICDICFR20_DRC0_1_SHIFT             (15u)
#define INTC_ICDICFR20_DRC1_0_SHIFT             (16u)
#define INTC_ICDICFR20_DRC1_1_SHIFT             (17u)
#define INTC_ICDICFR20_LINI0_INT_T_0_SHIFT      (22u)
#define INTC_ICDICFR20_LINI0_INT_T_1_SHIFT      (23u)
#define INTC_ICDICFR20_LINI0_INT_R_0_SHIFT      (24u)
#define INTC_ICDICFR20_LINI0_INT_R_1_SHIFT      (25u)
#define INTC_ICDICFR20_LINI0_INT_S_0_SHIFT      (26u)
#define INTC_ICDICFR20_LINI0_INT_S_1_SHIFT      (27u)
#define INTC_ICDICFR20_LINI0_INT_M_0_SHIFT      (28u)
#define INTC_ICDICFR20_LINI0_INT_M_1_SHIFT      (29u)
#define INTC_ICDICFR20_LINI1_INT_T_0_SHIFT      (30u)
#define INTC_ICDICFR20_LINI1_INT_T_1_SHIFT      (31u)

#define INTC_ICDICFR21_LINI1_INT_R_0_SHIFT      (0u)
#define INTC_ICDICFR21_LINI1_INT_R_1_SHIFT      (1u)
#define INTC_ICDICFR21_LINI1_INT_S_0_SHIFT      (2u)
#define INTC_ICDICFR21_LINI1_INT_S_1_SHIFT      (3u)
#define INTC_ICDICFR21_LINI1_INT_M_0_SHIFT      (4u)
#define INTC_ICDICFR21_LINI1_INT_M_1_SHIFT      (5u)
#define INTC_ICDICFR21_ERI0_0_SHIFT             (22u)
#define INTC_ICDICFR21_ERI0_1_SHIFT             (23u)
#define INTC_ICDICFR21_RXI0_0_SHIFT             (24u)
#define INTC_ICDICFR21_RXI0_1_SHIFT             (25u)
#define INTC_ICDICFR21_TXI0_0_SHIFT             (26u)
#define INTC_ICDICFR21_TXI0_1_SHIFT             (27u)
#define INTC_ICDICFR21_TEI0_0_SHIFT             (28u)
#define INTC_ICDICFR21_TEI0_1_SHIFT             (29u)
#define INTC_ICDICFR21_ERI1_0_SHIFT             (30u)
#define INTC_ICDICFR21_ERI1_1_SHIFT             (31u)

#define INTC_ICDICFR22_RXI1_0_SHIFT             (0u)
#define INTC_ICDICFR22_RXI1_1_SHIFT             (1u)
#define INTC_ICDICFR22_TXI1_0_SHIFT             (2u)
#define INTC_ICDICFR22_TXI1_1_SHIFT             (3u)
#define INTC_ICDICFR22_TEI1_0_SHIFT             (4u)
#define INTC_ICDICFR22_TEI1_1_SHIFT             (5u)
#define INTC_ICDICFR22_AVBI_DATA_0_SHIFT        (6u)
#define INTC_ICDICFR22_AVBI_DATA_1_SHIFT        (7u)
#define INTC_ICDICFR22_AVBI_ERROR_0_SHIFT       (8u)
#define INTC_ICDICFR22_AVBI_ERROR_1_SHIFT       (9u)
#define INTC_ICDICFR22_AVBI_MANAGE_0_SHIFT      (10u)
#define INTC_ICDICFR22_AVBI_MANAGE_1_SHIFT      (11u)
#define INTC_ICDICFR22_AVBI_MAC_0_SHIFT         (12u)
#define INTC_ICDICFR22_AVBI_MAC_1_SHIFT         (13u)
#define INTC_ICDICFR22_ETHERI_0_SHIFT           (14u)
#define INTC_ICDICFR22_ETHERI_1_SHIFT           (15u)
#define INTC_ICDICFR22_CEUI_0_SHIFT             (24u)
#define INTC_ICDICFR22_CEUI_1_SHIFT             (25u)

#define INTC_ICDICFR23_H2XMLB_ERRINT_0_SHIFT    (26u)
#define INTC_ICDICFR23_H2XMLB_ERRINT_1_SHIFT    (27u)
#define INTC_ICDICFR23_H2XIC1_ERRINT_0_SHIFT    (28u)
#define INTC_ICDICFR23_H2XIC1_ERRINT_1_SHIFT    (29u)
#define INTC_ICDICFR23_X2HPERI1_ERRINT_0_SHIFT  (30u)
#define INTC_ICDICFR23_X2HPERI1_ERRINT_1_SHIFT  (31u)

#define INTC_ICDICFR24_X2HPERI2_ERRINT_0_SHIFT  (0u)
#define INTC_ICDICFR24_X2HPERI2_ERRINT_1_SHIFT  (1u)
#define INTC_ICDICFR24_X2HPERI34_ERRINT_0_SHIFT (2u)
#define INTC_ICDICFR24_X2HPERI34_ERRINT_1_SHIFT (3u)
#define INTC_ICDICFR24_X2HPERI5_ERRINT_0_SHIFT  (4u)
#define INTC_ICDICFR24_X2HPERI5_ERRINT_1_SHIFT  (5u)
#define INTC_ICDICFR24_X2HPERI67_ERRINT_0_SHIFT (6u)
#define INTC_ICDICFR24_X2HPERI67_ERRINT_1_SHIFT (7u)
#define INTC_ICDICFR24_X2HDBGR_ERRINT_0_SHIFT   (8u)
#define INTC_ICDICFR24_X2HDBGR_ERRINT_1_SHIFT   (9u)
#define INTC_ICDICFR24_X2HBSC_ERRINT_0_SHIFT    (10u)
#define INTC_ICDICFR24_X2HBSC_ERRINT_1_SHIFT    (11u)
#define INTC_ICDICFR24_X2HSPI1_ERRINT_0_SHIFT   (12u)
#define INTC_ICDICFR24_X2HSPI1_ERRINT_1_SHIFT   (13u)
#define INTC_ICDICFR24_X2HSPI2_ERRINT_0_SHIFT   (14u)
#define INTC_ICDICFR24_X2HSPI2_ERRINT_1_SHIFT   (15u)
#define INTC_ICDICFR24_PRRI_0_SHIFT             (16u)
#define INTC_ICDICFR24_PRRI_1_SHIFT             (17u)
#define INTC_ICDICFR24_IFEI0_0_SHIFT            (18u)
#define INTC_ICDICFR24_IFEI0_1_SHIFT            (19u)
#define INTC_ICDICFR24_OFFI0_0_SHIFT            (20u)
#define INTC_ICDICFR24_OFFI0_1_SHIFT            (21u)
#define INTC_ICDICFR24_PFVEI0_0_SHIFT           (22u)
#define INTC_ICDICFR24_PFVEI0_1_SHIFT           (23u)
#define INTC_ICDICFR24_IFEI1_0_SHIFT            (24u)
#define INTC_ICDICFR24_IFEI1_1_SHIFT            (25u)
#define INTC_ICDICFR24_OFFI1_0_SHIFT            (26u)
#define INTC_ICDICFR24_OFFI1_1_SHIFT            (27u)
#define INTC_ICDICFR24_PFVEI1_0_SHIFT           (28u)
#define INTC_ICDICFR24_PFVEI1_1_SHIFT           (29u)

#define INTC_ICDICFR26_TINT0_0_SHIFT            (0u)
#define INTC_ICDICFR26_TINT0_1_SHIFT            (1u)
#define INTC_ICDICFR26_TINT1_0_SHIFT            (2u)
#define INTC_ICDICFR26_TINT1_1_SHIFT            (3u)
#define INTC_ICDICFR26_TINT2_0_SHIFT            (4u)
#define INTC_ICDICFR26_TINT2_1_SHIFT            (5u)
#define INTC_ICDICFR26_TINT3_0_SHIFT            (6u)
#define INTC_ICDICFR26_TINT3_1_SHIFT            (7u)
#define INTC_ICDICFR26_TINT4_0_SHIFT            (8u)
#define INTC_ICDICFR26_TINT4_1_SHIFT            (9u)
#define INTC_ICDICFR26_TINT5_0_SHIFT            (10u)
#define INTC_ICDICFR26_TINT5_1_SHIFT            (11u)
#define INTC_ICDICFR26_TINT6_0_SHIFT            (12u)
#define INTC_ICDICFR26_TINT6_1_SHIFT            (13u)
#define INTC_ICDICFR26_TINT7_0_SHIFT            (14u)
#define INTC_ICDICFR26_TINT7_1_SHIFT            (15u)
#define INTC_ICDICFR26_TINT8_0_SHIFT            (16u)
#define INTC_ICDICFR26_TINT8_1_SHIFT            (17u)
#define INTC_ICDICFR26_TINT9_0_SHIFT            (18u)
#define INTC_ICDICFR26_TINT9_1_SHIFT            (19u)
#define INTC_ICDICFR26_TINT10_0_SHIFT           (20u)
#define INTC_ICDICFR26_TINT10_1_SHIFT           (21u)
#define INTC_ICDICFR26_TINT11_0_SHIFT           (22u)
#define INTC_ICDICFR26_TINT11_1_SHIFT           (23u)
#define INTC_ICDICFR26_TINT12_0_SHIFT           (24u)
#define INTC_ICDICFR26_TINT12_1_SHIFT           (25u)
#define INTC_ICDICFR26_TINT13_0_SHIFT           (26u)
#define INTC_ICDICFR26_TINT13_1_SHIFT           (27u)
#define INTC_ICDICFR26_TINT14_0_SHIFT           (28u)
#define INTC_ICDICFR26_TINT14_1_SHIFT           (29u)
#define INTC_ICDICFR26_TINT15_0_SHIFT           (30u)
#define INTC_ICDICFR26_TINT15_1_SHIFT           (31u)

#define INTC_ICDICFR27_TINT16_0_SHIFT           (0u)
#define INTC_ICDICFR27_TINT16_1_SHIFT           (1u)
#define INTC_ICDICFR27_TINT17_0_SHIFT           (2u)
#define INTC_ICDICFR27_TINT17_1_SHIFT           (3u)
#define INTC_ICDICFR27_TINT18_0_SHIFT           (4u)
#define INTC_ICDICFR27_TINT18_1_SHIFT           (5u)
#define INTC_ICDICFR27_TINT19_0_SHIFT           (6u)
#define INTC_ICDICFR27_TINT19_1_SHIFT           (7u)
#define INTC_ICDICFR27_TINT20_0_SHIFT           (8u)
#define INTC_ICDICFR27_TINT20_1_SHIFT           (9u)
#define INTC_ICDICFR27_TINT21_0_SHIFT           (10u)
#define INTC_ICDICFR27_TINT21_1_SHIFT           (11u)
#define INTC_ICDICFR27_TINT22_0_SHIFT           (12u)
#define INTC_ICDICFR27_TINT22_1_SHIFT           (13u)
#define INTC_ICDICFR27_TINT23_0_SHIFT           (14u)
#define INTC_ICDICFR27_TINT23_1_SHIFT           (15u)
#define INTC_ICDICFR27_TINT24_0_SHIFT           (16u)
#define INTC_ICDICFR27_TINT24_1_SHIFT           (17u)
#define INTC_ICDICFR27_TINT25_0_SHIFT           (18u)
#define INTC_ICDICFR27_TINT25_1_SHIFT           (19u)
#define INTC_ICDICFR27_TINT26_0_SHIFT           (20u)
#define INTC_ICDICFR27_TINT26_1_SHIFT           (21u)
#define INTC_ICDICFR27_TINT27_0_SHIFT           (22u)
#define INTC_ICDICFR27_TINT27_1_SHIFT           (23u)
#define INTC_ICDICFR27_TINT28_0_SHIFT           (24u)
#define INTC_ICDICFR27_TINT28_1_SHIFT           (25u)
#define INTC_ICDICFR27_TINT29_0_SHIFT           (26u)
#define INTC_ICDICFR27_TINT29_1_SHIFT           (27u)
#define INTC_ICDICFR27_TINT30_0_SHIFT           (28u)
#define INTC_ICDICFR27_TINT30_1_SHIFT           (29u)
#define INTC_ICDICFR27_TINT31_0_SHIFT           (30u)
#define INTC_ICDICFR27_TINT31_1_SHIFT           (31u)

#define INTC_ICDICFR28_TINT32_0_SHIFT           (0u)
#define INTC_ICDICFR28_TINT32_1_SHIFT           (1u)
#define INTC_ICDICFR28_TINT33_0_SHIFT           (2u)
#define INTC_ICDICFR28_TINT33_1_SHIFT           (3u)
#define INTC_ICDICFR28_TINT34_0_SHIFT           (4u)
#define INTC_ICDICFR28_TINT34_1_SHIFT           (5u)
#define INTC_ICDICFR28_TINT35_0_SHIFT           (6u)
#define INTC_ICDICFR28_TINT35_1_SHIFT           (7u)
#define INTC_ICDICFR28_TINT36_0_SHIFT           (8u)
#define INTC_ICDICFR28_TINT36_1_SHIFT           (9u)
#define INTC_ICDICFR28_TINT37_0_SHIFT           (10u)
#define INTC_ICDICFR28_TINT37_1_SHIFT           (11u)
#define INTC_ICDICFR28_TINT38_0_SHIFT           (12u)
#define INTC_ICDICFR28_TINT38_1_SHIFT           (13u)
#define INTC_ICDICFR28_TINT39_0_SHIFT           (14u)
#define INTC_ICDICFR28_TINT39_1_SHIFT           (15u)
#define INTC_ICDICFR28_TINT40_0_SHIFT           (16u)
#define INTC_ICDICFR28_TINT40_1_SHIFT           (17u)
#define INTC_ICDICFR28_TINT41_0_SHIFT           (18u)
#define INTC_ICDICFR28_TINT41_1_SHIFT           (19u)
#define INTC_ICDICFR28_TINT42_0_SHIFT           (20u)
#define INTC_ICDICFR28_TINT42_1_SHIFT           (21u)
#define INTC_ICDICFR28_TINT43_0_SHIFT           (22u)
#define INTC_ICDICFR28_TINT43_1_SHIFT           (23u)
#define INTC_ICDICFR28_TINT44_0_SHIFT           (24u)
#define INTC_ICDICFR28_TINT44_1_SHIFT           (25u)
#define INTC_ICDICFR28_TINT45_0_SHIFT           (26u)
#define INTC_ICDICFR28_TINT45_1_SHIFT           (27u)
#define INTC_ICDICFR28_TINT46_0_SHIFT           (28u)
#define INTC_ICDICFR28_TINT46_1_SHIFT           (29u)
#define INTC_ICDICFR28_TINT47_0_SHIFT           (30u)
#define INTC_ICDICFR28_TINT47_1_SHIFT           (31u)

#define INTC_ICDICFR29_TINT48_0_SHIFT           (0u)
#define INTC_ICDICFR29_TINT48_1_SHIFT           (1u)
#define INTC_ICDICFR29_TINT49_0_SHIFT           (2u)
#define INTC_ICDICFR29_TINT49_1_SHIFT           (3u)
#define INTC_ICDICFR29_TINT50_0_SHIFT           (4u)
#define INTC_ICDICFR29_TINT50_1_SHIFT           (5u)
#define INTC_ICDICFR29_TINT51_0_SHIFT           (6u)
#define INTC_ICDICFR29_TINT51_1_SHIFT           (7u)
#define INTC_ICDICFR29_TINT52_0_SHIFT           (8u)
#define INTC_ICDICFR29_TINT52_1_SHIFT           (9u)
#define INTC_ICDICFR29_TINT53_0_SHIFT           (10u)
#define INTC_ICDICFR29_TINT53_1_SHIFT           (11u)
#define INTC_ICDICFR29_TINT54_0_SHIFT           (12u)
#define INTC_ICDICFR29_TINT54_1_SHIFT           (13u)
#define INTC_ICDICFR29_TINT55_0_SHIFT           (14u)
#define INTC_ICDICFR29_TINT55_1_SHIFT           (15u)
#define INTC_ICDICFR29_TINT56_0_SHIFT           (16u)
#define INTC_ICDICFR29_TINT56_1_SHIFT           (17u)
#define INTC_ICDICFR29_TINT57_0_SHIFT           (18u)
#define INTC_ICDICFR29_TINT57_1_SHIFT           (19u)
#define INTC_ICDICFR29_TINT58_0_SHIFT           (20u)
#define INTC_ICDICFR29_TINT58_1_SHIFT           (21u)
#define INTC_ICDICFR29_TINT59_0_SHIFT           (22u)
#define INTC_ICDICFR29_TINT59_1_SHIFT           (23u)
#define INTC_ICDICFR29_TINT60_0_SHIFT           (24u)
#define INTC_ICDICFR29_TINT60_1_SHIFT           (25u)
#define INTC_ICDICFR29_TINT61_0_SHIFT           (26u)
#define INTC_ICDICFR29_TINT61_1_SHIFT           (27u)
#define INTC_ICDICFR29_TINT62_0_SHIFT           (28u)
#define INTC_ICDICFR29_TINT62_1_SHIFT           (29u)
#define INTC_ICDICFR29_TINT63_0_SHIFT           (30u)
#define INTC_ICDICFR29_TINT63_1_SHIFT           (31u)

#define INTC_ICDICFR30_TINT64_0_SHIFT           (0u)
#define INTC_ICDICFR30_TINT64_1_SHIFT           (1u)
#define INTC_ICDICFR30_TINT65_0_SHIFT           (2u)
#define INTC_ICDICFR30_TINT65_1_SHIFT           (3u)
#define INTC_ICDICFR30_TINT66_0_SHIFT           (4u)
#define INTC_ICDICFR30_TINT66_1_SHIFT           (5u)
#define INTC_ICDICFR30_TINT67_0_SHIFT           (6u)
#define INTC_ICDICFR30_TINT67_1_SHIFT           (7u)
#define INTC_ICDICFR30_TINT68_0_SHIFT           (8u)
#define INTC_ICDICFR30_TINT68_1_SHIFT           (9u)
#define INTC_ICDICFR30_TINT69_0_SHIFT           (10u)
#define INTC_ICDICFR30_TINT69_1_SHIFT           (11u)
#define INTC_ICDICFR30_TINT70_0_SHIFT           (12u)
#define INTC_ICDICFR30_TINT70_1_SHIFT           (13u)
#define INTC_ICDICFR30_TINT71_0_SHIFT           (14u)
#define INTC_ICDICFR30_TINT71_1_SHIFT           (15u)
#define INTC_ICDICFR30_TINT72_0_SHIFT           (16u)
#define INTC_ICDICFR30_TINT72_1_SHIFT           (17u)
#define INTC_ICDICFR30_TINT73_0_SHIFT           (18u)
#define INTC_ICDICFR30_TINT73_1_SHIFT           (19u)
#define INTC_ICDICFR30_TINT74_0_SHIFT           (20u)
#define INTC_ICDICFR30_TINT74_1_SHIFT           (21u)
#define INTC_ICDICFR30_TINT75_0_SHIFT           (22u)
#define INTC_ICDICFR30_TINT75_1_SHIFT           (23u)
#define INTC_ICDICFR30_TINT76_0_SHIFT           (24u)
#define INTC_ICDICFR30_TINT76_1_SHIFT           (25u)
#define INTC_ICDICFR30_TINT77_0_SHIFT           (26u)
#define INTC_ICDICFR30_TINT77_1_SHIFT           (27u)
#define INTC_ICDICFR30_TINT78_0_SHIFT           (28u)
#define INTC_ICDICFR30_TINT78_1_SHIFT           (29u)
#define INTC_ICDICFR30_TINT79_0_SHIFT           (30u)
#define INTC_ICDICFR30_TINT79_1_SHIFT           (31u)

#define INTC_ICDICFR31_TINT80_0_SHIFT           (0u)
#define INTC_ICDICFR31_TINT80_1_SHIFT           (1u)
#define INTC_ICDICFR31_TINT81_0_SHIFT           (2u)
#define INTC_ICDICFR31_TINT81_1_SHIFT           (3u)
#define INTC_ICDICFR31_TINT82_0_SHIFT           (4u)
#define INTC_ICDICFR31_TINT82_1_SHIFT           (5u)
#define INTC_ICDICFR31_TINT83_0_SHIFT           (6u)
#define INTC_ICDICFR31_TINT83_1_SHIFT           (7u)
#define INTC_ICDICFR31_TINT84_0_SHIFT           (8u)
#define INTC_ICDICFR31_TINT84_1_SHIFT           (9u)
#define INTC_ICDICFR31_TINT85_0_SHIFT           (10u)
#define INTC_ICDICFR31_TINT85_1_SHIFT           (11u)
#define INTC_ICDICFR31_TINT86_0_SHIFT           (12u)
#define INTC_ICDICFR31_TINT86_1_SHIFT           (13u)
#define INTC_ICDICFR31_TINT87_0_SHIFT           (14u)
#define INTC_ICDICFR31_TINT87_1_SHIFT           (15u)
#define INTC_ICDICFR31_TINT88_0_SHIFT           (16u)
#define INTC_ICDICFR31_TINT88_1_SHIFT           (17u)
#define INTC_ICDICFR31_TINT89_0_SHIFT           (18u)
#define INTC_ICDICFR31_TINT89_1_SHIFT           (19u)
#define INTC_ICDICFR31_TINT90_0_SHIFT           (20u)
#define INTC_ICDICFR31_TINT90_1_SHIFT           (21u)
#define INTC_ICDICFR31_TINT91_0_SHIFT           (22u)
#define INTC_ICDICFR31_TINT91_1_SHIFT           (23u)
#define INTC_ICDICFR31_TINT92_0_SHIFT           (24u)
#define INTC_ICDICFR31_TINT92_1_SHIFT           (25u)
#define INTC_ICDICFR31_TINT93_0_SHIFT           (26u)
#define INTC_ICDICFR31_TINT93_1_SHIFT           (27u)
#define INTC_ICDICFR31_TINT94_0_SHIFT           (28u)
#define INTC_ICDICFR31_TINT94_1_SHIFT           (29u)
#define INTC_ICDICFR31_TINT95_0_SHIFT           (30u)
#define INTC_ICDICFR31_TINT95_1_SHIFT           (31u)

#define INTC_ICDICFR32_TINT96_0_SHIFT           (0u)
#define INTC_ICDICFR32_TINT96_1_SHIFT           (1u)
#define INTC_ICDICFR32_TINT97_0_SHIFT           (2u)
#define INTC_ICDICFR32_TINT97_1_SHIFT           (3u)
#define INTC_ICDICFR32_TINT98_0_SHIFT           (4u)
#define INTC_ICDICFR32_TINT98_1_SHIFT           (5u)
#define INTC_ICDICFR32_TINT99_0_SHIFT           (6u)
#define INTC_ICDICFR32_TINT99_1_SHIFT           (7u)
#define INTC_ICDICFR32_TINT100_0_SHIFT          (8u)
#define INTC_ICDICFR32_TINT100_1_SHIFT          (9u)
#define INTC_ICDICFR32_TINT101_0_SHIFT          (10u)
#define INTC_ICDICFR32_TINT101_1_SHIFT          (11u)
#define INTC_ICDICFR32_TINT102_0_SHIFT          (12u)
#define INTC_ICDICFR32_TINT102_1_SHIFT          (13u)
#define INTC_ICDICFR32_TINT103_0_SHIFT          (14u)
#define INTC_ICDICFR32_TINT103_1_SHIFT          (15u)
#define INTC_ICDICFR32_TINT104_0_SHIFT          (16u)
#define INTC_ICDICFR32_TINT104_1_SHIFT          (17u)
#define INTC_ICDICFR32_TINT105_0_SHIFT          (18u)
#define INTC_ICDICFR32_TINT105_1_SHIFT          (19u)
#define INTC_ICDICFR32_TINT106_0_SHIFT          (20u)
#define INTC_ICDICFR32_TINT106_1_SHIFT          (21u)
#define INTC_ICDICFR32_TINT107_0_SHIFT          (22u)
#define INTC_ICDICFR32_TINT107_1_SHIFT          (23u)
#define INTC_ICDICFR32_TINT108_0_SHIFT          (24u)
#define INTC_ICDICFR32_TINT108_1_SHIFT          (25u)
#define INTC_ICDICFR32_TINT109_0_SHIFT          (26u)
#define INTC_ICDICFR32_TINT109_1_SHIFT          (27u)
#define INTC_ICDICFR32_TINT110_0_SHIFT          (28u)
#define INTC_ICDICFR32_TINT110_1_SHIFT          (29u)
#define INTC_ICDICFR32_TINT111_0_SHIFT          (30u)
#define INTC_ICDICFR32_TINT111_1_SHIFT          (31u)

#define INTC_ICDICFR33_TINT112_0_SHIFT          (0u)
#define INTC_ICDICFR33_TINT112_1_SHIFT          (1u)
#define INTC_ICDICFR33_TINT113_0_SHIFT          (2u)
#define INTC_ICDICFR33_TINT113_1_SHIFT          (3u)
#define INTC_ICDICFR33_TINT114_0_SHIFT          (4u)
#define INTC_ICDICFR33_TINT114_1_SHIFT          (5u)
#define INTC_ICDICFR33_TINT115_0_SHIFT          (6u)
#define INTC_ICDICFR33_TINT115_1_SHIFT          (7u)
#define INTC_ICDICFR33_TINT116_0_SHIFT          (8u)
#define INTC_ICDICFR33_TINT116_1_SHIFT          (9u)
#define INTC_ICDICFR33_TINT117_0_SHIFT          (10u)
#define INTC_ICDICFR33_TINT117_1_SHIFT          (11u)
#define INTC_ICDICFR33_TINT118_0_SHIFT          (12u)
#define INTC_ICDICFR33_TINT118_1_SHIFT          (13u)
#define INTC_ICDICFR33_TINT119_0_SHIFT          (14u)
#define INTC_ICDICFR33_TINT119_1_SHIFT          (15u)
#define INTC_ICDICFR33_TINT120_0_SHIFT          (16u)
#define INTC_ICDICFR33_TINT120_1_SHIFT          (17u)
#define INTC_ICDICFR33_TINT121_0_SHIFT          (18u)
#define INTC_ICDICFR33_TINT121_1_SHIFT          (19u)
#define INTC_ICDICFR33_TINT122_0_SHIFT          (20u)
#define INTC_ICDICFR33_TINT122_1_SHIFT          (21u)
#define INTC_ICDICFR33_TINT123_0_SHIFT          (22u)
#define INTC_ICDICFR33_TINT123_1_SHIFT          (23u)
#define INTC_ICDICFR33_TINT124_0_SHIFT          (24u)
#define INTC_ICDICFR33_TINT124_1_SHIFT          (25u)
#define INTC_ICDICFR33_TINT125_0_SHIFT          (26u)
#define INTC_ICDICFR33_TINT125_1_SHIFT          (27u)
#define INTC_ICDICFR33_TINT126_0_SHIFT          (28u)
#define INTC_ICDICFR33_TINT126_1_SHIFT          (29u)
#define INTC_ICDICFR33_TINT127_0_SHIFT          (30u)
#define INTC_ICDICFR33_TINT127_1_SHIFT          (31u)

#define INTC_ICDICFR34_TINT128_0_SHIFT          (0u)
#define INTC_ICDICFR34_TINT128_1_SHIFT          (1u)
#define INTC_ICDICFR34_TINT129_0_SHIFT          (2u)
#define INTC_ICDICFR34_TINT129_1_SHIFT          (3u)
#define INTC_ICDICFR34_TINT130_0_SHIFT          (4u)
#define INTC_ICDICFR34_TINT130_1_SHIFT          (5u)
#define INTC_ICDICFR34_TINT131_0_SHIFT          (6u)
#define INTC_ICDICFR34_TINT131_1_SHIFT          (7u)
#define INTC_ICDICFR34_TINT132_0_SHIFT          (8u)
#define INTC_ICDICFR34_TINT132_1_SHIFT          (9u)
#define INTC_ICDICFR34_TINT133_0_SHIFT          (10u)
#define INTC_ICDICFR34_TINT133_1_SHIFT          (11u)
#define INTC_ICDICFR34_TINT134_0_SHIFT          (12u)
#define INTC_ICDICFR34_TINT134_1_SHIFT          (13u)
#define INTC_ICDICFR34_TINT135_0_SHIFT          (14u)
#define INTC_ICDICFR34_TINT135_1_SHIFT          (15u)
#define INTC_ICDICFR34_TINT136_0_SHIFT          (16u)
#define INTC_ICDICFR34_TINT136_1_SHIFT          (17u)
#define INTC_ICDICFR34_TINT137_0_SHIFT          (18u)
#define INTC_ICDICFR34_TINT137_1_SHIFT          (19u)
#define INTC_ICDICFR34_TINT138_0_SHIFT          (20u)
#define INTC_ICDICFR34_TINT138_1_SHIFT          (21u)
#define INTC_ICDICFR34_TINT139_0_SHIFT          (22u)
#define INTC_ICDICFR34_TINT139_1_SHIFT          (23u)
#define INTC_ICDICFR34_TINT140_0_SHIFT          (24u)
#define INTC_ICDICFR34_TINT140_1_SHIFT          (25u)
#define INTC_ICDICFR34_TINT141_0_SHIFT          (26u)
#define INTC_ICDICFR34_TINT141_1_SHIFT          (27u)
#define INTC_ICDICFR34_TINT142_0_SHIFT          (28u)
#define INTC_ICDICFR34_TINT142_1_SHIFT          (29u)
#define INTC_ICDICFR34_TINT143_0_SHIFT          (30u)
#define INTC_ICDICFR34_TINT143_1_SHIFT          (31u)

#define INTC_ICDICFR35_TINT144_0_SHIFT          (0u)
#define INTC_ICDICFR35_TINT144_1_SHIFT          (1u)
#define INTC_ICDICFR35_TINT145_0_SHIFT          (2u)
#define INTC_ICDICFR35_TINT145_1_SHIFT          (3u)
#define INTC_ICDICFR35_TINT146_0_SHIFT          (4u)
#define INTC_ICDICFR35_TINT146_1_SHIFT          (5u)
#define INTC_ICDICFR35_TINT147_0_SHIFT          (6u)
#define INTC_ICDICFR35_TINT147_1_SHIFT          (7u)
#define INTC_ICDICFR35_TINT148_0_SHIFT          (8u)
#define INTC_ICDICFR35_TINT148_1_SHIFT          (9u)
#define INTC_ICDICFR35_TINT149_0_SHIFT          (10u)
#define INTC_ICDICFR35_TINT149_1_SHIFT          (11u)
#define INTC_ICDICFR35_TINT150_0_SHIFT          (12u)
#define INTC_ICDICFR35_TINT150_1_SHIFT          (13u)
#define INTC_ICDICFR35_TINT151_0_SHIFT          (14u)
#define INTC_ICDICFR35_TINT151_1_SHIFT          (15u)
#define INTC_ICDICFR35_TINT152_0_SHIFT          (16u)
#define INTC_ICDICFR35_TINT152_1_SHIFT          (17u)
#define INTC_ICDICFR35_TINT153_0_SHIFT          (18u)
#define INTC_ICDICFR35_TINT153_1_SHIFT          (19u)
#define INTC_ICDICFR35_TINT154_0_SHIFT          (20u)
#define INTC_ICDICFR35_TINT154_1_SHIFT          (21u)
#define INTC_ICDICFR35_TINT155_0_SHIFT          (22u)
#define INTC_ICDICFR35_TINT155_1_SHIFT          (23u)
#define INTC_ICDICFR35_TINT156_0_SHIFT          (24u)
#define INTC_ICDICFR35_TINT156_1_SHIFT          (25u)
#define INTC_ICDICFR35_TINT157_0_SHIFT          (26u)
#define INTC_ICDICFR35_TINT157_1_SHIFT          (27u)
#define INTC_ICDICFR35_TINT158_0_SHIFT          (28u)
#define INTC_ICDICFR35_TINT158_1_SHIFT          (29u)
#define INTC_ICDICFR35_TINT159_0_SHIFT          (30u)
#define INTC_ICDICFR35_TINT159_1_SHIFT          (31u)

#define INTC_ICDICFR36_TINT160_0_SHIFT          (0u)
#define INTC_ICDICFR36_TINT160_1_SHIFT          (1u)
#define INTC_ICDICFR36_TINT161_0_SHIFT          (2u)
#define INTC_ICDICFR36_TINT161_1_SHIFT          (3u)
#define INTC_ICDICFR36_TINT162_0_SHIFT          (4u)
#define INTC_ICDICFR36_TINT162_1_SHIFT          (5u)
#define INTC_ICDICFR36_TINT163_0_SHIFT          (6u)
#define INTC_ICDICFR36_TINT163_1_SHIFT          (7u)
#define INTC_ICDICFR36_TINT164_0_SHIFT          (8u)
#define INTC_ICDICFR36_TINT164_1_SHIFT          (9u)
#define INTC_ICDICFR36_TINT165_0_SHIFT          (10u)
#define INTC_ICDICFR36_TINT165_1_SHIFT          (11u)
#define INTC_ICDICFR36_TINT166_0_SHIFT          (12u)
#define INTC_ICDICFR36_TINT166_1_SHIFT          (13u)
#define INTC_ICDICFR36_TINT167_0_SHIFT          (14u)
#define INTC_ICDICFR36_TINT167_1_SHIFT          (15u)
#define INTC_ICDICFR36_TINT168_0_SHIFT          (16u)
#define INTC_ICDICFR36_TINT168_1_SHIFT          (17u)
#define INTC_ICDICFR36_TINT169_0_SHIFT          (18u)
#define INTC_ICDICFR36_TINT169_1_SHIFT          (19u)
#define INTC_ICDICFR36_TINT170_0_SHIFT          (20u)
#define INTC_ICDICFR36_TINT170_1_SHIFT          (21u)

#define INTC_ICDSGIR_SGIINTID_SHIFT             (0u)
#define INTC_ICDSGIR_SATT_SHIFT                 (15u)
#define INTC_ICDSGIR_CPUTargetList_SHIFT        (16u)
#define INTC_ICDSGIR_TargetListFilter_SHIFT     (24u)

#define INTC_ICCICR_EnableS_SHIFT               (0u)
#define INTC_ICCICR_EnableNS_SHIFT              (1u)
#define INTC_ICCICR_AckCtl_SHIFT                (2u)
#define INTC_ICCICR_FIQEn_SHIFT                 (3u)
#define INTC_ICCICR_SBPR_SHIFT                  (4u)

#define INTC_ICCPMR_Priority_SHIFT              (0u)

#define INTC_ICCBPR_Binarypoint_SHIFT           (0u)

#define INTC_ICCIAR_ACKINTID_SHIFT              (0u)
#define INTC_ICCIAR_CPUID_SHIFT                 (10u)

#define INTC_ICCEOIR_EOIINTID_SHIFT             (0u)
#define INTC_ICCEOIR_CPUID_SHIFT                (10u)

#define INTC_ICCRPR_Priority_SHIFT              (0u)

#define INTC_ICCHPIR_PENDINTID_SHIFT            (0u)
#define INTC_ICCHPIR_CPUID_SHIFT                (10u)

#define INTC_ICCABPR_Binarypoint_SHIFT          (0u)

#define INTC_ICCIIDR_Implementer_SHIFT          (0u)
#define INTC_ICCIIDR_Revision_SHIFT             (12u)
#define INTC_ICCIIDR_Architecture_version_SHIFT (16u)
#define INTC_ICCIIDR_ProductID_SHIFT            (20u)

#define INTC_ICR0_NMIF_SHIFT                    (1u)
#define INTC_ICR0_NMIE_SHIFT                    (8u)
#define INTC_ICR0_NMIL_SHIFT                    (15u)

#define INTC_ICR1_IRQ00S_SHIFT                  (0u)
#define INTC_ICR1_IRQ01S_SHIFT                  (1u)
#define INTC_ICR1_IRQ10S_SHIFT                  (2u)
#define INTC_ICR1_IRQ11S_SHIFT                  (3u)
#define INTC_ICR1_IRQ20S_SHIFT                  (4u)
#define INTC_ICR1_IRQ21S_SHIFT                  (5u)
#define INTC_ICR1_IRQ30S_SHIFT                  (6u)
#define INTC_ICR1_IRQ31S_SHIFT                  (7u)
#define INTC_ICR1_IRQ40S_SHIFT                  (8u)
#define INTC_ICR1_IRQ41S_SHIFT                  (9u)
#define INTC_ICR1_IRQ50S_SHIFT                  (10u)
#define INTC_ICR1_IRQ51S_SHIFT                  (11u)
#define INTC_ICR1_IRQ60S_SHIFT                  (12u)
#define INTC_ICR1_IRQ61S_SHIFT                  (13u)
#define INTC_ICR1_IRQ70S_SHIFT                  (14u)
#define INTC_ICR1_IRQ71S_SHIFT                  (15u)

#define INTC_IRQRR_IRQ0F_SHIFT                  (0u)
#define INTC_IRQRR_IRQ1F_SHIFT                  (1u)
#define INTC_IRQRR_IRQ2F_SHIFT                  (2u)
#define INTC_IRQRR_IRQ3F_SHIFT                  (3u)
#define INTC_IRQRR_IRQ4F_SHIFT                  (4u)
#define INTC_IRQRR_IRQ5F_SHIFT                  (5u)
#define INTC_IRQRR_IRQ6F_SHIFT                  (6u)
#define INTC_IRQRR_IRQ7F_SHIFT                  (7u)


#endif /* INTC_IOBITMASK_H */

/* End of File */
