//*****************************************************************************
//
// frame.c - Draws a standard application frame on the LCD.
//
// Copyright (c) 2013 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.0.1.11577 of the DK-TM4C129X Firmware Package.
//
//*****************************************************************************

#include <stdbool.h>
#include <stdint.h>
#include "grlib/grlib.h"
#include "drivers/frame.h"

//*****************************************************************************
//
//! \addtogroup frame_api
//! @{
//
//*****************************************************************************

//*****************************************************************************
//
// The top left corner of the border.
//
//*****************************************************************************
static const uint8_t g_pui8TopLeft[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    10, 0,
    26, 0,

    37,
    0x00, 0x00, 0x00,
    0x08, 0x00, 0x00,
    0x0a, 0x00, 0x00,
    0x0b, 0x00, 0x00,
    0x10, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x40, 0x00, 0x00,
    0x44, 0x00, 0x00,
    0x46, 0x00, 0x00,
    0x48, 0x00, 0x00,
    0x4a, 0x00, 0x00,
    0x4c, 0x00, 0x00,
    0x50, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x54, 0x00, 0x00,
    0x56, 0x00, 0x00,
    0x58, 0x00, 0x00,
    0x5c, 0x00, 0x00,
    0x5e, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x15, 0x24, 0x1b, 0x1d, 0x23, 0x1c, 0x1f, 0x00, 0x13,
    0x1a, 0x1b, 0x10, 0x0a, 0x0b, 0x0e, 0x0e, 0x17, 0x00, 0x1c, 0x17, 0x0e,
    0x17, 0x14, 0x10, 0x0d, 0x18, 0x0a, 0x0b, 0x20, 0x0d, 0x0b, 0x14, 0x10,
    0x10, 0x0c, 0x16, 0x0b, 0x1c, 0x0f, 0x0e, 0x12, 0x0a, 0x10, 0x13, 0x16,
    0x0e, 0x18, 0x1e, 0x18, 0x12, 0x0a, 0x0f, 0x13, 0x17, 0x16, 0x12, 0x0f,
    0x24, 0x14, 0x16, 0x12, 0x12, 0x12, 0x18, 0x10, 0x0e, 0x0f, 0x25, 0x14,
    0x18, 0x10, 0x0d, 0x0e, 0x0a, 0x16, 0x0c, 0x11, 0x1c, 0x0d, 0x0d, 0x0c,
    0x0a, 0x16, 0x11, 0x0f, 0x17, 0x0c, 0x24, 0x0b, 0x0e, 0x0c, 0x0b, 0x17,
    0x17, 0x15, 0x10, 0x0b, 0x21, 0x15, 0x0f, 0x10, 0x10, 0x13, 0x09, 0x11,
    0x0f, 0x16, 0x1e, 0x09, 0x0a, 0x0c, 0x16, 0x16, 0x17, 0x14, 0x18, 0x16,
    0x1d, 0x13, 0x11, 0x0e, 0x11, 0x15, 0x10, 0x13, 0x12, 0x10, 0x20, 0x15,
    0x11, 0x10, 0x16, 0x18, 0x10, 0x15, 0x12, 0x10, 0x24, 0x0e, 0x0e, 0x16,
    0x10, 0x0f, 0x0a, 0x15, 0x18, 0x0c, 0x22, 0x0d, 0x0a, 0x0c, 0x0d, 0x0c,
    0x0d, 0x0d, 0x11, 0x11, 0x24, 0x11, 0x16, 0x0c, 0x0b, 0x0f, 0x0d, 0x18,
    0x0e, 0x14, 0x1a, 0x18, 0x17, 0x18, 0x0a, 0x0b, 0x15, 0x0a, 0x09, 0x15,
    0x19, 0x18, 0x14, 0x0d, 0x0c, 0x0e, 0x10, 0x0b, 0x18, 0x0d, 0x22, 0x10,
    0x0c, 0x0b, 0x14, 0x0c, 0x17, 0x14, 0x0e, 0x0d, 0x23, 0x0b, 0x0d, 0x0d,
    0x16, 0x0c, 0x17, 0x0a, 0x0c, 0x11, 0x1b, 0x14, 0x17, 0x0b, 0x0d, 0x10,
    0x0a, 0x0c, 0x13, 0x07, 0x1a, 0x16, 0x17, 0x0c, 0x09, 0x13, 0x16, 0x06,
    0x08, 0x03, 0x1f, 0x18, 0x15, 0x0b, 0x12, 0x11, 0x08, 0x02, 0x00, 0x00,
    0x1c, 0x10, 0x11, 0x0a, 0x0d, 0x15, 0x05, 0x00, 0x00, 0x00, 0x1e, 0x0d,
    0x10, 0x0e, 0x0e, 0x04, 0x01, 0x00, 0x00, 0x00,
};

//*****************************************************************************
//
// The top side of the border.
//
//*****************************************************************************
static const uint8_t g_pui8Top[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    44, 1,
    22, 0,

    39,
    0x10, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x12, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x15, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x17, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x40, 0x00, 0x00,
    0x42, 0x00, 0x00,
    0x44, 0x00, 0x00,
    0x46, 0x00, 0x00,
    0x48, 0x00, 0x00,
    0x4a, 0x00, 0x00,
    0x4c, 0x00, 0x00,
    0x4e, 0x00, 0x00,
    0x50, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x54, 0x00, 0x00,
    0x56, 0x00, 0x00,
    0x58, 0x00, 0x00,
    0x5a, 0x00, 0x00,
    0x5c, 0x00, 0x00,
    0x5e, 0x00, 0x00,

    0x1f, 0x22, 0x1d, 0x20, 0x27, 0x26, 0x22, 0x23, 0x1a, 0x21, 0x18, 0x1b,
    0x1a, 0x24, 0x1a, 0x1e, 0x1a, 0x19, 0x27, 0x1b, 0x20, 0x25, 0x21, 0x1c,
    0x22, 0x20, 0x1f, 0x27, 0x1c, 0x24, 0x20, 0x24, 0x1e, 0x26, 0x1c, 0x1d,
    0x24, 0x26, 0x19, 0x27, 0x20, 0x19, 0x1b, 0x22, 0x26, 0x1d, 0x19, 0x18,
    0x1f, 0x19, 0x1b, 0x27, 0x26, 0x25, 0x1c, 0x20, 0x1e, 0x24, 0x20, 0x22,
    0x20, 0x18, 0x1f, 0x26, 0x26, 0x23, 0x1c, 0x23, 0x22, 0x1d, 0x23, 0x1a,
    0x1f, 0x26, 0x25, 0x1d, 0x1b, 0x26, 0x1d, 0x22, 0x27, 0x21, 0x22, 0x25,
    0x1f, 0x26, 0x1e, 0x25, 0x22, 0x26, 0x1f, 0x1b, 0x27, 0x26, 0x1a, 0x26,
    0x22, 0x1e, 0x21, 0x1c, 0x24, 0x1c, 0x1f, 0x1b, 0x1b, 0x1c, 0x20, 0x1e,
    0x1a, 0x26, 0x19, 0x1a, 0x1f, 0x24, 0x27, 0x26, 0x22, 0x1e, 0x23, 0x1d,
    0x1c, 0x1b, 0x21, 0x1b, 0x1a, 0x23, 0x1a, 0x24, 0x1a, 0x23, 0x19, 0x27,
    0x18, 0x20, 0x1a, 0x1b, 0x24, 0x23, 0x22, 0x27, 0x22, 0x24, 0x19, 0x1a,
    0x20, 0x19, 0x19, 0x1b, 0x1f, 0x25, 0x21, 0x24, 0x18, 0x1a, 0x27, 0x1b,
    0x26, 0x1a, 0x27, 0x18, 0x25, 0x19, 0x18, 0x26, 0x21, 0x1a, 0x1a, 0x1e,
    0x26, 0x25, 0x1d, 0x20, 0x21, 0x1f, 0x22, 0x19, 0x20, 0x24, 0x1c, 0x27,
    0x21, 0x26, 0x23, 0x22, 0x18, 0x23, 0x25, 0x26, 0x25, 0x25, 0x27, 0x23,
    0x26, 0x27, 0x22, 0x1f, 0x1a, 0x25, 0x26, 0x19, 0x22, 0x1b, 0x22, 0x1b,
    0x23, 0x1d, 0x1d, 0x1b, 0x19, 0x22, 0x1b, 0x22, 0x20, 0x27, 0x1c, 0x20,
    0x23, 0x19, 0x1f, 0x21, 0x27, 0x1f, 0x1d, 0x25, 0x1e, 0x18, 0x1d, 0x21,
    0x25, 0x1b, 0x22, 0x1f, 0x1f, 0x1c, 0x23, 0x1a, 0x21, 0x18, 0x1e, 0x23,
    0x22, 0x22, 0x1d, 0x1a, 0x21, 0x22, 0x23, 0x1d, 0x23, 0x1b, 0x26, 0x22,
    0x22, 0x1c, 0x20, 0x19, 0x1c, 0x26, 0x22, 0x19, 0x19, 0x1d, 0x21, 0x21,
    0x22, 0x1c, 0x24, 0x1c, 0x1d, 0x1b, 0x27, 0x18, 0x25, 0x1d, 0x1b, 0x1e,
    0x27, 0x26, 0x24, 0x23, 0x19, 0x22, 0x1e, 0x24, 0x27, 0x26, 0x25, 0x1b,
    0x24, 0x20, 0x1c, 0x26, 0x26, 0x25, 0x1f, 0x21, 0x1a, 0x1c, 0x25, 0x1f,
    0x16, 0x11, 0x15, 0x15, 0x0f, 0x0d, 0x0e, 0x12, 0x11, 0x0c, 0x0a, 0x09,
    0x09, 0x12, 0x0d, 0x0c, 0x0d, 0x09, 0x0e, 0x16, 0x11, 0x0c, 0x12, 0x14,
    0x0f, 0x0a, 0x16, 0x12, 0x10, 0x0b, 0x10, 0x0e, 0x15, 0x0e, 0x0b, 0x0d,
    0x13, 0x12, 0x17, 0x0d, 0x16, 0x0a, 0x0e, 0x08, 0x14, 0x14, 0x0c, 0x09,
    0x15, 0x13, 0x08, 0x0f, 0x17, 0x13, 0x0b, 0x0f, 0x15, 0x09, 0x09, 0x0e,
    0x0c, 0x12, 0x14, 0x0a, 0x08, 0x08, 0x0f, 0x14, 0x13, 0x0f, 0x09, 0x11,
    0x11, 0x10, 0x11, 0x0d, 0x0c, 0x16, 0x0f, 0x0a, 0x11, 0x10, 0x11, 0x11,
    0x0b, 0x15, 0x09, 0x09, 0x16, 0x0a, 0x0f, 0x0b, 0x15, 0x0c, 0x0d, 0x16,
    0x0d, 0x15, 0x12, 0x08, 0x0c, 0x14, 0x12, 0x15, 0x0c, 0x0b, 0x0b, 0x11,
    0x09, 0x12, 0x14, 0x13, 0x0b, 0x0e, 0x0d, 0x0e, 0x0b, 0x0e, 0x10, 0x0a,
    0x10, 0x08, 0x0e, 0x0e, 0x0c, 0x13, 0x0c, 0x12, 0x10, 0x16, 0x12, 0x14,
    0x13, 0x0c, 0x12, 0x08, 0x10, 0x15, 0x11, 0x12, 0x10, 0x0e, 0x0d, 0x13,
    0x14, 0x12, 0x0a, 0x08, 0x09, 0x12, 0x0b, 0x11, 0x13, 0x11, 0x08, 0x08,
    0x0c, 0x0c, 0x12, 0x15, 0x0a, 0x0d, 0x12, 0x16, 0x12, 0x0d, 0x16, 0x0a,
    0x0a, 0x10, 0x15, 0x12, 0x16, 0x0b, 0x0e, 0x13, 0x15, 0x10, 0x13, 0x16,
    0x0b, 0x16, 0x10, 0x16, 0x0f, 0x10, 0x17, 0x14, 0x15, 0x11, 0x12, 0x17,
    0x16, 0x0d, 0x15, 0x11, 0x12, 0x14, 0x14, 0x14, 0x0c, 0x11, 0x0f, 0x0a,
    0x14, 0x15, 0x15, 0x12, 0x0e, 0x11, 0x11, 0x12, 0x10, 0x0a, 0x11, 0x08,
    0x13, 0x10, 0x15, 0x10, 0x09, 0x0f, 0x10, 0x08, 0x15, 0x0e, 0x12, 0x0f,
    0x0a, 0x0e, 0x0b, 0x0e, 0x08, 0x13, 0x11, 0x15, 0x11, 0x0f, 0x0f, 0x17,
    0x08, 0x09, 0x12, 0x11, 0x0b, 0x0b, 0x12, 0x16, 0x13, 0x0f, 0x0f, 0x15,
    0x17, 0x17, 0x16, 0x14, 0x0d, 0x10, 0x0b, 0x0f, 0x17, 0x0f, 0x16, 0x17,
    0x0a, 0x0f, 0x14, 0x14, 0x16, 0x0c, 0x14, 0x17, 0x0d, 0x0e, 0x10, 0x10,
    0x11, 0x0b, 0x0f, 0x0d, 0x12, 0x16, 0x0b, 0x11, 0x15, 0x09, 0x0d, 0x0b,
    0x12, 0x11, 0x12, 0x11, 0x08, 0x10, 0x11, 0x0b, 0x08, 0x0d, 0x08, 0x16,
    0x15, 0x11, 0x13, 0x16, 0x0a, 0x0c, 0x0a, 0x0b, 0x12, 0x0a, 0x0a, 0x0b,
    0x17, 0x08, 0x0a, 0x09, 0x0f, 0x12, 0x16, 0x09, 0x11, 0x09, 0x0e, 0x0f,
    0x0e, 0x0c, 0x0b, 0x16, 0x11, 0x0b, 0x08, 0x0e, 0x15, 0x14, 0x0d, 0x17,
    0x08, 0x10, 0x0b, 0x12, 0x13, 0x0d, 0x16, 0x12, 0x0d, 0x08, 0x14, 0x14,
    0x13, 0x12, 0x16, 0x0d, 0x14, 0x0c, 0x14, 0x0b, 0x11, 0x08, 0x09, 0x0a,
    0x0b, 0x0a, 0x11, 0x08, 0x16, 0x17, 0x08, 0x16, 0x0f, 0x0c, 0x11, 0x0a,
    0x11, 0x0f, 0x15, 0x16, 0x10, 0x11, 0x13, 0x0b, 0x0c, 0x12, 0x10, 0x08,
    0x16, 0x0d, 0x0b, 0x10, 0x0e, 0x0c, 0x12, 0x12, 0x0f, 0x0c, 0x13, 0x0d,
    0x0b, 0x14, 0x0c, 0x12, 0x08, 0x15, 0x15, 0x11, 0x0d, 0x12, 0x10, 0x15,
    0x0c, 0x0c, 0x09, 0x10, 0x16, 0x11, 0x10, 0x15, 0x17, 0x13, 0x0d, 0x0d,
    0x08, 0x08, 0x08, 0x0f, 0x0c, 0x13, 0x15, 0x10, 0x0f, 0x09, 0x0b, 0x0f,
    0x16, 0x08, 0x09, 0x0b, 0x13, 0x11, 0x09, 0x17, 0x15, 0x0a, 0x0f, 0x14,
    0x14, 0x08, 0x11, 0x13, 0x13, 0x16, 0x09, 0x14, 0x17, 0x09, 0x0c, 0x0b,
    0x14, 0x09, 0x13, 0x0c, 0x0a, 0x17, 0x14, 0x09, 0x17, 0x15, 0x0d, 0x13,
    0x0f, 0x0e, 0x12, 0x0d, 0x11, 0x0a, 0x09, 0x0e, 0x0a, 0x12, 0x09, 0x16,
    0x11, 0x0b, 0x12, 0x10, 0x0c, 0x17, 0x14, 0x09, 0x08, 0x10, 0x0e, 0x0b,
    0x0f, 0x0a, 0x0c, 0x0e, 0x08, 0x12, 0x0a, 0x0f, 0x09, 0x14, 0x14, 0x12,
    0x16, 0x15, 0x09, 0x08, 0x10, 0x0a, 0x16, 0x09, 0x0e, 0x11, 0x12, 0x13,
    0x10, 0x0e, 0x15, 0x11, 0x16, 0x0b, 0x14, 0x0d, 0x0e, 0x09, 0x14, 0x0e,
    0x13, 0x16, 0x15, 0x15, 0x13, 0x12, 0x10, 0x11, 0x10, 0x11, 0x12, 0x08,
    0x14, 0x11, 0x0a, 0x0a, 0x0b, 0x14, 0x15, 0x13, 0x0a, 0x12, 0x0d, 0x09,
    0x16, 0x09, 0x0f, 0x0c, 0x0b, 0x0c, 0x12, 0x17, 0x0b, 0x10, 0x14, 0x16,
    0x0a, 0x0c, 0x10, 0x12, 0x15, 0x0b, 0x12, 0x12, 0x15, 0x15, 0x14, 0x08,
    0x11, 0x11, 0x14, 0x14, 0x0c, 0x09, 0x16, 0x0a, 0x0a, 0x0d, 0x0f, 0x0e,
    0x12, 0x09, 0x0d, 0x15, 0x11, 0x09, 0x14, 0x13, 0x0e, 0x0d, 0x0e, 0x0c,
    0x0c, 0x0a, 0x08, 0x16, 0x0c, 0x14, 0x12, 0x13, 0x0a, 0x08, 0x17, 0x14,
    0x09, 0x15, 0x0b, 0x17, 0x10, 0x12, 0x0f, 0x15, 0x16, 0x13, 0x0e, 0x0b,
    0x15, 0x0a, 0x12, 0x0d, 0x0d, 0x10, 0x0f, 0x12, 0x13, 0x0f, 0x10, 0x08,
    0x0c, 0x0b, 0x13, 0x0f, 0x0b, 0x12, 0x0b, 0x0d, 0x10, 0x0e, 0x0d, 0x08,
    0x09, 0x14, 0x16, 0x17, 0x10, 0x0c, 0x0a, 0x0d, 0x0f, 0x15, 0x12, 0x14,
    0x0e, 0x0a, 0x0e, 0x09, 0x11, 0x17, 0x09, 0x15, 0x0a, 0x14, 0x0d, 0x0e,
    0x0f, 0x10, 0x13, 0x17, 0x17, 0x09, 0x08, 0x08, 0x16, 0x16, 0x08, 0x0e,
    0x0a, 0x0b, 0x14, 0x11, 0x09, 0x0f, 0x0e, 0x0f, 0x11, 0x15, 0x11, 0x0b,
    0x14, 0x12, 0x09, 0x17, 0x0f, 0x0e, 0x0d, 0x16, 0x16, 0x09, 0x16, 0x16,
    0x0b, 0x16, 0x16, 0x09, 0x15, 0x17, 0x10, 0x08, 0x0b, 0x0c, 0x12, 0x0c,
    0x13, 0x08, 0x13, 0x0d, 0x15, 0x0c, 0x10, 0x12, 0x17, 0x11, 0x12, 0x0e,
    0x08, 0x17, 0x0d, 0x16, 0x09, 0x0c, 0x14, 0x0c, 0x0a, 0x13, 0x0e, 0x08,
    0x13, 0x16, 0x08, 0x16, 0x0a, 0x12, 0x0a, 0x16, 0x12, 0x15, 0x0c, 0x10,
    0x0a, 0x15, 0x0b, 0x09, 0x0f, 0x15, 0x10, 0x0f, 0x15, 0x16, 0x0e, 0x17,
    0x0a, 0x0b, 0x0b, 0x0d, 0x16, 0x12, 0x0d, 0x11, 0x10, 0x0e, 0x10, 0x13,
    0x08, 0x12, 0x11, 0x13, 0x10, 0x16, 0x0b, 0x12, 0x13, 0x0f, 0x14, 0x0a,
    0x0d, 0x0d, 0x12, 0x0a, 0x0b, 0x08, 0x0a, 0x0e, 0x0b, 0x0e, 0x14, 0x0a,
    0x08, 0x0a, 0x13, 0x10, 0x10, 0x0b, 0x0b, 0x10, 0x16, 0x15, 0x0b, 0x0e,
    0x13, 0x0f, 0x09, 0x0f, 0x17, 0x16, 0x12, 0x0c, 0x0b, 0x0c, 0x0f, 0x0f,
    0x0c, 0x11, 0x16, 0x10, 0x17, 0x12, 0x12, 0x17, 0x14, 0x0e, 0x10, 0x0d,
    0x12, 0x13, 0x15, 0x10, 0x11, 0x09, 0x17, 0x0d, 0x11, 0x08, 0x14, 0x10,
    0x16, 0x0e, 0x14, 0x0a, 0x13, 0x0b, 0x11, 0x08, 0x15, 0x0f, 0x10, 0x14,
    0x0a, 0x0a, 0x14, 0x16, 0x10, 0x0c, 0x0b, 0x0b, 0x08, 0x09, 0x13, 0x11,
    0x0b, 0x12, 0x17, 0x14, 0x13, 0x13, 0x0c, 0x12, 0x0a, 0x09, 0x14, 0x15,
    0x0d, 0x0e, 0x15, 0x0a, 0x15, 0x0e, 0x16, 0x17, 0x10, 0x13, 0x16, 0x09,
    0x0b, 0x0b, 0x0a, 0x09, 0x11, 0x08, 0x09, 0x0a, 0x14, 0x17, 0x0c, 0x14,
    0x0a, 0x11, 0x14, 0x0e, 0x11, 0x0f, 0x16, 0x0c, 0x08, 0x0a, 0x13, 0x0d,
    0x13, 0x15, 0x15, 0x0e, 0x13, 0x0a, 0x0e, 0x17, 0x0d, 0x10, 0x08, 0x16,
    0x11, 0x09, 0x09, 0x0d, 0x09, 0x0d, 0x09, 0x0c, 0x16, 0x16, 0x12, 0x0f,
    0x0d, 0x10, 0x14, 0x0e, 0x13, 0x10, 0x13, 0x0f, 0x0d, 0x10, 0x15, 0x09,
    0x13, 0x0b, 0x08, 0x08, 0x13, 0x08, 0x17, 0x0c, 0x0a, 0x08, 0x12, 0x0c,
    0x0d, 0x13, 0x10, 0x0b, 0x12, 0x0b, 0x13, 0x08, 0x14, 0x10, 0x0e, 0x0f,
    0x09, 0x0a, 0x16, 0x0f, 0x13, 0x14, 0x10, 0x0e, 0x17, 0x10, 0x0f, 0x13,
    0x11, 0x0e, 0x08, 0x13, 0x0f, 0x12, 0x08, 0x14, 0x0e, 0x11, 0x08, 0x08,
    0x14, 0x14, 0x08, 0x10, 0x0d, 0x0e, 0x08, 0x0e, 0x11, 0x17, 0x15, 0x0c,
    0x13, 0x0e, 0x12, 0x13, 0x16, 0x09, 0x0e, 0x10, 0x0f, 0x0f, 0x0c, 0x17,
    0x09, 0x0c, 0x13, 0x0f, 0x15, 0x14, 0x10, 0x12, 0x11, 0x10, 0x0a, 0x16,
    0x17, 0x0b, 0x0d, 0x10, 0x0a, 0x0b, 0x14, 0x15, 0x11, 0x0f, 0x11, 0x10,
    0x10, 0x17, 0x08, 0x08, 0x0e, 0x0d, 0x17, 0x10, 0x11, 0x13, 0x17, 0x0f,
    0x10, 0x10, 0x09, 0x09, 0x08, 0x0c, 0x08, 0x08, 0x0f, 0x0e, 0x10, 0x11,
    0x11, 0x0d, 0x0f, 0x0b, 0x14, 0x08, 0x14, 0x0d, 0x08, 0x15, 0x0d, 0x0f,
    0x0a, 0x0d, 0x17, 0x14, 0x08, 0x17, 0x0b, 0x11, 0x0f, 0x0d, 0x13, 0x10,
    0x11, 0x14, 0x10, 0x09, 0x0a, 0x09, 0x13, 0x13, 0x0f, 0x0b, 0x17, 0x0c,
    0x0c, 0x13, 0x11, 0x0d, 0x10, 0x17, 0x14, 0x13, 0x0c, 0x14, 0x0f, 0x0d,
    0x14, 0x12, 0x16, 0x0c, 0x08, 0x11, 0x15, 0x12, 0x0d, 0x0e, 0x13, 0x10,
    0x10, 0x0f, 0x0c, 0x17, 0x12, 0x0b, 0x0b, 0x17, 0x17, 0x15, 0x0c, 0x0f,
    0x14, 0x08, 0x0a, 0x08, 0x15, 0x12, 0x0e, 0x12, 0x0c, 0x0c, 0x16, 0x0d,
    0x16, 0x13, 0x17, 0x0c, 0x09, 0x13, 0x14, 0x11, 0x0a, 0x08, 0x11, 0x15,
    0x0b, 0x15, 0x14, 0x0a, 0x12, 0x08, 0x12, 0x0e, 0x09, 0x15, 0x0f, 0x17,
    0x0f, 0x15, 0x11, 0x14, 0x09, 0x0f, 0x09, 0x08, 0x0b, 0x08, 0x0c, 0x0d,
    0x12, 0x0b, 0x0a, 0x14, 0x12, 0x0b, 0x15, 0x16, 0x0c, 0x09, 0x0b, 0x08,
    0x09, 0x0a, 0x16, 0x0a, 0x12, 0x12, 0x0e, 0x17, 0x0a, 0x15, 0x17, 0x14,
    0x17, 0x0d, 0x0f, 0x16, 0x0a, 0x08, 0x0c, 0x15, 0x0c, 0x0e, 0x12, 0x16,
    0x12, 0x0f, 0x15, 0x16, 0x11, 0x08, 0x16, 0x13, 0x0b, 0x15, 0x15, 0x15,
    0x0f, 0x0c, 0x15, 0x12, 0x0a, 0x14, 0x0e, 0x09, 0x09, 0x15, 0x17, 0x0c,
    0x16, 0x0c, 0x0a, 0x0a, 0x12, 0x15, 0x09, 0x0d, 0x0d, 0x16, 0x0b, 0x16,
    0x17, 0x0a, 0x11, 0x0a, 0x17, 0x0f, 0x08, 0x0f, 0x13, 0x15, 0x09, 0x16,
    0x12, 0x10, 0x17, 0x13, 0x0d, 0x17, 0x08, 0x0c, 0x0b, 0x0b, 0x0e, 0x16,
    0x08, 0x10, 0x0b, 0x0d, 0x0f, 0x0f, 0x0b, 0x0e, 0x11, 0x15, 0x11, 0x11,
    0x0c, 0x11, 0x08, 0x08, 0x0f, 0x0a, 0x16, 0x09, 0x12, 0x16, 0x15, 0x17,
    0x16, 0x16, 0x0c, 0x0a, 0x09, 0x13, 0x08, 0x09, 0x0b, 0x0c, 0x0f, 0x12,
    0x13, 0x13, 0x09, 0x0d, 0x10, 0x13, 0x16, 0x15, 0x0d, 0x17, 0x16, 0x14,
    0x09, 0x15, 0x16, 0x13, 0x13, 0x13, 0x13, 0x12, 0x11, 0x17, 0x14, 0x13,
    0x12, 0x15, 0x15, 0x16, 0x09, 0x0c, 0x11, 0x15, 0x08, 0x12, 0x0a, 0x10,
    0x0e, 0x09, 0x0e, 0x13, 0x09, 0x0c, 0x10, 0x0a, 0x09, 0x0e, 0x16, 0x15,
    0x0a, 0x12, 0x0f, 0x14, 0x12, 0x0c, 0x0f, 0x0c, 0x0a, 0x0c, 0x0b, 0x0c,
    0x11, 0x14, 0x09, 0x11, 0x0f, 0x0c, 0x0a, 0x15, 0x0e, 0x10, 0x11, 0x0f,
    0x15, 0x0a, 0x12, 0x16, 0x10, 0x10, 0x14, 0x13, 0x0b, 0x0c, 0x0f, 0x15,
    0x10, 0x16, 0x09, 0x13, 0x0b, 0x0d, 0x17, 0x14, 0x09, 0x08, 0x0d, 0x10,
    0x0d, 0x0f, 0x0e, 0x13, 0x08, 0x08, 0x0b, 0x15, 0x0a, 0x15, 0x14, 0x13,
    0x0e, 0x10, 0x0e, 0x11, 0x14, 0x15, 0x0e, 0x0d, 0x13, 0x10, 0x08, 0x17,
    0x15, 0x17, 0x13, 0x17, 0x08, 0x09, 0x0f, 0x0d, 0x10, 0x16, 0x09, 0x11,
    0x16, 0x0c, 0x0e, 0x09, 0x09, 0x0a, 0x14, 0x10, 0x12, 0x0a, 0x09, 0x0f,
    0x17, 0x10, 0x14, 0x13, 0x08, 0x14, 0x12, 0x16, 0x14, 0x0e, 0x15, 0x14,
    0x0f, 0x0d, 0x09, 0x17, 0x0b, 0x0a, 0x11, 0x0a, 0x0e, 0x17, 0x0b, 0x10,
    0x14, 0x0f, 0x0e, 0x08, 0x11, 0x17, 0x0a, 0x08, 0x16, 0x0e, 0x11, 0x09,
    0x0f, 0x12, 0x16, 0x11, 0x15, 0x0a, 0x14, 0x10, 0x0b, 0x12, 0x0b, 0x08,
    0x0b, 0x15, 0x12, 0x0b, 0x0c, 0x08, 0x11, 0x09, 0x0f, 0x17, 0x09, 0x09,
    0x17, 0x0c, 0x0a, 0x16, 0x12, 0x13, 0x17, 0x0a, 0x0e, 0x15, 0x13, 0x0b,
    0x17, 0x10, 0x13, 0x0b, 0x0b, 0x17, 0x0b, 0x0f, 0x15, 0x16, 0x12, 0x09,
    0x16, 0x0b, 0x0a, 0x0e, 0x0b, 0x0b, 0x10, 0x0b, 0x10, 0x12, 0x09, 0x0a,
    0x0e, 0x08, 0x0c, 0x15, 0x16, 0x08, 0x08, 0x16, 0x11, 0x14, 0x09, 0x14,
    0x13, 0x0c, 0x0b, 0x11, 0x0b, 0x16, 0x12, 0x09, 0x09, 0x15, 0x10, 0x0d,
    0x09, 0x08, 0x10, 0x11, 0x13, 0x12, 0x14, 0x0a, 0x12, 0x09, 0x17, 0x11,
    0x0a, 0x08, 0x0f, 0x13, 0x15, 0x10, 0x10, 0x11, 0x15, 0x13, 0x0a, 0x08,
    0x12, 0x14, 0x0a, 0x14, 0x12, 0x12, 0x09, 0x13, 0x13, 0x12, 0x0d, 0x0f,
    0x0c, 0x09, 0x11, 0x17, 0x0b, 0x11, 0x10, 0x0d, 0x11, 0x08, 0x08, 0x0e,
    0x10, 0x10, 0x17, 0x0d, 0x0c, 0x09, 0x0d, 0x16, 0x16, 0x0f, 0x12, 0x11,
    0x0a, 0x14, 0x0d, 0x16, 0x0f, 0x12, 0x0d, 0x13, 0x14, 0x16, 0x13, 0x17,
    0x0f, 0x0c, 0x0c, 0x09, 0x0c, 0x0d, 0x10, 0x14, 0x16, 0x10, 0x0a, 0x0b,
    0x12, 0x10, 0x0a, 0x10, 0x08, 0x14, 0x0a, 0x0a, 0x11, 0x0f, 0x08, 0x08,
    0x09, 0x0e, 0x14, 0x15, 0x0c, 0x0f, 0x15, 0x14, 0x14, 0x0a, 0x16, 0x09,
    0x0f, 0x0e, 0x16, 0x0e, 0x17, 0x08, 0x11, 0x11, 0x10, 0x13, 0x0a, 0x10,
    0x10, 0x0c, 0x13, 0x09, 0x13, 0x14, 0x0a, 0x15, 0x0a, 0x16, 0x13, 0x0f,
    0x0e, 0x10, 0x0c, 0x0b, 0x12, 0x0b, 0x0c, 0x0a, 0x12, 0x0a, 0x10, 0x11,
    0x0a, 0x0a, 0x0a, 0x13, 0x16, 0x0c, 0x0c, 0x0e, 0x11, 0x08, 0x10, 0x0c,
    0x15, 0x12, 0x09, 0x08, 0x11, 0x14, 0x0f, 0x17, 0x0d, 0x14, 0x0a, 0x17,
    0x17, 0x0e, 0x0a, 0x12, 0x11, 0x13, 0x0b, 0x13, 0x15, 0x0d, 0x0f, 0x13,
    0x12, 0x13, 0x0a, 0x0b, 0x14, 0x12, 0x10, 0x11, 0x0d, 0x11, 0x11, 0x16,
    0x0e, 0x09, 0x15, 0x13, 0x15, 0x08, 0x13, 0x15, 0x0f, 0x15, 0x0f, 0x08,
    0x16, 0x09, 0x0b, 0x14, 0x09, 0x16, 0x11, 0x11, 0x14, 0x09, 0x11, 0x0d,
    0x14, 0x0d, 0x14, 0x15, 0x11, 0x17, 0x11, 0x10, 0x0c, 0x10, 0x0b, 0x0c,
    0x08, 0x0f, 0x11, 0x0a, 0x0c, 0x14, 0x12, 0x0b, 0x15, 0x15, 0x17, 0x17,
    0x14, 0x11, 0x10, 0x11, 0x12, 0x0a, 0x16, 0x0e, 0x0f, 0x13, 0x0c, 0x08,
    0x12, 0x15, 0x10, 0x16, 0x0e, 0x14, 0x0a, 0x0e, 0x0b, 0x13, 0x11, 0x10,
    0x0f, 0x0b, 0x14, 0x0d, 0x08, 0x13, 0x0d, 0x15, 0x0c, 0x15, 0x0e, 0x17,
    0x17, 0x0d, 0x0d, 0x0f, 0x08, 0x12, 0x10, 0x12, 0x10, 0x09, 0x10, 0x16,
    0x15, 0x12, 0x0d, 0x09, 0x0e, 0x16, 0x12, 0x16, 0x09, 0x0e, 0x0b, 0x0a,
    0x0a, 0x10, 0x08, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x14, 0x14, 0x16, 0x14,
    0x0e, 0x0e, 0x0e, 0x16, 0x10, 0x17, 0x14, 0x0d, 0x12, 0x0a, 0x0f, 0x08,
    0x08, 0x09, 0x17, 0x0a, 0x10, 0x0a, 0x0c, 0x13, 0x13, 0x0c, 0x0a, 0x0a,
    0x13, 0x10, 0x11, 0x0f, 0x0c, 0x0f, 0x0b, 0x12, 0x16, 0x12, 0x11, 0x0e,
    0x12, 0x0e, 0x13, 0x0c, 0x10, 0x0b, 0x0d, 0x10, 0x0d, 0x0c, 0x12, 0x15,
    0x0f, 0x17, 0x10, 0x0b, 0x0b, 0x12, 0x0d, 0x16, 0x0a, 0x17, 0x0e, 0x0e,
    0x0e, 0x12, 0x09, 0x0d, 0x0c, 0x12, 0x13, 0x17, 0x08, 0x0f, 0x0b, 0x10,
    0x12, 0x11, 0x09, 0x17, 0x16, 0x14, 0x15, 0x0e, 0x13, 0x0d, 0x11, 0x17,
    0x08, 0x17, 0x16, 0x0b, 0x16, 0x0c, 0x12, 0x0d, 0x16, 0x13, 0x12, 0x0b,
    0x0e, 0x0d, 0x0a, 0x0e, 0x15, 0x0e, 0x17, 0x0f, 0x08, 0x09, 0x0f, 0x16,
    0x15, 0x0c, 0x0c, 0x11, 0x12, 0x16, 0x10, 0x13, 0x15, 0x0f, 0x16, 0x13,
    0x14, 0x10, 0x09, 0x12, 0x0c, 0x13, 0x16, 0x12, 0x08, 0x09, 0x08, 0x15,
    0x0f, 0x08, 0x0d, 0x10, 0x09, 0x14, 0x0f, 0x17, 0x09, 0x13, 0x10, 0x13,
    0x12, 0x09, 0x0e, 0x0f, 0x10, 0x0d, 0x0b, 0x0c, 0x15, 0x0c, 0x17, 0x09,
    0x17, 0x16, 0x14, 0x08, 0x17, 0x14, 0x16, 0x0f, 0x15, 0x0c, 0x17, 0x17,
    0x09, 0x0e, 0x16, 0x0a, 0x0a, 0x0e, 0x16, 0x14, 0x10, 0x0d, 0x0c, 0x09,
    0x12, 0x10, 0x0e, 0x10, 0x14, 0x0e, 0x12, 0x14, 0x0c, 0x0e, 0x15, 0x0c,
    0x16, 0x0c, 0x13, 0x12, 0x12, 0x0e, 0x0f, 0x17, 0x14, 0x0d, 0x0b, 0x17,
    0x09, 0x17, 0x08, 0x0a, 0x12, 0x08, 0x0c, 0x14, 0x15, 0x10, 0x09, 0x0a,
    0x14, 0x0a, 0x17, 0x0c, 0x10, 0x16, 0x10, 0x0f, 0x0a, 0x0c, 0x0a, 0x15,
    0x12, 0x11, 0x14, 0x0f, 0x17, 0x17, 0x0f, 0x08, 0x17, 0x0f, 0x0b, 0x11,
    0x0f, 0x0f, 0x0e, 0x0d, 0x08, 0x0f, 0x10, 0x14, 0x12, 0x10, 0x09, 0x0b,
    0x0e, 0x11, 0x12, 0x11, 0x16, 0x14, 0x0e, 0x11, 0x0e, 0x0a, 0x08, 0x0d,
    0x0a, 0x0f, 0x0e, 0x09, 0x17, 0x11, 0x13, 0x0f, 0x09, 0x09, 0x15, 0x09,
    0x11, 0x0d, 0x16, 0x0c, 0x15, 0x17, 0x0f, 0x0c, 0x11, 0x0a, 0x15, 0x10,
    0x17, 0x0b, 0x09, 0x0e, 0x0e, 0x09, 0x13, 0x11, 0x11, 0x0a, 0x13, 0x10,
    0x14, 0x0e, 0x08, 0x15, 0x10, 0x15, 0x17, 0x09, 0x0a, 0x15, 0x0e, 0x08,
    0x15, 0x15, 0x0c, 0x0f, 0x08, 0x0a, 0x17, 0x17, 0x0d, 0x09, 0x0d, 0x14,
    0x0b, 0x09, 0x0d, 0x14, 0x0c, 0x08, 0x0d, 0x08, 0x0f, 0x0d, 0x16, 0x17,
    0x0a, 0x15, 0x09, 0x0d, 0x13, 0x0f, 0x0e, 0x11, 0x0d, 0x12, 0x09, 0x0d,
    0x14, 0x09, 0x0d, 0x0a, 0x0a, 0x13, 0x17, 0x0d, 0x15, 0x0c, 0x0a, 0x09,
    0x0d, 0x10, 0x0a, 0x14, 0x15, 0x08, 0x13, 0x08, 0x16, 0x15, 0x0e, 0x12,
    0x0c, 0x14, 0x0b, 0x11, 0x0f, 0x0c, 0x17, 0x0c, 0x0d, 0x0c, 0x0f, 0x10,
    0x08, 0x0e, 0x15, 0x15, 0x12, 0x08, 0x16, 0x17, 0x10, 0x09, 0x14, 0x0e,
    0x0a, 0x0f, 0x0f, 0x08, 0x0c, 0x15, 0x13, 0x11, 0x12, 0x16, 0x0a, 0x0a,
    0x0b, 0x0a, 0x0e, 0x11, 0x0f, 0x16, 0x09, 0x0f, 0x0c, 0x17, 0x0c, 0x17,
    0x17, 0x0b, 0x17, 0x10, 0x0c, 0x13, 0x16, 0x0e, 0x0a, 0x0e, 0x0f, 0x0f,
    0x0c, 0x0a, 0x08, 0x16, 0x09, 0x0b, 0x09, 0x0d, 0x0e, 0x0f, 0x16, 0x15,
    0x0e, 0x08, 0x0c, 0x12, 0x08, 0x11, 0x11, 0x08, 0x15, 0x10, 0x10, 0x09,
    0x0b, 0x0f, 0x10, 0x0e, 0x15, 0x08, 0x16, 0x09, 0x0a, 0x16, 0x08, 0x0c,
    0x0a, 0x09, 0x11, 0x10, 0x11, 0x10, 0x0d, 0x17, 0x10, 0x12, 0x11, 0x11,
    0x0c, 0x0b, 0x11, 0x09, 0x14, 0x09, 0x0b, 0x08, 0x10, 0x14, 0x0e, 0x0e,
    0x17, 0x08, 0x0c, 0x13, 0x0a, 0x0f, 0x14, 0x13, 0x0c, 0x0b, 0x09, 0x08,
    0x10, 0x11, 0x17, 0x13, 0x09, 0x0a, 0x09, 0x12, 0x17, 0x17, 0x15, 0x0d,
    0x0b, 0x17, 0x0b, 0x09, 0x13, 0x13, 0x0c, 0x13, 0x13, 0x11, 0x0f, 0x16,
    0x08, 0x0b, 0x11, 0x0d, 0x0e, 0x12, 0x0d, 0x16, 0x0b, 0x0d, 0x12, 0x0c,
    0x0f, 0x13, 0x17, 0x0f, 0x13, 0x14, 0x14, 0x17, 0x13, 0x08, 0x09, 0x0f,
    0x13, 0x0e, 0x0a, 0x0f, 0x17, 0x11, 0x0d, 0x08, 0x14, 0x16, 0x0d, 0x0b,
    0x10, 0x12, 0x09, 0x14, 0x17, 0x13, 0x09, 0x0f, 0x0f, 0x08, 0x17, 0x0b,
    0x14, 0x14, 0x0a, 0x10, 0x15, 0x0c, 0x17, 0x10, 0x12, 0x0a, 0x17, 0x11,
    0x13, 0x0d, 0x11, 0x10, 0x0b, 0x16, 0x13, 0x14, 0x11, 0x15, 0x10, 0x11,
    0x10, 0x11, 0x08, 0x08, 0x11, 0x08, 0x0b, 0x0e, 0x15, 0x0e, 0x16, 0x12,
    0x12, 0x16, 0x0a, 0x0c, 0x08, 0x0a, 0x15, 0x14, 0x0f, 0x0f, 0x0d, 0x13,
    0x0d, 0x08, 0x0f, 0x16, 0x15, 0x08, 0x0f, 0x0e, 0x12, 0x10, 0x0e, 0x0c,
    0x11, 0x12, 0x12, 0x0e, 0x08, 0x11, 0x08, 0x12, 0x0f, 0x0b, 0x17, 0x10,
    0x0e, 0x15, 0x0d, 0x16, 0x0c, 0x12, 0x11, 0x11, 0x13, 0x09, 0x10, 0x11,
    0x09, 0x08, 0x17, 0x13, 0x10, 0x0e, 0x17, 0x0a, 0x08, 0x12, 0x10, 0x09,
    0x0c, 0x11, 0x14, 0x14, 0x15, 0x13, 0x0c, 0x0b, 0x11, 0x12, 0x0a, 0x15,
    0x0c, 0x14, 0x0f, 0x08, 0x15, 0x08, 0x11, 0x16, 0x08, 0x11, 0x12, 0x11,
    0x08, 0x12, 0x13, 0x08, 0x0d, 0x0b, 0x0a, 0x11, 0x15, 0x16, 0x0d, 0x12,
    0x12, 0x12, 0x16, 0x0b, 0x0c, 0x08, 0x09, 0x11, 0x14, 0x11, 0x11, 0x12,
    0x11, 0x0b, 0x11, 0x11, 0x14, 0x0b, 0x0b, 0x14, 0x16, 0x16, 0x15, 0x0b,
    0x0a, 0x08, 0x15, 0x17, 0x16, 0x0a, 0x12, 0x11, 0x14, 0x10, 0x15, 0x09,
    0x11, 0x16, 0x12, 0x0e, 0x10, 0x0c, 0x08, 0x09, 0x10, 0x11, 0x13, 0x0c,
    0x15, 0x16, 0x09, 0x13, 0x14, 0x17, 0x17, 0x17, 0x17, 0x14, 0x16, 0x16,
    0x17, 0x10, 0x0f, 0x14, 0x09, 0x0d, 0x15, 0x12, 0x0b, 0x10, 0x08, 0x14,
    0x14, 0x09, 0x15, 0x0d, 0x12, 0x11, 0x12, 0x0f, 0x0f, 0x13, 0x0b, 0x0c,
    0x11, 0x0c, 0x0a, 0x0b, 0x15, 0x14, 0x13, 0x0d, 0x10, 0x16, 0x12, 0x0b,
    0x08, 0x16, 0x16, 0x17, 0x08, 0x10, 0x16, 0x14, 0x11, 0x10, 0x11, 0x08,
    0x08, 0x08, 0x12, 0x08, 0x11, 0x09, 0x15, 0x0a, 0x0d, 0x17, 0x0e, 0x0a,
    0x14, 0x0a, 0x10, 0x0c, 0x08, 0x0a, 0x10, 0x09, 0x08, 0x0e, 0x09, 0x09,
    0x17, 0x17, 0x15, 0x10, 0x10, 0x0f, 0x11, 0x10, 0x10, 0x0b, 0x11, 0x09,
    0x0c, 0x0f, 0x0c, 0x11, 0x0f, 0x12, 0x14, 0x0b, 0x14, 0x0c, 0x0f, 0x15,
    0x0e, 0x17, 0x17, 0x0f, 0x0e, 0x08, 0x10, 0x0d, 0x08, 0x0e, 0x16, 0x10,
    0x15, 0x0f, 0x09, 0x0d, 0x13, 0x12, 0x0f, 0x08, 0x0a, 0x13, 0x11, 0x11,
    0x0e, 0x0e, 0x14, 0x0a, 0x13, 0x0c, 0x08, 0x09, 0x0c, 0x17, 0x10, 0x12,
    0x08, 0x09, 0x08, 0x08, 0x0f, 0x17, 0x11, 0x0d, 0x0e, 0x13, 0x13, 0x0a,
    0x0e, 0x0a, 0x0a, 0x10, 0x15, 0x14, 0x09, 0x0b, 0x0a, 0x15, 0x0e, 0x15,
    0x0a, 0x0f, 0x17, 0x0e, 0x0e, 0x10, 0x09, 0x0f, 0x12, 0x09, 0x0f, 0x09,
    0x08, 0x09, 0x0f, 0x0f, 0x14, 0x0a, 0x11, 0x0a, 0x0d, 0x14, 0x12, 0x0a,
    0x10, 0x13, 0x0e, 0x12, 0x11, 0x15, 0x10, 0x13, 0x0c, 0x10, 0x0a, 0x13,
    0x08, 0x0b, 0x0a, 0x13, 0x0c, 0x12, 0x14, 0x0d, 0x13, 0x0c, 0x15, 0x0f,
    0x0f, 0x0f, 0x11, 0x14, 0x0b, 0x0c, 0x16, 0x13, 0x17, 0x0d, 0x0e, 0x11,
    0x0a, 0x17, 0x0d, 0x0f, 0x0f, 0x0f, 0x0a, 0x10, 0x12, 0x0d, 0x0b, 0x17,
    0x17, 0x08, 0x0d, 0x13, 0x0c, 0x0a, 0x0a, 0x14, 0x11, 0x14, 0x10, 0x14,
    0x09, 0x0f, 0x0f, 0x08, 0x14, 0x16, 0x12, 0x17, 0x15, 0x17, 0x0e, 0x0d,
    0x0f, 0x11, 0x15, 0x09, 0x17, 0x09, 0x09, 0x17, 0x09, 0x0e, 0x12, 0x0e,
    0x10, 0x15, 0x0a, 0x0a, 0x12, 0x12, 0x16, 0x13, 0x09, 0x0e, 0x14, 0x16,
    0x0c, 0x0e, 0x15, 0x0a, 0x0e, 0x0c, 0x0f, 0x15, 0x16, 0x0d, 0x17, 0x15,
    0x0e, 0x08, 0x14, 0x10, 0x0f, 0x0f, 0x16, 0x17, 0x0c, 0x09, 0x0a, 0x16,
    0x14, 0x08, 0x11, 0x16, 0x0f, 0x0d, 0x14, 0x14, 0x14, 0x12, 0x16, 0x0a,
    0x17, 0x0e, 0x17, 0x16, 0x14, 0x16, 0x13, 0x0a, 0x17, 0x10, 0x13, 0x0e,
    0x0a, 0x17, 0x13, 0x16, 0x16, 0x0f, 0x09, 0x15, 0x08, 0x14, 0x0c, 0x08,
    0x0e, 0x12, 0x0c, 0x09, 0x0b, 0x0e, 0x11, 0x14, 0x0a, 0x08, 0x15, 0x0b,
    0x0b, 0x12, 0x09, 0x09, 0x0e, 0x09, 0x17, 0x10, 0x08, 0x13, 0x0f, 0x17,
    0x0a, 0x10, 0x14, 0x0b, 0x0d, 0x09, 0x0b, 0x13, 0x13, 0x10, 0x15, 0x17,
    0x17, 0x0f, 0x13, 0x09, 0x0f, 0x11, 0x0d, 0x13, 0x0b, 0x0e, 0x14, 0x11,
    0x0f, 0x14, 0x0a, 0x10, 0x0f, 0x12, 0x0f, 0x12, 0x0a, 0x0c, 0x15, 0x10,
    0x0d, 0x09, 0x0b, 0x09, 0x12, 0x09, 0x08, 0x11, 0x11, 0x14, 0x13, 0x08,
    0x0d, 0x08, 0x14, 0x10, 0x0f, 0x11, 0x0a, 0x17, 0x0d, 0x0c, 0x10, 0x14,
    0x16, 0x17, 0x0f, 0x09, 0x0c, 0x0d, 0x11, 0x11, 0x0f, 0x15, 0x12, 0x09,
    0x17, 0x13, 0x12, 0x10, 0x0f, 0x0e, 0x11, 0x14, 0x0e, 0x0d, 0x0c, 0x16,
    0x16, 0x0f, 0x16, 0x0c, 0x13, 0x0e, 0x09, 0x12, 0x0e, 0x10, 0x14, 0x12,
    0x15, 0x0e, 0x0c, 0x0c, 0x0c, 0x17, 0x0d, 0x0b, 0x12, 0x08, 0x13, 0x09,
    0x0e, 0x0c, 0x16, 0x15, 0x12, 0x0b, 0x14, 0x10, 0x12, 0x12, 0x15, 0x0e,
    0x08, 0x16, 0x09, 0x0f, 0x0e, 0x15, 0x09, 0x0c, 0x0c, 0x0e, 0x10, 0x10,
    0x0d, 0x16, 0x13, 0x08, 0x17, 0x0f, 0x0a, 0x0e, 0x14, 0x08, 0x0b, 0x0e,
    0x0b, 0x17, 0x17, 0x16, 0x12, 0x14, 0x0c, 0x13, 0x13, 0x0e, 0x0a, 0x09,
    0x0c, 0x0c, 0x0e, 0x10, 0x12, 0x17, 0x08, 0x08, 0x15, 0x14, 0x08, 0x15,
    0x0c, 0x0a, 0x0b, 0x08, 0x0b, 0x0f, 0x0f, 0x0e, 0x0f, 0x0f, 0x0d, 0x09,
    0x0b, 0x12, 0x14, 0x17, 0x08, 0x17, 0x09, 0x0c, 0x0b, 0x0f, 0x15, 0x16,
    0x0e, 0x15, 0x17, 0x0c, 0x12, 0x17, 0x09, 0x17, 0x0a, 0x0c, 0x17, 0x0d,
    0x13, 0x0f, 0x14, 0x0a, 0x16, 0x09, 0x0c, 0x0a, 0x14, 0x08, 0x09, 0x14,
    0x08, 0x0a, 0x09, 0x0c, 0x12, 0x16, 0x0a, 0x08, 0x14, 0x09, 0x0c, 0x0f,
    0x09, 0x0d, 0x0e, 0x0b, 0x12, 0x0e, 0x11, 0x0d, 0x15, 0x0d, 0x10, 0x14,
    0x0f, 0x14, 0x16, 0x0b, 0x15, 0x08, 0x08, 0x15, 0x0b, 0x09, 0x09, 0x15,
    0x17, 0x0c, 0x15, 0x14, 0x0e, 0x0a, 0x0b, 0x0f, 0x10, 0x11, 0x13, 0x0a,
    0x16, 0x0f, 0x0b, 0x0d, 0x12, 0x0e, 0x14, 0x0a, 0x17, 0x10, 0x0d, 0x17,
    0x14, 0x15, 0x14, 0x0f, 0x16, 0x0d, 0x11, 0x14, 0x16, 0x16, 0x0e, 0x0f,
    0x0c, 0x17, 0x0b, 0x13, 0x11, 0x15, 0x0a, 0x10, 0x0d, 0x0e, 0x15, 0x17,
    0x14, 0x12, 0x0a, 0x14, 0x0a, 0x0f, 0x13, 0x17, 0x0d, 0x0f, 0x0e, 0x0b,
    0x15, 0x17, 0x17, 0x13, 0x16, 0x0e, 0x0a, 0x0a, 0x0e, 0x0e, 0x16, 0x17,
    0x0b, 0x09, 0x10, 0x11, 0x0f, 0x0d, 0x10, 0x0b, 0x08, 0x13, 0x08, 0x0a,
    0x0b, 0x13, 0x0a, 0x10, 0x0b, 0x10, 0x14, 0x09, 0x10, 0x14, 0x15, 0x0f,
    0x0b, 0x08, 0x11, 0x11, 0x0e, 0x10, 0x11, 0x12, 0x11, 0x09, 0x0b, 0x08,
    0x0f, 0x14, 0x0c, 0x0f, 0x0f, 0x0c, 0x11, 0x12, 0x08, 0x14, 0x0b, 0x0c,
    0x0c, 0x17, 0x0e, 0x15, 0x14, 0x0b, 0x0c, 0x17, 0x0b, 0x16, 0x10, 0x12,
    0x0e, 0x0a, 0x0c, 0x17, 0x0b, 0x0f, 0x08, 0x12, 0x0c, 0x0c, 0x0a, 0x14,
    0x11, 0x14, 0x0e, 0x12, 0x10, 0x12, 0x17, 0x15, 0x12, 0x0d, 0x12, 0x0e,
    0x11, 0x17, 0x0e, 0x14, 0x15, 0x16, 0x0f, 0x0b, 0x09, 0x13, 0x0b, 0x0c,
    0x0b, 0x0b, 0x17, 0x10, 0x10, 0x09, 0x0c, 0x09, 0x16, 0x12, 0x13, 0x0e,
    0x0d, 0x12, 0x0b, 0x17, 0x08, 0x16, 0x0e, 0x11, 0x15, 0x14, 0x0e, 0x13,
    0x13, 0x15, 0x17, 0x14, 0x11, 0x0a, 0x09, 0x15, 0x0e, 0x09, 0x0d, 0x16,
    0x0b, 0x11, 0x17, 0x09, 0x0c, 0x13, 0x0f, 0x11, 0x0e, 0x12, 0x11, 0x0e,
    0x11, 0x08, 0x08, 0x0e, 0x14, 0x0e, 0x0a, 0x10, 0x0c, 0x09, 0x0c, 0x15,
    0x0c, 0x0e, 0x12, 0x12, 0x0f, 0x17, 0x10, 0x12, 0x11, 0x10, 0x13, 0x15,
    0x0c, 0x0b, 0x0f, 0x13, 0x16, 0x08, 0x0a, 0x0f, 0x08, 0x0a, 0x16, 0x15,
    0x10, 0x08, 0x0d, 0x14, 0x09, 0x12, 0x12, 0x0d, 0x09, 0x0d, 0x08, 0x10,
    0x0d, 0x11, 0x0b, 0x16, 0x0a, 0x17, 0x13, 0x0e, 0x0a, 0x0b, 0x0a, 0x08,
    0x0c, 0x0c, 0x0f, 0x0c, 0x0e, 0x0d, 0x0a, 0x17, 0x0d, 0x10, 0x14, 0x0f,
    0x0b, 0x0e, 0x15, 0x0c, 0x14, 0x15, 0x15, 0x09, 0x0f, 0x08, 0x17, 0x11,
    0x08, 0x13, 0x08, 0x0a, 0x16, 0x0a, 0x0a, 0x0a, 0x0e, 0x12, 0x0f, 0x15,
    0x0f, 0x11, 0x12, 0x0e, 0x13, 0x15, 0x10, 0x0a, 0x0f, 0x08, 0x17, 0x10,
    0x12, 0x14, 0x16, 0x14, 0x0d, 0x13, 0x0a, 0x0d, 0x0e, 0x13, 0x0a, 0x17,
    0x0a, 0x17, 0x17, 0x12, 0x14, 0x10, 0x0a, 0x0c, 0x0a, 0x14, 0x12, 0x16,
    0x12, 0x0b, 0x08, 0x0a, 0x0b, 0x08, 0x12, 0x16, 0x14, 0x10, 0x12, 0x0a,
    0x0c, 0x14, 0x10, 0x13, 0x10, 0x12, 0x12, 0x13, 0x11, 0x12, 0x0e, 0x0d,
    0x0b, 0x10, 0x11, 0x0d, 0x0d, 0x0c, 0x0b, 0x08, 0x0f, 0x0b, 0x0a, 0x13,
    0x0b, 0x14, 0x11, 0x08, 0x0d, 0x0c, 0x0a, 0x11, 0x09, 0x13, 0x0d, 0x12,
    0x0d, 0x08, 0x0d, 0x16, 0x12, 0x14, 0x0c, 0x15, 0x0d, 0x16, 0x0a, 0x13,
    0x0a, 0x0e, 0x13, 0x12, 0x11, 0x15, 0x0d, 0x15, 0x12, 0x17, 0x16, 0x17,
    0x0c, 0x09, 0x11, 0x0d, 0x14, 0x16, 0x08, 0x09, 0x17, 0x0e, 0x08, 0x11,
    0x0a, 0x0d, 0x0f, 0x0f, 0x0b, 0x11, 0x0a, 0x0d, 0x08, 0x16, 0x17, 0x11,
    0x13, 0x0d, 0x0f, 0x0e, 0x0d, 0x0e, 0x0d, 0x11, 0x0f, 0x17, 0x16, 0x0b,
    0x16, 0x16, 0x0d, 0x15, 0x0c, 0x0d, 0x0e, 0x0f, 0x12, 0x15, 0x16, 0x15,
    0x0f, 0x09, 0x0b, 0x0f, 0x17, 0x0b, 0x09, 0x13, 0x11, 0x11, 0x09, 0x16,
    0x17, 0x0f, 0x0f, 0x0e, 0x0f, 0x0e, 0x12, 0x0d, 0x0d, 0x17, 0x0a, 0x11,
    0x0d, 0x11, 0x09, 0x17, 0x0e, 0x08, 0x15, 0x16, 0x09, 0x09, 0x0e, 0x09,
    0x0d, 0x0f, 0x15, 0x16, 0x09, 0x17, 0x14, 0x08, 0x0f, 0x0b, 0x0f, 0x16,
    0x12, 0x0a, 0x0b, 0x17, 0x09, 0x0d, 0x11, 0x0f, 0x17, 0x12, 0x0e, 0x0e,
    0x12, 0x0c, 0x0c, 0x14, 0x0e, 0x13, 0x16, 0x13, 0x0b, 0x13, 0x11, 0x0c,
    0x13, 0x0e, 0x0d, 0x0a, 0x11, 0x15, 0x08, 0x0b, 0x17, 0x0c, 0x0b, 0x09,
    0x12, 0x14, 0x10, 0x11, 0x0e, 0x17, 0x17, 0x08, 0x0b, 0x0c, 0x15, 0x11,
    0x17, 0x13, 0x0c, 0x0a, 0x0f, 0x16, 0x0e, 0x0a, 0x0c, 0x14, 0x0d, 0x16,
    0x11, 0x0d, 0x0a, 0x10, 0x12, 0x0d, 0x12, 0x0c, 0x09, 0x0a, 0x16, 0x0f,
    0x09, 0x16, 0x10, 0x0d, 0x0a, 0x0e, 0x17, 0x0a, 0x09, 0x0c, 0x0c, 0x10,
    0x0a, 0x13, 0x13, 0x0e, 0x0f, 0x08, 0x0d, 0x09, 0x0e, 0x0f, 0x12, 0x08,
    0x0f, 0x12, 0x12, 0x17, 0x12, 0x17, 0x08, 0x09, 0x0f, 0x12, 0x0a, 0x0b,
    0x17, 0x0f, 0x09, 0x0e, 0x14, 0x0f, 0x17, 0x16, 0x0e, 0x15, 0x0b, 0x13,
    0x13, 0x13, 0x0a, 0x14, 0x0f, 0x09, 0x08, 0x16, 0x14, 0x13, 0x16, 0x0f,
    0x12, 0x16, 0x10, 0x09, 0x11, 0x12, 0x0d, 0x11, 0x0a, 0x0f, 0x08, 0x16,
    0x17, 0x17, 0x15, 0x0d, 0x15, 0x08, 0x09, 0x10, 0x13, 0x0b, 0x0d, 0x0b,
    0x0d, 0x0d, 0x09, 0x0a, 0x08, 0x17, 0x11, 0x13, 0x16, 0x0a, 0x15, 0x10,
    0x14, 0x0b, 0x09, 0x17, 0x12, 0x09, 0x16, 0x12, 0x09, 0x13, 0x17, 0x16,
    0x13, 0x09, 0x0f, 0x0f, 0x0d, 0x14, 0x12, 0x13, 0x0a, 0x14, 0x15, 0x0a,
    0x14, 0x0e, 0x16, 0x13, 0x11, 0x14, 0x0b, 0x0e, 0x17, 0x0d, 0x0d, 0x12,
    0x0f, 0x0b, 0x0c, 0x10, 0x16, 0x0c, 0x0f, 0x12, 0x0e, 0x17, 0x0a, 0x13,
    0x13, 0x15, 0x0e, 0x15, 0x11, 0x0c, 0x08, 0x0e, 0x13, 0x17, 0x09, 0x0c,
    0x13, 0x0d, 0x12, 0x13, 0x12, 0x17, 0x0d, 0x0a, 0x0b, 0x12, 0x13, 0x0a,
    0x16, 0x0a, 0x14, 0x0c, 0x09, 0x17, 0x08, 0x15, 0x14, 0x0f, 0x12, 0x0e,
    0x13, 0x13, 0x14, 0x0f, 0x12, 0x15, 0x13, 0x0e, 0x0a, 0x0d, 0x09, 0x15,
    0x0d, 0x0f, 0x17, 0x11, 0x09, 0x13, 0x13, 0x08, 0x15, 0x10, 0x0d, 0x17,
    0x0f, 0x0e, 0x15, 0x0b, 0x15, 0x10, 0x11, 0x11, 0x0b, 0x0e, 0x08, 0x16,
    0x0c, 0x14, 0x0c, 0x0e, 0x0a, 0x0d, 0x0c, 0x0f, 0x14, 0x0c, 0x09, 0x16,
    0x17, 0x15, 0x16, 0x15, 0x0d, 0x0c, 0x15, 0x14, 0x12, 0x12, 0x08, 0x0f,
    0x0a, 0x12, 0x09, 0x0e, 0x08, 0x09, 0x0c, 0x0c, 0x15, 0x11, 0x13, 0x17,
    0x16, 0x08, 0x0f, 0x13, 0x0c, 0x11, 0x11, 0x0c, 0x0e, 0x10, 0x0a, 0x13,
    0x14, 0x17, 0x10, 0x0e, 0x12, 0x10, 0x16, 0x15, 0x0b, 0x17, 0x0b, 0x0b,
    0x08, 0x10, 0x0f, 0x16, 0x09, 0x0b, 0x16, 0x08, 0x0b, 0x0e, 0x14, 0x10,
    0x17, 0x0e, 0x14, 0x0d, 0x16, 0x16, 0x09, 0x13, 0x16, 0x11, 0x0a, 0x10,
    0x0a, 0x08, 0x0d, 0x0d, 0x17, 0x11, 0x10, 0x08, 0x0a, 0x08, 0x17, 0x0c,
    0x0c, 0x15, 0x0d, 0x0f, 0x0b, 0x09, 0x17, 0x0a, 0x0f, 0x14, 0x10, 0x0e,
    0x09, 0x15, 0x08, 0x0d, 0x17, 0x08, 0x0f, 0x0f, 0x14, 0x08, 0x15, 0x0f,
    0x11, 0x08, 0x08, 0x14, 0x0c, 0x0a, 0x0a, 0x11, 0x11, 0x15, 0x15, 0x12,
    0x09, 0x0a, 0x16, 0x0e, 0x0e, 0x0e, 0x17, 0x0f, 0x0b, 0x17, 0x14, 0x0a,
    0x08, 0x0c, 0x11, 0x14, 0x0c, 0x0f, 0x0c, 0x16, 0x0f, 0x0d, 0x13, 0x14,
    0x0f, 0x15, 0x0d, 0x09, 0x13, 0x0a, 0x14, 0x14, 0x0d, 0x12, 0x0a, 0x13,
    0x08, 0x09, 0x0b, 0x0c, 0x09, 0x08, 0x0f, 0x09, 0x0c, 0x09, 0x16, 0x11,
    0x10, 0x0a, 0x10, 0x08, 0x10, 0x0b, 0x15, 0x17, 0x09, 0x0a, 0x09, 0x15,
    0x0d, 0x15, 0x11, 0x12, 0x0f, 0x14, 0x0d, 0x10, 0x16, 0x11, 0x14, 0x08,
    0x11, 0x0b, 0x09, 0x16, 0x0c, 0x08, 0x10, 0x15, 0x0b, 0x08, 0x16, 0x13,
    0x0c, 0x13, 0x13, 0x0e, 0x15, 0x14, 0x0b, 0x0b, 0x11, 0x15, 0x15, 0x08,
    0x11, 0x0b, 0x11, 0x10, 0x14, 0x0d, 0x10, 0x0e, 0x11, 0x12, 0x0c, 0x16,
    0x12, 0x14, 0x13, 0x15, 0x15, 0x12, 0x10, 0x0a, 0x0d, 0x0b, 0x11, 0x0b,
    0x08, 0x14, 0x0e, 0x11, 0x12, 0x0c, 0x12, 0x0c, 0x10, 0x0b, 0x14, 0x0d,
    0x10, 0x0c, 0x13, 0x0a, 0x16, 0x17, 0x08, 0x11, 0x14, 0x14, 0x0e, 0x11,
    0x0e, 0x16, 0x14, 0x14, 0x0a, 0x0d, 0x08, 0x0a, 0x0a, 0x0e, 0x14, 0x14,
    0x13, 0x0e, 0x08, 0x0b, 0x11, 0x14, 0x10, 0x0a, 0x09, 0x0c, 0x0d, 0x08,
    0x0b, 0x0d, 0x11, 0x08, 0x0a, 0x17, 0x12, 0x10, 0x16, 0x0e, 0x0d, 0x08,
    0x13, 0x0d, 0x0b, 0x15, 0x14, 0x17, 0x12, 0x0f, 0x0e, 0x12, 0x13, 0x17,
    0x0f, 0x0c, 0x0a, 0x10, 0x10, 0x0f, 0x10, 0x14, 0x15, 0x0a, 0x14, 0x17,
    0x09, 0x0e, 0x10, 0x08, 0x15, 0x15, 0x09, 0x10, 0x0a, 0x0c, 0x0e, 0x16,
    0x0c, 0x09, 0x0e, 0x12, 0x13, 0x09, 0x12, 0x0a, 0x0e, 0x15, 0x13, 0x16,
    0x0d, 0x0c, 0x12, 0x0a, 0x0e, 0x0f, 0x0a, 0x10, 0x15, 0x12, 0x10, 0x12,
    0x10, 0x12, 0x0b, 0x12, 0x16, 0x12, 0x11, 0x0b, 0x13, 0x17, 0x15, 0x0e,
    0x09, 0x10, 0x11, 0x0f, 0x0d, 0x0c, 0x0d, 0x12, 0x10, 0x08, 0x15, 0x17,
    0x0f, 0x17, 0x0f, 0x0c, 0x12, 0x08, 0x17, 0x0a, 0x12, 0x0a, 0x14, 0x11,
    0x17, 0x15, 0x08, 0x11, 0x15, 0x17, 0x13, 0x0f, 0x0a, 0x10, 0x08, 0x17,
    0x17, 0x14, 0x10, 0x0c, 0x0f, 0x10, 0x13, 0x11, 0x09, 0x11, 0x0a, 0x16,
    0x15, 0x0c, 0x0d, 0x09, 0x0c, 0x12, 0x14, 0x0c, 0x0f, 0x15, 0x15, 0x0d,
    0x14, 0x11, 0x14, 0x17, 0x0a, 0x15, 0x16, 0x09, 0x12, 0x0f, 0x0e, 0x09,
    0x17, 0x0a, 0x13, 0x08, 0x14, 0x15, 0x17, 0x12, 0x0a, 0x0c, 0x14, 0x0f,
    0x17, 0x11, 0x13, 0x0f, 0x0e, 0x11, 0x14, 0x0a, 0x0a, 0x10, 0x09, 0x0d,
    0x0d, 0x08, 0x0f, 0x17, 0x0f, 0x16, 0x09, 0x0e, 0x08, 0x14, 0x0e, 0x15,
    0x12, 0x0d, 0x10, 0x14, 0x12, 0x0c, 0x0b, 0x11, 0x15, 0x16, 0x08, 0x0b,
    0x0f, 0x15, 0x0e, 0x12, 0x0d, 0x0f, 0x17, 0x13, 0x10, 0x0f, 0x13, 0x17,
    0x0d, 0x14, 0x0e, 0x0e, 0x11, 0x15, 0x0b, 0x0b, 0x0b, 0x13, 0x17, 0x15,
    0x08, 0x0b, 0x0e, 0x15, 0x09, 0x0f, 0x08, 0x11, 0x0c, 0x0e, 0x0b, 0x12,
    0x16, 0x0b, 0x0e, 0x0f, 0x12, 0x09, 0x0e, 0x08, 0x16, 0x15, 0x0e, 0x10,
    0x12, 0x12, 0x13, 0x15, 0x0e, 0x13, 0x13, 0x0e, 0x17, 0x0a, 0x0b, 0x09,
    0x12, 0x0c, 0x12, 0x16, 0x13, 0x16, 0x11, 0x11, 0x0a, 0x17, 0x08, 0x15,
    0x09, 0x0f, 0x15, 0x08, 0x0d, 0x0c, 0x10, 0x17, 0x16, 0x0c, 0x15, 0x0d,
    0x08, 0x11, 0x13, 0x08, 0x13, 0x17, 0x09, 0x0d, 0x0c, 0x13, 0x0c, 0x17,
    0x12, 0x15, 0x10, 0x14, 0x15, 0x11, 0x12, 0x17, 0x09, 0x0f, 0x17, 0x0e,
    0x13, 0x10, 0x0e, 0x12, 0x15, 0x0c, 0x08, 0x16, 0x15, 0x14, 0x16, 0x11,
    0x13, 0x17, 0x16, 0x17, 0x13, 0x0b, 0x16, 0x0d, 0x09, 0x0f, 0x0a, 0x16,
    0x09, 0x14, 0x16, 0x0a, 0x0b, 0x15, 0x10, 0x17, 0x0e, 0x16, 0x12, 0x0b,
    0x0a, 0x12, 0x09, 0x08, 0x0e, 0x08, 0x11, 0x0a, 0x17, 0x0f, 0x0a, 0x12,
    0x13, 0x09, 0x08, 0x14, 0x10, 0x0a, 0x13, 0x11, 0x16, 0x11, 0x14, 0x0a,
    0x0f, 0x0c, 0x0a, 0x15, 0x0b, 0x15, 0x09, 0x0e, 0x10, 0x0a, 0x0e, 0x16,
    0x0a, 0x17, 0x09, 0x0a, 0x0f, 0x0b, 0x14, 0x0a, 0x0c, 0x15, 0x17, 0x15,
    0x17, 0x13, 0x0f, 0x16, 0x0d, 0x0b, 0x09, 0x14, 0x10, 0x0c, 0x11, 0x14,
    0x14, 0x10, 0x13, 0x09, 0x14, 0x14, 0x16, 0x0c, 0x09, 0x10, 0x09, 0x0b,
    0x0b, 0x0b, 0x15, 0x09, 0x14, 0x0e, 0x09, 0x0b, 0x08, 0x0c, 0x0b, 0x16,
    0x0c, 0x0d, 0x09, 0x09, 0x0e, 0x0a, 0x16, 0x0b, 0x12, 0x11, 0x0d, 0x0e,
    0x0e, 0x0b, 0x13, 0x0f, 0x14, 0x14, 0x12, 0x17, 0x17, 0x10, 0x09, 0x13,
    0x16, 0x0a, 0x17, 0x16, 0x0f, 0x0a, 0x15, 0x14, 0x0f, 0x16, 0x15, 0x16,
    0x08, 0x14, 0x09, 0x12, 0x0d, 0x0f, 0x09, 0x14, 0x12, 0x14, 0x0b, 0x0f,
    0x10, 0x16, 0x0e, 0x10, 0x0e, 0x10, 0x0c, 0x0d, 0x12, 0x0c, 0x0b, 0x0a,
    0x0e, 0x08, 0x17, 0x16, 0x16, 0x15, 0x15, 0x17, 0x11, 0x16, 0x12, 0x16,
    0x0e, 0x13, 0x12, 0x09, 0x10, 0x16, 0x10, 0x09, 0x15, 0x17, 0x12, 0x0c,
    0x0f, 0x16, 0x11, 0x0a, 0x0a, 0x15, 0x0c, 0x11, 0x15, 0x0c, 0x10, 0x14,
    0x09, 0x0d, 0x14, 0x12, 0x0c, 0x0e, 0x10, 0x12, 0x0a, 0x0b, 0x13, 0x13,
    0x0a, 0x0c, 0x14, 0x08, 0x0b, 0x0e, 0x0d, 0x12, 0x0d, 0x16, 0x14, 0x0f,
    0x14, 0x09, 0x09, 0x11, 0x0d, 0x12, 0x0e, 0x0f, 0x17, 0x0a, 0x09, 0x0c,
    0x11, 0x12, 0x17, 0x14, 0x15, 0x13, 0x0f, 0x08, 0x17, 0x0c, 0x08, 0x0a,
    0x12, 0x0e, 0x15, 0x17, 0x0c, 0x11, 0x0f, 0x09, 0x13, 0x11, 0x13, 0x09,
    0x0b, 0x09, 0x10, 0x0b, 0x0c, 0x11, 0x0f, 0x16, 0x0b, 0x0f, 0x13, 0x09,
    0x0a, 0x0a, 0x0a, 0x09, 0x0e, 0x0b, 0x0c, 0x09, 0x11, 0x09, 0x09, 0x16,
    0x12, 0x10, 0x17, 0x0e, 0x09, 0x12, 0x0f, 0x0d, 0x14, 0x17, 0x10, 0x09,
    0x11, 0x08, 0x17, 0x15, 0x0f, 0x12, 0x16, 0x11, 0x15, 0x09, 0x13, 0x0c,
    0x0c, 0x17, 0x0d, 0x15, 0x08, 0x0e, 0x13, 0x13, 0x17, 0x13, 0x09, 0x08,
    0x0d, 0x11, 0x0e, 0x0a, 0x11, 0x16, 0x0b, 0x0a, 0x16, 0x0a, 0x17, 0x0d,
    0x15, 0x16, 0x17, 0x12, 0x17, 0x12, 0x17, 0x0c, 0x11, 0x0c, 0x09, 0x11,
    0x12, 0x15, 0x0d, 0x12, 0x10, 0x0e, 0x12, 0x16, 0x17, 0x08, 0x08, 0x10,
    0x17, 0x0b, 0x13, 0x15, 0x0e, 0x13, 0x0b, 0x0c, 0x11, 0x0a, 0x16, 0x11,
    0x15, 0x16, 0x16, 0x0f, 0x0a, 0x08, 0x09, 0x15, 0x15, 0x0e, 0x0f, 0x0e,
    0x08, 0x16, 0x13, 0x0b, 0x16, 0x14, 0x08, 0x13, 0x0a, 0x10, 0x0a, 0x17,
    0x12, 0x0f, 0x14, 0x15, 0x14, 0x09, 0x08, 0x0d, 0x0a, 0x09, 0x0d, 0x16,
    0x0d, 0x11, 0x0c, 0x14, 0x13, 0x0b, 0x09, 0x14, 0x09, 0x14, 0x17, 0x08,
    0x11, 0x17, 0x13, 0x14, 0x0f, 0x15, 0x14, 0x0a, 0x0d, 0x10, 0x08, 0x09,
    0x12, 0x09, 0x0f, 0x14, 0x0a, 0x14, 0x12, 0x0f, 0x0d, 0x16, 0x0c, 0x09,
    0x0a, 0x0d, 0x15, 0x0c, 0x0a, 0x15, 0x0c, 0x13, 0x14, 0x08, 0x0f, 0x0c,
    0x16, 0x0b, 0x0f, 0x0b, 0x14, 0x0f, 0x0d, 0x0e, 0x11, 0x14, 0x0a, 0x13,
    0x11, 0x15, 0x0b, 0x17, 0x14, 0x0f, 0x09, 0x16, 0x15, 0x16, 0x0b, 0x17,
    0x14, 0x10, 0x13, 0x11, 0x11, 0x0b, 0x15, 0x0f, 0x0f, 0x0d, 0x13, 0x0b,
    0x15, 0x08, 0x11, 0x0e, 0x15, 0x14, 0x09, 0x0f, 0x11, 0x0d, 0x0f, 0x0d,
    0x15, 0x10, 0x0c, 0x12, 0x0f, 0x10, 0x12, 0x0b, 0x09, 0x0e, 0x14, 0x12,
    0x11, 0x12, 0x09, 0x08, 0x17, 0x15, 0x0c, 0x14, 0x15, 0x16, 0x0b, 0x13,
    0x12, 0x0d, 0x0a, 0x0c, 0x12, 0x11, 0x12, 0x0f, 0x0a, 0x17, 0x0a, 0x11,
    0x10, 0x14, 0x15, 0x11, 0x0a, 0x11, 0x0b, 0x14, 0x0b, 0x0d, 0x15, 0x0b,
    0x0a, 0x09, 0x08, 0x08, 0x17, 0x0b, 0x13, 0x12, 0x10, 0x16, 0x17, 0x0b,
    0x10, 0x12, 0x12, 0x12, 0x11, 0x14, 0x0c, 0x09, 0x11, 0x09, 0x12, 0x14,
    0x13, 0x16, 0x10, 0x17, 0x0b, 0x0d, 0x0b, 0x0d, 0x0f, 0x0b, 0x0d, 0x0f,
    0x0f, 0x09, 0x0a, 0x08, 0x08, 0x09, 0x0b, 0x10, 0x13, 0x16, 0x0b, 0x0d,
    0x13, 0x10, 0x0f, 0x0c, 0x12, 0x09, 0x09, 0x0d, 0x17, 0x12, 0x0c, 0x0b,
    0x17, 0x0f, 0x10, 0x0f, 0x13, 0x16, 0x16, 0x0b, 0x08, 0x08, 0x0b, 0x08,
    0x0a, 0x0f, 0x11, 0x16, 0x0d, 0x15, 0x0b, 0x09, 0x0d, 0x12, 0x0e, 0x17,
    0x14, 0x0f, 0x0d, 0x14, 0x09, 0x12, 0x17, 0x09, 0x09, 0x10, 0x10, 0x15,
    0x0f, 0x0f, 0x08, 0x10, 0x10, 0x0c, 0x11, 0x13, 0x13, 0x0b, 0x11, 0x09,
    0x08, 0x15, 0x0a, 0x0e, 0x0f, 0x11, 0x0e, 0x0c, 0x08, 0x13, 0x08, 0x0a,
    0x0e, 0x08, 0x0b, 0x0f, 0x10, 0x14, 0x0d, 0x08, 0x0c, 0x0d, 0x10, 0x15,
    0x14, 0x11, 0x14, 0x0d, 0x0d, 0x09, 0x0d, 0x12, 0x0f, 0x15, 0x0f, 0x09,
    0x17, 0x17, 0x0e, 0x0c, 0x09, 0x16, 0x11, 0x08, 0x10, 0x0d, 0x0f, 0x13,
    0x0f, 0x0b, 0x17, 0x0d, 0x17, 0x0c, 0x11, 0x13, 0x16, 0x0d, 0x08, 0x0b,
    0x0f, 0x0d, 0x16, 0x16, 0x0b, 0x0d, 0x17, 0x0b, 0x0d, 0x0e, 0x0f, 0x0e,
    0x0c, 0x08, 0x0f, 0x15, 0x0e, 0x17, 0x10, 0x15, 0x0a, 0x0f, 0x0b, 0x09,
    0x14, 0x14, 0x14, 0x12, 0x0a, 0x15, 0x16, 0x11, 0x0a, 0x14, 0x0f, 0x0e,
    0x0a, 0x0f, 0x11, 0x0f, 0x15, 0x08, 0x15, 0x0a, 0x09, 0x0d, 0x17, 0x0f,
    0x0c, 0x10, 0x0d, 0x0e, 0x08, 0x10, 0x10, 0x14, 0x0d, 0x0d, 0x0f, 0x0f,
    0x0a, 0x0d, 0x09, 0x0d, 0x0a, 0x10, 0x13, 0x0c, 0x17, 0x0c, 0x13, 0x15,
    0x0d, 0x11, 0x08, 0x0f, 0x16, 0x08, 0x17, 0x0a, 0x10, 0x0c, 0x11, 0x10,
    0x15, 0x09, 0x0d, 0x0b, 0x0f, 0x14, 0x12, 0x11, 0x0a, 0x14, 0x16, 0x0c,
    0x0c, 0x11, 0x11, 0x0c, 0x16, 0x0c, 0x0a, 0x0c, 0x15, 0x0a, 0x13, 0x13,
    0x0b, 0x12, 0x16, 0x13, 0x17, 0x10, 0x0c, 0x15, 0x11, 0x11, 0x08, 0x08,
    0x0e, 0x13, 0x12, 0x10, 0x0f, 0x10, 0x15, 0x14, 0x0a, 0x0e, 0x08, 0x09,
    0x12, 0x0b, 0x0d, 0x10, 0x0e, 0x09, 0x0c, 0x11, 0x14, 0x0b, 0x0d, 0x14,
    0x13, 0x11, 0x11, 0x0d, 0x0b, 0x11, 0x0e, 0x12, 0x0d, 0x08, 0x0a, 0x14,
    0x11, 0x08, 0x10, 0x13, 0x0e, 0x11, 0x14, 0x09, 0x15, 0x0a, 0x12, 0x0b,
    0x0b, 0x16, 0x15, 0x17, 0x09, 0x0a, 0x14, 0x15, 0x14, 0x0d, 0x0a, 0x08,
    0x17, 0x10, 0x12, 0x0c, 0x10, 0x15, 0x09, 0x09, 0x15, 0x11, 0x15, 0x0c,
    0x0b, 0x11, 0x0d, 0x08, 0x14, 0x17, 0x0c, 0x17, 0x16, 0x09, 0x17, 0x08,
    0x0c, 0x13, 0x15, 0x09, 0x09, 0x17, 0x0a, 0x08, 0x10, 0x15, 0x0d, 0x08,
    0x12, 0x0e, 0x0a, 0x10, 0x08, 0x17, 0x14, 0x0b, 0x11, 0x0a, 0x0c, 0x0d,
    0x0a, 0x11, 0x0d, 0x08, 0x13, 0x0d, 0x09, 0x17, 0x09, 0x17, 0x09, 0x0a,
    0x17, 0x0b, 0x0b, 0x0f, 0x08, 0x10, 0x0f, 0x13, 0x17, 0x12, 0x0b, 0x17,
    0x11, 0x08, 0x0b, 0x0b, 0x0a, 0x10, 0x10, 0x0c, 0x09, 0x16, 0x0d, 0x14,
    0x09, 0x0e, 0x13, 0x0c, 0x17, 0x0c, 0x10, 0x08, 0x0b, 0x16, 0x15, 0x0f,
    0x0d, 0x11, 0x15, 0x13, 0x0f, 0x0d, 0x08, 0x10, 0x09, 0x14, 0x12, 0x0e,
    0x08, 0x10, 0x12, 0x16, 0x11, 0x15, 0x0f, 0x13, 0x0c, 0x0a, 0x17, 0x0b,
    0x0f, 0x10, 0x0b, 0x12, 0x0f, 0x08, 0x0a, 0x14, 0x12, 0x17, 0x0f, 0x09,
    0x0c, 0x0f, 0x11, 0x0e, 0x0c, 0x0c, 0x14, 0x0c, 0x15, 0x0e, 0x0b, 0x0e,
    0x0b, 0x12, 0x0a, 0x0f, 0x14, 0x0a, 0x13, 0x0c, 0x13, 0x16, 0x16, 0x0a,
    0x17, 0x09, 0x17, 0x11, 0x08, 0x0f, 0x12, 0x0c, 0x16, 0x0c, 0x12, 0x0b,
    0x11, 0x0f, 0x0f, 0x0e, 0x15, 0x12, 0x15, 0x09, 0x0c, 0x17, 0x11, 0x09,
    0x0a, 0x0c, 0x0d, 0x15, 0x0a, 0x0c, 0x08, 0x0a, 0x0d, 0x17, 0x13, 0x0d,
    0x0e, 0x0e, 0x12, 0x0d, 0x13, 0x0d, 0x10, 0x0c, 0x14, 0x17, 0x12, 0x12,
    0x12, 0x0f, 0x13, 0x16, 0x0f, 0x0c, 0x08, 0x11, 0x10, 0x0d, 0x0f, 0x13,
    0x12, 0x0f, 0x15, 0x08, 0x0e, 0x11, 0x0d, 0x15, 0x17, 0x08, 0x0a, 0x12,
    0x0d, 0x13, 0x17, 0x0a, 0x12, 0x11, 0x15, 0x0d, 0x09, 0x10, 0x0b, 0x11,
    0x15, 0x0b, 0x0a, 0x0e, 0x11, 0x11, 0x09, 0x0c, 0x09, 0x17, 0x0c, 0x0f,
    0x10, 0x11, 0x0d, 0x10, 0x12, 0x0f, 0x0b, 0x08, 0x0a, 0x0a, 0x0b, 0x15,
    0x14, 0x08, 0x0b, 0x15, 0x11, 0x0e, 0x0e, 0x0e, 0x12, 0x11, 0x14, 0x0c,
    0x0b, 0x16, 0x10, 0x0c, 0x15, 0x15, 0x14, 0x0e, 0x0f, 0x09, 0x16, 0x09,
    0x11, 0x0a, 0x09, 0x14, 0x0c, 0x0d, 0x12, 0x08, 0x0d, 0x15, 0x16, 0x16,
    0x0c, 0x0d, 0x0d, 0x17, 0x17, 0x0a, 0x0c, 0x0a, 0x08, 0x15, 0x0f, 0x16,
    0x12, 0x0c, 0x0c, 0x09, 0x0e, 0x0b, 0x0a, 0x08, 0x0d, 0x0c, 0x14, 0x12,
    0x11, 0x0e, 0x13, 0x16, 0x0c, 0x11, 0x15, 0x11, 0x16, 0x0a, 0x10, 0x15,
    0x0d, 0x14, 0x08, 0x0d, 0x11, 0x10, 0x0c, 0x0b, 0x14, 0x11, 0x0c, 0x0b,
    0x14, 0x0f, 0x0b, 0x0a, 0x13, 0x17, 0x15, 0x0c, 0x0e, 0x10, 0x0b, 0x13,
    0x09, 0x08, 0x0c, 0x08, 0x0b, 0x14, 0x16, 0x11, 0x11, 0x17, 0x17, 0x0b,
    0x0f, 0x0b, 0x0e, 0x0c, 0x14, 0x13, 0x0f, 0x11, 0x0a, 0x13, 0x14, 0x16,
    0x03, 0x00, 0x06, 0x02, 0x06, 0x02, 0x06, 0x00, 0x00, 0x05, 0x07, 0x05,
    0x01, 0x01, 0x06, 0x02, 0x04, 0x04, 0x03, 0x00, 0x05, 0x05, 0x06, 0x04,
    0x06, 0x00, 0x00, 0x07, 0x02, 0x05, 0x04, 0x06, 0x06, 0x02, 0x00, 0x05,
    0x05, 0x07, 0x05, 0x05, 0x04, 0x05, 0x03, 0x06, 0x06, 0x01, 0x00, 0x02,
    0x06, 0x04, 0x03, 0x04, 0x02, 0x01, 0x00, 0x01, 0x02, 0x01, 0x00, 0x04,
    0x07, 0x04, 0x03, 0x05, 0x07, 0x03, 0x03, 0x05, 0x03, 0x00, 0x02, 0x07,
    0x05, 0x06, 0x05, 0x04, 0x07, 0x06, 0x06, 0x06, 0x03, 0x01, 0x02, 0x05,
    0x03, 0x02, 0x06, 0x05, 0x04, 0x07, 0x01, 0x03, 0x04, 0x04, 0x00, 0x04,
    0x00, 0x04, 0x01, 0x03, 0x04, 0x04, 0x03, 0x02, 0x02, 0x01, 0x07, 0x02,
    0x07, 0x05, 0x00, 0x02, 0x07, 0x02, 0x00, 0x03, 0x05, 0x07, 0x00, 0x01,
    0x07, 0x02, 0x04, 0x04, 0x07, 0x05, 0x00, 0x07, 0x01, 0x02, 0x03, 0x06,
    0x06, 0x06, 0x01, 0x00, 0x07, 0x00, 0x03, 0x07, 0x06, 0x03, 0x02, 0x06,
    0x06, 0x03, 0x01, 0x04, 0x02, 0x02, 0x05, 0x02, 0x04, 0x02, 0x06, 0x03,
    0x00, 0x07, 0x03, 0x02, 0x01, 0x06, 0x01, 0x07, 0x05, 0x03, 0x00, 0x05,
    0x04, 0x03, 0x04, 0x03, 0x07, 0x07, 0x01, 0x05, 0x02, 0x03, 0x01, 0x05,
    0x05, 0x07, 0x00, 0x01, 0x02, 0x06, 0x05, 0x03, 0x05, 0x00, 0x05, 0x07,
    0x07, 0x06, 0x06, 0x04, 0x02, 0x07, 0x02, 0x06, 0x03, 0x06, 0x01, 0x03,
    0x06, 0x02, 0x01, 0x01, 0x06, 0x02, 0x06, 0x03, 0x02, 0x06, 0x05, 0x05,
    0x05, 0x02, 0x00, 0x03, 0x03, 0x05, 0x02, 0x02, 0x04, 0x01, 0x07, 0x06,
    0x01, 0x01, 0x04, 0x05, 0x00, 0x06, 0x00, 0x07, 0x01, 0x01, 0x00, 0x07,
    0x04, 0x07, 0x03, 0x07, 0x05, 0x00, 0x04, 0x03, 0x03, 0x04, 0x06, 0x07,
    0x01, 0x01, 0x02, 0x06, 0x03, 0x02, 0x05, 0x04, 0x04, 0x01, 0x01, 0x05,
    0x00, 0x02, 0x04, 0x01, 0x03, 0x04, 0x00, 0x07, 0x03, 0x03, 0x06, 0x01,
    0x04, 0x03, 0x05, 0x00, 0x07, 0x04, 0x00, 0x01, 0x05, 0x02, 0x07, 0x01,
    0x04, 0x04, 0x05, 0x01, 0x06, 0x07, 0x06, 0x06, 0x01, 0x02, 0x07, 0x05,
};

//*******************************************************************v**********
//
// The top right corner of the border.
//
//*****************************************************************************
static const uint8_t g_pui8TopRight[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    10, 0,
    26, 0,

    34,
    0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00,
    0x10, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x12, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x15, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x17, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x44, 0x00, 0x00,
    0x46, 0x00, 0x00,
    0x48, 0x00, 0x00,
    0x4e, 0x00, 0x00,
    0x54, 0x00, 0x00,
    0x56, 0x00, 0x00,
    0x58, 0x00, 0x00,
    0x5a, 0x00, 0x00,
    0x5e, 0x00, 0x00,

    0x1d, 0x21, 0x1d, 0x1c, 0x1a, 0x1e, 0x14, 0x00, 0x00, 0x00, 0x13, 0x16,
    0x18, 0x18, 0x0c, 0x11, 0x1d, 0x20, 0x14, 0x00, 0x13, 0x0b, 0x18, 0x10,
    0x18, 0x14, 0x11, 0x11, 0x04, 0x00, 0x0a, 0x0c, 0x0e, 0x0a, 0x0e, 0x0a,
    0x14, 0x11, 0x07, 0x01, 0x15, 0x0a, 0x18, 0x18, 0x0a, 0x12, 0x15, 0x0e,
    0x0f, 0x06, 0x0c, 0x0a, 0x0a, 0x16, 0x0c, 0x0c, 0x0e, 0x0c, 0x14, 0x02,
    0x12, 0x15, 0x16, 0x10, 0x0b, 0x0d, 0x0c, 0x15, 0x19, 0x04, 0x0d, 0x16,
    0x15, 0x0a, 0x0a, 0x15, 0x19, 0x0b, 0x0c, 0x08, 0x16, 0x0f, 0x11, 0x19,
    0x0d, 0x12, 0x0d, 0x0f, 0x13, 0x08, 0x15, 0x0c, 0x0e, 0x15, 0x19, 0x0c,
    0x13, 0x18, 0x15, 0x02, 0x19, 0x13, 0x10, 0x0e, 0x15, 0x12, 0x0c, 0x11,
    0x13, 0x07, 0x19, 0x0e, 0x12, 0x17, 0x14, 0x0a, 0x13, 0x0b, 0x17, 0x06,
    0x0a, 0x13, 0x16, 0x10, 0x0c, 0x13, 0x17, 0x0f, 0x0a, 0x07, 0x16, 0x0e,
    0x0f, 0x18, 0x11, 0x0e, 0x10, 0x12, 0x0c, 0x09, 0x14, 0x13, 0x0c, 0x13,
    0x0d, 0x0e, 0x0b, 0x0f, 0x0e, 0x05, 0x17, 0x10, 0x16, 0x12, 0x0f, 0x14,
    0x19, 0x10, 0x0c, 0x06, 0x0b, 0x15, 0x0c, 0x13, 0x17, 0x12, 0x12, 0x0a,
    0x11, 0x07, 0x16, 0x0c, 0x0e, 0x16, 0x0d, 0x0f, 0x0f, 0x0c, 0x13, 0x02,
    0x14, 0x0b, 0x12, 0x0f, 0x0e, 0x0b, 0x11, 0x0f, 0x19, 0x07, 0x0e, 0x10,
    0x16, 0x0f, 0x0f, 0x17, 0x12, 0x0e, 0x0b, 0x07, 0x14, 0x13, 0x0d, 0x0b,
    0x0b, 0x10, 0x16, 0x0d, 0x11, 0x02, 0x09, 0x0a, 0x14, 0x11, 0x12, 0x12,
    0x14, 0x0b, 0x18, 0x04, 0x01, 0x03, 0x06, 0x11, 0x19, 0x18, 0x10, 0x14,
    0x17, 0x08, 0x00, 0x00, 0x14, 0x22, 0x0c, 0x15, 0x15, 0x17, 0x0e, 0x02,
    0x00, 0x00, 0x00, 0x1b, 0x13, 0x14, 0x11, 0x0a, 0x15, 0x04, 0x00, 0x00,
    0x00, 0x12, 0x1f, 0x11, 0x0c, 0x0a, 0x13, 0x04,
};

//*****************************************************************************
//
// The left side of the border.
//
//*****************************************************************************
static const uint8_t g_pui8Left[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    6, 0,
    204, 0,

    39,
    0x10, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x12, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x15, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x17, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x40, 0x00, 0x00,
    0x42, 0x00, 0x00,
    0x44, 0x00, 0x00,
    0x46, 0x00, 0x00,
    0x48, 0x00, 0x00,
    0x4a, 0x00, 0x00,
    0x4c, 0x00, 0x00,
    0x4e, 0x00, 0x00,
    0x50, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x54, 0x00, 0x00,
    0x56, 0x00, 0x00,
    0x58, 0x00, 0x00,
    0x5a, 0x00, 0x00,
    0x5c, 0x00, 0x00,
    0x5e, 0x00, 0x00,

    0x24, 0x15, 0x12, 0x0f, 0x16, 0x04, 0x25, 0x09, 0x0e, 0x13, 0x0c, 0x03,
    0x1d, 0x15, 0x0e, 0x0a, 0x17, 0x00, 0x22, 0x0c, 0x0f, 0x0a, 0x0d, 0x06,
    0x27, 0x14, 0x09, 0x0e, 0x09, 0x03, 0x20, 0x16, 0x0b, 0x0a, 0x0e, 0x01,
    0x23, 0x0c, 0x0c, 0x0a, 0x17, 0x04, 0x21, 0x0d, 0x0e, 0x08, 0x0f, 0x03,
    0x19, 0x0a, 0x13, 0x11, 0x0d, 0x00, 0x1d, 0x0c, 0x15, 0x0e, 0x12, 0x07,
    0x25, 0x0a, 0x15, 0x09, 0x0c, 0x02, 0x1c, 0x08, 0x10, 0x10, 0x0b, 0x04,
    0x19, 0x15, 0x15, 0x10, 0x16, 0x02, 0x27, 0x17, 0x0e, 0x12, 0x10, 0x05,
    0x23, 0x16, 0x17, 0x10, 0x0c, 0x05, 0x1f, 0x0a, 0x14, 0x0d, 0x0b, 0x00,
    0x21, 0x0f, 0x09, 0x0a, 0x08, 0x02, 0x22, 0x09, 0x0a, 0x0f, 0x12, 0x00,
    0x24, 0x11, 0x08, 0x0a, 0x0b, 0x04, 0x26, 0x16, 0x0e, 0x16, 0x0f, 0x05,
    0x20, 0x16, 0x15, 0x0c, 0x0b, 0x00, 0x1d, 0x14, 0x11, 0x0f, 0x16, 0x04,
    0x25, 0x10, 0x13, 0x17, 0x08, 0x03, 0x18, 0x14, 0x17, 0x08, 0x17, 0x01,
    0x21, 0x16, 0x0a, 0x17, 0x14, 0x04, 0x22, 0x0d, 0x0f, 0x10, 0x12, 0x05,
    0x22, 0x08, 0x0f, 0x0c, 0x10, 0x03, 0x26, 0x0d, 0x17, 0x11, 0x0d, 0x07,
    0x27, 0x0d, 0x14, 0x17, 0x0e, 0x05, 0x1a, 0x17, 0x11, 0x0c, 0x16, 0x03,
    0x26, 0x11, 0x14, 0x0d, 0x0a, 0x03, 0x18, 0x14, 0x0e, 0x0f, 0x08, 0x07,
    0x26, 0x16, 0x0b, 0x16, 0x10, 0x04, 0x26, 0x10, 0x16, 0x12, 0x10, 0x02,
    0x1e, 0x13, 0x0c, 0x17, 0x17, 0x01, 0x1e, 0x16, 0x14, 0x0a, 0x0b, 0x07,
    0x21, 0x0b, 0x13, 0x17, 0x13, 0x06, 0x26, 0x12, 0x13, 0x0a, 0x10, 0x02,
    0x22, 0x0e, 0x15, 0x11, 0x08, 0x02, 0x26, 0x0e, 0x08, 0x0a, 0x0e, 0x00,
    0x1c, 0x15, 0x16, 0x09, 0x08, 0x01, 0x18, 0x11, 0x0d, 0x13, 0x10, 0x00,
    0x20, 0x0f, 0x13, 0x0b, 0x11, 0x02, 0x1f, 0x0c, 0x12, 0x0c, 0x15, 0x05,
    0x22, 0x13, 0x0a, 0x12, 0x16, 0x04, 0x23, 0x0a, 0x0e, 0x11, 0x0c, 0x03,
    0x24, 0x0c, 0x08, 0x09, 0x17, 0x04, 0x1b, 0x0f, 0x08, 0x17, 0x13, 0x05,
    0x1b, 0x0b, 0x16, 0x16, 0x10, 0x06, 0x22, 0x0a, 0x10, 0x14, 0x15, 0x03,
    0x1d, 0x10, 0x11, 0x14, 0x0a, 0x06, 0x1b, 0x16, 0x09, 0x0b, 0x08, 0x00,
    0x25, 0x0c, 0x11, 0x15, 0x0b, 0x02, 0x20, 0x0f, 0x10, 0x0e, 0x0d, 0x00,
    0x1a, 0x17, 0x0a, 0x13, 0x14, 0x00, 0x19, 0x0a, 0x11, 0x12, 0x16, 0x05,
    0x20, 0x0a, 0x12, 0x11, 0x0e, 0x05, 0x23, 0x0b, 0x17, 0x0c, 0x09, 0x01,
    0x21, 0x11, 0x12, 0x09, 0x08, 0x00, 0x1a, 0x0b, 0x08, 0x0c, 0x16, 0x06,
    0x1d, 0x17, 0x16, 0x16, 0x12, 0x06, 0x22, 0x0a, 0x17, 0x0c, 0x14, 0x02,
    0x18, 0x0f, 0x11, 0x08, 0x14, 0x05, 0x1b, 0x0e, 0x0c, 0x15, 0x10, 0x02,
    0x25, 0x12, 0x0f, 0x15, 0x17, 0x03, 0x22, 0x0c, 0x0d, 0x10, 0x0a, 0x00,
    0x1d, 0x14, 0x0a, 0x0c, 0x09, 0x07, 0x22, 0x0a, 0x0e, 0x0c, 0x0a, 0x01,
    0x26, 0x0d, 0x11, 0x0b, 0x0a, 0x00, 0x20, 0x08, 0x13, 0x17, 0x16, 0x05,
    0x1e, 0x10, 0x17, 0x13, 0x08, 0x00, 0x23, 0x0e, 0x16, 0x16, 0x13, 0x00,
    0x25, 0x0d, 0x0a, 0x0b, 0x11, 0x02, 0x1e, 0x10, 0x12, 0x08, 0x14, 0x06,
    0x19, 0x0c, 0x16, 0x15, 0x0c, 0x06, 0x20, 0x12, 0x0c, 0x0f, 0x0e, 0x02,
    0x21, 0x0a, 0x14, 0x10, 0x08, 0x03, 0x21, 0x15, 0x15, 0x14, 0x09, 0x03,
    0x19, 0x10, 0x17, 0x14, 0x10, 0x06, 0x21, 0x12, 0x08, 0x10, 0x0f, 0x02,
    0x1c, 0x08, 0x17, 0x11, 0x10, 0x02, 0x27, 0x0a, 0x0f, 0x13, 0x12, 0x04,
    0x1a, 0x0c, 0x0d, 0x17, 0x08, 0x03, 0x1e, 0x09, 0x17, 0x0e, 0x16, 0x03,
    0x1b, 0x0f, 0x09, 0x0b, 0x17, 0x04, 0x20, 0x0c, 0x11, 0x10, 0x15, 0x01,
    0x25, 0x15, 0x0c, 0x0d, 0x10, 0x07, 0x25, 0x12, 0x0a, 0x0b, 0x12, 0x01,
    0x21, 0x09, 0x0d, 0x11, 0x10, 0x01, 0x18, 0x13, 0x12, 0x09, 0x17, 0x05,
    0x23, 0x10, 0x17, 0x0d, 0x08, 0x06, 0x1f, 0x16, 0x12, 0x13, 0x0b, 0x01,
    0x22, 0x08, 0x15, 0x15, 0x0b, 0x04, 0x18, 0x15, 0x11, 0x0d, 0x0e, 0x01,
    0x20, 0x0f, 0x15, 0x0b, 0x11, 0x06, 0x26, 0x0c, 0x0d, 0x15, 0x11, 0x03,
    0x22, 0x08, 0x0c, 0x0c, 0x13, 0x03, 0x1f, 0x0e, 0x10, 0x0c, 0x0b, 0x06,
    0x24, 0x0b, 0x12, 0x0e, 0x10, 0x00, 0x20, 0x09, 0x10, 0x0e, 0x0d, 0x01,
    0x1c, 0x0b, 0x0e, 0x11, 0x09, 0x00, 0x27, 0x13, 0x09, 0x0c, 0x08, 0x06,
    0x23, 0x0f, 0x0b, 0x0c, 0x14, 0x03, 0x19, 0x11, 0x11, 0x13, 0x17, 0x01,
    0x24, 0x10, 0x0c, 0x0d, 0x17, 0x04, 0x20, 0x0b, 0x15, 0x17, 0x15, 0x07,
    0x27, 0x15, 0x12, 0x09, 0x09, 0x05, 0x26, 0x15, 0x0a, 0x0a, 0x09, 0x07,
    0x20, 0x0a, 0x10, 0x0a, 0x16, 0x04, 0x1d, 0x13, 0x09, 0x11, 0x08, 0x00,
    0x1b, 0x10, 0x0c, 0x08, 0x10, 0x00, 0x27, 0x0f, 0x17, 0x12, 0x11, 0x00,
    0x1c, 0x0f, 0x15, 0x0f, 0x11, 0x07, 0x1e, 0x0a, 0x09, 0x17, 0x0c, 0x07,
    0x1f, 0x12, 0x12, 0x10, 0x0c, 0x05, 0x21, 0x0f, 0x0c, 0x15, 0x10, 0x06,
    0x27, 0x10, 0x0c, 0x16, 0x0a, 0x06, 0x26, 0x0f, 0x0d, 0x14, 0x16, 0x07,
    0x23, 0x0d, 0x09, 0x15, 0x0c, 0x03, 0x25, 0x13, 0x09, 0x0f, 0x0c, 0x02,
    0x1b, 0x15, 0x14, 0x10, 0x12, 0x02, 0x1c, 0x12, 0x15, 0x11, 0x10, 0x07,
    0x1e, 0x0f, 0x0f, 0x14, 0x0b, 0x02, 0x23, 0x17, 0x13, 0x15, 0x14, 0x07,
    0x1c, 0x11, 0x13, 0x0d, 0x09, 0x00, 0x22, 0x0c, 0x15, 0x0e, 0x14, 0x04,
    0x24, 0x09, 0x0a, 0x11, 0x12, 0x05, 0x21, 0x09, 0x0a, 0x08, 0x15, 0x02,
    0x1e, 0x11, 0x0d, 0x09, 0x0e, 0x00, 0x19, 0x12, 0x13, 0x15, 0x17, 0x06,
    0x25, 0x12, 0x09, 0x13, 0x09, 0x07, 0x1b, 0x15, 0x17, 0x0d, 0x0f, 0x05,
    0x18, 0x08, 0x14, 0x0a, 0x09, 0x04, 0x20, 0x10, 0x0b, 0x15, 0x12, 0x05,
    0x27, 0x13, 0x0c, 0x12, 0x11, 0x02, 0x1f, 0x0f, 0x17, 0x10, 0x0a, 0x00,
    0x1f, 0x0d, 0x15, 0x0f, 0x13, 0x02, 0x19, 0x14, 0x0d, 0x15, 0x17, 0x03,
    0x1f, 0x0f, 0x16, 0x12, 0x0d, 0x04, 0x1c, 0x0c, 0x0c, 0x11, 0x17, 0x07,
    0x26, 0x0e, 0x0d, 0x15, 0x17, 0x03, 0x25, 0x0f, 0x15, 0x13, 0x16, 0x04,
    0x27, 0x08, 0x0d, 0x0c, 0x15, 0x02, 0x23, 0x0d, 0x14, 0x12, 0x08, 0x01,
    0x1b, 0x0d, 0x0e, 0x10, 0x17, 0x03, 0x1e, 0x15, 0x15, 0x13, 0x13, 0x06,
    0x1b, 0x11, 0x0c, 0x08, 0x0c, 0x01, 0x21, 0x0c, 0x0a, 0x17, 0x10, 0x00,
    0x1b, 0x0c, 0x0e, 0x08, 0x17, 0x03, 0x1a, 0x0a, 0x13, 0x11, 0x12, 0x05,
    0x27, 0x08, 0x10, 0x15, 0x14, 0x02, 0x22, 0x17, 0x15, 0x17, 0x17, 0x01,
    0x19, 0x11, 0x0e, 0x0c, 0x10, 0x07, 0x1d, 0x14, 0x0b, 0x13, 0x15, 0x01,
    0x1a, 0x17, 0x0d, 0x16, 0x11, 0x07, 0x21, 0x11, 0x08, 0x0a, 0x0e, 0x06,
    0x1e, 0x09, 0x14, 0x0c, 0x08, 0x06, 0x1e, 0x09, 0x0e, 0x15, 0x0e, 0x07,
    0x24, 0x14, 0x13, 0x08, 0x0f, 0x04, 0x1a, 0x12, 0x0f, 0x10, 0x10, 0x00,
    0x20, 0x09, 0x12, 0x11, 0x0b, 0x00, 0x1e, 0x12, 0x09, 0x0b, 0x17, 0x00,
    0x27, 0x0d, 0x0b, 0x0d, 0x0b, 0x05, 0x1c, 0x17, 0x0e, 0x17, 0x17, 0x07,
    0x1f, 0x0a, 0x10, 0x17, 0x12, 0x00, 0x18, 0x0b, 0x09, 0x12, 0x14, 0x02,
    0x23, 0x0a, 0x17, 0x14, 0x0d, 0x07, 0x26, 0x0d, 0x0d, 0x09, 0x13, 0x04,
    0x23, 0x17, 0x0f, 0x0a, 0x16, 0x03, 0x18, 0x0e, 0x11, 0x10, 0x0d, 0x02,
    0x20, 0x0e, 0x10, 0x12, 0x08, 0x02, 0x18, 0x13, 0x0f, 0x08, 0x10, 0x06,
    0x27, 0x0e, 0x0a, 0x0c, 0x0f, 0x06, 0x24, 0x0b, 0x14, 0x0c, 0x0d, 0x05,
    0x23, 0x0e, 0x09, 0x0d, 0x16, 0x03, 0x22, 0x0f, 0x15, 0x0a, 0x0a, 0x06,
    0x1e, 0x0a, 0x11, 0x15, 0x0b, 0x00, 0x23, 0x0a, 0x0f, 0x15, 0x0e, 0x07,
    0x23, 0x0b, 0x0b, 0x10, 0x0f, 0x04, 0x1b, 0x0a, 0x17, 0x0d, 0x0f, 0x07,
    0x24, 0x09, 0x0e, 0x12, 0x0b, 0x04, 0x20, 0x12, 0x14, 0x09, 0x10, 0x07,
    0x1a, 0x0b, 0x09, 0x12, 0x09, 0x04, 0x22, 0x14, 0x13, 0x15, 0x0d, 0x01,
    0x1e, 0x11, 0x0d, 0x0e, 0x17, 0x06, 0x1c, 0x13, 0x16, 0x13, 0x0e, 0x01,
    0x1c, 0x16, 0x15, 0x08, 0x17, 0x02, 0x27, 0x0a, 0x11, 0x09, 0x15, 0x05,
    0x21, 0x0f, 0x0f, 0x0d, 0x0d, 0x06, 0x1f, 0x14, 0x0e, 0x14, 0x0a, 0x02,
    0x21, 0x0f, 0x09, 0x10, 0x0a, 0x03, 0x22, 0x0f, 0x0d, 0x10, 0x0f, 0x02,
    0x25, 0x0f, 0x10, 0x0f, 0x11, 0x02, 0x1a, 0x0b, 0x15, 0x12, 0x10, 0x01,
    0x1f, 0x08, 0x16, 0x15, 0x15, 0x00, 0x1b, 0x0e, 0x10, 0x0d, 0x17, 0x05,
    0x24, 0x11, 0x0a, 0x0a, 0x0a, 0x05, 0x20, 0x17, 0x0a, 0x08, 0x0f, 0x05,
    0x1e, 0x11, 0x17, 0x0b, 0x0b, 0x04, 0x1d, 0x12, 0x10, 0x0c, 0x10, 0x02,
    0x1d, 0x14, 0x14, 0x15, 0x09, 0x05, 0x20, 0x16, 0x0d, 0x13, 0x08, 0x03,
    0x1d, 0x11, 0x0f, 0x0f, 0x11, 0x07, 0x1b, 0x17, 0x10, 0x0a, 0x0b, 0x05,
};

//*****************************************************************************
//
// The right side of the border.
//
//*****************************************************************************
static const uint8_t g_pui8Right[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    6, 0,
    204, 0,

    39,
    0x10, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x12, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x15, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x17, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x40, 0x00, 0x00,
    0x42, 0x00, 0x00,
    0x44, 0x00, 0x00,
    0x46, 0x00, 0x00,
    0x48, 0x00, 0x00,
    0x4a, 0x00, 0x00,
    0x4c, 0x00, 0x00,
    0x4e, 0x00, 0x00,
    0x50, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x54, 0x00, 0x00,
    0x56, 0x00, 0x00,
    0x58, 0x00, 0x00,
    0x5a, 0x00, 0x00,
    0x5c, 0x00, 0x00,
    0x5e, 0x00, 0x00,

    0x1f, 0x10, 0x15, 0x0b, 0x0f, 0x01, 0x20, 0x0e, 0x09, 0x16, 0x08, 0x07,
    0x23, 0x0a, 0x12, 0x0f, 0x08, 0x07, 0x20, 0x12, 0x11, 0x17, 0x12, 0x02,
    0x1d, 0x0d, 0x14, 0x0f, 0x0e, 0x02, 0x25, 0x16, 0x16, 0x12, 0x0a, 0x02,
    0x26, 0x12, 0x13, 0x08, 0x10, 0x06, 0x27, 0x0c, 0x17, 0x11, 0x13, 0x00,
    0x20, 0x0b, 0x12, 0x09, 0x0b, 0x02, 0x1d, 0x10, 0x13, 0x0a, 0x08, 0x00,
    0x1f, 0x15, 0x08, 0x0d, 0x10, 0x01, 0x22, 0x0f, 0x14, 0x0e, 0x0f, 0x02,
    0x1b, 0x0e, 0x11, 0x0b, 0x08, 0x02, 0x1b, 0x10, 0x11, 0x16, 0x11, 0x06,
    0x1b, 0x17, 0x0e, 0x17, 0x09, 0x03, 0x19, 0x11, 0x0c, 0x09, 0x16, 0x06,
    0x1b, 0x11, 0x0b, 0x08, 0x08, 0x05, 0x1e, 0x0c, 0x09, 0x08, 0x0f, 0x00,
    0x1d, 0x13, 0x12, 0x17, 0x11, 0x02, 0x24, 0x15, 0x0b, 0x0a, 0x14, 0x02,
    0x20, 0x15, 0x17, 0x14, 0x16, 0x07, 0x21, 0x0a, 0x10, 0x14, 0x0a, 0x04,
    0x1f, 0x10, 0x15, 0x11, 0x10, 0x02, 0x23, 0x16, 0x08, 0x0d, 0x15, 0x05,
    0x21, 0x11, 0x0f, 0x15, 0x13, 0x01, 0x1b, 0x0c, 0x08, 0x0a, 0x09, 0x07,
    0x18, 0x12, 0x08, 0x10, 0x0f, 0x01, 0x19, 0x17, 0x14, 0x17, 0x10, 0x02,
    0x1c, 0x0c, 0x0b, 0x0d, 0x11, 0x00, 0x27, 0x0b, 0x11, 0x0e, 0x08, 0x02,
    0x21, 0x0c, 0x11, 0x11, 0x0e, 0x05, 0x20, 0x0f, 0x0d, 0x11, 0x17, 0x06,
    0x24, 0x09, 0x14, 0x10, 0x08, 0x02, 0x25, 0x0d, 0x11, 0x08, 0x12, 0x01,
    0x19, 0x11, 0x0d, 0x12, 0x08, 0x03, 0x18, 0x11, 0x12, 0x12, 0x0b, 0x00,
    0x1d, 0x14, 0x10, 0x12, 0x0d, 0x04, 0x1f, 0x0a, 0x12, 0x0b, 0x13, 0x05,
    0x20, 0x11, 0x08, 0x0a, 0x11, 0x05, 0x1c, 0x12, 0x0d, 0x12, 0x0d, 0x02,
    0x19, 0x0d, 0x16, 0x14, 0x17, 0x01, 0x25, 0x0d, 0x16, 0x0e, 0x17, 0x01,
    0x27, 0x0f, 0x0e, 0x11, 0x12, 0x00, 0x1c, 0x0b, 0x12, 0x0d, 0x0d, 0x02,
    0x18, 0x12, 0x17, 0x0d, 0x0d, 0x02, 0x23, 0x0e, 0x12, 0x11, 0x0a, 0x05,
    0x24, 0x08, 0x17, 0x12, 0x0f, 0x07, 0x25, 0x0e, 0x0e, 0x0c, 0x08, 0x00,
    0x1d, 0x0c, 0x0c, 0x08, 0x12, 0x05, 0x1c, 0x13, 0x0c, 0x0b, 0x09, 0x04,
    0x20, 0x14, 0x08, 0x0b, 0x0e, 0x01, 0x25, 0x0a, 0x0c, 0x15, 0x14, 0x05,
    0x25, 0x12, 0x09, 0x0b, 0x16, 0x00, 0x1c, 0x0c, 0x0e, 0x11, 0x0c, 0x00,
    0x1b, 0x10, 0x14, 0x10, 0x13, 0x06, 0x1a, 0x0c, 0x11, 0x0a, 0x0f, 0x07,
    0x1e, 0x0d, 0x09, 0x12, 0x0b, 0x07, 0x1d, 0x08, 0x10, 0x0f, 0x0b, 0x03,
    0x20, 0x10, 0x13, 0x17, 0x09, 0x07, 0x18, 0x0d, 0x0f, 0x14, 0x15, 0x01,
    0x21, 0x17, 0x0f, 0x0b, 0x0a, 0x07, 0x1a, 0x10, 0x0c, 0x0c, 0x0a, 0x03,
    0x1a, 0x10, 0x10, 0x13, 0x17, 0x05, 0x1a, 0x10, 0x0c, 0x15, 0x0f, 0x02,
    0x24, 0x10, 0x13, 0x0b, 0x0c, 0x04, 0x1f, 0x16, 0x10, 0x16, 0x09, 0x05,
    0x25, 0x0c, 0x0c, 0x0a, 0x11, 0x03, 0x21, 0x13, 0x17, 0x0a, 0x0f, 0x07,
    0x25, 0x11, 0x0e, 0x0a, 0x0e, 0x07, 0x1f, 0x0b, 0x0e, 0x0b, 0x0f, 0x05,
    0x23, 0x16, 0x11, 0x0c, 0x15, 0x05, 0x18, 0x13, 0x08, 0x0c, 0x15, 0x04,
    0x23, 0x0f, 0x0d, 0x12, 0x11, 0x06, 0x21, 0x0f, 0x0e, 0x17, 0x11, 0x06,
    0x26, 0x09, 0x08, 0x0d, 0x0c, 0x04, 0x18, 0x08, 0x0e, 0x12, 0x0d, 0x02,
    0x1d, 0x0d, 0x17, 0x0e, 0x11, 0x06, 0x27, 0x0c, 0x0d, 0x0d, 0x17, 0x07,
    0x19, 0x10, 0x0e, 0x0f, 0x0f, 0x00, 0x1d, 0x0e, 0x09, 0x0d, 0x13, 0x03,
    0x26, 0x13, 0x0f, 0x0d, 0x0d, 0x06, 0x21, 0x13, 0x09, 0x11, 0x09, 0x05,
    0x1e, 0x09, 0x08, 0x14, 0x0e, 0x07, 0x23, 0x0f, 0x0f, 0x09, 0x17, 0x07,
    0x1a, 0x0c, 0x0d, 0x0b, 0x12, 0x00, 0x22, 0x10, 0x14, 0x09, 0x15, 0x01,
    0x26, 0x0f, 0x15, 0x08, 0x08, 0x07, 0x23, 0x0f, 0x08, 0x13, 0x0c, 0x03,
    0x22, 0x17, 0x16, 0x09, 0x09, 0x07, 0x19, 0x0b, 0x0b, 0x0e, 0x0f, 0x07,
    0x1f, 0x09, 0x0f, 0x0b, 0x0b, 0x02, 0x1e, 0x09, 0x14, 0x0c, 0x09, 0x06,
    0x1b, 0x14, 0x0d, 0x0c, 0x10, 0x04, 0x22, 0x0b, 0x10, 0x11, 0x0d, 0x05,
    0x1f, 0x0e, 0x15, 0x13, 0x14, 0x02, 0x21, 0x0b, 0x0d, 0x08, 0x0f, 0x04,
    0x1e, 0x15, 0x12, 0x0a, 0x09, 0x05, 0x18, 0x0d, 0x10, 0x0d, 0x11, 0x00,
    0x26, 0x0c, 0x0c, 0x0f, 0x15, 0x04, 0x19, 0x0d, 0x17, 0x17, 0x09, 0x05,
    0x1b, 0x12, 0x17, 0x11, 0x13, 0x03, 0x1a, 0x09, 0x0d, 0x14, 0x0c, 0x03,
    0x1f, 0x0c, 0x14, 0x17, 0x11, 0x03, 0x18, 0x10, 0x12, 0x0c, 0x08, 0x04,
    0x25, 0x0a, 0x15, 0x15, 0x09, 0x07, 0x20, 0x0d, 0x11, 0x10, 0x16, 0x02,
    0x18, 0x08, 0x0e, 0x0d, 0x14, 0x05, 0x24, 0x0c, 0x17, 0x11, 0x0c, 0x04,
    0x27, 0x0d, 0x09, 0x11, 0x11, 0x01, 0x19, 0x0f, 0x0c, 0x17, 0x0c, 0x03,
    0x26, 0x15, 0x13, 0x10, 0x0e, 0x05, 0x25, 0x0e, 0x12, 0x0c, 0x13, 0x03,
    0x27, 0x10, 0x14, 0x16, 0x09, 0x00, 0x1f, 0x08, 0x0d, 0x11, 0x12, 0x07,
    0x23, 0x14, 0x0f, 0x17, 0x14, 0x05, 0x1e, 0x13, 0x11, 0x09, 0x0c, 0x07,
    0x23, 0x09, 0x0d, 0x0e, 0x0e, 0x00, 0x26, 0x0d, 0x11, 0x12, 0x0c, 0x05,
    0x23, 0x13, 0x14, 0x08, 0x0c, 0x03, 0x18, 0x08, 0x0b, 0x0f, 0x08, 0x00,
    0x1b, 0x0e, 0x13, 0x14, 0x10, 0x07, 0x23, 0x0c, 0x09, 0x09, 0x13, 0x04,
    0x1b, 0x11, 0x15, 0x15, 0x0c, 0x01, 0x20, 0x17, 0x15, 0x0c, 0x08, 0x01,
    0x23, 0x08, 0x0a, 0x17, 0x10, 0x01, 0x27, 0x13, 0x11, 0x13, 0x0f, 0x00,
    0x22, 0x0b, 0x0d, 0x14, 0x0d, 0x00, 0x1c, 0x10, 0x12, 0x0a, 0x0d, 0x07,
    0x1c, 0x16, 0x16, 0x0a, 0x0a, 0x07, 0x1d, 0x16, 0x08, 0x10, 0x16, 0x04,
    0x23, 0x15, 0x0b, 0x0c, 0x10, 0x05, 0x1e, 0x0b, 0x16, 0x14, 0x08, 0x01,
    0x25, 0x0d, 0x14, 0x0f, 0x0f, 0x01, 0x1e, 0x14, 0x08, 0x0d, 0x17, 0x01,
    0x1c, 0x0c, 0x09, 0x0c, 0x15, 0x07, 0x25, 0x10, 0x15, 0x08, 0x15, 0x03,
    0x23, 0x0c, 0x12, 0x12, 0x08, 0x05, 0x26, 0x16, 0x08, 0x12, 0x0d, 0x03,
    0x25, 0x14, 0x0c, 0x15, 0x0a, 0x01, 0x18, 0x0f, 0x0f, 0x0a, 0x14, 0x02,
    0x1a, 0x11, 0x15, 0x17, 0x12, 0x05, 0x1e, 0x0d, 0x17, 0x08, 0x08, 0x00,
    0x23, 0x16, 0x16, 0x14, 0x11, 0x02, 0x1b, 0x0e, 0x08, 0x0f, 0x0b, 0x01,
    0x22, 0x0c, 0x12, 0x0a, 0x0e, 0x03, 0x1f, 0x11, 0x17, 0x0d, 0x10, 0x04,
    0x18, 0x17, 0x17, 0x17, 0x08, 0x07, 0x18, 0x14, 0x16, 0x16, 0x10, 0x03,
    0x1a, 0x13, 0x16, 0x0b, 0x0b, 0x01, 0x1e, 0x16, 0x0e, 0x08, 0x08, 0x06,
    0x1f, 0x10, 0x0e, 0x0e, 0x15, 0x07, 0x18, 0x15, 0x16, 0x08, 0x15, 0x07,
    0x27, 0x15, 0x13, 0x16, 0x13, 0x01, 0x1d, 0x16, 0x17, 0x0b, 0x09, 0x01,
    0x1e, 0x0f, 0x09, 0x14, 0x10, 0x01, 0x22, 0x17, 0x12, 0x09, 0x0e, 0x04,
    0x18, 0x0f, 0x0e, 0x17, 0x0f, 0x01, 0x26, 0x0f, 0x09, 0x12, 0x0e, 0x06,
    0x25, 0x13, 0x13, 0x15, 0x17, 0x06, 0x18, 0x0d, 0x0d, 0x0a, 0x0a, 0x06,
    0x1c, 0x15, 0x15, 0x17, 0x16, 0x02, 0x20, 0x17, 0x14, 0x16, 0x16, 0x01,
    0x1a, 0x15, 0x13, 0x0c, 0x0f, 0x00, 0x19, 0x0d, 0x15, 0x15, 0x0a, 0x06,
    0x22, 0x0b, 0x0b, 0x08, 0x0d, 0x03, 0x25, 0x12, 0x0b, 0x13, 0x12, 0x00,
    0x18, 0x0b, 0x08, 0x14, 0x09, 0x07, 0x18, 0x0c, 0x14, 0x13, 0x10, 0x02,
    0x25, 0x12, 0x11, 0x13, 0x10, 0x06, 0x20, 0x0b, 0x08, 0x14, 0x0b, 0x02,
    0x1a, 0x09, 0x08, 0x0d, 0x14, 0x05, 0x1f, 0x14, 0x16, 0x10, 0x11, 0x00,
    0x1f, 0x11, 0x0d, 0x0c, 0x0d, 0x06, 0x21, 0x0a, 0x10, 0x0a, 0x16, 0x00,
    0x27, 0x0e, 0x0b, 0x17, 0x0a, 0x03, 0x1d, 0x0c, 0x10, 0x0e, 0x12, 0x02,
    0x19, 0x09, 0x0a, 0x08, 0x12, 0x05, 0x19, 0x09, 0x0c, 0x0e, 0x0e, 0x04,
    0x1b, 0x17, 0x14, 0x14, 0x0a, 0x05, 0x24, 0x09, 0x08, 0x08, 0x09, 0x01,
    0x20, 0x0e, 0x10, 0x08, 0x14, 0x01, 0x1d, 0x16, 0x0c, 0x10, 0x17, 0x07,
    0x1b, 0x08, 0x09, 0x0f, 0x0e, 0x03, 0x18, 0x12, 0x0f, 0x14, 0x0e, 0x04,
    0x1f, 0x0b, 0x13, 0x0f, 0x0c, 0x06, 0x23, 0x14, 0x0b, 0x0c, 0x15, 0x00,
    0x1f, 0x0b, 0x16, 0x14, 0x13, 0x07, 0x23, 0x16, 0x16, 0x14, 0x0e, 0x02,
    0x1c, 0x0f, 0x17, 0x13, 0x0b, 0x03, 0x1d, 0x12, 0x12, 0x09, 0x0a, 0x07,
    0x26, 0x16, 0x14, 0x09, 0x0a, 0x05, 0x19, 0x11, 0x15, 0x08, 0x0d, 0x04,
    0x26, 0x08, 0x0f, 0x15, 0x15, 0x07, 0x1a, 0x09, 0x0d, 0x0a, 0x14, 0x04,
    0x21, 0x0a, 0x0c, 0x0b, 0x0b, 0x03, 0x1b, 0x09, 0x0d, 0x17, 0x0a, 0x03,
    0x22, 0x0c, 0x09, 0x0f, 0x0c, 0x03, 0x18, 0x0b, 0x0f, 0x10, 0x08, 0x02,
    0x1e, 0x0b, 0x0d, 0x14, 0x0d, 0x01, 0x1d, 0x16, 0x0c, 0x11, 0x0a, 0x03,
    0x18, 0x0e, 0x10, 0x0d, 0x0e, 0x05, 0x25, 0x08, 0x17, 0x16, 0x10, 0x02,
    0x1d, 0x10, 0x10, 0x14, 0x09, 0x04, 0x19, 0x10, 0x14, 0x0e, 0x0c, 0x00,
};

//*****************************************************************************
//
// The bottom left corner of the border.
//
//*****************************************************************************
static const uint8_t g_pui8BottomLeft[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    10, 0,
    10, 0,

    33,
    0x00, 0x00, 0x00,
    0x0b, 0x00, 0x00,
    0x10, 0x00, 0x00,
    0x12, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x17, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x42, 0x00, 0x00,
    0x4a, 0x00, 0x00,
    0x4c, 0x00, 0x00,
    0x50, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x54, 0x00, 0x00,
    0x56, 0x00, 0x00,
    0x58, 0x00, 0x00,
    0x5c, 0x00, 0x00,
    0x5e, 0x00, 0x00,

    0x1d, 0x11, 0x0e, 0x0b, 0x15, 0x07, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x0b,
    0x13, 0x0d, 0x09, 0x14, 0x03, 0x00, 0x00, 0x00, 0x18, 0x11, 0x12, 0x0f,
    0x0c, 0x13, 0x06, 0x01, 0x00, 0x00, 0x20, 0x12, 0x0c, 0x0e, 0x09, 0x16,
    0x17, 0x1b, 0x1f, 0x16, 0x19, 0x0d, 0x16, 0x15, 0x0f, 0x09, 0x09, 0x0d,
    0x09, 0x1e, 0x1b, 0x0a, 0x12, 0x16, 0x0e, 0x10, 0x0b, 0x0e, 0x11, 0x10,
    0x14, 0x21, 0x13, 0x11, 0x0d, 0x14, 0x0f, 0x0a, 0x09, 0x0f, 0x00, 0x1a,
    0x0e, 0x08, 0x15, 0x13, 0x0f, 0x11, 0x08, 0x16, 0x00, 0x14, 0x03, 0x02,
    0x0b, 0x0f, 0x09, 0x11, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03,
    0x05, 0x06, 0x07, 0x04,
};

//*****************************************************************************
//
// The bottom side of the border.
//
//*****************************************************************************
static const uint8_t g_pui8Bottom[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    44, 1,
    6, 0,

    39,
    0x10, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x12, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x15, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x17, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x40, 0x00, 0x00,
    0x42, 0x00, 0x00,
    0x44, 0x00, 0x00,
    0x46, 0x00, 0x00,
    0x48, 0x00, 0x00,
    0x4a, 0x00, 0x00,
    0x4c, 0x00, 0x00,
    0x4e, 0x00, 0x00,
    0x50, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x54, 0x00, 0x00,
    0x56, 0x00, 0x00,
    0x58, 0x00, 0x00,
    0x5a, 0x00, 0x00,
    0x5c, 0x00, 0x00,
    0x5e, 0x00, 0x00,

    0x1a, 0x1d, 0x21, 0x1b, 0x26, 0x22, 0x25, 0x1d, 0x1c, 0x1f, 0x1e, 0x1c,
    0x19, 0x27, 0x21, 0x1a, 0x1f, 0x1f, 0x1d, 0x1c, 0x24, 0x23, 0x19, 0x20,
    0x24, 0x22, 0x1a, 0x25, 0x27, 0x1c, 0x20, 0x1a, 0x22, 0x1a, 0x1e, 0x21,
    0x24, 0x1b, 0x26, 0x18, 0x22, 0x1d, 0x1d, 0x24, 0x1c, 0x26, 0x26, 0x23,
    0x1e, 0x1c, 0x18, 0x1a, 0x27, 0x1a, 0x22, 0x23, 0x24, 0x25, 0x20, 0x24,
    0x1a, 0x19, 0x27, 0x24, 0x1b, 0x1d, 0x1d, 0x18, 0x20, 0x1c, 0x19, 0x1b,
    0x21, 0x1e, 0x27, 0x25, 0x1c, 0x26, 0x21, 0x22, 0x1a, 0x21, 0x25, 0x1a,
    0x24, 0x20, 0x25, 0x21, 0x1d, 0x1e, 0x1d, 0x1f, 0x20, 0x1c, 0x1c, 0x24,
    0x22, 0x21, 0x24, 0x1a, 0x26, 0x25, 0x1e, 0x1f, 0x1b, 0x1e, 0x1d, 0x20,
    0x1c, 0x26, 0x1b, 0x1f, 0x20, 0x18, 0x21, 0x1c, 0x20, 0x1f, 0x26, 0x26,
    0x26, 0x1b, 0x1e, 0x1e, 0x20, 0x22, 0x1a, 0x1a, 0x1c, 0x27, 0x1d, 0x1a,
    0x24, 0x23, 0x21, 0x18, 0x1a, 0x27, 0x20, 0x1e, 0x25, 0x24, 0x26, 0x1e,
    0x24, 0x20, 0x23, 0x1d, 0x18, 0x21, 0x1c, 0x26, 0x25, 0x22, 0x1d, 0x1e,
    0x1d, 0x20, 0x20, 0x21, 0x1f, 0x26, 0x23, 0x1c, 0x22, 0x1d, 0x1c, 0x24,
    0x1c, 0x25, 0x1b, 0x1a, 0x21, 0x19, 0x20, 0x1e, 0x21, 0x1c, 0x24, 0x21,
    0x26, 0x18, 0x20, 0x23, 0x22, 0x25, 0x19, 0x27, 0x1e, 0x22, 0x21, 0x25,
    0x21, 0x1c, 0x19, 0x1b, 0x22, 0x1e, 0x18, 0x26, 0x1b, 0x1b, 0x19, 0x25,
    0x1c, 0x21, 0x1c, 0x26, 0x26, 0x18, 0x20, 0x24, 0x18, 0x19, 0x20, 0x23,
    0x27, 0x22, 0x23, 0x1d, 0x1d, 0x1c, 0x1a, 0x26, 0x21, 0x1c, 0x1a, 0x1b,
    0x23, 0x1a, 0x1a, 0x27, 0x1d, 0x1b, 0x24, 0x22, 0x25, 0x19, 0x20, 0x23,
    0x19, 0x19, 0x20, 0x1a, 0x1a, 0x18, 0x26, 0x19, 0x23, 0x21, 0x1f, 0x18,
    0x26, 0x22, 0x26, 0x20, 0x26, 0x19, 0x23, 0x22, 0x1b, 0x26, 0x21, 0x20,
    0x19, 0x1d, 0x1b, 0x27, 0x1f, 0x24, 0x22, 0x20, 0x25, 0x1b, 0x23, 0x18,
    0x1c, 0x22, 0x1a, 0x27, 0x1b, 0x21, 0x18, 0x1a, 0x1b, 0x27, 0x22, 0x1a,
    0x18, 0x1e, 0x24, 0x1b, 0x1c, 0x1d, 0x24, 0x1e, 0x23, 0x27, 0x1d, 0x1a,
    0x08, 0x13, 0x0f, 0x0c, 0x0d, 0x0f, 0x0f, 0x10, 0x0e, 0x0a, 0x12, 0x0f,
    0x10, 0x0f, 0x12, 0x15, 0x15, 0x0e, 0x0c, 0x10, 0x0e, 0x11, 0x13, 0x0a,
    0x12, 0x0e, 0x13, 0x15, 0x15, 0x0c, 0x0d, 0x16, 0x08, 0x15, 0x0b, 0x0d,
    0x0d, 0x12, 0x16, 0x14, 0x15, 0x11, 0x0b, 0x0e, 0x08, 0x16, 0x0b, 0x15,
    0x0d, 0x10, 0x0e, 0x13, 0x09, 0x09, 0x15, 0x13, 0x0f, 0x11, 0x11, 0x0c,
    0x16, 0x17, 0x0a, 0x16, 0x15, 0x0e, 0x0c, 0x0a, 0x08, 0x0a, 0x17, 0x16,
    0x13, 0x0a, 0x0c, 0x14, 0x08, 0x0f, 0x12, 0x0d, 0x08, 0x08, 0x09, 0x09,
    0x09, 0x17, 0x15, 0x10, 0x10, 0x0f, 0x15, 0x0e, 0x0f, 0x08, 0x0d, 0x0c,
    0x0e, 0x12, 0x0f, 0x0f, 0x15, 0x0e, 0x0d, 0x11, 0x11, 0x11, 0x0d, 0x12,
    0x09, 0x17, 0x08, 0x09, 0x17, 0x09, 0x0b, 0x08, 0x09, 0x08, 0x11, 0x11,
    0x10, 0x0e, 0x08, 0x17, 0x0f, 0x0e, 0x0b, 0x15, 0x09, 0x13, 0x0c, 0x16,
    0x09, 0x11, 0x0f, 0x13, 0x0b, 0x15, 0x0d, 0x0c, 0x14, 0x0d, 0x0d, 0x14,
    0x0f, 0x10, 0x15, 0x10, 0x11, 0x0e, 0x0a, 0x09, 0x15, 0x0b, 0x08, 0x0c,
    0x12, 0x0c, 0x0a, 0x13, 0x17, 0x0e, 0x12, 0x09, 0x08, 0x09, 0x14, 0x0b,
    0x16, 0x0a, 0x10, 0x13, 0x10, 0x15, 0x10, 0x08, 0x0e, 0x0d, 0x11, 0x17,
    0x14, 0x13, 0x09, 0x12, 0x17, 0x0a, 0x17, 0x12, 0x0e, 0x09, 0x0d, 0x0e,
    0x10, 0x17, 0x10, 0x11, 0x09, 0x0d, 0x14, 0x08, 0x0f, 0x0c, 0x13, 0x17,
    0x0a, 0x0b, 0x17, 0x10, 0x11, 0x11, 0x10, 0x0d, 0x0c, 0x11, 0x17, 0x0c,
    0x14, 0x16, 0x16, 0x0b, 0x08, 0x0c, 0x11, 0x10, 0x0c, 0x0a, 0x09, 0x0d,
    0x0f, 0x16, 0x0d, 0x16, 0x0b, 0x09, 0x16, 0x0d, 0x0d, 0x16, 0x16, 0x16,
    0x0f, 0x0f, 0x0b, 0x14, 0x09, 0x0b, 0x09, 0x15, 0x0a, 0x17, 0x08, 0x0b,
    0x0c, 0x12, 0x14, 0x10, 0x14, 0x15, 0x16, 0x0b, 0x14, 0x0b, 0x0a, 0x08,
    0x0d, 0x08, 0x0e, 0x12, 0x17, 0x0c, 0x10, 0x0e, 0x14, 0x14, 0x0b, 0x15,
    0x08, 0x0c, 0x12, 0x0b, 0x0b, 0x12, 0x0e, 0x10, 0x0d, 0x0a, 0x08, 0x09,
    0x08, 0x16, 0x0d, 0x14, 0x0a, 0x10, 0x14, 0x0f, 0x11, 0x0b, 0x0a, 0x10,
    0x0e, 0x13, 0x12, 0x11, 0x0e, 0x08, 0x0a, 0x13, 0x0a, 0x0a, 0x15, 0x0b,
    0x09, 0x0b, 0x17, 0x0c, 0x13, 0x14, 0x14, 0x0c, 0x17, 0x16, 0x14, 0x0f,
    0x10, 0x13, 0x13, 0x08, 0x15, 0x15, 0x0f, 0x0b, 0x10, 0x0a, 0x15, 0x17,
    0x0b, 0x17, 0x12, 0x0d, 0x0a, 0x10, 0x11, 0x0c, 0x13, 0x10, 0x10, 0x0f,
    0x0d, 0x0c, 0x13, 0x0d, 0x0a, 0x10, 0x15, 0x13, 0x0c, 0x11, 0x13, 0x09,
    0x0e, 0x0b, 0x0d, 0x16, 0x0d, 0x0b, 0x16, 0x11, 0x0b, 0x10, 0x17, 0x0e,
    0x09, 0x10, 0x12, 0x14, 0x08, 0x0b, 0x0c, 0x0e, 0x10, 0x17, 0x13, 0x12,
    0x0f, 0x11, 0x0e, 0x13, 0x0a, 0x0a, 0x15, 0x10, 0x0e, 0x0b, 0x0f, 0x14,
    0x0f, 0x0d, 0x0d, 0x12, 0x16, 0x0c, 0x09, 0x17, 0x14, 0x13, 0x14, 0x15,
    0x17, 0x08, 0x0b, 0x0f, 0x08, 0x17, 0x0a, 0x10, 0x10, 0x10, 0x0c, 0x12,
    0x13, 0x09, 0x0b, 0x09, 0x0d, 0x12, 0x16, 0x14, 0x08, 0x0b, 0x0f, 0x16,
    0x0f, 0x10, 0x16, 0x0c, 0x0c, 0x12, 0x09, 0x0b, 0x13, 0x0d, 0x12, 0x14,
    0x0c, 0x15, 0x0c, 0x15, 0x0e, 0x10, 0x0f, 0x09, 0x12, 0x13, 0x0b, 0x17,
    0x0d, 0x09, 0x13, 0x0e, 0x0d, 0x0b, 0x0c, 0x15, 0x13, 0x0b, 0x09, 0x17,
    0x16, 0x0b, 0x0b, 0x11, 0x10, 0x16, 0x0d, 0x15, 0x13, 0x11, 0x12, 0x09,
    0x0a, 0x0a, 0x0b, 0x14, 0x15, 0x0f, 0x13, 0x0b, 0x11, 0x0f, 0x11, 0x16,
    0x12, 0x16, 0x14, 0x0e, 0x09, 0x16, 0x0e, 0x17, 0x09, 0x11, 0x10, 0x12,
    0x10, 0x16, 0x0f, 0x0b, 0x10, 0x0a, 0x0d, 0x12, 0x0d, 0x10, 0x0f, 0x0a,
    0x17, 0x0a, 0x0e, 0x10, 0x12, 0x17, 0x0f, 0x0d, 0x15, 0x0b, 0x13, 0x16,
    0x0a, 0x0a, 0x16, 0x0b, 0x14, 0x0f, 0x16, 0x0c, 0x0d, 0x0e, 0x10, 0x16,
    0x10, 0x15, 0x11, 0x15, 0x0d, 0x08, 0x08, 0x0d, 0x0b, 0x0e, 0x16, 0x16,
    0x0e, 0x0e, 0x0b, 0x0b, 0x12, 0x17, 0x0a, 0x14, 0x0a, 0x09, 0x17, 0x16,
    0x10, 0x16, 0x0a, 0x15, 0x0c, 0x12, 0x14, 0x15, 0x0f, 0x0d, 0x12, 0x15,
    0x0e, 0x13, 0x0b, 0x12, 0x09, 0x0a, 0x10, 0x0f, 0x10, 0x14, 0x13, 0x0a,
    0x14, 0x16, 0x16, 0x16, 0x17, 0x16, 0x14, 0x0f, 0x15, 0x17, 0x0d, 0x09,
    0x0c, 0x0b, 0x10, 0x0d, 0x0e, 0x09, 0x15, 0x17, 0x16, 0x10, 0x09, 0x12,
    0x0e, 0x08, 0x10, 0x0e, 0x17, 0x0d, 0x15, 0x14, 0x0c, 0x0b, 0x16, 0x17,
    0x0c, 0x14, 0x09, 0x14, 0x0d, 0x09, 0x13, 0x12, 0x0d, 0x0c, 0x17, 0x13,
    0x0e, 0x15, 0x12, 0x0c, 0x0d, 0x14, 0x16, 0x14, 0x15, 0x0f, 0x0a, 0x14,
    0x14, 0x08, 0x11, 0x09, 0x0b, 0x10, 0x08, 0x10, 0x0c, 0x0a, 0x0d, 0x12,
    0x0b, 0x08, 0x0d, 0x10, 0x0d, 0x0c, 0x0b, 0x13, 0x0a, 0x16, 0x17, 0x0f,
    0x12, 0x16, 0x0c, 0x0f, 0x0d, 0x0f, 0x0c, 0x0a, 0x10, 0x15, 0x0c, 0x13,
    0x0d, 0x0d, 0x0c, 0x12, 0x0f, 0x12, 0x0d, 0x12, 0x13, 0x12, 0x0a, 0x08,
    0x17, 0x0e, 0x13, 0x09, 0x0c, 0x13, 0x11, 0x16, 0x11, 0x15, 0x0e, 0x16,
    0x0d, 0x12, 0x09, 0x15, 0x10, 0x0d, 0x11, 0x15, 0x12, 0x16, 0x10, 0x0a,
    0x10, 0x15, 0x14, 0x0b, 0x10, 0x17, 0x0c, 0x0f, 0x0e, 0x08, 0x11, 0x12,
    0x13, 0x0a, 0x11, 0x0d, 0x08, 0x17, 0x0c, 0x0d, 0x12, 0x0d, 0x0b, 0x0a,
    0x12, 0x15, 0x17, 0x0d, 0x13, 0x10, 0x0f, 0x0c, 0x0e, 0x0c, 0x0f, 0x16,
    0x0b, 0x14, 0x0e, 0x11, 0x14, 0x17, 0x0c, 0x0f, 0x0a, 0x16, 0x14, 0x0a,
    0x16, 0x09, 0x10, 0x10, 0x0e, 0x14, 0x12, 0x09, 0x11, 0x12, 0x0f, 0x0d,
    0x0a, 0x16, 0x11, 0x10, 0x0b, 0x09, 0x0f, 0x0e, 0x15, 0x15, 0x08, 0x11,
    0x15, 0x0d, 0x09, 0x17, 0x0b, 0x16, 0x09, 0x09, 0x17, 0x12, 0x11, 0x0e,
    0x0e, 0x0b, 0x0f, 0x17, 0x16, 0x16, 0x0d, 0x08, 0x15, 0x16, 0x11, 0x08,
    0x17, 0x08, 0x0f, 0x15, 0x16, 0x10, 0x0f, 0x13, 0x15, 0x10, 0x12, 0x08,
    0x0f, 0x14, 0x0a, 0x0f, 0x0e, 0x13, 0x15, 0x15, 0x17, 0x0d, 0x15, 0x15,
    0x0b, 0x0a, 0x16, 0x09, 0x09, 0x0f, 0x0a, 0x08, 0x10, 0x12, 0x16, 0x0e,
    0x0a, 0x0d, 0x0a, 0x08, 0x16, 0x15, 0x09, 0x0d, 0x11, 0x0b, 0x15, 0x08,
    0x17, 0x12, 0x16, 0x17, 0x17, 0x13, 0x15, 0x0b, 0x16, 0x13, 0x0d, 0x17,
    0x0b, 0x0f, 0x08, 0x13, 0x0a, 0x16, 0x0a, 0x0c, 0x0b, 0x0d, 0x0d, 0x0a,
    0x0a, 0x0e, 0x10, 0x14, 0x12, 0x0d, 0x15, 0x11, 0x08, 0x13, 0x11, 0x08,
    0x09, 0x0c, 0x08, 0x0b, 0x0a, 0x0b, 0x10, 0x0e, 0x10, 0x15, 0x10, 0x13,
    0x0c, 0x08, 0x10, 0x16, 0x0e, 0x0d, 0x10, 0x0e, 0x09, 0x09, 0x0e, 0x10,
    0x0f, 0x12, 0x15, 0x10, 0x0b, 0x0a, 0x15, 0x0c, 0x0e, 0x16, 0x10, 0x11,
    0x0a, 0x08, 0x17, 0x13, 0x16, 0x10, 0x0f, 0x0a, 0x11, 0x17, 0x08, 0x17,
    0x0c, 0x10, 0x0d, 0x0e, 0x11, 0x13, 0x16, 0x09, 0x0e, 0x14, 0x12, 0x11,
    0x17, 0x0f, 0x16, 0x0d, 0x0e, 0x0f, 0x16, 0x11, 0x10, 0x16, 0x0c, 0x0e,
    0x0f, 0x13, 0x11, 0x08, 0x12, 0x11, 0x17, 0x17, 0x0a, 0x0d, 0x0e, 0x14,
    0x09, 0x0d, 0x15, 0x0f, 0x0a, 0x0f, 0x09, 0x09, 0x17, 0x17, 0x0e, 0x0e,
    0x0f, 0x0d, 0x17, 0x17, 0x0c, 0x0b, 0x0d, 0x13, 0x17, 0x16, 0x13, 0x12,
    0x10, 0x13, 0x12, 0x13, 0x09, 0x08, 0x0f, 0x0a, 0x0d, 0x0d, 0x11, 0x0f,
    0x14, 0x12, 0x10, 0x13, 0x12, 0x17, 0x09, 0x0a, 0x0d, 0x09, 0x09, 0x11,
    0x0c, 0x0f, 0x0d, 0x0c, 0x0e, 0x08, 0x16, 0x16, 0x14, 0x11, 0x12, 0x15,
    0x11, 0x09, 0x08, 0x17, 0x0e, 0x11, 0x0f, 0x0b, 0x0c, 0x08, 0x17, 0x17,
    0x08, 0x08, 0x09, 0x0d, 0x0a, 0x0b, 0x16, 0x0f, 0x12, 0x0b, 0x13, 0x08,
    0x0c, 0x12, 0x17, 0x09, 0x0b, 0x12, 0x17, 0x15, 0x13, 0x17, 0x14, 0x0a,
    0x11, 0x0c, 0x0d, 0x16, 0x0c, 0x0c, 0x15, 0x0c, 0x0d, 0x17, 0x12, 0x0f,
    0x0b, 0x10, 0x16, 0x16, 0x14, 0x12, 0x17, 0x09, 0x0c, 0x16, 0x0b, 0x10,
    0x10, 0x0a, 0x0d, 0x0c, 0x09, 0x0a, 0x0f, 0x12, 0x0e, 0x15, 0x11, 0x13,
    0x09, 0x0f, 0x17, 0x0f, 0x0f, 0x11, 0x17, 0x12, 0x0a, 0x16, 0x10, 0x17,
    0x10, 0x0f, 0x09, 0x15, 0x0e, 0x0c, 0x0d, 0x17, 0x0e, 0x13, 0x0b, 0x10,
    0x15, 0x13, 0x0b, 0x0b, 0x10, 0x14, 0x16, 0x12, 0x0b, 0x16, 0x09, 0x12,
    0x10, 0x09, 0x0c, 0x13, 0x17, 0x14, 0x13, 0x10, 0x0c, 0x14, 0x0e, 0x12,
    0x08, 0x14, 0x11, 0x0e, 0x0f, 0x15, 0x16, 0x0c, 0x11, 0x09, 0x0f, 0x09,
    0x16, 0x0e, 0x13, 0x09, 0x0d, 0x15, 0x13, 0x16, 0x16, 0x08, 0x11, 0x16,
    0x15, 0x0c, 0x0f, 0x09, 0x08, 0x15, 0x14, 0x09, 0x12, 0x0e, 0x0f, 0x09,
    0x01, 0x05, 0x04, 0x04, 0x03, 0x02, 0x03, 0x03, 0x02, 0x00, 0x02, 0x01,
    0x03, 0x06, 0x01, 0x03, 0x05, 0x00, 0x04, 0x02, 0x03, 0x00, 0x03, 0x05,
    0x03, 0x05, 0x03, 0x07, 0x04, 0x03, 0x03, 0x06, 0x00, 0x07, 0x03, 0x03,
    0x01, 0x06, 0x07, 0x04, 0x07, 0x01, 0x05, 0x02, 0x00, 0x07, 0x06, 0x05,
    0x07, 0x02, 0x00, 0x02, 0x02, 0x03, 0x00, 0x06, 0x00, 0x03, 0x06, 0x05,
    0x06, 0x01, 0x03, 0x07, 0x01, 0x06, 0x03, 0x03, 0x05, 0x02, 0x07, 0x05,
    0x04, 0x05, 0x07, 0x04, 0x04, 0x06, 0x02, 0x03, 0x00, 0x02, 0x06, 0x03,
    0x05, 0x06, 0x02, 0x06, 0x02, 0x00, 0x03, 0x01, 0x02, 0x07, 0x00, 0x03,
    0x06, 0x03, 0x07, 0x03, 0x05, 0x07, 0x00, 0x01, 0x04, 0x00, 0x06, 0x00,
    0x07, 0x00, 0x04, 0x00, 0x02, 0x02, 0x04, 0x00, 0x01, 0x06, 0x07, 0x03,
    0x06, 0x03, 0x05, 0x01, 0x02, 0x05, 0x05, 0x00, 0x01, 0x04, 0x04, 0x06,
    0x03, 0x05, 0x00, 0x07, 0x06, 0x06, 0x00, 0x05, 0x07, 0x04, 0x05, 0x02,
    0x07, 0x02, 0x02, 0x00, 0x00, 0x02, 0x04, 0x07, 0x05, 0x01, 0x00, 0x07,
    0x07, 0x05, 0x00, 0x00, 0x01, 0x05, 0x07, 0x05, 0x02, 0x00, 0x05, 0x01,
    0x07, 0x05, 0x06, 0x06, 0x01, 0x04, 0x01, 0x00, 0x06, 0x03, 0x01, 0x07,
    0x06, 0x05, 0x06, 0x03, 0x07, 0x06, 0x03, 0x07, 0x03, 0x04, 0x07, 0x05,
    0x01, 0x07, 0x03, 0x04, 0x00, 0x00, 0x05, 0x07, 0x05, 0x04, 0x06, 0x06,
    0x01, 0x07, 0x06, 0x00, 0x03, 0x00, 0x07, 0x01, 0x05, 0x05, 0x04, 0x05,
    0x04, 0x00, 0x04, 0x00, 0x04, 0x03, 0x05, 0x05, 0x03, 0x01, 0x01, 0x03,
    0x01, 0x07, 0x03, 0x06, 0x03, 0x01, 0x04, 0x04, 0x01, 0x03, 0x04, 0x04,
    0x03, 0x04, 0x06, 0x01, 0x01, 0x02, 0x06, 0x06, 0x03, 0x02, 0x06, 0x07,
    0x06, 0x04, 0x04, 0x02, 0x05, 0x06, 0x05, 0x06, 0x05, 0x00, 0x04, 0x00,
    0x02, 0x01, 0x05, 0x03, 0x05, 0x02, 0x07, 0x01, 0x06, 0x05, 0x03, 0x00,
    0x00, 0x01, 0x06, 0x03, 0x04, 0x04, 0x03, 0x02, 0x01, 0x07, 0x05, 0x06,
    0x06, 0x02, 0x04, 0x03, 0x03, 0x01, 0x04, 0x05, 0x03, 0x02, 0x01, 0x01,
};

//*****************************************************************************
//
// The bottom right corner of the border.
//
//*****************************************************************************
static const uint8_t g_pui8BottomRight[] =
{
    IMAGE_FMT_8BPP_UNCOMP,
    10, 0,
    10, 0,

    29,
    0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00,
    0x0b, 0x00, 0x00,
    0x10, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x12, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x14, 0x00, 0x00,
    0x16, 0x00, 0x00,
    0x17, 0x00, 0x00,
    0x20, 0x00, 0x00,
    0x21, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x24, 0x00, 0x00,
    0x25, 0x00, 0x00,
    0x26, 0x00, 0x00,
    0x27, 0x00, 0x00,
    0x28, 0x00, 0x00,
    0x29, 0x00, 0x00,
    0x2a, 0x00, 0x00,
    0x2b, 0x00, 0x00,
    0x2c, 0x00, 0x00,
    0x2d, 0x00, 0x00,
    0x2e, 0x00, 0x00,
    0x2f, 0x00, 0x00,
    0x40, 0x00, 0x00,
    0x48, 0x00, 0x00,
    0x50, 0x00, 0x00,
    0x56, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x14, 0x1c, 0x14, 0x0a, 0x17, 0x0d, 0x04, 0x00, 0x00,
    0x00, 0x1b, 0x0e, 0x0d, 0x13, 0x17, 0x12, 0x09, 0x00, 0x00, 0x16, 0x1b,
    0x13, 0x10, 0x19, 0x13, 0x0e, 0x07, 0x16, 0x1a, 0x1c, 0x14, 0x18, 0x13,
    0x0a, 0x10, 0x10, 0x04, 0x1d, 0x0a, 0x15, 0x13, 0x19, 0x11, 0x15, 0x15,
    0x18, 0x03, 0x12, 0x14, 0x19, 0x0e, 0x16, 0x11, 0x14, 0x17, 0x0e, 0x08,
    0x14, 0x0b, 0x18, 0x0c, 0x0a, 0x13, 0x0b, 0x14, 0x06, 0x01, 0x11, 0x10,
    0x0d, 0x0f, 0x13, 0x0a, 0x0a, 0x13, 0x07, 0x00, 0x0e, 0x10, 0x0f, 0x17,
    0x0b, 0x11, 0x09, 0x04, 0x02, 0x00, 0x07, 0x03, 0x05, 0x05, 0x05, 0x08,
    0x02, 0x00, 0x00, 0x00,
};

//*****************************************************************************
//
//! Draws a frame on the LCD with the application name in the title bar.
//!
//! \param psContext is a pointer to the graphics library context used to draw
//! the application frame.
//! \param pcAppName is a pointer to a string that contains the name of the
//! application.
//!
//! This function draws an application frame onto the LCD, using the supplied
//! graphics library context to access the LCD and the given name in the title
//! bar of the application frame.
//!
//! \return None.
//
//*****************************************************************************
void
FrameDraw(tContext *psContext, const char *pcAppName)
{
    tRectangle sRect;

    //
    // See if the display is in a landscape or portrait configuration.
    //
    if(GrContextDpyWidthGet(psContext) == 320)
    {
        //
        // Reset the clipping region to the entire LCD surface.
        //
        sRect.i16XMin = 0;
        sRect.i16YMin = 0;
        sRect.i16XMax = 319;
        sRect.i16YMax = 239;
        GrContextClipRegionSet(psContext, &sRect);

        //
        // Draw the images of the border.
        //
        GrImageDraw(psContext, g_pui8TopLeft, 0, 0);
        GrImageDraw(psContext, g_pui8Top, 10, 0);
        GrImageDraw(psContext, g_pui8TopRight, 310, 0);
        GrImageDraw(psContext, g_pui8Left, 0, 26);
        GrImageDraw(psContext, g_pui8Right, 314, 26);
        GrImageDraw(psContext, g_pui8BottomLeft, 0, 230);
        GrImageDraw(psContext, g_pui8Bottom, 10, 234);
        GrImageDraw(psContext, g_pui8BottomRight, 310, 230);

        //
        // Select red test in the Computer Modern sans-serif 18pt bold font.
        //
        GrContextForegroundSet(psContext, ClrWhite);
        GrContextFontSet(psContext, g_psFontCmss18b);

        //
        // Draw the application name centered in the title bar.
        //
        GrStringDrawCentered(psContext, pcAppName, -1, 160, 8, false);

        //
        // Set the clip region to the interior region of the border.
        //
        sRect.i16XMin = 8;
        sRect.i16YMin = 24;
        sRect.i16XMax = 311;
        sRect.i16YMax = 231;
        GrContextClipRegionSet(psContext, &sRect);
    }
    else
    {
        //
        // Reset the clipping region to the entire LCD surface.
        //
        sRect.i16XMin = 0;
        sRect.i16YMin = 0;
        sRect.i16XMax = 239;
        sRect.i16YMax = 319;
        GrContextClipRegionSet(psContext, &sRect);

        //
        // Draw the images of the border.
        //
        GrImageDraw(psContext, g_pui8TopLeft, 0, 0);
        GrImageDraw(psContext, g_pui8Top, 10, 0);
        GrImageDraw(psContext, g_pui8TopRight, 230, 0);
        GrImageDraw(psContext, g_pui8Left, 0, 26);
        GrImageDraw(psContext, g_pui8Left, 0, 106);
        GrImageDraw(psContext, g_pui8Right, 234, 26);
        GrImageDraw(psContext, g_pui8Right, 234, 106);
        GrImageDraw(psContext, g_pui8BottomLeft, 0, 310);
        GrImageDraw(psContext, g_pui8Bottom, 10, 314);
        GrImageDraw(psContext, g_pui8BottomRight, 230, 310);

        //
        // Select red test in the Computer Modern sans-serif 18pt bold font.
        //
        GrContextForegroundSet(psContext, ClrWhite);
        GrContextFontSet(psContext, g_psFontCmss18b);

        //
        // Draw the application name centered in the title bar.
        //
        GrStringDrawCentered(psContext, pcAppName, -1, 120, 8, false);

        //
        // Set the clip region to the interior region of the border.
        //
        sRect.i16XMin = 8;
        sRect.i16YMin = 24;
        sRect.i16XMax = 231;
        sRect.i16YMax = 311;
        GrContextClipRegionSet(psContext, &sRect);
    }
}

//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************
