/**
 * @file same54_crypto.c
 * @brief SAME54 hardware cryptography accelerator
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCrypto Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

//Switch to the appropriate trace level
#define TRACE_LEVEL CRYPTO_TRACE_LEVEL

//Dependencies
#include "pukcc/CryptoLib_typedef_pb.h"
#include "pukcc/CryptoLib_Headers_pb.h"
#include "core/crypto.h"
#include "hardware/same54_crypto.h"
#include "hardware/same54_crypto_pukcc.h"
#include "debug.h"

//Global variables
OsMutex same54CryptoMutex;


/**
 * @brief Cryptography accelerator initialization
 **/

error_t same54CryptoInit(void)
{
   error_t error;

   //Create a mutex to prevent simultaneous access to the cryptography
   //accelerator
   if(!osCreateMutex(&same54CryptoMutex))
   {
      //Failed to create mutex
      return ERROR_OUT_OF_RESOURCES;
   }

   //Initialize public key accelerator
   error = pukccInit();

   //Return status code
   return error;
}
