/**
 * @file ssl_misc.h
 * @brief SSL 3.0 helper functions
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSL Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _SSL_MISC_H
#define _SSL_MISC_H

//Dependencies
#include "core/crypto.h"
#include "tls.h"

//C++ guard
#ifdef __cplusplus
   extern "C" {
#endif

//SSL 3.0 related constants
extern const uint8_t sslPad1[48];
extern const uint8_t sslPad2[48];

//SSL 3.0 related functions
error_t sslExpandKey(const uint8_t *secret, size_t secretLen,
   const uint8_t *random, size_t randomLen, uint8_t *output, size_t outputLen);

error_t sslComputeMac(TlsEncryptionEngine *encryptionEngine,
   const TlsRecord *record, const uint8_t *data, size_t dataLen, uint8_t *mac);

uint32_t sslVerifyPadding(TlsEncryptionEngine *decryptionEngine,
   const uint8_t *data, size_t dataLen, size_t *paddingLen);

uint32_t sslVerifyMac(TlsEncryptionEngine *decryptionEngine,
   const TlsRecord *record, const uint8_t *data, size_t dataLen,
   size_t maxDataLen, const uint8_t *mac);

//C++ guard
#ifdef __cplusplus
   }
#endif

#endif
