/**
 * @file ftp_server_commands.h
 * @brief FTP server (command processing)
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _FTP_SERVER_COMMANDS_H
#define _FTP_SERVER_COMMANDS_H

//Dependencies
#include "ftp/ftp_server.h"

//C++ guard
#ifdef __cplusplus
   extern "C" {
#endif

//FTP server related functions
void ftpServerProcessCmd(FtpServerContext *context,
   FtpClientConnection *connection);

void ftpServerProcessUnknownCmd(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessNoop(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessSyst(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessFeat(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessType(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessStru(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessMode(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessUser(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessPass(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessRein(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessQuit(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessPort(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessEprt(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessPasv(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessEpsv(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessAbor(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessPwd(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessCwd(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessCdup(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessList(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessMkd(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessRmd(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessSize(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessRetr(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessStor(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessAppe(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessRnfr(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessRnto(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

void ftpServerProcessDele(FtpServerContext *context,
   FtpClientConnection *connection, char_t *param);

//C++ guard
#ifdef __cplusplus
   }
#endif

#endif
