/**
 * @file ftp_server_events.h
 * @brief FTP server (event handlers)
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _FTP_SERVER_EVENTS_H
#define _FTP_SERVER_EVENTS_H

//Dependencies
#include "ftp/ftp_server.h"

//Time constant
#define FTP_SERVER_180_DAYS (180 * 86400)

//C++ guard
#ifdef __cplusplus
   extern "C" {
#endif

//FTP server related functions
void ftpServerControlEventHandler(FtpServerContext *context,
   FtpClientConnection *connection, uint_t eventFlags);

void ftpServerDataEventHandler(FtpServerContext *context,
   FtpClientConnection *connection, uint_t eventFlags);

void ftpServerSendData(FtpServerContext *context, FtpClientConnection *connection);
void ftpServerReceiveData(FtpServerContext *context, FtpClientConnection *connection);

//C++ guard
#ifdef __cplusplus
   }
#endif

#endif
