/**
 * @file ftp_server_misc.h
 * @brief Helper functions for FTP server
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _FTP_SERVER_MISC_H
#define _FTP_SERVER_MISC_H

//Dependencies
#include "ftp/ftp_server.h"

//C++ guard
#ifdef __cplusplus
   extern "C" {
#endif

//FTP server related functions
uint16_t ftpServerGetPassivePort(FtpServerContext *context);

void ftpServerCloseConnection(FtpServerContext *context,
   FtpClientConnection *connection);

FtpClientConnection *ftpServerAcceptControlConnection(FtpServerContext *context);
void ftpServerCloseControlConnection(FtpClientConnection *connection);

error_t ftpServerOpenDataConnection(FtpServerContext *context,
   FtpClientConnection *connection);

void ftpServerAcceptDataConnection(FtpClientConnection *connection);
void ftpServerCloseDataConnection(FtpClientConnection *connection);

error_t ftpServerGetPath(FtpClientConnection *connection,
   const char_t *inputPath, char_t *outputPath, size_t maxLen);

uint_t ftpServerGetFilePermissions(FtpServerContext *context,
   FtpClientConnection *connection, const char_t *path);

const char_t *ftpServerStripRootDir(FtpServerContext *context, const char_t *path);
const char_t *ftpServerStripHomeDir(FtpClientConnection *connection, const char_t *path);

//C++ guard
#ifdef __cplusplus
   }
#endif

#endif
