/**
 * @file system_at32uc3a0512.c
 * @brief AT32UC3A0512 system initialization
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

//Dependencies
#include <stdlib.h>
#include <avr32/io.h>
#include "evk1105.h"
#include "pm.h"
#include "flashc.h"
#include "sdramc.h"

//Low-level initialization function
extern void _init_startup(void);


/**
 * @brief System initialization
 **/

void systemInit(void)
{
   //Low-level initialization
   _init_startup();

   //Switch main clock to OSC0 (12MHz)
   pm_switch_to_osc0(&AVR32_PM, OSC0_FREQ, AVR32_PM_OSCCTRL1_STARTUP_2048_RCOSC);

   //Start OSC1 (11.2896MHz)
   pm_enable_osc1_crystal(&AVR32_PM, OSC1_FREQ);
   pm_enable_clk1(&AVR32_PM, AVR32_PM_OSCCTRL1_STARTUP_2048_RCOSC);

   //Configure PLL0 (132MHz)
   pm_pll_setup(&AVR32_PM, 0, 10, 1, 0, 16);
   //Set PLL operating range (80 to 180MHz) and output divider (2)
   pm_pll_set_option(&AVR32_PM, 0, 1, 1, 0);

   //Start PLL0
   pm_pll_enable(&AVR32_PM, 0);
   //Wait for the PLL to lock
   pm_wait_for_pll0_locked(&AVR32_PM);

   //Set FLASH wait-state
   flashc_set_wait_state(1);

   //Switch main clock to PLL0
   pm_switch_to_clock(&AVR32_PM, AVR32_PM_MCCTRL_MCSEL_PLL0);

   //Configure PLL1 (96MHz)
   pm_pll_setup(&AVR32_PM, 1, 7, 1, 0, 16);
   //Set PLL operating range (80 to 180MHz) and output divider (2)
   pm_pll_set_option(&AVR32_PM, 1, 1, 1, 0);

   //Start PLL1
   pm_pll_enable(&AVR32_PM, 1);
   //Wait for the PLL to lock
   pm_wait_for_pll1_locked(&AVR32_PM);

   //Set clock dividers for PBA, PBB and HSB clocks
   pm_cksel(&AVR32_PM, 0, 0, 0, 0, 0, 0);

   //Initialize SDRAM memory
   sdramc_init(HSB_FREQ);
}
