/**
 * @file wilc1000_config.h
 * @brief WILC1000 configuration
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _WILC1000_CONFIG_H
#define _WILC1000_CONFIG_H

//Dependencies
#include <stdint.h>

//WILC1000 chip revision
#define CONF_WILC_USE_1000_REV_B

//SPI interface
#define CONF_WILC_USE_SPI     1

//Debug logs
#define CONF_WILC_DEBUG       1
//Debug output redirection
#define CONF_WILC_PRINTF      TRACE_PRINTF

//RST pin (PD9)
#define CONF_WILC_RST_PIN     {PIO_GROUP_D, PIO_PD9, PIO_OUTPUT, PIO_DEFAULT}

//CE pin (PD28)
#define CONF_WILC_CE_PIN      {PIO_GROUP_D, PIO_PD28, PIO_OUTPUT, PIO_DEFAULT}

//WAKE pin (PD10)
#define CONF_WILC_WAKE_PIN    {PIO_GROUP_D, PIO_PD10, PIO_OUTPUT, PIO_DEFAULT}

//CS pin (PD29)
#define CONF_WILC_CS_PIN      {PIO_GROUP_D, PIO_PD29, PIO_OUTPUT, PIO_DRVSTR_ME}

//IRQ pin (PA21)
#define CONF_WILC_IRQ_PIN     {PIO_GROUP_A, PIO_PA21, PIO_INPUT, PIO_PULLUP | PIO_IT_LOW_LEVEL}
#define CONF_WILC_IRQ_ID_PIO  ID_PIOA

//SCK pin (PD25)
#define CONF_WILC_SCK_PIN     {PIO_GROUP_D, PIO_PD25A_SPI1_SPCK, PIO_PERIPH_A, PIO_DRVSTR_ME}

//MOSI pin (PD26)
#define CONF_WILC_MOSI_PIN    {PIO_GROUP_D, PIO_PD26A_SPI1_MOSI, PIO_PERIPH_A, PIO_DRVSTR_ME}

//MISO pin (PD27)
#define CONF_WILC_MISO_PIN    {PIO_GROUP_D, PIO_PD27A_SPI1_MISO, PIO_PERIPH_A, PIO_DRVSTR_ME}

//SPI instance
#define CONF_WILC_SPI         SPI1
#define CONF_WILC_SPI_ID      ID_SPI1

//SPI clock
#define CONF_WILC_SPI_CLOCK   40000000

//Interrupt group priority
#define CONF_WILC_IRQ_PRIORITY 0

//Forward function declaration
extern void wilc1000EventHook(uint8_t msgType, void *msg);

//Callback function that processes Wi-Fi event notifications
#define CONF_WILC_EVENT_HOOK(msgType, msg) wilc1000EventHook(msgType, msg)

#endif
