/**
 * @file spi0_driver.h
 * @brief SPI0 driver
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _SPI0_DRIVER_H
#define _SPI0_DRIVER_H

//SPI0 driver
extern const SpiDriver spi0Driver;

//SPI0 related functions
error_t spi0Init(void);
error_t spi0SetMode(uint_t mode);
error_t spi0SetBitrate(uint_t bitrate);
void spi0AssertCs(void);
void spi0DeassertCs(void);
uint8_t spi0Transfer(uint8_t data);

#endif
