/**
 * @file winc1500_config.h
 * @brief WINC1500 configuration
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _WINC1500_CONFIG_H
#define _WINC1500_CONFIG_H

//Dependencies
#include <stdint.h>

//SPI interface
#define CONF_WINC_USE_SPI               1

//Debug logs
#define CONF_WINC_DEBUG                 1
//Debug output redirection
#define CONF_WINC_PRINTF                TRACE_PRINTF

//RST pin (PA6)
#define CONF_WINC_RST_PIN               PIN_PA06
#define CONF_WINC_RST_MASK              PORT_PA06

//CE pin (PA27)
#define CONF_WINC_CE_PIN                PIN_PA27
#define CONF_WINC_CE_MASK               PORT_PA27

//WAKE pin (PA7)
#define CONF_WINC_WAKE_PIN              PIN_PA07
#define CONF_WINC_WAKE_MASK             PORT_PA07

//CS pin (PB28)
#define CONF_WINC_CS_PIN                PIN_PB28
#define CONF_WINC_CS_MASK               PORT_PB28

//IRQ pin (PB7)
#define CONF_WINC_IRQ_PIN               PIN_PB07
#define CONF_WINC_IRQ_MASK              PORT_PB07
#define CONF_WINC_IRQ_MUX()             PORT->Group[1].PMUX[3].bit.PMUXO = MUX_PB07A_EIC_EXTINT7
#define CONF_WINC_IRQ_CONFIG()          EIC->CONFIG[0].bit.SENSE7 = EIC_CONFIG_SENSE7_LOW_Val

//SCK pin (PB26)
#define CONF_WINC_SCK_PIN               PIN_PB26
#define CONF_WINC_SCK_MASK              PORT_PB26
#define CONF_WINC_SCK_PAD               1
#define CONF_WINC_SCK_MUX()             PORT->Group[1].PMUX[13].bit.PMUXE = MUX_PB26D_SERCOM4_PAD1

//MOSI pin (PB27)
#define CONF_WINC_MOSI_PIN              PIN_PB27
#define CONF_WINC_MOSI_MASK             PORT_PB27
#define CONF_WINC_MOSI_PAD              0
#define CONF_WINC_MOSI_MUX()            PORT->Group[1].PMUX[13].bit.PMUXO = MUX_PB27D_SERCOM4_PAD0

//MISO pin (PB29)
#define CONF_WINC_MISO_PIN              PIN_PB29
#define CONF_WINC_MISO_MASK             PORT_PB29
#define CONF_WINC_MISO_PAD              3
#define CONF_WINC_MISO_MUX()            PORT->Group[1].PMUX[14].bit.PMUXO = MUX_PB29D_SERCOM4_PAD3

//SERCOM instance
#define CONF_WINC_SERCOM                SERCOM4
#define CONF_WINC_SERCOM_GCLK_ID_CORE   SERCOM4_GCLK_ID_CORE
#define CONF_WINC_SERCOM_APB_CLK_EN()   MCLK->APBDMASK.bit.SERCOM4_ = 1

//SPI clock
#define CONF_WINC_SPI_CLOCK             20000000

//IRQ number
#define CONF_WINC_IRQn                  EIC_7_IRQn
//IRQ handler
#define CONF_WINC_IRQHandler            EIC_7_Handler

//Interrupt priority grouping
#define CONF_WINC_IRQ_PRIORITY_GROUPING 4
//Interrupt group priority
#define CONF_WINC_IRQ_GROUP_PRIORITY    7
//Interrupt subpriority
#define CONF_WINC_IRQ_SUB_PRIORITY      0

//Forward function declaration
extern void winc1500EventHook(uint8_t msgType, void *msg);

//Callback function that processes Wi-Fi event notifications
#define CONF_WINC_EVENT_HOOK(msgType, msg) winc1500EventHook(msgType, msg)

#endif
