/**
 * @file wilc1000_config.h
 * @brief WILC1000 configuration
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _WILC1000_CONFIG_H
#define _WILC1000_CONFIG_H

//Dependencies
#include <stdint.h>

//WILC1000 chip revision
#define CONF_WILC_USE_1000_REV_B

//SPI interface
#define CONF_WILC_USE_SPI     1

//Debug logs
#define CONF_WILC_DEBUG       1
//Debug output redirection
#define CONF_WILC_PRINTF      TRACE_PRINTF

//RST pin (PB3)
#define CONF_WILC_RST_PIN     PIO_PB3
#define CONF_WILC_RST_PIO     PIOB
#define CONF_WILC_RST_ID_PIO  ID_PIOB

//CE pin (PA5)
#define CONF_WILC_CE_PIN      PIO_PA5
#define CONF_WILC_CE_PIO      PIOA
#define CONF_WILC_CE_ID_PIO   ID_PIOA

//WAKE pin (PB2)
#define CONF_WILC_WAKE_PIN    PIO_PB2
#define CONF_WILC_WAKE_PIO    PIOB
#define CONF_WILC_WAKE_ID_PIO ID_PIOB

//CS pin (PD25)
#define CONF_WILC_CS_PIN      PIO_PD25
#define CONF_WILC_CS_PIO      PIOD
#define CONF_WILC_CS_ID_PIO   ID_PIOD

//IRQ pin (PD28)
#define CONF_WILC_IRQ_PIN     PIO_PD28
#define CONF_WILC_IRQ_PIO     PIOD
#define CONF_WILC_IRQ_ID_PIO  ID_PIOD

//SCK pin (PD22)
#define CONF_WILC_SCK_PIN     PIO_PD22B_SPI0_SPCK

//MOSI pin (PD21)
#define CONF_WILC_MOSI_PIN    PIO_PD21B_SPI0_MOSI

//MISO pin (PD20)
#define CONF_WILC_MISO_PIN    PIO_PD20B_SPI0_MISO

//SPI instance
#define CONF_WILC_SPI         SPI0
#define CONF_WILC_SPI_ID      ID_SPI0
#define CONF_WILC_SPI_PIO     PIOD
#define CONF_WILC_SPI_ID_PIO  ID_PIOD

//SPI clock
#define CONF_WILC_SPI_CLOCK   48000000

//IRQ number
#define CONF_WILC_IRQn        PIOD_IRQn
//IRQ handler
#define CONF_WILC_IRQHandler  PIOD_Handler

//Interrupt priority grouping
#define CONF_WILC_IRQ_PRIORITY_GROUPING 4
//Interrupt group priority
#define CONF_WILC_IRQ_GROUP_PRIORITY    7
//Interrupt subpriority
#define CONF_WILC_IRQ_SUB_PRIORITY      0

//Forward function declaration
extern void wilc1000EventHook(uint8_t msgType, void *msg);

//Callback function that processes Wi-Fi event notifications
#define CONF_WILC_EVENT_HOOK(msgType, msg) wilc1000EventHook(msgType, msg)

#endif
