/**
 * @file wwd_buffer.h
 * @brief WICED network buffer management
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _WWD_BUFFER_H
#define _WWD_BUFFER_H

//Dependencies
#include "wwd_constants.h"
#include "wwd_network_constants.h"

typedef struct
{
   uint32_t used;
   wwd_interface_t interface;
   uint32_t size;
   uint32_t offset;
   uint8_t data[1518 + WICED_LINK_OVERHEAD_BELOW_ETHERNET_FRAME_MAX];
} WwdBuffer;

typedef WwdBuffer *wiced_buffer_t;

typedef struct
{
    void* internal_buffer;
    uint16_t buff_size;
} nons_buffer_init_t;

typedef void wiced_buffer_fifo_t;

#endif
