/**
 * @file mp3_decoder.h
 * @brief MP3 decoder task
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _MP3_DECODER_H
#define _MP3_DECODER_H

//Dependencies
#include "os_port.h"
#include "core/net.h"
#include "icecast/icecast_client.h"

//Stack size required to run the MP3 decoder
#ifndef MP3_DECODER_STACK_SIZE
   #define MP3_DECODER_STACK_SIZE 800
#elif (MP3_DECODER_STACK_SIZE < 1)
   #error MP3_DECODER_STACK_SIZE parameter is not valid
#endif

//Priority at which the MP3 decoder should run
#ifndef MP3_DECODER_PRIORITY
   #define MP3_DECODER_PRIORITY 2
#elif (MP3_DECODER_PRIORITY < 0)
   #error MP3_DECODER_PRIORITY parameter is not valid
#endif

//MP3 decoder related functions
error_t mp3DecoderStart(IcecastClientContext *icecastClientContext);
void mp3DecoderTask(void *param);

#endif
