/**
 * @file system_s7g2.c
 * @brief System configuration for Renesas Synergy S7G2 device
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#include "bsp_irq_cfg.h"
#include "s7g2.h"

//Event numbers
#define EVENT_PORT_IRQ0           0x001
#define EVENT_PORT_IRQ1           0x002
#define EVENT_PORT_IRQ2           0x003
#define EVENT_PORT_IRQ3           0x004
#define EVENT_PORT_IRQ4           0x005
#define EVENT_PORT_IRQ5           0x006
#define EVENT_PORT_IRQ6           0x007
#define EVENT_PORT_IRQ7           0x008
#define EVENT_PORT_IRQ8           0x009
#define EVENT_PORT_IRQ9           0x00A
#define EVENT_PORT_IRQ10          0x00B
#define EVENT_PORT_IRQ11          0x00C
#define EVENT_PORT_IRQ12          0x00D
#define EVENT_PORT_IRQ13          0x00E
#define EVENT_PORT_IRQ14          0x00F
#define EVENT_PORT_IRQ15          0x010
#define EVENT_DMAC0_INT           0x020
#define EVENT_DMAC1_INT           0x021
#define EVENT_DMAC2_INT           0x022
#define EVENT_DMAC3_INT           0x023
#define EVENT_DMAC4_INT           0x024
#define EVENT_DMAC5_INT           0x025
#define EVENT_DMAC6_INT           0x026
#define EVENT_DMAC7_INT           0x027
#define EVENT_DTC_COMPLETE        0x029
#define EVENT_ICU_SNZCANCEL       0x02D
#define EVENT_FCU_FIFERR          0x030
#define EVENT_FCU_FRDYI           0x031
#define EVENT_LVD_LVD1            0x038
#define EVENT_LVD_LVD2            0x039
#define EVENT_MOSC_STOP           0x03B
#define EVENT_SYSTEM_SNZREQ       0x03C
#define EVENT_AGT0_AGTI           0x040
#define EVENT_AGT0_AGTCMAI        0x041
#define EVENT_AGT0_AGTCMBI        0x042
#define EVENT_AGT1_AGTI           0x043
#define EVENT_AGT1_AGTCMAI        0x044
#define EVENT_AGT1_AGTCMBI        0x045
#define EVENT_IWDT_NMIUNDF        0x046
#define EVENT_WDT_NMIUNDF         0x047
#define EVENT_RTC_ALM             0x048
#define EVENT_RTC_PRD             0x049
#define EVENT_RTC_CUP             0x04A
#define EVENT_ADC120_ADI          0x04B
#define EVENT_ADC120_GBADI        0x04C
#define EVENT_ADC120_CMPAI        0x04D
#define EVENT_ADC120_CMPBI        0x04E
#define EVENT_ADC120_WCMPM        0x04F
#define EVENT_ADC120_WCMPUM       0x050
#define EVENT_ADC121_ADI          0x051
#define EVENT_ADC121_GBADI        0x052
#define EVENT_ADC121_CMPAI        0x053
#define EVENT_ADC121_CMPBI        0x054
#define EVENT_ADC121_WCMPM        0x055
#define EVENT_ADC121_WCMPUM       0x056
#define EVENT_ACMP_HS0            0x057
#define EVENT_ACMP_HS1            0x058
#define EVENT_ACMP_HS2            0x059
#define EVENT_ACMP_HS3            0x05A
#define EVENT_ACMP_HS4            0x05B
#define EVENT_ACMP_HS5            0x05C
#define EVENT_USBFS_D0FIFO        0x05F
#define EVENT_USBFS_D1FIFO        0x060
#define EVENT_USBFS_USBI          0x061
#define EVENT_USBFS_USBR          0x062
#define EVENT_IIC0_RXI            0x063
#define EVENT_IIC0_TXI            0x064
#define EVENT_IIC0_TEI            0x065
#define EVENT_IIC0_EEI            0x066
#define EVENT_IIC0_WUI            0x067
#define EVENT_IIC1_RXI            0x068
#define EVENT_IIC1_TXI            0x069
#define EVENT_IIC1_TEI            0x06A
#define EVENT_IIC1_EEI            0x06B
#define EVENT_IIC2_RXI            0x06D
#define EVENT_IIC2_TXI            0x06E
#define EVENT_IIC2_TEI            0x06F
#define EVENT_IIC2_EEI            0x070
#define EVENT_SSI0_SSITXI         0x072
#define EVENT_SSI0_SSIRXI         0x073
#define EVENT_SSI0_SSIF           0x075
#define EVENT_SSI1_SSIRT          0x078
#define EVENT_SSI1_SSIF           0x079
#define EVENT_SRC_IDEI            0x07A
#define EVENT_SRC_ODFI            0x07B
#define EVENT_SRC_OVFI            0x07C
#define EVENT_SRC_UDFI            0x07D
#define EVENT_SRC_CEFI            0x07E
#define EVENT_PDC_PCDFI           0x07F
#define EVENT_PDC_PCFEI           0x080
#define EVENT_PDC_PCERI           0x081
#define EVENT_CTSU_CTSUWR         0x082
#define EVENT_CTSU_CTSURD         0x083
#define EVENT_CTSU_CTSUFN         0x084
#define EVENT_KEY_INTKR           0x085
#define EVENT_DOC_DOPCI           0x086
#define EVENT_CAC_FERRI           0x087
#define EVENT_CAC_MENDI           0x088
#define EVENT_CAC_OVFI            0x089
#define EVENT_CAN0_ERS            0x08A
#define EVENT_CAN0_RXF            0x08B
#define EVENT_CAN0_TXF            0x08C
#define EVENT_CAN0_RXM            0x08D
#define EVENT_CAN0_TXM            0x08E
#define EVENT_CAN1_ERS            0x08F
#define EVENT_CAN1_RXF            0x090
#define EVENT_CAN1_TXF            0x091
#define EVENT_CAN1_RXM            0x092
#define EVENT_CAN1_TXM            0x093
#define EVENT_IOPORT_GROUP1       0x094
#define EVENT_IOPORT_GROUP2       0x095
#define EVENT_IOPORT_GROUP3       0x096
#define EVENT_IOPORT_GROUP4       0x097
#define EVENT_ELC_SWEVT0          0x098
#define EVENT_ELC_SWEVT1          0x099
#define EVENT_POEG_GROUP0         0x09A
#define EVENT_POEG_GROUP1         0x09B
#define EVENT_POEG_GROUP2         0x09C
#define EVENT_POEG_GROUP3         0x09D
#define EVENT_GPT0_CCMPA          0x0B0
#define EVENT_GPT0_CCMPB          0x0B1
#define EVENT_GPT0_CMPC           0x0B2
#define EVENT_GPT0_CMPD           0x0B3
#define EVENT_GPT0_CMPE           0x0B4
#define EVENT_GPT0_CMPF           0x0B5
#define EVENT_GPT0_OVF            0x0B6
#define EVENT_GPT0_UDF            0x0B7
#define EVENT_GPT0_ADTRGA         0x0B8
#define EVENT_GPT0_ADTRGB         0x0B9
#define EVENT_GPT1_CCMPA          0x0BA
#define EVENT_GPT1_CCMPB          0x0BB
#define EVENT_GPT1_CMPC           0x0BC
#define EVENT_GPT1_CMPD           0x0BD
#define EVENT_GPT1_CMPE           0x0BE
#define EVENT_GPT1_CMPF           0x0BF
#define EVENT_GPT1_OVF            0x0C0
#define EVENT_GPT1_UDF            0x0C1
#define EVENT_GPT1_ADTRGA         0x0C2
#define EVENT_GPT1_ADTRGB         0x0C3
#define EVENT_GPT2_CCMPA          0x0C4
#define EVENT_GPT2_CCMPB          0x0C5
#define EVENT_GPT2_CMPC           0x0C6
#define EVENT_GPT2_CMPD           0x0C7
#define EVENT_GPT2_CMPE           0x0C8
#define EVENT_GPT2_CMPF           0x0C9
#define EVENT_GPT2_OVF            0x0CA
#define EVENT_GPT2_UDF            0x0CB
#define EVENT_GPT2_ADTRGA         0x0CC
#define EVENT_GPT2_ADTRGB         0x0CD
#define EVENT_GPT3_CCMPA          0x0CE
#define EVENT_GPT3_CCMPB          0x0CF
#define EVENT_GPT3_CMPC           0x0D0
#define EVENT_GPT3_CMPD           0x0D1
#define EVENT_GPT3_CMPE           0x0D2
#define EVENT_GPT3_CMPF           0x0D3
#define EVENT_GPT3_OVF            0x0D4
#define EVENT_GPT3_UDF            0x0D5
#define EVENT_GPT3_ADTRGA         0x0D6
#define EVENT_GPT3_ADTRGB         0x0D7
#define EVENT_GPT4_CCMPA          0x0D8
#define EVENT_GPT4_CCMPB          0x0D9
#define EVENT_GPT4_CMPC           0x0DA
#define EVENT_GPT4_CMPD           0x0DB
#define EVENT_GPT4_CMPE           0x0DC
#define EVENT_GPT4_CMPF           0x0DD
#define EVENT_GPT4_OVF            0x0DE
#define EVENT_GPT4_UDF            0x0DF
#define EVENT_GPT4_ADTRGA         0x0E0
#define EVENT_GPT4_ADTRGB         0x0E1
#define EVENT_GPT5_CCMPA          0x0E2
#define EVENT_GPT5_CCMPB          0x0E3
#define EVENT_GPT5_CMPC           0x0E4
#define EVENT_GPT5_CMPD           0x0E5
#define EVENT_GPT5_CMPE           0x0E6
#define EVENT_GPT5_CMPF           0x0E7
#define EVENT_GPT5_OVF            0x0E8
#define EVENT_GPT5_UDF            0x0E9
#define EVENT_GPT5_ADTRGA         0x0EA
#define EVENT_GPT5_ADTRGB         0x0EB
#define EVENT_GPT6_CCMPA          0x0EC
#define EVENT_GPT6_CCMPB          0x0ED
#define EVENT_GPT6_CMPC           0x0EE
#define EVENT_GPT6_CMPD           0x0EF
#define EVENT_GPT6_CMPE           0x0F0
#define EVENT_GPT6_CMPF           0x0F1
#define EVENT_GPT6_OVF            0x0F2
#define EVENT_GPT6_UDF            0x0F3
#define EVENT_GPT6_ADTRGA         0x0F4
#define EVENT_GPT6_ADTRGB         0x0F5
#define EVENT_GPT7_CCMPA          0x0F6
#define EVENT_GPT7_CCMPB          0x0F7
#define EVENT_GPT7_CMPC           0x0F8
#define EVENT_GPT7_CMPD           0x0F9
#define EVENT_GPT7_CMPE           0x0FA
#define EVENT_GPT7_CMPF           0x0FB
#define EVENT_GPT7_OVF            0x0FC
#define EVENT_GPT7_UDF            0x0FD
#define EVENT_GPT7_ADTRGA         0x0FE
#define EVENT_GPT7_ADTRGB         0x0FF
#define EVENT_GPT8_CCMPA          0x100
#define EVENT_GPT8_CCMPB          0x101
#define EVENT_GPT8_CMPC           0x102
#define EVENT_GPT8_CMPD           0x103
#define EVENT_GPT8_CMPE           0x104
#define EVENT_GPT8_CMPF           0x105
#define EVENT_GPT8_OVF            0x106
#define EVENT_GPT8_UDF            0x107
#define EVENT_GPT9_CCMPA          0x10A
#define EVENT_GPT9_CCMPB          0x10B
#define EVENT_GPT9_CMPC           0x10C
#define EVENT_GPT9_CMPD           0x10D
#define EVENT_GPT9_CMPE           0x10E
#define EVENT_GPT9_CMPF           0x10F
#define EVENT_GPT9_OVF            0x110
#define EVENT_GPT9_UDF            0x111
#define EVENT_GPT10_CCMPA         0x114
#define EVENT_GPT10_CCMPB         0x115
#define EVENT_GPT10_CMPC          0x116
#define EVENT_GPT10_CMPD          0x117
#define EVENT_GPT10_CMPE          0x118
#define EVENT_GPT10_CMPF          0x119
#define EVENT_GPT10_OVF           0x11A
#define EVENT_GPT10_UDF           0x11B
#define EVENT_GPT11_CCMPA         0x11E
#define EVENT_GPT11_CCMPB         0x11F
#define EVENT_GPT11_CMPC          0x120
#define EVENT_GPT11_CMPD          0x121
#define EVENT_GPT11_CMPE          0x122
#define EVENT_GPT11_CMPF          0x123
#define EVENT_GPT11_OVF           0x124
#define EVENT_GPT11_UDF           0x125
#define EVENT_GPT12_CCMPA         0x128
#define EVENT_GPT12_CCMPB         0x129
#define EVENT_GPT12_CMPC          0x12A
#define EVENT_GPT12_CMPD          0x12B
#define EVENT_GPT12_CMPE          0x12C
#define EVENT_GPT12_CMPF          0x12D
#define EVENT_GPT12_OVF           0x12E
#define EVENT_GPT12_UDF           0x12F
#define EVENT_GPT13_CCMPA         0x132
#define EVENT_GPT13_CCMPB         0x133
#define EVENT_GPT13_CMPC          0x134
#define EVENT_GPT13_CMPD          0x135
#define EVENT_GPT13_CMPE          0x136
#define EVENT_GPT13_CMPF          0x137
#define EVENT_GPT13_OVF           0x138
#define EVENT_GPT13_UDF           0x139
#define EVENT_GPT_UVWEDGE         0x150
#define EVENT_ETHER_IPLS          0x160
#define EVENT_ETHER_MINT          0x161
#define EVENT_ETHER_PINT          0x162
#define EVENT_ETHER_EINT0         0x163
#define EVENT_ETHER_EINT1         0x164
#define EVENT_USBHS_D0FIFO        0x171
#define EVENT_USBHS_D1FIFO        0x172
#define EVENT_USBHS_USBIR         0x173
#define EVENT_SCI0_RXI            0x174
#define EVENT_SCI0_TXI            0x175
#define EVENT_SCI0_TEI            0x176
#define EVENT_SCI0_ERI            0x177
#define EVENT_SCI0_AM             0x178
#define EVENT_SCI0_RXI_OR_ERI     0x179
#define EVENT_SCI1_RXI            0x17A
#define EVENT_SCI1_TXI            0x17B
#define EVENT_SCI1_TEI            0x17C
#define EVENT_SCI1_ERI            0x17D
#define EVENT_SCI1_AM             0x17E
#define EVENT_SCI2_RXI            0x180
#define EVENT_SCI2_TXI            0x181
#define EVENT_SCI2_TEI            0x182
#define EVENT_SCI2_ERI            0x183
#define EVENT_SCI2_AM             0x184
#define EVENT_SCI3_RXI            0x186
#define EVENT_SCI3_TXI            0x187
#define EVENT_SCI3_TEI            0x188
#define EVENT_SCI3_ERI            0x189
#define EVENT_SCI3_AM             0x18A
#define EVENT_SCI4_RXI            0x18C
#define EVENT_SCI4_TXI            0x18D
#define EVENT_SCI4_TEI            0x18E
#define EVENT_SCI4_ERI            0x18F
#define EVENT_SCI4_AM             0x190
#define EVENT_SCI5_RXI            0x192
#define EVENT_SCI5_TXI            0x193
#define EVENT_SCI5_TEI            0x194
#define EVENT_SCI5_ERI            0x195
#define EVENT_SCI5_AM             0x196
#define EVENT_SCI6_RXI            0x198
#define EVENT_SCI6_TXI            0x199
#define EVENT_SCI6_TEI            0x19A
#define EVENT_SCI6_ERI            0x19B
#define EVENT_SCI6_AM             0x19C
#define EVENT_SCI7_RXI            0x19E
#define EVENT_SCI7_TXI            0x19F
#define EVENT_SCI7_TEI            0x1A0
#define EVENT_SCI7_ERI            0x1A1
#define EVENT_SCI7_AM             0x1A2
#define EVENT_SCI8_RXI            0x1A4
#define EVENT_SCI8_TXI            0x1A5
#define EVENT_SCI8_TEI            0x1A6
#define EVENT_SCI8_ERI            0x1A7
#define EVENT_SCI8_AM             0x1A8
#define EVENT_SCI9_RXI            0x1AA
#define EVENT_SCI9_TXI            0x1AB
#define EVENT_SCI9_TEI            0x1AC
#define EVENT_SCI9_ERI            0x1AD
#define EVENT_SCI9_AM             0x1AE
#define EVENT_SPI0_SPRI           0x1BC
#define EVENT_SPI0_SPTI           0x1BD
#define EVENT_SPI0_SPII           0x1BE
#define EVENT_SPI0_SPEI           0x1BF
#define EVENT_SPI0_SPTEND         0x1C0
#define EVENT_SPI1_SPRI           0x1C1
#define EVENT_SPI1_SPTI           0x1C2
#define EVENT_SPI1_SPII           0x1C3
#define EVENT_SPI1_SPEI           0x1C4
#define EVENT_SPI1_SPTEND         0x1C5
#define EVENT_QSPI_INTR           0x1C6
#define EVENT_SDHI_MMC0_ACCS      0x1C7
#define EVENT_SDHI_MMC0_SDIO      0x1C8
#define EVENT_SDHI_MMC0_CARD      0x1C9
#define EVENT_SDHI_MMC0_ODMSDBREQ 0x1CA
#define EVENT_SDHI_MMC1_ACCS      0x1CB
#define EVENT_SDHI_MMC1_SDIO      0x1CC
#define EVENT_SDHI_MMC1_CARD      0x1CD
#define EVENT_SDHI_MMC1_ODMSDBREQ 0x1CE
#define EVENT_GLCDC_VPOS          0x1FA
#define EVENT_GLCDC_L1UNDF        0x1FB
#define EVENT_GLCDC_L2UNDF        0x1FC
#define EVENT_DRW_IRQ             0x1FD
#define EVENT_JPEG_JEDI           0x1FE
#define EVENT_JPEG_JDTI           0x1FF

//System clock frequency (240MHz)
uint32_t SystemCoreClock = 240000000;


/**
 * @brief Setup the system clock
 **/

void SystemInit(void)
{
   //Enable FPU
#if (__FPU_PRESENT == 1) && (__FPU_USED == 1)
   SCB->CPACR |= ((3UL << 10 * 2) | (3UL << 11 * 2));
#endif

   //Redirect the desired events to the NVIC
#if (BSP_IRQ_CFG_PORT_IRQ0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ0_IRQn] = EVENT_PORT_IRQ0;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ1_IRQn] = EVENT_PORT_IRQ1;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ2_IRQn] = EVENT_PORT_IRQ2;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ3 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ3_IRQn] = EVENT_PORT_IRQ3;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ4 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ4_IRQn] = EVENT_PORT_IRQ4;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ5 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ5_IRQn] = EVENT_PORT_IRQ5;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ6 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ6_IRQn] = EVENT_PORT_IRQ6;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ7 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ7_IRQn] = EVENT_PORT_IRQ7;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ8 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ8_IRQn] = EVENT_PORT_IRQ8;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ9 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ9_IRQn] = EVENT_PORT_IRQ9;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ10 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ10_IRQn] = EVENT_PORT_IRQ10;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ11 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ11_IRQn] = EVENT_PORT_IRQ11;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ12 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ12_IRQn] = EVENT_PORT_IRQ12;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ13 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ13_IRQn] = EVENT_PORT_IRQ13;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ14 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ14_IRQn] = EVENT_PORT_IRQ14;
#endif
#if (BSP_IRQ_CFG_PORT_IRQ15 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PORT_IRQ15_IRQn] = EVENT_PORT_IRQ15;
#endif
#if (BSP_IRQ_CFG_DMAC0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC0_INT_IRQn] = EVENT_DMAC0_INT;
#endif
#if (BSP_IRQ_CFG_DMAC1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC1_INT_IRQn] = EVENT_DMAC1_INT;
#endif
#if (BSP_IRQ_CFG_DMAC2_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC2_INT_IRQn] = EVENT_DMAC2_INT;
#endif
#if (BSP_IRQ_CFG_DMAC3_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC3_INT_IRQn] = EVENT_DMAC3_INT;
#endif
#if (BSP_IRQ_CFG_DMAC4_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC4_INT_IRQn] = EVENT_DMAC4_INT;
#endif
#if (BSP_IRQ_CFG_DMAC5_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC5_INT_IRQn] = EVENT_DMAC5_INT;
#endif
#if (BSP_IRQ_CFG_DMAC6_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC6_INT_IRQn] = EVENT_DMAC6_INT;
#endif
#if (BSP_IRQ_CFG_DMAC7_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC7_INT_IRQn] = EVENT_DMAC7_INT;
#endif
#if (BSP_IRQ_CFG_DTC_COMPLETE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DTC_COMPLETE_IRQn] = EVENT_DTC_COMPLETE;
#endif
#if (BSP_IRQ_CFG_ICU_SNZCANCEL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_SNZCANCEL_IRQn] = EVENT_ICU_SNZCANCEL;
#endif
#if (BSP_IRQ_CFG_FCU_FIFERR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[FCU_FIFERR_IRQn] = EVENT_FCU_FIFERR;
#endif
#if (BSP_IRQ_CFG_FCU_FRDYI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[FCU_FRDYI_IRQn] = EVENT_FCU_FRDYI;
#endif
#if (BSP_IRQ_CFG_LVD_LVD1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[LVD_LVD1_IRQn] = EVENT_LVD_LVD1;
#endif
#if (BSP_IRQ_CFG_LVD_LVD2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[LVD_LVD2_IRQn] = EVENT_LVD_LVD2;
#endif
#if (BSP_IRQ_CFG_MOSC_STOP != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[MOSC_STOP_IRQn] = EVENT_MOSC_STOP;
#endif
#if (BSP_IRQ_CFG_SYSTEM_SNZREQ != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SYSTEM_SNZREQ_IRQn] = EVENT_SYSTEM_SNZREQ;
#endif
#if (BSP_IRQ_CFG_AGT0_AGTI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT0_AGTI_IRQn] = EVENT_AGT0_AGTI;
#endif
#if (BSP_IRQ_CFG_AGT0_AGTCMAI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT0_AGTCMAI_IRQn] = EVENT_AGT0_AGTCMAI;
#endif
#if (BSP_IRQ_CFG_AGT0_AGTCMBI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT0_AGTCMBI_IRQn] = EVENT_AGT0_AGTCMBI;
#endif
#if (BSP_IRQ_CFG_AGT1_AGTI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT1_AGTI_IRQn] = EVENT_AGT1_AGTI;
#endif
#if (BSP_IRQ_CFG_AGT1_AGTCMAI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT1_AGTCMAI_IRQn] = EVENT_AGT1_AGTCMAI;
#endif
#if (BSP_IRQ_CFG_AGT1_AGTCMBI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT1_AGTCMBI_IRQn] = EVENT_AGT1_AGTCMBI;
#endif
#if (BSP_IRQ_CFG_IWDT_NMIUNDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IWDT_NMIUNDF_IRQn] = EVENT_IWDT_NMIUNDF;
#endif
#if (BSP_IRQ_CFG_WDT_NMIUNDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[WDT_NMIUNDF_IRQn] = EVENT_WDT_NMIUNDF;
#endif
#if (BSP_IRQ_CFG_RTC_ALM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[RTC_ALM_IRQn] = EVENT_RTC_ALM;
#endif
#if (BSP_IRQ_CFG_RTC_PRD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[RTC_PRD_IRQn] = EVENT_RTC_PRD;
#endif
#if (BSP_IRQ_CFG_RTC_CUP != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[RTC_CUP_IRQn] = EVENT_RTC_CUP;
#endif
#if (BSP_IRQ_CFG_ADC120_ADI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC120_ADI_IRQn] = EVENT_ADC120_ADI;
#endif
#if (BSP_IRQ_CFG_ADC120_GBADI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC120_GBADI_IRQn] = EVENT_ADC120_GBADI;
#endif
#if (BSP_IRQ_CFG_ADC120_CMPAI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC120_CMPAI_IRQn] = EVENT_ADC120_CMPAI;
#endif
#if (BSP_IRQ_CFG_ADC120_CMPBI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC120_CMPBI_IRQn] = EVENT_ADC120_CMPBI;
#endif
#if (BSP_IRQ_CFG_ADC120_WCMPM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC120_WCMPM_IRQn] = EVENT_ADC120_WCMPM;
#endif
#if (BSP_IRQ_CFG_ADC120_WCMPUM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC120_WCMPUM_IRQn] = EVENT_ADC120_WCMPUM;
#endif
#if (BSP_IRQ_CFG_ADC121_ADI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC121_ADI_IRQn] = EVENT_ADC121_ADI;
#endif
#if (BSP_IRQ_CFG_ADC121_GBADI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC121_GBADI_IRQn] = EVENT_ADC121_GBADI;
#endif
#if (BSP_IRQ_CFG_ADC121_CMPAI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC121_CMPAI_IRQn] = EVENT_ADC121_CMPAI;
#endif
#if (BSP_IRQ_CFG_ADC121_CMPBI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC121_CMPBI_IRQn] = EVENT_ADC121_CMPBI;
#endif
#if (BSP_IRQ_CFG_ADC121_WCMPM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC121_WCMPM_IRQn] = EVENT_ADC121_WCMPM;
#endif
#if (BSP_IRQ_CFG_ADC121_WCMPUM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC121_WCMPUM_IRQn] = EVENT_ADC121_WCMPUM;
#endif
#if (BSP_IRQ_CFG_ACMP_HS0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ACMP_HS0_IRQn] = EVENT_ACMP_HS0;
#endif
#if (BSP_IRQ_CFG_ACMP_HS1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ACMP_HS1_IRQn] = EVENT_ACMP_HS1;
#endif
#if (BSP_IRQ_CFG_ACMP_HS2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ACMP_HS2_IRQn] = EVENT_ACMP_HS2;
#endif
#if (BSP_IRQ_CFG_ACMP_HS3 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ACMP_HS3_IRQn] = EVENT_ACMP_HS3;
#endif
#if (BSP_IRQ_CFG_ACMP_HS4 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ACMP_HS4_IRQn] = EVENT_ACMP_HS4;
#endif
#if (BSP_IRQ_CFG_ACMP_HS5 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ACMP_HS5_IRQn] = EVENT_ACMP_HS5;
#endif
#if (BSP_IRQ_CFG_USBFS_D0FIFO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_D0FIFO_IRQn] = EVENT_USBFS_D0FIFO;
#endif
#if (BSP_IRQ_CFG_USBFS_D1FIFO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_D1FIFO_IRQn] = EVENT_USBFS_D1FIFO;
#endif
#if (BSP_IRQ_CFG_USBFS_USBI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_USBI_IRQn] = EVENT_USBFS_USBI;
#endif
#if (BSP_IRQ_CFG_USBFS_USBR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_USBR_IRQn] = EVENT_USBFS_USBR;
#endif
#if (BSP_IRQ_CFG_IIC0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_RXI_IRQn] = EVENT_IIC0_RXI;
#endif
#if (BSP_IRQ_CFG_IIC0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_TXI_IRQn] = EVENT_IIC0_TXI;
#endif
#if (BSP_IRQ_CFG_IIC0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_TEI_IRQn] = EVENT_IIC0_TEI;
#endif
#if (BSP_IRQ_CFG_IIC0_EEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_EEI_IRQn] = EVENT_IIC0_EEI;
#endif
#if (BSP_IRQ_CFG_IIC0_WUI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_WUI_IRQn] = EVENT_IIC0_WUI;
#endif
#if (BSP_IRQ_CFG_IIC1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_RXI_IRQn] = EVENT_IIC1_RXI;
#endif
#if (BSP_IRQ_CFG_IIC1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_TXI_IRQn] = EVENT_IIC1_TXI;
#endif
#if (BSP_IRQ_CFG_IIC1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_TEI_IRQn] = EVENT_IIC1_TEI;
#endif
#if (BSP_IRQ_CFG_IIC1_EEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_EEI_IRQn] = EVENT_IIC1_EEI;
#endif
#if (BSP_IRQ_CFG_IIC2_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_RXI_IRQn] = EVENT_IIC2_RXI;
#endif
#if (BSP_IRQ_CFG_IIC2_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_TXI_IRQn] = EVENT_IIC2_TXI;
#endif
#if (BSP_IRQ_CFG_IIC2_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_TEI_IRQn] = EVENT_IIC2_TEI;
#endif
#if (BSP_IRQ_CFG_IIC2_EEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_EEI_IRQn] = EVENT_IIC2_EEI;
#endif
#if (BSP_IRQ_CFG_SSI0_SSITXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI0_SSITXI_IRQn] = EVENT_SSI0_SSITXI;
#endif
#if (BSP_IRQ_CFG_SSI0_SSIRXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI0_SSIRXI_IRQn] = EVENT_SSI0_SSIRXI;
#endif
#if (BSP_IRQ_CFG_SSI0_SSIF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI0_SSIF_IRQn] = EVENT_SSI0_SSIF;
#endif
#if (BSP_IRQ_CFG_SSI1_SSIRT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI1_SSIRT_IRQn] = EVENT_SSI1_SSIRT;
#endif
#if (BSP_IRQ_CFG_SSI1_SSIF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI1_SSIF_IRQn] = EVENT_SSI1_SSIF;
#endif
#if (BSP_IRQ_CFG_SRC_IDEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_IDEI_IRQn] = EVENT_SRC_IDEI;
#endif
#if (BSP_IRQ_CFG_SRC_ODFI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_ODFI_IRQn] = EVENT_SRC_ODFI;
#endif
#if (BSP_IRQ_CFG_SRC_OVFI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_OVFI_IRQn] = EVENT_SRC_OVFI;
#endif
#if (BSP_IRQ_CFG_SRC_UDFI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_UDFI_IRQn] = EVENT_SRC_UDFI;
#endif
#if (BSP_IRQ_CFG_SRC_CEFI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_CEFI_IRQn] = EVENT_SRC_CEFI;
#endif
#if (BSP_IRQ_CFG_PDC_PCDFI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PDC_PCDFI_IRQn] = EVENT_PDC_PCDFI;
#endif
#if (BSP_IRQ_CFG_PDC_PCFEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PDC_PCFEI_IRQn] = EVENT_PDC_PCFEI;
#endif
#if (BSP_IRQ_CFG_PDC_PCERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PDC_PCERI_IRQn] = EVENT_PDC_PCERI;
#endif
#if (BSP_IRQ_CFG_CTSU_CTSUWR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CTSU_CTSUWR_IRQn] = EVENT_CTSU_CTSUWR;
#endif
#if (BSP_IRQ_CFG_CTSU_CTSURD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CTSU_CTSURD_IRQn] = EVENT_CTSU_CTSURD;
#endif
#if (BSP_IRQ_CFG_CTSU_CTSUFN != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CTSU_CTSUFN_IRQn] = EVENT_CTSU_CTSUFN;
#endif
#if (BSP_IRQ_CFG_KEY_INTKR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[KEY_INTKR_IRQn] = EVENT_KEY_INTKR;
#endif
#if (BSP_IRQ_CFG_DOC_DOPCI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DOC_DOPCI_IRQn] = EVENT_DOC_DOPCI;
#endif
#if (BSP_IRQ_CFG_CAC_FERRI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAC_FERRI_IRQn] = EVENT_CAC_FERRI;
#endif
#if (BSP_IRQ_CFG_CAC_MENDI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAC_MENDI_IRQn] = EVENT_CAC_MENDI;
#endif
#if (BSP_IRQ_CFG_CAC_OVFI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAC_OVFI_IRQn] = EVENT_CAC_OVFI;
#endif
#if (BSP_IRQ_CFG_CAN0_ERS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_ERS_IRQn] = EVENT_CAN0_ERS;
#endif
#if (BSP_IRQ_CFG_CAN0_RXF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_RXF_IRQn] = EVENT_CAN0_RXF;
#endif
#if (BSP_IRQ_CFG_CAN0_TXF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_TXF_IRQn] = EVENT_CAN0_TXF;
#endif
#if (BSP_IRQ_CFG_CAN0_RXM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_RXM_IRQn] = EVENT_CAN0_RXM;
#endif
#if (BSP_IRQ_CFG_CAN0_TXM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_TXM_IRQn] = EVENT_CAN0_TXM;
#endif
#if (BSP_IRQ_CFG_CAN1_ERS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_ERS_IRQn] = EVENT_CAN1_ERS;
#endif
#if (BSP_IRQ_CFG_CAN1_RXF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_RXF_IRQn] = EVENT_CAN1_RXF;
#endif
#if (BSP_IRQ_CFG_CAN1_TXF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_TXF_IRQn] = EVENT_CAN1_TXF;
#endif
#if (BSP_IRQ_CFG_CAN1_RXM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_RXM_IRQn] = EVENT_CAN1_RXM;
#endif
#if (BSP_IRQ_CFG_CAN1_TXM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_TXM_IRQn] = EVENT_CAN1_TXM;
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_GROUP1_IRQn] = EVENT_IOPORT_GROUP1;
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_GROUP2_IRQn] = EVENT_IOPORT_GROUP2;
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP3 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_GROUP3_IRQn] = EVENT_IOPORT_GROUP3;
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP4 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_GROUP4_IRQn] = EVENT_IOPORT_GROUP4;
#endif
#if (BSP_IRQ_CFG_ELC_SWEVT0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ELC_SWEVT0_IRQn] = EVENT_ELC_SWEVT0;
#endif
#if (BSP_IRQ_CFG_ELC_SWEVT1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ELC_SWEVT1_IRQn] = EVENT_ELC_SWEVT1;
#endif
#if (BSP_IRQ_CFG_POEG_GROUP0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG_GROUP0_IRQn] = EVENT_POEG_GROUP0;
#endif
#if (BSP_IRQ_CFG_POEG_GROUP1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG_GROUP1_IRQn] = EVENT_POEG_GROUP1;
#endif
#if (BSP_IRQ_CFG_POEG_GROUP2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG_GROUP2_IRQn] = EVENT_POEG_GROUP2;
#endif
#if (BSP_IRQ_CFG_POEG_GROUP3 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG_GROUP3_IRQn] = EVENT_POEG_GROUP3;
#endif
#if (BSP_IRQ_CFG_GPT0_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CCMPA_IRQn] = EVENT_GPT0_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT0_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CCMPB_IRQn] = EVENT_GPT0_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT0_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CMPC_IRQn] = EVENT_GPT0_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT0_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CMPD_IRQn] = EVENT_GPT0_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT0_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CMPE_IRQn] = EVENT_GPT0_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT0_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CMPF_IRQn] = EVENT_GPT0_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT0_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_OVF_IRQn] = EVENT_GPT0_OVF;
#endif
#if (BSP_IRQ_CFG_GPT0_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_UDF_IRQn] = EVENT_GPT0_UDF;
#endif
#if (BSP_IRQ_CFG_GPT0_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_ADTRGA_IRQn] = EVENT_GPT0_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT0_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_ADTRGB_IRQn] = EVENT_GPT0_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT1_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CCMPA_IRQn] = EVENT_GPT1_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT1_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CCMPB_IRQn] = EVENT_GPT1_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT1_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CMPC_IRQn] = EVENT_GPT1_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT1_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CMPD_IRQn] = EVENT_GPT1_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT1_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CMPE_IRQn] = EVENT_GPT1_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT1_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CMPF_IRQn] = EVENT_GPT1_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT1_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_OVF_IRQn] = EVENT_GPT1_OVF;
#endif
#if (BSP_IRQ_CFG_GPT1_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_UDF_IRQn] = EVENT_GPT1_UDF;
#endif
#if (BSP_IRQ_CFG_GPT1_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_ADTRGA_IRQn] = EVENT_GPT1_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT1_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_ADTRGB_IRQn] = EVENT_GPT1_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT2_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CCMPA_IRQn] = EVENT_GPT2_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT2_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CCMPB_IRQn] = EVENT_GPT2_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT2_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CMPC_IRQn] = EVENT_GPT2_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT2_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CMPD_IRQn] = EVENT_GPT2_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT2_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CMPE_IRQn] = EVENT_GPT2_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT2_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CMPF_IRQn] = EVENT_GPT2_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT2_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_OVF_IRQn] = EVENT_GPT2_OVF;
#endif
#if (BSP_IRQ_CFG_GPT2_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_UDF_IRQn] = EVENT_GPT2_UDF;
#endif
#if (BSP_IRQ_CFG_GPT2_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_ADTRGA_IRQn] = EVENT_GPT2_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT2_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_ADTRGB_IRQn] = EVENT_GPT2_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT3_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CCMPA_IRQn] = EVENT_GPT3_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT3_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CCMPB_IRQn] = EVENT_GPT3_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT3_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CMPC_IRQn] = EVENT_GPT3_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT3_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CMPD_IRQn] = EVENT_GPT3_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT3_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CMPE_IRQn] = EVENT_GPT3_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT3_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CMPF_IRQn] = EVENT_GPT3_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT3_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_OVF_IRQn] = EVENT_GPT3_OVF;
#endif
#if (BSP_IRQ_CFG_GPT3_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_UDF_IRQn] = EVENT_GPT3_UDF;
#endif
#if (BSP_IRQ_CFG_GPT3_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_ADTRGA_IRQn] = EVENT_GPT3_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT3_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_ADTRGB_IRQn] = EVENT_GPT3_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT4_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CCMPA_IRQn] = EVENT_GPT4_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT4_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CCMPB_IRQn] = EVENT_GPT4_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT4_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CMPC_IRQn] = EVENT_GPT4_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT4_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CMPD_IRQn] = EVENT_GPT4_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT4_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CMPE_IRQn] = EVENT_GPT4_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT4_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CMPF_IRQn] = EVENT_GPT4_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT4_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_OVF_IRQn] = EVENT_GPT4_OVF;
#endif
#if (BSP_IRQ_CFG_GPT4_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_UDF_IRQn] = EVENT_GPT4_UDF;
#endif
#if (BSP_IRQ_CFG_GPT4_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_ADTRGA_IRQn] = EVENT_GPT4_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT4_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_ADTRGB_IRQn] = EVENT_GPT4_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT5_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CCMPA_IRQn] = EVENT_GPT5_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT5_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CCMPB_IRQn] = EVENT_GPT5_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT5_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CMPC_IRQn] = EVENT_GPT5_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT5_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CMPD_IRQn] = EVENT_GPT5_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT5_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CMPE_IRQn] = EVENT_GPT5_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT5_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CMPF_IRQn] = EVENT_GPT5_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT5_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_OVF_IRQn] = EVENT_GPT5_OVF;
#endif
#if (BSP_IRQ_CFG_GPT5_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_UDF_IRQn] = EVENT_GPT5_UDF;
#endif
#if (BSP_IRQ_CFG_GPT5_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_ADTRGA_IRQn] = EVENT_GPT5_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT5_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_ADTRGB_IRQn] = EVENT_GPT5_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT6_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CCMPA_IRQn] = EVENT_GPT6_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT6_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CCMPB_IRQn] = EVENT_GPT6_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT6_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CMPC_IRQn] = EVENT_GPT6_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT6_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CMPD_IRQn] = EVENT_GPT6_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT6_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CMPE_IRQn] = EVENT_GPT6_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT6_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CMPF_IRQn] = EVENT_GPT6_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT6_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_OVF_IRQn] = EVENT_GPT6_OVF;
#endif
#if (BSP_IRQ_CFG_GPT6_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_UDF_IRQn] = EVENT_GPT6_UDF;
#endif
#if (BSP_IRQ_CFG_GPT6_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_ADTRGA_IRQn] = EVENT_GPT6_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT6_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_ADTRGB_IRQn] = EVENT_GPT6_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT7_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CCMPA_IRQn] = EVENT_GPT7_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT7_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CCMPB_IRQn] = EVENT_GPT7_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT7_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CMPC_IRQn] = EVENT_GPT7_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT7_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CMPD_IRQn] = EVENT_GPT7_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT7_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CMPE_IRQn] = EVENT_GPT7_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT7_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CMPF_IRQn] = EVENT_GPT7_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT7_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_OVF_IRQn] = EVENT_GPT7_OVF;
#endif
#if (BSP_IRQ_CFG_GPT7_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_UDF_IRQn] = EVENT_GPT7_UDF;
#endif
#if (BSP_IRQ_CFG_GPT7_ADTRGA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_ADTRGA_IRQn] = EVENT_GPT7_ADTRGA;
#endif
#if (BSP_IRQ_CFG_GPT7_ADTRGB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_ADTRGB_IRQn] = EVENT_GPT7_ADTRGB;
#endif
#if (BSP_IRQ_CFG_GPT8_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CCMPA_IRQn] = EVENT_GPT8_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT8_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CCMPB_IRQn] = EVENT_GPT8_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT8_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CMPC_IRQn] = EVENT_GPT8_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT8_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CMPD_IRQn] = EVENT_GPT8_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT8_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CMPE_IRQn] = EVENT_GPT8_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT8_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CMPF_IRQn] = EVENT_GPT8_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT8_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_OVF_IRQn] = EVENT_GPT8_OVF;
#endif
#if (BSP_IRQ_CFG_GPT8_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_UDF_IRQn] = EVENT_GPT8_UDF;
#endif
#if (BSP_IRQ_CFG_GPT9_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CCMPA_IRQn] = EVENT_GPT9_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT9_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CCMPB_IRQn] = EVENT_GPT9_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT9_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CMPC_IRQn] = EVENT_GPT9_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT9_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CMPD_IRQn] = EVENT_GPT9_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT9_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CMPE_IRQn] = EVENT_GPT9_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT9_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CMPF_IRQn] = EVENT_GPT9_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT9_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_OVF_IRQn] = EVENT_GPT9_OVF;
#endif
#if (BSP_IRQ_CFG_GPT9_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_UDF_IRQn] = EVENT_GPT9_UDF;
#endif
#if (BSP_IRQ_CFG_GPT10_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CCMPA_IRQn] = EVENT_GPT10_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT10_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CCMPB_IRQn] = EVENT_GPT10_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT10_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CMPC_IRQn] = EVENT_GPT10_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT10_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CMPD_IRQn] = EVENT_GPT10_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT10_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CMPE_IRQn] = EVENT_GPT10_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT10_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CMPF_IRQn] = EVENT_GPT10_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT10_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_OVF_IRQn] = EVENT_GPT10_OVF;
#endif
#if (BSP_IRQ_CFG_GPT10_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_UDF_IRQn] = EVENT_GPT10_UDF;
#endif
#if (BSP_IRQ_CFG_GPT11_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CCMPA_IRQn] = EVENT_GPT11_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT11_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CCMPB_IRQn] = EVENT_GPT11_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT11_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CMPC_IRQn] = EVENT_GPT11_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT11_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CMPD_IRQn] = EVENT_GPT11_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT11_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CMPE_IRQn] = EVENT_GPT11_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT11_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CMPF_IRQn] = EVENT_GPT11_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT11_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_OVF_IRQn] = EVENT_GPT11_OVF;
#endif
#if (BSP_IRQ_CFG_GPT11_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_UDF_IRQn] = EVENT_GPT11_UDF;
#endif
#if (BSP_IRQ_CFG_GPT12_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CCMPA_IRQn] = EVENT_GPT12_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT12_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CCMPB_IRQn] = EVENT_GPT12_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT12_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CMPC_IRQn] = EVENT_GPT12_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT12_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CMPD_IRQn] = EVENT_GPT12_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT12_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CMPE_IRQn] = EVENT_GPT12_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT12_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CMPF_IRQn] = EVENT_GPT12_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT12_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_OVF_IRQn] = EVENT_GPT12_OVF;
#endif
#if (BSP_IRQ_CFG_GPT12_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_UDF_IRQn] = EVENT_GPT12_UDF;
#endif
#if (BSP_IRQ_CFG_GPT13_CCMPA != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CCMPA_IRQn] = EVENT_GPT13_CCMPA;
#endif
#if (BSP_IRQ_CFG_GPT13_CCMPB != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CCMPB_IRQn] = EVENT_GPT13_CCMPB;
#endif
#if (BSP_IRQ_CFG_GPT13_CMPC != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CMPC_IRQn] = EVENT_GPT13_CMPC;
#endif
#if (BSP_IRQ_CFG_GPT13_CMPD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CMPD_IRQn] = EVENT_GPT13_CMPD;
#endif
#if (BSP_IRQ_CFG_GPT13_CMPE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CMPE_IRQn] = EVENT_GPT13_CMPE;
#endif
#if (BSP_IRQ_CFG_GPT13_CMPF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CMPF_IRQn] = EVENT_GPT13_CMPF;
#endif
#if (BSP_IRQ_CFG_GPT13_OVF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_OVF_IRQn] = EVENT_GPT13_OVF;
#endif
#if (BSP_IRQ_CFG_GPT13_UDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_UDF_IRQn] = EVENT_GPT13_UDF;
#endif
#if (BSP_IRQ_CFG_GPT_UVWEDGE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT_UVWEDGE_IRQn] = EVENT_GPT_UVWEDGE;
#endif
#if (BSP_IRQ_CFG_ETHER_IPLS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ETHER_IPLS_IRQn] = EVENT_ETHER_IPLS;
#endif
#if (BSP_IRQ_CFG_ETHER_MINT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ETHER_MINT_IRQn] = EVENT_ETHER_MINT;
#endif
#if (BSP_IRQ_CFG_ETHER_PINT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ETHER_PINT_IRQn] = EVENT_ETHER_PINT;
#endif
#if (BSP_IRQ_CFG_ETHER_EINT0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ETHER_EINT0_IRQn] = EVENT_ETHER_EINT0;
#endif
#if (BSP_IRQ_CFG_ETHER_EINT1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ETHER_EINT1_IRQn] = EVENT_ETHER_EINT1;
#endif
#if (BSP_IRQ_CFG_USBHS_D0FIFO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBHS_D0FIFO_IRQn] = EVENT_USBHS_D0FIFO;
#endif
#if (BSP_IRQ_CFG_USBHS_D1FIFO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBHS_D1FIFO_IRQn] = EVENT_USBHS_D1FIFO;
#endif
#if (BSP_IRQ_CFG_USBHS_USBIR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBHS_USBIR_IRQn] = EVENT_USBHS_USBIR;
#endif
#if (BSP_IRQ_CFG_SCI0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_RXI_IRQn] = EVENT_SCI0_RXI;
#endif
#if (BSP_IRQ_CFG_SCI0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_TXI_IRQn] = EVENT_SCI0_TXI;
#endif
#if (BSP_IRQ_CFG_SCI0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_TEI_IRQn] = EVENT_SCI0_TEI;
#endif
#if (BSP_IRQ_CFG_SCI0_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_ERI_IRQn] = EVENT_SCI0_ERI;
#endif
#if (BSP_IRQ_CFG_SCI0_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_AM_IRQn] = EVENT_SCI0_AM;
#endif
#if (BSP_IRQ_CFG_SCI0_RXI_OR_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_RXI_OR_ERI_IRQn] = EVENT_SCI0_RXI_OR_ERI;
#endif
#if (BSP_IRQ_CFG_SCI1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_RXI_IRQn] = EVENT_SCI1_RXI;
#endif
#if (BSP_IRQ_CFG_SCI1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_TXI_IRQn] = EVENT_SCI1_TXI;
#endif
#if (BSP_IRQ_CFG_SCI1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_TEI_IRQn] = EVENT_SCI1_TEI;
#endif
#if (BSP_IRQ_CFG_SCI1_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_ERI_IRQn] = EVENT_SCI1_ERI;
#endif
#if (BSP_IRQ_CFG_SCI1_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_AM_IRQn] = EVENT_SCI1_AM;
#endif
#if (BSP_IRQ_CFG_SCI2_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_RXI_IRQn] = EVENT_SCI2_RXI;
#endif
#if (BSP_IRQ_CFG_SCI2_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_TXI_IRQn] = EVENT_SCI2_TXI;
#endif
#if (BSP_IRQ_CFG_SCI2_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_TEI_IRQn] = EVENT_SCI2_TEI;
#endif
#if (BSP_IRQ_CFG_SCI2_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_ERI_IRQn] = EVENT_SCI2_ERI;
#endif
#if (BSP_IRQ_CFG_SCI2_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_AM_IRQn] = EVENT_SCI2_AM;
#endif
#if (BSP_IRQ_CFG_SCI3_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_RXI_IRQn] = EVENT_SCI3_RXI;
#endif
#if (BSP_IRQ_CFG_SCI3_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_TXI_IRQn] = EVENT_SCI3_TXI;
#endif
#if (BSP_IRQ_CFG_SCI3_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_TEI_IRQn] = EVENT_SCI3_TEI;
#endif
#if (BSP_IRQ_CFG_SCI3_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_ERI_IRQn] = EVENT_SCI3_ERI;
#endif
#if (BSP_IRQ_CFG_SCI3_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_AM_IRQn] = EVENT_SCI3_AM;
#endif
#if (BSP_IRQ_CFG_SCI4_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_RXI_IRQn] = EVENT_SCI4_RXI;
#endif
#if (BSP_IRQ_CFG_SCI4_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_TXI_IRQn] = EVENT_SCI4_TXI;
#endif
#if (BSP_IRQ_CFG_SCI4_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_TEI_IRQn] = EVENT_SCI4_TEI;
#endif
#if (BSP_IRQ_CFG_SCI4_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_ERI_IRQn] = EVENT_SCI4_ERI;
#endif
#if (BSP_IRQ_CFG_SCI4_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_AM_IRQn] = EVENT_SCI4_AM;
#endif
#if (BSP_IRQ_CFG_SCI5_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_RXI_IRQn] = EVENT_SCI5_RXI;
#endif
#if (BSP_IRQ_CFG_SCI5_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_TXI_IRQn] = EVENT_SCI5_TXI;
#endif
#if (BSP_IRQ_CFG_SCI5_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_TEI_IRQn] = EVENT_SCI5_TEI;
#endif
#if (BSP_IRQ_CFG_SCI5_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_ERI_IRQn] = EVENT_SCI5_ERI;
#endif
#if (BSP_IRQ_CFG_SCI5_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_AM_IRQn] = EVENT_SCI5_AM;
#endif
#if (BSP_IRQ_CFG_SCI6_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_RXI_IRQn] = EVENT_SCI6_RXI;
#endif
#if (BSP_IRQ_CFG_SCI6_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_TXI_IRQn] = EVENT_SCI6_TXI;
#endif
#if (BSP_IRQ_CFG_SCI6_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_TEI_IRQn] = EVENT_SCI6_TEI;
#endif
#if (BSP_IRQ_CFG_SCI6_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_ERI_IRQn] = EVENT_SCI6_ERI;
#endif
#if (BSP_IRQ_CFG_SCI6_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_AM_IRQn] = EVENT_SCI6_AM;
#endif
#if (BSP_IRQ_CFG_SCI7_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_RXI_IRQn] = EVENT_SCI7_RXI;
#endif
#if (BSP_IRQ_CFG_SCI7_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_TXI_IRQn] = EVENT_SCI7_TXI;
#endif
#if (BSP_IRQ_CFG_SCI7_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_TEI_IRQn] = EVENT_SCI7_TEI;
#endif
#if (BSP_IRQ_CFG_SCI7_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_ERI_IRQn] = EVENT_SCI7_ERI;
#endif
#if (BSP_IRQ_CFG_SCI7_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_AM_IRQn] = EVENT_SCI7_AM;
#endif
#if (BSP_IRQ_CFG_SCI8_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_RXI_IRQn] = EVENT_SCI8_RXI;
#endif
#if (BSP_IRQ_CFG_SCI8_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_TXI_IRQn] = EVENT_SCI8_TXI;
#endif
#if (BSP_IRQ_CFG_SCI8_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_TEI_IRQn] = EVENT_SCI8_TEI;
#endif
#if (BSP_IRQ_CFG_SCI8_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_ERI_IRQn] = EVENT_SCI8_ERI;
#endif
#if (BSP_IRQ_CFG_SCI8_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_AM_IRQn] = EVENT_SCI8_AM;
#endif
#if (BSP_IRQ_CFG_SCI9_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_RXI_IRQn] = EVENT_SCI9_RXI;
#endif
#if (BSP_IRQ_CFG_SCI9_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_TXI_IRQn] = EVENT_SCI9_TXI;
#endif
#if (BSP_IRQ_CFG_SCI9_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_TEI_IRQn] = EVENT_SCI9_TEI;
#endif
#if (BSP_IRQ_CFG_SCI9_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_ERI_IRQn] = EVENT_SCI9_ERI;
#endif
#if (BSP_IRQ_CFG_SCI9_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_AM_IRQn] = EVENT_SCI9_AM;
#endif
#if (BSP_IRQ_CFG_SPI0_SPRI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_SPRI_IRQn] = EVENT_SPI0_SPRI;
#endif
#if (BSP_IRQ_CFG_SPI0_SPTI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_SPTI_IRQn] = EVENT_SPI0_SPTI;
#endif
#if (BSP_IRQ_CFG_SPI0_SPII != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_SPII_IRQn] = EVENT_SPI0_SPII;
#endif
#if (BSP_IRQ_CFG_SPI0_SPEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_SPEI_IRQn] = EVENT_SPI0_SPEI;
#endif
#if (BSP_IRQ_CFG_SPI0_SPTEND != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_SPTEND_IRQn] = EVENT_SPI0_SPTEND;
#endif
#if (BSP_IRQ_CFG_SPI1_SPRI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_SPRI_IRQn] = EVENT_SPI1_SPRI;
#endif
#if (BSP_IRQ_CFG_SPI1_SPTI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_SPTI_IRQn] = EVENT_SPI1_SPTI;
#endif
#if (BSP_IRQ_CFG_SPI1_SPII != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_SPII_IRQn] = EVENT_SPI1_SPII;
#endif
#if (BSP_IRQ_CFG_SPI1_SPEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_SPEI_IRQn] = EVENT_SPI1_SPEI;
#endif
#if (BSP_IRQ_CFG_SPI1_SPTEND != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_SPTEND_IRQn] = EVENT_SPI1_SPTEND;
#endif
#if (BSP_IRQ_CFG_QSPI_INTR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[QSPI_INTR_IRQn] = EVENT_QSPI_INTR;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_ACCS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC0_ACCS_IRQn] = EVENT_SDHI_MMC0_ACCS;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_SDIO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC0_SDIO_IRQn] = EVENT_SDHI_MMC0_SDIO;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_CARD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC0_CARD_IRQn] = EVENT_SDHI_MMC0_CARD;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_ODMSDBREQ != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC0_ODMSDBREQ_IRQn] = EVENT_SDHI_MMC0_ODMSDBREQ;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_ACCS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC1_ACCS_IRQn] = EVENT_SDHI_MMC1_ACCS;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_SDIO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC1_SDIO_IRQn] = EVENT_SDHI_MMC1_SDIO;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_CARD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC1_CARD_IRQn] = EVENT_SDHI_MMC1_CARD;
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_ODMSDBREQ != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHI_MMC1_ODMSDBREQ_IRQn] = EVENT_SDHI_MMC1_ODMSDBREQ;
#endif
#if (BSP_IRQ_CFG_GLCDC_VPOS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GLCDC_VPOS_IRQn] = EVENT_GLCDC_VPOS;
#endif
#if (BSP_IRQ_CFG_GLCDC_L1UNDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GLCDC_L1UNDF_IRQn] = EVENT_GLCDC_L1UNDF;
#endif
#if (BSP_IRQ_CFG_GLCDC_L2UNDF != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GLCDC_L2UNDF_IRQn] = EVENT_GLCDC_L2UNDF;
#endif
#if (BSP_IRQ_CFG_DRW_IRQ != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DRW_IRQ_IRQn] = EVENT_DRW_IRQ;
#endif
#if (BSP_IRQ_CFG_JPEG_JEDI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[JPEG_JEDI_IRQn] = EVENT_JPEG_JEDI;
#endif
#if (BSP_IRQ_CFG_JPEG_JDTI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[JPEG_JDTI_IRQn] = EVENT_JPEG_JDTI;
#endif

   //Disable write protection
   R_SRAM->RAMPRCR = 0xF1;

   //Set RAM wait states
   R_SRAM->RAMWTSC_b.SRAM0WTEN = 1;
   R_SRAM->RAMWTSC_b.SRAM1WTEN = 1;
   R_SRAM->RAMWTSC_b.SRAMHSWTEN = 1;

   //Enable write protection
   R_SRAM->RAMPRCR = 0xF0;

   //Set ROM wait states
   R_ROMC->ROMWT_b.ROMWT = 2;

   //Disable write protection
   R_SYSTEM->PRCR = 0xA50F;

   //Select main clock
   R_SYSTEM->MOMCR_b.MOSEL = 0;
   //Set main clock oscillator drive capability (20 to 24MHz)
   R_SYSTEM->MOMCR_b.MODRV0 = 0;
   //Start main clock operation
   R_SYSTEM->MOSCCR_b.MOSTP = 0;

   //Wait for the main clock to stabilize
   while(!R_SYSTEM->OSCSF_b.MOSCSF);

   //Main clock is used as PLL source
   R_SYSTEM->PLLCCR_b.PLLSRCSEL = 0;
   //Configure PLL input division ratio (/1)
   R_SYSTEM->PLLCCR_b.PLIDIV = 0;
   //Configure PLL multiplication ratio (x10)
   R_SYSTEM->PLLCCR_b.PLLMUL = 19;
   //Start PLL
   R_SYSTEM->PLLCR_b.PLLSTP = 0;

   //Wait for the PLL to stabilize
   while(!R_SYSTEM->OSCSF_b.PLLSF);

   //Set FCK clock divisor (1/4)
   R_SYSTEM->SCKDIVCR_b.FCK = 2;
   //Set ICK clock divisor (1/1)
   R_SYSTEM->SCKDIVCR_b.ICK = 0;
   //Set BCK clock divisor (1/2)
   R_SYSTEM->SCKDIVCR_b.BCK = 1;
   //Set PCKA clock divisor (1/2)
   R_SYSTEM->SCKDIVCR_b.PCKA = 1;
   //Set PCKB clock divisor (1/4)
   R_SYSTEM->SCKDIVCR_b.PCKB = 2;
   //Set PCKC clock divisor (1/4)
   R_SYSTEM->SCKDIVCR_b.PCKC = 2;
   //Set PCKD clock divisor (1/2)
   R_SYSTEM->SCKDIVCR_b.PCKD = 1;
   //Set ULCK clock divisor (1/5)
   R_SYSTEM->SCKDIVCR2_b.UCK = 4;

   //Switch from MOCO clock to PLL
   R_SYSTEM->SCKSCR_b.CKSEL = 5;

   //Enable write protection
   R_SYSTEM->PRCR = 0xA500;
}


/**
 * @brief Update the variable SystemCoreClock
 **/

void SystemCoreClockUpdate(void)
{
}
