/**
 * @file dmac0.h
 * @brief DMAC (Direct Access Memory Controller)
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _DMAC0_H
#define _DMAC0_H

//Dependencies
#include "os_port.h"

//DMA channel 0 interrupt priority
#ifndef DMAC0_IRQ_PRIORITY
   #define DMAC0_IRQ_PRIORITY 25
#elif (DMAC0_IRQ_PRIORITY < 0)
   #error DMAC0_IRQ_PRIORITY parameter is not valid
#endif

//DMAC0 related functions
void dmac0Init(void);

void dmac0SetNext0(const void *srcAddr, const void *destAddr, size_t byteCount);
void dmac0SetNext1(const void *srcAddr, const void *destAddr, size_t byteCount);

void dmac0Start(void);
void dmac0Stop(void);

void dmac0EnableIrq(void);
void dmac0DisableIrq(void);

void dmac0IrqHandler(uint32_t int_sense);

#endif
