/**
 * @file private_mib_module.c
 * @brief Private MIB module
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

//Switch to the appropriate trace level
#define TRACE_LEVEL SNMP_TRACE_LEVEL

//Dependencies
#include "core/net.h"
#include "mibs/mib_common.h"
#include "private_mib_module.h"
#include "private_mib_impl.h"
#include "core/crypto.h"
#include "encoding/asn1.h"
#include "encoding/oid.h"
#include "debug.h"


/**
 * @brief Private MIB base
 **/

PrivateMibBase privateMibBase;


/**
 * @brief Private MIB objects
 **/

const MibObject privateMibObjects[] =
{
   //testString object (1.3.6.1.4.1.8072.9999.9999.123.1.1)
   {
      "testString",
      {43, 6, 1, 4, 1, 191, 8, 206, 15, 206, 15, 123, 1, 1},
      14,
      ASN1_CLASS_UNIVERSAL,
      ASN1_TYPE_OCTET_STRING,
      MIB_ACCESS_READ_WRITE,
      &privateMibBase.testString,
      &privateMibBase.testStringLen,
      PRIVATE_MIB_TEST_STRING_SIZE,
      NULL,
      NULL,
      NULL
   },
   //testInteger object (1.3.6.1.4.1.8072.9999.9999.123.1.2)
   {
      "testInteger",
      {43, 6, 1, 4, 1, 191, 8, 206, 15, 206, 15, 123, 1, 2},
      14,
      ASN1_CLASS_UNIVERSAL,
      ASN1_TYPE_INTEGER,
      MIB_ACCESS_READ_WRITE,
      &privateMibBase.testInteger,
      NULL,
      sizeof(int32_t),
      NULL,
      NULL,
      NULL
   },
   //currentTime object (1.3.6.1.4.1.8072.9999.9999.123.1.3)
   {
      "currentTime",
      {43, 6, 1, 4, 1, 191, 8, 206, 15, 206, 15, 123, 1, 3},
      14,
      ASN1_CLASS_APPLICATION,
      MIB_TYPE_TIME_TICKS,
      MIB_ACCESS_READ_ONLY,
      NULL,
      NULL,
      sizeof(uint32_t),
      NULL,
      privateMibGetCurrentTime,
      NULL
   },
   //ledCount object (1.3.6.1.4.1.8072.9999.9999.123.2.1)
   {
      "ledCount",
      {43, 6, 1, 4, 1, 191, 8, 206, 15, 206, 15, 123, 2, 1},
      14,
      ASN1_CLASS_UNIVERSAL,
      ASN1_TYPE_INTEGER,
      MIB_ACCESS_READ_ONLY,
      &privateMibBase.ledCount,
      NULL,
      sizeof(int32_t),
      NULL,
      NULL,
      NULL
   },
   //ledColor object (1.3.6.1.4.1.8072.9999.9999.123.2.2.1.2)
   {
      "ledColor",
      {43, 6, 1, 4, 1, 191, 8, 206, 15, 206, 15, 123, 2, 2, 1, 2},
      16,
      ASN1_CLASS_UNIVERSAL,
      ASN1_TYPE_OCTET_STRING,
      MIB_ACCESS_READ_ONLY,
      NULL,
      NULL,
      PRIVATE_MIB_LED_COLOR_SIZE,
      NULL,
      privateMibGetLedEntry,
      privateMibGetNextLedEntry
   },
   //ledState object (1.3.6.1.4.1.8072.9999.9999.123.2.2.1.3)
   {
      "ledState",
      {43, 6, 1, 4, 1, 191, 8, 206, 15, 206, 15, 123, 2, 2, 1, 3},
      16,
      ASN1_CLASS_UNIVERSAL,
      ASN1_TYPE_INTEGER,
      MIB_ACCESS_READ_WRITE,
      NULL,
      NULL,
      sizeof(int32_t),
      privateMibSetLedEntry,
      privateMibGetLedEntry,
      privateMibGetNextLedEntry
   }
};


/**
 * @brief Private MIB module
 **/

const MibModule privateMibModule =
{
   "Private MIB",
   {43, 6, 1, 4, 1, 191, 8, 206, 15, 206, 15, 123},
   12,
   privateMibObjects,
   arraysize(privateMibObjects),
   privateMibInit,
   privateMibLoad,
   privateMibUnload,
   privateMibLock,
   privateMibUnlock
};
