/**
 * @file os_port_config.h
 * @brief RTOS port configuration file
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _OS_PORT_CONFIG_H
#define _OS_PORT_CONFIG_H

//Select underlying RTOS
#define USE_FREERTOS

//Milliseconds to system ticks
#define OS_MS_TO_SYSTICKS(n) ((n + 9) / 10)

//System ticks to milliseconds
#define OS_SYSTICKS_TO_MS(n) ((n) * 10)

//Trace output redirection
#define TRACE_PRINTF(...) ets_printf(__VA_ARGS__)
#define TRACE_ARRAY(p, a, n) debugDisplayArray(NULL, p, a, n)

#endif
