/**
 * @file usbd_conf.h
 * @brief USB device low-level configuration
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _USBD_CONF_H
#define _USBD_CONF_H

//Dependencies
#include "stm32f4xx_hal.h"

//Settings
#define USBD_MAX_NUM_INTERFACES     1
#define USBD_MAX_NUM_CONFIGURATION  1
#define USBD_MAX_STR_DESC_SIZ       256
#define USBD_SUPPORT_USER_STRING    0
#define USBD_SELF_POWERED           1
#define USBD_DEBUG_LEVEL            0

//Debug macros
#if (USBD_DEBUG_LEVEL > 0)
   #define USBD_UsrLog(...) printf(__VA_ARGS__); printf("\r\n");
#else
   #define USBD_UsrLog(...)
#endif

#if (USBD_DEBUG_LEVEL > 1)
   #define USBD_ErrLog(...) printf("ERROR: "); printf(__VA_ARGS__); printf("\r\n");
#else
   #define USBD_ErrLog(...)
#endif

#if (USBD_DEBUG_LEVEL > 2)
   #define USBD_DbgLog(...) printf("DEBUG: "); printf(__VA_ARGS__); printf("\r\n");
#else
   #define USBD_DbgLog(...)
#endif

#endif
