/**
 * @file system_msp432e401y.c
 * @brief System configuration for MSP432E401Y device
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#include "msp432e401y.h"
#include "driverlib/fpu.h"
#include "driverlib/sysctl.h"
#include "system_msp432e401y.h"

//System clock frequency (120MHz)
uint32_t SystemCoreClock = 120000000;


/**
 * @brief Setup the system clock
 **/

void SystemInit(void)
{
   //Enable floating-point unit
   FPUEnable();

   //Run from the PLL at 120MHz
   SysCtlClockFreqSet(SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN |
      SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480, 120000000);
}


/**
 * @brief Update the variable SystemCoreClock
 **/

void SystemCoreClockUpdate(void)
{
}
