/**
 * @file system_f28m35x
 * @brief System configuration for F28M35x device
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#include <stdint.h>
#include "inc/hw_types.h"
#include "inc/hw_sysctl.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "system_f28m35x.h"

//System clock frequency (75MHz)
uint32_t SystemCoreClock = 75000000;


/**
 * @brief Setup the system clock
 **/

void SystemInit(void)
{
   //Disable protection
   HWREG(SYSCTL_MWRALLOW) = 0xA5A5A5A5;

   // Sets up PLL (M3 running at 75MHz and C28 running at 150MHz)
   SysCtlClockConfigSet(SYSCTL_USE_PLL | (SYSCTL_SPLLIMULT_M & 0xF) |
      SYSCTL_SYSDIV_1 | SYSCTL_M3SSDIV_2 | SYSCTL_XCLKDIV_4);

   //Initialize Flash wait-states
   //FlashInit();

   //Disable clock for watchdog modules
   SysCtlPeripheralDisable(SYSCTL_PERIPH_WDOG1);
   SysCtlPeripheralDisable(SYSCTL_PERIPH_WDOG0);
}


/**
 * @brief Update the variable SystemCoreClock
 **/

void SystemCoreClockUpdate(void)
{
   //Retrieve system clock
   SystemCoreClock = SysCtlClockGet(20000000);
}
