/**
 * @file private_mib_module.h
 * @brief Private MIB module
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _PRIVATE_MIB_MODULE_H
#define _PRIVATE_MIB_MODULE_H

//Dependencies
#include "mibs/mib_common.h"

//Size of testString object
#define PRIVATE_MIB_TEST_STRING_SIZE 32
//Number of LEDs
#define PRIVATE_MIB_LED_COUNT 3
//Size of ledColor object
#define PRIVATE_MIB_LED_COLOR_SIZE 8


/**
 * @brief LED table entry
 **/

typedef struct
{
   char_t ledColor[PRIVATE_MIB_LED_COLOR_SIZE];
   size_t ledColorLen;
   int32_t ledState;
} PrivateMibLedEntry;


/**
 * @brief Private MIB base
 **/

typedef struct
{
   char_t testString[PRIVATE_MIB_TEST_STRING_SIZE];
   size_t testStringLen;
   int32_t testInteger;
   uint32_t currentTime;
   int32_t ledCount;
   PrivateMibLedEntry ledTable[PRIVATE_MIB_LED_COUNT];
} PrivateMibBase;


//Private MIB related constants
extern PrivateMibBase privateMibBase;
extern const MibObject privateMibObjects[];
extern const MibModule privateMibModule;

#endif
