/**
 * @file evk1105.h
 * @brief EVK1105 evaluation kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _EVK1105_H
#define _EVK1105_H

//Dependencies
#include <avr32/io.h>

//OSC0 frequency (12MHz)
#define OSC0_FREQ 12000000
//OSC1 frequency (11.2896MHz)
#define OSC1_FREQ 11289600
//OSC32 frequency (32kHz)
#define OSC32_FREQ 32768

//Main clock frequency (66MHz)
#define MCLK_FREQ (12000000 * 11 / 2)
//CPU clock frequency (66MHz)
#define CPU_FREQ (MCLK_FREQ / 1)
//HSB clock frequency (66MHz)
#define HSB_FREQ (MCLK_FREQ / 1)
//PBA clock frequency (66MHz)
#define PBA_FREQ (MCLK_FREQ / 1)
//PBB clock frequency (66MHz)
#define PBB_FREQ (MCLK_FREQ / 1)

//LED0 (PB27)
#define LED0_PORT 1
#define LED0_POS  27

//LED1 (PB28)
#define LED1_PORT 1
#define LED1_POS  28

//LED2 (PA5)
#define LED2_PORT 0
#define LED2_POS  5

//LED3 (PA6)
#define LED3_PORT 0
#define LED3_POS  6

//SDRAM memory parameters
#define SDRAM_PART_HDR  "mt48lc16m16a2tg7e.h"
//SDRAM data bus width
#define SDRAM_DBW 16

#endif
