/**
 * @file sam3x_ek.h
 * @brief SAM3X-EK evaluation kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _SAM3X_EK_H
#define _SAM3X_EK_H

//Dependencies
#include "sam3xa.h"

//LED1
#define LED1            PIO_PA12
#define PIO_LED1        PIOA
#define ID_PIO_LED1     ID_PIOA

//LED2
#define LED2            PIO_PB12
#define PIO_LED2        PIOB
#define ID_PIO_LED2     ID_PIOB

//LED3
#define LED3            PIO_PB13
#define PIO_LED3        PIOB
#define ID_PIO_LED3     ID_PIOB

//LED4
#define LED4            PIO_PA13
#define PIO_LED4        PIOA
#define ID_PIO_LED4     ID_PIOA

//Left button
#define BT_LEFT         PIO_PE7
#define PIO_BT_LEFT     PIOE
#define ID_PIO_BT_LEFT  ID_PIOE

//Right button
#define BT_RIGHT        PIO_PB23
#define PIO_BT_RIGHT    PIOB
#define ID_PIO_BT_RIGHT ID_PIOB

#endif
