/**
 * @file sam4e_ek.h
 * @brief SAM4E-EK evaluation kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _SAM4E_EK_H
#define _SAM4E_EK_H

//Dependencies
#include "sam4e.h"

//LED1
#define LED1            PIO_PA0
#define PIO_LED1        PIOA

//LED2
#define LED2            PIO_PD20
#define PIO_LED2        PIOD

//LED3
#define LED3            PIO_PD21
#define PIO_LED3        PIOD

//LED4
#define LED4            PIO_PD22
#define PIO_LED4        PIOD

//Up button
#define BT_UP          PIO_PA1
#define PIO_BT_UP      PIOA

//Down button
#define BT_DOWN        PIO_PA2
#define PIO_BT_DOWN    PIOA

//WAKU button
#define BT_WAKU        PIO_PA19
#define PIO_BT_WAKU    PIOA

//TAMP button
#define BT_TAMP        PIO_PA20
#define PIO_BT_TAMP    PIOA

//LCD data bus
#define LCD_DATA       (PIO_PC7 | PIO_PC6 | PIO_PC5 | PIO_PC4 | PIO_PC3 | PIO_PC2 | PIO_PC1 | PIO_PC0)
#define PIO_LCD_DATA   PIOC

//LCD control pins
#define LCD_RS         PIO_PC19
#define PIO_LCD_RS     PIOC

#define LCD_RD         PIO_PC11
#define PIO_LCD_RD     PIOC

#define LCD_WR         PIO_PC8
#define PIO_LCD_WR     PIOC

#define LCD_NCS1       PIO_PD18
#define PIO_LCD_NCS1   PIOD

//LCD backlight pin
#define LCD_BL        PIO_PC13
#define PIO_LCD_BL    PIOC

#endif
