/**
 * @file sdram.h
 * @brief SDRAM configuration
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _SDRAM_H
#define _SDRAM_H

//Dependencies
#include "error.h"

//SDRAM base address
#define AT91C_SDRAM_BASE ((volatile uint32_t *) 0x20000000)
//SDRAM size (32 Mega bytes)
#define AT91C_SDRAM_SIZE (32 * 1024 * 1024)

//SDRAM control signals
#define AT91C_SDRAM_CTRL_MASK (AT91C_PA29_RAS | AT91C_PA28_CAS | AT91C_PA27_SDWE | AT91C_PA26_NCS1_SDCS | \
                               AT91C_PA25_SDCKE | AT91C_PA24_SDA10 | AT91C_PA23_NWR1_NBS1_CFIOR_NUB)
//SDRAM address bus (A1/NBS2, A12 and A15 not used)
#define AT91C_SDRAM_ADDR_MASK (AT91C_PB17_A17_BA1 | AT91C_PB16_A16_BA0 | AT91C_PB14_A14 | AT91C_PB13_A13 | \
                               AT91C_PB11_A11 | AT91C_PB10_A10 | AT91C_PB9_A9 | AT91C_PB8_A8 | \
                               AT91C_PB7_A7 | AT91C_PB6_A6 | AT91C_PB5_A5 | AT91C_PB4_A4 | \
                               AT91C_PB3_A3 | AT91C_PB2_A2 | AT91C_PB0_A0_NBS0)

//SDRAM data bus
#define AT91C_SDRAM_DATA_MASK (AT91C_PC15_D15 | AT91C_PC14_D14 | AT91C_PC13_D13 | AT91C_PC12_D12 | \
                               AT91C_PC11_D11 | AT91C_PC10_D10 | AT91C_PC9_D9 | AT91C_PC8_D8 | \
                               AT91C_PC7_D7 | AT91C_PC6_D6 | AT91C_PC5_D5 | AT91C_PC4_D4 | \
                               AT91C_PC3_D3 | AT91C_PC2_D2 | AT91C_PC1_D1 | AT91C_PC0_D0)

//SDRAM characteristics
#define AT91C_SDRC_TWR_2  (2 << 7)
#define AT91C_SDRC_TRC_4  (4 << 11)
#define AT91C_SDRC_TRP_4  (4 << 15)
#define AT91C_SDRC_TRCD_2 (2 << 19)
#define AT91C_SDRC_TRAS_3 (3 << 23)
#define AT91C_SDRC_TXSR_4 (4 << 27)

//Refresh period (64ms for 8192 rows)
#define AT91C_SDRC_TR_TIME (AT91B_MCK / 1000 * 64 / 8192)

void sdramInit(void);
error_t sdramTest(void);

#endif
