/**
 * @file sama5d3_eds.h
 * @brief SAMA5D3-EDS evaluation kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _SAMA5D3_EDS_H
#define _SAMA5D3_EDS_H

//Clocks
#define BOARD_MAINOSC 12000000
#define BOARD_MCK ((unsigned long) ((BOARD_MAINOSC / 3 / 2) * 66 ))

//DDRAM type
#define DDRAM_MT47H64M16HR 0
#define DDRAM_MT47H128M16RT 1
#define BOARD_DDRAM_TYPE DDRAM_MT47H128M16RT

#endif
