/**
 * @file lpc1788_32_dev_kit.h
 * @brief LPC1788-32 Developer's Kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _LPC1788_32_DEV_KIT_H
#define _LPC1788_32_DEV_KIT_H

//Dependencies
#include "lpc177x_8x.h"

//LED3
#define LED3_MASK                (1 << 26)
#define LED3_FIODIR              LPC_GPIO2->DIR
#define LED3_FIOSET              LPC_GPIO2->SET
#define LED3_FIOCLR              LPC_GPIO2->CLR

//LED4
#define LED4_MASK                (1 << 27)
#define LED4_FIODIR              LPC_GPIO2->DIR
#define LED4_FIOSET              LPC_GPIO2->SET
#define LED4_FIOCLR              LPC_GPIO2->CLR

//SW6
#define SW6_MASK                 (1 << 10)
#define SW6_FIODIR               LPC_GPIO2->DIR
#define SW6_FIOPIN               LPC_GPIO2->PIN

//Joystick
#define JOYSTICK_UP_MASK         (1 << 25)
#define JOYSTICK_DOWN_MASK       (1 << 27)
#define JOYSTICK_LEFT_MASK       (1 << 23)
#define JOYSTICK_RIGHT_MASK      (1 << 26)
#define JOYSTICK_FIODIR          LPC_GPIO2->DIR
#define JOYSTICK_FIOPIN          LPC_GPIO2->PIN

#endif
