/**
 * @file frdm_k66f.h
 * @brief FRDM-K66F evaluation board
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _FRDM_K66F_H
#define _FRDM_K66F_H

//Dependencies
#include "mk66f18.h"

//Red LED
#define LED_R_POS    9
#define LED_R_MASK   (1 << LED_R_POS)
#define PORT_LED_R   PORTC
#define GPIO_LED_R   PTC

//Green LED
#define LED_G_POS    6
#define LED_G_MASK   (1 << LED_G_POS)
#define PORT_LED_G   PORTE
#define GPIO_LED_G   PTE

//Blue LED
#define LED_B_POS    11
#define LED_B_MASK   (1 << LED_B_POS)
#define PORT_LED_B   PORTA
#define GPIO_LED_B   PTA

//SW2
#define SW2_POS      11
#define SW2_MASK     (1 << SW2_POS)
#define PORT_SW2     PORTD
#define GPIO_SW2     PTD

//SW3
#define SW3_POS      10
#define SW3_MASK     (1 << SW3_POS)
#define PORT_SW3     PORTA
#define GPIO_SW3     PTA

#endif
