/**
 * @file twr_k60n512.h
 * @brief TWR-K60N512 module
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _TWR_K60N512_H
#define _TWR_K60N512_H

//Dependencies
#include "mk60n512md100.h"

//LED1
#define LED1_POS     11
#define LED1_MASK    (1 << LED1_POS)
#define PORT_LED1    PORTA
#define GPIO_LED1    PTA

//LED2
#define LED2_POS     28
#define LED2_MASK    (1 << LED2_POS)
#define PORT_LED2    PORTA
#define GPIO_LED2    PTA

//LED3
#define LED3_POS     29
#define LED3_MASK    (1 << LED3_POS)
#define PORT_LED3    PORTA
#define GPIO_LED3    PTA

//LED4
#define LED4_POS     10
#define LED4_MASK    (1 << LED4_POS)
#define PORT_LED4    PORTA
#define GPIO_LED4    PTA

//SW1
#define SW1_POS      19
#define SW1_MASK     (1 << SW1_POS)
#define PORT_SW1     PORTA
#define GPIO_SW1     PTA

//SW2
#define SW2_POS      26
#define SW2_MASK     (1 << SW2_POS)
#define PORT_SW2     PORTE
#define GPIO_SW2     PTE

#endif
