/**
 * @file twr_k65f180m.h
 * @brief TWR-K65F180M module
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _TWR_K65F180M_H
#define _TWR_K65F180M_H

//Dependencies
#include "mk65f18.h"

//LED6
#define LED6_POS     4
#define LED6_MASK    (1 << LED6_POS)
#define PORT_LED6    PORTB
#define GPIO_LED6    PTB

//LED7
#define LED7_POS     5
#define LED7_MASK    (1 << LED7_POS)
#define PORT_LED7    PORTB
#define GPIO_LED7    PTB

//LED8
#define LED8_POS     28
#define LED8_MASK    (1 << LED8_POS)
#define PORT_LED8    PORTA
#define GPIO_LED8    PTA

//LED9
#define LED9_POS     29
#define LED9_MASK    (1 << LED9_POS)
#define PORT_LED9    PORTA
#define GPIO_LED9    PTA

//SW2
#define SW2_POS      4
#define SW2_MASK     (1 << SW2_POS)
#define PORT_SW2     PORTA
#define GPIO_SW2     PTA

//SW3
#define SW3_POS      10
#define SW3_MASK     (1 << SW3_POS)
#define PORT_SW3     PORTA
#define GPIO_SW3     PTA

#endif
