/**
 * @file twr_mcf5225x.h
 * @brief TWR-MCF5225X module
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _TWR_MCF5225X_H
#define _TWR_MCF5225X_H

//Dependencies
#include "mcf52259.h"

//System bus frequency
#define SYSTEM_CLOCK_HZ 80000000

//LED1
#define LED1_MASK    (1 << 0)
//LED2
#define LED2_MASK    (1 << 1)
//LED3
#define LED3_MASK    (1 << 2)
//LED4
#define LED4_MASK    (1 << 3)

//SW1
#define SW1_MASK     (1 << 0)
//SW3
#define SW3_MASK     (1 << 1)

#endif
