/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          GNU C Compiler - CodeSourcery Sourcery G++
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    KV5xP64M75RM Rev.0, November 2014
**     Version:             rev. 0.1, 2015-02-24
**     Build:               b150312
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MKV58F22
**
**     Copyright (c) 1997 - 2015 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 0.1 (2015-02-24)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file MKV58F22.h
 * @version 0.1
 * @date 2015-02-24
 * @brief CMSIS Peripheral Access Layer for MKV58F22
 *
 * CMSIS Peripheral Access Layer for MKV58F22
 */


/* ----------------------------------------------------------------------------
   -- MCU activation
   ---------------------------------------------------------------------------- */

/* Prevention from multiple including the same memory map */
#if !defined(MKV58F22_H_)  /* Check if memory map has not been already included */
#define MKV58F22_H_
#define MCU_MKV58F22

/* Check if another memory map has not been also included */
#if (defined(MCU_ACTIVE))
  #error MKV58F22 memory map: There is already included another memory map. Only one memory map can be included.
#endif /* (defined(MCU_ACTIVE)) */
#define MCU_ACTIVE

#include <stdint.h>

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0000u
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0001u

/**
 * @brief Macro to calculate address of an aliased word in the peripheral
 *        bitband area for a peripheral register and bit (bit band region 0x40000000 to
 *        0x400FFFFF).
 * @param Reg Register to access.
 * @param Bit Bit number to access.
 * @return  Address of the aliased word in the peripheral bitband area.
 */
#define BITBAND_REGADDR(Reg,Bit) (0x42000000u + (32u*((uint32_t)&(Reg) - (uint32_t)0x40000000u)) + (4u*((uint32_t)(Bit))))
/**
 * @brief Macro to access a single bit of a peripheral register (bit band region
 *        0x40000000 to 0x400FFFFF) using the bit-band alias region access. Can
 *        be used for peripherals with 32bit access allowed.
 * @param Reg Register to access.
 * @param Bit Bit number to access.
 * @return Value of the targeted bit in the bit band region.
 */
#define BITBAND_REG32(Reg,Bit) (*((uint32_t volatile*)(BITBAND_REGADDR(Reg,Bit))))
#define BITBAND_REG(Reg,Bit) (BITBAND_REG32(Reg,Bit))
/**
 * @brief Macro to access a single bit of a peripheral register (bit band region
 *        0x40000000 to 0x400FFFFF) using the bit-band alias region access. Can
 *        be used for peripherals with 16bit access allowed.
 * @param Reg Register to access.
 * @param Bit Bit number to access.
 * @return Value of the targeted bit in the bit band region.
 */
#define BITBAND_REG16(Reg,Bit) (*((uint16_t volatile*)(BITBAND_REGADDR(Reg,Bit))))
/**
 * @brief Macro to access a single bit of a peripheral register (bit band region
 *        0x40000000 to 0x400FFFFF) using the bit-band alias region access. Can
 *        be used for peripherals with 8bit access allowed.
 * @param Reg Register to access.
 * @param Bit Bit number to access.
 * @return Value of the targeted bit in the bit band region.
 */
#define BITBAND_REG8(Reg,Bit) (*((uint8_t volatile*)(BITBAND_REGADDR(Reg,Bit))))

/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 137                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M7 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M7 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M7 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M7 Usage Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M7 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M7 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M7 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M7 System Tick Interrupt */

  /* Device specific interrupts */
  DMA0_DMA16_IRQn              = 0,                /**< DMA channel 0/16 transfer complete */
  DMA1_DMA17_IRQn              = 1,                /**< DMA channel 1/17 transfer complete */
  DMA2_DMA18_IRQn              = 2,                /**< DMA channel 2/18 transfer complete */
  DMA3_DMA19_IRQn              = 3,                /**< DMA channel 3/19 transfer complete */
  DMA4_DMA20_IRQn              = 4,                /**< DMA channel 4/20 transfer complete */
  DMA5_DMA21_IRQn              = 5,                /**< DMA channel 5/21 transfer complete */
  DMA6_DMA22_IRQn              = 6,                /**< DMA channel 6/22 transfer complete */
  DMA7_DMA23_IRQn              = 7,                /**< DMA channel 7/23 transfer complete */
  DMA8_DMA24_IRQn              = 8,                /**< DMA channel 8/24 transfer complete */
  DMA9_DMA25_IRQn              = 9,                /**< DMA channel 9/25 transfer complete */
  DMA10_DMA26_IRQn             = 10,               /**< DMA channel 10/26 transfer complete */
  DMA11_DMA27_IRQn             = 11,               /**< DMA channel 11/27 transfer complete */
  DMA12_DMA28_IRQn             = 12,               /**< DMA channel 12/28 transfer complete */
  DMA13_DMA29_IRQn             = 13,               /**< DMA channel 13/29 transfer complete */
  DMA14_DMA30_IRQn             = 14,               /**< DMA channel 14/30 transfer complete */
  DMA15_DMA31_IRQn             = 15,               /**< DMA channel 15/31 transfer complete */
  DMA_Error_IRQn               = 16,               /**< DMA error interrupt channels 0-31 */
  MCM_IRQn                     = 17,               /**< MCM normal interrupt */
  FTFE_IRQn                    = 18,               /**< FTFL command complete */
  Read_Collision_IRQn          = 19,               /**< FTFL read collision */
  PMC_IRQn                     = 20,               /**< PMC controller low-voltage detect, low-voltage warning */
  LLWU_IRQn                    = 21,               /**< Low leakage wakeup */
  WDOG_EWM_IRQn                = 22,               /**< Single interrupt vector for  WDOG and EWM */
  TRNG_IRQn                    = 23,               /**< True randon number generator */
  I2C0_IRQn                    = 24,               /**< Inter-integrated circuit 0 */
  I2C1_IRQn                    = 25,               /**< Inter-integrated circuit 1 */
  SPI0_IRQn                    = 26,               /**< Serial peripheral Interface 0 */
  SPI1_IRQn                    = 27,               /**< Serial peripheral Interface 1 */
  UART5_RX_TX_IRQn             = 28,               /**< UART5 receive/transmit interrupt */
  UART5_ERR_IRQn               = 29,               /**< UART5 error interrupt */
  UART0_LON_IRQn               = 30,               /**< UART0 LON */
  UART0_RX_TX_IRQn             = 31,               /**< UART0 receive/transmit interrupt */
  UART0_ERR_IRQn               = 32,               /**< UART0 error interrupt */
  UART1_RX_TX_IRQn             = 33,               /**< UART1 receive/transmit interrupt */
  UART1_ERR_IRQn               = 34,               /**< UART1 error interrupt */
  UART2_RX_TX_IRQn             = 35,               /**< UART2 receive/transmit interrupt */
  UART2_ERR_IRQn               = 36,               /**< UART2 error interrupt */
  ADC0_IRQn                    = 37,               /**< Analog-to-digital converter 0 */
  HSADC_ERR_IRQn               = 38,               /**< High speed analog-to-digital converter zero cross */
  HSADC0A_IRQn                 = 39,               /**< High speed analog-to-digital converter 0 submodule A scan complete */
  CMP0_IRQn                    = 40,               /**< Comparator 0 */
  CMP1_IRQn                    = 41,               /**< Comparator 1 */
  FTM0_IRQn                    = 42,               /**< FlexTimer module 0 fault, overflow and channels interrupt */
  FTM1_IRQn                    = 43,               /**< FlexTimer module 1 fault, overflow and channels interrupt */
  UART3_RX_TX_IRQn             = 44,               /**< UART3 receive/transmit interrupt */
  UART3_ERR_IRQn               = 45,               /**< UART3 error interrupt */
  UART4_RX_TX_IRQn             = 46,               /**< UART4 receive/transmit interrupt */
  UART4_ERR_IRQn               = 47,               /**< UART4 error interrupt */
  PIT0_IRQn                    = 48,               /**< Periodic interrupt timer channel 0 */
  PIT1_IRQn                    = 49,               /**< Periodic interrupt timer channel 1 */
  PIT2_IRQn                    = 50,               /**< Periodic interrupt timer channel 2 */
  PIT3_IRQn                    = 51,               /**< Periodic interrupt timer channel 3 */
  PDB0_IRQn                    = 52,               /**< Programmable delay block 0 */
  FTM2_IRQn                    = 53,               /**< FlexTimer module 2 fault, overflow and channels interrupt */
  XBARA_IRQn                   = 54,               /**< Inter-peripheral crossbar switch A */
  PDB1_IRQn                    = 55,               /**< Programmable delay block 1 */
  DAC0_IRQn                    = 56,               /**< Digital-to-analog converter 0 */
  MCG_IRQn                     = 57,               /**< Multipurpose clock generator */
  LPTMR0_IRQn                  = 58,               /**< Low power timer interrupt */
  PORTA_IRQn                   = 59,               /**< Port A interrupt */
  PORTB_IRQn                   = 60,               /**< Port B interrupt */
  PORTC_IRQn                   = 61,               /**< Port C interrupt */
  PORTD_IRQn                   = 62,               /**< Port D interrupt */
  PORTE_IRQn                   = 63,               /**< Port E interrupt */
  SWI_IRQn                     = 64,               /**< Software interrupt */
  SPI2_IRQn                    = 65,               /**< Serial peripheral Interface 2 */
  ENC_COMPARE_IRQn             = 66,               /**< ENC Compare */
  ENC_HOME_IRQn                = 67,               /**< ENC Home */
  ENC_WDOG_SAB_IRQn            = 68,               /**< ENC Wdog/SAB */
  ENC_INDEX_IRQn               = 69,               /**< ENC Index/Roll over/Roll Under */
  CMP2_IRQn                    = 70,               /**< Comparator 2 */
  FTM3_IRQn                    = 71,               /**< FlexTimer module 3 fault, overflow and channels */
  Reserved88_IRQn              = 72,               /**< Reserved interrupt */
  HSADC0B_IRQn                 = 73,               /**< High speed analog-to-digital converter 0 submodule B scan complete */
  HSADC1C_IRQn                 = 74,               /**< High speed analog-to-digital converter 1 submodule C scan complete */
  CAN0_ORed_Message_buffer_IRQn = 75,              /**< Flex controller area network 0 message buffer */
  CAN0_Bus_Off_IRQn            = 76,               /**< Flex controller area network 0 bus off */
  CAN0_Error_IRQn              = 77,               /**< Flex controller area network 0 error */
  CAN0_Tx_Warning_IRQn         = 78,               /**< Flex controller area network 0 transmit */
  CAN0_Rx_Warning_IRQn         = 79,               /**< Flex controller area network 0 receive */
  CAN0_Wake_Up_IRQn            = 80,               /**< Flex controller area network 0 wake up */
  PWMA_CMP0_IRQn               = 81,               /**< Pulse width modulator A channel 0 compare */
  PWMA_RELOAD0_IRQn            = 82,               /**< Pulse width modulator A channel 0 reload */
  PWMA_CMP1_IRQn               = 83,               /**< Pulse width modulator A channel 1 compare */
  PWMA_RELOAD1_IRQn            = 84,               /**< Pulse width modulator A channel 1 reload */
  PWMA_CMP2_IRQn               = 85,               /**< Pulse width modulator A channel 2 compare */
  PWMA_RELOAD2_IRQn            = 86,               /**< Pulse width modulator A channel 2 reload */
  PWMA_CMP3_IRQn               = 87,               /**< Pulse width modulator A channel 3 compare */
  PWMA_RELOAD3_IRQn            = 88,               /**< Pulse width modulator A channel 3 reload */
  PWMA_CAP_IRQn                = 89,               /**< Pulse width modulator A capture */
  PWMA_RERR_IRQn               = 90,               /**< Pulse width modulator A reload error */
  PWMA_FAULT_IRQn              = 91,               /**< Pulse width modulator A fault */
  CMP3_IRQn                    = 92,               /**< Comparator 3 */
  HSADC1D_IRQn                 = 93,               /**< High speed analog-to-digital converter 1 submodule D scan complete */
  CAN1_ORed_Message_buffer_IRQn = 94,              /**< Flex controller area network 1 message buffer */
  CAN1_Bus_Off_IRQn            = 95,               /**< Flex controller area network 1 bus off */
  CAN1_Error_IRQn              = 96,               /**< Flex controller area network 1 error */
  CAN1_Tx_Warning_IRQn         = 97,               /**< Flex controller area network 1 transmit */
  CAN1_Rx_Warning_IRQn         = 98,               /**< Flex controller area network 1 receive */
  CAN1_Wake_Up_IRQn            = 99,               /**< Flex controller area network 1 wake up */
  ENET_1588_Timer_IRQn         = 100,              /**< Ethernet MAC IEEE 1588 timer */
  ENET_Transmit_IRQn           = 101,              /**< Ethernet MAC transmit */
  ENET_Receive_IRQn            = 102,              /**< Ethernet MAC receive */
  ENET_Error_IRQn              = 103,              /**< Ethernet MAC error and miscelaneous */
  PWMB_CMP0_IRQn               = 104,              /**< Pulse width modulator B channel 0 compare */
  PWMB_RELOAD0_IRQn            = 105,              /**< Pulse width modulator B channel 0 reload */
  PWMB_CMP1_IRQn               = 106,              /**< Pulse width modulator B channel 1 compare */
  PWMB_RELOAD1_IRQn            = 107,              /**< Pulse width modulator B channel 1 reload */
  PWMB_CMP2_IRQn               = 108,              /**< Pulse width modulator B channel 2 compare */
  PWMB_RELOAD2_IRQn            = 109,              /**< Pulse width modulator B channel 2 reload */
  PWMB_CMP3_IRQn               = 110,              /**< Pulse width modulator B channel 3 compare */
  PWMB_RELOAD3_IRQn            = 111,              /**< Pulse width modulator B channel 3 reload */
  PWMB_CAP_IRQn                = 112,              /**< Pulse width modulator B capture */
  PWMB_RERR_IRQn               = 113,              /**< Pulse width modulator B reload error */
  PWMB_FAULT_IRQn              = 114,              /**< Pulse width modulator B fault */
  CAN2_ORed_Message_buffer_IRQn = 115,             /**< Flex controller area network 2 message buffer */
  CAN2_Bus_Off_IRQn            = 116,              /**< Flex controller area network 2 bus off */
  CAN2_Error_IRQn              = 117,              /**< Flex controller area network 2 error */
  CAN2_Tx_Warning_IRQn         = 118,              /**< Flex controller area network 2 transmit */
  CAN2_Rx_Warning_IRQn         = 119,              /**< Flex controller area network 2 receive */
  CAN2_Wake_Up_IRQn            = 120               /**< Flex controller area network 2 wake up */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M7 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M7 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  0         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               4         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */

#include "core_cm7.h"                  /* Core Peripheral Access Layer */
#include "system_MKV58F22.h"           /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __IO uint32_t SC1[2];                            /**< ADC Status and Control Registers 1, array offset: 0x0, array step: 0x4 */
  __IO uint32_t CFG1;                              /**< ADC Configuration Register 1, offset: 0x8 */
  __IO uint32_t CFG2;                              /**< ADC Configuration Register 2, offset: 0xC */
  __I  uint32_t R[2];                              /**< ADC Data Result Register, array offset: 0x10, array step: 0x4 */
  __IO uint32_t CV1;                               /**< Compare Value Registers, offset: 0x18 */
  __IO uint32_t CV2;                               /**< Compare Value Registers, offset: 0x1C */
  __IO uint32_t SC2;                               /**< Status and Control Register 2, offset: 0x20 */
  __IO uint32_t SC3;                               /**< Status and Control Register 3, offset: 0x24 */
  __IO uint32_t OFS;                               /**< ADC Offset Correction Register, offset: 0x28 */
  __IO uint32_t PG;                                /**< ADC Plus-Side Gain Register, offset: 0x2C */
  __IO uint32_t MG;                                /**< ADC Minus-Side Gain Register, offset: 0x30 */
  __IO uint32_t CLPD;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x34 */
  __IO uint32_t CLPS;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x38 */
  __IO uint32_t CLP4;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x3C */
  __IO uint32_t CLP3;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x40 */
  __IO uint32_t CLP2;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x44 */
  __IO uint32_t CLP1;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x48 */
  __IO uint32_t CLP0;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x4C */
       uint8_t RESERVED_0[4];
  __IO uint32_t CLMD;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x54 */
  __IO uint32_t CLMS;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x58 */
  __IO uint32_t CLM4;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x5C */
  __IO uint32_t CLM3;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x60 */
  __IO uint32_t CLM2;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x64 */
  __IO uint32_t CLM1;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x68 */
  __IO uint32_t CLM0;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x6C */
} ADC_Type, *ADC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register accessors */
#define ADC_SC1_REG(base,index)                  ((base)->SC1[index])
#define ADC_SC1_COUNT                            2
#define ADC_CFG1_REG(base)                       ((base)->CFG1)
#define ADC_CFG2_REG(base)                       ((base)->CFG2)
#define ADC_R_REG(base,index)                    ((base)->R[index])
#define ADC_R_COUNT                              2
#define ADC_CV1_REG(base)                        ((base)->CV1)
#define ADC_CV2_REG(base)                        ((base)->CV2)
#define ADC_SC2_REG(base)                        ((base)->SC2)
#define ADC_SC3_REG(base)                        ((base)->SC3)
#define ADC_OFS_REG(base)                        ((base)->OFS)
#define ADC_PG_REG(base)                         ((base)->PG)
#define ADC_MG_REG(base)                         ((base)->MG)
#define ADC_CLPD_REG(base)                       ((base)->CLPD)
#define ADC_CLPS_REG(base)                       ((base)->CLPS)
#define ADC_CLP4_REG(base)                       ((base)->CLP4)
#define ADC_CLP3_REG(base)                       ((base)->CLP3)
#define ADC_CLP2_REG(base)                       ((base)->CLP2)
#define ADC_CLP1_REG(base)                       ((base)->CLP1)
#define ADC_CLP0_REG(base)                       ((base)->CLP0)
#define ADC_CLMD_REG(base)                       ((base)->CLMD)
#define ADC_CLMS_REG(base)                       ((base)->CLMS)
#define ADC_CLM4_REG(base)                       ((base)->CLM4)
#define ADC_CLM3_REG(base)                       ((base)->CLM3)
#define ADC_CLM2_REG(base)                       ((base)->CLM2)
#define ADC_CLM1_REG(base)                       ((base)->CLM1)
#define ADC_CLM0_REG(base)                       ((base)->CLM0)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/* SC1 Bit Fields */
#define ADC_SC1_ADCH_MASK                        0x1Fu
#define ADC_SC1_ADCH_SHIFT                       0
#define ADC_SC1_ADCH_WIDTH                       5
#define ADC_SC1_ADCH(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_ADCH_SHIFT))&ADC_SC1_ADCH_MASK)
#define ADC_SC1_DIFF_MASK                        0x20u
#define ADC_SC1_DIFF_SHIFT                       5
#define ADC_SC1_DIFF_WIDTH                       1
#define ADC_SC1_DIFF(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_DIFF_SHIFT))&ADC_SC1_DIFF_MASK)
#define ADC_SC1_AIEN_MASK                        0x40u
#define ADC_SC1_AIEN_SHIFT                       6
#define ADC_SC1_AIEN_WIDTH                       1
#define ADC_SC1_AIEN(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_AIEN_SHIFT))&ADC_SC1_AIEN_MASK)
#define ADC_SC1_COCO_MASK                        0x80u
#define ADC_SC1_COCO_SHIFT                       7
#define ADC_SC1_COCO_WIDTH                       1
#define ADC_SC1_COCO(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_COCO_SHIFT))&ADC_SC1_COCO_MASK)
/* CFG1 Bit Fields */
#define ADC_CFG1_ADICLK_MASK                     0x3u
#define ADC_CFG1_ADICLK_SHIFT                    0
#define ADC_CFG1_ADICLK_WIDTH                    2
#define ADC_CFG1_ADICLK(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADICLK_SHIFT))&ADC_CFG1_ADICLK_MASK)
#define ADC_CFG1_MODE_MASK                       0xCu
#define ADC_CFG1_MODE_SHIFT                      2
#define ADC_CFG1_MODE_WIDTH                      2
#define ADC_CFG1_MODE(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_MODE_SHIFT))&ADC_CFG1_MODE_MASK)
#define ADC_CFG1_ADLSMP_MASK                     0x10u
#define ADC_CFG1_ADLSMP_SHIFT                    4
#define ADC_CFG1_ADLSMP_WIDTH                    1
#define ADC_CFG1_ADLSMP(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADLSMP_SHIFT))&ADC_CFG1_ADLSMP_MASK)
#define ADC_CFG1_ADIV_MASK                       0x60u
#define ADC_CFG1_ADIV_SHIFT                      5
#define ADC_CFG1_ADIV_WIDTH                      2
#define ADC_CFG1_ADIV(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADIV_SHIFT))&ADC_CFG1_ADIV_MASK)
#define ADC_CFG1_ADLPC_MASK                      0x80u
#define ADC_CFG1_ADLPC_SHIFT                     7
#define ADC_CFG1_ADLPC_WIDTH                     1
#define ADC_CFG1_ADLPC(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADLPC_SHIFT))&ADC_CFG1_ADLPC_MASK)
/* CFG2 Bit Fields */
#define ADC_CFG2_ADLSTS_MASK                     0x3u
#define ADC_CFG2_ADLSTS_SHIFT                    0
#define ADC_CFG2_ADLSTS_WIDTH                    2
#define ADC_CFG2_ADLSTS(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_ADLSTS_SHIFT))&ADC_CFG2_ADLSTS_MASK)
#define ADC_CFG2_ADHSC_MASK                      0x4u
#define ADC_CFG2_ADHSC_SHIFT                     2
#define ADC_CFG2_ADHSC_WIDTH                     1
#define ADC_CFG2_ADHSC(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_ADHSC_SHIFT))&ADC_CFG2_ADHSC_MASK)
#define ADC_CFG2_ADACKEN_MASK                    0x8u
#define ADC_CFG2_ADACKEN_SHIFT                   3
#define ADC_CFG2_ADACKEN_WIDTH                   1
#define ADC_CFG2_ADACKEN(x)                      (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_ADACKEN_SHIFT))&ADC_CFG2_ADACKEN_MASK)
#define ADC_CFG2_MUXSEL_MASK                     0x10u
#define ADC_CFG2_MUXSEL_SHIFT                    4
#define ADC_CFG2_MUXSEL_WIDTH                    1
#define ADC_CFG2_MUXSEL(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_MUXSEL_SHIFT))&ADC_CFG2_MUXSEL_MASK)
/* R Bit Fields */
#define ADC_R_D_MASK                             0xFFFFu
#define ADC_R_D_SHIFT                            0
#define ADC_R_D_WIDTH                            16
#define ADC_R_D(x)                               (((uint32_t)(((uint32_t)(x))<<ADC_R_D_SHIFT))&ADC_R_D_MASK)
/* CV1 Bit Fields */
#define ADC_CV1_CV_MASK                          0xFFFFu
#define ADC_CV1_CV_SHIFT                         0
#define ADC_CV1_CV_WIDTH                         16
#define ADC_CV1_CV(x)                            (((uint32_t)(((uint32_t)(x))<<ADC_CV1_CV_SHIFT))&ADC_CV1_CV_MASK)
/* CV2 Bit Fields */
#define ADC_CV2_CV_MASK                          0xFFFFu
#define ADC_CV2_CV_SHIFT                         0
#define ADC_CV2_CV_WIDTH                         16
#define ADC_CV2_CV(x)                            (((uint32_t)(((uint32_t)(x))<<ADC_CV2_CV_SHIFT))&ADC_CV2_CV_MASK)
/* SC2 Bit Fields */
#define ADC_SC2_REFSEL_MASK                      0x3u
#define ADC_SC2_REFSEL_SHIFT                     0
#define ADC_SC2_REFSEL_WIDTH                     2
#define ADC_SC2_REFSEL(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_SC2_REFSEL_SHIFT))&ADC_SC2_REFSEL_MASK)
#define ADC_SC2_DMAEN_MASK                       0x4u
#define ADC_SC2_DMAEN_SHIFT                      2
#define ADC_SC2_DMAEN_WIDTH                      1
#define ADC_SC2_DMAEN(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_DMAEN_SHIFT))&ADC_SC2_DMAEN_MASK)
#define ADC_SC2_ACREN_MASK                       0x8u
#define ADC_SC2_ACREN_SHIFT                      3
#define ADC_SC2_ACREN_WIDTH                      1
#define ADC_SC2_ACREN(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ACREN_SHIFT))&ADC_SC2_ACREN_MASK)
#define ADC_SC2_ACFGT_MASK                       0x10u
#define ADC_SC2_ACFGT_SHIFT                      4
#define ADC_SC2_ACFGT_WIDTH                      1
#define ADC_SC2_ACFGT(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ACFGT_SHIFT))&ADC_SC2_ACFGT_MASK)
#define ADC_SC2_ACFE_MASK                        0x20u
#define ADC_SC2_ACFE_SHIFT                       5
#define ADC_SC2_ACFE_WIDTH                       1
#define ADC_SC2_ACFE(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ACFE_SHIFT))&ADC_SC2_ACFE_MASK)
#define ADC_SC2_ADTRG_MASK                       0x40u
#define ADC_SC2_ADTRG_SHIFT                      6
#define ADC_SC2_ADTRG_WIDTH                      1
#define ADC_SC2_ADTRG(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ADTRG_SHIFT))&ADC_SC2_ADTRG_MASK)
#define ADC_SC2_ADACT_MASK                       0x80u
#define ADC_SC2_ADACT_SHIFT                      7
#define ADC_SC2_ADACT_WIDTH                      1
#define ADC_SC2_ADACT(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ADACT_SHIFT))&ADC_SC2_ADACT_MASK)
/* SC3 Bit Fields */
#define ADC_SC3_AVGS_MASK                        0x3u
#define ADC_SC3_AVGS_SHIFT                       0
#define ADC_SC3_AVGS_WIDTH                       2
#define ADC_SC3_AVGS(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_AVGS_SHIFT))&ADC_SC3_AVGS_MASK)
#define ADC_SC3_AVGE_MASK                        0x4u
#define ADC_SC3_AVGE_SHIFT                       2
#define ADC_SC3_AVGE_WIDTH                       1
#define ADC_SC3_AVGE(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_AVGE_SHIFT))&ADC_SC3_AVGE_MASK)
#define ADC_SC3_ADCO_MASK                        0x8u
#define ADC_SC3_ADCO_SHIFT                       3
#define ADC_SC3_ADCO_WIDTH                       1
#define ADC_SC3_ADCO(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_ADCO_SHIFT))&ADC_SC3_ADCO_MASK)
#define ADC_SC3_CALF_MASK                        0x40u
#define ADC_SC3_CALF_SHIFT                       6
#define ADC_SC3_CALF_WIDTH                       1
#define ADC_SC3_CALF(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_CALF_SHIFT))&ADC_SC3_CALF_MASK)
#define ADC_SC3_CAL_MASK                         0x80u
#define ADC_SC3_CAL_SHIFT                        7
#define ADC_SC3_CAL_WIDTH                        1
#define ADC_SC3_CAL(x)                           (((uint32_t)(((uint32_t)(x))<<ADC_SC3_CAL_SHIFT))&ADC_SC3_CAL_MASK)
/* OFS Bit Fields */
#define ADC_OFS_OFS_MASK                         0xFFFFu
#define ADC_OFS_OFS_SHIFT                        0
#define ADC_OFS_OFS_WIDTH                        16
#define ADC_OFS_OFS(x)                           (((uint32_t)(((uint32_t)(x))<<ADC_OFS_OFS_SHIFT))&ADC_OFS_OFS_MASK)
/* PG Bit Fields */
#define ADC_PG_PG_MASK                           0xFFFFu
#define ADC_PG_PG_SHIFT                          0
#define ADC_PG_PG_WIDTH                          16
#define ADC_PG_PG(x)                             (((uint32_t)(((uint32_t)(x))<<ADC_PG_PG_SHIFT))&ADC_PG_PG_MASK)
/* MG Bit Fields */
#define ADC_MG_MG_MASK                           0xFFFFu
#define ADC_MG_MG_SHIFT                          0
#define ADC_MG_MG_WIDTH                          16
#define ADC_MG_MG(x)                             (((uint32_t)(((uint32_t)(x))<<ADC_MG_MG_SHIFT))&ADC_MG_MG_MASK)
/* CLPD Bit Fields */
#define ADC_CLPD_CLPD_MASK                       0x3Fu
#define ADC_CLPD_CLPD_SHIFT                      0
#define ADC_CLPD_CLPD_WIDTH                      6
#define ADC_CLPD_CLPD(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLPD_CLPD_SHIFT))&ADC_CLPD_CLPD_MASK)
/* CLPS Bit Fields */
#define ADC_CLPS_CLPS_MASK                       0x3Fu
#define ADC_CLPS_CLPS_SHIFT                      0
#define ADC_CLPS_CLPS_WIDTH                      6
#define ADC_CLPS_CLPS(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLPS_CLPS_SHIFT))&ADC_CLPS_CLPS_MASK)
/* CLP4 Bit Fields */
#define ADC_CLP4_CLP4_MASK                       0x3FFu
#define ADC_CLP4_CLP4_SHIFT                      0
#define ADC_CLP4_CLP4_WIDTH                      10
#define ADC_CLP4_CLP4(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP4_CLP4_SHIFT))&ADC_CLP4_CLP4_MASK)
/* CLP3 Bit Fields */
#define ADC_CLP3_CLP3_MASK                       0x1FFu
#define ADC_CLP3_CLP3_SHIFT                      0
#define ADC_CLP3_CLP3_WIDTH                      9
#define ADC_CLP3_CLP3(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP3_CLP3_SHIFT))&ADC_CLP3_CLP3_MASK)
/* CLP2 Bit Fields */
#define ADC_CLP2_CLP2_MASK                       0xFFu
#define ADC_CLP2_CLP2_SHIFT                      0
#define ADC_CLP2_CLP2_WIDTH                      8
#define ADC_CLP2_CLP2(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP2_CLP2_SHIFT))&ADC_CLP2_CLP2_MASK)
/* CLP1 Bit Fields */
#define ADC_CLP1_CLP1_MASK                       0x7Fu
#define ADC_CLP1_CLP1_SHIFT                      0
#define ADC_CLP1_CLP1_WIDTH                      7
#define ADC_CLP1_CLP1(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP1_CLP1_SHIFT))&ADC_CLP1_CLP1_MASK)
/* CLP0 Bit Fields */
#define ADC_CLP0_CLP0_MASK                       0x3Fu
#define ADC_CLP0_CLP0_SHIFT                      0
#define ADC_CLP0_CLP0_WIDTH                      6
#define ADC_CLP0_CLP0(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP0_CLP0_SHIFT))&ADC_CLP0_CLP0_MASK)
/* CLMD Bit Fields */
#define ADC_CLMD_CLMD_MASK                       0x3Fu
#define ADC_CLMD_CLMD_SHIFT                      0
#define ADC_CLMD_CLMD_WIDTH                      6
#define ADC_CLMD_CLMD(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLMD_CLMD_SHIFT))&ADC_CLMD_CLMD_MASK)
/* CLMS Bit Fields */
#define ADC_CLMS_CLMS_MASK                       0x3Fu
#define ADC_CLMS_CLMS_SHIFT                      0
#define ADC_CLMS_CLMS_WIDTH                      6
#define ADC_CLMS_CLMS(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLMS_CLMS_SHIFT))&ADC_CLMS_CLMS_MASK)
/* CLM4 Bit Fields */
#define ADC_CLM4_CLM4_MASK                       0x3FFu
#define ADC_CLM4_CLM4_SHIFT                      0
#define ADC_CLM4_CLM4_WIDTH                      10
#define ADC_CLM4_CLM4(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM4_CLM4_SHIFT))&ADC_CLM4_CLM4_MASK)
/* CLM3 Bit Fields */
#define ADC_CLM3_CLM3_MASK                       0x1FFu
#define ADC_CLM3_CLM3_SHIFT                      0
#define ADC_CLM3_CLM3_WIDTH                      9
#define ADC_CLM3_CLM3(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM3_CLM3_SHIFT))&ADC_CLM3_CLM3_MASK)
/* CLM2 Bit Fields */
#define ADC_CLM2_CLM2_MASK                       0xFFu
#define ADC_CLM2_CLM2_SHIFT                      0
#define ADC_CLM2_CLM2_WIDTH                      8
#define ADC_CLM2_CLM2(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM2_CLM2_SHIFT))&ADC_CLM2_CLM2_MASK)
/* CLM1 Bit Fields */
#define ADC_CLM1_CLM1_MASK                       0x7Fu
#define ADC_CLM1_CLM1_SHIFT                      0
#define ADC_CLM1_CLM1_WIDTH                      7
#define ADC_CLM1_CLM1(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM1_CLM1_SHIFT))&ADC_CLM1_CLM1_MASK)
/* CLM0 Bit Fields */
#define ADC_CLM0_CLM0_MASK                       0x3Fu
#define ADC_CLM0_CLM0_SHIFT                      0
#define ADC_CLM0_CLM0_WIDTH                      6
#define ADC_CLM0_CLM0(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM0_CLM0_SHIFT))&ADC_CLM0_CLM0_MASK)

/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base address */
#define ADC0_BASE                                (0x4003B000u)
/** Peripheral ADC0 base pointer */
#define ADC0                                     ((ADC_Type *)ADC0_BASE)
#define ADC0_BASE_PTR                            (ADC0)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { ADC0_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0 }

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register instance definitions */
/* ADC0 */
#define ADC0_SC1A                                ADC_SC1_REG(ADC0,0)
#define ADC0_SC1B                                ADC_SC1_REG(ADC0,1)
#define ADC0_CFG1                                ADC_CFG1_REG(ADC0)
#define ADC0_CFG2                                ADC_CFG2_REG(ADC0)
#define ADC0_RA                                  ADC_R_REG(ADC0,0)
#define ADC0_RB                                  ADC_R_REG(ADC0,1)
#define ADC0_CV1                                 ADC_CV1_REG(ADC0)
#define ADC0_CV2                                 ADC_CV2_REG(ADC0)
#define ADC0_SC2                                 ADC_SC2_REG(ADC0)
#define ADC0_SC3                                 ADC_SC3_REG(ADC0)
#define ADC0_OFS                                 ADC_OFS_REG(ADC0)
#define ADC0_PG                                  ADC_PG_REG(ADC0)
#define ADC0_MG                                  ADC_MG_REG(ADC0)
#define ADC0_CLPD                                ADC_CLPD_REG(ADC0)
#define ADC0_CLPS                                ADC_CLPS_REG(ADC0)
#define ADC0_CLP4                                ADC_CLP4_REG(ADC0)
#define ADC0_CLP3                                ADC_CLP3_REG(ADC0)
#define ADC0_CLP2                                ADC_CLP2_REG(ADC0)
#define ADC0_CLP1                                ADC_CLP1_REG(ADC0)
#define ADC0_CLP0                                ADC_CLP0_REG(ADC0)
#define ADC0_CLMD                                ADC_CLMD_REG(ADC0)
#define ADC0_CLMS                                ADC_CLMS_REG(ADC0)
#define ADC0_CLM4                                ADC_CLM4_REG(ADC0)
#define ADC0_CLM3                                ADC_CLM3_REG(ADC0)
#define ADC0_CLM2                                ADC_CLM2_REG(ADC0)
#define ADC0_CLM1                                ADC_CLM1_REG(ADC0)
#define ADC0_CLM0                                ADC_CLM0_REG(ADC0)

/* ADC - Register array accessors */
#define ADC0_SC1(index)                          ADC_SC1_REG(ADC0,index)
#define ADC0_R(index)                            ADC_R_REG(ADC0,index)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AIPS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Peripheral_Access_Layer AIPS Peripheral Access Layer
 * @{
 */

/** AIPS - Register Layout Typedef */
typedef struct {
  __IO uint32_t MPRA;                              /**< Master Privilege Register A, offset: 0x0 */
       uint8_t RESERVED_0[28];
  __IO uint32_t PACRA;                             /**< Peripheral Access Control Register, offset: 0x20 */
  __IO uint32_t PACRB;                             /**< Peripheral Access Control Register, offset: 0x24 */
  __IO uint32_t PACRC;                             /**< Peripheral Access Control Register, offset: 0x28 */
  __IO uint32_t PACRD;                             /**< Peripheral Access Control Register, offset: 0x2C */
       uint8_t RESERVED_1[16];
  __IO uint32_t PACRE;                             /**< Peripheral Access Control Register, offset: 0x40 */
  __IO uint32_t PACRF;                             /**< Peripheral Access Control Register, offset: 0x44 */
  __IO uint32_t PACRG;                             /**< Peripheral Access Control Register, offset: 0x48 */
  __IO uint32_t PACRH;                             /**< Peripheral Access Control Register, offset: 0x4C */
  __IO uint32_t PACRI;                             /**< Peripheral Access Control Register, offset: 0x50 */
  __IO uint32_t PACRJ;                             /**< Peripheral Access Control Register, offset: 0x54 */
  __IO uint32_t PACRK;                             /**< Peripheral Access Control Register, offset: 0x58 */
  __IO uint32_t PACRL;                             /**< Peripheral Access Control Register, offset: 0x5C */
  __IO uint32_t PACRM;                             /**< Peripheral Access Control Register, offset: 0x60 */
  __IO uint32_t PACRN;                             /**< Peripheral Access Control Register, offset: 0x64 */
  __IO uint32_t PACRO;                             /**< Peripheral Access Control Register, offset: 0x68 */
  __IO uint32_t PACRP;                             /**< Peripheral Access Control Register, offset: 0x6C */
} AIPS_Type, *AIPS_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- AIPS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Register_Accessor_Macros AIPS - Register accessor macros
 * @{
 */


/* AIPS - Register accessors */
#define AIPS_MPRA_REG(base)                      ((base)->MPRA)
#define AIPS_PACRA_REG(base)                     ((base)->PACRA)
#define AIPS_PACRB_REG(base)                     ((base)->PACRB)
#define AIPS_PACRC_REG(base)                     ((base)->PACRC)
#define AIPS_PACRD_REG(base)                     ((base)->PACRD)
#define AIPS_PACRE_REG(base)                     ((base)->PACRE)
#define AIPS_PACRF_REG(base)                     ((base)->PACRF)
#define AIPS_PACRG_REG(base)                     ((base)->PACRG)
#define AIPS_PACRH_REG(base)                     ((base)->PACRH)
#define AIPS_PACRI_REG(base)                     ((base)->PACRI)
#define AIPS_PACRJ_REG(base)                     ((base)->PACRJ)
#define AIPS_PACRK_REG(base)                     ((base)->PACRK)
#define AIPS_PACRL_REG(base)                     ((base)->PACRL)
#define AIPS_PACRM_REG(base)                     ((base)->PACRM)
#define AIPS_PACRN_REG(base)                     ((base)->PACRN)
#define AIPS_PACRO_REG(base)                     ((base)->PACRO)
#define AIPS_PACRP_REG(base)                     ((base)->PACRP)

/*!
 * @}
 */ /* end of group AIPS_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- AIPS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Register_Masks AIPS Register Masks
 * @{
 */

/* MPRA Bit Fields */
#define AIPS_MPRA_MPL5_MASK                      0x100u
#define AIPS_MPRA_MPL5_SHIFT                     8
#define AIPS_MPRA_MPL5_WIDTH                     1
#define AIPS_MPRA_MPL5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL5_SHIFT))&AIPS_MPRA_MPL5_MASK)
#define AIPS_MPRA_MTW5_MASK                      0x200u
#define AIPS_MPRA_MTW5_SHIFT                     9
#define AIPS_MPRA_MTW5_WIDTH                     1
#define AIPS_MPRA_MTW5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW5_SHIFT))&AIPS_MPRA_MTW5_MASK)
#define AIPS_MPRA_MTR5_MASK                      0x400u
#define AIPS_MPRA_MTR5_SHIFT                     10
#define AIPS_MPRA_MTR5_WIDTH                     1
#define AIPS_MPRA_MTR5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR5_SHIFT))&AIPS_MPRA_MTR5_MASK)
#define AIPS_MPRA_MPL4_MASK                      0x1000u
#define AIPS_MPRA_MPL4_SHIFT                     12
#define AIPS_MPRA_MPL4_WIDTH                     1
#define AIPS_MPRA_MPL4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL4_SHIFT))&AIPS_MPRA_MPL4_MASK)
#define AIPS_MPRA_MTW4_MASK                      0x2000u
#define AIPS_MPRA_MTW4_SHIFT                     13
#define AIPS_MPRA_MTW4_WIDTH                     1
#define AIPS_MPRA_MTW4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW4_SHIFT))&AIPS_MPRA_MTW4_MASK)
#define AIPS_MPRA_MTR4_MASK                      0x4000u
#define AIPS_MPRA_MTR4_SHIFT                     14
#define AIPS_MPRA_MTR4_WIDTH                     1
#define AIPS_MPRA_MTR4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR4_SHIFT))&AIPS_MPRA_MTR4_MASK)
#define AIPS_MPRA_MPL2_MASK                      0x100000u
#define AIPS_MPRA_MPL2_SHIFT                     20
#define AIPS_MPRA_MPL2_WIDTH                     1
#define AIPS_MPRA_MPL2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL2_SHIFT))&AIPS_MPRA_MPL2_MASK)
#define AIPS_MPRA_MTW2_MASK                      0x200000u
#define AIPS_MPRA_MTW2_SHIFT                     21
#define AIPS_MPRA_MTW2_WIDTH                     1
#define AIPS_MPRA_MTW2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW2_SHIFT))&AIPS_MPRA_MTW2_MASK)
#define AIPS_MPRA_MTR2_MASK                      0x400000u
#define AIPS_MPRA_MTR2_SHIFT                     22
#define AIPS_MPRA_MTR2_WIDTH                     1
#define AIPS_MPRA_MTR2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR2_SHIFT))&AIPS_MPRA_MTR2_MASK)
#define AIPS_MPRA_MPL1_MASK                      0x1000000u
#define AIPS_MPRA_MPL1_SHIFT                     24
#define AIPS_MPRA_MPL1_WIDTH                     1
#define AIPS_MPRA_MPL1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL1_SHIFT))&AIPS_MPRA_MPL1_MASK)
#define AIPS_MPRA_MTW1_MASK                      0x2000000u
#define AIPS_MPRA_MTW1_SHIFT                     25
#define AIPS_MPRA_MTW1_WIDTH                     1
#define AIPS_MPRA_MTW1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW1_SHIFT))&AIPS_MPRA_MTW1_MASK)
#define AIPS_MPRA_MTR1_MASK                      0x4000000u
#define AIPS_MPRA_MTR1_SHIFT                     26
#define AIPS_MPRA_MTR1_WIDTH                     1
#define AIPS_MPRA_MTR1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR1_SHIFT))&AIPS_MPRA_MTR1_MASK)
#define AIPS_MPRA_MPL0_MASK                      0x10000000u
#define AIPS_MPRA_MPL0_SHIFT                     28
#define AIPS_MPRA_MPL0_WIDTH                     1
#define AIPS_MPRA_MPL0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL0_SHIFT))&AIPS_MPRA_MPL0_MASK)
#define AIPS_MPRA_MTW0_MASK                      0x20000000u
#define AIPS_MPRA_MTW0_SHIFT                     29
#define AIPS_MPRA_MTW0_WIDTH                     1
#define AIPS_MPRA_MTW0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW0_SHIFT))&AIPS_MPRA_MTW0_MASK)
#define AIPS_MPRA_MTR0_MASK                      0x40000000u
#define AIPS_MPRA_MTR0_SHIFT                     30
#define AIPS_MPRA_MTR0_WIDTH                     1
#define AIPS_MPRA_MTR0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR0_SHIFT))&AIPS_MPRA_MTR0_MASK)
/* PACRA Bit Fields */
#define AIPS_PACRA_TP7_MASK                      0x1u
#define AIPS_PACRA_TP7_SHIFT                     0
#define AIPS_PACRA_TP7_WIDTH                     1
#define AIPS_PACRA_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP7_SHIFT))&AIPS_PACRA_TP7_MASK)
#define AIPS_PACRA_WP7_MASK                      0x2u
#define AIPS_PACRA_WP7_SHIFT                     1
#define AIPS_PACRA_WP7_WIDTH                     1
#define AIPS_PACRA_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP7_SHIFT))&AIPS_PACRA_WP7_MASK)
#define AIPS_PACRA_SP7_MASK                      0x4u
#define AIPS_PACRA_SP7_SHIFT                     2
#define AIPS_PACRA_SP7_WIDTH                     1
#define AIPS_PACRA_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP7_SHIFT))&AIPS_PACRA_SP7_MASK)
#define AIPS_PACRA_TP6_MASK                      0x10u
#define AIPS_PACRA_TP6_SHIFT                     4
#define AIPS_PACRA_TP6_WIDTH                     1
#define AIPS_PACRA_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP6_SHIFT))&AIPS_PACRA_TP6_MASK)
#define AIPS_PACRA_WP6_MASK                      0x20u
#define AIPS_PACRA_WP6_SHIFT                     5
#define AIPS_PACRA_WP6_WIDTH                     1
#define AIPS_PACRA_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP6_SHIFT))&AIPS_PACRA_WP6_MASK)
#define AIPS_PACRA_SP6_MASK                      0x40u
#define AIPS_PACRA_SP6_SHIFT                     6
#define AIPS_PACRA_SP6_WIDTH                     1
#define AIPS_PACRA_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP6_SHIFT))&AIPS_PACRA_SP6_MASK)
#define AIPS_PACRA_TP5_MASK                      0x100u
#define AIPS_PACRA_TP5_SHIFT                     8
#define AIPS_PACRA_TP5_WIDTH                     1
#define AIPS_PACRA_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP5_SHIFT))&AIPS_PACRA_TP5_MASK)
#define AIPS_PACRA_WP5_MASK                      0x200u
#define AIPS_PACRA_WP5_SHIFT                     9
#define AIPS_PACRA_WP5_WIDTH                     1
#define AIPS_PACRA_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP5_SHIFT))&AIPS_PACRA_WP5_MASK)
#define AIPS_PACRA_SP5_MASK                      0x400u
#define AIPS_PACRA_SP5_SHIFT                     10
#define AIPS_PACRA_SP5_WIDTH                     1
#define AIPS_PACRA_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP5_SHIFT))&AIPS_PACRA_SP5_MASK)
#define AIPS_PACRA_TP4_MASK                      0x1000u
#define AIPS_PACRA_TP4_SHIFT                     12
#define AIPS_PACRA_TP4_WIDTH                     1
#define AIPS_PACRA_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP4_SHIFT))&AIPS_PACRA_TP4_MASK)
#define AIPS_PACRA_WP4_MASK                      0x2000u
#define AIPS_PACRA_WP4_SHIFT                     13
#define AIPS_PACRA_WP4_WIDTH                     1
#define AIPS_PACRA_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP4_SHIFT))&AIPS_PACRA_WP4_MASK)
#define AIPS_PACRA_SP4_MASK                      0x4000u
#define AIPS_PACRA_SP4_SHIFT                     14
#define AIPS_PACRA_SP4_WIDTH                     1
#define AIPS_PACRA_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP4_SHIFT))&AIPS_PACRA_SP4_MASK)
#define AIPS_PACRA_TP3_MASK                      0x10000u
#define AIPS_PACRA_TP3_SHIFT                     16
#define AIPS_PACRA_TP3_WIDTH                     1
#define AIPS_PACRA_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP3_SHIFT))&AIPS_PACRA_TP3_MASK)
#define AIPS_PACRA_WP3_MASK                      0x20000u
#define AIPS_PACRA_WP3_SHIFT                     17
#define AIPS_PACRA_WP3_WIDTH                     1
#define AIPS_PACRA_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP3_SHIFT))&AIPS_PACRA_WP3_MASK)
#define AIPS_PACRA_SP3_MASK                      0x40000u
#define AIPS_PACRA_SP3_SHIFT                     18
#define AIPS_PACRA_SP3_WIDTH                     1
#define AIPS_PACRA_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP3_SHIFT))&AIPS_PACRA_SP3_MASK)
#define AIPS_PACRA_TP2_MASK                      0x100000u
#define AIPS_PACRA_TP2_SHIFT                     20
#define AIPS_PACRA_TP2_WIDTH                     1
#define AIPS_PACRA_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP2_SHIFT))&AIPS_PACRA_TP2_MASK)
#define AIPS_PACRA_WP2_MASK                      0x200000u
#define AIPS_PACRA_WP2_SHIFT                     21
#define AIPS_PACRA_WP2_WIDTH                     1
#define AIPS_PACRA_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP2_SHIFT))&AIPS_PACRA_WP2_MASK)
#define AIPS_PACRA_SP2_MASK                      0x400000u
#define AIPS_PACRA_SP2_SHIFT                     22
#define AIPS_PACRA_SP2_WIDTH                     1
#define AIPS_PACRA_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP2_SHIFT))&AIPS_PACRA_SP2_MASK)
#define AIPS_PACRA_TP1_MASK                      0x1000000u
#define AIPS_PACRA_TP1_SHIFT                     24
#define AIPS_PACRA_TP1_WIDTH                     1
#define AIPS_PACRA_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP1_SHIFT))&AIPS_PACRA_TP1_MASK)
#define AIPS_PACRA_WP1_MASK                      0x2000000u
#define AIPS_PACRA_WP1_SHIFT                     25
#define AIPS_PACRA_WP1_WIDTH                     1
#define AIPS_PACRA_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP1_SHIFT))&AIPS_PACRA_WP1_MASK)
#define AIPS_PACRA_SP1_MASK                      0x4000000u
#define AIPS_PACRA_SP1_SHIFT                     26
#define AIPS_PACRA_SP1_WIDTH                     1
#define AIPS_PACRA_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP1_SHIFT))&AIPS_PACRA_SP1_MASK)
#define AIPS_PACRA_TP0_MASK                      0x10000000u
#define AIPS_PACRA_TP0_SHIFT                     28
#define AIPS_PACRA_TP0_WIDTH                     1
#define AIPS_PACRA_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP0_SHIFT))&AIPS_PACRA_TP0_MASK)
#define AIPS_PACRA_WP0_MASK                      0x20000000u
#define AIPS_PACRA_WP0_SHIFT                     29
#define AIPS_PACRA_WP0_WIDTH                     1
#define AIPS_PACRA_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP0_SHIFT))&AIPS_PACRA_WP0_MASK)
#define AIPS_PACRA_SP0_MASK                      0x40000000u
#define AIPS_PACRA_SP0_SHIFT                     30
#define AIPS_PACRA_SP0_WIDTH                     1
#define AIPS_PACRA_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP0_SHIFT))&AIPS_PACRA_SP0_MASK)
/* PACRB Bit Fields */
#define AIPS_PACRB_TP7_MASK                      0x1u
#define AIPS_PACRB_TP7_SHIFT                     0
#define AIPS_PACRB_TP7_WIDTH                     1
#define AIPS_PACRB_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP7_SHIFT))&AIPS_PACRB_TP7_MASK)
#define AIPS_PACRB_WP7_MASK                      0x2u
#define AIPS_PACRB_WP7_SHIFT                     1
#define AIPS_PACRB_WP7_WIDTH                     1
#define AIPS_PACRB_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP7_SHIFT))&AIPS_PACRB_WP7_MASK)
#define AIPS_PACRB_SP7_MASK                      0x4u
#define AIPS_PACRB_SP7_SHIFT                     2
#define AIPS_PACRB_SP7_WIDTH                     1
#define AIPS_PACRB_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP7_SHIFT))&AIPS_PACRB_SP7_MASK)
#define AIPS_PACRB_TP6_MASK                      0x10u
#define AIPS_PACRB_TP6_SHIFT                     4
#define AIPS_PACRB_TP6_WIDTH                     1
#define AIPS_PACRB_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP6_SHIFT))&AIPS_PACRB_TP6_MASK)
#define AIPS_PACRB_WP6_MASK                      0x20u
#define AIPS_PACRB_WP6_SHIFT                     5
#define AIPS_PACRB_WP6_WIDTH                     1
#define AIPS_PACRB_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP6_SHIFT))&AIPS_PACRB_WP6_MASK)
#define AIPS_PACRB_SP6_MASK                      0x40u
#define AIPS_PACRB_SP6_SHIFT                     6
#define AIPS_PACRB_SP6_WIDTH                     1
#define AIPS_PACRB_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP6_SHIFT))&AIPS_PACRB_SP6_MASK)
#define AIPS_PACRB_TP5_MASK                      0x100u
#define AIPS_PACRB_TP5_SHIFT                     8
#define AIPS_PACRB_TP5_WIDTH                     1
#define AIPS_PACRB_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP5_SHIFT))&AIPS_PACRB_TP5_MASK)
#define AIPS_PACRB_WP5_MASK                      0x200u
#define AIPS_PACRB_WP5_SHIFT                     9
#define AIPS_PACRB_WP5_WIDTH                     1
#define AIPS_PACRB_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP5_SHIFT))&AIPS_PACRB_WP5_MASK)
#define AIPS_PACRB_SP5_MASK                      0x400u
#define AIPS_PACRB_SP5_SHIFT                     10
#define AIPS_PACRB_SP5_WIDTH                     1
#define AIPS_PACRB_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP5_SHIFT))&AIPS_PACRB_SP5_MASK)
#define AIPS_PACRB_TP4_MASK                      0x1000u
#define AIPS_PACRB_TP4_SHIFT                     12
#define AIPS_PACRB_TP4_WIDTH                     1
#define AIPS_PACRB_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP4_SHIFT))&AIPS_PACRB_TP4_MASK)
#define AIPS_PACRB_WP4_MASK                      0x2000u
#define AIPS_PACRB_WP4_SHIFT                     13
#define AIPS_PACRB_WP4_WIDTH                     1
#define AIPS_PACRB_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP4_SHIFT))&AIPS_PACRB_WP4_MASK)
#define AIPS_PACRB_SP4_MASK                      0x4000u
#define AIPS_PACRB_SP4_SHIFT                     14
#define AIPS_PACRB_SP4_WIDTH                     1
#define AIPS_PACRB_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP4_SHIFT))&AIPS_PACRB_SP4_MASK)
#define AIPS_PACRB_TP3_MASK                      0x10000u
#define AIPS_PACRB_TP3_SHIFT                     16
#define AIPS_PACRB_TP3_WIDTH                     1
#define AIPS_PACRB_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP3_SHIFT))&AIPS_PACRB_TP3_MASK)
#define AIPS_PACRB_WP3_MASK                      0x20000u
#define AIPS_PACRB_WP3_SHIFT                     17
#define AIPS_PACRB_WP3_WIDTH                     1
#define AIPS_PACRB_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP3_SHIFT))&AIPS_PACRB_WP3_MASK)
#define AIPS_PACRB_SP3_MASK                      0x40000u
#define AIPS_PACRB_SP3_SHIFT                     18
#define AIPS_PACRB_SP3_WIDTH                     1
#define AIPS_PACRB_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP3_SHIFT))&AIPS_PACRB_SP3_MASK)
#define AIPS_PACRB_TP2_MASK                      0x100000u
#define AIPS_PACRB_TP2_SHIFT                     20
#define AIPS_PACRB_TP2_WIDTH                     1
#define AIPS_PACRB_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP2_SHIFT))&AIPS_PACRB_TP2_MASK)
#define AIPS_PACRB_WP2_MASK                      0x200000u
#define AIPS_PACRB_WP2_SHIFT                     21
#define AIPS_PACRB_WP2_WIDTH                     1
#define AIPS_PACRB_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP2_SHIFT))&AIPS_PACRB_WP2_MASK)
#define AIPS_PACRB_SP2_MASK                      0x400000u
#define AIPS_PACRB_SP2_SHIFT                     22
#define AIPS_PACRB_SP2_WIDTH                     1
#define AIPS_PACRB_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP2_SHIFT))&AIPS_PACRB_SP2_MASK)
#define AIPS_PACRB_TP1_MASK                      0x1000000u
#define AIPS_PACRB_TP1_SHIFT                     24
#define AIPS_PACRB_TP1_WIDTH                     1
#define AIPS_PACRB_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP1_SHIFT))&AIPS_PACRB_TP1_MASK)
#define AIPS_PACRB_WP1_MASK                      0x2000000u
#define AIPS_PACRB_WP1_SHIFT                     25
#define AIPS_PACRB_WP1_WIDTH                     1
#define AIPS_PACRB_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP1_SHIFT))&AIPS_PACRB_WP1_MASK)
#define AIPS_PACRB_SP1_MASK                      0x4000000u
#define AIPS_PACRB_SP1_SHIFT                     26
#define AIPS_PACRB_SP1_WIDTH                     1
#define AIPS_PACRB_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP1_SHIFT))&AIPS_PACRB_SP1_MASK)
#define AIPS_PACRB_TP0_MASK                      0x10000000u
#define AIPS_PACRB_TP0_SHIFT                     28
#define AIPS_PACRB_TP0_WIDTH                     1
#define AIPS_PACRB_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP0_SHIFT))&AIPS_PACRB_TP0_MASK)
#define AIPS_PACRB_WP0_MASK                      0x20000000u
#define AIPS_PACRB_WP0_SHIFT                     29
#define AIPS_PACRB_WP0_WIDTH                     1
#define AIPS_PACRB_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP0_SHIFT))&AIPS_PACRB_WP0_MASK)
#define AIPS_PACRB_SP0_MASK                      0x40000000u
#define AIPS_PACRB_SP0_SHIFT                     30
#define AIPS_PACRB_SP0_WIDTH                     1
#define AIPS_PACRB_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP0_SHIFT))&AIPS_PACRB_SP0_MASK)
/* PACRC Bit Fields */
#define AIPS_PACRC_TP7_MASK                      0x1u
#define AIPS_PACRC_TP7_SHIFT                     0
#define AIPS_PACRC_TP7_WIDTH                     1
#define AIPS_PACRC_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP7_SHIFT))&AIPS_PACRC_TP7_MASK)
#define AIPS_PACRC_WP7_MASK                      0x2u
#define AIPS_PACRC_WP7_SHIFT                     1
#define AIPS_PACRC_WP7_WIDTH                     1
#define AIPS_PACRC_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP7_SHIFT))&AIPS_PACRC_WP7_MASK)
#define AIPS_PACRC_SP7_MASK                      0x4u
#define AIPS_PACRC_SP7_SHIFT                     2
#define AIPS_PACRC_SP7_WIDTH                     1
#define AIPS_PACRC_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP7_SHIFT))&AIPS_PACRC_SP7_MASK)
#define AIPS_PACRC_TP6_MASK                      0x10u
#define AIPS_PACRC_TP6_SHIFT                     4
#define AIPS_PACRC_TP6_WIDTH                     1
#define AIPS_PACRC_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP6_SHIFT))&AIPS_PACRC_TP6_MASK)
#define AIPS_PACRC_WP6_MASK                      0x20u
#define AIPS_PACRC_WP6_SHIFT                     5
#define AIPS_PACRC_WP6_WIDTH                     1
#define AIPS_PACRC_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP6_SHIFT))&AIPS_PACRC_WP6_MASK)
#define AIPS_PACRC_SP6_MASK                      0x40u
#define AIPS_PACRC_SP6_SHIFT                     6
#define AIPS_PACRC_SP6_WIDTH                     1
#define AIPS_PACRC_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP6_SHIFT))&AIPS_PACRC_SP6_MASK)
#define AIPS_PACRC_TP5_MASK                      0x100u
#define AIPS_PACRC_TP5_SHIFT                     8
#define AIPS_PACRC_TP5_WIDTH                     1
#define AIPS_PACRC_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP5_SHIFT))&AIPS_PACRC_TP5_MASK)
#define AIPS_PACRC_WP5_MASK                      0x200u
#define AIPS_PACRC_WP5_SHIFT                     9
#define AIPS_PACRC_WP5_WIDTH                     1
#define AIPS_PACRC_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP5_SHIFT))&AIPS_PACRC_WP5_MASK)
#define AIPS_PACRC_SP5_MASK                      0x400u
#define AIPS_PACRC_SP5_SHIFT                     10
#define AIPS_PACRC_SP5_WIDTH                     1
#define AIPS_PACRC_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP5_SHIFT))&AIPS_PACRC_SP5_MASK)
#define AIPS_PACRC_TP4_MASK                      0x1000u
#define AIPS_PACRC_TP4_SHIFT                     12
#define AIPS_PACRC_TP4_WIDTH                     1
#define AIPS_PACRC_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP4_SHIFT))&AIPS_PACRC_TP4_MASK)
#define AIPS_PACRC_WP4_MASK                      0x2000u
#define AIPS_PACRC_WP4_SHIFT                     13
#define AIPS_PACRC_WP4_WIDTH                     1
#define AIPS_PACRC_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP4_SHIFT))&AIPS_PACRC_WP4_MASK)
#define AIPS_PACRC_SP4_MASK                      0x4000u
#define AIPS_PACRC_SP4_SHIFT                     14
#define AIPS_PACRC_SP4_WIDTH                     1
#define AIPS_PACRC_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP4_SHIFT))&AIPS_PACRC_SP4_MASK)
#define AIPS_PACRC_TP3_MASK                      0x10000u
#define AIPS_PACRC_TP3_SHIFT                     16
#define AIPS_PACRC_TP3_WIDTH                     1
#define AIPS_PACRC_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP3_SHIFT))&AIPS_PACRC_TP3_MASK)
#define AIPS_PACRC_WP3_MASK                      0x20000u
#define AIPS_PACRC_WP3_SHIFT                     17
#define AIPS_PACRC_WP3_WIDTH                     1
#define AIPS_PACRC_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP3_SHIFT))&AIPS_PACRC_WP3_MASK)
#define AIPS_PACRC_SP3_MASK                      0x40000u
#define AIPS_PACRC_SP3_SHIFT                     18
#define AIPS_PACRC_SP3_WIDTH                     1
#define AIPS_PACRC_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP3_SHIFT))&AIPS_PACRC_SP3_MASK)
#define AIPS_PACRC_TP2_MASK                      0x100000u
#define AIPS_PACRC_TP2_SHIFT                     20
#define AIPS_PACRC_TP2_WIDTH                     1
#define AIPS_PACRC_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP2_SHIFT))&AIPS_PACRC_TP2_MASK)
#define AIPS_PACRC_WP2_MASK                      0x200000u
#define AIPS_PACRC_WP2_SHIFT                     21
#define AIPS_PACRC_WP2_WIDTH                     1
#define AIPS_PACRC_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP2_SHIFT))&AIPS_PACRC_WP2_MASK)
#define AIPS_PACRC_SP2_MASK                      0x400000u
#define AIPS_PACRC_SP2_SHIFT                     22
#define AIPS_PACRC_SP2_WIDTH                     1
#define AIPS_PACRC_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP2_SHIFT))&AIPS_PACRC_SP2_MASK)
#define AIPS_PACRC_TP1_MASK                      0x1000000u
#define AIPS_PACRC_TP1_SHIFT                     24
#define AIPS_PACRC_TP1_WIDTH                     1
#define AIPS_PACRC_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP1_SHIFT))&AIPS_PACRC_TP1_MASK)
#define AIPS_PACRC_WP1_MASK                      0x2000000u
#define AIPS_PACRC_WP1_SHIFT                     25
#define AIPS_PACRC_WP1_WIDTH                     1
#define AIPS_PACRC_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP1_SHIFT))&AIPS_PACRC_WP1_MASK)
#define AIPS_PACRC_SP1_MASK                      0x4000000u
#define AIPS_PACRC_SP1_SHIFT                     26
#define AIPS_PACRC_SP1_WIDTH                     1
#define AIPS_PACRC_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP1_SHIFT))&AIPS_PACRC_SP1_MASK)
#define AIPS_PACRC_TP0_MASK                      0x10000000u
#define AIPS_PACRC_TP0_SHIFT                     28
#define AIPS_PACRC_TP0_WIDTH                     1
#define AIPS_PACRC_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP0_SHIFT))&AIPS_PACRC_TP0_MASK)
#define AIPS_PACRC_WP0_MASK                      0x20000000u
#define AIPS_PACRC_WP0_SHIFT                     29
#define AIPS_PACRC_WP0_WIDTH                     1
#define AIPS_PACRC_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP0_SHIFT))&AIPS_PACRC_WP0_MASK)
#define AIPS_PACRC_SP0_MASK                      0x40000000u
#define AIPS_PACRC_SP0_SHIFT                     30
#define AIPS_PACRC_SP0_WIDTH                     1
#define AIPS_PACRC_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP0_SHIFT))&AIPS_PACRC_SP0_MASK)
/* PACRD Bit Fields */
#define AIPS_PACRD_TP7_MASK                      0x1u
#define AIPS_PACRD_TP7_SHIFT                     0
#define AIPS_PACRD_TP7_WIDTH                     1
#define AIPS_PACRD_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP7_SHIFT))&AIPS_PACRD_TP7_MASK)
#define AIPS_PACRD_WP7_MASK                      0x2u
#define AIPS_PACRD_WP7_SHIFT                     1
#define AIPS_PACRD_WP7_WIDTH                     1
#define AIPS_PACRD_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP7_SHIFT))&AIPS_PACRD_WP7_MASK)
#define AIPS_PACRD_SP7_MASK                      0x4u
#define AIPS_PACRD_SP7_SHIFT                     2
#define AIPS_PACRD_SP7_WIDTH                     1
#define AIPS_PACRD_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP7_SHIFT))&AIPS_PACRD_SP7_MASK)
#define AIPS_PACRD_TP6_MASK                      0x10u
#define AIPS_PACRD_TP6_SHIFT                     4
#define AIPS_PACRD_TP6_WIDTH                     1
#define AIPS_PACRD_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP6_SHIFT))&AIPS_PACRD_TP6_MASK)
#define AIPS_PACRD_WP6_MASK                      0x20u
#define AIPS_PACRD_WP6_SHIFT                     5
#define AIPS_PACRD_WP6_WIDTH                     1
#define AIPS_PACRD_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP6_SHIFT))&AIPS_PACRD_WP6_MASK)
#define AIPS_PACRD_SP6_MASK                      0x40u
#define AIPS_PACRD_SP6_SHIFT                     6
#define AIPS_PACRD_SP6_WIDTH                     1
#define AIPS_PACRD_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP6_SHIFT))&AIPS_PACRD_SP6_MASK)
#define AIPS_PACRD_TP5_MASK                      0x100u
#define AIPS_PACRD_TP5_SHIFT                     8
#define AIPS_PACRD_TP5_WIDTH                     1
#define AIPS_PACRD_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP5_SHIFT))&AIPS_PACRD_TP5_MASK)
#define AIPS_PACRD_WP5_MASK                      0x200u
#define AIPS_PACRD_WP5_SHIFT                     9
#define AIPS_PACRD_WP5_WIDTH                     1
#define AIPS_PACRD_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP5_SHIFT))&AIPS_PACRD_WP5_MASK)
#define AIPS_PACRD_SP5_MASK                      0x400u
#define AIPS_PACRD_SP5_SHIFT                     10
#define AIPS_PACRD_SP5_WIDTH                     1
#define AIPS_PACRD_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP5_SHIFT))&AIPS_PACRD_SP5_MASK)
#define AIPS_PACRD_TP4_MASK                      0x1000u
#define AIPS_PACRD_TP4_SHIFT                     12
#define AIPS_PACRD_TP4_WIDTH                     1
#define AIPS_PACRD_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP4_SHIFT))&AIPS_PACRD_TP4_MASK)
#define AIPS_PACRD_WP4_MASK                      0x2000u
#define AIPS_PACRD_WP4_SHIFT                     13
#define AIPS_PACRD_WP4_WIDTH                     1
#define AIPS_PACRD_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP4_SHIFT))&AIPS_PACRD_WP4_MASK)
#define AIPS_PACRD_SP4_MASK                      0x4000u
#define AIPS_PACRD_SP4_SHIFT                     14
#define AIPS_PACRD_SP4_WIDTH                     1
#define AIPS_PACRD_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP4_SHIFT))&AIPS_PACRD_SP4_MASK)
#define AIPS_PACRD_TP3_MASK                      0x10000u
#define AIPS_PACRD_TP3_SHIFT                     16
#define AIPS_PACRD_TP3_WIDTH                     1
#define AIPS_PACRD_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP3_SHIFT))&AIPS_PACRD_TP3_MASK)
#define AIPS_PACRD_WP3_MASK                      0x20000u
#define AIPS_PACRD_WP3_SHIFT                     17
#define AIPS_PACRD_WP3_WIDTH                     1
#define AIPS_PACRD_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP3_SHIFT))&AIPS_PACRD_WP3_MASK)
#define AIPS_PACRD_SP3_MASK                      0x40000u
#define AIPS_PACRD_SP3_SHIFT                     18
#define AIPS_PACRD_SP3_WIDTH                     1
#define AIPS_PACRD_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP3_SHIFT))&AIPS_PACRD_SP3_MASK)
#define AIPS_PACRD_TP2_MASK                      0x100000u
#define AIPS_PACRD_TP2_SHIFT                     20
#define AIPS_PACRD_TP2_WIDTH                     1
#define AIPS_PACRD_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP2_SHIFT))&AIPS_PACRD_TP2_MASK)
#define AIPS_PACRD_WP2_MASK                      0x200000u
#define AIPS_PACRD_WP2_SHIFT                     21
#define AIPS_PACRD_WP2_WIDTH                     1
#define AIPS_PACRD_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP2_SHIFT))&AIPS_PACRD_WP2_MASK)
#define AIPS_PACRD_SP2_MASK                      0x400000u
#define AIPS_PACRD_SP2_SHIFT                     22
#define AIPS_PACRD_SP2_WIDTH                     1
#define AIPS_PACRD_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP2_SHIFT))&AIPS_PACRD_SP2_MASK)
#define AIPS_PACRD_TP1_MASK                      0x1000000u
#define AIPS_PACRD_TP1_SHIFT                     24
#define AIPS_PACRD_TP1_WIDTH                     1
#define AIPS_PACRD_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP1_SHIFT))&AIPS_PACRD_TP1_MASK)
#define AIPS_PACRD_WP1_MASK                      0x2000000u
#define AIPS_PACRD_WP1_SHIFT                     25
#define AIPS_PACRD_WP1_WIDTH                     1
#define AIPS_PACRD_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP1_SHIFT))&AIPS_PACRD_WP1_MASK)
#define AIPS_PACRD_SP1_MASK                      0x4000000u
#define AIPS_PACRD_SP1_SHIFT                     26
#define AIPS_PACRD_SP1_WIDTH                     1
#define AIPS_PACRD_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP1_SHIFT))&AIPS_PACRD_SP1_MASK)
#define AIPS_PACRD_TP0_MASK                      0x10000000u
#define AIPS_PACRD_TP0_SHIFT                     28
#define AIPS_PACRD_TP0_WIDTH                     1
#define AIPS_PACRD_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP0_SHIFT))&AIPS_PACRD_TP0_MASK)
#define AIPS_PACRD_WP0_MASK                      0x20000000u
#define AIPS_PACRD_WP0_SHIFT                     29
#define AIPS_PACRD_WP0_WIDTH                     1
#define AIPS_PACRD_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP0_SHIFT))&AIPS_PACRD_WP0_MASK)
#define AIPS_PACRD_SP0_MASK                      0x40000000u
#define AIPS_PACRD_SP0_SHIFT                     30
#define AIPS_PACRD_SP0_WIDTH                     1
#define AIPS_PACRD_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP0_SHIFT))&AIPS_PACRD_SP0_MASK)
/* PACRE Bit Fields */
#define AIPS_PACRE_TP7_MASK                      0x1u
#define AIPS_PACRE_TP7_SHIFT                     0
#define AIPS_PACRE_TP7_WIDTH                     1
#define AIPS_PACRE_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP7_SHIFT))&AIPS_PACRE_TP7_MASK)
#define AIPS_PACRE_WP7_MASK                      0x2u
#define AIPS_PACRE_WP7_SHIFT                     1
#define AIPS_PACRE_WP7_WIDTH                     1
#define AIPS_PACRE_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP7_SHIFT))&AIPS_PACRE_WP7_MASK)
#define AIPS_PACRE_SP7_MASK                      0x4u
#define AIPS_PACRE_SP7_SHIFT                     2
#define AIPS_PACRE_SP7_WIDTH                     1
#define AIPS_PACRE_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP7_SHIFT))&AIPS_PACRE_SP7_MASK)
#define AIPS_PACRE_TP6_MASK                      0x10u
#define AIPS_PACRE_TP6_SHIFT                     4
#define AIPS_PACRE_TP6_WIDTH                     1
#define AIPS_PACRE_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP6_SHIFT))&AIPS_PACRE_TP6_MASK)
#define AIPS_PACRE_WP6_MASK                      0x20u
#define AIPS_PACRE_WP6_SHIFT                     5
#define AIPS_PACRE_WP6_WIDTH                     1
#define AIPS_PACRE_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP6_SHIFT))&AIPS_PACRE_WP6_MASK)
#define AIPS_PACRE_SP6_MASK                      0x40u
#define AIPS_PACRE_SP6_SHIFT                     6
#define AIPS_PACRE_SP6_WIDTH                     1
#define AIPS_PACRE_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP6_SHIFT))&AIPS_PACRE_SP6_MASK)
#define AIPS_PACRE_TP5_MASK                      0x100u
#define AIPS_PACRE_TP5_SHIFT                     8
#define AIPS_PACRE_TP5_WIDTH                     1
#define AIPS_PACRE_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP5_SHIFT))&AIPS_PACRE_TP5_MASK)
#define AIPS_PACRE_WP5_MASK                      0x200u
#define AIPS_PACRE_WP5_SHIFT                     9
#define AIPS_PACRE_WP5_WIDTH                     1
#define AIPS_PACRE_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP5_SHIFT))&AIPS_PACRE_WP5_MASK)
#define AIPS_PACRE_SP5_MASK                      0x400u
#define AIPS_PACRE_SP5_SHIFT                     10
#define AIPS_PACRE_SP5_WIDTH                     1
#define AIPS_PACRE_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP5_SHIFT))&AIPS_PACRE_SP5_MASK)
#define AIPS_PACRE_TP4_MASK                      0x1000u
#define AIPS_PACRE_TP4_SHIFT                     12
#define AIPS_PACRE_TP4_WIDTH                     1
#define AIPS_PACRE_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP4_SHIFT))&AIPS_PACRE_TP4_MASK)
#define AIPS_PACRE_WP4_MASK                      0x2000u
#define AIPS_PACRE_WP4_SHIFT                     13
#define AIPS_PACRE_WP4_WIDTH                     1
#define AIPS_PACRE_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP4_SHIFT))&AIPS_PACRE_WP4_MASK)
#define AIPS_PACRE_SP4_MASK                      0x4000u
#define AIPS_PACRE_SP4_SHIFT                     14
#define AIPS_PACRE_SP4_WIDTH                     1
#define AIPS_PACRE_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP4_SHIFT))&AIPS_PACRE_SP4_MASK)
#define AIPS_PACRE_TP3_MASK                      0x10000u
#define AIPS_PACRE_TP3_SHIFT                     16
#define AIPS_PACRE_TP3_WIDTH                     1
#define AIPS_PACRE_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP3_SHIFT))&AIPS_PACRE_TP3_MASK)
#define AIPS_PACRE_WP3_MASK                      0x20000u
#define AIPS_PACRE_WP3_SHIFT                     17
#define AIPS_PACRE_WP3_WIDTH                     1
#define AIPS_PACRE_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP3_SHIFT))&AIPS_PACRE_WP3_MASK)
#define AIPS_PACRE_SP3_MASK                      0x40000u
#define AIPS_PACRE_SP3_SHIFT                     18
#define AIPS_PACRE_SP3_WIDTH                     1
#define AIPS_PACRE_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP3_SHIFT))&AIPS_PACRE_SP3_MASK)
#define AIPS_PACRE_TP2_MASK                      0x100000u
#define AIPS_PACRE_TP2_SHIFT                     20
#define AIPS_PACRE_TP2_WIDTH                     1
#define AIPS_PACRE_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP2_SHIFT))&AIPS_PACRE_TP2_MASK)
#define AIPS_PACRE_WP2_MASK                      0x200000u
#define AIPS_PACRE_WP2_SHIFT                     21
#define AIPS_PACRE_WP2_WIDTH                     1
#define AIPS_PACRE_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP2_SHIFT))&AIPS_PACRE_WP2_MASK)
#define AIPS_PACRE_SP2_MASK                      0x400000u
#define AIPS_PACRE_SP2_SHIFT                     22
#define AIPS_PACRE_SP2_WIDTH                     1
#define AIPS_PACRE_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP2_SHIFT))&AIPS_PACRE_SP2_MASK)
#define AIPS_PACRE_TP1_MASK                      0x1000000u
#define AIPS_PACRE_TP1_SHIFT                     24
#define AIPS_PACRE_TP1_WIDTH                     1
#define AIPS_PACRE_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP1_SHIFT))&AIPS_PACRE_TP1_MASK)
#define AIPS_PACRE_WP1_MASK                      0x2000000u
#define AIPS_PACRE_WP1_SHIFT                     25
#define AIPS_PACRE_WP1_WIDTH                     1
#define AIPS_PACRE_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP1_SHIFT))&AIPS_PACRE_WP1_MASK)
#define AIPS_PACRE_SP1_MASK                      0x4000000u
#define AIPS_PACRE_SP1_SHIFT                     26
#define AIPS_PACRE_SP1_WIDTH                     1
#define AIPS_PACRE_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP1_SHIFT))&AIPS_PACRE_SP1_MASK)
#define AIPS_PACRE_TP0_MASK                      0x10000000u
#define AIPS_PACRE_TP0_SHIFT                     28
#define AIPS_PACRE_TP0_WIDTH                     1
#define AIPS_PACRE_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP0_SHIFT))&AIPS_PACRE_TP0_MASK)
#define AIPS_PACRE_WP0_MASK                      0x20000000u
#define AIPS_PACRE_WP0_SHIFT                     29
#define AIPS_PACRE_WP0_WIDTH                     1
#define AIPS_PACRE_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP0_SHIFT))&AIPS_PACRE_WP0_MASK)
#define AIPS_PACRE_SP0_MASK                      0x40000000u
#define AIPS_PACRE_SP0_SHIFT                     30
#define AIPS_PACRE_SP0_WIDTH                     1
#define AIPS_PACRE_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP0_SHIFT))&AIPS_PACRE_SP0_MASK)
/* PACRF Bit Fields */
#define AIPS_PACRF_TP7_MASK                      0x1u
#define AIPS_PACRF_TP7_SHIFT                     0
#define AIPS_PACRF_TP7_WIDTH                     1
#define AIPS_PACRF_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP7_SHIFT))&AIPS_PACRF_TP7_MASK)
#define AIPS_PACRF_WP7_MASK                      0x2u
#define AIPS_PACRF_WP7_SHIFT                     1
#define AIPS_PACRF_WP7_WIDTH                     1
#define AIPS_PACRF_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP7_SHIFT))&AIPS_PACRF_WP7_MASK)
#define AIPS_PACRF_SP7_MASK                      0x4u
#define AIPS_PACRF_SP7_SHIFT                     2
#define AIPS_PACRF_SP7_WIDTH                     1
#define AIPS_PACRF_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP7_SHIFT))&AIPS_PACRF_SP7_MASK)
#define AIPS_PACRF_TP6_MASK                      0x10u
#define AIPS_PACRF_TP6_SHIFT                     4
#define AIPS_PACRF_TP6_WIDTH                     1
#define AIPS_PACRF_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP6_SHIFT))&AIPS_PACRF_TP6_MASK)
#define AIPS_PACRF_WP6_MASK                      0x20u
#define AIPS_PACRF_WP6_SHIFT                     5
#define AIPS_PACRF_WP6_WIDTH                     1
#define AIPS_PACRF_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP6_SHIFT))&AIPS_PACRF_WP6_MASK)
#define AIPS_PACRF_SP6_MASK                      0x40u
#define AIPS_PACRF_SP6_SHIFT                     6
#define AIPS_PACRF_SP6_WIDTH                     1
#define AIPS_PACRF_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP6_SHIFT))&AIPS_PACRF_SP6_MASK)
#define AIPS_PACRF_TP5_MASK                      0x100u
#define AIPS_PACRF_TP5_SHIFT                     8
#define AIPS_PACRF_TP5_WIDTH                     1
#define AIPS_PACRF_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP5_SHIFT))&AIPS_PACRF_TP5_MASK)
#define AIPS_PACRF_WP5_MASK                      0x200u
#define AIPS_PACRF_WP5_SHIFT                     9
#define AIPS_PACRF_WP5_WIDTH                     1
#define AIPS_PACRF_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP5_SHIFT))&AIPS_PACRF_WP5_MASK)
#define AIPS_PACRF_SP5_MASK                      0x400u
#define AIPS_PACRF_SP5_SHIFT                     10
#define AIPS_PACRF_SP5_WIDTH                     1
#define AIPS_PACRF_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP5_SHIFT))&AIPS_PACRF_SP5_MASK)
#define AIPS_PACRF_TP4_MASK                      0x1000u
#define AIPS_PACRF_TP4_SHIFT                     12
#define AIPS_PACRF_TP4_WIDTH                     1
#define AIPS_PACRF_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP4_SHIFT))&AIPS_PACRF_TP4_MASK)
#define AIPS_PACRF_WP4_MASK                      0x2000u
#define AIPS_PACRF_WP4_SHIFT                     13
#define AIPS_PACRF_WP4_WIDTH                     1
#define AIPS_PACRF_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP4_SHIFT))&AIPS_PACRF_WP4_MASK)
#define AIPS_PACRF_SP4_MASK                      0x4000u
#define AIPS_PACRF_SP4_SHIFT                     14
#define AIPS_PACRF_SP4_WIDTH                     1
#define AIPS_PACRF_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP4_SHIFT))&AIPS_PACRF_SP4_MASK)
#define AIPS_PACRF_TP3_MASK                      0x10000u
#define AIPS_PACRF_TP3_SHIFT                     16
#define AIPS_PACRF_TP3_WIDTH                     1
#define AIPS_PACRF_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP3_SHIFT))&AIPS_PACRF_TP3_MASK)
#define AIPS_PACRF_WP3_MASK                      0x20000u
#define AIPS_PACRF_WP3_SHIFT                     17
#define AIPS_PACRF_WP3_WIDTH                     1
#define AIPS_PACRF_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP3_SHIFT))&AIPS_PACRF_WP3_MASK)
#define AIPS_PACRF_SP3_MASK                      0x40000u
#define AIPS_PACRF_SP3_SHIFT                     18
#define AIPS_PACRF_SP3_WIDTH                     1
#define AIPS_PACRF_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP3_SHIFT))&AIPS_PACRF_SP3_MASK)
#define AIPS_PACRF_TP2_MASK                      0x100000u
#define AIPS_PACRF_TP2_SHIFT                     20
#define AIPS_PACRF_TP2_WIDTH                     1
#define AIPS_PACRF_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP2_SHIFT))&AIPS_PACRF_TP2_MASK)
#define AIPS_PACRF_WP2_MASK                      0x200000u
#define AIPS_PACRF_WP2_SHIFT                     21
#define AIPS_PACRF_WP2_WIDTH                     1
#define AIPS_PACRF_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP2_SHIFT))&AIPS_PACRF_WP2_MASK)
#define AIPS_PACRF_SP2_MASK                      0x400000u
#define AIPS_PACRF_SP2_SHIFT                     22
#define AIPS_PACRF_SP2_WIDTH                     1
#define AIPS_PACRF_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP2_SHIFT))&AIPS_PACRF_SP2_MASK)
#define AIPS_PACRF_TP1_MASK                      0x1000000u
#define AIPS_PACRF_TP1_SHIFT                     24
#define AIPS_PACRF_TP1_WIDTH                     1
#define AIPS_PACRF_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP1_SHIFT))&AIPS_PACRF_TP1_MASK)
#define AIPS_PACRF_WP1_MASK                      0x2000000u
#define AIPS_PACRF_WP1_SHIFT                     25
#define AIPS_PACRF_WP1_WIDTH                     1
#define AIPS_PACRF_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP1_SHIFT))&AIPS_PACRF_WP1_MASK)
#define AIPS_PACRF_SP1_MASK                      0x4000000u
#define AIPS_PACRF_SP1_SHIFT                     26
#define AIPS_PACRF_SP1_WIDTH                     1
#define AIPS_PACRF_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP1_SHIFT))&AIPS_PACRF_SP1_MASK)
#define AIPS_PACRF_TP0_MASK                      0x10000000u
#define AIPS_PACRF_TP0_SHIFT                     28
#define AIPS_PACRF_TP0_WIDTH                     1
#define AIPS_PACRF_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP0_SHIFT))&AIPS_PACRF_TP0_MASK)
#define AIPS_PACRF_WP0_MASK                      0x20000000u
#define AIPS_PACRF_WP0_SHIFT                     29
#define AIPS_PACRF_WP0_WIDTH                     1
#define AIPS_PACRF_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP0_SHIFT))&AIPS_PACRF_WP0_MASK)
#define AIPS_PACRF_SP0_MASK                      0x40000000u
#define AIPS_PACRF_SP0_SHIFT                     30
#define AIPS_PACRF_SP0_WIDTH                     1
#define AIPS_PACRF_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP0_SHIFT))&AIPS_PACRF_SP0_MASK)
/* PACRG Bit Fields */
#define AIPS_PACRG_TP7_MASK                      0x1u
#define AIPS_PACRG_TP7_SHIFT                     0
#define AIPS_PACRG_TP7_WIDTH                     1
#define AIPS_PACRG_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP7_SHIFT))&AIPS_PACRG_TP7_MASK)
#define AIPS_PACRG_WP7_MASK                      0x2u
#define AIPS_PACRG_WP7_SHIFT                     1
#define AIPS_PACRG_WP7_WIDTH                     1
#define AIPS_PACRG_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP7_SHIFT))&AIPS_PACRG_WP7_MASK)
#define AIPS_PACRG_SP7_MASK                      0x4u
#define AIPS_PACRG_SP7_SHIFT                     2
#define AIPS_PACRG_SP7_WIDTH                     1
#define AIPS_PACRG_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP7_SHIFT))&AIPS_PACRG_SP7_MASK)
#define AIPS_PACRG_TP6_MASK                      0x10u
#define AIPS_PACRG_TP6_SHIFT                     4
#define AIPS_PACRG_TP6_WIDTH                     1
#define AIPS_PACRG_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP6_SHIFT))&AIPS_PACRG_TP6_MASK)
#define AIPS_PACRG_WP6_MASK                      0x20u
#define AIPS_PACRG_WP6_SHIFT                     5
#define AIPS_PACRG_WP6_WIDTH                     1
#define AIPS_PACRG_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP6_SHIFT))&AIPS_PACRG_WP6_MASK)
#define AIPS_PACRG_SP6_MASK                      0x40u
#define AIPS_PACRG_SP6_SHIFT                     6
#define AIPS_PACRG_SP6_WIDTH                     1
#define AIPS_PACRG_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP6_SHIFT))&AIPS_PACRG_SP6_MASK)
#define AIPS_PACRG_TP5_MASK                      0x100u
#define AIPS_PACRG_TP5_SHIFT                     8
#define AIPS_PACRG_TP5_WIDTH                     1
#define AIPS_PACRG_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP5_SHIFT))&AIPS_PACRG_TP5_MASK)
#define AIPS_PACRG_WP5_MASK                      0x200u
#define AIPS_PACRG_WP5_SHIFT                     9
#define AIPS_PACRG_WP5_WIDTH                     1
#define AIPS_PACRG_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP5_SHIFT))&AIPS_PACRG_WP5_MASK)
#define AIPS_PACRG_SP5_MASK                      0x400u
#define AIPS_PACRG_SP5_SHIFT                     10
#define AIPS_PACRG_SP5_WIDTH                     1
#define AIPS_PACRG_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP5_SHIFT))&AIPS_PACRG_SP5_MASK)
#define AIPS_PACRG_TP4_MASK                      0x1000u
#define AIPS_PACRG_TP4_SHIFT                     12
#define AIPS_PACRG_TP4_WIDTH                     1
#define AIPS_PACRG_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP4_SHIFT))&AIPS_PACRG_TP4_MASK)
#define AIPS_PACRG_WP4_MASK                      0x2000u
#define AIPS_PACRG_WP4_SHIFT                     13
#define AIPS_PACRG_WP4_WIDTH                     1
#define AIPS_PACRG_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP4_SHIFT))&AIPS_PACRG_WP4_MASK)
#define AIPS_PACRG_SP4_MASK                      0x4000u
#define AIPS_PACRG_SP4_SHIFT                     14
#define AIPS_PACRG_SP4_WIDTH                     1
#define AIPS_PACRG_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP4_SHIFT))&AIPS_PACRG_SP4_MASK)
#define AIPS_PACRG_TP3_MASK                      0x10000u
#define AIPS_PACRG_TP3_SHIFT                     16
#define AIPS_PACRG_TP3_WIDTH                     1
#define AIPS_PACRG_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP3_SHIFT))&AIPS_PACRG_TP3_MASK)
#define AIPS_PACRG_WP3_MASK                      0x20000u
#define AIPS_PACRG_WP3_SHIFT                     17
#define AIPS_PACRG_WP3_WIDTH                     1
#define AIPS_PACRG_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP3_SHIFT))&AIPS_PACRG_WP3_MASK)
#define AIPS_PACRG_SP3_MASK                      0x40000u
#define AIPS_PACRG_SP3_SHIFT                     18
#define AIPS_PACRG_SP3_WIDTH                     1
#define AIPS_PACRG_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP3_SHIFT))&AIPS_PACRG_SP3_MASK)
#define AIPS_PACRG_TP2_MASK                      0x100000u
#define AIPS_PACRG_TP2_SHIFT                     20
#define AIPS_PACRG_TP2_WIDTH                     1
#define AIPS_PACRG_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP2_SHIFT))&AIPS_PACRG_TP2_MASK)
#define AIPS_PACRG_WP2_MASK                      0x200000u
#define AIPS_PACRG_WP2_SHIFT                     21
#define AIPS_PACRG_WP2_WIDTH                     1
#define AIPS_PACRG_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP2_SHIFT))&AIPS_PACRG_WP2_MASK)
#define AIPS_PACRG_SP2_MASK                      0x400000u
#define AIPS_PACRG_SP2_SHIFT                     22
#define AIPS_PACRG_SP2_WIDTH                     1
#define AIPS_PACRG_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP2_SHIFT))&AIPS_PACRG_SP2_MASK)
#define AIPS_PACRG_TP1_MASK                      0x1000000u
#define AIPS_PACRG_TP1_SHIFT                     24
#define AIPS_PACRG_TP1_WIDTH                     1
#define AIPS_PACRG_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP1_SHIFT))&AIPS_PACRG_TP1_MASK)
#define AIPS_PACRG_WP1_MASK                      0x2000000u
#define AIPS_PACRG_WP1_SHIFT                     25
#define AIPS_PACRG_WP1_WIDTH                     1
#define AIPS_PACRG_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP1_SHIFT))&AIPS_PACRG_WP1_MASK)
#define AIPS_PACRG_SP1_MASK                      0x4000000u
#define AIPS_PACRG_SP1_SHIFT                     26
#define AIPS_PACRG_SP1_WIDTH                     1
#define AIPS_PACRG_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP1_SHIFT))&AIPS_PACRG_SP1_MASK)
#define AIPS_PACRG_TP0_MASK                      0x10000000u
#define AIPS_PACRG_TP0_SHIFT                     28
#define AIPS_PACRG_TP0_WIDTH                     1
#define AIPS_PACRG_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP0_SHIFT))&AIPS_PACRG_TP0_MASK)
#define AIPS_PACRG_WP0_MASK                      0x20000000u
#define AIPS_PACRG_WP0_SHIFT                     29
#define AIPS_PACRG_WP0_WIDTH                     1
#define AIPS_PACRG_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP0_SHIFT))&AIPS_PACRG_WP0_MASK)
#define AIPS_PACRG_SP0_MASK                      0x40000000u
#define AIPS_PACRG_SP0_SHIFT                     30
#define AIPS_PACRG_SP0_WIDTH                     1
#define AIPS_PACRG_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP0_SHIFT))&AIPS_PACRG_SP0_MASK)
/* PACRH Bit Fields */
#define AIPS_PACRH_TP7_MASK                      0x1u
#define AIPS_PACRH_TP7_SHIFT                     0
#define AIPS_PACRH_TP7_WIDTH                     1
#define AIPS_PACRH_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP7_SHIFT))&AIPS_PACRH_TP7_MASK)
#define AIPS_PACRH_WP7_MASK                      0x2u
#define AIPS_PACRH_WP7_SHIFT                     1
#define AIPS_PACRH_WP7_WIDTH                     1
#define AIPS_PACRH_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP7_SHIFT))&AIPS_PACRH_WP7_MASK)
#define AIPS_PACRH_SP7_MASK                      0x4u
#define AIPS_PACRH_SP7_SHIFT                     2
#define AIPS_PACRH_SP7_WIDTH                     1
#define AIPS_PACRH_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP7_SHIFT))&AIPS_PACRH_SP7_MASK)
#define AIPS_PACRH_TP6_MASK                      0x10u
#define AIPS_PACRH_TP6_SHIFT                     4
#define AIPS_PACRH_TP6_WIDTH                     1
#define AIPS_PACRH_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP6_SHIFT))&AIPS_PACRH_TP6_MASK)
#define AIPS_PACRH_WP6_MASK                      0x20u
#define AIPS_PACRH_WP6_SHIFT                     5
#define AIPS_PACRH_WP6_WIDTH                     1
#define AIPS_PACRH_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP6_SHIFT))&AIPS_PACRH_WP6_MASK)
#define AIPS_PACRH_SP6_MASK                      0x40u
#define AIPS_PACRH_SP6_SHIFT                     6
#define AIPS_PACRH_SP6_WIDTH                     1
#define AIPS_PACRH_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP6_SHIFT))&AIPS_PACRH_SP6_MASK)
#define AIPS_PACRH_TP5_MASK                      0x100u
#define AIPS_PACRH_TP5_SHIFT                     8
#define AIPS_PACRH_TP5_WIDTH                     1
#define AIPS_PACRH_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP5_SHIFT))&AIPS_PACRH_TP5_MASK)
#define AIPS_PACRH_WP5_MASK                      0x200u
#define AIPS_PACRH_WP5_SHIFT                     9
#define AIPS_PACRH_WP5_WIDTH                     1
#define AIPS_PACRH_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP5_SHIFT))&AIPS_PACRH_WP5_MASK)
#define AIPS_PACRH_SP5_MASK                      0x400u
#define AIPS_PACRH_SP5_SHIFT                     10
#define AIPS_PACRH_SP5_WIDTH                     1
#define AIPS_PACRH_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP5_SHIFT))&AIPS_PACRH_SP5_MASK)
#define AIPS_PACRH_TP4_MASK                      0x1000u
#define AIPS_PACRH_TP4_SHIFT                     12
#define AIPS_PACRH_TP4_WIDTH                     1
#define AIPS_PACRH_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP4_SHIFT))&AIPS_PACRH_TP4_MASK)
#define AIPS_PACRH_WP4_MASK                      0x2000u
#define AIPS_PACRH_WP4_SHIFT                     13
#define AIPS_PACRH_WP4_WIDTH                     1
#define AIPS_PACRH_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP4_SHIFT))&AIPS_PACRH_WP4_MASK)
#define AIPS_PACRH_SP4_MASK                      0x4000u
#define AIPS_PACRH_SP4_SHIFT                     14
#define AIPS_PACRH_SP4_WIDTH                     1
#define AIPS_PACRH_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP4_SHIFT))&AIPS_PACRH_SP4_MASK)
#define AIPS_PACRH_TP3_MASK                      0x10000u
#define AIPS_PACRH_TP3_SHIFT                     16
#define AIPS_PACRH_TP3_WIDTH                     1
#define AIPS_PACRH_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP3_SHIFT))&AIPS_PACRH_TP3_MASK)
#define AIPS_PACRH_WP3_MASK                      0x20000u
#define AIPS_PACRH_WP3_SHIFT                     17
#define AIPS_PACRH_WP3_WIDTH                     1
#define AIPS_PACRH_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP3_SHIFT))&AIPS_PACRH_WP3_MASK)
#define AIPS_PACRH_SP3_MASK                      0x40000u
#define AIPS_PACRH_SP3_SHIFT                     18
#define AIPS_PACRH_SP3_WIDTH                     1
#define AIPS_PACRH_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP3_SHIFT))&AIPS_PACRH_SP3_MASK)
#define AIPS_PACRH_TP2_MASK                      0x100000u
#define AIPS_PACRH_TP2_SHIFT                     20
#define AIPS_PACRH_TP2_WIDTH                     1
#define AIPS_PACRH_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP2_SHIFT))&AIPS_PACRH_TP2_MASK)
#define AIPS_PACRH_WP2_MASK                      0x200000u
#define AIPS_PACRH_WP2_SHIFT                     21
#define AIPS_PACRH_WP2_WIDTH                     1
#define AIPS_PACRH_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP2_SHIFT))&AIPS_PACRH_WP2_MASK)
#define AIPS_PACRH_SP2_MASK                      0x400000u
#define AIPS_PACRH_SP2_SHIFT                     22
#define AIPS_PACRH_SP2_WIDTH                     1
#define AIPS_PACRH_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP2_SHIFT))&AIPS_PACRH_SP2_MASK)
#define AIPS_PACRH_TP1_MASK                      0x1000000u
#define AIPS_PACRH_TP1_SHIFT                     24
#define AIPS_PACRH_TP1_WIDTH                     1
#define AIPS_PACRH_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP1_SHIFT))&AIPS_PACRH_TP1_MASK)
#define AIPS_PACRH_WP1_MASK                      0x2000000u
#define AIPS_PACRH_WP1_SHIFT                     25
#define AIPS_PACRH_WP1_WIDTH                     1
#define AIPS_PACRH_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP1_SHIFT))&AIPS_PACRH_WP1_MASK)
#define AIPS_PACRH_SP1_MASK                      0x4000000u
#define AIPS_PACRH_SP1_SHIFT                     26
#define AIPS_PACRH_SP1_WIDTH                     1
#define AIPS_PACRH_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP1_SHIFT))&AIPS_PACRH_SP1_MASK)
#define AIPS_PACRH_TP0_MASK                      0x10000000u
#define AIPS_PACRH_TP0_SHIFT                     28
#define AIPS_PACRH_TP0_WIDTH                     1
#define AIPS_PACRH_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP0_SHIFT))&AIPS_PACRH_TP0_MASK)
#define AIPS_PACRH_WP0_MASK                      0x20000000u
#define AIPS_PACRH_WP0_SHIFT                     29
#define AIPS_PACRH_WP0_WIDTH                     1
#define AIPS_PACRH_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP0_SHIFT))&AIPS_PACRH_WP0_MASK)
#define AIPS_PACRH_SP0_MASK                      0x40000000u
#define AIPS_PACRH_SP0_SHIFT                     30
#define AIPS_PACRH_SP0_WIDTH                     1
#define AIPS_PACRH_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP0_SHIFT))&AIPS_PACRH_SP0_MASK)
/* PACRI Bit Fields */
#define AIPS_PACRI_TP7_MASK                      0x1u
#define AIPS_PACRI_TP7_SHIFT                     0
#define AIPS_PACRI_TP7_WIDTH                     1
#define AIPS_PACRI_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP7_SHIFT))&AIPS_PACRI_TP7_MASK)
#define AIPS_PACRI_WP7_MASK                      0x2u
#define AIPS_PACRI_WP7_SHIFT                     1
#define AIPS_PACRI_WP7_WIDTH                     1
#define AIPS_PACRI_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP7_SHIFT))&AIPS_PACRI_WP7_MASK)
#define AIPS_PACRI_SP7_MASK                      0x4u
#define AIPS_PACRI_SP7_SHIFT                     2
#define AIPS_PACRI_SP7_WIDTH                     1
#define AIPS_PACRI_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP7_SHIFT))&AIPS_PACRI_SP7_MASK)
#define AIPS_PACRI_TP6_MASK                      0x10u
#define AIPS_PACRI_TP6_SHIFT                     4
#define AIPS_PACRI_TP6_WIDTH                     1
#define AIPS_PACRI_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP6_SHIFT))&AIPS_PACRI_TP6_MASK)
#define AIPS_PACRI_WP6_MASK                      0x20u
#define AIPS_PACRI_WP6_SHIFT                     5
#define AIPS_PACRI_WP6_WIDTH                     1
#define AIPS_PACRI_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP6_SHIFT))&AIPS_PACRI_WP6_MASK)
#define AIPS_PACRI_SP6_MASK                      0x40u
#define AIPS_PACRI_SP6_SHIFT                     6
#define AIPS_PACRI_SP6_WIDTH                     1
#define AIPS_PACRI_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP6_SHIFT))&AIPS_PACRI_SP6_MASK)
#define AIPS_PACRI_TP5_MASK                      0x100u
#define AIPS_PACRI_TP5_SHIFT                     8
#define AIPS_PACRI_TP5_WIDTH                     1
#define AIPS_PACRI_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP5_SHIFT))&AIPS_PACRI_TP5_MASK)
#define AIPS_PACRI_WP5_MASK                      0x200u
#define AIPS_PACRI_WP5_SHIFT                     9
#define AIPS_PACRI_WP5_WIDTH                     1
#define AIPS_PACRI_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP5_SHIFT))&AIPS_PACRI_WP5_MASK)
#define AIPS_PACRI_SP5_MASK                      0x400u
#define AIPS_PACRI_SP5_SHIFT                     10
#define AIPS_PACRI_SP5_WIDTH                     1
#define AIPS_PACRI_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP5_SHIFT))&AIPS_PACRI_SP5_MASK)
#define AIPS_PACRI_TP4_MASK                      0x1000u
#define AIPS_PACRI_TP4_SHIFT                     12
#define AIPS_PACRI_TP4_WIDTH                     1
#define AIPS_PACRI_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP4_SHIFT))&AIPS_PACRI_TP4_MASK)
#define AIPS_PACRI_WP4_MASK                      0x2000u
#define AIPS_PACRI_WP4_SHIFT                     13
#define AIPS_PACRI_WP4_WIDTH                     1
#define AIPS_PACRI_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP4_SHIFT))&AIPS_PACRI_WP4_MASK)
#define AIPS_PACRI_SP4_MASK                      0x4000u
#define AIPS_PACRI_SP4_SHIFT                     14
#define AIPS_PACRI_SP4_WIDTH                     1
#define AIPS_PACRI_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP4_SHIFT))&AIPS_PACRI_SP4_MASK)
#define AIPS_PACRI_TP3_MASK                      0x10000u
#define AIPS_PACRI_TP3_SHIFT                     16
#define AIPS_PACRI_TP3_WIDTH                     1
#define AIPS_PACRI_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP3_SHIFT))&AIPS_PACRI_TP3_MASK)
#define AIPS_PACRI_WP3_MASK                      0x20000u
#define AIPS_PACRI_WP3_SHIFT                     17
#define AIPS_PACRI_WP3_WIDTH                     1
#define AIPS_PACRI_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP3_SHIFT))&AIPS_PACRI_WP3_MASK)
#define AIPS_PACRI_SP3_MASK                      0x40000u
#define AIPS_PACRI_SP3_SHIFT                     18
#define AIPS_PACRI_SP3_WIDTH                     1
#define AIPS_PACRI_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP3_SHIFT))&AIPS_PACRI_SP3_MASK)
#define AIPS_PACRI_TP2_MASK                      0x100000u
#define AIPS_PACRI_TP2_SHIFT                     20
#define AIPS_PACRI_TP2_WIDTH                     1
#define AIPS_PACRI_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP2_SHIFT))&AIPS_PACRI_TP2_MASK)
#define AIPS_PACRI_WP2_MASK                      0x200000u
#define AIPS_PACRI_WP2_SHIFT                     21
#define AIPS_PACRI_WP2_WIDTH                     1
#define AIPS_PACRI_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP2_SHIFT))&AIPS_PACRI_WP2_MASK)
#define AIPS_PACRI_SP2_MASK                      0x400000u
#define AIPS_PACRI_SP2_SHIFT                     22
#define AIPS_PACRI_SP2_WIDTH                     1
#define AIPS_PACRI_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP2_SHIFT))&AIPS_PACRI_SP2_MASK)
#define AIPS_PACRI_TP1_MASK                      0x1000000u
#define AIPS_PACRI_TP1_SHIFT                     24
#define AIPS_PACRI_TP1_WIDTH                     1
#define AIPS_PACRI_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP1_SHIFT))&AIPS_PACRI_TP1_MASK)
#define AIPS_PACRI_WP1_MASK                      0x2000000u
#define AIPS_PACRI_WP1_SHIFT                     25
#define AIPS_PACRI_WP1_WIDTH                     1
#define AIPS_PACRI_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP1_SHIFT))&AIPS_PACRI_WP1_MASK)
#define AIPS_PACRI_SP1_MASK                      0x4000000u
#define AIPS_PACRI_SP1_SHIFT                     26
#define AIPS_PACRI_SP1_WIDTH                     1
#define AIPS_PACRI_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP1_SHIFT))&AIPS_PACRI_SP1_MASK)
#define AIPS_PACRI_TP0_MASK                      0x10000000u
#define AIPS_PACRI_TP0_SHIFT                     28
#define AIPS_PACRI_TP0_WIDTH                     1
#define AIPS_PACRI_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP0_SHIFT))&AIPS_PACRI_TP0_MASK)
#define AIPS_PACRI_WP0_MASK                      0x20000000u
#define AIPS_PACRI_WP0_SHIFT                     29
#define AIPS_PACRI_WP0_WIDTH                     1
#define AIPS_PACRI_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP0_SHIFT))&AIPS_PACRI_WP0_MASK)
#define AIPS_PACRI_SP0_MASK                      0x40000000u
#define AIPS_PACRI_SP0_SHIFT                     30
#define AIPS_PACRI_SP0_WIDTH                     1
#define AIPS_PACRI_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP0_SHIFT))&AIPS_PACRI_SP0_MASK)
/* PACRJ Bit Fields */
#define AIPS_PACRJ_TP7_MASK                      0x1u
#define AIPS_PACRJ_TP7_SHIFT                     0
#define AIPS_PACRJ_TP7_WIDTH                     1
#define AIPS_PACRJ_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP7_SHIFT))&AIPS_PACRJ_TP7_MASK)
#define AIPS_PACRJ_WP7_MASK                      0x2u
#define AIPS_PACRJ_WP7_SHIFT                     1
#define AIPS_PACRJ_WP7_WIDTH                     1
#define AIPS_PACRJ_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP7_SHIFT))&AIPS_PACRJ_WP7_MASK)
#define AIPS_PACRJ_SP7_MASK                      0x4u
#define AIPS_PACRJ_SP7_SHIFT                     2
#define AIPS_PACRJ_SP7_WIDTH                     1
#define AIPS_PACRJ_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP7_SHIFT))&AIPS_PACRJ_SP7_MASK)
#define AIPS_PACRJ_TP6_MASK                      0x10u
#define AIPS_PACRJ_TP6_SHIFT                     4
#define AIPS_PACRJ_TP6_WIDTH                     1
#define AIPS_PACRJ_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP6_SHIFT))&AIPS_PACRJ_TP6_MASK)
#define AIPS_PACRJ_WP6_MASK                      0x20u
#define AIPS_PACRJ_WP6_SHIFT                     5
#define AIPS_PACRJ_WP6_WIDTH                     1
#define AIPS_PACRJ_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP6_SHIFT))&AIPS_PACRJ_WP6_MASK)
#define AIPS_PACRJ_SP6_MASK                      0x40u
#define AIPS_PACRJ_SP6_SHIFT                     6
#define AIPS_PACRJ_SP6_WIDTH                     1
#define AIPS_PACRJ_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP6_SHIFT))&AIPS_PACRJ_SP6_MASK)
#define AIPS_PACRJ_TP5_MASK                      0x100u
#define AIPS_PACRJ_TP5_SHIFT                     8
#define AIPS_PACRJ_TP5_WIDTH                     1
#define AIPS_PACRJ_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP5_SHIFT))&AIPS_PACRJ_TP5_MASK)
#define AIPS_PACRJ_WP5_MASK                      0x200u
#define AIPS_PACRJ_WP5_SHIFT                     9
#define AIPS_PACRJ_WP5_WIDTH                     1
#define AIPS_PACRJ_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP5_SHIFT))&AIPS_PACRJ_WP5_MASK)
#define AIPS_PACRJ_SP5_MASK                      0x400u
#define AIPS_PACRJ_SP5_SHIFT                     10
#define AIPS_PACRJ_SP5_WIDTH                     1
#define AIPS_PACRJ_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP5_SHIFT))&AIPS_PACRJ_SP5_MASK)
#define AIPS_PACRJ_TP4_MASK                      0x1000u
#define AIPS_PACRJ_TP4_SHIFT                     12
#define AIPS_PACRJ_TP4_WIDTH                     1
#define AIPS_PACRJ_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP4_SHIFT))&AIPS_PACRJ_TP4_MASK)
#define AIPS_PACRJ_WP4_MASK                      0x2000u
#define AIPS_PACRJ_WP4_SHIFT                     13
#define AIPS_PACRJ_WP4_WIDTH                     1
#define AIPS_PACRJ_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP4_SHIFT))&AIPS_PACRJ_WP4_MASK)
#define AIPS_PACRJ_SP4_MASK                      0x4000u
#define AIPS_PACRJ_SP4_SHIFT                     14
#define AIPS_PACRJ_SP4_WIDTH                     1
#define AIPS_PACRJ_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP4_SHIFT))&AIPS_PACRJ_SP4_MASK)
#define AIPS_PACRJ_TP3_MASK                      0x10000u
#define AIPS_PACRJ_TP3_SHIFT                     16
#define AIPS_PACRJ_TP3_WIDTH                     1
#define AIPS_PACRJ_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP3_SHIFT))&AIPS_PACRJ_TP3_MASK)
#define AIPS_PACRJ_WP3_MASK                      0x20000u
#define AIPS_PACRJ_WP3_SHIFT                     17
#define AIPS_PACRJ_WP3_WIDTH                     1
#define AIPS_PACRJ_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP3_SHIFT))&AIPS_PACRJ_WP3_MASK)
#define AIPS_PACRJ_SP3_MASK                      0x40000u
#define AIPS_PACRJ_SP3_SHIFT                     18
#define AIPS_PACRJ_SP3_WIDTH                     1
#define AIPS_PACRJ_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP3_SHIFT))&AIPS_PACRJ_SP3_MASK)
#define AIPS_PACRJ_TP2_MASK                      0x100000u
#define AIPS_PACRJ_TP2_SHIFT                     20
#define AIPS_PACRJ_TP2_WIDTH                     1
#define AIPS_PACRJ_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP2_SHIFT))&AIPS_PACRJ_TP2_MASK)
#define AIPS_PACRJ_WP2_MASK                      0x200000u
#define AIPS_PACRJ_WP2_SHIFT                     21
#define AIPS_PACRJ_WP2_WIDTH                     1
#define AIPS_PACRJ_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP2_SHIFT))&AIPS_PACRJ_WP2_MASK)
#define AIPS_PACRJ_SP2_MASK                      0x400000u
#define AIPS_PACRJ_SP2_SHIFT                     22
#define AIPS_PACRJ_SP2_WIDTH                     1
#define AIPS_PACRJ_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP2_SHIFT))&AIPS_PACRJ_SP2_MASK)
#define AIPS_PACRJ_TP1_MASK                      0x1000000u
#define AIPS_PACRJ_TP1_SHIFT                     24
#define AIPS_PACRJ_TP1_WIDTH                     1
#define AIPS_PACRJ_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP1_SHIFT))&AIPS_PACRJ_TP1_MASK)
#define AIPS_PACRJ_WP1_MASK                      0x2000000u
#define AIPS_PACRJ_WP1_SHIFT                     25
#define AIPS_PACRJ_WP1_WIDTH                     1
#define AIPS_PACRJ_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP1_SHIFT))&AIPS_PACRJ_WP1_MASK)
#define AIPS_PACRJ_SP1_MASK                      0x4000000u
#define AIPS_PACRJ_SP1_SHIFT                     26
#define AIPS_PACRJ_SP1_WIDTH                     1
#define AIPS_PACRJ_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP1_SHIFT))&AIPS_PACRJ_SP1_MASK)
#define AIPS_PACRJ_TP0_MASK                      0x10000000u
#define AIPS_PACRJ_TP0_SHIFT                     28
#define AIPS_PACRJ_TP0_WIDTH                     1
#define AIPS_PACRJ_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP0_SHIFT))&AIPS_PACRJ_TP0_MASK)
#define AIPS_PACRJ_WP0_MASK                      0x20000000u
#define AIPS_PACRJ_WP0_SHIFT                     29
#define AIPS_PACRJ_WP0_WIDTH                     1
#define AIPS_PACRJ_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP0_SHIFT))&AIPS_PACRJ_WP0_MASK)
#define AIPS_PACRJ_SP0_MASK                      0x40000000u
#define AIPS_PACRJ_SP0_SHIFT                     30
#define AIPS_PACRJ_SP0_WIDTH                     1
#define AIPS_PACRJ_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP0_SHIFT))&AIPS_PACRJ_SP0_MASK)
/* PACRK Bit Fields */
#define AIPS_PACRK_TP7_MASK                      0x1u
#define AIPS_PACRK_TP7_SHIFT                     0
#define AIPS_PACRK_TP7_WIDTH                     1
#define AIPS_PACRK_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP7_SHIFT))&AIPS_PACRK_TP7_MASK)
#define AIPS_PACRK_WP7_MASK                      0x2u
#define AIPS_PACRK_WP7_SHIFT                     1
#define AIPS_PACRK_WP7_WIDTH                     1
#define AIPS_PACRK_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP7_SHIFT))&AIPS_PACRK_WP7_MASK)
#define AIPS_PACRK_SP7_MASK                      0x4u
#define AIPS_PACRK_SP7_SHIFT                     2
#define AIPS_PACRK_SP7_WIDTH                     1
#define AIPS_PACRK_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP7_SHIFT))&AIPS_PACRK_SP7_MASK)
#define AIPS_PACRK_TP6_MASK                      0x10u
#define AIPS_PACRK_TP6_SHIFT                     4
#define AIPS_PACRK_TP6_WIDTH                     1
#define AIPS_PACRK_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP6_SHIFT))&AIPS_PACRK_TP6_MASK)
#define AIPS_PACRK_WP6_MASK                      0x20u
#define AIPS_PACRK_WP6_SHIFT                     5
#define AIPS_PACRK_WP6_WIDTH                     1
#define AIPS_PACRK_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP6_SHIFT))&AIPS_PACRK_WP6_MASK)
#define AIPS_PACRK_SP6_MASK                      0x40u
#define AIPS_PACRK_SP6_SHIFT                     6
#define AIPS_PACRK_SP6_WIDTH                     1
#define AIPS_PACRK_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP6_SHIFT))&AIPS_PACRK_SP6_MASK)
#define AIPS_PACRK_TP5_MASK                      0x100u
#define AIPS_PACRK_TP5_SHIFT                     8
#define AIPS_PACRK_TP5_WIDTH                     1
#define AIPS_PACRK_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP5_SHIFT))&AIPS_PACRK_TP5_MASK)
#define AIPS_PACRK_WP5_MASK                      0x200u
#define AIPS_PACRK_WP5_SHIFT                     9
#define AIPS_PACRK_WP5_WIDTH                     1
#define AIPS_PACRK_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP5_SHIFT))&AIPS_PACRK_WP5_MASK)
#define AIPS_PACRK_SP5_MASK                      0x400u
#define AIPS_PACRK_SP5_SHIFT                     10
#define AIPS_PACRK_SP5_WIDTH                     1
#define AIPS_PACRK_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP5_SHIFT))&AIPS_PACRK_SP5_MASK)
#define AIPS_PACRK_TP4_MASK                      0x1000u
#define AIPS_PACRK_TP4_SHIFT                     12
#define AIPS_PACRK_TP4_WIDTH                     1
#define AIPS_PACRK_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP4_SHIFT))&AIPS_PACRK_TP4_MASK)
#define AIPS_PACRK_WP4_MASK                      0x2000u
#define AIPS_PACRK_WP4_SHIFT                     13
#define AIPS_PACRK_WP4_WIDTH                     1
#define AIPS_PACRK_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP4_SHIFT))&AIPS_PACRK_WP4_MASK)
#define AIPS_PACRK_SP4_MASK                      0x4000u
#define AIPS_PACRK_SP4_SHIFT                     14
#define AIPS_PACRK_SP4_WIDTH                     1
#define AIPS_PACRK_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP4_SHIFT))&AIPS_PACRK_SP4_MASK)
#define AIPS_PACRK_TP3_MASK                      0x10000u
#define AIPS_PACRK_TP3_SHIFT                     16
#define AIPS_PACRK_TP3_WIDTH                     1
#define AIPS_PACRK_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP3_SHIFT))&AIPS_PACRK_TP3_MASK)
#define AIPS_PACRK_WP3_MASK                      0x20000u
#define AIPS_PACRK_WP3_SHIFT                     17
#define AIPS_PACRK_WP3_WIDTH                     1
#define AIPS_PACRK_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP3_SHIFT))&AIPS_PACRK_WP3_MASK)
#define AIPS_PACRK_SP3_MASK                      0x40000u
#define AIPS_PACRK_SP3_SHIFT                     18
#define AIPS_PACRK_SP3_WIDTH                     1
#define AIPS_PACRK_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP3_SHIFT))&AIPS_PACRK_SP3_MASK)
#define AIPS_PACRK_TP2_MASK                      0x100000u
#define AIPS_PACRK_TP2_SHIFT                     20
#define AIPS_PACRK_TP2_WIDTH                     1
#define AIPS_PACRK_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP2_SHIFT))&AIPS_PACRK_TP2_MASK)
#define AIPS_PACRK_WP2_MASK                      0x200000u
#define AIPS_PACRK_WP2_SHIFT                     21
#define AIPS_PACRK_WP2_WIDTH                     1
#define AIPS_PACRK_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP2_SHIFT))&AIPS_PACRK_WP2_MASK)
#define AIPS_PACRK_SP2_MASK                      0x400000u
#define AIPS_PACRK_SP2_SHIFT                     22
#define AIPS_PACRK_SP2_WIDTH                     1
#define AIPS_PACRK_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP2_SHIFT))&AIPS_PACRK_SP2_MASK)
#define AIPS_PACRK_TP1_MASK                      0x1000000u
#define AIPS_PACRK_TP1_SHIFT                     24
#define AIPS_PACRK_TP1_WIDTH                     1
#define AIPS_PACRK_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP1_SHIFT))&AIPS_PACRK_TP1_MASK)
#define AIPS_PACRK_WP1_MASK                      0x2000000u
#define AIPS_PACRK_WP1_SHIFT                     25
#define AIPS_PACRK_WP1_WIDTH                     1
#define AIPS_PACRK_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP1_SHIFT))&AIPS_PACRK_WP1_MASK)
#define AIPS_PACRK_SP1_MASK                      0x4000000u
#define AIPS_PACRK_SP1_SHIFT                     26
#define AIPS_PACRK_SP1_WIDTH                     1
#define AIPS_PACRK_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP1_SHIFT))&AIPS_PACRK_SP1_MASK)
#define AIPS_PACRK_TP0_MASK                      0x10000000u
#define AIPS_PACRK_TP0_SHIFT                     28
#define AIPS_PACRK_TP0_WIDTH                     1
#define AIPS_PACRK_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP0_SHIFT))&AIPS_PACRK_TP0_MASK)
#define AIPS_PACRK_WP0_MASK                      0x20000000u
#define AIPS_PACRK_WP0_SHIFT                     29
#define AIPS_PACRK_WP0_WIDTH                     1
#define AIPS_PACRK_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP0_SHIFT))&AIPS_PACRK_WP0_MASK)
#define AIPS_PACRK_SP0_MASK                      0x40000000u
#define AIPS_PACRK_SP0_SHIFT                     30
#define AIPS_PACRK_SP0_WIDTH                     1
#define AIPS_PACRK_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP0_SHIFT))&AIPS_PACRK_SP0_MASK)
/* PACRL Bit Fields */
#define AIPS_PACRL_TP7_MASK                      0x1u
#define AIPS_PACRL_TP7_SHIFT                     0
#define AIPS_PACRL_TP7_WIDTH                     1
#define AIPS_PACRL_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP7_SHIFT))&AIPS_PACRL_TP7_MASK)
#define AIPS_PACRL_WP7_MASK                      0x2u
#define AIPS_PACRL_WP7_SHIFT                     1
#define AIPS_PACRL_WP7_WIDTH                     1
#define AIPS_PACRL_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP7_SHIFT))&AIPS_PACRL_WP7_MASK)
#define AIPS_PACRL_SP7_MASK                      0x4u
#define AIPS_PACRL_SP7_SHIFT                     2
#define AIPS_PACRL_SP7_WIDTH                     1
#define AIPS_PACRL_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP7_SHIFT))&AIPS_PACRL_SP7_MASK)
#define AIPS_PACRL_TP6_MASK                      0x10u
#define AIPS_PACRL_TP6_SHIFT                     4
#define AIPS_PACRL_TP6_WIDTH                     1
#define AIPS_PACRL_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP6_SHIFT))&AIPS_PACRL_TP6_MASK)
#define AIPS_PACRL_WP6_MASK                      0x20u
#define AIPS_PACRL_WP6_SHIFT                     5
#define AIPS_PACRL_WP6_WIDTH                     1
#define AIPS_PACRL_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP6_SHIFT))&AIPS_PACRL_WP6_MASK)
#define AIPS_PACRL_SP6_MASK                      0x40u
#define AIPS_PACRL_SP6_SHIFT                     6
#define AIPS_PACRL_SP6_WIDTH                     1
#define AIPS_PACRL_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP6_SHIFT))&AIPS_PACRL_SP6_MASK)
#define AIPS_PACRL_TP5_MASK                      0x100u
#define AIPS_PACRL_TP5_SHIFT                     8
#define AIPS_PACRL_TP5_WIDTH                     1
#define AIPS_PACRL_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP5_SHIFT))&AIPS_PACRL_TP5_MASK)
#define AIPS_PACRL_WP5_MASK                      0x200u
#define AIPS_PACRL_WP5_SHIFT                     9
#define AIPS_PACRL_WP5_WIDTH                     1
#define AIPS_PACRL_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP5_SHIFT))&AIPS_PACRL_WP5_MASK)
#define AIPS_PACRL_SP5_MASK                      0x400u
#define AIPS_PACRL_SP5_SHIFT                     10
#define AIPS_PACRL_SP5_WIDTH                     1
#define AIPS_PACRL_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP5_SHIFT))&AIPS_PACRL_SP5_MASK)
#define AIPS_PACRL_TP4_MASK                      0x1000u
#define AIPS_PACRL_TP4_SHIFT                     12
#define AIPS_PACRL_TP4_WIDTH                     1
#define AIPS_PACRL_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP4_SHIFT))&AIPS_PACRL_TP4_MASK)
#define AIPS_PACRL_WP4_MASK                      0x2000u
#define AIPS_PACRL_WP4_SHIFT                     13
#define AIPS_PACRL_WP4_WIDTH                     1
#define AIPS_PACRL_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP4_SHIFT))&AIPS_PACRL_WP4_MASK)
#define AIPS_PACRL_SP4_MASK                      0x4000u
#define AIPS_PACRL_SP4_SHIFT                     14
#define AIPS_PACRL_SP4_WIDTH                     1
#define AIPS_PACRL_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP4_SHIFT))&AIPS_PACRL_SP4_MASK)
#define AIPS_PACRL_TP3_MASK                      0x10000u
#define AIPS_PACRL_TP3_SHIFT                     16
#define AIPS_PACRL_TP3_WIDTH                     1
#define AIPS_PACRL_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP3_SHIFT))&AIPS_PACRL_TP3_MASK)
#define AIPS_PACRL_WP3_MASK                      0x20000u
#define AIPS_PACRL_WP3_SHIFT                     17
#define AIPS_PACRL_WP3_WIDTH                     1
#define AIPS_PACRL_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP3_SHIFT))&AIPS_PACRL_WP3_MASK)
#define AIPS_PACRL_SP3_MASK                      0x40000u
#define AIPS_PACRL_SP3_SHIFT                     18
#define AIPS_PACRL_SP3_WIDTH                     1
#define AIPS_PACRL_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP3_SHIFT))&AIPS_PACRL_SP3_MASK)
#define AIPS_PACRL_TP2_MASK                      0x100000u
#define AIPS_PACRL_TP2_SHIFT                     20
#define AIPS_PACRL_TP2_WIDTH                     1
#define AIPS_PACRL_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP2_SHIFT))&AIPS_PACRL_TP2_MASK)
#define AIPS_PACRL_WP2_MASK                      0x200000u
#define AIPS_PACRL_WP2_SHIFT                     21
#define AIPS_PACRL_WP2_WIDTH                     1
#define AIPS_PACRL_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP2_SHIFT))&AIPS_PACRL_WP2_MASK)
#define AIPS_PACRL_SP2_MASK                      0x400000u
#define AIPS_PACRL_SP2_SHIFT                     22
#define AIPS_PACRL_SP2_WIDTH                     1
#define AIPS_PACRL_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP2_SHIFT))&AIPS_PACRL_SP2_MASK)
#define AIPS_PACRL_TP1_MASK                      0x1000000u
#define AIPS_PACRL_TP1_SHIFT                     24
#define AIPS_PACRL_TP1_WIDTH                     1
#define AIPS_PACRL_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP1_SHIFT))&AIPS_PACRL_TP1_MASK)
#define AIPS_PACRL_WP1_MASK                      0x2000000u
#define AIPS_PACRL_WP1_SHIFT                     25
#define AIPS_PACRL_WP1_WIDTH                     1
#define AIPS_PACRL_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP1_SHIFT))&AIPS_PACRL_WP1_MASK)
#define AIPS_PACRL_SP1_MASK                      0x4000000u
#define AIPS_PACRL_SP1_SHIFT                     26
#define AIPS_PACRL_SP1_WIDTH                     1
#define AIPS_PACRL_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP1_SHIFT))&AIPS_PACRL_SP1_MASK)
#define AIPS_PACRL_TP0_MASK                      0x10000000u
#define AIPS_PACRL_TP0_SHIFT                     28
#define AIPS_PACRL_TP0_WIDTH                     1
#define AIPS_PACRL_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP0_SHIFT))&AIPS_PACRL_TP0_MASK)
#define AIPS_PACRL_WP0_MASK                      0x20000000u
#define AIPS_PACRL_WP0_SHIFT                     29
#define AIPS_PACRL_WP0_WIDTH                     1
#define AIPS_PACRL_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP0_SHIFT))&AIPS_PACRL_WP0_MASK)
#define AIPS_PACRL_SP0_MASK                      0x40000000u
#define AIPS_PACRL_SP0_SHIFT                     30
#define AIPS_PACRL_SP0_WIDTH                     1
#define AIPS_PACRL_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP0_SHIFT))&AIPS_PACRL_SP0_MASK)
/* PACRM Bit Fields */
#define AIPS_PACRM_TP7_MASK                      0x1u
#define AIPS_PACRM_TP7_SHIFT                     0
#define AIPS_PACRM_TP7_WIDTH                     1
#define AIPS_PACRM_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP7_SHIFT))&AIPS_PACRM_TP7_MASK)
#define AIPS_PACRM_WP7_MASK                      0x2u
#define AIPS_PACRM_WP7_SHIFT                     1
#define AIPS_PACRM_WP7_WIDTH                     1
#define AIPS_PACRM_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP7_SHIFT))&AIPS_PACRM_WP7_MASK)
#define AIPS_PACRM_SP7_MASK                      0x4u
#define AIPS_PACRM_SP7_SHIFT                     2
#define AIPS_PACRM_SP7_WIDTH                     1
#define AIPS_PACRM_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP7_SHIFT))&AIPS_PACRM_SP7_MASK)
#define AIPS_PACRM_TP6_MASK                      0x10u
#define AIPS_PACRM_TP6_SHIFT                     4
#define AIPS_PACRM_TP6_WIDTH                     1
#define AIPS_PACRM_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP6_SHIFT))&AIPS_PACRM_TP6_MASK)
#define AIPS_PACRM_WP6_MASK                      0x20u
#define AIPS_PACRM_WP6_SHIFT                     5
#define AIPS_PACRM_WP6_WIDTH                     1
#define AIPS_PACRM_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP6_SHIFT))&AIPS_PACRM_WP6_MASK)
#define AIPS_PACRM_SP6_MASK                      0x40u
#define AIPS_PACRM_SP6_SHIFT                     6
#define AIPS_PACRM_SP6_WIDTH                     1
#define AIPS_PACRM_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP6_SHIFT))&AIPS_PACRM_SP6_MASK)
#define AIPS_PACRM_TP5_MASK                      0x100u
#define AIPS_PACRM_TP5_SHIFT                     8
#define AIPS_PACRM_TP5_WIDTH                     1
#define AIPS_PACRM_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP5_SHIFT))&AIPS_PACRM_TP5_MASK)
#define AIPS_PACRM_WP5_MASK                      0x200u
#define AIPS_PACRM_WP5_SHIFT                     9
#define AIPS_PACRM_WP5_WIDTH                     1
#define AIPS_PACRM_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP5_SHIFT))&AIPS_PACRM_WP5_MASK)
#define AIPS_PACRM_SP5_MASK                      0x400u
#define AIPS_PACRM_SP5_SHIFT                     10
#define AIPS_PACRM_SP5_WIDTH                     1
#define AIPS_PACRM_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP5_SHIFT))&AIPS_PACRM_SP5_MASK)
#define AIPS_PACRM_TP4_MASK                      0x1000u
#define AIPS_PACRM_TP4_SHIFT                     12
#define AIPS_PACRM_TP4_WIDTH                     1
#define AIPS_PACRM_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP4_SHIFT))&AIPS_PACRM_TP4_MASK)
#define AIPS_PACRM_WP4_MASK                      0x2000u
#define AIPS_PACRM_WP4_SHIFT                     13
#define AIPS_PACRM_WP4_WIDTH                     1
#define AIPS_PACRM_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP4_SHIFT))&AIPS_PACRM_WP4_MASK)
#define AIPS_PACRM_SP4_MASK                      0x4000u
#define AIPS_PACRM_SP4_SHIFT                     14
#define AIPS_PACRM_SP4_WIDTH                     1
#define AIPS_PACRM_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP4_SHIFT))&AIPS_PACRM_SP4_MASK)
#define AIPS_PACRM_TP3_MASK                      0x10000u
#define AIPS_PACRM_TP3_SHIFT                     16
#define AIPS_PACRM_TP3_WIDTH                     1
#define AIPS_PACRM_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP3_SHIFT))&AIPS_PACRM_TP3_MASK)
#define AIPS_PACRM_WP3_MASK                      0x20000u
#define AIPS_PACRM_WP3_SHIFT                     17
#define AIPS_PACRM_WP3_WIDTH                     1
#define AIPS_PACRM_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP3_SHIFT))&AIPS_PACRM_WP3_MASK)
#define AIPS_PACRM_SP3_MASK                      0x40000u
#define AIPS_PACRM_SP3_SHIFT                     18
#define AIPS_PACRM_SP3_WIDTH                     1
#define AIPS_PACRM_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP3_SHIFT))&AIPS_PACRM_SP3_MASK)
#define AIPS_PACRM_TP2_MASK                      0x100000u
#define AIPS_PACRM_TP2_SHIFT                     20
#define AIPS_PACRM_TP2_WIDTH                     1
#define AIPS_PACRM_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP2_SHIFT))&AIPS_PACRM_TP2_MASK)
#define AIPS_PACRM_WP2_MASK                      0x200000u
#define AIPS_PACRM_WP2_SHIFT                     21
#define AIPS_PACRM_WP2_WIDTH                     1
#define AIPS_PACRM_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP2_SHIFT))&AIPS_PACRM_WP2_MASK)
#define AIPS_PACRM_SP2_MASK                      0x400000u
#define AIPS_PACRM_SP2_SHIFT                     22
#define AIPS_PACRM_SP2_WIDTH                     1
#define AIPS_PACRM_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP2_SHIFT))&AIPS_PACRM_SP2_MASK)
#define AIPS_PACRM_TP1_MASK                      0x1000000u
#define AIPS_PACRM_TP1_SHIFT                     24
#define AIPS_PACRM_TP1_WIDTH                     1
#define AIPS_PACRM_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP1_SHIFT))&AIPS_PACRM_TP1_MASK)
#define AIPS_PACRM_WP1_MASK                      0x2000000u
#define AIPS_PACRM_WP1_SHIFT                     25
#define AIPS_PACRM_WP1_WIDTH                     1
#define AIPS_PACRM_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP1_SHIFT))&AIPS_PACRM_WP1_MASK)
#define AIPS_PACRM_SP1_MASK                      0x4000000u
#define AIPS_PACRM_SP1_SHIFT                     26
#define AIPS_PACRM_SP1_WIDTH                     1
#define AIPS_PACRM_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP1_SHIFT))&AIPS_PACRM_SP1_MASK)
#define AIPS_PACRM_TP0_MASK                      0x10000000u
#define AIPS_PACRM_TP0_SHIFT                     28
#define AIPS_PACRM_TP0_WIDTH                     1
#define AIPS_PACRM_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP0_SHIFT))&AIPS_PACRM_TP0_MASK)
#define AIPS_PACRM_WP0_MASK                      0x20000000u
#define AIPS_PACRM_WP0_SHIFT                     29
#define AIPS_PACRM_WP0_WIDTH                     1
#define AIPS_PACRM_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP0_SHIFT))&AIPS_PACRM_WP0_MASK)
#define AIPS_PACRM_SP0_MASK                      0x40000000u
#define AIPS_PACRM_SP0_SHIFT                     30
#define AIPS_PACRM_SP0_WIDTH                     1
#define AIPS_PACRM_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP0_SHIFT))&AIPS_PACRM_SP0_MASK)
/* PACRN Bit Fields */
#define AIPS_PACRN_TP7_MASK                      0x1u
#define AIPS_PACRN_TP7_SHIFT                     0
#define AIPS_PACRN_TP7_WIDTH                     1
#define AIPS_PACRN_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP7_SHIFT))&AIPS_PACRN_TP7_MASK)
#define AIPS_PACRN_WP7_MASK                      0x2u
#define AIPS_PACRN_WP7_SHIFT                     1
#define AIPS_PACRN_WP7_WIDTH                     1
#define AIPS_PACRN_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP7_SHIFT))&AIPS_PACRN_WP7_MASK)
#define AIPS_PACRN_SP7_MASK                      0x4u
#define AIPS_PACRN_SP7_SHIFT                     2
#define AIPS_PACRN_SP7_WIDTH                     1
#define AIPS_PACRN_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP7_SHIFT))&AIPS_PACRN_SP7_MASK)
#define AIPS_PACRN_TP6_MASK                      0x10u
#define AIPS_PACRN_TP6_SHIFT                     4
#define AIPS_PACRN_TP6_WIDTH                     1
#define AIPS_PACRN_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP6_SHIFT))&AIPS_PACRN_TP6_MASK)
#define AIPS_PACRN_WP6_MASK                      0x20u
#define AIPS_PACRN_WP6_SHIFT                     5
#define AIPS_PACRN_WP6_WIDTH                     1
#define AIPS_PACRN_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP6_SHIFT))&AIPS_PACRN_WP6_MASK)
#define AIPS_PACRN_SP6_MASK                      0x40u
#define AIPS_PACRN_SP6_SHIFT                     6
#define AIPS_PACRN_SP6_WIDTH                     1
#define AIPS_PACRN_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP6_SHIFT))&AIPS_PACRN_SP6_MASK)
#define AIPS_PACRN_TP5_MASK                      0x100u
#define AIPS_PACRN_TP5_SHIFT                     8
#define AIPS_PACRN_TP5_WIDTH                     1
#define AIPS_PACRN_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP5_SHIFT))&AIPS_PACRN_TP5_MASK)
#define AIPS_PACRN_WP5_MASK                      0x200u
#define AIPS_PACRN_WP5_SHIFT                     9
#define AIPS_PACRN_WP5_WIDTH                     1
#define AIPS_PACRN_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP5_SHIFT))&AIPS_PACRN_WP5_MASK)
#define AIPS_PACRN_SP5_MASK                      0x400u
#define AIPS_PACRN_SP5_SHIFT                     10
#define AIPS_PACRN_SP5_WIDTH                     1
#define AIPS_PACRN_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP5_SHIFT))&AIPS_PACRN_SP5_MASK)
#define AIPS_PACRN_TP4_MASK                      0x1000u
#define AIPS_PACRN_TP4_SHIFT                     12
#define AIPS_PACRN_TP4_WIDTH                     1
#define AIPS_PACRN_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP4_SHIFT))&AIPS_PACRN_TP4_MASK)
#define AIPS_PACRN_WP4_MASK                      0x2000u
#define AIPS_PACRN_WP4_SHIFT                     13
#define AIPS_PACRN_WP4_WIDTH                     1
#define AIPS_PACRN_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP4_SHIFT))&AIPS_PACRN_WP4_MASK)
#define AIPS_PACRN_SP4_MASK                      0x4000u
#define AIPS_PACRN_SP4_SHIFT                     14
#define AIPS_PACRN_SP4_WIDTH                     1
#define AIPS_PACRN_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP4_SHIFT))&AIPS_PACRN_SP4_MASK)
#define AIPS_PACRN_TP3_MASK                      0x10000u
#define AIPS_PACRN_TP3_SHIFT                     16
#define AIPS_PACRN_TP3_WIDTH                     1
#define AIPS_PACRN_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP3_SHIFT))&AIPS_PACRN_TP3_MASK)
#define AIPS_PACRN_WP3_MASK                      0x20000u
#define AIPS_PACRN_WP3_SHIFT                     17
#define AIPS_PACRN_WP3_WIDTH                     1
#define AIPS_PACRN_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP3_SHIFT))&AIPS_PACRN_WP3_MASK)
#define AIPS_PACRN_SP3_MASK                      0x40000u
#define AIPS_PACRN_SP3_SHIFT                     18
#define AIPS_PACRN_SP3_WIDTH                     1
#define AIPS_PACRN_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP3_SHIFT))&AIPS_PACRN_SP3_MASK)
#define AIPS_PACRN_TP2_MASK                      0x100000u
#define AIPS_PACRN_TP2_SHIFT                     20
#define AIPS_PACRN_TP2_WIDTH                     1
#define AIPS_PACRN_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP2_SHIFT))&AIPS_PACRN_TP2_MASK)
#define AIPS_PACRN_WP2_MASK                      0x200000u
#define AIPS_PACRN_WP2_SHIFT                     21
#define AIPS_PACRN_WP2_WIDTH                     1
#define AIPS_PACRN_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP2_SHIFT))&AIPS_PACRN_WP2_MASK)
#define AIPS_PACRN_SP2_MASK                      0x400000u
#define AIPS_PACRN_SP2_SHIFT                     22
#define AIPS_PACRN_SP2_WIDTH                     1
#define AIPS_PACRN_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP2_SHIFT))&AIPS_PACRN_SP2_MASK)
#define AIPS_PACRN_TP1_MASK                      0x1000000u
#define AIPS_PACRN_TP1_SHIFT                     24
#define AIPS_PACRN_TP1_WIDTH                     1
#define AIPS_PACRN_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP1_SHIFT))&AIPS_PACRN_TP1_MASK)
#define AIPS_PACRN_WP1_MASK                      0x2000000u
#define AIPS_PACRN_WP1_SHIFT                     25
#define AIPS_PACRN_WP1_WIDTH                     1
#define AIPS_PACRN_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP1_SHIFT))&AIPS_PACRN_WP1_MASK)
#define AIPS_PACRN_SP1_MASK                      0x4000000u
#define AIPS_PACRN_SP1_SHIFT                     26
#define AIPS_PACRN_SP1_WIDTH                     1
#define AIPS_PACRN_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP1_SHIFT))&AIPS_PACRN_SP1_MASK)
#define AIPS_PACRN_TP0_MASK                      0x10000000u
#define AIPS_PACRN_TP0_SHIFT                     28
#define AIPS_PACRN_TP0_WIDTH                     1
#define AIPS_PACRN_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP0_SHIFT))&AIPS_PACRN_TP0_MASK)
#define AIPS_PACRN_WP0_MASK                      0x20000000u
#define AIPS_PACRN_WP0_SHIFT                     29
#define AIPS_PACRN_WP0_WIDTH                     1
#define AIPS_PACRN_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP0_SHIFT))&AIPS_PACRN_WP0_MASK)
#define AIPS_PACRN_SP0_MASK                      0x40000000u
#define AIPS_PACRN_SP0_SHIFT                     30
#define AIPS_PACRN_SP0_WIDTH                     1
#define AIPS_PACRN_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP0_SHIFT))&AIPS_PACRN_SP0_MASK)
/* PACRO Bit Fields */
#define AIPS_PACRO_TP7_MASK                      0x1u
#define AIPS_PACRO_TP7_SHIFT                     0
#define AIPS_PACRO_TP7_WIDTH                     1
#define AIPS_PACRO_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP7_SHIFT))&AIPS_PACRO_TP7_MASK)
#define AIPS_PACRO_WP7_MASK                      0x2u
#define AIPS_PACRO_WP7_SHIFT                     1
#define AIPS_PACRO_WP7_WIDTH                     1
#define AIPS_PACRO_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP7_SHIFT))&AIPS_PACRO_WP7_MASK)
#define AIPS_PACRO_SP7_MASK                      0x4u
#define AIPS_PACRO_SP7_SHIFT                     2
#define AIPS_PACRO_SP7_WIDTH                     1
#define AIPS_PACRO_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP7_SHIFT))&AIPS_PACRO_SP7_MASK)
#define AIPS_PACRO_TP6_MASK                      0x10u
#define AIPS_PACRO_TP6_SHIFT                     4
#define AIPS_PACRO_TP6_WIDTH                     1
#define AIPS_PACRO_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP6_SHIFT))&AIPS_PACRO_TP6_MASK)
#define AIPS_PACRO_WP6_MASK                      0x20u
#define AIPS_PACRO_WP6_SHIFT                     5
#define AIPS_PACRO_WP6_WIDTH                     1
#define AIPS_PACRO_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP6_SHIFT))&AIPS_PACRO_WP6_MASK)
#define AIPS_PACRO_SP6_MASK                      0x40u
#define AIPS_PACRO_SP6_SHIFT                     6
#define AIPS_PACRO_SP6_WIDTH                     1
#define AIPS_PACRO_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP6_SHIFT))&AIPS_PACRO_SP6_MASK)
#define AIPS_PACRO_TP5_MASK                      0x100u
#define AIPS_PACRO_TP5_SHIFT                     8
#define AIPS_PACRO_TP5_WIDTH                     1
#define AIPS_PACRO_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP5_SHIFT))&AIPS_PACRO_TP5_MASK)
#define AIPS_PACRO_WP5_MASK                      0x200u
#define AIPS_PACRO_WP5_SHIFT                     9
#define AIPS_PACRO_WP5_WIDTH                     1
#define AIPS_PACRO_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP5_SHIFT))&AIPS_PACRO_WP5_MASK)
#define AIPS_PACRO_SP5_MASK                      0x400u
#define AIPS_PACRO_SP5_SHIFT                     10
#define AIPS_PACRO_SP5_WIDTH                     1
#define AIPS_PACRO_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP5_SHIFT))&AIPS_PACRO_SP5_MASK)
#define AIPS_PACRO_TP4_MASK                      0x1000u
#define AIPS_PACRO_TP4_SHIFT                     12
#define AIPS_PACRO_TP4_WIDTH                     1
#define AIPS_PACRO_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP4_SHIFT))&AIPS_PACRO_TP4_MASK)
#define AIPS_PACRO_WP4_MASK                      0x2000u
#define AIPS_PACRO_WP4_SHIFT                     13
#define AIPS_PACRO_WP4_WIDTH                     1
#define AIPS_PACRO_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP4_SHIFT))&AIPS_PACRO_WP4_MASK)
#define AIPS_PACRO_SP4_MASK                      0x4000u
#define AIPS_PACRO_SP4_SHIFT                     14
#define AIPS_PACRO_SP4_WIDTH                     1
#define AIPS_PACRO_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP4_SHIFT))&AIPS_PACRO_SP4_MASK)
#define AIPS_PACRO_TP3_MASK                      0x10000u
#define AIPS_PACRO_TP3_SHIFT                     16
#define AIPS_PACRO_TP3_WIDTH                     1
#define AIPS_PACRO_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP3_SHIFT))&AIPS_PACRO_TP3_MASK)
#define AIPS_PACRO_WP3_MASK                      0x20000u
#define AIPS_PACRO_WP3_SHIFT                     17
#define AIPS_PACRO_WP3_WIDTH                     1
#define AIPS_PACRO_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP3_SHIFT))&AIPS_PACRO_WP3_MASK)
#define AIPS_PACRO_SP3_MASK                      0x40000u
#define AIPS_PACRO_SP3_SHIFT                     18
#define AIPS_PACRO_SP3_WIDTH                     1
#define AIPS_PACRO_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP3_SHIFT))&AIPS_PACRO_SP3_MASK)
#define AIPS_PACRO_TP2_MASK                      0x100000u
#define AIPS_PACRO_TP2_SHIFT                     20
#define AIPS_PACRO_TP2_WIDTH                     1
#define AIPS_PACRO_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP2_SHIFT))&AIPS_PACRO_TP2_MASK)
#define AIPS_PACRO_WP2_MASK                      0x200000u
#define AIPS_PACRO_WP2_SHIFT                     21
#define AIPS_PACRO_WP2_WIDTH                     1
#define AIPS_PACRO_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP2_SHIFT))&AIPS_PACRO_WP2_MASK)
#define AIPS_PACRO_SP2_MASK                      0x400000u
#define AIPS_PACRO_SP2_SHIFT                     22
#define AIPS_PACRO_SP2_WIDTH                     1
#define AIPS_PACRO_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP2_SHIFT))&AIPS_PACRO_SP2_MASK)
#define AIPS_PACRO_TP1_MASK                      0x1000000u
#define AIPS_PACRO_TP1_SHIFT                     24
#define AIPS_PACRO_TP1_WIDTH                     1
#define AIPS_PACRO_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP1_SHIFT))&AIPS_PACRO_TP1_MASK)
#define AIPS_PACRO_WP1_MASK                      0x2000000u
#define AIPS_PACRO_WP1_SHIFT                     25
#define AIPS_PACRO_WP1_WIDTH                     1
#define AIPS_PACRO_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP1_SHIFT))&AIPS_PACRO_WP1_MASK)
#define AIPS_PACRO_SP1_MASK                      0x4000000u
#define AIPS_PACRO_SP1_SHIFT                     26
#define AIPS_PACRO_SP1_WIDTH                     1
#define AIPS_PACRO_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP1_SHIFT))&AIPS_PACRO_SP1_MASK)
#define AIPS_PACRO_TP0_MASK                      0x10000000u
#define AIPS_PACRO_TP0_SHIFT                     28
#define AIPS_PACRO_TP0_WIDTH                     1
#define AIPS_PACRO_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP0_SHIFT))&AIPS_PACRO_TP0_MASK)
#define AIPS_PACRO_WP0_MASK                      0x20000000u
#define AIPS_PACRO_WP0_SHIFT                     29
#define AIPS_PACRO_WP0_WIDTH                     1
#define AIPS_PACRO_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP0_SHIFT))&AIPS_PACRO_WP0_MASK)
#define AIPS_PACRO_SP0_MASK                      0x40000000u
#define AIPS_PACRO_SP0_SHIFT                     30
#define AIPS_PACRO_SP0_WIDTH                     1
#define AIPS_PACRO_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP0_SHIFT))&AIPS_PACRO_SP0_MASK)
/* PACRP Bit Fields */
#define AIPS_PACRP_TP7_MASK                      0x1u
#define AIPS_PACRP_TP7_SHIFT                     0
#define AIPS_PACRP_TP7_WIDTH                     1
#define AIPS_PACRP_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP7_SHIFT))&AIPS_PACRP_TP7_MASK)
#define AIPS_PACRP_WP7_MASK                      0x2u
#define AIPS_PACRP_WP7_SHIFT                     1
#define AIPS_PACRP_WP7_WIDTH                     1
#define AIPS_PACRP_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP7_SHIFT))&AIPS_PACRP_WP7_MASK)
#define AIPS_PACRP_SP7_MASK                      0x4u
#define AIPS_PACRP_SP7_SHIFT                     2
#define AIPS_PACRP_SP7_WIDTH                     1
#define AIPS_PACRP_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP7_SHIFT))&AIPS_PACRP_SP7_MASK)
#define AIPS_PACRP_TP6_MASK                      0x10u
#define AIPS_PACRP_TP6_SHIFT                     4
#define AIPS_PACRP_TP6_WIDTH                     1
#define AIPS_PACRP_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP6_SHIFT))&AIPS_PACRP_TP6_MASK)
#define AIPS_PACRP_WP6_MASK                      0x20u
#define AIPS_PACRP_WP6_SHIFT                     5
#define AIPS_PACRP_WP6_WIDTH                     1
#define AIPS_PACRP_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP6_SHIFT))&AIPS_PACRP_WP6_MASK)
#define AIPS_PACRP_SP6_MASK                      0x40u
#define AIPS_PACRP_SP6_SHIFT                     6
#define AIPS_PACRP_SP6_WIDTH                     1
#define AIPS_PACRP_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP6_SHIFT))&AIPS_PACRP_SP6_MASK)
#define AIPS_PACRP_TP5_MASK                      0x100u
#define AIPS_PACRP_TP5_SHIFT                     8
#define AIPS_PACRP_TP5_WIDTH                     1
#define AIPS_PACRP_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP5_SHIFT))&AIPS_PACRP_TP5_MASK)
#define AIPS_PACRP_WP5_MASK                      0x200u
#define AIPS_PACRP_WP5_SHIFT                     9
#define AIPS_PACRP_WP5_WIDTH                     1
#define AIPS_PACRP_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP5_SHIFT))&AIPS_PACRP_WP5_MASK)
#define AIPS_PACRP_SP5_MASK                      0x400u
#define AIPS_PACRP_SP5_SHIFT                     10
#define AIPS_PACRP_SP5_WIDTH                     1
#define AIPS_PACRP_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP5_SHIFT))&AIPS_PACRP_SP5_MASK)
#define AIPS_PACRP_TP4_MASK                      0x1000u
#define AIPS_PACRP_TP4_SHIFT                     12
#define AIPS_PACRP_TP4_WIDTH                     1
#define AIPS_PACRP_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP4_SHIFT))&AIPS_PACRP_TP4_MASK)
#define AIPS_PACRP_WP4_MASK                      0x2000u
#define AIPS_PACRP_WP4_SHIFT                     13
#define AIPS_PACRP_WP4_WIDTH                     1
#define AIPS_PACRP_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP4_SHIFT))&AIPS_PACRP_WP4_MASK)
#define AIPS_PACRP_SP4_MASK                      0x4000u
#define AIPS_PACRP_SP4_SHIFT                     14
#define AIPS_PACRP_SP4_WIDTH                     1
#define AIPS_PACRP_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP4_SHIFT))&AIPS_PACRP_SP4_MASK)
#define AIPS_PACRP_TP3_MASK                      0x10000u
#define AIPS_PACRP_TP3_SHIFT                     16
#define AIPS_PACRP_TP3_WIDTH                     1
#define AIPS_PACRP_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP3_SHIFT))&AIPS_PACRP_TP3_MASK)
#define AIPS_PACRP_WP3_MASK                      0x20000u
#define AIPS_PACRP_WP3_SHIFT                     17
#define AIPS_PACRP_WP3_WIDTH                     1
#define AIPS_PACRP_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP3_SHIFT))&AIPS_PACRP_WP3_MASK)
#define AIPS_PACRP_SP3_MASK                      0x40000u
#define AIPS_PACRP_SP3_SHIFT                     18
#define AIPS_PACRP_SP3_WIDTH                     1
#define AIPS_PACRP_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP3_SHIFT))&AIPS_PACRP_SP3_MASK)
#define AIPS_PACRP_TP2_MASK                      0x100000u
#define AIPS_PACRP_TP2_SHIFT                     20
#define AIPS_PACRP_TP2_WIDTH                     1
#define AIPS_PACRP_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP2_SHIFT))&AIPS_PACRP_TP2_MASK)
#define AIPS_PACRP_WP2_MASK                      0x200000u
#define AIPS_PACRP_WP2_SHIFT                     21
#define AIPS_PACRP_WP2_WIDTH                     1
#define AIPS_PACRP_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP2_SHIFT))&AIPS_PACRP_WP2_MASK)
#define AIPS_PACRP_SP2_MASK                      0x400000u
#define AIPS_PACRP_SP2_SHIFT                     22
#define AIPS_PACRP_SP2_WIDTH                     1
#define AIPS_PACRP_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP2_SHIFT))&AIPS_PACRP_SP2_MASK)
#define AIPS_PACRP_TP1_MASK                      0x1000000u
#define AIPS_PACRP_TP1_SHIFT                     24
#define AIPS_PACRP_TP1_WIDTH                     1
#define AIPS_PACRP_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP1_SHIFT))&AIPS_PACRP_TP1_MASK)
#define AIPS_PACRP_WP1_MASK                      0x2000000u
#define AIPS_PACRP_WP1_SHIFT                     25
#define AIPS_PACRP_WP1_WIDTH                     1
#define AIPS_PACRP_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP1_SHIFT))&AIPS_PACRP_WP1_MASK)
#define AIPS_PACRP_SP1_MASK                      0x4000000u
#define AIPS_PACRP_SP1_SHIFT                     26
#define AIPS_PACRP_SP1_WIDTH                     1
#define AIPS_PACRP_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP1_SHIFT))&AIPS_PACRP_SP1_MASK)
#define AIPS_PACRP_TP0_MASK                      0x10000000u
#define AIPS_PACRP_TP0_SHIFT                     28
#define AIPS_PACRP_TP0_WIDTH                     1
#define AIPS_PACRP_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP0_SHIFT))&AIPS_PACRP_TP0_MASK)
#define AIPS_PACRP_WP0_MASK                      0x20000000u
#define AIPS_PACRP_WP0_SHIFT                     29
#define AIPS_PACRP_WP0_WIDTH                     1
#define AIPS_PACRP_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP0_SHIFT))&AIPS_PACRP_WP0_MASK)
#define AIPS_PACRP_SP0_MASK                      0x40000000u
#define AIPS_PACRP_SP0_SHIFT                     30
#define AIPS_PACRP_SP0_WIDTH                     1
#define AIPS_PACRP_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP0_SHIFT))&AIPS_PACRP_SP0_MASK)

/*!
 * @}
 */ /* end of group AIPS_Register_Masks */


/* AIPS - Peripheral instance base addresses */
/** Peripheral AIPS0 base address */
#define AIPS0_BASE                               (0x40000000u)
/** Peripheral AIPS0 base pointer */
#define AIPS0                                    ((AIPS_Type *)AIPS0_BASE)
#define AIPS0_BASE_PTR                           (AIPS0)
/** Peripheral AIPS1 base address */
#define AIPS1_BASE                               (0x40080000u)
/** Peripheral AIPS1 base pointer */
#define AIPS1                                    ((AIPS_Type *)AIPS1_BASE)
#define AIPS1_BASE_PTR                           (AIPS1)
/** Array initializer of AIPS peripheral base addresses */
#define AIPS_BASE_ADDRS                          { AIPS0_BASE, AIPS1_BASE }
/** Array initializer of AIPS peripheral base pointers */
#define AIPS_BASE_PTRS                           { AIPS0, AIPS1 }

/* ----------------------------------------------------------------------------
   -- AIPS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Register_Accessor_Macros AIPS - Register accessor macros
 * @{
 */


/* AIPS - Register instance definitions */
/* AIPS0 */
#define AIPS0_MPRA                               AIPS_MPRA_REG(AIPS0)
#define AIPS0_PACRA                              AIPS_PACRA_REG(AIPS0)
#define AIPS0_PACRB                              AIPS_PACRB_REG(AIPS0)
#define AIPS0_PACRC                              AIPS_PACRC_REG(AIPS0)
#define AIPS0_PACRD                              AIPS_PACRD_REG(AIPS0)
#define AIPS0_PACRE                              AIPS_PACRE_REG(AIPS0)
#define AIPS0_PACRF                              AIPS_PACRF_REG(AIPS0)
#define AIPS0_PACRG                              AIPS_PACRG_REG(AIPS0)
#define AIPS0_PACRH                              AIPS_PACRH_REG(AIPS0)
#define AIPS0_PACRI                              AIPS_PACRI_REG(AIPS0)
#define AIPS0_PACRJ                              AIPS_PACRJ_REG(AIPS0)
#define AIPS0_PACRK                              AIPS_PACRK_REG(AIPS0)
#define AIPS0_PACRL                              AIPS_PACRL_REG(AIPS0)
#define AIPS0_PACRM                              AIPS_PACRM_REG(AIPS0)
#define AIPS0_PACRN                              AIPS_PACRN_REG(AIPS0)
#define AIPS0_PACRO                              AIPS_PACRO_REG(AIPS0)
#define AIPS0_PACRP                              AIPS_PACRP_REG(AIPS0)
/* AIPS1 */
#define AIPS1_MPRA                               AIPS_MPRA_REG(AIPS1)
#define AIPS1_PACRA                              AIPS_PACRA_REG(AIPS1)
#define AIPS1_PACRB                              AIPS_PACRB_REG(AIPS1)
#define AIPS1_PACRC                              AIPS_PACRC_REG(AIPS1)
#define AIPS1_PACRD                              AIPS_PACRD_REG(AIPS1)
#define AIPS1_PACRE                              AIPS_PACRE_REG(AIPS1)
#define AIPS1_PACRF                              AIPS_PACRF_REG(AIPS1)
#define AIPS1_PACRG                              AIPS_PACRG_REG(AIPS1)
#define AIPS1_PACRH                              AIPS_PACRH_REG(AIPS1)
#define AIPS1_PACRI                              AIPS_PACRI_REG(AIPS1)
#define AIPS1_PACRJ                              AIPS_PACRJ_REG(AIPS1)
#define AIPS1_PACRK                              AIPS_PACRK_REG(AIPS1)
#define AIPS1_PACRL                              AIPS_PACRL_REG(AIPS1)
#define AIPS1_PACRM                              AIPS_PACRM_REG(AIPS1)
#define AIPS1_PACRN                              AIPS_PACRN_REG(AIPS1)
#define AIPS1_PACRO                              AIPS_PACRO_REG(AIPS1)
#define AIPS1_PACRP                              AIPS_PACRP_REG(AIPS1)

/*!
 * @}
 */ /* end of group AIPS_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group AIPS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AOI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Peripheral_Access_Layer AOI Peripheral Access Layer
 * @{
 */

/** AOI - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT01;                           /**< Boolean Function Term 0 and 1 Configuration Register for EVENTn, array offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT23;                           /**< Boolean Function Term 2 and 3 Configuration Register for EVENTn, array offset: 0x2, array step: 0x4 */
  } BFCRT[4];
} AOI_Type, *AOI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- AOI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Register_Accessor_Macros AOI - Register accessor macros
 * @{
 */


/* AOI - Register accessors */
#define AOI_BFCRT01_REG(base,index)              ((base)->BFCRT[index].BFCRT01)
#define AOI_BFCRT01_COUNT                        4
#define AOI_BFCRT23_REG(base,index)              ((base)->BFCRT[index].BFCRT23)
#define AOI_BFCRT23_COUNT                        4

/*!
 * @}
 */ /* end of group AOI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- AOI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Register_Masks AOI Register Masks
 * @{
 */

/* BFCRT01 Bit Fields */
#define AOI_BFCRT01_PT1_DC_MASK                  0x3u
#define AOI_BFCRT01_PT1_DC_SHIFT                 0
#define AOI_BFCRT01_PT1_DC_WIDTH                 2
#define AOI_BFCRT01_PT1_DC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT1_DC_SHIFT))&AOI_BFCRT01_PT1_DC_MASK)
#define AOI_BFCRT01_PT1_CC_MASK                  0xCu
#define AOI_BFCRT01_PT1_CC_SHIFT                 2
#define AOI_BFCRT01_PT1_CC_WIDTH                 2
#define AOI_BFCRT01_PT1_CC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT1_CC_SHIFT))&AOI_BFCRT01_PT1_CC_MASK)
#define AOI_BFCRT01_PT1_BC_MASK                  0x30u
#define AOI_BFCRT01_PT1_BC_SHIFT                 4
#define AOI_BFCRT01_PT1_BC_WIDTH                 2
#define AOI_BFCRT01_PT1_BC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT1_BC_SHIFT))&AOI_BFCRT01_PT1_BC_MASK)
#define AOI_BFCRT01_PT1_AC_MASK                  0xC0u
#define AOI_BFCRT01_PT1_AC_SHIFT                 6
#define AOI_BFCRT01_PT1_AC_WIDTH                 2
#define AOI_BFCRT01_PT1_AC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT1_AC_SHIFT))&AOI_BFCRT01_PT1_AC_MASK)
#define AOI_BFCRT01_PT0_DC_MASK                  0x300u
#define AOI_BFCRT01_PT0_DC_SHIFT                 8
#define AOI_BFCRT01_PT0_DC_WIDTH                 2
#define AOI_BFCRT01_PT0_DC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT0_DC_SHIFT))&AOI_BFCRT01_PT0_DC_MASK)
#define AOI_BFCRT01_PT0_CC_MASK                  0xC00u
#define AOI_BFCRT01_PT0_CC_SHIFT                 10
#define AOI_BFCRT01_PT0_CC_WIDTH                 2
#define AOI_BFCRT01_PT0_CC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT0_CC_SHIFT))&AOI_BFCRT01_PT0_CC_MASK)
#define AOI_BFCRT01_PT0_BC_MASK                  0x3000u
#define AOI_BFCRT01_PT0_BC_SHIFT                 12
#define AOI_BFCRT01_PT0_BC_WIDTH                 2
#define AOI_BFCRT01_PT0_BC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT0_BC_SHIFT))&AOI_BFCRT01_PT0_BC_MASK)
#define AOI_BFCRT01_PT0_AC_MASK                  0xC000u
#define AOI_BFCRT01_PT0_AC_SHIFT                 14
#define AOI_BFCRT01_PT0_AC_WIDTH                 2
#define AOI_BFCRT01_PT0_AC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT01_PT0_AC_SHIFT))&AOI_BFCRT01_PT0_AC_MASK)
/* BFCRT23 Bit Fields */
#define AOI_BFCRT23_PT3_DC_MASK                  0x3u
#define AOI_BFCRT23_PT3_DC_SHIFT                 0
#define AOI_BFCRT23_PT3_DC_WIDTH                 2
#define AOI_BFCRT23_PT3_DC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT3_DC_SHIFT))&AOI_BFCRT23_PT3_DC_MASK)
#define AOI_BFCRT23_PT3_CC_MASK                  0xCu
#define AOI_BFCRT23_PT3_CC_SHIFT                 2
#define AOI_BFCRT23_PT3_CC_WIDTH                 2
#define AOI_BFCRT23_PT3_CC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT3_CC_SHIFT))&AOI_BFCRT23_PT3_CC_MASK)
#define AOI_BFCRT23_PT3_BC_MASK                  0x30u
#define AOI_BFCRT23_PT3_BC_SHIFT                 4
#define AOI_BFCRT23_PT3_BC_WIDTH                 2
#define AOI_BFCRT23_PT3_BC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT3_BC_SHIFT))&AOI_BFCRT23_PT3_BC_MASK)
#define AOI_BFCRT23_PT3_AC_MASK                  0xC0u
#define AOI_BFCRT23_PT3_AC_SHIFT                 6
#define AOI_BFCRT23_PT3_AC_WIDTH                 2
#define AOI_BFCRT23_PT3_AC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT3_AC_SHIFT))&AOI_BFCRT23_PT3_AC_MASK)
#define AOI_BFCRT23_PT2_DC_MASK                  0x300u
#define AOI_BFCRT23_PT2_DC_SHIFT                 8
#define AOI_BFCRT23_PT2_DC_WIDTH                 2
#define AOI_BFCRT23_PT2_DC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT2_DC_SHIFT))&AOI_BFCRT23_PT2_DC_MASK)
#define AOI_BFCRT23_PT2_CC_MASK                  0xC00u
#define AOI_BFCRT23_PT2_CC_SHIFT                 10
#define AOI_BFCRT23_PT2_CC_WIDTH                 2
#define AOI_BFCRT23_PT2_CC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT2_CC_SHIFT))&AOI_BFCRT23_PT2_CC_MASK)
#define AOI_BFCRT23_PT2_BC_MASK                  0x3000u
#define AOI_BFCRT23_PT2_BC_SHIFT                 12
#define AOI_BFCRT23_PT2_BC_WIDTH                 2
#define AOI_BFCRT23_PT2_BC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT2_BC_SHIFT))&AOI_BFCRT23_PT2_BC_MASK)
#define AOI_BFCRT23_PT2_AC_MASK                  0xC000u
#define AOI_BFCRT23_PT2_AC_SHIFT                 14
#define AOI_BFCRT23_PT2_AC_WIDTH                 2
#define AOI_BFCRT23_PT2_AC(x)                    (((uint16_t)(((uint16_t)(x))<<AOI_BFCRT23_PT2_AC_SHIFT))&AOI_BFCRT23_PT2_AC_MASK)

/*!
 * @}
 */ /* end of group AOI_Register_Masks */


/* AOI - Peripheral instance base addresses */
/** Peripheral AOI base address */
#define AOI_BASE                                 (0x800B6000u)
/** Peripheral AOI base pointer */
#define AOI                                      ((AOI_Type *)AOI_BASE)
#define AOI_BASE_PTR                             (AOI)
/** Array initializer of AOI peripheral base addresses */
#define AOI_BASE_ADDRS                           { AOI_BASE }
/** Array initializer of AOI peripheral base pointers */
#define AOI_BASE_PTRS                            { AOI }

/* ----------------------------------------------------------------------------
   -- AOI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Register_Accessor_Macros AOI - Register accessor macros
 * @{
 */


/* AOI - Register instance definitions */
/* AOI */
#define AOI_BFCRT010                             AOI_BFCRT01_REG(AOI,0)
#define AOI_BFCRT230                             AOI_BFCRT23_REG(AOI,0)
#define AOI_BFCRT011                             AOI_BFCRT01_REG(AOI,1)
#define AOI_BFCRT231                             AOI_BFCRT23_REG(AOI,1)
#define AOI_BFCRT012                             AOI_BFCRT01_REG(AOI,2)
#define AOI_BFCRT232                             AOI_BFCRT23_REG(AOI,2)
#define AOI_BFCRT013                             AOI_BFCRT01_REG(AOI,3)
#define AOI_BFCRT233                             AOI_BFCRT23_REG(AOI,3)

/* AOI - Register array accessors */
#define AOI_BFCRT01(index)                       AOI_BFCRT01_REG(AOI,index)
#define AOI_BFCRT23(index)                       AOI_BFCRT23_REG(AOI,index)

/*!
 * @}
 */ /* end of group AOI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group AOI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AXBS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXBS_Peripheral_Access_Layer AXBS Peripheral Access Layer
 * @{
 */

/** AXBS - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  struct {                                         /* offset: 0x10, array step: 0x100 */
    __IO uint32_t CRS;                               /**< Control Register, array offset: 0x10, array step: 0x100 */
         uint8_t RESERVED_0[252];
  } SLAVE[8];
} AXBS_Type, *AXBS_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- AXBS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXBS_Register_Accessor_Macros AXBS - Register accessor macros
 * @{
 */


/* AXBS - Register accessors */
#define AXBS_CRS_REG(base,index)                 ((base)->SLAVE[index].CRS)
#define AXBS_CRS_COUNT                           8

/*!
 * @}
 */ /* end of group AXBS_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- AXBS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXBS_Register_Masks AXBS Register Masks
 * @{
 */

/* CRS Bit Fields */
#define AXBS_CRS_PARK_MASK                       0x7u
#define AXBS_CRS_PARK_SHIFT                      0
#define AXBS_CRS_PARK_WIDTH                      3
#define AXBS_CRS_PARK(x)                         (((uint32_t)(((uint32_t)(x))<<AXBS_CRS_PARK_SHIFT))&AXBS_CRS_PARK_MASK)
#define AXBS_CRS_PCTL_MASK                       0x30u
#define AXBS_CRS_PCTL_SHIFT                      4
#define AXBS_CRS_PCTL_WIDTH                      2
#define AXBS_CRS_PCTL(x)                         (((uint32_t)(((uint32_t)(x))<<AXBS_CRS_PCTL_SHIFT))&AXBS_CRS_PCTL_MASK)
#define AXBS_CRS_ARB_MASK                        0x300u
#define AXBS_CRS_ARB_SHIFT                       8
#define AXBS_CRS_ARB_WIDTH                       2
#define AXBS_CRS_ARB(x)                          (((uint32_t)(((uint32_t)(x))<<AXBS_CRS_ARB_SHIFT))&AXBS_CRS_ARB_MASK)
#define AXBS_CRS_HLP_MASK                        0x40000000u
#define AXBS_CRS_HLP_SHIFT                       30
#define AXBS_CRS_HLP_WIDTH                       1
#define AXBS_CRS_HLP(x)                          (((uint32_t)(((uint32_t)(x))<<AXBS_CRS_HLP_SHIFT))&AXBS_CRS_HLP_MASK)
#define AXBS_CRS_RO_MASK                         0x80000000u
#define AXBS_CRS_RO_SHIFT                        31
#define AXBS_CRS_RO_WIDTH                        1
#define AXBS_CRS_RO(x)                           (((uint32_t)(((uint32_t)(x))<<AXBS_CRS_RO_SHIFT))&AXBS_CRS_RO_MASK)

/*!
 * @}
 */ /* end of group AXBS_Register_Masks */


/* AXBS - Peripheral instance base addresses */
/** Peripheral AXBS base address */
#define AXBS_BASE                                (0x10000u)
/** Peripheral AXBS base pointer */
#define AXBS                                     ((AXBS_Type *)AXBS_BASE)
#define AXBS_BASE_PTR                            (AXBS)
/** Array initializer of AXBS peripheral base addresses */
#define AXBS_BASE_ADDRS                          { AXBS_BASE }
/** Array initializer of AXBS peripheral base pointers */
#define AXBS_BASE_PTRS                           { AXBS }

/* ----------------------------------------------------------------------------
   -- AXBS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXBS_Register_Accessor_Macros AXBS - Register accessor macros
 * @{
 */


/* AXBS - Register instance definitions */
/* AXBS */
#define AXBS_CRS0                                AXBS_CRS_REG(AXBS,0)
#define AXBS_CRS1                                AXBS_CRS_REG(AXBS,1)
#define AXBS_CRS2                                AXBS_CRS_REG(AXBS,2)
#define AXBS_CRS3                                AXBS_CRS_REG(AXBS,3)
#define AXBS_CRS4                                AXBS_CRS_REG(AXBS,4)
#define AXBS_CRS5                                AXBS_CRS_REG(AXBS,5)
#define AXBS_CRS6                                AXBS_CRS_REG(AXBS,6)
#define AXBS_CRS7                                AXBS_CRS_REG(AXBS,7)

/* AXBS - Register array accessors */
#define AXBS_CRS(index)                          AXBS_CRS_REG(AXBS,index)

/*!
 * @}
 */ /* end of group AXBS_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group AXBS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration Register, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1 register, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free Running Timer, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< Rx Mailboxes Global Mask Register, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Rx 14 Mask register, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Rx 15 Mask register, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1 register, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __IO uint32_t IMASK1;                            /**< Interrupt Masks 1 register, offset: 0x28 */
       uint8_t RESERVED_2[4];
  __IO uint32_t IFLAG1;                            /**< Interrupt Flags 1 register, offset: 0x30 */
  __IO uint32_t CTRL2;                             /**< Control 2 register, offset: 0x34 */
  __I  uint32_t ESR2;                              /**< Error and Status 2 register, offset: 0x38 */
       uint8_t RESERVED_3[8];
  __I  uint32_t CRCR;                              /**< CRC Register, offset: 0x44 */
  __IO uint32_t RXFGMASK;                          /**< Rx FIFO Global Mask register, offset: 0x48 */
  __I  uint32_t RXFIR;                             /**< Rx FIFO Information Register, offset: 0x4C */
       uint8_t RESERVED_4[48];
  struct {                                         /* offset: 0x80, array step: 0x10 */
    __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 15 CS Register, array offset: 0x80, array step: 0x10 */
    __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 15 ID Register, array offset: 0x84, array step: 0x10 */
    __IO uint32_t WORD0;                             /**< Message Buffer 0 WORD0 Register..Message Buffer 15 WORD0 Register, array offset: 0x88, array step: 0x10 */
    __IO uint32_t WORD1;                             /**< Message Buffer 0 WORD1 Register..Message Buffer 15 WORD1 Register, array offset: 0x8C, array step: 0x10 */
  } MB[16];
       uint8_t RESERVED_5[1792];
  __IO uint32_t RXIMR[16];                         /**< Rx Individual Mask Registers, array offset: 0x880, array step: 0x4 */
} CAN_Type, *CAN_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CAN - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Accessor_Macros CAN - Register accessor macros
 * @{
 */


/* CAN - Register accessors */
#define CAN_MCR_REG(base)                        ((base)->MCR)
#define CAN_CTRL1_REG(base)                      ((base)->CTRL1)
#define CAN_TIMER_REG(base)                      ((base)->TIMER)
#define CAN_RXMGMASK_REG(base)                   ((base)->RXMGMASK)
#define CAN_RX14MASK_REG(base)                   ((base)->RX14MASK)
#define CAN_RX15MASK_REG(base)                   ((base)->RX15MASK)
#define CAN_ECR_REG(base)                        ((base)->ECR)
#define CAN_ESR1_REG(base)                       ((base)->ESR1)
#define CAN_IMASK1_REG(base)                     ((base)->IMASK1)
#define CAN_IFLAG1_REG(base)                     ((base)->IFLAG1)
#define CAN_CTRL2_REG(base)                      ((base)->CTRL2)
#define CAN_ESR2_REG(base)                       ((base)->ESR2)
#define CAN_CRCR_REG(base)                       ((base)->CRCR)
#define CAN_RXFGMASK_REG(base)                   ((base)->RXFGMASK)
#define CAN_RXFIR_REG(base)                      ((base)->RXFIR)
#define CAN_CS_REG(base,index)                   ((base)->MB[index].CS)
#define CAN_CS_COUNT                             16
#define CAN_ID_REG(base,index)                   ((base)->MB[index].ID)
#define CAN_ID_COUNT                             16
#define CAN_WORD0_REG(base,index)                ((base)->MB[index].WORD0)
#define CAN_WORD0_COUNT                          16
#define CAN_WORD1_REG(base,index)                ((base)->MB[index].WORD1)
#define CAN_WORD1_COUNT                          16
#define CAN_RXIMR_REG(base,index)                ((base)->RXIMR[index])
#define CAN_RXIMR_COUNT                          16

/*!
 * @}
 */ /* end of group CAN_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/* MCR Bit Fields */
#define CAN_MCR_MAXMB_MASK                       0x7Fu
#define CAN_MCR_MAXMB_SHIFT                      0
#define CAN_MCR_MAXMB_WIDTH                      7
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_MCR_MAXMB_SHIFT))&CAN_MCR_MAXMB_MASK)
#define CAN_MCR_IDAM_MASK                        0x300u
#define CAN_MCR_IDAM_SHIFT                       8
#define CAN_MCR_IDAM_WIDTH                       2
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_IDAM_SHIFT))&CAN_MCR_IDAM_MASK)
#define CAN_MCR_AEN_MASK                         0x1000u
#define CAN_MCR_AEN_SHIFT                        12
#define CAN_MCR_AEN_WIDTH                        1
#define CAN_MCR_AEN(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_MCR_AEN_SHIFT))&CAN_MCR_AEN_MASK)
#define CAN_MCR_LPRIOEN_MASK                     0x2000u
#define CAN_MCR_LPRIOEN_SHIFT                    13
#define CAN_MCR_LPRIOEN_WIDTH                    1
#define CAN_MCR_LPRIOEN(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_MCR_LPRIOEN_SHIFT))&CAN_MCR_LPRIOEN_MASK)
#define CAN_MCR_DMA_MASK                         0x8000u
#define CAN_MCR_DMA_SHIFT                        15
#define CAN_MCR_DMA_WIDTH                        1
#define CAN_MCR_DMA(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_MCR_DMA_SHIFT))&CAN_MCR_DMA_MASK)
#define CAN_MCR_IRMQ_MASK                        0x10000u
#define CAN_MCR_IRMQ_SHIFT                       16
#define CAN_MCR_IRMQ_WIDTH                       1
#define CAN_MCR_IRMQ(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_IRMQ_SHIFT))&CAN_MCR_IRMQ_MASK)
#define CAN_MCR_SRXDIS_MASK                      0x20000u
#define CAN_MCR_SRXDIS_SHIFT                     17
#define CAN_MCR_SRXDIS_WIDTH                     1
#define CAN_MCR_SRXDIS(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_MCR_SRXDIS_SHIFT))&CAN_MCR_SRXDIS_MASK)
#define CAN_MCR_DOZE_MASK                        0x40000u
#define CAN_MCR_DOZE_SHIFT                       18
#define CAN_MCR_DOZE_WIDTH                       1
#define CAN_MCR_DOZE(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_DOZE_SHIFT))&CAN_MCR_DOZE_MASK)
#define CAN_MCR_WAKSRC_MASK                      0x80000u
#define CAN_MCR_WAKSRC_SHIFT                     19
#define CAN_MCR_WAKSRC_WIDTH                     1
#define CAN_MCR_WAKSRC(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_MCR_WAKSRC_SHIFT))&CAN_MCR_WAKSRC_MASK)
#define CAN_MCR_LPMACK_MASK                      0x100000u
#define CAN_MCR_LPMACK_SHIFT                     20
#define CAN_MCR_LPMACK_WIDTH                     1
#define CAN_MCR_LPMACK(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_MCR_LPMACK_SHIFT))&CAN_MCR_LPMACK_MASK)
#define CAN_MCR_WRNEN_MASK                       0x200000u
#define CAN_MCR_WRNEN_SHIFT                      21
#define CAN_MCR_WRNEN_WIDTH                      1
#define CAN_MCR_WRNEN(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_MCR_WRNEN_SHIFT))&CAN_MCR_WRNEN_MASK)
#define CAN_MCR_SLFWAK_MASK                      0x400000u
#define CAN_MCR_SLFWAK_SHIFT                     22
#define CAN_MCR_SLFWAK_WIDTH                     1
#define CAN_MCR_SLFWAK(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_MCR_SLFWAK_SHIFT))&CAN_MCR_SLFWAK_MASK)
#define CAN_MCR_SUPV_MASK                        0x800000u
#define CAN_MCR_SUPV_SHIFT                       23
#define CAN_MCR_SUPV_WIDTH                       1
#define CAN_MCR_SUPV(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_SUPV_SHIFT))&CAN_MCR_SUPV_MASK)
#define CAN_MCR_FRZACK_MASK                      0x1000000u
#define CAN_MCR_FRZACK_SHIFT                     24
#define CAN_MCR_FRZACK_WIDTH                     1
#define CAN_MCR_FRZACK(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_MCR_FRZACK_SHIFT))&CAN_MCR_FRZACK_MASK)
#define CAN_MCR_SOFTRST_MASK                     0x2000000u
#define CAN_MCR_SOFTRST_SHIFT                    25
#define CAN_MCR_SOFTRST_WIDTH                    1
#define CAN_MCR_SOFTRST(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_MCR_SOFTRST_SHIFT))&CAN_MCR_SOFTRST_MASK)
#define CAN_MCR_WAKMSK_MASK                      0x4000000u
#define CAN_MCR_WAKMSK_SHIFT                     26
#define CAN_MCR_WAKMSK_WIDTH                     1
#define CAN_MCR_WAKMSK(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_MCR_WAKMSK_SHIFT))&CAN_MCR_WAKMSK_MASK)
#define CAN_MCR_NOTRDY_MASK                      0x8000000u
#define CAN_MCR_NOTRDY_SHIFT                     27
#define CAN_MCR_NOTRDY_WIDTH                     1
#define CAN_MCR_NOTRDY(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_MCR_NOTRDY_SHIFT))&CAN_MCR_NOTRDY_MASK)
#define CAN_MCR_HALT_MASK                        0x10000000u
#define CAN_MCR_HALT_SHIFT                       28
#define CAN_MCR_HALT_WIDTH                       1
#define CAN_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_HALT_SHIFT))&CAN_MCR_HALT_MASK)
#define CAN_MCR_RFEN_MASK                        0x20000000u
#define CAN_MCR_RFEN_SHIFT                       29
#define CAN_MCR_RFEN_WIDTH                       1
#define CAN_MCR_RFEN(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_RFEN_SHIFT))&CAN_MCR_RFEN_MASK)
#define CAN_MCR_FRZ_MASK                         0x40000000u
#define CAN_MCR_FRZ_SHIFT                        30
#define CAN_MCR_FRZ_WIDTH                        1
#define CAN_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_MCR_FRZ_SHIFT))&CAN_MCR_FRZ_MASK)
#define CAN_MCR_MDIS_MASK                        0x80000000u
#define CAN_MCR_MDIS_SHIFT                       31
#define CAN_MCR_MDIS_WIDTH                       1
#define CAN_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_MDIS_SHIFT))&CAN_MCR_MDIS_MASK)
/* CTRL1 Bit Fields */
#define CAN_CTRL1_PROPSEG_MASK                   0x7u
#define CAN_CTRL1_PROPSEG_SHIFT                  0
#define CAN_CTRL1_PROPSEG_WIDTH                  3
#define CAN_CTRL1_PROPSEG(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PROPSEG_SHIFT))&CAN_CTRL1_PROPSEG_MASK)
#define CAN_CTRL1_LOM_MASK                       0x8u
#define CAN_CTRL1_LOM_SHIFT                      3
#define CAN_CTRL1_LOM_WIDTH                      1
#define CAN_CTRL1_LOM(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_LOM_SHIFT))&CAN_CTRL1_LOM_MASK)
#define CAN_CTRL1_LBUF_MASK                      0x10u
#define CAN_CTRL1_LBUF_SHIFT                     4
#define CAN_CTRL1_LBUF_WIDTH                     1
#define CAN_CTRL1_LBUF(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_LBUF_SHIFT))&CAN_CTRL1_LBUF_MASK)
#define CAN_CTRL1_TSYN_MASK                      0x20u
#define CAN_CTRL1_TSYN_SHIFT                     5
#define CAN_CTRL1_TSYN_WIDTH                     1
#define CAN_CTRL1_TSYN(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_TSYN_SHIFT))&CAN_CTRL1_TSYN_MASK)
#define CAN_CTRL1_BOFFREC_MASK                   0x40u
#define CAN_CTRL1_BOFFREC_SHIFT                  6
#define CAN_CTRL1_BOFFREC_WIDTH                  1
#define CAN_CTRL1_BOFFREC(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_BOFFREC_SHIFT))&CAN_CTRL1_BOFFREC_MASK)
#define CAN_CTRL1_SMP_MASK                       0x80u
#define CAN_CTRL1_SMP_SHIFT                      7
#define CAN_CTRL1_SMP_WIDTH                      1
#define CAN_CTRL1_SMP(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_SMP_SHIFT))&CAN_CTRL1_SMP_MASK)
#define CAN_CTRL1_RWRNMSK_MASK                   0x400u
#define CAN_CTRL1_RWRNMSK_SHIFT                  10
#define CAN_CTRL1_RWRNMSK_WIDTH                  1
#define CAN_CTRL1_RWRNMSK(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_RWRNMSK_SHIFT))&CAN_CTRL1_RWRNMSK_MASK)
#define CAN_CTRL1_TWRNMSK_MASK                   0x800u
#define CAN_CTRL1_TWRNMSK_SHIFT                  11
#define CAN_CTRL1_TWRNMSK_WIDTH                  1
#define CAN_CTRL1_TWRNMSK(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_TWRNMSK_SHIFT))&CAN_CTRL1_TWRNMSK_MASK)
#define CAN_CTRL1_LPB_MASK                       0x1000u
#define CAN_CTRL1_LPB_SHIFT                      12
#define CAN_CTRL1_LPB_WIDTH                      1
#define CAN_CTRL1_LPB(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_LPB_SHIFT))&CAN_CTRL1_LPB_MASK)
#define CAN_CTRL1_CLKSRC_MASK                    0x2000u
#define CAN_CTRL1_CLKSRC_SHIFT                   13
#define CAN_CTRL1_CLKSRC_WIDTH                   1
#define CAN_CTRL1_CLKSRC(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_CLKSRC_SHIFT))&CAN_CTRL1_CLKSRC_MASK)
#define CAN_CTRL1_ERRMSK_MASK                    0x4000u
#define CAN_CTRL1_ERRMSK_SHIFT                   14
#define CAN_CTRL1_ERRMSK_WIDTH                   1
#define CAN_CTRL1_ERRMSK(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_ERRMSK_SHIFT))&CAN_CTRL1_ERRMSK_MASK)
#define CAN_CTRL1_BOFFMSK_MASK                   0x8000u
#define CAN_CTRL1_BOFFMSK_SHIFT                  15
#define CAN_CTRL1_BOFFMSK_WIDTH                  1
#define CAN_CTRL1_BOFFMSK(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_BOFFMSK_SHIFT))&CAN_CTRL1_BOFFMSK_MASK)
#define CAN_CTRL1_PSEG2_MASK                     0x70000u
#define CAN_CTRL1_PSEG2_SHIFT                    16
#define CAN_CTRL1_PSEG2_WIDTH                    3
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PSEG2_SHIFT))&CAN_CTRL1_PSEG2_MASK)
#define CAN_CTRL1_PSEG1_MASK                     0x380000u
#define CAN_CTRL1_PSEG1_SHIFT                    19
#define CAN_CTRL1_PSEG1_WIDTH                    3
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PSEG1_SHIFT))&CAN_CTRL1_PSEG1_MASK)
#define CAN_CTRL1_RJW_MASK                       0xC00000u
#define CAN_CTRL1_RJW_SHIFT                      22
#define CAN_CTRL1_RJW_WIDTH                      2
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_RJW_SHIFT))&CAN_CTRL1_RJW_MASK)
#define CAN_CTRL1_PRESDIV_MASK                   0xFF000000u
#define CAN_CTRL1_PRESDIV_SHIFT                  24
#define CAN_CTRL1_PRESDIV_WIDTH                  8
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PRESDIV_SHIFT))&CAN_CTRL1_PRESDIV_MASK)
/* TIMER Bit Fields */
#define CAN_TIMER_TIMER_MASK                     0xFFFFu
#define CAN_TIMER_TIMER_SHIFT                    0
#define CAN_TIMER_TIMER_WIDTH                    16
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_TIMER_TIMER_SHIFT))&CAN_TIMER_TIMER_MASK)
/* RXMGMASK Bit Fields */
#define CAN_RXMGMASK_MG_MASK                     0xFFFFFFFFu
#define CAN_RXMGMASK_MG_SHIFT                    0
#define CAN_RXMGMASK_MG_WIDTH                    32
#define CAN_RXMGMASK_MG(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_RXMGMASK_MG_SHIFT))&CAN_RXMGMASK_MG_MASK)
/* RX14MASK Bit Fields */
#define CAN_RX14MASK_RX14M_MASK                  0xFFFFFFFFu
#define CAN_RX14MASK_RX14M_SHIFT                 0
#define CAN_RX14MASK_RX14M_WIDTH                 32
#define CAN_RX14MASK_RX14M(x)                    (((uint32_t)(((uint32_t)(x))<<CAN_RX14MASK_RX14M_SHIFT))&CAN_RX14MASK_RX14M_MASK)
/* RX15MASK Bit Fields */
#define CAN_RX15MASK_RX15M_MASK                  0xFFFFFFFFu
#define CAN_RX15MASK_RX15M_SHIFT                 0
#define CAN_RX15MASK_RX15M_WIDTH                 32
#define CAN_RX15MASK_RX15M(x)                    (((uint32_t)(((uint32_t)(x))<<CAN_RX15MASK_RX15M_SHIFT))&CAN_RX15MASK_RX15M_MASK)
/* ECR Bit Fields */
#define CAN_ECR_TXERRCNT_MASK                    0xFFu
#define CAN_ECR_TXERRCNT_SHIFT                   0
#define CAN_ECR_TXERRCNT_WIDTH                   8
#define CAN_ECR_TXERRCNT(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ECR_TXERRCNT_SHIFT))&CAN_ECR_TXERRCNT_MASK)
#define CAN_ECR_RXERRCNT_MASK                    0xFF00u
#define CAN_ECR_RXERRCNT_SHIFT                   8
#define CAN_ECR_RXERRCNT_WIDTH                   8
#define CAN_ECR_RXERRCNT(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ECR_RXERRCNT_SHIFT))&CAN_ECR_RXERRCNT_MASK)
/* ESR1 Bit Fields */
#define CAN_ESR1_WAKINT_MASK                     0x1u
#define CAN_ESR1_WAKINT_SHIFT                    0
#define CAN_ESR1_WAKINT_WIDTH                    1
#define CAN_ESR1_WAKINT(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_WAKINT_SHIFT))&CAN_ESR1_WAKINT_MASK)
#define CAN_ESR1_ERRINT_MASK                     0x2u
#define CAN_ESR1_ERRINT_SHIFT                    1
#define CAN_ESR1_ERRINT_WIDTH                    1
#define CAN_ESR1_ERRINT(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_ERRINT_SHIFT))&CAN_ESR1_ERRINT_MASK)
#define CAN_ESR1_BOFFINT_MASK                    0x4u
#define CAN_ESR1_BOFFINT_SHIFT                   2
#define CAN_ESR1_BOFFINT_WIDTH                   1
#define CAN_ESR1_BOFFINT(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_BOFFINT_SHIFT))&CAN_ESR1_BOFFINT_MASK)
#define CAN_ESR1_RX_MASK                         0x8u
#define CAN_ESR1_RX_SHIFT                        3
#define CAN_ESR1_RX_WIDTH                        1
#define CAN_ESR1_RX(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_RX_SHIFT))&CAN_ESR1_RX_MASK)
#define CAN_ESR1_FLTCONF_MASK                    0x30u
#define CAN_ESR1_FLTCONF_SHIFT                   4
#define CAN_ESR1_FLTCONF_WIDTH                   2
#define CAN_ESR1_FLTCONF(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_FLTCONF_SHIFT))&CAN_ESR1_FLTCONF_MASK)
#define CAN_ESR1_TX_MASK                         0x40u
#define CAN_ESR1_TX_SHIFT                        6
#define CAN_ESR1_TX_WIDTH                        1
#define CAN_ESR1_TX(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_TX_SHIFT))&CAN_ESR1_TX_MASK)
#define CAN_ESR1_IDLE_MASK                       0x80u
#define CAN_ESR1_IDLE_SHIFT                      7
#define CAN_ESR1_IDLE_WIDTH                      1
#define CAN_ESR1_IDLE(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_IDLE_SHIFT))&CAN_ESR1_IDLE_MASK)
#define CAN_ESR1_RXWRN_MASK                      0x100u
#define CAN_ESR1_RXWRN_SHIFT                     8
#define CAN_ESR1_RXWRN_WIDTH                     1
#define CAN_ESR1_RXWRN(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_RXWRN_SHIFT))&CAN_ESR1_RXWRN_MASK)
#define CAN_ESR1_TXWRN_MASK                      0x200u
#define CAN_ESR1_TXWRN_SHIFT                     9
#define CAN_ESR1_TXWRN_WIDTH                     1
#define CAN_ESR1_TXWRN(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_TXWRN_SHIFT))&CAN_ESR1_TXWRN_MASK)
#define CAN_ESR1_STFERR_MASK                     0x400u
#define CAN_ESR1_STFERR_SHIFT                    10
#define CAN_ESR1_STFERR_WIDTH                    1
#define CAN_ESR1_STFERR(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_STFERR_SHIFT))&CAN_ESR1_STFERR_MASK)
#define CAN_ESR1_FRMERR_MASK                     0x800u
#define CAN_ESR1_FRMERR_SHIFT                    11
#define CAN_ESR1_FRMERR_WIDTH                    1
#define CAN_ESR1_FRMERR(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_FRMERR_SHIFT))&CAN_ESR1_FRMERR_MASK)
#define CAN_ESR1_CRCERR_MASK                     0x1000u
#define CAN_ESR1_CRCERR_SHIFT                    12
#define CAN_ESR1_CRCERR_WIDTH                    1
#define CAN_ESR1_CRCERR(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_CRCERR_SHIFT))&CAN_ESR1_CRCERR_MASK)
#define CAN_ESR1_ACKERR_MASK                     0x2000u
#define CAN_ESR1_ACKERR_SHIFT                    13
#define CAN_ESR1_ACKERR_WIDTH                    1
#define CAN_ESR1_ACKERR(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_ACKERR_SHIFT))&CAN_ESR1_ACKERR_MASK)
#define CAN_ESR1_BIT0ERR_MASK                    0x4000u
#define CAN_ESR1_BIT0ERR_SHIFT                   14
#define CAN_ESR1_BIT0ERR_WIDTH                   1
#define CAN_ESR1_BIT0ERR(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_BIT0ERR_SHIFT))&CAN_ESR1_BIT0ERR_MASK)
#define CAN_ESR1_BIT1ERR_MASK                    0x8000u
#define CAN_ESR1_BIT1ERR_SHIFT                   15
#define CAN_ESR1_BIT1ERR_WIDTH                   1
#define CAN_ESR1_BIT1ERR(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_BIT1ERR_SHIFT))&CAN_ESR1_BIT1ERR_MASK)
#define CAN_ESR1_RWRNINT_MASK                    0x10000u
#define CAN_ESR1_RWRNINT_SHIFT                   16
#define CAN_ESR1_RWRNINT_WIDTH                   1
#define CAN_ESR1_RWRNINT(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_RWRNINT_SHIFT))&CAN_ESR1_RWRNINT_MASK)
#define CAN_ESR1_TWRNINT_MASK                    0x20000u
#define CAN_ESR1_TWRNINT_SHIFT                   17
#define CAN_ESR1_TWRNINT_WIDTH                   1
#define CAN_ESR1_TWRNINT(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_TWRNINT_SHIFT))&CAN_ESR1_TWRNINT_MASK)
#define CAN_ESR1_SYNCH_MASK                      0x40000u
#define CAN_ESR1_SYNCH_SHIFT                     18
#define CAN_ESR1_SYNCH_WIDTH                     1
#define CAN_ESR1_SYNCH(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_SYNCH_SHIFT))&CAN_ESR1_SYNCH_MASK)
/* IMASK1 Bit Fields */
#define CAN_IMASK1_BUFLM_MASK                    0xFFFFFFFFu
#define CAN_IMASK1_BUFLM_SHIFT                   0
#define CAN_IMASK1_BUFLM_WIDTH                   32
#define CAN_IMASK1_BUFLM(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_IMASK1_BUFLM_SHIFT))&CAN_IMASK1_BUFLM_MASK)
/* IFLAG1 Bit Fields */
#define CAN_IFLAG1_BUF0I_MASK                    0x1u
#define CAN_IFLAG1_BUF0I_SHIFT                   0
#define CAN_IFLAG1_BUF0I_WIDTH                   1
#define CAN_IFLAG1_BUF0I(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF0I_SHIFT))&CAN_IFLAG1_BUF0I_MASK)
#define CAN_IFLAG1_BUF4TO1I_MASK                 0x1Eu
#define CAN_IFLAG1_BUF4TO1I_SHIFT                1
#define CAN_IFLAG1_BUF4TO1I_WIDTH                4
#define CAN_IFLAG1_BUF4TO1I(x)                   (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF4TO1I_SHIFT))&CAN_IFLAG1_BUF4TO1I_MASK)
#define CAN_IFLAG1_BUF5I_MASK                    0x20u
#define CAN_IFLAG1_BUF5I_SHIFT                   5
#define CAN_IFLAG1_BUF5I_WIDTH                   1
#define CAN_IFLAG1_BUF5I(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF5I_SHIFT))&CAN_IFLAG1_BUF5I_MASK)
#define CAN_IFLAG1_BUF6I_MASK                    0x40u
#define CAN_IFLAG1_BUF6I_SHIFT                   6
#define CAN_IFLAG1_BUF6I_WIDTH                   1
#define CAN_IFLAG1_BUF6I(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF6I_SHIFT))&CAN_IFLAG1_BUF6I_MASK)
#define CAN_IFLAG1_BUF7I_MASK                    0x80u
#define CAN_IFLAG1_BUF7I_SHIFT                   7
#define CAN_IFLAG1_BUF7I_WIDTH                   1
#define CAN_IFLAG1_BUF7I(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF7I_SHIFT))&CAN_IFLAG1_BUF7I_MASK)
#define CAN_IFLAG1_BUF31TO8I_MASK                0xFFFFFF00u
#define CAN_IFLAG1_BUF31TO8I_SHIFT               8
#define CAN_IFLAG1_BUF31TO8I_WIDTH               24
#define CAN_IFLAG1_BUF31TO8I(x)                  (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF31TO8I_SHIFT))&CAN_IFLAG1_BUF31TO8I_MASK)
/* CTRL2 Bit Fields */
#define CAN_CTRL2_EACEN_MASK                     0x10000u
#define CAN_CTRL2_EACEN_SHIFT                    16
#define CAN_CTRL2_EACEN_WIDTH                    1
#define CAN_CTRL2_EACEN(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_EACEN_SHIFT))&CAN_CTRL2_EACEN_MASK)
#define CAN_CTRL2_RRS_MASK                       0x20000u
#define CAN_CTRL2_RRS_SHIFT                      17
#define CAN_CTRL2_RRS_WIDTH                      1
#define CAN_CTRL2_RRS(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_RRS_SHIFT))&CAN_CTRL2_RRS_MASK)
#define CAN_CTRL2_MRP_MASK                       0x40000u
#define CAN_CTRL2_MRP_SHIFT                      18
#define CAN_CTRL2_MRP_WIDTH                      1
#define CAN_CTRL2_MRP(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_MRP_SHIFT))&CAN_CTRL2_MRP_MASK)
#define CAN_CTRL2_TASD_MASK                      0xF80000u
#define CAN_CTRL2_TASD_SHIFT                     19
#define CAN_CTRL2_TASD_WIDTH                     5
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_TASD_SHIFT))&CAN_CTRL2_TASD_MASK)
#define CAN_CTRL2_RFFN_MASK                      0xF000000u
#define CAN_CTRL2_RFFN_SHIFT                     24
#define CAN_CTRL2_RFFN_WIDTH                     4
#define CAN_CTRL2_RFFN(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_RFFN_SHIFT))&CAN_CTRL2_RFFN_MASK)
#define CAN_CTRL2_WRMFRZ_MASK                    0x10000000u
#define CAN_CTRL2_WRMFRZ_SHIFT                   28
#define CAN_CTRL2_WRMFRZ_WIDTH                   1
#define CAN_CTRL2_WRMFRZ(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_WRMFRZ_SHIFT))&CAN_CTRL2_WRMFRZ_MASK)
/* ESR2 Bit Fields */
#define CAN_ESR2_IMB_MASK                        0x2000u
#define CAN_ESR2_IMB_SHIFT                       13
#define CAN_ESR2_IMB_WIDTH                       1
#define CAN_ESR2_IMB(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_ESR2_IMB_SHIFT))&CAN_ESR2_IMB_MASK)
#define CAN_ESR2_VPS_MASK                        0x4000u
#define CAN_ESR2_VPS_SHIFT                       14
#define CAN_ESR2_VPS_WIDTH                       1
#define CAN_ESR2_VPS(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_ESR2_VPS_SHIFT))&CAN_ESR2_VPS_MASK)
#define CAN_ESR2_LPTM_MASK                       0x7F0000u
#define CAN_ESR2_LPTM_SHIFT                      16
#define CAN_ESR2_LPTM_WIDTH                      7
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_ESR2_LPTM_SHIFT))&CAN_ESR2_LPTM_MASK)
/* CRCR Bit Fields */
#define CAN_CRCR_TXCRC_MASK                      0x7FFFu
#define CAN_CRCR_TXCRC_SHIFT                     0
#define CAN_CRCR_TXCRC_WIDTH                     15
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CRCR_TXCRC_SHIFT))&CAN_CRCR_TXCRC_MASK)
#define CAN_CRCR_MBCRC_MASK                      0x7F0000u
#define CAN_CRCR_MBCRC_SHIFT                     16
#define CAN_CRCR_MBCRC_WIDTH                     7
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CRCR_MBCRC_SHIFT))&CAN_CRCR_MBCRC_MASK)
/* RXFGMASK Bit Fields */
#define CAN_RXFGMASK_FGM_MASK                    0xFFFFFFFFu
#define CAN_RXFGMASK_FGM_SHIFT                   0
#define CAN_RXFGMASK_FGM_WIDTH                   32
#define CAN_RXFGMASK_FGM(x)                      (((uint32_t)(((uint32_t)(x))<<CAN_RXFGMASK_FGM_SHIFT))&CAN_RXFGMASK_FGM_MASK)
/* RXFIR Bit Fields */
#define CAN_RXFIR_IDHIT_MASK                     0x1FFu
#define CAN_RXFIR_IDHIT_SHIFT                    0
#define CAN_RXFIR_IDHIT_WIDTH                    9
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_RXFIR_IDHIT_SHIFT))&CAN_RXFIR_IDHIT_MASK)
/* CS Bit Fields */
#define CAN_CS_TIME_STAMP_MASK                   0xFFFFu
#define CAN_CS_TIME_STAMP_SHIFT                  0
#define CAN_CS_TIME_STAMP_WIDTH                  16
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CS_TIME_STAMP_SHIFT))&CAN_CS_TIME_STAMP_MASK)
#define CAN_CS_DLC_MASK                          0xF0000u
#define CAN_CS_DLC_SHIFT                         16
#define CAN_CS_DLC_WIDTH                         4
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_DLC_SHIFT))&CAN_CS_DLC_MASK)
#define CAN_CS_RTR_MASK                          0x100000u
#define CAN_CS_RTR_SHIFT                         20
#define CAN_CS_RTR_WIDTH                         1
#define CAN_CS_RTR(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_RTR_SHIFT))&CAN_CS_RTR_MASK)
#define CAN_CS_IDE_MASK                          0x200000u
#define CAN_CS_IDE_SHIFT                         21
#define CAN_CS_IDE_WIDTH                         1
#define CAN_CS_IDE(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_IDE_SHIFT))&CAN_CS_IDE_MASK)
#define CAN_CS_SRR_MASK                          0x400000u
#define CAN_CS_SRR_SHIFT                         22
#define CAN_CS_SRR_WIDTH                         1
#define CAN_CS_SRR(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_SRR_SHIFT))&CAN_CS_SRR_MASK)
#define CAN_CS_CODE_MASK                         0xF000000u
#define CAN_CS_CODE_SHIFT                        24
#define CAN_CS_CODE_WIDTH                        4
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_CS_CODE_SHIFT))&CAN_CS_CODE_MASK)
#define CAN_CS_ESI_MASK                          0x20000000u
#define CAN_CS_ESI_SHIFT                         29
#define CAN_CS_ESI_WIDTH                         1
#define CAN_CS_ESI(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_ESI_SHIFT))&CAN_CS_ESI_MASK)
#define CAN_CS_BRS_MASK                          0x40000000u
#define CAN_CS_BRS_SHIFT                         30
#define CAN_CS_BRS_WIDTH                         1
#define CAN_CS_BRS(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_BRS_SHIFT))&CAN_CS_BRS_MASK)
#define CAN_CS_EDL_MASK                          0x80000000u
#define CAN_CS_EDL_SHIFT                         31
#define CAN_CS_EDL_WIDTH                         1
#define CAN_CS_EDL(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_EDL_SHIFT))&CAN_CS_EDL_MASK)
/* ID Bit Fields */
#define CAN_ID_EXT_MASK                          0x3FFFFu
#define CAN_ID_EXT_SHIFT                         0
#define CAN_ID_EXT_WIDTH                         18
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_ID_EXT_SHIFT))&CAN_ID_EXT_MASK)
#define CAN_ID_STD_MASK                          0x1FFC0000u
#define CAN_ID_STD_SHIFT                         18
#define CAN_ID_STD_WIDTH                         11
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_ID_STD_SHIFT))&CAN_ID_STD_MASK)
#define CAN_ID_PRIO_MASK                         0xE0000000u
#define CAN_ID_PRIO_SHIFT                        29
#define CAN_ID_PRIO_WIDTH                        3
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_ID_PRIO_SHIFT))&CAN_ID_PRIO_MASK)
/* WORD0 Bit Fields */
#define CAN_WORD0_DATA_BYTE_3_MASK               0xFFu
#define CAN_WORD0_DATA_BYTE_3_SHIFT              0
#define CAN_WORD0_DATA_BYTE_3_WIDTH              8
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_3_SHIFT))&CAN_WORD0_DATA_BYTE_3_MASK)
#define CAN_WORD0_DATA_BYTE_2_MASK               0xFF00u
#define CAN_WORD0_DATA_BYTE_2_SHIFT              8
#define CAN_WORD0_DATA_BYTE_2_WIDTH              8
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_2_SHIFT))&CAN_WORD0_DATA_BYTE_2_MASK)
#define CAN_WORD0_DATA_BYTE_1_MASK               0xFF0000u
#define CAN_WORD0_DATA_BYTE_1_SHIFT              16
#define CAN_WORD0_DATA_BYTE_1_WIDTH              8
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_1_SHIFT))&CAN_WORD0_DATA_BYTE_1_MASK)
#define CAN_WORD0_DATA_BYTE_0_MASK               0xFF000000u
#define CAN_WORD0_DATA_BYTE_0_SHIFT              24
#define CAN_WORD0_DATA_BYTE_0_WIDTH              8
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_0_SHIFT))&CAN_WORD0_DATA_BYTE_0_MASK)
/* WORD1 Bit Fields */
#define CAN_WORD1_DATA_BYTE_7_MASK               0xFFu
#define CAN_WORD1_DATA_BYTE_7_SHIFT              0
#define CAN_WORD1_DATA_BYTE_7_WIDTH              8
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_7_SHIFT))&CAN_WORD1_DATA_BYTE_7_MASK)
#define CAN_WORD1_DATA_BYTE_6_MASK               0xFF00u
#define CAN_WORD1_DATA_BYTE_6_SHIFT              8
#define CAN_WORD1_DATA_BYTE_6_WIDTH              8
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_6_SHIFT))&CAN_WORD1_DATA_BYTE_6_MASK)
#define CAN_WORD1_DATA_BYTE_5_MASK               0xFF0000u
#define CAN_WORD1_DATA_BYTE_5_SHIFT              16
#define CAN_WORD1_DATA_BYTE_5_WIDTH              8
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_5_SHIFT))&CAN_WORD1_DATA_BYTE_5_MASK)
#define CAN_WORD1_DATA_BYTE_4_MASK               0xFF000000u
#define CAN_WORD1_DATA_BYTE_4_SHIFT              24
#define CAN_WORD1_DATA_BYTE_4_WIDTH              8
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_4_SHIFT))&CAN_WORD1_DATA_BYTE_4_MASK)
/* RXIMR Bit Fields */
#define CAN_RXIMR_MI_MASK                        0xFFFFFFFFu
#define CAN_RXIMR_MI_SHIFT                       0
#define CAN_RXIMR_MI_WIDTH                       32
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_RXIMR_MI_SHIFT))&CAN_RXIMR_MI_MASK)

/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
/** Peripheral CAN0 base address */
#define CAN0_BASE                                (0x40024000u)
/** Peripheral CAN0 base pointer */
#define CAN0                                     ((CAN_Type *)CAN0_BASE)
#define CAN0_BASE_PTR                            (CAN0)
/** Peripheral CAN1 base address */
#define CAN1_BASE                                (0x40025000u)
/** Peripheral CAN1 base pointer */
#define CAN1                                     ((CAN_Type *)CAN1_BASE)
#define CAN1_BASE_PTR                            (CAN1)
/** Peripheral CAN2 base address */
#define CAN2_BASE                                (0x400A4000u)
/** Peripheral CAN2 base pointer */
#define CAN2                                     ((CAN_Type *)CAN2_BASE)
#define CAN2_BASE_PTR                            (CAN2)
/** Array initializer of CAN peripheral base addresses */
#define CAN_BASE_ADDRS                           { CAN0_BASE, CAN1_BASE, CAN2_BASE }
/** Array initializer of CAN peripheral base pointers */
#define CAN_BASE_PTRS                            { CAN0, CAN1, CAN2 }

/* ----------------------------------------------------------------------------
   -- CAN - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Accessor_Macros CAN - Register accessor macros
 * @{
 */


/* CAN - Register instance definitions */
/* CAN0 */
#define CAN0_MCR                                 CAN_MCR_REG(CAN0)
#define CAN0_CTRL1                               CAN_CTRL1_REG(CAN0)
#define CAN0_TIMER                               CAN_TIMER_REG(CAN0)
#define CAN0_RXMGMASK                            CAN_RXMGMASK_REG(CAN0)
#define CAN0_RX14MASK                            CAN_RX14MASK_REG(CAN0)
#define CAN0_RX15MASK                            CAN_RX15MASK_REG(CAN0)
#define CAN0_ECR                                 CAN_ECR_REG(CAN0)
#define CAN0_ESR1                                CAN_ESR1_REG(CAN0)
#define CAN0_IMASK1                              CAN_IMASK1_REG(CAN0)
#define CAN0_IFLAG1                              CAN_IFLAG1_REG(CAN0)
#define CAN0_CTRL2                               CAN_CTRL2_REG(CAN0)
#define CAN0_ESR2                                CAN_ESR2_REG(CAN0)
#define CAN0_CRCR                                CAN_CRCR_REG(CAN0)
#define CAN0_RXFGMASK                            CAN_RXFGMASK_REG(CAN0)
#define CAN0_RXFIR                               CAN_RXFIR_REG(CAN0)
#define CAN0_CS0                                 CAN_CS_REG(CAN0,0)
#define CAN0_ID0                                 CAN_ID_REG(CAN0,0)
#define CAN0_WORD00                              CAN_WORD0_REG(CAN0,0)
#define CAN0_WORD10                              CAN_WORD1_REG(CAN0,0)
#define CAN0_CS1                                 CAN_CS_REG(CAN0,1)
#define CAN0_ID1                                 CAN_ID_REG(CAN0,1)
#define CAN0_WORD01                              CAN_WORD0_REG(CAN0,1)
#define CAN0_WORD11                              CAN_WORD1_REG(CAN0,1)
#define CAN0_CS2                                 CAN_CS_REG(CAN0,2)
#define CAN0_ID2                                 CAN_ID_REG(CAN0,2)
#define CAN0_WORD02                              CAN_WORD0_REG(CAN0,2)
#define CAN0_WORD12                              CAN_WORD1_REG(CAN0,2)
#define CAN0_CS3                                 CAN_CS_REG(CAN0,3)
#define CAN0_ID3                                 CAN_ID_REG(CAN0,3)
#define CAN0_WORD03                              CAN_WORD0_REG(CAN0,3)
#define CAN0_WORD13                              CAN_WORD1_REG(CAN0,3)
#define CAN0_CS4                                 CAN_CS_REG(CAN0,4)
#define CAN0_ID4                                 CAN_ID_REG(CAN0,4)
#define CAN0_WORD04                              CAN_WORD0_REG(CAN0,4)
#define CAN0_WORD14                              CAN_WORD1_REG(CAN0,4)
#define CAN0_CS5                                 CAN_CS_REG(CAN0,5)
#define CAN0_ID5                                 CAN_ID_REG(CAN0,5)
#define CAN0_WORD05                              CAN_WORD0_REG(CAN0,5)
#define CAN0_WORD15                              CAN_WORD1_REG(CAN0,5)
#define CAN0_CS6                                 CAN_CS_REG(CAN0,6)
#define CAN0_ID6                                 CAN_ID_REG(CAN0,6)
#define CAN0_WORD06                              CAN_WORD0_REG(CAN0,6)
#define CAN0_WORD16                              CAN_WORD1_REG(CAN0,6)
#define CAN0_CS7                                 CAN_CS_REG(CAN0,7)
#define CAN0_ID7                                 CAN_ID_REG(CAN0,7)
#define CAN0_WORD07                              CAN_WORD0_REG(CAN0,7)
#define CAN0_WORD17                              CAN_WORD1_REG(CAN0,7)
#define CAN0_CS8                                 CAN_CS_REG(CAN0,8)
#define CAN0_ID8                                 CAN_ID_REG(CAN0,8)
#define CAN0_WORD08                              CAN_WORD0_REG(CAN0,8)
#define CAN0_WORD18                              CAN_WORD1_REG(CAN0,8)
#define CAN0_CS9                                 CAN_CS_REG(CAN0,9)
#define CAN0_ID9                                 CAN_ID_REG(CAN0,9)
#define CAN0_WORD09                              CAN_WORD0_REG(CAN0,9)
#define CAN0_WORD19                              CAN_WORD1_REG(CAN0,9)
#define CAN0_CS10                                CAN_CS_REG(CAN0,10)
#define CAN0_ID10                                CAN_ID_REG(CAN0,10)
#define CAN0_WORD010                             CAN_WORD0_REG(CAN0,10)
#define CAN0_WORD110                             CAN_WORD1_REG(CAN0,10)
#define CAN0_CS11                                CAN_CS_REG(CAN0,11)
#define CAN0_ID11                                CAN_ID_REG(CAN0,11)
#define CAN0_WORD011                             CAN_WORD0_REG(CAN0,11)
#define CAN0_WORD111                             CAN_WORD1_REG(CAN0,11)
#define CAN0_CS12                                CAN_CS_REG(CAN0,12)
#define CAN0_ID12                                CAN_ID_REG(CAN0,12)
#define CAN0_WORD012                             CAN_WORD0_REG(CAN0,12)
#define CAN0_WORD112                             CAN_WORD1_REG(CAN0,12)
#define CAN0_CS13                                CAN_CS_REG(CAN0,13)
#define CAN0_ID13                                CAN_ID_REG(CAN0,13)
#define CAN0_WORD013                             CAN_WORD0_REG(CAN0,13)
#define CAN0_WORD113                             CAN_WORD1_REG(CAN0,13)
#define CAN0_CS14                                CAN_CS_REG(CAN0,14)
#define CAN0_ID14                                CAN_ID_REG(CAN0,14)
#define CAN0_WORD014                             CAN_WORD0_REG(CAN0,14)
#define CAN0_WORD114                             CAN_WORD1_REG(CAN0,14)
#define CAN0_CS15                                CAN_CS_REG(CAN0,15)
#define CAN0_ID15                                CAN_ID_REG(CAN0,15)
#define CAN0_WORD015                             CAN_WORD0_REG(CAN0,15)
#define CAN0_WORD115                             CAN_WORD1_REG(CAN0,15)
#define CAN0_RXIMR0                              CAN_RXIMR_REG(CAN0,0)
#define CAN0_RXIMR1                              CAN_RXIMR_REG(CAN0,1)
#define CAN0_RXIMR2                              CAN_RXIMR_REG(CAN0,2)
#define CAN0_RXIMR3                              CAN_RXIMR_REG(CAN0,3)
#define CAN0_RXIMR4                              CAN_RXIMR_REG(CAN0,4)
#define CAN0_RXIMR5                              CAN_RXIMR_REG(CAN0,5)
#define CAN0_RXIMR6                              CAN_RXIMR_REG(CAN0,6)
#define CAN0_RXIMR7                              CAN_RXIMR_REG(CAN0,7)
#define CAN0_RXIMR8                              CAN_RXIMR_REG(CAN0,8)
#define CAN0_RXIMR9                              CAN_RXIMR_REG(CAN0,9)
#define CAN0_RXIMR10                             CAN_RXIMR_REG(CAN0,10)
#define CAN0_RXIMR11                             CAN_RXIMR_REG(CAN0,11)
#define CAN0_RXIMR12                             CAN_RXIMR_REG(CAN0,12)
#define CAN0_RXIMR13                             CAN_RXIMR_REG(CAN0,13)
#define CAN0_RXIMR14                             CAN_RXIMR_REG(CAN0,14)
#define CAN0_RXIMR15                             CAN_RXIMR_REG(CAN0,15)
/* CAN1 */
#define CAN1_MCR                                 CAN_MCR_REG(CAN1)
#define CAN1_CTRL1                               CAN_CTRL1_REG(CAN1)
#define CAN1_TIMER                               CAN_TIMER_REG(CAN1)
#define CAN1_RXMGMASK                            CAN_RXMGMASK_REG(CAN1)
#define CAN1_RX14MASK                            CAN_RX14MASK_REG(CAN1)
#define CAN1_RX15MASK                            CAN_RX15MASK_REG(CAN1)
#define CAN1_ECR                                 CAN_ECR_REG(CAN1)
#define CAN1_ESR1                                CAN_ESR1_REG(CAN1)
#define CAN1_IMASK1                              CAN_IMASK1_REG(CAN1)
#define CAN1_IFLAG1                              CAN_IFLAG1_REG(CAN1)
#define CAN1_CTRL2                               CAN_CTRL2_REG(CAN1)
#define CAN1_ESR2                                CAN_ESR2_REG(CAN1)
#define CAN1_CRCR                                CAN_CRCR_REG(CAN1)
#define CAN1_RXFGMASK                            CAN_RXFGMASK_REG(CAN1)
#define CAN1_RXFIR                               CAN_RXFIR_REG(CAN1)
#define CAN1_CS0                                 CAN_CS_REG(CAN1,0)
#define CAN1_ID0                                 CAN_ID_REG(CAN1,0)
#define CAN1_WORD00                              CAN_WORD0_REG(CAN1,0)
#define CAN1_WORD10                              CAN_WORD1_REG(CAN1,0)
#define CAN1_CS1                                 CAN_CS_REG(CAN1,1)
#define CAN1_ID1                                 CAN_ID_REG(CAN1,1)
#define CAN1_WORD01                              CAN_WORD0_REG(CAN1,1)
#define CAN1_WORD11                              CAN_WORD1_REG(CAN1,1)
#define CAN1_CS2                                 CAN_CS_REG(CAN1,2)
#define CAN1_ID2                                 CAN_ID_REG(CAN1,2)
#define CAN1_WORD02                              CAN_WORD0_REG(CAN1,2)
#define CAN1_WORD12                              CAN_WORD1_REG(CAN1,2)
#define CAN1_CS3                                 CAN_CS_REG(CAN1,3)
#define CAN1_ID3                                 CAN_ID_REG(CAN1,3)
#define CAN1_WORD03                              CAN_WORD0_REG(CAN1,3)
#define CAN1_WORD13                              CAN_WORD1_REG(CAN1,3)
#define CAN1_CS4                                 CAN_CS_REG(CAN1,4)
#define CAN1_ID4                                 CAN_ID_REG(CAN1,4)
#define CAN1_WORD04                              CAN_WORD0_REG(CAN1,4)
#define CAN1_WORD14                              CAN_WORD1_REG(CAN1,4)
#define CAN1_CS5                                 CAN_CS_REG(CAN1,5)
#define CAN1_ID5                                 CAN_ID_REG(CAN1,5)
#define CAN1_WORD05                              CAN_WORD0_REG(CAN1,5)
#define CAN1_WORD15                              CAN_WORD1_REG(CAN1,5)
#define CAN1_CS6                                 CAN_CS_REG(CAN1,6)
#define CAN1_ID6                                 CAN_ID_REG(CAN1,6)
#define CAN1_WORD06                              CAN_WORD0_REG(CAN1,6)
#define CAN1_WORD16                              CAN_WORD1_REG(CAN1,6)
#define CAN1_CS7                                 CAN_CS_REG(CAN1,7)
#define CAN1_ID7                                 CAN_ID_REG(CAN1,7)
#define CAN1_WORD07                              CAN_WORD0_REG(CAN1,7)
#define CAN1_WORD17                              CAN_WORD1_REG(CAN1,7)
#define CAN1_CS8                                 CAN_CS_REG(CAN1,8)
#define CAN1_ID8                                 CAN_ID_REG(CAN1,8)
#define CAN1_WORD08                              CAN_WORD0_REG(CAN1,8)
#define CAN1_WORD18                              CAN_WORD1_REG(CAN1,8)
#define CAN1_CS9                                 CAN_CS_REG(CAN1,9)
#define CAN1_ID9                                 CAN_ID_REG(CAN1,9)
#define CAN1_WORD09                              CAN_WORD0_REG(CAN1,9)
#define CAN1_WORD19                              CAN_WORD1_REG(CAN1,9)
#define CAN1_CS10                                CAN_CS_REG(CAN1,10)
#define CAN1_ID10                                CAN_ID_REG(CAN1,10)
#define CAN1_WORD010                             CAN_WORD0_REG(CAN1,10)
#define CAN1_WORD110                             CAN_WORD1_REG(CAN1,10)
#define CAN1_CS11                                CAN_CS_REG(CAN1,11)
#define CAN1_ID11                                CAN_ID_REG(CAN1,11)
#define CAN1_WORD011                             CAN_WORD0_REG(CAN1,11)
#define CAN1_WORD111                             CAN_WORD1_REG(CAN1,11)
#define CAN1_CS12                                CAN_CS_REG(CAN1,12)
#define CAN1_ID12                                CAN_ID_REG(CAN1,12)
#define CAN1_WORD012                             CAN_WORD0_REG(CAN1,12)
#define CAN1_WORD112                             CAN_WORD1_REG(CAN1,12)
#define CAN1_CS13                                CAN_CS_REG(CAN1,13)
#define CAN1_ID13                                CAN_ID_REG(CAN1,13)
#define CAN1_WORD013                             CAN_WORD0_REG(CAN1,13)
#define CAN1_WORD113                             CAN_WORD1_REG(CAN1,13)
#define CAN1_CS14                                CAN_CS_REG(CAN1,14)
#define CAN1_ID14                                CAN_ID_REG(CAN1,14)
#define CAN1_WORD014                             CAN_WORD0_REG(CAN1,14)
#define CAN1_WORD114                             CAN_WORD1_REG(CAN1,14)
#define CAN1_CS15                                CAN_CS_REG(CAN1,15)
#define CAN1_ID15                                CAN_ID_REG(CAN1,15)
#define CAN1_WORD015                             CAN_WORD0_REG(CAN1,15)
#define CAN1_WORD115                             CAN_WORD1_REG(CAN1,15)
#define CAN1_RXIMR0                              CAN_RXIMR_REG(CAN1,0)
#define CAN1_RXIMR1                              CAN_RXIMR_REG(CAN1,1)
#define CAN1_RXIMR2                              CAN_RXIMR_REG(CAN1,2)
#define CAN1_RXIMR3                              CAN_RXIMR_REG(CAN1,3)
#define CAN1_RXIMR4                              CAN_RXIMR_REG(CAN1,4)
#define CAN1_RXIMR5                              CAN_RXIMR_REG(CAN1,5)
#define CAN1_RXIMR6                              CAN_RXIMR_REG(CAN1,6)
#define CAN1_RXIMR7                              CAN_RXIMR_REG(CAN1,7)
#define CAN1_RXIMR8                              CAN_RXIMR_REG(CAN1,8)
#define CAN1_RXIMR9                              CAN_RXIMR_REG(CAN1,9)
#define CAN1_RXIMR10                             CAN_RXIMR_REG(CAN1,10)
#define CAN1_RXIMR11                             CAN_RXIMR_REG(CAN1,11)
#define CAN1_RXIMR12                             CAN_RXIMR_REG(CAN1,12)
#define CAN1_RXIMR13                             CAN_RXIMR_REG(CAN1,13)
#define CAN1_RXIMR14                             CAN_RXIMR_REG(CAN1,14)
#define CAN1_RXIMR15                             CAN_RXIMR_REG(CAN1,15)
/* CAN2 */
#define CAN2_MCR                                 CAN_MCR_REG(CAN2)
#define CAN2_CTRL1                               CAN_CTRL1_REG(CAN2)
#define CAN2_TIMER                               CAN_TIMER_REG(CAN2)
#define CAN2_RXMGMASK                            CAN_RXMGMASK_REG(CAN2)
#define CAN2_RX14MASK                            CAN_RX14MASK_REG(CAN2)
#define CAN2_RX15MASK                            CAN_RX15MASK_REG(CAN2)
#define CAN2_ECR                                 CAN_ECR_REG(CAN2)
#define CAN2_ESR1                                CAN_ESR1_REG(CAN2)
#define CAN2_IMASK1                              CAN_IMASK1_REG(CAN2)
#define CAN2_IFLAG1                              CAN_IFLAG1_REG(CAN2)
#define CAN2_CTRL2                               CAN_CTRL2_REG(CAN2)
#define CAN2_ESR2                                CAN_ESR2_REG(CAN2)
#define CAN2_CRCR                                CAN_CRCR_REG(CAN2)
#define CAN2_RXFGMASK                            CAN_RXFGMASK_REG(CAN2)
#define CAN2_RXFIR                               CAN_RXFIR_REG(CAN2)
#define CAN2_CS0                                 CAN_CS_REG(CAN2,0)
#define CAN2_ID0                                 CAN_ID_REG(CAN2,0)
#define CAN2_WORD00                              CAN_WORD0_REG(CAN2,0)
#define CAN2_WORD10                              CAN_WORD1_REG(CAN2,0)
#define CAN2_CS1                                 CAN_CS_REG(CAN2,1)
#define CAN2_ID1                                 CAN_ID_REG(CAN2,1)
#define CAN2_WORD01                              CAN_WORD0_REG(CAN2,1)
#define CAN2_WORD11                              CAN_WORD1_REG(CAN2,1)
#define CAN2_CS2                                 CAN_CS_REG(CAN2,2)
#define CAN2_ID2                                 CAN_ID_REG(CAN2,2)
#define CAN2_WORD02                              CAN_WORD0_REG(CAN2,2)
#define CAN2_WORD12                              CAN_WORD1_REG(CAN2,2)
#define CAN2_CS3                                 CAN_CS_REG(CAN2,3)
#define CAN2_ID3                                 CAN_ID_REG(CAN2,3)
#define CAN2_WORD03                              CAN_WORD0_REG(CAN2,3)
#define CAN2_WORD13                              CAN_WORD1_REG(CAN2,3)
#define CAN2_CS4                                 CAN_CS_REG(CAN2,4)
#define CAN2_ID4                                 CAN_ID_REG(CAN2,4)
#define CAN2_WORD04                              CAN_WORD0_REG(CAN2,4)
#define CAN2_WORD14                              CAN_WORD1_REG(CAN2,4)
#define CAN2_CS5                                 CAN_CS_REG(CAN2,5)
#define CAN2_ID5                                 CAN_ID_REG(CAN2,5)
#define CAN2_WORD05                              CAN_WORD0_REG(CAN2,5)
#define CAN2_WORD15                              CAN_WORD1_REG(CAN2,5)
#define CAN2_CS6                                 CAN_CS_REG(CAN2,6)
#define CAN2_ID6                                 CAN_ID_REG(CAN2,6)
#define CAN2_WORD06                              CAN_WORD0_REG(CAN2,6)
#define CAN2_WORD16                              CAN_WORD1_REG(CAN2,6)
#define CAN2_CS7                                 CAN_CS_REG(CAN2,7)
#define CAN2_ID7                                 CAN_ID_REG(CAN2,7)
#define CAN2_WORD07                              CAN_WORD0_REG(CAN2,7)
#define CAN2_WORD17                              CAN_WORD1_REG(CAN2,7)
#define CAN2_CS8                                 CAN_CS_REG(CAN2,8)
#define CAN2_ID8                                 CAN_ID_REG(CAN2,8)
#define CAN2_WORD08                              CAN_WORD0_REG(CAN2,8)
#define CAN2_WORD18                              CAN_WORD1_REG(CAN2,8)
#define CAN2_CS9                                 CAN_CS_REG(CAN2,9)
#define CAN2_ID9                                 CAN_ID_REG(CAN2,9)
#define CAN2_WORD09                              CAN_WORD0_REG(CAN2,9)
#define CAN2_WORD19                              CAN_WORD1_REG(CAN2,9)
#define CAN2_CS10                                CAN_CS_REG(CAN2,10)
#define CAN2_ID10                                CAN_ID_REG(CAN2,10)
#define CAN2_WORD010                             CAN_WORD0_REG(CAN2,10)
#define CAN2_WORD110                             CAN_WORD1_REG(CAN2,10)
#define CAN2_CS11                                CAN_CS_REG(CAN2,11)
#define CAN2_ID11                                CAN_ID_REG(CAN2,11)
#define CAN2_WORD011                             CAN_WORD0_REG(CAN2,11)
#define CAN2_WORD111                             CAN_WORD1_REG(CAN2,11)
#define CAN2_CS12                                CAN_CS_REG(CAN2,12)
#define CAN2_ID12                                CAN_ID_REG(CAN2,12)
#define CAN2_WORD012                             CAN_WORD0_REG(CAN2,12)
#define CAN2_WORD112                             CAN_WORD1_REG(CAN2,12)
#define CAN2_CS13                                CAN_CS_REG(CAN2,13)
#define CAN2_ID13                                CAN_ID_REG(CAN2,13)
#define CAN2_WORD013                             CAN_WORD0_REG(CAN2,13)
#define CAN2_WORD113                             CAN_WORD1_REG(CAN2,13)
#define CAN2_CS14                                CAN_CS_REG(CAN2,14)
#define CAN2_ID14                                CAN_ID_REG(CAN2,14)
#define CAN2_WORD014                             CAN_WORD0_REG(CAN2,14)
#define CAN2_WORD114                             CAN_WORD1_REG(CAN2,14)
#define CAN2_CS15                                CAN_CS_REG(CAN2,15)
#define CAN2_ID15                                CAN_ID_REG(CAN2,15)
#define CAN2_WORD015                             CAN_WORD0_REG(CAN2,15)
#define CAN2_WORD115                             CAN_WORD1_REG(CAN2,15)
#define CAN2_RXIMR0                              CAN_RXIMR_REG(CAN2,0)
#define CAN2_RXIMR1                              CAN_RXIMR_REG(CAN2,1)
#define CAN2_RXIMR2                              CAN_RXIMR_REG(CAN2,2)
#define CAN2_RXIMR3                              CAN_RXIMR_REG(CAN2,3)
#define CAN2_RXIMR4                              CAN_RXIMR_REG(CAN2,4)
#define CAN2_RXIMR5                              CAN_RXIMR_REG(CAN2,5)
#define CAN2_RXIMR6                              CAN_RXIMR_REG(CAN2,6)
#define CAN2_RXIMR7                              CAN_RXIMR_REG(CAN2,7)
#define CAN2_RXIMR8                              CAN_RXIMR_REG(CAN2,8)
#define CAN2_RXIMR9                              CAN_RXIMR_REG(CAN2,9)
#define CAN2_RXIMR10                             CAN_RXIMR_REG(CAN2,10)
#define CAN2_RXIMR11                             CAN_RXIMR_REG(CAN2,11)
#define CAN2_RXIMR12                             CAN_RXIMR_REG(CAN2,12)
#define CAN2_RXIMR13                             CAN_RXIMR_REG(CAN2,13)
#define CAN2_RXIMR14                             CAN_RXIMR_REG(CAN2,14)
#define CAN2_RXIMR15                             CAN_RXIMR_REG(CAN2,15)

/* CAN - Register array accessors */
#define CAN0_CS(index)                           CAN_CS_REG(CAN0,index)
#define CAN1_CS(index)                           CAN_CS_REG(CAN1,index)
#define CAN2_CS(index)                           CAN_CS_REG(CAN2,index)
#define CAN0_ID(index)                           CAN_ID_REG(CAN0,index)
#define CAN1_ID(index)                           CAN_ID_REG(CAN1,index)
#define CAN2_ID(index)                           CAN_ID_REG(CAN2,index)
#define CAN0_WORD0(index)                        CAN_WORD0_REG(CAN0,index)
#define CAN1_WORD0(index)                        CAN_WORD0_REG(CAN1,index)
#define CAN2_WORD0(index)                        CAN_WORD0_REG(CAN2,index)
#define CAN0_WORD1(index)                        CAN_WORD1_REG(CAN0,index)
#define CAN1_WORD1(index)                        CAN_WORD1_REG(CAN1,index)
#define CAN2_WORD1(index)                        CAN_WORD1_REG(CAN2,index)
#define CAN0_RXIMR(index)                        CAN_RXIMR_REG(CAN0,index)
#define CAN1_RXIMR(index)                        CAN_RXIMR_REG(CAN1,index)
#define CAN2_RXIMR(index)                        CAN_RXIMR_REG(CAN2,index)

/*!
 * @}
 */ /* end of group CAN_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAU_Peripheral_Access_Layer CAU Peripheral Access Layer
 * @{
 */

/** CAU - Register Layout Typedef */
typedef struct {
  __O  uint32_t DIRECT[16];                        /**< Direct access register 0..Direct access register 15, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[2048];
  __O  uint32_t LDR_CASR;                          /**< Status register - Load Register command, offset: 0x840 */
  __O  uint32_t LDR_CAA;                           /**< Accumulator register - Load Register command, offset: 0x844 */
  __O  uint32_t LDR_CA[9];                         /**< General Purpose Register 0 - Load Register command..General Purpose Register 8 - Load Register command, array offset: 0x848, array step: 0x4 */
       uint8_t RESERVED_1[20];
  __I  uint32_t STR_CASR;                          /**< Status register - Store Register command, offset: 0x880 */
  __I  uint32_t STR_CAA;                           /**< Accumulator register - Store Register command, offset: 0x884 */
  __I  uint32_t STR_CA[9];                         /**< General Purpose Register 0 - Store Register command..General Purpose Register 8 - Store Register command, array offset: 0x888, array step: 0x4 */
       uint8_t RESERVED_2[20];
  __O  uint32_t ADR_CASR;                          /**< Status register - Add Register command, offset: 0x8C0 */
  __O  uint32_t ADR_CAA;                           /**< Accumulator register - Add to register command, offset: 0x8C4 */
  __O  uint32_t ADR_CA[9];                         /**< General Purpose Register 0 - Add to register command..General Purpose Register 8 - Add to register command, array offset: 0x8C8, array step: 0x4 */
       uint8_t RESERVED_3[20];
  __O  uint32_t RADR_CASR;                         /**< Status register - Reverse and Add to Register command, offset: 0x900 */
  __O  uint32_t RADR_CAA;                          /**< Accumulator register - Reverse and Add to Register command, offset: 0x904 */
  __O  uint32_t RADR_CA[9];                        /**< General Purpose Register 0 - Reverse and Add to Register command..General Purpose Register 8 - Reverse and Add to Register command, array offset: 0x908, array step: 0x4 */
       uint8_t RESERVED_4[84];
  __O  uint32_t XOR_CASR;                          /**< Status register - Exclusive Or command, offset: 0x980 */
  __O  uint32_t XOR_CAA;                           /**< Accumulator register - Exclusive Or command, offset: 0x984 */
  __O  uint32_t XOR_CA[9];                         /**< General Purpose Register 0 - Exclusive Or command..General Purpose Register 8 - Exclusive Or command, array offset: 0x988, array step: 0x4 */
       uint8_t RESERVED_5[20];
  __O  uint32_t ROTL_CASR;                         /**< Status register - Rotate Left command, offset: 0x9C0 */
  __O  uint32_t ROTL_CAA;                          /**< Accumulator register - Rotate Left command, offset: 0x9C4 */
  __O  uint32_t ROTL_CA[9];                        /**< General Purpose Register 0 - Rotate Left command..General Purpose Register 8 - Rotate Left command, array offset: 0x9C8, array step: 0x4 */
       uint8_t RESERVED_6[276];
  __O  uint32_t AESC_CASR;                         /**< Status register - AES Column Operation command, offset: 0xB00 */
  __O  uint32_t AESC_CAA;                          /**< Accumulator register - AES Column Operation command, offset: 0xB04 */
  __O  uint32_t AESC_CA[9];                        /**< General Purpose Register 0 - AES Column Operation command..General Purpose Register 8 - AES Column Operation command, array offset: 0xB08, array step: 0x4 */
       uint8_t RESERVED_7[20];
  __O  uint32_t AESIC_CASR;                        /**< Status register - AES Inverse Column Operation command, offset: 0xB40 */
  __O  uint32_t AESIC_CAA;                         /**< Accumulator register - AES Inverse Column Operation command, offset: 0xB44 */
  __O  uint32_t AESIC_CA[9];                       /**< General Purpose Register 0 - AES Inverse Column Operation command..General Purpose Register 8 - AES Inverse Column Operation command, array offset: 0xB48, array step: 0x4 */
} CAU_Type, *CAU_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CAU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAU_Register_Accessor_Macros CAU - Register accessor macros
 * @{
 */


/* CAU - Register accessors */
#define CAU_DIRECT_REG(base,index)               ((base)->DIRECT[index])
#define CAU_DIRECT_COUNT                         16
#define CAU_LDR_CASR_REG(base)                   ((base)->LDR_CASR)
#define CAU_LDR_CAA_REG(base)                    ((base)->LDR_CAA)
#define CAU_LDR_CA_REG(base,index)               ((base)->LDR_CA[index])
#define CAU_LDR_CA_COUNT                         9
#define CAU_STR_CASR_REG(base)                   ((base)->STR_CASR)
#define CAU_STR_CAA_REG(base)                    ((base)->STR_CAA)
#define CAU_STR_CA_REG(base,index)               ((base)->STR_CA[index])
#define CAU_STR_CA_COUNT                         9
#define CAU_ADR_CASR_REG(base)                   ((base)->ADR_CASR)
#define CAU_ADR_CAA_REG(base)                    ((base)->ADR_CAA)
#define CAU_ADR_CA_REG(base,index)               ((base)->ADR_CA[index])
#define CAU_ADR_CA_COUNT                         9
#define CAU_RADR_CASR_REG(base)                  ((base)->RADR_CASR)
#define CAU_RADR_CAA_REG(base)                   ((base)->RADR_CAA)
#define CAU_RADR_CA_REG(base,index)              ((base)->RADR_CA[index])
#define CAU_RADR_CA_COUNT                        9
#define CAU_XOR_CASR_REG(base)                   ((base)->XOR_CASR)
#define CAU_XOR_CAA_REG(base)                    ((base)->XOR_CAA)
#define CAU_XOR_CA_REG(base,index)               ((base)->XOR_CA[index])
#define CAU_XOR_CA_COUNT                         9
#define CAU_ROTL_CASR_REG(base)                  ((base)->ROTL_CASR)
#define CAU_ROTL_CAA_REG(base)                   ((base)->ROTL_CAA)
#define CAU_ROTL_CA_REG(base,index)              ((base)->ROTL_CA[index])
#define CAU_ROTL_CA_COUNT                        9
#define CAU_AESC_CASR_REG(base)                  ((base)->AESC_CASR)
#define CAU_AESC_CAA_REG(base)                   ((base)->AESC_CAA)
#define CAU_AESC_CA_REG(base,index)              ((base)->AESC_CA[index])
#define CAU_AESC_CA_COUNT                        9
#define CAU_AESIC_CASR_REG(base)                 ((base)->AESIC_CASR)
#define CAU_AESIC_CAA_REG(base)                  ((base)->AESIC_CAA)
#define CAU_AESIC_CA_REG(base,index)             ((base)->AESIC_CA[index])
#define CAU_AESIC_CA_COUNT                       9

/*!
 * @}
 */ /* end of group CAU_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CAU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAU_Register_Masks CAU Register Masks
 * @{
 */

/* DIRECT Bit Fields */
#define CAU_DIRECT_CAU_DIRECT0_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT0_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT0_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT0(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT0_SHIFT))&CAU_DIRECT_CAU_DIRECT0_MASK)
#define CAU_DIRECT_CAU_DIRECT1_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT1_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT1_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT1(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT1_SHIFT))&CAU_DIRECT_CAU_DIRECT1_MASK)
#define CAU_DIRECT_CAU_DIRECT2_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT2_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT2_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT2(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT2_SHIFT))&CAU_DIRECT_CAU_DIRECT2_MASK)
#define CAU_DIRECT_CAU_DIRECT3_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT3_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT3_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT3(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT3_SHIFT))&CAU_DIRECT_CAU_DIRECT3_MASK)
#define CAU_DIRECT_CAU_DIRECT4_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT4_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT4_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT4(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT4_SHIFT))&CAU_DIRECT_CAU_DIRECT4_MASK)
#define CAU_DIRECT_CAU_DIRECT5_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT5_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT5_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT5(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT5_SHIFT))&CAU_DIRECT_CAU_DIRECT5_MASK)
#define CAU_DIRECT_CAU_DIRECT6_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT6_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT6_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT6(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT6_SHIFT))&CAU_DIRECT_CAU_DIRECT6_MASK)
#define CAU_DIRECT_CAU_DIRECT7_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT7_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT7_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT7(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT7_SHIFT))&CAU_DIRECT_CAU_DIRECT7_MASK)
#define CAU_DIRECT_CAU_DIRECT8_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT8_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT8_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT8(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT8_SHIFT))&CAU_DIRECT_CAU_DIRECT8_MASK)
#define CAU_DIRECT_CAU_DIRECT9_MASK              0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT9_SHIFT             0
#define CAU_DIRECT_CAU_DIRECT9_WIDTH             32
#define CAU_DIRECT_CAU_DIRECT9(x)                (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT9_SHIFT))&CAU_DIRECT_CAU_DIRECT9_MASK)
#define CAU_DIRECT_CAU_DIRECT10_MASK             0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT10_SHIFT            0
#define CAU_DIRECT_CAU_DIRECT10_WIDTH            32
#define CAU_DIRECT_CAU_DIRECT10(x)               (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT10_SHIFT))&CAU_DIRECT_CAU_DIRECT10_MASK)
#define CAU_DIRECT_CAU_DIRECT11_MASK             0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT11_SHIFT            0
#define CAU_DIRECT_CAU_DIRECT11_WIDTH            32
#define CAU_DIRECT_CAU_DIRECT11(x)               (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT11_SHIFT))&CAU_DIRECT_CAU_DIRECT11_MASK)
#define CAU_DIRECT_CAU_DIRECT12_MASK             0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT12_SHIFT            0
#define CAU_DIRECT_CAU_DIRECT12_WIDTH            32
#define CAU_DIRECT_CAU_DIRECT12(x)               (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT12_SHIFT))&CAU_DIRECT_CAU_DIRECT12_MASK)
#define CAU_DIRECT_CAU_DIRECT13_MASK             0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT13_SHIFT            0
#define CAU_DIRECT_CAU_DIRECT13_WIDTH            32
#define CAU_DIRECT_CAU_DIRECT13(x)               (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT13_SHIFT))&CAU_DIRECT_CAU_DIRECT13_MASK)
#define CAU_DIRECT_CAU_DIRECT14_MASK             0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT14_SHIFT            0
#define CAU_DIRECT_CAU_DIRECT14_WIDTH            32
#define CAU_DIRECT_CAU_DIRECT14(x)               (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT14_SHIFT))&CAU_DIRECT_CAU_DIRECT14_MASK)
#define CAU_DIRECT_CAU_DIRECT15_MASK             0xFFFFFFFFu
#define CAU_DIRECT_CAU_DIRECT15_SHIFT            0
#define CAU_DIRECT_CAU_DIRECT15_WIDTH            32
#define CAU_DIRECT_CAU_DIRECT15(x)               (((uint32_t)(((uint32_t)(x))<<CAU_DIRECT_CAU_DIRECT15_SHIFT))&CAU_DIRECT_CAU_DIRECT15_MASK)
/* LDR_CASR Bit Fields */
#define CAU_LDR_CASR_IC_MASK                     0x1u
#define CAU_LDR_CASR_IC_SHIFT                    0
#define CAU_LDR_CASR_IC_WIDTH                    1
#define CAU_LDR_CASR_IC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CASR_IC_SHIFT))&CAU_LDR_CASR_IC_MASK)
#define CAU_LDR_CASR_DPE_MASK                    0x2u
#define CAU_LDR_CASR_DPE_SHIFT                   1
#define CAU_LDR_CASR_DPE_WIDTH                   1
#define CAU_LDR_CASR_DPE(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CASR_DPE_SHIFT))&CAU_LDR_CASR_DPE_MASK)
#define CAU_LDR_CASR_VER_MASK                    0xF0000000u
#define CAU_LDR_CASR_VER_SHIFT                   28
#define CAU_LDR_CASR_VER_WIDTH                   4
#define CAU_LDR_CASR_VER(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CASR_VER_SHIFT))&CAU_LDR_CASR_VER_MASK)
/* LDR_CAA Bit Fields */
#define CAU_LDR_CAA_ACC_MASK                     0xFFFFFFFFu
#define CAU_LDR_CAA_ACC_SHIFT                    0
#define CAU_LDR_CAA_ACC_WIDTH                    32
#define CAU_LDR_CAA_ACC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CAA_ACC_SHIFT))&CAU_LDR_CAA_ACC_MASK)
/* LDR_CA Bit Fields */
#define CAU_LDR_CA_CA0_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA0_SHIFT                     0
#define CAU_LDR_CA_CA0_WIDTH                     32
#define CAU_LDR_CA_CA0(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA0_SHIFT))&CAU_LDR_CA_CA0_MASK)
#define CAU_LDR_CA_CA1_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA1_SHIFT                     0
#define CAU_LDR_CA_CA1_WIDTH                     32
#define CAU_LDR_CA_CA1(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA1_SHIFT))&CAU_LDR_CA_CA1_MASK)
#define CAU_LDR_CA_CA2_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA2_SHIFT                     0
#define CAU_LDR_CA_CA2_WIDTH                     32
#define CAU_LDR_CA_CA2(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA2_SHIFT))&CAU_LDR_CA_CA2_MASK)
#define CAU_LDR_CA_CA3_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA3_SHIFT                     0
#define CAU_LDR_CA_CA3_WIDTH                     32
#define CAU_LDR_CA_CA3(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA3_SHIFT))&CAU_LDR_CA_CA3_MASK)
#define CAU_LDR_CA_CA4_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA4_SHIFT                     0
#define CAU_LDR_CA_CA4_WIDTH                     32
#define CAU_LDR_CA_CA4(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA4_SHIFT))&CAU_LDR_CA_CA4_MASK)
#define CAU_LDR_CA_CA5_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA5_SHIFT                     0
#define CAU_LDR_CA_CA5_WIDTH                     32
#define CAU_LDR_CA_CA5(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA5_SHIFT))&CAU_LDR_CA_CA5_MASK)
#define CAU_LDR_CA_CA6_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA6_SHIFT                     0
#define CAU_LDR_CA_CA6_WIDTH                     32
#define CAU_LDR_CA_CA6(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA6_SHIFT))&CAU_LDR_CA_CA6_MASK)
#define CAU_LDR_CA_CA7_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA7_SHIFT                     0
#define CAU_LDR_CA_CA7_WIDTH                     32
#define CAU_LDR_CA_CA7(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA7_SHIFT))&CAU_LDR_CA_CA7_MASK)
#define CAU_LDR_CA_CA8_MASK                      0xFFFFFFFFu
#define CAU_LDR_CA_CA8_SHIFT                     0
#define CAU_LDR_CA_CA8_WIDTH                     32
#define CAU_LDR_CA_CA8(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_LDR_CA_CA8_SHIFT))&CAU_LDR_CA_CA8_MASK)
/* STR_CASR Bit Fields */
#define CAU_STR_CASR_IC_MASK                     0x1u
#define CAU_STR_CASR_IC_SHIFT                    0
#define CAU_STR_CASR_IC_WIDTH                    1
#define CAU_STR_CASR_IC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_STR_CASR_IC_SHIFT))&CAU_STR_CASR_IC_MASK)
#define CAU_STR_CASR_DPE_MASK                    0x2u
#define CAU_STR_CASR_DPE_SHIFT                   1
#define CAU_STR_CASR_DPE_WIDTH                   1
#define CAU_STR_CASR_DPE(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_STR_CASR_DPE_SHIFT))&CAU_STR_CASR_DPE_MASK)
#define CAU_STR_CASR_VER_MASK                    0xF0000000u
#define CAU_STR_CASR_VER_SHIFT                   28
#define CAU_STR_CASR_VER_WIDTH                   4
#define CAU_STR_CASR_VER(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_STR_CASR_VER_SHIFT))&CAU_STR_CASR_VER_MASK)
/* STR_CAA Bit Fields */
#define CAU_STR_CAA_ACC_MASK                     0xFFFFFFFFu
#define CAU_STR_CAA_ACC_SHIFT                    0
#define CAU_STR_CAA_ACC_WIDTH                    32
#define CAU_STR_CAA_ACC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_STR_CAA_ACC_SHIFT))&CAU_STR_CAA_ACC_MASK)
/* STR_CA Bit Fields */
#define CAU_STR_CA_CA0_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA0_SHIFT                     0
#define CAU_STR_CA_CA0_WIDTH                     32
#define CAU_STR_CA_CA0(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA0_SHIFT))&CAU_STR_CA_CA0_MASK)
#define CAU_STR_CA_CA1_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA1_SHIFT                     0
#define CAU_STR_CA_CA1_WIDTH                     32
#define CAU_STR_CA_CA1(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA1_SHIFT))&CAU_STR_CA_CA1_MASK)
#define CAU_STR_CA_CA2_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA2_SHIFT                     0
#define CAU_STR_CA_CA2_WIDTH                     32
#define CAU_STR_CA_CA2(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA2_SHIFT))&CAU_STR_CA_CA2_MASK)
#define CAU_STR_CA_CA3_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA3_SHIFT                     0
#define CAU_STR_CA_CA3_WIDTH                     32
#define CAU_STR_CA_CA3(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA3_SHIFT))&CAU_STR_CA_CA3_MASK)
#define CAU_STR_CA_CA4_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA4_SHIFT                     0
#define CAU_STR_CA_CA4_WIDTH                     32
#define CAU_STR_CA_CA4(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA4_SHIFT))&CAU_STR_CA_CA4_MASK)
#define CAU_STR_CA_CA5_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA5_SHIFT                     0
#define CAU_STR_CA_CA5_WIDTH                     32
#define CAU_STR_CA_CA5(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA5_SHIFT))&CAU_STR_CA_CA5_MASK)
#define CAU_STR_CA_CA6_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA6_SHIFT                     0
#define CAU_STR_CA_CA6_WIDTH                     32
#define CAU_STR_CA_CA6(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA6_SHIFT))&CAU_STR_CA_CA6_MASK)
#define CAU_STR_CA_CA7_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA7_SHIFT                     0
#define CAU_STR_CA_CA7_WIDTH                     32
#define CAU_STR_CA_CA7(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA7_SHIFT))&CAU_STR_CA_CA7_MASK)
#define CAU_STR_CA_CA8_MASK                      0xFFFFFFFFu
#define CAU_STR_CA_CA8_SHIFT                     0
#define CAU_STR_CA_CA8_WIDTH                     32
#define CAU_STR_CA_CA8(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_STR_CA_CA8_SHIFT))&CAU_STR_CA_CA8_MASK)
/* ADR_CASR Bit Fields */
#define CAU_ADR_CASR_IC_MASK                     0x1u
#define CAU_ADR_CASR_IC_SHIFT                    0
#define CAU_ADR_CASR_IC_WIDTH                    1
#define CAU_ADR_CASR_IC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CASR_IC_SHIFT))&CAU_ADR_CASR_IC_MASK)
#define CAU_ADR_CASR_DPE_MASK                    0x2u
#define CAU_ADR_CASR_DPE_SHIFT                   1
#define CAU_ADR_CASR_DPE_WIDTH                   1
#define CAU_ADR_CASR_DPE(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CASR_DPE_SHIFT))&CAU_ADR_CASR_DPE_MASK)
#define CAU_ADR_CASR_VER_MASK                    0xF0000000u
#define CAU_ADR_CASR_VER_SHIFT                   28
#define CAU_ADR_CASR_VER_WIDTH                   4
#define CAU_ADR_CASR_VER(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CASR_VER_SHIFT))&CAU_ADR_CASR_VER_MASK)
/* ADR_CAA Bit Fields */
#define CAU_ADR_CAA_ACC_MASK                     0xFFFFFFFFu
#define CAU_ADR_CAA_ACC_SHIFT                    0
#define CAU_ADR_CAA_ACC_WIDTH                    32
#define CAU_ADR_CAA_ACC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CAA_ACC_SHIFT))&CAU_ADR_CAA_ACC_MASK)
/* ADR_CA Bit Fields */
#define CAU_ADR_CA_CA0_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA0_SHIFT                     0
#define CAU_ADR_CA_CA0_WIDTH                     32
#define CAU_ADR_CA_CA0(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA0_SHIFT))&CAU_ADR_CA_CA0_MASK)
#define CAU_ADR_CA_CA1_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA1_SHIFT                     0
#define CAU_ADR_CA_CA1_WIDTH                     32
#define CAU_ADR_CA_CA1(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA1_SHIFT))&CAU_ADR_CA_CA1_MASK)
#define CAU_ADR_CA_CA2_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA2_SHIFT                     0
#define CAU_ADR_CA_CA2_WIDTH                     32
#define CAU_ADR_CA_CA2(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA2_SHIFT))&CAU_ADR_CA_CA2_MASK)
#define CAU_ADR_CA_CA3_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA3_SHIFT                     0
#define CAU_ADR_CA_CA3_WIDTH                     32
#define CAU_ADR_CA_CA3(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA3_SHIFT))&CAU_ADR_CA_CA3_MASK)
#define CAU_ADR_CA_CA4_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA4_SHIFT                     0
#define CAU_ADR_CA_CA4_WIDTH                     32
#define CAU_ADR_CA_CA4(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA4_SHIFT))&CAU_ADR_CA_CA4_MASK)
#define CAU_ADR_CA_CA5_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA5_SHIFT                     0
#define CAU_ADR_CA_CA5_WIDTH                     32
#define CAU_ADR_CA_CA5(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA5_SHIFT))&CAU_ADR_CA_CA5_MASK)
#define CAU_ADR_CA_CA6_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA6_SHIFT                     0
#define CAU_ADR_CA_CA6_WIDTH                     32
#define CAU_ADR_CA_CA6(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA6_SHIFT))&CAU_ADR_CA_CA6_MASK)
#define CAU_ADR_CA_CA7_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA7_SHIFT                     0
#define CAU_ADR_CA_CA7_WIDTH                     32
#define CAU_ADR_CA_CA7(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA7_SHIFT))&CAU_ADR_CA_CA7_MASK)
#define CAU_ADR_CA_CA8_MASK                      0xFFFFFFFFu
#define CAU_ADR_CA_CA8_SHIFT                     0
#define CAU_ADR_CA_CA8_WIDTH                     32
#define CAU_ADR_CA_CA8(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_ADR_CA_CA8_SHIFT))&CAU_ADR_CA_CA8_MASK)
/* RADR_CASR Bit Fields */
#define CAU_RADR_CASR_IC_MASK                    0x1u
#define CAU_RADR_CASR_IC_SHIFT                   0
#define CAU_RADR_CASR_IC_WIDTH                   1
#define CAU_RADR_CASR_IC(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CASR_IC_SHIFT))&CAU_RADR_CASR_IC_MASK)
#define CAU_RADR_CASR_DPE_MASK                   0x2u
#define CAU_RADR_CASR_DPE_SHIFT                  1
#define CAU_RADR_CASR_DPE_WIDTH                  1
#define CAU_RADR_CASR_DPE(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CASR_DPE_SHIFT))&CAU_RADR_CASR_DPE_MASK)
#define CAU_RADR_CASR_VER_MASK                   0xF0000000u
#define CAU_RADR_CASR_VER_SHIFT                  28
#define CAU_RADR_CASR_VER_WIDTH                  4
#define CAU_RADR_CASR_VER(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CASR_VER_SHIFT))&CAU_RADR_CASR_VER_MASK)
/* RADR_CAA Bit Fields */
#define CAU_RADR_CAA_ACC_MASK                    0xFFFFFFFFu
#define CAU_RADR_CAA_ACC_SHIFT                   0
#define CAU_RADR_CAA_ACC_WIDTH                   32
#define CAU_RADR_CAA_ACC(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CAA_ACC_SHIFT))&CAU_RADR_CAA_ACC_MASK)
/* RADR_CA Bit Fields */
#define CAU_RADR_CA_CA0_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA0_SHIFT                    0
#define CAU_RADR_CA_CA0_WIDTH                    32
#define CAU_RADR_CA_CA0(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA0_SHIFT))&CAU_RADR_CA_CA0_MASK)
#define CAU_RADR_CA_CA1_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA1_SHIFT                    0
#define CAU_RADR_CA_CA1_WIDTH                    32
#define CAU_RADR_CA_CA1(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA1_SHIFT))&CAU_RADR_CA_CA1_MASK)
#define CAU_RADR_CA_CA2_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA2_SHIFT                    0
#define CAU_RADR_CA_CA2_WIDTH                    32
#define CAU_RADR_CA_CA2(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA2_SHIFT))&CAU_RADR_CA_CA2_MASK)
#define CAU_RADR_CA_CA3_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA3_SHIFT                    0
#define CAU_RADR_CA_CA3_WIDTH                    32
#define CAU_RADR_CA_CA3(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA3_SHIFT))&CAU_RADR_CA_CA3_MASK)
#define CAU_RADR_CA_CA4_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA4_SHIFT                    0
#define CAU_RADR_CA_CA4_WIDTH                    32
#define CAU_RADR_CA_CA4(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA4_SHIFT))&CAU_RADR_CA_CA4_MASK)
#define CAU_RADR_CA_CA5_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA5_SHIFT                    0
#define CAU_RADR_CA_CA5_WIDTH                    32
#define CAU_RADR_CA_CA5(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA5_SHIFT))&CAU_RADR_CA_CA5_MASK)
#define CAU_RADR_CA_CA6_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA6_SHIFT                    0
#define CAU_RADR_CA_CA6_WIDTH                    32
#define CAU_RADR_CA_CA6(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA6_SHIFT))&CAU_RADR_CA_CA6_MASK)
#define CAU_RADR_CA_CA7_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA7_SHIFT                    0
#define CAU_RADR_CA_CA7_WIDTH                    32
#define CAU_RADR_CA_CA7(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA7_SHIFT))&CAU_RADR_CA_CA7_MASK)
#define CAU_RADR_CA_CA8_MASK                     0xFFFFFFFFu
#define CAU_RADR_CA_CA8_SHIFT                    0
#define CAU_RADR_CA_CA8_WIDTH                    32
#define CAU_RADR_CA_CA8(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_RADR_CA_CA8_SHIFT))&CAU_RADR_CA_CA8_MASK)
/* XOR_CASR Bit Fields */
#define CAU_XOR_CASR_IC_MASK                     0x1u
#define CAU_XOR_CASR_IC_SHIFT                    0
#define CAU_XOR_CASR_IC_WIDTH                    1
#define CAU_XOR_CASR_IC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CASR_IC_SHIFT))&CAU_XOR_CASR_IC_MASK)
#define CAU_XOR_CASR_DPE_MASK                    0x2u
#define CAU_XOR_CASR_DPE_SHIFT                   1
#define CAU_XOR_CASR_DPE_WIDTH                   1
#define CAU_XOR_CASR_DPE(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CASR_DPE_SHIFT))&CAU_XOR_CASR_DPE_MASK)
#define CAU_XOR_CASR_VER_MASK                    0xF0000000u
#define CAU_XOR_CASR_VER_SHIFT                   28
#define CAU_XOR_CASR_VER_WIDTH                   4
#define CAU_XOR_CASR_VER(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CASR_VER_SHIFT))&CAU_XOR_CASR_VER_MASK)
/* XOR_CAA Bit Fields */
#define CAU_XOR_CAA_ACC_MASK                     0xFFFFFFFFu
#define CAU_XOR_CAA_ACC_SHIFT                    0
#define CAU_XOR_CAA_ACC_WIDTH                    32
#define CAU_XOR_CAA_ACC(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CAA_ACC_SHIFT))&CAU_XOR_CAA_ACC_MASK)
/* XOR_CA Bit Fields */
#define CAU_XOR_CA_CA0_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA0_SHIFT                     0
#define CAU_XOR_CA_CA0_WIDTH                     32
#define CAU_XOR_CA_CA0(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA0_SHIFT))&CAU_XOR_CA_CA0_MASK)
#define CAU_XOR_CA_CA1_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA1_SHIFT                     0
#define CAU_XOR_CA_CA1_WIDTH                     32
#define CAU_XOR_CA_CA1(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA1_SHIFT))&CAU_XOR_CA_CA1_MASK)
#define CAU_XOR_CA_CA2_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA2_SHIFT                     0
#define CAU_XOR_CA_CA2_WIDTH                     32
#define CAU_XOR_CA_CA2(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA2_SHIFT))&CAU_XOR_CA_CA2_MASK)
#define CAU_XOR_CA_CA3_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA3_SHIFT                     0
#define CAU_XOR_CA_CA3_WIDTH                     32
#define CAU_XOR_CA_CA3(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA3_SHIFT))&CAU_XOR_CA_CA3_MASK)
#define CAU_XOR_CA_CA4_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA4_SHIFT                     0
#define CAU_XOR_CA_CA4_WIDTH                     32
#define CAU_XOR_CA_CA4(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA4_SHIFT))&CAU_XOR_CA_CA4_MASK)
#define CAU_XOR_CA_CA5_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA5_SHIFT                     0
#define CAU_XOR_CA_CA5_WIDTH                     32
#define CAU_XOR_CA_CA5(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA5_SHIFT))&CAU_XOR_CA_CA5_MASK)
#define CAU_XOR_CA_CA6_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA6_SHIFT                     0
#define CAU_XOR_CA_CA6_WIDTH                     32
#define CAU_XOR_CA_CA6(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA6_SHIFT))&CAU_XOR_CA_CA6_MASK)
#define CAU_XOR_CA_CA7_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA7_SHIFT                     0
#define CAU_XOR_CA_CA7_WIDTH                     32
#define CAU_XOR_CA_CA7(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA7_SHIFT))&CAU_XOR_CA_CA7_MASK)
#define CAU_XOR_CA_CA8_MASK                      0xFFFFFFFFu
#define CAU_XOR_CA_CA8_SHIFT                     0
#define CAU_XOR_CA_CA8_WIDTH                     32
#define CAU_XOR_CA_CA8(x)                        (((uint32_t)(((uint32_t)(x))<<CAU_XOR_CA_CA8_SHIFT))&CAU_XOR_CA_CA8_MASK)
/* ROTL_CASR Bit Fields */
#define CAU_ROTL_CASR_IC_MASK                    0x1u
#define CAU_ROTL_CASR_IC_SHIFT                   0
#define CAU_ROTL_CASR_IC_WIDTH                   1
#define CAU_ROTL_CASR_IC(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CASR_IC_SHIFT))&CAU_ROTL_CASR_IC_MASK)
#define CAU_ROTL_CASR_DPE_MASK                   0x2u
#define CAU_ROTL_CASR_DPE_SHIFT                  1
#define CAU_ROTL_CASR_DPE_WIDTH                  1
#define CAU_ROTL_CASR_DPE(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CASR_DPE_SHIFT))&CAU_ROTL_CASR_DPE_MASK)
#define CAU_ROTL_CASR_VER_MASK                   0xF0000000u
#define CAU_ROTL_CASR_VER_SHIFT                  28
#define CAU_ROTL_CASR_VER_WIDTH                  4
#define CAU_ROTL_CASR_VER(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CASR_VER_SHIFT))&CAU_ROTL_CASR_VER_MASK)
/* ROTL_CAA Bit Fields */
#define CAU_ROTL_CAA_ACC_MASK                    0xFFFFFFFFu
#define CAU_ROTL_CAA_ACC_SHIFT                   0
#define CAU_ROTL_CAA_ACC_WIDTH                   32
#define CAU_ROTL_CAA_ACC(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CAA_ACC_SHIFT))&CAU_ROTL_CAA_ACC_MASK)
/* ROTL_CA Bit Fields */
#define CAU_ROTL_CA_CA0_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA0_SHIFT                    0
#define CAU_ROTL_CA_CA0_WIDTH                    32
#define CAU_ROTL_CA_CA0(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA0_SHIFT))&CAU_ROTL_CA_CA0_MASK)
#define CAU_ROTL_CA_CA1_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA1_SHIFT                    0
#define CAU_ROTL_CA_CA1_WIDTH                    32
#define CAU_ROTL_CA_CA1(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA1_SHIFT))&CAU_ROTL_CA_CA1_MASK)
#define CAU_ROTL_CA_CA2_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA2_SHIFT                    0
#define CAU_ROTL_CA_CA2_WIDTH                    32
#define CAU_ROTL_CA_CA2(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA2_SHIFT))&CAU_ROTL_CA_CA2_MASK)
#define CAU_ROTL_CA_CA3_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA3_SHIFT                    0
#define CAU_ROTL_CA_CA3_WIDTH                    32
#define CAU_ROTL_CA_CA3(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA3_SHIFT))&CAU_ROTL_CA_CA3_MASK)
#define CAU_ROTL_CA_CA4_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA4_SHIFT                    0
#define CAU_ROTL_CA_CA4_WIDTH                    32
#define CAU_ROTL_CA_CA4(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA4_SHIFT))&CAU_ROTL_CA_CA4_MASK)
#define CAU_ROTL_CA_CA5_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA5_SHIFT                    0
#define CAU_ROTL_CA_CA5_WIDTH                    32
#define CAU_ROTL_CA_CA5(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA5_SHIFT))&CAU_ROTL_CA_CA5_MASK)
#define CAU_ROTL_CA_CA6_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA6_SHIFT                    0
#define CAU_ROTL_CA_CA6_WIDTH                    32
#define CAU_ROTL_CA_CA6(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA6_SHIFT))&CAU_ROTL_CA_CA6_MASK)
#define CAU_ROTL_CA_CA7_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA7_SHIFT                    0
#define CAU_ROTL_CA_CA7_WIDTH                    32
#define CAU_ROTL_CA_CA7(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA7_SHIFT))&CAU_ROTL_CA_CA7_MASK)
#define CAU_ROTL_CA_CA8_MASK                     0xFFFFFFFFu
#define CAU_ROTL_CA_CA8_SHIFT                    0
#define CAU_ROTL_CA_CA8_WIDTH                    32
#define CAU_ROTL_CA_CA8(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_ROTL_CA_CA8_SHIFT))&CAU_ROTL_CA_CA8_MASK)
/* AESC_CASR Bit Fields */
#define CAU_AESC_CASR_IC_MASK                    0x1u
#define CAU_AESC_CASR_IC_SHIFT                   0
#define CAU_AESC_CASR_IC_WIDTH                   1
#define CAU_AESC_CASR_IC(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CASR_IC_SHIFT))&CAU_AESC_CASR_IC_MASK)
#define CAU_AESC_CASR_DPE_MASK                   0x2u
#define CAU_AESC_CASR_DPE_SHIFT                  1
#define CAU_AESC_CASR_DPE_WIDTH                  1
#define CAU_AESC_CASR_DPE(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CASR_DPE_SHIFT))&CAU_AESC_CASR_DPE_MASK)
#define CAU_AESC_CASR_VER_MASK                   0xF0000000u
#define CAU_AESC_CASR_VER_SHIFT                  28
#define CAU_AESC_CASR_VER_WIDTH                  4
#define CAU_AESC_CASR_VER(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CASR_VER_SHIFT))&CAU_AESC_CASR_VER_MASK)
/* AESC_CAA Bit Fields */
#define CAU_AESC_CAA_ACC_MASK                    0xFFFFFFFFu
#define CAU_AESC_CAA_ACC_SHIFT                   0
#define CAU_AESC_CAA_ACC_WIDTH                   32
#define CAU_AESC_CAA_ACC(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CAA_ACC_SHIFT))&CAU_AESC_CAA_ACC_MASK)
/* AESC_CA Bit Fields */
#define CAU_AESC_CA_CA0_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA0_SHIFT                    0
#define CAU_AESC_CA_CA0_WIDTH                    32
#define CAU_AESC_CA_CA0(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA0_SHIFT))&CAU_AESC_CA_CA0_MASK)
#define CAU_AESC_CA_CA1_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA1_SHIFT                    0
#define CAU_AESC_CA_CA1_WIDTH                    32
#define CAU_AESC_CA_CA1(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA1_SHIFT))&CAU_AESC_CA_CA1_MASK)
#define CAU_AESC_CA_CA2_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA2_SHIFT                    0
#define CAU_AESC_CA_CA2_WIDTH                    32
#define CAU_AESC_CA_CA2(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA2_SHIFT))&CAU_AESC_CA_CA2_MASK)
#define CAU_AESC_CA_CA3_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA3_SHIFT                    0
#define CAU_AESC_CA_CA3_WIDTH                    32
#define CAU_AESC_CA_CA3(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA3_SHIFT))&CAU_AESC_CA_CA3_MASK)
#define CAU_AESC_CA_CA4_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA4_SHIFT                    0
#define CAU_AESC_CA_CA4_WIDTH                    32
#define CAU_AESC_CA_CA4(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA4_SHIFT))&CAU_AESC_CA_CA4_MASK)
#define CAU_AESC_CA_CA5_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA5_SHIFT                    0
#define CAU_AESC_CA_CA5_WIDTH                    32
#define CAU_AESC_CA_CA5(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA5_SHIFT))&CAU_AESC_CA_CA5_MASK)
#define CAU_AESC_CA_CA6_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA6_SHIFT                    0
#define CAU_AESC_CA_CA6_WIDTH                    32
#define CAU_AESC_CA_CA6(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA6_SHIFT))&CAU_AESC_CA_CA6_MASK)
#define CAU_AESC_CA_CA7_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA7_SHIFT                    0
#define CAU_AESC_CA_CA7_WIDTH                    32
#define CAU_AESC_CA_CA7(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA7_SHIFT))&CAU_AESC_CA_CA7_MASK)
#define CAU_AESC_CA_CA8_MASK                     0xFFFFFFFFu
#define CAU_AESC_CA_CA8_SHIFT                    0
#define CAU_AESC_CA_CA8_WIDTH                    32
#define CAU_AESC_CA_CA8(x)                       (((uint32_t)(((uint32_t)(x))<<CAU_AESC_CA_CA8_SHIFT))&CAU_AESC_CA_CA8_MASK)
/* AESIC_CASR Bit Fields */
#define CAU_AESIC_CASR_IC_MASK                   0x1u
#define CAU_AESIC_CASR_IC_SHIFT                  0
#define CAU_AESIC_CASR_IC_WIDTH                  1
#define CAU_AESIC_CASR_IC(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CASR_IC_SHIFT))&CAU_AESIC_CASR_IC_MASK)
#define CAU_AESIC_CASR_DPE_MASK                  0x2u
#define CAU_AESIC_CASR_DPE_SHIFT                 1
#define CAU_AESIC_CASR_DPE_WIDTH                 1
#define CAU_AESIC_CASR_DPE(x)                    (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CASR_DPE_SHIFT))&CAU_AESIC_CASR_DPE_MASK)
#define CAU_AESIC_CASR_VER_MASK                  0xF0000000u
#define CAU_AESIC_CASR_VER_SHIFT                 28
#define CAU_AESIC_CASR_VER_WIDTH                 4
#define CAU_AESIC_CASR_VER(x)                    (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CASR_VER_SHIFT))&CAU_AESIC_CASR_VER_MASK)
/* AESIC_CAA Bit Fields */
#define CAU_AESIC_CAA_ACC_MASK                   0xFFFFFFFFu
#define CAU_AESIC_CAA_ACC_SHIFT                  0
#define CAU_AESIC_CAA_ACC_WIDTH                  32
#define CAU_AESIC_CAA_ACC(x)                     (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CAA_ACC_SHIFT))&CAU_AESIC_CAA_ACC_MASK)
/* AESIC_CA Bit Fields */
#define CAU_AESIC_CA_CA0_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA0_SHIFT                   0
#define CAU_AESIC_CA_CA0_WIDTH                   32
#define CAU_AESIC_CA_CA0(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA0_SHIFT))&CAU_AESIC_CA_CA0_MASK)
#define CAU_AESIC_CA_CA1_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA1_SHIFT                   0
#define CAU_AESIC_CA_CA1_WIDTH                   32
#define CAU_AESIC_CA_CA1(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA1_SHIFT))&CAU_AESIC_CA_CA1_MASK)
#define CAU_AESIC_CA_CA2_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA2_SHIFT                   0
#define CAU_AESIC_CA_CA2_WIDTH                   32
#define CAU_AESIC_CA_CA2(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA2_SHIFT))&CAU_AESIC_CA_CA2_MASK)
#define CAU_AESIC_CA_CA3_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA3_SHIFT                   0
#define CAU_AESIC_CA_CA3_WIDTH                   32
#define CAU_AESIC_CA_CA3(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA3_SHIFT))&CAU_AESIC_CA_CA3_MASK)
#define CAU_AESIC_CA_CA4_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA4_SHIFT                   0
#define CAU_AESIC_CA_CA4_WIDTH                   32
#define CAU_AESIC_CA_CA4(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA4_SHIFT))&CAU_AESIC_CA_CA4_MASK)
#define CAU_AESIC_CA_CA5_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA5_SHIFT                   0
#define CAU_AESIC_CA_CA5_WIDTH                   32
#define CAU_AESIC_CA_CA5(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA5_SHIFT))&CAU_AESIC_CA_CA5_MASK)
#define CAU_AESIC_CA_CA6_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA6_SHIFT                   0
#define CAU_AESIC_CA_CA6_WIDTH                   32
#define CAU_AESIC_CA_CA6(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA6_SHIFT))&CAU_AESIC_CA_CA6_MASK)
#define CAU_AESIC_CA_CA7_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA7_SHIFT                   0
#define CAU_AESIC_CA_CA7_WIDTH                   32
#define CAU_AESIC_CA_CA7(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA7_SHIFT))&CAU_AESIC_CA_CA7_MASK)
#define CAU_AESIC_CA_CA8_MASK                    0xFFFFFFFFu
#define CAU_AESIC_CA_CA8_SHIFT                   0
#define CAU_AESIC_CA_CA8_WIDTH                   32
#define CAU_AESIC_CA_CA8(x)                      (((uint32_t)(((uint32_t)(x))<<CAU_AESIC_CA_CA8_SHIFT))&CAU_AESIC_CA_CA8_MASK)

/*!
 * @}
 */ /* end of group CAU_Register_Masks */


/* CAU - Peripheral instance base addresses */
/** Peripheral CAU base address */
#define CAU_BASE                                 (0xE0081000u)
/** Peripheral CAU base pointer */
#define CAU                                      ((CAU_Type *)CAU_BASE)
#define CAU_BASE_PTR                             (CAU)
/** Array initializer of CAU peripheral base addresses */
#define CAU_BASE_ADDRS                           { CAU_BASE }
/** Array initializer of CAU peripheral base pointers */
#define CAU_BASE_PTRS                            { CAU }

/* ----------------------------------------------------------------------------
   -- CAU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAU_Register_Accessor_Macros CAU - Register accessor macros
 * @{
 */


/* CAU - Register instance definitions */
/* CAU */
#define CAU_DIRECT0                              CAU_DIRECT_REG(CAU,0)
#define CAU_DIRECT1                              CAU_DIRECT_REG(CAU,1)
#define CAU_DIRECT2                              CAU_DIRECT_REG(CAU,2)
#define CAU_DIRECT3                              CAU_DIRECT_REG(CAU,3)
#define CAU_DIRECT4                              CAU_DIRECT_REG(CAU,4)
#define CAU_DIRECT5                              CAU_DIRECT_REG(CAU,5)
#define CAU_DIRECT6                              CAU_DIRECT_REG(CAU,6)
#define CAU_DIRECT7                              CAU_DIRECT_REG(CAU,7)
#define CAU_DIRECT8                              CAU_DIRECT_REG(CAU,8)
#define CAU_DIRECT9                              CAU_DIRECT_REG(CAU,9)
#define CAU_DIRECT10                             CAU_DIRECT_REG(CAU,10)
#define CAU_DIRECT11                             CAU_DIRECT_REG(CAU,11)
#define CAU_DIRECT12                             CAU_DIRECT_REG(CAU,12)
#define CAU_DIRECT13                             CAU_DIRECT_REG(CAU,13)
#define CAU_DIRECT14                             CAU_DIRECT_REG(CAU,14)
#define CAU_DIRECT15                             CAU_DIRECT_REG(CAU,15)
#define CAU_LDR_CASR                             CAU_LDR_CASR_REG(CAU)
#define CAU_LDR_CAA                              CAU_LDR_CAA_REG(CAU)
#define CAU_LDR_CA0                              CAU_LDR_CA_REG(CAU,0)
#define CAU_LDR_CA1                              CAU_LDR_CA_REG(CAU,1)
#define CAU_LDR_CA2                              CAU_LDR_CA_REG(CAU,2)
#define CAU_LDR_CA3                              CAU_LDR_CA_REG(CAU,3)
#define CAU_LDR_CA4                              CAU_LDR_CA_REG(CAU,4)
#define CAU_LDR_CA5                              CAU_LDR_CA_REG(CAU,5)
#define CAU_LDR_CA6                              CAU_LDR_CA_REG(CAU,6)
#define CAU_LDR_CA7                              CAU_LDR_CA_REG(CAU,7)
#define CAU_LDR_CA8                              CAU_LDR_CA_REG(CAU,8)
#define CAU_STR_CASR                             CAU_STR_CASR_REG(CAU)
#define CAU_STR_CAA                              CAU_STR_CAA_REG(CAU)
#define CAU_STR_CA0                              CAU_STR_CA_REG(CAU,0)
#define CAU_STR_CA1                              CAU_STR_CA_REG(CAU,1)
#define CAU_STR_CA2                              CAU_STR_CA_REG(CAU,2)
#define CAU_STR_CA3                              CAU_STR_CA_REG(CAU,3)
#define CAU_STR_CA4                              CAU_STR_CA_REG(CAU,4)
#define CAU_STR_CA5                              CAU_STR_CA_REG(CAU,5)
#define CAU_STR_CA6                              CAU_STR_CA_REG(CAU,6)
#define CAU_STR_CA7                              CAU_STR_CA_REG(CAU,7)
#define CAU_STR_CA8                              CAU_STR_CA_REG(CAU,8)
#define CAU_ADR_CASR                             CAU_ADR_CASR_REG(CAU)
#define CAU_ADR_CAA                              CAU_ADR_CAA_REG(CAU)
#define CAU_ADR_CA0                              CAU_ADR_CA_REG(CAU,0)
#define CAU_ADR_CA1                              CAU_ADR_CA_REG(CAU,1)
#define CAU_ADR_CA2                              CAU_ADR_CA_REG(CAU,2)
#define CAU_ADR_CA3                              CAU_ADR_CA_REG(CAU,3)
#define CAU_ADR_CA4                              CAU_ADR_CA_REG(CAU,4)
#define CAU_ADR_CA5                              CAU_ADR_CA_REG(CAU,5)
#define CAU_ADR_CA6                              CAU_ADR_CA_REG(CAU,6)
#define CAU_ADR_CA7                              CAU_ADR_CA_REG(CAU,7)
#define CAU_ADR_CA8                              CAU_ADR_CA_REG(CAU,8)
#define CAU_RADR_CASR                            CAU_RADR_CASR_REG(CAU)
#define CAU_RADR_CAA                             CAU_RADR_CAA_REG(CAU)
#define CAU_RADR_CA0                             CAU_RADR_CA_REG(CAU,0)
#define CAU_RADR_CA1                             CAU_RADR_CA_REG(CAU,1)
#define CAU_RADR_CA2                             CAU_RADR_CA_REG(CAU,2)
#define CAU_RADR_CA3                             CAU_RADR_CA_REG(CAU,3)
#define CAU_RADR_CA4                             CAU_RADR_CA_REG(CAU,4)
#define CAU_RADR_CA5                             CAU_RADR_CA_REG(CAU,5)
#define CAU_RADR_CA6                             CAU_RADR_CA_REG(CAU,6)
#define CAU_RADR_CA7                             CAU_RADR_CA_REG(CAU,7)
#define CAU_RADR_CA8                             CAU_RADR_CA_REG(CAU,8)
#define CAU_XOR_CASR                             CAU_XOR_CASR_REG(CAU)
#define CAU_XOR_CAA                              CAU_XOR_CAA_REG(CAU)
#define CAU_XOR_CA0                              CAU_XOR_CA_REG(CAU,0)
#define CAU_XOR_CA1                              CAU_XOR_CA_REG(CAU,1)
#define CAU_XOR_CA2                              CAU_XOR_CA_REG(CAU,2)
#define CAU_XOR_CA3                              CAU_XOR_CA_REG(CAU,3)
#define CAU_XOR_CA4                              CAU_XOR_CA_REG(CAU,4)
#define CAU_XOR_CA5                              CAU_XOR_CA_REG(CAU,5)
#define CAU_XOR_CA6                              CAU_XOR_CA_REG(CAU,6)
#define CAU_XOR_CA7                              CAU_XOR_CA_REG(CAU,7)
#define CAU_XOR_CA8                              CAU_XOR_CA_REG(CAU,8)
#define CAU_ROTL_CASR                            CAU_ROTL_CASR_REG(CAU)
#define CAU_ROTL_CAA                             CAU_ROTL_CAA_REG(CAU)
#define CAU_ROTL_CA0                             CAU_ROTL_CA_REG(CAU,0)
#define CAU_ROTL_CA1                             CAU_ROTL_CA_REG(CAU,1)
#define CAU_ROTL_CA2                             CAU_ROTL_CA_REG(CAU,2)
#define CAU_ROTL_CA3                             CAU_ROTL_CA_REG(CAU,3)
#define CAU_ROTL_CA4                             CAU_ROTL_CA_REG(CAU,4)
#define CAU_ROTL_CA5                             CAU_ROTL_CA_REG(CAU,5)
#define CAU_ROTL_CA6                             CAU_ROTL_CA_REG(CAU,6)
#define CAU_ROTL_CA7                             CAU_ROTL_CA_REG(CAU,7)
#define CAU_ROTL_CA8                             CAU_ROTL_CA_REG(CAU,8)
#define CAU_AESC_CASR                            CAU_AESC_CASR_REG(CAU)
#define CAU_AESC_CAA                             CAU_AESC_CAA_REG(CAU)
#define CAU_AESC_CA0                             CAU_AESC_CA_REG(CAU,0)
#define CAU_AESC_CA1                             CAU_AESC_CA_REG(CAU,1)
#define CAU_AESC_CA2                             CAU_AESC_CA_REG(CAU,2)
#define CAU_AESC_CA3                             CAU_AESC_CA_REG(CAU,3)
#define CAU_AESC_CA4                             CAU_AESC_CA_REG(CAU,4)
#define CAU_AESC_CA5                             CAU_AESC_CA_REG(CAU,5)
#define CAU_AESC_CA6                             CAU_AESC_CA_REG(CAU,6)
#define CAU_AESC_CA7                             CAU_AESC_CA_REG(CAU,7)
#define CAU_AESC_CA8                             CAU_AESC_CA_REG(CAU,8)
#define CAU_AESIC_CASR                           CAU_AESIC_CASR_REG(CAU)
#define CAU_AESIC_CAA                            CAU_AESIC_CAA_REG(CAU)
#define CAU_AESIC_CA0                            CAU_AESIC_CA_REG(CAU,0)
#define CAU_AESIC_CA1                            CAU_AESIC_CA_REG(CAU,1)
#define CAU_AESIC_CA2                            CAU_AESIC_CA_REG(CAU,2)
#define CAU_AESIC_CA3                            CAU_AESIC_CA_REG(CAU,3)
#define CAU_AESIC_CA4                            CAU_AESIC_CA_REG(CAU,4)
#define CAU_AESIC_CA5                            CAU_AESIC_CA_REG(CAU,5)
#define CAU_AESIC_CA6                            CAU_AESIC_CA_REG(CAU,6)
#define CAU_AESIC_CA7                            CAU_AESIC_CA_REG(CAU,7)
#define CAU_AESIC_CA8                            CAU_AESIC_CA_REG(CAU,8)

/* CAU - Register array accessors */
#define CAU_DIRECT(index)                        CAU_DIRECT_REG(CAU,index)
#define CAU_LDR_CA(index)                        CAU_LDR_CA_REG(CAU,index)
#define CAU_STR_CA(index)                        CAU_STR_CA_REG(CAU,index)
#define CAU_ADR_CA(index)                        CAU_ADR_CA_REG(CAU,index)
#define CAU_RADR_CA(index)                       CAU_RADR_CA_REG(CAU,index)
#define CAU_XOR_CA(index)                        CAU_XOR_CA_REG(CAU,index)
#define CAU_ROTL_CA(index)                       CAU_ROTL_CA_REG(CAU,index)
#define CAU_AESC_CA(index)                       CAU_AESC_CA_REG(CAU,index)
#define CAU_AESIC_CA(index)                      CAU_AESIC_CA_REG(CAU,index)

/*!
 * @}
 */ /* end of group CAU_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CAU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Peripheral_Access_Layer CMP Peripheral Access Layer
 * @{
 */

/** CMP - Register Layout Typedef */
typedef struct {
  __IO uint8_t CR0;                                /**< CMP Control Register 0, offset: 0x0 */
  __IO uint8_t CR1;                                /**< CMP Control Register 1, offset: 0x1 */
  __IO uint8_t FPR;                                /**< CMP Filter Period Register, offset: 0x2 */
  __IO uint8_t SCR;                                /**< CMP Status and Control Register, offset: 0x3 */
  __IO uint8_t DACCR;                              /**< DAC Control Register, offset: 0x4 */
  __IO uint8_t MUXCR;                              /**< MUX Control Register, offset: 0x5 */
} CMP_Type, *CMP_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CMP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Accessor_Macros CMP - Register accessor macros
 * @{
 */


/* CMP - Register accessors */
#define CMP_CR0_REG(base)                        ((base)->CR0)
#define CMP_CR1_REG(base)                        ((base)->CR1)
#define CMP_FPR_REG(base)                        ((base)->FPR)
#define CMP_SCR_REG(base)                        ((base)->SCR)
#define CMP_DACCR_REG(base)                      ((base)->DACCR)
#define CMP_MUXCR_REG(base)                      ((base)->MUXCR)

/*!
 * @}
 */ /* end of group CMP_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Masks CMP Register Masks
 * @{
 */

/* CR0 Bit Fields */
#define CMP_CR0_HYSTCTR_MASK                     0x3u
#define CMP_CR0_HYSTCTR_SHIFT                    0
#define CMP_CR0_HYSTCTR_WIDTH                    2
#define CMP_CR0_HYSTCTR(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_CR0_HYSTCTR_SHIFT))&CMP_CR0_HYSTCTR_MASK)
#define CMP_CR0_FILTER_CNT_MASK                  0x70u
#define CMP_CR0_FILTER_CNT_SHIFT                 4
#define CMP_CR0_FILTER_CNT_WIDTH                 3
#define CMP_CR0_FILTER_CNT(x)                    (((uint8_t)(((uint8_t)(x))<<CMP_CR0_FILTER_CNT_SHIFT))&CMP_CR0_FILTER_CNT_MASK)
/* CR1 Bit Fields */
#define CMP_CR1_EN_MASK                          0x1u
#define CMP_CR1_EN_SHIFT                         0
#define CMP_CR1_EN_WIDTH                         1
#define CMP_CR1_EN(x)                            (((uint8_t)(((uint8_t)(x))<<CMP_CR1_EN_SHIFT))&CMP_CR1_EN_MASK)
#define CMP_CR1_OPE_MASK                         0x2u
#define CMP_CR1_OPE_SHIFT                        1
#define CMP_CR1_OPE_WIDTH                        1
#define CMP_CR1_OPE(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_CR1_OPE_SHIFT))&CMP_CR1_OPE_MASK)
#define CMP_CR1_COS_MASK                         0x4u
#define CMP_CR1_COS_SHIFT                        2
#define CMP_CR1_COS_WIDTH                        1
#define CMP_CR1_COS(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_CR1_COS_SHIFT))&CMP_CR1_COS_MASK)
#define CMP_CR1_INV_MASK                         0x8u
#define CMP_CR1_INV_SHIFT                        3
#define CMP_CR1_INV_WIDTH                        1
#define CMP_CR1_INV(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_CR1_INV_SHIFT))&CMP_CR1_INV_MASK)
#define CMP_CR1_PMODE_MASK                       0x10u
#define CMP_CR1_PMODE_SHIFT                      4
#define CMP_CR1_PMODE_WIDTH                      1
#define CMP_CR1_PMODE(x)                         (((uint8_t)(((uint8_t)(x))<<CMP_CR1_PMODE_SHIFT))&CMP_CR1_PMODE_MASK)
#define CMP_CR1_TRIGM_MASK                       0x20u
#define CMP_CR1_TRIGM_SHIFT                      5
#define CMP_CR1_TRIGM_WIDTH                      1
#define CMP_CR1_TRIGM(x)                         (((uint8_t)(((uint8_t)(x))<<CMP_CR1_TRIGM_SHIFT))&CMP_CR1_TRIGM_MASK)
#define CMP_CR1_WE_MASK                          0x40u
#define CMP_CR1_WE_SHIFT                         6
#define CMP_CR1_WE_WIDTH                         1
#define CMP_CR1_WE(x)                            (((uint8_t)(((uint8_t)(x))<<CMP_CR1_WE_SHIFT))&CMP_CR1_WE_MASK)
#define CMP_CR1_SE_MASK                          0x80u
#define CMP_CR1_SE_SHIFT                         7
#define CMP_CR1_SE_WIDTH                         1
#define CMP_CR1_SE(x)                            (((uint8_t)(((uint8_t)(x))<<CMP_CR1_SE_SHIFT))&CMP_CR1_SE_MASK)
/* FPR Bit Fields */
#define CMP_FPR_FILT_PER_MASK                    0xFFu
#define CMP_FPR_FILT_PER_SHIFT                   0
#define CMP_FPR_FILT_PER_WIDTH                   8
#define CMP_FPR_FILT_PER(x)                      (((uint8_t)(((uint8_t)(x))<<CMP_FPR_FILT_PER_SHIFT))&CMP_FPR_FILT_PER_MASK)
/* SCR Bit Fields */
#define CMP_SCR_COUT_MASK                        0x1u
#define CMP_SCR_COUT_SHIFT                       0
#define CMP_SCR_COUT_WIDTH                       1
#define CMP_SCR_COUT(x)                          (((uint8_t)(((uint8_t)(x))<<CMP_SCR_COUT_SHIFT))&CMP_SCR_COUT_MASK)
#define CMP_SCR_CFF_MASK                         0x2u
#define CMP_SCR_CFF_SHIFT                        1
#define CMP_SCR_CFF_WIDTH                        1
#define CMP_SCR_CFF(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_CFF_SHIFT))&CMP_SCR_CFF_MASK)
#define CMP_SCR_CFR_MASK                         0x4u
#define CMP_SCR_CFR_SHIFT                        2
#define CMP_SCR_CFR_WIDTH                        1
#define CMP_SCR_CFR(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_CFR_SHIFT))&CMP_SCR_CFR_MASK)
#define CMP_SCR_IEF_MASK                         0x8u
#define CMP_SCR_IEF_SHIFT                        3
#define CMP_SCR_IEF_WIDTH                        1
#define CMP_SCR_IEF(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_IEF_SHIFT))&CMP_SCR_IEF_MASK)
#define CMP_SCR_IER_MASK                         0x10u
#define CMP_SCR_IER_SHIFT                        4
#define CMP_SCR_IER_WIDTH                        1
#define CMP_SCR_IER(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_IER_SHIFT))&CMP_SCR_IER_MASK)
#define CMP_SCR_DMAEN_MASK                       0x40u
#define CMP_SCR_DMAEN_SHIFT                      6
#define CMP_SCR_DMAEN_WIDTH                      1
#define CMP_SCR_DMAEN(x)                         (((uint8_t)(((uint8_t)(x))<<CMP_SCR_DMAEN_SHIFT))&CMP_SCR_DMAEN_MASK)
/* DACCR Bit Fields */
#define CMP_DACCR_VOSEL_MASK                     0x3Fu
#define CMP_DACCR_VOSEL_SHIFT                    0
#define CMP_DACCR_VOSEL_WIDTH                    6
#define CMP_DACCR_VOSEL(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_DACCR_VOSEL_SHIFT))&CMP_DACCR_VOSEL_MASK)
#define CMP_DACCR_VRSEL_MASK                     0x40u
#define CMP_DACCR_VRSEL_SHIFT                    6
#define CMP_DACCR_VRSEL_WIDTH                    1
#define CMP_DACCR_VRSEL(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_DACCR_VRSEL_SHIFT))&CMP_DACCR_VRSEL_MASK)
#define CMP_DACCR_DACEN_MASK                     0x80u
#define CMP_DACCR_DACEN_SHIFT                    7
#define CMP_DACCR_DACEN_WIDTH                    1
#define CMP_DACCR_DACEN(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_DACCR_DACEN_SHIFT))&CMP_DACCR_DACEN_MASK)
/* MUXCR Bit Fields */
#define CMP_MUXCR_MSEL_MASK                      0x7u
#define CMP_MUXCR_MSEL_SHIFT                     0
#define CMP_MUXCR_MSEL_WIDTH                     3
#define CMP_MUXCR_MSEL(x)                        (((uint8_t)(((uint8_t)(x))<<CMP_MUXCR_MSEL_SHIFT))&CMP_MUXCR_MSEL_MASK)
#define CMP_MUXCR_PSEL_MASK                      0x38u
#define CMP_MUXCR_PSEL_SHIFT                     3
#define CMP_MUXCR_PSEL_WIDTH                     3
#define CMP_MUXCR_PSEL(x)                        (((uint8_t)(((uint8_t)(x))<<CMP_MUXCR_PSEL_SHIFT))&CMP_MUXCR_PSEL_MASK)

/*!
 * @}
 */ /* end of group CMP_Register_Masks */


/* CMP - Peripheral instance base addresses */
/** Peripheral CMP0 base address */
#define CMP0_BASE                                (0x40073000u)
/** Peripheral CMP0 base pointer */
#define CMP0                                     ((CMP_Type *)CMP0_BASE)
#define CMP0_BASE_PTR                            (CMP0)
/** Peripheral CMP1 base address */
#define CMP1_BASE                                (0x40073040u)
/** Peripheral CMP1 base pointer */
#define CMP1                                     ((CMP_Type *)CMP1_BASE)
#define CMP1_BASE_PTR                            (CMP1)
/** Peripheral CMP2 base address */
#define CMP2_BASE                                (0x40073080u)
/** Peripheral CMP2 base pointer */
#define CMP2                                     ((CMP_Type *)CMP2_BASE)
#define CMP2_BASE_PTR                            (CMP2)
/** Peripheral CMP3 base address */
#define CMP3_BASE                                (0x400730C0u)
/** Peripheral CMP3 base pointer */
#define CMP3                                     ((CMP_Type *)CMP3_BASE)
#define CMP3_BASE_PTR                            (CMP3)
/** Array initializer of CMP peripheral base addresses */
#define CMP_BASE_ADDRS                           { CMP0_BASE, CMP1_BASE, CMP2_BASE, CMP3_BASE }
/** Array initializer of CMP peripheral base pointers */
#define CMP_BASE_PTRS                            { CMP0, CMP1, CMP2, CMP3 }

/* ----------------------------------------------------------------------------
   -- CMP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Accessor_Macros CMP - Register accessor macros
 * @{
 */


/* CMP - Register instance definitions */
/* CMP0 */
#define CMP0_CR0                                 CMP_CR0_REG(CMP0)
#define CMP0_CR1                                 CMP_CR1_REG(CMP0)
#define CMP0_FPR                                 CMP_FPR_REG(CMP0)
#define CMP0_SCR                                 CMP_SCR_REG(CMP0)
#define CMP0_DACCR                               CMP_DACCR_REG(CMP0)
#define CMP0_MUXCR                               CMP_MUXCR_REG(CMP0)
/* CMP1 */
#define CMP1_CR0                                 CMP_CR0_REG(CMP1)
#define CMP1_CR1                                 CMP_CR1_REG(CMP1)
#define CMP1_FPR                                 CMP_FPR_REG(CMP1)
#define CMP1_SCR                                 CMP_SCR_REG(CMP1)
#define CMP1_DACCR                               CMP_DACCR_REG(CMP1)
#define CMP1_MUXCR                               CMP_MUXCR_REG(CMP1)
/* CMP2 */
#define CMP2_CR0                                 CMP_CR0_REG(CMP2)
#define CMP2_CR1                                 CMP_CR1_REG(CMP2)
#define CMP2_FPR                                 CMP_FPR_REG(CMP2)
#define CMP2_SCR                                 CMP_SCR_REG(CMP2)
#define CMP2_DACCR                               CMP_DACCR_REG(CMP2)
#define CMP2_MUXCR                               CMP_MUXCR_REG(CMP2)
/* CMP3 */
#define CMP3_CR0                                 CMP_CR0_REG(CMP3)
#define CMP3_CR1                                 CMP_CR1_REG(CMP3)
#define CMP3_FPR                                 CMP_FPR_REG(CMP3)
#define CMP3_SCR                                 CMP_SCR_REG(CMP3)
#define CMP3_DACCR                               CMP_DACCR_REG(CMP3)
#define CMP3_MUXCR                               CMP_MUXCR_REG(CMP3)

/*!
 * @}
 */ /* end of group CMP_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint16_t CRCL;                              /**< CRC_CRCL register., offset: 0x0 */
      __IO uint16_t CRCH;                              /**< CRC_CRCH register., offset: 0x2 */
    } ACCESS16BIT;
    __IO uint32_t CRC;                               /**< CRC Data register, offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint8_t CRCLL;                              /**< CRC_CRCLL register., offset: 0x0 */
      __IO uint8_t CRCLU;                              /**< CRC_CRCLU register., offset: 0x1 */
      __IO uint8_t CRCHL;                              /**< CRC_CRCHL register., offset: 0x2 */
      __IO uint8_t CRCHU;                              /**< CRC_CRCHU register., offset: 0x3 */
    } ACCESS8BIT;
  };
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint16_t GPOLYL;                            /**< CRC_GPOLYL register., offset: 0x4 */
      __IO uint16_t GPOLYH;                            /**< CRC_GPOLYH register., offset: 0x6 */
    } GPOLY_ACCESS16BIT;
    __IO uint32_t GPOLY;                             /**< CRC Polynomial register, offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint8_t GPOLYLL;                            /**< CRC_GPOLYLL register., offset: 0x4 */
      __IO uint8_t GPOLYLU;                            /**< CRC_GPOLYLU register., offset: 0x5 */
      __IO uint8_t GPOLYHL;                            /**< CRC_GPOLYHL register., offset: 0x6 */
      __IO uint8_t GPOLYHU;                            /**< CRC_GPOLYHU register., offset: 0x7 */
    } GPOLY_ACCESS8BIT;
  };
  union {                                          /* offset: 0x8 */
    __IO uint32_t CTRL;                              /**< CRC Control register, offset: 0x8 */
    struct {                                         /* offset: 0x8 */
           uint8_t RESERVED_0[3];
      __IO uint8_t CTRLHU;                             /**< CRC_CTRLHU register., offset: 0xB */
    } CTRL_ACCESS8BIT;
  };
} CRC_Type, *CRC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CRC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Accessor_Macros CRC - Register accessor macros
 * @{
 */


/* CRC - Register accessors */
#define CRC_CRCL_REG(base)                       ((base)->ACCESS16BIT.CRCL)
#define CRC_CRCH_REG(base)                       ((base)->ACCESS16BIT.CRCH)
#define CRC_CRC_REG(base)                        ((base)->CRC)
#define CRC_CRCLL_REG(base)                      ((base)->ACCESS8BIT.CRCLL)
#define CRC_CRCLU_REG(base)                      ((base)->ACCESS8BIT.CRCLU)
#define CRC_CRCHL_REG(base)                      ((base)->ACCESS8BIT.CRCHL)
#define CRC_CRCHU_REG(base)                      ((base)->ACCESS8BIT.CRCHU)
#define CRC_GPOLYL_REG(base)                     ((base)->GPOLY_ACCESS16BIT.GPOLYL)
#define CRC_GPOLYH_REG(base)                     ((base)->GPOLY_ACCESS16BIT.GPOLYH)
#define CRC_GPOLY_REG(base)                      ((base)->GPOLY)
#define CRC_GPOLYLL_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYLL)
#define CRC_GPOLYLU_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYLU)
#define CRC_GPOLYHL_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYHL)
#define CRC_GPOLYHU_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYHU)
#define CRC_CTRL_REG(base)                       ((base)->CTRL)
#define CRC_CTRLHU_REG(base)                     ((base)->CTRL_ACCESS8BIT.CTRLHU)

/*!
 * @}
 */ /* end of group CRC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/* CRCL Bit Fields */
#define CRC_CRCL_CRCL_MASK                       0xFFFFu
#define CRC_CRCL_CRCL_SHIFT                      0
#define CRC_CRCL_CRCL_WIDTH                      16
#define CRC_CRCL_CRCL(x)                         (((uint16_t)(((uint16_t)(x))<<CRC_CRCL_CRCL_SHIFT))&CRC_CRCL_CRCL_MASK)
/* CRCH Bit Fields */
#define CRC_CRCH_CRCH_MASK                       0xFFFFu
#define CRC_CRCH_CRCH_SHIFT                      0
#define CRC_CRCH_CRCH_WIDTH                      16
#define CRC_CRCH_CRCH(x)                         (((uint16_t)(((uint16_t)(x))<<CRC_CRCH_CRCH_SHIFT))&CRC_CRCH_CRCH_MASK)
/* CRC Bit Fields */
#define CRC_CRC_LL_MASK                          0xFFu
#define CRC_CRC_LL_SHIFT                         0
#define CRC_CRC_LL_WIDTH                         8
#define CRC_CRC_LL(x)                            (((uint32_t)(((uint32_t)(x))<<CRC_CRC_LL_SHIFT))&CRC_CRC_LL_MASK)
#define CRC_CRC_LU_MASK                          0xFF00u
#define CRC_CRC_LU_SHIFT                         8
#define CRC_CRC_LU_WIDTH                         8
#define CRC_CRC_LU(x)                            (((uint32_t)(((uint32_t)(x))<<CRC_CRC_LU_SHIFT))&CRC_CRC_LU_MASK)
#define CRC_CRC_HL_MASK                          0xFF0000u
#define CRC_CRC_HL_SHIFT                         16
#define CRC_CRC_HL_WIDTH                         8
#define CRC_CRC_HL(x)                            (((uint32_t)(((uint32_t)(x))<<CRC_CRC_HL_SHIFT))&CRC_CRC_HL_MASK)
#define CRC_CRC_HU_MASK                          0xFF000000u
#define CRC_CRC_HU_SHIFT                         24
#define CRC_CRC_HU_WIDTH                         8
#define CRC_CRC_HU(x)                            (((uint32_t)(((uint32_t)(x))<<CRC_CRC_HU_SHIFT))&CRC_CRC_HU_MASK)
/* CRCLL Bit Fields */
#define CRC_CRCLL_CRCLL_MASK                     0xFFu
#define CRC_CRCLL_CRCLL_SHIFT                    0
#define CRC_CRCLL_CRCLL_WIDTH                    8
#define CRC_CRCLL_CRCLL(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CRCLL_CRCLL_SHIFT))&CRC_CRCLL_CRCLL_MASK)
/* CRCLU Bit Fields */
#define CRC_CRCLU_CRCLU_MASK                     0xFFu
#define CRC_CRCLU_CRCLU_SHIFT                    0
#define CRC_CRCLU_CRCLU_WIDTH                    8
#define CRC_CRCLU_CRCLU(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CRCLU_CRCLU_SHIFT))&CRC_CRCLU_CRCLU_MASK)
/* CRCHL Bit Fields */
#define CRC_CRCHL_CRCHL_MASK                     0xFFu
#define CRC_CRCHL_CRCHL_SHIFT                    0
#define CRC_CRCHL_CRCHL_WIDTH                    8
#define CRC_CRCHL_CRCHL(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CRCHL_CRCHL_SHIFT))&CRC_CRCHL_CRCHL_MASK)
/* CRCHU Bit Fields */
#define CRC_CRCHU_CRCHU_MASK                     0xFFu
#define CRC_CRCHU_CRCHU_SHIFT                    0
#define CRC_CRCHU_CRCHU_WIDTH                    8
#define CRC_CRCHU_CRCHU(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CRCHU_CRCHU_SHIFT))&CRC_CRCHU_CRCHU_MASK)
/* GPOLYL Bit Fields */
#define CRC_GPOLYL_GPOLYL_MASK                   0xFFFFu
#define CRC_GPOLYL_GPOLYL_SHIFT                  0
#define CRC_GPOLYL_GPOLYL_WIDTH                  16
#define CRC_GPOLYL_GPOLYL(x)                     (((uint16_t)(((uint16_t)(x))<<CRC_GPOLYL_GPOLYL_SHIFT))&CRC_GPOLYL_GPOLYL_MASK)
/* GPOLYH Bit Fields */
#define CRC_GPOLYH_GPOLYH_MASK                   0xFFFFu
#define CRC_GPOLYH_GPOLYH_SHIFT                  0
#define CRC_GPOLYH_GPOLYH_WIDTH                  16
#define CRC_GPOLYH_GPOLYH(x)                     (((uint16_t)(((uint16_t)(x))<<CRC_GPOLYH_GPOLYH_SHIFT))&CRC_GPOLYH_GPOLYH_MASK)
/* GPOLY Bit Fields */
#define CRC_GPOLY_LOW_MASK                       0xFFFFu
#define CRC_GPOLY_LOW_SHIFT                      0
#define CRC_GPOLY_LOW_WIDTH                      16
#define CRC_GPOLY_LOW(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_GPOLY_LOW_SHIFT))&CRC_GPOLY_LOW_MASK)
#define CRC_GPOLY_HIGH_MASK                      0xFFFF0000u
#define CRC_GPOLY_HIGH_SHIFT                     16
#define CRC_GPOLY_HIGH_WIDTH                     16
#define CRC_GPOLY_HIGH(x)                        (((uint32_t)(((uint32_t)(x))<<CRC_GPOLY_HIGH_SHIFT))&CRC_GPOLY_HIGH_MASK)
/* GPOLYLL Bit Fields */
#define CRC_GPOLYLL_GPOLYLL_MASK                 0xFFu
#define CRC_GPOLYLL_GPOLYLL_SHIFT                0
#define CRC_GPOLYLL_GPOLYLL_WIDTH                8
#define CRC_GPOLYLL_GPOLYLL(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYLL_GPOLYLL_SHIFT))&CRC_GPOLYLL_GPOLYLL_MASK)
/* GPOLYLU Bit Fields */
#define CRC_GPOLYLU_GPOLYLU_MASK                 0xFFu
#define CRC_GPOLYLU_GPOLYLU_SHIFT                0
#define CRC_GPOLYLU_GPOLYLU_WIDTH                8
#define CRC_GPOLYLU_GPOLYLU(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYLU_GPOLYLU_SHIFT))&CRC_GPOLYLU_GPOLYLU_MASK)
/* GPOLYHL Bit Fields */
#define CRC_GPOLYHL_GPOLYHL_MASK                 0xFFu
#define CRC_GPOLYHL_GPOLYHL_SHIFT                0
#define CRC_GPOLYHL_GPOLYHL_WIDTH                8
#define CRC_GPOLYHL_GPOLYHL(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYHL_GPOLYHL_SHIFT))&CRC_GPOLYHL_GPOLYHL_MASK)
/* GPOLYHU Bit Fields */
#define CRC_GPOLYHU_GPOLYHU_MASK                 0xFFu
#define CRC_GPOLYHU_GPOLYHU_SHIFT                0
#define CRC_GPOLYHU_GPOLYHU_WIDTH                8
#define CRC_GPOLYHU_GPOLYHU(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYHU_GPOLYHU_SHIFT))&CRC_GPOLYHU_GPOLYHU_MASK)
/* CTRL Bit Fields */
#define CRC_CTRL_TCRC_MASK                       0x1000000u
#define CRC_CTRL_TCRC_SHIFT                      24
#define CRC_CTRL_TCRC_WIDTH                      1
#define CRC_CTRL_TCRC(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_TCRC_SHIFT))&CRC_CTRL_TCRC_MASK)
#define CRC_CTRL_WAS_MASK                        0x2000000u
#define CRC_CTRL_WAS_SHIFT                       25
#define CRC_CTRL_WAS_WIDTH                       1
#define CRC_CTRL_WAS(x)                          (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_WAS_SHIFT))&CRC_CTRL_WAS_MASK)
#define CRC_CTRL_FXOR_MASK                       0x4000000u
#define CRC_CTRL_FXOR_SHIFT                      26
#define CRC_CTRL_FXOR_WIDTH                      1
#define CRC_CTRL_FXOR(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_FXOR_SHIFT))&CRC_CTRL_FXOR_MASK)
#define CRC_CTRL_TOTR_MASK                       0x30000000u
#define CRC_CTRL_TOTR_SHIFT                      28
#define CRC_CTRL_TOTR_WIDTH                      2
#define CRC_CTRL_TOTR(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_TOTR_SHIFT))&CRC_CTRL_TOTR_MASK)
#define CRC_CTRL_TOT_MASK                        0xC0000000u
#define CRC_CTRL_TOT_SHIFT                       30
#define CRC_CTRL_TOT_WIDTH                       2
#define CRC_CTRL_TOT(x)                          (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_TOT_SHIFT))&CRC_CTRL_TOT_MASK)
/* CTRLHU Bit Fields */
#define CRC_CTRLHU_TCRC_MASK                     0x1u
#define CRC_CTRLHU_TCRC_SHIFT                    0
#define CRC_CTRLHU_TCRC_WIDTH                    1
#define CRC_CTRLHU_TCRC(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_TCRC_SHIFT))&CRC_CTRLHU_TCRC_MASK)
#define CRC_CTRLHU_WAS_MASK                      0x2u
#define CRC_CTRLHU_WAS_SHIFT                     1
#define CRC_CTRLHU_WAS_WIDTH                     1
#define CRC_CTRLHU_WAS(x)                        (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_WAS_SHIFT))&CRC_CTRLHU_WAS_MASK)
#define CRC_CTRLHU_FXOR_MASK                     0x4u
#define CRC_CTRLHU_FXOR_SHIFT                    2
#define CRC_CTRLHU_FXOR_WIDTH                    1
#define CRC_CTRLHU_FXOR(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_FXOR_SHIFT))&CRC_CTRLHU_FXOR_MASK)
#define CRC_CTRLHU_TOTR_MASK                     0x30u
#define CRC_CTRLHU_TOTR_SHIFT                    4
#define CRC_CTRLHU_TOTR_WIDTH                    2
#define CRC_CTRLHU_TOTR(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_TOTR_SHIFT))&CRC_CTRLHU_TOTR_MASK)
#define CRC_CTRLHU_TOT_MASK                      0xC0u
#define CRC_CTRLHU_TOT_SHIFT                     6
#define CRC_CTRLHU_TOT_WIDTH                     2
#define CRC_CTRLHU_TOT(x)                        (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_TOT_SHIFT))&CRC_CTRLHU_TOT_MASK)

/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
/** Peripheral CRC base address */
#define CRC_BASE                                 (0x40032000u)
/** Peripheral CRC base pointer */
#define CRC0                                     ((CRC_Type *)CRC_BASE)
#define CRC_BASE_PTR                             (CRC0)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS                           { CRC_BASE }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS                            { CRC0 }

/* ----------------------------------------------------------------------------
   -- CRC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Accessor_Macros CRC - Register accessor macros
 * @{
 */


/* CRC - Register instance definitions */
/* CRC */
#define CRC_CRCL                                 CRC_CRCL_REG(CRC0)
#define CRC_CRCLL                                CRC_CRCLL_REG(CRC0)
#define CRC_DATA                                 CRC_CRC_REG(CRC0)
#define CRC_CRCLU                                CRC_CRCLU_REG(CRC0)
#define CRC_CRCH                                 CRC_CRCH_REG(CRC0)
#define CRC_CRCHL                                CRC_CRCHL_REG(CRC0)
#define CRC_CRCHU                                CRC_CRCHU_REG(CRC0)
#define CRC_GPOLY                                CRC_GPOLY_REG(CRC0)
#define CRC_GPOLYL                               CRC_GPOLYL_REG(CRC0)
#define CRC_GPOLYLL                              CRC_GPOLYLL_REG(CRC0)
#define CRC_GPOLYLU                              CRC_GPOLYLU_REG(CRC0)
#define CRC_GPOLYH                               CRC_GPOLYH_REG(CRC0)
#define CRC_GPOLYHL                              CRC_GPOLYHL_REG(CRC0)
#define CRC_GPOLYHU                              CRC_GPOLYHU_REG(CRC0)
#define CRC_CTRL                                 CRC_CTRL_REG(CRC0)
#define CRC_CTRLHU                               CRC_CTRLHU_REG(CRC0)

/*!
 * @}
 */ /* end of group CRC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DAC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Peripheral_Access_Layer DAC Peripheral Access Layer
 * @{
 */

/** DAC - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x2 */
    __IO uint8_t DATL;                               /**< DAC Data Low Register, array offset: 0x0, array step: 0x2 */
    __IO uint8_t DATH;                               /**< DAC Data High Register, array offset: 0x1, array step: 0x2 */
  } DAT[16];
  __IO uint8_t SR;                                 /**< DAC Status Register, offset: 0x20 */
  __IO uint8_t C0;                                 /**< DAC Control Register, offset: 0x21 */
  __IO uint8_t C1;                                 /**< DAC Control Register 1, offset: 0x22 */
  __IO uint8_t C2;                                 /**< DAC Control Register 2, offset: 0x23 */
} DAC_Type, *DAC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DAC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Accessor_Macros DAC - Register accessor macros
 * @{
 */


/* DAC - Register accessors */
#define DAC_DATL_REG(base,index)                 ((base)->DAT[index].DATL)
#define DAC_DATL_COUNT                           16
#define DAC_DATH_REG(base,index)                 ((base)->DAT[index].DATH)
#define DAC_DATH_COUNT                           16
#define DAC_SR_REG(base)                         ((base)->SR)
#define DAC_C0_REG(base)                         ((base)->C0)
#define DAC_C1_REG(base)                         ((base)->C1)
#define DAC_C2_REG(base)                         ((base)->C2)

/*!
 * @}
 */ /* end of group DAC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DAC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Masks DAC Register Masks
 * @{
 */

/* DATL Bit Fields */
#define DAC_DATL_DATA0_MASK                      0xFFu
#define DAC_DATL_DATA0_SHIFT                     0
#define DAC_DATL_DATA0_WIDTH                     8
#define DAC_DATL_DATA0(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_DATL_DATA0_SHIFT))&DAC_DATL_DATA0_MASK)
/* DATH Bit Fields */
#define DAC_DATH_DATA1_MASK                      0xFu
#define DAC_DATH_DATA1_SHIFT                     0
#define DAC_DATH_DATA1_WIDTH                     4
#define DAC_DATH_DATA1(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_DATH_DATA1_SHIFT))&DAC_DATH_DATA1_MASK)
/* SR Bit Fields */
#define DAC_SR_DACBFRPBF_MASK                    0x1u
#define DAC_SR_DACBFRPBF_SHIFT                   0
#define DAC_SR_DACBFRPBF_WIDTH                   1
#define DAC_SR_DACBFRPBF(x)                      (((uint8_t)(((uint8_t)(x))<<DAC_SR_DACBFRPBF_SHIFT))&DAC_SR_DACBFRPBF_MASK)
#define DAC_SR_DACBFRPTF_MASK                    0x2u
#define DAC_SR_DACBFRPTF_SHIFT                   1
#define DAC_SR_DACBFRPTF_WIDTH                   1
#define DAC_SR_DACBFRPTF(x)                      (((uint8_t)(((uint8_t)(x))<<DAC_SR_DACBFRPTF_SHIFT))&DAC_SR_DACBFRPTF_MASK)
#define DAC_SR_DACBFWMF_MASK                     0x4u
#define DAC_SR_DACBFWMF_SHIFT                    2
#define DAC_SR_DACBFWMF_WIDTH                    1
#define DAC_SR_DACBFWMF(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_SR_DACBFWMF_SHIFT))&DAC_SR_DACBFWMF_MASK)
/* C0 Bit Fields */
#define DAC_C0_DACBBIEN_MASK                     0x1u
#define DAC_C0_DACBBIEN_SHIFT                    0
#define DAC_C0_DACBBIEN_WIDTH                    1
#define DAC_C0_DACBBIEN(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACBBIEN_SHIFT))&DAC_C0_DACBBIEN_MASK)
#define DAC_C0_DACBTIEN_MASK                     0x2u
#define DAC_C0_DACBTIEN_SHIFT                    1
#define DAC_C0_DACBTIEN_WIDTH                    1
#define DAC_C0_DACBTIEN(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACBTIEN_SHIFT))&DAC_C0_DACBTIEN_MASK)
#define DAC_C0_DACBWIEN_MASK                     0x4u
#define DAC_C0_DACBWIEN_SHIFT                    2
#define DAC_C0_DACBWIEN_WIDTH                    1
#define DAC_C0_DACBWIEN(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACBWIEN_SHIFT))&DAC_C0_DACBWIEN_MASK)
#define DAC_C0_LPEN_MASK                         0x8u
#define DAC_C0_LPEN_SHIFT                        3
#define DAC_C0_LPEN_WIDTH                        1
#define DAC_C0_LPEN(x)                           (((uint8_t)(((uint8_t)(x))<<DAC_C0_LPEN_SHIFT))&DAC_C0_LPEN_MASK)
#define DAC_C0_DACSWTRG_MASK                     0x10u
#define DAC_C0_DACSWTRG_SHIFT                    4
#define DAC_C0_DACSWTRG_WIDTH                    1
#define DAC_C0_DACSWTRG(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACSWTRG_SHIFT))&DAC_C0_DACSWTRG_MASK)
#define DAC_C0_DACTRGSEL_MASK                    0x20u
#define DAC_C0_DACTRGSEL_SHIFT                   5
#define DAC_C0_DACTRGSEL_WIDTH                   1
#define DAC_C0_DACTRGSEL(x)                      (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACTRGSEL_SHIFT))&DAC_C0_DACTRGSEL_MASK)
#define DAC_C0_DACRFS_MASK                       0x40u
#define DAC_C0_DACRFS_SHIFT                      6
#define DAC_C0_DACRFS_WIDTH                      1
#define DAC_C0_DACRFS(x)                         (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACRFS_SHIFT))&DAC_C0_DACRFS_MASK)
#define DAC_C0_DACEN_MASK                        0x80u
#define DAC_C0_DACEN_SHIFT                       7
#define DAC_C0_DACEN_WIDTH                       1
#define DAC_C0_DACEN(x)                          (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACEN_SHIFT))&DAC_C0_DACEN_MASK)
/* C1 Bit Fields */
#define DAC_C1_DACBFEN_MASK                      0x1u
#define DAC_C1_DACBFEN_SHIFT                     0
#define DAC_C1_DACBFEN_WIDTH                     1
#define DAC_C1_DACBFEN(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C1_DACBFEN_SHIFT))&DAC_C1_DACBFEN_MASK)
#define DAC_C1_DACBFMD_MASK                      0x6u
#define DAC_C1_DACBFMD_SHIFT                     1
#define DAC_C1_DACBFMD_WIDTH                     2
#define DAC_C1_DACBFMD(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C1_DACBFMD_SHIFT))&DAC_C1_DACBFMD_MASK)
#define DAC_C1_DACBFWM_MASK                      0x18u
#define DAC_C1_DACBFWM_SHIFT                     3
#define DAC_C1_DACBFWM_WIDTH                     2
#define DAC_C1_DACBFWM(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C1_DACBFWM_SHIFT))&DAC_C1_DACBFWM_MASK)
#define DAC_C1_DMAEN_MASK                        0x80u
#define DAC_C1_DMAEN_SHIFT                       7
#define DAC_C1_DMAEN_WIDTH                       1
#define DAC_C1_DMAEN(x)                          (((uint8_t)(((uint8_t)(x))<<DAC_C1_DMAEN_SHIFT))&DAC_C1_DMAEN_MASK)
/* C2 Bit Fields */
#define DAC_C2_DACBFUP_MASK                      0xFu
#define DAC_C2_DACBFUP_SHIFT                     0
#define DAC_C2_DACBFUP_WIDTH                     4
#define DAC_C2_DACBFUP(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C2_DACBFUP_SHIFT))&DAC_C2_DACBFUP_MASK)
#define DAC_C2_DACBFRP_MASK                      0xF0u
#define DAC_C2_DACBFRP_SHIFT                     4
#define DAC_C2_DACBFRP_WIDTH                     4
#define DAC_C2_DACBFRP(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C2_DACBFRP_SHIFT))&DAC_C2_DACBFRP_MASK)

/*!
 * @}
 */ /* end of group DAC_Register_Masks */


/* DAC - Peripheral instance base addresses */
/** Peripheral DAC0 base address */
#define DAC0_BASE                                (0x4003F000u)
/** Peripheral DAC0 base pointer */
#define DAC0                                     ((DAC_Type *)DAC0_BASE)
#define DAC0_BASE_PTR                            (DAC0)
/** Array initializer of DAC peripheral base addresses */
#define DAC_BASE_ADDRS                           { DAC0_BASE }
/** Array initializer of DAC peripheral base pointers */
#define DAC_BASE_PTRS                            { DAC0 }

/* ----------------------------------------------------------------------------
   -- DAC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Accessor_Macros DAC - Register accessor macros
 * @{
 */


/* DAC - Register instance definitions */
/* DAC0 */
#define DAC0_DAT0L                               DAC_DATL_REG(DAC0,0)
#define DAC0_DAT0H                               DAC_DATH_REG(DAC0,0)
#define DAC0_DAT1L                               DAC_DATL_REG(DAC0,1)
#define DAC0_DAT1H                               DAC_DATH_REG(DAC0,1)
#define DAC0_DAT2L                               DAC_DATL_REG(DAC0,2)
#define DAC0_DAT2H                               DAC_DATH_REG(DAC0,2)
#define DAC0_DAT3L                               DAC_DATL_REG(DAC0,3)
#define DAC0_DAT3H                               DAC_DATH_REG(DAC0,3)
#define DAC0_DAT4L                               DAC_DATL_REG(DAC0,4)
#define DAC0_DAT4H                               DAC_DATH_REG(DAC0,4)
#define DAC0_DAT5L                               DAC_DATL_REG(DAC0,5)
#define DAC0_DAT5H                               DAC_DATH_REG(DAC0,5)
#define DAC0_DAT6L                               DAC_DATL_REG(DAC0,6)
#define DAC0_DAT6H                               DAC_DATH_REG(DAC0,6)
#define DAC0_DAT7L                               DAC_DATL_REG(DAC0,7)
#define DAC0_DAT7H                               DAC_DATH_REG(DAC0,7)
#define DAC0_DAT8L                               DAC_DATL_REG(DAC0,8)
#define DAC0_DAT8H                               DAC_DATH_REG(DAC0,8)
#define DAC0_DAT9L                               DAC_DATL_REG(DAC0,9)
#define DAC0_DAT9H                               DAC_DATH_REG(DAC0,9)
#define DAC0_DAT10L                              DAC_DATL_REG(DAC0,10)
#define DAC0_DAT10H                              DAC_DATH_REG(DAC0,10)
#define DAC0_DAT11L                              DAC_DATL_REG(DAC0,11)
#define DAC0_DAT11H                              DAC_DATH_REG(DAC0,11)
#define DAC0_DAT12L                              DAC_DATL_REG(DAC0,12)
#define DAC0_DAT12H                              DAC_DATH_REG(DAC0,12)
#define DAC0_DAT13L                              DAC_DATL_REG(DAC0,13)
#define DAC0_DAT13H                              DAC_DATH_REG(DAC0,13)
#define DAC0_DAT14L                              DAC_DATL_REG(DAC0,14)
#define DAC0_DAT14H                              DAC_DATH_REG(DAC0,14)
#define DAC0_DAT15L                              DAC_DATL_REG(DAC0,15)
#define DAC0_DAT15H                              DAC_DATH_REG(DAC0,15)
#define DAC0_SR                                  DAC_SR_REG(DAC0)
#define DAC0_C0                                  DAC_C0_REG(DAC0)
#define DAC0_C1                                  DAC_C1_REG(DAC0)
#define DAC0_C2                                  DAC_C2_REG(DAC0)

/* DAC - Register array accessors */
#define DAC0_DATL(index)                         DAC_DATL_REG(DAC0,index)
#define DAC0_DATH(index)                         DAC_DATH_REG(DAC0,index)

/*!
 * @}
 */ /* end of group DAC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DAC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CR;                                /**< Control Register, offset: 0x0 */
  __I  uint32_t ES;                                /**< Error Status Register, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t ERQ;                               /**< Enable Request Register, offset: 0xC */
       uint8_t RESERVED_1[4];
  __IO uint32_t EEI;                               /**< Enable Error Interrupt Register, offset: 0x14 */
  __O  uint8_t CEEI;                               /**< Clear Enable Error Interrupt Register, offset: 0x18 */
  __O  uint8_t SEEI;                               /**< Set Enable Error Interrupt Register, offset: 0x19 */
  __O  uint8_t CERQ;                               /**< Clear Enable Request Register, offset: 0x1A */
  __O  uint8_t SERQ;                               /**< Set Enable Request Register, offset: 0x1B */
  __O  uint8_t CDNE;                               /**< Clear DONE Status Bit Register, offset: 0x1C */
  __O  uint8_t SSRT;                               /**< Set START Bit Register, offset: 0x1D */
  __O  uint8_t CERR;                               /**< Clear Error Register, offset: 0x1E */
  __O  uint8_t CINT;                               /**< Clear Interrupt Request Register, offset: 0x1F */
       uint8_t RESERVED_2[4];
  __IO uint32_t INT;                               /**< Interrupt Request Register, offset: 0x24 */
       uint8_t RESERVED_3[4];
  __IO uint32_t ERR;                               /**< Error Register, offset: 0x2C */
       uint8_t RESERVED_4[4];
  __I  uint32_t HRS;                               /**< Hardware Request Status Register, offset: 0x34 */
       uint8_t RESERVED_5[12];
  __IO uint32_t EARS;                              /**< Enable Asynchronous Request in Stop Register, offset: 0x44 */
       uint8_t RESERVED_6[184];
  __IO uint8_t DCHPRI3;                            /**< Channel n Priority Register, offset: 0x100 */
  __IO uint8_t DCHPRI2;                            /**< Channel n Priority Register, offset: 0x101 */
  __IO uint8_t DCHPRI1;                            /**< Channel n Priority Register, offset: 0x102 */
  __IO uint8_t DCHPRI0;                            /**< Channel n Priority Register, offset: 0x103 */
  __IO uint8_t DCHPRI7;                            /**< Channel n Priority Register, offset: 0x104 */
  __IO uint8_t DCHPRI6;                            /**< Channel n Priority Register, offset: 0x105 */
  __IO uint8_t DCHPRI5;                            /**< Channel n Priority Register, offset: 0x106 */
  __IO uint8_t DCHPRI4;                            /**< Channel n Priority Register, offset: 0x107 */
  __IO uint8_t DCHPRI11;                           /**< Channel n Priority Register, offset: 0x108 */
  __IO uint8_t DCHPRI10;                           /**< Channel n Priority Register, offset: 0x109 */
  __IO uint8_t DCHPRI9;                            /**< Channel n Priority Register, offset: 0x10A */
  __IO uint8_t DCHPRI8;                            /**< Channel n Priority Register, offset: 0x10B */
  __IO uint8_t DCHPRI15;                           /**< Channel n Priority Register, offset: 0x10C */
  __IO uint8_t DCHPRI14;                           /**< Channel n Priority Register, offset: 0x10D */
  __IO uint8_t DCHPRI13;                           /**< Channel n Priority Register, offset: 0x10E */
  __IO uint8_t DCHPRI12;                           /**< Channel n Priority Register, offset: 0x10F */
  __IO uint8_t DCHPRI19;                           /**< Channel n Priority Register, offset: 0x110 */
  __IO uint8_t DCHPRI18;                           /**< Channel n Priority Register, offset: 0x111 */
  __IO uint8_t DCHPRI17;                           /**< Channel n Priority Register, offset: 0x112 */
  __IO uint8_t DCHPRI16;                           /**< Channel n Priority Register, offset: 0x113 */
  __IO uint8_t DCHPRI23;                           /**< Channel n Priority Register, offset: 0x114 */
  __IO uint8_t DCHPRI22;                           /**< Channel n Priority Register, offset: 0x115 */
  __IO uint8_t DCHPRI21;                           /**< Channel n Priority Register, offset: 0x116 */
  __IO uint8_t DCHPRI20;                           /**< Channel n Priority Register, offset: 0x117 */
  __IO uint8_t DCHPRI27;                           /**< Channel n Priority Register, offset: 0x118 */
  __IO uint8_t DCHPRI26;                           /**< Channel n Priority Register, offset: 0x119 */
  __IO uint8_t DCHPRI25;                           /**< Channel n Priority Register, offset: 0x11A */
  __IO uint8_t DCHPRI24;                           /**< Channel n Priority Register, offset: 0x11B */
  __IO uint8_t DCHPRI31;                           /**< Channel n Priority Register, offset: 0x11C */
  __IO uint8_t DCHPRI30;                           /**< Channel n Priority Register, offset: 0x11D */
  __IO uint8_t DCHPRI29;                           /**< Channel n Priority Register, offset: 0x11E */
  __IO uint8_t DCHPRI28;                           /**< Channel n Priority Register, offset: 0x11F */
       uint8_t RESERVED_7[3808];
  struct {                                         /* offset: 0x1000, array step: 0x20 */
    __IO uint32_t SADDR;                             /**< TCD Source Address, array offset: 0x1000, array step: 0x20 */
    __IO uint16_t SOFF;                              /**< TCD Signed Source Address Offset, array offset: 0x1004, array step: 0x20 */
    __IO uint16_t ATTR;                              /**< TCD Transfer Attributes, array offset: 0x1006, array step: 0x20 */
    union {                                          /* offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLNO;                       /**< TCD Minor Byte Count (Minor Loop Disabled), array offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLOFFNO;                    /**< TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled), array offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLOFFYES;                   /**< TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled), array offset: 0x1008, array step: 0x20 */
    };
    __IO uint32_t SLAST;                             /**< TCD Last Source Address Adjustment, array offset: 0x100C, array step: 0x20 */
    __IO uint32_t DADDR;                             /**< TCD Destination Address, array offset: 0x1010, array step: 0x20 */
    __IO uint16_t DOFF;                              /**< TCD Signed Destination Address Offset, array offset: 0x1014, array step: 0x20 */
    union {                                          /* offset: 0x1016, array step: 0x20 */
      __IO uint16_t CITER_ELINKNO;                     /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x1016, array step: 0x20 */
      __IO uint16_t CITER_ELINKYES;                    /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x1016, array step: 0x20 */
    };
    __IO uint32_t DLAST_SGA;                         /**< TCD Last Destination Address Adjustment/Scatter Gather Address, array offset: 0x1018, array step: 0x20 */
    __IO uint16_t CSR;                               /**< TCD Control and Status, array offset: 0x101C, array step: 0x20 */
    union {                                          /* offset: 0x101E, array step: 0x20 */
      __IO uint16_t BITER_ELINKNO;                     /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x101E, array step: 0x20 */
      __IO uint16_t BITER_ELINKYES;                    /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x101E, array step: 0x20 */
    };
  } TCD[32];
} DMA_Type, *DMA_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DMA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Accessor_Macros DMA - Register accessor macros
 * @{
 */


/* DMA - Register accessors */
#define DMA_CR_REG(base)                         ((base)->CR)
#define DMA_ES_REG(base)                         ((base)->ES)
#define DMA_ERQ_REG(base)                        ((base)->ERQ)
#define DMA_EEI_REG(base)                        ((base)->EEI)
#define DMA_CEEI_REG(base)                       ((base)->CEEI)
#define DMA_SEEI_REG(base)                       ((base)->SEEI)
#define DMA_CERQ_REG(base)                       ((base)->CERQ)
#define DMA_SERQ_REG(base)                       ((base)->SERQ)
#define DMA_CDNE_REG(base)                       ((base)->CDNE)
#define DMA_SSRT_REG(base)                       ((base)->SSRT)
#define DMA_CERR_REG(base)                       ((base)->CERR)
#define DMA_CINT_REG(base)                       ((base)->CINT)
#define DMA_INT_REG(base)                        ((base)->INT)
#define DMA_ERR_REG(base)                        ((base)->ERR)
#define DMA_HRS_REG(base)                        ((base)->HRS)
#define DMA_EARS_REG(base)                       ((base)->EARS)
#define DMA_DCHPRI3_REG(base)                    ((base)->DCHPRI3)
#define DMA_DCHPRI2_REG(base)                    ((base)->DCHPRI2)
#define DMA_DCHPRI1_REG(base)                    ((base)->DCHPRI1)
#define DMA_DCHPRI0_REG(base)                    ((base)->DCHPRI0)
#define DMA_DCHPRI7_REG(base)                    ((base)->DCHPRI7)
#define DMA_DCHPRI6_REG(base)                    ((base)->DCHPRI6)
#define DMA_DCHPRI5_REG(base)                    ((base)->DCHPRI5)
#define DMA_DCHPRI4_REG(base)                    ((base)->DCHPRI4)
#define DMA_DCHPRI11_REG(base)                   ((base)->DCHPRI11)
#define DMA_DCHPRI10_REG(base)                   ((base)->DCHPRI10)
#define DMA_DCHPRI9_REG(base)                    ((base)->DCHPRI9)
#define DMA_DCHPRI8_REG(base)                    ((base)->DCHPRI8)
#define DMA_DCHPRI15_REG(base)                   ((base)->DCHPRI15)
#define DMA_DCHPRI14_REG(base)                   ((base)->DCHPRI14)
#define DMA_DCHPRI13_REG(base)                   ((base)->DCHPRI13)
#define DMA_DCHPRI12_REG(base)                   ((base)->DCHPRI12)
#define DMA_DCHPRI19_REG(base)                   ((base)->DCHPRI19)
#define DMA_DCHPRI18_REG(base)                   ((base)->DCHPRI18)
#define DMA_DCHPRI17_REG(base)                   ((base)->DCHPRI17)
#define DMA_DCHPRI16_REG(base)                   ((base)->DCHPRI16)
#define DMA_DCHPRI23_REG(base)                   ((base)->DCHPRI23)
#define DMA_DCHPRI22_REG(base)                   ((base)->DCHPRI22)
#define DMA_DCHPRI21_REG(base)                   ((base)->DCHPRI21)
#define DMA_DCHPRI20_REG(base)                   ((base)->DCHPRI20)
#define DMA_DCHPRI27_REG(base)                   ((base)->DCHPRI27)
#define DMA_DCHPRI26_REG(base)                   ((base)->DCHPRI26)
#define DMA_DCHPRI25_REG(base)                   ((base)->DCHPRI25)
#define DMA_DCHPRI24_REG(base)                   ((base)->DCHPRI24)
#define DMA_DCHPRI31_REG(base)                   ((base)->DCHPRI31)
#define DMA_DCHPRI30_REG(base)                   ((base)->DCHPRI30)
#define DMA_DCHPRI29_REG(base)                   ((base)->DCHPRI29)
#define DMA_DCHPRI28_REG(base)                   ((base)->DCHPRI28)
#define DMA_SADDR_REG(base,index)                ((base)->TCD[index].SADDR)
#define DMA_SADDR_COUNT                          32
#define DMA_SOFF_REG(base,index)                 ((base)->TCD[index].SOFF)
#define DMA_SOFF_COUNT                           32
#define DMA_ATTR_REG(base,index)                 ((base)->TCD[index].ATTR)
#define DMA_ATTR_COUNT                           32
#define DMA_NBYTES_MLNO_REG(base,index)          ((base)->TCD[index].NBYTES_MLNO)
#define DMA_NBYTES_MLNO_COUNT                    32
#define DMA_NBYTES_MLOFFNO_REG(base,index)       ((base)->TCD[index].NBYTES_MLOFFNO)
#define DMA_NBYTES_MLOFFNO_COUNT                 32
#define DMA_NBYTES_MLOFFYES_REG(base,index)      ((base)->TCD[index].NBYTES_MLOFFYES)
#define DMA_NBYTES_MLOFFYES_COUNT                32
#define DMA_SLAST_REG(base,index)                ((base)->TCD[index].SLAST)
#define DMA_SLAST_COUNT                          32
#define DMA_DADDR_REG(base,index)                ((base)->TCD[index].DADDR)
#define DMA_DADDR_COUNT                          32
#define DMA_DOFF_REG(base,index)                 ((base)->TCD[index].DOFF)
#define DMA_DOFF_COUNT                           32
#define DMA_CITER_ELINKNO_REG(base,index)        ((base)->TCD[index].CITER_ELINKNO)
#define DMA_CITER_ELINKNO_COUNT                  32
#define DMA_CITER_ELINKYES_REG(base,index)       ((base)->TCD[index].CITER_ELINKYES)
#define DMA_CITER_ELINKYES_COUNT                 32
#define DMA_DLAST_SGA_REG(base,index)            ((base)->TCD[index].DLAST_SGA)
#define DMA_DLAST_SGA_COUNT                      32
#define DMA_CSR_REG(base,index)                  ((base)->TCD[index].CSR)
#define DMA_CSR_COUNT                            32
#define DMA_BITER_ELINKNO_REG(base,index)        ((base)->TCD[index].BITER_ELINKNO)
#define DMA_BITER_ELINKNO_COUNT                  32
#define DMA_BITER_ELINKYES_REG(base,index)       ((base)->TCD[index].BITER_ELINKYES)
#define DMA_BITER_ELINKYES_COUNT                 32

/*!
 * @}
 */ /* end of group DMA_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/* CR Bit Fields */
#define DMA_CR_EDBG_MASK                         0x2u
#define DMA_CR_EDBG_SHIFT                        1
#define DMA_CR_EDBG_WIDTH                        1
#define DMA_CR_EDBG(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_EDBG_SHIFT))&DMA_CR_EDBG_MASK)
#define DMA_CR_ERCA_MASK                         0x4u
#define DMA_CR_ERCA_SHIFT                        2
#define DMA_CR_ERCA_WIDTH                        1
#define DMA_CR_ERCA(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_ERCA_SHIFT))&DMA_CR_ERCA_MASK)
#define DMA_CR_ERGA_MASK                         0x8u
#define DMA_CR_ERGA_SHIFT                        3
#define DMA_CR_ERGA_WIDTH                        1
#define DMA_CR_ERGA(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_ERGA_SHIFT))&DMA_CR_ERGA_MASK)
#define DMA_CR_HOE_MASK                          0x10u
#define DMA_CR_HOE_SHIFT                         4
#define DMA_CR_HOE_WIDTH                         1
#define DMA_CR_HOE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_CR_HOE_SHIFT))&DMA_CR_HOE_MASK)
#define DMA_CR_HALT_MASK                         0x20u
#define DMA_CR_HALT_SHIFT                        5
#define DMA_CR_HALT_WIDTH                        1
#define DMA_CR_HALT(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_HALT_SHIFT))&DMA_CR_HALT_MASK)
#define DMA_CR_CLM_MASK                          0x40u
#define DMA_CR_CLM_SHIFT                         6
#define DMA_CR_CLM_WIDTH                         1
#define DMA_CR_CLM(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_CR_CLM_SHIFT))&DMA_CR_CLM_MASK)
#define DMA_CR_EMLM_MASK                         0x80u
#define DMA_CR_EMLM_SHIFT                        7
#define DMA_CR_EMLM_WIDTH                        1
#define DMA_CR_EMLM(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_EMLM_SHIFT))&DMA_CR_EMLM_MASK)
#define DMA_CR_GRP0PRI_MASK                      0x100u
#define DMA_CR_GRP0PRI_SHIFT                     8
#define DMA_CR_GRP0PRI_WIDTH                     1
#define DMA_CR_GRP0PRI(x)                        (((uint32_t)(((uint32_t)(x))<<DMA_CR_GRP0PRI_SHIFT))&DMA_CR_GRP0PRI_MASK)
#define DMA_CR_GRP1PRI_MASK                      0x400u
#define DMA_CR_GRP1PRI_SHIFT                     10
#define DMA_CR_GRP1PRI_WIDTH                     1
#define DMA_CR_GRP1PRI(x)                        (((uint32_t)(((uint32_t)(x))<<DMA_CR_GRP1PRI_SHIFT))&DMA_CR_GRP1PRI_MASK)
#define DMA_CR_ECX_MASK                          0x10000u
#define DMA_CR_ECX_SHIFT                         16
#define DMA_CR_ECX_WIDTH                         1
#define DMA_CR_ECX(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_CR_ECX_SHIFT))&DMA_CR_ECX_MASK)
#define DMA_CR_CX_MASK                           0x20000u
#define DMA_CR_CX_SHIFT                          17
#define DMA_CR_CX_WIDTH                          1
#define DMA_CR_CX(x)                             (((uint32_t)(((uint32_t)(x))<<DMA_CR_CX_SHIFT))&DMA_CR_CX_MASK)
/* ES Bit Fields */
#define DMA_ES_DBE_MASK                          0x1u
#define DMA_ES_DBE_SHIFT                         0
#define DMA_ES_DBE_WIDTH                         1
#define DMA_ES_DBE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_DBE_SHIFT))&DMA_ES_DBE_MASK)
#define DMA_ES_SBE_MASK                          0x2u
#define DMA_ES_SBE_SHIFT                         1
#define DMA_ES_SBE_WIDTH                         1
#define DMA_ES_SBE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SBE_SHIFT))&DMA_ES_SBE_MASK)
#define DMA_ES_SGE_MASK                          0x4u
#define DMA_ES_SGE_SHIFT                         2
#define DMA_ES_SGE_WIDTH                         1
#define DMA_ES_SGE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SGE_SHIFT))&DMA_ES_SGE_MASK)
#define DMA_ES_NCE_MASK                          0x8u
#define DMA_ES_NCE_SHIFT                         3
#define DMA_ES_NCE_WIDTH                         1
#define DMA_ES_NCE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_NCE_SHIFT))&DMA_ES_NCE_MASK)
#define DMA_ES_DOE_MASK                          0x10u
#define DMA_ES_DOE_SHIFT                         4
#define DMA_ES_DOE_WIDTH                         1
#define DMA_ES_DOE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_DOE_SHIFT))&DMA_ES_DOE_MASK)
#define DMA_ES_DAE_MASK                          0x20u
#define DMA_ES_DAE_SHIFT                         5
#define DMA_ES_DAE_WIDTH                         1
#define DMA_ES_DAE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_DAE_SHIFT))&DMA_ES_DAE_MASK)
#define DMA_ES_SOE_MASK                          0x40u
#define DMA_ES_SOE_SHIFT                         6
#define DMA_ES_SOE_WIDTH                         1
#define DMA_ES_SOE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SOE_SHIFT))&DMA_ES_SOE_MASK)
#define DMA_ES_SAE_MASK                          0x80u
#define DMA_ES_SAE_SHIFT                         7
#define DMA_ES_SAE_WIDTH                         1
#define DMA_ES_SAE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SAE_SHIFT))&DMA_ES_SAE_MASK)
#define DMA_ES_ERRCHN_MASK                       0x1F00u
#define DMA_ES_ERRCHN_SHIFT                      8
#define DMA_ES_ERRCHN_WIDTH                      5
#define DMA_ES_ERRCHN(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ES_ERRCHN_SHIFT))&DMA_ES_ERRCHN_MASK)
#define DMA_ES_CPE_MASK                          0x4000u
#define DMA_ES_CPE_SHIFT                         14
#define DMA_ES_CPE_WIDTH                         1
#define DMA_ES_CPE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_CPE_SHIFT))&DMA_ES_CPE_MASK)
#define DMA_ES_GPE_MASK                          0x8000u
#define DMA_ES_GPE_SHIFT                         15
#define DMA_ES_GPE_WIDTH                         1
#define DMA_ES_GPE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_GPE_SHIFT))&DMA_ES_GPE_MASK)
#define DMA_ES_ECX_MASK                          0x10000u
#define DMA_ES_ECX_SHIFT                         16
#define DMA_ES_ECX_WIDTH                         1
#define DMA_ES_ECX(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_ECX_SHIFT))&DMA_ES_ECX_MASK)
#define DMA_ES_VLD_MASK                          0x80000000u
#define DMA_ES_VLD_SHIFT                         31
#define DMA_ES_VLD_WIDTH                         1
#define DMA_ES_VLD(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_VLD_SHIFT))&DMA_ES_VLD_MASK)
/* ERQ Bit Fields */
#define DMA_ERQ_ERQ0_MASK                        0x1u
#define DMA_ERQ_ERQ0_SHIFT                       0
#define DMA_ERQ_ERQ0_WIDTH                       1
#define DMA_ERQ_ERQ0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ0_SHIFT))&DMA_ERQ_ERQ0_MASK)
#define DMA_ERQ_ERQ1_MASK                        0x2u
#define DMA_ERQ_ERQ1_SHIFT                       1
#define DMA_ERQ_ERQ1_WIDTH                       1
#define DMA_ERQ_ERQ1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ1_SHIFT))&DMA_ERQ_ERQ1_MASK)
#define DMA_ERQ_ERQ2_MASK                        0x4u
#define DMA_ERQ_ERQ2_SHIFT                       2
#define DMA_ERQ_ERQ2_WIDTH                       1
#define DMA_ERQ_ERQ2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ2_SHIFT))&DMA_ERQ_ERQ2_MASK)
#define DMA_ERQ_ERQ3_MASK                        0x8u
#define DMA_ERQ_ERQ3_SHIFT                       3
#define DMA_ERQ_ERQ3_WIDTH                       1
#define DMA_ERQ_ERQ3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ3_SHIFT))&DMA_ERQ_ERQ3_MASK)
#define DMA_ERQ_ERQ4_MASK                        0x10u
#define DMA_ERQ_ERQ4_SHIFT                       4
#define DMA_ERQ_ERQ4_WIDTH                       1
#define DMA_ERQ_ERQ4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ4_SHIFT))&DMA_ERQ_ERQ4_MASK)
#define DMA_ERQ_ERQ5_MASK                        0x20u
#define DMA_ERQ_ERQ5_SHIFT                       5
#define DMA_ERQ_ERQ5_WIDTH                       1
#define DMA_ERQ_ERQ5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ5_SHIFT))&DMA_ERQ_ERQ5_MASK)
#define DMA_ERQ_ERQ6_MASK                        0x40u
#define DMA_ERQ_ERQ6_SHIFT                       6
#define DMA_ERQ_ERQ6_WIDTH                       1
#define DMA_ERQ_ERQ6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ6_SHIFT))&DMA_ERQ_ERQ6_MASK)
#define DMA_ERQ_ERQ7_MASK                        0x80u
#define DMA_ERQ_ERQ7_SHIFT                       7
#define DMA_ERQ_ERQ7_WIDTH                       1
#define DMA_ERQ_ERQ7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ7_SHIFT))&DMA_ERQ_ERQ7_MASK)
#define DMA_ERQ_ERQ8_MASK                        0x100u
#define DMA_ERQ_ERQ8_SHIFT                       8
#define DMA_ERQ_ERQ8_WIDTH                       1
#define DMA_ERQ_ERQ8(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ8_SHIFT))&DMA_ERQ_ERQ8_MASK)
#define DMA_ERQ_ERQ9_MASK                        0x200u
#define DMA_ERQ_ERQ9_SHIFT                       9
#define DMA_ERQ_ERQ9_WIDTH                       1
#define DMA_ERQ_ERQ9(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ9_SHIFT))&DMA_ERQ_ERQ9_MASK)
#define DMA_ERQ_ERQ10_MASK                       0x400u
#define DMA_ERQ_ERQ10_SHIFT                      10
#define DMA_ERQ_ERQ10_WIDTH                      1
#define DMA_ERQ_ERQ10(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ10_SHIFT))&DMA_ERQ_ERQ10_MASK)
#define DMA_ERQ_ERQ11_MASK                       0x800u
#define DMA_ERQ_ERQ11_SHIFT                      11
#define DMA_ERQ_ERQ11_WIDTH                      1
#define DMA_ERQ_ERQ11(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ11_SHIFT))&DMA_ERQ_ERQ11_MASK)
#define DMA_ERQ_ERQ12_MASK                       0x1000u
#define DMA_ERQ_ERQ12_SHIFT                      12
#define DMA_ERQ_ERQ12_WIDTH                      1
#define DMA_ERQ_ERQ12(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ12_SHIFT))&DMA_ERQ_ERQ12_MASK)
#define DMA_ERQ_ERQ13_MASK                       0x2000u
#define DMA_ERQ_ERQ13_SHIFT                      13
#define DMA_ERQ_ERQ13_WIDTH                      1
#define DMA_ERQ_ERQ13(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ13_SHIFT))&DMA_ERQ_ERQ13_MASK)
#define DMA_ERQ_ERQ14_MASK                       0x4000u
#define DMA_ERQ_ERQ14_SHIFT                      14
#define DMA_ERQ_ERQ14_WIDTH                      1
#define DMA_ERQ_ERQ14(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ14_SHIFT))&DMA_ERQ_ERQ14_MASK)
#define DMA_ERQ_ERQ15_MASK                       0x8000u
#define DMA_ERQ_ERQ15_SHIFT                      15
#define DMA_ERQ_ERQ15_WIDTH                      1
#define DMA_ERQ_ERQ15(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ15_SHIFT))&DMA_ERQ_ERQ15_MASK)
#define DMA_ERQ_ERQ16_MASK                       0x10000u
#define DMA_ERQ_ERQ16_SHIFT                      16
#define DMA_ERQ_ERQ16_WIDTH                      1
#define DMA_ERQ_ERQ16(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ16_SHIFT))&DMA_ERQ_ERQ16_MASK)
#define DMA_ERQ_ERQ17_MASK                       0x20000u
#define DMA_ERQ_ERQ17_SHIFT                      17
#define DMA_ERQ_ERQ17_WIDTH                      1
#define DMA_ERQ_ERQ17(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ17_SHIFT))&DMA_ERQ_ERQ17_MASK)
#define DMA_ERQ_ERQ18_MASK                       0x40000u
#define DMA_ERQ_ERQ18_SHIFT                      18
#define DMA_ERQ_ERQ18_WIDTH                      1
#define DMA_ERQ_ERQ18(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ18_SHIFT))&DMA_ERQ_ERQ18_MASK)
#define DMA_ERQ_ERQ19_MASK                       0x80000u
#define DMA_ERQ_ERQ19_SHIFT                      19
#define DMA_ERQ_ERQ19_WIDTH                      1
#define DMA_ERQ_ERQ19(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ19_SHIFT))&DMA_ERQ_ERQ19_MASK)
#define DMA_ERQ_ERQ20_MASK                       0x100000u
#define DMA_ERQ_ERQ20_SHIFT                      20
#define DMA_ERQ_ERQ20_WIDTH                      1
#define DMA_ERQ_ERQ20(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ20_SHIFT))&DMA_ERQ_ERQ20_MASK)
#define DMA_ERQ_ERQ21_MASK                       0x200000u
#define DMA_ERQ_ERQ21_SHIFT                      21
#define DMA_ERQ_ERQ21_WIDTH                      1
#define DMA_ERQ_ERQ21(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ21_SHIFT))&DMA_ERQ_ERQ21_MASK)
#define DMA_ERQ_ERQ22_MASK                       0x400000u
#define DMA_ERQ_ERQ22_SHIFT                      22
#define DMA_ERQ_ERQ22_WIDTH                      1
#define DMA_ERQ_ERQ22(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ22_SHIFT))&DMA_ERQ_ERQ22_MASK)
#define DMA_ERQ_ERQ23_MASK                       0x800000u
#define DMA_ERQ_ERQ23_SHIFT                      23
#define DMA_ERQ_ERQ23_WIDTH                      1
#define DMA_ERQ_ERQ23(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ23_SHIFT))&DMA_ERQ_ERQ23_MASK)
#define DMA_ERQ_ERQ24_MASK                       0x1000000u
#define DMA_ERQ_ERQ24_SHIFT                      24
#define DMA_ERQ_ERQ24_WIDTH                      1
#define DMA_ERQ_ERQ24(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ24_SHIFT))&DMA_ERQ_ERQ24_MASK)
#define DMA_ERQ_ERQ25_MASK                       0x2000000u
#define DMA_ERQ_ERQ25_SHIFT                      25
#define DMA_ERQ_ERQ25_WIDTH                      1
#define DMA_ERQ_ERQ25(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ25_SHIFT))&DMA_ERQ_ERQ25_MASK)
#define DMA_ERQ_ERQ26_MASK                       0x4000000u
#define DMA_ERQ_ERQ26_SHIFT                      26
#define DMA_ERQ_ERQ26_WIDTH                      1
#define DMA_ERQ_ERQ26(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ26_SHIFT))&DMA_ERQ_ERQ26_MASK)
#define DMA_ERQ_ERQ27_MASK                       0x8000000u
#define DMA_ERQ_ERQ27_SHIFT                      27
#define DMA_ERQ_ERQ27_WIDTH                      1
#define DMA_ERQ_ERQ27(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ27_SHIFT))&DMA_ERQ_ERQ27_MASK)
#define DMA_ERQ_ERQ28_MASK                       0x10000000u
#define DMA_ERQ_ERQ28_SHIFT                      28
#define DMA_ERQ_ERQ28_WIDTH                      1
#define DMA_ERQ_ERQ28(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ28_SHIFT))&DMA_ERQ_ERQ28_MASK)
#define DMA_ERQ_ERQ29_MASK                       0x20000000u
#define DMA_ERQ_ERQ29_SHIFT                      29
#define DMA_ERQ_ERQ29_WIDTH                      1
#define DMA_ERQ_ERQ29(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ29_SHIFT))&DMA_ERQ_ERQ29_MASK)
#define DMA_ERQ_ERQ30_MASK                       0x40000000u
#define DMA_ERQ_ERQ30_SHIFT                      30
#define DMA_ERQ_ERQ30_WIDTH                      1
#define DMA_ERQ_ERQ30(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ30_SHIFT))&DMA_ERQ_ERQ30_MASK)
#define DMA_ERQ_ERQ31_MASK                       0x80000000u
#define DMA_ERQ_ERQ31_SHIFT                      31
#define DMA_ERQ_ERQ31_WIDTH                      1
#define DMA_ERQ_ERQ31(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ31_SHIFT))&DMA_ERQ_ERQ31_MASK)
/* EEI Bit Fields */
#define DMA_EEI_EEI0_MASK                        0x1u
#define DMA_EEI_EEI0_SHIFT                       0
#define DMA_EEI_EEI0_WIDTH                       1
#define DMA_EEI_EEI0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI0_SHIFT))&DMA_EEI_EEI0_MASK)
#define DMA_EEI_EEI1_MASK                        0x2u
#define DMA_EEI_EEI1_SHIFT                       1
#define DMA_EEI_EEI1_WIDTH                       1
#define DMA_EEI_EEI1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI1_SHIFT))&DMA_EEI_EEI1_MASK)
#define DMA_EEI_EEI2_MASK                        0x4u
#define DMA_EEI_EEI2_SHIFT                       2
#define DMA_EEI_EEI2_WIDTH                       1
#define DMA_EEI_EEI2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI2_SHIFT))&DMA_EEI_EEI2_MASK)
#define DMA_EEI_EEI3_MASK                        0x8u
#define DMA_EEI_EEI3_SHIFT                       3
#define DMA_EEI_EEI3_WIDTH                       1
#define DMA_EEI_EEI3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI3_SHIFT))&DMA_EEI_EEI3_MASK)
#define DMA_EEI_EEI4_MASK                        0x10u
#define DMA_EEI_EEI4_SHIFT                       4
#define DMA_EEI_EEI4_WIDTH                       1
#define DMA_EEI_EEI4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI4_SHIFT))&DMA_EEI_EEI4_MASK)
#define DMA_EEI_EEI5_MASK                        0x20u
#define DMA_EEI_EEI5_SHIFT                       5
#define DMA_EEI_EEI5_WIDTH                       1
#define DMA_EEI_EEI5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI5_SHIFT))&DMA_EEI_EEI5_MASK)
#define DMA_EEI_EEI6_MASK                        0x40u
#define DMA_EEI_EEI6_SHIFT                       6
#define DMA_EEI_EEI6_WIDTH                       1
#define DMA_EEI_EEI6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI6_SHIFT))&DMA_EEI_EEI6_MASK)
#define DMA_EEI_EEI7_MASK                        0x80u
#define DMA_EEI_EEI7_SHIFT                       7
#define DMA_EEI_EEI7_WIDTH                       1
#define DMA_EEI_EEI7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI7_SHIFT))&DMA_EEI_EEI7_MASK)
#define DMA_EEI_EEI8_MASK                        0x100u
#define DMA_EEI_EEI8_SHIFT                       8
#define DMA_EEI_EEI8_WIDTH                       1
#define DMA_EEI_EEI8(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI8_SHIFT))&DMA_EEI_EEI8_MASK)
#define DMA_EEI_EEI9_MASK                        0x200u
#define DMA_EEI_EEI9_SHIFT                       9
#define DMA_EEI_EEI9_WIDTH                       1
#define DMA_EEI_EEI9(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI9_SHIFT))&DMA_EEI_EEI9_MASK)
#define DMA_EEI_EEI10_MASK                       0x400u
#define DMA_EEI_EEI10_SHIFT                      10
#define DMA_EEI_EEI10_WIDTH                      1
#define DMA_EEI_EEI10(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI10_SHIFT))&DMA_EEI_EEI10_MASK)
#define DMA_EEI_EEI11_MASK                       0x800u
#define DMA_EEI_EEI11_SHIFT                      11
#define DMA_EEI_EEI11_WIDTH                      1
#define DMA_EEI_EEI11(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI11_SHIFT))&DMA_EEI_EEI11_MASK)
#define DMA_EEI_EEI12_MASK                       0x1000u
#define DMA_EEI_EEI12_SHIFT                      12
#define DMA_EEI_EEI12_WIDTH                      1
#define DMA_EEI_EEI12(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI12_SHIFT))&DMA_EEI_EEI12_MASK)
#define DMA_EEI_EEI13_MASK                       0x2000u
#define DMA_EEI_EEI13_SHIFT                      13
#define DMA_EEI_EEI13_WIDTH                      1
#define DMA_EEI_EEI13(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI13_SHIFT))&DMA_EEI_EEI13_MASK)
#define DMA_EEI_EEI14_MASK                       0x4000u
#define DMA_EEI_EEI14_SHIFT                      14
#define DMA_EEI_EEI14_WIDTH                      1
#define DMA_EEI_EEI14(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI14_SHIFT))&DMA_EEI_EEI14_MASK)
#define DMA_EEI_EEI15_MASK                       0x8000u
#define DMA_EEI_EEI15_SHIFT                      15
#define DMA_EEI_EEI15_WIDTH                      1
#define DMA_EEI_EEI15(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI15_SHIFT))&DMA_EEI_EEI15_MASK)
#define DMA_EEI_EEI16_MASK                       0x10000u
#define DMA_EEI_EEI16_SHIFT                      16
#define DMA_EEI_EEI16_WIDTH                      1
#define DMA_EEI_EEI16(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI16_SHIFT))&DMA_EEI_EEI16_MASK)
#define DMA_EEI_EEI17_MASK                       0x20000u
#define DMA_EEI_EEI17_SHIFT                      17
#define DMA_EEI_EEI17_WIDTH                      1
#define DMA_EEI_EEI17(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI17_SHIFT))&DMA_EEI_EEI17_MASK)
#define DMA_EEI_EEI18_MASK                       0x40000u
#define DMA_EEI_EEI18_SHIFT                      18
#define DMA_EEI_EEI18_WIDTH                      1
#define DMA_EEI_EEI18(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI18_SHIFT))&DMA_EEI_EEI18_MASK)
#define DMA_EEI_EEI19_MASK                       0x80000u
#define DMA_EEI_EEI19_SHIFT                      19
#define DMA_EEI_EEI19_WIDTH                      1
#define DMA_EEI_EEI19(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI19_SHIFT))&DMA_EEI_EEI19_MASK)
#define DMA_EEI_EEI20_MASK                       0x100000u
#define DMA_EEI_EEI20_SHIFT                      20
#define DMA_EEI_EEI20_WIDTH                      1
#define DMA_EEI_EEI20(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI20_SHIFT))&DMA_EEI_EEI20_MASK)
#define DMA_EEI_EEI21_MASK                       0x200000u
#define DMA_EEI_EEI21_SHIFT                      21
#define DMA_EEI_EEI21_WIDTH                      1
#define DMA_EEI_EEI21(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI21_SHIFT))&DMA_EEI_EEI21_MASK)
#define DMA_EEI_EEI22_MASK                       0x400000u
#define DMA_EEI_EEI22_SHIFT                      22
#define DMA_EEI_EEI22_WIDTH                      1
#define DMA_EEI_EEI22(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI22_SHIFT))&DMA_EEI_EEI22_MASK)
#define DMA_EEI_EEI23_MASK                       0x800000u
#define DMA_EEI_EEI23_SHIFT                      23
#define DMA_EEI_EEI23_WIDTH                      1
#define DMA_EEI_EEI23(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI23_SHIFT))&DMA_EEI_EEI23_MASK)
#define DMA_EEI_EEI24_MASK                       0x1000000u
#define DMA_EEI_EEI24_SHIFT                      24
#define DMA_EEI_EEI24_WIDTH                      1
#define DMA_EEI_EEI24(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI24_SHIFT))&DMA_EEI_EEI24_MASK)
#define DMA_EEI_EEI25_MASK                       0x2000000u
#define DMA_EEI_EEI25_SHIFT                      25
#define DMA_EEI_EEI25_WIDTH                      1
#define DMA_EEI_EEI25(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI25_SHIFT))&DMA_EEI_EEI25_MASK)
#define DMA_EEI_EEI26_MASK                       0x4000000u
#define DMA_EEI_EEI26_SHIFT                      26
#define DMA_EEI_EEI26_WIDTH                      1
#define DMA_EEI_EEI26(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI26_SHIFT))&DMA_EEI_EEI26_MASK)
#define DMA_EEI_EEI27_MASK                       0x8000000u
#define DMA_EEI_EEI27_SHIFT                      27
#define DMA_EEI_EEI27_WIDTH                      1
#define DMA_EEI_EEI27(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI27_SHIFT))&DMA_EEI_EEI27_MASK)
#define DMA_EEI_EEI28_MASK                       0x10000000u
#define DMA_EEI_EEI28_SHIFT                      28
#define DMA_EEI_EEI28_WIDTH                      1
#define DMA_EEI_EEI28(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI28_SHIFT))&DMA_EEI_EEI28_MASK)
#define DMA_EEI_EEI29_MASK                       0x20000000u
#define DMA_EEI_EEI29_SHIFT                      29
#define DMA_EEI_EEI29_WIDTH                      1
#define DMA_EEI_EEI29(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI29_SHIFT))&DMA_EEI_EEI29_MASK)
#define DMA_EEI_EEI30_MASK                       0x40000000u
#define DMA_EEI_EEI30_SHIFT                      30
#define DMA_EEI_EEI30_WIDTH                      1
#define DMA_EEI_EEI30(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI30_SHIFT))&DMA_EEI_EEI30_MASK)
#define DMA_EEI_EEI31_MASK                       0x80000000u
#define DMA_EEI_EEI31_SHIFT                      31
#define DMA_EEI_EEI31_WIDTH                      1
#define DMA_EEI_EEI31(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI31_SHIFT))&DMA_EEI_EEI31_MASK)
/* CEEI Bit Fields */
#define DMA_CEEI_CEEI_MASK                       0x1Fu
#define DMA_CEEI_CEEI_SHIFT                      0
#define DMA_CEEI_CEEI_WIDTH                      5
#define DMA_CEEI_CEEI(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CEEI_CEEI_SHIFT))&DMA_CEEI_CEEI_MASK)
#define DMA_CEEI_CAEE_MASK                       0x40u
#define DMA_CEEI_CAEE_SHIFT                      6
#define DMA_CEEI_CAEE_WIDTH                      1
#define DMA_CEEI_CAEE(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CEEI_CAEE_SHIFT))&DMA_CEEI_CAEE_MASK)
#define DMA_CEEI_NOP_MASK                        0x80u
#define DMA_CEEI_NOP_SHIFT                       7
#define DMA_CEEI_NOP_WIDTH                       1
#define DMA_CEEI_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CEEI_NOP_SHIFT))&DMA_CEEI_NOP_MASK)
/* SEEI Bit Fields */
#define DMA_SEEI_SEEI_MASK                       0x1Fu
#define DMA_SEEI_SEEI_SHIFT                      0
#define DMA_SEEI_SEEI_WIDTH                      5
#define DMA_SEEI_SEEI(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SEEI_SEEI_SHIFT))&DMA_SEEI_SEEI_MASK)
#define DMA_SEEI_SAEE_MASK                       0x40u
#define DMA_SEEI_SAEE_SHIFT                      6
#define DMA_SEEI_SAEE_WIDTH                      1
#define DMA_SEEI_SAEE(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SEEI_SAEE_SHIFT))&DMA_SEEI_SAEE_MASK)
#define DMA_SEEI_NOP_MASK                        0x80u
#define DMA_SEEI_NOP_SHIFT                       7
#define DMA_SEEI_NOP_WIDTH                       1
#define DMA_SEEI_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_SEEI_NOP_SHIFT))&DMA_SEEI_NOP_MASK)
/* CERQ Bit Fields */
#define DMA_CERQ_CERQ_MASK                       0x1Fu
#define DMA_CERQ_CERQ_SHIFT                      0
#define DMA_CERQ_CERQ_WIDTH                      5
#define DMA_CERQ_CERQ(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERQ_CERQ_SHIFT))&DMA_CERQ_CERQ_MASK)
#define DMA_CERQ_CAER_MASK                       0x40u
#define DMA_CERQ_CAER_SHIFT                      6
#define DMA_CERQ_CAER_WIDTH                      1
#define DMA_CERQ_CAER(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERQ_CAER_SHIFT))&DMA_CERQ_CAER_MASK)
#define DMA_CERQ_NOP_MASK                        0x80u
#define DMA_CERQ_NOP_SHIFT                       7
#define DMA_CERQ_NOP_WIDTH                       1
#define DMA_CERQ_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CERQ_NOP_SHIFT))&DMA_CERQ_NOP_MASK)
/* SERQ Bit Fields */
#define DMA_SERQ_SERQ_MASK                       0x1Fu
#define DMA_SERQ_SERQ_SHIFT                      0
#define DMA_SERQ_SERQ_WIDTH                      5
#define DMA_SERQ_SERQ(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SERQ_SERQ_SHIFT))&DMA_SERQ_SERQ_MASK)
#define DMA_SERQ_SAER_MASK                       0x40u
#define DMA_SERQ_SAER_SHIFT                      6
#define DMA_SERQ_SAER_WIDTH                      1
#define DMA_SERQ_SAER(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SERQ_SAER_SHIFT))&DMA_SERQ_SAER_MASK)
#define DMA_SERQ_NOP_MASK                        0x80u
#define DMA_SERQ_NOP_SHIFT                       7
#define DMA_SERQ_NOP_WIDTH                       1
#define DMA_SERQ_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_SERQ_NOP_SHIFT))&DMA_SERQ_NOP_MASK)
/* CDNE Bit Fields */
#define DMA_CDNE_CDNE_MASK                       0x1Fu
#define DMA_CDNE_CDNE_SHIFT                      0
#define DMA_CDNE_CDNE_WIDTH                      5
#define DMA_CDNE_CDNE(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CDNE_CDNE_SHIFT))&DMA_CDNE_CDNE_MASK)
#define DMA_CDNE_CADN_MASK                       0x40u
#define DMA_CDNE_CADN_SHIFT                      6
#define DMA_CDNE_CADN_WIDTH                      1
#define DMA_CDNE_CADN(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CDNE_CADN_SHIFT))&DMA_CDNE_CADN_MASK)
#define DMA_CDNE_NOP_MASK                        0x80u
#define DMA_CDNE_NOP_SHIFT                       7
#define DMA_CDNE_NOP_WIDTH                       1
#define DMA_CDNE_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CDNE_NOP_SHIFT))&DMA_CDNE_NOP_MASK)
/* SSRT Bit Fields */
#define DMA_SSRT_SSRT_MASK                       0x1Fu
#define DMA_SSRT_SSRT_SHIFT                      0
#define DMA_SSRT_SSRT_WIDTH                      5
#define DMA_SSRT_SSRT(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SSRT_SSRT_SHIFT))&DMA_SSRT_SSRT_MASK)
#define DMA_SSRT_SAST_MASK                       0x40u
#define DMA_SSRT_SAST_SHIFT                      6
#define DMA_SSRT_SAST_WIDTH                      1
#define DMA_SSRT_SAST(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SSRT_SAST_SHIFT))&DMA_SSRT_SAST_MASK)
#define DMA_SSRT_NOP_MASK                        0x80u
#define DMA_SSRT_NOP_SHIFT                       7
#define DMA_SSRT_NOP_WIDTH                       1
#define DMA_SSRT_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_SSRT_NOP_SHIFT))&DMA_SSRT_NOP_MASK)
/* CERR Bit Fields */
#define DMA_CERR_CERR_MASK                       0x1Fu
#define DMA_CERR_CERR_SHIFT                      0
#define DMA_CERR_CERR_WIDTH                      5
#define DMA_CERR_CERR(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERR_CERR_SHIFT))&DMA_CERR_CERR_MASK)
#define DMA_CERR_CAEI_MASK                       0x40u
#define DMA_CERR_CAEI_SHIFT                      6
#define DMA_CERR_CAEI_WIDTH                      1
#define DMA_CERR_CAEI(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERR_CAEI_SHIFT))&DMA_CERR_CAEI_MASK)
#define DMA_CERR_NOP_MASK                        0x80u
#define DMA_CERR_NOP_SHIFT                       7
#define DMA_CERR_NOP_WIDTH                       1
#define DMA_CERR_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CERR_NOP_SHIFT))&DMA_CERR_NOP_MASK)
/* CINT Bit Fields */
#define DMA_CINT_CINT_MASK                       0x1Fu
#define DMA_CINT_CINT_SHIFT                      0
#define DMA_CINT_CINT_WIDTH                      5
#define DMA_CINT_CINT(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CINT_CINT_SHIFT))&DMA_CINT_CINT_MASK)
#define DMA_CINT_CAIR_MASK                       0x40u
#define DMA_CINT_CAIR_SHIFT                      6
#define DMA_CINT_CAIR_WIDTH                      1
#define DMA_CINT_CAIR(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CINT_CAIR_SHIFT))&DMA_CINT_CAIR_MASK)
#define DMA_CINT_NOP_MASK                        0x80u
#define DMA_CINT_NOP_SHIFT                       7
#define DMA_CINT_NOP_WIDTH                       1
#define DMA_CINT_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CINT_NOP_SHIFT))&DMA_CINT_NOP_MASK)
/* INT Bit Fields */
#define DMA_INT_INT0_MASK                        0x1u
#define DMA_INT_INT0_SHIFT                       0
#define DMA_INT_INT0_WIDTH                       1
#define DMA_INT_INT0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT0_SHIFT))&DMA_INT_INT0_MASK)
#define DMA_INT_INT1_MASK                        0x2u
#define DMA_INT_INT1_SHIFT                       1
#define DMA_INT_INT1_WIDTH                       1
#define DMA_INT_INT1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT1_SHIFT))&DMA_INT_INT1_MASK)
#define DMA_INT_INT2_MASK                        0x4u
#define DMA_INT_INT2_SHIFT                       2
#define DMA_INT_INT2_WIDTH                       1
#define DMA_INT_INT2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT2_SHIFT))&DMA_INT_INT2_MASK)
#define DMA_INT_INT3_MASK                        0x8u
#define DMA_INT_INT3_SHIFT                       3
#define DMA_INT_INT3_WIDTH                       1
#define DMA_INT_INT3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT3_SHIFT))&DMA_INT_INT3_MASK)
#define DMA_INT_INT4_MASK                        0x10u
#define DMA_INT_INT4_SHIFT                       4
#define DMA_INT_INT4_WIDTH                       1
#define DMA_INT_INT4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT4_SHIFT))&DMA_INT_INT4_MASK)
#define DMA_INT_INT5_MASK                        0x20u
#define DMA_INT_INT5_SHIFT                       5
#define DMA_INT_INT5_WIDTH                       1
#define DMA_INT_INT5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT5_SHIFT))&DMA_INT_INT5_MASK)
#define DMA_INT_INT6_MASK                        0x40u
#define DMA_INT_INT6_SHIFT                       6
#define DMA_INT_INT6_WIDTH                       1
#define DMA_INT_INT6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT6_SHIFT))&DMA_INT_INT6_MASK)
#define DMA_INT_INT7_MASK                        0x80u
#define DMA_INT_INT7_SHIFT                       7
#define DMA_INT_INT7_WIDTH                       1
#define DMA_INT_INT7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT7_SHIFT))&DMA_INT_INT7_MASK)
#define DMA_INT_INT8_MASK                        0x100u
#define DMA_INT_INT8_SHIFT                       8
#define DMA_INT_INT8_WIDTH                       1
#define DMA_INT_INT8(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT8_SHIFT))&DMA_INT_INT8_MASK)
#define DMA_INT_INT9_MASK                        0x200u
#define DMA_INT_INT9_SHIFT                       9
#define DMA_INT_INT9_WIDTH                       1
#define DMA_INT_INT9(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT9_SHIFT))&DMA_INT_INT9_MASK)
#define DMA_INT_INT10_MASK                       0x400u
#define DMA_INT_INT10_SHIFT                      10
#define DMA_INT_INT10_WIDTH                      1
#define DMA_INT_INT10(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT10_SHIFT))&DMA_INT_INT10_MASK)
#define DMA_INT_INT11_MASK                       0x800u
#define DMA_INT_INT11_SHIFT                      11
#define DMA_INT_INT11_WIDTH                      1
#define DMA_INT_INT11(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT11_SHIFT))&DMA_INT_INT11_MASK)
#define DMA_INT_INT12_MASK                       0x1000u
#define DMA_INT_INT12_SHIFT                      12
#define DMA_INT_INT12_WIDTH                      1
#define DMA_INT_INT12(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT12_SHIFT))&DMA_INT_INT12_MASK)
#define DMA_INT_INT13_MASK                       0x2000u
#define DMA_INT_INT13_SHIFT                      13
#define DMA_INT_INT13_WIDTH                      1
#define DMA_INT_INT13(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT13_SHIFT))&DMA_INT_INT13_MASK)
#define DMA_INT_INT14_MASK                       0x4000u
#define DMA_INT_INT14_SHIFT                      14
#define DMA_INT_INT14_WIDTH                      1
#define DMA_INT_INT14(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT14_SHIFT))&DMA_INT_INT14_MASK)
#define DMA_INT_INT15_MASK                       0x8000u
#define DMA_INT_INT15_SHIFT                      15
#define DMA_INT_INT15_WIDTH                      1
#define DMA_INT_INT15(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT15_SHIFT))&DMA_INT_INT15_MASK)
#define DMA_INT_INT16_MASK                       0x10000u
#define DMA_INT_INT16_SHIFT                      16
#define DMA_INT_INT16_WIDTH                      1
#define DMA_INT_INT16(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT16_SHIFT))&DMA_INT_INT16_MASK)
#define DMA_INT_INT17_MASK                       0x20000u
#define DMA_INT_INT17_SHIFT                      17
#define DMA_INT_INT17_WIDTH                      1
#define DMA_INT_INT17(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT17_SHIFT))&DMA_INT_INT17_MASK)
#define DMA_INT_INT18_MASK                       0x40000u
#define DMA_INT_INT18_SHIFT                      18
#define DMA_INT_INT18_WIDTH                      1
#define DMA_INT_INT18(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT18_SHIFT))&DMA_INT_INT18_MASK)
#define DMA_INT_INT19_MASK                       0x80000u
#define DMA_INT_INT19_SHIFT                      19
#define DMA_INT_INT19_WIDTH                      1
#define DMA_INT_INT19(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT19_SHIFT))&DMA_INT_INT19_MASK)
#define DMA_INT_INT20_MASK                       0x100000u
#define DMA_INT_INT20_SHIFT                      20
#define DMA_INT_INT20_WIDTH                      1
#define DMA_INT_INT20(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT20_SHIFT))&DMA_INT_INT20_MASK)
#define DMA_INT_INT21_MASK                       0x200000u
#define DMA_INT_INT21_SHIFT                      21
#define DMA_INT_INT21_WIDTH                      1
#define DMA_INT_INT21(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT21_SHIFT))&DMA_INT_INT21_MASK)
#define DMA_INT_INT22_MASK                       0x400000u
#define DMA_INT_INT22_SHIFT                      22
#define DMA_INT_INT22_WIDTH                      1
#define DMA_INT_INT22(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT22_SHIFT))&DMA_INT_INT22_MASK)
#define DMA_INT_INT23_MASK                       0x800000u
#define DMA_INT_INT23_SHIFT                      23
#define DMA_INT_INT23_WIDTH                      1
#define DMA_INT_INT23(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT23_SHIFT))&DMA_INT_INT23_MASK)
#define DMA_INT_INT24_MASK                       0x1000000u
#define DMA_INT_INT24_SHIFT                      24
#define DMA_INT_INT24_WIDTH                      1
#define DMA_INT_INT24(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT24_SHIFT))&DMA_INT_INT24_MASK)
#define DMA_INT_INT25_MASK                       0x2000000u
#define DMA_INT_INT25_SHIFT                      25
#define DMA_INT_INT25_WIDTH                      1
#define DMA_INT_INT25(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT25_SHIFT))&DMA_INT_INT25_MASK)
#define DMA_INT_INT26_MASK                       0x4000000u
#define DMA_INT_INT26_SHIFT                      26
#define DMA_INT_INT26_WIDTH                      1
#define DMA_INT_INT26(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT26_SHIFT))&DMA_INT_INT26_MASK)
#define DMA_INT_INT27_MASK                       0x8000000u
#define DMA_INT_INT27_SHIFT                      27
#define DMA_INT_INT27_WIDTH                      1
#define DMA_INT_INT27(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT27_SHIFT))&DMA_INT_INT27_MASK)
#define DMA_INT_INT28_MASK                       0x10000000u
#define DMA_INT_INT28_SHIFT                      28
#define DMA_INT_INT28_WIDTH                      1
#define DMA_INT_INT28(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT28_SHIFT))&DMA_INT_INT28_MASK)
#define DMA_INT_INT29_MASK                       0x20000000u
#define DMA_INT_INT29_SHIFT                      29
#define DMA_INT_INT29_WIDTH                      1
#define DMA_INT_INT29(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT29_SHIFT))&DMA_INT_INT29_MASK)
#define DMA_INT_INT30_MASK                       0x40000000u
#define DMA_INT_INT30_SHIFT                      30
#define DMA_INT_INT30_WIDTH                      1
#define DMA_INT_INT30(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT30_SHIFT))&DMA_INT_INT30_MASK)
#define DMA_INT_INT31_MASK                       0x80000000u
#define DMA_INT_INT31_SHIFT                      31
#define DMA_INT_INT31_WIDTH                      1
#define DMA_INT_INT31(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT31_SHIFT))&DMA_INT_INT31_MASK)
/* ERR Bit Fields */
#define DMA_ERR_ERR0_MASK                        0x1u
#define DMA_ERR_ERR0_SHIFT                       0
#define DMA_ERR_ERR0_WIDTH                       1
#define DMA_ERR_ERR0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR0_SHIFT))&DMA_ERR_ERR0_MASK)
#define DMA_ERR_ERR1_MASK                        0x2u
#define DMA_ERR_ERR1_SHIFT                       1
#define DMA_ERR_ERR1_WIDTH                       1
#define DMA_ERR_ERR1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR1_SHIFT))&DMA_ERR_ERR1_MASK)
#define DMA_ERR_ERR2_MASK                        0x4u
#define DMA_ERR_ERR2_SHIFT                       2
#define DMA_ERR_ERR2_WIDTH                       1
#define DMA_ERR_ERR2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR2_SHIFT))&DMA_ERR_ERR2_MASK)
#define DMA_ERR_ERR3_MASK                        0x8u
#define DMA_ERR_ERR3_SHIFT                       3
#define DMA_ERR_ERR3_WIDTH                       1
#define DMA_ERR_ERR3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR3_SHIFT))&DMA_ERR_ERR3_MASK)
#define DMA_ERR_ERR4_MASK                        0x10u
#define DMA_ERR_ERR4_SHIFT                       4
#define DMA_ERR_ERR4_WIDTH                       1
#define DMA_ERR_ERR4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR4_SHIFT))&DMA_ERR_ERR4_MASK)
#define DMA_ERR_ERR5_MASK                        0x20u
#define DMA_ERR_ERR5_SHIFT                       5
#define DMA_ERR_ERR5_WIDTH                       1
#define DMA_ERR_ERR5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR5_SHIFT))&DMA_ERR_ERR5_MASK)
#define DMA_ERR_ERR6_MASK                        0x40u
#define DMA_ERR_ERR6_SHIFT                       6
#define DMA_ERR_ERR6_WIDTH                       1
#define DMA_ERR_ERR6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR6_SHIFT))&DMA_ERR_ERR6_MASK)
#define DMA_ERR_ERR7_MASK                        0x80u
#define DMA_ERR_ERR7_SHIFT                       7
#define DMA_ERR_ERR7_WIDTH                       1
#define DMA_ERR_ERR7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR7_SHIFT))&DMA_ERR_ERR7_MASK)
#define DMA_ERR_ERR8_MASK                        0x100u
#define DMA_ERR_ERR8_SHIFT                       8
#define DMA_ERR_ERR8_WIDTH                       1
#define DMA_ERR_ERR8(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR8_SHIFT))&DMA_ERR_ERR8_MASK)
#define DMA_ERR_ERR9_MASK                        0x200u
#define DMA_ERR_ERR9_SHIFT                       9
#define DMA_ERR_ERR9_WIDTH                       1
#define DMA_ERR_ERR9(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR9_SHIFT))&DMA_ERR_ERR9_MASK)
#define DMA_ERR_ERR10_MASK                       0x400u
#define DMA_ERR_ERR10_SHIFT                      10
#define DMA_ERR_ERR10_WIDTH                      1
#define DMA_ERR_ERR10(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR10_SHIFT))&DMA_ERR_ERR10_MASK)
#define DMA_ERR_ERR11_MASK                       0x800u
#define DMA_ERR_ERR11_SHIFT                      11
#define DMA_ERR_ERR11_WIDTH                      1
#define DMA_ERR_ERR11(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR11_SHIFT))&DMA_ERR_ERR11_MASK)
#define DMA_ERR_ERR12_MASK                       0x1000u
#define DMA_ERR_ERR12_SHIFT                      12
#define DMA_ERR_ERR12_WIDTH                      1
#define DMA_ERR_ERR12(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR12_SHIFT))&DMA_ERR_ERR12_MASK)
#define DMA_ERR_ERR13_MASK                       0x2000u
#define DMA_ERR_ERR13_SHIFT                      13
#define DMA_ERR_ERR13_WIDTH                      1
#define DMA_ERR_ERR13(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR13_SHIFT))&DMA_ERR_ERR13_MASK)
#define DMA_ERR_ERR14_MASK                       0x4000u
#define DMA_ERR_ERR14_SHIFT                      14
#define DMA_ERR_ERR14_WIDTH                      1
#define DMA_ERR_ERR14(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR14_SHIFT))&DMA_ERR_ERR14_MASK)
#define DMA_ERR_ERR15_MASK                       0x8000u
#define DMA_ERR_ERR15_SHIFT                      15
#define DMA_ERR_ERR15_WIDTH                      1
#define DMA_ERR_ERR15(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR15_SHIFT))&DMA_ERR_ERR15_MASK)
#define DMA_ERR_ERR16_MASK                       0x10000u
#define DMA_ERR_ERR16_SHIFT                      16
#define DMA_ERR_ERR16_WIDTH                      1
#define DMA_ERR_ERR16(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR16_SHIFT))&DMA_ERR_ERR16_MASK)
#define DMA_ERR_ERR17_MASK                       0x20000u
#define DMA_ERR_ERR17_SHIFT                      17
#define DMA_ERR_ERR17_WIDTH                      1
#define DMA_ERR_ERR17(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR17_SHIFT))&DMA_ERR_ERR17_MASK)
#define DMA_ERR_ERR18_MASK                       0x40000u
#define DMA_ERR_ERR18_SHIFT                      18
#define DMA_ERR_ERR18_WIDTH                      1
#define DMA_ERR_ERR18(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR18_SHIFT))&DMA_ERR_ERR18_MASK)
#define DMA_ERR_ERR19_MASK                       0x80000u
#define DMA_ERR_ERR19_SHIFT                      19
#define DMA_ERR_ERR19_WIDTH                      1
#define DMA_ERR_ERR19(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR19_SHIFT))&DMA_ERR_ERR19_MASK)
#define DMA_ERR_ERR20_MASK                       0x100000u
#define DMA_ERR_ERR20_SHIFT                      20
#define DMA_ERR_ERR20_WIDTH                      1
#define DMA_ERR_ERR20(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR20_SHIFT))&DMA_ERR_ERR20_MASK)
#define DMA_ERR_ERR21_MASK                       0x200000u
#define DMA_ERR_ERR21_SHIFT                      21
#define DMA_ERR_ERR21_WIDTH                      1
#define DMA_ERR_ERR21(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR21_SHIFT))&DMA_ERR_ERR21_MASK)
#define DMA_ERR_ERR22_MASK                       0x400000u
#define DMA_ERR_ERR22_SHIFT                      22
#define DMA_ERR_ERR22_WIDTH                      1
#define DMA_ERR_ERR22(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR22_SHIFT))&DMA_ERR_ERR22_MASK)
#define DMA_ERR_ERR23_MASK                       0x800000u
#define DMA_ERR_ERR23_SHIFT                      23
#define DMA_ERR_ERR23_WIDTH                      1
#define DMA_ERR_ERR23(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR23_SHIFT))&DMA_ERR_ERR23_MASK)
#define DMA_ERR_ERR24_MASK                       0x1000000u
#define DMA_ERR_ERR24_SHIFT                      24
#define DMA_ERR_ERR24_WIDTH                      1
#define DMA_ERR_ERR24(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR24_SHIFT))&DMA_ERR_ERR24_MASK)
#define DMA_ERR_ERR25_MASK                       0x2000000u
#define DMA_ERR_ERR25_SHIFT                      25
#define DMA_ERR_ERR25_WIDTH                      1
#define DMA_ERR_ERR25(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR25_SHIFT))&DMA_ERR_ERR25_MASK)
#define DMA_ERR_ERR26_MASK                       0x4000000u
#define DMA_ERR_ERR26_SHIFT                      26
#define DMA_ERR_ERR26_WIDTH                      1
#define DMA_ERR_ERR26(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR26_SHIFT))&DMA_ERR_ERR26_MASK)
#define DMA_ERR_ERR27_MASK                       0x8000000u
#define DMA_ERR_ERR27_SHIFT                      27
#define DMA_ERR_ERR27_WIDTH                      1
#define DMA_ERR_ERR27(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR27_SHIFT))&DMA_ERR_ERR27_MASK)
#define DMA_ERR_ERR28_MASK                       0x10000000u
#define DMA_ERR_ERR28_SHIFT                      28
#define DMA_ERR_ERR28_WIDTH                      1
#define DMA_ERR_ERR28(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR28_SHIFT))&DMA_ERR_ERR28_MASK)
#define DMA_ERR_ERR29_MASK                       0x20000000u
#define DMA_ERR_ERR29_SHIFT                      29
#define DMA_ERR_ERR29_WIDTH                      1
#define DMA_ERR_ERR29(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR29_SHIFT))&DMA_ERR_ERR29_MASK)
#define DMA_ERR_ERR30_MASK                       0x40000000u
#define DMA_ERR_ERR30_SHIFT                      30
#define DMA_ERR_ERR30_WIDTH                      1
#define DMA_ERR_ERR30(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR30_SHIFT))&DMA_ERR_ERR30_MASK)
#define DMA_ERR_ERR31_MASK                       0x80000000u
#define DMA_ERR_ERR31_SHIFT                      31
#define DMA_ERR_ERR31_WIDTH                      1
#define DMA_ERR_ERR31(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR31_SHIFT))&DMA_ERR_ERR31_MASK)
/* HRS Bit Fields */
#define DMA_HRS_HRS0_MASK                        0x1u
#define DMA_HRS_HRS0_SHIFT                       0
#define DMA_HRS_HRS0_WIDTH                       1
#define DMA_HRS_HRS0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS0_SHIFT))&DMA_HRS_HRS0_MASK)
#define DMA_HRS_HRS1_MASK                        0x2u
#define DMA_HRS_HRS1_SHIFT                       1
#define DMA_HRS_HRS1_WIDTH                       1
#define DMA_HRS_HRS1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS1_SHIFT))&DMA_HRS_HRS1_MASK)
#define DMA_HRS_HRS2_MASK                        0x4u
#define DMA_HRS_HRS2_SHIFT                       2
#define DMA_HRS_HRS2_WIDTH                       1
#define DMA_HRS_HRS2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS2_SHIFT))&DMA_HRS_HRS2_MASK)
#define DMA_HRS_HRS3_MASK                        0x8u
#define DMA_HRS_HRS3_SHIFT                       3
#define DMA_HRS_HRS3_WIDTH                       1
#define DMA_HRS_HRS3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS3_SHIFT))&DMA_HRS_HRS3_MASK)
#define DMA_HRS_HRS4_MASK                        0x10u
#define DMA_HRS_HRS4_SHIFT                       4
#define DMA_HRS_HRS4_WIDTH                       1
#define DMA_HRS_HRS4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS4_SHIFT))&DMA_HRS_HRS4_MASK)
#define DMA_HRS_HRS5_MASK                        0x20u
#define DMA_HRS_HRS5_SHIFT                       5
#define DMA_HRS_HRS5_WIDTH                       1
#define DMA_HRS_HRS5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS5_SHIFT))&DMA_HRS_HRS5_MASK)
#define DMA_HRS_HRS6_MASK                        0x40u
#define DMA_HRS_HRS6_SHIFT                       6
#define DMA_HRS_HRS6_WIDTH                       1
#define DMA_HRS_HRS6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS6_SHIFT))&DMA_HRS_HRS6_MASK)
#define DMA_HRS_HRS7_MASK                        0x80u
#define DMA_HRS_HRS7_SHIFT                       7
#define DMA_HRS_HRS7_WIDTH                       1
#define DMA_HRS_HRS7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS7_SHIFT))&DMA_HRS_HRS7_MASK)
#define DMA_HRS_HRS8_MASK                        0x100u
#define DMA_HRS_HRS8_SHIFT                       8
#define DMA_HRS_HRS8_WIDTH                       1
#define DMA_HRS_HRS8(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS8_SHIFT))&DMA_HRS_HRS8_MASK)
#define DMA_HRS_HRS9_MASK                        0x200u
#define DMA_HRS_HRS9_SHIFT                       9
#define DMA_HRS_HRS9_WIDTH                       1
#define DMA_HRS_HRS9(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS9_SHIFT))&DMA_HRS_HRS9_MASK)
#define DMA_HRS_HRS10_MASK                       0x400u
#define DMA_HRS_HRS10_SHIFT                      10
#define DMA_HRS_HRS10_WIDTH                      1
#define DMA_HRS_HRS10(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS10_SHIFT))&DMA_HRS_HRS10_MASK)
#define DMA_HRS_HRS11_MASK                       0x800u
#define DMA_HRS_HRS11_SHIFT                      11
#define DMA_HRS_HRS11_WIDTH                      1
#define DMA_HRS_HRS11(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS11_SHIFT))&DMA_HRS_HRS11_MASK)
#define DMA_HRS_HRS12_MASK                       0x1000u
#define DMA_HRS_HRS12_SHIFT                      12
#define DMA_HRS_HRS12_WIDTH                      1
#define DMA_HRS_HRS12(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS12_SHIFT))&DMA_HRS_HRS12_MASK)
#define DMA_HRS_HRS13_MASK                       0x2000u
#define DMA_HRS_HRS13_SHIFT                      13
#define DMA_HRS_HRS13_WIDTH                      1
#define DMA_HRS_HRS13(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS13_SHIFT))&DMA_HRS_HRS13_MASK)
#define DMA_HRS_HRS14_MASK                       0x4000u
#define DMA_HRS_HRS14_SHIFT                      14
#define DMA_HRS_HRS14_WIDTH                      1
#define DMA_HRS_HRS14(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS14_SHIFT))&DMA_HRS_HRS14_MASK)
#define DMA_HRS_HRS15_MASK                       0x8000u
#define DMA_HRS_HRS15_SHIFT                      15
#define DMA_HRS_HRS15_WIDTH                      1
#define DMA_HRS_HRS15(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS15_SHIFT))&DMA_HRS_HRS15_MASK)
#define DMA_HRS_HRS16_MASK                       0x10000u
#define DMA_HRS_HRS16_SHIFT                      16
#define DMA_HRS_HRS16_WIDTH                      1
#define DMA_HRS_HRS16(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS16_SHIFT))&DMA_HRS_HRS16_MASK)
#define DMA_HRS_HRS17_MASK                       0x20000u
#define DMA_HRS_HRS17_SHIFT                      17
#define DMA_HRS_HRS17_WIDTH                      1
#define DMA_HRS_HRS17(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS17_SHIFT))&DMA_HRS_HRS17_MASK)
#define DMA_HRS_HRS18_MASK                       0x40000u
#define DMA_HRS_HRS18_SHIFT                      18
#define DMA_HRS_HRS18_WIDTH                      1
#define DMA_HRS_HRS18(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS18_SHIFT))&DMA_HRS_HRS18_MASK)
#define DMA_HRS_HRS19_MASK                       0x80000u
#define DMA_HRS_HRS19_SHIFT                      19
#define DMA_HRS_HRS19_WIDTH                      1
#define DMA_HRS_HRS19(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS19_SHIFT))&DMA_HRS_HRS19_MASK)
#define DMA_HRS_HRS20_MASK                       0x100000u
#define DMA_HRS_HRS20_SHIFT                      20
#define DMA_HRS_HRS20_WIDTH                      1
#define DMA_HRS_HRS20(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS20_SHIFT))&DMA_HRS_HRS20_MASK)
#define DMA_HRS_HRS21_MASK                       0x200000u
#define DMA_HRS_HRS21_SHIFT                      21
#define DMA_HRS_HRS21_WIDTH                      1
#define DMA_HRS_HRS21(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS21_SHIFT))&DMA_HRS_HRS21_MASK)
#define DMA_HRS_HRS22_MASK                       0x400000u
#define DMA_HRS_HRS22_SHIFT                      22
#define DMA_HRS_HRS22_WIDTH                      1
#define DMA_HRS_HRS22(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS22_SHIFT))&DMA_HRS_HRS22_MASK)
#define DMA_HRS_HRS23_MASK                       0x800000u
#define DMA_HRS_HRS23_SHIFT                      23
#define DMA_HRS_HRS23_WIDTH                      1
#define DMA_HRS_HRS23(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS23_SHIFT))&DMA_HRS_HRS23_MASK)
#define DMA_HRS_HRS24_MASK                       0x1000000u
#define DMA_HRS_HRS24_SHIFT                      24
#define DMA_HRS_HRS24_WIDTH                      1
#define DMA_HRS_HRS24(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS24_SHIFT))&DMA_HRS_HRS24_MASK)
#define DMA_HRS_HRS25_MASK                       0x2000000u
#define DMA_HRS_HRS25_SHIFT                      25
#define DMA_HRS_HRS25_WIDTH                      1
#define DMA_HRS_HRS25(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS25_SHIFT))&DMA_HRS_HRS25_MASK)
#define DMA_HRS_HRS26_MASK                       0x4000000u
#define DMA_HRS_HRS26_SHIFT                      26
#define DMA_HRS_HRS26_WIDTH                      1
#define DMA_HRS_HRS26(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS26_SHIFT))&DMA_HRS_HRS26_MASK)
#define DMA_HRS_HRS27_MASK                       0x8000000u
#define DMA_HRS_HRS27_SHIFT                      27
#define DMA_HRS_HRS27_WIDTH                      1
#define DMA_HRS_HRS27(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS27_SHIFT))&DMA_HRS_HRS27_MASK)
#define DMA_HRS_HRS28_MASK                       0x10000000u
#define DMA_HRS_HRS28_SHIFT                      28
#define DMA_HRS_HRS28_WIDTH                      1
#define DMA_HRS_HRS28(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS28_SHIFT))&DMA_HRS_HRS28_MASK)
#define DMA_HRS_HRS29_MASK                       0x20000000u
#define DMA_HRS_HRS29_SHIFT                      29
#define DMA_HRS_HRS29_WIDTH                      1
#define DMA_HRS_HRS29(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS29_SHIFT))&DMA_HRS_HRS29_MASK)
#define DMA_HRS_HRS30_MASK                       0x40000000u
#define DMA_HRS_HRS30_SHIFT                      30
#define DMA_HRS_HRS30_WIDTH                      1
#define DMA_HRS_HRS30(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS30_SHIFT))&DMA_HRS_HRS30_MASK)
#define DMA_HRS_HRS31_MASK                       0x80000000u
#define DMA_HRS_HRS31_SHIFT                      31
#define DMA_HRS_HRS31_WIDTH                      1
#define DMA_HRS_HRS31(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS31_SHIFT))&DMA_HRS_HRS31_MASK)
/* EARS Bit Fields */
#define DMA_EARS_EDREQ_0_MASK                    0x1u
#define DMA_EARS_EDREQ_0_SHIFT                   0
#define DMA_EARS_EDREQ_0_WIDTH                   1
#define DMA_EARS_EDREQ_0(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_0_SHIFT))&DMA_EARS_EDREQ_0_MASK)
#define DMA_EARS_EDREQ_1_MASK                    0x2u
#define DMA_EARS_EDREQ_1_SHIFT                   1
#define DMA_EARS_EDREQ_1_WIDTH                   1
#define DMA_EARS_EDREQ_1(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_1_SHIFT))&DMA_EARS_EDREQ_1_MASK)
#define DMA_EARS_EDREQ_2_MASK                    0x4u
#define DMA_EARS_EDREQ_2_SHIFT                   2
#define DMA_EARS_EDREQ_2_WIDTH                   1
#define DMA_EARS_EDREQ_2(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_2_SHIFT))&DMA_EARS_EDREQ_2_MASK)
#define DMA_EARS_EDREQ_3_MASK                    0x8u
#define DMA_EARS_EDREQ_3_SHIFT                   3
#define DMA_EARS_EDREQ_3_WIDTH                   1
#define DMA_EARS_EDREQ_3(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_3_SHIFT))&DMA_EARS_EDREQ_3_MASK)
#define DMA_EARS_EDREQ_4_MASK                    0x10u
#define DMA_EARS_EDREQ_4_SHIFT                   4
#define DMA_EARS_EDREQ_4_WIDTH                   1
#define DMA_EARS_EDREQ_4(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_4_SHIFT))&DMA_EARS_EDREQ_4_MASK)
#define DMA_EARS_EDREQ_5_MASK                    0x20u
#define DMA_EARS_EDREQ_5_SHIFT                   5
#define DMA_EARS_EDREQ_5_WIDTH                   1
#define DMA_EARS_EDREQ_5(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_5_SHIFT))&DMA_EARS_EDREQ_5_MASK)
#define DMA_EARS_EDREQ_6_MASK                    0x40u
#define DMA_EARS_EDREQ_6_SHIFT                   6
#define DMA_EARS_EDREQ_6_WIDTH                   1
#define DMA_EARS_EDREQ_6(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_6_SHIFT))&DMA_EARS_EDREQ_6_MASK)
#define DMA_EARS_EDREQ_7_MASK                    0x80u
#define DMA_EARS_EDREQ_7_SHIFT                   7
#define DMA_EARS_EDREQ_7_WIDTH                   1
#define DMA_EARS_EDREQ_7(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_7_SHIFT))&DMA_EARS_EDREQ_7_MASK)
#define DMA_EARS_EDREQ_8_MASK                    0x100u
#define DMA_EARS_EDREQ_8_SHIFT                   8
#define DMA_EARS_EDREQ_8_WIDTH                   1
#define DMA_EARS_EDREQ_8(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_8_SHIFT))&DMA_EARS_EDREQ_8_MASK)
#define DMA_EARS_EDREQ_9_MASK                    0x200u
#define DMA_EARS_EDREQ_9_SHIFT                   9
#define DMA_EARS_EDREQ_9_WIDTH                   1
#define DMA_EARS_EDREQ_9(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_9_SHIFT))&DMA_EARS_EDREQ_9_MASK)
#define DMA_EARS_EDREQ_10_MASK                   0x400u
#define DMA_EARS_EDREQ_10_SHIFT                  10
#define DMA_EARS_EDREQ_10_WIDTH                  1
#define DMA_EARS_EDREQ_10(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_10_SHIFT))&DMA_EARS_EDREQ_10_MASK)
#define DMA_EARS_EDREQ_11_MASK                   0x800u
#define DMA_EARS_EDREQ_11_SHIFT                  11
#define DMA_EARS_EDREQ_11_WIDTH                  1
#define DMA_EARS_EDREQ_11(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_11_SHIFT))&DMA_EARS_EDREQ_11_MASK)
#define DMA_EARS_EDREQ_12_MASK                   0x1000u
#define DMA_EARS_EDREQ_12_SHIFT                  12
#define DMA_EARS_EDREQ_12_WIDTH                  1
#define DMA_EARS_EDREQ_12(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_12_SHIFT))&DMA_EARS_EDREQ_12_MASK)
#define DMA_EARS_EDREQ_13_MASK                   0x2000u
#define DMA_EARS_EDREQ_13_SHIFT                  13
#define DMA_EARS_EDREQ_13_WIDTH                  1
#define DMA_EARS_EDREQ_13(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_13_SHIFT))&DMA_EARS_EDREQ_13_MASK)
#define DMA_EARS_EDREQ_14_MASK                   0x4000u
#define DMA_EARS_EDREQ_14_SHIFT                  14
#define DMA_EARS_EDREQ_14_WIDTH                  1
#define DMA_EARS_EDREQ_14(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_14_SHIFT))&DMA_EARS_EDREQ_14_MASK)
#define DMA_EARS_EDREQ_15_MASK                   0x8000u
#define DMA_EARS_EDREQ_15_SHIFT                  15
#define DMA_EARS_EDREQ_15_WIDTH                  1
#define DMA_EARS_EDREQ_15(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_15_SHIFT))&DMA_EARS_EDREQ_15_MASK)
#define DMA_EARS_EDREQ_16_MASK                   0x10000u
#define DMA_EARS_EDREQ_16_SHIFT                  16
#define DMA_EARS_EDREQ_16_WIDTH                  1
#define DMA_EARS_EDREQ_16(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_16_SHIFT))&DMA_EARS_EDREQ_16_MASK)
#define DMA_EARS_EDREQ_17_MASK                   0x20000u
#define DMA_EARS_EDREQ_17_SHIFT                  17
#define DMA_EARS_EDREQ_17_WIDTH                  1
#define DMA_EARS_EDREQ_17(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_17_SHIFT))&DMA_EARS_EDREQ_17_MASK)
#define DMA_EARS_EDREQ_18_MASK                   0x40000u
#define DMA_EARS_EDREQ_18_SHIFT                  18
#define DMA_EARS_EDREQ_18_WIDTH                  1
#define DMA_EARS_EDREQ_18(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_18_SHIFT))&DMA_EARS_EDREQ_18_MASK)
#define DMA_EARS_EDREQ_19_MASK                   0x80000u
#define DMA_EARS_EDREQ_19_SHIFT                  19
#define DMA_EARS_EDREQ_19_WIDTH                  1
#define DMA_EARS_EDREQ_19(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_19_SHIFT))&DMA_EARS_EDREQ_19_MASK)
#define DMA_EARS_EDREQ_20_MASK                   0x100000u
#define DMA_EARS_EDREQ_20_SHIFT                  20
#define DMA_EARS_EDREQ_20_WIDTH                  1
#define DMA_EARS_EDREQ_20(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_20_SHIFT))&DMA_EARS_EDREQ_20_MASK)
#define DMA_EARS_EDREQ_21_MASK                   0x200000u
#define DMA_EARS_EDREQ_21_SHIFT                  21
#define DMA_EARS_EDREQ_21_WIDTH                  1
#define DMA_EARS_EDREQ_21(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_21_SHIFT))&DMA_EARS_EDREQ_21_MASK)
#define DMA_EARS_EDREQ_22_MASK                   0x400000u
#define DMA_EARS_EDREQ_22_SHIFT                  22
#define DMA_EARS_EDREQ_22_WIDTH                  1
#define DMA_EARS_EDREQ_22(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_22_SHIFT))&DMA_EARS_EDREQ_22_MASK)
#define DMA_EARS_EDREQ_23_MASK                   0x800000u
#define DMA_EARS_EDREQ_23_SHIFT                  23
#define DMA_EARS_EDREQ_23_WIDTH                  1
#define DMA_EARS_EDREQ_23(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_23_SHIFT))&DMA_EARS_EDREQ_23_MASK)
#define DMA_EARS_EDREQ_24_MASK                   0x1000000u
#define DMA_EARS_EDREQ_24_SHIFT                  24
#define DMA_EARS_EDREQ_24_WIDTH                  1
#define DMA_EARS_EDREQ_24(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_24_SHIFT))&DMA_EARS_EDREQ_24_MASK)
#define DMA_EARS_EDREQ_25_MASK                   0x2000000u
#define DMA_EARS_EDREQ_25_SHIFT                  25
#define DMA_EARS_EDREQ_25_WIDTH                  1
#define DMA_EARS_EDREQ_25(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_25_SHIFT))&DMA_EARS_EDREQ_25_MASK)
#define DMA_EARS_EDREQ_26_MASK                   0x4000000u
#define DMA_EARS_EDREQ_26_SHIFT                  26
#define DMA_EARS_EDREQ_26_WIDTH                  1
#define DMA_EARS_EDREQ_26(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_26_SHIFT))&DMA_EARS_EDREQ_26_MASK)
#define DMA_EARS_EDREQ_27_MASK                   0x8000000u
#define DMA_EARS_EDREQ_27_SHIFT                  27
#define DMA_EARS_EDREQ_27_WIDTH                  1
#define DMA_EARS_EDREQ_27(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_27_SHIFT))&DMA_EARS_EDREQ_27_MASK)
#define DMA_EARS_EDREQ_28_MASK                   0x10000000u
#define DMA_EARS_EDREQ_28_SHIFT                  28
#define DMA_EARS_EDREQ_28_WIDTH                  1
#define DMA_EARS_EDREQ_28(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_28_SHIFT))&DMA_EARS_EDREQ_28_MASK)
#define DMA_EARS_EDREQ_29_MASK                   0x20000000u
#define DMA_EARS_EDREQ_29_SHIFT                  29
#define DMA_EARS_EDREQ_29_WIDTH                  1
#define DMA_EARS_EDREQ_29(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_29_SHIFT))&DMA_EARS_EDREQ_29_MASK)
#define DMA_EARS_EDREQ_30_MASK                   0x40000000u
#define DMA_EARS_EDREQ_30_SHIFT                  30
#define DMA_EARS_EDREQ_30_WIDTH                  1
#define DMA_EARS_EDREQ_30(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_30_SHIFT))&DMA_EARS_EDREQ_30_MASK)
#define DMA_EARS_EDREQ_31_MASK                   0x80000000u
#define DMA_EARS_EDREQ_31_SHIFT                  31
#define DMA_EARS_EDREQ_31_WIDTH                  1
#define DMA_EARS_EDREQ_31(x)                     (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_31_SHIFT))&DMA_EARS_EDREQ_31_MASK)
/* DCHPRI3 Bit Fields */
#define DMA_DCHPRI3_CHPRI_MASK                   0xFu
#define DMA_DCHPRI3_CHPRI_SHIFT                  0
#define DMA_DCHPRI3_CHPRI_WIDTH                  4
#define DMA_DCHPRI3_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI3_CHPRI_SHIFT))&DMA_DCHPRI3_CHPRI_MASK)
#define DMA_DCHPRI3_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI3_GRPPRI_SHIFT                 4
#define DMA_DCHPRI3_GRPPRI_WIDTH                 2
#define DMA_DCHPRI3_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI3_GRPPRI_SHIFT))&DMA_DCHPRI3_GRPPRI_MASK)
#define DMA_DCHPRI3_DPA_MASK                     0x40u
#define DMA_DCHPRI3_DPA_SHIFT                    6
#define DMA_DCHPRI3_DPA_WIDTH                    1
#define DMA_DCHPRI3_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI3_DPA_SHIFT))&DMA_DCHPRI3_DPA_MASK)
#define DMA_DCHPRI3_ECP_MASK                     0x80u
#define DMA_DCHPRI3_ECP_SHIFT                    7
#define DMA_DCHPRI3_ECP_WIDTH                    1
#define DMA_DCHPRI3_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI3_ECP_SHIFT))&DMA_DCHPRI3_ECP_MASK)
/* DCHPRI2 Bit Fields */
#define DMA_DCHPRI2_CHPRI_MASK                   0xFu
#define DMA_DCHPRI2_CHPRI_SHIFT                  0
#define DMA_DCHPRI2_CHPRI_WIDTH                  4
#define DMA_DCHPRI2_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI2_CHPRI_SHIFT))&DMA_DCHPRI2_CHPRI_MASK)
#define DMA_DCHPRI2_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI2_GRPPRI_SHIFT                 4
#define DMA_DCHPRI2_GRPPRI_WIDTH                 2
#define DMA_DCHPRI2_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI2_GRPPRI_SHIFT))&DMA_DCHPRI2_GRPPRI_MASK)
#define DMA_DCHPRI2_DPA_MASK                     0x40u
#define DMA_DCHPRI2_DPA_SHIFT                    6
#define DMA_DCHPRI2_DPA_WIDTH                    1
#define DMA_DCHPRI2_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI2_DPA_SHIFT))&DMA_DCHPRI2_DPA_MASK)
#define DMA_DCHPRI2_ECP_MASK                     0x80u
#define DMA_DCHPRI2_ECP_SHIFT                    7
#define DMA_DCHPRI2_ECP_WIDTH                    1
#define DMA_DCHPRI2_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI2_ECP_SHIFT))&DMA_DCHPRI2_ECP_MASK)
/* DCHPRI1 Bit Fields */
#define DMA_DCHPRI1_CHPRI_MASK                   0xFu
#define DMA_DCHPRI1_CHPRI_SHIFT                  0
#define DMA_DCHPRI1_CHPRI_WIDTH                  4
#define DMA_DCHPRI1_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI1_CHPRI_SHIFT))&DMA_DCHPRI1_CHPRI_MASK)
#define DMA_DCHPRI1_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI1_GRPPRI_SHIFT                 4
#define DMA_DCHPRI1_GRPPRI_WIDTH                 2
#define DMA_DCHPRI1_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI1_GRPPRI_SHIFT))&DMA_DCHPRI1_GRPPRI_MASK)
#define DMA_DCHPRI1_DPA_MASK                     0x40u
#define DMA_DCHPRI1_DPA_SHIFT                    6
#define DMA_DCHPRI1_DPA_WIDTH                    1
#define DMA_DCHPRI1_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI1_DPA_SHIFT))&DMA_DCHPRI1_DPA_MASK)
#define DMA_DCHPRI1_ECP_MASK                     0x80u
#define DMA_DCHPRI1_ECP_SHIFT                    7
#define DMA_DCHPRI1_ECP_WIDTH                    1
#define DMA_DCHPRI1_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI1_ECP_SHIFT))&DMA_DCHPRI1_ECP_MASK)
/* DCHPRI0 Bit Fields */
#define DMA_DCHPRI0_CHPRI_MASK                   0xFu
#define DMA_DCHPRI0_CHPRI_SHIFT                  0
#define DMA_DCHPRI0_CHPRI_WIDTH                  4
#define DMA_DCHPRI0_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI0_CHPRI_SHIFT))&DMA_DCHPRI0_CHPRI_MASK)
#define DMA_DCHPRI0_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI0_GRPPRI_SHIFT                 4
#define DMA_DCHPRI0_GRPPRI_WIDTH                 2
#define DMA_DCHPRI0_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI0_GRPPRI_SHIFT))&DMA_DCHPRI0_GRPPRI_MASK)
#define DMA_DCHPRI0_DPA_MASK                     0x40u
#define DMA_DCHPRI0_DPA_SHIFT                    6
#define DMA_DCHPRI0_DPA_WIDTH                    1
#define DMA_DCHPRI0_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI0_DPA_SHIFT))&DMA_DCHPRI0_DPA_MASK)
#define DMA_DCHPRI0_ECP_MASK                     0x80u
#define DMA_DCHPRI0_ECP_SHIFT                    7
#define DMA_DCHPRI0_ECP_WIDTH                    1
#define DMA_DCHPRI0_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI0_ECP_SHIFT))&DMA_DCHPRI0_ECP_MASK)
/* DCHPRI7 Bit Fields */
#define DMA_DCHPRI7_CHPRI_MASK                   0xFu
#define DMA_DCHPRI7_CHPRI_SHIFT                  0
#define DMA_DCHPRI7_CHPRI_WIDTH                  4
#define DMA_DCHPRI7_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI7_CHPRI_SHIFT))&DMA_DCHPRI7_CHPRI_MASK)
#define DMA_DCHPRI7_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI7_GRPPRI_SHIFT                 4
#define DMA_DCHPRI7_GRPPRI_WIDTH                 2
#define DMA_DCHPRI7_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI7_GRPPRI_SHIFT))&DMA_DCHPRI7_GRPPRI_MASK)
#define DMA_DCHPRI7_DPA_MASK                     0x40u
#define DMA_DCHPRI7_DPA_SHIFT                    6
#define DMA_DCHPRI7_DPA_WIDTH                    1
#define DMA_DCHPRI7_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI7_DPA_SHIFT))&DMA_DCHPRI7_DPA_MASK)
#define DMA_DCHPRI7_ECP_MASK                     0x80u
#define DMA_DCHPRI7_ECP_SHIFT                    7
#define DMA_DCHPRI7_ECP_WIDTH                    1
#define DMA_DCHPRI7_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI7_ECP_SHIFT))&DMA_DCHPRI7_ECP_MASK)
/* DCHPRI6 Bit Fields */
#define DMA_DCHPRI6_CHPRI_MASK                   0xFu
#define DMA_DCHPRI6_CHPRI_SHIFT                  0
#define DMA_DCHPRI6_CHPRI_WIDTH                  4
#define DMA_DCHPRI6_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI6_CHPRI_SHIFT))&DMA_DCHPRI6_CHPRI_MASK)
#define DMA_DCHPRI6_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI6_GRPPRI_SHIFT                 4
#define DMA_DCHPRI6_GRPPRI_WIDTH                 2
#define DMA_DCHPRI6_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI6_GRPPRI_SHIFT))&DMA_DCHPRI6_GRPPRI_MASK)
#define DMA_DCHPRI6_DPA_MASK                     0x40u
#define DMA_DCHPRI6_DPA_SHIFT                    6
#define DMA_DCHPRI6_DPA_WIDTH                    1
#define DMA_DCHPRI6_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI6_DPA_SHIFT))&DMA_DCHPRI6_DPA_MASK)
#define DMA_DCHPRI6_ECP_MASK                     0x80u
#define DMA_DCHPRI6_ECP_SHIFT                    7
#define DMA_DCHPRI6_ECP_WIDTH                    1
#define DMA_DCHPRI6_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI6_ECP_SHIFT))&DMA_DCHPRI6_ECP_MASK)
/* DCHPRI5 Bit Fields */
#define DMA_DCHPRI5_CHPRI_MASK                   0xFu
#define DMA_DCHPRI5_CHPRI_SHIFT                  0
#define DMA_DCHPRI5_CHPRI_WIDTH                  4
#define DMA_DCHPRI5_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI5_CHPRI_SHIFT))&DMA_DCHPRI5_CHPRI_MASK)
#define DMA_DCHPRI5_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI5_GRPPRI_SHIFT                 4
#define DMA_DCHPRI5_GRPPRI_WIDTH                 2
#define DMA_DCHPRI5_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI5_GRPPRI_SHIFT))&DMA_DCHPRI5_GRPPRI_MASK)
#define DMA_DCHPRI5_DPA_MASK                     0x40u
#define DMA_DCHPRI5_DPA_SHIFT                    6
#define DMA_DCHPRI5_DPA_WIDTH                    1
#define DMA_DCHPRI5_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI5_DPA_SHIFT))&DMA_DCHPRI5_DPA_MASK)
#define DMA_DCHPRI5_ECP_MASK                     0x80u
#define DMA_DCHPRI5_ECP_SHIFT                    7
#define DMA_DCHPRI5_ECP_WIDTH                    1
#define DMA_DCHPRI5_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI5_ECP_SHIFT))&DMA_DCHPRI5_ECP_MASK)
/* DCHPRI4 Bit Fields */
#define DMA_DCHPRI4_CHPRI_MASK                   0xFu
#define DMA_DCHPRI4_CHPRI_SHIFT                  0
#define DMA_DCHPRI4_CHPRI_WIDTH                  4
#define DMA_DCHPRI4_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI4_CHPRI_SHIFT))&DMA_DCHPRI4_CHPRI_MASK)
#define DMA_DCHPRI4_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI4_GRPPRI_SHIFT                 4
#define DMA_DCHPRI4_GRPPRI_WIDTH                 2
#define DMA_DCHPRI4_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI4_GRPPRI_SHIFT))&DMA_DCHPRI4_GRPPRI_MASK)
#define DMA_DCHPRI4_DPA_MASK                     0x40u
#define DMA_DCHPRI4_DPA_SHIFT                    6
#define DMA_DCHPRI4_DPA_WIDTH                    1
#define DMA_DCHPRI4_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI4_DPA_SHIFT))&DMA_DCHPRI4_DPA_MASK)
#define DMA_DCHPRI4_ECP_MASK                     0x80u
#define DMA_DCHPRI4_ECP_SHIFT                    7
#define DMA_DCHPRI4_ECP_WIDTH                    1
#define DMA_DCHPRI4_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI4_ECP_SHIFT))&DMA_DCHPRI4_ECP_MASK)
/* DCHPRI11 Bit Fields */
#define DMA_DCHPRI11_CHPRI_MASK                  0xFu
#define DMA_DCHPRI11_CHPRI_SHIFT                 0
#define DMA_DCHPRI11_CHPRI_WIDTH                 4
#define DMA_DCHPRI11_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI11_CHPRI_SHIFT))&DMA_DCHPRI11_CHPRI_MASK)
#define DMA_DCHPRI11_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI11_GRPPRI_SHIFT                4
#define DMA_DCHPRI11_GRPPRI_WIDTH                2
#define DMA_DCHPRI11_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI11_GRPPRI_SHIFT))&DMA_DCHPRI11_GRPPRI_MASK)
#define DMA_DCHPRI11_DPA_MASK                    0x40u
#define DMA_DCHPRI11_DPA_SHIFT                   6
#define DMA_DCHPRI11_DPA_WIDTH                   1
#define DMA_DCHPRI11_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI11_DPA_SHIFT))&DMA_DCHPRI11_DPA_MASK)
#define DMA_DCHPRI11_ECP_MASK                    0x80u
#define DMA_DCHPRI11_ECP_SHIFT                   7
#define DMA_DCHPRI11_ECP_WIDTH                   1
#define DMA_DCHPRI11_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI11_ECP_SHIFT))&DMA_DCHPRI11_ECP_MASK)
/* DCHPRI10 Bit Fields */
#define DMA_DCHPRI10_CHPRI_MASK                  0xFu
#define DMA_DCHPRI10_CHPRI_SHIFT                 0
#define DMA_DCHPRI10_CHPRI_WIDTH                 4
#define DMA_DCHPRI10_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI10_CHPRI_SHIFT))&DMA_DCHPRI10_CHPRI_MASK)
#define DMA_DCHPRI10_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI10_GRPPRI_SHIFT                4
#define DMA_DCHPRI10_GRPPRI_WIDTH                2
#define DMA_DCHPRI10_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI10_GRPPRI_SHIFT))&DMA_DCHPRI10_GRPPRI_MASK)
#define DMA_DCHPRI10_DPA_MASK                    0x40u
#define DMA_DCHPRI10_DPA_SHIFT                   6
#define DMA_DCHPRI10_DPA_WIDTH                   1
#define DMA_DCHPRI10_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI10_DPA_SHIFT))&DMA_DCHPRI10_DPA_MASK)
#define DMA_DCHPRI10_ECP_MASK                    0x80u
#define DMA_DCHPRI10_ECP_SHIFT                   7
#define DMA_DCHPRI10_ECP_WIDTH                   1
#define DMA_DCHPRI10_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI10_ECP_SHIFT))&DMA_DCHPRI10_ECP_MASK)
/* DCHPRI9 Bit Fields */
#define DMA_DCHPRI9_CHPRI_MASK                   0xFu
#define DMA_DCHPRI9_CHPRI_SHIFT                  0
#define DMA_DCHPRI9_CHPRI_WIDTH                  4
#define DMA_DCHPRI9_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI9_CHPRI_SHIFT))&DMA_DCHPRI9_CHPRI_MASK)
#define DMA_DCHPRI9_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI9_GRPPRI_SHIFT                 4
#define DMA_DCHPRI9_GRPPRI_WIDTH                 2
#define DMA_DCHPRI9_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI9_GRPPRI_SHIFT))&DMA_DCHPRI9_GRPPRI_MASK)
#define DMA_DCHPRI9_DPA_MASK                     0x40u
#define DMA_DCHPRI9_DPA_SHIFT                    6
#define DMA_DCHPRI9_DPA_WIDTH                    1
#define DMA_DCHPRI9_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI9_DPA_SHIFT))&DMA_DCHPRI9_DPA_MASK)
#define DMA_DCHPRI9_ECP_MASK                     0x80u
#define DMA_DCHPRI9_ECP_SHIFT                    7
#define DMA_DCHPRI9_ECP_WIDTH                    1
#define DMA_DCHPRI9_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI9_ECP_SHIFT))&DMA_DCHPRI9_ECP_MASK)
/* DCHPRI8 Bit Fields */
#define DMA_DCHPRI8_CHPRI_MASK                   0xFu
#define DMA_DCHPRI8_CHPRI_SHIFT                  0
#define DMA_DCHPRI8_CHPRI_WIDTH                  4
#define DMA_DCHPRI8_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI8_CHPRI_SHIFT))&DMA_DCHPRI8_CHPRI_MASK)
#define DMA_DCHPRI8_GRPPRI_MASK                  0x30u
#define DMA_DCHPRI8_GRPPRI_SHIFT                 4
#define DMA_DCHPRI8_GRPPRI_WIDTH                 2
#define DMA_DCHPRI8_GRPPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI8_GRPPRI_SHIFT))&DMA_DCHPRI8_GRPPRI_MASK)
#define DMA_DCHPRI8_DPA_MASK                     0x40u
#define DMA_DCHPRI8_DPA_SHIFT                    6
#define DMA_DCHPRI8_DPA_WIDTH                    1
#define DMA_DCHPRI8_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI8_DPA_SHIFT))&DMA_DCHPRI8_DPA_MASK)
#define DMA_DCHPRI8_ECP_MASK                     0x80u
#define DMA_DCHPRI8_ECP_SHIFT                    7
#define DMA_DCHPRI8_ECP_WIDTH                    1
#define DMA_DCHPRI8_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI8_ECP_SHIFT))&DMA_DCHPRI8_ECP_MASK)
/* DCHPRI15 Bit Fields */
#define DMA_DCHPRI15_CHPRI_MASK                  0xFu
#define DMA_DCHPRI15_CHPRI_SHIFT                 0
#define DMA_DCHPRI15_CHPRI_WIDTH                 4
#define DMA_DCHPRI15_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI15_CHPRI_SHIFT))&DMA_DCHPRI15_CHPRI_MASK)
#define DMA_DCHPRI15_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI15_GRPPRI_SHIFT                4
#define DMA_DCHPRI15_GRPPRI_WIDTH                2
#define DMA_DCHPRI15_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI15_GRPPRI_SHIFT))&DMA_DCHPRI15_GRPPRI_MASK)
#define DMA_DCHPRI15_DPA_MASK                    0x40u
#define DMA_DCHPRI15_DPA_SHIFT                   6
#define DMA_DCHPRI15_DPA_WIDTH                   1
#define DMA_DCHPRI15_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI15_DPA_SHIFT))&DMA_DCHPRI15_DPA_MASK)
#define DMA_DCHPRI15_ECP_MASK                    0x80u
#define DMA_DCHPRI15_ECP_SHIFT                   7
#define DMA_DCHPRI15_ECP_WIDTH                   1
#define DMA_DCHPRI15_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI15_ECP_SHIFT))&DMA_DCHPRI15_ECP_MASK)
/* DCHPRI14 Bit Fields */
#define DMA_DCHPRI14_CHPRI_MASK                  0xFu
#define DMA_DCHPRI14_CHPRI_SHIFT                 0
#define DMA_DCHPRI14_CHPRI_WIDTH                 4
#define DMA_DCHPRI14_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI14_CHPRI_SHIFT))&DMA_DCHPRI14_CHPRI_MASK)
#define DMA_DCHPRI14_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI14_GRPPRI_SHIFT                4
#define DMA_DCHPRI14_GRPPRI_WIDTH                2
#define DMA_DCHPRI14_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI14_GRPPRI_SHIFT))&DMA_DCHPRI14_GRPPRI_MASK)
#define DMA_DCHPRI14_DPA_MASK                    0x40u
#define DMA_DCHPRI14_DPA_SHIFT                   6
#define DMA_DCHPRI14_DPA_WIDTH                   1
#define DMA_DCHPRI14_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI14_DPA_SHIFT))&DMA_DCHPRI14_DPA_MASK)
#define DMA_DCHPRI14_ECP_MASK                    0x80u
#define DMA_DCHPRI14_ECP_SHIFT                   7
#define DMA_DCHPRI14_ECP_WIDTH                   1
#define DMA_DCHPRI14_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI14_ECP_SHIFT))&DMA_DCHPRI14_ECP_MASK)
/* DCHPRI13 Bit Fields */
#define DMA_DCHPRI13_CHPRI_MASK                  0xFu
#define DMA_DCHPRI13_CHPRI_SHIFT                 0
#define DMA_DCHPRI13_CHPRI_WIDTH                 4
#define DMA_DCHPRI13_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI13_CHPRI_SHIFT))&DMA_DCHPRI13_CHPRI_MASK)
#define DMA_DCHPRI13_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI13_GRPPRI_SHIFT                4
#define DMA_DCHPRI13_GRPPRI_WIDTH                2
#define DMA_DCHPRI13_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI13_GRPPRI_SHIFT))&DMA_DCHPRI13_GRPPRI_MASK)
#define DMA_DCHPRI13_DPA_MASK                    0x40u
#define DMA_DCHPRI13_DPA_SHIFT                   6
#define DMA_DCHPRI13_DPA_WIDTH                   1
#define DMA_DCHPRI13_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI13_DPA_SHIFT))&DMA_DCHPRI13_DPA_MASK)
#define DMA_DCHPRI13_ECP_MASK                    0x80u
#define DMA_DCHPRI13_ECP_SHIFT                   7
#define DMA_DCHPRI13_ECP_WIDTH                   1
#define DMA_DCHPRI13_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI13_ECP_SHIFT))&DMA_DCHPRI13_ECP_MASK)
/* DCHPRI12 Bit Fields */
#define DMA_DCHPRI12_CHPRI_MASK                  0xFu
#define DMA_DCHPRI12_CHPRI_SHIFT                 0
#define DMA_DCHPRI12_CHPRI_WIDTH                 4
#define DMA_DCHPRI12_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI12_CHPRI_SHIFT))&DMA_DCHPRI12_CHPRI_MASK)
#define DMA_DCHPRI12_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI12_GRPPRI_SHIFT                4
#define DMA_DCHPRI12_GRPPRI_WIDTH                2
#define DMA_DCHPRI12_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI12_GRPPRI_SHIFT))&DMA_DCHPRI12_GRPPRI_MASK)
#define DMA_DCHPRI12_DPA_MASK                    0x40u
#define DMA_DCHPRI12_DPA_SHIFT                   6
#define DMA_DCHPRI12_DPA_WIDTH                   1
#define DMA_DCHPRI12_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI12_DPA_SHIFT))&DMA_DCHPRI12_DPA_MASK)
#define DMA_DCHPRI12_ECP_MASK                    0x80u
#define DMA_DCHPRI12_ECP_SHIFT                   7
#define DMA_DCHPRI12_ECP_WIDTH                   1
#define DMA_DCHPRI12_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI12_ECP_SHIFT))&DMA_DCHPRI12_ECP_MASK)
/* DCHPRI19 Bit Fields */
#define DMA_DCHPRI19_CHPRI_MASK                  0xFu
#define DMA_DCHPRI19_CHPRI_SHIFT                 0
#define DMA_DCHPRI19_CHPRI_WIDTH                 4
#define DMA_DCHPRI19_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI19_CHPRI_SHIFT))&DMA_DCHPRI19_CHPRI_MASK)
#define DMA_DCHPRI19_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI19_GRPPRI_SHIFT                4
#define DMA_DCHPRI19_GRPPRI_WIDTH                2
#define DMA_DCHPRI19_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI19_GRPPRI_SHIFT))&DMA_DCHPRI19_GRPPRI_MASK)
#define DMA_DCHPRI19_DPA_MASK                    0x40u
#define DMA_DCHPRI19_DPA_SHIFT                   6
#define DMA_DCHPRI19_DPA_WIDTH                   1
#define DMA_DCHPRI19_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI19_DPA_SHIFT))&DMA_DCHPRI19_DPA_MASK)
#define DMA_DCHPRI19_ECP_MASK                    0x80u
#define DMA_DCHPRI19_ECP_SHIFT                   7
#define DMA_DCHPRI19_ECP_WIDTH                   1
#define DMA_DCHPRI19_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI19_ECP_SHIFT))&DMA_DCHPRI19_ECP_MASK)
/* DCHPRI18 Bit Fields */
#define DMA_DCHPRI18_CHPRI_MASK                  0xFu
#define DMA_DCHPRI18_CHPRI_SHIFT                 0
#define DMA_DCHPRI18_CHPRI_WIDTH                 4
#define DMA_DCHPRI18_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI18_CHPRI_SHIFT))&DMA_DCHPRI18_CHPRI_MASK)
#define DMA_DCHPRI18_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI18_GRPPRI_SHIFT                4
#define DMA_DCHPRI18_GRPPRI_WIDTH                2
#define DMA_DCHPRI18_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI18_GRPPRI_SHIFT))&DMA_DCHPRI18_GRPPRI_MASK)
#define DMA_DCHPRI18_DPA_MASK                    0x40u
#define DMA_DCHPRI18_DPA_SHIFT                   6
#define DMA_DCHPRI18_DPA_WIDTH                   1
#define DMA_DCHPRI18_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI18_DPA_SHIFT))&DMA_DCHPRI18_DPA_MASK)
#define DMA_DCHPRI18_ECP_MASK                    0x80u
#define DMA_DCHPRI18_ECP_SHIFT                   7
#define DMA_DCHPRI18_ECP_WIDTH                   1
#define DMA_DCHPRI18_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI18_ECP_SHIFT))&DMA_DCHPRI18_ECP_MASK)
/* DCHPRI17 Bit Fields */
#define DMA_DCHPRI17_CHPRI_MASK                  0xFu
#define DMA_DCHPRI17_CHPRI_SHIFT                 0
#define DMA_DCHPRI17_CHPRI_WIDTH                 4
#define DMA_DCHPRI17_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI17_CHPRI_SHIFT))&DMA_DCHPRI17_CHPRI_MASK)
#define DMA_DCHPRI17_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI17_GRPPRI_SHIFT                4
#define DMA_DCHPRI17_GRPPRI_WIDTH                2
#define DMA_DCHPRI17_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI17_GRPPRI_SHIFT))&DMA_DCHPRI17_GRPPRI_MASK)
#define DMA_DCHPRI17_DPA_MASK                    0x40u
#define DMA_DCHPRI17_DPA_SHIFT                   6
#define DMA_DCHPRI17_DPA_WIDTH                   1
#define DMA_DCHPRI17_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI17_DPA_SHIFT))&DMA_DCHPRI17_DPA_MASK)
#define DMA_DCHPRI17_ECP_MASK                    0x80u
#define DMA_DCHPRI17_ECP_SHIFT                   7
#define DMA_DCHPRI17_ECP_WIDTH                   1
#define DMA_DCHPRI17_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI17_ECP_SHIFT))&DMA_DCHPRI17_ECP_MASK)
/* DCHPRI16 Bit Fields */
#define DMA_DCHPRI16_CHPRI_MASK                  0xFu
#define DMA_DCHPRI16_CHPRI_SHIFT                 0
#define DMA_DCHPRI16_CHPRI_WIDTH                 4
#define DMA_DCHPRI16_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI16_CHPRI_SHIFT))&DMA_DCHPRI16_CHPRI_MASK)
#define DMA_DCHPRI16_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI16_GRPPRI_SHIFT                4
#define DMA_DCHPRI16_GRPPRI_WIDTH                2
#define DMA_DCHPRI16_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI16_GRPPRI_SHIFT))&DMA_DCHPRI16_GRPPRI_MASK)
#define DMA_DCHPRI16_DPA_MASK                    0x40u
#define DMA_DCHPRI16_DPA_SHIFT                   6
#define DMA_DCHPRI16_DPA_WIDTH                   1
#define DMA_DCHPRI16_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI16_DPA_SHIFT))&DMA_DCHPRI16_DPA_MASK)
#define DMA_DCHPRI16_ECP_MASK                    0x80u
#define DMA_DCHPRI16_ECP_SHIFT                   7
#define DMA_DCHPRI16_ECP_WIDTH                   1
#define DMA_DCHPRI16_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI16_ECP_SHIFT))&DMA_DCHPRI16_ECP_MASK)
/* DCHPRI23 Bit Fields */
#define DMA_DCHPRI23_CHPRI_MASK                  0xFu
#define DMA_DCHPRI23_CHPRI_SHIFT                 0
#define DMA_DCHPRI23_CHPRI_WIDTH                 4
#define DMA_DCHPRI23_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI23_CHPRI_SHIFT))&DMA_DCHPRI23_CHPRI_MASK)
#define DMA_DCHPRI23_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI23_GRPPRI_SHIFT                4
#define DMA_DCHPRI23_GRPPRI_WIDTH                2
#define DMA_DCHPRI23_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI23_GRPPRI_SHIFT))&DMA_DCHPRI23_GRPPRI_MASK)
#define DMA_DCHPRI23_DPA_MASK                    0x40u
#define DMA_DCHPRI23_DPA_SHIFT                   6
#define DMA_DCHPRI23_DPA_WIDTH                   1
#define DMA_DCHPRI23_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI23_DPA_SHIFT))&DMA_DCHPRI23_DPA_MASK)
#define DMA_DCHPRI23_ECP_MASK                    0x80u
#define DMA_DCHPRI23_ECP_SHIFT                   7
#define DMA_DCHPRI23_ECP_WIDTH                   1
#define DMA_DCHPRI23_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI23_ECP_SHIFT))&DMA_DCHPRI23_ECP_MASK)
/* DCHPRI22 Bit Fields */
#define DMA_DCHPRI22_CHPRI_MASK                  0xFu
#define DMA_DCHPRI22_CHPRI_SHIFT                 0
#define DMA_DCHPRI22_CHPRI_WIDTH                 4
#define DMA_DCHPRI22_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI22_CHPRI_SHIFT))&DMA_DCHPRI22_CHPRI_MASK)
#define DMA_DCHPRI22_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI22_GRPPRI_SHIFT                4
#define DMA_DCHPRI22_GRPPRI_WIDTH                2
#define DMA_DCHPRI22_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI22_GRPPRI_SHIFT))&DMA_DCHPRI22_GRPPRI_MASK)
#define DMA_DCHPRI22_DPA_MASK                    0x40u
#define DMA_DCHPRI22_DPA_SHIFT                   6
#define DMA_DCHPRI22_DPA_WIDTH                   1
#define DMA_DCHPRI22_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI22_DPA_SHIFT))&DMA_DCHPRI22_DPA_MASK)
#define DMA_DCHPRI22_ECP_MASK                    0x80u
#define DMA_DCHPRI22_ECP_SHIFT                   7
#define DMA_DCHPRI22_ECP_WIDTH                   1
#define DMA_DCHPRI22_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI22_ECP_SHIFT))&DMA_DCHPRI22_ECP_MASK)
/* DCHPRI21 Bit Fields */
#define DMA_DCHPRI21_CHPRI_MASK                  0xFu
#define DMA_DCHPRI21_CHPRI_SHIFT                 0
#define DMA_DCHPRI21_CHPRI_WIDTH                 4
#define DMA_DCHPRI21_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI21_CHPRI_SHIFT))&DMA_DCHPRI21_CHPRI_MASK)
#define DMA_DCHPRI21_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI21_GRPPRI_SHIFT                4
#define DMA_DCHPRI21_GRPPRI_WIDTH                2
#define DMA_DCHPRI21_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI21_GRPPRI_SHIFT))&DMA_DCHPRI21_GRPPRI_MASK)
#define DMA_DCHPRI21_DPA_MASK                    0x40u
#define DMA_DCHPRI21_DPA_SHIFT                   6
#define DMA_DCHPRI21_DPA_WIDTH                   1
#define DMA_DCHPRI21_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI21_DPA_SHIFT))&DMA_DCHPRI21_DPA_MASK)
#define DMA_DCHPRI21_ECP_MASK                    0x80u
#define DMA_DCHPRI21_ECP_SHIFT                   7
#define DMA_DCHPRI21_ECP_WIDTH                   1
#define DMA_DCHPRI21_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI21_ECP_SHIFT))&DMA_DCHPRI21_ECP_MASK)
/* DCHPRI20 Bit Fields */
#define DMA_DCHPRI20_CHPRI_MASK                  0xFu
#define DMA_DCHPRI20_CHPRI_SHIFT                 0
#define DMA_DCHPRI20_CHPRI_WIDTH                 4
#define DMA_DCHPRI20_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI20_CHPRI_SHIFT))&DMA_DCHPRI20_CHPRI_MASK)
#define DMA_DCHPRI20_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI20_GRPPRI_SHIFT                4
#define DMA_DCHPRI20_GRPPRI_WIDTH                2
#define DMA_DCHPRI20_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI20_GRPPRI_SHIFT))&DMA_DCHPRI20_GRPPRI_MASK)
#define DMA_DCHPRI20_DPA_MASK                    0x40u
#define DMA_DCHPRI20_DPA_SHIFT                   6
#define DMA_DCHPRI20_DPA_WIDTH                   1
#define DMA_DCHPRI20_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI20_DPA_SHIFT))&DMA_DCHPRI20_DPA_MASK)
#define DMA_DCHPRI20_ECP_MASK                    0x80u
#define DMA_DCHPRI20_ECP_SHIFT                   7
#define DMA_DCHPRI20_ECP_WIDTH                   1
#define DMA_DCHPRI20_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI20_ECP_SHIFT))&DMA_DCHPRI20_ECP_MASK)
/* DCHPRI27 Bit Fields */
#define DMA_DCHPRI27_CHPRI_MASK                  0xFu
#define DMA_DCHPRI27_CHPRI_SHIFT                 0
#define DMA_DCHPRI27_CHPRI_WIDTH                 4
#define DMA_DCHPRI27_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI27_CHPRI_SHIFT))&DMA_DCHPRI27_CHPRI_MASK)
#define DMA_DCHPRI27_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI27_GRPPRI_SHIFT                4
#define DMA_DCHPRI27_GRPPRI_WIDTH                2
#define DMA_DCHPRI27_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI27_GRPPRI_SHIFT))&DMA_DCHPRI27_GRPPRI_MASK)
#define DMA_DCHPRI27_DPA_MASK                    0x40u
#define DMA_DCHPRI27_DPA_SHIFT                   6
#define DMA_DCHPRI27_DPA_WIDTH                   1
#define DMA_DCHPRI27_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI27_DPA_SHIFT))&DMA_DCHPRI27_DPA_MASK)
#define DMA_DCHPRI27_ECP_MASK                    0x80u
#define DMA_DCHPRI27_ECP_SHIFT                   7
#define DMA_DCHPRI27_ECP_WIDTH                   1
#define DMA_DCHPRI27_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI27_ECP_SHIFT))&DMA_DCHPRI27_ECP_MASK)
/* DCHPRI26 Bit Fields */
#define DMA_DCHPRI26_CHPRI_MASK                  0xFu
#define DMA_DCHPRI26_CHPRI_SHIFT                 0
#define DMA_DCHPRI26_CHPRI_WIDTH                 4
#define DMA_DCHPRI26_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI26_CHPRI_SHIFT))&DMA_DCHPRI26_CHPRI_MASK)
#define DMA_DCHPRI26_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI26_GRPPRI_SHIFT                4
#define DMA_DCHPRI26_GRPPRI_WIDTH                2
#define DMA_DCHPRI26_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI26_GRPPRI_SHIFT))&DMA_DCHPRI26_GRPPRI_MASK)
#define DMA_DCHPRI26_DPA_MASK                    0x40u
#define DMA_DCHPRI26_DPA_SHIFT                   6
#define DMA_DCHPRI26_DPA_WIDTH                   1
#define DMA_DCHPRI26_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI26_DPA_SHIFT))&DMA_DCHPRI26_DPA_MASK)
#define DMA_DCHPRI26_ECP_MASK                    0x80u
#define DMA_DCHPRI26_ECP_SHIFT                   7
#define DMA_DCHPRI26_ECP_WIDTH                   1
#define DMA_DCHPRI26_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI26_ECP_SHIFT))&DMA_DCHPRI26_ECP_MASK)
/* DCHPRI25 Bit Fields */
#define DMA_DCHPRI25_CHPRI_MASK                  0xFu
#define DMA_DCHPRI25_CHPRI_SHIFT                 0
#define DMA_DCHPRI25_CHPRI_WIDTH                 4
#define DMA_DCHPRI25_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI25_CHPRI_SHIFT))&DMA_DCHPRI25_CHPRI_MASK)
#define DMA_DCHPRI25_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI25_GRPPRI_SHIFT                4
#define DMA_DCHPRI25_GRPPRI_WIDTH                2
#define DMA_DCHPRI25_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI25_GRPPRI_SHIFT))&DMA_DCHPRI25_GRPPRI_MASK)
#define DMA_DCHPRI25_DPA_MASK                    0x40u
#define DMA_DCHPRI25_DPA_SHIFT                   6
#define DMA_DCHPRI25_DPA_WIDTH                   1
#define DMA_DCHPRI25_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI25_DPA_SHIFT))&DMA_DCHPRI25_DPA_MASK)
#define DMA_DCHPRI25_ECP_MASK                    0x80u
#define DMA_DCHPRI25_ECP_SHIFT                   7
#define DMA_DCHPRI25_ECP_WIDTH                   1
#define DMA_DCHPRI25_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI25_ECP_SHIFT))&DMA_DCHPRI25_ECP_MASK)
/* DCHPRI24 Bit Fields */
#define DMA_DCHPRI24_CHPRI_MASK                  0xFu
#define DMA_DCHPRI24_CHPRI_SHIFT                 0
#define DMA_DCHPRI24_CHPRI_WIDTH                 4
#define DMA_DCHPRI24_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI24_CHPRI_SHIFT))&DMA_DCHPRI24_CHPRI_MASK)
#define DMA_DCHPRI24_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI24_GRPPRI_SHIFT                4
#define DMA_DCHPRI24_GRPPRI_WIDTH                2
#define DMA_DCHPRI24_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI24_GRPPRI_SHIFT))&DMA_DCHPRI24_GRPPRI_MASK)
#define DMA_DCHPRI24_DPA_MASK                    0x40u
#define DMA_DCHPRI24_DPA_SHIFT                   6
#define DMA_DCHPRI24_DPA_WIDTH                   1
#define DMA_DCHPRI24_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI24_DPA_SHIFT))&DMA_DCHPRI24_DPA_MASK)
#define DMA_DCHPRI24_ECP_MASK                    0x80u
#define DMA_DCHPRI24_ECP_SHIFT                   7
#define DMA_DCHPRI24_ECP_WIDTH                   1
#define DMA_DCHPRI24_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI24_ECP_SHIFT))&DMA_DCHPRI24_ECP_MASK)
/* DCHPRI31 Bit Fields */
#define DMA_DCHPRI31_CHPRI_MASK                  0xFu
#define DMA_DCHPRI31_CHPRI_SHIFT                 0
#define DMA_DCHPRI31_CHPRI_WIDTH                 4
#define DMA_DCHPRI31_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI31_CHPRI_SHIFT))&DMA_DCHPRI31_CHPRI_MASK)
#define DMA_DCHPRI31_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI31_GRPPRI_SHIFT                4
#define DMA_DCHPRI31_GRPPRI_WIDTH                2
#define DMA_DCHPRI31_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI31_GRPPRI_SHIFT))&DMA_DCHPRI31_GRPPRI_MASK)
#define DMA_DCHPRI31_DPA_MASK                    0x40u
#define DMA_DCHPRI31_DPA_SHIFT                   6
#define DMA_DCHPRI31_DPA_WIDTH                   1
#define DMA_DCHPRI31_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI31_DPA_SHIFT))&DMA_DCHPRI31_DPA_MASK)
#define DMA_DCHPRI31_ECP_MASK                    0x80u
#define DMA_DCHPRI31_ECP_SHIFT                   7
#define DMA_DCHPRI31_ECP_WIDTH                   1
#define DMA_DCHPRI31_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI31_ECP_SHIFT))&DMA_DCHPRI31_ECP_MASK)
/* DCHPRI30 Bit Fields */
#define DMA_DCHPRI30_CHPRI_MASK                  0xFu
#define DMA_DCHPRI30_CHPRI_SHIFT                 0
#define DMA_DCHPRI30_CHPRI_WIDTH                 4
#define DMA_DCHPRI30_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI30_CHPRI_SHIFT))&DMA_DCHPRI30_CHPRI_MASK)
#define DMA_DCHPRI30_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI30_GRPPRI_SHIFT                4
#define DMA_DCHPRI30_GRPPRI_WIDTH                2
#define DMA_DCHPRI30_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI30_GRPPRI_SHIFT))&DMA_DCHPRI30_GRPPRI_MASK)
#define DMA_DCHPRI30_DPA_MASK                    0x40u
#define DMA_DCHPRI30_DPA_SHIFT                   6
#define DMA_DCHPRI30_DPA_WIDTH                   1
#define DMA_DCHPRI30_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI30_DPA_SHIFT))&DMA_DCHPRI30_DPA_MASK)
#define DMA_DCHPRI30_ECP_MASK                    0x80u
#define DMA_DCHPRI30_ECP_SHIFT                   7
#define DMA_DCHPRI30_ECP_WIDTH                   1
#define DMA_DCHPRI30_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI30_ECP_SHIFT))&DMA_DCHPRI30_ECP_MASK)
/* DCHPRI29 Bit Fields */
#define DMA_DCHPRI29_CHPRI_MASK                  0xFu
#define DMA_DCHPRI29_CHPRI_SHIFT                 0
#define DMA_DCHPRI29_CHPRI_WIDTH                 4
#define DMA_DCHPRI29_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI29_CHPRI_SHIFT))&DMA_DCHPRI29_CHPRI_MASK)
#define DMA_DCHPRI29_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI29_GRPPRI_SHIFT                4
#define DMA_DCHPRI29_GRPPRI_WIDTH                2
#define DMA_DCHPRI29_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI29_GRPPRI_SHIFT))&DMA_DCHPRI29_GRPPRI_MASK)
#define DMA_DCHPRI29_DPA_MASK                    0x40u
#define DMA_DCHPRI29_DPA_SHIFT                   6
#define DMA_DCHPRI29_DPA_WIDTH                   1
#define DMA_DCHPRI29_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI29_DPA_SHIFT))&DMA_DCHPRI29_DPA_MASK)
#define DMA_DCHPRI29_ECP_MASK                    0x80u
#define DMA_DCHPRI29_ECP_SHIFT                   7
#define DMA_DCHPRI29_ECP_WIDTH                   1
#define DMA_DCHPRI29_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI29_ECP_SHIFT))&DMA_DCHPRI29_ECP_MASK)
/* DCHPRI28 Bit Fields */
#define DMA_DCHPRI28_CHPRI_MASK                  0xFu
#define DMA_DCHPRI28_CHPRI_SHIFT                 0
#define DMA_DCHPRI28_CHPRI_WIDTH                 4
#define DMA_DCHPRI28_CHPRI(x)                    (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI28_CHPRI_SHIFT))&DMA_DCHPRI28_CHPRI_MASK)
#define DMA_DCHPRI28_GRPPRI_MASK                 0x30u
#define DMA_DCHPRI28_GRPPRI_SHIFT                4
#define DMA_DCHPRI28_GRPPRI_WIDTH                2
#define DMA_DCHPRI28_GRPPRI(x)                   (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI28_GRPPRI_SHIFT))&DMA_DCHPRI28_GRPPRI_MASK)
#define DMA_DCHPRI28_DPA_MASK                    0x40u
#define DMA_DCHPRI28_DPA_SHIFT                   6
#define DMA_DCHPRI28_DPA_WIDTH                   1
#define DMA_DCHPRI28_DPA(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI28_DPA_SHIFT))&DMA_DCHPRI28_DPA_MASK)
#define DMA_DCHPRI28_ECP_MASK                    0x80u
#define DMA_DCHPRI28_ECP_SHIFT                   7
#define DMA_DCHPRI28_ECP_WIDTH                   1
#define DMA_DCHPRI28_ECP(x)                      (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI28_ECP_SHIFT))&DMA_DCHPRI28_ECP_MASK)
/* SADDR Bit Fields */
#define DMA_SADDR_SADDR_MASK                     0xFFFFFFFFu
#define DMA_SADDR_SADDR_SHIFT                    0
#define DMA_SADDR_SADDR_WIDTH                    32
#define DMA_SADDR_SADDR(x)                       (((uint32_t)(((uint32_t)(x))<<DMA_SADDR_SADDR_SHIFT))&DMA_SADDR_SADDR_MASK)
/* SOFF Bit Fields */
#define DMA_SOFF_SOFF_MASK                       0xFFFFu
#define DMA_SOFF_SOFF_SHIFT                      0
#define DMA_SOFF_SOFF_WIDTH                      16
#define DMA_SOFF_SOFF(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_SOFF_SOFF_SHIFT))&DMA_SOFF_SOFF_MASK)
/* ATTR Bit Fields */
#define DMA_ATTR_DSIZE_MASK                      0x7u
#define DMA_ATTR_DSIZE_SHIFT                     0
#define DMA_ATTR_DSIZE_WIDTH                     3
#define DMA_ATTR_DSIZE(x)                        (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_DSIZE_SHIFT))&DMA_ATTR_DSIZE_MASK)
#define DMA_ATTR_DMOD_MASK                       0xF8u
#define DMA_ATTR_DMOD_SHIFT                      3
#define DMA_ATTR_DMOD_WIDTH                      5
#define DMA_ATTR_DMOD(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_DMOD_SHIFT))&DMA_ATTR_DMOD_MASK)
#define DMA_ATTR_SSIZE_MASK                      0x700u
#define DMA_ATTR_SSIZE_SHIFT                     8
#define DMA_ATTR_SSIZE_WIDTH                     3
#define DMA_ATTR_SSIZE(x)                        (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_SSIZE_SHIFT))&DMA_ATTR_SSIZE_MASK)
#define DMA_ATTR_SMOD_MASK                       0xF800u
#define DMA_ATTR_SMOD_SHIFT                      11
#define DMA_ATTR_SMOD_WIDTH                      5
#define DMA_ATTR_SMOD(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_SMOD_SHIFT))&DMA_ATTR_SMOD_MASK)
/* NBYTES_MLNO Bit Fields */
#define DMA_NBYTES_MLNO_NBYTES_MASK              0xFFFFFFFFu
#define DMA_NBYTES_MLNO_NBYTES_SHIFT             0
#define DMA_NBYTES_MLNO_NBYTES_WIDTH             32
#define DMA_NBYTES_MLNO_NBYTES(x)                (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLNO_NBYTES_SHIFT))&DMA_NBYTES_MLNO_NBYTES_MASK)
/* NBYTES_MLOFFNO Bit Fields */
#define DMA_NBYTES_MLOFFNO_NBYTES_MASK           0x3FFFFFFFu
#define DMA_NBYTES_MLOFFNO_NBYTES_SHIFT          0
#define DMA_NBYTES_MLOFFNO_NBYTES_WIDTH          30
#define DMA_NBYTES_MLOFFNO_NBYTES(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFNO_NBYTES_SHIFT))&DMA_NBYTES_MLOFFNO_NBYTES_MASK)
#define DMA_NBYTES_MLOFFNO_DMLOE_MASK            0x40000000u
#define DMA_NBYTES_MLOFFNO_DMLOE_SHIFT           30
#define DMA_NBYTES_MLOFFNO_DMLOE_WIDTH           1
#define DMA_NBYTES_MLOFFNO_DMLOE(x)              (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFNO_DMLOE_SHIFT))&DMA_NBYTES_MLOFFNO_DMLOE_MASK)
#define DMA_NBYTES_MLOFFNO_SMLOE_MASK            0x80000000u
#define DMA_NBYTES_MLOFFNO_SMLOE_SHIFT           31
#define DMA_NBYTES_MLOFFNO_SMLOE_WIDTH           1
#define DMA_NBYTES_MLOFFNO_SMLOE(x)              (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFNO_SMLOE_SHIFT))&DMA_NBYTES_MLOFFNO_SMLOE_MASK)
/* NBYTES_MLOFFYES Bit Fields */
#define DMA_NBYTES_MLOFFYES_NBYTES_MASK          0x3FFu
#define DMA_NBYTES_MLOFFYES_NBYTES_SHIFT         0
#define DMA_NBYTES_MLOFFYES_NBYTES_WIDTH         10
#define DMA_NBYTES_MLOFFYES_NBYTES(x)            (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_NBYTES_SHIFT))&DMA_NBYTES_MLOFFYES_NBYTES_MASK)
#define DMA_NBYTES_MLOFFYES_MLOFF_MASK           0x3FFFFC00u
#define DMA_NBYTES_MLOFFYES_MLOFF_SHIFT          10
#define DMA_NBYTES_MLOFFYES_MLOFF_WIDTH          20
#define DMA_NBYTES_MLOFFYES_MLOFF(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_MLOFF_SHIFT))&DMA_NBYTES_MLOFFYES_MLOFF_MASK)
#define DMA_NBYTES_MLOFFYES_DMLOE_MASK           0x40000000u
#define DMA_NBYTES_MLOFFYES_DMLOE_SHIFT          30
#define DMA_NBYTES_MLOFFYES_DMLOE_WIDTH          1
#define DMA_NBYTES_MLOFFYES_DMLOE(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_DMLOE_SHIFT))&DMA_NBYTES_MLOFFYES_DMLOE_MASK)
#define DMA_NBYTES_MLOFFYES_SMLOE_MASK           0x80000000u
#define DMA_NBYTES_MLOFFYES_SMLOE_SHIFT          31
#define DMA_NBYTES_MLOFFYES_SMLOE_WIDTH          1
#define DMA_NBYTES_MLOFFYES_SMLOE(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_SMLOE_SHIFT))&DMA_NBYTES_MLOFFYES_SMLOE_MASK)
/* SLAST Bit Fields */
#define DMA_SLAST_SLAST_MASK                     0xFFFFFFFFu
#define DMA_SLAST_SLAST_SHIFT                    0
#define DMA_SLAST_SLAST_WIDTH                    32
#define DMA_SLAST_SLAST(x)                       (((uint32_t)(((uint32_t)(x))<<DMA_SLAST_SLAST_SHIFT))&DMA_SLAST_SLAST_MASK)
/* DADDR Bit Fields */
#define DMA_DADDR_DADDR_MASK                     0xFFFFFFFFu
#define DMA_DADDR_DADDR_SHIFT                    0
#define DMA_DADDR_DADDR_WIDTH                    32
#define DMA_DADDR_DADDR(x)                       (((uint32_t)(((uint32_t)(x))<<DMA_DADDR_DADDR_SHIFT))&DMA_DADDR_DADDR_MASK)
/* DOFF Bit Fields */
#define DMA_DOFF_DOFF_MASK                       0xFFFFu
#define DMA_DOFF_DOFF_SHIFT                      0
#define DMA_DOFF_DOFF_WIDTH                      16
#define DMA_DOFF_DOFF(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_DOFF_DOFF_SHIFT))&DMA_DOFF_DOFF_MASK)
/* CITER_ELINKNO Bit Fields */
#define DMA_CITER_ELINKNO_CITER_MASK             0x7FFFu
#define DMA_CITER_ELINKNO_CITER_SHIFT            0
#define DMA_CITER_ELINKNO_CITER_WIDTH            15
#define DMA_CITER_ELINKNO_CITER(x)               (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKNO_CITER_SHIFT))&DMA_CITER_ELINKNO_CITER_MASK)
#define DMA_CITER_ELINKNO_ELINK_MASK             0x8000u
#define DMA_CITER_ELINKNO_ELINK_SHIFT            15
#define DMA_CITER_ELINKNO_ELINK_WIDTH            1
#define DMA_CITER_ELINKNO_ELINK(x)               (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKNO_ELINK_SHIFT))&DMA_CITER_ELINKNO_ELINK_MASK)
/* CITER_ELINKYES Bit Fields */
#define DMA_CITER_ELINKYES_CITER_MASK            0x1FFu
#define DMA_CITER_ELINKYES_CITER_SHIFT           0
#define DMA_CITER_ELINKYES_CITER_WIDTH           9
#define DMA_CITER_ELINKYES_CITER(x)              (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKYES_CITER_SHIFT))&DMA_CITER_ELINKYES_CITER_MASK)
#define DMA_CITER_ELINKYES_LINKCH_MASK           0x3E00u
#define DMA_CITER_ELINKYES_LINKCH_SHIFT          9
#define DMA_CITER_ELINKYES_LINKCH_WIDTH          5
#define DMA_CITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKYES_LINKCH_SHIFT))&DMA_CITER_ELINKYES_LINKCH_MASK)
#define DMA_CITER_ELINKYES_ELINK_MASK            0x8000u
#define DMA_CITER_ELINKYES_ELINK_SHIFT           15
#define DMA_CITER_ELINKYES_ELINK_WIDTH           1
#define DMA_CITER_ELINKYES_ELINK(x)              (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKYES_ELINK_SHIFT))&DMA_CITER_ELINKYES_ELINK_MASK)
/* DLAST_SGA Bit Fields */
#define DMA_DLAST_SGA_DLASTSGA_MASK              0xFFFFFFFFu
#define DMA_DLAST_SGA_DLASTSGA_SHIFT             0
#define DMA_DLAST_SGA_DLASTSGA_WIDTH             32
#define DMA_DLAST_SGA_DLASTSGA(x)                (((uint32_t)(((uint32_t)(x))<<DMA_DLAST_SGA_DLASTSGA_SHIFT))&DMA_DLAST_SGA_DLASTSGA_MASK)
/* CSR Bit Fields */
#define DMA_CSR_START_MASK                       0x1u
#define DMA_CSR_START_SHIFT                      0
#define DMA_CSR_START_WIDTH                      1
#define DMA_CSR_START(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_CSR_START_SHIFT))&DMA_CSR_START_MASK)
#define DMA_CSR_INTMAJOR_MASK                    0x2u
#define DMA_CSR_INTMAJOR_SHIFT                   1
#define DMA_CSR_INTMAJOR_WIDTH                   1
#define DMA_CSR_INTMAJOR(x)                      (((uint16_t)(((uint16_t)(x))<<DMA_CSR_INTMAJOR_SHIFT))&DMA_CSR_INTMAJOR_MASK)
#define DMA_CSR_INTHALF_MASK                     0x4u
#define DMA_CSR_INTHALF_SHIFT                    2
#define DMA_CSR_INTHALF_WIDTH                    1
#define DMA_CSR_INTHALF(x)                       (((uint16_t)(((uint16_t)(x))<<DMA_CSR_INTHALF_SHIFT))&DMA_CSR_INTHALF_MASK)
#define DMA_CSR_DREQ_MASK                        0x8u
#define DMA_CSR_DREQ_SHIFT                       3
#define DMA_CSR_DREQ_WIDTH                       1
#define DMA_CSR_DREQ(x)                          (((uint16_t)(((uint16_t)(x))<<DMA_CSR_DREQ_SHIFT))&DMA_CSR_DREQ_MASK)
#define DMA_CSR_ESG_MASK                         0x10u
#define DMA_CSR_ESG_SHIFT                        4
#define DMA_CSR_ESG_WIDTH                        1
#define DMA_CSR_ESG(x)                           (((uint16_t)(((uint16_t)(x))<<DMA_CSR_ESG_SHIFT))&DMA_CSR_ESG_MASK)
#define DMA_CSR_MAJORELINK_MASK                  0x20u
#define DMA_CSR_MAJORELINK_SHIFT                 5
#define DMA_CSR_MAJORELINK_WIDTH                 1
#define DMA_CSR_MAJORELINK(x)                    (((uint16_t)(((uint16_t)(x))<<DMA_CSR_MAJORELINK_SHIFT))&DMA_CSR_MAJORELINK_MASK)
#define DMA_CSR_ACTIVE_MASK                      0x40u
#define DMA_CSR_ACTIVE_SHIFT                     6
#define DMA_CSR_ACTIVE_WIDTH                     1
#define DMA_CSR_ACTIVE(x)                        (((uint16_t)(((uint16_t)(x))<<DMA_CSR_ACTIVE_SHIFT))&DMA_CSR_ACTIVE_MASK)
#define DMA_CSR_DONE_MASK                        0x80u
#define DMA_CSR_DONE_SHIFT                       7
#define DMA_CSR_DONE_WIDTH                       1
#define DMA_CSR_DONE(x)                          (((uint16_t)(((uint16_t)(x))<<DMA_CSR_DONE_SHIFT))&DMA_CSR_DONE_MASK)
#define DMA_CSR_MAJORLINKCH_MASK                 0x1F00u
#define DMA_CSR_MAJORLINKCH_SHIFT                8
#define DMA_CSR_MAJORLINKCH_WIDTH                5
#define DMA_CSR_MAJORLINKCH(x)                   (((uint16_t)(((uint16_t)(x))<<DMA_CSR_MAJORLINKCH_SHIFT))&DMA_CSR_MAJORLINKCH_MASK)
#define DMA_CSR_BWC_MASK                         0xC000u
#define DMA_CSR_BWC_SHIFT                        14
#define DMA_CSR_BWC_WIDTH                        2
#define DMA_CSR_BWC(x)                           (((uint16_t)(((uint16_t)(x))<<DMA_CSR_BWC_SHIFT))&DMA_CSR_BWC_MASK)
/* BITER_ELINKNO Bit Fields */
#define DMA_BITER_ELINKNO_BITER_MASK             0x7FFFu
#define DMA_BITER_ELINKNO_BITER_SHIFT            0
#define DMA_BITER_ELINKNO_BITER_WIDTH            15
#define DMA_BITER_ELINKNO_BITER(x)               (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKNO_BITER_SHIFT))&DMA_BITER_ELINKNO_BITER_MASK)
#define DMA_BITER_ELINKNO_ELINK_MASK             0x8000u
#define DMA_BITER_ELINKNO_ELINK_SHIFT            15
#define DMA_BITER_ELINKNO_ELINK_WIDTH            1
#define DMA_BITER_ELINKNO_ELINK(x)               (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKNO_ELINK_SHIFT))&DMA_BITER_ELINKNO_ELINK_MASK)
/* BITER_ELINKYES Bit Fields */
#define DMA_BITER_ELINKYES_BITER_MASK            0x1FFu
#define DMA_BITER_ELINKYES_BITER_SHIFT           0
#define DMA_BITER_ELINKYES_BITER_WIDTH           9
#define DMA_BITER_ELINKYES_BITER(x)              (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKYES_BITER_SHIFT))&DMA_BITER_ELINKYES_BITER_MASK)
#define DMA_BITER_ELINKYES_LINKCH_MASK           0x3E00u
#define DMA_BITER_ELINKYES_LINKCH_SHIFT          9
#define DMA_BITER_ELINKYES_LINKCH_WIDTH          5
#define DMA_BITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKYES_LINKCH_SHIFT))&DMA_BITER_ELINKYES_LINKCH_MASK)
#define DMA_BITER_ELINKYES_ELINK_MASK            0x8000u
#define DMA_BITER_ELINKYES_ELINK_SHIFT           15
#define DMA_BITER_ELINKYES_ELINK_WIDTH           1
#define DMA_BITER_ELINKYES_ELINK(x)              (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKYES_ELINK_SHIFT))&DMA_BITER_ELINKYES_ELINK_MASK)

/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA base address */
#define DMA_BASE                                 (0x40008000u)
/** Peripheral DMA base pointer */
#define DMA0                                     ((DMA_Type *)DMA_BASE)
#define DMA_BASE_PTR                             (DMA0)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS                           { DMA_BASE }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA0 }

/* ----------------------------------------------------------------------------
   -- DMA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Accessor_Macros DMA - Register accessor macros
 * @{
 */


/* DMA - Register instance definitions */
/* DMA */
#define DMA_CR                                   DMA_CR_REG(DMA0)
#define DMA_ES                                   DMA_ES_REG(DMA0)
#define DMA_ERQ                                  DMA_ERQ_REG(DMA0)
#define DMA_EEI                                  DMA_EEI_REG(DMA0)
#define DMA_CEEI                                 DMA_CEEI_REG(DMA0)
#define DMA_SEEI                                 DMA_SEEI_REG(DMA0)
#define DMA_CERQ                                 DMA_CERQ_REG(DMA0)
#define DMA_SERQ                                 DMA_SERQ_REG(DMA0)
#define DMA_CDNE                                 DMA_CDNE_REG(DMA0)
#define DMA_SSRT                                 DMA_SSRT_REG(DMA0)
#define DMA_CERR                                 DMA_CERR_REG(DMA0)
#define DMA_CINT                                 DMA_CINT_REG(DMA0)
#define DMA_INT                                  DMA_INT_REG(DMA0)
#define DMA_ERR                                  DMA_ERR_REG(DMA0)
#define DMA_HRS                                  DMA_HRS_REG(DMA0)
#define DMA_EARS                                 DMA_EARS_REG(DMA0)
#define DMA_DCHPRI3                              DMA_DCHPRI3_REG(DMA0)
#define DMA_DCHPRI2                              DMA_DCHPRI2_REG(DMA0)
#define DMA_DCHPRI1                              DMA_DCHPRI1_REG(DMA0)
#define DMA_DCHPRI0                              DMA_DCHPRI0_REG(DMA0)
#define DMA_DCHPRI7                              DMA_DCHPRI7_REG(DMA0)
#define DMA_DCHPRI6                              DMA_DCHPRI6_REG(DMA0)
#define DMA_DCHPRI5                              DMA_DCHPRI5_REG(DMA0)
#define DMA_DCHPRI4                              DMA_DCHPRI4_REG(DMA0)
#define DMA_DCHPRI11                             DMA_DCHPRI11_REG(DMA0)
#define DMA_DCHPRI10                             DMA_DCHPRI10_REG(DMA0)
#define DMA_DCHPRI9                              DMA_DCHPRI9_REG(DMA0)
#define DMA_DCHPRI8                              DMA_DCHPRI8_REG(DMA0)
#define DMA_DCHPRI15                             DMA_DCHPRI15_REG(DMA0)
#define DMA_DCHPRI14                             DMA_DCHPRI14_REG(DMA0)
#define DMA_DCHPRI13                             DMA_DCHPRI13_REG(DMA0)
#define DMA_DCHPRI12                             DMA_DCHPRI12_REG(DMA0)
#define DMA_DCHPRI19                             DMA_DCHPRI19_REG(DMA0)
#define DMA_DCHPRI18                             DMA_DCHPRI18_REG(DMA0)
#define DMA_DCHPRI17                             DMA_DCHPRI17_REG(DMA0)
#define DMA_DCHPRI16                             DMA_DCHPRI16_REG(DMA0)
#define DMA_DCHPRI23                             DMA_DCHPRI23_REG(DMA0)
#define DMA_DCHPRI22                             DMA_DCHPRI22_REG(DMA0)
#define DMA_DCHPRI21                             DMA_DCHPRI21_REG(DMA0)
#define DMA_DCHPRI20                             DMA_DCHPRI20_REG(DMA0)
#define DMA_DCHPRI27                             DMA_DCHPRI27_REG(DMA0)
#define DMA_DCHPRI26                             DMA_DCHPRI26_REG(DMA0)
#define DMA_DCHPRI25                             DMA_DCHPRI25_REG(DMA0)
#define DMA_DCHPRI24                             DMA_DCHPRI24_REG(DMA0)
#define DMA_DCHPRI31                             DMA_DCHPRI31_REG(DMA0)
#define DMA_DCHPRI30                             DMA_DCHPRI30_REG(DMA0)
#define DMA_DCHPRI29                             DMA_DCHPRI29_REG(DMA0)
#define DMA_DCHPRI28                             DMA_DCHPRI28_REG(DMA0)
#define DMA_TCD0_SADDR                           DMA_SADDR_REG(DMA0,0)
#define DMA_TCD0_SOFF                            DMA_SOFF_REG(DMA0,0)
#define DMA_TCD0_ATTR                            DMA_ATTR_REG(DMA0,0)
#define DMA_TCD0_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,0)
#define DMA_TCD0_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,0)
#define DMA_TCD0_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,0)
#define DMA_TCD0_SLAST                           DMA_SLAST_REG(DMA0,0)
#define DMA_TCD0_DADDR                           DMA_DADDR_REG(DMA0,0)
#define DMA_TCD0_DOFF                            DMA_DOFF_REG(DMA0,0)
#define DMA_TCD0_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,0)
#define DMA_TCD0_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,0)
#define DMA_TCD0_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,0)
#define DMA_TCD0_CSR                             DMA_CSR_REG(DMA0,0)
#define DMA_TCD0_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,0)
#define DMA_TCD0_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,0)
#define DMA_TCD1_SADDR                           DMA_SADDR_REG(DMA0,1)
#define DMA_TCD1_SOFF                            DMA_SOFF_REG(DMA0,1)
#define DMA_TCD1_ATTR                            DMA_ATTR_REG(DMA0,1)
#define DMA_TCD1_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,1)
#define DMA_TCD1_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,1)
#define DMA_TCD1_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,1)
#define DMA_TCD1_SLAST                           DMA_SLAST_REG(DMA0,1)
#define DMA_TCD1_DADDR                           DMA_DADDR_REG(DMA0,1)
#define DMA_TCD1_DOFF                            DMA_DOFF_REG(DMA0,1)
#define DMA_TCD1_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,1)
#define DMA_TCD1_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,1)
#define DMA_TCD1_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,1)
#define DMA_TCD1_CSR                             DMA_CSR_REG(DMA0,1)
#define DMA_TCD1_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,1)
#define DMA_TCD1_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,1)
#define DMA_TCD2_SADDR                           DMA_SADDR_REG(DMA0,2)
#define DMA_TCD2_SOFF                            DMA_SOFF_REG(DMA0,2)
#define DMA_TCD2_ATTR                            DMA_ATTR_REG(DMA0,2)
#define DMA_TCD2_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,2)
#define DMA_TCD2_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,2)
#define DMA_TCD2_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,2)
#define DMA_TCD2_SLAST                           DMA_SLAST_REG(DMA0,2)
#define DMA_TCD2_DADDR                           DMA_DADDR_REG(DMA0,2)
#define DMA_TCD2_DOFF                            DMA_DOFF_REG(DMA0,2)
#define DMA_TCD2_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,2)
#define DMA_TCD2_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,2)
#define DMA_TCD2_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,2)
#define DMA_TCD2_CSR                             DMA_CSR_REG(DMA0,2)
#define DMA_TCD2_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,2)
#define DMA_TCD2_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,2)
#define DMA_TCD3_SADDR                           DMA_SADDR_REG(DMA0,3)
#define DMA_TCD3_SOFF                            DMA_SOFF_REG(DMA0,3)
#define DMA_TCD3_ATTR                            DMA_ATTR_REG(DMA0,3)
#define DMA_TCD3_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,3)
#define DMA_TCD3_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,3)
#define DMA_TCD3_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,3)
#define DMA_TCD3_SLAST                           DMA_SLAST_REG(DMA0,3)
#define DMA_TCD3_DADDR                           DMA_DADDR_REG(DMA0,3)
#define DMA_TCD3_DOFF                            DMA_DOFF_REG(DMA0,3)
#define DMA_TCD3_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,3)
#define DMA_TCD3_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,3)
#define DMA_TCD3_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,3)
#define DMA_TCD3_CSR                             DMA_CSR_REG(DMA0,3)
#define DMA_TCD3_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,3)
#define DMA_TCD3_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,3)
#define DMA_TCD4_SADDR                           DMA_SADDR_REG(DMA0,4)
#define DMA_TCD4_SOFF                            DMA_SOFF_REG(DMA0,4)
#define DMA_TCD4_ATTR                            DMA_ATTR_REG(DMA0,4)
#define DMA_TCD4_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,4)
#define DMA_TCD4_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,4)
#define DMA_TCD4_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,4)
#define DMA_TCD4_SLAST                           DMA_SLAST_REG(DMA0,4)
#define DMA_TCD4_DADDR                           DMA_DADDR_REG(DMA0,4)
#define DMA_TCD4_DOFF                            DMA_DOFF_REG(DMA0,4)
#define DMA_TCD4_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,4)
#define DMA_TCD4_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,4)
#define DMA_TCD4_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,4)
#define DMA_TCD4_CSR                             DMA_CSR_REG(DMA0,4)
#define DMA_TCD4_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,4)
#define DMA_TCD4_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,4)
#define DMA_TCD5_SADDR                           DMA_SADDR_REG(DMA0,5)
#define DMA_TCD5_SOFF                            DMA_SOFF_REG(DMA0,5)
#define DMA_TCD5_ATTR                            DMA_ATTR_REG(DMA0,5)
#define DMA_TCD5_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,5)
#define DMA_TCD5_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,5)
#define DMA_TCD5_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,5)
#define DMA_TCD5_SLAST                           DMA_SLAST_REG(DMA0,5)
#define DMA_TCD5_DADDR                           DMA_DADDR_REG(DMA0,5)
#define DMA_TCD5_DOFF                            DMA_DOFF_REG(DMA0,5)
#define DMA_TCD5_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,5)
#define DMA_TCD5_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,5)
#define DMA_TCD5_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,5)
#define DMA_TCD5_CSR                             DMA_CSR_REG(DMA0,5)
#define DMA_TCD5_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,5)
#define DMA_TCD5_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,5)
#define DMA_TCD6_SADDR                           DMA_SADDR_REG(DMA0,6)
#define DMA_TCD6_SOFF                            DMA_SOFF_REG(DMA0,6)
#define DMA_TCD6_ATTR                            DMA_ATTR_REG(DMA0,6)
#define DMA_TCD6_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,6)
#define DMA_TCD6_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,6)
#define DMA_TCD6_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,6)
#define DMA_TCD6_SLAST                           DMA_SLAST_REG(DMA0,6)
#define DMA_TCD6_DADDR                           DMA_DADDR_REG(DMA0,6)
#define DMA_TCD6_DOFF                            DMA_DOFF_REG(DMA0,6)
#define DMA_TCD6_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,6)
#define DMA_TCD6_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,6)
#define DMA_TCD6_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,6)
#define DMA_TCD6_CSR                             DMA_CSR_REG(DMA0,6)
#define DMA_TCD6_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,6)
#define DMA_TCD6_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,6)
#define DMA_TCD7_SADDR                           DMA_SADDR_REG(DMA0,7)
#define DMA_TCD7_SOFF                            DMA_SOFF_REG(DMA0,7)
#define DMA_TCD7_ATTR                            DMA_ATTR_REG(DMA0,7)
#define DMA_TCD7_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,7)
#define DMA_TCD7_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,7)
#define DMA_TCD7_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,7)
#define DMA_TCD7_SLAST                           DMA_SLAST_REG(DMA0,7)
#define DMA_TCD7_DADDR                           DMA_DADDR_REG(DMA0,7)
#define DMA_TCD7_DOFF                            DMA_DOFF_REG(DMA0,7)
#define DMA_TCD7_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,7)
#define DMA_TCD7_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,7)
#define DMA_TCD7_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,7)
#define DMA_TCD7_CSR                             DMA_CSR_REG(DMA0,7)
#define DMA_TCD7_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,7)
#define DMA_TCD7_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,7)
#define DMA_TCD8_SADDR                           DMA_SADDR_REG(DMA0,8)
#define DMA_TCD8_SOFF                            DMA_SOFF_REG(DMA0,8)
#define DMA_TCD8_ATTR                            DMA_ATTR_REG(DMA0,8)
#define DMA_TCD8_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,8)
#define DMA_TCD8_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,8)
#define DMA_TCD8_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,8)
#define DMA_TCD8_SLAST                           DMA_SLAST_REG(DMA0,8)
#define DMA_TCD8_DADDR                           DMA_DADDR_REG(DMA0,8)
#define DMA_TCD8_DOFF                            DMA_DOFF_REG(DMA0,8)
#define DMA_TCD8_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,8)
#define DMA_TCD8_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,8)
#define DMA_TCD8_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,8)
#define DMA_TCD8_CSR                             DMA_CSR_REG(DMA0,8)
#define DMA_TCD8_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,8)
#define DMA_TCD8_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,8)
#define DMA_TCD9_SADDR                           DMA_SADDR_REG(DMA0,9)
#define DMA_TCD9_SOFF                            DMA_SOFF_REG(DMA0,9)
#define DMA_TCD9_ATTR                            DMA_ATTR_REG(DMA0,9)
#define DMA_TCD9_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,9)
#define DMA_TCD9_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,9)
#define DMA_TCD9_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,9)
#define DMA_TCD9_SLAST                           DMA_SLAST_REG(DMA0,9)
#define DMA_TCD9_DADDR                           DMA_DADDR_REG(DMA0,9)
#define DMA_TCD9_DOFF                            DMA_DOFF_REG(DMA0,9)
#define DMA_TCD9_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,9)
#define DMA_TCD9_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,9)
#define DMA_TCD9_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,9)
#define DMA_TCD9_CSR                             DMA_CSR_REG(DMA0,9)
#define DMA_TCD9_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,9)
#define DMA_TCD9_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,9)
#define DMA_TCD10_SADDR                          DMA_SADDR_REG(DMA0,10)
#define DMA_TCD10_SOFF                           DMA_SOFF_REG(DMA0,10)
#define DMA_TCD10_ATTR                           DMA_ATTR_REG(DMA0,10)
#define DMA_TCD10_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,10)
#define DMA_TCD10_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,10)
#define DMA_TCD10_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,10)
#define DMA_TCD10_SLAST                          DMA_SLAST_REG(DMA0,10)
#define DMA_TCD10_DADDR                          DMA_DADDR_REG(DMA0,10)
#define DMA_TCD10_DOFF                           DMA_DOFF_REG(DMA0,10)
#define DMA_TCD10_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,10)
#define DMA_TCD10_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,10)
#define DMA_TCD10_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,10)
#define DMA_TCD10_CSR                            DMA_CSR_REG(DMA0,10)
#define DMA_TCD10_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,10)
#define DMA_TCD10_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,10)
#define DMA_TCD11_SADDR                          DMA_SADDR_REG(DMA0,11)
#define DMA_TCD11_SOFF                           DMA_SOFF_REG(DMA0,11)
#define DMA_TCD11_ATTR                           DMA_ATTR_REG(DMA0,11)
#define DMA_TCD11_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,11)
#define DMA_TCD11_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,11)
#define DMA_TCD11_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,11)
#define DMA_TCD11_SLAST                          DMA_SLAST_REG(DMA0,11)
#define DMA_TCD11_DADDR                          DMA_DADDR_REG(DMA0,11)
#define DMA_TCD11_DOFF                           DMA_DOFF_REG(DMA0,11)
#define DMA_TCD11_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,11)
#define DMA_TCD11_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,11)
#define DMA_TCD11_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,11)
#define DMA_TCD11_CSR                            DMA_CSR_REG(DMA0,11)
#define DMA_TCD11_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,11)
#define DMA_TCD11_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,11)
#define DMA_TCD12_SADDR                          DMA_SADDR_REG(DMA0,12)
#define DMA_TCD12_SOFF                           DMA_SOFF_REG(DMA0,12)
#define DMA_TCD12_ATTR                           DMA_ATTR_REG(DMA0,12)
#define DMA_TCD12_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,12)
#define DMA_TCD12_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,12)
#define DMA_TCD12_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,12)
#define DMA_TCD12_SLAST                          DMA_SLAST_REG(DMA0,12)
#define DMA_TCD12_DADDR                          DMA_DADDR_REG(DMA0,12)
#define DMA_TCD12_DOFF                           DMA_DOFF_REG(DMA0,12)
#define DMA_TCD12_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,12)
#define DMA_TCD12_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,12)
#define DMA_TCD12_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,12)
#define DMA_TCD12_CSR                            DMA_CSR_REG(DMA0,12)
#define DMA_TCD12_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,12)
#define DMA_TCD12_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,12)
#define DMA_TCD13_SADDR                          DMA_SADDR_REG(DMA0,13)
#define DMA_TCD13_SOFF                           DMA_SOFF_REG(DMA0,13)
#define DMA_TCD13_ATTR                           DMA_ATTR_REG(DMA0,13)
#define DMA_TCD13_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,13)
#define DMA_TCD13_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,13)
#define DMA_TCD13_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,13)
#define DMA_TCD13_SLAST                          DMA_SLAST_REG(DMA0,13)
#define DMA_TCD13_DADDR                          DMA_DADDR_REG(DMA0,13)
#define DMA_TCD13_DOFF                           DMA_DOFF_REG(DMA0,13)
#define DMA_TCD13_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,13)
#define DMA_TCD13_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,13)
#define DMA_TCD13_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,13)
#define DMA_TCD13_CSR                            DMA_CSR_REG(DMA0,13)
#define DMA_TCD13_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,13)
#define DMA_TCD13_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,13)
#define DMA_TCD14_SADDR                          DMA_SADDR_REG(DMA0,14)
#define DMA_TCD14_SOFF                           DMA_SOFF_REG(DMA0,14)
#define DMA_TCD14_ATTR                           DMA_ATTR_REG(DMA0,14)
#define DMA_TCD14_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,14)
#define DMA_TCD14_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,14)
#define DMA_TCD14_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,14)
#define DMA_TCD14_SLAST                          DMA_SLAST_REG(DMA0,14)
#define DMA_TCD14_DADDR                          DMA_DADDR_REG(DMA0,14)
#define DMA_TCD14_DOFF                           DMA_DOFF_REG(DMA0,14)
#define DMA_TCD14_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,14)
#define DMA_TCD14_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,14)
#define DMA_TCD14_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,14)
#define DMA_TCD14_CSR                            DMA_CSR_REG(DMA0,14)
#define DMA_TCD14_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,14)
#define DMA_TCD14_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,14)
#define DMA_TCD15_SADDR                          DMA_SADDR_REG(DMA0,15)
#define DMA_TCD15_SOFF                           DMA_SOFF_REG(DMA0,15)
#define DMA_TCD15_ATTR                           DMA_ATTR_REG(DMA0,15)
#define DMA_TCD15_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,15)
#define DMA_TCD15_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,15)
#define DMA_TCD15_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,15)
#define DMA_TCD15_SLAST                          DMA_SLAST_REG(DMA0,15)
#define DMA_TCD15_DADDR                          DMA_DADDR_REG(DMA0,15)
#define DMA_TCD15_DOFF                           DMA_DOFF_REG(DMA0,15)
#define DMA_TCD15_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,15)
#define DMA_TCD15_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,15)
#define DMA_TCD15_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,15)
#define DMA_TCD15_CSR                            DMA_CSR_REG(DMA0,15)
#define DMA_TCD15_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,15)
#define DMA_TCD15_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,15)
#define DMA_TCD16_SADDR                          DMA_SADDR_REG(DMA0,16)
#define DMA_TCD16_SOFF                           DMA_SOFF_REG(DMA0,16)
#define DMA_TCD16_ATTR                           DMA_ATTR_REG(DMA0,16)
#define DMA_TCD16_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,16)
#define DMA_TCD16_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,16)
#define DMA_TCD16_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,16)
#define DMA_TCD16_SLAST                          DMA_SLAST_REG(DMA0,16)
#define DMA_TCD16_DADDR                          DMA_DADDR_REG(DMA0,16)
#define DMA_TCD16_DOFF                           DMA_DOFF_REG(DMA0,16)
#define DMA_TCD16_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,16)
#define DMA_TCD16_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,16)
#define DMA_TCD16_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,16)
#define DMA_TCD16_CSR                            DMA_CSR_REG(DMA0,16)
#define DMA_TCD16_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,16)
#define DMA_TCD16_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,16)
#define DMA_TCD17_SADDR                          DMA_SADDR_REG(DMA0,17)
#define DMA_TCD17_SOFF                           DMA_SOFF_REG(DMA0,17)
#define DMA_TCD17_ATTR                           DMA_ATTR_REG(DMA0,17)
#define DMA_TCD17_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,17)
#define DMA_TCD17_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,17)
#define DMA_TCD17_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,17)
#define DMA_TCD17_SLAST                          DMA_SLAST_REG(DMA0,17)
#define DMA_TCD17_DADDR                          DMA_DADDR_REG(DMA0,17)
#define DMA_TCD17_DOFF                           DMA_DOFF_REG(DMA0,17)
#define DMA_TCD17_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,17)
#define DMA_TCD17_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,17)
#define DMA_TCD17_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,17)
#define DMA_TCD17_CSR                            DMA_CSR_REG(DMA0,17)
#define DMA_TCD17_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,17)
#define DMA_TCD17_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,17)
#define DMA_TCD18_SADDR                          DMA_SADDR_REG(DMA0,18)
#define DMA_TCD18_SOFF                           DMA_SOFF_REG(DMA0,18)
#define DMA_TCD18_ATTR                           DMA_ATTR_REG(DMA0,18)
#define DMA_TCD18_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,18)
#define DMA_TCD18_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,18)
#define DMA_TCD18_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,18)
#define DMA_TCD18_SLAST                          DMA_SLAST_REG(DMA0,18)
#define DMA_TCD18_DADDR                          DMA_DADDR_REG(DMA0,18)
#define DMA_TCD18_DOFF                           DMA_DOFF_REG(DMA0,18)
#define DMA_TCD18_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,18)
#define DMA_TCD18_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,18)
#define DMA_TCD18_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,18)
#define DMA_TCD18_CSR                            DMA_CSR_REG(DMA0,18)
#define DMA_TCD18_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,18)
#define DMA_TCD18_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,18)
#define DMA_TCD19_SADDR                          DMA_SADDR_REG(DMA0,19)
#define DMA_TCD19_SOFF                           DMA_SOFF_REG(DMA0,19)
#define DMA_TCD19_ATTR                           DMA_ATTR_REG(DMA0,19)
#define DMA_TCD19_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,19)
#define DMA_TCD19_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,19)
#define DMA_TCD19_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,19)
#define DMA_TCD19_SLAST                          DMA_SLAST_REG(DMA0,19)
#define DMA_TCD19_DADDR                          DMA_DADDR_REG(DMA0,19)
#define DMA_TCD19_DOFF                           DMA_DOFF_REG(DMA0,19)
#define DMA_TCD19_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,19)
#define DMA_TCD19_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,19)
#define DMA_TCD19_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,19)
#define DMA_TCD19_CSR                            DMA_CSR_REG(DMA0,19)
#define DMA_TCD19_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,19)
#define DMA_TCD19_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,19)
#define DMA_TCD20_SADDR                          DMA_SADDR_REG(DMA0,20)
#define DMA_TCD20_SOFF                           DMA_SOFF_REG(DMA0,20)
#define DMA_TCD20_ATTR                           DMA_ATTR_REG(DMA0,20)
#define DMA_TCD20_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,20)
#define DMA_TCD20_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,20)
#define DMA_TCD20_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,20)
#define DMA_TCD20_SLAST                          DMA_SLAST_REG(DMA0,20)
#define DMA_TCD20_DADDR                          DMA_DADDR_REG(DMA0,20)
#define DMA_TCD20_DOFF                           DMA_DOFF_REG(DMA0,20)
#define DMA_TCD20_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,20)
#define DMA_TCD20_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,20)
#define DMA_TCD20_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,20)
#define DMA_TCD20_CSR                            DMA_CSR_REG(DMA0,20)
#define DMA_TCD20_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,20)
#define DMA_TCD20_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,20)
#define DMA_TCD21_SADDR                          DMA_SADDR_REG(DMA0,21)
#define DMA_TCD21_SOFF                           DMA_SOFF_REG(DMA0,21)
#define DMA_TCD21_ATTR                           DMA_ATTR_REG(DMA0,21)
#define DMA_TCD21_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,21)
#define DMA_TCD21_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,21)
#define DMA_TCD21_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,21)
#define DMA_TCD21_SLAST                          DMA_SLAST_REG(DMA0,21)
#define DMA_TCD21_DADDR                          DMA_DADDR_REG(DMA0,21)
#define DMA_TCD21_DOFF                           DMA_DOFF_REG(DMA0,21)
#define DMA_TCD21_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,21)
#define DMA_TCD21_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,21)
#define DMA_TCD21_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,21)
#define DMA_TCD21_CSR                            DMA_CSR_REG(DMA0,21)
#define DMA_TCD21_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,21)
#define DMA_TCD21_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,21)
#define DMA_TCD22_SADDR                          DMA_SADDR_REG(DMA0,22)
#define DMA_TCD22_SOFF                           DMA_SOFF_REG(DMA0,22)
#define DMA_TCD22_ATTR                           DMA_ATTR_REG(DMA0,22)
#define DMA_TCD22_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,22)
#define DMA_TCD22_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,22)
#define DMA_TCD22_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,22)
#define DMA_TCD22_SLAST                          DMA_SLAST_REG(DMA0,22)
#define DMA_TCD22_DADDR                          DMA_DADDR_REG(DMA0,22)
#define DMA_TCD22_DOFF                           DMA_DOFF_REG(DMA0,22)
#define DMA_TCD22_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,22)
#define DMA_TCD22_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,22)
#define DMA_TCD22_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,22)
#define DMA_TCD22_CSR                            DMA_CSR_REG(DMA0,22)
#define DMA_TCD22_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,22)
#define DMA_TCD22_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,22)
#define DMA_TCD23_SADDR                          DMA_SADDR_REG(DMA0,23)
#define DMA_TCD23_SOFF                           DMA_SOFF_REG(DMA0,23)
#define DMA_TCD23_ATTR                           DMA_ATTR_REG(DMA0,23)
#define DMA_TCD23_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,23)
#define DMA_TCD23_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,23)
#define DMA_TCD23_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,23)
#define DMA_TCD23_SLAST                          DMA_SLAST_REG(DMA0,23)
#define DMA_TCD23_DADDR                          DMA_DADDR_REG(DMA0,23)
#define DMA_TCD23_DOFF                           DMA_DOFF_REG(DMA0,23)
#define DMA_TCD23_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,23)
#define DMA_TCD23_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,23)
#define DMA_TCD23_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,23)
#define DMA_TCD23_CSR                            DMA_CSR_REG(DMA0,23)
#define DMA_TCD23_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,23)
#define DMA_TCD23_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,23)
#define DMA_TCD24_SADDR                          DMA_SADDR_REG(DMA0,24)
#define DMA_TCD24_SOFF                           DMA_SOFF_REG(DMA0,24)
#define DMA_TCD24_ATTR                           DMA_ATTR_REG(DMA0,24)
#define DMA_TCD24_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,24)
#define DMA_TCD24_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,24)
#define DMA_TCD24_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,24)
#define DMA_TCD24_SLAST                          DMA_SLAST_REG(DMA0,24)
#define DMA_TCD24_DADDR                          DMA_DADDR_REG(DMA0,24)
#define DMA_TCD24_DOFF                           DMA_DOFF_REG(DMA0,24)
#define DMA_TCD24_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,24)
#define DMA_TCD24_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,24)
#define DMA_TCD24_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,24)
#define DMA_TCD24_CSR                            DMA_CSR_REG(DMA0,24)
#define DMA_TCD24_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,24)
#define DMA_TCD24_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,24)
#define DMA_TCD25_SADDR                          DMA_SADDR_REG(DMA0,25)
#define DMA_TCD25_SOFF                           DMA_SOFF_REG(DMA0,25)
#define DMA_TCD25_ATTR                           DMA_ATTR_REG(DMA0,25)
#define DMA_TCD25_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,25)
#define DMA_TCD25_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,25)
#define DMA_TCD25_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,25)
#define DMA_TCD25_SLAST                          DMA_SLAST_REG(DMA0,25)
#define DMA_TCD25_DADDR                          DMA_DADDR_REG(DMA0,25)
#define DMA_TCD25_DOFF                           DMA_DOFF_REG(DMA0,25)
#define DMA_TCD25_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,25)
#define DMA_TCD25_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,25)
#define DMA_TCD25_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,25)
#define DMA_TCD25_CSR                            DMA_CSR_REG(DMA0,25)
#define DMA_TCD25_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,25)
#define DMA_TCD25_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,25)
#define DMA_TCD26_SADDR                          DMA_SADDR_REG(DMA0,26)
#define DMA_TCD26_SOFF                           DMA_SOFF_REG(DMA0,26)
#define DMA_TCD26_ATTR                           DMA_ATTR_REG(DMA0,26)
#define DMA_TCD26_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,26)
#define DMA_TCD26_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,26)
#define DMA_TCD26_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,26)
#define DMA_TCD26_SLAST                          DMA_SLAST_REG(DMA0,26)
#define DMA_TCD26_DADDR                          DMA_DADDR_REG(DMA0,26)
#define DMA_TCD26_DOFF                           DMA_DOFF_REG(DMA0,26)
#define DMA_TCD26_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,26)
#define DMA_TCD26_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,26)
#define DMA_TCD26_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,26)
#define DMA_TCD26_CSR                            DMA_CSR_REG(DMA0,26)
#define DMA_TCD26_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,26)
#define DMA_TCD26_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,26)
#define DMA_TCD27_SADDR                          DMA_SADDR_REG(DMA0,27)
#define DMA_TCD27_SOFF                           DMA_SOFF_REG(DMA0,27)
#define DMA_TCD27_ATTR                           DMA_ATTR_REG(DMA0,27)
#define DMA_TCD27_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,27)
#define DMA_TCD27_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,27)
#define DMA_TCD27_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,27)
#define DMA_TCD27_SLAST                          DMA_SLAST_REG(DMA0,27)
#define DMA_TCD27_DADDR                          DMA_DADDR_REG(DMA0,27)
#define DMA_TCD27_DOFF                           DMA_DOFF_REG(DMA0,27)
#define DMA_TCD27_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,27)
#define DMA_TCD27_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,27)
#define DMA_TCD27_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,27)
#define DMA_TCD27_CSR                            DMA_CSR_REG(DMA0,27)
#define DMA_TCD27_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,27)
#define DMA_TCD27_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,27)
#define DMA_TCD28_SADDR                          DMA_SADDR_REG(DMA0,28)
#define DMA_TCD28_SOFF                           DMA_SOFF_REG(DMA0,28)
#define DMA_TCD28_ATTR                           DMA_ATTR_REG(DMA0,28)
#define DMA_TCD28_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,28)
#define DMA_TCD28_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,28)
#define DMA_TCD28_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,28)
#define DMA_TCD28_SLAST                          DMA_SLAST_REG(DMA0,28)
#define DMA_TCD28_DADDR                          DMA_DADDR_REG(DMA0,28)
#define DMA_TCD28_DOFF                           DMA_DOFF_REG(DMA0,28)
#define DMA_TCD28_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,28)
#define DMA_TCD28_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,28)
#define DMA_TCD28_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,28)
#define DMA_TCD28_CSR                            DMA_CSR_REG(DMA0,28)
#define DMA_TCD28_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,28)
#define DMA_TCD28_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,28)
#define DMA_TCD29_SADDR                          DMA_SADDR_REG(DMA0,29)
#define DMA_TCD29_SOFF                           DMA_SOFF_REG(DMA0,29)
#define DMA_TCD29_ATTR                           DMA_ATTR_REG(DMA0,29)
#define DMA_TCD29_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,29)
#define DMA_TCD29_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,29)
#define DMA_TCD29_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,29)
#define DMA_TCD29_SLAST                          DMA_SLAST_REG(DMA0,29)
#define DMA_TCD29_DADDR                          DMA_DADDR_REG(DMA0,29)
#define DMA_TCD29_DOFF                           DMA_DOFF_REG(DMA0,29)
#define DMA_TCD29_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,29)
#define DMA_TCD29_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,29)
#define DMA_TCD29_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,29)
#define DMA_TCD29_CSR                            DMA_CSR_REG(DMA0,29)
#define DMA_TCD29_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,29)
#define DMA_TCD29_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,29)
#define DMA_TCD30_SADDR                          DMA_SADDR_REG(DMA0,30)
#define DMA_TCD30_SOFF                           DMA_SOFF_REG(DMA0,30)
#define DMA_TCD30_ATTR                           DMA_ATTR_REG(DMA0,30)
#define DMA_TCD30_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,30)
#define DMA_TCD30_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,30)
#define DMA_TCD30_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,30)
#define DMA_TCD30_SLAST                          DMA_SLAST_REG(DMA0,30)
#define DMA_TCD30_DADDR                          DMA_DADDR_REG(DMA0,30)
#define DMA_TCD30_DOFF                           DMA_DOFF_REG(DMA0,30)
#define DMA_TCD30_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,30)
#define DMA_TCD30_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,30)
#define DMA_TCD30_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,30)
#define DMA_TCD30_CSR                            DMA_CSR_REG(DMA0,30)
#define DMA_TCD30_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,30)
#define DMA_TCD30_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,30)
#define DMA_TCD31_SADDR                          DMA_SADDR_REG(DMA0,31)
#define DMA_TCD31_SOFF                           DMA_SOFF_REG(DMA0,31)
#define DMA_TCD31_ATTR                           DMA_ATTR_REG(DMA0,31)
#define DMA_TCD31_NBYTES_MLNO                    DMA_NBYTES_MLNO_REG(DMA0,31)
#define DMA_TCD31_NBYTES_MLOFFNO                 DMA_NBYTES_MLOFFNO_REG(DMA0,31)
#define DMA_TCD31_NBYTES_MLOFFYES                DMA_NBYTES_MLOFFYES_REG(DMA0,31)
#define DMA_TCD31_SLAST                          DMA_SLAST_REG(DMA0,31)
#define DMA_TCD31_DADDR                          DMA_DADDR_REG(DMA0,31)
#define DMA_TCD31_DOFF                           DMA_DOFF_REG(DMA0,31)
#define DMA_TCD31_CITER_ELINKNO                  DMA_CITER_ELINKNO_REG(DMA0,31)
#define DMA_TCD31_CITER_ELINKYES                 DMA_CITER_ELINKYES_REG(DMA0,31)
#define DMA_TCD31_DLASTSGA                       DMA_DLAST_SGA_REG(DMA0,31)
#define DMA_TCD31_CSR                            DMA_CSR_REG(DMA0,31)
#define DMA_TCD31_BITER_ELINKNO                  DMA_BITER_ELINKNO_REG(DMA0,31)
#define DMA_TCD31_BITER_ELINKYES                 DMA_BITER_ELINKYES_REG(DMA0,31)

/* DMA - Register array accessors */
#define DMA_SADDR(index)                         DMA_SADDR_REG(DMA0,index)
#define DMA_SOFF(index)                          DMA_SOFF_REG(DMA0,index)
#define DMA_ATTR(index)                          DMA_ATTR_REG(DMA0,index)
#define DMA_NBYTES_MLNO(index)                   DMA_NBYTES_MLNO_REG(DMA0,index)
#define DMA_NBYTES_MLOFFNO(index)                DMA_NBYTES_MLOFFNO_REG(DMA0,index)
#define DMA_NBYTES_MLOFFYES(index)               DMA_NBYTES_MLOFFYES_REG(DMA0,index)
#define DMA_SLAST(index)                         DMA_SLAST_REG(DMA0,index)
#define DMA_DADDR(index)                         DMA_DADDR_REG(DMA0,index)
#define DMA_DOFF(index)                          DMA_DOFF_REG(DMA0,index)
#define DMA_CITER_ELINKNO(index)                 DMA_CITER_ELINKNO_REG(DMA0,index)
#define DMA_CITER_ELINKYES(index)                DMA_CITER_ELINKYES_REG(DMA0,index)
#define DMA_DLAST_SGA(index)                     DMA_DLAST_SGA_REG(DMA0,index)
#define DMA_CSR(index)                           DMA_CSR_REG(DMA0,index)
#define DMA_BITER_ELINKNO(index)                 DMA_BITER_ELINKNO_REG(DMA0,index)
#define DMA_BITER_ELINKYES(index)                DMA_BITER_ELINKYES_REG(DMA0,index)

/*!
 * @}
 */ /* end of group DMA_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMAMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Peripheral_Access_Layer DMAMUX Peripheral Access Layer
 * @{
 */

/** DMAMUX - Register Layout Typedef */
typedef struct {
  __IO uint8_t CHCFG[32];                          /**< Channel Configuration register, array offset: 0x0, array step: 0x1 */
} DMAMUX_Type, *DMAMUX_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DMAMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Accessor_Macros DMAMUX - Register accessor macros
 * @{
 */


/* DMAMUX - Register accessors */
#define DMAMUX_CHCFG_REG(base,index)             ((base)->CHCFG[index])
#define DMAMUX_CHCFG_COUNT                       32

/*!
 * @}
 */ /* end of group DMAMUX_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DMAMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Masks DMAMUX Register Masks
 * @{
 */

/* CHCFG Bit Fields */
#define DMAMUX_CHCFG_SOURCE_MASK                 0x3Fu
#define DMAMUX_CHCFG_SOURCE_SHIFT                0
#define DMAMUX_CHCFG_SOURCE_WIDTH                6
#define DMAMUX_CHCFG_SOURCE(x)                   (((uint8_t)(((uint8_t)(x))<<DMAMUX_CHCFG_SOURCE_SHIFT))&DMAMUX_CHCFG_SOURCE_MASK)
#define DMAMUX_CHCFG_TRIG_MASK                   0x40u
#define DMAMUX_CHCFG_TRIG_SHIFT                  6
#define DMAMUX_CHCFG_TRIG_WIDTH                  1
#define DMAMUX_CHCFG_TRIG(x)                     (((uint8_t)(((uint8_t)(x))<<DMAMUX_CHCFG_TRIG_SHIFT))&DMAMUX_CHCFG_TRIG_MASK)
#define DMAMUX_CHCFG_ENBL_MASK                   0x80u
#define DMAMUX_CHCFG_ENBL_SHIFT                  7
#define DMAMUX_CHCFG_ENBL_WIDTH                  1
#define DMAMUX_CHCFG_ENBL(x)                     (((uint8_t)(((uint8_t)(x))<<DMAMUX_CHCFG_ENBL_SHIFT))&DMAMUX_CHCFG_ENBL_MASK)

/*!
 * @}
 */ /* end of group DMAMUX_Register_Masks */


/* DMAMUX - Peripheral instance base addresses */
/** Peripheral DMAMUX base address */
#define DMAMUX_BASE                              (0x40021000u)
/** Peripheral DMAMUX base pointer */
#define DMAMUX                                   ((DMAMUX_Type *)DMAMUX_BASE)
#define DMAMUX_BASE_PTR                          (DMAMUX)
/** Array initializer of DMAMUX peripheral base addresses */
#define DMAMUX_BASE_ADDRS                        { DMAMUX_BASE }
/** Array initializer of DMAMUX peripheral base pointers */
#define DMAMUX_BASE_PTRS                         { DMAMUX }

/* ----------------------------------------------------------------------------
   -- DMAMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Accessor_Macros DMAMUX - Register accessor macros
 * @{
 */


/* DMAMUX - Register instance definitions */
/* DMAMUX */
#define DMAMUX_CHCFG0                            DMAMUX_CHCFG_REG(DMAMUX,0)
#define DMAMUX_CHCFG1                            DMAMUX_CHCFG_REG(DMAMUX,1)
#define DMAMUX_CHCFG2                            DMAMUX_CHCFG_REG(DMAMUX,2)
#define DMAMUX_CHCFG3                            DMAMUX_CHCFG_REG(DMAMUX,3)
#define DMAMUX_CHCFG4                            DMAMUX_CHCFG_REG(DMAMUX,4)
#define DMAMUX_CHCFG5                            DMAMUX_CHCFG_REG(DMAMUX,5)
#define DMAMUX_CHCFG6                            DMAMUX_CHCFG_REG(DMAMUX,6)
#define DMAMUX_CHCFG7                            DMAMUX_CHCFG_REG(DMAMUX,7)
#define DMAMUX_CHCFG8                            DMAMUX_CHCFG_REG(DMAMUX,8)
#define DMAMUX_CHCFG9                            DMAMUX_CHCFG_REG(DMAMUX,9)
#define DMAMUX_CHCFG10                           DMAMUX_CHCFG_REG(DMAMUX,10)
#define DMAMUX_CHCFG11                           DMAMUX_CHCFG_REG(DMAMUX,11)
#define DMAMUX_CHCFG12                           DMAMUX_CHCFG_REG(DMAMUX,12)
#define DMAMUX_CHCFG13                           DMAMUX_CHCFG_REG(DMAMUX,13)
#define DMAMUX_CHCFG14                           DMAMUX_CHCFG_REG(DMAMUX,14)
#define DMAMUX_CHCFG15                           DMAMUX_CHCFG_REG(DMAMUX,15)
#define DMAMUX_CHCFG16                           DMAMUX_CHCFG_REG(DMAMUX,16)
#define DMAMUX_CHCFG17                           DMAMUX_CHCFG_REG(DMAMUX,17)
#define DMAMUX_CHCFG18                           DMAMUX_CHCFG_REG(DMAMUX,18)
#define DMAMUX_CHCFG19                           DMAMUX_CHCFG_REG(DMAMUX,19)
#define DMAMUX_CHCFG20                           DMAMUX_CHCFG_REG(DMAMUX,20)
#define DMAMUX_CHCFG21                           DMAMUX_CHCFG_REG(DMAMUX,21)
#define DMAMUX_CHCFG22                           DMAMUX_CHCFG_REG(DMAMUX,22)
#define DMAMUX_CHCFG23                           DMAMUX_CHCFG_REG(DMAMUX,23)
#define DMAMUX_CHCFG24                           DMAMUX_CHCFG_REG(DMAMUX,24)
#define DMAMUX_CHCFG25                           DMAMUX_CHCFG_REG(DMAMUX,25)
#define DMAMUX_CHCFG26                           DMAMUX_CHCFG_REG(DMAMUX,26)
#define DMAMUX_CHCFG27                           DMAMUX_CHCFG_REG(DMAMUX,27)
#define DMAMUX_CHCFG28                           DMAMUX_CHCFG_REG(DMAMUX,28)
#define DMAMUX_CHCFG29                           DMAMUX_CHCFG_REG(DMAMUX,29)
#define DMAMUX_CHCFG30                           DMAMUX_CHCFG_REG(DMAMUX,30)
#define DMAMUX_CHCFG31                           DMAMUX_CHCFG_REG(DMAMUX,31)

/* DMAMUX - Register array accessors */
#define DMAMUX_CHCFG(index)                      DMAMUX_CHCFG_REG(DMAMUX,index)

/*!
 * @}
 */ /* end of group DMAMUX_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DMAMUX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Peripheral_Access_Layer ENC Peripheral Access Layer
 * @{
 */

/** ENC - Register Layout Typedef */
typedef struct {
  __IO uint16_t CTRL;                              /**< Control Register, offset: 0x0 */
  __IO uint16_t FILT;                              /**< Input Filter Register, offset: 0x2 */
  __IO uint16_t WTR;                               /**< Watchdog Timeout Register, offset: 0x4 */
  __IO uint16_t POSD;                              /**< Position Difference Counter Register, offset: 0x6 */
  __I  uint16_t POSDH;                             /**< Position Difference Hold Register, offset: 0x8 */
  __IO uint16_t REV;                               /**< Revolution Counter Register, offset: 0xA */
  __I  uint16_t REVH;                              /**< Revolution Hold Register, offset: 0xC */
  __IO uint16_t UPOS;                              /**< Upper Position Counter Register, offset: 0xE */
  __IO uint16_t LPOS;                              /**< Lower Position Counter Register, offset: 0x10 */
  __I  uint16_t UPOSH;                             /**< Upper Position Hold Register, offset: 0x12 */
  __I  uint16_t LPOSH;                             /**< Lower Position Hold Register, offset: 0x14 */
  __IO uint16_t UINIT;                             /**< Upper Initialization Register, offset: 0x16 */
  __IO uint16_t LINIT;                             /**< Lower Initialization Register, offset: 0x18 */
  __I  uint16_t IMR;                               /**< Input Monitor Register, offset: 0x1A */
  __IO uint16_t TST;                               /**< Test Register, offset: 0x1C */
  __IO uint16_t CTRL2;                             /**< Control 2 Register, offset: 0x1E */
  __IO uint16_t UMOD;                              /**< Upper Modulus Register, offset: 0x20 */
  __IO uint16_t LMOD;                              /**< Lower Modulus Register, offset: 0x22 */
  __IO uint16_t UCOMP;                             /**< Upper Position Compare Register, offset: 0x24 */
  __IO uint16_t LCOMP;                             /**< Lower Position Compare Register, offset: 0x26 */
} ENC_Type, *ENC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ENC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Register_Accessor_Macros ENC - Register accessor macros
 * @{
 */


/* ENC - Register accessors */
#define ENC_CTRL_REG(base)                       ((base)->CTRL)
#define ENC_FILT_REG(base)                       ((base)->FILT)
#define ENC_WTR_REG(base)                        ((base)->WTR)
#define ENC_POSD_REG(base)                       ((base)->POSD)
#define ENC_POSDH_REG(base)                      ((base)->POSDH)
#define ENC_REV_REG(base)                        ((base)->REV)
#define ENC_REVH_REG(base)                       ((base)->REVH)
#define ENC_UPOS_REG(base)                       ((base)->UPOS)
#define ENC_LPOS_REG(base)                       ((base)->LPOS)
#define ENC_UPOSH_REG(base)                      ((base)->UPOSH)
#define ENC_LPOSH_REG(base)                      ((base)->LPOSH)
#define ENC_UINIT_REG(base)                      ((base)->UINIT)
#define ENC_LINIT_REG(base)                      ((base)->LINIT)
#define ENC_IMR_REG(base)                        ((base)->IMR)
#define ENC_TST_REG(base)                        ((base)->TST)
#define ENC_CTRL2_REG(base)                      ((base)->CTRL2)
#define ENC_UMOD_REG(base)                       ((base)->UMOD)
#define ENC_LMOD_REG(base)                       ((base)->LMOD)
#define ENC_UCOMP_REG(base)                      ((base)->UCOMP)
#define ENC_LCOMP_REG(base)                      ((base)->LCOMP)

/*!
 * @}
 */ /* end of group ENC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ENC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Register_Masks ENC Register Masks
 * @{
 */

/* CTRL Bit Fields */
#define ENC_CTRL_CMPIE_MASK                      0x1u
#define ENC_CTRL_CMPIE_SHIFT                     0
#define ENC_CTRL_CMPIE_WIDTH                     1
#define ENC_CTRL_CMPIE(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_CMPIE_SHIFT))&ENC_CTRL_CMPIE_MASK)
#define ENC_CTRL_CMPIRQ_MASK                     0x2u
#define ENC_CTRL_CMPIRQ_SHIFT                    1
#define ENC_CTRL_CMPIRQ_WIDTH                    1
#define ENC_CTRL_CMPIRQ(x)                       (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_CMPIRQ_SHIFT))&ENC_CTRL_CMPIRQ_MASK)
#define ENC_CTRL_WDE_MASK                        0x4u
#define ENC_CTRL_WDE_SHIFT                       2
#define ENC_CTRL_WDE_WIDTH                       1
#define ENC_CTRL_WDE(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_WDE_SHIFT))&ENC_CTRL_WDE_MASK)
#define ENC_CTRL_DIE_MASK                        0x8u
#define ENC_CTRL_DIE_SHIFT                       3
#define ENC_CTRL_DIE_WIDTH                       1
#define ENC_CTRL_DIE(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_DIE_SHIFT))&ENC_CTRL_DIE_MASK)
#define ENC_CTRL_DIRQ_MASK                       0x10u
#define ENC_CTRL_DIRQ_SHIFT                      4
#define ENC_CTRL_DIRQ_WIDTH                      1
#define ENC_CTRL_DIRQ(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_DIRQ_SHIFT))&ENC_CTRL_DIRQ_MASK)
#define ENC_CTRL_XNE_MASK                        0x20u
#define ENC_CTRL_XNE_SHIFT                       5
#define ENC_CTRL_XNE_WIDTH                       1
#define ENC_CTRL_XNE(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_XNE_SHIFT))&ENC_CTRL_XNE_MASK)
#define ENC_CTRL_XIP_MASK                        0x40u
#define ENC_CTRL_XIP_SHIFT                       6
#define ENC_CTRL_XIP_WIDTH                       1
#define ENC_CTRL_XIP(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_XIP_SHIFT))&ENC_CTRL_XIP_MASK)
#define ENC_CTRL_XIE_MASK                        0x80u
#define ENC_CTRL_XIE_SHIFT                       7
#define ENC_CTRL_XIE_WIDTH                       1
#define ENC_CTRL_XIE(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_XIE_SHIFT))&ENC_CTRL_XIE_MASK)
#define ENC_CTRL_XIRQ_MASK                       0x100u
#define ENC_CTRL_XIRQ_SHIFT                      8
#define ENC_CTRL_XIRQ_WIDTH                      1
#define ENC_CTRL_XIRQ(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_XIRQ_SHIFT))&ENC_CTRL_XIRQ_MASK)
#define ENC_CTRL_PH1_MASK                        0x200u
#define ENC_CTRL_PH1_SHIFT                       9
#define ENC_CTRL_PH1_WIDTH                       1
#define ENC_CTRL_PH1(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_PH1_SHIFT))&ENC_CTRL_PH1_MASK)
#define ENC_CTRL_REV_MASK                        0x400u
#define ENC_CTRL_REV_SHIFT                       10
#define ENC_CTRL_REV_WIDTH                       1
#define ENC_CTRL_REV(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_REV_SHIFT))&ENC_CTRL_REV_MASK)
#define ENC_CTRL_SWIP_MASK                       0x800u
#define ENC_CTRL_SWIP_SHIFT                      11
#define ENC_CTRL_SWIP_WIDTH                      1
#define ENC_CTRL_SWIP(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_SWIP_SHIFT))&ENC_CTRL_SWIP_MASK)
#define ENC_CTRL_HNE_MASK                        0x1000u
#define ENC_CTRL_HNE_SHIFT                       12
#define ENC_CTRL_HNE_WIDTH                       1
#define ENC_CTRL_HNE(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_HNE_SHIFT))&ENC_CTRL_HNE_MASK)
#define ENC_CTRL_HIP_MASK                        0x2000u
#define ENC_CTRL_HIP_SHIFT                       13
#define ENC_CTRL_HIP_WIDTH                       1
#define ENC_CTRL_HIP(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_HIP_SHIFT))&ENC_CTRL_HIP_MASK)
#define ENC_CTRL_HIE_MASK                        0x4000u
#define ENC_CTRL_HIE_SHIFT                       14
#define ENC_CTRL_HIE_WIDTH                       1
#define ENC_CTRL_HIE(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_HIE_SHIFT))&ENC_CTRL_HIE_MASK)
#define ENC_CTRL_HIRQ_MASK                       0x8000u
#define ENC_CTRL_HIRQ_SHIFT                      15
#define ENC_CTRL_HIRQ_WIDTH                      1
#define ENC_CTRL_HIRQ(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_CTRL_HIRQ_SHIFT))&ENC_CTRL_HIRQ_MASK)
/* FILT Bit Fields */
#define ENC_FILT_FILT_PER_MASK                   0xFFu
#define ENC_FILT_FILT_PER_SHIFT                  0
#define ENC_FILT_FILT_PER_WIDTH                  8
#define ENC_FILT_FILT_PER(x)                     (((uint16_t)(((uint16_t)(x))<<ENC_FILT_FILT_PER_SHIFT))&ENC_FILT_FILT_PER_MASK)
#define ENC_FILT_FILT_CNT_MASK                   0x700u
#define ENC_FILT_FILT_CNT_SHIFT                  8
#define ENC_FILT_FILT_CNT_WIDTH                  3
#define ENC_FILT_FILT_CNT(x)                     (((uint16_t)(((uint16_t)(x))<<ENC_FILT_FILT_CNT_SHIFT))&ENC_FILT_FILT_CNT_MASK)
/* WTR Bit Fields */
#define ENC_WTR_WDOG_MASK                        0xFFFFu
#define ENC_WTR_WDOG_SHIFT                       0
#define ENC_WTR_WDOG_WIDTH                       16
#define ENC_WTR_WDOG(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_WTR_WDOG_SHIFT))&ENC_WTR_WDOG_MASK)
/* POSD Bit Fields */
#define ENC_POSD_POSD_MASK                       0xFFFFu
#define ENC_POSD_POSD_SHIFT                      0
#define ENC_POSD_POSD_WIDTH                      16
#define ENC_POSD_POSD(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_POSD_POSD_SHIFT))&ENC_POSD_POSD_MASK)
/* POSDH Bit Fields */
#define ENC_POSDH_POSDH_MASK                     0xFFFFu
#define ENC_POSDH_POSDH_SHIFT                    0
#define ENC_POSDH_POSDH_WIDTH                    16
#define ENC_POSDH_POSDH(x)                       (((uint16_t)(((uint16_t)(x))<<ENC_POSDH_POSDH_SHIFT))&ENC_POSDH_POSDH_MASK)
/* REV Bit Fields */
#define ENC_REV_REV_MASK                         0xFFFFu
#define ENC_REV_REV_SHIFT                        0
#define ENC_REV_REV_WIDTH                        16
#define ENC_REV_REV(x)                           (((uint16_t)(((uint16_t)(x))<<ENC_REV_REV_SHIFT))&ENC_REV_REV_MASK)
/* REVH Bit Fields */
#define ENC_REVH_REVH_MASK                       0xFFFFu
#define ENC_REVH_REVH_SHIFT                      0
#define ENC_REVH_REVH_WIDTH                      16
#define ENC_REVH_REVH(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_REVH_REVH_SHIFT))&ENC_REVH_REVH_MASK)
/* UPOS Bit Fields */
#define ENC_UPOS_POS_MASK                        0xFFFFu
#define ENC_UPOS_POS_SHIFT                       0
#define ENC_UPOS_POS_WIDTH                       16
#define ENC_UPOS_POS(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_UPOS_POS_SHIFT))&ENC_UPOS_POS_MASK)
/* LPOS Bit Fields */
#define ENC_LPOS_POS_MASK                        0xFFFFu
#define ENC_LPOS_POS_SHIFT                       0
#define ENC_LPOS_POS_WIDTH                       16
#define ENC_LPOS_POS(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_LPOS_POS_SHIFT))&ENC_LPOS_POS_MASK)
/* UPOSH Bit Fields */
#define ENC_UPOSH_POSH_MASK                      0xFFFFu
#define ENC_UPOSH_POSH_SHIFT                     0
#define ENC_UPOSH_POSH_WIDTH                     16
#define ENC_UPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_UPOSH_POSH_SHIFT))&ENC_UPOSH_POSH_MASK)
/* LPOSH Bit Fields */
#define ENC_LPOSH_POSH_MASK                      0xFFFFu
#define ENC_LPOSH_POSH_SHIFT                     0
#define ENC_LPOSH_POSH_WIDTH                     16
#define ENC_LPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_LPOSH_POSH_SHIFT))&ENC_LPOSH_POSH_MASK)
/* UINIT Bit Fields */
#define ENC_UINIT_INIT_MASK                      0xFFFFu
#define ENC_UINIT_INIT_SHIFT                     0
#define ENC_UINIT_INIT_WIDTH                     16
#define ENC_UINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_UINIT_INIT_SHIFT))&ENC_UINIT_INIT_MASK)
/* LINIT Bit Fields */
#define ENC_LINIT_INIT_MASK                      0xFFFFu
#define ENC_LINIT_INIT_SHIFT                     0
#define ENC_LINIT_INIT_WIDTH                     16
#define ENC_LINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_LINIT_INIT_SHIFT))&ENC_LINIT_INIT_MASK)
/* IMR Bit Fields */
#define ENC_IMR_HOME_MASK                        0x1u
#define ENC_IMR_HOME_SHIFT                       0
#define ENC_IMR_HOME_WIDTH                       1
#define ENC_IMR_HOME(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_IMR_HOME_SHIFT))&ENC_IMR_HOME_MASK)
#define ENC_IMR_INDEX_MASK                       0x2u
#define ENC_IMR_INDEX_SHIFT                      1
#define ENC_IMR_INDEX_WIDTH                      1
#define ENC_IMR_INDEX(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_IMR_INDEX_SHIFT))&ENC_IMR_INDEX_MASK)
#define ENC_IMR_PHB_MASK                         0x4u
#define ENC_IMR_PHB_SHIFT                        2
#define ENC_IMR_PHB_WIDTH                        1
#define ENC_IMR_PHB(x)                           (((uint16_t)(((uint16_t)(x))<<ENC_IMR_PHB_SHIFT))&ENC_IMR_PHB_MASK)
#define ENC_IMR_PHA_MASK                         0x8u
#define ENC_IMR_PHA_SHIFT                        3
#define ENC_IMR_PHA_WIDTH                        1
#define ENC_IMR_PHA(x)                           (((uint16_t)(((uint16_t)(x))<<ENC_IMR_PHA_SHIFT))&ENC_IMR_PHA_MASK)
#define ENC_IMR_FHOM_MASK                        0x10u
#define ENC_IMR_FHOM_SHIFT                       4
#define ENC_IMR_FHOM_WIDTH                       1
#define ENC_IMR_FHOM(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_IMR_FHOM_SHIFT))&ENC_IMR_FHOM_MASK)
#define ENC_IMR_FIND_MASK                        0x20u
#define ENC_IMR_FIND_SHIFT                       5
#define ENC_IMR_FIND_WIDTH                       1
#define ENC_IMR_FIND(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_IMR_FIND_SHIFT))&ENC_IMR_FIND_MASK)
#define ENC_IMR_FPHB_MASK                        0x40u
#define ENC_IMR_FPHB_SHIFT                       6
#define ENC_IMR_FPHB_WIDTH                       1
#define ENC_IMR_FPHB(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_IMR_FPHB_SHIFT))&ENC_IMR_FPHB_MASK)
#define ENC_IMR_FPHA_MASK                        0x80u
#define ENC_IMR_FPHA_SHIFT                       7
#define ENC_IMR_FPHA_WIDTH                       1
#define ENC_IMR_FPHA(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_IMR_FPHA_SHIFT))&ENC_IMR_FPHA_MASK)
/* TST Bit Fields */
#define ENC_TST_TEST_COUNT_MASK                  0xFFu
#define ENC_TST_TEST_COUNT_SHIFT                 0
#define ENC_TST_TEST_COUNT_WIDTH                 8
#define ENC_TST_TEST_COUNT(x)                    (((uint16_t)(((uint16_t)(x))<<ENC_TST_TEST_COUNT_SHIFT))&ENC_TST_TEST_COUNT_MASK)
#define ENC_TST_TEST_PERIOD_MASK                 0x1F00u
#define ENC_TST_TEST_PERIOD_SHIFT                8
#define ENC_TST_TEST_PERIOD_WIDTH                5
#define ENC_TST_TEST_PERIOD(x)                   (((uint16_t)(((uint16_t)(x))<<ENC_TST_TEST_PERIOD_SHIFT))&ENC_TST_TEST_PERIOD_MASK)
#define ENC_TST_QDN_MASK                         0x2000u
#define ENC_TST_QDN_SHIFT                        13
#define ENC_TST_QDN_WIDTH                        1
#define ENC_TST_QDN(x)                           (((uint16_t)(((uint16_t)(x))<<ENC_TST_QDN_SHIFT))&ENC_TST_QDN_MASK)
#define ENC_TST_TCE_MASK                         0x4000u
#define ENC_TST_TCE_SHIFT                        14
#define ENC_TST_TCE_WIDTH                        1
#define ENC_TST_TCE(x)                           (((uint16_t)(((uint16_t)(x))<<ENC_TST_TCE_SHIFT))&ENC_TST_TCE_MASK)
#define ENC_TST_TEN_MASK                         0x8000u
#define ENC_TST_TEN_SHIFT                        15
#define ENC_TST_TEN_WIDTH                        1
#define ENC_TST_TEN(x)                           (((uint16_t)(((uint16_t)(x))<<ENC_TST_TEN_SHIFT))&ENC_TST_TEN_MASK)
/* CTRL2 Bit Fields */
#define ENC_CTRL2_UPDHLD_MASK                    0x1u
#define ENC_CTRL2_UPDHLD_SHIFT                   0
#define ENC_CTRL2_UPDHLD_WIDTH                   1
#define ENC_CTRL2_UPDHLD(x)                      (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_UPDHLD_SHIFT))&ENC_CTRL2_UPDHLD_MASK)
#define ENC_CTRL2_UPDPOS_MASK                    0x2u
#define ENC_CTRL2_UPDPOS_SHIFT                   1
#define ENC_CTRL2_UPDPOS_WIDTH                   1
#define ENC_CTRL2_UPDPOS(x)                      (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_UPDPOS_SHIFT))&ENC_CTRL2_UPDPOS_MASK)
#define ENC_CTRL2_MOD_MASK                       0x4u
#define ENC_CTRL2_MOD_SHIFT                      2
#define ENC_CTRL2_MOD_WIDTH                      1
#define ENC_CTRL2_MOD(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_MOD_SHIFT))&ENC_CTRL2_MOD_MASK)
#define ENC_CTRL2_DIR_MASK                       0x8u
#define ENC_CTRL2_DIR_SHIFT                      3
#define ENC_CTRL2_DIR_WIDTH                      1
#define ENC_CTRL2_DIR(x)                         (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_DIR_SHIFT))&ENC_CTRL2_DIR_MASK)
#define ENC_CTRL2_RUIE_MASK                      0x10u
#define ENC_CTRL2_RUIE_SHIFT                     4
#define ENC_CTRL2_RUIE_WIDTH                     1
#define ENC_CTRL2_RUIE(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_RUIE_SHIFT))&ENC_CTRL2_RUIE_MASK)
#define ENC_CTRL2_RUIRQ_MASK                     0x20u
#define ENC_CTRL2_RUIRQ_SHIFT                    5
#define ENC_CTRL2_RUIRQ_WIDTH                    1
#define ENC_CTRL2_RUIRQ(x)                       (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_RUIRQ_SHIFT))&ENC_CTRL2_RUIRQ_MASK)
#define ENC_CTRL2_ROIE_MASK                      0x40u
#define ENC_CTRL2_ROIE_SHIFT                     6
#define ENC_CTRL2_ROIE_WIDTH                     1
#define ENC_CTRL2_ROIE(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_ROIE_SHIFT))&ENC_CTRL2_ROIE_MASK)
#define ENC_CTRL2_ROIRQ_MASK                     0x80u
#define ENC_CTRL2_ROIRQ_SHIFT                    7
#define ENC_CTRL2_ROIRQ_WIDTH                    1
#define ENC_CTRL2_ROIRQ(x)                       (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_ROIRQ_SHIFT))&ENC_CTRL2_ROIRQ_MASK)
#define ENC_CTRL2_REVMOD_MASK                    0x100u
#define ENC_CTRL2_REVMOD_SHIFT                   8
#define ENC_CTRL2_REVMOD_WIDTH                   1
#define ENC_CTRL2_REVMOD(x)                      (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_REVMOD_SHIFT))&ENC_CTRL2_REVMOD_MASK)
#define ENC_CTRL2_OUTCTL_MASK                    0x200u
#define ENC_CTRL2_OUTCTL_SHIFT                   9
#define ENC_CTRL2_OUTCTL_WIDTH                   1
#define ENC_CTRL2_OUTCTL(x)                      (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_OUTCTL_SHIFT))&ENC_CTRL2_OUTCTL_MASK)
#define ENC_CTRL2_SABIE_MASK                     0x400u
#define ENC_CTRL2_SABIE_SHIFT                    10
#define ENC_CTRL2_SABIE_WIDTH                    1
#define ENC_CTRL2_SABIE(x)                       (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_SABIE_SHIFT))&ENC_CTRL2_SABIE_MASK)
#define ENC_CTRL2_SABIRQ_MASK                    0x800u
#define ENC_CTRL2_SABIRQ_SHIFT                   11
#define ENC_CTRL2_SABIRQ_WIDTH                   1
#define ENC_CTRL2_SABIRQ(x)                      (((uint16_t)(((uint16_t)(x))<<ENC_CTRL2_SABIRQ_SHIFT))&ENC_CTRL2_SABIRQ_MASK)
/* UMOD Bit Fields */
#define ENC_UMOD_MOD_MASK                        0xFFFFu
#define ENC_UMOD_MOD_SHIFT                       0
#define ENC_UMOD_MOD_WIDTH                       16
#define ENC_UMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_UMOD_MOD_SHIFT))&ENC_UMOD_MOD_MASK)
/* LMOD Bit Fields */
#define ENC_LMOD_MOD_MASK                        0xFFFFu
#define ENC_LMOD_MOD_SHIFT                       0
#define ENC_LMOD_MOD_WIDTH                       16
#define ENC_LMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x))<<ENC_LMOD_MOD_SHIFT))&ENC_LMOD_MOD_MASK)
/* UCOMP Bit Fields */
#define ENC_UCOMP_COMP_MASK                      0xFFFFu
#define ENC_UCOMP_COMP_SHIFT                     0
#define ENC_UCOMP_COMP_WIDTH                     16
#define ENC_UCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_UCOMP_COMP_SHIFT))&ENC_UCOMP_COMP_MASK)
/* LCOMP Bit Fields */
#define ENC_LCOMP_COMP_MASK                      0xFFFFu
#define ENC_LCOMP_COMP_SHIFT                     0
#define ENC_LCOMP_COMP_WIDTH                     16
#define ENC_LCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x))<<ENC_LCOMP_COMP_SHIFT))&ENC_LCOMP_COMP_MASK)

/*!
 * @}
 */ /* end of group ENC_Register_Masks */


/* ENC - Peripheral instance base addresses */
/** Peripheral ENC base address */
#define ENC_BASE                                 (0x800AA000u)
/** Peripheral ENC base pointer */
#define ENC                                      ((ENC_Type *)ENC_BASE)
#define ENC_BASE_PTR                             (ENC)
/** Array initializer of ENC peripheral base addresses */
#define ENC_BASE_ADDRS                           { ENC_BASE }
/** Array initializer of ENC peripheral base pointers */
#define ENC_BASE_PTRS                            { ENC }

/* ----------------------------------------------------------------------------
   -- ENC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Register_Accessor_Macros ENC - Register accessor macros
 * @{
 */


/* ENC - Register instance definitions */
/* ENC */
#define ENC_CTRL                                 ENC_CTRL_REG(ENC)
#define ENC_FILT                                 ENC_FILT_REG(ENC)
#define ENC_WTR                                  ENC_WTR_REG(ENC)
#define ENC_POSD                                 ENC_POSD_REG(ENC)
#define ENC_POSDH                                ENC_POSDH_REG(ENC)
#define ENC_REV                                  ENC_REV_REG(ENC)
#define ENC_REVH                                 ENC_REVH_REG(ENC)
#define ENC_UPOS                                 ENC_UPOS_REG(ENC)
#define ENC_LPOS                                 ENC_LPOS_REG(ENC)
#define ENC_UPOSH                                ENC_UPOSH_REG(ENC)
#define ENC_LPOSH                                ENC_LPOSH_REG(ENC)
#define ENC_UINIT                                ENC_UINIT_REG(ENC)
#define ENC_LINIT                                ENC_LINIT_REG(ENC)
#define ENC_IMR                                  ENC_IMR_REG(ENC)
#define ENC_TST                                  ENC_TST_REG(ENC)
#define ENC_CTRL2                                ENC_CTRL2_REG(ENC)
#define ENC_UMOD                                 ENC_UMOD_REG(ENC)
#define ENC_LMOD                                 ENC_LMOD_REG(ENC)
#define ENC_UCOMP                                ENC_UCOMP_REG(ENC)
#define ENC_LCOMP                                ENC_LCOMP_REG(ENC)

/*!
 * @}
 */ /* end of group ENC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ENC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENET Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Peripheral_Access_Layer ENET Peripheral Access Layer
 * @{
 */

/** ENET - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4];
  __IO uint32_t EIR;                               /**< Interrupt Event Register, offset: 0x4 */
  __IO uint32_t EIMR;                              /**< Interrupt Mask Register, offset: 0x8 */
       uint8_t RESERVED_1[4];
  __IO uint32_t RDAR;                              /**< Receive Descriptor Active Register, offset: 0x10 */
  __IO uint32_t TDAR;                              /**< Transmit Descriptor Active Register, offset: 0x14 */
       uint8_t RESERVED_2[12];
  __IO uint32_t ECR;                               /**< Ethernet Control Register, offset: 0x24 */
       uint8_t RESERVED_3[24];
  __IO uint32_t MMFR;                              /**< MII Management Frame Register, offset: 0x40 */
  __IO uint32_t MSCR;                              /**< MII Speed Control Register, offset: 0x44 */
       uint8_t RESERVED_4[28];
  __IO uint32_t MIBC;                              /**< MIB Control Register, offset: 0x64 */
       uint8_t RESERVED_5[28];
  __IO uint32_t RCR;                               /**< Receive Control Register, offset: 0x84 */
       uint8_t RESERVED_6[60];
  __IO uint32_t TCR;                               /**< Transmit Control Register, offset: 0xC4 */
       uint8_t RESERVED_7[28];
  __IO uint32_t PALR;                              /**< Physical Address Lower Register, offset: 0xE4 */
  __IO uint32_t PAUR;                              /**< Physical Address Upper Register, offset: 0xE8 */
  __IO uint32_t OPD;                               /**< Opcode/Pause Duration Register, offset: 0xEC */
       uint8_t RESERVED_8[40];
  __IO uint32_t IAUR;                              /**< Descriptor Individual Upper Address Register, offset: 0x118 */
  __IO uint32_t IALR;                              /**< Descriptor Individual Lower Address Register, offset: 0x11C */
  __IO uint32_t GAUR;                              /**< Descriptor Group Upper Address Register, offset: 0x120 */
  __IO uint32_t GALR;                              /**< Descriptor Group Lower Address Register, offset: 0x124 */
       uint8_t RESERVED_9[28];
  __IO uint32_t TFWR;                              /**< Transmit FIFO Watermark Register, offset: 0x144 */
       uint8_t RESERVED_10[56];
  __IO uint32_t RDSR;                              /**< Receive Descriptor Ring Start Register, offset: 0x180 */
  __IO uint32_t TDSR;                              /**< Transmit Buffer Descriptor Ring Start Register, offset: 0x184 */
  __IO uint32_t MRBR;                              /**< Maximum Receive Buffer Size Register, offset: 0x188 */
       uint8_t RESERVED_11[4];
  __IO uint32_t RSFL;                              /**< Receive FIFO Section Full Threshold, offset: 0x190 */
  __IO uint32_t RSEM;                              /**< Receive FIFO Section Empty Threshold, offset: 0x194 */
  __IO uint32_t RAEM;                              /**< Receive FIFO Almost Empty Threshold, offset: 0x198 */
  __IO uint32_t RAFL;                              /**< Receive FIFO Almost Full Threshold, offset: 0x19C */
  __IO uint32_t TSEM;                              /**< Transmit FIFO Section Empty Threshold, offset: 0x1A0 */
  __IO uint32_t TAEM;                              /**< Transmit FIFO Almost Empty Threshold, offset: 0x1A4 */
  __IO uint32_t TAFL;                              /**< Transmit FIFO Almost Full Threshold, offset: 0x1A8 */
  __IO uint32_t TIPG;                              /**< Transmit Inter-Packet Gap, offset: 0x1AC */
  __IO uint32_t FTRL;                              /**< Frame Truncation Length, offset: 0x1B0 */
       uint8_t RESERVED_12[12];
  __IO uint32_t TACC;                              /**< Transmit Accelerator Function Configuration, offset: 0x1C0 */
  __IO uint32_t RACC;                              /**< Receive Accelerator Function Configuration, offset: 0x1C4 */
       uint8_t RESERVED_13[56];
  __I  uint32_t RMON_T_DROP;                       /**< Reserved Statistic Register, offset: 0x200 */
  __I  uint32_t RMON_T_PACKETS;                    /**< Tx Packet Count Statistic Register, offset: 0x204 */
  __I  uint32_t RMON_T_BC_PKT;                     /**< Tx Broadcast Packets Statistic Register, offset: 0x208 */
  __I  uint32_t RMON_T_MC_PKT;                     /**< Tx Multicast Packets Statistic Register, offset: 0x20C */
  __I  uint32_t RMON_T_CRC_ALIGN;                  /**< Tx Packets with CRC/Align Error Statistic Register, offset: 0x210 */
  __I  uint32_t RMON_T_UNDERSIZE;                  /**< Tx Packets Less Than Bytes and Good CRC Statistic Register, offset: 0x214 */
  __I  uint32_t RMON_T_OVERSIZE;                   /**< Tx Packets GT MAX_FL bytes and Good CRC Statistic Register, offset: 0x218 */
  __I  uint32_t RMON_T_FRAG;                       /**< Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register, offset: 0x21C */
  __I  uint32_t RMON_T_JAB;                        /**< Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register, offset: 0x220 */
  __I  uint32_t RMON_T_COL;                        /**< Tx Collision Count Statistic Register, offset: 0x224 */
  __I  uint32_t RMON_T_P64;                        /**< Tx 64-Byte Packets Statistic Register, offset: 0x228 */
  __I  uint32_t RMON_T_P65TO127;                   /**< Tx 65- to 127-byte Packets Statistic Register, offset: 0x22C */
  __I  uint32_t RMON_T_P128TO255;                  /**< Tx 128- to 255-byte Packets Statistic Register, offset: 0x230 */
  __I  uint32_t RMON_T_P256TO511;                  /**< Tx 256- to 511-byte Packets Statistic Register, offset: 0x234 */
  __I  uint32_t RMON_T_P512TO1023;                 /**< Tx 512- to 1023-byte Packets Statistic Register, offset: 0x238 */
  __I  uint32_t RMON_T_P1024TO2047;                /**< Tx 1024- to 2047-byte Packets Statistic Register, offset: 0x23C */
  __I  uint32_t RMON_T_P_GTE2048;                  /**< Tx Packets Greater Than 2048 Bytes Statistic Register, offset: 0x240 */
  __I  uint32_t RMON_T_OCTETS;                     /**< Tx Octets Statistic Register, offset: 0x244 */
  __I  uint32_t IEEE_T_DROP;                       /**< IEEE_T_DROP Reserved Statistic Register, offset: 0x248 */
  __I  uint32_t IEEE_T_FRAME_OK;                   /**< Frames Transmitted OK Statistic Register, offset: 0x24C */
  __I  uint32_t IEEE_T_1COL;                       /**< Frames Transmitted with Single Collision Statistic Register, offset: 0x250 */
  __I  uint32_t IEEE_T_MCOL;                       /**< Frames Transmitted with Multiple Collisions Statistic Register, offset: 0x254 */
  __I  uint32_t IEEE_T_DEF;                        /**< Frames Transmitted after Deferral Delay Statistic Register, offset: 0x258 */
  __I  uint32_t IEEE_T_LCOL;                       /**< Frames Transmitted with Late Collision Statistic Register, offset: 0x25C */
  __I  uint32_t IEEE_T_EXCOL;                      /**< Frames Transmitted with Excessive Collisions Statistic Register, offset: 0x260 */
  __I  uint32_t IEEE_T_MACERR;                     /**< Frames Transmitted with Tx FIFO Underrun Statistic Register, offset: 0x264 */
  __I  uint32_t IEEE_T_CSERR;                      /**< Frames Transmitted with Carrier Sense Error Statistic Register, offset: 0x268 */
  __I  uint32_t IEEE_T_SQE;                        /**< , offset: 0x26C */
  __I  uint32_t IEEE_T_FDXFC;                      /**< Flow Control Pause Frames Transmitted Statistic Register, offset: 0x270 */
  __I  uint32_t IEEE_T_OCTETS_OK;                  /**< Octet Count for Frames Transmitted w/o Error Statistic Register, offset: 0x274 */
       uint8_t RESERVED_14[12];
  __I  uint32_t RMON_R_PACKETS;                    /**< Rx Packet Count Statistic Register, offset: 0x284 */
  __I  uint32_t RMON_R_BC_PKT;                     /**< Rx Broadcast Packets Statistic Register, offset: 0x288 */
  __I  uint32_t RMON_R_MC_PKT;                     /**< Rx Multicast Packets Statistic Register, offset: 0x28C */
  __I  uint32_t RMON_R_CRC_ALIGN;                  /**< Rx Packets with CRC/Align Error Statistic Register, offset: 0x290 */
  __I  uint32_t RMON_R_UNDERSIZE;                  /**< Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register, offset: 0x294 */
  __I  uint32_t RMON_R_OVERSIZE;                   /**< Rx Packets Greater Than MAX_FL and Good CRC Statistic Register, offset: 0x298 */
  __I  uint32_t RMON_R_FRAG;                       /**< Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register, offset: 0x29C */
  __I  uint32_t RMON_R_JAB;                        /**< Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register, offset: 0x2A0 */
  __I  uint32_t RMON_R_RESVD_0;                    /**< Reserved Statistic Register, offset: 0x2A4 */
  __I  uint32_t RMON_R_P64;                        /**< Rx 64-Byte Packets Statistic Register, offset: 0x2A8 */
  __I  uint32_t RMON_R_P65TO127;                   /**< Rx 65- to 127-Byte Packets Statistic Register, offset: 0x2AC */
  __I  uint32_t RMON_R_P128TO255;                  /**< Rx 128- to 255-Byte Packets Statistic Register, offset: 0x2B0 */
  __I  uint32_t RMON_R_P256TO511;                  /**< Rx 256- to 511-Byte Packets Statistic Register, offset: 0x2B4 */
  __I  uint32_t RMON_R_P512TO1023;                 /**< Rx 512- to 1023-Byte Packets Statistic Register, offset: 0x2B8 */
  __I  uint32_t RMON_R_P1024TO2047;                /**< Rx 1024- to 2047-Byte Packets Statistic Register, offset: 0x2BC */
  __I  uint32_t RMON_R_P_GTE2048;                  /**< Rx Packets Greater than 2048 Bytes Statistic Register, offset: 0x2C0 */
  __I  uint32_t RMON_R_OCTETS;                     /**< Rx Octets Statistic Register, offset: 0x2C4 */
  __I  uint32_t IEEE_R_DROP;                       /**< Frames not Counted Correctly Statistic Register, offset: 0x2C8 */
  __I  uint32_t IEEE_R_FRAME_OK;                   /**< Frames Received OK Statistic Register, offset: 0x2CC */
  __I  uint32_t IEEE_R_CRC;                        /**< Frames Received with CRC Error Statistic Register, offset: 0x2D0 */
  __I  uint32_t IEEE_R_ALIGN;                      /**< Frames Received with Alignment Error Statistic Register, offset: 0x2D4 */
  __I  uint32_t IEEE_R_MACERR;                     /**< Receive FIFO Overflow Count Statistic Register, offset: 0x2D8 */
  __I  uint32_t IEEE_R_FDXFC;                      /**< Flow Control Pause Frames Received Statistic Register, offset: 0x2DC */
  __I  uint32_t IEEE_R_OCTETS_OK;                  /**< Octet Count for Frames Received without Error Statistic Register, offset: 0x2E0 */
       uint8_t RESERVED_15[284];
  __IO uint32_t ATCR;                              /**< Adjustable Timer Control Register, offset: 0x400 */
  __IO uint32_t ATVR;                              /**< Timer Value Register, offset: 0x404 */
  __IO uint32_t ATOFF;                             /**< Timer Offset Register, offset: 0x408 */
  __IO uint32_t ATPER;                             /**< Timer Period Register, offset: 0x40C */
  __IO uint32_t ATCOR;                             /**< Timer Correction Register, offset: 0x410 */
  __IO uint32_t ATINC;                             /**< Time-Stamping Clock Period Register, offset: 0x414 */
  __I  uint32_t ATSTMP;                            /**< Timestamp of Last Transmitted Frame, offset: 0x418 */
       uint8_t RESERVED_16[488];
  __IO uint32_t TGSR;                              /**< Timer Global Status Register, offset: 0x604 */
  struct {                                         /* offset: 0x608, array step: 0x8 */
    __IO uint32_t TCSR;                              /**< Timer Control Status Register, array offset: 0x608, array step: 0x8 */
    __IO uint32_t TCCR;                              /**< Timer Compare Capture Register, array offset: 0x60C, array step: 0x8 */
  } CHANNEL[4];
} ENET_Type, *ENET_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ENET - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Accessor_Macros ENET - Register accessor macros
 * @{
 */


/* ENET - Register accessors */
#define ENET_EIR_REG(base)                       ((base)->EIR)
#define ENET_EIMR_REG(base)                      ((base)->EIMR)
#define ENET_RDAR_REG(base)                      ((base)->RDAR)
#define ENET_TDAR_REG(base)                      ((base)->TDAR)
#define ENET_ECR_REG(base)                       ((base)->ECR)
#define ENET_MMFR_REG(base)                      ((base)->MMFR)
#define ENET_MSCR_REG(base)                      ((base)->MSCR)
#define ENET_MIBC_REG(base)                      ((base)->MIBC)
#define ENET_RCR_REG(base)                       ((base)->RCR)
#define ENET_TCR_REG(base)                       ((base)->TCR)
#define ENET_PALR_REG(base)                      ((base)->PALR)
#define ENET_PAUR_REG(base)                      ((base)->PAUR)
#define ENET_OPD_REG(base)                       ((base)->OPD)
#define ENET_IAUR_REG(base)                      ((base)->IAUR)
#define ENET_IALR_REG(base)                      ((base)->IALR)
#define ENET_GAUR_REG(base)                      ((base)->GAUR)
#define ENET_GALR_REG(base)                      ((base)->GALR)
#define ENET_TFWR_REG(base)                      ((base)->TFWR)
#define ENET_RDSR_REG(base)                      ((base)->RDSR)
#define ENET_TDSR_REG(base)                      ((base)->TDSR)
#define ENET_MRBR_REG(base)                      ((base)->MRBR)
#define ENET_RSFL_REG(base)                      ((base)->RSFL)
#define ENET_RSEM_REG(base)                      ((base)->RSEM)
#define ENET_RAEM_REG(base)                      ((base)->RAEM)
#define ENET_RAFL_REG(base)                      ((base)->RAFL)
#define ENET_TSEM_REG(base)                      ((base)->TSEM)
#define ENET_TAEM_REG(base)                      ((base)->TAEM)
#define ENET_TAFL_REG(base)                      ((base)->TAFL)
#define ENET_TIPG_REG(base)                      ((base)->TIPG)
#define ENET_FTRL_REG(base)                      ((base)->FTRL)
#define ENET_TACC_REG(base)                      ((base)->TACC)
#define ENET_RACC_REG(base)                      ((base)->RACC)
#define ENET_RMON_T_DROP_REG(base)               ((base)->RMON_T_DROP)
#define ENET_RMON_T_PACKETS_REG(base)            ((base)->RMON_T_PACKETS)
#define ENET_RMON_T_BC_PKT_REG(base)             ((base)->RMON_T_BC_PKT)
#define ENET_RMON_T_MC_PKT_REG(base)             ((base)->RMON_T_MC_PKT)
#define ENET_RMON_T_CRC_ALIGN_REG(base)          ((base)->RMON_T_CRC_ALIGN)
#define ENET_RMON_T_UNDERSIZE_REG(base)          ((base)->RMON_T_UNDERSIZE)
#define ENET_RMON_T_OVERSIZE_REG(base)           ((base)->RMON_T_OVERSIZE)
#define ENET_RMON_T_FRAG_REG(base)               ((base)->RMON_T_FRAG)
#define ENET_RMON_T_JAB_REG(base)                ((base)->RMON_T_JAB)
#define ENET_RMON_T_COL_REG(base)                ((base)->RMON_T_COL)
#define ENET_RMON_T_P64_REG(base)                ((base)->RMON_T_P64)
#define ENET_RMON_T_P65TO127_REG(base)           ((base)->RMON_T_P65TO127)
#define ENET_RMON_T_P128TO255_REG(base)          ((base)->RMON_T_P128TO255)
#define ENET_RMON_T_P256TO511_REG(base)          ((base)->RMON_T_P256TO511)
#define ENET_RMON_T_P512TO1023_REG(base)         ((base)->RMON_T_P512TO1023)
#define ENET_RMON_T_P1024TO2047_REG(base)        ((base)->RMON_T_P1024TO2047)
#define ENET_RMON_T_P_GTE2048_REG(base)          ((base)->RMON_T_P_GTE2048)
#define ENET_RMON_T_OCTETS_REG(base)             ((base)->RMON_T_OCTETS)
#define ENET_IEEE_T_DROP_REG(base)               ((base)->IEEE_T_DROP)
#define ENET_IEEE_T_FRAME_OK_REG(base)           ((base)->IEEE_T_FRAME_OK)
#define ENET_IEEE_T_1COL_REG(base)               ((base)->IEEE_T_1COL)
#define ENET_IEEE_T_MCOL_REG(base)               ((base)->IEEE_T_MCOL)
#define ENET_IEEE_T_DEF_REG(base)                ((base)->IEEE_T_DEF)
#define ENET_IEEE_T_LCOL_REG(base)               ((base)->IEEE_T_LCOL)
#define ENET_IEEE_T_EXCOL_REG(base)              ((base)->IEEE_T_EXCOL)
#define ENET_IEEE_T_MACERR_REG(base)             ((base)->IEEE_T_MACERR)
#define ENET_IEEE_T_CSERR_REG(base)              ((base)->IEEE_T_CSERR)
#define ENET_IEEE_T_SQE_REG(base)                ((base)->IEEE_T_SQE)
#define ENET_IEEE_T_FDXFC_REG(base)              ((base)->IEEE_T_FDXFC)
#define ENET_IEEE_T_OCTETS_OK_REG(base)          ((base)->IEEE_T_OCTETS_OK)
#define ENET_RMON_R_PACKETS_REG(base)            ((base)->RMON_R_PACKETS)
#define ENET_RMON_R_BC_PKT_REG(base)             ((base)->RMON_R_BC_PKT)
#define ENET_RMON_R_MC_PKT_REG(base)             ((base)->RMON_R_MC_PKT)
#define ENET_RMON_R_CRC_ALIGN_REG(base)          ((base)->RMON_R_CRC_ALIGN)
#define ENET_RMON_R_UNDERSIZE_REG(base)          ((base)->RMON_R_UNDERSIZE)
#define ENET_RMON_R_OVERSIZE_REG(base)           ((base)->RMON_R_OVERSIZE)
#define ENET_RMON_R_FRAG_REG(base)               ((base)->RMON_R_FRAG)
#define ENET_RMON_R_JAB_REG(base)                ((base)->RMON_R_JAB)
#define ENET_RMON_R_RESVD_0_REG(base)            ((base)->RMON_R_RESVD_0)
#define ENET_RMON_R_P64_REG(base)                ((base)->RMON_R_P64)
#define ENET_RMON_R_P65TO127_REG(base)           ((base)->RMON_R_P65TO127)
#define ENET_RMON_R_P128TO255_REG(base)          ((base)->RMON_R_P128TO255)
#define ENET_RMON_R_P256TO511_REG(base)          ((base)->RMON_R_P256TO511)
#define ENET_RMON_R_P512TO1023_REG(base)         ((base)->RMON_R_P512TO1023)
#define ENET_RMON_R_P1024TO2047_REG(base)        ((base)->RMON_R_P1024TO2047)
#define ENET_RMON_R_P_GTE2048_REG(base)          ((base)->RMON_R_P_GTE2048)
#define ENET_RMON_R_OCTETS_REG(base)             ((base)->RMON_R_OCTETS)
#define ENET_IEEE_R_DROP_REG(base)               ((base)->IEEE_R_DROP)
#define ENET_IEEE_R_FRAME_OK_REG(base)           ((base)->IEEE_R_FRAME_OK)
#define ENET_IEEE_R_CRC_REG(base)                ((base)->IEEE_R_CRC)
#define ENET_IEEE_R_ALIGN_REG(base)              ((base)->IEEE_R_ALIGN)
#define ENET_IEEE_R_MACERR_REG(base)             ((base)->IEEE_R_MACERR)
#define ENET_IEEE_R_FDXFC_REG(base)              ((base)->IEEE_R_FDXFC)
#define ENET_IEEE_R_OCTETS_OK_REG(base)          ((base)->IEEE_R_OCTETS_OK)
#define ENET_ATCR_REG(base)                      ((base)->ATCR)
#define ENET_ATVR_REG(base)                      ((base)->ATVR)
#define ENET_ATOFF_REG(base)                     ((base)->ATOFF)
#define ENET_ATPER_REG(base)                     ((base)->ATPER)
#define ENET_ATCOR_REG(base)                     ((base)->ATCOR)
#define ENET_ATINC_REG(base)                     ((base)->ATINC)
#define ENET_ATSTMP_REG(base)                    ((base)->ATSTMP)
#define ENET_TGSR_REG(base)                      ((base)->TGSR)
#define ENET_TCSR_REG(base,index)                ((base)->CHANNEL[index].TCSR)
#define ENET_TCSR_COUNT                          4
#define ENET_TCCR_REG(base,index)                ((base)->CHANNEL[index].TCCR)
#define ENET_TCCR_COUNT                          4

/*!
 * @}
 */ /* end of group ENET_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ENET Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Masks ENET Register Masks
 * @{
 */

/* EIR Bit Fields */
#define ENET_EIR_TS_TIMER_MASK                   0x8000u
#define ENET_EIR_TS_TIMER_SHIFT                  15
#define ENET_EIR_TS_TIMER_WIDTH                  1
#define ENET_EIR_TS_TIMER(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_EIR_TS_TIMER_SHIFT))&ENET_EIR_TS_TIMER_MASK)
#define ENET_EIR_TS_AVAIL_MASK                   0x10000u
#define ENET_EIR_TS_AVAIL_SHIFT                  16
#define ENET_EIR_TS_AVAIL_WIDTH                  1
#define ENET_EIR_TS_AVAIL(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_EIR_TS_AVAIL_SHIFT))&ENET_EIR_TS_AVAIL_MASK)
#define ENET_EIR_WAKEUP_MASK                     0x20000u
#define ENET_EIR_WAKEUP_SHIFT                    17
#define ENET_EIR_WAKEUP_WIDTH                    1
#define ENET_EIR_WAKEUP(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_EIR_WAKEUP_SHIFT))&ENET_EIR_WAKEUP_MASK)
#define ENET_EIR_PLR_MASK                        0x40000u
#define ENET_EIR_PLR_SHIFT                       18
#define ENET_EIR_PLR_WIDTH                       1
#define ENET_EIR_PLR(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIR_PLR_SHIFT))&ENET_EIR_PLR_MASK)
#define ENET_EIR_UN_MASK                         0x80000u
#define ENET_EIR_UN_SHIFT                        19
#define ENET_EIR_UN_WIDTH                        1
#define ENET_EIR_UN(x)                           (((uint32_t)(((uint32_t)(x))<<ENET_EIR_UN_SHIFT))&ENET_EIR_UN_MASK)
#define ENET_EIR_RL_MASK                         0x100000u
#define ENET_EIR_RL_SHIFT                        20
#define ENET_EIR_RL_WIDTH                        1
#define ENET_EIR_RL(x)                           (((uint32_t)(((uint32_t)(x))<<ENET_EIR_RL_SHIFT))&ENET_EIR_RL_MASK)
#define ENET_EIR_LC_MASK                         0x200000u
#define ENET_EIR_LC_SHIFT                        21
#define ENET_EIR_LC_WIDTH                        1
#define ENET_EIR_LC(x)                           (((uint32_t)(((uint32_t)(x))<<ENET_EIR_LC_SHIFT))&ENET_EIR_LC_MASK)
#define ENET_EIR_EBERR_MASK                      0x400000u
#define ENET_EIR_EBERR_SHIFT                     22
#define ENET_EIR_EBERR_WIDTH                     1
#define ENET_EIR_EBERR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_EIR_EBERR_SHIFT))&ENET_EIR_EBERR_MASK)
#define ENET_EIR_MII_MASK                        0x800000u
#define ENET_EIR_MII_SHIFT                       23
#define ENET_EIR_MII_WIDTH                       1
#define ENET_EIR_MII(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIR_MII_SHIFT))&ENET_EIR_MII_MASK)
#define ENET_EIR_RXB_MASK                        0x1000000u
#define ENET_EIR_RXB_SHIFT                       24
#define ENET_EIR_RXB_WIDTH                       1
#define ENET_EIR_RXB(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIR_RXB_SHIFT))&ENET_EIR_RXB_MASK)
#define ENET_EIR_RXF_MASK                        0x2000000u
#define ENET_EIR_RXF_SHIFT                       25
#define ENET_EIR_RXF_WIDTH                       1
#define ENET_EIR_RXF(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIR_RXF_SHIFT))&ENET_EIR_RXF_MASK)
#define ENET_EIR_TXB_MASK                        0x4000000u
#define ENET_EIR_TXB_SHIFT                       26
#define ENET_EIR_TXB_WIDTH                       1
#define ENET_EIR_TXB(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIR_TXB_SHIFT))&ENET_EIR_TXB_MASK)
#define ENET_EIR_TXF_MASK                        0x8000000u
#define ENET_EIR_TXF_SHIFT                       27
#define ENET_EIR_TXF_WIDTH                       1
#define ENET_EIR_TXF(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIR_TXF_SHIFT))&ENET_EIR_TXF_MASK)
#define ENET_EIR_GRA_MASK                        0x10000000u
#define ENET_EIR_GRA_SHIFT                       28
#define ENET_EIR_GRA_WIDTH                       1
#define ENET_EIR_GRA(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIR_GRA_SHIFT))&ENET_EIR_GRA_MASK)
#define ENET_EIR_BABT_MASK                       0x20000000u
#define ENET_EIR_BABT_SHIFT                      29
#define ENET_EIR_BABT_WIDTH                      1
#define ENET_EIR_BABT(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIR_BABT_SHIFT))&ENET_EIR_BABT_MASK)
#define ENET_EIR_BABR_MASK                       0x40000000u
#define ENET_EIR_BABR_SHIFT                      30
#define ENET_EIR_BABR_WIDTH                      1
#define ENET_EIR_BABR(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIR_BABR_SHIFT))&ENET_EIR_BABR_MASK)
/* EIMR Bit Fields */
#define ENET_EIMR_TS_TIMER_MASK                  0x8000u
#define ENET_EIMR_TS_TIMER_SHIFT                 15
#define ENET_EIMR_TS_TIMER_WIDTH                 1
#define ENET_EIMR_TS_TIMER(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_TS_TIMER_SHIFT))&ENET_EIMR_TS_TIMER_MASK)
#define ENET_EIMR_TS_AVAIL_MASK                  0x10000u
#define ENET_EIMR_TS_AVAIL_SHIFT                 16
#define ENET_EIMR_TS_AVAIL_WIDTH                 1
#define ENET_EIMR_TS_AVAIL(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_TS_AVAIL_SHIFT))&ENET_EIMR_TS_AVAIL_MASK)
#define ENET_EIMR_WAKEUP_MASK                    0x20000u
#define ENET_EIMR_WAKEUP_SHIFT                   17
#define ENET_EIMR_WAKEUP_WIDTH                   1
#define ENET_EIMR_WAKEUP(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_WAKEUP_SHIFT))&ENET_EIMR_WAKEUP_MASK)
#define ENET_EIMR_PLR_MASK                       0x40000u
#define ENET_EIMR_PLR_SHIFT                      18
#define ENET_EIMR_PLR_WIDTH                      1
#define ENET_EIMR_PLR(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_PLR_SHIFT))&ENET_EIMR_PLR_MASK)
#define ENET_EIMR_UN_MASK                        0x80000u
#define ENET_EIMR_UN_SHIFT                       19
#define ENET_EIMR_UN_WIDTH                       1
#define ENET_EIMR_UN(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_UN_SHIFT))&ENET_EIMR_UN_MASK)
#define ENET_EIMR_RL_MASK                        0x100000u
#define ENET_EIMR_RL_SHIFT                       20
#define ENET_EIMR_RL_WIDTH                       1
#define ENET_EIMR_RL(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_RL_SHIFT))&ENET_EIMR_RL_MASK)
#define ENET_EIMR_LC_MASK                        0x200000u
#define ENET_EIMR_LC_SHIFT                       21
#define ENET_EIMR_LC_WIDTH                       1
#define ENET_EIMR_LC(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_LC_SHIFT))&ENET_EIMR_LC_MASK)
#define ENET_EIMR_EBERR_MASK                     0x400000u
#define ENET_EIMR_EBERR_SHIFT                    22
#define ENET_EIMR_EBERR_WIDTH                    1
#define ENET_EIMR_EBERR(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_EBERR_SHIFT))&ENET_EIMR_EBERR_MASK)
#define ENET_EIMR_MII_MASK                       0x800000u
#define ENET_EIMR_MII_SHIFT                      23
#define ENET_EIMR_MII_WIDTH                      1
#define ENET_EIMR_MII(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_MII_SHIFT))&ENET_EIMR_MII_MASK)
#define ENET_EIMR_RXB_MASK                       0x1000000u
#define ENET_EIMR_RXB_SHIFT                      24
#define ENET_EIMR_RXB_WIDTH                      1
#define ENET_EIMR_RXB(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_RXB_SHIFT))&ENET_EIMR_RXB_MASK)
#define ENET_EIMR_RXF_MASK                       0x2000000u
#define ENET_EIMR_RXF_SHIFT                      25
#define ENET_EIMR_RXF_WIDTH                      1
#define ENET_EIMR_RXF(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_RXF_SHIFT))&ENET_EIMR_RXF_MASK)
#define ENET_EIMR_TXB_MASK                       0x4000000u
#define ENET_EIMR_TXB_SHIFT                      26
#define ENET_EIMR_TXB_WIDTH                      1
#define ENET_EIMR_TXB(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_TXB_SHIFT))&ENET_EIMR_TXB_MASK)
#define ENET_EIMR_TXF_MASK                       0x8000000u
#define ENET_EIMR_TXF_SHIFT                      27
#define ENET_EIMR_TXF_WIDTH                      1
#define ENET_EIMR_TXF(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_TXF_SHIFT))&ENET_EIMR_TXF_MASK)
#define ENET_EIMR_GRA_MASK                       0x10000000u
#define ENET_EIMR_GRA_SHIFT                      28
#define ENET_EIMR_GRA_WIDTH                      1
#define ENET_EIMR_GRA(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_GRA_SHIFT))&ENET_EIMR_GRA_MASK)
#define ENET_EIMR_BABT_MASK                      0x20000000u
#define ENET_EIMR_BABT_SHIFT                     29
#define ENET_EIMR_BABT_WIDTH                     1
#define ENET_EIMR_BABT(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_BABT_SHIFT))&ENET_EIMR_BABT_MASK)
#define ENET_EIMR_BABR_MASK                      0x40000000u
#define ENET_EIMR_BABR_SHIFT                     30
#define ENET_EIMR_BABR_WIDTH                     1
#define ENET_EIMR_BABR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_EIMR_BABR_SHIFT))&ENET_EIMR_BABR_MASK)
/* RDAR Bit Fields */
#define ENET_RDAR_RDAR_MASK                      0x1000000u
#define ENET_RDAR_RDAR_SHIFT                     24
#define ENET_RDAR_RDAR_WIDTH                     1
#define ENET_RDAR_RDAR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_RDAR_RDAR_SHIFT))&ENET_RDAR_RDAR_MASK)
/* TDAR Bit Fields */
#define ENET_TDAR_TDAR_MASK                      0x1000000u
#define ENET_TDAR_TDAR_SHIFT                     24
#define ENET_TDAR_TDAR_WIDTH                     1
#define ENET_TDAR_TDAR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_TDAR_TDAR_SHIFT))&ENET_TDAR_TDAR_MASK)
/* ECR Bit Fields */
#define ENET_ECR_RESET_MASK                      0x1u
#define ENET_ECR_RESET_SHIFT                     0
#define ENET_ECR_RESET_WIDTH                     1
#define ENET_ECR_RESET(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ECR_RESET_SHIFT))&ENET_ECR_RESET_MASK)
#define ENET_ECR_ETHEREN_MASK                    0x2u
#define ENET_ECR_ETHEREN_SHIFT                   1
#define ENET_ECR_ETHEREN_WIDTH                   1
#define ENET_ECR_ETHEREN(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_ECR_ETHEREN_SHIFT))&ENET_ECR_ETHEREN_MASK)
#define ENET_ECR_MAGICEN_MASK                    0x4u
#define ENET_ECR_MAGICEN_SHIFT                   2
#define ENET_ECR_MAGICEN_WIDTH                   1
#define ENET_ECR_MAGICEN(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_ECR_MAGICEN_SHIFT))&ENET_ECR_MAGICEN_MASK)
#define ENET_ECR_SLEEP_MASK                      0x8u
#define ENET_ECR_SLEEP_SHIFT                     3
#define ENET_ECR_SLEEP_WIDTH                     1
#define ENET_ECR_SLEEP(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ECR_SLEEP_SHIFT))&ENET_ECR_SLEEP_MASK)
#define ENET_ECR_EN1588_MASK                     0x10u
#define ENET_ECR_EN1588_SHIFT                    4
#define ENET_ECR_EN1588_WIDTH                    1
#define ENET_ECR_EN1588(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_ECR_EN1588_SHIFT))&ENET_ECR_EN1588_MASK)
#define ENET_ECR_DBGEN_MASK                      0x40u
#define ENET_ECR_DBGEN_SHIFT                     6
#define ENET_ECR_DBGEN_WIDTH                     1
#define ENET_ECR_DBGEN(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ECR_DBGEN_SHIFT))&ENET_ECR_DBGEN_MASK)
#define ENET_ECR_STOPEN_MASK                     0x80u
#define ENET_ECR_STOPEN_SHIFT                    7
#define ENET_ECR_STOPEN_WIDTH                    1
#define ENET_ECR_STOPEN(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_ECR_STOPEN_SHIFT))&ENET_ECR_STOPEN_MASK)
#define ENET_ECR_DBSWP_MASK                      0x100u
#define ENET_ECR_DBSWP_SHIFT                     8
#define ENET_ECR_DBSWP_WIDTH                     1
#define ENET_ECR_DBSWP(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ECR_DBSWP_SHIFT))&ENET_ECR_DBSWP_MASK)
/* MMFR Bit Fields */
#define ENET_MMFR_DATA_MASK                      0xFFFFu
#define ENET_MMFR_DATA_SHIFT                     0
#define ENET_MMFR_DATA_WIDTH                     16
#define ENET_MMFR_DATA(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_DATA_SHIFT))&ENET_MMFR_DATA_MASK)
#define ENET_MMFR_TA_MASK                        0x30000u
#define ENET_MMFR_TA_SHIFT                       16
#define ENET_MMFR_TA_WIDTH                       2
#define ENET_MMFR_TA(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_TA_SHIFT))&ENET_MMFR_TA_MASK)
#define ENET_MMFR_RA_MASK                        0x7C0000u
#define ENET_MMFR_RA_SHIFT                       18
#define ENET_MMFR_RA_WIDTH                       5
#define ENET_MMFR_RA(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_RA_SHIFT))&ENET_MMFR_RA_MASK)
#define ENET_MMFR_PA_MASK                        0xF800000u
#define ENET_MMFR_PA_SHIFT                       23
#define ENET_MMFR_PA_WIDTH                       5
#define ENET_MMFR_PA(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_PA_SHIFT))&ENET_MMFR_PA_MASK)
#define ENET_MMFR_OP_MASK                        0x30000000u
#define ENET_MMFR_OP_SHIFT                       28
#define ENET_MMFR_OP_WIDTH                       2
#define ENET_MMFR_OP(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_OP_SHIFT))&ENET_MMFR_OP_MASK)
#define ENET_MMFR_ST_MASK                        0xC0000000u
#define ENET_MMFR_ST_SHIFT                       30
#define ENET_MMFR_ST_WIDTH                       2
#define ENET_MMFR_ST(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_ST_SHIFT))&ENET_MMFR_ST_MASK)
/* MSCR Bit Fields */
#define ENET_MSCR_MII_SPEED_MASK                 0x7Eu
#define ENET_MSCR_MII_SPEED_SHIFT                1
#define ENET_MSCR_MII_SPEED_WIDTH                6
#define ENET_MSCR_MII_SPEED(x)                   (((uint32_t)(((uint32_t)(x))<<ENET_MSCR_MII_SPEED_SHIFT))&ENET_MSCR_MII_SPEED_MASK)
#define ENET_MSCR_DIS_PRE_MASK                   0x80u
#define ENET_MSCR_DIS_PRE_SHIFT                  7
#define ENET_MSCR_DIS_PRE_WIDTH                  1
#define ENET_MSCR_DIS_PRE(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_MSCR_DIS_PRE_SHIFT))&ENET_MSCR_DIS_PRE_MASK)
#define ENET_MSCR_HOLDTIME_MASK                  0x700u
#define ENET_MSCR_HOLDTIME_SHIFT                 8
#define ENET_MSCR_HOLDTIME_WIDTH                 3
#define ENET_MSCR_HOLDTIME(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_MSCR_HOLDTIME_SHIFT))&ENET_MSCR_HOLDTIME_MASK)
/* MIBC Bit Fields */
#define ENET_MIBC_MIB_CLEAR_MASK                 0x20000000u
#define ENET_MIBC_MIB_CLEAR_SHIFT                29
#define ENET_MIBC_MIB_CLEAR_WIDTH                1
#define ENET_MIBC_MIB_CLEAR(x)                   (((uint32_t)(((uint32_t)(x))<<ENET_MIBC_MIB_CLEAR_SHIFT))&ENET_MIBC_MIB_CLEAR_MASK)
#define ENET_MIBC_MIB_IDLE_MASK                  0x40000000u
#define ENET_MIBC_MIB_IDLE_SHIFT                 30
#define ENET_MIBC_MIB_IDLE_WIDTH                 1
#define ENET_MIBC_MIB_IDLE(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_MIBC_MIB_IDLE_SHIFT))&ENET_MIBC_MIB_IDLE_MASK)
#define ENET_MIBC_MIB_DIS_MASK                   0x80000000u
#define ENET_MIBC_MIB_DIS_SHIFT                  31
#define ENET_MIBC_MIB_DIS_WIDTH                  1
#define ENET_MIBC_MIB_DIS(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_MIBC_MIB_DIS_SHIFT))&ENET_MIBC_MIB_DIS_MASK)
/* RCR Bit Fields */
#define ENET_RCR_LOOP_MASK                       0x1u
#define ENET_RCR_LOOP_SHIFT                      0
#define ENET_RCR_LOOP_WIDTH                      1
#define ENET_RCR_LOOP(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_RCR_LOOP_SHIFT))&ENET_RCR_LOOP_MASK)
#define ENET_RCR_DRT_MASK                        0x2u
#define ENET_RCR_DRT_SHIFT                       1
#define ENET_RCR_DRT_WIDTH                       1
#define ENET_RCR_DRT(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_RCR_DRT_SHIFT))&ENET_RCR_DRT_MASK)
#define ENET_RCR_MII_MODE_MASK                   0x4u
#define ENET_RCR_MII_MODE_SHIFT                  2
#define ENET_RCR_MII_MODE_WIDTH                  1
#define ENET_RCR_MII_MODE(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_RCR_MII_MODE_SHIFT))&ENET_RCR_MII_MODE_MASK)
#define ENET_RCR_PROM_MASK                       0x8u
#define ENET_RCR_PROM_SHIFT                      3
#define ENET_RCR_PROM_WIDTH                      1
#define ENET_RCR_PROM(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_RCR_PROM_SHIFT))&ENET_RCR_PROM_MASK)
#define ENET_RCR_BC_REJ_MASK                     0x10u
#define ENET_RCR_BC_REJ_SHIFT                    4
#define ENET_RCR_BC_REJ_WIDTH                    1
#define ENET_RCR_BC_REJ(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCR_BC_REJ_SHIFT))&ENET_RCR_BC_REJ_MASK)
#define ENET_RCR_FCE_MASK                        0x20u
#define ENET_RCR_FCE_SHIFT                       5
#define ENET_RCR_FCE_WIDTH                       1
#define ENET_RCR_FCE(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_RCR_FCE_SHIFT))&ENET_RCR_FCE_MASK)
#define ENET_RCR_RMII_MODE_MASK                  0x100u
#define ENET_RCR_RMII_MODE_SHIFT                 8
#define ENET_RCR_RMII_MODE_WIDTH                 1
#define ENET_RCR_RMII_MODE(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_RCR_RMII_MODE_SHIFT))&ENET_RCR_RMII_MODE_MASK)
#define ENET_RCR_RMII_10T_MASK                   0x200u
#define ENET_RCR_RMII_10T_SHIFT                  9
#define ENET_RCR_RMII_10T_WIDTH                  1
#define ENET_RCR_RMII_10T(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_RCR_RMII_10T_SHIFT))&ENET_RCR_RMII_10T_MASK)
#define ENET_RCR_PADEN_MASK                      0x1000u
#define ENET_RCR_PADEN_SHIFT                     12
#define ENET_RCR_PADEN_WIDTH                     1
#define ENET_RCR_PADEN(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_RCR_PADEN_SHIFT))&ENET_RCR_PADEN_MASK)
#define ENET_RCR_PAUFWD_MASK                     0x2000u
#define ENET_RCR_PAUFWD_SHIFT                    13
#define ENET_RCR_PAUFWD_WIDTH                    1
#define ENET_RCR_PAUFWD(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCR_PAUFWD_SHIFT))&ENET_RCR_PAUFWD_MASK)
#define ENET_RCR_CRCFWD_MASK                     0x4000u
#define ENET_RCR_CRCFWD_SHIFT                    14
#define ENET_RCR_CRCFWD_WIDTH                    1
#define ENET_RCR_CRCFWD(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCR_CRCFWD_SHIFT))&ENET_RCR_CRCFWD_MASK)
#define ENET_RCR_CFEN_MASK                       0x8000u
#define ENET_RCR_CFEN_SHIFT                      15
#define ENET_RCR_CFEN_WIDTH                      1
#define ENET_RCR_CFEN(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_RCR_CFEN_SHIFT))&ENET_RCR_CFEN_MASK)
#define ENET_RCR_MAX_FL_MASK                     0x3FFF0000u
#define ENET_RCR_MAX_FL_SHIFT                    16
#define ENET_RCR_MAX_FL_WIDTH                    14
#define ENET_RCR_MAX_FL(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCR_MAX_FL_SHIFT))&ENET_RCR_MAX_FL_MASK)
#define ENET_RCR_NLC_MASK                        0x40000000u
#define ENET_RCR_NLC_SHIFT                       30
#define ENET_RCR_NLC_WIDTH                       1
#define ENET_RCR_NLC(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_RCR_NLC_SHIFT))&ENET_RCR_NLC_MASK)
#define ENET_RCR_GRS_MASK                        0x80000000u
#define ENET_RCR_GRS_SHIFT                       31
#define ENET_RCR_GRS_WIDTH                       1
#define ENET_RCR_GRS(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_RCR_GRS_SHIFT))&ENET_RCR_GRS_MASK)
/* TCR Bit Fields */
#define ENET_TCR_GTS_MASK                        0x1u
#define ENET_TCR_GTS_SHIFT                       0
#define ENET_TCR_GTS_WIDTH                       1
#define ENET_TCR_GTS(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_TCR_GTS_SHIFT))&ENET_TCR_GTS_MASK)
#define ENET_TCR_FDEN_MASK                       0x4u
#define ENET_TCR_FDEN_SHIFT                      2
#define ENET_TCR_FDEN_WIDTH                      1
#define ENET_TCR_FDEN(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TCR_FDEN_SHIFT))&ENET_TCR_FDEN_MASK)
#define ENET_TCR_TFC_PAUSE_MASK                  0x8u
#define ENET_TCR_TFC_PAUSE_SHIFT                 3
#define ENET_TCR_TFC_PAUSE_WIDTH                 1
#define ENET_TCR_TFC_PAUSE(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_TCR_TFC_PAUSE_SHIFT))&ENET_TCR_TFC_PAUSE_MASK)
#define ENET_TCR_RFC_PAUSE_MASK                  0x10u
#define ENET_TCR_RFC_PAUSE_SHIFT                 4
#define ENET_TCR_RFC_PAUSE_WIDTH                 1
#define ENET_TCR_RFC_PAUSE(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_TCR_RFC_PAUSE_SHIFT))&ENET_TCR_RFC_PAUSE_MASK)
#define ENET_TCR_ADDSEL_MASK                     0xE0u
#define ENET_TCR_ADDSEL_SHIFT                    5
#define ENET_TCR_ADDSEL_WIDTH                    3
#define ENET_TCR_ADDSEL(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_TCR_ADDSEL_SHIFT))&ENET_TCR_ADDSEL_MASK)
#define ENET_TCR_ADDINS_MASK                     0x100u
#define ENET_TCR_ADDINS_SHIFT                    8
#define ENET_TCR_ADDINS_WIDTH                    1
#define ENET_TCR_ADDINS(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_TCR_ADDINS_SHIFT))&ENET_TCR_ADDINS_MASK)
#define ENET_TCR_CRCFWD_MASK                     0x200u
#define ENET_TCR_CRCFWD_SHIFT                    9
#define ENET_TCR_CRCFWD_WIDTH                    1
#define ENET_TCR_CRCFWD(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_TCR_CRCFWD_SHIFT))&ENET_TCR_CRCFWD_MASK)
/* PALR Bit Fields */
#define ENET_PALR_PADDR1_MASK                    0xFFFFFFFFu
#define ENET_PALR_PADDR1_SHIFT                   0
#define ENET_PALR_PADDR1_WIDTH                   32
#define ENET_PALR_PADDR1(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_PALR_PADDR1_SHIFT))&ENET_PALR_PADDR1_MASK)
/* PAUR Bit Fields */
#define ENET_PAUR_TYPE_MASK                      0xFFFFu
#define ENET_PAUR_TYPE_SHIFT                     0
#define ENET_PAUR_TYPE_WIDTH                     16
#define ENET_PAUR_TYPE(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_PAUR_TYPE_SHIFT))&ENET_PAUR_TYPE_MASK)
#define ENET_PAUR_PADDR2_MASK                    0xFFFF0000u
#define ENET_PAUR_PADDR2_SHIFT                   16
#define ENET_PAUR_PADDR2_WIDTH                   16
#define ENET_PAUR_PADDR2(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_PAUR_PADDR2_SHIFT))&ENET_PAUR_PADDR2_MASK)
/* OPD Bit Fields */
#define ENET_OPD_PAUSE_DUR_MASK                  0xFFFFu
#define ENET_OPD_PAUSE_DUR_SHIFT                 0
#define ENET_OPD_PAUSE_DUR_WIDTH                 16
#define ENET_OPD_PAUSE_DUR(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_OPD_PAUSE_DUR_SHIFT))&ENET_OPD_PAUSE_DUR_MASK)
#define ENET_OPD_OPCODE_MASK                     0xFFFF0000u
#define ENET_OPD_OPCODE_SHIFT                    16
#define ENET_OPD_OPCODE_WIDTH                    16
#define ENET_OPD_OPCODE(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_OPD_OPCODE_SHIFT))&ENET_OPD_OPCODE_MASK)
/* IAUR Bit Fields */
#define ENET_IAUR_IADDR1_MASK                    0xFFFFFFFFu
#define ENET_IAUR_IADDR1_SHIFT                   0
#define ENET_IAUR_IADDR1_WIDTH                   32
#define ENET_IAUR_IADDR1(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_IAUR_IADDR1_SHIFT))&ENET_IAUR_IADDR1_MASK)
/* IALR Bit Fields */
#define ENET_IALR_IADDR2_MASK                    0xFFFFFFFFu
#define ENET_IALR_IADDR2_SHIFT                   0
#define ENET_IALR_IADDR2_WIDTH                   32
#define ENET_IALR_IADDR2(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_IALR_IADDR2_SHIFT))&ENET_IALR_IADDR2_MASK)
/* GAUR Bit Fields */
#define ENET_GAUR_GADDR1_MASK                    0xFFFFFFFFu
#define ENET_GAUR_GADDR1_SHIFT                   0
#define ENET_GAUR_GADDR1_WIDTH                   32
#define ENET_GAUR_GADDR1(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_GAUR_GADDR1_SHIFT))&ENET_GAUR_GADDR1_MASK)
/* GALR Bit Fields */
#define ENET_GALR_GADDR2_MASK                    0xFFFFFFFFu
#define ENET_GALR_GADDR2_SHIFT                   0
#define ENET_GALR_GADDR2_WIDTH                   32
#define ENET_GALR_GADDR2(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_GALR_GADDR2_SHIFT))&ENET_GALR_GADDR2_MASK)
/* TFWR Bit Fields */
#define ENET_TFWR_TFWR_MASK                      0x3Fu
#define ENET_TFWR_TFWR_SHIFT                     0
#define ENET_TFWR_TFWR_WIDTH                     6
#define ENET_TFWR_TFWR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_TFWR_TFWR_SHIFT))&ENET_TFWR_TFWR_MASK)
#define ENET_TFWR_STRFWD_MASK                    0x100u
#define ENET_TFWR_STRFWD_SHIFT                   8
#define ENET_TFWR_STRFWD_WIDTH                   1
#define ENET_TFWR_STRFWD(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_TFWR_STRFWD_SHIFT))&ENET_TFWR_STRFWD_MASK)
/* RDSR Bit Fields */
#define ENET_RDSR_R_DES_START_MASK               0xFFFFFFF8u
#define ENET_RDSR_R_DES_START_SHIFT              3
#define ENET_RDSR_R_DES_START_WIDTH              29
#define ENET_RDSR_R_DES_START(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_RDSR_R_DES_START_SHIFT))&ENET_RDSR_R_DES_START_MASK)
/* TDSR Bit Fields */
#define ENET_TDSR_X_DES_START_MASK               0xFFFFFFF8u
#define ENET_TDSR_X_DES_START_SHIFT              3
#define ENET_TDSR_X_DES_START_WIDTH              29
#define ENET_TDSR_X_DES_START(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_TDSR_X_DES_START_SHIFT))&ENET_TDSR_X_DES_START_MASK)
/* MRBR Bit Fields */
#define ENET_MRBR_R_BUF_SIZE_MASK                0x7F0u
#define ENET_MRBR_R_BUF_SIZE_SHIFT               4
#define ENET_MRBR_R_BUF_SIZE_WIDTH               7
#define ENET_MRBR_R_BUF_SIZE(x)                  (((uint32_t)(((uint32_t)(x))<<ENET_MRBR_R_BUF_SIZE_SHIFT))&ENET_MRBR_R_BUF_SIZE_MASK)
/* RSFL Bit Fields */
#define ENET_RSFL_RX_SECTION_FULL_MASK           0xFFu
#define ENET_RSFL_RX_SECTION_FULL_SHIFT          0
#define ENET_RSFL_RX_SECTION_FULL_WIDTH          8
#define ENET_RSFL_RX_SECTION_FULL(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RSFL_RX_SECTION_FULL_SHIFT))&ENET_RSFL_RX_SECTION_FULL_MASK)
/* RSEM Bit Fields */
#define ENET_RSEM_RX_SECTION_EMPTY_MASK          0xFFu
#define ENET_RSEM_RX_SECTION_EMPTY_SHIFT         0
#define ENET_RSEM_RX_SECTION_EMPTY_WIDTH         8
#define ENET_RSEM_RX_SECTION_EMPTY(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RSEM_RX_SECTION_EMPTY_SHIFT))&ENET_RSEM_RX_SECTION_EMPTY_MASK)
#define ENET_RSEM_STAT_SECTION_EMPTY_MASK        0x1F0000u
#define ENET_RSEM_STAT_SECTION_EMPTY_SHIFT       16
#define ENET_RSEM_STAT_SECTION_EMPTY_WIDTH       5
#define ENET_RSEM_STAT_SECTION_EMPTY(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RSEM_STAT_SECTION_EMPTY_SHIFT))&ENET_RSEM_STAT_SECTION_EMPTY_MASK)
/* RAEM Bit Fields */
#define ENET_RAEM_RX_ALMOST_EMPTY_MASK           0xFFu
#define ENET_RAEM_RX_ALMOST_EMPTY_SHIFT          0
#define ENET_RAEM_RX_ALMOST_EMPTY_WIDTH          8
#define ENET_RAEM_RX_ALMOST_EMPTY(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RAEM_RX_ALMOST_EMPTY_SHIFT))&ENET_RAEM_RX_ALMOST_EMPTY_MASK)
/* RAFL Bit Fields */
#define ENET_RAFL_RX_ALMOST_FULL_MASK            0xFFu
#define ENET_RAFL_RX_ALMOST_FULL_SHIFT           0
#define ENET_RAFL_RX_ALMOST_FULL_WIDTH           8
#define ENET_RAFL_RX_ALMOST_FULL(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RAFL_RX_ALMOST_FULL_SHIFT))&ENET_RAFL_RX_ALMOST_FULL_MASK)
/* TSEM Bit Fields */
#define ENET_TSEM_TX_SECTION_EMPTY_MASK          0xFFu
#define ENET_TSEM_TX_SECTION_EMPTY_SHIFT         0
#define ENET_TSEM_TX_SECTION_EMPTY_WIDTH         8
#define ENET_TSEM_TX_SECTION_EMPTY(x)            (((uint32_t)(((uint32_t)(x))<<ENET_TSEM_TX_SECTION_EMPTY_SHIFT))&ENET_TSEM_TX_SECTION_EMPTY_MASK)
/* TAEM Bit Fields */
#define ENET_TAEM_TX_ALMOST_EMPTY_MASK           0xFFu
#define ENET_TAEM_TX_ALMOST_EMPTY_SHIFT          0
#define ENET_TAEM_TX_ALMOST_EMPTY_WIDTH          8
#define ENET_TAEM_TX_ALMOST_EMPTY(x)             (((uint32_t)(((uint32_t)(x))<<ENET_TAEM_TX_ALMOST_EMPTY_SHIFT))&ENET_TAEM_TX_ALMOST_EMPTY_MASK)
/* TAFL Bit Fields */
#define ENET_TAFL_TX_ALMOST_FULL_MASK            0xFFu
#define ENET_TAFL_TX_ALMOST_FULL_SHIFT           0
#define ENET_TAFL_TX_ALMOST_FULL_WIDTH           8
#define ENET_TAFL_TX_ALMOST_FULL(x)              (((uint32_t)(((uint32_t)(x))<<ENET_TAFL_TX_ALMOST_FULL_SHIFT))&ENET_TAFL_TX_ALMOST_FULL_MASK)
/* TIPG Bit Fields */
#define ENET_TIPG_IPG_MASK                       0x1Fu
#define ENET_TIPG_IPG_SHIFT                      0
#define ENET_TIPG_IPG_WIDTH                      5
#define ENET_TIPG_IPG(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TIPG_IPG_SHIFT))&ENET_TIPG_IPG_MASK)
/* FTRL Bit Fields */
#define ENET_FTRL_TRUNC_FL_MASK                  0x3FFFu
#define ENET_FTRL_TRUNC_FL_SHIFT                 0
#define ENET_FTRL_TRUNC_FL_WIDTH                 14
#define ENET_FTRL_TRUNC_FL(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_FTRL_TRUNC_FL_SHIFT))&ENET_FTRL_TRUNC_FL_MASK)
/* TACC Bit Fields */
#define ENET_TACC_SHIFT16_MASK                   0x1u
#define ENET_TACC_SHIFT16_SHIFT                  0
#define ENET_TACC_SHIFT16_WIDTH                  1
#define ENET_TACC_SHIFT16(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_TACC_SHIFT16_SHIFT))&ENET_TACC_SHIFT16_MASK)
#define ENET_TACC_IPCHK_MASK                     0x8u
#define ENET_TACC_IPCHK_SHIFT                    3
#define ENET_TACC_IPCHK_WIDTH                    1
#define ENET_TACC_IPCHK(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_TACC_IPCHK_SHIFT))&ENET_TACC_IPCHK_MASK)
#define ENET_TACC_PROCHK_MASK                    0x10u
#define ENET_TACC_PROCHK_SHIFT                   4
#define ENET_TACC_PROCHK_WIDTH                   1
#define ENET_TACC_PROCHK(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_TACC_PROCHK_SHIFT))&ENET_TACC_PROCHK_MASK)
/* RACC Bit Fields */
#define ENET_RACC_PADREM_MASK                    0x1u
#define ENET_RACC_PADREM_SHIFT                   0
#define ENET_RACC_PADREM_WIDTH                   1
#define ENET_RACC_PADREM(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_RACC_PADREM_SHIFT))&ENET_RACC_PADREM_MASK)
#define ENET_RACC_IPDIS_MASK                     0x2u
#define ENET_RACC_IPDIS_SHIFT                    1
#define ENET_RACC_IPDIS_WIDTH                    1
#define ENET_RACC_IPDIS(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RACC_IPDIS_SHIFT))&ENET_RACC_IPDIS_MASK)
#define ENET_RACC_PRODIS_MASK                    0x4u
#define ENET_RACC_PRODIS_SHIFT                   2
#define ENET_RACC_PRODIS_WIDTH                   1
#define ENET_RACC_PRODIS(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_RACC_PRODIS_SHIFT))&ENET_RACC_PRODIS_MASK)
#define ENET_RACC_LINEDIS_MASK                   0x40u
#define ENET_RACC_LINEDIS_SHIFT                  6
#define ENET_RACC_LINEDIS_WIDTH                  1
#define ENET_RACC_LINEDIS(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_RACC_LINEDIS_SHIFT))&ENET_RACC_LINEDIS_MASK)
#define ENET_RACC_SHIFT16_MASK                   0x80u
#define ENET_RACC_SHIFT16_SHIFT                  7
#define ENET_RACC_SHIFT16_WIDTH                  1
#define ENET_RACC_SHIFT16(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_RACC_SHIFT16_SHIFT))&ENET_RACC_SHIFT16_MASK)
/* RMON_T_PACKETS Bit Fields */
#define ENET_RMON_T_PACKETS_TXPKTS_MASK          0xFFFFu
#define ENET_RMON_T_PACKETS_TXPKTS_SHIFT         0
#define ENET_RMON_T_PACKETS_TXPKTS_WIDTH         16
#define ENET_RMON_T_PACKETS_TXPKTS(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_PACKETS_TXPKTS_SHIFT))&ENET_RMON_T_PACKETS_TXPKTS_MASK)
/* RMON_T_BC_PKT Bit Fields */
#define ENET_RMON_T_BC_PKT_TXPKTS_MASK           0xFFFFu
#define ENET_RMON_T_BC_PKT_TXPKTS_SHIFT          0
#define ENET_RMON_T_BC_PKT_TXPKTS_WIDTH          16
#define ENET_RMON_T_BC_PKT_TXPKTS(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_BC_PKT_TXPKTS_SHIFT))&ENET_RMON_T_BC_PKT_TXPKTS_MASK)
/* RMON_T_MC_PKT Bit Fields */
#define ENET_RMON_T_MC_PKT_TXPKTS_MASK           0xFFFFu
#define ENET_RMON_T_MC_PKT_TXPKTS_SHIFT          0
#define ENET_RMON_T_MC_PKT_TXPKTS_WIDTH          16
#define ENET_RMON_T_MC_PKT_TXPKTS(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_MC_PKT_TXPKTS_SHIFT))&ENET_RMON_T_MC_PKT_TXPKTS_MASK)
/* RMON_T_CRC_ALIGN Bit Fields */
#define ENET_RMON_T_CRC_ALIGN_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_CRC_ALIGN_TXPKTS_SHIFT       0
#define ENET_RMON_T_CRC_ALIGN_TXPKTS_WIDTH       16
#define ENET_RMON_T_CRC_ALIGN_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_CRC_ALIGN_TXPKTS_SHIFT))&ENET_RMON_T_CRC_ALIGN_TXPKTS_MASK)
/* RMON_T_UNDERSIZE Bit Fields */
#define ENET_RMON_T_UNDERSIZE_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_UNDERSIZE_TXPKTS_SHIFT       0
#define ENET_RMON_T_UNDERSIZE_TXPKTS_WIDTH       16
#define ENET_RMON_T_UNDERSIZE_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_UNDERSIZE_TXPKTS_SHIFT))&ENET_RMON_T_UNDERSIZE_TXPKTS_MASK)
/* RMON_T_OVERSIZE Bit Fields */
#define ENET_RMON_T_OVERSIZE_TXPKTS_MASK         0xFFFFu
#define ENET_RMON_T_OVERSIZE_TXPKTS_SHIFT        0
#define ENET_RMON_T_OVERSIZE_TXPKTS_WIDTH        16
#define ENET_RMON_T_OVERSIZE_TXPKTS(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_OVERSIZE_TXPKTS_SHIFT))&ENET_RMON_T_OVERSIZE_TXPKTS_MASK)
/* RMON_T_FRAG Bit Fields */
#define ENET_RMON_T_FRAG_TXPKTS_MASK             0xFFFFu
#define ENET_RMON_T_FRAG_TXPKTS_SHIFT            0
#define ENET_RMON_T_FRAG_TXPKTS_WIDTH            16
#define ENET_RMON_T_FRAG_TXPKTS(x)               (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_FRAG_TXPKTS_SHIFT))&ENET_RMON_T_FRAG_TXPKTS_MASK)
/* RMON_T_JAB Bit Fields */
#define ENET_RMON_T_JAB_TXPKTS_MASK              0xFFFFu
#define ENET_RMON_T_JAB_TXPKTS_SHIFT             0
#define ENET_RMON_T_JAB_TXPKTS_WIDTH             16
#define ENET_RMON_T_JAB_TXPKTS(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_JAB_TXPKTS_SHIFT))&ENET_RMON_T_JAB_TXPKTS_MASK)
/* RMON_T_COL Bit Fields */
#define ENET_RMON_T_COL_TXPKTS_MASK              0xFFFFu
#define ENET_RMON_T_COL_TXPKTS_SHIFT             0
#define ENET_RMON_T_COL_TXPKTS_WIDTH             16
#define ENET_RMON_T_COL_TXPKTS(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_COL_TXPKTS_SHIFT))&ENET_RMON_T_COL_TXPKTS_MASK)
/* RMON_T_P64 Bit Fields */
#define ENET_RMON_T_P64_TXPKTS_MASK              0xFFFFu
#define ENET_RMON_T_P64_TXPKTS_SHIFT             0
#define ENET_RMON_T_P64_TXPKTS_WIDTH             16
#define ENET_RMON_T_P64_TXPKTS(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P64_TXPKTS_SHIFT))&ENET_RMON_T_P64_TXPKTS_MASK)
/* RMON_T_P65TO127 Bit Fields */
#define ENET_RMON_T_P65TO127_TXPKTS_MASK         0xFFFFu
#define ENET_RMON_T_P65TO127_TXPKTS_SHIFT        0
#define ENET_RMON_T_P65TO127_TXPKTS_WIDTH        16
#define ENET_RMON_T_P65TO127_TXPKTS(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P65TO127_TXPKTS_SHIFT))&ENET_RMON_T_P65TO127_TXPKTS_MASK)
/* RMON_T_P128TO255 Bit Fields */
#define ENET_RMON_T_P128TO255_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_P128TO255_TXPKTS_SHIFT       0
#define ENET_RMON_T_P128TO255_TXPKTS_WIDTH       16
#define ENET_RMON_T_P128TO255_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P128TO255_TXPKTS_SHIFT))&ENET_RMON_T_P128TO255_TXPKTS_MASK)
/* RMON_T_P256TO511 Bit Fields */
#define ENET_RMON_T_P256TO511_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_P256TO511_TXPKTS_SHIFT       0
#define ENET_RMON_T_P256TO511_TXPKTS_WIDTH       16
#define ENET_RMON_T_P256TO511_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P256TO511_TXPKTS_SHIFT))&ENET_RMON_T_P256TO511_TXPKTS_MASK)
/* RMON_T_P512TO1023 Bit Fields */
#define ENET_RMON_T_P512TO1023_TXPKTS_MASK       0xFFFFu
#define ENET_RMON_T_P512TO1023_TXPKTS_SHIFT      0
#define ENET_RMON_T_P512TO1023_TXPKTS_WIDTH      16
#define ENET_RMON_T_P512TO1023_TXPKTS(x)         (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P512TO1023_TXPKTS_SHIFT))&ENET_RMON_T_P512TO1023_TXPKTS_MASK)
/* RMON_T_P1024TO2047 Bit Fields */
#define ENET_RMON_T_P1024TO2047_TXPKTS_MASK      0xFFFFu
#define ENET_RMON_T_P1024TO2047_TXPKTS_SHIFT     0
#define ENET_RMON_T_P1024TO2047_TXPKTS_WIDTH     16
#define ENET_RMON_T_P1024TO2047_TXPKTS(x)        (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P1024TO2047_TXPKTS_SHIFT))&ENET_RMON_T_P1024TO2047_TXPKTS_MASK)
/* RMON_T_P_GTE2048 Bit Fields */
#define ENET_RMON_T_P_GTE2048_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_P_GTE2048_TXPKTS_SHIFT       0
#define ENET_RMON_T_P_GTE2048_TXPKTS_WIDTH       16
#define ENET_RMON_T_P_GTE2048_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P_GTE2048_TXPKTS_SHIFT))&ENET_RMON_T_P_GTE2048_TXPKTS_MASK)
/* RMON_T_OCTETS Bit Fields */
#define ENET_RMON_T_OCTETS_TXOCTS_MASK           0xFFFFFFFFu
#define ENET_RMON_T_OCTETS_TXOCTS_SHIFT          0
#define ENET_RMON_T_OCTETS_TXOCTS_WIDTH          32
#define ENET_RMON_T_OCTETS_TXOCTS(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_OCTETS_TXOCTS_SHIFT))&ENET_RMON_T_OCTETS_TXOCTS_MASK)
/* IEEE_T_FRAME_OK Bit Fields */
#define ENET_IEEE_T_FRAME_OK_COUNT_MASK          0xFFFFu
#define ENET_IEEE_T_FRAME_OK_COUNT_SHIFT         0
#define ENET_IEEE_T_FRAME_OK_COUNT_WIDTH         16
#define ENET_IEEE_T_FRAME_OK_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_FRAME_OK_COUNT_SHIFT))&ENET_IEEE_T_FRAME_OK_COUNT_MASK)
/* IEEE_T_1COL Bit Fields */
#define ENET_IEEE_T_1COL_COUNT_MASK              0xFFFFu
#define ENET_IEEE_T_1COL_COUNT_SHIFT             0
#define ENET_IEEE_T_1COL_COUNT_WIDTH             16
#define ENET_IEEE_T_1COL_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_1COL_COUNT_SHIFT))&ENET_IEEE_T_1COL_COUNT_MASK)
/* IEEE_T_MCOL Bit Fields */
#define ENET_IEEE_T_MCOL_COUNT_MASK              0xFFFFu
#define ENET_IEEE_T_MCOL_COUNT_SHIFT             0
#define ENET_IEEE_T_MCOL_COUNT_WIDTH             16
#define ENET_IEEE_T_MCOL_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_MCOL_COUNT_SHIFT))&ENET_IEEE_T_MCOL_COUNT_MASK)
/* IEEE_T_DEF Bit Fields */
#define ENET_IEEE_T_DEF_COUNT_MASK               0xFFFFu
#define ENET_IEEE_T_DEF_COUNT_SHIFT              0
#define ENET_IEEE_T_DEF_COUNT_WIDTH              16
#define ENET_IEEE_T_DEF_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_DEF_COUNT_SHIFT))&ENET_IEEE_T_DEF_COUNT_MASK)
/* IEEE_T_LCOL Bit Fields */
#define ENET_IEEE_T_LCOL_COUNT_MASK              0xFFFFu
#define ENET_IEEE_T_LCOL_COUNT_SHIFT             0
#define ENET_IEEE_T_LCOL_COUNT_WIDTH             16
#define ENET_IEEE_T_LCOL_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_LCOL_COUNT_SHIFT))&ENET_IEEE_T_LCOL_COUNT_MASK)
/* IEEE_T_EXCOL Bit Fields */
#define ENET_IEEE_T_EXCOL_COUNT_MASK             0xFFFFu
#define ENET_IEEE_T_EXCOL_COUNT_SHIFT            0
#define ENET_IEEE_T_EXCOL_COUNT_WIDTH            16
#define ENET_IEEE_T_EXCOL_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_EXCOL_COUNT_SHIFT))&ENET_IEEE_T_EXCOL_COUNT_MASK)
/* IEEE_T_MACERR Bit Fields */
#define ENET_IEEE_T_MACERR_COUNT_MASK            0xFFFFu
#define ENET_IEEE_T_MACERR_COUNT_SHIFT           0
#define ENET_IEEE_T_MACERR_COUNT_WIDTH           16
#define ENET_IEEE_T_MACERR_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_MACERR_COUNT_SHIFT))&ENET_IEEE_T_MACERR_COUNT_MASK)
/* IEEE_T_CSERR Bit Fields */
#define ENET_IEEE_T_CSERR_COUNT_MASK             0xFFFFu
#define ENET_IEEE_T_CSERR_COUNT_SHIFT            0
#define ENET_IEEE_T_CSERR_COUNT_WIDTH            16
#define ENET_IEEE_T_CSERR_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_CSERR_COUNT_SHIFT))&ENET_IEEE_T_CSERR_COUNT_MASK)
/* IEEE_T_SQE Bit Fields */
#define ENET_IEEE_T_SQE_COUNT_MASK               0xFFFFu
#define ENET_IEEE_T_SQE_COUNT_SHIFT              0
#define ENET_IEEE_T_SQE_COUNT_WIDTH              16
#define ENET_IEEE_T_SQE_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_SQE_COUNT_SHIFT))&ENET_IEEE_T_SQE_COUNT_MASK)
/* IEEE_T_FDXFC Bit Fields */
#define ENET_IEEE_T_FDXFC_COUNT_MASK             0xFFFFu
#define ENET_IEEE_T_FDXFC_COUNT_SHIFT            0
#define ENET_IEEE_T_FDXFC_COUNT_WIDTH            16
#define ENET_IEEE_T_FDXFC_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_FDXFC_COUNT_SHIFT))&ENET_IEEE_T_FDXFC_COUNT_MASK)
/* IEEE_T_OCTETS_OK Bit Fields */
#define ENET_IEEE_T_OCTETS_OK_COUNT_MASK         0xFFFFFFFFu
#define ENET_IEEE_T_OCTETS_OK_COUNT_SHIFT        0
#define ENET_IEEE_T_OCTETS_OK_COUNT_WIDTH        32
#define ENET_IEEE_T_OCTETS_OK_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_OCTETS_OK_COUNT_SHIFT))&ENET_IEEE_T_OCTETS_OK_COUNT_MASK)
/* RMON_R_PACKETS Bit Fields */
#define ENET_RMON_R_PACKETS_COUNT_MASK           0xFFFFu
#define ENET_RMON_R_PACKETS_COUNT_SHIFT          0
#define ENET_RMON_R_PACKETS_COUNT_WIDTH          16
#define ENET_RMON_R_PACKETS_COUNT(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_PACKETS_COUNT_SHIFT))&ENET_RMON_R_PACKETS_COUNT_MASK)
/* RMON_R_BC_PKT Bit Fields */
#define ENET_RMON_R_BC_PKT_COUNT_MASK            0xFFFFu
#define ENET_RMON_R_BC_PKT_COUNT_SHIFT           0
#define ENET_RMON_R_BC_PKT_COUNT_WIDTH           16
#define ENET_RMON_R_BC_PKT_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_BC_PKT_COUNT_SHIFT))&ENET_RMON_R_BC_PKT_COUNT_MASK)
/* RMON_R_MC_PKT Bit Fields */
#define ENET_RMON_R_MC_PKT_COUNT_MASK            0xFFFFu
#define ENET_RMON_R_MC_PKT_COUNT_SHIFT           0
#define ENET_RMON_R_MC_PKT_COUNT_WIDTH           16
#define ENET_RMON_R_MC_PKT_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_MC_PKT_COUNT_SHIFT))&ENET_RMON_R_MC_PKT_COUNT_MASK)
/* RMON_R_CRC_ALIGN Bit Fields */
#define ENET_RMON_R_CRC_ALIGN_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_CRC_ALIGN_COUNT_SHIFT        0
#define ENET_RMON_R_CRC_ALIGN_COUNT_WIDTH        16
#define ENET_RMON_R_CRC_ALIGN_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_CRC_ALIGN_COUNT_SHIFT))&ENET_RMON_R_CRC_ALIGN_COUNT_MASK)
/* RMON_R_UNDERSIZE Bit Fields */
#define ENET_RMON_R_UNDERSIZE_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_UNDERSIZE_COUNT_SHIFT        0
#define ENET_RMON_R_UNDERSIZE_COUNT_WIDTH        16
#define ENET_RMON_R_UNDERSIZE_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_UNDERSIZE_COUNT_SHIFT))&ENET_RMON_R_UNDERSIZE_COUNT_MASK)
/* RMON_R_OVERSIZE Bit Fields */
#define ENET_RMON_R_OVERSIZE_COUNT_MASK          0xFFFFu
#define ENET_RMON_R_OVERSIZE_COUNT_SHIFT         0
#define ENET_RMON_R_OVERSIZE_COUNT_WIDTH         16
#define ENET_RMON_R_OVERSIZE_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_OVERSIZE_COUNT_SHIFT))&ENET_RMON_R_OVERSIZE_COUNT_MASK)
/* RMON_R_FRAG Bit Fields */
#define ENET_RMON_R_FRAG_COUNT_MASK              0xFFFFu
#define ENET_RMON_R_FRAG_COUNT_SHIFT             0
#define ENET_RMON_R_FRAG_COUNT_WIDTH             16
#define ENET_RMON_R_FRAG_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_FRAG_COUNT_SHIFT))&ENET_RMON_R_FRAG_COUNT_MASK)
/* RMON_R_JAB Bit Fields */
#define ENET_RMON_R_JAB_COUNT_MASK               0xFFFFu
#define ENET_RMON_R_JAB_COUNT_SHIFT              0
#define ENET_RMON_R_JAB_COUNT_WIDTH              16
#define ENET_RMON_R_JAB_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_JAB_COUNT_SHIFT))&ENET_RMON_R_JAB_COUNT_MASK)
/* RMON_R_P64 Bit Fields */
#define ENET_RMON_R_P64_COUNT_MASK               0xFFFFu
#define ENET_RMON_R_P64_COUNT_SHIFT              0
#define ENET_RMON_R_P64_COUNT_WIDTH              16
#define ENET_RMON_R_P64_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P64_COUNT_SHIFT))&ENET_RMON_R_P64_COUNT_MASK)
/* RMON_R_P65TO127 Bit Fields */
#define ENET_RMON_R_P65TO127_COUNT_MASK          0xFFFFu
#define ENET_RMON_R_P65TO127_COUNT_SHIFT         0
#define ENET_RMON_R_P65TO127_COUNT_WIDTH         16
#define ENET_RMON_R_P65TO127_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P65TO127_COUNT_SHIFT))&ENET_RMON_R_P65TO127_COUNT_MASK)
/* RMON_R_P128TO255 Bit Fields */
#define ENET_RMON_R_P128TO255_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_P128TO255_COUNT_SHIFT        0
#define ENET_RMON_R_P128TO255_COUNT_WIDTH        16
#define ENET_RMON_R_P128TO255_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P128TO255_COUNT_SHIFT))&ENET_RMON_R_P128TO255_COUNT_MASK)
/* RMON_R_P256TO511 Bit Fields */
#define ENET_RMON_R_P256TO511_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_P256TO511_COUNT_SHIFT        0
#define ENET_RMON_R_P256TO511_COUNT_WIDTH        16
#define ENET_RMON_R_P256TO511_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P256TO511_COUNT_SHIFT))&ENET_RMON_R_P256TO511_COUNT_MASK)
/* RMON_R_P512TO1023 Bit Fields */
#define ENET_RMON_R_P512TO1023_COUNT_MASK        0xFFFFu
#define ENET_RMON_R_P512TO1023_COUNT_SHIFT       0
#define ENET_RMON_R_P512TO1023_COUNT_WIDTH       16
#define ENET_RMON_R_P512TO1023_COUNT(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P512TO1023_COUNT_SHIFT))&ENET_RMON_R_P512TO1023_COUNT_MASK)
/* RMON_R_P1024TO2047 Bit Fields */
#define ENET_RMON_R_P1024TO2047_COUNT_MASK       0xFFFFu
#define ENET_RMON_R_P1024TO2047_COUNT_SHIFT      0
#define ENET_RMON_R_P1024TO2047_COUNT_WIDTH      16
#define ENET_RMON_R_P1024TO2047_COUNT(x)         (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P1024TO2047_COUNT_SHIFT))&ENET_RMON_R_P1024TO2047_COUNT_MASK)
/* RMON_R_P_GTE2048 Bit Fields */
#define ENET_RMON_R_P_GTE2048_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_P_GTE2048_COUNT_SHIFT        0
#define ENET_RMON_R_P_GTE2048_COUNT_WIDTH        16
#define ENET_RMON_R_P_GTE2048_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P_GTE2048_COUNT_SHIFT))&ENET_RMON_R_P_GTE2048_COUNT_MASK)
/* RMON_R_OCTETS Bit Fields */
#define ENET_RMON_R_OCTETS_COUNT_MASK            0xFFFFFFFFu
#define ENET_RMON_R_OCTETS_COUNT_SHIFT           0
#define ENET_RMON_R_OCTETS_COUNT_WIDTH           32
#define ENET_RMON_R_OCTETS_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_OCTETS_COUNT_SHIFT))&ENET_RMON_R_OCTETS_COUNT_MASK)
/* IEEE_R_DROP Bit Fields */
#define ENET_IEEE_R_DROP_COUNT_MASK              0xFFFFu
#define ENET_IEEE_R_DROP_COUNT_SHIFT             0
#define ENET_IEEE_R_DROP_COUNT_WIDTH             16
#define ENET_IEEE_R_DROP_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_DROP_COUNT_SHIFT))&ENET_IEEE_R_DROP_COUNT_MASK)
/* IEEE_R_FRAME_OK Bit Fields */
#define ENET_IEEE_R_FRAME_OK_COUNT_MASK          0xFFFFu
#define ENET_IEEE_R_FRAME_OK_COUNT_SHIFT         0
#define ENET_IEEE_R_FRAME_OK_COUNT_WIDTH         16
#define ENET_IEEE_R_FRAME_OK_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_FRAME_OK_COUNT_SHIFT))&ENET_IEEE_R_FRAME_OK_COUNT_MASK)
/* IEEE_R_CRC Bit Fields */
#define ENET_IEEE_R_CRC_COUNT_MASK               0xFFFFu
#define ENET_IEEE_R_CRC_COUNT_SHIFT              0
#define ENET_IEEE_R_CRC_COUNT_WIDTH              16
#define ENET_IEEE_R_CRC_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_CRC_COUNT_SHIFT))&ENET_IEEE_R_CRC_COUNT_MASK)
/* IEEE_R_ALIGN Bit Fields */
#define ENET_IEEE_R_ALIGN_COUNT_MASK             0xFFFFu
#define ENET_IEEE_R_ALIGN_COUNT_SHIFT            0
#define ENET_IEEE_R_ALIGN_COUNT_WIDTH            16
#define ENET_IEEE_R_ALIGN_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_ALIGN_COUNT_SHIFT))&ENET_IEEE_R_ALIGN_COUNT_MASK)
/* IEEE_R_MACERR Bit Fields */
#define ENET_IEEE_R_MACERR_COUNT_MASK            0xFFFFu
#define ENET_IEEE_R_MACERR_COUNT_SHIFT           0
#define ENET_IEEE_R_MACERR_COUNT_WIDTH           16
#define ENET_IEEE_R_MACERR_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_MACERR_COUNT_SHIFT))&ENET_IEEE_R_MACERR_COUNT_MASK)
/* IEEE_R_FDXFC Bit Fields */
#define ENET_IEEE_R_FDXFC_COUNT_MASK             0xFFFFu
#define ENET_IEEE_R_FDXFC_COUNT_SHIFT            0
#define ENET_IEEE_R_FDXFC_COUNT_WIDTH            16
#define ENET_IEEE_R_FDXFC_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_FDXFC_COUNT_SHIFT))&ENET_IEEE_R_FDXFC_COUNT_MASK)
/* IEEE_R_OCTETS_OK Bit Fields */
#define ENET_IEEE_R_OCTETS_OK_COUNT_MASK         0xFFFFFFFFu
#define ENET_IEEE_R_OCTETS_OK_COUNT_SHIFT        0
#define ENET_IEEE_R_OCTETS_OK_COUNT_WIDTH        32
#define ENET_IEEE_R_OCTETS_OK_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_OCTETS_OK_COUNT_SHIFT))&ENET_IEEE_R_OCTETS_OK_COUNT_MASK)
/* ATCR Bit Fields */
#define ENET_ATCR_EN_MASK                        0x1u
#define ENET_ATCR_EN_SHIFT                       0
#define ENET_ATCR_EN_WIDTH                       1
#define ENET_ATCR_EN(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_EN_SHIFT))&ENET_ATCR_EN_MASK)
#define ENET_ATCR_OFFEN_MASK                     0x4u
#define ENET_ATCR_OFFEN_SHIFT                    2
#define ENET_ATCR_OFFEN_WIDTH                    1
#define ENET_ATCR_OFFEN(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_OFFEN_SHIFT))&ENET_ATCR_OFFEN_MASK)
#define ENET_ATCR_OFFRST_MASK                    0x8u
#define ENET_ATCR_OFFRST_SHIFT                   3
#define ENET_ATCR_OFFRST_WIDTH                   1
#define ENET_ATCR_OFFRST(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_OFFRST_SHIFT))&ENET_ATCR_OFFRST_MASK)
#define ENET_ATCR_PEREN_MASK                     0x10u
#define ENET_ATCR_PEREN_SHIFT                    4
#define ENET_ATCR_PEREN_WIDTH                    1
#define ENET_ATCR_PEREN(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_PEREN_SHIFT))&ENET_ATCR_PEREN_MASK)
#define ENET_ATCR_PINPER_MASK                    0x80u
#define ENET_ATCR_PINPER_SHIFT                   7
#define ENET_ATCR_PINPER_WIDTH                   1
#define ENET_ATCR_PINPER(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_PINPER_SHIFT))&ENET_ATCR_PINPER_MASK)
#define ENET_ATCR_RESTART_MASK                   0x200u
#define ENET_ATCR_RESTART_SHIFT                  9
#define ENET_ATCR_RESTART_WIDTH                  1
#define ENET_ATCR_RESTART(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_RESTART_SHIFT))&ENET_ATCR_RESTART_MASK)
#define ENET_ATCR_CAPTURE_MASK                   0x800u
#define ENET_ATCR_CAPTURE_SHIFT                  11
#define ENET_ATCR_CAPTURE_WIDTH                  1
#define ENET_ATCR_CAPTURE(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_CAPTURE_SHIFT))&ENET_ATCR_CAPTURE_MASK)
#define ENET_ATCR_SLAVE_MASK                     0x2000u
#define ENET_ATCR_SLAVE_SHIFT                    13
#define ENET_ATCR_SLAVE_WIDTH                    1
#define ENET_ATCR_SLAVE(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_ATCR_SLAVE_SHIFT))&ENET_ATCR_SLAVE_MASK)
/* ATVR Bit Fields */
#define ENET_ATVR_ATIME_MASK                     0xFFFFFFFFu
#define ENET_ATVR_ATIME_SHIFT                    0
#define ENET_ATVR_ATIME_WIDTH                    32
#define ENET_ATVR_ATIME(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_ATVR_ATIME_SHIFT))&ENET_ATVR_ATIME_MASK)
/* ATOFF Bit Fields */
#define ENET_ATOFF_OFFSET_MASK                   0xFFFFFFFFu
#define ENET_ATOFF_OFFSET_SHIFT                  0
#define ENET_ATOFF_OFFSET_WIDTH                  32
#define ENET_ATOFF_OFFSET(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_ATOFF_OFFSET_SHIFT))&ENET_ATOFF_OFFSET_MASK)
/* ATPER Bit Fields */
#define ENET_ATPER_PERIOD_MASK                   0xFFFFFFFFu
#define ENET_ATPER_PERIOD_SHIFT                  0
#define ENET_ATPER_PERIOD_WIDTH                  32
#define ENET_ATPER_PERIOD(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_ATPER_PERIOD_SHIFT))&ENET_ATPER_PERIOD_MASK)
/* ATCOR Bit Fields */
#define ENET_ATCOR_COR_MASK                      0x7FFFFFFFu
#define ENET_ATCOR_COR_SHIFT                     0
#define ENET_ATCOR_COR_WIDTH                     31
#define ENET_ATCOR_COR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ATCOR_COR_SHIFT))&ENET_ATCOR_COR_MASK)
/* ATINC Bit Fields */
#define ENET_ATINC_INC_MASK                      0x7Fu
#define ENET_ATINC_INC_SHIFT                     0
#define ENET_ATINC_INC_WIDTH                     7
#define ENET_ATINC_INC(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ATINC_INC_SHIFT))&ENET_ATINC_INC_MASK)
#define ENET_ATINC_INC_CORR_MASK                 0x7F00u
#define ENET_ATINC_INC_CORR_SHIFT                8
#define ENET_ATINC_INC_CORR_WIDTH                7
#define ENET_ATINC_INC_CORR(x)                   (((uint32_t)(((uint32_t)(x))<<ENET_ATINC_INC_CORR_SHIFT))&ENET_ATINC_INC_CORR_MASK)
/* ATSTMP Bit Fields */
#define ENET_ATSTMP_TIMESTAMP_MASK               0xFFFFFFFFu
#define ENET_ATSTMP_TIMESTAMP_SHIFT              0
#define ENET_ATSTMP_TIMESTAMP_WIDTH              32
#define ENET_ATSTMP_TIMESTAMP(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_ATSTMP_TIMESTAMP_SHIFT))&ENET_ATSTMP_TIMESTAMP_MASK)
/* TGSR Bit Fields */
#define ENET_TGSR_TF0_MASK                       0x1u
#define ENET_TGSR_TF0_SHIFT                      0
#define ENET_TGSR_TF0_WIDTH                      1
#define ENET_TGSR_TF0(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TGSR_TF0_SHIFT))&ENET_TGSR_TF0_MASK)
#define ENET_TGSR_TF1_MASK                       0x2u
#define ENET_TGSR_TF1_SHIFT                      1
#define ENET_TGSR_TF1_WIDTH                      1
#define ENET_TGSR_TF1(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TGSR_TF1_SHIFT))&ENET_TGSR_TF1_MASK)
#define ENET_TGSR_TF2_MASK                       0x4u
#define ENET_TGSR_TF2_SHIFT                      2
#define ENET_TGSR_TF2_WIDTH                      1
#define ENET_TGSR_TF2(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TGSR_TF2_SHIFT))&ENET_TGSR_TF2_MASK)
#define ENET_TGSR_TF3_MASK                       0x8u
#define ENET_TGSR_TF3_SHIFT                      3
#define ENET_TGSR_TF3_WIDTH                      1
#define ENET_TGSR_TF3(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TGSR_TF3_SHIFT))&ENET_TGSR_TF3_MASK)
/* TCSR Bit Fields */
#define ENET_TCSR_TDRE_MASK                      0x1u
#define ENET_TCSR_TDRE_SHIFT                     0
#define ENET_TCSR_TDRE_WIDTH                     1
#define ENET_TCSR_TDRE(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_TCSR_TDRE_SHIFT))&ENET_TCSR_TDRE_MASK)
#define ENET_TCSR_TMODE_MASK                     0x3Cu
#define ENET_TCSR_TMODE_SHIFT                    2
#define ENET_TCSR_TMODE_WIDTH                    4
#define ENET_TCSR_TMODE(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_TCSR_TMODE_SHIFT))&ENET_TCSR_TMODE_MASK)
#define ENET_TCSR_TIE_MASK                       0x40u
#define ENET_TCSR_TIE_SHIFT                      6
#define ENET_TCSR_TIE_WIDTH                      1
#define ENET_TCSR_TIE(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TCSR_TIE_SHIFT))&ENET_TCSR_TIE_MASK)
#define ENET_TCSR_TF_MASK                        0x80u
#define ENET_TCSR_TF_SHIFT                       7
#define ENET_TCSR_TF_WIDTH                       1
#define ENET_TCSR_TF(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_TCSR_TF_SHIFT))&ENET_TCSR_TF_MASK)
/* TCCR Bit Fields */
#define ENET_TCCR_TCC_MASK                       0xFFFFFFFFu
#define ENET_TCCR_TCC_SHIFT                      0
#define ENET_TCCR_TCC_WIDTH                      32
#define ENET_TCCR_TCC(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TCCR_TCC_SHIFT))&ENET_TCCR_TCC_MASK)

/*!
 * @}
 */ /* end of group ENET_Register_Masks */


/* ENET - Peripheral instance base addresses */
/** Peripheral ENET base address */
#define ENET_BASE                                (0x400C0000u)
/** Peripheral ENET base pointer */
#define ENET                                     ((ENET_Type *)ENET_BASE)
#define ENET_BASE_PTR                            (ENET)
/** Array initializer of ENET peripheral base addresses */
#define ENET_BASE_ADDRS                          { ENET_BASE }
/** Array initializer of ENET peripheral base pointers */
#define ENET_BASE_PTRS                           { ENET }

/* ----------------------------------------------------------------------------
   -- ENET - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Accessor_Macros ENET - Register accessor macros
 * @{
 */


/* ENET - Register instance definitions */
/* ENET */
#define ENET_EIR                                 ENET_EIR_REG(ENET)
#define ENET_EIMR                                ENET_EIMR_REG(ENET)
#define ENET_RDAR                                ENET_RDAR_REG(ENET)
#define ENET_TDAR                                ENET_TDAR_REG(ENET)
#define ENET_ECR                                 ENET_ECR_REG(ENET)
#define ENET_MMFR                                ENET_MMFR_REG(ENET)
#define ENET_MSCR                                ENET_MSCR_REG(ENET)
#define ENET_MIBC                                ENET_MIBC_REG(ENET)
#define ENET_RCR                                 ENET_RCR_REG(ENET)
#define ENET_TCR                                 ENET_TCR_REG(ENET)
#define ENET_PALR                                ENET_PALR_REG(ENET)
#define ENET_PAUR                                ENET_PAUR_REG(ENET)
#define ENET_OPD                                 ENET_OPD_REG(ENET)
#define ENET_IAUR                                ENET_IAUR_REG(ENET)
#define ENET_IALR                                ENET_IALR_REG(ENET)
#define ENET_GAUR                                ENET_GAUR_REG(ENET)
#define ENET_GALR                                ENET_GALR_REG(ENET)
#define ENET_TFWR                                ENET_TFWR_REG(ENET)
#define ENET_RDSR                                ENET_RDSR_REG(ENET)
#define ENET_TDSR                                ENET_TDSR_REG(ENET)
#define ENET_MRBR                                ENET_MRBR_REG(ENET)
#define ENET_RSFL                                ENET_RSFL_REG(ENET)
#define ENET_RSEM                                ENET_RSEM_REG(ENET)
#define ENET_RAEM                                ENET_RAEM_REG(ENET)
#define ENET_RAFL                                ENET_RAFL_REG(ENET)
#define ENET_TSEM                                ENET_TSEM_REG(ENET)
#define ENET_TAEM                                ENET_TAEM_REG(ENET)
#define ENET_TAFL                                ENET_TAFL_REG(ENET)
#define ENET_TIPG                                ENET_TIPG_REG(ENET)
#define ENET_FTRL                                ENET_FTRL_REG(ENET)
#define ENET_TACC                                ENET_TACC_REG(ENET)
#define ENET_RACC                                ENET_RACC_REG(ENET)
#define ENET_RMON_T_DROP                         ENET_RMON_T_DROP_REG(ENET)
#define ENET_RMON_T_PACKETS                      ENET_RMON_T_PACKETS_REG(ENET)
#define ENET_RMON_T_BC_PKT                       ENET_RMON_T_BC_PKT_REG(ENET)
#define ENET_RMON_T_MC_PKT                       ENET_RMON_T_MC_PKT_REG(ENET)
#define ENET_RMON_T_CRC_ALIGN                    ENET_RMON_T_CRC_ALIGN_REG(ENET)
#define ENET_RMON_T_UNDERSIZE                    ENET_RMON_T_UNDERSIZE_REG(ENET)
#define ENET_RMON_T_OVERSIZE                     ENET_RMON_T_OVERSIZE_REG(ENET)
#define ENET_RMON_T_FRAG                         ENET_RMON_T_FRAG_REG(ENET)
#define ENET_RMON_T_JAB                          ENET_RMON_T_JAB_REG(ENET)
#define ENET_RMON_T_COL                          ENET_RMON_T_COL_REG(ENET)
#define ENET_RMON_T_P64                          ENET_RMON_T_P64_REG(ENET)
#define ENET_RMON_T_P65TO127                     ENET_RMON_T_P65TO127_REG(ENET)
#define ENET_RMON_T_P128TO255                    ENET_RMON_T_P128TO255_REG(ENET)
#define ENET_RMON_T_P256TO511                    ENET_RMON_T_P256TO511_REG(ENET)
#define ENET_RMON_T_P512TO1023                   ENET_RMON_T_P512TO1023_REG(ENET)
#define ENET_RMON_T_P1024TO2047                  ENET_RMON_T_P1024TO2047_REG(ENET)
#define ENET_RMON_T_P_GTE2048                    ENET_RMON_T_P_GTE2048_REG(ENET)
#define ENET_RMON_T_OCTETS                       ENET_RMON_T_OCTETS_REG(ENET)
#define ENET_IEEE_T_DROP                         ENET_IEEE_T_DROP_REG(ENET)
#define ENET_IEEE_T_FRAME_OK                     ENET_IEEE_T_FRAME_OK_REG(ENET)
#define ENET_IEEE_T_1COL                         ENET_IEEE_T_1COL_REG(ENET)
#define ENET_IEEE_T_MCOL                         ENET_IEEE_T_MCOL_REG(ENET)
#define ENET_IEEE_T_DEF                          ENET_IEEE_T_DEF_REG(ENET)
#define ENET_IEEE_T_LCOL                         ENET_IEEE_T_LCOL_REG(ENET)
#define ENET_IEEE_T_EXCOL                        ENET_IEEE_T_EXCOL_REG(ENET)
#define ENET_IEEE_T_MACERR                       ENET_IEEE_T_MACERR_REG(ENET)
#define ENET_IEEE_T_CSERR                        ENET_IEEE_T_CSERR_REG(ENET)
#define ENET_IEEE_T_SQE                          ENET_IEEE_T_SQE_REG(ENET)
#define ENET_IEEE_T_FDXFC                        ENET_IEEE_T_FDXFC_REG(ENET)
#define ENET_IEEE_T_OCTETS_OK                    ENET_IEEE_T_OCTETS_OK_REG(ENET)
#define ENET_RMON_R_PACKETS                      ENET_RMON_R_PACKETS_REG(ENET)
#define ENET_RMON_R_BC_PKT                       ENET_RMON_R_BC_PKT_REG(ENET)
#define ENET_RMON_R_MC_PKT                       ENET_RMON_R_MC_PKT_REG(ENET)
#define ENET_RMON_R_CRC_ALIGN                    ENET_RMON_R_CRC_ALIGN_REG(ENET)
#define ENET_RMON_R_UNDERSIZE                    ENET_RMON_R_UNDERSIZE_REG(ENET)
#define ENET_RMON_R_OVERSIZE                     ENET_RMON_R_OVERSIZE_REG(ENET)
#define ENET_RMON_R_FRAG                         ENET_RMON_R_FRAG_REG(ENET)
#define ENET_RMON_R_JAB                          ENET_RMON_R_JAB_REG(ENET)
#define ENET_RMON_R_RESVD_0                      ENET_RMON_R_RESVD_0_REG(ENET)
#define ENET_RMON_R_P64                          ENET_RMON_R_P64_REG(ENET)
#define ENET_RMON_R_P65TO127                     ENET_RMON_R_P65TO127_REG(ENET)
#define ENET_RMON_R_P128TO255                    ENET_RMON_R_P128TO255_REG(ENET)
#define ENET_RMON_R_P256TO511                    ENET_RMON_R_P256TO511_REG(ENET)
#define ENET_RMON_R_P512TO1023                   ENET_RMON_R_P512TO1023_REG(ENET)
#define ENET_RMON_R_P1024TO2047                  ENET_RMON_R_P1024TO2047_REG(ENET)
#define ENET_RMON_R_P_GTE2048                    ENET_RMON_R_P_GTE2048_REG(ENET)
#define ENET_RMON_R_OCTETS                       ENET_RMON_R_OCTETS_REG(ENET)
#define ENET_IEEE_R_DROP                         ENET_IEEE_R_DROP_REG(ENET)
#define ENET_IEEE_R_FRAME_OK                     ENET_IEEE_R_FRAME_OK_REG(ENET)
#define ENET_IEEE_R_CRC                          ENET_IEEE_R_CRC_REG(ENET)
#define ENET_IEEE_R_ALIGN                        ENET_IEEE_R_ALIGN_REG(ENET)
#define ENET_IEEE_R_MACERR                       ENET_IEEE_R_MACERR_REG(ENET)
#define ENET_IEEE_R_FDXFC                        ENET_IEEE_R_FDXFC_REG(ENET)
#define ENET_IEEE_R_OCTETS_OK                    ENET_IEEE_R_OCTETS_OK_REG(ENET)
#define ENET_ATCR                                ENET_ATCR_REG(ENET)
#define ENET_ATVR                                ENET_ATVR_REG(ENET)
#define ENET_ATOFF                               ENET_ATOFF_REG(ENET)
#define ENET_ATPER                               ENET_ATPER_REG(ENET)
#define ENET_ATCOR                               ENET_ATCOR_REG(ENET)
#define ENET_ATINC                               ENET_ATINC_REG(ENET)
#define ENET_ATSTMP                              ENET_ATSTMP_REG(ENET)
#define ENET_TGSR                                ENET_TGSR_REG(ENET)
#define ENET_TCSR0                               ENET_TCSR_REG(ENET,0)
#define ENET_TCCR0                               ENET_TCCR_REG(ENET,0)
#define ENET_TCSR1                               ENET_TCSR_REG(ENET,1)
#define ENET_TCCR1                               ENET_TCCR_REG(ENET,1)
#define ENET_TCSR2                               ENET_TCSR_REG(ENET,2)
#define ENET_TCCR2                               ENET_TCCR_REG(ENET,2)
#define ENET_TCSR3                               ENET_TCSR_REG(ENET,3)
#define ENET_TCCR3                               ENET_TCCR_REG(ENET,3)

/* ENET - Register array accessors */
#define ENET_TCSR(index)                         ENET_TCSR_REG(ENET,index)
#define ENET_TCCR(index)                         ENET_TCCR_REG(ENET,index)

/*!
 * @}
 */ /* end of group ENET_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ENET_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EWM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Peripheral_Access_Layer EWM Peripheral Access Layer
 * @{
 */

/** EWM - Register Layout Typedef */
typedef struct {
  __IO uint8_t CTRL;                               /**< Control Register, offset: 0x0 */
  __O  uint8_t SERV;                               /**< Service Register, offset: 0x1 */
  __IO uint8_t CMPL;                               /**< Compare Low Register, offset: 0x2 */
  __IO uint8_t CMPH;                               /**< Compare High Register, offset: 0x3 */
  __IO uint8_t CLKCTRL;                            /**< Clock Control Register, offset: 0x4 */
  __IO uint8_t CLKPRESCALER;                       /**< Clock Prescaler Register, offset: 0x5 */
} EWM_Type, *EWM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- EWM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Accessor_Macros EWM - Register accessor macros
 * @{
 */


/* EWM - Register accessors */
#define EWM_CTRL_REG(base)                       ((base)->CTRL)
#define EWM_SERV_REG(base)                       ((base)->SERV)
#define EWM_CMPL_REG(base)                       ((base)->CMPL)
#define EWM_CMPH_REG(base)                       ((base)->CMPH)
#define EWM_CLKCTRL_REG(base)                    ((base)->CLKCTRL)
#define EWM_CLKPRESCALER_REG(base)               ((base)->CLKPRESCALER)

/*!
 * @}
 */ /* end of group EWM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- EWM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Masks EWM Register Masks
 * @{
 */

/* CTRL Bit Fields */
#define EWM_CTRL_EWMEN_MASK                      0x1u
#define EWM_CTRL_EWMEN_SHIFT                     0
#define EWM_CTRL_EWMEN_WIDTH                     1
#define EWM_CTRL_EWMEN(x)                        (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_EWMEN_SHIFT))&EWM_CTRL_EWMEN_MASK)
#define EWM_CTRL_ASSIN_MASK                      0x2u
#define EWM_CTRL_ASSIN_SHIFT                     1
#define EWM_CTRL_ASSIN_WIDTH                     1
#define EWM_CTRL_ASSIN(x)                        (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_ASSIN_SHIFT))&EWM_CTRL_ASSIN_MASK)
#define EWM_CTRL_INEN_MASK                       0x4u
#define EWM_CTRL_INEN_SHIFT                      2
#define EWM_CTRL_INEN_WIDTH                      1
#define EWM_CTRL_INEN(x)                         (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_INEN_SHIFT))&EWM_CTRL_INEN_MASK)
#define EWM_CTRL_INTEN_MASK                      0x8u
#define EWM_CTRL_INTEN_SHIFT                     3
#define EWM_CTRL_INTEN_WIDTH                     1
#define EWM_CTRL_INTEN(x)                        (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_INTEN_SHIFT))&EWM_CTRL_INTEN_MASK)
/* SERV Bit Fields */
#define EWM_SERV_SERVICE_MASK                    0xFFu
#define EWM_SERV_SERVICE_SHIFT                   0
#define EWM_SERV_SERVICE_WIDTH                   8
#define EWM_SERV_SERVICE(x)                      (((uint8_t)(((uint8_t)(x))<<EWM_SERV_SERVICE_SHIFT))&EWM_SERV_SERVICE_MASK)
/* CMPL Bit Fields */
#define EWM_CMPL_COMPAREL_MASK                   0xFFu
#define EWM_CMPL_COMPAREL_SHIFT                  0
#define EWM_CMPL_COMPAREL_WIDTH                  8
#define EWM_CMPL_COMPAREL(x)                     (((uint8_t)(((uint8_t)(x))<<EWM_CMPL_COMPAREL_SHIFT))&EWM_CMPL_COMPAREL_MASK)
/* CMPH Bit Fields */
#define EWM_CMPH_COMPAREH_MASK                   0xFFu
#define EWM_CMPH_COMPAREH_SHIFT                  0
#define EWM_CMPH_COMPAREH_WIDTH                  8
#define EWM_CMPH_COMPAREH(x)                     (((uint8_t)(((uint8_t)(x))<<EWM_CMPH_COMPAREH_SHIFT))&EWM_CMPH_COMPAREH_MASK)
/* CLKCTRL Bit Fields */
#define EWM_CLKCTRL_CLKSEL_MASK                  0x3u
#define EWM_CLKCTRL_CLKSEL_SHIFT                 0
#define EWM_CLKCTRL_CLKSEL_WIDTH                 2
#define EWM_CLKCTRL_CLKSEL(x)                    (((uint8_t)(((uint8_t)(x))<<EWM_CLKCTRL_CLKSEL_SHIFT))&EWM_CLKCTRL_CLKSEL_MASK)
/* CLKPRESCALER Bit Fields */
#define EWM_CLKPRESCALER_CLK_DIV_MASK            0xFFu
#define EWM_CLKPRESCALER_CLK_DIV_SHIFT           0
#define EWM_CLKPRESCALER_CLK_DIV_WIDTH           8
#define EWM_CLKPRESCALER_CLK_DIV(x)              (((uint8_t)(((uint8_t)(x))<<EWM_CLKPRESCALER_CLK_DIV_SHIFT))&EWM_CLKPRESCALER_CLK_DIV_MASK)

/*!
 * @}
 */ /* end of group EWM_Register_Masks */


/* EWM - Peripheral instance base addresses */
/** Peripheral EWM base address */
#define EWM_BASE                                 (0x40061000u)
/** Peripheral EWM base pointer */
#define EWM                                      ((EWM_Type *)EWM_BASE)
#define EWM_BASE_PTR                             (EWM)
/** Array initializer of EWM peripheral base addresses */
#define EWM_BASE_ADDRS                           { EWM_BASE }
/** Array initializer of EWM peripheral base pointers */
#define EWM_BASE_PTRS                            { EWM }

/* ----------------------------------------------------------------------------
   -- EWM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Accessor_Macros EWM - Register accessor macros
 * @{
 */


/* EWM - Register instance definitions */
/* EWM */
#define EWM_CTRL                                 EWM_CTRL_REG(EWM)
#define EWM_SERV                                 EWM_SERV_REG(EWM)
#define EWM_CMPL                                 EWM_CMPL_REG(EWM)
#define EWM_CMPH                                 EWM_CMPH_REG(EWM)
#define EWM_CLKCTRL                              EWM_CLKCTRL_REG(EWM)
#define EWM_CLKPRESCALER                         EWM_CLKPRESCALER_REG(EWM)

/*!
 * @}
 */ /* end of group EWM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group EWM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FB_Peripheral_Access_Layer FB Peripheral Access Layer
 * @{
 */

/** FB - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0xC */
    __IO uint32_t CSAR;                              /**< Chip Select Address Register, array offset: 0x0, array step: 0xC */
    __IO uint32_t CSMR;                              /**< Chip Select Mask Register, array offset: 0x4, array step: 0xC */
    __IO uint32_t CSCR;                              /**< Chip Select Control Register, array offset: 0x8, array step: 0xC */
  } CS[6];
       uint8_t RESERVED_0[24];
  __IO uint32_t CSPMCR;                            /**< Chip Select port Multiplexing Control Register, offset: 0x60 */
} FB_Type, *FB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FB_Register_Accessor_Macros FB - Register accessor macros
 * @{
 */


/* FB - Register accessors */
#define FB_CSAR_REG(base,index)                  ((base)->CS[index].CSAR)
#define FB_CSAR_COUNT                            6
#define FB_CSMR_REG(base,index)                  ((base)->CS[index].CSMR)
#define FB_CSMR_COUNT                            6
#define FB_CSCR_REG(base,index)                  ((base)->CS[index].CSCR)
#define FB_CSCR_COUNT                            6
#define FB_CSPMCR_REG(base)                      ((base)->CSPMCR)

/*!
 * @}
 */ /* end of group FB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FB_Register_Masks FB Register Masks
 * @{
 */

/* CSAR Bit Fields */
#define FB_CSAR_BA_MASK                          0xFFFF0000u
#define FB_CSAR_BA_SHIFT                         16
#define FB_CSAR_BA_WIDTH                         16
#define FB_CSAR_BA(x)                            (((uint32_t)(((uint32_t)(x))<<FB_CSAR_BA_SHIFT))&FB_CSAR_BA_MASK)
/* CSMR Bit Fields */
#define FB_CSMR_V_MASK                           0x1u
#define FB_CSMR_V_SHIFT                          0
#define FB_CSMR_V_WIDTH                          1
#define FB_CSMR_V(x)                             (((uint32_t)(((uint32_t)(x))<<FB_CSMR_V_SHIFT))&FB_CSMR_V_MASK)
#define FB_CSMR_WP_MASK                          0x100u
#define FB_CSMR_WP_SHIFT                         8
#define FB_CSMR_WP_WIDTH                         1
#define FB_CSMR_WP(x)                            (((uint32_t)(((uint32_t)(x))<<FB_CSMR_WP_SHIFT))&FB_CSMR_WP_MASK)
#define FB_CSMR_BAM_MASK                         0xFFFF0000u
#define FB_CSMR_BAM_SHIFT                        16
#define FB_CSMR_BAM_WIDTH                        16
#define FB_CSMR_BAM(x)                           (((uint32_t)(((uint32_t)(x))<<FB_CSMR_BAM_SHIFT))&FB_CSMR_BAM_MASK)
/* CSCR Bit Fields */
#define FB_CSCR_BSTW_MASK                        0x8u
#define FB_CSCR_BSTW_SHIFT                       3
#define FB_CSCR_BSTW_WIDTH                       1
#define FB_CSCR_BSTW(x)                          (((uint32_t)(((uint32_t)(x))<<FB_CSCR_BSTW_SHIFT))&FB_CSCR_BSTW_MASK)
#define FB_CSCR_BSTR_MASK                        0x10u
#define FB_CSCR_BSTR_SHIFT                       4
#define FB_CSCR_BSTR_WIDTH                       1
#define FB_CSCR_BSTR(x)                          (((uint32_t)(((uint32_t)(x))<<FB_CSCR_BSTR_SHIFT))&FB_CSCR_BSTR_MASK)
#define FB_CSCR_BEM_MASK                         0x20u
#define FB_CSCR_BEM_SHIFT                        5
#define FB_CSCR_BEM_WIDTH                        1
#define FB_CSCR_BEM(x)                           (((uint32_t)(((uint32_t)(x))<<FB_CSCR_BEM_SHIFT))&FB_CSCR_BEM_MASK)
#define FB_CSCR_PS_MASK                          0xC0u
#define FB_CSCR_PS_SHIFT                         6
#define FB_CSCR_PS_WIDTH                         2
#define FB_CSCR_PS(x)                            (((uint32_t)(((uint32_t)(x))<<FB_CSCR_PS_SHIFT))&FB_CSCR_PS_MASK)
#define FB_CSCR_AA_MASK                          0x100u
#define FB_CSCR_AA_SHIFT                         8
#define FB_CSCR_AA_WIDTH                         1
#define FB_CSCR_AA(x)                            (((uint32_t)(((uint32_t)(x))<<FB_CSCR_AA_SHIFT))&FB_CSCR_AA_MASK)
#define FB_CSCR_BLS_MASK                         0x200u
#define FB_CSCR_BLS_SHIFT                        9
#define FB_CSCR_BLS_WIDTH                        1
#define FB_CSCR_BLS(x)                           (((uint32_t)(((uint32_t)(x))<<FB_CSCR_BLS_SHIFT))&FB_CSCR_BLS_MASK)
#define FB_CSCR_WS_MASK                          0xFC00u
#define FB_CSCR_WS_SHIFT                         10
#define FB_CSCR_WS_WIDTH                         6
#define FB_CSCR_WS(x)                            (((uint32_t)(((uint32_t)(x))<<FB_CSCR_WS_SHIFT))&FB_CSCR_WS_MASK)
#define FB_CSCR_WRAH_MASK                        0x30000u
#define FB_CSCR_WRAH_SHIFT                       16
#define FB_CSCR_WRAH_WIDTH                       2
#define FB_CSCR_WRAH(x)                          (((uint32_t)(((uint32_t)(x))<<FB_CSCR_WRAH_SHIFT))&FB_CSCR_WRAH_MASK)
#define FB_CSCR_RDAH_MASK                        0xC0000u
#define FB_CSCR_RDAH_SHIFT                       18
#define FB_CSCR_RDAH_WIDTH                       2
#define FB_CSCR_RDAH(x)                          (((uint32_t)(((uint32_t)(x))<<FB_CSCR_RDAH_SHIFT))&FB_CSCR_RDAH_MASK)
#define FB_CSCR_ASET_MASK                        0x300000u
#define FB_CSCR_ASET_SHIFT                       20
#define FB_CSCR_ASET_WIDTH                       2
#define FB_CSCR_ASET(x)                          (((uint32_t)(((uint32_t)(x))<<FB_CSCR_ASET_SHIFT))&FB_CSCR_ASET_MASK)
#define FB_CSCR_EXTS_MASK                        0x400000u
#define FB_CSCR_EXTS_SHIFT                       22
#define FB_CSCR_EXTS_WIDTH                       1
#define FB_CSCR_EXTS(x)                          (((uint32_t)(((uint32_t)(x))<<FB_CSCR_EXTS_SHIFT))&FB_CSCR_EXTS_MASK)
#define FB_CSCR_SWSEN_MASK                       0x800000u
#define FB_CSCR_SWSEN_SHIFT                      23
#define FB_CSCR_SWSEN_WIDTH                      1
#define FB_CSCR_SWSEN(x)                         (((uint32_t)(((uint32_t)(x))<<FB_CSCR_SWSEN_SHIFT))&FB_CSCR_SWSEN_MASK)
#define FB_CSCR_SWS_MASK                         0xFC000000u
#define FB_CSCR_SWS_SHIFT                        26
#define FB_CSCR_SWS_WIDTH                        6
#define FB_CSCR_SWS(x)                           (((uint32_t)(((uint32_t)(x))<<FB_CSCR_SWS_SHIFT))&FB_CSCR_SWS_MASK)
/* CSPMCR Bit Fields */
#define FB_CSPMCR_GROUP5_MASK                    0xF000u
#define FB_CSPMCR_GROUP5_SHIFT                   12
#define FB_CSPMCR_GROUP5_WIDTH                   4
#define FB_CSPMCR_GROUP5(x)                      (((uint32_t)(((uint32_t)(x))<<FB_CSPMCR_GROUP5_SHIFT))&FB_CSPMCR_GROUP5_MASK)
#define FB_CSPMCR_GROUP4_MASK                    0xF0000u
#define FB_CSPMCR_GROUP4_SHIFT                   16
#define FB_CSPMCR_GROUP4_WIDTH                   4
#define FB_CSPMCR_GROUP4(x)                      (((uint32_t)(((uint32_t)(x))<<FB_CSPMCR_GROUP4_SHIFT))&FB_CSPMCR_GROUP4_MASK)
#define FB_CSPMCR_GROUP3_MASK                    0xF00000u
#define FB_CSPMCR_GROUP3_SHIFT                   20
#define FB_CSPMCR_GROUP3_WIDTH                   4
#define FB_CSPMCR_GROUP3(x)                      (((uint32_t)(((uint32_t)(x))<<FB_CSPMCR_GROUP3_SHIFT))&FB_CSPMCR_GROUP3_MASK)
#define FB_CSPMCR_GROUP2_MASK                    0xF000000u
#define FB_CSPMCR_GROUP2_SHIFT                   24
#define FB_CSPMCR_GROUP2_WIDTH                   4
#define FB_CSPMCR_GROUP2(x)                      (((uint32_t)(((uint32_t)(x))<<FB_CSPMCR_GROUP2_SHIFT))&FB_CSPMCR_GROUP2_MASK)
#define FB_CSPMCR_GROUP1_MASK                    0xF0000000u
#define FB_CSPMCR_GROUP1_SHIFT                   28
#define FB_CSPMCR_GROUP1_WIDTH                   4
#define FB_CSPMCR_GROUP1(x)                      (((uint32_t)(((uint32_t)(x))<<FB_CSPMCR_GROUP1_SHIFT))&FB_CSPMCR_GROUP1_MASK)

/*!
 * @}
 */ /* end of group FB_Register_Masks */


/* FB - Peripheral instance base addresses */
/** Peripheral FB base address */
#define FB_BASE                                  (0x4000C000u)
/** Peripheral FB base pointer */
#define FB                                       ((FB_Type *)FB_BASE)
#define FB_BASE_PTR                              (FB)
/** Array initializer of FB peripheral base addresses */
#define FB_BASE_ADDRS                            { FB_BASE }
/** Array initializer of FB peripheral base pointers */
#define FB_BASE_PTRS                             { FB }

/* ----------------------------------------------------------------------------
   -- FB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FB_Register_Accessor_Macros FB - Register accessor macros
 * @{
 */


/* FB - Register instance definitions */
/* FB */
#define FB_CSAR0                                 FB_CSAR_REG(FB,0)
#define FB_CSMR0                                 FB_CSMR_REG(FB,0)
#define FB_CSCR0                                 FB_CSCR_REG(FB,0)
#define FB_CSAR1                                 FB_CSAR_REG(FB,1)
#define FB_CSMR1                                 FB_CSMR_REG(FB,1)
#define FB_CSCR1                                 FB_CSCR_REG(FB,1)
#define FB_CSAR2                                 FB_CSAR_REG(FB,2)
#define FB_CSMR2                                 FB_CSMR_REG(FB,2)
#define FB_CSCR2                                 FB_CSCR_REG(FB,2)
#define FB_CSAR3                                 FB_CSAR_REG(FB,3)
#define FB_CSMR3                                 FB_CSMR_REG(FB,3)
#define FB_CSCR3                                 FB_CSCR_REG(FB,3)
#define FB_CSAR4                                 FB_CSAR_REG(FB,4)
#define FB_CSMR4                                 FB_CSMR_REG(FB,4)
#define FB_CSCR4                                 FB_CSCR_REG(FB,4)
#define FB_CSAR5                                 FB_CSAR_REG(FB,5)
#define FB_CSMR5                                 FB_CSMR_REG(FB,5)
#define FB_CSCR5                                 FB_CSCR_REG(FB,5)
#define FB_CSPMCR                                FB_CSPMCR_REG(FB)

/* FB - Register array accessors */
#define FB_CSAR(index)                           FB_CSAR_REG(FB,index)
#define FB_CSMR(index)                           FB_CSMR_REG(FB,index)
#define FB_CSCR(index)                           FB_CSCR_REG(FB,index)

/*!
 * @}
 */ /* end of group FB_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMC_Peripheral_Access_Layer FMC Peripheral Access Layer
 * @{
 */

/** FMC - Register Layout Typedef */
typedef struct {
  __IO uint32_t PFAPR;                             /**< Flash Access Protection Register, offset: 0x0 */
  __IO uint32_t PFB0CR;                            /**< Flash Bank 0 Control Register, offset: 0x4 */
  __I  uint32_t PFB1CR;                            /**< Flash Bank 1 Control Register, offset: 0x8 */
} FMC_Type, *FMC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMC_Register_Accessor_Macros FMC - Register accessor macros
 * @{
 */


/* FMC - Register accessors */
#define FMC_PFAPR_REG(base)                      ((base)->PFAPR)
#define FMC_PFB0CR_REG(base)                     ((base)->PFB0CR)
#define FMC_PFB1CR_REG(base)                     ((base)->PFB1CR)

/*!
 * @}
 */ /* end of group FMC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMC_Register_Masks FMC Register Masks
 * @{
 */

/* PFAPR Bit Fields */
#define FMC_PFAPR_M0AP_MASK                      0x3u
#define FMC_PFAPR_M0AP_SHIFT                     0
#define FMC_PFAPR_M0AP_WIDTH                     2
#define FMC_PFAPR_M0AP(x)                        (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M0AP_SHIFT))&FMC_PFAPR_M0AP_MASK)
#define FMC_PFAPR_M1AP_MASK                      0xCu
#define FMC_PFAPR_M1AP_SHIFT                     2
#define FMC_PFAPR_M1AP_WIDTH                     2
#define FMC_PFAPR_M1AP(x)                        (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M1AP_SHIFT))&FMC_PFAPR_M1AP_MASK)
#define FMC_PFAPR_M2AP_MASK                      0x30u
#define FMC_PFAPR_M2AP_SHIFT                     4
#define FMC_PFAPR_M2AP_WIDTH                     2
#define FMC_PFAPR_M2AP(x)                        (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M2AP_SHIFT))&FMC_PFAPR_M2AP_MASK)
#define FMC_PFAPR_M3AP_MASK                      0xC0u
#define FMC_PFAPR_M3AP_SHIFT                     6
#define FMC_PFAPR_M3AP_WIDTH                     2
#define FMC_PFAPR_M3AP(x)                        (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M3AP_SHIFT))&FMC_PFAPR_M3AP_MASK)
#define FMC_PFAPR_M0PFD_MASK                     0x10000u
#define FMC_PFAPR_M0PFD_SHIFT                    16
#define FMC_PFAPR_M0PFD_WIDTH                    1
#define FMC_PFAPR_M0PFD(x)                       (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M0PFD_SHIFT))&FMC_PFAPR_M0PFD_MASK)
#define FMC_PFAPR_M1PFD_MASK                     0x20000u
#define FMC_PFAPR_M1PFD_SHIFT                    17
#define FMC_PFAPR_M1PFD_WIDTH                    1
#define FMC_PFAPR_M1PFD(x)                       (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M1PFD_SHIFT))&FMC_PFAPR_M1PFD_MASK)
#define FMC_PFAPR_M2PFD_MASK                     0x40000u
#define FMC_PFAPR_M2PFD_SHIFT                    18
#define FMC_PFAPR_M2PFD_WIDTH                    1
#define FMC_PFAPR_M2PFD(x)                       (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M2PFD_SHIFT))&FMC_PFAPR_M2PFD_MASK)
#define FMC_PFAPR_M3PFD_MASK                     0x80000u
#define FMC_PFAPR_M3PFD_SHIFT                    19
#define FMC_PFAPR_M3PFD_WIDTH                    1
#define FMC_PFAPR_M3PFD(x)                       (((uint32_t)(((uint32_t)(x))<<FMC_PFAPR_M3PFD_SHIFT))&FMC_PFAPR_M3PFD_MASK)
/* PFB0CR Bit Fields */
#define FMC_PFB0CR_B0IPE_MASK                    0x2u
#define FMC_PFB0CR_B0IPE_SHIFT                   1
#define FMC_PFB0CR_B0IPE_WIDTH                   1
#define FMC_PFB0CR_B0IPE(x)                      (((uint32_t)(((uint32_t)(x))<<FMC_PFB0CR_B0IPE_SHIFT))&FMC_PFB0CR_B0IPE_MASK)
#define FMC_PFB0CR_B0DPE_MASK                    0x4u
#define FMC_PFB0CR_B0DPE_SHIFT                   2
#define FMC_PFB0CR_B0DPE_WIDTH                   1
#define FMC_PFB0CR_B0DPE(x)                      (((uint32_t)(((uint32_t)(x))<<FMC_PFB0CR_B0DPE_SHIFT))&FMC_PFB0CR_B0DPE_MASK)
#define FMC_PFB0CR_B0MW_MASK                     0x60000u
#define FMC_PFB0CR_B0MW_SHIFT                    17
#define FMC_PFB0CR_B0MW_WIDTH                    2
#define FMC_PFB0CR_B0MW(x)                       (((uint32_t)(((uint32_t)(x))<<FMC_PFB0CR_B0MW_SHIFT))&FMC_PFB0CR_B0MW_MASK)
#define FMC_PFB0CR_B0RWSC_MASK                   0xF0000000u
#define FMC_PFB0CR_B0RWSC_SHIFT                  28
#define FMC_PFB0CR_B0RWSC_WIDTH                  4
#define FMC_PFB0CR_B0RWSC(x)                     (((uint32_t)(((uint32_t)(x))<<FMC_PFB0CR_B0RWSC_SHIFT))&FMC_PFB0CR_B0RWSC_MASK)

/*!
 * @}
 */ /* end of group FMC_Register_Masks */


/* FMC - Peripheral instance base addresses */
/** Peripheral FMC base address */
#define FMC_BASE                                 (0x4001F000u)
/** Peripheral FMC base pointer */
#define FMC                                      ((FMC_Type *)FMC_BASE)
#define FMC_BASE_PTR                             (FMC)
/** Array initializer of FMC peripheral base addresses */
#define FMC_BASE_ADDRS                           { FMC_BASE }
/** Array initializer of FMC peripheral base pointers */
#define FMC_BASE_PTRS                            { FMC }

/* ----------------------------------------------------------------------------
   -- FMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMC_Register_Accessor_Macros FMC - Register accessor macros
 * @{
 */


/* FMC - Register instance definitions */
/* FMC */
#define FMC_PFAPR                                FMC_PFAPR_REG(FMC)
#define FMC_PFB0CR                               FMC_PFB0CR_REG(FMC)
#define FMC_PFB1CR                               FMC_PFB1CR_REG(FMC)

/*!
 * @}
 */ /* end of group FMC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FTFE Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFE_Peripheral_Access_Layer FTFE Peripheral Access Layer
 * @{
 */

/** FTFE - Register Layout Typedef */
typedef struct {
  __IO uint8_t FSTAT;                              /**< Flash Status Register, offset: 0x0 */
  __IO uint8_t FCNFG;                              /**< Flash Configuration Register, offset: 0x1 */
  __I  uint8_t FSEC;                               /**< Flash Security Register, offset: 0x2 */
  __I  uint8_t FOPT;                               /**< Flash Option Register, offset: 0x3 */
  __IO uint8_t FCCOB3;                             /**< Flash Common Command Object Registers, offset: 0x4 */
  __IO uint8_t FCCOB2;                             /**< Flash Common Command Object Registers, offset: 0x5 */
  __IO uint8_t FCCOB1;                             /**< Flash Common Command Object Registers, offset: 0x6 */
  __IO uint8_t FCCOB0;                             /**< Flash Common Command Object Registers, offset: 0x7 */
  __IO uint8_t FCCOB7;                             /**< Flash Common Command Object Registers, offset: 0x8 */
  __IO uint8_t FCCOB6;                             /**< Flash Common Command Object Registers, offset: 0x9 */
  __IO uint8_t FCCOB5;                             /**< Flash Common Command Object Registers, offset: 0xA */
  __IO uint8_t FCCOB4;                             /**< Flash Common Command Object Registers, offset: 0xB */
  __IO uint8_t FCCOBB;                             /**< Flash Common Command Object Registers, offset: 0xC */
  __IO uint8_t FCCOBA;                             /**< Flash Common Command Object Registers, offset: 0xD */
  __IO uint8_t FCCOB9;                             /**< Flash Common Command Object Registers, offset: 0xE */
  __IO uint8_t FCCOB8;                             /**< Flash Common Command Object Registers, offset: 0xF */
  __IO uint8_t FPROT3;                             /**< Program Flash Protection Registers, offset: 0x10 */
  __IO uint8_t FPROT2;                             /**< Program Flash Protection Registers, offset: 0x11 */
  __IO uint8_t FPROT1;                             /**< Program Flash Protection Registers, offset: 0x12 */
  __IO uint8_t FPROT0;                             /**< Program Flash Protection Registers, offset: 0x13 */
} FTFE_Type, *FTFE_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FTFE - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFE_Register_Accessor_Macros FTFE - Register accessor macros
 * @{
 */


/* FTFE - Register accessors */
#define FTFE_FSTAT_REG(base)                     ((base)->FSTAT)
#define FTFE_FCNFG_REG(base)                     ((base)->FCNFG)
#define FTFE_FSEC_REG(base)                      ((base)->FSEC)
#define FTFE_FOPT_REG(base)                      ((base)->FOPT)
#define FTFE_FCCOB3_REG(base)                    ((base)->FCCOB3)
#define FTFE_FCCOB2_REG(base)                    ((base)->FCCOB2)
#define FTFE_FCCOB1_REG(base)                    ((base)->FCCOB1)
#define FTFE_FCCOB0_REG(base)                    ((base)->FCCOB0)
#define FTFE_FCCOB7_REG(base)                    ((base)->FCCOB7)
#define FTFE_FCCOB6_REG(base)                    ((base)->FCCOB6)
#define FTFE_FCCOB5_REG(base)                    ((base)->FCCOB5)
#define FTFE_FCCOB4_REG(base)                    ((base)->FCCOB4)
#define FTFE_FCCOBB_REG(base)                    ((base)->FCCOBB)
#define FTFE_FCCOBA_REG(base)                    ((base)->FCCOBA)
#define FTFE_FCCOB9_REG(base)                    ((base)->FCCOB9)
#define FTFE_FCCOB8_REG(base)                    ((base)->FCCOB8)
#define FTFE_FPROT3_REG(base)                    ((base)->FPROT3)
#define FTFE_FPROT2_REG(base)                    ((base)->FPROT2)
#define FTFE_FPROT1_REG(base)                    ((base)->FPROT1)
#define FTFE_FPROT0_REG(base)                    ((base)->FPROT0)

/*!
 * @}
 */ /* end of group FTFE_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FTFE Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFE_Register_Masks FTFE Register Masks
 * @{
 */

/* FSTAT Bit Fields */
#define FTFE_FSTAT_MGSTAT0_MASK                  0x1u
#define FTFE_FSTAT_MGSTAT0_SHIFT                 0
#define FTFE_FSTAT_MGSTAT0_WIDTH                 1
#define FTFE_FSTAT_MGSTAT0(x)                    (((uint8_t)(((uint8_t)(x))<<FTFE_FSTAT_MGSTAT0_SHIFT))&FTFE_FSTAT_MGSTAT0_MASK)
#define FTFE_FSTAT_FPVIOL_MASK                   0x10u
#define FTFE_FSTAT_FPVIOL_SHIFT                  4
#define FTFE_FSTAT_FPVIOL_WIDTH                  1
#define FTFE_FSTAT_FPVIOL(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FSTAT_FPVIOL_SHIFT))&FTFE_FSTAT_FPVIOL_MASK)
#define FTFE_FSTAT_ACCERR_MASK                   0x20u
#define FTFE_FSTAT_ACCERR_SHIFT                  5
#define FTFE_FSTAT_ACCERR_WIDTH                  1
#define FTFE_FSTAT_ACCERR(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FSTAT_ACCERR_SHIFT))&FTFE_FSTAT_ACCERR_MASK)
#define FTFE_FSTAT_RDCOLERR_MASK                 0x40u
#define FTFE_FSTAT_RDCOLERR_SHIFT                6
#define FTFE_FSTAT_RDCOLERR_WIDTH                1
#define FTFE_FSTAT_RDCOLERR(x)                   (((uint8_t)(((uint8_t)(x))<<FTFE_FSTAT_RDCOLERR_SHIFT))&FTFE_FSTAT_RDCOLERR_MASK)
#define FTFE_FSTAT_CCIF_MASK                     0x80u
#define FTFE_FSTAT_CCIF_SHIFT                    7
#define FTFE_FSTAT_CCIF_WIDTH                    1
#define FTFE_FSTAT_CCIF(x)                       (((uint8_t)(((uint8_t)(x))<<FTFE_FSTAT_CCIF_SHIFT))&FTFE_FSTAT_CCIF_MASK)
/* FCNFG Bit Fields */
#define FTFE_FCNFG_EEERDY_MASK                   0x1u
#define FTFE_FCNFG_EEERDY_SHIFT                  0
#define FTFE_FCNFG_EEERDY_WIDTH                  1
#define FTFE_FCNFG_EEERDY(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCNFG_EEERDY_SHIFT))&FTFE_FCNFG_EEERDY_MASK)
#define FTFE_FCNFG_RAMRDY_MASK                   0x2u
#define FTFE_FCNFG_RAMRDY_SHIFT                  1
#define FTFE_FCNFG_RAMRDY_WIDTH                  1
#define FTFE_FCNFG_RAMRDY(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCNFG_RAMRDY_SHIFT))&FTFE_FCNFG_RAMRDY_MASK)
#define FTFE_FCNFG_PFLSH_MASK                    0x4u
#define FTFE_FCNFG_PFLSH_SHIFT                   2
#define FTFE_FCNFG_PFLSH_WIDTH                   1
#define FTFE_FCNFG_PFLSH(x)                      (((uint8_t)(((uint8_t)(x))<<FTFE_FCNFG_PFLSH_SHIFT))&FTFE_FCNFG_PFLSH_MASK)
#define FTFE_FCNFG_ERSSUSP_MASK                  0x10u
#define FTFE_FCNFG_ERSSUSP_SHIFT                 4
#define FTFE_FCNFG_ERSSUSP_WIDTH                 1
#define FTFE_FCNFG_ERSSUSP(x)                    (((uint8_t)(((uint8_t)(x))<<FTFE_FCNFG_ERSSUSP_SHIFT))&FTFE_FCNFG_ERSSUSP_MASK)
#define FTFE_FCNFG_ERSAREQ_MASK                  0x20u
#define FTFE_FCNFG_ERSAREQ_SHIFT                 5
#define FTFE_FCNFG_ERSAREQ_WIDTH                 1
#define FTFE_FCNFG_ERSAREQ(x)                    (((uint8_t)(((uint8_t)(x))<<FTFE_FCNFG_ERSAREQ_SHIFT))&FTFE_FCNFG_ERSAREQ_MASK)
#define FTFE_FCNFG_RDCOLLIE_MASK                 0x40u
#define FTFE_FCNFG_RDCOLLIE_SHIFT                6
#define FTFE_FCNFG_RDCOLLIE_WIDTH                1
#define FTFE_FCNFG_RDCOLLIE(x)                   (((uint8_t)(((uint8_t)(x))<<FTFE_FCNFG_RDCOLLIE_SHIFT))&FTFE_FCNFG_RDCOLLIE_MASK)
#define FTFE_FCNFG_CCIE_MASK                     0x80u
#define FTFE_FCNFG_CCIE_SHIFT                    7
#define FTFE_FCNFG_CCIE_WIDTH                    1
#define FTFE_FCNFG_CCIE(x)                       (((uint8_t)(((uint8_t)(x))<<FTFE_FCNFG_CCIE_SHIFT))&FTFE_FCNFG_CCIE_MASK)
/* FSEC Bit Fields */
#define FTFE_FSEC_SEC_MASK                       0x3u
#define FTFE_FSEC_SEC_SHIFT                      0
#define FTFE_FSEC_SEC_WIDTH                      2
#define FTFE_FSEC_SEC(x)                         (((uint8_t)(((uint8_t)(x))<<FTFE_FSEC_SEC_SHIFT))&FTFE_FSEC_SEC_MASK)
#define FTFE_FSEC_FSLACC_MASK                    0xCu
#define FTFE_FSEC_FSLACC_SHIFT                   2
#define FTFE_FSEC_FSLACC_WIDTH                   2
#define FTFE_FSEC_FSLACC(x)                      (((uint8_t)(((uint8_t)(x))<<FTFE_FSEC_FSLACC_SHIFT))&FTFE_FSEC_FSLACC_MASK)
#define FTFE_FSEC_MEEN_MASK                      0x30u
#define FTFE_FSEC_MEEN_SHIFT                     4
#define FTFE_FSEC_MEEN_WIDTH                     2
#define FTFE_FSEC_MEEN(x)                        (((uint8_t)(((uint8_t)(x))<<FTFE_FSEC_MEEN_SHIFT))&FTFE_FSEC_MEEN_MASK)
#define FTFE_FSEC_KEYEN_MASK                     0xC0u
#define FTFE_FSEC_KEYEN_SHIFT                    6
#define FTFE_FSEC_KEYEN_WIDTH                    2
#define FTFE_FSEC_KEYEN(x)                       (((uint8_t)(((uint8_t)(x))<<FTFE_FSEC_KEYEN_SHIFT))&FTFE_FSEC_KEYEN_MASK)
/* FOPT Bit Fields */
#define FTFE_FOPT_OPT_MASK                       0xFFu
#define FTFE_FOPT_OPT_SHIFT                      0
#define FTFE_FOPT_OPT_WIDTH                      8
#define FTFE_FOPT_OPT(x)                         (((uint8_t)(((uint8_t)(x))<<FTFE_FOPT_OPT_SHIFT))&FTFE_FOPT_OPT_MASK)
/* FCCOB3 Bit Fields */
#define FTFE_FCCOB3_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB3_CCOBn_SHIFT                  0
#define FTFE_FCCOB3_CCOBn_WIDTH                  8
#define FTFE_FCCOB3_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB3_CCOBn_SHIFT))&FTFE_FCCOB3_CCOBn_MASK)
/* FCCOB2 Bit Fields */
#define FTFE_FCCOB2_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB2_CCOBn_SHIFT                  0
#define FTFE_FCCOB2_CCOBn_WIDTH                  8
#define FTFE_FCCOB2_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB2_CCOBn_SHIFT))&FTFE_FCCOB2_CCOBn_MASK)
/* FCCOB1 Bit Fields */
#define FTFE_FCCOB1_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB1_CCOBn_SHIFT                  0
#define FTFE_FCCOB1_CCOBn_WIDTH                  8
#define FTFE_FCCOB1_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB1_CCOBn_SHIFT))&FTFE_FCCOB1_CCOBn_MASK)
/* FCCOB0 Bit Fields */
#define FTFE_FCCOB0_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB0_CCOBn_SHIFT                  0
#define FTFE_FCCOB0_CCOBn_WIDTH                  8
#define FTFE_FCCOB0_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB0_CCOBn_SHIFT))&FTFE_FCCOB0_CCOBn_MASK)
/* FCCOB7 Bit Fields */
#define FTFE_FCCOB7_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB7_CCOBn_SHIFT                  0
#define FTFE_FCCOB7_CCOBn_WIDTH                  8
#define FTFE_FCCOB7_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB7_CCOBn_SHIFT))&FTFE_FCCOB7_CCOBn_MASK)
/* FCCOB6 Bit Fields */
#define FTFE_FCCOB6_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB6_CCOBn_SHIFT                  0
#define FTFE_FCCOB6_CCOBn_WIDTH                  8
#define FTFE_FCCOB6_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB6_CCOBn_SHIFT))&FTFE_FCCOB6_CCOBn_MASK)
/* FCCOB5 Bit Fields */
#define FTFE_FCCOB5_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB5_CCOBn_SHIFT                  0
#define FTFE_FCCOB5_CCOBn_WIDTH                  8
#define FTFE_FCCOB5_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB5_CCOBn_SHIFT))&FTFE_FCCOB5_CCOBn_MASK)
/* FCCOB4 Bit Fields */
#define FTFE_FCCOB4_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB4_CCOBn_SHIFT                  0
#define FTFE_FCCOB4_CCOBn_WIDTH                  8
#define FTFE_FCCOB4_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB4_CCOBn_SHIFT))&FTFE_FCCOB4_CCOBn_MASK)
/* FCCOBB Bit Fields */
#define FTFE_FCCOBB_CCOBn_MASK                   0xFFu
#define FTFE_FCCOBB_CCOBn_SHIFT                  0
#define FTFE_FCCOBB_CCOBn_WIDTH                  8
#define FTFE_FCCOBB_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOBB_CCOBn_SHIFT))&FTFE_FCCOBB_CCOBn_MASK)
/* FCCOBA Bit Fields */
#define FTFE_FCCOBA_CCOBn_MASK                   0xFFu
#define FTFE_FCCOBA_CCOBn_SHIFT                  0
#define FTFE_FCCOBA_CCOBn_WIDTH                  8
#define FTFE_FCCOBA_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOBA_CCOBn_SHIFT))&FTFE_FCCOBA_CCOBn_MASK)
/* FCCOB9 Bit Fields */
#define FTFE_FCCOB9_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB9_CCOBn_SHIFT                  0
#define FTFE_FCCOB9_CCOBn_WIDTH                  8
#define FTFE_FCCOB9_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB9_CCOBn_SHIFT))&FTFE_FCCOB9_CCOBn_MASK)
/* FCCOB8 Bit Fields */
#define FTFE_FCCOB8_CCOBn_MASK                   0xFFu
#define FTFE_FCCOB8_CCOBn_SHIFT                  0
#define FTFE_FCCOB8_CCOBn_WIDTH                  8
#define FTFE_FCCOB8_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFE_FCCOB8_CCOBn_SHIFT))&FTFE_FCCOB8_CCOBn_MASK)
/* FPROT3 Bit Fields */
#define FTFE_FPROT3_PROT_MASK                    0xFFu
#define FTFE_FPROT3_PROT_SHIFT                   0
#define FTFE_FPROT3_PROT_WIDTH                   8
#define FTFE_FPROT3_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFE_FPROT3_PROT_SHIFT))&FTFE_FPROT3_PROT_MASK)
/* FPROT2 Bit Fields */
#define FTFE_FPROT2_PROT_MASK                    0xFFu
#define FTFE_FPROT2_PROT_SHIFT                   0
#define FTFE_FPROT2_PROT_WIDTH                   8
#define FTFE_FPROT2_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFE_FPROT2_PROT_SHIFT))&FTFE_FPROT2_PROT_MASK)
/* FPROT1 Bit Fields */
#define FTFE_FPROT1_PROT_MASK                    0xFFu
#define FTFE_FPROT1_PROT_SHIFT                   0
#define FTFE_FPROT1_PROT_WIDTH                   8
#define FTFE_FPROT1_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFE_FPROT1_PROT_SHIFT))&FTFE_FPROT1_PROT_MASK)
/* FPROT0 Bit Fields */
#define FTFE_FPROT0_PROT_MASK                    0xFFu
#define FTFE_FPROT0_PROT_SHIFT                   0
#define FTFE_FPROT0_PROT_WIDTH                   8
#define FTFE_FPROT0_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFE_FPROT0_PROT_SHIFT))&FTFE_FPROT0_PROT_MASK)

/*!
 * @}
 */ /* end of group FTFE_Register_Masks */


/* FTFE - Peripheral instance base addresses */
/** Peripheral FTFE base address */
#define FTFE_BASE                                (0x40020000u)
/** Peripheral FTFE base pointer */
#define FTFE                                     ((FTFE_Type *)FTFE_BASE)
#define FTFE_BASE_PTR                            (FTFE)
/** Array initializer of FTFE peripheral base addresses */
#define FTFE_BASE_ADDRS                          { FTFE_BASE }
/** Array initializer of FTFE peripheral base pointers */
#define FTFE_BASE_PTRS                           { FTFE }

/* ----------------------------------------------------------------------------
   -- FTFE - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFE_Register_Accessor_Macros FTFE - Register accessor macros
 * @{
 */


/* FTFE - Register instance definitions */
/* FTFE */
#define FTFE_FSTAT                               FTFE_FSTAT_REG(FTFE)
#define FTFE_FCNFG                               FTFE_FCNFG_REG(FTFE)
#define FTFE_FSEC                                FTFE_FSEC_REG(FTFE)
#define FTFE_FOPT                                FTFE_FOPT_REG(FTFE)
#define FTFE_FCCOB3                              FTFE_FCCOB3_REG(FTFE)
#define FTFE_FCCOB2                              FTFE_FCCOB2_REG(FTFE)
#define FTFE_FCCOB1                              FTFE_FCCOB1_REG(FTFE)
#define FTFE_FCCOB0                              FTFE_FCCOB0_REG(FTFE)
#define FTFE_FCCOB7                              FTFE_FCCOB7_REG(FTFE)
#define FTFE_FCCOB6                              FTFE_FCCOB6_REG(FTFE)
#define FTFE_FCCOB5                              FTFE_FCCOB5_REG(FTFE)
#define FTFE_FCCOB4                              FTFE_FCCOB4_REG(FTFE)
#define FTFE_FCCOBB                              FTFE_FCCOBB_REG(FTFE)
#define FTFE_FCCOBA                              FTFE_FCCOBA_REG(FTFE)
#define FTFE_FCCOB9                              FTFE_FCCOB9_REG(FTFE)
#define FTFE_FCCOB8                              FTFE_FCCOB8_REG(FTFE)
#define FTFE_FPROT3                              FTFE_FPROT3_REG(FTFE)
#define FTFE_FPROT2                              FTFE_FPROT2_REG(FTFE)
#define FTFE_FPROT1                              FTFE_FPROT1_REG(FTFE)
#define FTFE_FPROT0                              FTFE_FPROT0_REG(FTFE)

/*!
 * @}
 */ /* end of group FTFE_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FTFE_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FTM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTM_Peripheral_Access_Layer FTM Peripheral Access Layer
 * @{
 */

/** FTM - Register Layout Typedef */
typedef struct {
  __IO uint32_t SC;                                /**< Status And Control, offset: 0x0 */
  __IO uint32_t CNT;                               /**< Counter, offset: 0x4 */
  __IO uint32_t MOD;                               /**< Modulo, offset: 0x8 */
  struct {                                         /* offset: 0xC, array step: 0x8 */
    __IO uint32_t CnSC;                              /**< Channel (n) Status And Control, array offset: 0xC, array step: 0x8 */
    __IO uint32_t CnV;                               /**< Channel (n) Value, array offset: 0x10, array step: 0x8 */
  } CONTROLS[8];
  __IO uint32_t CNTIN;                             /**< Counter Initial Value, offset: 0x4C */
  __IO uint32_t STATUS;                            /**< Capture And Compare Status, offset: 0x50 */
  __IO uint32_t MODE;                              /**< Features Mode Selection, offset: 0x54 */
  __IO uint32_t SYNC;                              /**< Synchronization, offset: 0x58 */
  __IO uint32_t OUTINIT;                           /**< Initial State For Channels Output, offset: 0x5C */
  __IO uint32_t OUTMASK;                           /**< Output Mask, offset: 0x60 */
  __IO uint32_t COMBINE;                           /**< Function For Linked Channels, offset: 0x64 */
  __IO uint32_t DEADTIME;                          /**< Deadtime Insertion Control, offset: 0x68 */
  __IO uint32_t EXTTRIG;                           /**< FTM External Trigger, offset: 0x6C */
  __IO uint32_t POL;                               /**< Channels Polarity, offset: 0x70 */
  __IO uint32_t FMS;                               /**< Fault Mode Status, offset: 0x74 */
  __IO uint32_t FILTER;                            /**< Input Capture Filter Control, offset: 0x78 */
  __IO uint32_t FLTCTRL;                           /**< Fault Control, offset: 0x7C */
  __IO uint32_t QDCTRL;                            /**< Quadrature Decoder Control And Status, offset: 0x80 */
  __IO uint32_t CONF;                              /**< Configuration, offset: 0x84 */
  __IO uint32_t FLTPOL;                            /**< FTM Fault Input Polarity, offset: 0x88 */
  __IO uint32_t SYNCONF;                           /**< Synchronization Configuration, offset: 0x8C */
  __IO uint32_t INVCTRL;                           /**< FTM Inverting Control, offset: 0x90 */
  __IO uint32_t SWOCTRL;                           /**< FTM Software Output Control, offset: 0x94 */
  __IO uint32_t PWMLOAD;                           /**< FTM PWM Load, offset: 0x98 */
} FTM_Type, *FTM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FTM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTM_Register_Accessor_Macros FTM - Register accessor macros
 * @{
 */


/* FTM - Register accessors */
#define FTM_SC_REG(base)                         ((base)->SC)
#define FTM_CNT_REG(base)                        ((base)->CNT)
#define FTM_MOD_REG(base)                        ((base)->MOD)
#define FTM_CnSC_REG(base,index)                 ((base)->CONTROLS[index].CnSC)
#define FTM_CnSC_COUNT                           8
#define FTM_CnV_REG(base,index)                  ((base)->CONTROLS[index].CnV)
#define FTM_CnV_COUNT                            8
#define FTM_CNTIN_REG(base)                      ((base)->CNTIN)
#define FTM_STATUS_REG(base)                     ((base)->STATUS)
#define FTM_MODE_REG(base)                       ((base)->MODE)
#define FTM_SYNC_REG(base)                       ((base)->SYNC)
#define FTM_OUTINIT_REG(base)                    ((base)->OUTINIT)
#define FTM_OUTMASK_REG(base)                    ((base)->OUTMASK)
#define FTM_COMBINE_REG(base)                    ((base)->COMBINE)
#define FTM_DEADTIME_REG(base)                   ((base)->DEADTIME)
#define FTM_EXTTRIG_REG(base)                    ((base)->EXTTRIG)
#define FTM_POL_REG(base)                        ((base)->POL)
#define FTM_FMS_REG(base)                        ((base)->FMS)
#define FTM_FILTER_REG(base)                     ((base)->FILTER)
#define FTM_FLTCTRL_REG(base)                    ((base)->FLTCTRL)
#define FTM_QDCTRL_REG(base)                     ((base)->QDCTRL)
#define FTM_CONF_REG(base)                       ((base)->CONF)
#define FTM_FLTPOL_REG(base)                     ((base)->FLTPOL)
#define FTM_SYNCONF_REG(base)                    ((base)->SYNCONF)
#define FTM_INVCTRL_REG(base)                    ((base)->INVCTRL)
#define FTM_SWOCTRL_REG(base)                    ((base)->SWOCTRL)
#define FTM_PWMLOAD_REG(base)                    ((base)->PWMLOAD)

/*!
 * @}
 */ /* end of group FTM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FTM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTM_Register_Masks FTM Register Masks
 * @{
 */

/* SC Bit Fields */
#define FTM_SC_PS_MASK                           0x7u
#define FTM_SC_PS_SHIFT                          0
#define FTM_SC_PS_WIDTH                          3
#define FTM_SC_PS(x)                             (((uint32_t)(((uint32_t)(x))<<FTM_SC_PS_SHIFT))&FTM_SC_PS_MASK)
#define FTM_SC_CLKS_MASK                         0x18u
#define FTM_SC_CLKS_SHIFT                        3
#define FTM_SC_CLKS_WIDTH                        2
#define FTM_SC_CLKS(x)                           (((uint32_t)(((uint32_t)(x))<<FTM_SC_CLKS_SHIFT))&FTM_SC_CLKS_MASK)
#define FTM_SC_CPWMS_MASK                        0x20u
#define FTM_SC_CPWMS_SHIFT                       5
#define FTM_SC_CPWMS_WIDTH                       1
#define FTM_SC_CPWMS(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_SC_CPWMS_SHIFT))&FTM_SC_CPWMS_MASK)
#define FTM_SC_TOIE_MASK                         0x40u
#define FTM_SC_TOIE_SHIFT                        6
#define FTM_SC_TOIE_WIDTH                        1
#define FTM_SC_TOIE(x)                           (((uint32_t)(((uint32_t)(x))<<FTM_SC_TOIE_SHIFT))&FTM_SC_TOIE_MASK)
#define FTM_SC_TOF_MASK                          0x80u
#define FTM_SC_TOF_SHIFT                         7
#define FTM_SC_TOF_WIDTH                         1
#define FTM_SC_TOF(x)                            (((uint32_t)(((uint32_t)(x))<<FTM_SC_TOF_SHIFT))&FTM_SC_TOF_MASK)
/* CNT Bit Fields */
#define FTM_CNT_COUNT_MASK                       0xFFFFu
#define FTM_CNT_COUNT_SHIFT                      0
#define FTM_CNT_COUNT_WIDTH                      16
#define FTM_CNT_COUNT(x)                         (((uint32_t)(((uint32_t)(x))<<FTM_CNT_COUNT_SHIFT))&FTM_CNT_COUNT_MASK)
/* MOD Bit Fields */
#define FTM_MOD_MOD_MASK                         0xFFFFu
#define FTM_MOD_MOD_SHIFT                        0
#define FTM_MOD_MOD_WIDTH                        16
#define FTM_MOD_MOD(x)                           (((uint32_t)(((uint32_t)(x))<<FTM_MOD_MOD_SHIFT))&FTM_MOD_MOD_MASK)
/* CnSC Bit Fields */
#define FTM_CnSC_DMA_MASK                        0x1u
#define FTM_CnSC_DMA_SHIFT                       0
#define FTM_CnSC_DMA_WIDTH                       1
#define FTM_CnSC_DMA(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_DMA_SHIFT))&FTM_CnSC_DMA_MASK)
#define FTM_CnSC_ICRST_MASK                      0x2u
#define FTM_CnSC_ICRST_SHIFT                     1
#define FTM_CnSC_ICRST_WIDTH                     1
#define FTM_CnSC_ICRST(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_ICRST_SHIFT))&FTM_CnSC_ICRST_MASK)
#define FTM_CnSC_ELSA_MASK                       0x4u
#define FTM_CnSC_ELSA_SHIFT                      2
#define FTM_CnSC_ELSA_WIDTH                      1
#define FTM_CnSC_ELSA(x)                         (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_ELSA_SHIFT))&FTM_CnSC_ELSA_MASK)
#define FTM_CnSC_ELSB_MASK                       0x8u
#define FTM_CnSC_ELSB_SHIFT                      3
#define FTM_CnSC_ELSB_WIDTH                      1
#define FTM_CnSC_ELSB(x)                         (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_ELSB_SHIFT))&FTM_CnSC_ELSB_MASK)
#define FTM_CnSC_MSA_MASK                        0x10u
#define FTM_CnSC_MSA_SHIFT                       4
#define FTM_CnSC_MSA_WIDTH                       1
#define FTM_CnSC_MSA(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_MSA_SHIFT))&FTM_CnSC_MSA_MASK)
#define FTM_CnSC_MSB_MASK                        0x20u
#define FTM_CnSC_MSB_SHIFT                       5
#define FTM_CnSC_MSB_WIDTH                       1
#define FTM_CnSC_MSB(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_MSB_SHIFT))&FTM_CnSC_MSB_MASK)
#define FTM_CnSC_CHIE_MASK                       0x40u
#define FTM_CnSC_CHIE_SHIFT                      6
#define FTM_CnSC_CHIE_WIDTH                      1
#define FTM_CnSC_CHIE(x)                         (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_CHIE_SHIFT))&FTM_CnSC_CHIE_MASK)
#define FTM_CnSC_CHF_MASK                        0x80u
#define FTM_CnSC_CHF_SHIFT                       7
#define FTM_CnSC_CHF_WIDTH                       1
#define FTM_CnSC_CHF(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_CnSC_CHF_SHIFT))&FTM_CnSC_CHF_MASK)
/* CnV Bit Fields */
#define FTM_CnV_VAL_MASK                         0xFFFFu
#define FTM_CnV_VAL_SHIFT                        0
#define FTM_CnV_VAL_WIDTH                        16
#define FTM_CnV_VAL(x)                           (((uint32_t)(((uint32_t)(x))<<FTM_CnV_VAL_SHIFT))&FTM_CnV_VAL_MASK)
/* CNTIN Bit Fields */
#define FTM_CNTIN_INIT_MASK                      0xFFFFu
#define FTM_CNTIN_INIT_SHIFT                     0
#define FTM_CNTIN_INIT_WIDTH                     16
#define FTM_CNTIN_INIT(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_CNTIN_INIT_SHIFT))&FTM_CNTIN_INIT_MASK)
/* STATUS Bit Fields */
#define FTM_STATUS_CH0F_MASK                     0x1u
#define FTM_STATUS_CH0F_SHIFT                    0
#define FTM_STATUS_CH0F_WIDTH                    1
#define FTM_STATUS_CH0F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH0F_SHIFT))&FTM_STATUS_CH0F_MASK)
#define FTM_STATUS_CH1F_MASK                     0x2u
#define FTM_STATUS_CH1F_SHIFT                    1
#define FTM_STATUS_CH1F_WIDTH                    1
#define FTM_STATUS_CH1F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH1F_SHIFT))&FTM_STATUS_CH1F_MASK)
#define FTM_STATUS_CH2F_MASK                     0x4u
#define FTM_STATUS_CH2F_SHIFT                    2
#define FTM_STATUS_CH2F_WIDTH                    1
#define FTM_STATUS_CH2F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH2F_SHIFT))&FTM_STATUS_CH2F_MASK)
#define FTM_STATUS_CH3F_MASK                     0x8u
#define FTM_STATUS_CH3F_SHIFT                    3
#define FTM_STATUS_CH3F_WIDTH                    1
#define FTM_STATUS_CH3F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH3F_SHIFT))&FTM_STATUS_CH3F_MASK)
#define FTM_STATUS_CH4F_MASK                     0x10u
#define FTM_STATUS_CH4F_SHIFT                    4
#define FTM_STATUS_CH4F_WIDTH                    1
#define FTM_STATUS_CH4F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH4F_SHIFT))&FTM_STATUS_CH4F_MASK)
#define FTM_STATUS_CH5F_MASK                     0x20u
#define FTM_STATUS_CH5F_SHIFT                    5
#define FTM_STATUS_CH5F_WIDTH                    1
#define FTM_STATUS_CH5F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH5F_SHIFT))&FTM_STATUS_CH5F_MASK)
#define FTM_STATUS_CH6F_MASK                     0x40u
#define FTM_STATUS_CH6F_SHIFT                    6
#define FTM_STATUS_CH6F_WIDTH                    1
#define FTM_STATUS_CH6F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH6F_SHIFT))&FTM_STATUS_CH6F_MASK)
#define FTM_STATUS_CH7F_MASK                     0x80u
#define FTM_STATUS_CH7F_SHIFT                    7
#define FTM_STATUS_CH7F_WIDTH                    1
#define FTM_STATUS_CH7F(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_STATUS_CH7F_SHIFT))&FTM_STATUS_CH7F_MASK)
/* MODE Bit Fields */
#define FTM_MODE_FTMEN_MASK                      0x1u
#define FTM_MODE_FTMEN_SHIFT                     0
#define FTM_MODE_FTMEN_WIDTH                     1
#define FTM_MODE_FTMEN(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_MODE_FTMEN_SHIFT))&FTM_MODE_FTMEN_MASK)
#define FTM_MODE_INIT_MASK                       0x2u
#define FTM_MODE_INIT_SHIFT                      1
#define FTM_MODE_INIT_WIDTH                      1
#define FTM_MODE_INIT(x)                         (((uint32_t)(((uint32_t)(x))<<FTM_MODE_INIT_SHIFT))&FTM_MODE_INIT_MASK)
#define FTM_MODE_WPDIS_MASK                      0x4u
#define FTM_MODE_WPDIS_SHIFT                     2
#define FTM_MODE_WPDIS_WIDTH                     1
#define FTM_MODE_WPDIS(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_MODE_WPDIS_SHIFT))&FTM_MODE_WPDIS_MASK)
#define FTM_MODE_PWMSYNC_MASK                    0x8u
#define FTM_MODE_PWMSYNC_SHIFT                   3
#define FTM_MODE_PWMSYNC_WIDTH                   1
#define FTM_MODE_PWMSYNC(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_MODE_PWMSYNC_SHIFT))&FTM_MODE_PWMSYNC_MASK)
#define FTM_MODE_CAPTEST_MASK                    0x10u
#define FTM_MODE_CAPTEST_SHIFT                   4
#define FTM_MODE_CAPTEST_WIDTH                   1
#define FTM_MODE_CAPTEST(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_MODE_CAPTEST_SHIFT))&FTM_MODE_CAPTEST_MASK)
#define FTM_MODE_FAULTM_MASK                     0x60u
#define FTM_MODE_FAULTM_SHIFT                    5
#define FTM_MODE_FAULTM_WIDTH                    2
#define FTM_MODE_FAULTM(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_MODE_FAULTM_SHIFT))&FTM_MODE_FAULTM_MASK)
#define FTM_MODE_FAULTIE_MASK                    0x80u
#define FTM_MODE_FAULTIE_SHIFT                   7
#define FTM_MODE_FAULTIE_WIDTH                   1
#define FTM_MODE_FAULTIE(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_MODE_FAULTIE_SHIFT))&FTM_MODE_FAULTIE_MASK)
/* SYNC Bit Fields */
#define FTM_SYNC_CNTMIN_MASK                     0x1u
#define FTM_SYNC_CNTMIN_SHIFT                    0
#define FTM_SYNC_CNTMIN_WIDTH                    1
#define FTM_SYNC_CNTMIN(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_CNTMIN_SHIFT))&FTM_SYNC_CNTMIN_MASK)
#define FTM_SYNC_CNTMAX_MASK                     0x2u
#define FTM_SYNC_CNTMAX_SHIFT                    1
#define FTM_SYNC_CNTMAX_WIDTH                    1
#define FTM_SYNC_CNTMAX(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_CNTMAX_SHIFT))&FTM_SYNC_CNTMAX_MASK)
#define FTM_SYNC_REINIT_MASK                     0x4u
#define FTM_SYNC_REINIT_SHIFT                    2
#define FTM_SYNC_REINIT_WIDTH                    1
#define FTM_SYNC_REINIT(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_REINIT_SHIFT))&FTM_SYNC_REINIT_MASK)
#define FTM_SYNC_SYNCHOM_MASK                    0x8u
#define FTM_SYNC_SYNCHOM_SHIFT                   3
#define FTM_SYNC_SYNCHOM_WIDTH                   1
#define FTM_SYNC_SYNCHOM(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_SYNCHOM_SHIFT))&FTM_SYNC_SYNCHOM_MASK)
#define FTM_SYNC_TRIG0_MASK                      0x10u
#define FTM_SYNC_TRIG0_SHIFT                     4
#define FTM_SYNC_TRIG0_WIDTH                     1
#define FTM_SYNC_TRIG0(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_TRIG0_SHIFT))&FTM_SYNC_TRIG0_MASK)
#define FTM_SYNC_TRIG1_MASK                      0x20u
#define FTM_SYNC_TRIG1_SHIFT                     5
#define FTM_SYNC_TRIG1_WIDTH                     1
#define FTM_SYNC_TRIG1(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_TRIG1_SHIFT))&FTM_SYNC_TRIG1_MASK)
#define FTM_SYNC_TRIG2_MASK                      0x40u
#define FTM_SYNC_TRIG2_SHIFT                     6
#define FTM_SYNC_TRIG2_WIDTH                     1
#define FTM_SYNC_TRIG2(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_TRIG2_SHIFT))&FTM_SYNC_TRIG2_MASK)
#define FTM_SYNC_SWSYNC_MASK                     0x80u
#define FTM_SYNC_SWSYNC_SHIFT                    7
#define FTM_SYNC_SWSYNC_WIDTH                    1
#define FTM_SYNC_SWSYNC(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_SYNC_SWSYNC_SHIFT))&FTM_SYNC_SWSYNC_MASK)
/* OUTINIT Bit Fields */
#define FTM_OUTINIT_CH0OI_MASK                   0x1u
#define FTM_OUTINIT_CH0OI_SHIFT                  0
#define FTM_OUTINIT_CH0OI_WIDTH                  1
#define FTM_OUTINIT_CH0OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH0OI_SHIFT))&FTM_OUTINIT_CH0OI_MASK)
#define FTM_OUTINIT_CH1OI_MASK                   0x2u
#define FTM_OUTINIT_CH1OI_SHIFT                  1
#define FTM_OUTINIT_CH1OI_WIDTH                  1
#define FTM_OUTINIT_CH1OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH1OI_SHIFT))&FTM_OUTINIT_CH1OI_MASK)
#define FTM_OUTINIT_CH2OI_MASK                   0x4u
#define FTM_OUTINIT_CH2OI_SHIFT                  2
#define FTM_OUTINIT_CH2OI_WIDTH                  1
#define FTM_OUTINIT_CH2OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH2OI_SHIFT))&FTM_OUTINIT_CH2OI_MASK)
#define FTM_OUTINIT_CH3OI_MASK                   0x8u
#define FTM_OUTINIT_CH3OI_SHIFT                  3
#define FTM_OUTINIT_CH3OI_WIDTH                  1
#define FTM_OUTINIT_CH3OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH3OI_SHIFT))&FTM_OUTINIT_CH3OI_MASK)
#define FTM_OUTINIT_CH4OI_MASK                   0x10u
#define FTM_OUTINIT_CH4OI_SHIFT                  4
#define FTM_OUTINIT_CH4OI_WIDTH                  1
#define FTM_OUTINIT_CH4OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH4OI_SHIFT))&FTM_OUTINIT_CH4OI_MASK)
#define FTM_OUTINIT_CH5OI_MASK                   0x20u
#define FTM_OUTINIT_CH5OI_SHIFT                  5
#define FTM_OUTINIT_CH5OI_WIDTH                  1
#define FTM_OUTINIT_CH5OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH5OI_SHIFT))&FTM_OUTINIT_CH5OI_MASK)
#define FTM_OUTINIT_CH6OI_MASK                   0x40u
#define FTM_OUTINIT_CH6OI_SHIFT                  6
#define FTM_OUTINIT_CH6OI_WIDTH                  1
#define FTM_OUTINIT_CH6OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH6OI_SHIFT))&FTM_OUTINIT_CH6OI_MASK)
#define FTM_OUTINIT_CH7OI_MASK                   0x80u
#define FTM_OUTINIT_CH7OI_SHIFT                  7
#define FTM_OUTINIT_CH7OI_WIDTH                  1
#define FTM_OUTINIT_CH7OI(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTINIT_CH7OI_SHIFT))&FTM_OUTINIT_CH7OI_MASK)
/* OUTMASK Bit Fields */
#define FTM_OUTMASK_CH0OM_MASK                   0x1u
#define FTM_OUTMASK_CH0OM_SHIFT                  0
#define FTM_OUTMASK_CH0OM_WIDTH                  1
#define FTM_OUTMASK_CH0OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH0OM_SHIFT))&FTM_OUTMASK_CH0OM_MASK)
#define FTM_OUTMASK_CH1OM_MASK                   0x2u
#define FTM_OUTMASK_CH1OM_SHIFT                  1
#define FTM_OUTMASK_CH1OM_WIDTH                  1
#define FTM_OUTMASK_CH1OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH1OM_SHIFT))&FTM_OUTMASK_CH1OM_MASK)
#define FTM_OUTMASK_CH2OM_MASK                   0x4u
#define FTM_OUTMASK_CH2OM_SHIFT                  2
#define FTM_OUTMASK_CH2OM_WIDTH                  1
#define FTM_OUTMASK_CH2OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH2OM_SHIFT))&FTM_OUTMASK_CH2OM_MASK)
#define FTM_OUTMASK_CH3OM_MASK                   0x8u
#define FTM_OUTMASK_CH3OM_SHIFT                  3
#define FTM_OUTMASK_CH3OM_WIDTH                  1
#define FTM_OUTMASK_CH3OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH3OM_SHIFT))&FTM_OUTMASK_CH3OM_MASK)
#define FTM_OUTMASK_CH4OM_MASK                   0x10u
#define FTM_OUTMASK_CH4OM_SHIFT                  4
#define FTM_OUTMASK_CH4OM_WIDTH                  1
#define FTM_OUTMASK_CH4OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH4OM_SHIFT))&FTM_OUTMASK_CH4OM_MASK)
#define FTM_OUTMASK_CH5OM_MASK                   0x20u
#define FTM_OUTMASK_CH5OM_SHIFT                  5
#define FTM_OUTMASK_CH5OM_WIDTH                  1
#define FTM_OUTMASK_CH5OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH5OM_SHIFT))&FTM_OUTMASK_CH5OM_MASK)
#define FTM_OUTMASK_CH6OM_MASK                   0x40u
#define FTM_OUTMASK_CH6OM_SHIFT                  6
#define FTM_OUTMASK_CH6OM_WIDTH                  1
#define FTM_OUTMASK_CH6OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH6OM_SHIFT))&FTM_OUTMASK_CH6OM_MASK)
#define FTM_OUTMASK_CH7OM_MASK                   0x80u
#define FTM_OUTMASK_CH7OM_SHIFT                  7
#define FTM_OUTMASK_CH7OM_WIDTH                  1
#define FTM_OUTMASK_CH7OM(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_OUTMASK_CH7OM_SHIFT))&FTM_OUTMASK_CH7OM_MASK)
/* COMBINE Bit Fields */
#define FTM_COMBINE_COMBINE0_MASK                0x1u
#define FTM_COMBINE_COMBINE0_SHIFT               0
#define FTM_COMBINE_COMBINE0_WIDTH               1
#define FTM_COMBINE_COMBINE0(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMBINE0_SHIFT))&FTM_COMBINE_COMBINE0_MASK)
#define FTM_COMBINE_COMP0_MASK                   0x2u
#define FTM_COMBINE_COMP0_SHIFT                  1
#define FTM_COMBINE_COMP0_WIDTH                  1
#define FTM_COMBINE_COMP0(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMP0_SHIFT))&FTM_COMBINE_COMP0_MASK)
#define FTM_COMBINE_DECAPEN0_MASK                0x4u
#define FTM_COMBINE_DECAPEN0_SHIFT               2
#define FTM_COMBINE_DECAPEN0_WIDTH               1
#define FTM_COMBINE_DECAPEN0(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAPEN0_SHIFT))&FTM_COMBINE_DECAPEN0_MASK)
#define FTM_COMBINE_DECAP0_MASK                  0x8u
#define FTM_COMBINE_DECAP0_SHIFT                 3
#define FTM_COMBINE_DECAP0_WIDTH                 1
#define FTM_COMBINE_DECAP0(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAP0_SHIFT))&FTM_COMBINE_DECAP0_MASK)
#define FTM_COMBINE_DTEN0_MASK                   0x10u
#define FTM_COMBINE_DTEN0_SHIFT                  4
#define FTM_COMBINE_DTEN0_WIDTH                  1
#define FTM_COMBINE_DTEN0(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DTEN0_SHIFT))&FTM_COMBINE_DTEN0_MASK)
#define FTM_COMBINE_SYNCEN0_MASK                 0x20u
#define FTM_COMBINE_SYNCEN0_SHIFT                5
#define FTM_COMBINE_SYNCEN0_WIDTH                1
#define FTM_COMBINE_SYNCEN0(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_SYNCEN0_SHIFT))&FTM_COMBINE_SYNCEN0_MASK)
#define FTM_COMBINE_FAULTEN0_MASK                0x40u
#define FTM_COMBINE_FAULTEN0_SHIFT               6
#define FTM_COMBINE_FAULTEN0_WIDTH               1
#define FTM_COMBINE_FAULTEN0(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_FAULTEN0_SHIFT))&FTM_COMBINE_FAULTEN0_MASK)
#define FTM_COMBINE_COMBINE1_MASK                0x100u
#define FTM_COMBINE_COMBINE1_SHIFT               8
#define FTM_COMBINE_COMBINE1_WIDTH               1
#define FTM_COMBINE_COMBINE1(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMBINE1_SHIFT))&FTM_COMBINE_COMBINE1_MASK)
#define FTM_COMBINE_COMP1_MASK                   0x200u
#define FTM_COMBINE_COMP1_SHIFT                  9
#define FTM_COMBINE_COMP1_WIDTH                  1
#define FTM_COMBINE_COMP1(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMP1_SHIFT))&FTM_COMBINE_COMP1_MASK)
#define FTM_COMBINE_DECAPEN1_MASK                0x400u
#define FTM_COMBINE_DECAPEN1_SHIFT               10
#define FTM_COMBINE_DECAPEN1_WIDTH               1
#define FTM_COMBINE_DECAPEN1(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAPEN1_SHIFT))&FTM_COMBINE_DECAPEN1_MASK)
#define FTM_COMBINE_DECAP1_MASK                  0x800u
#define FTM_COMBINE_DECAP1_SHIFT                 11
#define FTM_COMBINE_DECAP1_WIDTH                 1
#define FTM_COMBINE_DECAP1(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAP1_SHIFT))&FTM_COMBINE_DECAP1_MASK)
#define FTM_COMBINE_DTEN1_MASK                   0x1000u
#define FTM_COMBINE_DTEN1_SHIFT                  12
#define FTM_COMBINE_DTEN1_WIDTH                  1
#define FTM_COMBINE_DTEN1(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DTEN1_SHIFT))&FTM_COMBINE_DTEN1_MASK)
#define FTM_COMBINE_SYNCEN1_MASK                 0x2000u
#define FTM_COMBINE_SYNCEN1_SHIFT                13
#define FTM_COMBINE_SYNCEN1_WIDTH                1
#define FTM_COMBINE_SYNCEN1(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_SYNCEN1_SHIFT))&FTM_COMBINE_SYNCEN1_MASK)
#define FTM_COMBINE_FAULTEN1_MASK                0x4000u
#define FTM_COMBINE_FAULTEN1_SHIFT               14
#define FTM_COMBINE_FAULTEN1_WIDTH               1
#define FTM_COMBINE_FAULTEN1(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_FAULTEN1_SHIFT))&FTM_COMBINE_FAULTEN1_MASK)
#define FTM_COMBINE_COMBINE2_MASK                0x10000u
#define FTM_COMBINE_COMBINE2_SHIFT               16
#define FTM_COMBINE_COMBINE2_WIDTH               1
#define FTM_COMBINE_COMBINE2(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMBINE2_SHIFT))&FTM_COMBINE_COMBINE2_MASK)
#define FTM_COMBINE_COMP2_MASK                   0x20000u
#define FTM_COMBINE_COMP2_SHIFT                  17
#define FTM_COMBINE_COMP2_WIDTH                  1
#define FTM_COMBINE_COMP2(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMP2_SHIFT))&FTM_COMBINE_COMP2_MASK)
#define FTM_COMBINE_DECAPEN2_MASK                0x40000u
#define FTM_COMBINE_DECAPEN2_SHIFT               18
#define FTM_COMBINE_DECAPEN2_WIDTH               1
#define FTM_COMBINE_DECAPEN2(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAPEN2_SHIFT))&FTM_COMBINE_DECAPEN2_MASK)
#define FTM_COMBINE_DECAP2_MASK                  0x80000u
#define FTM_COMBINE_DECAP2_SHIFT                 19
#define FTM_COMBINE_DECAP2_WIDTH                 1
#define FTM_COMBINE_DECAP2(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAP2_SHIFT))&FTM_COMBINE_DECAP2_MASK)
#define FTM_COMBINE_DTEN2_MASK                   0x100000u
#define FTM_COMBINE_DTEN2_SHIFT                  20
#define FTM_COMBINE_DTEN2_WIDTH                  1
#define FTM_COMBINE_DTEN2(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DTEN2_SHIFT))&FTM_COMBINE_DTEN2_MASK)
#define FTM_COMBINE_SYNCEN2_MASK                 0x200000u
#define FTM_COMBINE_SYNCEN2_SHIFT                21
#define FTM_COMBINE_SYNCEN2_WIDTH                1
#define FTM_COMBINE_SYNCEN2(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_SYNCEN2_SHIFT))&FTM_COMBINE_SYNCEN2_MASK)
#define FTM_COMBINE_FAULTEN2_MASK                0x400000u
#define FTM_COMBINE_FAULTEN2_SHIFT               22
#define FTM_COMBINE_FAULTEN2_WIDTH               1
#define FTM_COMBINE_FAULTEN2(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_FAULTEN2_SHIFT))&FTM_COMBINE_FAULTEN2_MASK)
#define FTM_COMBINE_COMBINE3_MASK                0x1000000u
#define FTM_COMBINE_COMBINE3_SHIFT               24
#define FTM_COMBINE_COMBINE3_WIDTH               1
#define FTM_COMBINE_COMBINE3(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMBINE3_SHIFT))&FTM_COMBINE_COMBINE3_MASK)
#define FTM_COMBINE_COMP3_MASK                   0x2000000u
#define FTM_COMBINE_COMP3_SHIFT                  25
#define FTM_COMBINE_COMP3_WIDTH                  1
#define FTM_COMBINE_COMP3(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_COMP3_SHIFT))&FTM_COMBINE_COMP3_MASK)
#define FTM_COMBINE_DECAPEN3_MASK                0x4000000u
#define FTM_COMBINE_DECAPEN3_SHIFT               26
#define FTM_COMBINE_DECAPEN3_WIDTH               1
#define FTM_COMBINE_DECAPEN3(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAPEN3_SHIFT))&FTM_COMBINE_DECAPEN3_MASK)
#define FTM_COMBINE_DECAP3_MASK                  0x8000000u
#define FTM_COMBINE_DECAP3_SHIFT                 27
#define FTM_COMBINE_DECAP3_WIDTH                 1
#define FTM_COMBINE_DECAP3(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DECAP3_SHIFT))&FTM_COMBINE_DECAP3_MASK)
#define FTM_COMBINE_DTEN3_MASK                   0x10000000u
#define FTM_COMBINE_DTEN3_SHIFT                  28
#define FTM_COMBINE_DTEN3_WIDTH                  1
#define FTM_COMBINE_DTEN3(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_DTEN3_SHIFT))&FTM_COMBINE_DTEN3_MASK)
#define FTM_COMBINE_SYNCEN3_MASK                 0x20000000u
#define FTM_COMBINE_SYNCEN3_SHIFT                29
#define FTM_COMBINE_SYNCEN3_WIDTH                1
#define FTM_COMBINE_SYNCEN3(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_SYNCEN3_SHIFT))&FTM_COMBINE_SYNCEN3_MASK)
#define FTM_COMBINE_FAULTEN3_MASK                0x40000000u
#define FTM_COMBINE_FAULTEN3_SHIFT               30
#define FTM_COMBINE_FAULTEN3_WIDTH               1
#define FTM_COMBINE_FAULTEN3(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_COMBINE_FAULTEN3_SHIFT))&FTM_COMBINE_FAULTEN3_MASK)
/* DEADTIME Bit Fields */
#define FTM_DEADTIME_DTVAL_MASK                  0x3Fu
#define FTM_DEADTIME_DTVAL_SHIFT                 0
#define FTM_DEADTIME_DTVAL_WIDTH                 6
#define FTM_DEADTIME_DTVAL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_DEADTIME_DTVAL_SHIFT))&FTM_DEADTIME_DTVAL_MASK)
#define FTM_DEADTIME_DTPS_MASK                   0xC0u
#define FTM_DEADTIME_DTPS_SHIFT                  6
#define FTM_DEADTIME_DTPS_WIDTH                  2
#define FTM_DEADTIME_DTPS(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_DEADTIME_DTPS_SHIFT))&FTM_DEADTIME_DTPS_MASK)
/* EXTTRIG Bit Fields */
#define FTM_EXTTRIG_CH2TRIG_MASK                 0x1u
#define FTM_EXTTRIG_CH2TRIG_SHIFT                0
#define FTM_EXTTRIG_CH2TRIG_WIDTH                1
#define FTM_EXTTRIG_CH2TRIG(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_CH2TRIG_SHIFT))&FTM_EXTTRIG_CH2TRIG_MASK)
#define FTM_EXTTRIG_CH3TRIG_MASK                 0x2u
#define FTM_EXTTRIG_CH3TRIG_SHIFT                1
#define FTM_EXTTRIG_CH3TRIG_WIDTH                1
#define FTM_EXTTRIG_CH3TRIG(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_CH3TRIG_SHIFT))&FTM_EXTTRIG_CH3TRIG_MASK)
#define FTM_EXTTRIG_CH4TRIG_MASK                 0x4u
#define FTM_EXTTRIG_CH4TRIG_SHIFT                2
#define FTM_EXTTRIG_CH4TRIG_WIDTH                1
#define FTM_EXTTRIG_CH4TRIG(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_CH4TRIG_SHIFT))&FTM_EXTTRIG_CH4TRIG_MASK)
#define FTM_EXTTRIG_CH5TRIG_MASK                 0x8u
#define FTM_EXTTRIG_CH5TRIG_SHIFT                3
#define FTM_EXTTRIG_CH5TRIG_WIDTH                1
#define FTM_EXTTRIG_CH5TRIG(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_CH5TRIG_SHIFT))&FTM_EXTTRIG_CH5TRIG_MASK)
#define FTM_EXTTRIG_CH0TRIG_MASK                 0x10u
#define FTM_EXTTRIG_CH0TRIG_SHIFT                4
#define FTM_EXTTRIG_CH0TRIG_WIDTH                1
#define FTM_EXTTRIG_CH0TRIG(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_CH0TRIG_SHIFT))&FTM_EXTTRIG_CH0TRIG_MASK)
#define FTM_EXTTRIG_CH1TRIG_MASK                 0x20u
#define FTM_EXTTRIG_CH1TRIG_SHIFT                5
#define FTM_EXTTRIG_CH1TRIG_WIDTH                1
#define FTM_EXTTRIG_CH1TRIG(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_CH1TRIG_SHIFT))&FTM_EXTTRIG_CH1TRIG_MASK)
#define FTM_EXTTRIG_INITTRIGEN_MASK              0x40u
#define FTM_EXTTRIG_INITTRIGEN_SHIFT             6
#define FTM_EXTTRIG_INITTRIGEN_WIDTH             1
#define FTM_EXTTRIG_INITTRIGEN(x)                (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_INITTRIGEN_SHIFT))&FTM_EXTTRIG_INITTRIGEN_MASK)
#define FTM_EXTTRIG_TRIGF_MASK                   0x80u
#define FTM_EXTTRIG_TRIGF_SHIFT                  7
#define FTM_EXTTRIG_TRIGF_WIDTH                  1
#define FTM_EXTTRIG_TRIGF(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_EXTTRIG_TRIGF_SHIFT))&FTM_EXTTRIG_TRIGF_MASK)
/* POL Bit Fields */
#define FTM_POL_POL0_MASK                        0x1u
#define FTM_POL_POL0_SHIFT                       0
#define FTM_POL_POL0_WIDTH                       1
#define FTM_POL_POL0(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL0_SHIFT))&FTM_POL_POL0_MASK)
#define FTM_POL_POL1_MASK                        0x2u
#define FTM_POL_POL1_SHIFT                       1
#define FTM_POL_POL1_WIDTH                       1
#define FTM_POL_POL1(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL1_SHIFT))&FTM_POL_POL1_MASK)
#define FTM_POL_POL2_MASK                        0x4u
#define FTM_POL_POL2_SHIFT                       2
#define FTM_POL_POL2_WIDTH                       1
#define FTM_POL_POL2(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL2_SHIFT))&FTM_POL_POL2_MASK)
#define FTM_POL_POL3_MASK                        0x8u
#define FTM_POL_POL3_SHIFT                       3
#define FTM_POL_POL3_WIDTH                       1
#define FTM_POL_POL3(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL3_SHIFT))&FTM_POL_POL3_MASK)
#define FTM_POL_POL4_MASK                        0x10u
#define FTM_POL_POL4_SHIFT                       4
#define FTM_POL_POL4_WIDTH                       1
#define FTM_POL_POL4(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL4_SHIFT))&FTM_POL_POL4_MASK)
#define FTM_POL_POL5_MASK                        0x20u
#define FTM_POL_POL5_SHIFT                       5
#define FTM_POL_POL5_WIDTH                       1
#define FTM_POL_POL5(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL5_SHIFT))&FTM_POL_POL5_MASK)
#define FTM_POL_POL6_MASK                        0x40u
#define FTM_POL_POL6_SHIFT                       6
#define FTM_POL_POL6_WIDTH                       1
#define FTM_POL_POL6(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL6_SHIFT))&FTM_POL_POL6_MASK)
#define FTM_POL_POL7_MASK                        0x80u
#define FTM_POL_POL7_SHIFT                       7
#define FTM_POL_POL7_WIDTH                       1
#define FTM_POL_POL7(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_POL_POL7_SHIFT))&FTM_POL_POL7_MASK)
/* FMS Bit Fields */
#define FTM_FMS_FAULTF0_MASK                     0x1u
#define FTM_FMS_FAULTF0_SHIFT                    0
#define FTM_FMS_FAULTF0_WIDTH                    1
#define FTM_FMS_FAULTF0(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_FMS_FAULTF0_SHIFT))&FTM_FMS_FAULTF0_MASK)
#define FTM_FMS_FAULTF1_MASK                     0x2u
#define FTM_FMS_FAULTF1_SHIFT                    1
#define FTM_FMS_FAULTF1_WIDTH                    1
#define FTM_FMS_FAULTF1(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_FMS_FAULTF1_SHIFT))&FTM_FMS_FAULTF1_MASK)
#define FTM_FMS_FAULTF2_MASK                     0x4u
#define FTM_FMS_FAULTF2_SHIFT                    2
#define FTM_FMS_FAULTF2_WIDTH                    1
#define FTM_FMS_FAULTF2(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_FMS_FAULTF2_SHIFT))&FTM_FMS_FAULTF2_MASK)
#define FTM_FMS_FAULTF3_MASK                     0x8u
#define FTM_FMS_FAULTF3_SHIFT                    3
#define FTM_FMS_FAULTF3_WIDTH                    1
#define FTM_FMS_FAULTF3(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_FMS_FAULTF3_SHIFT))&FTM_FMS_FAULTF3_MASK)
#define FTM_FMS_FAULTIN_MASK                     0x20u
#define FTM_FMS_FAULTIN_SHIFT                    5
#define FTM_FMS_FAULTIN_WIDTH                    1
#define FTM_FMS_FAULTIN(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_FMS_FAULTIN_SHIFT))&FTM_FMS_FAULTIN_MASK)
#define FTM_FMS_WPEN_MASK                        0x40u
#define FTM_FMS_WPEN_SHIFT                       6
#define FTM_FMS_WPEN_WIDTH                       1
#define FTM_FMS_WPEN(x)                          (((uint32_t)(((uint32_t)(x))<<FTM_FMS_WPEN_SHIFT))&FTM_FMS_WPEN_MASK)
#define FTM_FMS_FAULTF_MASK                      0x80u
#define FTM_FMS_FAULTF_SHIFT                     7
#define FTM_FMS_FAULTF_WIDTH                     1
#define FTM_FMS_FAULTF(x)                        (((uint32_t)(((uint32_t)(x))<<FTM_FMS_FAULTF_SHIFT))&FTM_FMS_FAULTF_MASK)
/* FILTER Bit Fields */
#define FTM_FILTER_CH0FVAL_MASK                  0xFu
#define FTM_FILTER_CH0FVAL_SHIFT                 0
#define FTM_FILTER_CH0FVAL_WIDTH                 4
#define FTM_FILTER_CH0FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FILTER_CH0FVAL_SHIFT))&FTM_FILTER_CH0FVAL_MASK)
#define FTM_FILTER_CH1FVAL_MASK                  0xF0u
#define FTM_FILTER_CH1FVAL_SHIFT                 4
#define FTM_FILTER_CH1FVAL_WIDTH                 4
#define FTM_FILTER_CH1FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FILTER_CH1FVAL_SHIFT))&FTM_FILTER_CH1FVAL_MASK)
#define FTM_FILTER_CH2FVAL_MASK                  0xF00u
#define FTM_FILTER_CH2FVAL_SHIFT                 8
#define FTM_FILTER_CH2FVAL_WIDTH                 4
#define FTM_FILTER_CH2FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FILTER_CH2FVAL_SHIFT))&FTM_FILTER_CH2FVAL_MASK)
#define FTM_FILTER_CH3FVAL_MASK                  0xF000u
#define FTM_FILTER_CH3FVAL_SHIFT                 12
#define FTM_FILTER_CH3FVAL_WIDTH                 4
#define FTM_FILTER_CH3FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FILTER_CH3FVAL_SHIFT))&FTM_FILTER_CH3FVAL_MASK)
/* FLTCTRL Bit Fields */
#define FTM_FLTCTRL_FAULT0EN_MASK                0x1u
#define FTM_FLTCTRL_FAULT0EN_SHIFT               0
#define FTM_FLTCTRL_FAULT0EN_WIDTH               1
#define FTM_FLTCTRL_FAULT0EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FAULT0EN_SHIFT))&FTM_FLTCTRL_FAULT0EN_MASK)
#define FTM_FLTCTRL_FAULT1EN_MASK                0x2u
#define FTM_FLTCTRL_FAULT1EN_SHIFT               1
#define FTM_FLTCTRL_FAULT1EN_WIDTH               1
#define FTM_FLTCTRL_FAULT1EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FAULT1EN_SHIFT))&FTM_FLTCTRL_FAULT1EN_MASK)
#define FTM_FLTCTRL_FAULT2EN_MASK                0x4u
#define FTM_FLTCTRL_FAULT2EN_SHIFT               2
#define FTM_FLTCTRL_FAULT2EN_WIDTH               1
#define FTM_FLTCTRL_FAULT2EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FAULT2EN_SHIFT))&FTM_FLTCTRL_FAULT2EN_MASK)
#define FTM_FLTCTRL_FAULT3EN_MASK                0x8u
#define FTM_FLTCTRL_FAULT3EN_SHIFT               3
#define FTM_FLTCTRL_FAULT3EN_WIDTH               1
#define FTM_FLTCTRL_FAULT3EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FAULT3EN_SHIFT))&FTM_FLTCTRL_FAULT3EN_MASK)
#define FTM_FLTCTRL_FFLTR0EN_MASK                0x10u
#define FTM_FLTCTRL_FFLTR0EN_SHIFT               4
#define FTM_FLTCTRL_FFLTR0EN_WIDTH               1
#define FTM_FLTCTRL_FFLTR0EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FFLTR0EN_SHIFT))&FTM_FLTCTRL_FFLTR0EN_MASK)
#define FTM_FLTCTRL_FFLTR1EN_MASK                0x20u
#define FTM_FLTCTRL_FFLTR1EN_SHIFT               5
#define FTM_FLTCTRL_FFLTR1EN_WIDTH               1
#define FTM_FLTCTRL_FFLTR1EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FFLTR1EN_SHIFT))&FTM_FLTCTRL_FFLTR1EN_MASK)
#define FTM_FLTCTRL_FFLTR2EN_MASK                0x40u
#define FTM_FLTCTRL_FFLTR2EN_SHIFT               6
#define FTM_FLTCTRL_FFLTR2EN_WIDTH               1
#define FTM_FLTCTRL_FFLTR2EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FFLTR2EN_SHIFT))&FTM_FLTCTRL_FFLTR2EN_MASK)
#define FTM_FLTCTRL_FFLTR3EN_MASK                0x80u
#define FTM_FLTCTRL_FFLTR3EN_SHIFT               7
#define FTM_FLTCTRL_FFLTR3EN_WIDTH               1
#define FTM_FLTCTRL_FFLTR3EN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FFLTR3EN_SHIFT))&FTM_FLTCTRL_FFLTR3EN_MASK)
#define FTM_FLTCTRL_FFVAL_MASK                   0xF00u
#define FTM_FLTCTRL_FFVAL_SHIFT                  8
#define FTM_FLTCTRL_FFVAL_WIDTH                  4
#define FTM_FLTCTRL_FFVAL(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_FLTCTRL_FFVAL_SHIFT))&FTM_FLTCTRL_FFVAL_MASK)
/* QDCTRL Bit Fields */
#define FTM_QDCTRL_QUADEN_MASK                   0x1u
#define FTM_QDCTRL_QUADEN_SHIFT                  0
#define FTM_QDCTRL_QUADEN_WIDTH                  1
#define FTM_QDCTRL_QUADEN(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_QUADEN_SHIFT))&FTM_QDCTRL_QUADEN_MASK)
#define FTM_QDCTRL_TOFDIR_MASK                   0x2u
#define FTM_QDCTRL_TOFDIR_SHIFT                  1
#define FTM_QDCTRL_TOFDIR_WIDTH                  1
#define FTM_QDCTRL_TOFDIR(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_TOFDIR_SHIFT))&FTM_QDCTRL_TOFDIR_MASK)
#define FTM_QDCTRL_QUADIR_MASK                   0x4u
#define FTM_QDCTRL_QUADIR_SHIFT                  2
#define FTM_QDCTRL_QUADIR_WIDTH                  1
#define FTM_QDCTRL_QUADIR(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_QUADIR_SHIFT))&FTM_QDCTRL_QUADIR_MASK)
#define FTM_QDCTRL_QUADMODE_MASK                 0x8u
#define FTM_QDCTRL_QUADMODE_SHIFT                3
#define FTM_QDCTRL_QUADMODE_WIDTH                1
#define FTM_QDCTRL_QUADMODE(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_QUADMODE_SHIFT))&FTM_QDCTRL_QUADMODE_MASK)
#define FTM_QDCTRL_PHBPOL_MASK                   0x10u
#define FTM_QDCTRL_PHBPOL_SHIFT                  4
#define FTM_QDCTRL_PHBPOL_WIDTH                  1
#define FTM_QDCTRL_PHBPOL(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_PHBPOL_SHIFT))&FTM_QDCTRL_PHBPOL_MASK)
#define FTM_QDCTRL_PHAPOL_MASK                   0x20u
#define FTM_QDCTRL_PHAPOL_SHIFT                  5
#define FTM_QDCTRL_PHAPOL_WIDTH                  1
#define FTM_QDCTRL_PHAPOL(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_PHAPOL_SHIFT))&FTM_QDCTRL_PHAPOL_MASK)
#define FTM_QDCTRL_PHBFLTREN_MASK                0x40u
#define FTM_QDCTRL_PHBFLTREN_SHIFT               6
#define FTM_QDCTRL_PHBFLTREN_WIDTH               1
#define FTM_QDCTRL_PHBFLTREN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_PHBFLTREN_SHIFT))&FTM_QDCTRL_PHBFLTREN_MASK)
#define FTM_QDCTRL_PHAFLTREN_MASK                0x80u
#define FTM_QDCTRL_PHAFLTREN_SHIFT               7
#define FTM_QDCTRL_PHAFLTREN_WIDTH               1
#define FTM_QDCTRL_PHAFLTREN(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_QDCTRL_PHAFLTREN_SHIFT))&FTM_QDCTRL_PHAFLTREN_MASK)
/* CONF Bit Fields */
#define FTM_CONF_NUMTOF_MASK                     0x1Fu
#define FTM_CONF_NUMTOF_SHIFT                    0
#define FTM_CONF_NUMTOF_WIDTH                    5
#define FTM_CONF_NUMTOF(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_CONF_NUMTOF_SHIFT))&FTM_CONF_NUMTOF_MASK)
#define FTM_CONF_BDMMODE_MASK                    0xC0u
#define FTM_CONF_BDMMODE_SHIFT                   6
#define FTM_CONF_BDMMODE_WIDTH                   2
#define FTM_CONF_BDMMODE(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_CONF_BDMMODE_SHIFT))&FTM_CONF_BDMMODE_MASK)
#define FTM_CONF_GTBEEN_MASK                     0x200u
#define FTM_CONF_GTBEEN_SHIFT                    9
#define FTM_CONF_GTBEEN_WIDTH                    1
#define FTM_CONF_GTBEEN(x)                       (((uint32_t)(((uint32_t)(x))<<FTM_CONF_GTBEEN_SHIFT))&FTM_CONF_GTBEEN_MASK)
#define FTM_CONF_GTBEOUT_MASK                    0x400u
#define FTM_CONF_GTBEOUT_SHIFT                   10
#define FTM_CONF_GTBEOUT_WIDTH                   1
#define FTM_CONF_GTBEOUT(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_CONF_GTBEOUT_SHIFT))&FTM_CONF_GTBEOUT_MASK)
/* FLTPOL Bit Fields */
#define FTM_FLTPOL_FLT0POL_MASK                  0x1u
#define FTM_FLTPOL_FLT0POL_SHIFT                 0
#define FTM_FLTPOL_FLT0POL_WIDTH                 1
#define FTM_FLTPOL_FLT0POL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FLTPOL_FLT0POL_SHIFT))&FTM_FLTPOL_FLT0POL_MASK)
#define FTM_FLTPOL_FLT1POL_MASK                  0x2u
#define FTM_FLTPOL_FLT1POL_SHIFT                 1
#define FTM_FLTPOL_FLT1POL_WIDTH                 1
#define FTM_FLTPOL_FLT1POL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FLTPOL_FLT1POL_SHIFT))&FTM_FLTPOL_FLT1POL_MASK)
#define FTM_FLTPOL_FLT2POL_MASK                  0x4u
#define FTM_FLTPOL_FLT2POL_SHIFT                 2
#define FTM_FLTPOL_FLT2POL_WIDTH                 1
#define FTM_FLTPOL_FLT2POL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FLTPOL_FLT2POL_SHIFT))&FTM_FLTPOL_FLT2POL_MASK)
#define FTM_FLTPOL_FLT3POL_MASK                  0x8u
#define FTM_FLTPOL_FLT3POL_SHIFT                 3
#define FTM_FLTPOL_FLT3POL_WIDTH                 1
#define FTM_FLTPOL_FLT3POL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_FLTPOL_FLT3POL_SHIFT))&FTM_FLTPOL_FLT3POL_MASK)
/* SYNCONF Bit Fields */
#define FTM_SYNCONF_HWTRIGMODE_MASK              0x1u
#define FTM_SYNCONF_HWTRIGMODE_SHIFT             0
#define FTM_SYNCONF_HWTRIGMODE_WIDTH             1
#define FTM_SYNCONF_HWTRIGMODE(x)                (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_HWTRIGMODE_SHIFT))&FTM_SYNCONF_HWTRIGMODE_MASK)
#define FTM_SYNCONF_CNTINC_MASK                  0x4u
#define FTM_SYNCONF_CNTINC_SHIFT                 2
#define FTM_SYNCONF_CNTINC_WIDTH                 1
#define FTM_SYNCONF_CNTINC(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_CNTINC_SHIFT))&FTM_SYNCONF_CNTINC_MASK)
#define FTM_SYNCONF_INVC_MASK                    0x10u
#define FTM_SYNCONF_INVC_SHIFT                   4
#define FTM_SYNCONF_INVC_WIDTH                   1
#define FTM_SYNCONF_INVC(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_INVC_SHIFT))&FTM_SYNCONF_INVC_MASK)
#define FTM_SYNCONF_SWOC_MASK                    0x20u
#define FTM_SYNCONF_SWOC_SHIFT                   5
#define FTM_SYNCONF_SWOC_WIDTH                   1
#define FTM_SYNCONF_SWOC(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_SWOC_SHIFT))&FTM_SYNCONF_SWOC_MASK)
#define FTM_SYNCONF_SYNCMODE_MASK                0x80u
#define FTM_SYNCONF_SYNCMODE_SHIFT               7
#define FTM_SYNCONF_SYNCMODE_WIDTH               1
#define FTM_SYNCONF_SYNCMODE(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_SYNCMODE_SHIFT))&FTM_SYNCONF_SYNCMODE_MASK)
#define FTM_SYNCONF_SWRSTCNT_MASK                0x100u
#define FTM_SYNCONF_SWRSTCNT_SHIFT               8
#define FTM_SYNCONF_SWRSTCNT_WIDTH               1
#define FTM_SYNCONF_SWRSTCNT(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_SWRSTCNT_SHIFT))&FTM_SYNCONF_SWRSTCNT_MASK)
#define FTM_SYNCONF_SWWRBUF_MASK                 0x200u
#define FTM_SYNCONF_SWWRBUF_SHIFT                9
#define FTM_SYNCONF_SWWRBUF_WIDTH                1
#define FTM_SYNCONF_SWWRBUF(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_SWWRBUF_SHIFT))&FTM_SYNCONF_SWWRBUF_MASK)
#define FTM_SYNCONF_SWOM_MASK                    0x400u
#define FTM_SYNCONF_SWOM_SHIFT                   10
#define FTM_SYNCONF_SWOM_WIDTH                   1
#define FTM_SYNCONF_SWOM(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_SWOM_SHIFT))&FTM_SYNCONF_SWOM_MASK)
#define FTM_SYNCONF_SWINVC_MASK                  0x800u
#define FTM_SYNCONF_SWINVC_SHIFT                 11
#define FTM_SYNCONF_SWINVC_WIDTH                 1
#define FTM_SYNCONF_SWINVC(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_SWINVC_SHIFT))&FTM_SYNCONF_SWINVC_MASK)
#define FTM_SYNCONF_SWSOC_MASK                   0x1000u
#define FTM_SYNCONF_SWSOC_SHIFT                  12
#define FTM_SYNCONF_SWSOC_WIDTH                  1
#define FTM_SYNCONF_SWSOC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_SWSOC_SHIFT))&FTM_SYNCONF_SWSOC_MASK)
#define FTM_SYNCONF_HWRSTCNT_MASK                0x10000u
#define FTM_SYNCONF_HWRSTCNT_SHIFT               16
#define FTM_SYNCONF_HWRSTCNT_WIDTH               1
#define FTM_SYNCONF_HWRSTCNT(x)                  (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_HWRSTCNT_SHIFT))&FTM_SYNCONF_HWRSTCNT_MASK)
#define FTM_SYNCONF_HWWRBUF_MASK                 0x20000u
#define FTM_SYNCONF_HWWRBUF_SHIFT                17
#define FTM_SYNCONF_HWWRBUF_WIDTH                1
#define FTM_SYNCONF_HWWRBUF(x)                   (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_HWWRBUF_SHIFT))&FTM_SYNCONF_HWWRBUF_MASK)
#define FTM_SYNCONF_HWOM_MASK                    0x40000u
#define FTM_SYNCONF_HWOM_SHIFT                   18
#define FTM_SYNCONF_HWOM_WIDTH                   1
#define FTM_SYNCONF_HWOM(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_HWOM_SHIFT))&FTM_SYNCONF_HWOM_MASK)
#define FTM_SYNCONF_HWINVC_MASK                  0x80000u
#define FTM_SYNCONF_HWINVC_SHIFT                 19
#define FTM_SYNCONF_HWINVC_WIDTH                 1
#define FTM_SYNCONF_HWINVC(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_HWINVC_SHIFT))&FTM_SYNCONF_HWINVC_MASK)
#define FTM_SYNCONF_HWSOC_MASK                   0x100000u
#define FTM_SYNCONF_HWSOC_SHIFT                  20
#define FTM_SYNCONF_HWSOC_WIDTH                  1
#define FTM_SYNCONF_HWSOC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SYNCONF_HWSOC_SHIFT))&FTM_SYNCONF_HWSOC_MASK)
/* INVCTRL Bit Fields */
#define FTM_INVCTRL_INV0EN_MASK                  0x1u
#define FTM_INVCTRL_INV0EN_SHIFT                 0
#define FTM_INVCTRL_INV0EN_WIDTH                 1
#define FTM_INVCTRL_INV0EN(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_INVCTRL_INV0EN_SHIFT))&FTM_INVCTRL_INV0EN_MASK)
#define FTM_INVCTRL_INV1EN_MASK                  0x2u
#define FTM_INVCTRL_INV1EN_SHIFT                 1
#define FTM_INVCTRL_INV1EN_WIDTH                 1
#define FTM_INVCTRL_INV1EN(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_INVCTRL_INV1EN_SHIFT))&FTM_INVCTRL_INV1EN_MASK)
#define FTM_INVCTRL_INV2EN_MASK                  0x4u
#define FTM_INVCTRL_INV2EN_SHIFT                 2
#define FTM_INVCTRL_INV2EN_WIDTH                 1
#define FTM_INVCTRL_INV2EN(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_INVCTRL_INV2EN_SHIFT))&FTM_INVCTRL_INV2EN_MASK)
#define FTM_INVCTRL_INV3EN_MASK                  0x8u
#define FTM_INVCTRL_INV3EN_SHIFT                 3
#define FTM_INVCTRL_INV3EN_WIDTH                 1
#define FTM_INVCTRL_INV3EN(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_INVCTRL_INV3EN_SHIFT))&FTM_INVCTRL_INV3EN_MASK)
/* SWOCTRL Bit Fields */
#define FTM_SWOCTRL_CH0OC_MASK                   0x1u
#define FTM_SWOCTRL_CH0OC_SHIFT                  0
#define FTM_SWOCTRL_CH0OC_WIDTH                  1
#define FTM_SWOCTRL_CH0OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH0OC_SHIFT))&FTM_SWOCTRL_CH0OC_MASK)
#define FTM_SWOCTRL_CH1OC_MASK                   0x2u
#define FTM_SWOCTRL_CH1OC_SHIFT                  1
#define FTM_SWOCTRL_CH1OC_WIDTH                  1
#define FTM_SWOCTRL_CH1OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH1OC_SHIFT))&FTM_SWOCTRL_CH1OC_MASK)
#define FTM_SWOCTRL_CH2OC_MASK                   0x4u
#define FTM_SWOCTRL_CH2OC_SHIFT                  2
#define FTM_SWOCTRL_CH2OC_WIDTH                  1
#define FTM_SWOCTRL_CH2OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH2OC_SHIFT))&FTM_SWOCTRL_CH2OC_MASK)
#define FTM_SWOCTRL_CH3OC_MASK                   0x8u
#define FTM_SWOCTRL_CH3OC_SHIFT                  3
#define FTM_SWOCTRL_CH3OC_WIDTH                  1
#define FTM_SWOCTRL_CH3OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH3OC_SHIFT))&FTM_SWOCTRL_CH3OC_MASK)
#define FTM_SWOCTRL_CH4OC_MASK                   0x10u
#define FTM_SWOCTRL_CH4OC_SHIFT                  4
#define FTM_SWOCTRL_CH4OC_WIDTH                  1
#define FTM_SWOCTRL_CH4OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH4OC_SHIFT))&FTM_SWOCTRL_CH4OC_MASK)
#define FTM_SWOCTRL_CH5OC_MASK                   0x20u
#define FTM_SWOCTRL_CH5OC_SHIFT                  5
#define FTM_SWOCTRL_CH5OC_WIDTH                  1
#define FTM_SWOCTRL_CH5OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH5OC_SHIFT))&FTM_SWOCTRL_CH5OC_MASK)
#define FTM_SWOCTRL_CH6OC_MASK                   0x40u
#define FTM_SWOCTRL_CH6OC_SHIFT                  6
#define FTM_SWOCTRL_CH6OC_WIDTH                  1
#define FTM_SWOCTRL_CH6OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH6OC_SHIFT))&FTM_SWOCTRL_CH6OC_MASK)
#define FTM_SWOCTRL_CH7OC_MASK                   0x80u
#define FTM_SWOCTRL_CH7OC_SHIFT                  7
#define FTM_SWOCTRL_CH7OC_WIDTH                  1
#define FTM_SWOCTRL_CH7OC(x)                     (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH7OC_SHIFT))&FTM_SWOCTRL_CH7OC_MASK)
#define FTM_SWOCTRL_CH0OCV_MASK                  0x100u
#define FTM_SWOCTRL_CH0OCV_SHIFT                 8
#define FTM_SWOCTRL_CH0OCV_WIDTH                 1
#define FTM_SWOCTRL_CH0OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH0OCV_SHIFT))&FTM_SWOCTRL_CH0OCV_MASK)
#define FTM_SWOCTRL_CH1OCV_MASK                  0x200u
#define FTM_SWOCTRL_CH1OCV_SHIFT                 9
#define FTM_SWOCTRL_CH1OCV_WIDTH                 1
#define FTM_SWOCTRL_CH1OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH1OCV_SHIFT))&FTM_SWOCTRL_CH1OCV_MASK)
#define FTM_SWOCTRL_CH2OCV_MASK                  0x400u
#define FTM_SWOCTRL_CH2OCV_SHIFT                 10
#define FTM_SWOCTRL_CH2OCV_WIDTH                 1
#define FTM_SWOCTRL_CH2OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH2OCV_SHIFT))&FTM_SWOCTRL_CH2OCV_MASK)
#define FTM_SWOCTRL_CH3OCV_MASK                  0x800u
#define FTM_SWOCTRL_CH3OCV_SHIFT                 11
#define FTM_SWOCTRL_CH3OCV_WIDTH                 1
#define FTM_SWOCTRL_CH3OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH3OCV_SHIFT))&FTM_SWOCTRL_CH3OCV_MASK)
#define FTM_SWOCTRL_CH4OCV_MASK                  0x1000u
#define FTM_SWOCTRL_CH4OCV_SHIFT                 12
#define FTM_SWOCTRL_CH4OCV_WIDTH                 1
#define FTM_SWOCTRL_CH4OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH4OCV_SHIFT))&FTM_SWOCTRL_CH4OCV_MASK)
#define FTM_SWOCTRL_CH5OCV_MASK                  0x2000u
#define FTM_SWOCTRL_CH5OCV_SHIFT                 13
#define FTM_SWOCTRL_CH5OCV_WIDTH                 1
#define FTM_SWOCTRL_CH5OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH5OCV_SHIFT))&FTM_SWOCTRL_CH5OCV_MASK)
#define FTM_SWOCTRL_CH6OCV_MASK                  0x4000u
#define FTM_SWOCTRL_CH6OCV_SHIFT                 14
#define FTM_SWOCTRL_CH6OCV_WIDTH                 1
#define FTM_SWOCTRL_CH6OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH6OCV_SHIFT))&FTM_SWOCTRL_CH6OCV_MASK)
#define FTM_SWOCTRL_CH7OCV_MASK                  0x8000u
#define FTM_SWOCTRL_CH7OCV_SHIFT                 15
#define FTM_SWOCTRL_CH7OCV_WIDTH                 1
#define FTM_SWOCTRL_CH7OCV(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_SWOCTRL_CH7OCV_SHIFT))&FTM_SWOCTRL_CH7OCV_MASK)
/* PWMLOAD Bit Fields */
#define FTM_PWMLOAD_CH0SEL_MASK                  0x1u
#define FTM_PWMLOAD_CH0SEL_SHIFT                 0
#define FTM_PWMLOAD_CH0SEL_WIDTH                 1
#define FTM_PWMLOAD_CH0SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH0SEL_SHIFT))&FTM_PWMLOAD_CH0SEL_MASK)
#define FTM_PWMLOAD_CH1SEL_MASK                  0x2u
#define FTM_PWMLOAD_CH1SEL_SHIFT                 1
#define FTM_PWMLOAD_CH1SEL_WIDTH                 1
#define FTM_PWMLOAD_CH1SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH1SEL_SHIFT))&FTM_PWMLOAD_CH1SEL_MASK)
#define FTM_PWMLOAD_CH2SEL_MASK                  0x4u
#define FTM_PWMLOAD_CH2SEL_SHIFT                 2
#define FTM_PWMLOAD_CH2SEL_WIDTH                 1
#define FTM_PWMLOAD_CH2SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH2SEL_SHIFT))&FTM_PWMLOAD_CH2SEL_MASK)
#define FTM_PWMLOAD_CH3SEL_MASK                  0x8u
#define FTM_PWMLOAD_CH3SEL_SHIFT                 3
#define FTM_PWMLOAD_CH3SEL_WIDTH                 1
#define FTM_PWMLOAD_CH3SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH3SEL_SHIFT))&FTM_PWMLOAD_CH3SEL_MASK)
#define FTM_PWMLOAD_CH4SEL_MASK                  0x10u
#define FTM_PWMLOAD_CH4SEL_SHIFT                 4
#define FTM_PWMLOAD_CH4SEL_WIDTH                 1
#define FTM_PWMLOAD_CH4SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH4SEL_SHIFT))&FTM_PWMLOAD_CH4SEL_MASK)
#define FTM_PWMLOAD_CH5SEL_MASK                  0x20u
#define FTM_PWMLOAD_CH5SEL_SHIFT                 5
#define FTM_PWMLOAD_CH5SEL_WIDTH                 1
#define FTM_PWMLOAD_CH5SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH5SEL_SHIFT))&FTM_PWMLOAD_CH5SEL_MASK)
#define FTM_PWMLOAD_CH6SEL_MASK                  0x40u
#define FTM_PWMLOAD_CH6SEL_SHIFT                 6
#define FTM_PWMLOAD_CH6SEL_WIDTH                 1
#define FTM_PWMLOAD_CH6SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH6SEL_SHIFT))&FTM_PWMLOAD_CH6SEL_MASK)
#define FTM_PWMLOAD_CH7SEL_MASK                  0x80u
#define FTM_PWMLOAD_CH7SEL_SHIFT                 7
#define FTM_PWMLOAD_CH7SEL_WIDTH                 1
#define FTM_PWMLOAD_CH7SEL(x)                    (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_CH7SEL_SHIFT))&FTM_PWMLOAD_CH7SEL_MASK)
#define FTM_PWMLOAD_LDOK_MASK                    0x200u
#define FTM_PWMLOAD_LDOK_SHIFT                   9
#define FTM_PWMLOAD_LDOK_WIDTH                   1
#define FTM_PWMLOAD_LDOK(x)                      (((uint32_t)(((uint32_t)(x))<<FTM_PWMLOAD_LDOK_SHIFT))&FTM_PWMLOAD_LDOK_MASK)

/*!
 * @}
 */ /* end of group FTM_Register_Masks */


/* FTM - Peripheral instance base addresses */
/** Peripheral FTM0 base address */
#define FTM0_BASE                                (0x40038000u)
/** Peripheral FTM0 base pointer */
#define FTM0                                     ((FTM_Type *)FTM0_BASE)
#define FTM0_BASE_PTR                            (FTM0)
/** Peripheral FTM1 base address */
#define FTM1_BASE                                (0x40039000u)
/** Peripheral FTM1 base pointer */
#define FTM1                                     ((FTM_Type *)FTM1_BASE)
#define FTM1_BASE_PTR                            (FTM1)
/** Peripheral FTM2 base address */
#define FTM2_BASE                                (0x4003A000u)
/** Peripheral FTM2 base pointer */
#define FTM2                                     ((FTM_Type *)FTM2_BASE)
#define FTM2_BASE_PTR                            (FTM2)
/** Peripheral FTM3 base address */
#define FTM3_BASE                                (0x40026000u)
/** Peripheral FTM3 base pointer */
#define FTM3                                     ((FTM_Type *)FTM3_BASE)
#define FTM3_BASE_PTR                            (FTM3)
/** Array initializer of FTM peripheral base addresses */
#define FTM_BASE_ADDRS                           { FTM0_BASE, FTM1_BASE, FTM2_BASE, FTM3_BASE }
/** Array initializer of FTM peripheral base pointers */
#define FTM_BASE_PTRS                            { FTM0, FTM1, FTM2, FTM3 }

/* ----------------------------------------------------------------------------
   -- FTM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTM_Register_Accessor_Macros FTM - Register accessor macros
 * @{
 */


/* FTM - Register instance definitions */
/* FTM0 */
#define FTM0_SC                                  FTM_SC_REG(FTM0)
#define FTM0_CNT                                 FTM_CNT_REG(FTM0)
#define FTM0_MOD                                 FTM_MOD_REG(FTM0)
#define FTM0_C0SC                                FTM_CnSC_REG(FTM0,0)
#define FTM0_C0V                                 FTM_CnV_REG(FTM0,0)
#define FTM0_C1SC                                FTM_CnSC_REG(FTM0,1)
#define FTM0_C1V                                 FTM_CnV_REG(FTM0,1)
#define FTM0_C2SC                                FTM_CnSC_REG(FTM0,2)
#define FTM0_C2V                                 FTM_CnV_REG(FTM0,2)
#define FTM0_C3SC                                FTM_CnSC_REG(FTM0,3)
#define FTM0_C3V                                 FTM_CnV_REG(FTM0,3)
#define FTM0_C4SC                                FTM_CnSC_REG(FTM0,4)
#define FTM0_C4V                                 FTM_CnV_REG(FTM0,4)
#define FTM0_C5SC                                FTM_CnSC_REG(FTM0,5)
#define FTM0_C5V                                 FTM_CnV_REG(FTM0,5)
#define FTM0_C6SC                                FTM_CnSC_REG(FTM0,6)
#define FTM0_C6V                                 FTM_CnV_REG(FTM0,6)
#define FTM0_C7SC                                FTM_CnSC_REG(FTM0,7)
#define FTM0_C7V                                 FTM_CnV_REG(FTM0,7)
#define FTM0_CNTIN                               FTM_CNTIN_REG(FTM0)
#define FTM0_STATUS                              FTM_STATUS_REG(FTM0)
#define FTM0_MODE                                FTM_MODE_REG(FTM0)
#define FTM0_SYNC                                FTM_SYNC_REG(FTM0)
#define FTM0_OUTINIT                             FTM_OUTINIT_REG(FTM0)
#define FTM0_OUTMASK                             FTM_OUTMASK_REG(FTM0)
#define FTM0_COMBINE                             FTM_COMBINE_REG(FTM0)
#define FTM0_DEADTIME                            FTM_DEADTIME_REG(FTM0)
#define FTM0_EXTTRIG                             FTM_EXTTRIG_REG(FTM0)
#define FTM0_POL                                 FTM_POL_REG(FTM0)
#define FTM0_FMS                                 FTM_FMS_REG(FTM0)
#define FTM0_FILTER                              FTM_FILTER_REG(FTM0)
#define FTM0_FLTCTRL                             FTM_FLTCTRL_REG(FTM0)
#define FTM0_QDCTRL                              FTM_QDCTRL_REG(FTM0)
#define FTM0_CONF                                FTM_CONF_REG(FTM0)
#define FTM0_FLTPOL                              FTM_FLTPOL_REG(FTM0)
#define FTM0_SYNCONF                             FTM_SYNCONF_REG(FTM0)
#define FTM0_INVCTRL                             FTM_INVCTRL_REG(FTM0)
#define FTM0_SWOCTRL                             FTM_SWOCTRL_REG(FTM0)
#define FTM0_PWMLOAD                             FTM_PWMLOAD_REG(FTM0)
/* FTM1 */
#define FTM1_SC                                  FTM_SC_REG(FTM1)
#define FTM1_CNT                                 FTM_CNT_REG(FTM1)
#define FTM1_MOD                                 FTM_MOD_REG(FTM1)
#define FTM1_C0SC                                FTM_CnSC_REG(FTM1,0)
#define FTM1_C0V                                 FTM_CnV_REG(FTM1,0)
#define FTM1_C1SC                                FTM_CnSC_REG(FTM1,1)
#define FTM1_C1V                                 FTM_CnV_REG(FTM1,1)
#define FTM1_CNTIN                               FTM_CNTIN_REG(FTM1)
#define FTM1_STATUS                              FTM_STATUS_REG(FTM1)
#define FTM1_MODE                                FTM_MODE_REG(FTM1)
#define FTM1_SYNC                                FTM_SYNC_REG(FTM1)
#define FTM1_OUTINIT                             FTM_OUTINIT_REG(FTM1)
#define FTM1_OUTMASK                             FTM_OUTMASK_REG(FTM1)
#define FTM1_COMBINE                             FTM_COMBINE_REG(FTM1)
#define FTM1_DEADTIME                            FTM_DEADTIME_REG(FTM1)
#define FTM1_EXTTRIG                             FTM_EXTTRIG_REG(FTM1)
#define FTM1_POL                                 FTM_POL_REG(FTM1)
#define FTM1_FMS                                 FTM_FMS_REG(FTM1)
#define FTM1_FILTER                              FTM_FILTER_REG(FTM1)
#define FTM1_FLTCTRL                             FTM_FLTCTRL_REG(FTM1)
#define FTM1_QDCTRL                              FTM_QDCTRL_REG(FTM1)
#define FTM1_CONF                                FTM_CONF_REG(FTM1)
#define FTM1_FLTPOL                              FTM_FLTPOL_REG(FTM1)
#define FTM1_SYNCONF                             FTM_SYNCONF_REG(FTM1)
#define FTM1_INVCTRL                             FTM_INVCTRL_REG(FTM1)
#define FTM1_SWOCTRL                             FTM_SWOCTRL_REG(FTM1)
#define FTM1_PWMLOAD                             FTM_PWMLOAD_REG(FTM1)
/* FTM2 */
#define FTM2_SC                                  FTM_SC_REG(FTM2)
#define FTM2_CNT                                 FTM_CNT_REG(FTM2)
#define FTM2_MOD                                 FTM_MOD_REG(FTM2)
#define FTM2_C0SC                                FTM_CnSC_REG(FTM2,0)
#define FTM2_C0V                                 FTM_CnV_REG(FTM2,0)
#define FTM2_C1SC                                FTM_CnSC_REG(FTM2,1)
#define FTM2_C1V                                 FTM_CnV_REG(FTM2,1)
#define FTM2_CNTIN                               FTM_CNTIN_REG(FTM2)
#define FTM2_STATUS                              FTM_STATUS_REG(FTM2)
#define FTM2_MODE                                FTM_MODE_REG(FTM2)
#define FTM2_SYNC                                FTM_SYNC_REG(FTM2)
#define FTM2_OUTINIT                             FTM_OUTINIT_REG(FTM2)
#define FTM2_OUTMASK                             FTM_OUTMASK_REG(FTM2)
#define FTM2_COMBINE                             FTM_COMBINE_REG(FTM2)
#define FTM2_DEADTIME                            FTM_DEADTIME_REG(FTM2)
#define FTM2_EXTTRIG                             FTM_EXTTRIG_REG(FTM2)
#define FTM2_POL                                 FTM_POL_REG(FTM2)
#define FTM2_FMS                                 FTM_FMS_REG(FTM2)
#define FTM2_FILTER                              FTM_FILTER_REG(FTM2)
#define FTM2_FLTCTRL                             FTM_FLTCTRL_REG(FTM2)
#define FTM2_QDCTRL                              FTM_QDCTRL_REG(FTM2)
#define FTM2_CONF                                FTM_CONF_REG(FTM2)
#define FTM2_FLTPOL                              FTM_FLTPOL_REG(FTM2)
#define FTM2_SYNCONF                             FTM_SYNCONF_REG(FTM2)
#define FTM2_INVCTRL                             FTM_INVCTRL_REG(FTM2)
#define FTM2_SWOCTRL                             FTM_SWOCTRL_REG(FTM2)
#define FTM2_PWMLOAD                             FTM_PWMLOAD_REG(FTM2)
/* FTM3 */
#define FTM3_SC                                  FTM_SC_REG(FTM3)
#define FTM3_CNT                                 FTM_CNT_REG(FTM3)
#define FTM3_MOD                                 FTM_MOD_REG(FTM3)
#define FTM3_C0SC                                FTM_CnSC_REG(FTM3,0)
#define FTM3_C0V                                 FTM_CnV_REG(FTM3,0)
#define FTM3_C1SC                                FTM_CnSC_REG(FTM3,1)
#define FTM3_C1V                                 FTM_CnV_REG(FTM3,1)
#define FTM3_C2SC                                FTM_CnSC_REG(FTM3,2)
#define FTM3_C2V                                 FTM_CnV_REG(FTM3,2)
#define FTM3_C3SC                                FTM_CnSC_REG(FTM3,3)
#define FTM3_C3V                                 FTM_CnV_REG(FTM3,3)
#define FTM3_C4SC                                FTM_CnSC_REG(FTM3,4)
#define FTM3_C4V                                 FTM_CnV_REG(FTM3,4)
#define FTM3_C5SC                                FTM_CnSC_REG(FTM3,5)
#define FTM3_C5V                                 FTM_CnV_REG(FTM3,5)
#define FTM3_C6SC                                FTM_CnSC_REG(FTM3,6)
#define FTM3_C6V                                 FTM_CnV_REG(FTM3,6)
#define FTM3_C7SC                                FTM_CnSC_REG(FTM3,7)
#define FTM3_C7V                                 FTM_CnV_REG(FTM3,7)
#define FTM3_CNTIN                               FTM_CNTIN_REG(FTM3)
#define FTM3_STATUS                              FTM_STATUS_REG(FTM3)
#define FTM3_MODE                                FTM_MODE_REG(FTM3)
#define FTM3_SYNC                                FTM_SYNC_REG(FTM3)
#define FTM3_OUTINIT                             FTM_OUTINIT_REG(FTM3)
#define FTM3_OUTMASK                             FTM_OUTMASK_REG(FTM3)
#define FTM3_COMBINE                             FTM_COMBINE_REG(FTM3)
#define FTM3_DEADTIME                            FTM_DEADTIME_REG(FTM3)
#define FTM3_EXTTRIG                             FTM_EXTTRIG_REG(FTM3)
#define FTM3_POL                                 FTM_POL_REG(FTM3)
#define FTM3_FMS                                 FTM_FMS_REG(FTM3)
#define FTM3_FILTER                              FTM_FILTER_REG(FTM3)
#define FTM3_FLTCTRL                             FTM_FLTCTRL_REG(FTM3)
#define FTM3_QDCTRL                              FTM_QDCTRL_REG(FTM3)
#define FTM3_CONF                                FTM_CONF_REG(FTM3)
#define FTM3_FLTPOL                              FTM_FLTPOL_REG(FTM3)
#define FTM3_SYNCONF                             FTM_SYNCONF_REG(FTM3)
#define FTM3_INVCTRL                             FTM_INVCTRL_REG(FTM3)
#define FTM3_SWOCTRL                             FTM_SWOCTRL_REG(FTM3)
#define FTM3_PWMLOAD                             FTM_PWMLOAD_REG(FTM3)

/* FTM - Register array accessors */
#define FTM0_CnSC(index)                         FTM_CnSC_REG(FTM0,index)
#define FTM1_CnSC(index)                         FTM_CnSC_REG(FTM1,index)
#define FTM2_CnSC(index)                         FTM_CnSC_REG(FTM2,index)
#define FTM3_CnSC(index)                         FTM_CnSC_REG(FTM3,index)
#define FTM0_CnV(index)                          FTM_CnV_REG(FTM0,index)
#define FTM1_CnV(index)                          FTM_CnV_REG(FTM1,index)
#define FTM2_CnV(index)                          FTM_CnV_REG(FTM2,index)
#define FTM3_CnV(index)                          FTM_CnV_REG(FTM3,index)

/*!
 * @}
 */ /* end of group FTM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FTM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __IO uint32_t PDOR;                              /**< Port Data Output Register, offset: 0x0 */
  __O  uint32_t PSOR;                              /**< Port Set Output Register, offset: 0x4 */
  __O  uint32_t PCOR;                              /**< Port Clear Output Register, offset: 0x8 */
  __O  uint32_t PTOR;                              /**< Port Toggle Output Register, offset: 0xC */
  __I  uint32_t PDIR;                              /**< Port Data Input Register, offset: 0x10 */
  __IO uint32_t PDDR;                              /**< Port Data Direction Register, offset: 0x14 */
} GPIO_Type, *GPIO_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register accessors */
#define GPIO_PDOR_REG(base)                      ((base)->PDOR)
#define GPIO_PSOR_REG(base)                      ((base)->PSOR)
#define GPIO_PCOR_REG(base)                      ((base)->PCOR)
#define GPIO_PTOR_REG(base)                      ((base)->PTOR)
#define GPIO_PDIR_REG(base)                      ((base)->PDIR)
#define GPIO_PDDR_REG(base)                      ((base)->PDDR)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/* PDOR Bit Fields */
#define GPIO_PDOR_PDO_MASK                       0xFFFFFFFFu
#define GPIO_PDOR_PDO_SHIFT                      0
#define GPIO_PDOR_PDO_WIDTH                      32
#define GPIO_PDOR_PDO(x)                         (((uint32_t)(((uint32_t)(x))<<GPIO_PDOR_PDO_SHIFT))&GPIO_PDOR_PDO_MASK)
/* PSOR Bit Fields */
#define GPIO_PSOR_PTSO_MASK                      0xFFFFFFFFu
#define GPIO_PSOR_PTSO_SHIFT                     0
#define GPIO_PSOR_PTSO_WIDTH                     32
#define GPIO_PSOR_PTSO(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_PSOR_PTSO_SHIFT))&GPIO_PSOR_PTSO_MASK)
/* PCOR Bit Fields */
#define GPIO_PCOR_PTCO_MASK                      0xFFFFFFFFu
#define GPIO_PCOR_PTCO_SHIFT                     0
#define GPIO_PCOR_PTCO_WIDTH                     32
#define GPIO_PCOR_PTCO(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_PCOR_PTCO_SHIFT))&GPIO_PCOR_PTCO_MASK)
/* PTOR Bit Fields */
#define GPIO_PTOR_PTTO_MASK                      0xFFFFFFFFu
#define GPIO_PTOR_PTTO_SHIFT                     0
#define GPIO_PTOR_PTTO_WIDTH                     32
#define GPIO_PTOR_PTTO(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_PTOR_PTTO_SHIFT))&GPIO_PTOR_PTTO_MASK)
/* PDIR Bit Fields */
#define GPIO_PDIR_PDI_MASK                       0xFFFFFFFFu
#define GPIO_PDIR_PDI_SHIFT                      0
#define GPIO_PDIR_PDI_WIDTH                      32
#define GPIO_PDIR_PDI(x)                         (((uint32_t)(((uint32_t)(x))<<GPIO_PDIR_PDI_SHIFT))&GPIO_PDIR_PDI_MASK)
/* PDDR Bit Fields */
#define GPIO_PDDR_PDD_MASK                       0xFFFFFFFFu
#define GPIO_PDDR_PDD_SHIFT                      0
#define GPIO_PDDR_PDD_WIDTH                      32
#define GPIO_PDDR_PDD(x)                         (((uint32_t)(((uint32_t)(x))<<GPIO_PDDR_PDD_SHIFT))&GPIO_PDDR_PDD_MASK)

/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIOA base address */
#define GPIOA_BASE                               (0x400FF000u)
/** Peripheral GPIOA base pointer */
#define GPIOA                                    ((GPIO_Type *)GPIOA_BASE)
#define GPIOA_BASE_PTR                           (GPIOA)
/** Peripheral GPIOB base address */
#define GPIOB_BASE                               (0x400FF040u)
/** Peripheral GPIOB base pointer */
#define GPIOB                                    ((GPIO_Type *)GPIOB_BASE)
#define GPIOB_BASE_PTR                           (GPIOB)
/** Peripheral GPIOC base address */
#define GPIOC_BASE                               (0x400FF080u)
/** Peripheral GPIOC base pointer */
#define GPIOC                                    ((GPIO_Type *)GPIOC_BASE)
#define GPIOC_BASE_PTR                           (GPIOC)
/** Peripheral GPIOD base address */
#define GPIOD_BASE                               (0x400FF0C0u)
/** Peripheral GPIOD base pointer */
#define GPIOD                                    ((GPIO_Type *)GPIOD_BASE)
#define GPIOD_BASE_PTR                           (GPIOD)
/** Peripheral GPIOE base address */
#define GPIOE_BASE                               (0x400FF100u)
/** Peripheral GPIOE base pointer */
#define GPIOE                                    ((GPIO_Type *)GPIOE_BASE)
#define GPIOE_BASE_PTR                           (GPIOE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS                          { GPIOA_BASE, GPIOB_BASE, GPIOC_BASE, GPIOD_BASE, GPIOE_BASE }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIOA, GPIOB, GPIOC, GPIOD, GPIOE }

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register instance definitions */
/* GPIOA */
#define GPIOA_PDOR                               GPIO_PDOR_REG(GPIOA)
#define GPIOA_PSOR                               GPIO_PSOR_REG(GPIOA)
#define GPIOA_PCOR                               GPIO_PCOR_REG(GPIOA)
#define GPIOA_PTOR                               GPIO_PTOR_REG(GPIOA)
#define GPIOA_PDIR                               GPIO_PDIR_REG(GPIOA)
#define GPIOA_PDDR                               GPIO_PDDR_REG(GPIOA)
/* GPIOB */
#define GPIOB_PDOR                               GPIO_PDOR_REG(GPIOB)
#define GPIOB_PSOR                               GPIO_PSOR_REG(GPIOB)
#define GPIOB_PCOR                               GPIO_PCOR_REG(GPIOB)
#define GPIOB_PTOR                               GPIO_PTOR_REG(GPIOB)
#define GPIOB_PDIR                               GPIO_PDIR_REG(GPIOB)
#define GPIOB_PDDR                               GPIO_PDDR_REG(GPIOB)
/* GPIOC */
#define GPIOC_PDOR                               GPIO_PDOR_REG(GPIOC)
#define GPIOC_PSOR                               GPIO_PSOR_REG(GPIOC)
#define GPIOC_PCOR                               GPIO_PCOR_REG(GPIOC)
#define GPIOC_PTOR                               GPIO_PTOR_REG(GPIOC)
#define GPIOC_PDIR                               GPIO_PDIR_REG(GPIOC)
#define GPIOC_PDDR                               GPIO_PDDR_REG(GPIOC)
/* GPIOD */
#define GPIOD_PDOR                               GPIO_PDOR_REG(GPIOD)
#define GPIOD_PSOR                               GPIO_PSOR_REG(GPIOD)
#define GPIOD_PCOR                               GPIO_PCOR_REG(GPIOD)
#define GPIOD_PTOR                               GPIO_PTOR_REG(GPIOD)
#define GPIOD_PDIR                               GPIO_PDIR_REG(GPIOD)
#define GPIOD_PDDR                               GPIO_PDDR_REG(GPIOD)
/* GPIOE */
#define GPIOE_PDOR                               GPIO_PDOR_REG(GPIOE)
#define GPIOE_PSOR                               GPIO_PSOR_REG(GPIOE)
#define GPIOE_PCOR                               GPIO_PCOR_REG(GPIOE)
#define GPIOE_PTOR                               GPIO_PTOR_REG(GPIOE)
#define GPIOE_PDIR                               GPIO_PDIR_REG(GPIOE)
#define GPIOE_PDDR                               GPIO_PDDR_REG(GPIOE)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- HSADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HSADC_Peripheral_Access_Layer HSADC Peripheral Access Layer
 * @{
 */

/** HSADC - Register Layout Typedef */
typedef struct {
  __IO uint16_t CTRL1;                             /**< ADC Control Register 1, offset: 0x0 */
  __IO uint16_t CTRL2;                             /**< ADC Control Register 2, offset: 0x2 */
  __IO uint16_t ZXCTRL1;                           /**< ADC Zero Crossing Control 1 Register, offset: 0x4 */
  __IO uint16_t ZXCTRL2;                           /**< ADC Zero Crossing Control 2 Register, offset: 0x6 */
  __IO uint16_t CLIST1;                            /**< ADC Channel List Register 1, offset: 0x8 */
  __IO uint16_t CLIST2;                            /**< ADC Channel List Register 2, offset: 0xA */
  __IO uint16_t CLIST3;                            /**< ADC Channel List Register 3, offset: 0xC */
  __IO uint16_t CLIST4;                            /**< ADC Channel List Register 4, offset: 0xE */
  __IO uint16_t SDIS;                              /**< ADC Sample Disable Register, offset: 0x10 */
  __IO uint16_t STAT;                              /**< ADC Status Register, offset: 0x12 */
  __I  uint16_t RDY;                               /**< ADC Ready Register, offset: 0x14 */
  __IO uint16_t LOLIMSTAT;                         /**< ADC Low Limit Status Register, offset: 0x16 */
  __IO uint16_t HILIMSTAT;                         /**< ADC High Limit Status Register, offset: 0x18 */
  __IO uint16_t ZXSTAT;                            /**< ADC Zero Crossing Status Register, offset: 0x1A */
  __IO uint16_t RSLT[16];                          /**< ADC Result Registers with sign extension, array offset: 0x1C, array step: 0x2 */
  __IO uint16_t LOLIM[16];                         /**< ADC Low Limit Registers, array offset: 0x3C, array step: 0x2 */
  __IO uint16_t HILIM[16];                         /**< ADC High Limit Registers, array offset: 0x5C, array step: 0x2 */
  __IO uint16_t OFFST[16];                         /**< ADC Offset Registers, array offset: 0x7C, array step: 0x2 */
  __IO uint16_t PWR;                               /**< ADC Power Control Register, offset: 0x9C */
       uint8_t RESERVED_0[6];
  __IO uint16_t SCTRL;                             /**< ADC Scan Control Register, offset: 0xA4 */
  __IO uint16_t PWR2;                              /**< ADC Power Control Register, offset: 0xA6 */
  __IO uint16_t CTRL3;                             /**< ADC Control Register 3, offset: 0xA8 */
  __IO uint16_t SCHLTEN;                           /**< ADC Scan Interrupt Enable Register, offset: 0xAA */
  __IO uint16_t SAMPTIM;                           /**< ADC Sampling Time Configuration Register, offset: 0xAC */
  __IO uint16_t CALIB;                             /**< ADCs Calibration Configuration, offset: 0xAE */
  __IO uint16_t CALVAL_A;                          /**< Calibration Values for ADC A Register, offset: 0xB0 */
  __IO uint16_t CALVAL_B;                          /**< Calibration Values for ADC B Register, offset: 0xB2 */
       uint8_t RESERVED_1[6];
  __IO uint16_t MUX67_SEL;                         /**< MUX6_7 Selection Controls Register, offset: 0xBA */
} HSADC_Type, *HSADC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- HSADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HSADC_Register_Accessor_Macros HSADC - Register accessor macros
 * @{
 */


/* HSADC - Register accessors */
#define HSADC_CTRL1_REG(base)                    ((base)->CTRL1)
#define HSADC_CTRL2_REG(base)                    ((base)->CTRL2)
#define HSADC_ZXCTRL1_REG(base)                  ((base)->ZXCTRL1)
#define HSADC_ZXCTRL2_REG(base)                  ((base)->ZXCTRL2)
#define HSADC_CLIST1_REG(base)                   ((base)->CLIST1)
#define HSADC_CLIST2_REG(base)                   ((base)->CLIST2)
#define HSADC_CLIST3_REG(base)                   ((base)->CLIST3)
#define HSADC_CLIST4_REG(base)                   ((base)->CLIST4)
#define HSADC_SDIS_REG(base)                     ((base)->SDIS)
#define HSADC_STAT_REG(base)                     ((base)->STAT)
#define HSADC_RDY_REG(base)                      ((base)->RDY)
#define HSADC_LOLIMSTAT_REG(base)                ((base)->LOLIMSTAT)
#define HSADC_HILIMSTAT_REG(base)                ((base)->HILIMSTAT)
#define HSADC_ZXSTAT_REG(base)                   ((base)->ZXSTAT)
#define HSADC_RSLT_REG(base,index)               ((base)->RSLT[index])
#define HSADC_RSLT_COUNT                         16
#define HSADC_LOLIM_REG(base,index)              ((base)->LOLIM[index])
#define HSADC_LOLIM_COUNT                        16
#define HSADC_HILIM_REG(base,index)              ((base)->HILIM[index])
#define HSADC_HILIM_COUNT                        16
#define HSADC_OFFST_REG(base,index)              ((base)->OFFST[index])
#define HSADC_OFFST_COUNT                        16
#define HSADC_PWR_REG(base)                      ((base)->PWR)
#define HSADC_SCTRL_REG(base)                    ((base)->SCTRL)
#define HSADC_PWR2_REG(base)                     ((base)->PWR2)
#define HSADC_CTRL3_REG(base)                    ((base)->CTRL3)
#define HSADC_SCHLTEN_REG(base)                  ((base)->SCHLTEN)
#define HSADC_SAMPTIM_REG(base)                  ((base)->SAMPTIM)
#define HSADC_CALIB_REG(base)                    ((base)->CALIB)
#define HSADC_CALVAL_A_REG(base)                 ((base)->CALVAL_A)
#define HSADC_CALVAL_B_REG(base)                 ((base)->CALVAL_B)
#define HSADC_MUX67_SEL_REG(base)                ((base)->MUX67_SEL)

/*!
 * @}
 */ /* end of group HSADC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- HSADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HSADC_Register_Masks HSADC Register Masks
 * @{
 */

/* CTRL1 Bit Fields */
#define HSADC_CTRL1_SMODE_MASK                   0x7u
#define HSADC_CTRL1_SMODE_SHIFT                  0
#define HSADC_CTRL1_SMODE_WIDTH                  3
#define HSADC_CTRL1_SMODE(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_SMODE_SHIFT))&HSADC_CTRL1_SMODE_MASK)
#define HSADC_CTRL1_CHNCFG_L_MASK                0xF0u
#define HSADC_CTRL1_CHNCFG_L_SHIFT               4
#define HSADC_CTRL1_CHNCFG_L_WIDTH               4
#define HSADC_CTRL1_CHNCFG_L(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_CHNCFG_L_SHIFT))&HSADC_CTRL1_CHNCFG_L_MASK)
#define HSADC_CTRL1_HLMTIE_MASK                  0x100u
#define HSADC_CTRL1_HLMTIE_SHIFT                 8
#define HSADC_CTRL1_HLMTIE_WIDTH                 1
#define HSADC_CTRL1_HLMTIE(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_HLMTIE_SHIFT))&HSADC_CTRL1_HLMTIE_MASK)
#define HSADC_CTRL1_LLMTIE_MASK                  0x200u
#define HSADC_CTRL1_LLMTIE_SHIFT                 9
#define HSADC_CTRL1_LLMTIE_WIDTH                 1
#define HSADC_CTRL1_LLMTIE(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_LLMTIE_SHIFT))&HSADC_CTRL1_LLMTIE_MASK)
#define HSADC_CTRL1_ZCIE_MASK                    0x400u
#define HSADC_CTRL1_ZCIE_SHIFT                   10
#define HSADC_CTRL1_ZCIE_WIDTH                   1
#define HSADC_CTRL1_ZCIE(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_ZCIE_SHIFT))&HSADC_CTRL1_ZCIE_MASK)
#define HSADC_CTRL1_EOSIE0_MASK                  0x800u
#define HSADC_CTRL1_EOSIE0_SHIFT                 11
#define HSADC_CTRL1_EOSIE0_WIDTH                 1
#define HSADC_CTRL1_EOSIE0(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_EOSIE0_SHIFT))&HSADC_CTRL1_EOSIE0_MASK)
#define HSADC_CTRL1_SYNC0_MASK                   0x1000u
#define HSADC_CTRL1_SYNC0_SHIFT                  12
#define HSADC_CTRL1_SYNC0_WIDTH                  1
#define HSADC_CTRL1_SYNC0(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_SYNC0_SHIFT))&HSADC_CTRL1_SYNC0_MASK)
#define HSADC_CTRL1_START0_MASK                  0x2000u
#define HSADC_CTRL1_START0_SHIFT                 13
#define HSADC_CTRL1_START0_WIDTH                 1
#define HSADC_CTRL1_START0(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_START0_SHIFT))&HSADC_CTRL1_START0_MASK)
#define HSADC_CTRL1_STOP0_MASK                   0x4000u
#define HSADC_CTRL1_STOP0_SHIFT                  14
#define HSADC_CTRL1_STOP0_WIDTH                  1
#define HSADC_CTRL1_STOP0(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_STOP0_SHIFT))&HSADC_CTRL1_STOP0_MASK)
#define HSADC_CTRL1_DMAEN0_MASK                  0x8000u
#define HSADC_CTRL1_DMAEN0_SHIFT                 15
#define HSADC_CTRL1_DMAEN0_WIDTH                 1
#define HSADC_CTRL1_DMAEN0(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL1_DMAEN0_SHIFT))&HSADC_CTRL1_DMAEN0_MASK)
/* CTRL2 Bit Fields */
#define HSADC_CTRL2_DIV0_MASK                    0x3Fu
#define HSADC_CTRL2_DIV0_SHIFT                   0
#define HSADC_CTRL2_DIV0_WIDTH                   6
#define HSADC_CTRL2_DIV0(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_DIV0_SHIFT))&HSADC_CTRL2_DIV0_MASK)
#define HSADC_CTRL2_SIMULT_MASK                  0x40u
#define HSADC_CTRL2_SIMULT_SHIFT                 6
#define HSADC_CTRL2_SIMULT_WIDTH                 1
#define HSADC_CTRL2_SIMULT(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_SIMULT_SHIFT))&HSADC_CTRL2_SIMULT_MASK)
#define HSADC_CTRL2_CHNCFG_H_MASK                0x780u
#define HSADC_CTRL2_CHNCFG_H_SHIFT               7
#define HSADC_CTRL2_CHNCFG_H_WIDTH               4
#define HSADC_CTRL2_CHNCFG_H(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_CHNCFG_H_SHIFT))&HSADC_CTRL2_CHNCFG_H_MASK)
#define HSADC_CTRL2_EOSIE1_MASK                  0x800u
#define HSADC_CTRL2_EOSIE1_SHIFT                 11
#define HSADC_CTRL2_EOSIE1_WIDTH                 1
#define HSADC_CTRL2_EOSIE1(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_EOSIE1_SHIFT))&HSADC_CTRL2_EOSIE1_MASK)
#define HSADC_CTRL2_SYNC1_MASK                   0x1000u
#define HSADC_CTRL2_SYNC1_SHIFT                  12
#define HSADC_CTRL2_SYNC1_WIDTH                  1
#define HSADC_CTRL2_SYNC1(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_SYNC1_SHIFT))&HSADC_CTRL2_SYNC1_MASK)
#define HSADC_CTRL2_START1_MASK                  0x2000u
#define HSADC_CTRL2_START1_SHIFT                 13
#define HSADC_CTRL2_START1_WIDTH                 1
#define HSADC_CTRL2_START1(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_START1_SHIFT))&HSADC_CTRL2_START1_MASK)
#define HSADC_CTRL2_STOP1_MASK                   0x4000u
#define HSADC_CTRL2_STOP1_SHIFT                  14
#define HSADC_CTRL2_STOP1_WIDTH                  1
#define HSADC_CTRL2_STOP1(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_STOP1_SHIFT))&HSADC_CTRL2_STOP1_MASK)
#define HSADC_CTRL2_DMAEN1_MASK                  0x8000u
#define HSADC_CTRL2_DMAEN1_SHIFT                 15
#define HSADC_CTRL2_DMAEN1_WIDTH                 1
#define HSADC_CTRL2_DMAEN1(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL2_DMAEN1_SHIFT))&HSADC_CTRL2_DMAEN1_MASK)
/* ZXCTRL1 Bit Fields */
#define HSADC_ZXCTRL1_ZCE0_MASK                  0x3u
#define HSADC_ZXCTRL1_ZCE0_SHIFT                 0
#define HSADC_ZXCTRL1_ZCE0_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE0(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE0_SHIFT))&HSADC_ZXCTRL1_ZCE0_MASK)
#define HSADC_ZXCTRL1_ZCE1_MASK                  0xCu
#define HSADC_ZXCTRL1_ZCE1_SHIFT                 2
#define HSADC_ZXCTRL1_ZCE1_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE1(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE1_SHIFT))&HSADC_ZXCTRL1_ZCE1_MASK)
#define HSADC_ZXCTRL1_ZCE2_MASK                  0x30u
#define HSADC_ZXCTRL1_ZCE2_SHIFT                 4
#define HSADC_ZXCTRL1_ZCE2_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE2(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE2_SHIFT))&HSADC_ZXCTRL1_ZCE2_MASK)
#define HSADC_ZXCTRL1_ZCE3_MASK                  0xC0u
#define HSADC_ZXCTRL1_ZCE3_SHIFT                 6
#define HSADC_ZXCTRL1_ZCE3_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE3(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE3_SHIFT))&HSADC_ZXCTRL1_ZCE3_MASK)
#define HSADC_ZXCTRL1_ZCE4_MASK                  0x300u
#define HSADC_ZXCTRL1_ZCE4_SHIFT                 8
#define HSADC_ZXCTRL1_ZCE4_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE4(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE4_SHIFT))&HSADC_ZXCTRL1_ZCE4_MASK)
#define HSADC_ZXCTRL1_ZCE5_MASK                  0xC00u
#define HSADC_ZXCTRL1_ZCE5_SHIFT                 10
#define HSADC_ZXCTRL1_ZCE5_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE5(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE5_SHIFT))&HSADC_ZXCTRL1_ZCE5_MASK)
#define HSADC_ZXCTRL1_ZCE6_MASK                  0x3000u
#define HSADC_ZXCTRL1_ZCE6_SHIFT                 12
#define HSADC_ZXCTRL1_ZCE6_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE6(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE6_SHIFT))&HSADC_ZXCTRL1_ZCE6_MASK)
#define HSADC_ZXCTRL1_ZCE7_MASK                  0xC000u
#define HSADC_ZXCTRL1_ZCE7_SHIFT                 14
#define HSADC_ZXCTRL1_ZCE7_WIDTH                 2
#define HSADC_ZXCTRL1_ZCE7(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL1_ZCE7_SHIFT))&HSADC_ZXCTRL1_ZCE7_MASK)
/* ZXCTRL2 Bit Fields */
#define HSADC_ZXCTRL2_ZCE8_MASK                  0x3u
#define HSADC_ZXCTRL2_ZCE8_SHIFT                 0
#define HSADC_ZXCTRL2_ZCE8_WIDTH                 2
#define HSADC_ZXCTRL2_ZCE8(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE8_SHIFT))&HSADC_ZXCTRL2_ZCE8_MASK)
#define HSADC_ZXCTRL2_ZCE9_MASK                  0xCu
#define HSADC_ZXCTRL2_ZCE9_SHIFT                 2
#define HSADC_ZXCTRL2_ZCE9_WIDTH                 2
#define HSADC_ZXCTRL2_ZCE9(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE9_SHIFT))&HSADC_ZXCTRL2_ZCE9_MASK)
#define HSADC_ZXCTRL2_ZCE10_MASK                 0x30u
#define HSADC_ZXCTRL2_ZCE10_SHIFT                4
#define HSADC_ZXCTRL2_ZCE10_WIDTH                2
#define HSADC_ZXCTRL2_ZCE10(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE10_SHIFT))&HSADC_ZXCTRL2_ZCE10_MASK)
#define HSADC_ZXCTRL2_ZCE11_MASK                 0xC0u
#define HSADC_ZXCTRL2_ZCE11_SHIFT                6
#define HSADC_ZXCTRL2_ZCE11_WIDTH                2
#define HSADC_ZXCTRL2_ZCE11(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE11_SHIFT))&HSADC_ZXCTRL2_ZCE11_MASK)
#define HSADC_ZXCTRL2_ZCE12_MASK                 0x300u
#define HSADC_ZXCTRL2_ZCE12_SHIFT                8
#define HSADC_ZXCTRL2_ZCE12_WIDTH                2
#define HSADC_ZXCTRL2_ZCE12(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE12_SHIFT))&HSADC_ZXCTRL2_ZCE12_MASK)
#define HSADC_ZXCTRL2_ZCE13_MASK                 0xC00u
#define HSADC_ZXCTRL2_ZCE13_SHIFT                10
#define HSADC_ZXCTRL2_ZCE13_WIDTH                2
#define HSADC_ZXCTRL2_ZCE13(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE13_SHIFT))&HSADC_ZXCTRL2_ZCE13_MASK)
#define HSADC_ZXCTRL2_ZCE14_MASK                 0x3000u
#define HSADC_ZXCTRL2_ZCE14_SHIFT                12
#define HSADC_ZXCTRL2_ZCE14_WIDTH                2
#define HSADC_ZXCTRL2_ZCE14(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE14_SHIFT))&HSADC_ZXCTRL2_ZCE14_MASK)
#define HSADC_ZXCTRL2_ZCE15_MASK                 0xC000u
#define HSADC_ZXCTRL2_ZCE15_SHIFT                14
#define HSADC_ZXCTRL2_ZCE15_WIDTH                2
#define HSADC_ZXCTRL2_ZCE15(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_ZXCTRL2_ZCE15_SHIFT))&HSADC_ZXCTRL2_ZCE15_MASK)
/* CLIST1 Bit Fields */
#define HSADC_CLIST1_SAMPLE0_MASK                0xFu
#define HSADC_CLIST1_SAMPLE0_SHIFT               0
#define HSADC_CLIST1_SAMPLE0_WIDTH               4
#define HSADC_CLIST1_SAMPLE0(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST1_SAMPLE0_SHIFT))&HSADC_CLIST1_SAMPLE0_MASK)
#define HSADC_CLIST1_SAMPLE1_MASK                0xF0u
#define HSADC_CLIST1_SAMPLE1_SHIFT               4
#define HSADC_CLIST1_SAMPLE1_WIDTH               4
#define HSADC_CLIST1_SAMPLE1(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST1_SAMPLE1_SHIFT))&HSADC_CLIST1_SAMPLE1_MASK)
#define HSADC_CLIST1_SAMPLE2_MASK                0xF00u
#define HSADC_CLIST1_SAMPLE2_SHIFT               8
#define HSADC_CLIST1_SAMPLE2_WIDTH               4
#define HSADC_CLIST1_SAMPLE2(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST1_SAMPLE2_SHIFT))&HSADC_CLIST1_SAMPLE2_MASK)
#define HSADC_CLIST1_SAMPLE3_MASK                0xF000u
#define HSADC_CLIST1_SAMPLE3_SHIFT               12
#define HSADC_CLIST1_SAMPLE3_WIDTH               4
#define HSADC_CLIST1_SAMPLE3(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST1_SAMPLE3_SHIFT))&HSADC_CLIST1_SAMPLE3_MASK)
/* CLIST2 Bit Fields */
#define HSADC_CLIST2_SAMPLE4_MASK                0xFu
#define HSADC_CLIST2_SAMPLE4_SHIFT               0
#define HSADC_CLIST2_SAMPLE4_WIDTH               4
#define HSADC_CLIST2_SAMPLE4(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST2_SAMPLE4_SHIFT))&HSADC_CLIST2_SAMPLE4_MASK)
#define HSADC_CLIST2_SAMPLE5_MASK                0xF0u
#define HSADC_CLIST2_SAMPLE5_SHIFT               4
#define HSADC_CLIST2_SAMPLE5_WIDTH               4
#define HSADC_CLIST2_SAMPLE5(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST2_SAMPLE5_SHIFT))&HSADC_CLIST2_SAMPLE5_MASK)
#define HSADC_CLIST2_SAMPLE6_MASK                0xF00u
#define HSADC_CLIST2_SAMPLE6_SHIFT               8
#define HSADC_CLIST2_SAMPLE6_WIDTH               4
#define HSADC_CLIST2_SAMPLE6(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST2_SAMPLE6_SHIFT))&HSADC_CLIST2_SAMPLE6_MASK)
#define HSADC_CLIST2_SAMPLE7_MASK                0xF000u
#define HSADC_CLIST2_SAMPLE7_SHIFT               12
#define HSADC_CLIST2_SAMPLE7_WIDTH               4
#define HSADC_CLIST2_SAMPLE7(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST2_SAMPLE7_SHIFT))&HSADC_CLIST2_SAMPLE7_MASK)
/* CLIST3 Bit Fields */
#define HSADC_CLIST3_SAMPLE8_MASK                0xFu
#define HSADC_CLIST3_SAMPLE8_SHIFT               0
#define HSADC_CLIST3_SAMPLE8_WIDTH               4
#define HSADC_CLIST3_SAMPLE8(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST3_SAMPLE8_SHIFT))&HSADC_CLIST3_SAMPLE8_MASK)
#define HSADC_CLIST3_SAMPLE9_MASK                0xF0u
#define HSADC_CLIST3_SAMPLE9_SHIFT               4
#define HSADC_CLIST3_SAMPLE9_WIDTH               4
#define HSADC_CLIST3_SAMPLE9(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST3_SAMPLE9_SHIFT))&HSADC_CLIST3_SAMPLE9_MASK)
#define HSADC_CLIST3_SAMPLE10_MASK               0xF00u
#define HSADC_CLIST3_SAMPLE10_SHIFT              8
#define HSADC_CLIST3_SAMPLE10_WIDTH              4
#define HSADC_CLIST3_SAMPLE10(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST3_SAMPLE10_SHIFT))&HSADC_CLIST3_SAMPLE10_MASK)
#define HSADC_CLIST3_SAMPLE11_MASK               0xF000u
#define HSADC_CLIST3_SAMPLE11_SHIFT              12
#define HSADC_CLIST3_SAMPLE11_WIDTH              4
#define HSADC_CLIST3_SAMPLE11(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST3_SAMPLE11_SHIFT))&HSADC_CLIST3_SAMPLE11_MASK)
/* CLIST4 Bit Fields */
#define HSADC_CLIST4_SAMPLE12_MASK               0xFu
#define HSADC_CLIST4_SAMPLE12_SHIFT              0
#define HSADC_CLIST4_SAMPLE12_WIDTH              4
#define HSADC_CLIST4_SAMPLE12(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST4_SAMPLE12_SHIFT))&HSADC_CLIST4_SAMPLE12_MASK)
#define HSADC_CLIST4_SAMPLE13_MASK               0xF0u
#define HSADC_CLIST4_SAMPLE13_SHIFT              4
#define HSADC_CLIST4_SAMPLE13_WIDTH              4
#define HSADC_CLIST4_SAMPLE13(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST4_SAMPLE13_SHIFT))&HSADC_CLIST4_SAMPLE13_MASK)
#define HSADC_CLIST4_SAMPLE14_MASK               0xF00u
#define HSADC_CLIST4_SAMPLE14_SHIFT              8
#define HSADC_CLIST4_SAMPLE14_WIDTH              4
#define HSADC_CLIST4_SAMPLE14(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST4_SAMPLE14_SHIFT))&HSADC_CLIST4_SAMPLE14_MASK)
#define HSADC_CLIST4_SAMPLE15_MASK               0xF000u
#define HSADC_CLIST4_SAMPLE15_SHIFT              12
#define HSADC_CLIST4_SAMPLE15_WIDTH              4
#define HSADC_CLIST4_SAMPLE15(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_CLIST4_SAMPLE15_SHIFT))&HSADC_CLIST4_SAMPLE15_MASK)
/* SDIS Bit Fields */
#define HSADC_SDIS_DS_MASK                       0xFFFFu
#define HSADC_SDIS_DS_SHIFT                      0
#define HSADC_SDIS_DS_WIDTH                      16
#define HSADC_SDIS_DS(x)                         (((uint16_t)(((uint16_t)(x))<<HSADC_SDIS_DS_SHIFT))&HSADC_SDIS_DS_MASK)
/* STAT Bit Fields */
#define HSADC_STAT_CALON0_MASK                   0x1u
#define HSADC_STAT_CALON0_SHIFT                  0
#define HSADC_STAT_CALON0_WIDTH                  1
#define HSADC_STAT_CALON0(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_CALON0_SHIFT))&HSADC_STAT_CALON0_MASK)
#define HSADC_STAT_CALON1_MASK                   0x2u
#define HSADC_STAT_CALON1_SHIFT                  1
#define HSADC_STAT_CALON1_WIDTH                  1
#define HSADC_STAT_CALON1(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_CALON1_SHIFT))&HSADC_STAT_CALON1_MASK)
#define HSADC_STAT_DUMMY0_MASK                   0x4u
#define HSADC_STAT_DUMMY0_SHIFT                  2
#define HSADC_STAT_DUMMY0_WIDTH                  1
#define HSADC_STAT_DUMMY0(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_DUMMY0_SHIFT))&HSADC_STAT_DUMMY0_MASK)
#define HSADC_STAT_DUMMY1_MASK                   0x8u
#define HSADC_STAT_DUMMY1_SHIFT                  3
#define HSADC_STAT_DUMMY1_WIDTH                  1
#define HSADC_STAT_DUMMY1(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_DUMMY1_SHIFT))&HSADC_STAT_DUMMY1_MASK)
#define HSADC_STAT_EOCALI0_MASK                  0x10u
#define HSADC_STAT_EOCALI0_SHIFT                 4
#define HSADC_STAT_EOCALI0_WIDTH                 1
#define HSADC_STAT_EOCALI0(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_EOCALI0_SHIFT))&HSADC_STAT_EOCALI0_MASK)
#define HSADC_STAT_EOCALI1_MASK                  0x20u
#define HSADC_STAT_EOCALI1_SHIFT                 5
#define HSADC_STAT_EOCALI1_WIDTH                 1
#define HSADC_STAT_EOCALI1(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_EOCALI1_SHIFT))&HSADC_STAT_EOCALI1_MASK)
#define HSADC_STAT_HLMTI_MASK                    0x100u
#define HSADC_STAT_HLMTI_SHIFT                   8
#define HSADC_STAT_HLMTI_WIDTH                   1
#define HSADC_STAT_HLMTI(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_HLMTI_SHIFT))&HSADC_STAT_HLMTI_MASK)
#define HSADC_STAT_LLMTI_MASK                    0x200u
#define HSADC_STAT_LLMTI_SHIFT                   9
#define HSADC_STAT_LLMTI_WIDTH                   1
#define HSADC_STAT_LLMTI(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_LLMTI_SHIFT))&HSADC_STAT_LLMTI_MASK)
#define HSADC_STAT_ZCI_MASK                      0x400u
#define HSADC_STAT_ZCI_SHIFT                     10
#define HSADC_STAT_ZCI_WIDTH                     1
#define HSADC_STAT_ZCI(x)                        (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_ZCI_SHIFT))&HSADC_STAT_ZCI_MASK)
#define HSADC_STAT_EOSI0_MASK                    0x800u
#define HSADC_STAT_EOSI0_SHIFT                   11
#define HSADC_STAT_EOSI0_WIDTH                   1
#define HSADC_STAT_EOSI0(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_EOSI0_SHIFT))&HSADC_STAT_EOSI0_MASK)
#define HSADC_STAT_EOSI1_MASK                    0x1000u
#define HSADC_STAT_EOSI1_SHIFT                   12
#define HSADC_STAT_EOSI1_WIDTH                   1
#define HSADC_STAT_EOSI1(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_EOSI1_SHIFT))&HSADC_STAT_EOSI1_MASK)
#define HSADC_STAT_CIP1_MASK                     0x4000u
#define HSADC_STAT_CIP1_SHIFT                    14
#define HSADC_STAT_CIP1_WIDTH                    1
#define HSADC_STAT_CIP1(x)                       (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_CIP1_SHIFT))&HSADC_STAT_CIP1_MASK)
#define HSADC_STAT_CIP0_MASK                     0x8000u
#define HSADC_STAT_CIP0_SHIFT                    15
#define HSADC_STAT_CIP0_WIDTH                    1
#define HSADC_STAT_CIP0(x)                       (((uint16_t)(((uint16_t)(x))<<HSADC_STAT_CIP0_SHIFT))&HSADC_STAT_CIP0_MASK)
/* RDY Bit Fields */
#define HSADC_RDY_RDY_MASK                       0xFFFFu
#define HSADC_RDY_RDY_SHIFT                      0
#define HSADC_RDY_RDY_WIDTH                      16
#define HSADC_RDY_RDY(x)                         (((uint16_t)(((uint16_t)(x))<<HSADC_RDY_RDY_SHIFT))&HSADC_RDY_RDY_MASK)
/* LOLIMSTAT Bit Fields */
#define HSADC_LOLIMSTAT_LLS_MASK                 0xFFFFu
#define HSADC_LOLIMSTAT_LLS_SHIFT                0
#define HSADC_LOLIMSTAT_LLS_WIDTH                16
#define HSADC_LOLIMSTAT_LLS(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_LOLIMSTAT_LLS_SHIFT))&HSADC_LOLIMSTAT_LLS_MASK)
/* HILIMSTAT Bit Fields */
#define HSADC_HILIMSTAT_HLS_MASK                 0xFFFFu
#define HSADC_HILIMSTAT_HLS_SHIFT                0
#define HSADC_HILIMSTAT_HLS_WIDTH                16
#define HSADC_HILIMSTAT_HLS(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_HILIMSTAT_HLS_SHIFT))&HSADC_HILIMSTAT_HLS_MASK)
/* ZXSTAT Bit Fields */
#define HSADC_ZXSTAT_ZCS_MASK                    0xFFFFu
#define HSADC_ZXSTAT_ZCS_SHIFT                   0
#define HSADC_ZXSTAT_ZCS_WIDTH                   16
#define HSADC_ZXSTAT_ZCS(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_ZXSTAT_ZCS_SHIFT))&HSADC_ZXSTAT_ZCS_MASK)
/* RSLT Bit Fields */
#define HSADC_RSLT_RSLT_MASK                     0x7FF8u
#define HSADC_RSLT_RSLT_SHIFT                    3
#define HSADC_RSLT_RSLT_WIDTH                    12
#define HSADC_RSLT_RSLT(x)                       (((uint16_t)(((uint16_t)(x))<<HSADC_RSLT_RSLT_SHIFT))&HSADC_RSLT_RSLT_MASK)
#define HSADC_RSLT_SEXT_MASK                     0x8000u
#define HSADC_RSLT_SEXT_SHIFT                    15
#define HSADC_RSLT_SEXT_WIDTH                    1
#define HSADC_RSLT_SEXT(x)                       (((uint16_t)(((uint16_t)(x))<<HSADC_RSLT_SEXT_SHIFT))&HSADC_RSLT_SEXT_MASK)
/* LOLIM Bit Fields */
#define HSADC_LOLIM_LLMT_MASK                    0x7FF8u
#define HSADC_LOLIM_LLMT_SHIFT                   3
#define HSADC_LOLIM_LLMT_WIDTH                   12
#define HSADC_LOLIM_LLMT(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_LOLIM_LLMT_SHIFT))&HSADC_LOLIM_LLMT_MASK)
/* HILIM Bit Fields */
#define HSADC_HILIM_HLMT_MASK                    0x7FF8u
#define HSADC_HILIM_HLMT_SHIFT                   3
#define HSADC_HILIM_HLMT_WIDTH                   12
#define HSADC_HILIM_HLMT(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_HILIM_HLMT_SHIFT))&HSADC_HILIM_HLMT_MASK)
/* OFFST Bit Fields */
#define HSADC_OFFST_OFFSET_MASK                  0x7FF8u
#define HSADC_OFFST_OFFSET_SHIFT                 3
#define HSADC_OFFST_OFFSET_WIDTH                 12
#define HSADC_OFFST_OFFSET(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_OFFST_OFFSET_SHIFT))&HSADC_OFFST_OFFSET_MASK)
/* PWR Bit Fields */
#define HSADC_PWR_PD0_MASK                       0x1u
#define HSADC_PWR_PD0_SHIFT                      0
#define HSADC_PWR_PD0_WIDTH                      1
#define HSADC_PWR_PD0(x)                         (((uint16_t)(((uint16_t)(x))<<HSADC_PWR_PD0_SHIFT))&HSADC_PWR_PD0_MASK)
#define HSADC_PWR_PD1_MASK                       0x2u
#define HSADC_PWR_PD1_SHIFT                      1
#define HSADC_PWR_PD1_WIDTH                      1
#define HSADC_PWR_PD1(x)                         (((uint16_t)(((uint16_t)(x))<<HSADC_PWR_PD1_SHIFT))&HSADC_PWR_PD1_MASK)
#define HSADC_PWR_APD_MASK                       0x8u
#define HSADC_PWR_APD_SHIFT                      3
#define HSADC_PWR_APD_WIDTH                      1
#define HSADC_PWR_APD(x)                         (((uint16_t)(((uint16_t)(x))<<HSADC_PWR_APD_SHIFT))&HSADC_PWR_APD_MASK)
#define HSADC_PWR_PUDELAY_MASK                   0x3F0u
#define HSADC_PWR_PUDELAY_SHIFT                  4
#define HSADC_PWR_PUDELAY_WIDTH                  6
#define HSADC_PWR_PUDELAY(x)                     (((uint16_t)(((uint16_t)(x))<<HSADC_PWR_PUDELAY_SHIFT))&HSADC_PWR_PUDELAY_MASK)
#define HSADC_PWR_PSTS0_MASK                     0x400u
#define HSADC_PWR_PSTS0_SHIFT                    10
#define HSADC_PWR_PSTS0_WIDTH                    1
#define HSADC_PWR_PSTS0(x)                       (((uint16_t)(((uint16_t)(x))<<HSADC_PWR_PSTS0_SHIFT))&HSADC_PWR_PSTS0_MASK)
#define HSADC_PWR_PSTS1_MASK                     0x800u
#define HSADC_PWR_PSTS1_SHIFT                    11
#define HSADC_PWR_PSTS1_WIDTH                    1
#define HSADC_PWR_PSTS1(x)                       (((uint16_t)(((uint16_t)(x))<<HSADC_PWR_PSTS1_SHIFT))&HSADC_PWR_PSTS1_MASK)
#define HSADC_PWR_ASB_MASK                       0x8000u
#define HSADC_PWR_ASB_SHIFT                      15
#define HSADC_PWR_ASB_WIDTH                      1
#define HSADC_PWR_ASB(x)                         (((uint16_t)(((uint16_t)(x))<<HSADC_PWR_ASB_SHIFT))&HSADC_PWR_ASB_MASK)
/* SCTRL Bit Fields */
#define HSADC_SCTRL_SC_MASK                      0xFFFFu
#define HSADC_SCTRL_SC_SHIFT                     0
#define HSADC_SCTRL_SC_WIDTH                     16
#define HSADC_SCTRL_SC(x)                        (((uint16_t)(((uint16_t)(x))<<HSADC_SCTRL_SC_SHIFT))&HSADC_SCTRL_SC_MASK)
/* PWR2 Bit Fields */
#define HSADC_PWR2_DIV1_MASK                     0x3F00u
#define HSADC_PWR2_DIV1_SHIFT                    8
#define HSADC_PWR2_DIV1_WIDTH                    6
#define HSADC_PWR2_DIV1(x)                       (((uint16_t)(((uint16_t)(x))<<HSADC_PWR2_DIV1_SHIFT))&HSADC_PWR2_DIV1_MASK)
/* CTRL3 Bit Fields */
#define HSADC_CTRL3_DMASRC_MASK                  0x40u
#define HSADC_CTRL3_DMASRC_SHIFT                 6
#define HSADC_CTRL3_DMASRC_WIDTH                 1
#define HSADC_CTRL3_DMASRC(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL3_DMASRC_SHIFT))&HSADC_CTRL3_DMASRC_MASK)
#define HSADC_CTRL3_ADCRES_MASK                  0x300u
#define HSADC_CTRL3_ADCRES_SHIFT                 8
#define HSADC_CTRL3_ADCRES_WIDTH                 2
#define HSADC_CTRL3_ADCRES(x)                    (((uint16_t)(((uint16_t)(x))<<HSADC_CTRL3_ADCRES_SHIFT))&HSADC_CTRL3_ADCRES_MASK)
/* SCHLTEN Bit Fields */
#define HSADC_SCHLTEN_SCHLTEN_MASK               0xFFFFu
#define HSADC_SCHLTEN_SCHLTEN_SHIFT              0
#define HSADC_SCHLTEN_SCHLTEN_WIDTH              16
#define HSADC_SCHLTEN_SCHLTEN(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_SCHLTEN_SCHLTEN_SHIFT))&HSADC_SCHLTEN_SCHLTEN_MASK)
/* SAMPTIM Bit Fields */
#define HSADC_SAMPTIM_SAMPT_A_MASK               0xFFu
#define HSADC_SAMPTIM_SAMPT_A_SHIFT              0
#define HSADC_SAMPTIM_SAMPT_A_WIDTH              8
#define HSADC_SAMPTIM_SAMPT_A(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_SAMPTIM_SAMPT_A_SHIFT))&HSADC_SAMPTIM_SAMPT_A_MASK)
#define HSADC_SAMPTIM_SAMPT_B_MASK               0xFF00u
#define HSADC_SAMPTIM_SAMPT_B_SHIFT              8
#define HSADC_SAMPTIM_SAMPT_B_WIDTH              8
#define HSADC_SAMPTIM_SAMPT_B(x)                 (((uint16_t)(((uint16_t)(x))<<HSADC_SAMPTIM_SAMPT_B_SHIFT))&HSADC_SAMPTIM_SAMPT_B_MASK)
/* CALIB Bit Fields */
#define HSADC_CALIB_REQSINGA_MASK                0x1u
#define HSADC_CALIB_REQSINGA_SHIFT               0
#define HSADC_CALIB_REQSINGA_WIDTH               1
#define HSADC_CALIB_REQSINGA(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_REQSINGA_SHIFT))&HSADC_CALIB_REQSINGA_MASK)
#define HSADC_CALIB_REQDIFA_MASK                 0x2u
#define HSADC_CALIB_REQDIFA_SHIFT                1
#define HSADC_CALIB_REQDIFA_WIDTH                1
#define HSADC_CALIB_REQDIFA(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_REQDIFA_SHIFT))&HSADC_CALIB_REQDIFA_MASK)
#define HSADC_CALIB_BYPA_MASK                    0x4u
#define HSADC_CALIB_BYPA_SHIFT                   2
#define HSADC_CALIB_BYPA_WIDTH                   1
#define HSADC_CALIB_BYPA(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_BYPA_SHIFT))&HSADC_CALIB_BYPA_MASK)
#define HSADC_CALIB_CAL_REQA_MASK                0x8u
#define HSADC_CALIB_CAL_REQA_SHIFT               3
#define HSADC_CALIB_CAL_REQA_WIDTH               1
#define HSADC_CALIB_CAL_REQA(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_CAL_REQA_SHIFT))&HSADC_CALIB_CAL_REQA_MASK)
#define HSADC_CALIB_REQSINGB_MASK                0x10u
#define HSADC_CALIB_REQSINGB_SHIFT               4
#define HSADC_CALIB_REQSINGB_WIDTH               1
#define HSADC_CALIB_REQSINGB(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_REQSINGB_SHIFT))&HSADC_CALIB_REQSINGB_MASK)
#define HSADC_CALIB_REQDIFB_MASK                 0x20u
#define HSADC_CALIB_REQDIFB_SHIFT                5
#define HSADC_CALIB_REQDIFB_WIDTH                1
#define HSADC_CALIB_REQDIFB(x)                   (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_REQDIFB_SHIFT))&HSADC_CALIB_REQDIFB_MASK)
#define HSADC_CALIB_BYPB_MASK                    0x40u
#define HSADC_CALIB_BYPB_SHIFT                   6
#define HSADC_CALIB_BYPB_WIDTH                   1
#define HSADC_CALIB_BYPB(x)                      (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_BYPB_SHIFT))&HSADC_CALIB_BYPB_MASK)
#define HSADC_CALIB_CAL_REQB_MASK                0x80u
#define HSADC_CALIB_CAL_REQB_SHIFT               7
#define HSADC_CALIB_CAL_REQB_WIDTH               1
#define HSADC_CALIB_CAL_REQB(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_CAL_REQB_SHIFT))&HSADC_CALIB_CAL_REQB_MASK)
#define HSADC_CALIB_EOCALIEA_MASK                0x100u
#define HSADC_CALIB_EOCALIEA_SHIFT               8
#define HSADC_CALIB_EOCALIEA_WIDTH               1
#define HSADC_CALIB_EOCALIEA(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_EOCALIEA_SHIFT))&HSADC_CALIB_EOCALIEA_MASK)
#define HSADC_CALIB_EOCALIEB_MASK                0x200u
#define HSADC_CALIB_EOCALIEB_SHIFT               9
#define HSADC_CALIB_EOCALIEB_WIDTH               1
#define HSADC_CALIB_EOCALIEB(x)                  (((uint16_t)(((uint16_t)(x))<<HSADC_CALIB_EOCALIEB_SHIFT))&HSADC_CALIB_EOCALIEB_MASK)
/* CALVAL_A Bit Fields */
#define HSADC_CALVAL_A_CALVSING_MASK             0x7Fu
#define HSADC_CALVAL_A_CALVSING_SHIFT            0
#define HSADC_CALVAL_A_CALVSING_WIDTH            7
#define HSADC_CALVAL_A_CALVSING(x)               (((uint16_t)(((uint16_t)(x))<<HSADC_CALVAL_A_CALVSING_SHIFT))&HSADC_CALVAL_A_CALVSING_MASK)
#define HSADC_CALVAL_A_CALVDIF_MASK              0x7F00u
#define HSADC_CALVAL_A_CALVDIF_SHIFT             8
#define HSADC_CALVAL_A_CALVDIF_WIDTH             7
#define HSADC_CALVAL_A_CALVDIF(x)                (((uint16_t)(((uint16_t)(x))<<HSADC_CALVAL_A_CALVDIF_SHIFT))&HSADC_CALVAL_A_CALVDIF_MASK)
/* CALVAL_B Bit Fields */
#define HSADC_CALVAL_B_CALVSING_MASK             0x7Fu
#define HSADC_CALVAL_B_CALVSING_SHIFT            0
#define HSADC_CALVAL_B_CALVSING_WIDTH            7
#define HSADC_CALVAL_B_CALVSING(x)               (((uint16_t)(((uint16_t)(x))<<HSADC_CALVAL_B_CALVSING_SHIFT))&HSADC_CALVAL_B_CALVSING_MASK)
#define HSADC_CALVAL_B_CALVDIF_MASK              0x7F00u
#define HSADC_CALVAL_B_CALVDIF_SHIFT             8
#define HSADC_CALVAL_B_CALVDIF_WIDTH             7
#define HSADC_CALVAL_B_CALVDIF(x)                (((uint16_t)(((uint16_t)(x))<<HSADC_CALVAL_B_CALVDIF_SHIFT))&HSADC_CALVAL_B_CALVDIF_MASK)
/* MUX67_SEL Bit Fields */
#define HSADC_MUX67_SEL_CH6_SELA_MASK            0x7u
#define HSADC_MUX67_SEL_CH6_SELA_SHIFT           0
#define HSADC_MUX67_SEL_CH6_SELA_WIDTH           3
#define HSADC_MUX67_SEL_CH6_SELA(x)              (((uint16_t)(((uint16_t)(x))<<HSADC_MUX67_SEL_CH6_SELA_SHIFT))&HSADC_MUX67_SEL_CH6_SELA_MASK)
#define HSADC_MUX67_SEL_CH7_SELA_MASK            0x70u
#define HSADC_MUX67_SEL_CH7_SELA_SHIFT           4
#define HSADC_MUX67_SEL_CH7_SELA_WIDTH           3
#define HSADC_MUX67_SEL_CH7_SELA(x)              (((uint16_t)(((uint16_t)(x))<<HSADC_MUX67_SEL_CH7_SELA_SHIFT))&HSADC_MUX67_SEL_CH7_SELA_MASK)
#define HSADC_MUX67_SEL_CH6_SELB_MASK            0x700u
#define HSADC_MUX67_SEL_CH6_SELB_SHIFT           8
#define HSADC_MUX67_SEL_CH6_SELB_WIDTH           3
#define HSADC_MUX67_SEL_CH6_SELB(x)              (((uint16_t)(((uint16_t)(x))<<HSADC_MUX67_SEL_CH6_SELB_SHIFT))&HSADC_MUX67_SEL_CH6_SELB_MASK)
#define HSADC_MUX67_SEL_CH7_SELB_MASK            0x7000u
#define HSADC_MUX67_SEL_CH7_SELB_SHIFT           12
#define HSADC_MUX67_SEL_CH7_SELB_WIDTH           3
#define HSADC_MUX67_SEL_CH7_SELB(x)              (((uint16_t)(((uint16_t)(x))<<HSADC_MUX67_SEL_CH7_SELB_SHIFT))&HSADC_MUX67_SEL_CH7_SELB_MASK)

/*!
 * @}
 */ /* end of group HSADC_Register_Masks */


/* HSADC - Peripheral instance base addresses */
/** Peripheral HSADC0 base address */
#define HSADC0_BASE                              (0x800B8000u)
/** Peripheral HSADC0 base pointer */
#define HSADC0                                   ((HSADC_Type *)HSADC0_BASE)
#define HSADC0_BASE_PTR                          (HSADC0)
/** Peripheral HSADC1 base address */
#define HSADC1_BASE                              (0x801B8000u)
/** Peripheral HSADC1 base pointer */
#define HSADC1                                   ((HSADC_Type *)HSADC1_BASE)
#define HSADC1_BASE_PTR                          (HSADC1)
/** Array initializer of HSADC peripheral base addresses */
#define HSADC_BASE_ADDRS                         { HSADC0_BASE, HSADC1_BASE }
/** Array initializer of HSADC peripheral base pointers */
#define HSADC_BASE_PTRS                          { HSADC0, HSADC1 }

/* ----------------------------------------------------------------------------
   -- HSADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HSADC_Register_Accessor_Macros HSADC - Register accessor macros
 * @{
 */


/* HSADC - Register instance definitions */
/* HSADC0 */
#define HSADC0_CTRL1                             HSADC_CTRL1_REG(HSADC0)
#define HSADC0_CTRL2                             HSADC_CTRL2_REG(HSADC0)
#define HSADC0_ZXCTRL1                           HSADC_ZXCTRL1_REG(HSADC0)
#define HSADC0_ZXCTRL2                           HSADC_ZXCTRL2_REG(HSADC0)
#define HSADC0_CLIST1                            HSADC_CLIST1_REG(HSADC0)
#define HSADC0_CLIST2                            HSADC_CLIST2_REG(HSADC0)
#define HSADC0_CLIST3                            HSADC_CLIST3_REG(HSADC0)
#define HSADC0_CLIST4                            HSADC_CLIST4_REG(HSADC0)
#define HSADC0_SDIS                              HSADC_SDIS_REG(HSADC0)
#define HSADC0_STAT                              HSADC_STAT_REG(HSADC0)
#define HSADC0_RDY                               HSADC_RDY_REG(HSADC0)
#define HSADC0_LOLIMSTAT                         HSADC_LOLIMSTAT_REG(HSADC0)
#define HSADC0_HILIMSTAT                         HSADC_HILIMSTAT_REG(HSADC0)
#define HSADC0_ZXSTAT                            HSADC_ZXSTAT_REG(HSADC0)
#define HSADC0_RSLT0                             HSADC_RSLT_REG(HSADC0,0)
#define HSADC0_RSLT1                             HSADC_RSLT_REG(HSADC0,1)
#define HSADC0_RSLT2                             HSADC_RSLT_REG(HSADC0,2)
#define HSADC0_RSLT3                             HSADC_RSLT_REG(HSADC0,3)
#define HSADC0_RSLT4                             HSADC_RSLT_REG(HSADC0,4)
#define HSADC0_RSLT5                             HSADC_RSLT_REG(HSADC0,5)
#define HSADC0_RSLT6                             HSADC_RSLT_REG(HSADC0,6)
#define HSADC0_RSLT7                             HSADC_RSLT_REG(HSADC0,7)
#define HSADC0_RSLT8                             HSADC_RSLT_REG(HSADC0,8)
#define HSADC0_RSLT9                             HSADC_RSLT_REG(HSADC0,9)
#define HSADC0_RSLT10                            HSADC_RSLT_REG(HSADC0,10)
#define HSADC0_RSLT11                            HSADC_RSLT_REG(HSADC0,11)
#define HSADC0_RSLT12                            HSADC_RSLT_REG(HSADC0,12)
#define HSADC0_RSLT13                            HSADC_RSLT_REG(HSADC0,13)
#define HSADC0_RSLT14                            HSADC_RSLT_REG(HSADC0,14)
#define HSADC0_RSLT15                            HSADC_RSLT_REG(HSADC0,15)
#define HSADC0_LOLIM0                            HSADC_LOLIM_REG(HSADC0,0)
#define HSADC0_LOLIM1                            HSADC_LOLIM_REG(HSADC0,1)
#define HSADC0_LOLIM2                            HSADC_LOLIM_REG(HSADC0,2)
#define HSADC0_LOLIM3                            HSADC_LOLIM_REG(HSADC0,3)
#define HSADC0_LOLIM4                            HSADC_LOLIM_REG(HSADC0,4)
#define HSADC0_LOLIM5                            HSADC_LOLIM_REG(HSADC0,5)
#define HSADC0_LOLIM6                            HSADC_LOLIM_REG(HSADC0,6)
#define HSADC0_LOLIM7                            HSADC_LOLIM_REG(HSADC0,7)
#define HSADC0_LOLIM8                            HSADC_LOLIM_REG(HSADC0,8)
#define HSADC0_LOLIM9                            HSADC_LOLIM_REG(HSADC0,9)
#define HSADC0_LOLIM10                           HSADC_LOLIM_REG(HSADC0,10)
#define HSADC0_LOLIM11                           HSADC_LOLIM_REG(HSADC0,11)
#define HSADC0_LOLIM12                           HSADC_LOLIM_REG(HSADC0,12)
#define HSADC0_LOLIM13                           HSADC_LOLIM_REG(HSADC0,13)
#define HSADC0_LOLIM14                           HSADC_LOLIM_REG(HSADC0,14)
#define HSADC0_LOLIM15                           HSADC_LOLIM_REG(HSADC0,15)
#define HSADC0_HILIM0                            HSADC_HILIM_REG(HSADC0,0)
#define HSADC0_HILIM1                            HSADC_HILIM_REG(HSADC0,1)
#define HSADC0_HILIM2                            HSADC_HILIM_REG(HSADC0,2)
#define HSADC0_HILIM3                            HSADC_HILIM_REG(HSADC0,3)
#define HSADC0_HILIM4                            HSADC_HILIM_REG(HSADC0,4)
#define HSADC0_HILIM5                            HSADC_HILIM_REG(HSADC0,5)
#define HSADC0_HILIM6                            HSADC_HILIM_REG(HSADC0,6)
#define HSADC0_HILIM7                            HSADC_HILIM_REG(HSADC0,7)
#define HSADC0_HILIM8                            HSADC_HILIM_REG(HSADC0,8)
#define HSADC0_HILIM9                            HSADC_HILIM_REG(HSADC0,9)
#define HSADC0_HILIM10                           HSADC_HILIM_REG(HSADC0,10)
#define HSADC0_HILIM11                           HSADC_HILIM_REG(HSADC0,11)
#define HSADC0_HILIM12                           HSADC_HILIM_REG(HSADC0,12)
#define HSADC0_HILIM13                           HSADC_HILIM_REG(HSADC0,13)
#define HSADC0_HILIM14                           HSADC_HILIM_REG(HSADC0,14)
#define HSADC0_HILIM15                           HSADC_HILIM_REG(HSADC0,15)
#define HSADC0_OFFST0                            HSADC_OFFST_REG(HSADC0,0)
#define HSADC0_OFFST1                            HSADC_OFFST_REG(HSADC0,1)
#define HSADC0_OFFST2                            HSADC_OFFST_REG(HSADC0,2)
#define HSADC0_OFFST3                            HSADC_OFFST_REG(HSADC0,3)
#define HSADC0_OFFST4                            HSADC_OFFST_REG(HSADC0,4)
#define HSADC0_OFFST5                            HSADC_OFFST_REG(HSADC0,5)
#define HSADC0_OFFST6                            HSADC_OFFST_REG(HSADC0,6)
#define HSADC0_OFFST7                            HSADC_OFFST_REG(HSADC0,7)
#define HSADC0_OFFST8                            HSADC_OFFST_REG(HSADC0,8)
#define HSADC0_OFFST9                            HSADC_OFFST_REG(HSADC0,9)
#define HSADC0_OFFST10                           HSADC_OFFST_REG(HSADC0,10)
#define HSADC0_OFFST11                           HSADC_OFFST_REG(HSADC0,11)
#define HSADC0_OFFST12                           HSADC_OFFST_REG(HSADC0,12)
#define HSADC0_OFFST13                           HSADC_OFFST_REG(HSADC0,13)
#define HSADC0_OFFST14                           HSADC_OFFST_REG(HSADC0,14)
#define HSADC0_OFFST15                           HSADC_OFFST_REG(HSADC0,15)
#define HSADC0_PWR                               HSADC_PWR_REG(HSADC0)
#define HSADC0_SCTRL                             HSADC_SCTRL_REG(HSADC0)
#define HSADC0_PWR2                              HSADC_PWR2_REG(HSADC0)
#define HSADC0_CTRL3                             HSADC_CTRL3_REG(HSADC0)
#define HSADC0_SCHLTEN                           HSADC_SCHLTEN_REG(HSADC0)
#define HSADC0_SAMPTIM                           HSADC_SAMPTIM_REG(HSADC0)
#define HSADC0_CALIB                             HSADC_CALIB_REG(HSADC0)
#define HSADC0_CALVAL_A                          HSADC_CALVAL_A_REG(HSADC0)
#define HSADC0_CALVAL_B                          HSADC_CALVAL_B_REG(HSADC0)
#define HSADC0_MUX67_SEL                         HSADC_MUX67_SEL_REG(HSADC0)
/* HSADC1 */
#define HSADC1_CTRL1                             HSADC_CTRL1_REG(HSADC1)
#define HSADC1_CTRL2                             HSADC_CTRL2_REG(HSADC1)
#define HSADC1_ZXCTRL1                           HSADC_ZXCTRL1_REG(HSADC1)
#define HSADC1_ZXCTRL2                           HSADC_ZXCTRL2_REG(HSADC1)
#define HSADC1_CLIST1                            HSADC_CLIST1_REG(HSADC1)
#define HSADC1_CLIST2                            HSADC_CLIST2_REG(HSADC1)
#define HSADC1_CLIST3                            HSADC_CLIST3_REG(HSADC1)
#define HSADC1_CLIST4                            HSADC_CLIST4_REG(HSADC1)
#define HSADC1_SDIS                              HSADC_SDIS_REG(HSADC1)
#define HSADC1_STAT                              HSADC_STAT_REG(HSADC1)
#define HSADC1_RDY                               HSADC_RDY_REG(HSADC1)
#define HSADC1_LOLIMSTAT                         HSADC_LOLIMSTAT_REG(HSADC1)
#define HSADC1_HILIMSTAT                         HSADC_HILIMSTAT_REG(HSADC1)
#define HSADC1_ZXSTAT                            HSADC_ZXSTAT_REG(HSADC1)
#define HSADC1_RSLT0                             HSADC_RSLT_REG(HSADC1,0)
#define HSADC1_RSLT1                             HSADC_RSLT_REG(HSADC1,1)
#define HSADC1_RSLT2                             HSADC_RSLT_REG(HSADC1,2)
#define HSADC1_RSLT3                             HSADC_RSLT_REG(HSADC1,3)
#define HSADC1_RSLT4                             HSADC_RSLT_REG(HSADC1,4)
#define HSADC1_RSLT5                             HSADC_RSLT_REG(HSADC1,5)
#define HSADC1_RSLT6                             HSADC_RSLT_REG(HSADC1,6)
#define HSADC1_RSLT7                             HSADC_RSLT_REG(HSADC1,7)
#define HSADC1_RSLT8                             HSADC_RSLT_REG(HSADC1,8)
#define HSADC1_RSLT9                             HSADC_RSLT_REG(HSADC1,9)
#define HSADC1_RSLT10                            HSADC_RSLT_REG(HSADC1,10)
#define HSADC1_RSLT11                            HSADC_RSLT_REG(HSADC1,11)
#define HSADC1_RSLT12                            HSADC_RSLT_REG(HSADC1,12)
#define HSADC1_RSLT13                            HSADC_RSLT_REG(HSADC1,13)
#define HSADC1_RSLT14                            HSADC_RSLT_REG(HSADC1,14)
#define HSADC1_RSLT15                            HSADC_RSLT_REG(HSADC1,15)
#define HSADC1_LOLIM0                            HSADC_LOLIM_REG(HSADC1,0)
#define HSADC1_LOLIM1                            HSADC_LOLIM_REG(HSADC1,1)
#define HSADC1_LOLIM2                            HSADC_LOLIM_REG(HSADC1,2)
#define HSADC1_LOLIM3                            HSADC_LOLIM_REG(HSADC1,3)
#define HSADC1_LOLIM4                            HSADC_LOLIM_REG(HSADC1,4)
#define HSADC1_LOLIM5                            HSADC_LOLIM_REG(HSADC1,5)
#define HSADC1_LOLIM6                            HSADC_LOLIM_REG(HSADC1,6)
#define HSADC1_LOLIM7                            HSADC_LOLIM_REG(HSADC1,7)
#define HSADC1_LOLIM8                            HSADC_LOLIM_REG(HSADC1,8)
#define HSADC1_LOLIM9                            HSADC_LOLIM_REG(HSADC1,9)
#define HSADC1_LOLIM10                           HSADC_LOLIM_REG(HSADC1,10)
#define HSADC1_LOLIM11                           HSADC_LOLIM_REG(HSADC1,11)
#define HSADC1_LOLIM12                           HSADC_LOLIM_REG(HSADC1,12)
#define HSADC1_LOLIM13                           HSADC_LOLIM_REG(HSADC1,13)
#define HSADC1_LOLIM14                           HSADC_LOLIM_REG(HSADC1,14)
#define HSADC1_LOLIM15                           HSADC_LOLIM_REG(HSADC1,15)
#define HSADC1_HILIM0                            HSADC_HILIM_REG(HSADC1,0)
#define HSADC1_HILIM1                            HSADC_HILIM_REG(HSADC1,1)
#define HSADC1_HILIM2                            HSADC_HILIM_REG(HSADC1,2)
#define HSADC1_HILIM3                            HSADC_HILIM_REG(HSADC1,3)
#define HSADC1_HILIM4                            HSADC_HILIM_REG(HSADC1,4)
#define HSADC1_HILIM5                            HSADC_HILIM_REG(HSADC1,5)
#define HSADC1_HILIM6                            HSADC_HILIM_REG(HSADC1,6)
#define HSADC1_HILIM7                            HSADC_HILIM_REG(HSADC1,7)
#define HSADC1_HILIM8                            HSADC_HILIM_REG(HSADC1,8)
#define HSADC1_HILIM9                            HSADC_HILIM_REG(HSADC1,9)
#define HSADC1_HILIM10                           HSADC_HILIM_REG(HSADC1,10)
#define HSADC1_HILIM11                           HSADC_HILIM_REG(HSADC1,11)
#define HSADC1_HILIM12                           HSADC_HILIM_REG(HSADC1,12)
#define HSADC1_HILIM13                           HSADC_HILIM_REG(HSADC1,13)
#define HSADC1_HILIM14                           HSADC_HILIM_REG(HSADC1,14)
#define HSADC1_HILIM15                           HSADC_HILIM_REG(HSADC1,15)
#define HSADC1_OFFST0                            HSADC_OFFST_REG(HSADC1,0)
#define HSADC1_OFFST1                            HSADC_OFFST_REG(HSADC1,1)
#define HSADC1_OFFST2                            HSADC_OFFST_REG(HSADC1,2)
#define HSADC1_OFFST3                            HSADC_OFFST_REG(HSADC1,3)
#define HSADC1_OFFST4                            HSADC_OFFST_REG(HSADC1,4)
#define HSADC1_OFFST5                            HSADC_OFFST_REG(HSADC1,5)
#define HSADC1_OFFST6                            HSADC_OFFST_REG(HSADC1,6)
#define HSADC1_OFFST7                            HSADC_OFFST_REG(HSADC1,7)
#define HSADC1_OFFST8                            HSADC_OFFST_REG(HSADC1,8)
#define HSADC1_OFFST9                            HSADC_OFFST_REG(HSADC1,9)
#define HSADC1_OFFST10                           HSADC_OFFST_REG(HSADC1,10)
#define HSADC1_OFFST11                           HSADC_OFFST_REG(HSADC1,11)
#define HSADC1_OFFST12                           HSADC_OFFST_REG(HSADC1,12)
#define HSADC1_OFFST13                           HSADC_OFFST_REG(HSADC1,13)
#define HSADC1_OFFST14                           HSADC_OFFST_REG(HSADC1,14)
#define HSADC1_OFFST15                           HSADC_OFFST_REG(HSADC1,15)
#define HSADC1_PWR                               HSADC_PWR_REG(HSADC1)
#define HSADC1_SCTRL                             HSADC_SCTRL_REG(HSADC1)
#define HSADC1_PWR2                              HSADC_PWR2_REG(HSADC1)
#define HSADC1_CTRL3                             HSADC_CTRL3_REG(HSADC1)
#define HSADC1_SCHLTEN                           HSADC_SCHLTEN_REG(HSADC1)
#define HSADC1_SAMPTIM                           HSADC_SAMPTIM_REG(HSADC1)
#define HSADC1_CALIB                             HSADC_CALIB_REG(HSADC1)
#define HSADC1_CALVAL_A                          HSADC_CALVAL_A_REG(HSADC1)
#define HSADC1_CALVAL_B                          HSADC_CALVAL_B_REG(HSADC1)
#define HSADC1_MUX67_SEL                         HSADC_MUX67_SEL_REG(HSADC1)

/* HSADC - Register array accessors */
#define HSADC0_RSLT(index)                       HSADC_RSLT_REG(HSADC0,index)
#define HSADC1_RSLT(index)                       HSADC_RSLT_REG(HSADC1,index)
#define HSADC0_LOLIM(index)                      HSADC_LOLIM_REG(HSADC0,index)
#define HSADC1_LOLIM(index)                      HSADC_LOLIM_REG(HSADC1,index)
#define HSADC0_HILIM(index)                      HSADC_HILIM_REG(HSADC0,index)
#define HSADC1_HILIM(index)                      HSADC_HILIM_REG(HSADC1,index)
#define HSADC0_OFFST(index)                      HSADC_OFFST_REG(HSADC0,index)
#define HSADC1_OFFST(index)                      HSADC_OFFST_REG(HSADC1,index)

/*!
 * @}
 */ /* end of group HSADC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group HSADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral_Access_Layer I2C Peripheral Access Layer
 * @{
 */

/** I2C - Register Layout Typedef */
typedef struct {
  __IO uint8_t A1;                                 /**< I2C Address Register 1, offset: 0x0 */
  __IO uint8_t F;                                  /**< I2C Frequency Divider register, offset: 0x1 */
  __IO uint8_t C1;                                 /**< I2C Control Register 1, offset: 0x2 */
  __IO uint8_t S;                                  /**< I2C Status register, offset: 0x3 */
  __IO uint8_t D;                                  /**< I2C Data I/O register, offset: 0x4 */
  __IO uint8_t C2;                                 /**< I2C Control Register 2, offset: 0x5 */
  __IO uint8_t FLT;                                /**< I2C Programmable Input Glitch Filter Register, offset: 0x6 */
  __IO uint8_t RA;                                 /**< I2C Range Address register, offset: 0x7 */
  __IO uint8_t SMB;                                /**< I2C SMBus Control and Status register, offset: 0x8 */
  __IO uint8_t A2;                                 /**< I2C Address Register 2, offset: 0x9 */
  __IO uint8_t SLTH;                               /**< I2C SCL Low Timeout Register High, offset: 0xA */
  __IO uint8_t SLTL;                               /**< I2C SCL Low Timeout Register Low, offset: 0xB */
} I2C_Type, *I2C_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- I2C - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Accessor_Macros I2C - Register accessor macros
 * @{
 */


/* I2C - Register accessors */
#define I2C_A1_REG(base)                         ((base)->A1)
#define I2C_F_REG(base)                          ((base)->F)
#define I2C_C1_REG(base)                         ((base)->C1)
#define I2C_S_REG(base)                          ((base)->S)
#define I2C_D_REG(base)                          ((base)->D)
#define I2C_C2_REG(base)                         ((base)->C2)
#define I2C_FLT_REG(base)                        ((base)->FLT)
#define I2C_RA_REG(base)                         ((base)->RA)
#define I2C_SMB_REG(base)                        ((base)->SMB)
#define I2C_A2_REG(base)                         ((base)->A2)
#define I2C_SLTH_REG(base)                       ((base)->SLTH)
#define I2C_SLTL_REG(base)                       ((base)->SLTL)

/*!
 * @}
 */ /* end of group I2C_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/* A1 Bit Fields */
#define I2C_A1_AD_MASK                           0xFEu
#define I2C_A1_AD_SHIFT                          1
#define I2C_A1_AD_WIDTH                          7
#define I2C_A1_AD(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_A1_AD_SHIFT))&I2C_A1_AD_MASK)
/* F Bit Fields */
#define I2C_F_ICR_MASK                           0x3Fu
#define I2C_F_ICR_SHIFT                          0
#define I2C_F_ICR_WIDTH                          6
#define I2C_F_ICR(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_F_ICR_SHIFT))&I2C_F_ICR_MASK)
#define I2C_F_MULT_MASK                          0xC0u
#define I2C_F_MULT_SHIFT                         6
#define I2C_F_MULT_WIDTH                         2
#define I2C_F_MULT(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_F_MULT_SHIFT))&I2C_F_MULT_MASK)
/* C1 Bit Fields */
#define I2C_C1_DMAEN_MASK                        0x1u
#define I2C_C1_DMAEN_SHIFT                       0
#define I2C_C1_DMAEN_WIDTH                       1
#define I2C_C1_DMAEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C1_DMAEN_SHIFT))&I2C_C1_DMAEN_MASK)
#define I2C_C1_WUEN_MASK                         0x2u
#define I2C_C1_WUEN_SHIFT                        1
#define I2C_C1_WUEN_WIDTH                        1
#define I2C_C1_WUEN(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C1_WUEN_SHIFT))&I2C_C1_WUEN_MASK)
#define I2C_C1_RSTA_MASK                         0x4u
#define I2C_C1_RSTA_SHIFT                        2
#define I2C_C1_RSTA_WIDTH                        1
#define I2C_C1_RSTA(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C1_RSTA_SHIFT))&I2C_C1_RSTA_MASK)
#define I2C_C1_TXAK_MASK                         0x8u
#define I2C_C1_TXAK_SHIFT                        3
#define I2C_C1_TXAK_WIDTH                        1
#define I2C_C1_TXAK(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C1_TXAK_SHIFT))&I2C_C1_TXAK_MASK)
#define I2C_C1_TX_MASK                           0x10u
#define I2C_C1_TX_SHIFT                          4
#define I2C_C1_TX_WIDTH                          1
#define I2C_C1_TX(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_C1_TX_SHIFT))&I2C_C1_TX_MASK)
#define I2C_C1_MST_MASK                          0x20u
#define I2C_C1_MST_SHIFT                         5
#define I2C_C1_MST_WIDTH                         1
#define I2C_C1_MST(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_C1_MST_SHIFT))&I2C_C1_MST_MASK)
#define I2C_C1_IICIE_MASK                        0x40u
#define I2C_C1_IICIE_SHIFT                       6
#define I2C_C1_IICIE_WIDTH                       1
#define I2C_C1_IICIE(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C1_IICIE_SHIFT))&I2C_C1_IICIE_MASK)
#define I2C_C1_IICEN_MASK                        0x80u
#define I2C_C1_IICEN_SHIFT                       7
#define I2C_C1_IICEN_WIDTH                       1
#define I2C_C1_IICEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C1_IICEN_SHIFT))&I2C_C1_IICEN_MASK)
/* S Bit Fields */
#define I2C_S_RXAK_MASK                          0x1u
#define I2C_S_RXAK_SHIFT                         0
#define I2C_S_RXAK_WIDTH                         1
#define I2C_S_RXAK(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_RXAK_SHIFT))&I2C_S_RXAK_MASK)
#define I2C_S_IICIF_MASK                         0x2u
#define I2C_S_IICIF_SHIFT                        1
#define I2C_S_IICIF_WIDTH                        1
#define I2C_S_IICIF(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_S_IICIF_SHIFT))&I2C_S_IICIF_MASK)
#define I2C_S_SRW_MASK                           0x4u
#define I2C_S_SRW_SHIFT                          2
#define I2C_S_SRW_WIDTH                          1
#define I2C_S_SRW(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_S_SRW_SHIFT))&I2C_S_SRW_MASK)
#define I2C_S_RAM_MASK                           0x8u
#define I2C_S_RAM_SHIFT                          3
#define I2C_S_RAM_WIDTH                          1
#define I2C_S_RAM(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_S_RAM_SHIFT))&I2C_S_RAM_MASK)
#define I2C_S_ARBL_MASK                          0x10u
#define I2C_S_ARBL_SHIFT                         4
#define I2C_S_ARBL_WIDTH                         1
#define I2C_S_ARBL(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_ARBL_SHIFT))&I2C_S_ARBL_MASK)
#define I2C_S_BUSY_MASK                          0x20u
#define I2C_S_BUSY_SHIFT                         5
#define I2C_S_BUSY_WIDTH                         1
#define I2C_S_BUSY(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_BUSY_SHIFT))&I2C_S_BUSY_MASK)
#define I2C_S_IAAS_MASK                          0x40u
#define I2C_S_IAAS_SHIFT                         6
#define I2C_S_IAAS_WIDTH                         1
#define I2C_S_IAAS(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_IAAS_SHIFT))&I2C_S_IAAS_MASK)
#define I2C_S_TCF_MASK                           0x80u
#define I2C_S_TCF_SHIFT                          7
#define I2C_S_TCF_WIDTH                          1
#define I2C_S_TCF(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_S_TCF_SHIFT))&I2C_S_TCF_MASK)
/* D Bit Fields */
#define I2C_D_DATA_MASK                          0xFFu
#define I2C_D_DATA_SHIFT                         0
#define I2C_D_DATA_WIDTH                         8
#define I2C_D_DATA(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_D_DATA_SHIFT))&I2C_D_DATA_MASK)
/* C2 Bit Fields */
#define I2C_C2_AD_MASK                           0x7u
#define I2C_C2_AD_SHIFT                          0
#define I2C_C2_AD_WIDTH                          3
#define I2C_C2_AD(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_C2_AD_SHIFT))&I2C_C2_AD_MASK)
#define I2C_C2_RMEN_MASK                         0x8u
#define I2C_C2_RMEN_SHIFT                        3
#define I2C_C2_RMEN_WIDTH                        1
#define I2C_C2_RMEN(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C2_RMEN_SHIFT))&I2C_C2_RMEN_MASK)
#define I2C_C2_SBRC_MASK                         0x10u
#define I2C_C2_SBRC_SHIFT                        4
#define I2C_C2_SBRC_WIDTH                        1
#define I2C_C2_SBRC(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C2_SBRC_SHIFT))&I2C_C2_SBRC_MASK)
#define I2C_C2_HDRS_MASK                         0x20u
#define I2C_C2_HDRS_SHIFT                        5
#define I2C_C2_HDRS_WIDTH                        1
#define I2C_C2_HDRS(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C2_HDRS_SHIFT))&I2C_C2_HDRS_MASK)
#define I2C_C2_ADEXT_MASK                        0x40u
#define I2C_C2_ADEXT_SHIFT                       6
#define I2C_C2_ADEXT_WIDTH                       1
#define I2C_C2_ADEXT(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C2_ADEXT_SHIFT))&I2C_C2_ADEXT_MASK)
#define I2C_C2_GCAEN_MASK                        0x80u
#define I2C_C2_GCAEN_SHIFT                       7
#define I2C_C2_GCAEN_WIDTH                       1
#define I2C_C2_GCAEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C2_GCAEN_SHIFT))&I2C_C2_GCAEN_MASK)
/* FLT Bit Fields */
#define I2C_FLT_FLT_MASK                         0xFu
#define I2C_FLT_FLT_SHIFT                        0
#define I2C_FLT_FLT_WIDTH                        4
#define I2C_FLT_FLT(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_FLT_FLT_SHIFT))&I2C_FLT_FLT_MASK)
#define I2C_FLT_STARTF_MASK                      0x10u
#define I2C_FLT_STARTF_SHIFT                     4
#define I2C_FLT_STARTF_WIDTH                     1
#define I2C_FLT_STARTF(x)                        (((uint8_t)(((uint8_t)(x))<<I2C_FLT_STARTF_SHIFT))&I2C_FLT_STARTF_MASK)
#define I2C_FLT_SSIE_MASK                        0x20u
#define I2C_FLT_SSIE_SHIFT                       5
#define I2C_FLT_SSIE_WIDTH                       1
#define I2C_FLT_SSIE(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_FLT_SSIE_SHIFT))&I2C_FLT_SSIE_MASK)
#define I2C_FLT_STOPF_MASK                       0x40u
#define I2C_FLT_STOPF_SHIFT                      6
#define I2C_FLT_STOPF_WIDTH                      1
#define I2C_FLT_STOPF(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_FLT_STOPF_SHIFT))&I2C_FLT_STOPF_MASK)
#define I2C_FLT_SHEN_MASK                        0x80u
#define I2C_FLT_SHEN_SHIFT                       7
#define I2C_FLT_SHEN_WIDTH                       1
#define I2C_FLT_SHEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_FLT_SHEN_SHIFT))&I2C_FLT_SHEN_MASK)
/* RA Bit Fields */
#define I2C_RA_RAD_MASK                          0xFEu
#define I2C_RA_RAD_SHIFT                         1
#define I2C_RA_RAD_WIDTH                         7
#define I2C_RA_RAD(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_RA_RAD_SHIFT))&I2C_RA_RAD_MASK)
/* SMB Bit Fields */
#define I2C_SMB_SHTF2IE_MASK                     0x1u
#define I2C_SMB_SHTF2IE_SHIFT                    0
#define I2C_SMB_SHTF2IE_WIDTH                    1
#define I2C_SMB_SHTF2IE(x)                       (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SHTF2IE_SHIFT))&I2C_SMB_SHTF2IE_MASK)
#define I2C_SMB_SHTF2_MASK                       0x2u
#define I2C_SMB_SHTF2_SHIFT                      1
#define I2C_SMB_SHTF2_WIDTH                      1
#define I2C_SMB_SHTF2(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SHTF2_SHIFT))&I2C_SMB_SHTF2_MASK)
#define I2C_SMB_SHTF1_MASK                       0x4u
#define I2C_SMB_SHTF1_SHIFT                      2
#define I2C_SMB_SHTF1_WIDTH                      1
#define I2C_SMB_SHTF1(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SHTF1_SHIFT))&I2C_SMB_SHTF1_MASK)
#define I2C_SMB_SLTF_MASK                        0x8u
#define I2C_SMB_SLTF_SHIFT                       3
#define I2C_SMB_SLTF_WIDTH                       1
#define I2C_SMB_SLTF(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SLTF_SHIFT))&I2C_SMB_SLTF_MASK)
#define I2C_SMB_TCKSEL_MASK                      0x10u
#define I2C_SMB_TCKSEL_SHIFT                     4
#define I2C_SMB_TCKSEL_WIDTH                     1
#define I2C_SMB_TCKSEL(x)                        (((uint8_t)(((uint8_t)(x))<<I2C_SMB_TCKSEL_SHIFT))&I2C_SMB_TCKSEL_MASK)
#define I2C_SMB_SIICAEN_MASK                     0x20u
#define I2C_SMB_SIICAEN_SHIFT                    5
#define I2C_SMB_SIICAEN_WIDTH                    1
#define I2C_SMB_SIICAEN(x)                       (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SIICAEN_SHIFT))&I2C_SMB_SIICAEN_MASK)
#define I2C_SMB_ALERTEN_MASK                     0x40u
#define I2C_SMB_ALERTEN_SHIFT                    6
#define I2C_SMB_ALERTEN_WIDTH                    1
#define I2C_SMB_ALERTEN(x)                       (((uint8_t)(((uint8_t)(x))<<I2C_SMB_ALERTEN_SHIFT))&I2C_SMB_ALERTEN_MASK)
#define I2C_SMB_FACK_MASK                        0x80u
#define I2C_SMB_FACK_SHIFT                       7
#define I2C_SMB_FACK_WIDTH                       1
#define I2C_SMB_FACK(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_SMB_FACK_SHIFT))&I2C_SMB_FACK_MASK)
/* A2 Bit Fields */
#define I2C_A2_SAD_MASK                          0xFEu
#define I2C_A2_SAD_SHIFT                         1
#define I2C_A2_SAD_WIDTH                         7
#define I2C_A2_SAD(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_A2_SAD_SHIFT))&I2C_A2_SAD_MASK)
/* SLTH Bit Fields */
#define I2C_SLTH_SSLT_MASK                       0xFFu
#define I2C_SLTH_SSLT_SHIFT                      0
#define I2C_SLTH_SSLT_WIDTH                      8
#define I2C_SLTH_SSLT(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SLTH_SSLT_SHIFT))&I2C_SLTH_SSLT_MASK)
/* SLTL Bit Fields */
#define I2C_SLTL_SSLT_MASK                       0xFFu
#define I2C_SLTL_SSLT_SHIFT                      0
#define I2C_SLTL_SSLT_WIDTH                      8
#define I2C_SLTL_SSLT(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SLTL_SSLT_SHIFT))&I2C_SLTL_SSLT_MASK)

/*!
 * @}
 */ /* end of group I2C_Register_Masks */


/* I2C - Peripheral instance base addresses */
/** Peripheral I2C0 base address */
#define I2C0_BASE                                (0x40066000u)
/** Peripheral I2C0 base pointer */
#define I2C0                                     ((I2C_Type *)I2C0_BASE)
#define I2C0_BASE_PTR                            (I2C0)
/** Peripheral I2C1 base address */
#define I2C1_BASE                                (0x40067000u)
/** Peripheral I2C1 base pointer */
#define I2C1                                     ((I2C_Type *)I2C1_BASE)
#define I2C1_BASE_PTR                            (I2C1)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                           { I2C0_BASE, I2C1_BASE }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                            { I2C0, I2C1 }

/* ----------------------------------------------------------------------------
   -- I2C - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Accessor_Macros I2C - Register accessor macros
 * @{
 */


/* I2C - Register instance definitions */
/* I2C0 */
#define I2C0_A1                                  I2C_A1_REG(I2C0)
#define I2C0_F                                   I2C_F_REG(I2C0)
#define I2C0_C1                                  I2C_C1_REG(I2C0)
#define I2C0_S                                   I2C_S_REG(I2C0)
#define I2C0_D                                   I2C_D_REG(I2C0)
#define I2C0_C2                                  I2C_C2_REG(I2C0)
#define I2C0_FLT                                 I2C_FLT_REG(I2C0)
#define I2C0_RA                                  I2C_RA_REG(I2C0)
#define I2C0_SMB                                 I2C_SMB_REG(I2C0)
#define I2C0_A2                                  I2C_A2_REG(I2C0)
#define I2C0_SLTH                                I2C_SLTH_REG(I2C0)
#define I2C0_SLTL                                I2C_SLTL_REG(I2C0)
/* I2C1 */
#define I2C1_A1                                  I2C_A1_REG(I2C1)
#define I2C1_F                                   I2C_F_REG(I2C1)
#define I2C1_C1                                  I2C_C1_REG(I2C1)
#define I2C1_S                                   I2C_S_REG(I2C1)
#define I2C1_D                                   I2C_D_REG(I2C1)
#define I2C1_C2                                  I2C_C2_REG(I2C1)
#define I2C1_FLT                                 I2C_FLT_REG(I2C1)
#define I2C1_RA                                  I2C_RA_REG(I2C1)
#define I2C1_SMB                                 I2C_SMB_REG(I2C1)
#define I2C1_A2                                  I2C_A2_REG(I2C1)
#define I2C1_SLTH                                I2C_SLTH_REG(I2C1)
#define I2C1_SLTL                                I2C_SLTL_REG(I2C1)

/*!
 * @}
 */ /* end of group I2C_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group I2C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LLWU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Peripheral_Access_Layer LLWU Peripheral Access Layer
 * @{
 */

/** LLWU - Register Layout Typedef */
typedef struct {
  __IO uint8_t PE1;                                /**< LLWU Pin Enable 1 register, offset: 0x0 */
  __IO uint8_t PE2;                                /**< LLWU Pin Enable 2 register, offset: 0x1 */
  __IO uint8_t PE3;                                /**< LLWU Pin Enable 3 register, offset: 0x2 */
  __IO uint8_t PE4;                                /**< LLWU Pin Enable 4 register, offset: 0x3 */
  __IO uint8_t PE5;                                /**< LLWU Pin Enable 5 register, offset: 0x4 */
  __IO uint8_t PE6;                                /**< LLWU Pin Enable 6 register, offset: 0x5 */
  __IO uint8_t PE7;                                /**< LLWU Pin Enable 7 register, offset: 0x6 */
  __IO uint8_t PE8;                                /**< LLWU Pin Enable 8 register, offset: 0x7 */
  __IO uint8_t ME;                                 /**< LLWU Module Enable register, offset: 0x8 */
  __IO uint8_t PF1;                                /**< LLWU Pin Flag 1 register, offset: 0x9 */
  __IO uint8_t PF2;                                /**< LLWU Pin Flag 2 register, offset: 0xA */
  __IO uint8_t PF3;                                /**< LLWU Pin Flag 3 register, offset: 0xB */
  __IO uint8_t PF4;                                /**< LLWU Pin Flag 4 register, offset: 0xC */
  __I  uint8_t MF5;                                /**< LLWU Module Flag 5 register, offset: 0xD */
  __IO uint8_t FILT1;                              /**< LLWU Pin Filter 1 register, offset: 0xE */
  __IO uint8_t FILT2;                              /**< LLWU Pin Filter 2 register, offset: 0xF */
  __IO uint8_t FILT3;                              /**< LLWU Pin Filter 3 register, offset: 0x10 */
  __IO uint8_t FILT4;                              /**< LLWU Pin Filter 4 register, offset: 0x11 */
} LLWU_Type, *LLWU_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LLWU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Accessor_Macros LLWU - Register accessor macros
 * @{
 */


/* LLWU - Register accessors */
#define LLWU_PE1_REG(base)                       ((base)->PE1)
#define LLWU_PE2_REG(base)                       ((base)->PE2)
#define LLWU_PE3_REG(base)                       ((base)->PE3)
#define LLWU_PE4_REG(base)                       ((base)->PE4)
#define LLWU_PE5_REG(base)                       ((base)->PE5)
#define LLWU_PE6_REG(base)                       ((base)->PE6)
#define LLWU_PE7_REG(base)                       ((base)->PE7)
#define LLWU_PE8_REG(base)                       ((base)->PE8)
#define LLWU_ME_REG(base)                        ((base)->ME)
#define LLWU_PF1_REG(base)                       ((base)->PF1)
#define LLWU_PF2_REG(base)                       ((base)->PF2)
#define LLWU_PF3_REG(base)                       ((base)->PF3)
#define LLWU_PF4_REG(base)                       ((base)->PF4)
#define LLWU_MF5_REG(base)                       ((base)->MF5)
#define LLWU_FILT1_REG(base)                     ((base)->FILT1)
#define LLWU_FILT2_REG(base)                     ((base)->FILT2)
#define LLWU_FILT3_REG(base)                     ((base)->FILT3)
#define LLWU_FILT4_REG(base)                     ((base)->FILT4)

/*!
 * @}
 */ /* end of group LLWU_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LLWU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Masks LLWU Register Masks
 * @{
 */

/* PE1 Bit Fields */
#define LLWU_PE1_WUPE0_MASK                      0x3u
#define LLWU_PE1_WUPE0_SHIFT                     0
#define LLWU_PE1_WUPE0_WIDTH                     2
#define LLWU_PE1_WUPE0(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE0_SHIFT))&LLWU_PE1_WUPE0_MASK)
#define LLWU_PE1_WUPE1_MASK                      0xCu
#define LLWU_PE1_WUPE1_SHIFT                     2
#define LLWU_PE1_WUPE1_WIDTH                     2
#define LLWU_PE1_WUPE1(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE1_SHIFT))&LLWU_PE1_WUPE1_MASK)
#define LLWU_PE1_WUPE2_MASK                      0x30u
#define LLWU_PE1_WUPE2_SHIFT                     4
#define LLWU_PE1_WUPE2_WIDTH                     2
#define LLWU_PE1_WUPE2(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE2_SHIFT))&LLWU_PE1_WUPE2_MASK)
#define LLWU_PE1_WUPE3_MASK                      0xC0u
#define LLWU_PE1_WUPE3_SHIFT                     6
#define LLWU_PE1_WUPE3_WIDTH                     2
#define LLWU_PE1_WUPE3(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE3_SHIFT))&LLWU_PE1_WUPE3_MASK)
/* PE2 Bit Fields */
#define LLWU_PE2_WUPE4_MASK                      0x3u
#define LLWU_PE2_WUPE4_SHIFT                     0
#define LLWU_PE2_WUPE4_WIDTH                     2
#define LLWU_PE2_WUPE4(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE4_SHIFT))&LLWU_PE2_WUPE4_MASK)
#define LLWU_PE2_WUPE5_MASK                      0xCu
#define LLWU_PE2_WUPE5_SHIFT                     2
#define LLWU_PE2_WUPE5_WIDTH                     2
#define LLWU_PE2_WUPE5(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE5_SHIFT))&LLWU_PE2_WUPE5_MASK)
#define LLWU_PE2_WUPE6_MASK                      0x30u
#define LLWU_PE2_WUPE6_SHIFT                     4
#define LLWU_PE2_WUPE6_WIDTH                     2
#define LLWU_PE2_WUPE6(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE6_SHIFT))&LLWU_PE2_WUPE6_MASK)
#define LLWU_PE2_WUPE7_MASK                      0xC0u
#define LLWU_PE2_WUPE7_SHIFT                     6
#define LLWU_PE2_WUPE7_WIDTH                     2
#define LLWU_PE2_WUPE7(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE7_SHIFT))&LLWU_PE2_WUPE7_MASK)
/* PE3 Bit Fields */
#define LLWU_PE3_WUPE8_MASK                      0x3u
#define LLWU_PE3_WUPE8_SHIFT                     0
#define LLWU_PE3_WUPE8_WIDTH                     2
#define LLWU_PE3_WUPE8(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE8_SHIFT))&LLWU_PE3_WUPE8_MASK)
#define LLWU_PE3_WUPE9_MASK                      0xCu
#define LLWU_PE3_WUPE9_SHIFT                     2
#define LLWU_PE3_WUPE9_WIDTH                     2
#define LLWU_PE3_WUPE9(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE9_SHIFT))&LLWU_PE3_WUPE9_MASK)
#define LLWU_PE3_WUPE10_MASK                     0x30u
#define LLWU_PE3_WUPE10_SHIFT                    4
#define LLWU_PE3_WUPE10_WIDTH                    2
#define LLWU_PE3_WUPE10(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE10_SHIFT))&LLWU_PE3_WUPE10_MASK)
#define LLWU_PE3_WUPE11_MASK                     0xC0u
#define LLWU_PE3_WUPE11_SHIFT                    6
#define LLWU_PE3_WUPE11_WIDTH                    2
#define LLWU_PE3_WUPE11(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE11_SHIFT))&LLWU_PE3_WUPE11_MASK)
/* PE4 Bit Fields */
#define LLWU_PE4_WUPE12_MASK                     0x3u
#define LLWU_PE4_WUPE12_SHIFT                    0
#define LLWU_PE4_WUPE12_WIDTH                    2
#define LLWU_PE4_WUPE12(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE12_SHIFT))&LLWU_PE4_WUPE12_MASK)
#define LLWU_PE4_WUPE13_MASK                     0xCu
#define LLWU_PE4_WUPE13_SHIFT                    2
#define LLWU_PE4_WUPE13_WIDTH                    2
#define LLWU_PE4_WUPE13(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE13_SHIFT))&LLWU_PE4_WUPE13_MASK)
#define LLWU_PE4_WUPE14_MASK                     0x30u
#define LLWU_PE4_WUPE14_SHIFT                    4
#define LLWU_PE4_WUPE14_WIDTH                    2
#define LLWU_PE4_WUPE14(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE14_SHIFT))&LLWU_PE4_WUPE14_MASK)
#define LLWU_PE4_WUPE15_MASK                     0xC0u
#define LLWU_PE4_WUPE15_SHIFT                    6
#define LLWU_PE4_WUPE15_WIDTH                    2
#define LLWU_PE4_WUPE15(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE15_SHIFT))&LLWU_PE4_WUPE15_MASK)
/* PE5 Bit Fields */
#define LLWU_PE5_WUPE16_MASK                     0x3u
#define LLWU_PE5_WUPE16_SHIFT                    0
#define LLWU_PE5_WUPE16_WIDTH                    2
#define LLWU_PE5_WUPE16(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE16_SHIFT))&LLWU_PE5_WUPE16_MASK)
#define LLWU_PE5_WUPE17_MASK                     0xCu
#define LLWU_PE5_WUPE17_SHIFT                    2
#define LLWU_PE5_WUPE17_WIDTH                    2
#define LLWU_PE5_WUPE17(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE17_SHIFT))&LLWU_PE5_WUPE17_MASK)
#define LLWU_PE5_WUPE18_MASK                     0x30u
#define LLWU_PE5_WUPE18_SHIFT                    4
#define LLWU_PE5_WUPE18_WIDTH                    2
#define LLWU_PE5_WUPE18(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE18_SHIFT))&LLWU_PE5_WUPE18_MASK)
#define LLWU_PE5_WUPE19_MASK                     0xC0u
#define LLWU_PE5_WUPE19_SHIFT                    6
#define LLWU_PE5_WUPE19_WIDTH                    2
#define LLWU_PE5_WUPE19(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE19_SHIFT))&LLWU_PE5_WUPE19_MASK)
/* PE6 Bit Fields */
#define LLWU_PE6_WUPE20_MASK                     0x3u
#define LLWU_PE6_WUPE20_SHIFT                    0
#define LLWU_PE6_WUPE20_WIDTH                    2
#define LLWU_PE6_WUPE20(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE20_SHIFT))&LLWU_PE6_WUPE20_MASK)
#define LLWU_PE6_WUPE21_MASK                     0xCu
#define LLWU_PE6_WUPE21_SHIFT                    2
#define LLWU_PE6_WUPE21_WIDTH                    2
#define LLWU_PE6_WUPE21(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE21_SHIFT))&LLWU_PE6_WUPE21_MASK)
#define LLWU_PE6_WUPE22_MASK                     0x30u
#define LLWU_PE6_WUPE22_SHIFT                    4
#define LLWU_PE6_WUPE22_WIDTH                    2
#define LLWU_PE6_WUPE22(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE22_SHIFT))&LLWU_PE6_WUPE22_MASK)
#define LLWU_PE6_WUPE23_MASK                     0xC0u
#define LLWU_PE6_WUPE23_SHIFT                    6
#define LLWU_PE6_WUPE23_WIDTH                    2
#define LLWU_PE6_WUPE23(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE23_SHIFT))&LLWU_PE6_WUPE23_MASK)
/* PE7 Bit Fields */
#define LLWU_PE7_WUPE24_MASK                     0x3u
#define LLWU_PE7_WUPE24_SHIFT                    0
#define LLWU_PE7_WUPE24_WIDTH                    2
#define LLWU_PE7_WUPE24(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE24_SHIFT))&LLWU_PE7_WUPE24_MASK)
#define LLWU_PE7_WUPE25_MASK                     0xCu
#define LLWU_PE7_WUPE25_SHIFT                    2
#define LLWU_PE7_WUPE25_WIDTH                    2
#define LLWU_PE7_WUPE25(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE25_SHIFT))&LLWU_PE7_WUPE25_MASK)
#define LLWU_PE7_WUPE26_MASK                     0x30u
#define LLWU_PE7_WUPE26_SHIFT                    4
#define LLWU_PE7_WUPE26_WIDTH                    2
#define LLWU_PE7_WUPE26(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE26_SHIFT))&LLWU_PE7_WUPE26_MASK)
#define LLWU_PE7_WUPE27_MASK                     0xC0u
#define LLWU_PE7_WUPE27_SHIFT                    6
#define LLWU_PE7_WUPE27_WIDTH                    2
#define LLWU_PE7_WUPE27(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE27_SHIFT))&LLWU_PE7_WUPE27_MASK)
/* PE8 Bit Fields */
#define LLWU_PE8_WUPE28_MASK                     0x3u
#define LLWU_PE8_WUPE28_SHIFT                    0
#define LLWU_PE8_WUPE28_WIDTH                    2
#define LLWU_PE8_WUPE28(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE28_SHIFT))&LLWU_PE8_WUPE28_MASK)
#define LLWU_PE8_WUPE29_MASK                     0xCu
#define LLWU_PE8_WUPE29_SHIFT                    2
#define LLWU_PE8_WUPE29_WIDTH                    2
#define LLWU_PE8_WUPE29(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE29_SHIFT))&LLWU_PE8_WUPE29_MASK)
#define LLWU_PE8_WUPE30_MASK                     0x30u
#define LLWU_PE8_WUPE30_SHIFT                    4
#define LLWU_PE8_WUPE30_WIDTH                    2
#define LLWU_PE8_WUPE30(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE30_SHIFT))&LLWU_PE8_WUPE30_MASK)
#define LLWU_PE8_WUPE31_MASK                     0xC0u
#define LLWU_PE8_WUPE31_SHIFT                    6
#define LLWU_PE8_WUPE31_WIDTH                    2
#define LLWU_PE8_WUPE31(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE31_SHIFT))&LLWU_PE8_WUPE31_MASK)
/* ME Bit Fields */
#define LLWU_ME_WUME0_MASK                       0x1u
#define LLWU_ME_WUME0_SHIFT                      0
#define LLWU_ME_WUME0_WIDTH                      1
#define LLWU_ME_WUME0(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME0_SHIFT))&LLWU_ME_WUME0_MASK)
#define LLWU_ME_WUME1_MASK                       0x2u
#define LLWU_ME_WUME1_SHIFT                      1
#define LLWU_ME_WUME1_WIDTH                      1
#define LLWU_ME_WUME1(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME1_SHIFT))&LLWU_ME_WUME1_MASK)
#define LLWU_ME_WUME2_MASK                       0x4u
#define LLWU_ME_WUME2_SHIFT                      2
#define LLWU_ME_WUME2_WIDTH                      1
#define LLWU_ME_WUME2(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME2_SHIFT))&LLWU_ME_WUME2_MASK)
#define LLWU_ME_WUME3_MASK                       0x8u
#define LLWU_ME_WUME3_SHIFT                      3
#define LLWU_ME_WUME3_WIDTH                      1
#define LLWU_ME_WUME3(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME3_SHIFT))&LLWU_ME_WUME3_MASK)
#define LLWU_ME_WUME4_MASK                       0x10u
#define LLWU_ME_WUME4_SHIFT                      4
#define LLWU_ME_WUME4_WIDTH                      1
#define LLWU_ME_WUME4(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME4_SHIFT))&LLWU_ME_WUME4_MASK)
#define LLWU_ME_WUME5_MASK                       0x20u
#define LLWU_ME_WUME5_SHIFT                      5
#define LLWU_ME_WUME5_WIDTH                      1
#define LLWU_ME_WUME5(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME5_SHIFT))&LLWU_ME_WUME5_MASK)
#define LLWU_ME_WUME6_MASK                       0x40u
#define LLWU_ME_WUME6_SHIFT                      6
#define LLWU_ME_WUME6_WIDTH                      1
#define LLWU_ME_WUME6(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME6_SHIFT))&LLWU_ME_WUME6_MASK)
#define LLWU_ME_WUME7_MASK                       0x80u
#define LLWU_ME_WUME7_SHIFT                      7
#define LLWU_ME_WUME7_WIDTH                      1
#define LLWU_ME_WUME7(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME7_SHIFT))&LLWU_ME_WUME7_MASK)
/* PF1 Bit Fields */
#define LLWU_PF1_WUF0_MASK                       0x1u
#define LLWU_PF1_WUF0_SHIFT                      0
#define LLWU_PF1_WUF0_WIDTH                      1
#define LLWU_PF1_WUF0(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF0_SHIFT))&LLWU_PF1_WUF0_MASK)
#define LLWU_PF1_WUF1_MASK                       0x2u
#define LLWU_PF1_WUF1_SHIFT                      1
#define LLWU_PF1_WUF1_WIDTH                      1
#define LLWU_PF1_WUF1(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF1_SHIFT))&LLWU_PF1_WUF1_MASK)
#define LLWU_PF1_WUF2_MASK                       0x4u
#define LLWU_PF1_WUF2_SHIFT                      2
#define LLWU_PF1_WUF2_WIDTH                      1
#define LLWU_PF1_WUF2(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF2_SHIFT))&LLWU_PF1_WUF2_MASK)
#define LLWU_PF1_WUF3_MASK                       0x8u
#define LLWU_PF1_WUF3_SHIFT                      3
#define LLWU_PF1_WUF3_WIDTH                      1
#define LLWU_PF1_WUF3(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF3_SHIFT))&LLWU_PF1_WUF3_MASK)
#define LLWU_PF1_WUF4_MASK                       0x10u
#define LLWU_PF1_WUF4_SHIFT                      4
#define LLWU_PF1_WUF4_WIDTH                      1
#define LLWU_PF1_WUF4(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF4_SHIFT))&LLWU_PF1_WUF4_MASK)
#define LLWU_PF1_WUF5_MASK                       0x20u
#define LLWU_PF1_WUF5_SHIFT                      5
#define LLWU_PF1_WUF5_WIDTH                      1
#define LLWU_PF1_WUF5(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF5_SHIFT))&LLWU_PF1_WUF5_MASK)
#define LLWU_PF1_WUF6_MASK                       0x40u
#define LLWU_PF1_WUF6_SHIFT                      6
#define LLWU_PF1_WUF6_WIDTH                      1
#define LLWU_PF1_WUF6(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF6_SHIFT))&LLWU_PF1_WUF6_MASK)
#define LLWU_PF1_WUF7_MASK                       0x80u
#define LLWU_PF1_WUF7_SHIFT                      7
#define LLWU_PF1_WUF7_WIDTH                      1
#define LLWU_PF1_WUF7(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF7_SHIFT))&LLWU_PF1_WUF7_MASK)
/* PF2 Bit Fields */
#define LLWU_PF2_WUF8_MASK                       0x1u
#define LLWU_PF2_WUF8_SHIFT                      0
#define LLWU_PF2_WUF8_WIDTH                      1
#define LLWU_PF2_WUF8(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF8_SHIFT))&LLWU_PF2_WUF8_MASK)
#define LLWU_PF2_WUF9_MASK                       0x2u
#define LLWU_PF2_WUF9_SHIFT                      1
#define LLWU_PF2_WUF9_WIDTH                      1
#define LLWU_PF2_WUF9(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF9_SHIFT))&LLWU_PF2_WUF9_MASK)
#define LLWU_PF2_WUF10_MASK                      0x4u
#define LLWU_PF2_WUF10_SHIFT                     2
#define LLWU_PF2_WUF10_WIDTH                     1
#define LLWU_PF2_WUF10(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF10_SHIFT))&LLWU_PF2_WUF10_MASK)
#define LLWU_PF2_WUF11_MASK                      0x8u
#define LLWU_PF2_WUF11_SHIFT                     3
#define LLWU_PF2_WUF11_WIDTH                     1
#define LLWU_PF2_WUF11(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF11_SHIFT))&LLWU_PF2_WUF11_MASK)
#define LLWU_PF2_WUF12_MASK                      0x10u
#define LLWU_PF2_WUF12_SHIFT                     4
#define LLWU_PF2_WUF12_WIDTH                     1
#define LLWU_PF2_WUF12(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF12_SHIFT))&LLWU_PF2_WUF12_MASK)
#define LLWU_PF2_WUF13_MASK                      0x20u
#define LLWU_PF2_WUF13_SHIFT                     5
#define LLWU_PF2_WUF13_WIDTH                     1
#define LLWU_PF2_WUF13(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF13_SHIFT))&LLWU_PF2_WUF13_MASK)
#define LLWU_PF2_WUF14_MASK                      0x40u
#define LLWU_PF2_WUF14_SHIFT                     6
#define LLWU_PF2_WUF14_WIDTH                     1
#define LLWU_PF2_WUF14(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF14_SHIFT))&LLWU_PF2_WUF14_MASK)
#define LLWU_PF2_WUF15_MASK                      0x80u
#define LLWU_PF2_WUF15_SHIFT                     7
#define LLWU_PF2_WUF15_WIDTH                     1
#define LLWU_PF2_WUF15(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF15_SHIFT))&LLWU_PF2_WUF15_MASK)
/* PF3 Bit Fields */
#define LLWU_PF3_WUF16_MASK                      0x1u
#define LLWU_PF3_WUF16_SHIFT                     0
#define LLWU_PF3_WUF16_WIDTH                     1
#define LLWU_PF3_WUF16(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF16_SHIFT))&LLWU_PF3_WUF16_MASK)
#define LLWU_PF3_WUF17_MASK                      0x2u
#define LLWU_PF3_WUF17_SHIFT                     1
#define LLWU_PF3_WUF17_WIDTH                     1
#define LLWU_PF3_WUF17(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF17_SHIFT))&LLWU_PF3_WUF17_MASK)
#define LLWU_PF3_WUF18_MASK                      0x4u
#define LLWU_PF3_WUF18_SHIFT                     2
#define LLWU_PF3_WUF18_WIDTH                     1
#define LLWU_PF3_WUF18(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF18_SHIFT))&LLWU_PF3_WUF18_MASK)
#define LLWU_PF3_WUF19_MASK                      0x8u
#define LLWU_PF3_WUF19_SHIFT                     3
#define LLWU_PF3_WUF19_WIDTH                     1
#define LLWU_PF3_WUF19(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF19_SHIFT))&LLWU_PF3_WUF19_MASK)
#define LLWU_PF3_WUF20_MASK                      0x10u
#define LLWU_PF3_WUF20_SHIFT                     4
#define LLWU_PF3_WUF20_WIDTH                     1
#define LLWU_PF3_WUF20(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF20_SHIFT))&LLWU_PF3_WUF20_MASK)
#define LLWU_PF3_WUF21_MASK                      0x20u
#define LLWU_PF3_WUF21_SHIFT                     5
#define LLWU_PF3_WUF21_WIDTH                     1
#define LLWU_PF3_WUF21(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF21_SHIFT))&LLWU_PF3_WUF21_MASK)
#define LLWU_PF3_WUF22_MASK                      0x40u
#define LLWU_PF3_WUF22_SHIFT                     6
#define LLWU_PF3_WUF22_WIDTH                     1
#define LLWU_PF3_WUF22(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF22_SHIFT))&LLWU_PF3_WUF22_MASK)
#define LLWU_PF3_WUF23_MASK                      0x80u
#define LLWU_PF3_WUF23_SHIFT                     7
#define LLWU_PF3_WUF23_WIDTH                     1
#define LLWU_PF3_WUF23(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF23_SHIFT))&LLWU_PF3_WUF23_MASK)
/* PF4 Bit Fields */
#define LLWU_PF4_WUF24_MASK                      0x1u
#define LLWU_PF4_WUF24_SHIFT                     0
#define LLWU_PF4_WUF24_WIDTH                     1
#define LLWU_PF4_WUF24(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF24_SHIFT))&LLWU_PF4_WUF24_MASK)
#define LLWU_PF4_WUF25_MASK                      0x2u
#define LLWU_PF4_WUF25_SHIFT                     1
#define LLWU_PF4_WUF25_WIDTH                     1
#define LLWU_PF4_WUF25(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF25_SHIFT))&LLWU_PF4_WUF25_MASK)
#define LLWU_PF4_WUF26_MASK                      0x4u
#define LLWU_PF4_WUF26_SHIFT                     2
#define LLWU_PF4_WUF26_WIDTH                     1
#define LLWU_PF4_WUF26(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF26_SHIFT))&LLWU_PF4_WUF26_MASK)
#define LLWU_PF4_WUF27_MASK                      0x8u
#define LLWU_PF4_WUF27_SHIFT                     3
#define LLWU_PF4_WUF27_WIDTH                     1
#define LLWU_PF4_WUF27(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF27_SHIFT))&LLWU_PF4_WUF27_MASK)
#define LLWU_PF4_WUF28_MASK                      0x10u
#define LLWU_PF4_WUF28_SHIFT                     4
#define LLWU_PF4_WUF28_WIDTH                     1
#define LLWU_PF4_WUF28(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF28_SHIFT))&LLWU_PF4_WUF28_MASK)
#define LLWU_PF4_WUF29_MASK                      0x20u
#define LLWU_PF4_WUF29_SHIFT                     5
#define LLWU_PF4_WUF29_WIDTH                     1
#define LLWU_PF4_WUF29(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF29_SHIFT))&LLWU_PF4_WUF29_MASK)
#define LLWU_PF4_WUF30_MASK                      0x40u
#define LLWU_PF4_WUF30_SHIFT                     6
#define LLWU_PF4_WUF30_WIDTH                     1
#define LLWU_PF4_WUF30(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF30_SHIFT))&LLWU_PF4_WUF30_MASK)
#define LLWU_PF4_WUF31_MASK                      0x80u
#define LLWU_PF4_WUF31_SHIFT                     7
#define LLWU_PF4_WUF31_WIDTH                     1
#define LLWU_PF4_WUF31(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF31_SHIFT))&LLWU_PF4_WUF31_MASK)
/* MF5 Bit Fields */
#define LLWU_MF5_MWUF0_MASK                      0x1u
#define LLWU_MF5_MWUF0_SHIFT                     0
#define LLWU_MF5_MWUF0_WIDTH                     1
#define LLWU_MF5_MWUF0(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF0_SHIFT))&LLWU_MF5_MWUF0_MASK)
#define LLWU_MF5_MWUF1_MASK                      0x2u
#define LLWU_MF5_MWUF1_SHIFT                     1
#define LLWU_MF5_MWUF1_WIDTH                     1
#define LLWU_MF5_MWUF1(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF1_SHIFT))&LLWU_MF5_MWUF1_MASK)
#define LLWU_MF5_MWUF2_MASK                      0x4u
#define LLWU_MF5_MWUF2_SHIFT                     2
#define LLWU_MF5_MWUF2_WIDTH                     1
#define LLWU_MF5_MWUF2(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF2_SHIFT))&LLWU_MF5_MWUF2_MASK)
#define LLWU_MF5_MWUF3_MASK                      0x8u
#define LLWU_MF5_MWUF3_SHIFT                     3
#define LLWU_MF5_MWUF3_WIDTH                     1
#define LLWU_MF5_MWUF3(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF3_SHIFT))&LLWU_MF5_MWUF3_MASK)
#define LLWU_MF5_MWUF4_MASK                      0x10u
#define LLWU_MF5_MWUF4_SHIFT                     4
#define LLWU_MF5_MWUF4_WIDTH                     1
#define LLWU_MF5_MWUF4(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF4_SHIFT))&LLWU_MF5_MWUF4_MASK)
#define LLWU_MF5_MWUF5_MASK                      0x20u
#define LLWU_MF5_MWUF5_SHIFT                     5
#define LLWU_MF5_MWUF5_WIDTH                     1
#define LLWU_MF5_MWUF5(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF5_SHIFT))&LLWU_MF5_MWUF5_MASK)
#define LLWU_MF5_MWUF6_MASK                      0x40u
#define LLWU_MF5_MWUF6_SHIFT                     6
#define LLWU_MF5_MWUF6_WIDTH                     1
#define LLWU_MF5_MWUF6(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF6_SHIFT))&LLWU_MF5_MWUF6_MASK)
#define LLWU_MF5_MWUF7_MASK                      0x80u
#define LLWU_MF5_MWUF7_SHIFT                     7
#define LLWU_MF5_MWUF7_WIDTH                     1
#define LLWU_MF5_MWUF7(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF7_SHIFT))&LLWU_MF5_MWUF7_MASK)
/* FILT1 Bit Fields */
#define LLWU_FILT1_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT1_FILTSEL_SHIFT                 0
#define LLWU_FILT1_FILTSEL_WIDTH                 5
#define LLWU_FILT1_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT1_FILTSEL_SHIFT))&LLWU_FILT1_FILTSEL_MASK)
#define LLWU_FILT1_FILTE_MASK                    0x60u
#define LLWU_FILT1_FILTE_SHIFT                   5
#define LLWU_FILT1_FILTE_WIDTH                   2
#define LLWU_FILT1_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT1_FILTE_SHIFT))&LLWU_FILT1_FILTE_MASK)
#define LLWU_FILT1_FILTF_MASK                    0x80u
#define LLWU_FILT1_FILTF_SHIFT                   7
#define LLWU_FILT1_FILTF_WIDTH                   1
#define LLWU_FILT1_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT1_FILTF_SHIFT))&LLWU_FILT1_FILTF_MASK)
/* FILT2 Bit Fields */
#define LLWU_FILT2_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT2_FILTSEL_SHIFT                 0
#define LLWU_FILT2_FILTSEL_WIDTH                 5
#define LLWU_FILT2_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT2_FILTSEL_SHIFT))&LLWU_FILT2_FILTSEL_MASK)
#define LLWU_FILT2_FILTE_MASK                    0x60u
#define LLWU_FILT2_FILTE_SHIFT                   5
#define LLWU_FILT2_FILTE_WIDTH                   2
#define LLWU_FILT2_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT2_FILTE_SHIFT))&LLWU_FILT2_FILTE_MASK)
#define LLWU_FILT2_FILTF_MASK                    0x80u
#define LLWU_FILT2_FILTF_SHIFT                   7
#define LLWU_FILT2_FILTF_WIDTH                   1
#define LLWU_FILT2_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT2_FILTF_SHIFT))&LLWU_FILT2_FILTF_MASK)
/* FILT3 Bit Fields */
#define LLWU_FILT3_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT3_FILTSEL_SHIFT                 0
#define LLWU_FILT3_FILTSEL_WIDTH                 5
#define LLWU_FILT3_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT3_FILTSEL_SHIFT))&LLWU_FILT3_FILTSEL_MASK)
#define LLWU_FILT3_FILTE_MASK                    0x60u
#define LLWU_FILT3_FILTE_SHIFT                   5
#define LLWU_FILT3_FILTE_WIDTH                   2
#define LLWU_FILT3_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT3_FILTE_SHIFT))&LLWU_FILT3_FILTE_MASK)
#define LLWU_FILT3_FILTF_MASK                    0x80u
#define LLWU_FILT3_FILTF_SHIFT                   7
#define LLWU_FILT3_FILTF_WIDTH                   1
#define LLWU_FILT3_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT3_FILTF_SHIFT))&LLWU_FILT3_FILTF_MASK)
/* FILT4 Bit Fields */
#define LLWU_FILT4_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT4_FILTSEL_SHIFT                 0
#define LLWU_FILT4_FILTSEL_WIDTH                 5
#define LLWU_FILT4_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT4_FILTSEL_SHIFT))&LLWU_FILT4_FILTSEL_MASK)
#define LLWU_FILT4_FILTE_MASK                    0x60u
#define LLWU_FILT4_FILTE_SHIFT                   5
#define LLWU_FILT4_FILTE_WIDTH                   2
#define LLWU_FILT4_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT4_FILTE_SHIFT))&LLWU_FILT4_FILTE_MASK)
#define LLWU_FILT4_FILTF_MASK                    0x80u
#define LLWU_FILT4_FILTF_SHIFT                   7
#define LLWU_FILT4_FILTF_WIDTH                   1
#define LLWU_FILT4_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT4_FILTF_SHIFT))&LLWU_FILT4_FILTF_MASK)

/*!
 * @}
 */ /* end of group LLWU_Register_Masks */


/* LLWU - Peripheral instance base addresses */
/** Peripheral LLWU base address */
#define LLWU_BASE                                (0x4007C000u)
/** Peripheral LLWU base pointer */
#define LLWU                                     ((LLWU_Type *)LLWU_BASE)
#define LLWU_BASE_PTR                            (LLWU)
/** Array initializer of LLWU peripheral base addresses */
#define LLWU_BASE_ADDRS                          { LLWU_BASE }
/** Array initializer of LLWU peripheral base pointers */
#define LLWU_BASE_PTRS                           { LLWU }

/* ----------------------------------------------------------------------------
   -- LLWU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Accessor_Macros LLWU - Register accessor macros
 * @{
 */


/* LLWU - Register instance definitions */
/* LLWU */
#define LLWU_PE1                                 LLWU_PE1_REG(LLWU)
#define LLWU_PE2                                 LLWU_PE2_REG(LLWU)
#define LLWU_PE3                                 LLWU_PE3_REG(LLWU)
#define LLWU_PE4                                 LLWU_PE4_REG(LLWU)
#define LLWU_PE5                                 LLWU_PE5_REG(LLWU)
#define LLWU_PE6                                 LLWU_PE6_REG(LLWU)
#define LLWU_PE7                                 LLWU_PE7_REG(LLWU)
#define LLWU_PE8                                 LLWU_PE8_REG(LLWU)
#define LLWU_ME                                  LLWU_ME_REG(LLWU)
#define LLWU_PF1                                 LLWU_PF1_REG(LLWU)
#define LLWU_PF2                                 LLWU_PF2_REG(LLWU)
#define LLWU_PF3                                 LLWU_PF3_REG(LLWU)
#define LLWU_PF4                                 LLWU_PF4_REG(LLWU)
#define LLWU_MF5                                 LLWU_MF5_REG(LLWU)
#define LLWU_FILT1                               LLWU_FILT1_REG(LLWU)
#define LLWU_FILT2                               LLWU_FILT2_REG(LLWU)
#define LLWU_FILT3                               LLWU_FILT3_REG(LLWU)
#define LLWU_FILT4                               LLWU_FILT4_REG(LLWU)

/*!
 * @}
 */ /* end of group LLWU_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LLWU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LPTMR Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Peripheral_Access_Layer LPTMR Peripheral Access Layer
 * @{
 */

/** LPTMR - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSR;                               /**< Low Power Timer Control Status Register, offset: 0x0 */
  __IO uint32_t PSR;                               /**< Low Power Timer Prescale Register, offset: 0x4 */
  __IO uint32_t CMR;                               /**< Low Power Timer Compare Register, offset: 0x8 */
  __IO uint32_t CNR;                               /**< Low Power Timer Counter Register, offset: 0xC */
} LPTMR_Type, *LPTMR_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LPTMR - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Accessor_Macros LPTMR - Register accessor macros
 * @{
 */


/* LPTMR - Register accessors */
#define LPTMR_CSR_REG(base)                      ((base)->CSR)
#define LPTMR_PSR_REG(base)                      ((base)->PSR)
#define LPTMR_CMR_REG(base)                      ((base)->CMR)
#define LPTMR_CNR_REG(base)                      ((base)->CNR)

/*!
 * @}
 */ /* end of group LPTMR_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LPTMR Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Masks LPTMR Register Masks
 * @{
 */

/* CSR Bit Fields */
#define LPTMR_CSR_TEN_MASK                       0x1u
#define LPTMR_CSR_TEN_SHIFT                      0
#define LPTMR_CSR_TEN_WIDTH                      1
#define LPTMR_CSR_TEN(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TEN_SHIFT))&LPTMR_CSR_TEN_MASK)
#define LPTMR_CSR_TMS_MASK                       0x2u
#define LPTMR_CSR_TMS_SHIFT                      1
#define LPTMR_CSR_TMS_WIDTH                      1
#define LPTMR_CSR_TMS(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TMS_SHIFT))&LPTMR_CSR_TMS_MASK)
#define LPTMR_CSR_TFC_MASK                       0x4u
#define LPTMR_CSR_TFC_SHIFT                      2
#define LPTMR_CSR_TFC_WIDTH                      1
#define LPTMR_CSR_TFC(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TFC_SHIFT))&LPTMR_CSR_TFC_MASK)
#define LPTMR_CSR_TPP_MASK                       0x8u
#define LPTMR_CSR_TPP_SHIFT                      3
#define LPTMR_CSR_TPP_WIDTH                      1
#define LPTMR_CSR_TPP(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TPP_SHIFT))&LPTMR_CSR_TPP_MASK)
#define LPTMR_CSR_TPS_MASK                       0x30u
#define LPTMR_CSR_TPS_SHIFT                      4
#define LPTMR_CSR_TPS_WIDTH                      2
#define LPTMR_CSR_TPS(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TPS_SHIFT))&LPTMR_CSR_TPS_MASK)
#define LPTMR_CSR_TIE_MASK                       0x40u
#define LPTMR_CSR_TIE_SHIFT                      6
#define LPTMR_CSR_TIE_WIDTH                      1
#define LPTMR_CSR_TIE(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TIE_SHIFT))&LPTMR_CSR_TIE_MASK)
#define LPTMR_CSR_TCF_MASK                       0x80u
#define LPTMR_CSR_TCF_SHIFT                      7
#define LPTMR_CSR_TCF_WIDTH                      1
#define LPTMR_CSR_TCF(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TCF_SHIFT))&LPTMR_CSR_TCF_MASK)
/* PSR Bit Fields */
#define LPTMR_PSR_PCS_MASK                       0x3u
#define LPTMR_PSR_PCS_SHIFT                      0
#define LPTMR_PSR_PCS_WIDTH                      2
#define LPTMR_PSR_PCS(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_PSR_PCS_SHIFT))&LPTMR_PSR_PCS_MASK)
#define LPTMR_PSR_PBYP_MASK                      0x4u
#define LPTMR_PSR_PBYP_SHIFT                     2
#define LPTMR_PSR_PBYP_WIDTH                     1
#define LPTMR_PSR_PBYP(x)                        (((uint32_t)(((uint32_t)(x))<<LPTMR_PSR_PBYP_SHIFT))&LPTMR_PSR_PBYP_MASK)
#define LPTMR_PSR_PRESCALE_MASK                  0x78u
#define LPTMR_PSR_PRESCALE_SHIFT                 3
#define LPTMR_PSR_PRESCALE_WIDTH                 4
#define LPTMR_PSR_PRESCALE(x)                    (((uint32_t)(((uint32_t)(x))<<LPTMR_PSR_PRESCALE_SHIFT))&LPTMR_PSR_PRESCALE_MASK)
/* CMR Bit Fields */
#define LPTMR_CMR_COMPARE_MASK                   0xFFFFu
#define LPTMR_CMR_COMPARE_SHIFT                  0
#define LPTMR_CMR_COMPARE_WIDTH                  16
#define LPTMR_CMR_COMPARE(x)                     (((uint32_t)(((uint32_t)(x))<<LPTMR_CMR_COMPARE_SHIFT))&LPTMR_CMR_COMPARE_MASK)
/* CNR Bit Fields */
#define LPTMR_CNR_COUNTER_MASK                   0xFFFFu
#define LPTMR_CNR_COUNTER_SHIFT                  0
#define LPTMR_CNR_COUNTER_WIDTH                  16
#define LPTMR_CNR_COUNTER(x)                     (((uint32_t)(((uint32_t)(x))<<LPTMR_CNR_COUNTER_SHIFT))&LPTMR_CNR_COUNTER_MASK)

/*!
 * @}
 */ /* end of group LPTMR_Register_Masks */


/* LPTMR - Peripheral instance base addresses */
/** Peripheral LPTMR0 base address */
#define LPTMR0_BASE                              (0x40040000u)
/** Peripheral LPTMR0 base pointer */
#define LPTMR0                                   ((LPTMR_Type *)LPTMR0_BASE)
#define LPTMR0_BASE_PTR                          (LPTMR0)
/** Array initializer of LPTMR peripheral base addresses */
#define LPTMR_BASE_ADDRS                         { LPTMR0_BASE }
/** Array initializer of LPTMR peripheral base pointers */
#define LPTMR_BASE_PTRS                          { LPTMR0 }

/* ----------------------------------------------------------------------------
   -- LPTMR - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Accessor_Macros LPTMR - Register accessor macros
 * @{
 */


/* LPTMR - Register instance definitions */
/* LPTMR0 */
#define LPTMR0_CSR                               LPTMR_CSR_REG(LPTMR0)
#define LPTMR0_PSR                               LPTMR_PSR_REG(LPTMR0)
#define LPTMR0_CMR                               LPTMR_CMR_REG(LPTMR0)
#define LPTMR0_CNR                               LPTMR_CNR_REG(LPTMR0)

/*!
 * @}
 */ /* end of group LPTMR_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LPTMR_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MCG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Peripheral_Access_Layer MCG Peripheral Access Layer
 * @{
 */

/** MCG - Register Layout Typedef */
typedef struct {
  __IO uint8_t C1;                                 /**< MCG Control 1 Register, offset: 0x0 */
  __IO uint8_t C2;                                 /**< MCG Control 2 Register, offset: 0x1 */
  __IO uint8_t C3;                                 /**< MCG Control 3 Register, offset: 0x2 */
  __IO uint8_t C4;                                 /**< MCG Control 4 Register, offset: 0x3 */
  __IO uint8_t C5;                                 /**< MCG Control 5 Register, offset: 0x4 */
  __IO uint8_t C6;                                 /**< MCG Control 6 Register, offset: 0x5 */
  __IO uint8_t S;                                  /**< MCG Status Register, offset: 0x6 */
       uint8_t RESERVED_0[1];
  __IO uint8_t SC;                                 /**< MCG Status and Control Register, offset: 0x8 */
       uint8_t RESERVED_1[1];
  __IO uint8_t ATCVH;                              /**< MCG Auto Trim Compare Value High Register, offset: 0xA */
  __IO uint8_t ATCVL;                              /**< MCG Auto Trim Compare Value Low Register, offset: 0xB */
  __IO uint8_t C7;                                 /**< MCG Control 7 Register, offset: 0xC */
  __IO uint8_t C8;                                 /**< MCG Control 8 Register, offset: 0xD */
} MCG_Type, *MCG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MCG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Accessor_Macros MCG - Register accessor macros
 * @{
 */


/* MCG - Register accessors */
#define MCG_C1_REG(base)                         ((base)->C1)
#define MCG_C2_REG(base)                         ((base)->C2)
#define MCG_C3_REG(base)                         ((base)->C3)
#define MCG_C4_REG(base)                         ((base)->C4)
#define MCG_C5_REG(base)                         ((base)->C5)
#define MCG_C6_REG(base)                         ((base)->C6)
#define MCG_S_REG(base)                          ((base)->S)
#define MCG_SC_REG(base)                         ((base)->SC)
#define MCG_ATCVH_REG(base)                      ((base)->ATCVH)
#define MCG_ATCVL_REG(base)                      ((base)->ATCVL)
#define MCG_C7_REG(base)                         ((base)->C7)
#define MCG_C8_REG(base)                         ((base)->C8)

/*!
 * @}
 */ /* end of group MCG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MCG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Masks MCG Register Masks
 * @{
 */

/* C1 Bit Fields */
#define MCG_C1_IREFSTEN_MASK                     0x1u
#define MCG_C1_IREFSTEN_SHIFT                    0
#define MCG_C1_IREFSTEN_WIDTH                    1
#define MCG_C1_IREFSTEN(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_C1_IREFSTEN_SHIFT))&MCG_C1_IREFSTEN_MASK)
#define MCG_C1_IRCLKEN_MASK                      0x2u
#define MCG_C1_IRCLKEN_SHIFT                     1
#define MCG_C1_IRCLKEN_WIDTH                     1
#define MCG_C1_IRCLKEN(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C1_IRCLKEN_SHIFT))&MCG_C1_IRCLKEN_MASK)
#define MCG_C1_IREFS_MASK                        0x4u
#define MCG_C1_IREFS_SHIFT                       2
#define MCG_C1_IREFS_WIDTH                       1
#define MCG_C1_IREFS(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C1_IREFS_SHIFT))&MCG_C1_IREFS_MASK)
#define MCG_C1_FRDIV_MASK                        0x38u
#define MCG_C1_FRDIV_SHIFT                       3
#define MCG_C1_FRDIV_WIDTH                       3
#define MCG_C1_FRDIV(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C1_FRDIV_SHIFT))&MCG_C1_FRDIV_MASK)
#define MCG_C1_CLKS_MASK                         0xC0u
#define MCG_C1_CLKS_SHIFT                        6
#define MCG_C1_CLKS_WIDTH                        2
#define MCG_C1_CLKS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C1_CLKS_SHIFT))&MCG_C1_CLKS_MASK)
/* C2 Bit Fields */
#define MCG_C2_IRCS_MASK                         0x1u
#define MCG_C2_IRCS_SHIFT                        0
#define MCG_C2_IRCS_WIDTH                        1
#define MCG_C2_IRCS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C2_IRCS_SHIFT))&MCG_C2_IRCS_MASK)
#define MCG_C2_LP_MASK                           0x2u
#define MCG_C2_LP_SHIFT                          1
#define MCG_C2_LP_WIDTH                          1
#define MCG_C2_LP(x)                             (((uint8_t)(((uint8_t)(x))<<MCG_C2_LP_SHIFT))&MCG_C2_LP_MASK)
#define MCG_C2_EREFS_MASK                        0x4u
#define MCG_C2_EREFS_SHIFT                       2
#define MCG_C2_EREFS_WIDTH                       1
#define MCG_C2_EREFS(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C2_EREFS_SHIFT))&MCG_C2_EREFS_MASK)
#define MCG_C2_HGO_MASK                          0x8u
#define MCG_C2_HGO_SHIFT                         3
#define MCG_C2_HGO_WIDTH                         1
#define MCG_C2_HGO(x)                            (((uint8_t)(((uint8_t)(x))<<MCG_C2_HGO_SHIFT))&MCG_C2_HGO_MASK)
#define MCG_C2_RANGE_MASK                        0x30u
#define MCG_C2_RANGE_SHIFT                       4
#define MCG_C2_RANGE_WIDTH                       2
#define MCG_C2_RANGE(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C2_RANGE_SHIFT))&MCG_C2_RANGE_MASK)
#define MCG_C2_FCFTRIM_MASK                      0x40u
#define MCG_C2_FCFTRIM_SHIFT                     6
#define MCG_C2_FCFTRIM_WIDTH                     1
#define MCG_C2_FCFTRIM(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C2_FCFTRIM_SHIFT))&MCG_C2_FCFTRIM_MASK)
#define MCG_C2_LOCRE0_MASK                       0x80u
#define MCG_C2_LOCRE0_SHIFT                      7
#define MCG_C2_LOCRE0_WIDTH                      1
#define MCG_C2_LOCRE0(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C2_LOCRE0_SHIFT))&MCG_C2_LOCRE0_MASK)
/* C3 Bit Fields */
#define MCG_C3_SCTRIM_MASK                       0xFFu
#define MCG_C3_SCTRIM_SHIFT                      0
#define MCG_C3_SCTRIM_WIDTH                      8
#define MCG_C3_SCTRIM(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C3_SCTRIM_SHIFT))&MCG_C3_SCTRIM_MASK)
/* C4 Bit Fields */
#define MCG_C4_SCFTRIM_MASK                      0x1u
#define MCG_C4_SCFTRIM_SHIFT                     0
#define MCG_C4_SCFTRIM_WIDTH                     1
#define MCG_C4_SCFTRIM(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C4_SCFTRIM_SHIFT))&MCG_C4_SCFTRIM_MASK)
#define MCG_C4_FCTRIM_MASK                       0x1Eu
#define MCG_C4_FCTRIM_SHIFT                      1
#define MCG_C4_FCTRIM_WIDTH                      4
#define MCG_C4_FCTRIM(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C4_FCTRIM_SHIFT))&MCG_C4_FCTRIM_MASK)
#define MCG_C4_DRST_DRS_MASK                     0x60u
#define MCG_C4_DRST_DRS_SHIFT                    5
#define MCG_C4_DRST_DRS_WIDTH                    2
#define MCG_C4_DRST_DRS(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_C4_DRST_DRS_SHIFT))&MCG_C4_DRST_DRS_MASK)
#define MCG_C4_DMX32_MASK                        0x80u
#define MCG_C4_DMX32_SHIFT                       7
#define MCG_C4_DMX32_WIDTH                       1
#define MCG_C4_DMX32(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C4_DMX32_SHIFT))&MCG_C4_DMX32_MASK)
/* C5 Bit Fields */
#define MCG_C5_PRDIV_MASK                        0x7u
#define MCG_C5_PRDIV_SHIFT                       0
#define MCG_C5_PRDIV_WIDTH                       3
#define MCG_C5_PRDIV(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C5_PRDIV_SHIFT))&MCG_C5_PRDIV_MASK)
#define MCG_C5_PLLSTEN_MASK                      0x20u
#define MCG_C5_PLLSTEN_SHIFT                     5
#define MCG_C5_PLLSTEN_WIDTH                     1
#define MCG_C5_PLLSTEN(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C5_PLLSTEN_SHIFT))&MCG_C5_PLLSTEN_MASK)
#define MCG_C5_PLLCLKEN_MASK                     0x40u
#define MCG_C5_PLLCLKEN_SHIFT                    6
#define MCG_C5_PLLCLKEN_WIDTH                    1
#define MCG_C5_PLLCLKEN(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_C5_PLLCLKEN_SHIFT))&MCG_C5_PLLCLKEN_MASK)
/* C6 Bit Fields */
#define MCG_C6_VDIV_MASK                         0x1Fu
#define MCG_C6_VDIV_SHIFT                        0
#define MCG_C6_VDIV_WIDTH                        5
#define MCG_C6_VDIV(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C6_VDIV_SHIFT))&MCG_C6_VDIV_MASK)
#define MCG_C6_CME0_MASK                         0x20u
#define MCG_C6_CME0_SHIFT                        5
#define MCG_C6_CME0_WIDTH                        1
#define MCG_C6_CME0(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C6_CME0_SHIFT))&MCG_C6_CME0_MASK)
#define MCG_C6_PLLS_MASK                         0x40u
#define MCG_C6_PLLS_SHIFT                        6
#define MCG_C6_PLLS_WIDTH                        1
#define MCG_C6_PLLS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C6_PLLS_SHIFT))&MCG_C6_PLLS_MASK)
#define MCG_C6_LOLIE0_MASK                       0x80u
#define MCG_C6_LOLIE0_SHIFT                      7
#define MCG_C6_LOLIE0_WIDTH                      1
#define MCG_C6_LOLIE0(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C6_LOLIE0_SHIFT))&MCG_C6_LOLIE0_MASK)
/* S Bit Fields */
#define MCG_S_IRCST_MASK                         0x1u
#define MCG_S_IRCST_SHIFT                        0
#define MCG_S_IRCST_WIDTH                        1
#define MCG_S_IRCST(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_IRCST_SHIFT))&MCG_S_IRCST_MASK)
#define MCG_S_OSCINIT0_MASK                      0x2u
#define MCG_S_OSCINIT0_SHIFT                     1
#define MCG_S_OSCINIT0_WIDTH                     1
#define MCG_S_OSCINIT0(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_S_OSCINIT0_SHIFT))&MCG_S_OSCINIT0_MASK)
#define MCG_S_CLKST_MASK                         0xCu
#define MCG_S_CLKST_SHIFT                        2
#define MCG_S_CLKST_WIDTH                        2
#define MCG_S_CLKST(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_CLKST_SHIFT))&MCG_S_CLKST_MASK)
#define MCG_S_IREFST_MASK                        0x10u
#define MCG_S_IREFST_SHIFT                       4
#define MCG_S_IREFST_WIDTH                       1
#define MCG_S_IREFST(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_S_IREFST_SHIFT))&MCG_S_IREFST_MASK)
#define MCG_S_PLLST_MASK                         0x20u
#define MCG_S_PLLST_SHIFT                        5
#define MCG_S_PLLST_WIDTH                        1
#define MCG_S_PLLST(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_PLLST_SHIFT))&MCG_S_PLLST_MASK)
#define MCG_S_LOCK0_MASK                         0x40u
#define MCG_S_LOCK0_SHIFT                        6
#define MCG_S_LOCK0_WIDTH                        1
#define MCG_S_LOCK0(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_LOCK0_SHIFT))&MCG_S_LOCK0_MASK)
#define MCG_S_LOLS0_MASK                         0x80u
#define MCG_S_LOLS0_SHIFT                        7
#define MCG_S_LOLS0_WIDTH                        1
#define MCG_S_LOLS0(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_LOLS0_SHIFT))&MCG_S_LOLS0_MASK)
/* SC Bit Fields */
#define MCG_SC_LOCS0_MASK                        0x1u
#define MCG_SC_LOCS0_SHIFT                       0
#define MCG_SC_LOCS0_WIDTH                       1
#define MCG_SC_LOCS0(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_SC_LOCS0_SHIFT))&MCG_SC_LOCS0_MASK)
#define MCG_SC_FCRDIV_MASK                       0xEu
#define MCG_SC_FCRDIV_SHIFT                      1
#define MCG_SC_FCRDIV_WIDTH                      3
#define MCG_SC_FCRDIV(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_SC_FCRDIV_SHIFT))&MCG_SC_FCRDIV_MASK)
#define MCG_SC_FLTPRSRV_MASK                     0x10u
#define MCG_SC_FLTPRSRV_SHIFT                    4
#define MCG_SC_FLTPRSRV_WIDTH                    1
#define MCG_SC_FLTPRSRV(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_SC_FLTPRSRV_SHIFT))&MCG_SC_FLTPRSRV_MASK)
#define MCG_SC_ATMF_MASK                         0x20u
#define MCG_SC_ATMF_SHIFT                        5
#define MCG_SC_ATMF_WIDTH                        1
#define MCG_SC_ATMF(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_SC_ATMF_SHIFT))&MCG_SC_ATMF_MASK)
#define MCG_SC_ATMS_MASK                         0x40u
#define MCG_SC_ATMS_SHIFT                        6
#define MCG_SC_ATMS_WIDTH                        1
#define MCG_SC_ATMS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_SC_ATMS_SHIFT))&MCG_SC_ATMS_MASK)
#define MCG_SC_ATME_MASK                         0x80u
#define MCG_SC_ATME_SHIFT                        7
#define MCG_SC_ATME_WIDTH                        1
#define MCG_SC_ATME(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_SC_ATME_SHIFT))&MCG_SC_ATME_MASK)
/* ATCVH Bit Fields */
#define MCG_ATCVH_ATCVH_MASK                     0xFFu
#define MCG_ATCVH_ATCVH_SHIFT                    0
#define MCG_ATCVH_ATCVH_WIDTH                    8
#define MCG_ATCVH_ATCVH(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_ATCVH_ATCVH_SHIFT))&MCG_ATCVH_ATCVH_MASK)
/* ATCVL Bit Fields */
#define MCG_ATCVL_ATCVL_MASK                     0xFFu
#define MCG_ATCVL_ATCVL_SHIFT                    0
#define MCG_ATCVL_ATCVL_WIDTH                    8
#define MCG_ATCVL_ATCVL(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_ATCVL_ATCVL_SHIFT))&MCG_ATCVL_ATCVL_MASK)
/* C7 Bit Fields */
#define MCG_C7_OSCSEL_MASK                       0x3u
#define MCG_C7_OSCSEL_SHIFT                      0
#define MCG_C7_OSCSEL_WIDTH                      2
#define MCG_C7_OSCSEL(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C7_OSCSEL_SHIFT))&MCG_C7_OSCSEL_MASK)
/* C8 Bit Fields */
#define MCG_C8_LOCS1_MASK                        0x1u
#define MCG_C8_LOCS1_SHIFT                       0
#define MCG_C8_LOCS1_WIDTH                       1
#define MCG_C8_LOCS1(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C8_LOCS1_SHIFT))&MCG_C8_LOCS1_MASK)
#define MCG_C8_CME1_MASK                         0x20u
#define MCG_C8_CME1_SHIFT                        5
#define MCG_C8_CME1_WIDTH                        1
#define MCG_C8_CME1(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C8_CME1_SHIFT))&MCG_C8_CME1_MASK)
#define MCG_C8_LOLRE_MASK                        0x40u
#define MCG_C8_LOLRE_SHIFT                       6
#define MCG_C8_LOLRE_WIDTH                       1
#define MCG_C8_LOLRE(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C8_LOLRE_SHIFT))&MCG_C8_LOLRE_MASK)
#define MCG_C8_LOCRE1_MASK                       0x80u
#define MCG_C8_LOCRE1_SHIFT                      7
#define MCG_C8_LOCRE1_WIDTH                      1
#define MCG_C8_LOCRE1(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C8_LOCRE1_SHIFT))&MCG_C8_LOCRE1_MASK)

/*!
 * @}
 */ /* end of group MCG_Register_Masks */


/* MCG - Peripheral instance base addresses */
/** Peripheral MCG base address */
#define MCG_BASE                                 (0x40064000u)
/** Peripheral MCG base pointer */
#define MCG                                      ((MCG_Type *)MCG_BASE)
#define MCG_BASE_PTR                             (MCG)
/** Array initializer of MCG peripheral base addresses */
#define MCG_BASE_ADDRS                           { MCG_BASE }
/** Array initializer of MCG peripheral base pointers */
#define MCG_BASE_PTRS                            { MCG }

/* ----------------------------------------------------------------------------
   -- MCG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Accessor_Macros MCG - Register accessor macros
 * @{
 */


/* MCG - Register instance definitions */
/* MCG */
#define MCG_C1                                   MCG_C1_REG(MCG)
#define MCG_C2                                   MCG_C2_REG(MCG)
#define MCG_C3                                   MCG_C3_REG(MCG)
#define MCG_C4                                   MCG_C4_REG(MCG)
#define MCG_C5                                   MCG_C5_REG(MCG)
#define MCG_C6                                   MCG_C6_REG(MCG)
#define MCG_S                                    MCG_S_REG(MCG)
#define MCG_SC                                   MCG_SC_REG(MCG)
#define MCG_ATCVH                                MCG_ATCVH_REG(MCG)
#define MCG_ATCVL                                MCG_ATCVL_REG(MCG)
#define MCG_C7                                   MCG_C7_REG(MCG)
#define MCG_C8                                   MCG_C8_REG(MCG)

/*!
 * @}
 */ /* end of group MCG_Register_Accessor_Macros */

/* MCG C5[PLLCLKEN0] backward compatibility */
#define MCG_C5_PLLCLKEN0_MASK         (MCG_C5_PLLCLKEN_MASK)
#define MCG_C5_PLLCLKEN0_SHIFT        (MCG_C5_PLLCLKEN_SHIFT)
#define MCG_C5_PLLCLKEN0_WIDTH        (MCG_C5_PLLCLKEN_WIDTH)
#define MCG_C5_PLLCLKEN0(x)           (MCG_C5_PLLCLKEN(x))

/* MCG C5[PLLSTEN0] backward compatibility */
#define MCG_C5_PLLSTEN0_MASK         (MCG_C5_PLLSTEN_MASK)
#define MCG_C5_PLLSTEN0_SHIFT        (MCG_C5_PLLSTEN_SHIFT)
#define MCG_C5_PLLSTEN0_WIDTH        (MCG_C5_PLLSTEN_WIDTH)
#define MCG_C5_PLLSTEN0(x)           (MCG_C5_PLLSTEN(x))

/* MCG C5[PRDIV0] backward compatibility */
#define MCG_C5_PRDIV0_MASK         (MCG_C5_PRDIV_MASK)
#define MCG_C5_PRDIV0_SHIFT        (MCG_C5_PRDIV_SHIFT)
#define MCG_C5_PRDIV0_WIDTH        (MCG_C5_PRDIV_WIDTH)
#define MCG_C5_PRDIV0(x)           (MCG_C5_PRDIV(x))

/* MCG C6[VDIV0] backward compatibility */
#define MCG_C6_VDIV0_MASK         (MCG_C6_VDIV_MASK)
#define MCG_C6_VDIV0_SHIFT        (MCG_C6_VDIV_SHIFT)
#define MCG_C6_VDIV0_WIDTH        (MCG_C6_VDIV_WIDTH)
#define MCG_C6_VDIV0(x)           (MCG_C6_VDIV(x))


/*!
 * @}
 */ /* end of group MCG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Peripheral_Access_Layer MCM Peripheral Access Layer
 * @{
 */

/** MCM - Register Layout Typedef */
typedef struct {
  __I  uint32_t PCT;                               /**< Processor core type, offset: 0x0 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CR;                                /**< Control Register, offset: 0xC */
  __IO uint32_t ISCR;                              /**< Interrupt Status and Control Register, offset: 0x10 */
       uint8_t RESERVED_1[32];
  __IO uint32_t CPO;                               /**< Compute Only Operation Control Register, offset: 0x34 */
       uint8_t RESERVED_2[968];
  __I  uint32_t LMEM[5];                           /**< Local Memory General Descriptor Register, array offset: 0x400, array step: 0x4 */
} MCM_Type, *MCM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Accessor_Macros MCM - Register accessor macros
 * @{
 */


/* MCM - Register accessors */
#define MCM_PCT_REG(base)                        ((base)->PCT)
#define MCM_CR_REG(base)                         ((base)->CR)
#define MCM_ISCR_REG(base)                       ((base)->ISCR)
#define MCM_CPO_REG(base)                        ((base)->CPO)
#define MCM_LMEM_REG(base,index)                 ((base)->LMEM[index])
#define MCM_LMEM_COUNT                           5

/*!
 * @}
 */ /* end of group MCM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Masks MCM Register Masks
 * @{
 */

/* PCT Bit Fields */
#define MCM_PCT_PLREV_MASK                       0xFFFFu
#define MCM_PCT_PLREV_SHIFT                      0
#define MCM_PCT_PLREV_WIDTH                      16
#define MCM_PCT_PLREV(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_PCT_PLREV_SHIFT))&MCM_PCT_PLREV_MASK)
#define MCM_PCT_PCT_MASK                         0xFFFF0000u
#define MCM_PCT_PCT_SHIFT                        16
#define MCM_PCT_PCT_WIDTH                        16
#define MCM_PCT_PCT(x)                           (((uint32_t)(((uint32_t)(x))<<MCM_PCT_PCT_SHIFT))&MCM_PCT_PCT_MASK)
/* CR Bit Fields */
#define MCM_CR_AHBSPRI_MASK                      0x8000000u
#define MCM_CR_AHBSPRI_SHIFT                     27
#define MCM_CR_AHBSPRI_WIDTH                     1
#define MCM_CR_AHBSPRI(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_CR_AHBSPRI_SHIFT))&MCM_CR_AHBSPRI_MASK)
/* ISCR Bit Fields */
#define MCM_ISCR_WABORTS_MASK                    0x20u
#define MCM_ISCR_WABORTS_SHIFT                   5
#define MCM_ISCR_WABORTS_WIDTH                   1
#define MCM_ISCR_WABORTS(x)                      (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_WABORTS_SHIFT))&MCM_ISCR_WABORTS_MASK)
#define MCM_ISCR_WABORTS_OVERRUN_MASK            0x40u
#define MCM_ISCR_WABORTS_OVERRUN_SHIFT           6
#define MCM_ISCR_WABORTS_OVERRUN_WIDTH           1
#define MCM_ISCR_WABORTS_OVERRUN(x)              (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_WABORTS_OVERRUN_SHIFT))&MCM_ISCR_WABORTS_OVERRUN_MASK)
#define MCM_ISCR_FIOC_MASK                       0x100u
#define MCM_ISCR_FIOC_SHIFT                      8
#define MCM_ISCR_FIOC_WIDTH                      1
#define MCM_ISCR_FIOC(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FIOC_SHIFT))&MCM_ISCR_FIOC_MASK)
#define MCM_ISCR_FDZC_MASK                       0x200u
#define MCM_ISCR_FDZC_SHIFT                      9
#define MCM_ISCR_FDZC_WIDTH                      1
#define MCM_ISCR_FDZC(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FDZC_SHIFT))&MCM_ISCR_FDZC_MASK)
#define MCM_ISCR_FOFC_MASK                       0x400u
#define MCM_ISCR_FOFC_SHIFT                      10
#define MCM_ISCR_FOFC_WIDTH                      1
#define MCM_ISCR_FOFC(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FOFC_SHIFT))&MCM_ISCR_FOFC_MASK)
#define MCM_ISCR_FUFC_MASK                       0x800u
#define MCM_ISCR_FUFC_SHIFT                      11
#define MCM_ISCR_FUFC_WIDTH                      1
#define MCM_ISCR_FUFC(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FUFC_SHIFT))&MCM_ISCR_FUFC_MASK)
#define MCM_ISCR_FIXC_MASK                       0x1000u
#define MCM_ISCR_FIXC_SHIFT                      12
#define MCM_ISCR_FIXC_WIDTH                      1
#define MCM_ISCR_FIXC(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FIXC_SHIFT))&MCM_ISCR_FIXC_MASK)
#define MCM_ISCR_FIDC_MASK                       0x8000u
#define MCM_ISCR_FIDC_SHIFT                      15
#define MCM_ISCR_FIDC_WIDTH                      1
#define MCM_ISCR_FIDC(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FIDC_SHIFT))&MCM_ISCR_FIDC_MASK)
#define MCM_ISCR_WABORTS_EN_MASK                 0x200000u
#define MCM_ISCR_WABORTS_EN_SHIFT                21
#define MCM_ISCR_WABORTS_EN_WIDTH                1
#define MCM_ISCR_WABORTS_EN(x)                   (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_WABORTS_EN_SHIFT))&MCM_ISCR_WABORTS_EN_MASK)
#define MCM_ISCR_FIOCE_MASK                      0x1000000u
#define MCM_ISCR_FIOCE_SHIFT                     24
#define MCM_ISCR_FIOCE_WIDTH                     1
#define MCM_ISCR_FIOCE(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FIOCE_SHIFT))&MCM_ISCR_FIOCE_MASK)
#define MCM_ISCR_FDZCE_MASK                      0x2000000u
#define MCM_ISCR_FDZCE_SHIFT                     25
#define MCM_ISCR_FDZCE_WIDTH                     1
#define MCM_ISCR_FDZCE(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FDZCE_SHIFT))&MCM_ISCR_FDZCE_MASK)
#define MCM_ISCR_FOFCE_MASK                      0x4000000u
#define MCM_ISCR_FOFCE_SHIFT                     26
#define MCM_ISCR_FOFCE_WIDTH                     1
#define MCM_ISCR_FOFCE(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FOFCE_SHIFT))&MCM_ISCR_FOFCE_MASK)
#define MCM_ISCR_FUFCE_MASK                      0x8000000u
#define MCM_ISCR_FUFCE_SHIFT                     27
#define MCM_ISCR_FUFCE_WIDTH                     1
#define MCM_ISCR_FUFCE(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FUFCE_SHIFT))&MCM_ISCR_FUFCE_MASK)
#define MCM_ISCR_FIXCE_MASK                      0x10000000u
#define MCM_ISCR_FIXCE_SHIFT                     28
#define MCM_ISCR_FIXCE_WIDTH                     1
#define MCM_ISCR_FIXCE(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FIXCE_SHIFT))&MCM_ISCR_FIXCE_MASK)
#define MCM_ISCR_FIDCE_MASK                      0x80000000u
#define MCM_ISCR_FIDCE_SHIFT                     31
#define MCM_ISCR_FIDCE_WIDTH                     1
#define MCM_ISCR_FIDCE(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_ISCR_FIDCE_SHIFT))&MCM_ISCR_FIDCE_MASK)
/* CPO Bit Fields */
#define MCM_CPO_CPOREQ_MASK                      0x1u
#define MCM_CPO_CPOREQ_SHIFT                     0
#define MCM_CPO_CPOREQ_WIDTH                     1
#define MCM_CPO_CPOREQ(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_CPO_CPOREQ_SHIFT))&MCM_CPO_CPOREQ_MASK)
#define MCM_CPO_CPOACK_MASK                      0x2u
#define MCM_CPO_CPOACK_SHIFT                     1
#define MCM_CPO_CPOACK_WIDTH                     1
#define MCM_CPO_CPOACK(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_CPO_CPOACK_SHIFT))&MCM_CPO_CPOACK_MASK)
/* LMEM Bit Fields */
#define MCM_LMEM_LMEM_Type_MASK                  0xE000u
#define MCM_LMEM_LMEM_Type_SHIFT                 13
#define MCM_LMEM_LMEM_Type_WIDTH                 3
#define MCM_LMEM_LMEM_Type(x)                    (((uint32_t)(((uint32_t)(x))<<MCM_LMEM_LMEM_Type_SHIFT))&MCM_LMEM_LMEM_Type_MASK)
#define MCM_LMEM_LMEM_Width_MASK                 0xE0000u
#define MCM_LMEM_LMEM_Width_SHIFT                17
#define MCM_LMEM_LMEM_Width_WIDTH                3
#define MCM_LMEM_LMEM_Width(x)                   (((uint32_t)(((uint32_t)(x))<<MCM_LMEM_LMEM_Width_SHIFT))&MCM_LMEM_LMEM_Width_MASK)
#define MCM_LMEM_LMEM_Ways_MASK                  0xF00000u
#define MCM_LMEM_LMEM_Ways_SHIFT                 20
#define MCM_LMEM_LMEM_Ways_WIDTH                 4
#define MCM_LMEM_LMEM_Ways(x)                    (((uint32_t)(((uint32_t)(x))<<MCM_LMEM_LMEM_Ways_SHIFT))&MCM_LMEM_LMEM_Ways_MASK)
#define MCM_LMEM_LMEM_Size_MASK                  0xF000000u
#define MCM_LMEM_LMEM_Size_SHIFT                 24
#define MCM_LMEM_LMEM_Size_WIDTH                 4
#define MCM_LMEM_LMEM_Size(x)                    (((uint32_t)(((uint32_t)(x))<<MCM_LMEM_LMEM_Size_SHIFT))&MCM_LMEM_LMEM_Size_MASK)
#define MCM_LMEM_LMEM_Valid_MASK                 0x80000000u
#define MCM_LMEM_LMEM_Valid_SHIFT                31
#define MCM_LMEM_LMEM_Valid_WIDTH                1
#define MCM_LMEM_LMEM_Valid(x)                   (((uint32_t)(((uint32_t)(x))<<MCM_LMEM_LMEM_Valid_SHIFT))&MCM_LMEM_LMEM_Valid_MASK)

/*!
 * @}
 */ /* end of group MCM_Register_Masks */


/* MCM - Peripheral instance base addresses */
/** Peripheral MCM base address */
#define MCM_BASE                                 (0xE0080000u)
/** Peripheral MCM base pointer */
#define MCM                                      ((MCM_Type *)MCM_BASE)
#define MCM_BASE_PTR                             (MCM)
/** Array initializer of MCM peripheral base addresses */
#define MCM_BASE_ADDRS                           { MCM_BASE }
/** Array initializer of MCM peripheral base pointers */
#define MCM_BASE_PTRS                            { MCM }

/* ----------------------------------------------------------------------------
   -- MCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Accessor_Macros MCM - Register accessor macros
 * @{
 */


/* MCM - Register instance definitions */
/* MCM */
#define MCM_PCT                                  MCM_PCT_REG(MCM)
#define MCM_CR                                   MCM_CR_REG(MCM)
#define MCM_ISCR                                 MCM_ISCR_REG(MCM)
#define MCM_CPO                                  MCM_CPO_REG(MCM)
#define MCM_LMEM0                                MCM_LMEM_REG(MCM,0)
#define MCM_LMEM1                                MCM_LMEM_REG(MCM,1)
#define MCM_LMEM2                                MCM_LMEM_REG(MCM,2)
#define MCM_LMEM3                                MCM_LMEM_REG(MCM,3)
#define MCM_LMEM4                                MCM_LMEM_REG(MCM,4)

/* MCM - Register array accessors */
#define MCM_LMEM(index)                          MCM_LMEM_REG(MCM,index)

/*!
 * @}
 */ /* end of group MCM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MCM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MPU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Peripheral_Access_Layer MPU Peripheral Access Layer
 * @{
 */

/** MPU - Register Layout Typedef */
typedef struct {
  __IO uint32_t CESR;                              /**< Control/Error Status Register, offset: 0x0 */
       uint8_t RESERVED_0[12];
  struct {                                         /* offset: 0x10, array step: 0x8 */
    __I  uint32_t EAR;                               /**< Error Address Register, slave port n, array offset: 0x10, array step: 0x8 */
    __I  uint32_t EDR;                               /**< Error Detail Register, slave port n, array offset: 0x14, array step: 0x8 */
  } SP[5];
       uint8_t RESERVED_1[968];
  __IO uint32_t WORD[12][4];                       /**< Region Descriptor n, Word 0..Region Descriptor n, Word 3, array offset: 0x400, array step: index*0x10, index2*0x4 */
       uint8_t RESERVED_2[832];
  __IO uint32_t RGDAAC[12];                        /**< Region Descriptor Alternate Access Control n, array offset: 0x800, array step: 0x4 */
} MPU_Type, *MPU_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MPU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Register_Accessor_Macros MPU - Register accessor macros
 * @{
 */


/* MPU - Register accessors */
#define MPU_CESR_REG(base)                       ((base)->CESR)
#define MPU_EAR_REG(base,index)                  ((base)->SP[index].EAR)
#define MPU_EAR_COUNT                            5
#define MPU_EDR_REG(base,index)                  ((base)->SP[index].EDR)
#define MPU_EDR_COUNT                            5
#define MPU_WORD_REG(base,index,index2)          ((base)->WORD[index][index2])
#define MPU_WORD_COUNT                           12
#define MPU_WORD_COUNT2                          4
#define MPU_RGDAAC_REG(base,index)               ((base)->RGDAAC[index])
#define MPU_RGDAAC_COUNT                         12

/*!
 * @}
 */ /* end of group MPU_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MPU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Register_Masks MPU Register Masks
 * @{
 */

/* CESR Bit Fields */
#define MPU_CESR_VLD_MASK                        0x1u
#define MPU_CESR_VLD_SHIFT                       0
#define MPU_CESR_VLD_WIDTH                       1
#define MPU_CESR_VLD(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_CESR_VLD_SHIFT))&MPU_CESR_VLD_MASK)
#define MPU_CESR_NRGD_MASK                       0xF00u
#define MPU_CESR_NRGD_SHIFT                      8
#define MPU_CESR_NRGD_WIDTH                      4
#define MPU_CESR_NRGD(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_CESR_NRGD_SHIFT))&MPU_CESR_NRGD_MASK)
#define MPU_CESR_NSP_MASK                        0xF000u
#define MPU_CESR_NSP_SHIFT                       12
#define MPU_CESR_NSP_WIDTH                       4
#define MPU_CESR_NSP(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_CESR_NSP_SHIFT))&MPU_CESR_NSP_MASK)
#define MPU_CESR_HRL_MASK                        0xF0000u
#define MPU_CESR_HRL_SHIFT                       16
#define MPU_CESR_HRL_WIDTH                       4
#define MPU_CESR_HRL(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_CESR_HRL_SHIFT))&MPU_CESR_HRL_MASK)
#define MPU_CESR_SPERR_MASK                      0xF8000000u
#define MPU_CESR_SPERR_SHIFT                     27
#define MPU_CESR_SPERR_WIDTH                     5
#define MPU_CESR_SPERR(x)                        (((uint32_t)(((uint32_t)(x))<<MPU_CESR_SPERR_SHIFT))&MPU_CESR_SPERR_MASK)
/* EAR Bit Fields */
#define MPU_EAR_EADDR_MASK                       0xFFFFFFFFu
#define MPU_EAR_EADDR_SHIFT                      0
#define MPU_EAR_EADDR_WIDTH                      32
#define MPU_EAR_EADDR(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_EAR_EADDR_SHIFT))&MPU_EAR_EADDR_MASK)
/* EDR Bit Fields */
#define MPU_EDR_ERW_MASK                         0x1u
#define MPU_EDR_ERW_SHIFT                        0
#define MPU_EDR_ERW_WIDTH                        1
#define MPU_EDR_ERW(x)                           (((uint32_t)(((uint32_t)(x))<<MPU_EDR_ERW_SHIFT))&MPU_EDR_ERW_MASK)
#define MPU_EDR_EATTR_MASK                       0xEu
#define MPU_EDR_EATTR_SHIFT                      1
#define MPU_EDR_EATTR_WIDTH                      3
#define MPU_EDR_EATTR(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EATTR_SHIFT))&MPU_EDR_EATTR_MASK)
#define MPU_EDR_EMN_MASK                         0xF0u
#define MPU_EDR_EMN_SHIFT                        4
#define MPU_EDR_EMN_WIDTH                        4
#define MPU_EDR_EMN(x)                           (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EMN_SHIFT))&MPU_EDR_EMN_MASK)
#define MPU_EDR_EPID_MASK                        0xFF00u
#define MPU_EDR_EPID_SHIFT                       8
#define MPU_EDR_EPID_WIDTH                       8
#define MPU_EDR_EPID(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EPID_SHIFT))&MPU_EDR_EPID_MASK)
#define MPU_EDR_EACD_MASK                        0xFFFF0000u
#define MPU_EDR_EACD_SHIFT                       16
#define MPU_EDR_EACD_WIDTH                       16
#define MPU_EDR_EACD(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EACD_SHIFT))&MPU_EDR_EACD_MASK)
/* WORD Bit Fields */
#define MPU_WORD_VLD_MASK                        0x1u
#define MPU_WORD_VLD_SHIFT                       0
#define MPU_WORD_VLD_WIDTH                       1
#define MPU_WORD_VLD(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_WORD_VLD_SHIFT))&MPU_WORD_VLD_MASK)
#define MPU_WORD_M0UM_MASK                       0x7u
#define MPU_WORD_M0UM_SHIFT                      0
#define MPU_WORD_M0UM_WIDTH                      3
#define MPU_WORD_M0UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M0UM_SHIFT))&MPU_WORD_M0UM_MASK)
#define MPU_WORD_M0SM_MASK                       0x18u
#define MPU_WORD_M0SM_SHIFT                      3
#define MPU_WORD_M0SM_WIDTH                      2
#define MPU_WORD_M0SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M0SM_SHIFT))&MPU_WORD_M0SM_MASK)
#define MPU_WORD_M0PE_MASK                       0x20u
#define MPU_WORD_M0PE_SHIFT                      5
#define MPU_WORD_M0PE_WIDTH                      1
#define MPU_WORD_M0PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M0PE_SHIFT))&MPU_WORD_M0PE_MASK)
#define MPU_WORD_ENDADDR_MASK                    0xFFFFFFE0u
#define MPU_WORD_ENDADDR_SHIFT                   5
#define MPU_WORD_ENDADDR_WIDTH                   27
#define MPU_WORD_ENDADDR(x)                      (((uint32_t)(((uint32_t)(x))<<MPU_WORD_ENDADDR_SHIFT))&MPU_WORD_ENDADDR_MASK)
#define MPU_WORD_SRTADDR_MASK                    0xFFFFFFE0u
#define MPU_WORD_SRTADDR_SHIFT                   5
#define MPU_WORD_SRTADDR_WIDTH                   27
#define MPU_WORD_SRTADDR(x)                      (((uint32_t)(((uint32_t)(x))<<MPU_WORD_SRTADDR_SHIFT))&MPU_WORD_SRTADDR_MASK)
#define MPU_WORD_M1UM_MASK                       0x1C0u
#define MPU_WORD_M1UM_SHIFT                      6
#define MPU_WORD_M1UM_WIDTH                      3
#define MPU_WORD_M1UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M1UM_SHIFT))&MPU_WORD_M1UM_MASK)
#define MPU_WORD_M1SM_MASK                       0x600u
#define MPU_WORD_M1SM_SHIFT                      9
#define MPU_WORD_M1SM_WIDTH                      2
#define MPU_WORD_M1SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M1SM_SHIFT))&MPU_WORD_M1SM_MASK)
#define MPU_WORD_M1PE_MASK                       0x800u
#define MPU_WORD_M1PE_SHIFT                      11
#define MPU_WORD_M1PE_WIDTH                      1
#define MPU_WORD_M1PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M1PE_SHIFT))&MPU_WORD_M1PE_MASK)
#define MPU_WORD_M2UM_MASK                       0x7000u
#define MPU_WORD_M2UM_SHIFT                      12
#define MPU_WORD_M2UM_WIDTH                      3
#define MPU_WORD_M2UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M2UM_SHIFT))&MPU_WORD_M2UM_MASK)
#define MPU_WORD_M2SM_MASK                       0x18000u
#define MPU_WORD_M2SM_SHIFT                      15
#define MPU_WORD_M2SM_WIDTH                      2
#define MPU_WORD_M2SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M2SM_SHIFT))&MPU_WORD_M2SM_MASK)
#define MPU_WORD_PIDMASK_MASK                    0xFF0000u
#define MPU_WORD_PIDMASK_SHIFT                   16
#define MPU_WORD_PIDMASK_WIDTH                   8
#define MPU_WORD_PIDMASK(x)                      (((uint32_t)(((uint32_t)(x))<<MPU_WORD_PIDMASK_SHIFT))&MPU_WORD_PIDMASK_MASK)
#define MPU_WORD_M2PE_MASK                       0x20000u
#define MPU_WORD_M2PE_SHIFT                      17
#define MPU_WORD_M2PE_WIDTH                      1
#define MPU_WORD_M2PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M2PE_SHIFT))&MPU_WORD_M2PE_MASK)
#define MPU_WORD_M3UM_MASK                       0x1C0000u
#define MPU_WORD_M3UM_SHIFT                      18
#define MPU_WORD_M3UM_WIDTH                      3
#define MPU_WORD_M3UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M3UM_SHIFT))&MPU_WORD_M3UM_MASK)
#define MPU_WORD_M3SM_MASK                       0x600000u
#define MPU_WORD_M3SM_SHIFT                      21
#define MPU_WORD_M3SM_WIDTH                      2
#define MPU_WORD_M3SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M3SM_SHIFT))&MPU_WORD_M3SM_MASK)
#define MPU_WORD_M3PE_MASK                       0x800000u
#define MPU_WORD_M3PE_SHIFT                      23
#define MPU_WORD_M3PE_WIDTH                      1
#define MPU_WORD_M3PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M3PE_SHIFT))&MPU_WORD_M3PE_MASK)
#define MPU_WORD_PID_MASK                        0xFF000000u
#define MPU_WORD_PID_SHIFT                       24
#define MPU_WORD_PID_WIDTH                       8
#define MPU_WORD_PID(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_WORD_PID_SHIFT))&MPU_WORD_PID_MASK)
#define MPU_WORD_M4WE_MASK                       0x1000000u
#define MPU_WORD_M4WE_SHIFT                      24
#define MPU_WORD_M4WE_WIDTH                      1
#define MPU_WORD_M4WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M4WE_SHIFT))&MPU_WORD_M4WE_MASK)
#define MPU_WORD_M4RE_MASK                       0x2000000u
#define MPU_WORD_M4RE_SHIFT                      25
#define MPU_WORD_M4RE_WIDTH                      1
#define MPU_WORD_M4RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M4RE_SHIFT))&MPU_WORD_M4RE_MASK)
#define MPU_WORD_M5WE_MASK                       0x4000000u
#define MPU_WORD_M5WE_SHIFT                      26
#define MPU_WORD_M5WE_WIDTH                      1
#define MPU_WORD_M5WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M5WE_SHIFT))&MPU_WORD_M5WE_MASK)
#define MPU_WORD_M5RE_MASK                       0x8000000u
#define MPU_WORD_M5RE_SHIFT                      27
#define MPU_WORD_M5RE_WIDTH                      1
#define MPU_WORD_M5RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M5RE_SHIFT))&MPU_WORD_M5RE_MASK)
#define MPU_WORD_M6WE_MASK                       0x10000000u
#define MPU_WORD_M6WE_SHIFT                      28
#define MPU_WORD_M6WE_WIDTH                      1
#define MPU_WORD_M6WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M6WE_SHIFT))&MPU_WORD_M6WE_MASK)
#define MPU_WORD_M6RE_MASK                       0x20000000u
#define MPU_WORD_M6RE_SHIFT                      29
#define MPU_WORD_M6RE_WIDTH                      1
#define MPU_WORD_M6RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M6RE_SHIFT))&MPU_WORD_M6RE_MASK)
#define MPU_WORD_M7WE_MASK                       0x40000000u
#define MPU_WORD_M7WE_SHIFT                      30
#define MPU_WORD_M7WE_WIDTH                      1
#define MPU_WORD_M7WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M7WE_SHIFT))&MPU_WORD_M7WE_MASK)
#define MPU_WORD_M7RE_MASK                       0x80000000u
#define MPU_WORD_M7RE_SHIFT                      31
#define MPU_WORD_M7RE_WIDTH                      1
#define MPU_WORD_M7RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M7RE_SHIFT))&MPU_WORD_M7RE_MASK)
/* RGDAAC Bit Fields */
#define MPU_RGDAAC_M0UM_MASK                     0x7u
#define MPU_RGDAAC_M0UM_SHIFT                    0
#define MPU_RGDAAC_M0UM_WIDTH                    3
#define MPU_RGDAAC_M0UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M0UM_SHIFT))&MPU_RGDAAC_M0UM_MASK)
#define MPU_RGDAAC_M0SM_MASK                     0x18u
#define MPU_RGDAAC_M0SM_SHIFT                    3
#define MPU_RGDAAC_M0SM_WIDTH                    2
#define MPU_RGDAAC_M0SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M0SM_SHIFT))&MPU_RGDAAC_M0SM_MASK)
#define MPU_RGDAAC_M0PE_MASK                     0x20u
#define MPU_RGDAAC_M0PE_SHIFT                    5
#define MPU_RGDAAC_M0PE_WIDTH                    1
#define MPU_RGDAAC_M0PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M0PE_SHIFT))&MPU_RGDAAC_M0PE_MASK)
#define MPU_RGDAAC_M1UM_MASK                     0x1C0u
#define MPU_RGDAAC_M1UM_SHIFT                    6
#define MPU_RGDAAC_M1UM_WIDTH                    3
#define MPU_RGDAAC_M1UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M1UM_SHIFT))&MPU_RGDAAC_M1UM_MASK)
#define MPU_RGDAAC_M1SM_MASK                     0x600u
#define MPU_RGDAAC_M1SM_SHIFT                    9
#define MPU_RGDAAC_M1SM_WIDTH                    2
#define MPU_RGDAAC_M1SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M1SM_SHIFT))&MPU_RGDAAC_M1SM_MASK)
#define MPU_RGDAAC_M1PE_MASK                     0x800u
#define MPU_RGDAAC_M1PE_SHIFT                    11
#define MPU_RGDAAC_M1PE_WIDTH                    1
#define MPU_RGDAAC_M1PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M1PE_SHIFT))&MPU_RGDAAC_M1PE_MASK)
#define MPU_RGDAAC_M2UM_MASK                     0x7000u
#define MPU_RGDAAC_M2UM_SHIFT                    12
#define MPU_RGDAAC_M2UM_WIDTH                    3
#define MPU_RGDAAC_M2UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M2UM_SHIFT))&MPU_RGDAAC_M2UM_MASK)
#define MPU_RGDAAC_M2SM_MASK                     0x18000u
#define MPU_RGDAAC_M2SM_SHIFT                    15
#define MPU_RGDAAC_M2SM_WIDTH                    2
#define MPU_RGDAAC_M2SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M2SM_SHIFT))&MPU_RGDAAC_M2SM_MASK)
#define MPU_RGDAAC_M2PE_MASK                     0x20000u
#define MPU_RGDAAC_M2PE_SHIFT                    17
#define MPU_RGDAAC_M2PE_WIDTH                    1
#define MPU_RGDAAC_M2PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M2PE_SHIFT))&MPU_RGDAAC_M2PE_MASK)
#define MPU_RGDAAC_M3UM_MASK                     0x1C0000u
#define MPU_RGDAAC_M3UM_SHIFT                    18
#define MPU_RGDAAC_M3UM_WIDTH                    3
#define MPU_RGDAAC_M3UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M3UM_SHIFT))&MPU_RGDAAC_M3UM_MASK)
#define MPU_RGDAAC_M3SM_MASK                     0x600000u
#define MPU_RGDAAC_M3SM_SHIFT                    21
#define MPU_RGDAAC_M3SM_WIDTH                    2
#define MPU_RGDAAC_M3SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M3SM_SHIFT))&MPU_RGDAAC_M3SM_MASK)
#define MPU_RGDAAC_M3PE_MASK                     0x800000u
#define MPU_RGDAAC_M3PE_SHIFT                    23
#define MPU_RGDAAC_M3PE_WIDTH                    1
#define MPU_RGDAAC_M3PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M3PE_SHIFT))&MPU_RGDAAC_M3PE_MASK)
#define MPU_RGDAAC_M4WE_MASK                     0x1000000u
#define MPU_RGDAAC_M4WE_SHIFT                    24
#define MPU_RGDAAC_M4WE_WIDTH                    1
#define MPU_RGDAAC_M4WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M4WE_SHIFT))&MPU_RGDAAC_M4WE_MASK)
#define MPU_RGDAAC_M4RE_MASK                     0x2000000u
#define MPU_RGDAAC_M4RE_SHIFT                    25
#define MPU_RGDAAC_M4RE_WIDTH                    1
#define MPU_RGDAAC_M4RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M4RE_SHIFT))&MPU_RGDAAC_M4RE_MASK)
#define MPU_RGDAAC_M5WE_MASK                     0x4000000u
#define MPU_RGDAAC_M5WE_SHIFT                    26
#define MPU_RGDAAC_M5WE_WIDTH                    1
#define MPU_RGDAAC_M5WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M5WE_SHIFT))&MPU_RGDAAC_M5WE_MASK)
#define MPU_RGDAAC_M5RE_MASK                     0x8000000u
#define MPU_RGDAAC_M5RE_SHIFT                    27
#define MPU_RGDAAC_M5RE_WIDTH                    1
#define MPU_RGDAAC_M5RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M5RE_SHIFT))&MPU_RGDAAC_M5RE_MASK)
#define MPU_RGDAAC_M6WE_MASK                     0x10000000u
#define MPU_RGDAAC_M6WE_SHIFT                    28
#define MPU_RGDAAC_M6WE_WIDTH                    1
#define MPU_RGDAAC_M6WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M6WE_SHIFT))&MPU_RGDAAC_M6WE_MASK)
#define MPU_RGDAAC_M6RE_MASK                     0x20000000u
#define MPU_RGDAAC_M6RE_SHIFT                    29
#define MPU_RGDAAC_M6RE_WIDTH                    1
#define MPU_RGDAAC_M6RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M6RE_SHIFT))&MPU_RGDAAC_M6RE_MASK)
#define MPU_RGDAAC_M7WE_MASK                     0x40000000u
#define MPU_RGDAAC_M7WE_SHIFT                    30
#define MPU_RGDAAC_M7WE_WIDTH                    1
#define MPU_RGDAAC_M7WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M7WE_SHIFT))&MPU_RGDAAC_M7WE_MASK)
#define MPU_RGDAAC_M7RE_MASK                     0x80000000u
#define MPU_RGDAAC_M7RE_SHIFT                    31
#define MPU_RGDAAC_M7RE_WIDTH                    1
#define MPU_RGDAAC_M7RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M7RE_SHIFT))&MPU_RGDAAC_M7RE_MASK)

/*!
 * @}
 */ /* end of group MPU_Register_Masks */


/* MPU - Peripheral instance base addresses */
/** Peripheral MPU base address */
#define MPU_BASE                                 (0x4000D000u)
/** Peripheral MPU base pointer */
#define MPU                                      ((MPU_Type *)MPU_BASE)
#define MPU_BASE_PTR                             (MPU)
/** Array initializer of MPU peripheral base addresses */
#define MPU_BASE_ADDRS                           { MPU_BASE }
/** Array initializer of MPU peripheral base pointers */
#define MPU_BASE_PTRS                            { MPU }

/* ----------------------------------------------------------------------------
   -- MPU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Register_Accessor_Macros MPU - Register accessor macros
 * @{
 */


/* MPU - Register instance definitions */
/* MPU */
#define MPU_CESR                                 MPU_CESR_REG(MPU)
#define MPU_EAR0                                 MPU_EAR_REG(MPU,0)
#define MPU_EDR0                                 MPU_EDR_REG(MPU,0)
#define MPU_EAR1                                 MPU_EAR_REG(MPU,1)
#define MPU_EDR1                                 MPU_EDR_REG(MPU,1)
#define MPU_EAR2                                 MPU_EAR_REG(MPU,2)
#define MPU_EDR2                                 MPU_EDR_REG(MPU,2)
#define MPU_EAR3                                 MPU_EAR_REG(MPU,3)
#define MPU_EDR3                                 MPU_EDR_REG(MPU,3)
#define MPU_EAR4                                 MPU_EAR_REG(MPU,4)
#define MPU_EDR4                                 MPU_EDR_REG(MPU,4)
#define MPU_RGD0_WORD0                           MPU_WORD_REG(MPU,0,0)
#define MPU_RGD0_WORD1                           MPU_WORD_REG(MPU,0,1)
#define MPU_RGD0_WORD2                           MPU_WORD_REG(MPU,0,2)
#define MPU_RGD0_WORD3                           MPU_WORD_REG(MPU,0,3)
#define MPU_RGD1_WORD0                           MPU_WORD_REG(MPU,1,0)
#define MPU_RGD1_WORD1                           MPU_WORD_REG(MPU,1,1)
#define MPU_RGD1_WORD2                           MPU_WORD_REG(MPU,1,2)
#define MPU_RGD1_WORD3                           MPU_WORD_REG(MPU,1,3)
#define MPU_RGD2_WORD0                           MPU_WORD_REG(MPU,2,0)
#define MPU_RGD2_WORD1                           MPU_WORD_REG(MPU,2,1)
#define MPU_RGD2_WORD2                           MPU_WORD_REG(MPU,2,2)
#define MPU_RGD2_WORD3                           MPU_WORD_REG(MPU,2,3)
#define MPU_RGD3_WORD0                           MPU_WORD_REG(MPU,3,0)
#define MPU_RGD3_WORD1                           MPU_WORD_REG(MPU,3,1)
#define MPU_RGD3_WORD2                           MPU_WORD_REG(MPU,3,2)
#define MPU_RGD3_WORD3                           MPU_WORD_REG(MPU,3,3)
#define MPU_RGD4_WORD0                           MPU_WORD_REG(MPU,4,0)
#define MPU_RGD4_WORD1                           MPU_WORD_REG(MPU,4,1)
#define MPU_RGD4_WORD2                           MPU_WORD_REG(MPU,4,2)
#define MPU_RGD4_WORD3                           MPU_WORD_REG(MPU,4,3)
#define MPU_RGD5_WORD0                           MPU_WORD_REG(MPU,5,0)
#define MPU_RGD5_WORD1                           MPU_WORD_REG(MPU,5,1)
#define MPU_RGD5_WORD2                           MPU_WORD_REG(MPU,5,2)
#define MPU_RGD5_WORD3                           MPU_WORD_REG(MPU,5,3)
#define MPU_RGD6_WORD0                           MPU_WORD_REG(MPU,6,0)
#define MPU_RGD6_WORD1                           MPU_WORD_REG(MPU,6,1)
#define MPU_RGD6_WORD2                           MPU_WORD_REG(MPU,6,2)
#define MPU_RGD6_WORD3                           MPU_WORD_REG(MPU,6,3)
#define MPU_RGD7_WORD0                           MPU_WORD_REG(MPU,7,0)
#define MPU_RGD7_WORD1                           MPU_WORD_REG(MPU,7,1)
#define MPU_RGD7_WORD2                           MPU_WORD_REG(MPU,7,2)
#define MPU_RGD7_WORD3                           MPU_WORD_REG(MPU,7,3)
#define MPU_RGD8_WORD0                           MPU_WORD_REG(MPU,8,0)
#define MPU_RGD8_WORD1                           MPU_WORD_REG(MPU,8,1)
#define MPU_RGD8_WORD2                           MPU_WORD_REG(MPU,8,2)
#define MPU_RGD8_WORD3                           MPU_WORD_REG(MPU,8,3)
#define MPU_RGD9_WORD0                           MPU_WORD_REG(MPU,9,0)
#define MPU_RGD9_WORD1                           MPU_WORD_REG(MPU,9,1)
#define MPU_RGD9_WORD2                           MPU_WORD_REG(MPU,9,2)
#define MPU_RGD9_WORD3                           MPU_WORD_REG(MPU,9,3)
#define MPU_RGD10_WORD0                          MPU_WORD_REG(MPU,10,0)
#define MPU_RGD10_WORD1                          MPU_WORD_REG(MPU,10,1)
#define MPU_RGD10_WORD2                          MPU_WORD_REG(MPU,10,2)
#define MPU_RGD10_WORD3                          MPU_WORD_REG(MPU,10,3)
#define MPU_RGD11_WORD0                          MPU_WORD_REG(MPU,11,0)
#define MPU_RGD11_WORD1                          MPU_WORD_REG(MPU,11,1)
#define MPU_RGD11_WORD2                          MPU_WORD_REG(MPU,11,2)
#define MPU_RGD11_WORD3                          MPU_WORD_REG(MPU,11,3)
#define MPU_RGDAAC0                              MPU_RGDAAC_REG(MPU,0)
#define MPU_RGDAAC1                              MPU_RGDAAC_REG(MPU,1)
#define MPU_RGDAAC2                              MPU_RGDAAC_REG(MPU,2)
#define MPU_RGDAAC3                              MPU_RGDAAC_REG(MPU,3)
#define MPU_RGDAAC4                              MPU_RGDAAC_REG(MPU,4)
#define MPU_RGDAAC5                              MPU_RGDAAC_REG(MPU,5)
#define MPU_RGDAAC6                              MPU_RGDAAC_REG(MPU,6)
#define MPU_RGDAAC7                              MPU_RGDAAC_REG(MPU,7)
#define MPU_RGDAAC8                              MPU_RGDAAC_REG(MPU,8)
#define MPU_RGDAAC9                              MPU_RGDAAC_REG(MPU,9)
#define MPU_RGDAAC10                             MPU_RGDAAC_REG(MPU,10)
#define MPU_RGDAAC11                             MPU_RGDAAC_REG(MPU,11)

/* MPU - Register array accessors */
#define MPU_EAR(index)                           MPU_EAR_REG(MPU,index)
#define MPU_EDR(index)                           MPU_EDR_REG(MPU,index)
#define MPU_WORD(index,index2)                   MPU_WORD_REG(MPU,index,index2)
#define MPU_RGDAAC(index)                        MPU_RGDAAC_REG(MPU,index)

/*!
 * @}
 */ /* end of group MPU_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MPU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MSCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MSCM_Peripheral_Access_Layer MSCM Peripheral Access Layer
 * @{
 */

/** MSCM - Register Layout Typedef */
typedef struct {
  __I  uint32_t CPxTYPE;                           /**< Processor X Type Register, offset: 0x0 */
  __I  uint32_t CPxNUM;                            /**< Processor X Number Register, offset: 0x4 */
  __I  uint32_t CPxMASTER;                         /**< Processor X Master Register, offset: 0x8 */
  __I  uint32_t CPxCOUNT;                          /**< Processor X Count Register, offset: 0xC */
  __I  uint32_t CPxCFG[4];                         /**< Processor X Configuration Register, array offset: 0x10, array step: 0x4 */
  __I  uint32_t CP0TYPE;                           /**< Processor 0 Type Register, offset: 0x20 */
  __I  uint32_t CP0NUM;                            /**< Processor 0 Number Register, offset: 0x24 */
  __I  uint32_t CP0MASTER;                         /**< Processor 0 Master Register, offset: 0x28 */
  __I  uint32_t CP0COUNT;                          /**< Processor 0 Count Register, offset: 0x2C */
  __I  uint32_t CP0CFG[4];                         /**< Processor 0 Configuration Register, array offset: 0x30, array step: 0x4 */
  __I  uint32_t CP1TYPE;                           /**< Processor 1 Type Register, offset: 0x40 */
  __I  uint32_t CP1NUM;                            /**< Processor 1 Number Register, offset: 0x44 */
  __I  uint32_t CP1MASTER;                         /**< Processor 1 Master Register, offset: 0x48 */
  __I  uint32_t CP1COUNT;                          /**< Processor 1 Count Register, offset: 0x4C */
  __I  uint32_t CP1CFG[4];                         /**< Processor 1 Configuration Register, array offset: 0x50, array step: 0x4 */
       uint8_t RESERVED_0[928];
  __I  uint32_t OCMDR[3];                          /**< On-Chip Memory Descriptor Register, array offset: 0x400, array step: 0x4 */
} MSCM_Type, *MSCM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MSCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MSCM_Register_Accessor_Macros MSCM - Register accessor macros
 * @{
 */


/* MSCM - Register accessors */
#define MSCM_CPxTYPE_REG(base)                   ((base)->CPxTYPE)
#define MSCM_CPxNUM_REG(base)                    ((base)->CPxNUM)
#define MSCM_CPxMASTER_REG(base)                 ((base)->CPxMASTER)
#define MSCM_CPxCOUNT_REG(base)                  ((base)->CPxCOUNT)
#define MSCM_CPxCFG_REG(base,index)              ((base)->CPxCFG[index])
#define MSCM_CPxCFG_COUNT                        4
#define MSCM_CP0TYPE_REG(base)                   ((base)->CP0TYPE)
#define MSCM_CP0NUM_REG(base)                    ((base)->CP0NUM)
#define MSCM_CP0MASTER_REG(base)                 ((base)->CP0MASTER)
#define MSCM_CP0COUNT_REG(base)                  ((base)->CP0COUNT)
#define MSCM_CP0CFG_REG(base,index)              ((base)->CP0CFG[index])
#define MSCM_CP0CFG_COUNT                        4
#define MSCM_CP1TYPE_REG(base)                   ((base)->CP1TYPE)
#define MSCM_CP1NUM_REG(base)                    ((base)->CP1NUM)
#define MSCM_CP1MASTER_REG(base)                 ((base)->CP1MASTER)
#define MSCM_CP1COUNT_REG(base)                  ((base)->CP1COUNT)
#define MSCM_CP1CFG_REG(base,index)              ((base)->CP1CFG[index])
#define MSCM_CP1CFG_COUNT                        4
#define MSCM_OCMDR_REG(base,index)               ((base)->OCMDR[index])
#define MSCM_OCMDR_COUNT                         3

/*!
 * @}
 */ /* end of group MSCM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MSCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MSCM_Register_Masks MSCM Register Masks
 * @{
 */

/* CPxTYPE Bit Fields */
#define MSCM_CPxTYPE_RYPZ_MASK                   0xFFu
#define MSCM_CPxTYPE_RYPZ_SHIFT                  0
#define MSCM_CPxTYPE_RYPZ_WIDTH                  8
#define MSCM_CPxTYPE_RYPZ(x)                     (((uint32_t)(((uint32_t)(x))<<MSCM_CPxTYPE_RYPZ_SHIFT))&MSCM_CPxTYPE_RYPZ_MASK)
#define MSCM_CPxTYPE_PERSONALITY_MASK            0xFFFFFF00u
#define MSCM_CPxTYPE_PERSONALITY_SHIFT           8
#define MSCM_CPxTYPE_PERSONALITY_WIDTH           24
#define MSCM_CPxTYPE_PERSONALITY(x)              (((uint32_t)(((uint32_t)(x))<<MSCM_CPxTYPE_PERSONALITY_SHIFT))&MSCM_CPxTYPE_PERSONALITY_MASK)
/* CPxNUM Bit Fields */
#define MSCM_CPxNUM_CPN_MASK                     0x1u
#define MSCM_CPxNUM_CPN_SHIFT                    0
#define MSCM_CPxNUM_CPN_WIDTH                    1
#define MSCM_CPxNUM_CPN(x)                       (((uint32_t)(((uint32_t)(x))<<MSCM_CPxNUM_CPN_SHIFT))&MSCM_CPxNUM_CPN_MASK)
/* CPxMASTER Bit Fields */
#define MSCM_CPxMASTER_PPN_MASK                  0x3Fu
#define MSCM_CPxMASTER_PPN_SHIFT                 0
#define MSCM_CPxMASTER_PPN_WIDTH                 6
#define MSCM_CPxMASTER_PPN(x)                    (((uint32_t)(((uint32_t)(x))<<MSCM_CPxMASTER_PPN_SHIFT))&MSCM_CPxMASTER_PPN_MASK)
/* CPxCOUNT Bit Fields */
#define MSCM_CPxCOUNT_PCNT_MASK                  0x3u
#define MSCM_CPxCOUNT_PCNT_SHIFT                 0
#define MSCM_CPxCOUNT_PCNT_WIDTH                 2
#define MSCM_CPxCOUNT_PCNT(x)                    (((uint32_t)(((uint32_t)(x))<<MSCM_CPxCOUNT_PCNT_SHIFT))&MSCM_CPxCOUNT_PCNT_MASK)
/* CPxCFG Bit Fields */
#define MSCM_CPxCFG_DCWY_MASK                    0xFFu
#define MSCM_CPxCFG_DCWY_SHIFT                   0
#define MSCM_CPxCFG_DCWY_WIDTH                   8
#define MSCM_CPxCFG_DCWY(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CPxCFG_DCWY_SHIFT))&MSCM_CPxCFG_DCWY_MASK)
#define MSCM_CPxCFG_DCSZ_MASK                    0xFF00u
#define MSCM_CPxCFG_DCSZ_SHIFT                   8
#define MSCM_CPxCFG_DCSZ_WIDTH                   8
#define MSCM_CPxCFG_DCSZ(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CPxCFG_DCSZ_SHIFT))&MSCM_CPxCFG_DCSZ_MASK)
#define MSCM_CPxCFG_ICWY_MASK                    0xFF0000u
#define MSCM_CPxCFG_ICWY_SHIFT                   16
#define MSCM_CPxCFG_ICWY_WIDTH                   8
#define MSCM_CPxCFG_ICWY(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CPxCFG_ICWY_SHIFT))&MSCM_CPxCFG_ICWY_MASK)
#define MSCM_CPxCFG_ICSZ_MASK                    0xFF000000u
#define MSCM_CPxCFG_ICSZ_SHIFT                   24
#define MSCM_CPxCFG_ICSZ_WIDTH                   8
#define MSCM_CPxCFG_ICSZ(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CPxCFG_ICSZ_SHIFT))&MSCM_CPxCFG_ICSZ_MASK)
/* CP0TYPE Bit Fields */
#define MSCM_CP0TYPE_RYPZ_MASK                   0xFFu
#define MSCM_CP0TYPE_RYPZ_SHIFT                  0
#define MSCM_CP0TYPE_RYPZ_WIDTH                  8
#define MSCM_CP0TYPE_RYPZ(x)                     (((uint32_t)(((uint32_t)(x))<<MSCM_CP0TYPE_RYPZ_SHIFT))&MSCM_CP0TYPE_RYPZ_MASK)
#define MSCM_CP0TYPE_PERSONALITY_MASK            0xFFFFFF00u
#define MSCM_CP0TYPE_PERSONALITY_SHIFT           8
#define MSCM_CP0TYPE_PERSONALITY_WIDTH           24
#define MSCM_CP0TYPE_PERSONALITY(x)              (((uint32_t)(((uint32_t)(x))<<MSCM_CP0TYPE_PERSONALITY_SHIFT))&MSCM_CP0TYPE_PERSONALITY_MASK)
/* CP0NUM Bit Fields */
#define MSCM_CP0NUM_CPN_MASK                     0x1u
#define MSCM_CP0NUM_CPN_SHIFT                    0
#define MSCM_CP0NUM_CPN_WIDTH                    1
#define MSCM_CP0NUM_CPN(x)                       (((uint32_t)(((uint32_t)(x))<<MSCM_CP0NUM_CPN_SHIFT))&MSCM_CP0NUM_CPN_MASK)
/* CP0MASTER Bit Fields */
#define MSCM_CP0MASTER_PPN_MASK                  0x3Fu
#define MSCM_CP0MASTER_PPN_SHIFT                 0
#define MSCM_CP0MASTER_PPN_WIDTH                 6
#define MSCM_CP0MASTER_PPN(x)                    (((uint32_t)(((uint32_t)(x))<<MSCM_CP0MASTER_PPN_SHIFT))&MSCM_CP0MASTER_PPN_MASK)
/* CP0COUNT Bit Fields */
#define MSCM_CP0COUNT_PCNT_MASK                  0x3u
#define MSCM_CP0COUNT_PCNT_SHIFT                 0
#define MSCM_CP0COUNT_PCNT_WIDTH                 2
#define MSCM_CP0COUNT_PCNT(x)                    (((uint32_t)(((uint32_t)(x))<<MSCM_CP0COUNT_PCNT_SHIFT))&MSCM_CP0COUNT_PCNT_MASK)
/* CP0CFG Bit Fields */
#define MSCM_CP0CFG_DCWY_MASK                    0xFFu
#define MSCM_CP0CFG_DCWY_SHIFT                   0
#define MSCM_CP0CFG_DCWY_WIDTH                   8
#define MSCM_CP0CFG_DCWY(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP0CFG_DCWY_SHIFT))&MSCM_CP0CFG_DCWY_MASK)
#define MSCM_CP0CFG_DCSZ_MASK                    0xFF00u
#define MSCM_CP0CFG_DCSZ_SHIFT                   8
#define MSCM_CP0CFG_DCSZ_WIDTH                   8
#define MSCM_CP0CFG_DCSZ(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP0CFG_DCSZ_SHIFT))&MSCM_CP0CFG_DCSZ_MASK)
#define MSCM_CP0CFG_ICWY_MASK                    0xFF0000u
#define MSCM_CP0CFG_ICWY_SHIFT                   16
#define MSCM_CP0CFG_ICWY_WIDTH                   8
#define MSCM_CP0CFG_ICWY(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP0CFG_ICWY_SHIFT))&MSCM_CP0CFG_ICWY_MASK)
#define MSCM_CP0CFG_ICSZ_MASK                    0xFF000000u
#define MSCM_CP0CFG_ICSZ_SHIFT                   24
#define MSCM_CP0CFG_ICSZ_WIDTH                   8
#define MSCM_CP0CFG_ICSZ(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP0CFG_ICSZ_SHIFT))&MSCM_CP0CFG_ICSZ_MASK)
/* CP1TYPE Bit Fields */
#define MSCM_CP1TYPE_RYPZ_MASK                   0xFFu
#define MSCM_CP1TYPE_RYPZ_SHIFT                  0
#define MSCM_CP1TYPE_RYPZ_WIDTH                  8
#define MSCM_CP1TYPE_RYPZ(x)                     (((uint32_t)(((uint32_t)(x))<<MSCM_CP1TYPE_RYPZ_SHIFT))&MSCM_CP1TYPE_RYPZ_MASK)
#define MSCM_CP1TYPE_PERSONALITY_MASK            0xFFFFFF00u
#define MSCM_CP1TYPE_PERSONALITY_SHIFT           8
#define MSCM_CP1TYPE_PERSONALITY_WIDTH           24
#define MSCM_CP1TYPE_PERSONALITY(x)              (((uint32_t)(((uint32_t)(x))<<MSCM_CP1TYPE_PERSONALITY_SHIFT))&MSCM_CP1TYPE_PERSONALITY_MASK)
/* CP1NUM Bit Fields */
#define MSCM_CP1NUM_CPN_MASK                     0x1u
#define MSCM_CP1NUM_CPN_SHIFT                    0
#define MSCM_CP1NUM_CPN_WIDTH                    1
#define MSCM_CP1NUM_CPN(x)                       (((uint32_t)(((uint32_t)(x))<<MSCM_CP1NUM_CPN_SHIFT))&MSCM_CP1NUM_CPN_MASK)
/* CP1MASTER Bit Fields */
#define MSCM_CP1MASTER_PPN_MASK                  0x3Fu
#define MSCM_CP1MASTER_PPN_SHIFT                 0
#define MSCM_CP1MASTER_PPN_WIDTH                 6
#define MSCM_CP1MASTER_PPN(x)                    (((uint32_t)(((uint32_t)(x))<<MSCM_CP1MASTER_PPN_SHIFT))&MSCM_CP1MASTER_PPN_MASK)
/* CP1COUNT Bit Fields */
#define MSCM_CP1COUNT_PCNT_MASK                  0x3u
#define MSCM_CP1COUNT_PCNT_SHIFT                 0
#define MSCM_CP1COUNT_PCNT_WIDTH                 2
#define MSCM_CP1COUNT_PCNT(x)                    (((uint32_t)(((uint32_t)(x))<<MSCM_CP1COUNT_PCNT_SHIFT))&MSCM_CP1COUNT_PCNT_MASK)
/* CP1CFG Bit Fields */
#define MSCM_CP1CFG_DCWY_MASK                    0xFFu
#define MSCM_CP1CFG_DCWY_SHIFT                   0
#define MSCM_CP1CFG_DCWY_WIDTH                   8
#define MSCM_CP1CFG_DCWY(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP1CFG_DCWY_SHIFT))&MSCM_CP1CFG_DCWY_MASK)
#define MSCM_CP1CFG_DCSZ_MASK                    0xFF00u
#define MSCM_CP1CFG_DCSZ_SHIFT                   8
#define MSCM_CP1CFG_DCSZ_WIDTH                   8
#define MSCM_CP1CFG_DCSZ(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP1CFG_DCSZ_SHIFT))&MSCM_CP1CFG_DCSZ_MASK)
#define MSCM_CP1CFG_ICWY_MASK                    0xFF0000u
#define MSCM_CP1CFG_ICWY_SHIFT                   16
#define MSCM_CP1CFG_ICWY_WIDTH                   8
#define MSCM_CP1CFG_ICWY(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP1CFG_ICWY_SHIFT))&MSCM_CP1CFG_ICWY_MASK)
#define MSCM_CP1CFG_ICSZ_MASK                    0xFF000000u
#define MSCM_CP1CFG_ICSZ_SHIFT                   24
#define MSCM_CP1CFG_ICSZ_WIDTH                   8
#define MSCM_CP1CFG_ICSZ(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_CP1CFG_ICSZ_SHIFT))&MSCM_CP1CFG_ICSZ_MASK)
/* OCMDR Bit Fields */
#define MSCM_OCMDR_OCMPU_MASK                    0x1000u
#define MSCM_OCMDR_OCMPU_SHIFT                   12
#define MSCM_OCMDR_OCMPU_WIDTH                   1
#define MSCM_OCMDR_OCMPU(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_OCMPU_SHIFT))&MSCM_OCMDR_OCMPU_MASK)
#define MSCM_OCMDR_OCMT_MASK                     0xE000u
#define MSCM_OCMDR_OCMT_SHIFT                    13
#define MSCM_OCMDR_OCMT_WIDTH                    3
#define MSCM_OCMDR_OCMT(x)                       (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_OCMT_SHIFT))&MSCM_OCMDR_OCMT_MASK)
#define MSCM_OCMDR_RO_MASK                       0x10000u
#define MSCM_OCMDR_RO_SHIFT                      16
#define MSCM_OCMDR_RO_WIDTH                      1
#define MSCM_OCMDR_RO(x)                         (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_RO_SHIFT))&MSCM_OCMDR_RO_MASK)
#define MSCM_OCMDR_OCMW_MASK                     0xE0000u
#define MSCM_OCMDR_OCMW_SHIFT                    17
#define MSCM_OCMDR_OCMW_WIDTH                    3
#define MSCM_OCMDR_OCMW(x)                       (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_OCMW_SHIFT))&MSCM_OCMDR_OCMW_MASK)
#define MSCM_OCMDR_OCMSZ_MASK                    0xF000000u
#define MSCM_OCMDR_OCMSZ_SHIFT                   24
#define MSCM_OCMDR_OCMSZ_WIDTH                   4
#define MSCM_OCMDR_OCMSZ(x)                      (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_OCMSZ_SHIFT))&MSCM_OCMDR_OCMSZ_MASK)
#define MSCM_OCMDR_OCMSZH_MASK                   0x10000000u
#define MSCM_OCMDR_OCMSZH_SHIFT                  28
#define MSCM_OCMDR_OCMSZH_WIDTH                  1
#define MSCM_OCMDR_OCMSZH(x)                     (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_OCMSZH_SHIFT))&MSCM_OCMDR_OCMSZH_MASK)
#define MSCM_OCMDR_FMT_MASK                      0x40000000u
#define MSCM_OCMDR_FMT_SHIFT                     30
#define MSCM_OCMDR_FMT_WIDTH                     1
#define MSCM_OCMDR_FMT(x)                        (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_FMT_SHIFT))&MSCM_OCMDR_FMT_MASK)
#define MSCM_OCMDR_V_MASK                        0x80000000u
#define MSCM_OCMDR_V_SHIFT                       31
#define MSCM_OCMDR_V_WIDTH                       1
#define MSCM_OCMDR_V(x)                          (((uint32_t)(((uint32_t)(x))<<MSCM_OCMDR_V_SHIFT))&MSCM_OCMDR_V_MASK)

/*!
 * @}
 */ /* end of group MSCM_Register_Masks */


/* MSCM - Peripheral instance base addresses */
/** Peripheral MSCM base address */
#define MSCM_BASE                                (0x4000u)
/** Peripheral MSCM base pointer */
#define MSCM                                     ((MSCM_Type *)MSCM_BASE)
#define MSCM_BASE_PTR                            (MSCM)
/** Array initializer of MSCM peripheral base addresses */
#define MSCM_BASE_ADDRS                          { MSCM_BASE }
/** Array initializer of MSCM peripheral base pointers */
#define MSCM_BASE_PTRS                           { MSCM }

/* ----------------------------------------------------------------------------
   -- MSCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MSCM_Register_Accessor_Macros MSCM - Register accessor macros
 * @{
 */


/* MSCM - Register instance definitions */
/* MSCM */
#define MSCM_CPxTYPE                             MSCM_CPxTYPE_REG(MSCM)
#define MSCM_CPxNUM                              MSCM_CPxNUM_REG(MSCM)
#define MSCM_CPxMASTER                           MSCM_CPxMASTER_REG(MSCM)
#define MSCM_CPxCOUNT                            MSCM_CPxCOUNT_REG(MSCM)
#define MSCM_CPxCFG0                             MSCM_CPxCFG_REG(MSCM,0)
#define MSCM_CPxCFG1                             MSCM_CPxCFG_REG(MSCM,1)
#define MSCM_CPxCFG2                             MSCM_CPxCFG_REG(MSCM,2)
#define MSCM_CPxCFG3                             MSCM_CPxCFG_REG(MSCM,3)
#define MSCM_CP0TYPE                             MSCM_CP0TYPE_REG(MSCM)
#define MSCM_CP0NUM                              MSCM_CP0NUM_REG(MSCM)
#define MSCM_CP0MASTER                           MSCM_CP0MASTER_REG(MSCM)
#define MSCM_CP0COUNT                            MSCM_CP0COUNT_REG(MSCM)
#define MSCM_CP0CFG0                             MSCM_CP0CFG_REG(MSCM,0)
#define MSCM_CP0CFG1                             MSCM_CP0CFG_REG(MSCM,1)
#define MSCM_CP0CFG2                             MSCM_CP0CFG_REG(MSCM,2)
#define MSCM_CP0CFG3                             MSCM_CP0CFG_REG(MSCM,3)
#define MSCM_CP1TYPE                             MSCM_CP1TYPE_REG(MSCM)
#define MSCM_CP1NUM                              MSCM_CP1NUM_REG(MSCM)
#define MSCM_CP1MASTER                           MSCM_CP1MASTER_REG(MSCM)
#define MSCM_CP1COUNT                            MSCM_CP1COUNT_REG(MSCM)
#define MSCM_CP1CFG0                             MSCM_CP1CFG_REG(MSCM,0)
#define MSCM_CP1CFG1                             MSCM_CP1CFG_REG(MSCM,1)
#define MSCM_CP1CFG2                             MSCM_CP1CFG_REG(MSCM,2)
#define MSCM_CP1CFG3                             MSCM_CP1CFG_REG(MSCM,3)
#define MSCM_OCMDR0                              MSCM_OCMDR_REG(MSCM,0)
#define MSCM_OCMDR1                              MSCM_OCMDR_REG(MSCM,1)
#define MSCM_OCMDR2                              MSCM_OCMDR_REG(MSCM,2)

/* MSCM - Register array accessors */
#define MSCM_CPxCFG(index)                       MSCM_CPxCFG_REG(MSCM,index)
#define MSCM_CP0CFG(index)                       MSCM_CP0CFG_REG(MSCM,index)
#define MSCM_CP1CFG(index)                       MSCM_CP1CFG_REG(MSCM,index)
#define MSCM_OCMDR(index)                        MSCM_OCMDR_REG(MSCM,index)

/*!
 * @}
 */ /* end of group MSCM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MSCM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- NV Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Peripheral_Access_Layer NV Peripheral Access Layer
 * @{
 */

/** NV - Register Layout Typedef */
typedef struct {
  __I  uint8_t BACKKEY3;                           /**< Backdoor Comparison Key 3., offset: 0x0 */
  __I  uint8_t BACKKEY2;                           /**< Backdoor Comparison Key 2., offset: 0x1 */
  __I  uint8_t BACKKEY1;                           /**< Backdoor Comparison Key 1., offset: 0x2 */
  __I  uint8_t BACKKEY0;                           /**< Backdoor Comparison Key 0., offset: 0x3 */
  __I  uint8_t BACKKEY7;                           /**< Backdoor Comparison Key 7., offset: 0x4 */
  __I  uint8_t BACKKEY6;                           /**< Backdoor Comparison Key 6., offset: 0x5 */
  __I  uint8_t BACKKEY5;                           /**< Backdoor Comparison Key 5., offset: 0x6 */
  __I  uint8_t BACKKEY4;                           /**< Backdoor Comparison Key 4., offset: 0x7 */
  __I  uint8_t FPROT3;                             /**< Non-volatile P-Flash Protection 1 - Low Register, offset: 0x8 */
  __I  uint8_t FPROT2;                             /**< Non-volatile P-Flash Protection 1 - High Register, offset: 0x9 */
  __I  uint8_t FPROT1;                             /**< Non-volatile P-Flash Protection 0 - Low Register, offset: 0xA */
  __I  uint8_t FPROT0;                             /**< Non-volatile P-Flash Protection 0 - High Register, offset: 0xB */
  __I  uint8_t FSEC;                               /**< Non-volatile Flash Security Register, offset: 0xC */
  __I  uint8_t FOPT;                               /**< Non-volatile Flash Option Register, offset: 0xD */
  __I  uint8_t FEPROT;                             /**< Non-volatile EERAM Protection Register, offset: 0xE */
  __I  uint8_t FDPROT;                             /**< Non-volatile D-Flash Protection Register, offset: 0xF */
} NV_Type, *NV_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- NV - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Accessor_Macros NV - Register accessor macros
 * @{
 */


/* NV - Register accessors */
#define NV_BACKKEY3_REG(base)                    ((base)->BACKKEY3)
#define NV_BACKKEY2_REG(base)                    ((base)->BACKKEY2)
#define NV_BACKKEY1_REG(base)                    ((base)->BACKKEY1)
#define NV_BACKKEY0_REG(base)                    ((base)->BACKKEY0)
#define NV_BACKKEY7_REG(base)                    ((base)->BACKKEY7)
#define NV_BACKKEY6_REG(base)                    ((base)->BACKKEY6)
#define NV_BACKKEY5_REG(base)                    ((base)->BACKKEY5)
#define NV_BACKKEY4_REG(base)                    ((base)->BACKKEY4)
#define NV_FPROT3_REG(base)                      ((base)->FPROT3)
#define NV_FPROT2_REG(base)                      ((base)->FPROT2)
#define NV_FPROT1_REG(base)                      ((base)->FPROT1)
#define NV_FPROT0_REG(base)                      ((base)->FPROT0)
#define NV_FSEC_REG(base)                        ((base)->FSEC)
#define NV_FOPT_REG(base)                        ((base)->FOPT)
#define NV_FEPROT_REG(base)                      ((base)->FEPROT)
#define NV_FDPROT_REG(base)                      ((base)->FDPROT)

/*!
 * @}
 */ /* end of group NV_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- NV Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Masks NV Register Masks
 * @{
 */

/* BACKKEY3 Bit Fields */
#define NV_BACKKEY3_KEY_MASK                     0xFFu
#define NV_BACKKEY3_KEY_SHIFT                    0
#define NV_BACKKEY3_KEY_WIDTH                    8
#define NV_BACKKEY3_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY3_KEY_SHIFT))&NV_BACKKEY3_KEY_MASK)
/* BACKKEY2 Bit Fields */
#define NV_BACKKEY2_KEY_MASK                     0xFFu
#define NV_BACKKEY2_KEY_SHIFT                    0
#define NV_BACKKEY2_KEY_WIDTH                    8
#define NV_BACKKEY2_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY2_KEY_SHIFT))&NV_BACKKEY2_KEY_MASK)
/* BACKKEY1 Bit Fields */
#define NV_BACKKEY1_KEY_MASK                     0xFFu
#define NV_BACKKEY1_KEY_SHIFT                    0
#define NV_BACKKEY1_KEY_WIDTH                    8
#define NV_BACKKEY1_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY1_KEY_SHIFT))&NV_BACKKEY1_KEY_MASK)
/* BACKKEY0 Bit Fields */
#define NV_BACKKEY0_KEY_MASK                     0xFFu
#define NV_BACKKEY0_KEY_SHIFT                    0
#define NV_BACKKEY0_KEY_WIDTH                    8
#define NV_BACKKEY0_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY0_KEY_SHIFT))&NV_BACKKEY0_KEY_MASK)
/* BACKKEY7 Bit Fields */
#define NV_BACKKEY7_KEY_MASK                     0xFFu
#define NV_BACKKEY7_KEY_SHIFT                    0
#define NV_BACKKEY7_KEY_WIDTH                    8
#define NV_BACKKEY7_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY7_KEY_SHIFT))&NV_BACKKEY7_KEY_MASK)
/* BACKKEY6 Bit Fields */
#define NV_BACKKEY6_KEY_MASK                     0xFFu
#define NV_BACKKEY6_KEY_SHIFT                    0
#define NV_BACKKEY6_KEY_WIDTH                    8
#define NV_BACKKEY6_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY6_KEY_SHIFT))&NV_BACKKEY6_KEY_MASK)
/* BACKKEY5 Bit Fields */
#define NV_BACKKEY5_KEY_MASK                     0xFFu
#define NV_BACKKEY5_KEY_SHIFT                    0
#define NV_BACKKEY5_KEY_WIDTH                    8
#define NV_BACKKEY5_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY5_KEY_SHIFT))&NV_BACKKEY5_KEY_MASK)
/* BACKKEY4 Bit Fields */
#define NV_BACKKEY4_KEY_MASK                     0xFFu
#define NV_BACKKEY4_KEY_SHIFT                    0
#define NV_BACKKEY4_KEY_WIDTH                    8
#define NV_BACKKEY4_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY4_KEY_SHIFT))&NV_BACKKEY4_KEY_MASK)
/* FPROT3 Bit Fields */
#define NV_FPROT3_PROT_MASK                      0xFFu
#define NV_FPROT3_PROT_SHIFT                     0
#define NV_FPROT3_PROT_WIDTH                     8
#define NV_FPROT3_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT3_PROT_SHIFT))&NV_FPROT3_PROT_MASK)
/* FPROT2 Bit Fields */
#define NV_FPROT2_PROT_MASK                      0xFFu
#define NV_FPROT2_PROT_SHIFT                     0
#define NV_FPROT2_PROT_WIDTH                     8
#define NV_FPROT2_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT2_PROT_SHIFT))&NV_FPROT2_PROT_MASK)
/* FPROT1 Bit Fields */
#define NV_FPROT1_PROT_MASK                      0xFFu
#define NV_FPROT1_PROT_SHIFT                     0
#define NV_FPROT1_PROT_WIDTH                     8
#define NV_FPROT1_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT1_PROT_SHIFT))&NV_FPROT1_PROT_MASK)
/* FPROT0 Bit Fields */
#define NV_FPROT0_PROT_MASK                      0xFFu
#define NV_FPROT0_PROT_SHIFT                     0
#define NV_FPROT0_PROT_WIDTH                     8
#define NV_FPROT0_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT0_PROT_SHIFT))&NV_FPROT0_PROT_MASK)
/* FSEC Bit Fields */
#define NV_FSEC_SEC_MASK                         0x3u
#define NV_FSEC_SEC_SHIFT                        0
#define NV_FSEC_SEC_WIDTH                        2
#define NV_FSEC_SEC(x)                           (((uint8_t)(((uint8_t)(x))<<NV_FSEC_SEC_SHIFT))&NV_FSEC_SEC_MASK)
#define NV_FSEC_FSLACC_MASK                      0xCu
#define NV_FSEC_FSLACC_SHIFT                     2
#define NV_FSEC_FSLACC_WIDTH                     2
#define NV_FSEC_FSLACC(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FSEC_FSLACC_SHIFT))&NV_FSEC_FSLACC_MASK)
#define NV_FSEC_MEEN_MASK                        0x30u
#define NV_FSEC_MEEN_SHIFT                       4
#define NV_FSEC_MEEN_WIDTH                       2
#define NV_FSEC_MEEN(x)                          (((uint8_t)(((uint8_t)(x))<<NV_FSEC_MEEN_SHIFT))&NV_FSEC_MEEN_MASK)
#define NV_FSEC_KEYEN_MASK                       0xC0u
#define NV_FSEC_KEYEN_SHIFT                      6
#define NV_FSEC_KEYEN_WIDTH                      2
#define NV_FSEC_KEYEN(x)                         (((uint8_t)(((uint8_t)(x))<<NV_FSEC_KEYEN_SHIFT))&NV_FSEC_KEYEN_MASK)
/* FOPT Bit Fields */
#define NV_FOPT_LPBOOT_MASK                      0x1u
#define NV_FOPT_LPBOOT_SHIFT                     0
#define NV_FOPT_LPBOOT_WIDTH                     1
#define NV_FOPT_LPBOOT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FOPT_LPBOOT_SHIFT))&NV_FOPT_LPBOOT_MASK)
#define NV_FOPT_NMI_DIS_MASK                     0x4u
#define NV_FOPT_NMI_DIS_SHIFT                    2
#define NV_FOPT_NMI_DIS_WIDTH                    1
#define NV_FOPT_NMI_DIS(x)                       (((uint8_t)(((uint8_t)(x))<<NV_FOPT_NMI_DIS_SHIFT))&NV_FOPT_NMI_DIS_MASK)
#define NV_FOPT_FAST_INIT_MASK                   0x20u
#define NV_FOPT_FAST_INIT_SHIFT                  5
#define NV_FOPT_FAST_INIT_WIDTH                  1
#define NV_FOPT_FAST_INIT(x)                     (((uint8_t)(((uint8_t)(x))<<NV_FOPT_FAST_INIT_SHIFT))&NV_FOPT_FAST_INIT_MASK)
/* FEPROT Bit Fields */
#define NV_FEPROT_EPROT_MASK                     0xFFu
#define NV_FEPROT_EPROT_SHIFT                    0
#define NV_FEPROT_EPROT_WIDTH                    8
#define NV_FEPROT_EPROT(x)                       (((uint8_t)(((uint8_t)(x))<<NV_FEPROT_EPROT_SHIFT))&NV_FEPROT_EPROT_MASK)
/* FDPROT Bit Fields */
#define NV_FDPROT_DPROT_MASK                     0xFFu
#define NV_FDPROT_DPROT_SHIFT                    0
#define NV_FDPROT_DPROT_WIDTH                    8
#define NV_FDPROT_DPROT(x)                       (((uint8_t)(((uint8_t)(x))<<NV_FDPROT_DPROT_SHIFT))&NV_FDPROT_DPROT_MASK)

/*!
 * @}
 */ /* end of group NV_Register_Masks */


/* NV - Peripheral instance base addresses */
/** Peripheral FTFL_FlashConfig base address */
#define FTFL_FlashConfig_BASE                    (0x400u)
/** Peripheral FTFL_FlashConfig base pointer */
#define FTFL_FlashConfig                         ((NV_Type *)FTFL_FlashConfig_BASE)
#define FTFL_FlashConfig_BASE_PTR                (FTFL_FlashConfig)
/** Array initializer of NV peripheral base addresses */
#define NV_BASE_ADDRS                            { FTFL_FlashConfig_BASE }
/** Array initializer of NV peripheral base pointers */
#define NV_BASE_PTRS                             { FTFL_FlashConfig }

/* ----------------------------------------------------------------------------
   -- NV - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Accessor_Macros NV - Register accessor macros
 * @{
 */


/* NV - Register instance definitions */
/* FTFL_FlashConfig */
#define NV_BACKKEY3                              NV_BACKKEY3_REG(FTFL_FlashConfig)
#define NV_BACKKEY2                              NV_BACKKEY2_REG(FTFL_FlashConfig)
#define NV_BACKKEY1                              NV_BACKKEY1_REG(FTFL_FlashConfig)
#define NV_BACKKEY0                              NV_BACKKEY0_REG(FTFL_FlashConfig)
#define NV_BACKKEY7                              NV_BACKKEY7_REG(FTFL_FlashConfig)
#define NV_BACKKEY6                              NV_BACKKEY6_REG(FTFL_FlashConfig)
#define NV_BACKKEY5                              NV_BACKKEY5_REG(FTFL_FlashConfig)
#define NV_BACKKEY4                              NV_BACKKEY4_REG(FTFL_FlashConfig)
#define NV_FPROT3                                NV_FPROT3_REG(FTFL_FlashConfig)
#define NV_FPROT2                                NV_FPROT2_REG(FTFL_FlashConfig)
#define NV_FPROT1                                NV_FPROT1_REG(FTFL_FlashConfig)
#define NV_FPROT0                                NV_FPROT0_REG(FTFL_FlashConfig)
#define NV_FSEC                                  NV_FSEC_REG(FTFL_FlashConfig)
#define NV_FOPT                                  NV_FOPT_REG(FTFL_FlashConfig)
#define NV_FEPROT                                NV_FEPROT_REG(FTFL_FlashConfig)
#define NV_FDPROT                                NV_FDPROT_REG(FTFL_FlashConfig)

/*!
 * @}
 */ /* end of group NV_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group NV_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- OSC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Peripheral_Access_Layer OSC Peripheral Access Layer
 * @{
 */

/** OSC - Register Layout Typedef */
typedef struct {
  __IO uint8_t CR;                                 /**< OSC Control Register, offset: 0x0 */
       uint8_t RESERVED_0[1];
  __IO uint8_t DIV;                                /**< OSC_DIV, offset: 0x2 */
} OSC_Type, *OSC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- OSC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Register_Accessor_Macros OSC - Register accessor macros
 * @{
 */


/* OSC - Register accessors */
#define OSC_CR_REG(base)                         ((base)->CR)
#define OSC_DIV_REG(base)                        ((base)->DIV)

/*!
 * @}
 */ /* end of group OSC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- OSC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Register_Masks OSC Register Masks
 * @{
 */

/* CR Bit Fields */
#define OSC_CR_SC16P_MASK                        0x1u
#define OSC_CR_SC16P_SHIFT                       0
#define OSC_CR_SC16P_WIDTH                       1
#define OSC_CR_SC16P(x)                          (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC16P_SHIFT))&OSC_CR_SC16P_MASK)
#define OSC_CR_SC8P_MASK                         0x2u
#define OSC_CR_SC8P_SHIFT                        1
#define OSC_CR_SC8P_WIDTH                        1
#define OSC_CR_SC8P(x)                           (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC8P_SHIFT))&OSC_CR_SC8P_MASK)
#define OSC_CR_SC4P_MASK                         0x4u
#define OSC_CR_SC4P_SHIFT                        2
#define OSC_CR_SC4P_WIDTH                        1
#define OSC_CR_SC4P(x)                           (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC4P_SHIFT))&OSC_CR_SC4P_MASK)
#define OSC_CR_SC2P_MASK                         0x8u
#define OSC_CR_SC2P_SHIFT                        3
#define OSC_CR_SC2P_WIDTH                        1
#define OSC_CR_SC2P(x)                           (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC2P_SHIFT))&OSC_CR_SC2P_MASK)
#define OSC_CR_EREFSTEN_MASK                     0x20u
#define OSC_CR_EREFSTEN_SHIFT                    5
#define OSC_CR_EREFSTEN_WIDTH                    1
#define OSC_CR_EREFSTEN(x)                       (((uint8_t)(((uint8_t)(x))<<OSC_CR_EREFSTEN_SHIFT))&OSC_CR_EREFSTEN_MASK)
#define OSC_CR_ERCLKEN_MASK                      0x80u
#define OSC_CR_ERCLKEN_SHIFT                     7
#define OSC_CR_ERCLKEN_WIDTH                     1
#define OSC_CR_ERCLKEN(x)                        (((uint8_t)(((uint8_t)(x))<<OSC_CR_ERCLKEN_SHIFT))&OSC_CR_ERCLKEN_MASK)
/* DIV Bit Fields */
#define OSC_DIV_ERPS_MASK                        0xC0u
#define OSC_DIV_ERPS_SHIFT                       6
#define OSC_DIV_ERPS_WIDTH                       2
#define OSC_DIV_ERPS(x)                          (((uint8_t)(((uint8_t)(x))<<OSC_DIV_ERPS_SHIFT))&OSC_DIV_ERPS_MASK)

/*!
 * @}
 */ /* end of group OSC_Register_Masks */


/* OSC - Peripheral instance base addresses */
/** Peripheral OSC base address */
#define OSC_BASE                                 (0x40065000u)
/** Peripheral OSC base pointer */
#define OSC                                      ((OSC_Type *)OSC_BASE)
#define OSC_BASE_PTR                             (OSC)
/** Array initializer of OSC peripheral base addresses */
#define OSC_BASE_ADDRS                           { OSC_BASE }
/** Array initializer of OSC peripheral base pointers */
#define OSC_BASE_PTRS                            { OSC }

/* ----------------------------------------------------------------------------
   -- OSC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Register_Accessor_Macros OSC - Register accessor macros
 * @{
 */


/* OSC - Register instance definitions */
/* OSC */
#define OSC_CR                                   OSC_CR_REG(OSC)
#define OSC_DIV                                  OSC_DIV_REG(OSC)

/*!
 * @}
 */ /* end of group OSC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group OSC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PDB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PDB_Peripheral_Access_Layer PDB Peripheral Access Layer
 * @{
 */

/** PDB - Register Layout Typedef */
typedef struct {
  __IO uint32_t SC;                                /**< Status and Control register, offset: 0x0 */
  __IO uint32_t MOD;                               /**< Modulus register, offset: 0x4 */
  __I  uint32_t CNT;                               /**< Counter register, offset: 0x8 */
  __IO uint32_t IDLY;                              /**< Interrupt Delay register, offset: 0xC */
  struct {                                         /* offset: 0x10, array step: 0x28 */
    __IO uint32_t C1;                                /**< Channel n Control register 1, array offset: 0x10, array step: 0x28 */
    __IO uint32_t S;                                 /**< Channel n Status register, array offset: 0x14, array step: 0x28 */
    __IO uint32_t DLY[2];                            /**< Channel n Delay 0 register..Channel n Delay 1 register, array offset: 0x18, array step: index*0x28, index2*0x4 */
         uint8_t RESERVED_0[24];
  } CH[2];
       uint8_t RESERVED_0[240];
  struct {                                         /* offset: 0x150, array step: 0x8 */
    __IO uint32_t INTC;                              /**< DAC Interval Trigger n Control register, array offset: 0x150, array step: 0x8 */
    __IO uint32_t INT;                               /**< DAC Interval n register, array offset: 0x154, array step: 0x8 */
  } DAC[1];
       uint8_t RESERVED_1[56];
  __IO uint32_t POEN;                              /**< Pulse-Out n Enable register, offset: 0x190 */
  __IO uint32_t PODLY[2];                          /**< Pulse-Out n Delay register, array offset: 0x194, array step: 0x4 */
} PDB_Type, *PDB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PDB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PDB_Register_Accessor_Macros PDB - Register accessor macros
 * @{
 */


/* PDB - Register accessors */
#define PDB_SC_REG(base)                         ((base)->SC)
#define PDB_MOD_REG(base)                        ((base)->MOD)
#define PDB_CNT_REG(base)                        ((base)->CNT)
#define PDB_IDLY_REG(base)                       ((base)->IDLY)
#define PDB_C1_REG(base,index)                   ((base)->CH[index].C1)
#define PDB_C1_COUNT                             2
#define PDB_S_REG(base,index)                    ((base)->CH[index].S)
#define PDB_S_COUNT                              2
#define PDB_DLY_REG(base,index,index2)           ((base)->CH[index].DLY[index2])
#define PDB_DLY_COUNT                            2
#define PDB_DLY_COUNT2                           2
#define PDB_INTC_REG(base,index)                 ((base)->DAC[index].INTC)
#define PDB_INTC_COUNT                           1
#define PDB_INT_REG(base,index)                  ((base)->DAC[index].INT)
#define PDB_INT_COUNT                            1
#define PDB_POEN_REG(base)                       ((base)->POEN)
#define PDB_PODLY_REG(base,index)                ((base)->PODLY[index])
#define PDB_PODLY_COUNT                          2

/*!
 * @}
 */ /* end of group PDB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PDB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PDB_Register_Masks PDB Register Masks
 * @{
 */

/* SC Bit Fields */
#define PDB_SC_LDOK_MASK                         0x1u
#define PDB_SC_LDOK_SHIFT                        0
#define PDB_SC_LDOK_WIDTH                        1
#define PDB_SC_LDOK(x)                           (((uint32_t)(((uint32_t)(x))<<PDB_SC_LDOK_SHIFT))&PDB_SC_LDOK_MASK)
#define PDB_SC_CONT_MASK                         0x2u
#define PDB_SC_CONT_SHIFT                        1
#define PDB_SC_CONT_WIDTH                        1
#define PDB_SC_CONT(x)                           (((uint32_t)(((uint32_t)(x))<<PDB_SC_CONT_SHIFT))&PDB_SC_CONT_MASK)
#define PDB_SC_MULT_MASK                         0xCu
#define PDB_SC_MULT_SHIFT                        2
#define PDB_SC_MULT_WIDTH                        2
#define PDB_SC_MULT(x)                           (((uint32_t)(((uint32_t)(x))<<PDB_SC_MULT_SHIFT))&PDB_SC_MULT_MASK)
#define PDB_SC_PDBIE_MASK                        0x20u
#define PDB_SC_PDBIE_SHIFT                       5
#define PDB_SC_PDBIE_WIDTH                       1
#define PDB_SC_PDBIE(x)                          (((uint32_t)(((uint32_t)(x))<<PDB_SC_PDBIE_SHIFT))&PDB_SC_PDBIE_MASK)
#define PDB_SC_PDBIF_MASK                        0x40u
#define PDB_SC_PDBIF_SHIFT                       6
#define PDB_SC_PDBIF_WIDTH                       1
#define PDB_SC_PDBIF(x)                          (((uint32_t)(((uint32_t)(x))<<PDB_SC_PDBIF_SHIFT))&PDB_SC_PDBIF_MASK)
#define PDB_SC_PDBEN_MASK                        0x80u
#define PDB_SC_PDBEN_SHIFT                       7
#define PDB_SC_PDBEN_WIDTH                       1
#define PDB_SC_PDBEN(x)                          (((uint32_t)(((uint32_t)(x))<<PDB_SC_PDBEN_SHIFT))&PDB_SC_PDBEN_MASK)
#define PDB_SC_TRGSEL_MASK                       0xF00u
#define PDB_SC_TRGSEL_SHIFT                      8
#define PDB_SC_TRGSEL_WIDTH                      4
#define PDB_SC_TRGSEL(x)                         (((uint32_t)(((uint32_t)(x))<<PDB_SC_TRGSEL_SHIFT))&PDB_SC_TRGSEL_MASK)
#define PDB_SC_PRESCALER_MASK                    0x7000u
#define PDB_SC_PRESCALER_SHIFT                   12
#define PDB_SC_PRESCALER_WIDTH                   3
#define PDB_SC_PRESCALER(x)                      (((uint32_t)(((uint32_t)(x))<<PDB_SC_PRESCALER_SHIFT))&PDB_SC_PRESCALER_MASK)
#define PDB_SC_DMAEN_MASK                        0x8000u
#define PDB_SC_DMAEN_SHIFT                       15
#define PDB_SC_DMAEN_WIDTH                       1
#define PDB_SC_DMAEN(x)                          (((uint32_t)(((uint32_t)(x))<<PDB_SC_DMAEN_SHIFT))&PDB_SC_DMAEN_MASK)
#define PDB_SC_SWTRIG_MASK                       0x10000u
#define PDB_SC_SWTRIG_SHIFT                      16
#define PDB_SC_SWTRIG_WIDTH                      1
#define PDB_SC_SWTRIG(x)                         (((uint32_t)(((uint32_t)(x))<<PDB_SC_SWTRIG_SHIFT))&PDB_SC_SWTRIG_MASK)
#define PDB_SC_PDBEIE_MASK                       0x20000u
#define PDB_SC_PDBEIE_SHIFT                      17
#define PDB_SC_PDBEIE_WIDTH                      1
#define PDB_SC_PDBEIE(x)                         (((uint32_t)(((uint32_t)(x))<<PDB_SC_PDBEIE_SHIFT))&PDB_SC_PDBEIE_MASK)
#define PDB_SC_LDMOD_MASK                        0xC0000u
#define PDB_SC_LDMOD_SHIFT                       18
#define PDB_SC_LDMOD_WIDTH                       2
#define PDB_SC_LDMOD(x)                          (((uint32_t)(((uint32_t)(x))<<PDB_SC_LDMOD_SHIFT))&PDB_SC_LDMOD_MASK)
/* MOD Bit Fields */
#define PDB_MOD_MOD_MASK                         0xFFFFu
#define PDB_MOD_MOD_SHIFT                        0
#define PDB_MOD_MOD_WIDTH                        16
#define PDB_MOD_MOD(x)                           (((uint32_t)(((uint32_t)(x))<<PDB_MOD_MOD_SHIFT))&PDB_MOD_MOD_MASK)
/* CNT Bit Fields */
#define PDB_CNT_CNT_MASK                         0xFFFFu
#define PDB_CNT_CNT_SHIFT                        0
#define PDB_CNT_CNT_WIDTH                        16
#define PDB_CNT_CNT(x)                           (((uint32_t)(((uint32_t)(x))<<PDB_CNT_CNT_SHIFT))&PDB_CNT_CNT_MASK)
/* IDLY Bit Fields */
#define PDB_IDLY_IDLY_MASK                       0xFFFFu
#define PDB_IDLY_IDLY_SHIFT                      0
#define PDB_IDLY_IDLY_WIDTH                      16
#define PDB_IDLY_IDLY(x)                         (((uint32_t)(((uint32_t)(x))<<PDB_IDLY_IDLY_SHIFT))&PDB_IDLY_IDLY_MASK)
/* C1 Bit Fields */
#define PDB_C1_EN_MASK                           0xFFu
#define PDB_C1_EN_SHIFT                          0
#define PDB_C1_EN_WIDTH                          8
#define PDB_C1_EN(x)                             (((uint32_t)(((uint32_t)(x))<<PDB_C1_EN_SHIFT))&PDB_C1_EN_MASK)
#define PDB_C1_TOS_MASK                          0xFF00u
#define PDB_C1_TOS_SHIFT                         8
#define PDB_C1_TOS_WIDTH                         8
#define PDB_C1_TOS(x)                            (((uint32_t)(((uint32_t)(x))<<PDB_C1_TOS_SHIFT))&PDB_C1_TOS_MASK)
#define PDB_C1_BB_MASK                           0xFF0000u
#define PDB_C1_BB_SHIFT                          16
#define PDB_C1_BB_WIDTH                          8
#define PDB_C1_BB(x)                             (((uint32_t)(((uint32_t)(x))<<PDB_C1_BB_SHIFT))&PDB_C1_BB_MASK)
/* S Bit Fields */
#define PDB_S_ERR_MASK                           0xFFu
#define PDB_S_ERR_SHIFT                          0
#define PDB_S_ERR_WIDTH                          8
#define PDB_S_ERR(x)                             (((uint32_t)(((uint32_t)(x))<<PDB_S_ERR_SHIFT))&PDB_S_ERR_MASK)
#define PDB_S_CF_MASK                            0xFF0000u
#define PDB_S_CF_SHIFT                           16
#define PDB_S_CF_WIDTH                           8
#define PDB_S_CF(x)                              (((uint32_t)(((uint32_t)(x))<<PDB_S_CF_SHIFT))&PDB_S_CF_MASK)
/* DLY Bit Fields */
#define PDB_DLY_DLY_MASK                         0xFFFFu
#define PDB_DLY_DLY_SHIFT                        0
#define PDB_DLY_DLY_WIDTH                        16
#define PDB_DLY_DLY(x)                           (((uint32_t)(((uint32_t)(x))<<PDB_DLY_DLY_SHIFT))&PDB_DLY_DLY_MASK)
/* INTC Bit Fields */
#define PDB_INTC_TOE_MASK                        0x1u
#define PDB_INTC_TOE_SHIFT                       0
#define PDB_INTC_TOE_WIDTH                       1
#define PDB_INTC_TOE(x)                          (((uint32_t)(((uint32_t)(x))<<PDB_INTC_TOE_SHIFT))&PDB_INTC_TOE_MASK)
#define PDB_INTC_EXT_MASK                        0x2u
#define PDB_INTC_EXT_SHIFT                       1
#define PDB_INTC_EXT_WIDTH                       1
#define PDB_INTC_EXT(x)                          (((uint32_t)(((uint32_t)(x))<<PDB_INTC_EXT_SHIFT))&PDB_INTC_EXT_MASK)
/* INT Bit Fields */
#define PDB_INT_INT_MASK                         0xFFFFu
#define PDB_INT_INT_SHIFT                        0
#define PDB_INT_INT_WIDTH                        16
#define PDB_INT_INT(x)                           (((uint32_t)(((uint32_t)(x))<<PDB_INT_INT_SHIFT))&PDB_INT_INT_MASK)
/* POEN Bit Fields */
#define PDB_POEN_POEN_MASK                       0xFFu
#define PDB_POEN_POEN_SHIFT                      0
#define PDB_POEN_POEN_WIDTH                      8
#define PDB_POEN_POEN(x)                         (((uint32_t)(((uint32_t)(x))<<PDB_POEN_POEN_SHIFT))&PDB_POEN_POEN_MASK)
/* PODLY Bit Fields */
#define PDB_PODLY_DLY2_MASK                      0xFFFFu
#define PDB_PODLY_DLY2_SHIFT                     0
#define PDB_PODLY_DLY2_WIDTH                     16
#define PDB_PODLY_DLY2(x)                        (((uint32_t)(((uint32_t)(x))<<PDB_PODLY_DLY2_SHIFT))&PDB_PODLY_DLY2_MASK)
#define PDB_PODLY_DLY1_MASK                      0xFFFF0000u
#define PDB_PODLY_DLY1_SHIFT                     16
#define PDB_PODLY_DLY1_WIDTH                     16
#define PDB_PODLY_DLY1(x)                        (((uint32_t)(((uint32_t)(x))<<PDB_PODLY_DLY1_SHIFT))&PDB_PODLY_DLY1_MASK)

/*!
 * @}
 */ /* end of group PDB_Register_Masks */


/* PDB - Peripheral instance base addresses */
/** Peripheral PDB0 base address */
#define PDB0_BASE                                (0x40036000u)
/** Peripheral PDB0 base pointer */
#define PDB0                                     ((PDB_Type *)PDB0_BASE)
#define PDB0_BASE_PTR                            (PDB0)
/** Peripheral PDB1 base address */
#define PDB1_BASE                                (0x40031000u)
/** Peripheral PDB1 base pointer */
#define PDB1                                     ((PDB_Type *)PDB1_BASE)
#define PDB1_BASE_PTR                            (PDB1)
/** Array initializer of PDB peripheral base addresses */
#define PDB_BASE_ADDRS                           { PDB0_BASE, PDB1_BASE }
/** Array initializer of PDB peripheral base pointers */
#define PDB_BASE_PTRS                            { PDB0, PDB1 }

/* ----------------------------------------------------------------------------
   -- PDB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PDB_Register_Accessor_Macros PDB - Register accessor macros
 * @{
 */


/* PDB - Register instance definitions */
/* PDB0 */
#define PDB0_SC                                  PDB_SC_REG(PDB0)
#define PDB0_MOD                                 PDB_MOD_REG(PDB0)
#define PDB0_CNT                                 PDB_CNT_REG(PDB0)
#define PDB0_IDLY                                PDB_IDLY_REG(PDB0)
#define PDB0_CH0C1                               PDB_C1_REG(PDB0,0)
#define PDB0_CH0S                                PDB_S_REG(PDB0,0)
#define PDB0_CH0DLY0                             PDB_DLY_REG(PDB0,0,0)
#define PDB0_CH0DLY1                             PDB_DLY_REG(PDB0,0,1)
#define PDB0_CH1C1                               PDB_C1_REG(PDB0,1)
#define PDB0_CH1S                                PDB_S_REG(PDB0,1)
#define PDB0_CH1DLY0                             PDB_DLY_REG(PDB0,1,0)
#define PDB0_CH1DLY1                             PDB_DLY_REG(PDB0,1,1)
#define PDB0_DACINTC0                            PDB_INTC_REG(PDB0,0)
#define PDB0_DACINT0                             PDB_INT_REG(PDB0,0)
#define PDB0_POEN                                PDB_POEN_REG(PDB0)
#define PDB0_PO0DLY                              PDB_PODLY_REG(PDB0,0)
#define PDB0_PO1DLY                              PDB_PODLY_REG(PDB0,1)
/* PDB1 */
#define PDB1_SC                                  PDB_SC_REG(PDB1)
#define PDB1_MOD                                 PDB_MOD_REG(PDB1)
#define PDB1_CNT                                 PDB_CNT_REG(PDB1)
#define PDB1_IDLY                                PDB_IDLY_REG(PDB1)
#define PDB1_CH0C1                               PDB_C1_REG(PDB1,0)
#define PDB1_CH0S                                PDB_S_REG(PDB1,0)
#define PDB1_CH0DLY0                             PDB_DLY_REG(PDB1,0,0)
#define PDB1_CH0DLY1                             PDB_DLY_REG(PDB1,0,1)
#define PDB1_CH1C1                               PDB_C1_REG(PDB1,1)
#define PDB1_CH1S                                PDB_S_REG(PDB1,1)
#define PDB1_CH1DLY0                             PDB_DLY_REG(PDB1,1,0)
#define PDB1_CH1DLY1                             PDB_DLY_REG(PDB1,1,1)
#define PDB1_DACINTC0                            PDB_INTC_REG(PDB1,0)
#define PDB1_DACINT0                             PDB_INT_REG(PDB1,0)
#define PDB1_POEN                                PDB_POEN_REG(PDB1)
#define PDB1_PO0DLY                              PDB_PODLY_REG(PDB1,0)
#define PDB1_PO1DLY                              PDB_PODLY_REG(PDB1,1)

/* PDB - Register array accessors */
#define PDB0_C1(index)                           PDB_C1_REG(PDB0,index)
#define PDB1_C1(index)                           PDB_C1_REG(PDB1,index)
#define PDB0_S(index)                            PDB_S_REG(PDB0,index)
#define PDB1_S(index)                            PDB_S_REG(PDB1,index)
#define PDB0_DLY(index,index2)                   PDB_DLY_REG(PDB0,index,index2)
#define PDB1_DLY(index,index2)                   PDB_DLY_REG(PDB1,index,index2)
#define PDB0_INTC(index)                         PDB_INTC_REG(PDB0,index)
#define PDB1_INTC(index)                         PDB_INTC_REG(PDB1,index)
#define PDB0_INT(index)                          PDB_INT_REG(PDB0,index)
#define PDB1_INT(index)                          PDB_INT_REG(PDB1,index)
#define PDB0_PODLY(index)                        PDB_PODLY_REG(PDB0,index)
#define PDB1_PODLY(index)                        PDB_PODLY_REG(PDB1,index)

/*!
 * @}
 */ /* end of group PDB_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PDB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PIT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Peripheral_Access_Layer PIT Peripheral Access Layer
 * @{
 */

/** PIT - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< PIT Module Control Register, offset: 0x0 */
       uint8_t RESERVED_0[252];
  struct {                                         /* offset: 0x100, array step: 0x10 */
    __IO uint32_t LDVAL;                             /**< Timer Load Value Register, array offset: 0x100, array step: 0x10 */
    __I  uint32_t CVAL;                              /**< Current Timer Value Register, array offset: 0x104, array step: 0x10 */
    __IO uint32_t TCTRL;                             /**< Timer Control Register, array offset: 0x108, array step: 0x10 */
    __IO uint32_t TFLG;                              /**< Timer Flag Register, array offset: 0x10C, array step: 0x10 */
  } CHANNEL[4];
} PIT_Type, *PIT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Accessor_Macros PIT - Register accessor macros
 * @{
 */


/* PIT - Register accessors */
#define PIT_MCR_REG(base)                        ((base)->MCR)
#define PIT_LDVAL_REG(base,index)                ((base)->CHANNEL[index].LDVAL)
#define PIT_LDVAL_COUNT                          4
#define PIT_CVAL_REG(base,index)                 ((base)->CHANNEL[index].CVAL)
#define PIT_CVAL_COUNT                           4
#define PIT_TCTRL_REG(base,index)                ((base)->CHANNEL[index].TCTRL)
#define PIT_TCTRL_COUNT                          4
#define PIT_TFLG_REG(base,index)                 ((base)->CHANNEL[index].TFLG)
#define PIT_TFLG_COUNT                           4

/*!
 * @}
 */ /* end of group PIT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PIT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Masks PIT Register Masks
 * @{
 */

/* MCR Bit Fields */
#define PIT_MCR_FRZ_MASK                         0x1u
#define PIT_MCR_FRZ_SHIFT                        0
#define PIT_MCR_FRZ_WIDTH                        1
#define PIT_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x))<<PIT_MCR_FRZ_SHIFT))&PIT_MCR_FRZ_MASK)
#define PIT_MCR_MDIS_MASK                        0x2u
#define PIT_MCR_MDIS_SHIFT                       1
#define PIT_MCR_MDIS_WIDTH                       1
#define PIT_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x))<<PIT_MCR_MDIS_SHIFT))&PIT_MCR_MDIS_MASK)
/* LDVAL Bit Fields */
#define PIT_LDVAL_TSV_MASK                       0xFFFFFFFFu
#define PIT_LDVAL_TSV_SHIFT                      0
#define PIT_LDVAL_TSV_WIDTH                      32
#define PIT_LDVAL_TSV(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_LDVAL_TSV_SHIFT))&PIT_LDVAL_TSV_MASK)
/* CVAL Bit Fields */
#define PIT_CVAL_TVL_MASK                        0xFFFFFFFFu
#define PIT_CVAL_TVL_SHIFT                       0
#define PIT_CVAL_TVL_WIDTH                       32
#define PIT_CVAL_TVL(x)                          (((uint32_t)(((uint32_t)(x))<<PIT_CVAL_TVL_SHIFT))&PIT_CVAL_TVL_MASK)
/* TCTRL Bit Fields */
#define PIT_TCTRL_TEN_MASK                       0x1u
#define PIT_TCTRL_TEN_SHIFT                      0
#define PIT_TCTRL_TEN_WIDTH                      1
#define PIT_TCTRL_TEN(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_TCTRL_TEN_SHIFT))&PIT_TCTRL_TEN_MASK)
#define PIT_TCTRL_TIE_MASK                       0x2u
#define PIT_TCTRL_TIE_SHIFT                      1
#define PIT_TCTRL_TIE_WIDTH                      1
#define PIT_TCTRL_TIE(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_TCTRL_TIE_SHIFT))&PIT_TCTRL_TIE_MASK)
#define PIT_TCTRL_CHN_MASK                       0x4u
#define PIT_TCTRL_CHN_SHIFT                      2
#define PIT_TCTRL_CHN_WIDTH                      1
#define PIT_TCTRL_CHN(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_TCTRL_CHN_SHIFT))&PIT_TCTRL_CHN_MASK)
/* TFLG Bit Fields */
#define PIT_TFLG_TIF_MASK                        0x1u
#define PIT_TFLG_TIF_SHIFT                       0
#define PIT_TFLG_TIF_WIDTH                       1
#define PIT_TFLG_TIF(x)                          (((uint32_t)(((uint32_t)(x))<<PIT_TFLG_TIF_SHIFT))&PIT_TFLG_TIF_MASK)

/*!
 * @}
 */ /* end of group PIT_Register_Masks */


/* PIT - Peripheral instance base addresses */
/** Peripheral PIT base address */
#define PIT_BASE                                 (0xDC000u)
/** Peripheral PIT base pointer */
#define PIT                                      ((PIT_Type *)PIT_BASE)
#define PIT_BASE_PTR                             (PIT)
/** Array initializer of PIT peripheral base addresses */
#define PIT_BASE_ADDRS                           { PIT_BASE }
/** Array initializer of PIT peripheral base pointers */
#define PIT_BASE_PTRS                            { PIT }

/* ----------------------------------------------------------------------------
   -- PIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Accessor_Macros PIT - Register accessor macros
 * @{
 */


/* PIT - Register instance definitions */
/* PIT */
#define PIT_MCR                                  PIT_MCR_REG(PIT)
#define PIT_LDVAL0                               PIT_LDVAL_REG(PIT,0)
#define PIT_CVAL0                                PIT_CVAL_REG(PIT,0)
#define PIT_TCTRL0                               PIT_TCTRL_REG(PIT,0)
#define PIT_TFLG0                                PIT_TFLG_REG(PIT,0)
#define PIT_LDVAL1                               PIT_LDVAL_REG(PIT,1)
#define PIT_CVAL1                                PIT_CVAL_REG(PIT,1)
#define PIT_TCTRL1                               PIT_TCTRL_REG(PIT,1)
#define PIT_TFLG1                                PIT_TFLG_REG(PIT,1)
#define PIT_LDVAL2                               PIT_LDVAL_REG(PIT,2)
#define PIT_CVAL2                                PIT_CVAL_REG(PIT,2)
#define PIT_TCTRL2                               PIT_TCTRL_REG(PIT,2)
#define PIT_TFLG2                                PIT_TFLG_REG(PIT,2)
#define PIT_LDVAL3                               PIT_LDVAL_REG(PIT,3)
#define PIT_CVAL3                                PIT_CVAL_REG(PIT,3)
#define PIT_TCTRL3                               PIT_TCTRL_REG(PIT,3)
#define PIT_TFLG3                                PIT_TFLG_REG(PIT,3)

/* PIT - Register array accessors */
#define PIT_LDVAL(index)                         PIT_LDVAL_REG(PIT,index)
#define PIT_CVAL(index)                          PIT_CVAL_REG(PIT,index)
#define PIT_TCTRL(index)                         PIT_TCTRL_REG(PIT,index)
#define PIT_TFLG(index)                          PIT_TFLG_REG(PIT,index)

/*!
 * @}
 */ /* end of group PIT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PIT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Peripheral_Access_Layer PMC Peripheral Access Layer
 * @{
 */

/** PMC - Register Layout Typedef */
typedef struct {
  __IO uint8_t LVDSC1;                             /**< Low Voltage Detect Status And Control 1 register, offset: 0x0 */
  __IO uint8_t LVDSC2;                             /**< Low Voltage Detect Status And Control 2 register, offset: 0x1 */
  __IO uint8_t REGSC;                              /**< Regulator Status And Control register, offset: 0x2 */
       uint8_t RESERVED_0[8];
  __IO uint8_t HVDSC1;                             /**< High Voltage Detect Status And Control 1 register, offset: 0xB */
} PMC_Type, *PMC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Accessor_Macros PMC - Register accessor macros
 * @{
 */


/* PMC - Register accessors */
#define PMC_LVDSC1_REG(base)                     ((base)->LVDSC1)
#define PMC_LVDSC2_REG(base)                     ((base)->LVDSC2)
#define PMC_REGSC_REG(base)                      ((base)->REGSC)
#define PMC_HVDSC1_REG(base)                     ((base)->HVDSC1)

/*!
 * @}
 */ /* end of group PMC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Masks PMC Register Masks
 * @{
 */

/* LVDSC1 Bit Fields */
#define PMC_LVDSC1_LVDV_MASK                     0x3u
#define PMC_LVDSC1_LVDV_SHIFT                    0
#define PMC_LVDSC1_LVDV_WIDTH                    2
#define PMC_LVDSC1_LVDV(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDV_SHIFT))&PMC_LVDSC1_LVDV_MASK)
#define PMC_LVDSC1_LVDRE_MASK                    0x10u
#define PMC_LVDSC1_LVDRE_SHIFT                   4
#define PMC_LVDSC1_LVDRE_WIDTH                   1
#define PMC_LVDSC1_LVDRE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDRE_SHIFT))&PMC_LVDSC1_LVDRE_MASK)
#define PMC_LVDSC1_LVDIE_MASK                    0x20u
#define PMC_LVDSC1_LVDIE_SHIFT                   5
#define PMC_LVDSC1_LVDIE_WIDTH                   1
#define PMC_LVDSC1_LVDIE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDIE_SHIFT))&PMC_LVDSC1_LVDIE_MASK)
#define PMC_LVDSC1_LVDACK_MASK                   0x40u
#define PMC_LVDSC1_LVDACK_SHIFT                  6
#define PMC_LVDSC1_LVDACK_WIDTH                  1
#define PMC_LVDSC1_LVDACK(x)                     (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDACK_SHIFT))&PMC_LVDSC1_LVDACK_MASK)
#define PMC_LVDSC1_LVDF_MASK                     0x80u
#define PMC_LVDSC1_LVDF_SHIFT                    7
#define PMC_LVDSC1_LVDF_WIDTH                    1
#define PMC_LVDSC1_LVDF(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDF_SHIFT))&PMC_LVDSC1_LVDF_MASK)
/* LVDSC2 Bit Fields */
#define PMC_LVDSC2_LVWV_MASK                     0x3u
#define PMC_LVDSC2_LVWV_SHIFT                    0
#define PMC_LVDSC2_LVWV_WIDTH                    2
#define PMC_LVDSC2_LVWV(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWV_SHIFT))&PMC_LVDSC2_LVWV_MASK)
#define PMC_LVDSC2_LVWIE_MASK                    0x20u
#define PMC_LVDSC2_LVWIE_SHIFT                   5
#define PMC_LVDSC2_LVWIE_WIDTH                   1
#define PMC_LVDSC2_LVWIE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWIE_SHIFT))&PMC_LVDSC2_LVWIE_MASK)
#define PMC_LVDSC2_LVWACK_MASK                   0x40u
#define PMC_LVDSC2_LVWACK_SHIFT                  6
#define PMC_LVDSC2_LVWACK_WIDTH                  1
#define PMC_LVDSC2_LVWACK(x)                     (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWACK_SHIFT))&PMC_LVDSC2_LVWACK_MASK)
#define PMC_LVDSC2_LVWF_MASK                     0x80u
#define PMC_LVDSC2_LVWF_SHIFT                    7
#define PMC_LVDSC2_LVWF_WIDTH                    1
#define PMC_LVDSC2_LVWF(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWF_SHIFT))&PMC_LVDSC2_LVWF_MASK)
/* REGSC Bit Fields */
#define PMC_REGSC_BGBE_MASK                      0x1u
#define PMC_REGSC_BGBE_SHIFT                     0
#define PMC_REGSC_BGBE_WIDTH                     1
#define PMC_REGSC_BGBE(x)                        (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_BGBE_SHIFT))&PMC_REGSC_BGBE_MASK)
#define PMC_REGSC_REGONS_MASK                    0x4u
#define PMC_REGSC_REGONS_SHIFT                   2
#define PMC_REGSC_REGONS_WIDTH                   1
#define PMC_REGSC_REGONS(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_REGONS_SHIFT))&PMC_REGSC_REGONS_MASK)
#define PMC_REGSC_ACKISO_MASK                    0x8u
#define PMC_REGSC_ACKISO_SHIFT                   3
#define PMC_REGSC_ACKISO_WIDTH                   1
#define PMC_REGSC_ACKISO(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_ACKISO_SHIFT))&PMC_REGSC_ACKISO_MASK)
#define PMC_REGSC_BGEN_MASK                      0x10u
#define PMC_REGSC_BGEN_SHIFT                     4
#define PMC_REGSC_BGEN_WIDTH                     1
#define PMC_REGSC_BGEN(x)                        (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_BGEN_SHIFT))&PMC_REGSC_BGEN_MASK)
/* HVDSC1 Bit Fields */
#define PMC_HVDSC1_HVDV_MASK                     0x1u
#define PMC_HVDSC1_HVDV_SHIFT                    0
#define PMC_HVDSC1_HVDV_WIDTH                    1
#define PMC_HVDSC1_HVDV(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDV_SHIFT))&PMC_HVDSC1_HVDV_MASK)
#define PMC_HVDSC1_HVDRE_MASK                    0x10u
#define PMC_HVDSC1_HVDRE_SHIFT                   4
#define PMC_HVDSC1_HVDRE_WIDTH                   1
#define PMC_HVDSC1_HVDRE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDRE_SHIFT))&PMC_HVDSC1_HVDRE_MASK)
#define PMC_HVDSC1_HVDIE_MASK                    0x20u
#define PMC_HVDSC1_HVDIE_SHIFT                   5
#define PMC_HVDSC1_HVDIE_WIDTH                   1
#define PMC_HVDSC1_HVDIE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDIE_SHIFT))&PMC_HVDSC1_HVDIE_MASK)
#define PMC_HVDSC1_HVDACK_MASK                   0x40u
#define PMC_HVDSC1_HVDACK_SHIFT                  6
#define PMC_HVDSC1_HVDACK_WIDTH                  1
#define PMC_HVDSC1_HVDACK(x)                     (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDACK_SHIFT))&PMC_HVDSC1_HVDACK_MASK)
#define PMC_HVDSC1_HVDF_MASK                     0x80u
#define PMC_HVDSC1_HVDF_SHIFT                    7
#define PMC_HVDSC1_HVDF_WIDTH                    1
#define PMC_HVDSC1_HVDF(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDF_SHIFT))&PMC_HVDSC1_HVDF_MASK)

/*!
 * @}
 */ /* end of group PMC_Register_Masks */


/* PMC - Peripheral instance base addresses */
/** Peripheral PMC base address */
#define PMC_BASE                                 (0x4007D000u)
/** Peripheral PMC base pointer */
#define PMC                                      ((PMC_Type *)PMC_BASE)
#define PMC_BASE_PTR                             (PMC)
/** Array initializer of PMC peripheral base addresses */
#define PMC_BASE_ADDRS                           { PMC_BASE }
/** Array initializer of PMC peripheral base pointers */
#define PMC_BASE_PTRS                            { PMC }

/* ----------------------------------------------------------------------------
   -- PMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Accessor_Macros PMC - Register accessor macros
 * @{
 */


/* PMC - Register instance definitions */
/* PMC */
#define PMC_LVDSC1                               PMC_LVDSC1_REG(PMC)
#define PMC_LVDSC2                               PMC_LVDSC2_REG(PMC)
#define PMC_REGSC                                PMC_REGSC_REG(PMC)
#define PMC_HVDSC1                               PMC_HVDSC1_REG(PMC)

/*!
 * @}
 */ /* end of group PMC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PORT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Peripheral_Access_Layer PORT Peripheral Access Layer
 * @{
 */

/** PORT - Register Layout Typedef */
typedef struct {
  __IO uint32_t PCR[32];                           /**< Pin Control Register n, array offset: 0x0, array step: 0x4 */
  __O  uint32_t GPCLR;                             /**< Global Pin Control Low Register, offset: 0x80 */
  __O  uint32_t GPCHR;                             /**< Global Pin Control High Register, offset: 0x84 */
  __O  uint32_t GICLR;                             /**< Global Interrupt Control Low Register, offset: 0x88 */
  __O  uint32_t GICHR;                             /**< Global Interrupt Control High Register, offset: 0x8C */
       uint8_t RESERVED_0[16];
  __IO uint32_t ISFR;                              /**< Interrupt Status Flag Register, offset: 0xA0 */
       uint8_t RESERVED_1[28];
  __IO uint32_t DFER;                              /**< Digital Filter Enable Register, offset: 0xC0 */
  __IO uint32_t DFCR;                              /**< Digital Filter Clock Register, offset: 0xC4 */
  __IO uint32_t DFWR;                              /**< Digital Filter Width Register, offset: 0xC8 */
} PORT_Type, *PORT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PORT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Accessor_Macros PORT - Register accessor macros
 * @{
 */


/* PORT - Register accessors */
#define PORT_PCR_REG(base,index)                 ((base)->PCR[index])
#define PORT_PCR_COUNT                           32
#define PORT_GPCLR_REG(base)                     ((base)->GPCLR)
#define PORT_GPCHR_REG(base)                     ((base)->GPCHR)
#define PORT_GICLR_REG(base)                     ((base)->GICLR)
#define PORT_GICHR_REG(base)                     ((base)->GICHR)
#define PORT_ISFR_REG(base)                      ((base)->ISFR)
#define PORT_DFER_REG(base)                      ((base)->DFER)
#define PORT_DFCR_REG(base)                      ((base)->DFCR)
#define PORT_DFWR_REG(base)                      ((base)->DFWR)

/*!
 * @}
 */ /* end of group PORT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PORT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Masks PORT Register Masks
 * @{
 */

/* PCR Bit Fields */
#define PORT_PCR_PS_MASK                         0x1u
#define PORT_PCR_PS_SHIFT                        0
#define PORT_PCR_PS_WIDTH                        1
#define PORT_PCR_PS(x)                           (((uint32_t)(((uint32_t)(x))<<PORT_PCR_PS_SHIFT))&PORT_PCR_PS_MASK)
#define PORT_PCR_PE_MASK                         0x2u
#define PORT_PCR_PE_SHIFT                        1
#define PORT_PCR_PE_WIDTH                        1
#define PORT_PCR_PE(x)                           (((uint32_t)(((uint32_t)(x))<<PORT_PCR_PE_SHIFT))&PORT_PCR_PE_MASK)
#define PORT_PCR_SRE_MASK                        0x4u
#define PORT_PCR_SRE_SHIFT                       2
#define PORT_PCR_SRE_WIDTH                       1
#define PORT_PCR_SRE(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_SRE_SHIFT))&PORT_PCR_SRE_MASK)
#define PORT_PCR_PFE_MASK                        0x10u
#define PORT_PCR_PFE_SHIFT                       4
#define PORT_PCR_PFE_WIDTH                       1
#define PORT_PCR_PFE(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_PFE_SHIFT))&PORT_PCR_PFE_MASK)
#define PORT_PCR_ODE_MASK                        0x20u
#define PORT_PCR_ODE_SHIFT                       5
#define PORT_PCR_ODE_WIDTH                       1
#define PORT_PCR_ODE(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_ODE_SHIFT))&PORT_PCR_ODE_MASK)
#define PORT_PCR_DSE_MASK                        0x40u
#define PORT_PCR_DSE_SHIFT                       6
#define PORT_PCR_DSE_WIDTH                       1
#define PORT_PCR_DSE(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_DSE_SHIFT))&PORT_PCR_DSE_MASK)
#define PORT_PCR_MUX_MASK                        0xF00u
#define PORT_PCR_MUX_SHIFT                       8
#define PORT_PCR_MUX_WIDTH                       4
#define PORT_PCR_MUX(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_MUX_SHIFT))&PORT_PCR_MUX_MASK)
#define PORT_PCR_LK_MASK                         0x8000u
#define PORT_PCR_LK_SHIFT                        15
#define PORT_PCR_LK_WIDTH                        1
#define PORT_PCR_LK(x)                           (((uint32_t)(((uint32_t)(x))<<PORT_PCR_LK_SHIFT))&PORT_PCR_LK_MASK)
#define PORT_PCR_IRQC_MASK                       0xF0000u
#define PORT_PCR_IRQC_SHIFT                      16
#define PORT_PCR_IRQC_WIDTH                      4
#define PORT_PCR_IRQC(x)                         (((uint32_t)(((uint32_t)(x))<<PORT_PCR_IRQC_SHIFT))&PORT_PCR_IRQC_MASK)
#define PORT_PCR_ISF_MASK                        0x1000000u
#define PORT_PCR_ISF_SHIFT                       24
#define PORT_PCR_ISF_WIDTH                       1
#define PORT_PCR_ISF(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_ISF_SHIFT))&PORT_PCR_ISF_MASK)
/* GPCLR Bit Fields */
#define PORT_GPCLR_GPWD_MASK                     0xFFFFu
#define PORT_GPCLR_GPWD_SHIFT                    0
#define PORT_GPCLR_GPWD_WIDTH                    16
#define PORT_GPCLR_GPWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCLR_GPWD_SHIFT))&PORT_GPCLR_GPWD_MASK)
#define PORT_GPCLR_GPWE_MASK                     0xFFFF0000u
#define PORT_GPCLR_GPWE_SHIFT                    16
#define PORT_GPCLR_GPWE_WIDTH                    16
#define PORT_GPCLR_GPWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCLR_GPWE_SHIFT))&PORT_GPCLR_GPWE_MASK)
/* GPCHR Bit Fields */
#define PORT_GPCHR_GPWD_MASK                     0xFFFFu
#define PORT_GPCHR_GPWD_SHIFT                    0
#define PORT_GPCHR_GPWD_WIDTH                    16
#define PORT_GPCHR_GPWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCHR_GPWD_SHIFT))&PORT_GPCHR_GPWD_MASK)
#define PORT_GPCHR_GPWE_MASK                     0xFFFF0000u
#define PORT_GPCHR_GPWE_SHIFT                    16
#define PORT_GPCHR_GPWE_WIDTH                    16
#define PORT_GPCHR_GPWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCHR_GPWE_SHIFT))&PORT_GPCHR_GPWE_MASK)
/* GICLR Bit Fields */
#define PORT_GICLR_GIWE_MASK                     0xFFFFu
#define PORT_GICLR_GIWE_SHIFT                    0
#define PORT_GICLR_GIWE_WIDTH                    16
#define PORT_GICLR_GIWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICLR_GIWE_SHIFT))&PORT_GICLR_GIWE_MASK)
#define PORT_GICLR_GIWD_MASK                     0xFFFF0000u
#define PORT_GICLR_GIWD_SHIFT                    16
#define PORT_GICLR_GIWD_WIDTH                    16
#define PORT_GICLR_GIWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICLR_GIWD_SHIFT))&PORT_GICLR_GIWD_MASK)
/* GICHR Bit Fields */
#define PORT_GICHR_GIWE_MASK                     0xFFFFu
#define PORT_GICHR_GIWE_SHIFT                    0
#define PORT_GICHR_GIWE_WIDTH                    16
#define PORT_GICHR_GIWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICHR_GIWE_SHIFT))&PORT_GICHR_GIWE_MASK)
#define PORT_GICHR_GIWD_MASK                     0xFFFF0000u
#define PORT_GICHR_GIWD_SHIFT                    16
#define PORT_GICHR_GIWD_WIDTH                    16
#define PORT_GICHR_GIWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICHR_GIWD_SHIFT))&PORT_GICHR_GIWD_MASK)
/* ISFR Bit Fields */
#define PORT_ISFR_ISF_MASK                       0xFFFFFFFFu
#define PORT_ISFR_ISF_SHIFT                      0
#define PORT_ISFR_ISF_WIDTH                      32
#define PORT_ISFR_ISF(x)                         (((uint32_t)(((uint32_t)(x))<<PORT_ISFR_ISF_SHIFT))&PORT_ISFR_ISF_MASK)
/* DFER Bit Fields */
#define PORT_DFER_DFE_MASK                       0xFFFFFFFFu
#define PORT_DFER_DFE_SHIFT                      0
#define PORT_DFER_DFE_WIDTH                      32
#define PORT_DFER_DFE(x)                         (((uint32_t)(((uint32_t)(x))<<PORT_DFER_DFE_SHIFT))&PORT_DFER_DFE_MASK)
/* DFCR Bit Fields */
#define PORT_DFCR_CS_MASK                        0x1u
#define PORT_DFCR_CS_SHIFT                       0
#define PORT_DFCR_CS_WIDTH                       1
#define PORT_DFCR_CS(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_DFCR_CS_SHIFT))&PORT_DFCR_CS_MASK)
/* DFWR Bit Fields */
#define PORT_DFWR_FILT_MASK                      0x1Fu
#define PORT_DFWR_FILT_SHIFT                     0
#define PORT_DFWR_FILT_WIDTH                     5
#define PORT_DFWR_FILT(x)                        (((uint32_t)(((uint32_t)(x))<<PORT_DFWR_FILT_SHIFT))&PORT_DFWR_FILT_MASK)

/*!
 * @}
 */ /* end of group PORT_Register_Masks */


/* PORT - Peripheral instance base addresses */
/** Peripheral PORTA base address */
#define PORTA_BASE                               (0x40049000u)
/** Peripheral PORTA base pointer */
#define PORTA                                    ((PORT_Type *)PORTA_BASE)
#define PORTA_BASE_PTR                           (PORTA)
/** Peripheral PORTB base address */
#define PORTB_BASE                               (0x4004A000u)
/** Peripheral PORTB base pointer */
#define PORTB                                    ((PORT_Type *)PORTB_BASE)
#define PORTB_BASE_PTR                           (PORTB)
/** Peripheral PORTC base address */
#define PORTC_BASE                               (0x4004B000u)
/** Peripheral PORTC base pointer */
#define PORTC                                    ((PORT_Type *)PORTC_BASE)
#define PORTC_BASE_PTR                           (PORTC)
/** Peripheral PORTD base address */
#define PORTD_BASE                               (0x4004C000u)
/** Peripheral PORTD base pointer */
#define PORTD                                    ((PORT_Type *)PORTD_BASE)
#define PORTD_BASE_PTR                           (PORTD)
/** Peripheral PORTE base address */
#define PORTE_BASE                               (0x4004D000u)
/** Peripheral PORTE base pointer */
#define PORTE                                    ((PORT_Type *)PORTE_BASE)
#define PORTE_BASE_PTR                           (PORTE)
/** Array initializer of PORT peripheral base addresses */
#define PORT_BASE_ADDRS                          { PORTA_BASE, PORTB_BASE, PORTC_BASE, PORTD_BASE, PORTE_BASE }
/** Array initializer of PORT peripheral base pointers */
#define PORT_BASE_PTRS                           { PORTA, PORTB, PORTC, PORTD, PORTE }

/* ----------------------------------------------------------------------------
   -- PORT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Accessor_Macros PORT - Register accessor macros
 * @{
 */


/* PORT - Register instance definitions */
/* PORTA */
#define PORTA_PCR0                               PORT_PCR_REG(PORTA,0)
#define PORTA_PCR1                               PORT_PCR_REG(PORTA,1)
#define PORTA_PCR2                               PORT_PCR_REG(PORTA,2)
#define PORTA_PCR3                               PORT_PCR_REG(PORTA,3)
#define PORTA_PCR4                               PORT_PCR_REG(PORTA,4)
#define PORTA_PCR5                               PORT_PCR_REG(PORTA,5)
#define PORTA_PCR6                               PORT_PCR_REG(PORTA,6)
#define PORTA_PCR7                               PORT_PCR_REG(PORTA,7)
#define PORTA_PCR8                               PORT_PCR_REG(PORTA,8)
#define PORTA_PCR9                               PORT_PCR_REG(PORTA,9)
#define PORTA_PCR10                              PORT_PCR_REG(PORTA,10)
#define PORTA_PCR11                              PORT_PCR_REG(PORTA,11)
#define PORTA_PCR12                              PORT_PCR_REG(PORTA,12)
#define PORTA_PCR13                              PORT_PCR_REG(PORTA,13)
#define PORTA_PCR14                              PORT_PCR_REG(PORTA,14)
#define PORTA_PCR15                              PORT_PCR_REG(PORTA,15)
#define PORTA_PCR16                              PORT_PCR_REG(PORTA,16)
#define PORTA_PCR17                              PORT_PCR_REG(PORTA,17)
#define PORTA_PCR18                              PORT_PCR_REG(PORTA,18)
#define PORTA_PCR19                              PORT_PCR_REG(PORTA,19)
#define PORTA_PCR20                              PORT_PCR_REG(PORTA,20)
#define PORTA_PCR21                              PORT_PCR_REG(PORTA,21)
#define PORTA_PCR22                              PORT_PCR_REG(PORTA,22)
#define PORTA_PCR23                              PORT_PCR_REG(PORTA,23)
#define PORTA_PCR24                              PORT_PCR_REG(PORTA,24)
#define PORTA_PCR25                              PORT_PCR_REG(PORTA,25)
#define PORTA_PCR26                              PORT_PCR_REG(PORTA,26)
#define PORTA_PCR27                              PORT_PCR_REG(PORTA,27)
#define PORTA_PCR28                              PORT_PCR_REG(PORTA,28)
#define PORTA_PCR29                              PORT_PCR_REG(PORTA,29)
#define PORTA_PCR30                              PORT_PCR_REG(PORTA,30)
#define PORTA_PCR31                              PORT_PCR_REG(PORTA,31)
#define PORTA_GPCLR                              PORT_GPCLR_REG(PORTA)
#define PORTA_GPCHR                              PORT_GPCHR_REG(PORTA)
#define PORTA_GICLR                              PORT_GICLR_REG(PORTA)
#define PORTA_GICHR                              PORT_GICHR_REG(PORTA)
#define PORTA_ISFR                               PORT_ISFR_REG(PORTA)
#define PORTA_DFER                               PORT_DFER_REG(PORTA)
#define PORTA_DFCR                               PORT_DFCR_REG(PORTA)
#define PORTA_DFWR                               PORT_DFWR_REG(PORTA)
/* PORTB */
#define PORTB_PCR0                               PORT_PCR_REG(PORTB,0)
#define PORTB_PCR1                               PORT_PCR_REG(PORTB,1)
#define PORTB_PCR2                               PORT_PCR_REG(PORTB,2)
#define PORTB_PCR3                               PORT_PCR_REG(PORTB,3)
#define PORTB_PCR4                               PORT_PCR_REG(PORTB,4)
#define PORTB_PCR5                               PORT_PCR_REG(PORTB,5)
#define PORTB_PCR6                               PORT_PCR_REG(PORTB,6)
#define PORTB_PCR7                               PORT_PCR_REG(PORTB,7)
#define PORTB_PCR8                               PORT_PCR_REG(PORTB,8)
#define PORTB_PCR9                               PORT_PCR_REG(PORTB,9)
#define PORTB_PCR10                              PORT_PCR_REG(PORTB,10)
#define PORTB_PCR11                              PORT_PCR_REG(PORTB,11)
#define PORTB_PCR12                              PORT_PCR_REG(PORTB,12)
#define PORTB_PCR13                              PORT_PCR_REG(PORTB,13)
#define PORTB_PCR14                              PORT_PCR_REG(PORTB,14)
#define PORTB_PCR15                              PORT_PCR_REG(PORTB,15)
#define PORTB_PCR16                              PORT_PCR_REG(PORTB,16)
#define PORTB_PCR17                              PORT_PCR_REG(PORTB,17)
#define PORTB_PCR18                              PORT_PCR_REG(PORTB,18)
#define PORTB_PCR19                              PORT_PCR_REG(PORTB,19)
#define PORTB_PCR20                              PORT_PCR_REG(PORTB,20)
#define PORTB_PCR21                              PORT_PCR_REG(PORTB,21)
#define PORTB_PCR22                              PORT_PCR_REG(PORTB,22)
#define PORTB_PCR23                              PORT_PCR_REG(PORTB,23)
#define PORTB_PCR24                              PORT_PCR_REG(PORTB,24)
#define PORTB_PCR25                              PORT_PCR_REG(PORTB,25)
#define PORTB_PCR26                              PORT_PCR_REG(PORTB,26)
#define PORTB_PCR27                              PORT_PCR_REG(PORTB,27)
#define PORTB_PCR28                              PORT_PCR_REG(PORTB,28)
#define PORTB_PCR29                              PORT_PCR_REG(PORTB,29)
#define PORTB_PCR30                              PORT_PCR_REG(PORTB,30)
#define PORTB_PCR31                              PORT_PCR_REG(PORTB,31)
#define PORTB_GPCLR                              PORT_GPCLR_REG(PORTB)
#define PORTB_GPCHR                              PORT_GPCHR_REG(PORTB)
#define PORTB_GICLR                              PORT_GICLR_REG(PORTB)
#define PORTB_GICHR                              PORT_GICHR_REG(PORTB)
#define PORTB_ISFR                               PORT_ISFR_REG(PORTB)
#define PORTB_DFER                               PORT_DFER_REG(PORTB)
#define PORTB_DFCR                               PORT_DFCR_REG(PORTB)
#define PORTB_DFWR                               PORT_DFWR_REG(PORTB)
/* PORTC */
#define PORTC_PCR0                               PORT_PCR_REG(PORTC,0)
#define PORTC_PCR1                               PORT_PCR_REG(PORTC,1)
#define PORTC_PCR2                               PORT_PCR_REG(PORTC,2)
#define PORTC_PCR3                               PORT_PCR_REG(PORTC,3)
#define PORTC_PCR4                               PORT_PCR_REG(PORTC,4)
#define PORTC_PCR5                               PORT_PCR_REG(PORTC,5)
#define PORTC_PCR6                               PORT_PCR_REG(PORTC,6)
#define PORTC_PCR7                               PORT_PCR_REG(PORTC,7)
#define PORTC_PCR8                               PORT_PCR_REG(PORTC,8)
#define PORTC_PCR9                               PORT_PCR_REG(PORTC,9)
#define PORTC_PCR10                              PORT_PCR_REG(PORTC,10)
#define PORTC_PCR11                              PORT_PCR_REG(PORTC,11)
#define PORTC_PCR12                              PORT_PCR_REG(PORTC,12)
#define PORTC_PCR13                              PORT_PCR_REG(PORTC,13)
#define PORTC_PCR14                              PORT_PCR_REG(PORTC,14)
#define PORTC_PCR15                              PORT_PCR_REG(PORTC,15)
#define PORTC_PCR16                              PORT_PCR_REG(PORTC,16)
#define PORTC_PCR17                              PORT_PCR_REG(PORTC,17)
#define PORTC_PCR18                              PORT_PCR_REG(PORTC,18)
#define PORTC_PCR19                              PORT_PCR_REG(PORTC,19)
#define PORTC_PCR20                              PORT_PCR_REG(PORTC,20)
#define PORTC_PCR21                              PORT_PCR_REG(PORTC,21)
#define PORTC_PCR22                              PORT_PCR_REG(PORTC,22)
#define PORTC_PCR23                              PORT_PCR_REG(PORTC,23)
#define PORTC_PCR24                              PORT_PCR_REG(PORTC,24)
#define PORTC_PCR25                              PORT_PCR_REG(PORTC,25)
#define PORTC_PCR26                              PORT_PCR_REG(PORTC,26)
#define PORTC_PCR27                              PORT_PCR_REG(PORTC,27)
#define PORTC_PCR28                              PORT_PCR_REG(PORTC,28)
#define PORTC_PCR29                              PORT_PCR_REG(PORTC,29)
#define PORTC_PCR30                              PORT_PCR_REG(PORTC,30)
#define PORTC_PCR31                              PORT_PCR_REG(PORTC,31)
#define PORTC_GPCLR                              PORT_GPCLR_REG(PORTC)
#define PORTC_GPCHR                              PORT_GPCHR_REG(PORTC)
#define PORTC_GICLR                              PORT_GICLR_REG(PORTC)
#define PORTC_GICHR                              PORT_GICHR_REG(PORTC)
#define PORTC_ISFR                               PORT_ISFR_REG(PORTC)
#define PORTC_DFER                               PORT_DFER_REG(PORTC)
#define PORTC_DFCR                               PORT_DFCR_REG(PORTC)
#define PORTC_DFWR                               PORT_DFWR_REG(PORTC)
/* PORTD */
#define PORTD_PCR0                               PORT_PCR_REG(PORTD,0)
#define PORTD_PCR1                               PORT_PCR_REG(PORTD,1)
#define PORTD_PCR2                               PORT_PCR_REG(PORTD,2)
#define PORTD_PCR3                               PORT_PCR_REG(PORTD,3)
#define PORTD_PCR4                               PORT_PCR_REG(PORTD,4)
#define PORTD_PCR5                               PORT_PCR_REG(PORTD,5)
#define PORTD_PCR6                               PORT_PCR_REG(PORTD,6)
#define PORTD_PCR7                               PORT_PCR_REG(PORTD,7)
#define PORTD_PCR8                               PORT_PCR_REG(PORTD,8)
#define PORTD_PCR9                               PORT_PCR_REG(PORTD,9)
#define PORTD_PCR10                              PORT_PCR_REG(PORTD,10)
#define PORTD_PCR11                              PORT_PCR_REG(PORTD,11)
#define PORTD_PCR12                              PORT_PCR_REG(PORTD,12)
#define PORTD_PCR13                              PORT_PCR_REG(PORTD,13)
#define PORTD_PCR14                              PORT_PCR_REG(PORTD,14)
#define PORTD_PCR15                              PORT_PCR_REG(PORTD,15)
#define PORTD_PCR16                              PORT_PCR_REG(PORTD,16)
#define PORTD_PCR17                              PORT_PCR_REG(PORTD,17)
#define PORTD_PCR18                              PORT_PCR_REG(PORTD,18)
#define PORTD_PCR19                              PORT_PCR_REG(PORTD,19)
#define PORTD_PCR20                              PORT_PCR_REG(PORTD,20)
#define PORTD_PCR21                              PORT_PCR_REG(PORTD,21)
#define PORTD_PCR22                              PORT_PCR_REG(PORTD,22)
#define PORTD_PCR23                              PORT_PCR_REG(PORTD,23)
#define PORTD_PCR24                              PORT_PCR_REG(PORTD,24)
#define PORTD_PCR25                              PORT_PCR_REG(PORTD,25)
#define PORTD_PCR26                              PORT_PCR_REG(PORTD,26)
#define PORTD_PCR27                              PORT_PCR_REG(PORTD,27)
#define PORTD_PCR28                              PORT_PCR_REG(PORTD,28)
#define PORTD_PCR29                              PORT_PCR_REG(PORTD,29)
#define PORTD_PCR30                              PORT_PCR_REG(PORTD,30)
#define PORTD_PCR31                              PORT_PCR_REG(PORTD,31)
#define PORTD_GPCLR                              PORT_GPCLR_REG(PORTD)
#define PORTD_GPCHR                              PORT_GPCHR_REG(PORTD)
#define PORTD_GICLR                              PORT_GICLR_REG(PORTD)
#define PORTD_GICHR                              PORT_GICHR_REG(PORTD)
#define PORTD_ISFR                               PORT_ISFR_REG(PORTD)
#define PORTD_DFER                               PORT_DFER_REG(PORTD)
#define PORTD_DFCR                               PORT_DFCR_REG(PORTD)
#define PORTD_DFWR                               PORT_DFWR_REG(PORTD)
/* PORTE */
#define PORTE_PCR0                               PORT_PCR_REG(PORTE,0)
#define PORTE_PCR1                               PORT_PCR_REG(PORTE,1)
#define PORTE_PCR2                               PORT_PCR_REG(PORTE,2)
#define PORTE_PCR3                               PORT_PCR_REG(PORTE,3)
#define PORTE_PCR4                               PORT_PCR_REG(PORTE,4)
#define PORTE_PCR5                               PORT_PCR_REG(PORTE,5)
#define PORTE_PCR6                               PORT_PCR_REG(PORTE,6)
#define PORTE_PCR7                               PORT_PCR_REG(PORTE,7)
#define PORTE_PCR8                               PORT_PCR_REG(PORTE,8)
#define PORTE_PCR9                               PORT_PCR_REG(PORTE,9)
#define PORTE_PCR10                              PORT_PCR_REG(PORTE,10)
#define PORTE_PCR11                              PORT_PCR_REG(PORTE,11)
#define PORTE_PCR12                              PORT_PCR_REG(PORTE,12)
#define PORTE_PCR13                              PORT_PCR_REG(PORTE,13)
#define PORTE_PCR14                              PORT_PCR_REG(PORTE,14)
#define PORTE_PCR15                              PORT_PCR_REG(PORTE,15)
#define PORTE_PCR16                              PORT_PCR_REG(PORTE,16)
#define PORTE_PCR17                              PORT_PCR_REG(PORTE,17)
#define PORTE_PCR18                              PORT_PCR_REG(PORTE,18)
#define PORTE_PCR19                              PORT_PCR_REG(PORTE,19)
#define PORTE_PCR20                              PORT_PCR_REG(PORTE,20)
#define PORTE_PCR21                              PORT_PCR_REG(PORTE,21)
#define PORTE_PCR22                              PORT_PCR_REG(PORTE,22)
#define PORTE_PCR23                              PORT_PCR_REG(PORTE,23)
#define PORTE_PCR24                              PORT_PCR_REG(PORTE,24)
#define PORTE_PCR25                              PORT_PCR_REG(PORTE,25)
#define PORTE_PCR26                              PORT_PCR_REG(PORTE,26)
#define PORTE_PCR27                              PORT_PCR_REG(PORTE,27)
#define PORTE_PCR28                              PORT_PCR_REG(PORTE,28)
#define PORTE_PCR29                              PORT_PCR_REG(PORTE,29)
#define PORTE_PCR30                              PORT_PCR_REG(PORTE,30)
#define PORTE_PCR31                              PORT_PCR_REG(PORTE,31)
#define PORTE_GPCLR                              PORT_GPCLR_REG(PORTE)
#define PORTE_GPCHR                              PORT_GPCHR_REG(PORTE)
#define PORTE_GICLR                              PORT_GICLR_REG(PORTE)
#define PORTE_GICHR                              PORT_GICHR_REG(PORTE)
#define PORTE_ISFR                               PORT_ISFR_REG(PORTE)
#define PORTE_DFER                               PORT_DFER_REG(PORTE)
#define PORTE_DFCR                               PORT_DFCR_REG(PORTE)
#define PORTE_DFWR                               PORT_DFWR_REG(PORTE)

/* PORT - Register array accessors */
#define PORTA_PCR(index)                         PORT_PCR_REG(PORTA,index)
#define PORTB_PCR(index)                         PORT_PCR_REG(PORTB,index)
#define PORTC_PCR(index)                         PORT_PCR_REG(PORTC,index)
#define PORTD_PCR(index)                         PORT_PCR_REG(PORTD,index)
#define PORTE_PCR(index)                         PORT_PCR_REG(PORTE,index)

/*!
 * @}
 */ /* end of group PORT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PORT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PWM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PWM_Peripheral_Access_Layer PWM Peripheral Access Layer
 * @{
 */

/** PWM - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x60 */
    __I  uint16_t CNT;                               /**< Counter Register, array offset: 0x0, array step: 0x60 */
    __IO uint16_t INIT;                              /**< Initial Count Register, array offset: 0x2, array step: 0x60 */
    __IO uint16_t CTRL2;                             /**< Control 2 Register, array offset: 0x4, array step: 0x60 */
    __IO uint16_t CTRL;                              /**< Control Register, array offset: 0x6, array step: 0x60 */
         uint8_t RESERVED_0[2];
    __IO uint16_t VAL0;                              /**< Value Register 0, array offset: 0xA, array step: 0x60 */
    __IO uint16_t FRACVAL1;                          /**< Fractional Value Register 1, array offset: 0xC, array step: 0x60 */
    __IO uint16_t VAL1;                              /**< Value Register 1, array offset: 0xE, array step: 0x60 */
    __IO uint16_t FRACVAL2;                          /**< Fractional Value Register 2, array offset: 0x10, array step: 0x60 */
    __IO uint16_t VAL2;                              /**< Value Register 2, array offset: 0x12, array step: 0x60 */
    __IO uint16_t FRACVAL3;                          /**< Fractional Value Register 3, array offset: 0x14, array step: 0x60 */
    __IO uint16_t VAL3;                              /**< Value Register 3, array offset: 0x16, array step: 0x60 */
    __IO uint16_t FRACVAL4;                          /**< Fractional Value Register 4, array offset: 0x18, array step: 0x60 */
    __IO uint16_t VAL4;                              /**< Value Register 4, array offset: 0x1A, array step: 0x60 */
    __IO uint16_t FRACVAL5;                          /**< Fractional Value Register 5, array offset: 0x1C, array step: 0x60 */
    __IO uint16_t VAL5;                              /**< Value Register 5, array offset: 0x1E, array step: 0x60 */
    __IO uint16_t FRCTRL;                            /**< Fractional Control Register, array offset: 0x20, array step: 0x60 */
    __IO uint16_t OCTRL;                             /**< Output Control Register, array offset: 0x22, array step: 0x60 */
    __IO uint16_t STS;                               /**< Status Register, array offset: 0x24, array step: 0x60 */
    __IO uint16_t INTEN;                             /**< Interrupt Enable Register, array offset: 0x26, array step: 0x60 */
    __IO uint16_t DMAEN;                             /**< DMA Enable Register, array offset: 0x28, array step: 0x60 */
    __IO uint16_t TCTRL;                             /**< Output Trigger Control Register, array offset: 0x2A, array step: 0x60 */
    __IO uint16_t DISMAP[2];                         /**< Fault Disable Mapping Register 0..Fault Disable Mapping Register 1, array offset: 0x2C, array step: index*0x60, index2*0x2 */
    __IO uint16_t DTCNT0;                            /**< Deadtime Count Register 0, array offset: 0x30, array step: 0x60 */
    __IO uint16_t DTCNT1;                            /**< Deadtime Count Register 1, array offset: 0x32, array step: 0x60 */
    __IO uint16_t CAPTCTRLA;                         /**< Capture Control A Register, array offset: 0x34, array step: 0x60 */
    __IO uint16_t CAPTCOMPA;                         /**< Capture Compare A Register, array offset: 0x36, array step: 0x60 */
    __IO uint16_t CAPTCTRLB;                         /**< Capture Control B Register, array offset: 0x38, array step: 0x60 */
    __IO uint16_t CAPTCOMPB;                         /**< Capture Compare B Register, array offset: 0x3A, array step: 0x60 */
    __IO uint16_t CAPTCTRLX;                         /**< Capture Control X Register, array offset: 0x3C, array step: 0x60 */
    __IO uint16_t CAPTCOMPX;                         /**< Capture Compare X Register, array offset: 0x3E, array step: 0x60 */
    __I  uint16_t CVAL0;                             /**< Capture Value 0 Register, array offset: 0x40, array step: 0x60 */
    __I  uint16_t CVAL0CYC;                          /**< Capture Value 0 Cycle Register, array offset: 0x42, array step: 0x60 */
    __I  uint16_t CVAL1;                             /**< Capture Value 1 Register, array offset: 0x44, array step: 0x60 */
    __I  uint16_t CVAL1CYC;                          /**< Capture Value 1 Cycle Register, array offset: 0x46, array step: 0x60 */
    __I  uint16_t CVAL2;                             /**< Capture Value 2 Register, array offset: 0x48, array step: 0x60 */
    __I  uint16_t CVAL2CYC;                          /**< Capture Value 2 Cycle Register, array offset: 0x4A, array step: 0x60 */
    __I  uint16_t CVAL3;                             /**< Capture Value 3 Register, array offset: 0x4C, array step: 0x60 */
    __I  uint16_t CVAL3CYC;                          /**< Capture Value 3 Cycle Register, array offset: 0x4E, array step: 0x60 */
    __I  uint16_t CVAL4;                             /**< Capture Value 4 Register, array offset: 0x50, array step: 0x60 */
    __I  uint16_t CVAL4CYC;                          /**< Capture Value 4 Cycle Register, array offset: 0x52, array step: 0x60 */
    __I  uint16_t CVAL5;                             /**< Capture Value 5 Register, array offset: 0x54, array step: 0x60 */
    __I  uint16_t CVAL5CYC;                          /**< Capture Value 5 Cycle Register, array offset: 0x56, array step: 0x60 */
         uint8_t RESERVED_1[8];
  } SM[4];
  __IO uint16_t OUTEN;                             /**< Output Enable Register, offset: 0x180 */
  __IO uint16_t MASK;                              /**< Mask Register, offset: 0x182 */
  __IO uint16_t SWCOUT;                            /**< Software Controlled Output Register, offset: 0x184 */
  __IO uint16_t DTSRCSEL;                          /**< PWM Source Select Register, offset: 0x186 */
  __IO uint16_t MCTRL;                             /**< Master Control Register, offset: 0x188 */
  __IO uint16_t MCTRL2;                            /**< Master Control 2 Register, offset: 0x18A */
  struct {                                         /* offset: 0x18C, array step: 0xA */
    __IO uint16_t FAULT_CTRL;                        /**< Fault Control Register, array offset: 0x18C, array step: 0xA */
    __IO uint16_t FAULT_STS;                         /**< Fault Status Register, array offset: 0x18E, array step: 0xA */
    __IO uint16_t FAULT_FILT;                        /**< Fault Filter Register, array offset: 0x190, array step: 0xA */
    __IO uint16_t FAULT_TST;                         /**< Fault Test Register, array offset: 0x192, array step: 0xA */
    __IO uint16_t FAULT_CTRL2;                       /**< Fault Control 2 Register, array offset: 0x194, array step: 0xA */
  } FAULT[2];
} PWM_Type, *PWM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PWM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PWM_Register_Accessor_Macros PWM - Register accessor macros
 * @{
 */


/* PWM - Register accessors */
#define PWM_CNT_REG(base,index)                  ((base)->SM[index].CNT)
#define PWM_CNT_COUNT                            4
#define PWM_INIT_REG(base,index)                 ((base)->SM[index].INIT)
#define PWM_INIT_COUNT                           4
#define PWM_CTRL2_REG(base,index)                ((base)->SM[index].CTRL2)
#define PWM_CTRL2_COUNT                          4
#define PWM_CTRL_REG(base,index)                 ((base)->SM[index].CTRL)
#define PWM_CTRL_COUNT                           4
#define PWM_VAL0_REG(base,index)                 ((base)->SM[index].VAL0)
#define PWM_VAL0_COUNT                           4
#define PWM_FRACVAL1_REG(base,index)             ((base)->SM[index].FRACVAL1)
#define PWM_FRACVAL1_COUNT                       4
#define PWM_VAL1_REG(base,index)                 ((base)->SM[index].VAL1)
#define PWM_VAL1_COUNT                           4
#define PWM_FRACVAL2_REG(base,index)             ((base)->SM[index].FRACVAL2)
#define PWM_FRACVAL2_COUNT                       4
#define PWM_VAL2_REG(base,index)                 ((base)->SM[index].VAL2)
#define PWM_VAL2_COUNT                           4
#define PWM_FRACVAL3_REG(base,index)             ((base)->SM[index].FRACVAL3)
#define PWM_FRACVAL3_COUNT                       4
#define PWM_VAL3_REG(base,index)                 ((base)->SM[index].VAL3)
#define PWM_VAL3_COUNT                           4
#define PWM_FRACVAL4_REG(base,index)             ((base)->SM[index].FRACVAL4)
#define PWM_FRACVAL4_COUNT                       4
#define PWM_VAL4_REG(base,index)                 ((base)->SM[index].VAL4)
#define PWM_VAL4_COUNT                           4
#define PWM_FRACVAL5_REG(base,index)             ((base)->SM[index].FRACVAL5)
#define PWM_FRACVAL5_COUNT                       4
#define PWM_VAL5_REG(base,index)                 ((base)->SM[index].VAL5)
#define PWM_VAL5_COUNT                           4
#define PWM_FRCTRL_REG(base,index)               ((base)->SM[index].FRCTRL)
#define PWM_FRCTRL_COUNT                         4
#define PWM_OCTRL_REG(base,index)                ((base)->SM[index].OCTRL)
#define PWM_OCTRL_COUNT                          4
#define PWM_STS_REG(base,index)                  ((base)->SM[index].STS)
#define PWM_STS_COUNT                            4
#define PWM_INTEN_REG(base,index)                ((base)->SM[index].INTEN)
#define PWM_INTEN_COUNT                          4
#define PWM_DMAEN_REG(base,index)                ((base)->SM[index].DMAEN)
#define PWM_DMAEN_COUNT                          4
#define PWM_TCTRL_REG(base,index)                ((base)->SM[index].TCTRL)
#define PWM_TCTRL_COUNT                          4
#define PWM_DISMAP_REG(base,index,index2)        ((base)->SM[index].DISMAP[index2])
#define PWM_DISMAP_COUNT                         4
#define PWM_DISMAP_COUNT2                        2
#define PWM_DTCNT0_REG(base,index)               ((base)->SM[index].DTCNT0)
#define PWM_DTCNT0_COUNT                         4
#define PWM_DTCNT1_REG(base,index)               ((base)->SM[index].DTCNT1)
#define PWM_DTCNT1_COUNT                         4
#define PWM_CAPTCTRLA_REG(base,index)            ((base)->SM[index].CAPTCTRLA)
#define PWM_CAPTCTRLA_COUNT                      4
#define PWM_CAPTCOMPA_REG(base,index)            ((base)->SM[index].CAPTCOMPA)
#define PWM_CAPTCOMPA_COUNT                      4
#define PWM_CAPTCTRLB_REG(base,index)            ((base)->SM[index].CAPTCTRLB)
#define PWM_CAPTCTRLB_COUNT                      4
#define PWM_CAPTCOMPB_REG(base,index)            ((base)->SM[index].CAPTCOMPB)
#define PWM_CAPTCOMPB_COUNT                      4
#define PWM_CAPTCTRLX_REG(base,index)            ((base)->SM[index].CAPTCTRLX)
#define PWM_CAPTCTRLX_COUNT                      4
#define PWM_CAPTCOMPX_REG(base,index)            ((base)->SM[index].CAPTCOMPX)
#define PWM_CAPTCOMPX_COUNT                      4
#define PWM_CVAL0_REG(base,index)                ((base)->SM[index].CVAL0)
#define PWM_CVAL0_COUNT                          4
#define PWM_CVAL0CYC_REG(base,index)             ((base)->SM[index].CVAL0CYC)
#define PWM_CVAL0CYC_COUNT                       4
#define PWM_CVAL1_REG(base,index)                ((base)->SM[index].CVAL1)
#define PWM_CVAL1_COUNT                          4
#define PWM_CVAL1CYC_REG(base,index)             ((base)->SM[index].CVAL1CYC)
#define PWM_CVAL1CYC_COUNT                       4
#define PWM_CVAL2_REG(base,index)                ((base)->SM[index].CVAL2)
#define PWM_CVAL2_COUNT                          4
#define PWM_CVAL2CYC_REG(base,index)             ((base)->SM[index].CVAL2CYC)
#define PWM_CVAL2CYC_COUNT                       4
#define PWM_CVAL3_REG(base,index)                ((base)->SM[index].CVAL3)
#define PWM_CVAL3_COUNT                          4
#define PWM_CVAL3CYC_REG(base,index)             ((base)->SM[index].CVAL3CYC)
#define PWM_CVAL3CYC_COUNT                       4
#define PWM_CVAL4_REG(base,index)                ((base)->SM[index].CVAL4)
#define PWM_CVAL4_COUNT                          4
#define PWM_CVAL4CYC_REG(base,index)             ((base)->SM[index].CVAL4CYC)
#define PWM_CVAL4CYC_COUNT                       4
#define PWM_CVAL5_REG(base,index)                ((base)->SM[index].CVAL5)
#define PWM_CVAL5_COUNT                          4
#define PWM_CVAL5CYC_REG(base,index)             ((base)->SM[index].CVAL5CYC)
#define PWM_CVAL5CYC_COUNT                       4
#define PWM_OUTEN_REG(base)                      ((base)->OUTEN)
#define PWM_MASK_REG(base)                       ((base)->MASK)
#define PWM_SWCOUT_REG(base)                     ((base)->SWCOUT)
#define PWM_DTSRCSEL_REG(base)                   ((base)->DTSRCSEL)
#define PWM_MCTRL_REG(base)                      ((base)->MCTRL)
#define PWM_MCTRL2_REG(base)                     ((base)->MCTRL2)
#define PWM_FAULT_CTRL_REG(base,index)           ((base)->FAULT[index].FAULT_CTRL)
#define PWM_FAULT_CTRL_COUNT                     2
#define PWM_FAULT_STS_REG(base,index)            ((base)->FAULT[index].FAULT_STS)
#define PWM_FAULT_STS_COUNT                      2
#define PWM_FAULT_FILT_REG(base,index)           ((base)->FAULT[index].FAULT_FILT)
#define PWM_FAULT_FILT_COUNT                     2
#define PWM_FAULT_TST_REG(base,index)            ((base)->FAULT[index].FAULT_TST)
#define PWM_FAULT_TST_COUNT                      2
#define PWM_FAULT_CTRL2_REG(base,index)          ((base)->FAULT[index].FAULT_CTRL2)
#define PWM_FAULT_CTRL2_COUNT                    2

/*!
 * @}
 */ /* end of group PWM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PWM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PWM_Register_Masks PWM Register Masks
 * @{
 */

/* CNT Bit Fields */
#define PWM_CNT_CNT_MASK                         0xFFFFu
#define PWM_CNT_CNT_SHIFT                        0
#define PWM_CNT_CNT_WIDTH                        16
#define PWM_CNT_CNT(x)                           (((uint16_t)(((uint16_t)(x))<<PWM_CNT_CNT_SHIFT))&PWM_CNT_CNT_MASK)
/* INIT Bit Fields */
#define PWM_INIT_INIT_MASK                       0xFFFFu
#define PWM_INIT_INIT_SHIFT                      0
#define PWM_INIT_INIT_WIDTH                      16
#define PWM_INIT_INIT(x)                         (((uint16_t)(((uint16_t)(x))<<PWM_INIT_INIT_SHIFT))&PWM_INIT_INIT_MASK)
/* CTRL2 Bit Fields */
#define PWM_CTRL2_CLK_SEL_MASK                   0x3u
#define PWM_CTRL2_CLK_SEL_SHIFT                  0
#define PWM_CTRL2_CLK_SEL_WIDTH                  2
#define PWM_CTRL2_CLK_SEL(x)                     (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_CLK_SEL_SHIFT))&PWM_CTRL2_CLK_SEL_MASK)
#define PWM_CTRL2_RELOAD_SEL_MASK                0x4u
#define PWM_CTRL2_RELOAD_SEL_SHIFT               2
#define PWM_CTRL2_RELOAD_SEL_WIDTH               1
#define PWM_CTRL2_RELOAD_SEL(x)                  (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_RELOAD_SEL_SHIFT))&PWM_CTRL2_RELOAD_SEL_MASK)
#define PWM_CTRL2_FORCE_SEL_MASK                 0x38u
#define PWM_CTRL2_FORCE_SEL_SHIFT                3
#define PWM_CTRL2_FORCE_SEL_WIDTH                3
#define PWM_CTRL2_FORCE_SEL(x)                   (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_FORCE_SEL_SHIFT))&PWM_CTRL2_FORCE_SEL_MASK)
#define PWM_CTRL2_FORCE_MASK                     0x40u
#define PWM_CTRL2_FORCE_SHIFT                    6
#define PWM_CTRL2_FORCE_WIDTH                    1
#define PWM_CTRL2_FORCE(x)                       (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_FORCE_SHIFT))&PWM_CTRL2_FORCE_MASK)
#define PWM_CTRL2_FRCEN_MASK                     0x80u
#define PWM_CTRL2_FRCEN_SHIFT                    7
#define PWM_CTRL2_FRCEN_WIDTH                    1
#define PWM_CTRL2_FRCEN(x)                       (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_FRCEN_SHIFT))&PWM_CTRL2_FRCEN_MASK)
#define PWM_CTRL2_INIT_SEL_MASK                  0x300u
#define PWM_CTRL2_INIT_SEL_SHIFT                 8
#define PWM_CTRL2_INIT_SEL_WIDTH                 2
#define PWM_CTRL2_INIT_SEL(x)                    (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_INIT_SEL_SHIFT))&PWM_CTRL2_INIT_SEL_MASK)
#define PWM_CTRL2_PWMX_INIT_MASK                 0x400u
#define PWM_CTRL2_PWMX_INIT_SHIFT                10
#define PWM_CTRL2_PWMX_INIT_WIDTH                1
#define PWM_CTRL2_PWMX_INIT(x)                   (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_PWMX_INIT_SHIFT))&PWM_CTRL2_PWMX_INIT_MASK)
#define PWM_CTRL2_PWM45_INIT_MASK                0x800u
#define PWM_CTRL2_PWM45_INIT_SHIFT               11
#define PWM_CTRL2_PWM45_INIT_WIDTH               1
#define PWM_CTRL2_PWM45_INIT(x)                  (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_PWM45_INIT_SHIFT))&PWM_CTRL2_PWM45_INIT_MASK)
#define PWM_CTRL2_PWM23_INIT_MASK                0x1000u
#define PWM_CTRL2_PWM23_INIT_SHIFT               12
#define PWM_CTRL2_PWM23_INIT_WIDTH               1
#define PWM_CTRL2_PWM23_INIT(x)                  (((uint16_t)(((uint16_t)(x))<<PWM_CTRL2_PWM23_INIT_SHIFT))&PWM_CTRL2_PWM23_INIT_MASK)
#define PWM_CTRL2_INDEP_MASK                     0x2000u
#define PWM_CTRL2_INDEP_SHIFT                    13
#define PWM_CTRL2_INDEP_WIDTH                    1
#define PWM_CTRL2_INDEP(